/* FirmwareView.c generated by valac 0.56.13, the Vala compiler
 * generated from FirmwareView.vala, do not modify */

/*
* Copyright 2020-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "about.h"
#include <gtk/gtk.h>
#include <handy.h>
#include <granite.h>
#include <glib.h>
#include <fwupd.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define ABOUT_GETTEXT_PACKAGE "about-plug"

enum  {
	ABOUT_FIRMWARE_VIEW_0_PROPERTY,
	ABOUT_FIRMWARE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_view_properties[ABOUT_FIRMWARE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _AboutFirmwareViewUpdateListViewData AboutFirmwareViewUpdateListViewData;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW (about_firmware_view_firmware_header_row_get_type ())
#define ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW, AboutFirmwareViewFirmwareHeaderRow))
#define ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW, AboutFirmwareViewFirmwareHeaderRowClass))
#define ABOUT_FIRMWARE_VIEW_IS_FIRMWARE_HEADER_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW))
#define ABOUT_FIRMWARE_VIEW_IS_FIRMWARE_HEADER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW))
#define ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW, AboutFirmwareViewFirmwareHeaderRowClass))

typedef struct _AboutFirmwareViewFirmwareHeaderRow AboutFirmwareViewFirmwareHeaderRow;
typedef struct _AboutFirmwareViewFirmwareHeaderRowClass AboutFirmwareViewFirmwareHeaderRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AboutFirmwareViewUpdateData AboutFirmwareViewUpdateData;
typedef struct _AboutFirmwareViewDownloadFileData AboutFirmwareViewDownloadFileData;
typedef struct _Block5Data Block5Data;
typedef struct _AboutFirmwareViewFirmwareHeaderRowPrivate AboutFirmwareViewFirmwareHeaderRowPrivate;
enum  {
	ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW_0_PROPERTY,
	ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_view_firmware_header_row_properties[ABOUT_FIRMWARE_VIEW_FIRMWARE_HEADER_ROW_NUM_PROPERTIES];

struct _AboutFirmwareViewPrivate {
	GtkStack* stack;
	HdyDeck* deck;
	AboutFirmwareReleaseView* firmware_release_view;
	GraniteWidgetsAlertView* progress_alert_view;
	GraniteWidgetsAlertView* placeholder_alert_view;
	GtkListBox* update_list;
	guint num_updates;
	FwupdClient* fwupd_client;
};

struct _AboutFirmwareViewUpdateListViewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* widget_collection;
	GList* widget_it;
	GtkWidget* widget;
	GtkWidget* _tmp2_;
	GtkListBox* _tmp3_;
	GtkWidget* _tmp4_;
	GPtrArray* devices;
	FwupdClient* _tmp5_;
	GPtrArray* _tmp6_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GPtrArray* _tmp12_;
	gconstpointer _tmp13_;
	GraniteWidgetsAlertView* _tmp14_;
	GraniteWidgetsAlertView* _tmp15_;
	GtkListBox* _tmp16_;
	GraniteWidgetsAlertView* _tmp17_;
	GraniteWidgetsAlertView* _tmp18_;
	GtkStack* _tmp19_;
	HdyDeck* _tmp20_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	AboutFirmwareView* self;
	FwupdDevice* device;
};

struct _AboutFirmwareViewUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	FwupdDevice* device;
	FwupdRelease* release;
	GraniteWidgetsAlertView* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkStack* _tmp4_;
	GraniteWidgetsAlertView* _tmp5_;
	const gchar* detach_caption;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* detach_image;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GtkStack* _tmp15_;
	HdyDeck* _tmp16_;
	gchar* path;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	FwupdInstallFlags install_flags;
	gboolean _tmp19_;
	FwupdClient* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* e;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GtkStack* _tmp25_;
	HdyDeck* _tmp26_;
	GError* _inner_error0_;
};

struct _AboutFirmwareViewDownloadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutFirmwareView* self;
	FwupdDevice* device;
	gchar* uri;
	gchar* result;
	GFile* server_file;
	GFile* _tmp0_;
	gchar* path;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* local_file;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	gboolean _result_;
	gboolean _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	AboutFirmwareView* self;
	GraniteMessageDialog* dialog;
};

struct _AboutFirmwareViewFirmwareHeaderRow {
	GtkLabel parent_instance;
	AboutFirmwareViewFirmwareHeaderRowPrivate * priv;
};

struct _AboutFirmwareViewFirmwareHeaderRowClass {
	GtkLabelClass parent_class;
};

static gint AboutFirmwareView_private_offset;
static gpointer about_firmware_view_parent_class = NULL;
static gpointer about_firmware_view_firmware_header_row_parent_class = NULL;

static void about_firmware_view_update_list_view_data_free (gpointer _data);
static void about_firmware_view_update_list_view (AboutFirmwareView* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void about_firmware_view_update_list_view_finish (AboutFirmwareView* self,
                                                  GAsyncResult* _res_);
static gboolean about_firmware_view_update_list_view_co (AboutFirmwareViewUpdateListViewData* _data_);
static void about_firmware_view_update_list_view_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void about_firmware_view_add_device (AboutFirmwareView* self,
                                     FwupdDevice* device);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda14_ (Block4Data* _data4_,
                   GObject* obj,
                   GAsyncResult* res);
static void __lambda15_ (AboutFirmwareView* self,
                  FwupdDevice* device,
                  FwupdRelease* release);
static void about_firmware_view_update (AboutFirmwareView* self,
                                 FwupdDevice* device,
                                 FwupdRelease* release,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void about_firmware_view_update_finish (AboutFirmwareView* self,
                                        GAsyncResult* _res_);
static void ___lambda15__about_widgets_firmware_update_row_update (AboutWidgetsFirmwareUpdateRow* _sender,
                                                            FwupdDevice* device,
                                                            FwupdRelease* release,
                                                            gpointer self);
static void ____lambda14__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void about_firmware_view_show_release (AboutFirmwareView* self,
                                       GtkListBoxRow* widget);
static void about_firmware_view_on_device_added (AboutFirmwareView* self,
                                          FwupdClient* client,
                                          FwupdDevice* device);
static void about_firmware_view_on_device_removed (AboutFirmwareView* self,
                                            FwupdClient* client,
                                            FwupdDevice* device);
static gint about_firmware_view_compare_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                       AboutWidgetsFirmwareUpdateRow* row2,
                                       AboutFirmwareView* self);
static void about_firmware_view_header_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                      AboutWidgetsFirmwareUpdateRow* row2,
                                      AboutFirmwareView* self);
static GType about_firmware_view_firmware_header_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static AboutFirmwareViewFirmwareHeaderRow* about_firmware_view_firmware_header_row_new (const gchar* label);
static AboutFirmwareViewFirmwareHeaderRow* about_firmware_view_firmware_header_row_construct (GType object_type,
                                                                                       const gchar* label);
static void about_firmware_view_update_data_free (gpointer _data);
static gboolean about_firmware_view_update_co (AboutFirmwareViewUpdateData* _data_);
static void about_firmware_view_download_file (AboutFirmwareView* self,
                                        FwupdDevice* device,
                                        const gchar* uri,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gchar* about_firmware_view_download_file_finish (AboutFirmwareView* self,
                                                 GAsyncResult* _res_);
static void about_firmware_view_update_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static gboolean about_firmware_view_show_details_dialog (AboutFirmwareView* self,
                                                  FwupdDevice* device,
                                                  const gchar* detach_caption,
                                                  const gchar* detach_image);
static void about_firmware_view_show_reboot_dialog (AboutFirmwareView* self);
static void about_firmware_view_show_shutdown_dialog (AboutFirmwareView* self);
static void about_firmware_view_show_error_dialog (AboutFirmwareView* self,
                                            FwupdDevice* device,
                                            const gchar* secondary_text);
static void about_firmware_view_download_file_data_free (gpointer _data);
static gboolean about_firmware_view_download_file_co (AboutFirmwareViewDownloadFileData* _data_);
static void ___lambda16_ (AboutFirmwareView* self,
                   gint64 current_num_bytes,
                   gint64 total_num_bytes);
static void ____lambda16__gfile_progress_callback (gint64 current_num_bytes,
                                            gint64 total_num_bytes,
                                            gpointer self);
static void about_firmware_view_download_file_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void about_firmware_view_reboot_to_firmware_setup_clicked (AboutFirmwareView* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda17_ (Block5Data* _data5_,
                  gint _result_);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static GObject * about_firmware_view_firmware_header_row_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static GType about_firmware_view_firmware_header_row_get_type_once (void);
static GObject * about_firmware_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void _about_firmware_view_on_device_added_fwupd_client_device_added (FwupdClient* _sender,
                                                                     FwupdDevice* _result_,
                                                                     gpointer self);
static void _about_firmware_view_on_device_removed_fwupd_client_device_removed (FwupdClient* _sender,
                                                                         FwupdDevice* _result_,
                                                                         gpointer self);
static void _about_firmware_view_show_release_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void _about_firmware_view___lambda18_ (AboutFirmwareView* self,
                                       FwupdDevice* device,
                                       FwupdRelease* release);
static void __about_firmware_view___lambda18__about_firmware_release_view_update (AboutFirmwareReleaseView* _sender,
                                                                           FwupdDevice* device,
                                                                           FwupdRelease* release,
                                                                           gpointer self);
static void about_firmware_view_finalize (GObject * obj);
static GType about_firmware_view_get_type_once (void);

static inline gpointer
about_firmware_view_get_instance_private (AboutFirmwareView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutFirmwareView_private_offset);
}

AboutFirmwareView*
about_firmware_view_construct (GType object_type)
{
	AboutFirmwareView * self = NULL;
	self = (AboutFirmwareView*) g_object_new (object_type, "icon-name", "application-x-firmware", "title", _ ("Firmware"), "description", _ ("Firmware updates provided by device manufacturers can improve performa" \
"nce and fix critical security issues."), NULL);
	return self;
}

AboutFirmwareView*
about_firmware_view_new (void)
{
	return about_firmware_view_construct (ABOUT_TYPE_FIRMWARE_VIEW);
}

static void
about_firmware_view_update_list_view_data_free (gpointer _data)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewUpdateListViewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_firmware_view_update_list_view (AboutFirmwareView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	AboutFirmwareView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewUpdateListViewData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_update_list_view_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_firmware_view_update_list_view_co (_data_);
}

static void
about_firmware_view_update_list_view_finish (AboutFirmwareView* self,
                                             GAsyncResult* _res_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_firmware_view_update_list_view_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AboutFirmwareViewUpdateListViewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_update_list_view_co (_data_);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
about_firmware_view_update_list_view_co (AboutFirmwareViewUpdateListViewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->update_list;
	_data_->_tmp1_ = gtk_container_get_children ((GtkContainer*) _data_->_tmp0_);
	{
		_data_->widget_collection = _data_->_tmp1_;
		for (_data_->widget_it = _data_->widget_collection; _data_->widget_it != NULL; _data_->widget_it = _data_->widget_it->next) {
			_data_->widget = (GtkWidget*) _data_->widget_it->data;
			{
				_data_->_tmp2_ = _data_->widget;
				if (ABOUT_WIDGETS_IS_FIRMWARE_UPDATE_ROW (_data_->_tmp2_)) {
					_data_->_tmp3_ = _data_->self->priv->update_list;
					_data_->_tmp4_ = _data_->widget;
					gtk_container_remove ((GtkContainer*) _data_->_tmp3_, _data_->_tmp4_);
				}
			}
		}
		(_data_->widget_collection == NULL) ? NULL : (_data_->widget_collection = (g_list_free (_data_->widget_collection), NULL));
	}
	_data_->self->priv->num_updates = (guint) 0;
	{
		_data_->_tmp5_ = _data_->self->priv->fwupd_client;
		_data_->_state_ = 1;
		about_firmware_client_get_devices (_data_->_tmp5_, about_firmware_view_update_list_view_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = about_firmware_client_get_devices_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->devices = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp7_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp7_) {
						_data_->_tmp8_ = _data_->i;
						_data_->i = _data_->_tmp8_ + 1;
					}
					_data_->_tmp7_ = FALSE;
					_data_->_tmp9_ = _data_->devices;
					_data_->_tmp10_ = vala_g_ptr_array_get_length (_data_->_tmp9_);
					_data_->_tmp11_ = _data_->_tmp10_;
					if (!(_data_->i < _data_->_tmp11_)) {
						break;
					}
					_data_->_tmp12_ = _data_->devices;
					_data_->_tmp13_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->i);
					about_firmware_view_add_device (_data_->self, (FwupdDevice*) _data_->_tmp13_);
				}
			}
		}
		_data_->_tmp14_ = _data_->self->priv->placeholder_alert_view;
		granite_widgets_alert_view_set_title (_data_->_tmp14_, _ ("Firmware Updates Are Not Available"));
		_data_->_tmp15_ = _data_->self->priv->placeholder_alert_view;
		granite_widgets_alert_view_set_description (_data_->_tmp15_, _ ("Firmware updates are not supported on this or any connected devices."));
		_data_->_tmp16_ = _data_->self->priv->update_list;
		gtk_widget_show_all ((GtkWidget*) _data_->_tmp16_);
		_g_ptr_array_unref0 (_data_->devices);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp17_ = _data_->self->priv->placeholder_alert_view;
		granite_widgets_alert_view_set_title (_data_->_tmp17_, _ ("The Firmware Service Is Not Available"));
		_data_->_tmp18_ = _data_->self->priv->placeholder_alert_view;
		granite_widgets_alert_view_set_description (_data_->_tmp18_, _ ("Please make sure “fwupd” is installed and enabled."));
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->self->priv->stack;
	_data_->_tmp20_ = _data_->self->priv->deck;
	gtk_stack_set_visible_child (_data_->_tmp19_, (GtkWidget*) _data_->_tmp20_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->device);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda15_ (AboutFirmwareView* self,
             FwupdDevice* device,
             FwupdRelease* release)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	about_firmware_view_update (self, device, release, NULL, NULL);
}

static void
___lambda15__about_widgets_firmware_update_row_update (AboutWidgetsFirmwareUpdateRow* _sender,
                                                       FwupdDevice* device,
                                                       FwupdRelease* release,
                                                       gpointer self)
{
	__lambda15_ ((AboutFirmwareView*) self, device, release);
}

static void
___lambda14_ (Block4Data* _data4_,
              GObject* obj,
              GAsyncResult* res)
{
	AboutFirmwareView* self;
	FwupdRelease* release = NULL;
	AboutWidgetsFirmwareUpdateRow* row = NULL;
	FwupdRelease* _tmp5_;
	AboutWidgetsFirmwareUpdateRow* _tmp6_;
	AboutWidgetsFirmwareUpdateRow* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkListBox* _tmp11_;
	AboutWidgetsFirmwareUpdateRow* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	AboutWidgetsFirmwareUpdateRow* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	release = NULL;
	{
		GPtrArray* upgrades = NULL;
		GPtrArray* _tmp0_;
		_tmp0_ = about_firmware_client_get_upgrades_finish (res, &_inner_error0_);
		upgrades = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (upgrades != NULL) {
			gconstpointer _tmp1_;
			FwupdRelease* _tmp2_;
			_tmp1_ = g_ptr_array_index (upgrades, (guint) 0);
			_tmp2_ = _g_object_ref0 ((FwupdRelease*) _tmp1_);
			_g_object_unref0 (release);
			release = _tmp2_;
		}
		_g_ptr_array_unref0 (upgrades);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("FirmwareView.vala:143: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (release);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = release;
	_tmp6_ = about_widgets_firmware_update_row_new (_data4_->device, _tmp5_);
	g_object_ref_sink (_tmp6_);
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = about_widgets_firmware_update_row_get_is_updatable (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		guint _tmp10_;
		_tmp10_ = self->priv->num_updates;
		self->priv->num_updates = _tmp10_ + 1;
	}
	_tmp11_ = self->priv->update_list;
	_tmp12_ = row;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->update_list;
	gtk_list_box_invalidate_sort (_tmp13_);
	_tmp14_ = self->priv->update_list;
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
	_tmp15_ = row;
	g_signal_connect_object (_tmp15_, "update", (GCallback) ___lambda15__about_widgets_firmware_update_row_update, self, 0);
	_g_object_unref0 (row);
	_g_object_unref0 (release);
}

static void
____lambda14__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda14_ (self, source_object, res);
	block4_data_unref (self);
}

static void
about_firmware_view_add_device (AboutFirmwareView* self,
                                FwupdDevice* device)
{
	Block4Data* _data4_;
	FwupdDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data4_->device);
	_data4_->device = _tmp0_;
	if (fwupd_device_has_flag (_data4_->device, (FwupdDeviceFlags) FWUPD_DEVICE_FLAG_UPDATABLE)) {
		FwupdClient* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->fwupd_client;
		_tmp2_ = fwupd_device_get_id (_data4_->device);
		about_firmware_client_get_upgrades (_tmp1_, _tmp2_, ____lambda14__gasync_ready_callback, block4_data_ref (_data4_));
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
about_firmware_view_show_release (AboutFirmwareView* self,
                                  GtkListBoxRow* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (ABOUT_WIDGETS_IS_FIRMWARE_UPDATE_ROW (widget)) {
		AboutWidgetsFirmwareUpdateRow* row = NULL;
		AboutWidgetsFirmwareUpdateRow* _tmp0_;
		AboutFirmwareReleaseView* _tmp1_;
		AboutWidgetsFirmwareUpdateRow* _tmp2_;
		FwupdDevice* _tmp3_;
		FwupdDevice* _tmp4_;
		AboutWidgetsFirmwareUpdateRow* _tmp5_;
		FwupdRelease* _tmp6_;
		FwupdRelease* _tmp7_;
		HdyDeck* _tmp8_;
		AboutFirmwareReleaseView* _tmp9_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, ABOUT_WIDGETS_TYPE_FIRMWARE_UPDATE_ROW, AboutWidgetsFirmwareUpdateRow));
		row = _tmp0_;
		_tmp1_ = self->priv->firmware_release_view;
		_tmp2_ = row;
		_tmp3_ = about_widgets_firmware_update_row_get_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = row;
		_tmp6_ = about_widgets_firmware_update_row_get_release (_tmp5_);
		_tmp7_ = _tmp6_;
		about_firmware_release_view_update_view (_tmp1_, _tmp4_, _tmp7_);
		_tmp8_ = self->priv->deck;
		_tmp9_ = self->priv->firmware_release_view;
		hdy_deck_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (row);
	}
}

static void
about_firmware_view_on_device_added (AboutFirmwareView* self,
                                     FwupdClient* client,
                                     FwupdDevice* device)
{
	const gchar* _tmp0_;
	GtkStack* _tmp1_;
	HdyDeck* _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = fwupd_device_get_name (device);
	g_debug ("FirmwareView.vala:172: Added device: %s", _tmp0_);
	about_firmware_view_add_device (self, device);
	_tmp1_ = self->priv->stack;
	_tmp2_ = self->priv->deck;
	gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->update_list;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
}

static void
about_firmware_view_on_device_removed (AboutFirmwareView* self,
                                       FwupdClient* client,
                                       FwupdDevice* device)
{
	const gchar* _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GtkListBox* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = fwupd_device_get_name (device);
	g_debug ("FirmwareView.vala:181: Removed device: %s", _tmp0_);
	_tmp1_ = self->priv->update_list;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp2_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* widget = NULL;
			widget = (GtkWidget*) widget_it->data;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = widget;
				if (ABOUT_WIDGETS_IS_FIRMWARE_UPDATE_ROW (_tmp3_)) {
					AboutWidgetsFirmwareUpdateRow* row = NULL;
					GtkWidget* _tmp4_;
					AboutWidgetsFirmwareUpdateRow* _tmp5_;
					AboutWidgetsFirmwareUpdateRow* _tmp6_;
					FwupdDevice* _tmp7_;
					FwupdDevice* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp4_ = widget;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ABOUT_WIDGETS_TYPE_FIRMWARE_UPDATE_ROW, AboutWidgetsFirmwareUpdateRow));
					row = _tmp5_;
					_tmp6_ = row;
					_tmp7_ = about_widgets_firmware_update_row_get_device (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = fwupd_device_get_id (_tmp8_);
					_tmp10_ = fwupd_device_get_id (device);
					if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
						AboutWidgetsFirmwareUpdateRow* _tmp11_;
						gboolean _tmp12_;
						gboolean _tmp13_;
						GtkListBox* _tmp15_;
						GtkWidget* _tmp16_;
						GtkListBox* _tmp17_;
						_tmp11_ = row;
						_tmp12_ = about_widgets_firmware_update_row_get_is_updatable (_tmp11_);
						_tmp13_ = _tmp12_;
						if (_tmp13_) {
							guint _tmp14_;
							_tmp14_ = self->priv->num_updates;
							self->priv->num_updates = _tmp14_ - 1;
						}
						_tmp15_ = self->priv->update_list;
						_tmp16_ = widget;
						gtk_container_remove ((GtkContainer*) _tmp15_, _tmp16_);
						_tmp17_ = self->priv->update_list;
						gtk_list_box_invalidate_sort (_tmp17_);
					}
					_g_object_unref0 (row);
				}
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp18_ = self->priv->update_list;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
}

static gint
about_firmware_view_compare_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                  AboutWidgetsFirmwareUpdateRow* row2,
                                  AboutFirmwareView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FwupdDevice* _tmp10_;
	FwupdDevice* _tmp11_;
	const gchar* _tmp12_;
	FwupdDevice* _tmp13_;
	FwupdDevice* _tmp14_;
	const gchar* _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp1_ = about_widgets_firmware_update_row_get_is_updatable (row1);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = about_widgets_firmware_update_row_get_is_updatable (row2);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	}
	_tmp6_ = about_widgets_firmware_update_row_get_is_updatable (row1);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = about_widgets_firmware_update_row_get_is_updatable (row2);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = 1;
		return result;
	}
	_tmp10_ = about_widgets_firmware_update_row_get_device (row1);
	_tmp11_ = _tmp10_;
	_tmp12_ = fwupd_device_get_name (_tmp11_);
	_tmp13_ = about_widgets_firmware_update_row_get_device (row2);
	_tmp14_ = _tmp13_;
	_tmp15_ = fwupd_device_get_name (_tmp14_);
	result = g_utf8_collate (_tmp12_, _tmp15_);
	return result;
}

static void
about_firmware_view_header_rows (AboutWidgetsFirmwareUpdateRow* row1,
                                 AboutWidgetsFirmwareUpdateRow* row2,
                                 AboutFirmwareView* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row1 != NULL);
	if (row2 == NULL) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = about_widgets_firmware_update_row_get_is_updatable (row1);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AboutFirmwareViewFirmwareHeaderRow* header = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		AboutFirmwareViewFirmwareHeaderRow* _tmp5_;
		AboutFirmwareViewFirmwareHeaderRow* _tmp6_;
		AboutFirmwareViewFirmwareHeaderRow* _tmp7_;
		_tmp3_ = g_strdup_printf (g_dngettext (ABOUT_GETTEXT_PACKAGE, "%u Update Available", "%u Updates Available", (gulong) self->priv->num_updates), self->priv->num_updates);
		_tmp4_ = _tmp3_;
		_tmp5_ = about_firmware_view_firmware_header_row_new (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		header = _tmp6_;
		_tmp7_ = header;
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp7_);
		_g_object_unref0 (header);
	} else {
		gboolean _tmp8_ = FALSE;
		if (row2 == NULL) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = about_widgets_firmware_update_row_get_is_updatable (row1);
			_tmp10_ = _tmp9_;
			_tmp11_ = about_widgets_firmware_update_row_get_is_updatable (row2);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp10_ != _tmp12_;
		}
		if (_tmp8_) {
			AboutFirmwareViewFirmwareHeaderRow* header = NULL;
			AboutFirmwareViewFirmwareHeaderRow* _tmp13_;
			AboutFirmwareViewFirmwareHeaderRow* _tmp14_;
			_tmp13_ = about_firmware_view_firmware_header_row_new (_ ("Up to Date"));
			g_object_ref_sink (_tmp13_);
			header = _tmp13_;
			_tmp14_ = header;
			gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp14_);
			_g_object_unref0 (header);
		} else {
			gtk_list_box_row_set_header ((GtkListBoxRow*) row1, NULL);
		}
	}
}

static void
about_firmware_view_update_data_free (gpointer _data)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->release);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewUpdateData, _data_);
}

static void
about_firmware_view_update (AboutFirmwareView* self,
                            FwupdDevice* device,
                            FwupdRelease* release,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	AboutFirmwareViewUpdateData* _data_;
	AboutFirmwareView* _tmp0_;
	FwupdDevice* _tmp1_;
	FwupdRelease* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = _g_object_ref0 (release);
	_g_object_unref0 (_data_->release);
	_data_->release = _tmp2_;
	about_firmware_view_update_co (_data_);
}

static void
about_firmware_view_update_finish (AboutFirmwareView* self,
                                   GAsyncResult* _res_)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_firmware_view_update_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	AboutFirmwareViewUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_update_co (_data_);
}

static gboolean
about_firmware_view_update_co (AboutFirmwareViewUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->progress_alert_view;
	_data_->_tmp1_ = fwupd_device_get_name (_data_->device);
	_data_->_tmp2_ = g_strdup_printf (_ ("“%s” is being updated"), _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	granite_widgets_alert_view_set_title (_data_->_tmp0_, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->stack;
	_data_->_tmp5_ = _data_->self->priv->progress_alert_view;
	gtk_stack_set_visible_child (_data_->_tmp4_, (GtkWidget*) _data_->_tmp5_);
	_data_->_tmp6_ = fwupd_release_get_detach_caption (_data_->release);
	_data_->detach_caption = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->detach_caption;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = fwupd_release_get_detach_image (_data_->release);
		_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
		_data_->detach_image = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->detach_image;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = _data_->detach_image;
			_data_->_state_ = 1;
			about_firmware_view_download_file (_data_->self, _data_->device, _data_->_tmp11_, about_firmware_view_update_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp12_ = about_firmware_view_download_file_finish (_data_->self, _data_->_res_);
			_g_free0 (_data_->detach_image);
			_data_->detach_image = _data_->_tmp12_;
		}
		_data_->_tmp13_ = _data_->detach_caption;
		_data_->_tmp14_ = _data_->detach_image;
		if (about_firmware_view_show_details_dialog (_data_->self, _data_->device, _data_->_tmp13_, _data_->_tmp14_) == FALSE) {
			_data_->_tmp15_ = _data_->self->priv->stack;
			_data_->_tmp16_ = _data_->self->priv->deck;
			gtk_stack_set_visible_child (_data_->_tmp15_, (GtkWidget*) _data_->_tmp16_);
			_g_free0 (_data_->detach_image);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->detach_image);
	}
	_data_->_tmp17_ = fwupd_release_get_uri (_data_->release);
	_data_->_state_ = 2;
	about_firmware_view_download_file (_data_->self, _data_->device, _data_->_tmp17_, about_firmware_view_update_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp18_ = about_firmware_view_download_file_finish (_data_->self, _data_->_res_);
	_data_->path = _data_->_tmp18_;
	{
		_data_->install_flags = FWUPD_INSTALL_FLAG_NONE;
		if (fwupd_device_has_flag (_data_->device, (FwupdDeviceFlags) FWUPD_DEVICE_FLAG_ONLY_OFFLINE)) {
			_data_->install_flags = FWUPD_INSTALL_FLAG_OFFLINE;
		}
		_data_->_tmp20_ = _data_->self->priv->fwupd_client;
		_data_->_tmp21_ = fwupd_device_get_id (_data_->device);
		_data_->_tmp22_ = _data_->path;
		_data_->_state_ = 3;
		about_firmware_client_install (_data_->_tmp20_, _data_->_tmp21_, _data_->_tmp22_, _data_->install_flags, about_firmware_view_update_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp19_ = about_firmware_client_install_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->_tmp19_) {
			if (fwupd_device_has_flag (_data_->device, (FwupdDeviceFlags) FWUPD_DEVICE_FLAG_NEEDS_REBOOT)) {
				about_firmware_view_show_reboot_dialog (_data_->self);
			} else {
				if (fwupd_device_has_flag (_data_->device, (FwupdDeviceFlags) FWUPD_DEVICE_FLAG_NEEDS_SHUTDOWN)) {
					about_firmware_view_show_shutdown_dialog (_data_->self);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp23_ = _data_->e;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp24_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->self->priv->stack;
	_data_->_tmp26_ = _data_->self->priv->deck;
	gtk_stack_set_visible_child (_data_->_tmp25_, (GtkWidget*) _data_->_tmp26_);
	about_firmware_view_update_list_view (_data_->self, NULL, NULL);
	_g_free0 (_data_->path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_firmware_view_download_file_data_free (gpointer _data)
{
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutFirmwareViewDownloadFileData, _data_);
}

static void
about_firmware_view_download_file (AboutFirmwareView* self,
                                   FwupdDevice* device,
                                   const gchar* uri,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AboutFirmwareViewDownloadFileData* _data_;
	AboutFirmwareView* _tmp0_;
	FwupdDevice* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (AboutFirmwareViewDownloadFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_firmware_view_download_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	about_firmware_view_download_file_co (_data_);
}

static gchar*
about_firmware_view_download_file_finish (AboutFirmwareView* self,
                                          GAsyncResult* _res_)
{
	gchar* result;
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
___lambda16_ (AboutFirmwareView* self,
              gint64 current_num_bytes,
              gint64 total_num_bytes)
{
}

static void
____lambda16__gfile_progress_callback (gint64 current_num_bytes,
                                       gint64 total_num_bytes,
                                       gpointer self)
{
	___lambda16_ ((AboutFirmwareView*) self, current_num_bytes, total_num_bytes);
}

static void
about_firmware_view_download_file_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AboutFirmwareViewDownloadFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_firmware_view_download_file_co (_data_);
}

static gboolean
about_firmware_view_download_file_co (AboutFirmwareViewDownloadFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
	_data_->server_file = _data_->_tmp0_;
	_data_->_tmp1_ = g_get_tmp_dir ();
	_data_->_tmp2_ = _data_->server_file;
	_data_->_tmp3_ = g_file_get_basename (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_build_filename (_data_->_tmp1_, _data_->_tmp4_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_free0 (_data_->_tmp4_);
	_data_->path = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->path;
	_data_->_tmp8_ = g_file_new_for_path (_data_->_tmp7_);
	_data_->local_file = _data_->_tmp8_;
	{
		_data_->_tmp10_ = _data_->server_file;
		_data_->_tmp11_ = _data_->local_file;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->_tmp10_, _data_->_tmp11_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, ____lambda16__gfile_progress_callback, _data_->self, about_firmware_view_download_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = g_file_copy_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_result_ = _data_->_tmp9_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		_data_->_tmp14_ = g_strdup_printf ("Could not download file: %s", _data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_result_) {
		_data_->_tmp16_ = g_strdup_printf ("Download of %s was not successful", _data_->uri);
		_data_->_tmp17_ = _data_->_tmp16_;
		about_firmware_view_show_error_dialog (_data_->self, _data_->device, _data_->_tmp17_);
		_g_free0 (_data_->_tmp17_);
		_data_->result = NULL;
		_g_object_unref0 (_data_->local_file);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->server_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->path;
	_g_object_unref0 (_data_->local_file);
	_g_object_unref0 (_data_->server_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
about_firmware_view_show_error_dialog (AboutFirmwareView* self,
                                       FwupdDevice* device,
                                       const gchar* secondary_text)
{
	GThemedIcon* gicon = NULL;
	GThemedIcon* _tmp0_;
	GPtrArray* icons = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	GraniteMessageDialog* message_dialog = NULL;
	GThemedIcon* _tmp8_;
	GThemedIcon* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWindow* _tmp11_;
	GraniteMessageDialog* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (secondary_text != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	gicon = _tmp0_;
	_tmp1_ = fwupd_device_get_icons (device);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp3_ = icons;
	_tmp4_ = _tmp3_->pdata;
	_tmp4__length1 = _tmp3_->len;
	if (_tmp4_ != NULL) {
		GPtrArray* _tmp5_;
		gpointer* _tmp6_;
		gint _tmp6__length1;
		GThemedIcon* _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = _tmp5_->pdata;
		_tmp6__length1 = _tmp5_->len;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp6_, _tmp6__length1);
		_g_object_unref0 (gicon);
		gicon = _tmp7_;
	}
	_tmp8_ = gicon;
	_tmp9_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
	_tmp12_ = granite_message_dialog_new (_ ("Failed to install firmware release"), secondary_text, (GIcon*) _tmp8_, GTK_BUTTONS_CLOSE);
	granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	message_dialog = _tmp12_;
	gtk_widget_show_all ((GtkWidget*) message_dialog);
	gtk_dialog_run ((GtkDialog*) message_dialog);
	gtk_widget_destroy ((GtkWidget*) message_dialog);
	_g_object_unref0 (message_dialog);
	_g_ptr_array_unref0 (icons);
	_g_object_unref0 (gicon);
}

static gboolean
about_firmware_view_show_details_dialog (AboutFirmwareView* self,
                                         FwupdDevice* device,
                                         const gchar* detach_caption,
                                         const gchar* detach_image)
{
	GThemedIcon* gicon = NULL;
	GThemedIcon* _tmp0_;
	GPtrArray* icons = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	GraniteMessageDialog* message_dialog = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GThemedIcon* _tmp11_;
	GThemedIcon* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWindow* _tmp14_;
	GraniteMessageDialog* _tmp15_ = NULL;
	GraniteMessageDialog* _tmp16_;
	GtkButton* suggested_button = NULL;
	GraniteMessageDialog* _tmp17_;
	GtkWidget* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkStyleContext* _tmp21_;
	GraniteMessageDialog* _tmp27_;
	gboolean should_continue = FALSE;
	GraniteMessageDialog* _tmp28_;
	GraniteMessageDialog* _tmp29_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	g_return_val_if_fail (detach_caption != NULL, FALSE);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	gicon = _tmp0_;
	_tmp1_ = fwupd_device_get_icons (device);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp3_ = icons;
	_tmp4_ = _tmp3_->pdata;
	_tmp4__length1 = _tmp3_->len;
	if (_tmp4_ != NULL) {
		GPtrArray* _tmp5_;
		gpointer* _tmp6_;
		gint _tmp6__length1;
		GThemedIcon* _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = _tmp5_->pdata;
		_tmp6__length1 = _tmp5_->len;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp6_, _tmp6__length1);
		_g_object_unref0 (gicon);
		gicon = _tmp7_;
	}
	_tmp8_ = fwupd_device_get_name (device);
	_tmp9_ = g_strdup_printf (_ ("“%s” needs to manually be put in update mode"), _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gicon;
	_tmp12_ = (GThemedIcon*) g_themed_icon_new ("dialog-information");
	_tmp13_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_window_get_type (), GtkWindow));
	_tmp15_ = granite_message_dialog_new (_tmp10_, detach_caption, (GIcon*) _tmp11_, GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp15_, (GIcon*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp10_);
	message_dialog = _tmp16_;
	_tmp17_ = message_dialog;
	_tmp18_ = gtk_dialog_add_button ((GtkDialog*) _tmp17_, _ ("Continue"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp19_;
	_tmp20_ = suggested_button;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	if (detach_image != NULL) {
		GtkImage* custom_widget = NULL;
		GtkImage* _tmp22_;
		GraniteMessageDialog* _tmp23_;
		GtkBin* _tmp24_;
		GtkBin* _tmp25_;
		GtkImage* _tmp26_;
		_tmp22_ = (GtkImage*) gtk_image_new_from_file (detach_image);
		g_object_ref_sink (_tmp22_);
		custom_widget = _tmp22_;
		_tmp23_ = message_dialog;
		_tmp24_ = granite_message_dialog_get_custom_bin (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = custom_widget;
		gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
		_g_object_unref0 (custom_widget);
	}
	_tmp27_ = message_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_tmp28_ = message_dialog;
	should_continue = gtk_dialog_run ((GtkDialog*) _tmp28_) == ((gint) GTK_RESPONSE_ACCEPT);
	_tmp29_ = message_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	result = should_continue;
	_g_object_unref0 (suggested_button);
	_g_object_unref0 (message_dialog);
	_g_ptr_array_unref0 (icons);
	_g_object_unref0 (gicon);
	return result;
}

static void
about_firmware_view_show_reboot_dialog (AboutFirmwareView* self)
{
	GraniteMessageDialog* message_dialog = NULL;
	GThemedIcon* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GtkButton* suggested_button = NULL;
	GraniteMessageDialog* _tmp4_;
	GtkWidget* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GraniteMessageDialog* _tmp9_;
	GraniteMessageDialog* _tmp10_;
	GraniteMessageDialog* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("An update requires the system to restart to complete"), _ ("This will close all open applications and restart this device."), "application-x-firmware", GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp3_, (GIcon*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	message_dialog = _tmp3_;
	_tmp4_ = message_dialog;
	_tmp5_ = gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("Restart"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp6_;
	_tmp7_ = suggested_button;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp9_ = message_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = message_dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp10_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		AboutLoginManager* _tmp11_;
		AboutLoginManager* _tmp12_;
		_tmp11_ = about_login_manager_get_instance ();
		_tmp12_ = _tmp11_;
		about_login_manager_reboot (_tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = message_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_g_object_unref0 (suggested_button);
	_g_object_unref0 (message_dialog);
}

static void
about_firmware_view_show_shutdown_dialog (AboutFirmwareView* self)
{
	GraniteMessageDialog* message_dialog = NULL;
	GThemedIcon* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GtkButton* suggested_button = NULL;
	GraniteMessageDialog* _tmp4_;
	GtkWidget* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GraniteMessageDialog* _tmp9_;
	GraniteMessageDialog* _tmp10_;
	GraniteMessageDialog* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-shutdown");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("An update requires the system to shut down to complete"), _ ("This will close all open applications and turn off this device."), "application-x-firmware", GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp3_, (GIcon*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	message_dialog = _tmp3_;
	_tmp4_ = message_dialog;
	_tmp5_ = gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("Shut Down"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	suggested_button = _tmp6_;
	_tmp7_ = suggested_button;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp9_ = message_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = message_dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp10_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		AboutLoginManager* _tmp11_;
		AboutLoginManager* _tmp12_;
		_tmp11_ = about_login_manager_get_instance ();
		_tmp12_ = _tmp11_;
		about_login_manager_shutdown (_tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = message_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_g_object_unref0 (suggested_button);
	_g_object_unref0 (message_dialog);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AboutFirmwareView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__lambda17_ (Block5Data* _data5_,
             gint _result_)
{
	AboutFirmwareView* self;
	AboutLoginManager* login_manager = NULL;
	AboutLoginManager* _tmp0_;
	GError* _error_ = NULL;
	AboutLoginManager* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	AboutLoginManager* _tmp17_;
	self = _data5_->self;
	gtk_widget_destroy ((GtkWidget*) _data5_->dialog);
	if (_result_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		return;
	}
	_tmp0_ = about_login_manager_get_instance ();
	login_manager = _tmp0_;
	_tmp1_ = login_manager;
	_tmp2_ = about_login_manager_set_reboot_to_firmware_setup (_tmp1_);
	_error_ = _tmp2_;
	_tmp3_ = _error_;
	if (_tmp3_ != NULL) {
		GraniteMessageDialog* message_dialog = NULL;
		GThemedIcon* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GtkWidget* _tmp7_;
		GtkWindow* _tmp8_;
		GraniteMessageDialog* _tmp9_ = NULL;
		GraniteMessageDialog* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		_tmp4_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
		_tmp5_ = _tmp4_;
		_tmp6_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp7_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
		_tmp9_ = granite_message_dialog_new (_ ("Unable to restart to firmware setup"), _ ("A system error prevented automatically restarting into firmware setup."), (GIcon*) _tmp5_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp9_, (GIcon*) _tmp6_);
		_g_object_unref0 (_tmp6_);
		gtk_window_set_modal ((GtkWindow*) _tmp9_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp9_, _tmp8_);
		_g_object_unref0 (_tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp5_);
		message_dialog = _tmp10_;
		_tmp11_ = message_dialog;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		granite_message_dialog_show_error_details (_tmp11_, _tmp13_);
		_tmp14_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp14_);
		_tmp15_ = message_dialog;
		_tmp16_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp15_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp16_, 0);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (_error_);
		_g_object_unref0 (login_manager);
		return;
	}
	_tmp17_ = login_manager;
	about_login_manager_reboot (_tmp17_);
	_g_error_free0 (_error_);
	_g_object_unref0 (login_manager);
}

static void
___lambda17__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda17_ (self, response_id);
}

static void
about_firmware_view_reboot_to_firmware_setup_clicked (AboutFirmwareView* self)
{
	Block5Data* _data5_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWindow* _tmp4_;
	GraniteMessageDialog* _tmp5_ = NULL;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* continue_button = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkStyleContext* _tmp9_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
	_tmp3_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = granite_message_dialog_new (_ ("Restart to firmware setup"), _ ("This will close all open applications, restart this device, and open t" \
"he firmware setup screen."), (GIcon*) _tmp1_, GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp5_, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	_data5_->dialog = _tmp6_;
	_tmp7_ = gtk_dialog_add_button ((GtkDialog*) _data5_->dialog, _ ("Restart"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	continue_button = _tmp8_;
	_tmp9_ = gtk_widget_get_style_context (continue_button);
	gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_data ((GtkDialog*) _data5_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data5_->dialog);
	_g_object_unref0 (continue_button);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static AboutFirmwareViewFirmwareHeaderRow*
about_firmware_view_firmware_header_row_construct (GType object_type,
                                                   const gchar* label)
{
	AboutFirmwareViewFirmwareHeaderRow * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (AboutFirmwareViewFirmwareHeaderRow*) g_object_new (object_type, "label", label, NULL);
	return self;
}

static AboutFirmwareViewFirmwareHeaderRow*
about_firmware_view_firmware_header_row_new (const gchar* label)
{
	return about_firmware_view_firmware_header_row_construct (ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW, label);
}

static GObject *
about_firmware_view_firmware_header_row_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareViewFirmwareHeaderRow * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (about_firmware_view_firmware_header_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_FIRMWARE_VIEW_TYPE_FIRMWARE_HEADER_ROW, AboutFirmwareViewFirmwareHeaderRow);
	gtk_label_set_xalign ((GtkLabel*) self, (gfloat) 0);
	g_object_set ((GtkWidget*) self, "margin", 3, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GRANITE_STYLE_CLASS_H4_LABEL);
	return obj;
}

static void
about_firmware_view_firmware_header_row_class_init (AboutFirmwareViewFirmwareHeaderRowClass * klass,
                                                    gpointer klass_data)
{
	about_firmware_view_firmware_header_row_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_view_firmware_header_row_constructor;
}

static void
about_firmware_view_firmware_header_row_instance_init (AboutFirmwareViewFirmwareHeaderRow * self,
                                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
about_firmware_view_firmware_header_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareViewFirmwareHeaderRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_view_firmware_header_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareViewFirmwareHeaderRow), 0, (GInstanceInitFunc) about_firmware_view_firmware_header_row_instance_init, NULL };
	GType about_firmware_view_firmware_header_row_type_id;
	about_firmware_view_firmware_header_row_type_id = g_type_register_static (gtk_label_get_type (), "AboutFirmwareViewFirmwareHeaderRow", &g_define_type_info, 0);
	return about_firmware_view_firmware_header_row_type_id;
}

static GType
about_firmware_view_firmware_header_row_get_type (void)
{
	static volatile gsize about_firmware_view_firmware_header_row_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_view_firmware_header_row_type_id__once)) {
		GType about_firmware_view_firmware_header_row_type_id;
		about_firmware_view_firmware_header_row_type_id = about_firmware_view_firmware_header_row_get_type_once ();
		g_once_init_leave (&about_firmware_view_firmware_header_row_type_id__once, about_firmware_view_firmware_header_row_type_id);
	}
	return about_firmware_view_firmware_header_row_type_id__once;
}

static void
_about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	about_firmware_view_reboot_to_firmware_setup_clicked ((AboutFirmwareView*) self);
}

static void
_about_firmware_view_on_device_added_fwupd_client_device_added (FwupdClient* _sender,
                                                                FwupdDevice* _result_,
                                                                gpointer self)
{
	about_firmware_view_on_device_added ((AboutFirmwareView*) self, _sender, _result_);
}

static void
_about_firmware_view_on_device_removed_fwupd_client_device_removed (FwupdClient* _sender,
                                                                    FwupdDevice* _result_,
                                                                    gpointer self)
{
	about_firmware_view_on_device_removed ((AboutFirmwareView*) self, _sender, _result_);
}

static void
_about_firmware_view_show_release_gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	about_firmware_view_show_release ((AboutFirmwareView*) self, row);
}

static void
_about_firmware_view___lambda18_ (AboutFirmwareView* self,
                                  FwupdDevice* device,
                                  FwupdRelease* release)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (release != NULL);
	about_firmware_view_update (self, device, release, NULL, NULL);
}

static void
__about_firmware_view___lambda18__about_firmware_release_view_update (AboutFirmwareReleaseView* _sender,
                                                                      FwupdDevice* device,
                                                                      FwupdRelease* release,
                                                                      gpointer self)
{
	_about_firmware_view___lambda18_ ((AboutFirmwareView*) self, device, release);
}

static GObject *
about_firmware_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareView * self;
	GraniteWidgetsAlertView* _tmp0_;
	GraniteWidgetsAlertView* _tmp1_;
	GtkStyleContext* _tmp2_;
	GraniteWidgetsAlertView* _tmp3_;
	GraniteWidgetsAlertView* _tmp4_;
	GraniteWidgetsAlertView* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkListBox* _tmp7_ = NULL;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GraniteWidgetsAlertView* _tmp11_;
	GtkScrolledWindow* update_scrolled = NULL;
	GtkScrolledWindow* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkListBox* _tmp14_;
	AboutFirmwareReleaseView* _tmp15_;
	HdyDeck* _tmp16_ = NULL;
	HdyDeck* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	HdyDeck* _tmp19_;
	AboutFirmwareReleaseView* _tmp20_;
	HdyDeck* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkStack* _tmp23_ = NULL;
	GtkStack* _tmp24_;
	HdyDeck* _tmp25_;
	GtkStack* _tmp26_;
	GraniteWidgetsAlertView* _tmp27_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp28_;
	GtkFrame* _tmp29_;
	GtkStack* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkFrame* _tmp33_;
	AboutLoginManager* _tmp34_;
	AboutLoginManager* _tmp35_;
	gboolean _tmp36_;
	FwupdClient* _tmp42_;
	FwupdClient* _tmp43_;
	FwupdClient* _tmp44_;
	GtkListBox* _tmp45_;
	AboutFirmwareReleaseView* _tmp46_;
	parent_class = G_OBJECT_CLASS (about_firmware_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_VIEW, AboutFirmwareView);
	_tmp0_ = granite_widgets_alert_view_new ("", _ ("Do not unplug the device during the update."), "emblem-synchronized");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->progress_alert_view);
	self->priv->progress_alert_view = _tmp0_;
	_tmp1_ = self->priv->progress_alert_view;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_remove_class (_tmp2_, GTK_STYLE_CLASS_VIEW);
	_tmp3_ = granite_widgets_alert_view_new (_ ("Checking for Updates"), _ ("Connecting to the firmware service and searching for updates."), "sync-synchronizing");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->placeholder_alert_view);
	self->priv->placeholder_alert_view = _tmp3_;
	_tmp4_ = self->priv->placeholder_alert_view;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->placeholder_alert_view;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_remove_class (_tmp6_, GTK_STYLE_CLASS_VIEW);
	_tmp7_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp7_, TRUE);
	gtk_list_box_set_selection_mode (_tmp7_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->update_list);
	self->priv->update_list = _tmp7_;
	_tmp8_ = self->priv->update_list;
	gtk_list_box_set_sort_func (_tmp8_, (GtkListBoxSortFunc) about_firmware_view_compare_rows, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->update_list;
	gtk_list_box_set_header_func (_tmp9_, (GtkListBoxUpdateHeaderFunc) about_firmware_view_header_rows, g_object_ref (self), g_object_unref);
	_tmp10_ = self->priv->update_list;
	_tmp11_ = self->priv->placeholder_alert_view;
	gtk_list_box_set_placeholder (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp12_);
	update_scrolled = _tmp12_;
	_tmp13_ = update_scrolled;
	_tmp14_ = self->priv->update_list;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = about_firmware_release_view_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->firmware_release_view);
	self->priv->firmware_release_view = _tmp15_;
	_tmp16_ = (HdyDeck*) hdy_deck_new ();
	hdy_deck_set_can_swipe_back (_tmp16_, TRUE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->deck);
	self->priv->deck = _tmp16_;
	_tmp17_ = self->priv->deck;
	_tmp18_ = update_scrolled;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->deck;
	_tmp20_ = self->priv->firmware_release_view;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->deck;
	_tmp22_ = update_scrolled;
	hdy_deck_set_visible_child (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp23_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp23_;
	_tmp24_ = self->priv->stack;
	_tmp25_ = self->priv->deck;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->stack;
	_tmp27_ = self->priv->progress_alert_view;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp28_);
	frame = _tmp28_;
	_tmp29_ = frame;
	_tmp30_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = frame;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = about_login_manager_get_instance ();
	_tmp35_ = _tmp34_;
	_tmp36_ = about_login_manager_can_reboot_to_firmware_setup (_tmp35_);
	_g_object_unref0 (_tmp35_);
	if (_tmp36_) {
		GtkButton* reboot_to_firmware_setup_button = NULL;
		GtkButton* _tmp37_;
		GtkButton* _tmp38_;
		GtkButtonBox* _tmp39_;
		GtkButtonBox* _tmp40_;
		GtkButton* _tmp41_;
		_tmp37_ = (GtkButton*) gtk_button_new_with_label (_ ("Restart to Firmware Setup…"));
		g_object_ref_sink (_tmp37_);
		reboot_to_firmware_setup_button = _tmp37_;
		_tmp38_ = reboot_to_firmware_setup_button;
		g_signal_connect_object (_tmp38_, "clicked", (GCallback) _about_firmware_view_reboot_to_firmware_setup_clicked_gtk_button_clicked, self, 0);
		_tmp39_ = granite_simple_settings_page_get_action_area ((GraniteSimpleSettingsPage*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = reboot_to_firmware_setup_button;
		gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
		_g_object_unref0 (reboot_to_firmware_setup_button);
	}
	_tmp42_ = fwupd_client_new ();
	_g_object_unref0 (self->priv->fwupd_client);
	self->priv->fwupd_client = _tmp42_;
	_tmp43_ = self->priv->fwupd_client;
	g_signal_connect_object (_tmp43_, "device-added", (GCallback) _about_firmware_view_on_device_added_fwupd_client_device_added, self, 0);
	_tmp44_ = self->priv->fwupd_client;
	g_signal_connect_object (_tmp44_, "device-removed", (GCallback) _about_firmware_view_on_device_removed_fwupd_client_device_removed, self, 0);
	about_firmware_view_update_list_view (self, NULL, NULL);
	_tmp45_ = self->priv->update_list;
	g_signal_connect_object (_tmp45_, "row-activated", (GCallback) _about_firmware_view_show_release_gtk_list_box_row_activated, self, 0);
	_tmp46_ = self->priv->firmware_release_view;
	g_signal_connect_object (_tmp46_, "update", (GCallback) __about_firmware_view___lambda18__about_firmware_release_view_update, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (update_scrolled);
	return obj;
}

static void
about_firmware_view_class_init (AboutFirmwareViewClass * klass,
                                gpointer klass_data)
{
	about_firmware_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutFirmwareView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_firmware_view_finalize;
}

static void
about_firmware_view_instance_init (AboutFirmwareView * self,
                                   gpointer klass)
{
	self->priv = about_firmware_view_get_instance_private (self);
	self->priv->num_updates = (guint) 0;
}

static void
about_firmware_view_finalize (GObject * obj)
{
	AboutFirmwareView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_VIEW, AboutFirmwareView);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->deck);
	_g_object_unref0 (self->priv->firmware_release_view);
	_g_object_unref0 (self->priv->progress_alert_view);
	_g_object_unref0 (self->priv->placeholder_alert_view);
	_g_object_unref0 (self->priv->update_list);
	_g_object_unref0 (self->priv->fwupd_client);
	G_OBJECT_CLASS (about_firmware_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_firmware_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareView), 0, (GInstanceInitFunc) about_firmware_view_instance_init, NULL };
	GType about_firmware_view_type_id;
	about_firmware_view_type_id = g_type_register_static (GRANITE_TYPE_SIMPLE_SETTINGS_PAGE, "AboutFirmwareView", &g_define_type_info, 0);
	AboutFirmwareView_private_offset = g_type_add_instance_private (about_firmware_view_type_id, sizeof (AboutFirmwareViewPrivate));
	return about_firmware_view_type_id;
}

GType
about_firmware_view_get_type (void)
{
	static volatile gsize about_firmware_view_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_view_type_id__once)) {
		GType about_firmware_view_type_id;
		about_firmware_view_type_id = about_firmware_view_get_type_once ();
		g_once_init_leave (&about_firmware_view_type_id__once, about_firmware_view_type_id);
	}
	return about_firmware_view_type_id__once;
}

