/* FirmwareReleaseView.c generated by valac 0.56.13, the Vala compiler
 * generated from FirmwareReleaseView.vala, do not modify */

/*
 * Copyright (c) 2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include "about.h"
#include <fwupd.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <handy.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <appstream.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_0_PROPERTY,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_release_view_properties[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS
};
static guint about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS] = {0};

struct _AboutFirmwareReleaseViewPrivate {
	FwupdDevice* device;
	FwupdRelease* release;
	GraniteWidgetsAlertView* placeholder;
	GtkScrolledWindow* scrolled_window;
	GtkStack* content;
	GtkRevealer* update_button_revealer;
	GtkButton* update_button;
	GtkLabel* title_label;
	GtkLabel* summary_label;
	GtkLabel* description_label;
	GtkLabel* version_value_label;
	GtkLabel* vendor_value_label;
	GtkLabel* size_value_label;
	GtkLabel* install_duration_value_label;
	HdyDeck* deck;
};

static gint AboutFirmwareReleaseView_private_offset;
static gpointer about_firmware_release_view_parent_class = NULL;

static void about_firmware_release_view_go_back (AboutFirmwareReleaseView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * about_firmware_release_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _about_firmware_release_view___lambda8_ (AboutFirmwareReleaseView* self);
static void __about_firmware_release_view___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void _about_firmware_release_view___lambda9_ (AboutFirmwareReleaseView* self);
static void __about_firmware_release_view___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void about_firmware_release_view_finalize (GObject * obj);
static GType about_firmware_release_view_get_type_once (void);

static inline gpointer
about_firmware_release_view_get_instance_private (AboutFirmwareReleaseView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutFirmwareReleaseView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
about_firmware_release_view_update_view (AboutFirmwareReleaseView* self,
                                         FwupdDevice* device,
                                         FwupdRelease* release)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	gchar* device_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkStack* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	gchar* release_version = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GtkLabel* _tmp33_;
	const gchar* _tmp34_;
	GtkLabel* _tmp42_;
	const gchar* _tmp43_;
	GtkLabel* _tmp44_;
	const gchar* _tmp45_;
	GtkLabel* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	guint32 duration_minutes = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->device);
	self->priv->device = _tmp0_;
	_tmp1_ = _g_object_ref0 (release);
	_g_object_unref0 (self->priv->release);
	self->priv->release = _tmp1_;
	_tmp2_ = fwupd_device_get_name (device);
	_tmp3_ = g_strdup (_tmp2_);
	device_name = _tmp3_;
	_tmp4_ = self->priv->title_label;
	_tmp5_ = device_name;
	_tmp6_ = g_strdup_printf ("<b>%s</b>", _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->update_button_revealer;
	gtk_revealer_set_reveal_child (_tmp8_, release != NULL);
	if (release == NULL) {
		GraniteWidgetsAlertView* _tmp9_;
		const gchar* _tmp10_;
		GPtrArray* icons = NULL;
		GPtrArray* _tmp11_;
		GPtrArray* _tmp12_;
		GPtrArray* _tmp13_;
		gpointer* _tmp14_;
		gint _tmp14__length1;
		GtkStack* _tmp20_;
		GraniteWidgetsAlertView* _tmp21_;
		_tmp9_ = self->priv->placeholder;
		_tmp10_ = device_name;
		granite_widgets_alert_view_set_title (_tmp9_, _tmp10_);
		_tmp11_ = fwupd_device_get_icons (device);
		_tmp12_ = _g_ptr_array_ref0 (_tmp11_);
		icons = _tmp12_;
		_tmp13_ = icons;
		_tmp14_ = _tmp13_->pdata;
		_tmp14__length1 = _tmp13_->len;
		if (_tmp14_ != NULL) {
			GraniteWidgetsAlertView* _tmp15_;
			GPtrArray* _tmp16_;
			gpointer* _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			_tmp15_ = self->priv->placeholder;
			_tmp16_ = icons;
			_tmp17_ = _tmp16_->pdata;
			_tmp17__length1 = _tmp16_->len;
			_tmp18_ = _tmp17_[0];
			granite_widgets_alert_view_set_icon_name (_tmp15_, _tmp18_);
		} else {
			GraniteWidgetsAlertView* _tmp19_;
			_tmp19_ = self->priv->placeholder;
			granite_widgets_alert_view_set_icon_name (_tmp19_, "application-x-firmware");
		}
		_tmp20_ = self->priv->content;
		_tmp21_ = self->priv->placeholder;
		gtk_stack_set_visible_child (_tmp20_, (GtkWidget*) _tmp21_);
		_g_ptr_array_unref0 (icons);
		_g_free0 (device_name);
		return;
	}
	_tmp22_ = self->priv->content;
	_tmp23_ = self->priv->scrolled_window;
	gtk_stack_set_visible_child (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = fwupd_release_get_version (release);
	_tmp25_ = g_strdup (_tmp24_);
	release_version = _tmp25_;
	if (fwupd_release_get_flags (release) == ((FwupdReleaseFlags) FWUPD_RELEASE_FLAG_IS_UPGRADE)) {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = release_version;
		_tmp28_ = fwupd_device_get_version (device);
		_tmp26_ = g_strcmp0 (_tmp27_, _tmp28_) != 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GtkButton* _tmp29_;
		GtkButton* _tmp30_;
		_tmp29_ = self->priv->update_button;
		gtk_button_set_label (_tmp29_, _ ("Update"));
		_tmp30_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, TRUE);
	} else {
		GtkButton* _tmp31_;
		GtkButton* _tmp32_;
		_tmp31_ = self->priv->update_button;
		gtk_button_set_label (_tmp31_, _ ("Up to date"));
		_tmp32_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, FALSE);
	}
	_tmp33_ = self->priv->summary_label;
	_tmp34_ = fwupd_release_get_summary (release);
	gtk_label_set_label (_tmp33_, _tmp34_);
	{
		gchar* _tmp35_ = NULL;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		GtkLabel* _tmp38_;
		_tmp36_ = fwupd_release_get_description (release);
		_tmp37_ = as_markup_convert (_tmp36_, AS_MARKUP_KIND_TEXT, &_inner_error0_);
		_tmp35_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp38_ = self->priv->description_label;
		gtk_label_set_label (_tmp38_, _tmp35_);
		_g_free0 (_tmp35_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp39_;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = self->priv->description_label;
		gtk_label_set_label (_tmp39_, "");
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_warning ("FirmwareReleaseView.vala:220: Could not convert markup of release: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (release_version);
		_g_free0 (device_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp42_ = self->priv->version_value_label;
	_tmp43_ = release_version;
	gtk_label_set_label (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->vendor_value_label;
	_tmp45_ = fwupd_release_get_vendor (release);
	gtk_label_set_label (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->size_value_label;
	_tmp47_ = g_format_size_full (fwupd_release_get_size (release), G_FORMAT_SIZE_DEFAULT);
	_tmp48_ = _tmp47_;
	gtk_label_set_label (_tmp46_, _tmp48_);
	_g_free0 (_tmp48_);
	duration_minutes = fwupd_release_get_install_duration (release) / 60;
	if (duration_minutes < ((guint32) 1)) {
		GtkLabel* _tmp49_;
		_tmp49_ = self->priv->install_duration_value_label;
		gtk_label_set_label (_tmp49_, _ ("less than a minute"));
	} else {
		GtkLabel* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp50_ = self->priv->install_duration_value_label;
		_tmp51_ = g_strdup_printf (ngettext ("%llu minute", "%llu minutes", (gulong) duration_minutes), duration_minutes);
		_tmp52_ = _tmp51_;
		gtk_label_set_label (_tmp50_, _tmp52_);
		_g_free0 (_tmp52_);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_free0 (release_version);
	_g_free0 (device_name);
}

static void
about_firmware_release_view_go_back (AboutFirmwareReleaseView* self)
{
	HdyDeck* _tmp0_;
	HdyDeck* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	if (_tmp0_ == NULL) {
		GtkWidget* _tmp1_;
		HdyDeck* _tmp2_;
		_tmp1_ = gtk_widget_get_ancestor ((GtkWidget*) self, hdy_deck_get_type ());
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, hdy_deck_get_type (), HdyDeck));
		_g_object_unref0 (self->priv->deck);
		self->priv->deck = _tmp2_;
	}
	_tmp3_ = self->priv->deck;
	hdy_deck_navigate (_tmp3_, HDY_NAVIGATION_DIRECTION_BACK);
}

AboutFirmwareReleaseView*
about_firmware_release_view_construct (GType object_type)
{
	AboutFirmwareReleaseView * self = NULL;
	self = (AboutFirmwareReleaseView*) g_object_new (object_type, NULL);
	return self;
}

AboutFirmwareReleaseView*
about_firmware_release_view_new (void)
{
	return about_firmware_release_view_construct (ABOUT_TYPE_FIRMWARE_RELEASE_VIEW);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_about_firmware_release_view___lambda8_ (AboutFirmwareReleaseView* self)
{
	about_firmware_release_view_go_back (self);
}

static void
__about_firmware_release_view___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_about_firmware_release_view___lambda8_ ((AboutFirmwareReleaseView*) self);
}

static void
_about_firmware_release_view___lambda9_ (AboutFirmwareReleaseView* self)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	about_firmware_release_view_go_back (self);
	_tmp0_ = self->priv->device;
	_tmp1_ = self->priv->release;
	g_signal_emit (self, about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
__about_firmware_release_view___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_about_firmware_release_view___lambda9_ ((AboutFirmwareReleaseView*) self);
}

static GObject *
about_firmware_release_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareReleaseView * self;
	GtkButton* back_button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkRevealer* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkButton* _tmp9_;
	GtkBox* header_box = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GtkButton* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* version_label = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* vendor_label = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* size_label = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* install_duration_label = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkGrid* key_val_grid = NULL;
	GtkGrid* _tmp29_ = NULL;
	GtkGrid* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkLabel* _tmp43_;
	GtkGrid* _tmp44_;
	GtkLabel* _tmp45_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	GraniteWidgetsAlertView* _tmp48_;
	GraniteWidgetsAlertView* _tmp49_;
	GtkStyleContext* _tmp50_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp51_ = NULL;
	GtkGrid* _tmp52_;
	GtkLabel* _tmp53_;
	GtkGrid* _tmp54_;
	GtkLabel* _tmp55_;
	GtkGrid* _tmp56_;
	GtkGrid* _tmp57_;
	GtkScrolledWindow* _tmp58_ = NULL;
	GtkScrolledWindow* _tmp59_;
	GtkGrid* _tmp60_;
	GtkStack* _tmp61_;
	GtkStack* _tmp62_;
	GraniteWidgetsAlertView* _tmp63_;
	GtkStack* _tmp64_;
	GtkScrolledWindow* _tmp65_;
	GtkStyleContext* _tmp66_;
	GtkBox* _tmp67_;
	GtkSeparator* _tmp68_;
	GtkSeparator* _tmp69_;
	GtkStack* _tmp70_;
	GtkButton* _tmp71_;
	GtkButton* _tmp72_;
	parent_class = G_OBJECT_CLASS (about_firmware_release_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (_ ("All Updates"));
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_set ((GtkWidget*) _tmp0_, "margin", 6, NULL);
	g_object_ref_sink (_tmp0_);
	back_button = _tmp0_;
	_tmp1_ = back_button;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, GRANITE_STYLE_CLASS_BACK_BUTTON);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp3_;
	_tmp4_ = (GtkButton*) gtk_button_new_with_label ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
	g_object_set ((GtkWidget*) _tmp4_, "margin", 6, NULL);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->update_button);
	self->priv->update_button = _tmp4_;
	_tmp5_ = self->priv->update_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->update_button_revealer);
	self->priv->update_button_revealer = _tmp7_;
	_tmp8_ = self->priv->update_button_revealer;
	_tmp9_ = self->priv->update_button;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	header_box = _tmp10_;
	_tmp11_ = header_box;
	_tmp12_ = back_button;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, TRUE, TRUE, (guint) 0);
	_tmp13_ = header_box;
	_tmp14_ = self->priv->title_label;
	gtk_box_set_center_widget (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = header_box;
	_tmp16_ = self->priv->update_button_revealer;
	gtk_box_pack_end (_tmp15_, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	g_object_set (_tmp17_, "wrap", TRUE, NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->summary_label);
	self->priv->summary_label = _tmp17_;
	_tmp18_ = self->priv->summary_label;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp20_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
	g_object_set (_tmp20_, "wrap", TRUE, NULL);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->description_label);
	self->priv->description_label = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("Version:"));
	gtk_label_set_xalign (_tmp21_, (gfloat) 1);
	g_object_ref_sink (_tmp21_);
	version_label = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp22_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->version_value_label);
	self->priv->version_value_label = _tmp22_;
	_tmp23_ = (GtkLabel*) gtk_label_new (_ ("Vendor:"));
	gtk_label_set_xalign (_tmp23_, (gfloat) 1);
	g_object_ref_sink (_tmp23_);
	vendor_label = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp24_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->vendor_value_label);
	self->priv->vendor_value_label = _tmp24_;
	_tmp25_ = (GtkLabel*) gtk_label_new (_ ("Size:"));
	gtk_label_set_xalign (_tmp25_, (gfloat) 1);
	g_object_ref_sink (_tmp25_);
	size_label = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp26_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->size_value_label);
	self->priv->size_value_label = _tmp26_;
	_tmp27_ = (GtkLabel*) gtk_label_new (_ ("Estimated time to install:"));
	gtk_label_set_xalign (_tmp27_, (gfloat) 1);
	g_object_ref_sink (_tmp27_);
	install_duration_label = _tmp27_;
	_tmp28_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp28_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, TRUE);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->install_duration_value_label);
	self->priv->install_duration_value_label = _tmp28_;
	_tmp29_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_homogeneous (_tmp29_, TRUE);
	gtk_grid_set_column_spacing (_tmp29_, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp29_, 12);
	gtk_grid_set_row_spacing (_tmp29_, 3);
	g_object_ref_sink (_tmp29_);
	key_val_grid = _tmp29_;
	_tmp30_ = key_val_grid;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
	gtk_style_context_add_class (_tmp31_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp32_ = key_val_grid;
	_tmp33_ = version_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 0, 1, 1);
	_tmp34_ = key_val_grid;
	_tmp35_ = self->priv->version_value_label;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 1, 0, 1, 1);
	_tmp36_ = key_val_grid;
	_tmp37_ = vendor_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 0, 1, 1, 1);
	_tmp38_ = key_val_grid;
	_tmp39_ = self->priv->vendor_value_label;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, 1, 1, 1);
	_tmp40_ = key_val_grid;
	_tmp41_ = size_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 2, 1, 1);
	_tmp42_ = key_val_grid;
	_tmp43_ = self->priv->size_value_label;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 2, 1, 1);
	_tmp44_ = key_val_grid;
	_tmp45_ = install_duration_label;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 0, 3, 1, 1);
	_tmp46_ = key_val_grid;
	_tmp47_ = self->priv->install_duration_value_label;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 1, 3, 1, 1);
	_tmp48_ = granite_widgets_alert_view_new ("", _ ("There are no releases available for this device."), "");
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp48_;
	_tmp49_ = self->priv->placeholder;
	_tmp50_ = gtk_widget_get_style_context ((GtkWidget*) _tmp49_);
	gtk_style_context_remove_class (_tmp50_, GTK_STYLE_CLASS_VIEW);
	_tmp51_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp51_, GTK_ALIGN_CENTER);
	g_object_set ((GtkWidget*) _tmp51_, "margin", 12, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp51_, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (_tmp51_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp51_, TRUE);
	g_object_ref_sink (_tmp51_);
	grid = _tmp51_;
	_tmp52_ = grid;
	_tmp53_ = self->priv->summary_label;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = grid;
	_tmp55_ = self->priv->description_label;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = grid;
	_tmp57_ = key_val_grid;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp58_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp58_, TRUE);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp58_;
	_tmp59_ = self->priv->scrolled_window;
	_tmp60_ = grid;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp61_;
	_tmp62_ = self->priv->content;
	_tmp63_ = self->priv->placeholder;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = self->priv->content;
	_tmp65_ = self->priv->scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp66_, GTK_STYLE_CLASS_VIEW);
	_tmp67_ = header_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp67_);
	_tmp68_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp68_);
	_tmp69_ = _tmp68_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp69_);
	_g_object_unref0 (_tmp69_);
	_tmp70_ = self->priv->content;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp70_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp71_ = back_button;
	g_signal_connect_object (_tmp71_, "clicked", (GCallback) __about_firmware_release_view___lambda8__gtk_button_clicked, self, 0);
	_tmp72_ = self->priv->update_button;
	g_signal_connect_object (_tmp72_, "clicked", (GCallback) __about_firmware_release_view___lambda9__gtk_button_clicked, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (key_val_grid);
	_g_object_unref0 (install_duration_label);
	_g_object_unref0 (size_label);
	_g_object_unref0 (vendor_label);
	_g_object_unref0 (version_label);
	_g_object_unref0 (header_box);
	_g_object_unref0 (back_button);
	return obj;
}

static void
about_firmware_release_view_class_init (AboutFirmwareReleaseViewClass * klass,
                                        gpointer klass_data)
{
	about_firmware_release_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutFirmwareReleaseView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_release_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_firmware_release_view_finalize;
	about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL] = g_signal_new ("update", ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, fwupd_device_get_type (), fwupd_release_get_type ());
}

static void
about_firmware_release_view_instance_init (AboutFirmwareReleaseView * self,
                                           gpointer klass)
{
	self->priv = about_firmware_release_view_get_instance_private (self);
}

static void
about_firmware_release_view_finalize (GObject * obj)
{
	AboutFirmwareReleaseView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_g_object_unref0 (self->priv->device);
	_g_object_unref0 (self->priv->release);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->update_button_revealer);
	_g_object_unref0 (self->priv->update_button);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->summary_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->version_value_label);
	_g_object_unref0 (self->priv->vendor_value_label);
	_g_object_unref0 (self->priv->size_value_label);
	_g_object_unref0 (self->priv->install_duration_value_label);
	_g_object_unref0 (self->priv->deck);
	G_OBJECT_CLASS (about_firmware_release_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_firmware_release_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareReleaseViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_release_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareReleaseView), 0, (GInstanceInitFunc) about_firmware_release_view_instance_init, NULL };
	GType about_firmware_release_view_type_id;
	about_firmware_release_view_type_id = g_type_register_static (gtk_grid_get_type (), "AboutFirmwareReleaseView", &g_define_type_info, 0);
	AboutFirmwareReleaseView_private_offset = g_type_add_instance_private (about_firmware_release_view_type_id, sizeof (AboutFirmwareReleaseViewPrivate));
	return about_firmware_release_view_type_id;
}

GType
about_firmware_release_view_get_type (void)
{
	static volatile gsize about_firmware_release_view_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_release_view_type_id__once)) {
		GType about_firmware_release_view_type_id;
		about_firmware_release_view_type_id = about_firmware_release_view_get_type_once ();
		g_once_init_leave (&about_firmware_release_view_type_id__once, about_firmware_release_view_type_id);
	}
	return about_firmware_release_view_type_id__once;
}

