/* Plug.c generated by valac 0.56.13, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*           2015 Ivo Nunes, Akshay Shekher
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "about.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#define ABOUT_PLUG_OPERATING_SYSTEM "operating-system"
#define ABOUT_PLUG_HARDWARE "hardware"
#define ABOUT_PLUG_FIRMWARE "firmware"
#define ABOUT_GETTEXT_PACKAGE "about-plug"
#define ABOUT_LOCALEDIR "/usr/share/locale"

enum  {
	ABOUT_PLUG_0_PROPERTY,
	ABOUT_PLUG_NUM_PROPERTIES
};
static GParamSpec* about_plug_properties[ABOUT_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AboutPlugSearchData AboutPlugSearchData;

struct _AboutPlugPrivate {
	GtkGrid* main_grid;
	GtkStack* stack;
};

struct _AboutPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
};

static gint AboutPlug_private_offset;
static gpointer about_plug_parent_class = NULL;

static GtkWidget* about_plug_real_get_widget (SwitchboardPlug* base);
static void about_plug_real_shown (SwitchboardPlug* base);
static void about_plug_real_hidden (SwitchboardPlug* base);
static void about_plug_real_search_callback (SwitchboardPlug* base,
                                      const gchar* location);
static void about_plug_real_search_data_free (gpointer _data);
static void about_plug_real_search (SwitchboardPlug* base,
                             const gchar* search,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static gboolean about_plug_real_search_co (AboutPlugSearchData* _data_);
static void about_plug_finalize (GObject * obj);
static GType about_plug_get_type_once (void);

static inline gpointer
about_plug_get_instance_private (AboutPlug* self)
{
	return G_STRUCT_MEMBER_P (self, AboutPlug_private_offset);
}

AboutPlug*
about_plug_construct (GType object_type)
{
	AboutPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (ABOUT_GETTEXT_PACKAGE, ABOUT_LOCALEDIR);
	bind_textdomain_codeset (ABOUT_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/os", ABOUT_PLUG_OPERATING_SYSTEM);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/hardware", ABOUT_PLUG_HARDWARE);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/firmware", ABOUT_PLUG_FIRMWARE);
	self = (AboutPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_SYSTEM, "code-name", "io.elementary.switchboard.about", "display-name", _ ("System"), "description", _ ("View operating system and hardware information"), "icon", "application-x-firmware", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

AboutPlug*
about_plug_new (void)
{
	return about_plug_construct (ABOUT_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
about_plug_real_get_widget (SwitchboardPlug* base)
{
	AboutPlug * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp20_;
	GtkWidget* _tmp21_;
	GtkWidget* result;
	self = (AboutPlug*) base;
	_tmp0_ = self->priv->main_grid;
	if (_tmp0_ == NULL) {
		AboutOperatingSystemView* operating_system_view = NULL;
		AboutOperatingSystemView* _tmp1_;
		AboutHardwareView* hardware_view = NULL;
		AboutHardwareView* _tmp2_ = NULL;
		AboutFirmwareView* firmware_view = NULL;
		AboutFirmwareView* _tmp3_;
		GtkStack* _tmp4_ = NULL;
		GtkStack* _tmp5_;
		AboutOperatingSystemView* _tmp6_;
		GtkStack* _tmp7_;
		AboutHardwareView* _tmp8_;
		GtkStack* _tmp9_;
		AboutFirmwareView* _tmp10_;
		GtkStackSwitcher* stack_switcher = NULL;
		GtkStack* _tmp11_;
		GtkStack* _tmp12_;
		GtkStackSwitcher* _tmp13_ = NULL;
		GtkGrid* _tmp14_ = NULL;
		GtkGrid* _tmp15_;
		GtkStackSwitcher* _tmp16_;
		GtkGrid* _tmp17_;
		GtkStack* _tmp18_;
		GtkGrid* _tmp19_;
		_tmp1_ = about_operating_system_view_new ();
		g_object_ref_sink (_tmp1_);
		operating_system_view = _tmp1_;
		_tmp2_ = about_hardware_view_new ();
		gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp2_);
		hardware_view = _tmp2_;
		_tmp3_ = about_firmware_view_new ();
		g_object_ref_sink (_tmp3_);
		firmware_view = _tmp3_;
		_tmp4_ = (GtkStack*) gtk_stack_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp4_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = operating_system_view;
		gtk_stack_add_titled (_tmp5_, (GtkWidget*) _tmp6_, ABOUT_PLUG_OPERATING_SYSTEM, _ ("Operating System"));
		_tmp7_ = self->priv->stack;
		_tmp8_ = hardware_view;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, ABOUT_PLUG_HARDWARE, _ ("Hardware"));
		_tmp9_ = self->priv->stack;
		_tmp10_ = firmware_view;
		gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, ABOUT_PLUG_FIRMWARE, _ ("Firmware"));
		_tmp11_ = self->priv->stack;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_tmp13_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
		gtk_box_set_homogeneous ((GtkBox*) _tmp13_, TRUE);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp13_, 24);
		gtk_stack_switcher_set_stack (_tmp13_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		g_object_ref_sink (_tmp13_);
		stack_switcher = _tmp13_;
		_tmp14_ = (GtkGrid*) gtk_grid_new ();
		gtk_grid_set_row_spacing (_tmp14_, 12);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->main_grid);
		self->priv->main_grid = _tmp14_;
		_tmp15_ = self->priv->main_grid;
		_tmp16_ = stack_switcher;
		gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp16_, 0, 0, 1, 1);
		_tmp17_ = self->priv->main_grid;
		_tmp18_ = self->priv->stack;
		gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 0, 1, 1, 1);
		_tmp19_ = self->priv->main_grid;
		gtk_widget_show_all ((GtkWidget*) _tmp19_);
		_g_object_unref0 (stack_switcher);
		_g_object_unref0 (firmware_view);
		_g_object_unref0 (hardware_view);
		_g_object_unref0 (operating_system_view);
	}
	_tmp20_ = self->priv->main_grid;
	_tmp21_ = _g_object_ref0 ((GtkWidget*) _tmp20_);
	result = _tmp21_;
	return result;
}

static void
about_plug_real_shown (SwitchboardPlug* base)
{
	AboutPlug * self;
	self = (AboutPlug*) base;
}

static void
about_plug_real_hidden (SwitchboardPlug* base)
{
	AboutPlug * self;
	self = (AboutPlug*) base;
}

static void
about_plug_real_search_callback (SwitchboardPlug* base,
                                 const gchar* location)
{
	AboutPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	self = (AboutPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (ABOUT_PLUG_OPERATING_SYSTEM)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (ABOUT_PLUG_HARDWARE))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (ABOUT_PLUG_FIRMWARE))))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, location);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, ABOUT_PLUG_OPERATING_SYSTEM);
				break;
			}
		}
	}
}

static void
about_plug_real_search_data_free (gpointer _data)
{
	AboutPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutPlugSearchData, _data_);
}

static void
about_plug_real_search (SwitchboardPlug* base,
                        const gchar* search,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	AboutPlug * self;
	AboutPlugSearchData* _data_;
	AboutPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (AboutPlug*) base;
	_data_ = g_slice_new0 (AboutPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	about_plug_real_search_co (_data_);
}

static GeeTreeMap*
about_plug_search_finish (SwitchboardPlug* base,
                          GAsyncResult* _res_)
{
	GeeTreeMap* result;
	AboutPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
about_plug_real_search_co (AboutPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Operating System Information"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("Hardware Information"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, ABOUT_PLUG_HARDWARE);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Firmware"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, ABOUT_PLUG_FIRMWARE);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Restore Default Settings"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("Suggest Translations"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s", _data_->_tmp24_, _ ("Send Feedback"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s", _data_->_tmp28_, _ ("Report a Problem"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s", _data_->_tmp32_, _ ("Get Support"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s", _data_->_tmp36_, _ ("Updates"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp38_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_plug_class_init (AboutPlugClass * klass,
                       gpointer klass_data)
{
	about_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) about_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) about_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) about_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) about_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) about_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) about_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = about_plug_finalize;
}

static void
about_plug_instance_init (AboutPlug * self,
                          gpointer klass)
{
	self->priv = about_plug_get_instance_private (self);
}

static void
about_plug_finalize (GObject * obj)
{
	AboutPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_PLUG, AboutPlug);
	_g_object_unref0 (self->priv->main_grid);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (about_plug_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutPlug), 0, (GInstanceInitFunc) about_plug_instance_init, NULL };
	GType about_plug_type_id;
	about_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "AboutPlug", &g_define_type_info, 0);
	AboutPlug_private_offset = g_type_add_instance_private (about_plug_type_id, sizeof (AboutPlugPrivate));
	return about_plug_type_id;
}

GType
about_plug_get_type (void)
{
	static volatile gsize about_plug_type_id__once = 0;
	if (g_once_init_enter (&about_plug_type_id__once)) {
		GType about_plug_type_id;
		about_plug_type_id = about_plug_get_type_once ();
		g_once_init_leave (&about_plug_type_id__once, about_plug_type_id);
	}
	return about_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	AboutPlug* plug = NULL;
	AboutPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:125: Activating System plug");
	_tmp0_ = about_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

