/* SearchView.c generated by valac 0.56.17, the Vala compiler
 * generated from SearchView.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "switchboard.h"
#include <gee.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SWITCHBOARD_TYPE_SEARCH_VIEW (switchboard_search_view_get_type ())
#define SWITCHBOARD_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchView))
#define SWITCHBOARD_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))
#define SWITCHBOARD_IS_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_IS_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_SEARCH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))

typedef struct _SwitchboardSearchView SwitchboardSearchView;
typedef struct _SwitchboardSearchViewClass SwitchboardSearchViewClass;
typedef struct _SwitchboardSearchViewPrivate SwitchboardSearchViewPrivate;
enum  {
	SWITCHBOARD_SEARCH_VIEW_0_PROPERTY,
	SWITCHBOARD_SEARCH_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_search_view_properties[SWITCHBOARD_SEARCH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW (switchboard_search_view_search_row_get_type ())
#define SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow))
#define SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRowClass))
#define SWITCHBOARD_SEARCH_VIEW_IS_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW))
#define SWITCHBOARD_SEARCH_VIEW_IS_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW))
#define SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRowClass))

typedef struct _SwitchboardSearchViewSearchRow SwitchboardSearchViewSearchRow;
typedef struct _SwitchboardSearchViewSearchRowClass SwitchboardSearchViewSearchRowClass;
typedef struct _SwitchboardSearchViewLoadPlugsData SwitchboardSearchViewLoadPlugsData;
typedef struct _SwitchboardSearchViewSearchRowPrivate SwitchboardSearchViewSearchRowPrivate;
enum  {
	SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_0_PROPERTY,
	SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY,
	SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY,
	SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY,
	SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_NUM_PROPERTIES
};
static GParamSpec* switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_NUM_PROPERTIES];

#define SWITCHBOARD_TYPE_SWITCHBOARD_APP (switchboard_switchboard_app_get_type ())
#define SWITCHBOARD_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp))
#define SWITCHBOARD_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))
#define SWITCHBOARD_IS_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_IS_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_SWITCHBOARD_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))

typedef struct _SwitchboardSwitchboardApp SwitchboardSwitchboardApp;
typedef struct _SwitchboardSwitchboardAppClass SwitchboardSwitchboardAppClass;
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SwitchboardSearchView {
	GtkScrolledWindow parent_instance;
	SwitchboardSearchViewPrivate * priv;
};

struct _SwitchboardSearchViewClass {
	GtkScrolledWindowClass parent_class;
};

struct _SwitchboardSearchViewPrivate {
	GtkSearchEntry* search_entry;
	GtkListBox* listbox;
};

struct _SwitchboardSearchViewLoadPlugsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardSearchView* self;
	SwitchboardPlugsManager* plugs_manager;
	SwitchboardPlugsManager* _tmp0_;
	GeeIterator* _plug_it;
	SwitchboardPlugsManager* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	SwitchboardPlug* plug;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	GeeTreeMap* settings;
	SwitchboardPlug* _tmp9_;
	GeeTreeMap* _tmp10_;
	GeeTreeMap* _tmp11_;
	GeeTreeMap* _tmp12_;
	gboolean _tmp13_;
	GeeTreeMap* _tmp14_;
	GeeTreeMap* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* uri;
	GeeTreeMap* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeSet* _tmp21_;
	gint _tmp22_;
	gpointer* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SwitchboardSearchViewSearchRow* search_row;
	SwitchboardPlug* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	SwitchboardPlug* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	SwitchboardSearchViewSearchRow* _tmp35_;
	GtkListBox* _tmp36_;
	SwitchboardSearchViewSearchRow* _tmp37_;
	GeeTreeMap* search_results;
	SwitchboardPlug* _tmp38_;
	GeeTreeMap* _tmp39_;
	GeeIterator* _result_it;
	GeeTreeMap* _tmp40_;
	GeeSet* _tmp41_;
	GeeSet* _tmp42_;
	GeeSet* _tmp43_;
	GeeIterator* _tmp44_;
	GeeIterator* _tmp45_;
	GeeIterator* _tmp46_;
	GeeMapEntry* _result_;
	GeeIterator* _tmp47_;
	gpointer _tmp48_;
	const gchar* title;
	GeeMapEntry* _tmp49_;
	gconstpointer _tmp50_;
	gconstpointer _tmp51_;
	gchar* view;
	GeeMapEntry* _tmp52_;
	gconstpointer _tmp53_;
	gconstpointer _tmp54_;
	gchar* _tmp55_;
	gchar* sub_uri;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	GeeIterator* _setting_it;
	GeeTreeMap* _tmp59_;
	GeeSet* _tmp60_;
	GeeSet* _tmp61_;
	GeeSet* _tmp62_;
	GeeIterator* _tmp63_;
	GeeIterator* _tmp64_;
	GeeIterator* _tmp65_;
	GeeMapEntry* setting;
	GeeIterator* _tmp66_;
	gpointer _tmp67_;
	GeeMapEntry* _tmp68_;
	gconstpointer _tmp69_;
	gconstpointer _tmp70_;
	const gchar* _tmp71_;
	GeeMapEntry* _tmp72_;
	gconstpointer _tmp73_;
	gconstpointer _tmp74_;
	gchar* _tmp75_;
	SwitchboardPlug* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	SwitchboardSearchViewSearchRow* _tmp82_;
	GtkListBox* _tmp83_;
	SwitchboardSearchViewSearchRow* _tmp84_;
};

struct _SwitchboardSearchViewSearchRow {
	GtkListBoxRow parent_instance;
	SwitchboardSearchViewSearchRowPrivate * priv;
};

struct _SwitchboardSearchViewSearchRowClass {
	GtkListBoxRowClass parent_class;
};

struct _SwitchboardSearchViewSearchRowPrivate {
	gchar* _icon_name;
	gchar* _description;
	gchar* _uri;
};

struct _Block4Data {
	int _ref_count_;
	SwitchboardSearchView* self;
	GraniteWidgetsAlertView* alert_view;
	SwitchboardSwitchboardApp* app;
};

static gint SwitchboardSearchView_private_offset;
static gpointer switchboard_search_view_parent_class = NULL;
static gint SwitchboardSearchViewSearchRow_private_offset;
static gpointer switchboard_search_view_search_row_parent_class = NULL;

VALA_EXTERN GType switchboard_search_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSearchView, g_object_unref)
VALA_EXTERN void switchboard_search_view_activate_first_item (SwitchboardSearchView* self);
static gboolean switchboard_search_view_filter_func (SwitchboardSearchView* self,
                                              GtkListBoxRow* listbox_row);
static GType switchboard_search_view_search_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSearchViewSearchRow, g_object_unref)
static const gchar* switchboard_search_view_search_row_get_description (SwitchboardSearchViewSearchRow* self);
static void switchboard_search_view_load_plugs_data_free (gpointer _data);
static void switchboard_search_view_load_plugs (SwitchboardSearchView* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void switchboard_search_view_load_plugs_finish (SwitchboardSearchView* self,
                                                GAsyncResult* _res_);
static gboolean switchboard_search_view_load_plugs_co (SwitchboardSearchViewLoadPlugsData* _data_);
static SwitchboardSearchViewSearchRow* switchboard_search_view_search_row_new (const gchar* icon_name,
                                                                        const gchar* description,
                                                                        const gchar* uri);
static SwitchboardSearchViewSearchRow* switchboard_search_view_search_row_construct (GType object_type,
                                                                              const gchar* icon_name,
                                                                              const gchar* description,
                                                                              const gchar* uri);
static void switchboard_search_view_load_plugs_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_new (void);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_construct (GType object_type);
static const gchar* switchboard_search_view_search_row_get_icon_name (SwitchboardSearchViewSearchRow* self);
static void switchboard_search_view_search_row_set_icon_name (SwitchboardSearchViewSearchRow* self,
                                                       const gchar* value);
static void switchboard_search_view_search_row_set_description (SwitchboardSearchViewSearchRow* self,
                                                         const gchar* value);
static const gchar* switchboard_search_view_search_row_get_uri (SwitchboardSearchViewSearchRow* self);
static void switchboard_search_view_search_row_set_uri (SwitchboardSearchViewSearchRow* self,
                                                 const gchar* value);
static GObject * switchboard_search_view_search_row_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void switchboard_search_view_search_row_finalize (GObject * obj);
static GType switchboard_search_view_search_row_get_type_once (void);
static void _vala_switchboard_search_view_search_row_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_switchboard_search_view_search_row_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static GObject * switchboard_search_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN GType switchboard_switchboard_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSwitchboardApp, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GtkSearchEntry* switchboard_switchboard_app_get_search_box (SwitchboardSwitchboardApp* self);
static gboolean _switchboard_search_view_filter_func_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                        gpointer self);
static void _switchboard_search_view___lambda14_ (Block4Data* _data4_);
static void __switchboard_search_view___lambda14__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                            gpointer self);
static void _switchboard_search_view___lambda15_ (Block4Data* _data4_,
                                           GtkListBoxRow* row);
VALA_EXTERN gboolean switchboard_switchboard_app_load_setting_path (SwitchboardSwitchboardApp* self,
                                                        const gchar* setting_path,
                                                        SwitchboardPlugsManager* plugsmanager);
static void __switchboard_search_view___lambda15__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self);
static void switchboard_search_view_finalize (GObject * obj);
static GType switchboard_search_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
switchboard_search_view_get_instance_private (SwitchboardSearchView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardSearchView_private_offset);
}

void
switchboard_search_view_activate_first_item (SwitchboardSearchView* self)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, 0);
	g_signal_emit_by_name (_tmp1_, "activate");
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
switchboard_search_view_filter_func (SwitchboardSearchView* self,
                                     GtkListBoxRow* listbox_row)
{
	gchar* search_text = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (listbox_row != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	search_text = _tmp3_;
	_tmp5_ = search_text;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = search_text;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = TRUE;
		_g_free0 (search_text);
		return result;
	}
	_tmp7_ = switchboard_search_view_search_row_get_description (G_TYPE_CHECK_INSTANCE_CAST (listbox_row, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow));
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_tmp11_ = search_text;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_contains (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	result = _tmp14_;
	_g_free0 (search_text);
	return result;
}

static void
switchboard_search_view_load_plugs_data_free (gpointer _data)
{
	SwitchboardSearchViewLoadPlugsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardSearchViewLoadPlugsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
switchboard_search_view_load_plugs (SwitchboardSearchView* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SwitchboardSearchViewLoadPlugsData* _data_;
	SwitchboardSearchView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardSearchViewLoadPlugsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_search_view_load_plugs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_search_view_load_plugs_co (_data_);
}

static void
switchboard_search_view_load_plugs_finish (SwitchboardSearchView* self,
                                           GAsyncResult* _res_)
{
	SwitchboardSearchViewLoadPlugsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
switchboard_search_view_load_plugs_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SwitchboardSearchViewLoadPlugsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_search_view_load_plugs_co (_data_);
}

static gboolean
switchboard_search_view_load_plugs_co (SwitchboardSearchViewLoadPlugsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plugs_manager_get_default ();
	_data_->plugs_manager = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->plugs_manager;
		_data_->_tmp2_ = switchboard_plugs_manager_get_plugs (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp3_);
		_data_->_plug_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_plug_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_plug_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->plug = (SwitchboardPlug*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->plug;
			_data_->_tmp10_ = switchboard_plug_get_supported_settings (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
			_data_->settings = _data_->_tmp12_;
			_data_->_tmp14_ = _data_->settings;
			if (_data_->_tmp14_ == NULL) {
				_data_->_tmp13_ = TRUE;
			} else {
				_data_->_tmp15_ = _data_->settings;
				_data_->_tmp16_ = gee_abstract_map_get_size ((GeeAbstractMap*) _data_->_tmp15_);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp13_ = _data_->_tmp17_ <= 0;
			}
			if (_data_->_tmp13_) {
				_g_object_unref0 (_data_->settings);
				_g_object_unref0 (_data_->plug);
				continue;
			}
			_data_->_tmp18_ = _data_->settings;
			_data_->_tmp19_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = 0;
			_data_->_tmp23_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp21_, &_data_->_tmp22_);
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp24__length1 = _data_->_tmp22_;
			_data_->_tmp25_ = _data_->_tmp24_[0];
			_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp24_ = (_vala_array_free (_data_->_tmp24_, _data_->_tmp24__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp21_);
			_data_->uri = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->plug;
			_data_->_tmp29_ = switchboard_plug_get_icon (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = _data_->plug;
			_data_->_tmp32_ = switchboard_plug_get_display_name (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = _data_->uri;
			_data_->_tmp35_ = switchboard_search_view_search_row_new (_data_->_tmp30_, _data_->_tmp33_, _data_->_tmp34_);
			g_object_ref_sink (_data_->_tmp35_);
			_data_->search_row = _data_->_tmp35_;
			_data_->_tmp36_ = _data_->self->priv->listbox;
			_data_->_tmp37_ = _data_->search_row;
			gtk_container_add ((GtkContainer*) _data_->_tmp36_, (GtkWidget*) _data_->_tmp37_);
			_data_->_tmp38_ = _data_->plug;
			_data_->_state_ = 1;
			switchboard_plug_search (_data_->_tmp38_, "", switchboard_search_view_load_plugs_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp39_ = switchboard_plug_search_finish (_data_->_tmp38_, _data_->_res_);
			_data_->search_results = _data_->_tmp39_;
			{
				_data_->_tmp40_ = _data_->search_results;
				_data_->_tmp41_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				_g_object_unref0 (_data_->_tmp43_);
				_data_->_result_it = _data_->_tmp45_;
				while (TRUE) {
					_data_->_tmp46_ = _data_->_result_it;
					if (!gee_iterator_next (_data_->_tmp46_)) {
						break;
					}
					_data_->_tmp47_ = _data_->_result_it;
					_data_->_tmp48_ = gee_iterator_get (_data_->_tmp47_);
					_data_->_result_ = (GeeMapEntry*) _data_->_tmp48_;
					_data_->_tmp49_ = _data_->_result_;
					_data_->_tmp50_ = gee_map_entry_get_key (_data_->_tmp49_);
					_data_->_tmp51_ = _data_->_tmp50_;
					_data_->title = (const gchar*) _data_->_tmp51_;
					_data_->_tmp52_ = _data_->_result_;
					_data_->_tmp53_ = gee_map_entry_get_value (_data_->_tmp52_);
					_data_->_tmp54_ = _data_->_tmp53_;
					_data_->_tmp55_ = g_strdup ((const gchar*) _data_->_tmp54_);
					_data_->view = _data_->_tmp55_;
					_data_->_tmp56_ = _data_->uri;
					_data_->_tmp57_ = g_strdup (_data_->_tmp56_);
					_data_->sub_uri = _data_->_tmp57_;
					_data_->_tmp58_ = _data_->view;
					if (g_strcmp0 (_data_->_tmp58_, "") != 0) {
						{
							_data_->_tmp59_ = _data_->settings;
							_data_->_tmp60_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _data_->_tmp59_);
							_data_->_tmp61_ = _data_->_tmp60_;
							_data_->_tmp62_ = _data_->_tmp61_;
							_data_->_tmp63_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp62_);
							_data_->_tmp64_ = _data_->_tmp63_;
							_g_object_unref0 (_data_->_tmp62_);
							_data_->_setting_it = _data_->_tmp64_;
							while (TRUE) {
								_data_->_tmp65_ = _data_->_setting_it;
								if (!gee_iterator_next (_data_->_tmp65_)) {
									break;
								}
								_data_->_tmp66_ = _data_->_setting_it;
								_data_->_tmp67_ = gee_iterator_get (_data_->_tmp66_);
								_data_->setting = (GeeMapEntry*) _data_->_tmp67_;
								_data_->_tmp68_ = _data_->setting;
								_data_->_tmp69_ = gee_map_entry_get_value (_data_->_tmp68_);
								_data_->_tmp70_ = _data_->_tmp69_;
								_data_->_tmp71_ = _data_->view;
								if (g_strcmp0 ((const gchar*) _data_->_tmp70_, _data_->_tmp71_) == 0) {
									_data_->_tmp72_ = _data_->setting;
									_data_->_tmp73_ = gee_map_entry_get_key (_data_->_tmp72_);
									_data_->_tmp74_ = _data_->_tmp73_;
									_data_->_tmp75_ = g_strdup ((const gchar*) _data_->_tmp74_);
									_g_free0 (_data_->sub_uri);
									_data_->sub_uri = _data_->_tmp75_;
									_g_object_unref0 (_data_->setting);
									break;
								}
								_g_object_unref0 (_data_->setting);
							}
							_g_object_unref0 (_data_->_setting_it);
						}
					}
					_data_->_tmp76_ = _data_->plug;
					_data_->_tmp77_ = switchboard_plug_get_icon (_data_->_tmp76_);
					_data_->_tmp78_ = _data_->_tmp77_;
					_data_->_tmp79_ = _data_->title;
					_data_->_tmp80_ = _data_->sub_uri;
					_data_->sub_uri = NULL;
					_data_->_tmp81_ = _data_->_tmp80_;
					_data_->_tmp82_ = switchboard_search_view_search_row_new (_data_->_tmp78_, _data_->_tmp79_, _data_->_tmp81_);
					g_object_ref_sink (_data_->_tmp82_);
					_g_object_unref0 (_data_->search_row);
					_data_->search_row = _data_->_tmp82_;
					_g_free0 (_data_->_tmp81_);
					_data_->_tmp83_ = _data_->self->priv->listbox;
					_data_->_tmp84_ = _data_->search_row;
					gtk_container_add ((GtkContainer*) _data_->_tmp83_, (GtkWidget*) _data_->_tmp84_);
					_g_free0 (_data_->sub_uri);
					_g_free0 (_data_->view);
					_g_object_unref0 (_data_->_result_);
				}
				_g_object_unref0 (_data_->_result_it);
			}
			_g_object_unref0 (_data_->search_results);
			_g_object_unref0 (_data_->search_row);
			_g_free0 (_data_->uri);
			_g_object_unref0 (_data_->settings);
			_g_object_unref0 (_data_->plug);
		}
		_g_object_unref0 (_data_->_plug_it);
	}
	gtk_widget_show_all ((GtkWidget*) _data_->self);
	_g_object_unref0 (_data_->plugs_manager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SwitchboardSearchView*
switchboard_search_view_construct (GType object_type)
{
	SwitchboardSearchView * self = NULL;
	self = (SwitchboardSearchView*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardSearchView*
switchboard_search_view_new (void)
{
	return switchboard_search_view_construct (SWITCHBOARD_TYPE_SEARCH_VIEW);
}

static inline gpointer
switchboard_search_view_search_row_get_instance_private (SwitchboardSearchViewSearchRow* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardSearchViewSearchRow_private_offset);
}

static SwitchboardSearchViewSearchRow*
switchboard_search_view_search_row_construct (GType object_type,
                                              const gchar* icon_name,
                                              const gchar* description,
                                              const gchar* uri)
{
	SwitchboardSearchViewSearchRow * self = NULL;
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (SwitchboardSearchViewSearchRow*) g_object_new (object_type, "description", description, "icon-name", icon_name, "uri", uri, NULL);
	return self;
}

static SwitchboardSearchViewSearchRow*
switchboard_search_view_search_row_new (const gchar* icon_name,
                                        const gchar* description,
                                        const gchar* uri)
{
	return switchboard_search_view_search_row_construct (SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, icon_name, description, uri);
}

static const gchar*
switchboard_search_view_search_row_get_icon_name (SwitchboardSearchViewSearchRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
switchboard_search_view_search_row_set_icon_name (SwitchboardSearchViewSearchRow* self,
                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_search_view_search_row_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
switchboard_search_view_search_row_get_description (SwitchboardSearchViewSearchRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
switchboard_search_view_search_row_set_description (SwitchboardSearchViewSearchRow* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_search_view_search_row_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY]);
	}
}

static const gchar*
switchboard_search_view_search_row_get_uri (SwitchboardSearchViewSearchRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
switchboard_search_view_search_row_set_uri (SwitchboardSearchViewSearchRow* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_search_view_search_row_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY]);
	}
}

static GObject *
switchboard_search_view_search_row_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardSearchViewSearchRow * self;
	GtkImage* image = NULL;
	const gchar* _tmp0_;
	GtkImage* _tmp1_;
	GtkLabel* label = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkImage* _tmp13_;
	GtkGrid* _tmp14_;
	GtkLabel* _tmp15_;
	GtkGrid* _tmp16_;
	parent_class = G_OBJECT_CLASS (switchboard_search_view_search_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = self->priv->_description;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	_tmp4_ = label;
	gtk_label_set_ellipsize (_tmp4_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp5_ = label;
	gtk_label_set_max_width_chars (_tmp5_, 80);
	_tmp6_ = label;
	gtk_label_set_width_chars (_tmp6_, 80);
	_tmp7_ = label;
	gtk_label_set_xalign (_tmp7_, (gfloat) 0);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	grid = _tmp8_;
	_tmp9_ = grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = grid;
	gtk_grid_set_column_spacing (_tmp10_, 12);
	_tmp11_ = grid;
	g_object_set ((GtkWidget*) _tmp11_, "margin", 6, NULL);
	_tmp12_ = grid;
	_tmp13_ = image;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = grid;
	_tmp15_ = label;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_g_object_unref0 (grid);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	return obj;
}

static void
switchboard_search_view_search_row_class_init (SwitchboardSearchViewSearchRowClass * klass,
                                               gpointer klass_data)
{
	switchboard_search_view_search_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardSearchViewSearchRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_search_view_search_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_search_view_search_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_search_view_search_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_search_view_search_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY, switchboard_search_view_search_row_properties[SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
switchboard_search_view_search_row_instance_init (SwitchboardSearchViewSearchRow * self,
                                                  gpointer klass)
{
	self->priv = switchboard_search_view_search_row_get_instance_private (self);
}

static void
switchboard_search_view_search_row_finalize (GObject * obj)
{
	SwitchboardSearchViewSearchRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_uri);
	G_OBJECT_CLASS (switchboard_search_view_search_row_parent_class)->finalize (obj);
}

static GType
switchboard_search_view_search_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardSearchViewSearchRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_search_view_search_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardSearchViewSearchRow), 0, (GInstanceInitFunc) switchboard_search_view_search_row_instance_init, NULL };
	GType switchboard_search_view_search_row_type_id;
	switchboard_search_view_search_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SwitchboardSearchViewSearchRow", &g_define_type_info, 0);
	SwitchboardSearchViewSearchRow_private_offset = g_type_add_instance_private (switchboard_search_view_search_row_type_id, sizeof (SwitchboardSearchViewSearchRowPrivate));
	return switchboard_search_view_search_row_type_id;
}

static GType
switchboard_search_view_search_row_get_type (void)
{
	static volatile gsize switchboard_search_view_search_row_type_id__once = 0;
	if (g_once_init_enter (&switchboard_search_view_search_row_type_id__once)) {
		GType switchboard_search_view_search_row_type_id;
		switchboard_search_view_search_row_type_id = switchboard_search_view_search_row_get_type_once ();
		g_once_init_leave (&switchboard_search_view_search_row_type_id__once, switchboard_search_view_search_row_type_id);
	}
	return switchboard_search_view_search_row_type_id__once;
}

static void
_vala_switchboard_search_view_search_row_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	SwitchboardSearchViewSearchRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow);
	switch (property_id) {
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY:
		g_value_set_string (value, switchboard_search_view_search_row_get_icon_name (self));
		break;
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY:
		g_value_set_string (value, switchboard_search_view_search_row_get_description (self));
		break;
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY:
		g_value_set_string (value, switchboard_search_view_search_row_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_search_view_search_row_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	SwitchboardSearchViewSearchRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow);
	switch (property_id) {
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_ICON_NAME_PROPERTY:
		switchboard_search_view_search_row_set_icon_name (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_DESCRIPTION_PROPERTY:
		switchboard_search_view_search_row_set_description (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SEARCH_VIEW_SEARCH_ROW_URI_PROPERTY:
		switchboard_search_view_search_row_set_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SwitchboardSearchView* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->alert_view);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
_switchboard_search_view_filter_func_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                               gpointer self)
{
	gboolean result;
	result = switchboard_search_view_filter_func ((SwitchboardSearchView*) self, row);
	return result;
}

static void
_switchboard_search_view___lambda14_ (Block4Data* _data4_)
{
	SwitchboardSearchView* self;
	GraniteWidgetsAlertView* _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	self = _data4_->self;
	_tmp0_ = _data4_->alert_view;
	_tmp1_ = self->priv->search_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp3_);
	_tmp5_ = _tmp4_;
	granite_widgets_alert_view_set_title (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->listbox;
	gtk_list_box_invalidate_filter (_tmp6_);
	_tmp7_ = self->priv->listbox;
	gtk_list_box_select_row (_tmp7_, NULL);
}

static void
__switchboard_search_view___lambda14__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                       gpointer self)
{
	_switchboard_search_view___lambda14_ (self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_switchboard_search_view___lambda15_ (Block4Data* _data4_,
                                      GtkListBoxRow* row)
{
	SwitchboardSearchView* self;
	SwitchboardSwitchboardApp* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SwitchboardPlugsManager* _tmp5_;
	SwitchboardPlugsManager* _tmp6_;
	GtkSearchEntry* _tmp7_;
	self = _data4_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _data4_->app;
	_tmp1_ = switchboard_search_view_search_row_get_uri (G_TYPE_CHECK_INSTANCE_CAST (row, SWITCHBOARD_SEARCH_VIEW_TYPE_SEARCH_ROW, SwitchboardSearchViewSearchRow));
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "settings://", "");
	_tmp4_ = _tmp3_;
	_tmp5_ = switchboard_plugs_manager_get_default ();
	_tmp6_ = _tmp5_;
	switchboard_switchboard_app_load_setting_path (_tmp0_, _tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = self->priv->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp7_, "");
}

static void
__switchboard_search_view___lambda15__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self)
{
	_switchboard_search_view___lambda15_ (self, row);
}

static GObject *
switchboard_search_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardSearchView * self;
	Block4Data* _data4_;
	GraniteWidgetsAlertView* _tmp0_;
	GraniteWidgetsAlertView* _tmp1_;
	GtkStyleContext* _tmp2_;
	GraniteWidgetsAlertView* _tmp3_;
	GApplication* _tmp4_;
	SwitchboardSwitchboardApp* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GraniteWidgetsAlertView* _tmp13_;
	GtkListBox* _tmp14_;
	GtkSearchEntry* _tmp15_;
	GtkListBox* _tmp16_;
	parent_class = G_OBJECT_CLASS (switchboard_search_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchView);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = granite_widgets_alert_view_new ("", _ ("Try changing search terms."), "edit-find-symbolic");
	g_object_ref_sink (_tmp0_);
	_data4_->alert_view = _tmp0_;
	_tmp1_ = _data4_->alert_view;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp3_ = _data4_->alert_view;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = g_application_get_default ();
	_data4_->app = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	_tmp5_ = _data4_->app;
	_tmp6_ = switchboard_switchboard_app_get_search_box (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp8_;
	_tmp9_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp9_;
	_tmp10_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp10_, GTK_SELECTION_BROWSE);
	_tmp11_ = self->priv->listbox;
	gtk_list_box_set_filter_func (_tmp11_, _switchboard_search_view_filter_func_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->listbox;
	_tmp13_ = _data4_->alert_view;
	gtk_list_box_set_placeholder (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	switchboard_search_view_load_plugs (self, NULL, NULL);
	_tmp15_ = self->priv->search_entry;
	g_signal_connect_data (_tmp15_, "search-changed", (GCallback) __switchboard_search_view___lambda14__gtk_search_entry_search_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp16_ = self->priv->listbox;
	g_signal_connect_data (_tmp16_, "row-activated", (GCallback) __switchboard_search_view___lambda15__gtk_list_box_row_activated, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
switchboard_search_view_class_init (SwitchboardSearchViewClass * klass,
                                    gpointer klass_data)
{
	switchboard_search_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardSearchView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = switchboard_search_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_search_view_finalize;
}

static void
switchboard_search_view_instance_init (SwitchboardSearchView * self,
                                       gpointer klass)
{
	self->priv = switchboard_search_view_get_instance_private (self);
}

static void
switchboard_search_view_finalize (GObject * obj)
{
	SwitchboardSearchView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchView);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->listbox);
	G_OBJECT_CLASS (switchboard_search_view_parent_class)->finalize (obj);
}

static GType
switchboard_search_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardSearchViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_search_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardSearchView), 0, (GInstanceInitFunc) switchboard_search_view_instance_init, NULL };
	GType switchboard_search_view_type_id;
	switchboard_search_view_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "SwitchboardSearchView", &g_define_type_info, 0);
	SwitchboardSearchView_private_offset = g_type_add_instance_private (switchboard_search_view_type_id, sizeof (SwitchboardSearchViewPrivate));
	return switchboard_search_view_type_id;
}

GType
switchboard_search_view_get_type (void)
{
	static volatile gsize switchboard_search_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_search_view_type_id__once)) {
		GType switchboard_search_view_type_id;
		switchboard_search_view_type_id = switchboard_search_view_get_type_once ();
		g_once_init_leave (&switchboard_search_view_type_id__once, switchboard_search_view_type_id);
	}
	return switchboard_search_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

