/* CategoryView.c generated by valac 0.56.17, the Vala compiler
 * generated from CategoryView.vala, do not modify */

/*
* Copyright (c) 2011-2017 elementary LLC (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
* Authored by: Avi Romanoff <aviromanoff@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <gio/gio.h>
#include "switchboard.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SWITCHBOARD_TYPE_CATEGORY_VIEW (switchboard_category_view_get_type ())
#define SWITCHBOARD_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView))
#define SWITCHBOARD_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))
#define SWITCHBOARD_IS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_IS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))

typedef struct _SwitchboardCategoryView SwitchboardCategoryView;
typedef struct _SwitchboardCategoryViewClass SwitchboardCategoryViewClass;
typedef struct _SwitchboardCategoryViewPrivate SwitchboardCategoryViewPrivate;

#define SWITCHBOARD_TYPE_PLUGS_SEARCH (switchboard_plugs_search_get_type ())
#define SWITCHBOARD_PLUGS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearch))
#define SWITCHBOARD_PLUGS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearchClass))
#define SWITCHBOARD_IS_PLUGS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH))
#define SWITCHBOARD_IS_PLUGS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_PLUGS_SEARCH))
#define SWITCHBOARD_PLUGS_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearchClass))

typedef struct _SwitchboardPlugsSearch SwitchboardPlugsSearch;
typedef struct _SwitchboardPlugsSearchClass SwitchboardPlugsSearchClass;

#define SWITCHBOARD_TYPE_SEARCH_ENTRY (switchboard_search_entry_get_type ())
typedef struct _SwitchboardSearchEntry SwitchboardSearchEntry;

#define SWITCHBOARD_TYPE_CATEGORY (switchboard_category_get_type ())
#define SWITCHBOARD_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategory))
#define SWITCHBOARD_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategoryClass))
#define SWITCHBOARD_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY))
#define SWITCHBOARD_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY))
#define SWITCHBOARD_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategoryClass))

typedef struct _SwitchboardCategory SwitchboardCategory;
typedef struct _SwitchboardCategoryClass SwitchboardCategoryClass;
enum  {
	SWITCHBOARD_CATEGORY_VIEW_0_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_NUM_PROPERTIES];
#define _switchboard_plugs_search_unref0(var) ((var == NULL) ? NULL : (var = (switchboard_plugs_search_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
typedef struct _SwitchboardCategoryViewLoadDefaultPlugsData SwitchboardCategoryViewLoadDefaultPlugsData;

#define SWITCHBOARD_TYPE_CATEGORY_ICON (switchboard_category_icon_get_type ())
#define SWITCHBOARD_CATEGORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIcon))
#define SWITCHBOARD_CATEGORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIconClass))
#define SWITCHBOARD_IS_CATEGORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON))
#define SWITCHBOARD_IS_CATEGORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_ICON))
#define SWITCHBOARD_CATEGORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIconClass))

typedef struct _SwitchboardCategoryIcon SwitchboardCategoryIcon;
typedef struct _SwitchboardCategoryIconClass SwitchboardCategoryIconClass;

#define SWITCHBOARD_TYPE_SWITCHBOARD_APP (switchboard_switchboard_app_get_type ())
#define SWITCHBOARD_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp))
#define SWITCHBOARD_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))
#define SWITCHBOARD_IS_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_IS_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_SWITCHBOARD_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))

typedef struct _SwitchboardSwitchboardApp SwitchboardSwitchboardApp;
typedef struct _SwitchboardSwitchboardAppClass SwitchboardSwitchboardAppClass;
enum  {
	SWITCHBOARD_CATEGORY_VIEW_PLUG_SELECTED_SIGNAL,
	SWITCHBOARD_CATEGORY_VIEW_NUM_SIGNALS
};
static guint switchboard_category_view_signals[SWITCHBOARD_CATEGORY_VIEW_NUM_SIGNALS] = {0};

struct _SwitchboardCategoryView {
	GtkStack parent_instance;
	SwitchboardCategoryViewPrivate * priv;
};

struct _SwitchboardCategoryViewClass {
	GtkStackClass parent_class;
};

struct _SwitchboardSearchEntry {
	gchar* plug_name;
	gchar* ui_elements;
	gchar* open_window;
};

struct _SwitchboardCategoryViewPrivate {
	SwitchboardPlugsSearch* _plug_search;
	GeeArrayList* _plug_search_result;
	SwitchboardCategory* _personal_category;
	SwitchboardCategory* _hardware_category;
	SwitchboardCategory* _network_category;
	SwitchboardCategory* _system_category;
	gchar* _plug_to_open;
	GraniteWidgetsAlertView* alert_view;
};

struct _Block3Data {
	int _ref_count_;
	SwitchboardCategoryView* self;
	SwitchboardPlugsManager* plugsmanager;
	gpointer _async_data_;
};

struct _SwitchboardCategoryViewLoadDefaultPlugsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardCategoryView* self;
	Block3Data* _data3_;
	SwitchboardPlugsManager* _tmp0_;
};

static gint SwitchboardCategoryView_private_offset;
static gpointer switchboard_category_view_parent_class = NULL;

VALA_EXTERN GType switchboard_category_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryView, g_object_unref)
VALA_EXTERN gpointer switchboard_plugs_search_ref (gpointer instance);
VALA_EXTERN void switchboard_plugs_search_unref (gpointer instance);
VALA_EXTERN GParamSpec* switchboard_param_spec_plugs_search (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void switchboard_value_set_plugs_search (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void switchboard_value_take_plugs_search (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer switchboard_value_get_plugs_search (const GValue* value);
VALA_EXTERN GType switchboard_plugs_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardPlugsSearch, switchboard_plugs_search_unref)
VALA_EXTERN GType switchboard_search_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SwitchboardSearchEntry* switchboard_search_entry_dup (const SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_free (SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_copy (const SwitchboardSearchEntry* self,
                                    SwitchboardSearchEntry* dest);
VALA_EXTERN void switchboard_search_entry_destroy (SwitchboardSearchEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwitchboardSearchEntry, switchboard_search_entry_destroy)
VALA_EXTERN GType switchboard_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategory, g_object_unref)
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_new (const gchar* plug);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_construct (GType object_type,
                                                              const gchar* plug);
VALA_EXTERN void switchboard_category_view_show_alert (SwitchboardCategoryView* self,
                                           const gchar* primary_text,
                                           const gchar* secondary_text,
                                           const gchar* icon_name);
static void switchboard_category_view_load_default_plugs_data_free (gpointer _data);
VALA_EXTERN void switchboard_category_view_load_default_plugs (SwitchboardCategoryView* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void switchboard_category_view_load_default_plugs_finish (SwitchboardCategoryView* self,
                                                          GAsyncResult* _res_);
static gboolean switchboard_category_view_load_default_plugs_co (SwitchboardCategoryViewLoadDefaultPlugsData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda10_ (SwitchboardCategoryView* self,
                  SwitchboardPlug* plug);
VALA_EXTERN void switchboard_category_view_add_plug (SwitchboardCategoryView* self,
                                         SwitchboardPlug* plug);
static void ___lambda10__switchboard_plugs_manager_plug_added (SwitchboardPlugsManager* _sender,
                                                        SwitchboardPlug* plug,
                                                        gpointer self);
static gboolean __lambda11_ (Block3Data* _data3_);
static gboolean ___lambda11__gsource_func (gpointer self);
VALA_EXTERN GType switchboard_category_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryIcon, g_object_unref)
VALA_EXTERN SwitchboardCategoryIcon* switchboard_category_icon_new (SwitchboardPlug* plug);
VALA_EXTERN SwitchboardCategoryIcon* switchboard_category_icon_construct (GType object_type,
                                                              SwitchboardPlug* plug);
VALA_EXTERN SwitchboardCategory* switchboard_category_view_get_personal_category (SwitchboardCategoryView* self);
VALA_EXTERN void switchboard_category_add (SwitchboardCategory* self,
                               GtkWidget* widget);
VALA_EXTERN SwitchboardCategory* switchboard_category_view_get_hardware_category (SwitchboardCategoryView* self);
VALA_EXTERN SwitchboardCategory* switchboard_category_view_get_network_category (SwitchboardCategoryView* self);
VALA_EXTERN SwitchboardCategory* switchboard_category_view_get_system_category (SwitchboardCategoryView* self);
VALA_EXTERN gboolean switchboard_category_has_child (SwitchboardCategory* self);
VALA_EXTERN const gchar* switchboard_category_view_get_plug_to_open (SwitchboardCategoryView* self);
VALA_EXTERN GType switchboard_switchboard_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSwitchboardApp, g_object_unref)
VALA_EXTERN void switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                            SwitchboardPlug* plug);
VALA_EXTERN void switchboard_category_view_set_plug_to_open (SwitchboardCategoryView* self,
                                                 const gchar* value);
VALA_EXTERN gchar* switchboard_category_view_get_category_name (SwitchboardPlugCategory category);
VALA_EXTERN SwitchboardPlugsSearch* switchboard_category_view_get_plug_search (SwitchboardCategoryView* self);
static void switchboard_category_view_set_plug_search (SwitchboardCategoryView* self,
                                                SwitchboardPlugsSearch* value);
VALA_EXTERN GeeArrayList* switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self);
static void switchboard_category_view_set_plug_search_result (SwitchboardCategoryView* self,
                                                       GeeArrayList* value);
static void switchboard_category_view_set_personal_category (SwitchboardCategoryView* self,
                                                      SwitchboardCategory* value);
static void switchboard_category_view_set_hardware_category (SwitchboardCategoryView* self,
                                                      SwitchboardCategory* value);
static void switchboard_category_view_set_network_category (SwitchboardCategoryView* self,
                                                     SwitchboardCategory* value);
static void switchboard_category_view_set_system_category (SwitchboardCategoryView* self,
                                                    SwitchboardCategory* value);
static GObject * switchboard_category_view_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
VALA_EXTERN SwitchboardCategory* switchboard_category_new (SwitchboardPlugCategory category);
VALA_EXTERN SwitchboardCategory* switchboard_category_construct (GType object_type,
                                                     SwitchboardPlugCategory category);
VALA_EXTERN SwitchboardPlugsSearch* switchboard_plugs_search_new (void);
VALA_EXTERN SwitchboardPlugsSearch* switchboard_plugs_search_construct (GType object_type);
static void switchboard_category_view_finalize (GObject * obj);
static GType switchboard_category_view_get_type_once (void);
static void _vala_switchboard_category_view_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_switchboard_category_view_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
switchboard_category_view_get_instance_private (SwitchboardCategoryView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardCategoryView_private_offset);
}

SwitchboardCategoryView*
switchboard_category_view_construct (GType object_type,
                                     const gchar* plug)
{
	SwitchboardCategoryView * self = NULL;
	self = (SwitchboardCategoryView*) g_object_new (object_type, "plug-to-open", plug, NULL);
	return self;
}

SwitchboardCategoryView*
switchboard_category_view_new (const gchar* plug)
{
	return switchboard_category_view_construct (SWITCHBOARD_TYPE_CATEGORY_VIEW, plug);
}

void
switchboard_category_view_show_alert (SwitchboardCategoryView* self,
                                      const gchar* primary_text,
                                      const gchar* secondary_text,
                                      const gchar* icon_name)
{
	GraniteWidgetsAlertView* _tmp0_;
	GraniteWidgetsAlertView* _tmp1_;
	GraniteWidgetsAlertView* _tmp2_;
	GraniteWidgetsAlertView* _tmp3_;
	GraniteWidgetsAlertView* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_text != NULL);
	g_return_if_fail (secondary_text != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->alert_view;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->alert_view;
	granite_widgets_alert_view_set_title (_tmp1_, primary_text);
	_tmp2_ = self->priv->alert_view;
	granite_widgets_alert_view_set_description (_tmp2_, secondary_text);
	_tmp3_ = self->priv->alert_view;
	granite_widgets_alert_view_set_icon_name (_tmp3_, icon_name);
	_tmp4_ = self->priv->alert_view;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp4_);
}

static void
switchboard_category_view_load_default_plugs_data_free (gpointer _data)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardCategoryViewLoadDefaultPlugsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_category_view_load_default_plugs (SwitchboardCategoryView* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	SwitchboardCategoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardCategoryViewLoadDefaultPlugsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_category_view_load_default_plugs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_category_view_load_default_plugs_co (_data_);
}

void
switchboard_category_view_load_default_plugs_finish (SwitchboardCategoryView* self,
                                                     GAsyncResult* _res_)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SwitchboardCategoryView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->plugsmanager);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda10_ (SwitchboardCategoryView* self,
             SwitchboardPlug* plug)
{
	g_return_if_fail (plug != NULL);
	switchboard_category_view_add_plug (self, plug);
}

static void
___lambda10__switchboard_plugs_manager_plug_added (SwitchboardPlugsManager* _sender,
                                                   SwitchboardPlug* plug,
                                                   gpointer self)
{
	__lambda10_ ((SwitchboardCategoryView*) self, plug);
}

static gboolean
__lambda11_ (Block3Data* _data3_)
{
	SwitchboardCategoryView* self;
	gboolean result;
	self = _data3_->self;
	{
		GeeIterator* _plug_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = switchboard_plugs_manager_get_plugs (_data3_->plugsmanager);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_plug_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			SwitchboardPlug* plug = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			SwitchboardPlug* _tmp7_;
			_tmp4_ = _plug_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _plug_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			plug = (SwitchboardPlug*) _tmp6_;
			_tmp7_ = plug;
			switchboard_category_view_add_plug (self, _tmp7_);
			_g_object_unref0 (plug);
		}
		_g_object_unref0 (_plug_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
	return result;
}

static gboolean
switchboard_category_view_load_default_plugs_co (SwitchboardCategoryViewLoadDefaultPlugsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = switchboard_plugs_manager_get_default ();
	_data_->_data3_->plugsmanager = _data_->_tmp0_;
	g_signal_connect_object (_data_->_data3_->plugsmanager, "plug-added", (GCallback) ___lambda10__switchboard_plugs_manager_plug_added, _data_->self, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
switchboard_category_view_add_plug (SwitchboardCategoryView* self,
                                    SwitchboardPlug* plug)
{
	SwitchboardCategoryIcon* icon = NULL;
	SwitchboardCategoryIcon* _tmp0_;
	SwitchboardPlugCategory _tmp1_;
	SwitchboardPlugCategory _tmp2_;
	gboolean any_found = FALSE;
	SwitchboardCategory* _tmp11_;
	SwitchboardCategory* _tmp12_;
	SwitchboardCategory* _tmp13_;
	SwitchboardCategory* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plug != NULL);
	_tmp0_ = switchboard_category_icon_new (plug);
	g_object_ref_sink (_tmp0_);
	icon = _tmp0_;
	_tmp1_ = switchboard_plug_get_category (plug);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case SWITCHBOARD_PLUG_CATEGORY_PERSONAL:
		{
			SwitchboardCategory* _tmp3_;
			SwitchboardCategoryIcon* _tmp4_;
			_tmp3_ = self->priv->_personal_category;
			_tmp4_ = icon;
			switchboard_category_add (_tmp3_, (GtkWidget*) _tmp4_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_HARDWARE:
		{
			SwitchboardCategory* _tmp5_;
			SwitchboardCategoryIcon* _tmp6_;
			_tmp5_ = self->priv->_hardware_category;
			_tmp6_ = icon;
			switchboard_category_add (_tmp5_, (GtkWidget*) _tmp6_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_NETWORK:
		{
			SwitchboardCategory* _tmp7_;
			SwitchboardCategoryIcon* _tmp8_;
			_tmp7_ = self->priv->_network_category;
			_tmp8_ = icon;
			switchboard_category_add (_tmp7_, (GtkWidget*) _tmp8_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_SYSTEM:
		{
			SwitchboardCategory* _tmp9_;
			SwitchboardCategoryIcon* _tmp10_;
			_tmp9_ = self->priv->_system_category;
			_tmp10_ = icon;
			switchboard_category_add (_tmp9_, (GtkWidget*) _tmp10_);
			break;
		}
		default:
		{
			_g_object_unref0 (icon);
			return;
		}
	}
	any_found = FALSE;
	_tmp11_ = self->priv->_personal_category;
	if (switchboard_category_has_child (_tmp11_)) {
		any_found = TRUE;
	}
	_tmp12_ = self->priv->_hardware_category;
	if (switchboard_category_has_child (_tmp12_)) {
		any_found = TRUE;
	}
	_tmp13_ = self->priv->_network_category;
	if (switchboard_category_has_child (_tmp13_)) {
		any_found = TRUE;
	}
	_tmp14_ = self->priv->_system_category;
	if (switchboard_category_has_child (_tmp14_)) {
		any_found = TRUE;
	}
	if (any_found) {
		gtk_stack_set_visible_child_name ((GtkStack*) self, "category-grid");
	}
	_tmp16_ = self->priv->_plug_to_open;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = self->priv->_plug_to_open;
		_tmp18_ = switchboard_plug_get_code_name (plug);
		_tmp19_ = _tmp18_;
		_tmp15_ = g_str_has_suffix (_tmp17_, _tmp19_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		SwitchboardSwitchboardApp* app = NULL;
		GApplication* _tmp20_;
		SwitchboardSwitchboardApp* _tmp21_;
		_tmp20_ = g_application_get_default ();
		app = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
		_tmp21_ = app;
		switchboard_switchboard_app_load_plug (_tmp21_, plug);
		switchboard_category_view_set_plug_to_open (self, NULL);
	}
	_g_object_unref0 (icon);
}

gchar*
switchboard_category_view_get_category_name (SwitchboardPlugCategory category)
{
	gchar* result;
	switch (category) {
		case SWITCHBOARD_PLUG_CATEGORY_PERSONAL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Personal"));
			result = _tmp0_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_HARDWARE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Hardware"));
			result = _tmp1_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_NETWORK:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Network & Wireless"));
			result = _tmp2_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_SYSTEM:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Administration"));
			result = _tmp3_;
			return result;
		}
		default:
		break;
	}
	result = NULL;
	return result;
}

SwitchboardPlugsSearch*
switchboard_category_view_get_plug_search (SwitchboardCategoryView* self)
{
	SwitchboardPlugsSearch* result;
	SwitchboardPlugsSearch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug_search;
	result = _tmp0_;
	return result;
}

static gpointer
_switchboard_plugs_search_ref0 (gpointer self)
{
	return self ? switchboard_plugs_search_ref (self) : NULL;
}

static void
switchboard_category_view_set_plug_search (SwitchboardCategoryView* self,
                                           SwitchboardPlugsSearch* value)
{
	SwitchboardPlugsSearch* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_plug_search (self);
	if (old_value != value) {
		SwitchboardPlugsSearch* _tmp0_;
		_tmp0_ = _switchboard_plugs_search_ref0 (value);
		_switchboard_plugs_search_unref0 (self->priv->_plug_search);
		self->priv->_plug_search = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY]);
	}
}

GeeArrayList*
switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug_search_result;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_plug_search_result (SwitchboardCategoryView* self,
                                                  GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_plug_search_result (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plug_search_result);
		self->priv->_plug_search_result = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY]);
	}
}

SwitchboardCategory*
switchboard_category_view_get_personal_category (SwitchboardCategoryView* self)
{
	SwitchboardCategory* result;
	SwitchboardCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_personal_category;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_personal_category (SwitchboardCategoryView* self,
                                                 SwitchboardCategory* value)
{
	SwitchboardCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_personal_category (self);
	if (old_value != value) {
		SwitchboardCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_personal_category);
		self->priv->_personal_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY]);
	}
}

SwitchboardCategory*
switchboard_category_view_get_hardware_category (SwitchboardCategoryView* self)
{
	SwitchboardCategory* result;
	SwitchboardCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hardware_category;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_hardware_category (SwitchboardCategoryView* self,
                                                 SwitchboardCategory* value)
{
	SwitchboardCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_hardware_category (self);
	if (old_value != value) {
		SwitchboardCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hardware_category);
		self->priv->_hardware_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY]);
	}
}

SwitchboardCategory*
switchboard_category_view_get_network_category (SwitchboardCategoryView* self)
{
	SwitchboardCategory* result;
	SwitchboardCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_network_category;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_network_category (SwitchboardCategoryView* self,
                                                SwitchboardCategory* value)
{
	SwitchboardCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_network_category (self);
	if (old_value != value) {
		SwitchboardCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_network_category);
		self->priv->_network_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY]);
	}
}

SwitchboardCategory*
switchboard_category_view_get_system_category (SwitchboardCategoryView* self)
{
	SwitchboardCategory* result;
	SwitchboardCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_category;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_system_category (SwitchboardCategoryView* self,
                                               SwitchboardCategory* value)
{
	SwitchboardCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_system_category (self);
	if (old_value != value) {
		SwitchboardCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_system_category);
		self->priv->_system_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY]);
	}
}

const gchar*
switchboard_category_view_get_plug_to_open (SwitchboardCategoryView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug_to_open;
	result = _tmp0_;
	return result;
}

void
switchboard_category_view_set_plug_to_open (SwitchboardCategoryView* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_plug_to_open (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_plug_to_open);
		self->priv->_plug_to_open = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY]);
	}
}

static GObject *
switchboard_category_view_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardCategoryView * self;
	GraniteWidgetsAlertView* _tmp0_;
	GraniteWidgetsAlertView* _tmp1_;
	GtkStyleContext* _tmp2_;
	SwitchboardCategory* _tmp3_;
	SwitchboardCategory* _tmp4_;
	SwitchboardCategory* _tmp5_;
	SwitchboardCategory* _tmp6_;
	SwitchboardCategory* _tmp7_;
	SwitchboardCategory* _tmp8_;
	SwitchboardCategory* _tmp9_;
	SwitchboardCategory* _tmp10_;
	SwitchboardPlugsSearch* _tmp11_;
	SwitchboardPlugsSearch* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GtkGrid* category_grid = NULL;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkGrid* _tmp18_;
	SwitchboardCategory* _tmp19_;
	GtkGrid* _tmp20_;
	SwitchboardCategory* _tmp21_;
	GtkGrid* _tmp22_;
	SwitchboardCategory* _tmp23_;
	GtkGrid* _tmp24_;
	SwitchboardCategory* _tmp25_;
	GtkScrolledWindow* category_scrolled = NULL;
	GtkScrolledWindow* _tmp26_ = NULL;
	GtkScrolledWindow* _tmp27_;
	GtkGrid* _tmp28_;
	GraniteWidgetsAlertView* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	parent_class = G_OBJECT_CLASS (switchboard_category_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	_tmp0_ = granite_widgets_alert_view_new ("", "", "");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp0_;
	_tmp1_ = self->priv->alert_view;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp3_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_PERSONAL);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	switchboard_category_view_set_personal_category (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_HARDWARE);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	switchboard_category_view_set_hardware_category (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_NETWORK);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	switchboard_category_view_set_network_category (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_SYSTEM);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	switchboard_category_view_set_system_category (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = switchboard_plugs_search_new ();
	_tmp12_ = _tmp11_;
	switchboard_category_view_set_plug_search (self, _tmp12_);
	_switchboard_plugs_search_unref0 (_tmp12_);
	_tmp13_ = gee_array_list_new (SWITCHBOARD_TYPE_SEARCH_ENTRY, (GBoxedCopyFunc) switchboard_search_entry_dup, (GDestroyNotify) switchboard_search_entry_free, NULL, NULL, NULL);
	_tmp14_ = _tmp13_;
	switchboard_category_view_set_plug_search_result (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp15_);
	category_grid = _tmp15_;
	_tmp16_ = category_grid;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 12);
	_tmp17_ = category_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp17_, GTK_ORIENTATION_VERTICAL);
	_tmp18_ = category_grid;
	_tmp19_ = self->priv->_personal_category;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = category_grid;
	_tmp21_ = self->priv->_hardware_category;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = category_grid;
	_tmp23_ = self->priv->_network_category;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = category_grid;
	_tmp25_ = self->priv->_system_category;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp26_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp26_);
	category_scrolled = _tmp26_;
	_tmp27_ = category_scrolled;
	_tmp28_ = category_grid;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->alert_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = category_scrolled;
	gtk_stack_add_named ((GtkStack*) self, (GtkWidget*) _tmp30_, "category-grid");
	_g_object_unref0 (category_scrolled);
	_g_object_unref0 (category_grid);
	return obj;
}

static void
switchboard_category_view_class_init (SwitchboardCategoryViewClass * klass,
                                      gpointer klass_data)
{
	switchboard_category_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardCategoryView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_category_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_category_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_category_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_category_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY] = switchboard_param_spec_plugs_search ("plug-search", "plug-search", "plug-search", SWITCHBOARD_TYPE_PLUGS_SEARCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY] = g_param_spec_object ("plug-search-result", "plug-search-result", "plug-search-result", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY] = g_param_spec_object ("personal-category", "personal-category", "personal-category", SWITCHBOARD_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY] = g_param_spec_object ("hardware-category", "hardware-category", "hardware-category", SWITCHBOARD_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY] = g_param_spec_object ("network-category", "network-category", "network-category", SWITCHBOARD_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY] = g_param_spec_object ("system-category", "system-category", "system-category", SWITCHBOARD_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY] = g_param_spec_string ("plug-to-open", "plug-to-open", "plug-to-open", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	switchboard_category_view_signals[SWITCHBOARD_CATEGORY_VIEW_PLUG_SELECTED_SIGNAL] = g_signal_new ("plug-selected", SWITCHBOARD_TYPE_CATEGORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SWITCHBOARD_TYPE_PLUG);
}

static void
switchboard_category_view_instance_init (SwitchboardCategoryView * self,
                                         gpointer klass)
{
	self->priv = switchboard_category_view_get_instance_private (self);
	self->priv->_plug_to_open = NULL;
}

static void
switchboard_category_view_finalize (GObject * obj)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	_switchboard_plugs_search_unref0 (self->priv->_plug_search);
	_g_object_unref0 (self->priv->_plug_search_result);
	_g_object_unref0 (self->priv->_personal_category);
	_g_object_unref0 (self->priv->_hardware_category);
	_g_object_unref0 (self->priv->_network_category);
	_g_object_unref0 (self->priv->_system_category);
	_g_free0 (self->priv->_plug_to_open);
	_g_object_unref0 (self->priv->alert_view);
	G_OBJECT_CLASS (switchboard_category_view_parent_class)->finalize (obj);
}

static GType
switchboard_category_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardCategoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_category_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardCategoryView), 0, (GInstanceInitFunc) switchboard_category_view_instance_init, NULL };
	GType switchboard_category_view_type_id;
	switchboard_category_view_type_id = g_type_register_static (gtk_stack_get_type (), "SwitchboardCategoryView", &g_define_type_info, 0);
	SwitchboardCategoryView_private_offset = g_type_add_instance_private (switchboard_category_view_type_id, sizeof (SwitchboardCategoryViewPrivate));
	return switchboard_category_view_type_id;
}

GType
switchboard_category_view_get_type (void)
{
	static volatile gsize switchboard_category_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_category_view_type_id__once)) {
		GType switchboard_category_view_type_id;
		switchboard_category_view_type_id = switchboard_category_view_get_type_once ();
		g_once_init_leave (&switchboard_category_view_type_id__once, switchboard_category_view_type_id);
	}
	return switchboard_category_view_type_id__once;
}

static void
_vala_switchboard_category_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	switch (property_id) {
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY:
		switchboard_value_set_plugs_search (value, switchboard_category_view_get_plug_search (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_plug_search_result (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_personal_category (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_hardware_category (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_network_category (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_system_category (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY:
		g_value_set_string (value, switchboard_category_view_get_plug_to_open (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_category_view_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	switch (property_id) {
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_PROPERTY:
		switchboard_category_view_set_plug_search (self, switchboard_value_get_plugs_search (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY:
		switchboard_category_view_set_plug_search_result (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PERSONAL_CATEGORY_PROPERTY:
		switchboard_category_view_set_personal_category (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_HARDWARE_CATEGORY_PROPERTY:
		switchboard_category_view_set_hardware_category (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_NETWORK_CATEGORY_PROPERTY:
		switchboard_category_view_set_network_category (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_SYSTEM_CATEGORY_PROPERTY:
		switchboard_category_view_set_system_category (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY:
		switchboard_category_view_set_plug_to_open (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

