/* Application.c generated by valac 0.56.17, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright 2011-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
* Authored by: Avi Romanoff <avi@romanoff.me>
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "switchboard.h"
#include <handy.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <locale.h>
#include <gio/gdesktopappinfo.h>

#define GETTEXT_PACKAGE "io.elementary.switchboard"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SWITCHBOARD_TYPE_SWITCHBOARD_APP (switchboard_switchboard_app_get_type ())
#define SWITCHBOARD_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp))
#define SWITCHBOARD_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))
#define SWITCHBOARD_IS_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_IS_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_SWITCHBOARD_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))

typedef struct _SwitchboardSwitchboardApp SwitchboardSwitchboardApp;
typedef struct _SwitchboardSwitchboardAppClass SwitchboardSwitchboardAppClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SwitchboardSwitchboardAppPrivate SwitchboardSwitchboardAppPrivate;

#define SWITCHBOARD_TYPE_CATEGORY_VIEW (switchboard_category_view_get_type ())
#define SWITCHBOARD_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView))
#define SWITCHBOARD_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))
#define SWITCHBOARD_IS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_IS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))

typedef struct _SwitchboardCategoryView SwitchboardCategoryView;
typedef struct _SwitchboardCategoryViewClass SwitchboardCategoryViewClass;
enum  {
	SWITCHBOARD_SWITCHBOARD_APP_0_PROPERTY,
	SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY,
	SWITCHBOARD_SWITCHBOARD_APP_NUM_PROPERTIES
};
static GParamSpec* switchboard_switchboard_app_properties[SWITCHBOARD_SWITCHBOARD_APP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SWITCHBOARD_TYPE_SEARCH_VIEW (switchboard_search_view_get_type ())
#define SWITCHBOARD_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchView))
#define SWITCHBOARD_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))
#define SWITCHBOARD_IS_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_IS_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_SEARCH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))

typedef struct _SwitchboardSearchView SwitchboardSearchView;
typedef struct _SwitchboardSearchViewClass SwitchboardSearchViewClass;
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define SWITCHBOARD_TYPE_SEARCH_ENTRY (switchboard_search_entry_get_type ())
typedef struct _SwitchboardSearchEntry SwitchboardSearchEntry;
#define _switchboard_search_entry_free0(var) ((var == NULL) ? NULL : (var = (switchboard_search_entry_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SwitchboardSwitchboardApp {
	GtkApplication parent_instance;
	SwitchboardSwitchboardAppPrivate * priv;
};

struct _SwitchboardSwitchboardAppClass {
	GtkApplicationClass parent_class;
};

struct _SwitchboardSwitchboardAppPrivate {
	GtkSearchEntry* _search_box;
	gchar* all_settings_label;
	guint configure_id;
	GHashTable* plug_widgets;
	GtkButton* navigation_button;
	HdyDeck* deck;
	HdyHeaderBar* headerbar;
	HdyWindow* main_window;
	SwitchboardCategoryView* category_view;
};

struct _Block1Data {
	int _ref_count_;
	SwitchboardSwitchboardApp* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
	SwitchboardSearchView* searchview;
	GtkStack* search_stack;
	GtkAllocation rect;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	SwitchboardSwitchboardApp* self;
	SwitchboardPlug* plug;
};

struct _SwitchboardSearchEntry {
	gchar* plug_name;
	gchar* ui_elements;
	gchar* open_window;
};

static gint SwitchboardSwitchboardApp_private_offset;
static gpointer switchboard_switchboard_app_parent_class = NULL;
static gboolean switchboard_switchboard_app_opened_directly;
static gboolean switchboard_switchboard_app_opened_directly = FALSE;
static gchar* switchboard_switchboard_app_link;
static gchar* switchboard_switchboard_app_link = NULL;
static gchar* switchboard_switchboard_app_open_window;
static gchar* switchboard_switchboard_app_open_window = NULL;
static gchar* switchboard_switchboard_app_plug_to_open;
static gchar* switchboard_switchboard_app_plug_to_open = NULL;

static gint switchboard_main (gchar** args,
                       gint args_length1);
VALA_EXTERN GType switchboard_switchboard_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSwitchboardApp, g_object_unref)
VALA_EXTERN SwitchboardSwitchboardApp* switchboard_switchboard_app_new (void);
VALA_EXTERN SwitchboardSwitchboardApp* switchboard_switchboard_app_construct (GType object_type);
VALA_EXTERN GType switchboard_category_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryView, g_object_unref)
static void switchboard_switchboard_app_real_open (GApplication* base,
                                            GFile** files,
                                            gint files_length1,
                                            const gchar* hint);
static void switchboard_switchboard_app_real_activate (GApplication* base);
VALA_EXTERN GType switchboard_search_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSearchView, g_object_unref)
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN gboolean switchboard_switchboard_app_load_setting_path (SwitchboardSwitchboardApp* self,
                                                        const gchar* setting_path,
                                                        SwitchboardPlugsManager* plugsmanager);
VALA_EXTERN void switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                            SwitchboardPlug* plug);
static void __lambda12_ (Block1Data* _data1_);
static void ___lambda12__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void _g_object_unref0_ (gpointer var);
static void switchboard_switchboard_app_set_search_box (SwitchboardSwitchboardApp* self,
                                                 GtkSearchEntry* value);
VALA_EXTERN GtkSearchEntry* switchboard_switchboard_app_get_search_box (SwitchboardSwitchboardApp* self);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_new (const gchar* plug);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_construct (GType object_type,
                                                              const gchar* plug);
static void __lambda13_ (SwitchboardSwitchboardApp* self,
                  SwitchboardPlug* plug);
static void ___lambda13__switchboard_category_view_plug_selected (SwitchboardCategoryView* _sender,
                                                           SwitchboardPlug* plug,
                                                           gpointer self);
VALA_EXTERN void switchboard_category_view_load_default_plugs (SwitchboardCategoryView* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void switchboard_category_view_load_default_plugs_finish (SwitchboardCategoryView* self,
                                                          GAsyncResult* _res_);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_new (void);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_construct (GType object_type);
static void __lambda16_ (Block1Data* _data1_);
static void ___lambda16__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                   gpointer self);
static gboolean __lambda17_ (Block1Data* _data1_,
                      GdkEventKey* event);
VALA_EXTERN void switchboard_search_view_activate_first_item (SwitchboardSearchView* self);
static gboolean ___lambda17__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static void __lambda18_ (SwitchboardSwitchboardApp* self);
static void switchboard_switchboard_app_handle_navigation_button_clicked (SwitchboardSwitchboardApp* self);
static void ___lambda18__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda19_ (SwitchboardSwitchboardApp* self);
static void ___lambda19__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static gboolean __lambda20_ (SwitchboardSwitchboardApp* self,
                      GdkEventButton* event);
static gboolean ___lambda20__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void switchboard_switchboard_app_shut_down (SwitchboardSwitchboardApp* self);
static void _switchboard_switchboard_app_shut_down_gtk_widget_destroy (GtkWidget* _sender,
                                                                gpointer self);
static gboolean __lambda21_ (Block1Data* _data1_,
                      GdkEventConfigure* event);
static gboolean __lambda22_ (Block1Data* _data1_);
static gboolean ___lambda22__gsource_func (gpointer self);
static gboolean ___lambda21__gtk_widget_configure_event (GtkWidget* _sender,
                                                  GdkEventConfigure* event,
                                                  gpointer self);
static gboolean __lambda23_ (SwitchboardSwitchboardApp* self,
                      GdkEventKey* event);
static gboolean ___lambda23__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static void __lambda24_ (SwitchboardSwitchboardApp* self);
static void switchboard_switchboard_app_update_navigation (SwitchboardSwitchboardApp* self);
static void ___lambda24__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda25_ (SwitchboardSwitchboardApp* self);
static void ___lambda25__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void switchboard_category_view_show_alert (SwitchboardCategoryView* self,
                                           const gchar* primary_text,
                                           const gchar* secondary_text,
                                           const gchar* icon_name);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
VALA_EXTERN GType switchboard_search_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SwitchboardSearchEntry* switchboard_search_entry_dup (const SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_free (SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_copy (const SwitchboardSearchEntry* self,
                                    SwitchboardSearchEntry* dest);
VALA_EXTERN void switchboard_search_entry_destroy (SwitchboardSearchEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwitchboardSearchEntry, switchboard_search_entry_destroy)
VALA_EXTERN GeeArrayList* switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self);
static gboolean __lambda9_ (Block2Data* _data2_,
                     SwitchboardSearchEntry* entry);
static gboolean ___lambda9__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean ___lambda8__gsource_func (gpointer self);
static GObject * switchboard_switchboard_app_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void switchboard_switchboard_app_finalize (GObject * obj);
static GType switchboard_switchboard_app_get_type_once (void);
static void _vala_switchboard_switchboard_app_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_switchboard_switchboard_app_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gint
switchboard_main (gchar** args,
                  gint args_length1)
{
	SwitchboardSwitchboardApp* app = NULL;
	SwitchboardSwitchboardApp* _tmp0_;
	gint result;
	_tmp0_ = switchboard_switchboard_app_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return switchboard_main (argv, argc);
}

static inline gpointer
switchboard_switchboard_app_get_instance_private (SwitchboardSwitchboardApp* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardSwitchboardApp_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
switchboard_switchboard_app_real_open (GApplication* base,
                                       GFile** files,
                                       gint files_length1,
                                       const gchar* hint)
{
	SwitchboardSwitchboardApp * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	self = (SwitchboardSwitchboardApp*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (file);
		return;
	}
	_tmp3_ = file;
	_tmp4_ = g_file_get_uri_scheme (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "settings") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = file;
		_tmp8_ = g_file_get_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_replace (_tmp9_, "settings://", "");
		_g_free0 (switchboard_switchboard_app_link);
		switchboard_switchboard_app_link = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = switchboard_switchboard_app_link;
		if (g_str_has_suffix (_tmp11_, "/")) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = switchboard_switchboard_app_link;
			_tmp13_ = switchboard_switchboard_app_link;
			_tmp14_ = string_substring (_tmp12_, (glong) 0, (glong) string_last_index_of_char (_tmp13_, (gunichar) '/', 0));
			_g_free0 (switchboard_switchboard_app_link);
			switchboard_switchboard_app_link = _tmp14_;
		}
	} else {
		g_critical ("Application.vala:77: Calling Switchboard directly is unsupported, plea" \
"se use the settings:// scheme instead");
	}
	g_application_activate ((GApplication*) self);
	_g_object_unref0 (file);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SwitchboardSwitchboardApp* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->settings);
		_g_object_unref0 (_data1_->search_stack);
		_g_object_unref0 (_data1_->searchview);
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda12_ (Block1Data* _data1_)
{
	SwitchboardSwitchboardApp* self;
	GtkSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->gtk_settings;
	_tmp1_ = _data1_->granite_settings;
	_tmp2_ = granite_settings_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", _tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda12__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda12_ (self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda13_ (SwitchboardSwitchboardApp* self,
             SwitchboardPlug* plug)
{
	g_return_if_fail (plug != NULL);
	switchboard_switchboard_app_load_plug (self, plug);
}

static void
___lambda13__switchboard_category_view_plug_selected (SwitchboardCategoryView* _sender,
                                                      SwitchboardPlug* plug,
                                                      gpointer self)
{
	__lambda13_ ((SwitchboardSwitchboardApp*) self, plug);
}

static void
__lambda16_ (Block1Data* _data1_)
{
	SwitchboardSwitchboardApp* self;
	GtkSearchEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = _data1_->self;
	_tmp0_ = self->priv->_search_box;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 0)) {
		GtkStack* _tmp3_;
		SwitchboardSearchView* _tmp4_;
		_tmp3_ = _data1_->search_stack;
		_tmp4_ = _data1_->searchview;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	} else {
		GtkStack* _tmp5_;
		HdyDeck* _tmp6_;
		_tmp5_ = _data1_->search_stack;
		_tmp6_ = self->priv->deck;
		gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	}
}

static void
___lambda16__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                              gpointer self)
{
	__lambda16_ (self);
}

static gboolean
__lambda17_ (Block1Data* _data1_,
             GdkEventKey* event)
{
	SwitchboardSwitchboardApp* self;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Return:
		{
			SwitchboardSearchView* _tmp0_;
			_tmp0_ = _data1_->searchview;
			switchboard_search_view_activate_first_item (_tmp0_);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Down:
		{
			GtkSearchEntry* _tmp1_;
			_tmp1_ = self->priv->_search_box;
			g_signal_emit_by_name ((GtkWidget*) _tmp1_, "move-focus", GTK_DIR_TAB_FORWARD);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Escape:
		{
			GtkSearchEntry* _tmp2_;
			_tmp2_ = self->priv->_search_box;
			gtk_entry_set_text ((GtkEntry*) _tmp2_, "");
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda17__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda17_ (self, event);
	return result;
}

static void
__lambda18_ (SwitchboardSwitchboardApp* self)
{
	switchboard_switchboard_app_handle_navigation_button_clicked (self);
}

static void
___lambda18__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda18_ ((SwitchboardSwitchboardApp*) self);
}

static void
__lambda19_ (SwitchboardSwitchboardApp* self)
{
	HdyWindow* _tmp0_;
	_tmp0_ = self->priv->main_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
___lambda19__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda19_ ((SwitchboardSwitchboardApp*) self);
}

static gboolean
__lambda20_ (SwitchboardSwitchboardApp* self,
             GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 8)) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->navigation_button;
		gtk_button_clicked (_tmp0_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda20_ ((SwitchboardSwitchboardApp*) self, event);
	return result;
}

static void
_switchboard_switchboard_app_shut_down_gtk_widget_destroy (GtkWidget* _sender,
                                                           gpointer self)
{
	switchboard_switchboard_app_shut_down ((SwitchboardSwitchboardApp*) self);
}

static gboolean
__lambda22_ (Block1Data* _data1_)
{
	SwitchboardSwitchboardApp* self;
	HdyWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data1_->self;
	self->priv->configure_id = (guint) 0;
	_tmp0_ = self->priv->main_window;
	g_object_get ((GtkWindow*) _tmp0_, "is-maximized", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = _data1_->settings;
		g_settings_set_boolean (_tmp3_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp4_;
		HdyWindow* _tmp5_;
		GtkAllocation _tmp6_ = {0};
		GSettings* _tmp7_;
		GtkAllocation _tmp8_;
		GtkAllocation _tmp9_;
		gint root_x = 0;
		gint root_y = 0;
		HdyWindow* _tmp10_;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		GSettings* _tmp13_;
		_tmp4_ = _data1_->settings;
		g_settings_set_boolean (_tmp4_, "window-maximized", FALSE);
		_tmp5_ = self->priv->main_window;
		gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
		_data1_->rect = _tmp6_;
		_tmp7_ = _data1_->settings;
		_tmp8_ = _data1_->rect;
		_tmp9_ = _data1_->rect;
		g_settings_set (_tmp7_, "window-size", "(ii)", _tmp8_.width, _tmp9_.height);
		_tmp10_ = self->priv->main_window;
		gtk_window_get_position ((GtkWindow*) _tmp10_, &_tmp11_, &_tmp12_);
		root_x = _tmp11_;
		root_y = _tmp12_;
		_tmp13_ = _data1_->settings;
		g_settings_set (_tmp13_, "window-position", "(ii)", root_x, root_y);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda22_ (self);
	return result;
}

static gboolean
__lambda21_ (Block1Data* _data1_,
             GdkEventConfigure* event)
{
	SwitchboardSwitchboardApp* self;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda22__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gtk_widget_configure_event (GtkWidget* _sender,
                                         GdkEventConfigure* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda21_ (self, event);
	return result;
}

static gboolean
__lambda23_ (SwitchboardSwitchboardApp* self,
             GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Up:
		case GDK_KEY_Down:
		case GDK_KEY_Left:
		case GDK_KEY_Right:
		case GDK_KEY_Return:
		case GDK_KEY_Tab:
		{
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
		default:
		break;
	}
	if (event->is_modifier == ((guint) 0)) {
		GtkSearchEntry* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_search_box;
		g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSearchEntry* _tmp4_;
		_tmp4_ = self->priv->_search_box;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda23__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda23_ ((SwitchboardSwitchboardApp*) self, event);
	return result;
}

static void
__lambda24_ (SwitchboardSwitchboardApp* self)
{
	switchboard_switchboard_app_update_navigation (self);
}

static void
___lambda24__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda24_ ((SwitchboardSwitchboardApp*) self);
}

static void
__lambda25_ (SwitchboardSwitchboardApp* self)
{
	switchboard_switchboard_app_update_navigation (self);
}

static void
___lambda25__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda25_ ((SwitchboardSwitchboardApp*) self);
}

static void
switchboard_switchboard_app_real_activate (GApplication* base)
{
	SwitchboardSwitchboardApp * self;
	Block1Data* _data1_;
	SwitchboardPlugsManager* plugsmanager = NULL;
	SwitchboardPlugsManager* _tmp0_;
	GSettings* setting = NULL;
	GSettings* _tmp1_;
	GVariant* mapping_dic = NULL;
	GSettings* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GList* _tmp28_;
	GraniteSettings* _tmp31_;
	GraniteSettings* _tmp32_;
	GtkSettings* _tmp33_;
	GtkSettings* _tmp34_;
	GtkSettings* _tmp35_;
	GraniteSettings* _tmp36_;
	GraniteSettingsColorScheme _tmp37_;
	GraniteSettingsColorScheme _tmp38_;
	GraniteSettings* _tmp39_;
	GHashTable* _tmp40_;
	GSimpleAction* back_action = NULL;
	GSimpleAction* _tmp41_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp42_;
	GSimpleAction* _tmp43_;
	GSimpleAction* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	gchar** _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	const gchar* _tmp52_;
	GtkButton* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GtkButton* _tmp64_;
	GtkStyleContext* _tmp65_;
	gchar* _tmp66_;
	GtkSearchEntry* _tmp67_ = NULL;
	GtkSearchEntry* _tmp68_;
	gchar* _tmp69_;
	HdyHeaderBar* _tmp70_ = NULL;
	HdyHeaderBar* _tmp71_;
	GtkButton* _tmp72_;
	HdyHeaderBar* _tmp73_;
	GtkSearchEntry* _tmp74_;
	const gchar* _tmp75_;
	SwitchboardCategoryView* _tmp76_;
	SwitchboardCategoryView* _tmp77_;
	SwitchboardCategoryView* _tmp78_;
	HdyDeck* _tmp79_ = NULL;
	HdyDeck* _tmp80_;
	SwitchboardCategoryView* _tmp81_;
	SwitchboardSearchView* _tmp82_;
	GtkStack* _tmp83_;
	GtkStack* _tmp84_;
	GtkStack* _tmp85_;
	HdyDeck* _tmp86_;
	GtkStack* _tmp87_;
	SwitchboardSearchView* _tmp88_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp89_;
	GtkGrid* _tmp90_;
	HdyHeaderBar* _tmp91_;
	GtkGrid* _tmp92_;
	GtkStack* _tmp93_;
	HdyWindow* _tmp94_;
	HdyWindow* _tmp95_;
	HdyWindow* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	HdyWindow* _tmp99_;
	HdyWindow* _tmp100_;
	GtkGrid* _tmp101_;
	HdyWindow* _tmp102_;
	gint window_x = 0;
	gint window_y = 0;
	GSettings* _tmp103_;
	GSettings* _tmp104_;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	GSettings* _tmp107_;
	gint _tmp108_ = 0;
	gint _tmp109_ = 0;
	gboolean _tmp110_ = FALSE;
	HdyWindow* _tmp112_;
	GtkAllocation _tmp113_;
	GSettings* _tmp114_;
	HdyWindow* _tmp116_;
	GtkButton* _tmp117_;
	HdyWindow* _tmp118_;
	GtkSearchEntry* _tmp119_;
	GtkSearchEntry* _tmp120_;
	GSimpleAction* _tmp121_;
	GSimpleAction* _tmp122_;
	HdyWindow* _tmp123_;
	HdyWindow* _tmp124_;
	HdyWindow* _tmp125_;
	HdyWindow* _tmp126_;
	HdyDeck* _tmp127_;
	HdyDeck* _tmp128_;
	SwitchboardPlugsManager* _tmp129_;
	SwitchboardPlugsManager* _tmp130_;
	gboolean _tmp131_;
	self = (SwitchboardSwitchboardApp*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	hdy_init ();
	_tmp0_ = switchboard_plugs_manager_get_default ();
	plugsmanager = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.switchboard.preferences");
	setting = _tmp1_;
	_tmp2_ = setting;
	_tmp3_ = g_settings_get_value (_tmp2_, "mapping-override");
	mapping_dic = _tmp3_;
	_tmp5_ = switchboard_switchboard_app_link;
	if (_tmp5_ != NULL) {
		GVariant* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = mapping_dic;
		_tmp7_ = switchboard_switchboard_app_link;
		_tmp8_ = g_variant_lookup (_tmp6_, _tmp7_, "(ss)", &switchboard_switchboard_app_plug_to_open, &switchboard_switchboard_app_open_window, NULL);
		_tmp4_ = !_tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean plug_found = FALSE;
		const gchar* _tmp9_;
		SwitchboardPlugsManager* _tmp10_;
		_tmp9_ = switchboard_switchboard_app_link;
		_tmp10_ = plugsmanager;
		plug_found = switchboard_switchboard_app_load_setting_path (self, _tmp9_, _tmp10_);
		if (plug_found) {
			_g_free0 (switchboard_switchboard_app_link);
			switchboard_switchboard_app_link = NULL;
			switchboard_switchboard_app_opened_directly = TRUE;
		} else {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = switchboard_switchboard_app_link;
			_tmp12_ = g_strdup_printf (_ ("Specified link '%s' does not exist, going back to the main panel"), _tmp11_);
			_tmp13_ = _tmp12_;
			g_warning ("Application.vala:98: %s", _tmp13_);
			_g_free0 (_tmp13_);
		}
	} else {
		const gchar* _tmp14_;
		_tmp14_ = switchboard_switchboard_app_plug_to_open;
		if (_tmp14_ != NULL) {
			{
				GeeIterator* _plug_it = NULL;
				SwitchboardPlugsManager* _tmp15_;
				GeeCollection* _tmp16_;
				GeeCollection* _tmp17_;
				GeeIterator* _tmp18_;
				GeeIterator* _tmp19_;
				_tmp15_ = plugsmanager;
				_tmp16_ = switchboard_plugs_manager_get_plugs (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
				_tmp19_ = _tmp18_;
				_g_object_unref0 (_tmp17_);
				_plug_it = _tmp19_;
				while (TRUE) {
					GeeIterator* _tmp20_;
					SwitchboardPlug* plug = NULL;
					GeeIterator* _tmp21_;
					gpointer _tmp22_;
					const gchar* _tmp23_;
					SwitchboardPlug* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					_tmp20_ = _plug_it;
					if (!gee_iterator_next (_tmp20_)) {
						break;
					}
					_tmp21_ = _plug_it;
					_tmp22_ = gee_iterator_get (_tmp21_);
					plug = (SwitchboardPlug*) _tmp22_;
					_tmp23_ = switchboard_switchboard_app_plug_to_open;
					_tmp24_ = plug;
					_tmp25_ = switchboard_plug_get_code_name (_tmp24_);
					_tmp26_ = _tmp25_;
					if (g_str_has_suffix (_tmp23_, _tmp26_)) {
						SwitchboardPlug* _tmp27_;
						_tmp27_ = plug;
						switchboard_switchboard_app_load_plug (self, _tmp27_);
						_g_free0 (switchboard_switchboard_app_plug_to_open);
						switchboard_switchboard_app_plug_to_open = NULL;
						switchboard_switchboard_app_opened_directly = TRUE;
						_g_object_unref0 (plug);
						break;
					}
					_g_object_unref0 (plug);
				}
				_g_object_unref0 (_plug_it);
			}
		}
	}
	_tmp28_ = gtk_application_get_windows ((GtkApplication*) self);
	if (g_list_length (_tmp28_) > ((guint) 0)) {
		GList* _tmp29_;
		gconstpointer _tmp30_;
		_tmp29_ = gtk_application_get_windows ((GtkApplication*) self);
		_tmp30_ = _tmp29_->data;
		gtk_window_present ((GtkWindow*) _tmp30_);
		_g_variant_unref0 (mapping_dic);
		_g_object_unref0 (setting);
		_g_object_unref0 (plugsmanager);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp31_ = granite_settings_get_default ();
	_tmp32_ = _g_object_ref0 (_tmp31_);
	_data1_->granite_settings = _tmp32_;
	_tmp33_ = gtk_settings_get_default ();
	_tmp34_ = _g_object_ref0 (_tmp33_);
	_data1_->gtk_settings = _tmp34_;
	_tmp35_ = _data1_->gtk_settings;
	_tmp36_ = _data1_->granite_settings;
	_tmp37_ = granite_settings_get_prefers_color_scheme (_tmp36_);
	_tmp38_ = _tmp37_;
	g_object_set (_tmp35_, "gtk-application-prefer-dark-theme", _tmp38_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	_tmp39_ = _data1_->granite_settings;
	g_signal_connect_data ((GObject*) _tmp39_, "notify::prefers-color-scheme", (GCallback) ___lambda12__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp40_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->plug_widgets);
	self->priv->plug_widgets = _tmp40_;
	_tmp41_ = g_simple_action_new ("back", NULL);
	back_action = _tmp41_;
	_tmp42_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp42_;
	_tmp43_ = back_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp43_);
	_tmp44_ = quit_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp44_);
	_tmp45_ = g_strdup ("<Alt>Left");
	_tmp46_ = g_strdup ("Back");
	_tmp47_ = g_new0 (gchar*, 2 + 1);
	_tmp47_[0] = _tmp45_;
	_tmp47_[1] = _tmp46_;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp48_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp49_ = g_strdup ("<Control>q");
	_tmp50_ = g_new0 (gchar*, 1 + 1);
	_tmp50_[0] = _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp51_);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
	_tmp52_ = self->priv->all_settings_label;
	_tmp53_ = (GtkButton*) gtk_button_new_with_label (_ (_tmp52_));
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->navigation_button);
	self->priv->navigation_button = _tmp53_;
	_tmp54_ = self->priv->navigation_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp54_, "app.back");
	_tmp55_ = self->priv->navigation_button;
	_tmp56_ = self->priv->navigation_button;
	_tmp57_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp60_ = _tmp59_ = gtk_application_get_accels_for_action ((GtkApplication*) self, _tmp58_);
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _vala_array_length (_tmp59_);
	_tmp62_ = granite_markup_accel_tooltip (_tmp61_, (gint) _vala_array_length (_tmp59_), NULL);
	_tmp63_ = _tmp62_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp55_, _tmp63_);
	_g_free0 (_tmp63_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp64_ = self->priv->navigation_button;
	_tmp65_ = gtk_widget_get_style_context ((GtkWidget*) _tmp64_);
	gtk_style_context_add_class (_tmp65_, "back-button");
	_tmp66_ = g_strdup (_ ("Search Settings"));
	_tmp67_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp67_, _tmp66_);
	_g_free0 (_tmp66_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp67_, FALSE);
	g_object_ref_sink (_tmp67_);
	_tmp68_ = _tmp67_;
	switchboard_switchboard_app_set_search_box (self, _tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = g_strdup (_ ("System Settings"));
	_tmp70_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_has_subtitle (_tmp70_, FALSE);
	hdy_header_bar_set_show_close_button (_tmp70_, TRUE);
	hdy_header_bar_set_title (_tmp70_, _tmp69_);
	_g_free0 (_tmp69_);
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp70_;
	_tmp71_ = self->priv->headerbar;
	_tmp72_ = self->priv->navigation_button;
	hdy_header_bar_pack_start (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = self->priv->headerbar;
	_tmp74_ = self->priv->_search_box;
	hdy_header_bar_pack_end (_tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = switchboard_switchboard_app_plug_to_open;
	_tmp76_ = switchboard_category_view_new (_tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->category_view);
	self->priv->category_view = _tmp76_;
	_tmp77_ = self->priv->category_view;
	g_signal_connect_object (_tmp77_, "plug-selected", (GCallback) ___lambda13__switchboard_category_view_plug_selected, self, 0);
	_tmp78_ = self->priv->category_view;
	switchboard_category_view_load_default_plugs (_tmp78_, NULL, NULL);
	_tmp79_ = (HdyDeck*) hdy_deck_new ();
	hdy_deck_set_can_swipe_back (_tmp79_, TRUE);
	hdy_deck_set_can_swipe_forward (_tmp79_, TRUE);
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->deck);
	self->priv->deck = _tmp79_;
	_tmp80_ = self->priv->deck;
	_tmp81_ = self->priv->category_view;
	gtk_container_add ((GtkContainer*) _tmp80_, (GtkWidget*) _tmp81_);
	_tmp82_ = switchboard_search_view_new ();
	g_object_ref_sink (_tmp82_);
	_data1_->searchview = _tmp82_;
	_tmp83_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp83_);
	_data1_->search_stack = _tmp83_;
	_tmp84_ = _data1_->search_stack;
	gtk_stack_set_transition_type (_tmp84_, GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP);
	_tmp85_ = _data1_->search_stack;
	_tmp86_ = self->priv->deck;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = _data1_->search_stack;
	_tmp88_ = _data1_->searchview;
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp89_);
	grid = _tmp89_;
	_tmp90_ = grid;
	_tmp91_ = self->priv->headerbar;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 0, 0, 1, 1);
	_tmp92_ = grid;
	_tmp93_ = _data1_->search_stack;
	gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 0, 1, 1, 1);
	_tmp94_ = (HdyWindow*) hdy_window_new ();
	g_object_ref_sink (_tmp94_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp94_;
	_tmp95_ = self->priv->main_window;
	gtk_window_set_application ((GtkWindow*) _tmp95_, (GtkApplication*) self);
	_tmp96_ = self->priv->main_window;
	_tmp97_ = g_application_get_application_id ((GApplication*) self);
	_tmp98_ = _tmp97_;
	gtk_window_set_icon_name ((GtkWindow*) _tmp96_, _tmp98_);
	_tmp99_ = self->priv->main_window;
	gtk_window_set_title ((GtkWindow*) _tmp99_, _ ("System Settings"));
	_tmp100_ = self->priv->main_window;
	_tmp101_ = grid;
	gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = self->priv->main_window;
	gtk_widget_set_size_request ((GtkWidget*) _tmp102_, 640, 480);
	memset (&_data1_->rect, 0, sizeof (GtkAllocation));
	_tmp103_ = g_settings_new ("io.elementary.switchboard.saved-state");
	_data1_->settings = _tmp103_;
	_tmp104_ = _data1_->settings;
	g_settings_get (_tmp104_, "window-position", "(ii)", &_tmp105_, &_tmp106_);
	window_x = _tmp105_;
	window_y = _tmp106_;
	_tmp107_ = _data1_->settings;
	g_settings_get (_tmp107_, "window-size", "(ii)", &_tmp108_, &_tmp109_);
	_data1_->rect.width = _tmp108_;
	_data1_->rect.height = _tmp109_;
	if (window_x != -1) {
		_tmp110_ = TRUE;
	} else {
		_tmp110_ = window_y != -1;
	}
	if (_tmp110_) {
		HdyWindow* _tmp111_;
		_tmp111_ = self->priv->main_window;
		gtk_window_move ((GtkWindow*) _tmp111_, window_x, window_y);
	}
	_tmp112_ = self->priv->main_window;
	_tmp113_ = _data1_->rect;
	gtk_widget_set_allocation ((GtkWidget*) _tmp112_, &_tmp113_);
	_tmp114_ = _data1_->settings;
	if (g_settings_get_boolean (_tmp114_, "window-maximized")) {
		HdyWindow* _tmp115_;
		_tmp115_ = self->priv->main_window;
		gtk_window_maximize ((GtkWindow*) _tmp115_);
	}
	_tmp116_ = self->priv->main_window;
	gtk_widget_show_all ((GtkWidget*) _tmp116_);
	_tmp117_ = self->priv->navigation_button;
	gtk_widget_hide ((GtkWidget*) _tmp117_);
	_tmp118_ = self->priv->main_window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp118_);
	_tmp119_ = self->priv->_search_box;
	g_signal_connect_data (_tmp119_, "search-changed", (GCallback) ___lambda16__gtk_search_entry_search_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp120_ = self->priv->_search_box;
	g_signal_connect_data ((GtkWidget*) _tmp120_, "key-press-event", (GCallback) ___lambda17__gtk_widget_key_press_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp121_ = back_action;
	g_signal_connect_object (_tmp121_, "activate", (GCallback) ___lambda18__g_simple_action_activate, self, 0);
	_tmp122_ = quit_action;
	g_signal_connect_object (_tmp122_, "activate", (GCallback) ___lambda19__g_simple_action_activate, self, 0);
	_tmp123_ = self->priv->main_window;
	g_signal_connect_object ((GtkWidget*) _tmp123_, "button-release-event", (GCallback) ___lambda20__gtk_widget_button_release_event, self, 0);
	_tmp124_ = self->priv->main_window;
	g_signal_connect_object ((GtkWidget*) _tmp124_, "destroy", (GCallback) _switchboard_switchboard_app_shut_down_gtk_widget_destroy, self, 0);
	_tmp125_ = self->priv->main_window;
	g_signal_connect_data ((GtkWidget*) _tmp125_, "configure-event", (GCallback) ___lambda21__gtk_widget_configure_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp126_ = self->priv->main_window;
	g_signal_connect_object ((GtkWidget*) _tmp126_, "key-press-event", (GCallback) ___lambda23__gtk_widget_key_press_event, self, 0);
	_tmp127_ = self->priv->deck;
	g_signal_connect_object ((GObject*) _tmp127_, "notify::visible-child", (GCallback) ___lambda24__g_object_notify, self, 0);
	_tmp128_ = self->priv->deck;
	g_signal_connect_object ((GObject*) _tmp128_, "notify::transition-running", (GCallback) ___lambda25__g_object_notify, self, 0);
	_tmp129_ = switchboard_plugs_manager_get_default ();
	_tmp130_ = _tmp129_;
	_tmp131_ = switchboard_plugs_manager_has_plugs (_tmp130_) == FALSE;
	_g_object_unref0 (_tmp130_);
	if (_tmp131_) {
		SwitchboardCategoryView* _tmp132_;
		_tmp132_ = self->priv->category_view;
		switchboard_category_view_show_alert (_tmp132_, _ ("No Settings Found"), _ ("Install some and re-launch Switchboard."), "dialog-warning");
	} else {
		GtkSearchEntry* _tmp133_;
		GtkSearchEntry* _tmp134_;
		_tmp133_ = self->priv->_search_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp133_, TRUE);
		_tmp134_ = self->priv->_search_box;
		g_object_set ((GtkWidget*) _tmp134_, "has-focus", TRUE, NULL);
	}
	gtk_main ();
	_g_object_unref0 (grid);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (back_action);
	_g_variant_unref0 (mapping_dic);
	_g_object_unref0 (setting);
	_g_object_unref0 (plugsmanager);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
switchboard_switchboard_app_update_navigation (SwitchboardSwitchboardApp* self)
{
	HdyDeck* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_transition_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GHashTable* _tmp3_;
		HdyDeck* _tmp4_;
		GtkWidget* _tmp5_;
		gconstpointer _tmp6_;
		SwitchboardPlug* previous_child = NULL;
		GHashTable* _tmp11_;
		HdyDeck* _tmp12_;
		GtkWidget* _tmp13_;
		gconstpointer _tmp14_;
		SwitchboardPlug* _tmp15_;
		gboolean _tmp16_ = FALSE;
		SwitchboardPlug* _tmp17_;
		HdyDeck* _tmp20_;
		GtkWidget* _tmp21_;
		GtkWidget* _tmp22_;
		SwitchboardCategoryView* _tmp23_;
		GtkSearchEntry* _tmp57_;
		_tmp3_ = self->priv->plug_widgets;
		_tmp4_ = self->priv->deck;
		_tmp5_ = hdy_deck_get_adjacent_child (_tmp4_, HDY_NAVIGATION_DIRECTION_FORWARD);
		_tmp6_ = g_hash_table_lookup (_tmp3_, _tmp5_);
		if (((SwitchboardPlug*) _tmp6_) != NULL) {
			GHashTable* _tmp7_;
			HdyDeck* _tmp8_;
			GtkWidget* _tmp9_;
			gconstpointer _tmp10_;
			_tmp7_ = self->priv->plug_widgets;
			_tmp8_ = self->priv->deck;
			_tmp9_ = hdy_deck_get_adjacent_child (_tmp8_, HDY_NAVIGATION_DIRECTION_FORWARD);
			_tmp10_ = g_hash_table_lookup (_tmp7_, _tmp9_);
			switchboard_plug_hidden ((SwitchboardPlug*) _tmp10_);
		}
		_tmp11_ = self->priv->plug_widgets;
		_tmp12_ = self->priv->deck;
		_tmp13_ = hdy_deck_get_adjacent_child (_tmp12_, HDY_NAVIGATION_DIRECTION_BACK);
		_tmp14_ = g_hash_table_lookup (_tmp11_, _tmp13_);
		_tmp15_ = _g_object_ref0 ((SwitchboardPlug*) _tmp14_);
		previous_child = _tmp15_;
		_tmp17_ = previous_child;
		if (_tmp17_ != NULL) {
			SwitchboardPlug* _tmp18_;
			_tmp18_ = previous_child;
			_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, SWITCHBOARD_TYPE_PLUG);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			SwitchboardPlug* _tmp19_;
			_tmp19_ = previous_child;
			switchboard_plug_hidden (_tmp19_);
		}
		_tmp20_ = self->priv->deck;
		_tmp21_ = hdy_deck_get_visible_child (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->category_view;
		if (_tmp22_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget)) {
			HdyHeaderBar* _tmp24_;
			GtkButton* _tmp25_;
			GtkSearchEntry* _tmp26_;
			SwitchboardPlugsManager* _tmp27_;
			SwitchboardPlugsManager* _tmp28_;
			GtkSearchEntry* _tmp29_;
			GtkSearchEntry* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			_tmp24_ = self->priv->headerbar;
			hdy_header_bar_set_title (_tmp24_, _ ("System Settings"));
			_tmp25_ = self->priv->navigation_button;
			gtk_widget_hide ((GtkWidget*) _tmp25_);
			_tmp26_ = self->priv->_search_box;
			_tmp27_ = switchboard_plugs_manager_get_default ();
			_tmp28_ = _tmp27_;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, switchboard_plugs_manager_has_plugs (_tmp28_));
			_g_object_unref0 (_tmp28_);
			_tmp29_ = self->priv->_search_box;
			_tmp30_ = self->priv->_search_box;
			_tmp31_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp30_);
			_tmp32_ = _tmp31_;
			g_object_set ((GtkWidget*) _tmp29_, "has-focus", _tmp32_, NULL);
		} else {
			GHashTable* _tmp33_;
			HdyDeck* _tmp34_;
			GtkWidget* _tmp35_;
			GtkWidget* _tmp36_;
			gconstpointer _tmp37_;
			HdyHeaderBar* _tmp38_;
			GHashTable* _tmp39_;
			HdyDeck* _tmp40_;
			GtkWidget* _tmp41_;
			GtkWidget* _tmp42_;
			gconstpointer _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gboolean _tmp46_ = FALSE;
			SwitchboardPlug* _tmp47_;
			GtkButton* _tmp55_;
			GtkSearchEntry* _tmp56_;
			_tmp33_ = self->priv->plug_widgets;
			_tmp34_ = self->priv->deck;
			_tmp35_ = hdy_deck_get_visible_child (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_hash_table_lookup (_tmp33_, _tmp36_);
			switchboard_plug_shown ((SwitchboardPlug*) _tmp37_);
			_tmp38_ = self->priv->headerbar;
			_tmp39_ = self->priv->plug_widgets;
			_tmp40_ = self->priv->deck;
			_tmp41_ = hdy_deck_get_visible_child (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_hash_table_lookup (_tmp39_, _tmp42_);
			_tmp44_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _tmp43_);
			_tmp45_ = _tmp44_;
			hdy_header_bar_set_title (_tmp38_, _tmp45_);
			_tmp47_ = previous_child;
			if (_tmp47_ != NULL) {
				SwitchboardPlug* _tmp48_;
				_tmp48_ = previous_child;
				_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, SWITCHBOARD_TYPE_PLUG);
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				GtkButton* _tmp49_;
				SwitchboardPlug* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				_tmp49_ = self->priv->navigation_button;
				_tmp50_ = previous_child;
				_tmp51_ = switchboard_plug_get_display_name (_tmp50_);
				_tmp52_ = _tmp51_;
				gtk_button_set_label (_tmp49_, _tmp52_);
			} else {
				GtkButton* _tmp53_;
				const gchar* _tmp54_;
				_tmp53_ = self->priv->navigation_button;
				_tmp54_ = self->priv->all_settings_label;
				gtk_button_set_label (_tmp53_, _ (_tmp54_));
			}
			_tmp55_ = self->priv->navigation_button;
			gtk_widget_show ((GtkWidget*) _tmp55_);
			_tmp56_ = self->priv->_search_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
		}
		_tmp57_ = self->priv->_search_box;
		gtk_entry_set_text ((GtkEntry*) _tmp57_, "");
		_g_object_unref0 (previous_child);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwitchboardSwitchboardApp* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->plug);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda9_ (Block2Data* _data2_,
            SwitchboardSearchEntry* entry)
{
	SwitchboardSwitchboardApp* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = switchboard_plug_get_display_name (_data2_->plug);
	_tmp1_ = _tmp0_;
	_tmp2_ = (*entry).plug_name;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		const gchar* _tmp3_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = (*entry).open_window;
		if (_tmp3_ == NULL) {
			switchboard_plug_search_callback (_data2_->plug, "");
		} else {
			const gchar* _tmp4_;
			_tmp4_ = (*entry).open_window;
			switchboard_plug_search_callback (_data2_->plug, _tmp4_);
		}
		_tmp5_ = (*entry).open_window;
		_tmp6_ = switchboard_plug_get_display_name (_data2_->plug);
		_tmp7_ = _tmp6_;
		g_debug ("Application.vala:379: open section:%s of plug: %s", _tmp5_, _tmp7_);
		result = TRUE;
		_switchboard_search_entry_free0 (entry);
		return result;
	}
	result = FALSE;
	_switchboard_search_entry_free0 (entry);
	return result;
}

static gboolean
___lambda9__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, (SwitchboardSearchEntry*) g);
	return result;
}

static gboolean
__lambda8_ (Block2Data* _data2_)
{
	SwitchboardSwitchboardApp* self;
	GtkWidget* plug_widget = NULL;
	GtkWidget* _tmp5_;
	HdyDeck* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GtkWidget* _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	GHashTable* _tmp14_;
	GtkWidget* _tmp15_;
	gconstpointer _tmp16_;
	SwitchboardCategoryView* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	const gchar* _tmp24_;
	HdyDeck* _tmp31_;
	GtkWidget* _tmp32_;
	GtkWidget* _tmp33_;
	gboolean result;
	self = _data2_->self;
	while (TRUE) {
		HdyDeck* _tmp0_;
		GtkWidget* _tmp1_;
		HdyDeck* _tmp2_;
		HdyDeck* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp0_ = self->priv->deck;
		_tmp1_ = hdy_deck_get_adjacent_child (_tmp0_, HDY_NAVIGATION_DIRECTION_FORWARD);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = self->priv->deck;
		_tmp3_ = self->priv->deck;
		_tmp4_ = hdy_deck_get_adjacent_child (_tmp3_, HDY_NAVIGATION_DIRECTION_FORWARD);
		gtk_container_remove ((GtkContainer*) _tmp2_, _tmp4_);
	}
	_tmp5_ = switchboard_plug_get_widget (_data2_->plug);
	plug_widget = _tmp5_;
	_tmp6_ = self->priv->deck;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = plug_widget;
	_tmp10_ = g_list_find (_tmp8_, _tmp9_);
	_tmp11_ = _tmp10_ == NULL;
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
	if (_tmp11_) {
		HdyDeck* _tmp12_;
		GtkWidget* _tmp13_;
		_tmp12_ = self->priv->deck;
		_tmp13_ = plug_widget;
		gtk_container_add ((GtkContainer*) _tmp12_, _tmp13_);
	}
	_tmp14_ = self->priv->plug_widgets;
	_tmp15_ = plug_widget;
	_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
	if (((SwitchboardPlug*) _tmp16_) == NULL) {
		GHashTable* _tmp17_;
		GtkWidget* _tmp18_;
		GtkWidget* _tmp19_;
		SwitchboardPlug* _tmp20_;
		_tmp17_ = self->priv->plug_widgets;
		_tmp18_ = plug_widget;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_tmp20_ = _g_object_ref0 (_data2_->plug);
		g_hash_table_insert (_tmp17_, _tmp19_, _tmp20_);
	}
	_tmp21_ = self->priv->category_view;
	_tmp22_ = switchboard_category_view_get_plug_search_result (_tmp21_);
	_tmp23_ = _tmp22_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp23_, ___lambda9__gee_forall_func, _data2_);
	_tmp24_ = switchboard_switchboard_app_open_window;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		_tmp25_ = switchboard_switchboard_app_open_window;
		switchboard_plug_search_callback (_data2_->plug, _tmp25_);
		_g_free0 (switchboard_switchboard_app_open_window);
		switchboard_switchboard_app_open_window = NULL;
	}
	if (switchboard_switchboard_app_opened_directly) {
		HdyDeck* _tmp26_;
		_tmp26_ = self->priv->deck;
		hdy_deck_set_transition_duration (_tmp26_, (guint) 0);
		switchboard_switchboard_app_opened_directly = FALSE;
	} else {
		HdyDeck* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		_tmp27_ = self->priv->deck;
		_tmp28_ = hdy_deck_get_transition_duration (_tmp27_);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == ((guint) 0)) {
			HdyDeck* _tmp30_;
			_tmp30_ = self->priv->deck;
			hdy_deck_set_transition_duration (_tmp30_, (guint) 200);
		}
	}
	_tmp31_ = self->priv->deck;
	_tmp32_ = switchboard_plug_get_widget (_data2_->plug);
	_tmp33_ = _tmp32_;
	hdy_deck_set_visible_child (_tmp31_, _tmp33_);
	_g_object_unref0 (_tmp33_);
	result = FALSE;
	_g_object_unref0 (plug_widget);
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ (self);
	return result;
}

void
switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                       SwitchboardPlug* plug)
{
	Block2Data* _data2_;
	SwitchboardPlug* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plug != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (plug);
	_g_object_unref0 (_data2_->plug);
	_data2_->plug = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
switchboard_switchboard_app_shut_down (SwitchboardSwitchboardApp* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	HdyDeck* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	gconstpointer _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->plug_widgets;
	_tmp2_ = self->priv->deck;
	_tmp3_ = hdy_deck_get_visible_child (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp1_, _tmp4_);
	if (((SwitchboardPlug*) _tmp5_) != NULL) {
		GHashTable* _tmp6_;
		HdyDeck* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		gconstpointer _tmp10_;
		_tmp6_ = self->priv->plug_widgets;
		_tmp7_ = self->priv->deck;
		_tmp8_ = hdy_deck_get_visible_child (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_hash_table_lookup (_tmp6_, _tmp9_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE ((SwitchboardPlug*) _tmp10_, SWITCHBOARD_TYPE_PLUG);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GHashTable* _tmp11_;
		HdyDeck* _tmp12_;
		GtkWidget* _tmp13_;
		GtkWidget* _tmp14_;
		gconstpointer _tmp15_;
		_tmp11_ = self->priv->plug_widgets;
		_tmp12_ = self->priv->deck;
		_tmp13_ = hdy_deck_get_visible_child (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_hash_table_lookup (_tmp11_, _tmp14_);
		switchboard_plug_hidden ((SwitchboardPlug*) _tmp15_);
	}
	gtk_main_quit ();
}

static void
switchboard_switchboard_app_handle_navigation_button_clicked (SwitchboardSwitchboardApp* self)
{
	HdyDeck* _tmp0_;
	GtkWidget* _tmp1_;
	SwitchboardCategoryView* _tmp2_;
	HdyDeck* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_adjacent_child (_tmp0_, HDY_NAVIGATION_DIRECTION_BACK);
	_tmp2_ = self->priv->category_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget)) {
		HdyDeck* _tmp3_;
		switchboard_switchboard_app_opened_directly = FALSE;
		_tmp3_ = self->priv->deck;
		hdy_deck_set_transition_duration (_tmp3_, (guint) 200);
	}
	_tmp4_ = self->priv->deck;
	hdy_deck_navigate (_tmp4_, HDY_NAVIGATION_DIRECTION_BACK);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
switchboard_switchboard_app_load_setting_path (SwitchboardSwitchboardApp* self,
                                               const gchar* setting_path,
                                               SwitchboardPlugsManager* plugsmanager)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (setting_path != NULL, FALSE);
	g_return_val_if_fail (plugsmanager != NULL, FALSE);
	{
		GeeIterator* _plug_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = switchboard_plugs_manager_get_plugs (plugsmanager);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_plug_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			SwitchboardPlug* plug = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeTreeMap* supported_settings = NULL;
			SwitchboardPlug* _tmp7_;
			GeeTreeMap* _tmp8_;
			GeeTreeMap* _tmp9_;
			GeeTreeMap* _tmp10_;
			GeeTreeMap* _tmp11_;
			GeeTreeMap* _tmp12_;
			_tmp4_ = _plug_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _plug_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			plug = (SwitchboardPlug*) _tmp6_;
			_tmp7_ = plug;
			_tmp8_ = switchboard_plug_get_supported_settings (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			supported_settings = _tmp10_;
			_tmp11_ = supported_settings;
			if (_tmp11_ == NULL) {
				_g_object_unref0 (supported_settings);
				_g_object_unref0 (plug);
				continue;
			}
			_tmp12_ = supported_settings;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, setting_path)) {
				SwitchboardPlug* _tmp13_;
				GeeTreeMap* _tmp14_;
				gpointer _tmp15_;
				_tmp13_ = plug;
				switchboard_switchboard_app_load_plug (self, _tmp13_);
				_tmp14_ = supported_settings;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, setting_path);
				_g_free0 (switchboard_switchboard_app_open_window);
				switchboard_switchboard_app_open_window = (gchar*) _tmp15_;
				result = TRUE;
				_g_object_unref0 (supported_settings);
				_g_object_unref0 (plug);
				_g_object_unref0 (_plug_it);
				return result;
			}
			_g_object_unref0 (supported_settings);
			_g_object_unref0 (plug);
		}
		_g_object_unref0 (_plug_it);
	}
	if (string_contains (setting_path, "/")) {
		gint last_index = 0;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_;
		last_index = string_last_index_of_char (setting_path, (gunichar) '/', 0);
		_tmp16_ = string_substring (setting_path, (glong) 0, (glong) last_index);
		_tmp17_ = _tmp16_;
		_tmp18_ = switchboard_switchboard_app_load_setting_path (self, _tmp17_, plugsmanager);
		_g_free0 (_tmp17_);
		result = _tmp18_;
		return result;
	}
	result = FALSE;
	return result;
}

SwitchboardSwitchboardApp*
switchboard_switchboard_app_construct (GType object_type)
{
	SwitchboardSwitchboardApp * self = NULL;
	self = (SwitchboardSwitchboardApp*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardSwitchboardApp*
switchboard_switchboard_app_new (void)
{
	return switchboard_switchboard_app_construct (SWITCHBOARD_TYPE_SWITCHBOARD_APP);
}

GtkSearchEntry*
switchboard_switchboard_app_get_search_box (SwitchboardSwitchboardApp* self)
{
	GtkSearchEntry* result;
	GtkSearchEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_box;
	result = _tmp0_;
	return result;
}

static void
switchboard_switchboard_app_set_search_box (SwitchboardSwitchboardApp* self,
                                            GtkSearchEntry* value)
{
	GtkSearchEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_switchboard_app_get_search_box (self);
	if (old_value != value) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_box);
		self->priv->_search_box = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_switchboard_app_properties[SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY]);
	}
}

static GObject *
switchboard_switchboard_app_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardSwitchboardApp * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	GAppInfo* _tmp2_;
	GAppInfo* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (switchboard_switchboard_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	g_application_set_application_id ((GApplication*) self, "io.elementary.switchboard");
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_OPEN);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp2_ = g_app_info_get_default_for_uri_scheme ("settings");
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GDesktopAppInfo* appinfo = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		_tmp5_ = g_application_get_application_id ((GApplication*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, ".desktop", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_desktop_app_info_new (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		appinfo = _tmp10_;
		{
			GDesktopAppInfo* _tmp11_;
			_tmp11_ = appinfo;
			g_app_info_set_as_default_for_type ((GAppInfo*) _tmp11_, "x-scheme-handler/settings", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_critical ("Application.vala:60: Unable to set default for the settings scheme: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_g_object_unref0 (appinfo);
	}
	return obj;
}

static void
switchboard_switchboard_app_class_init (SwitchboardSwitchboardAppClass * klass,
                                        gpointer klass_data)
{
	switchboard_switchboard_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardSwitchboardApp_private_offset);
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) switchboard_switchboard_app_real_open;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) switchboard_switchboard_app_real_activate;
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_switchboard_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_switchboard_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_switchboard_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_switchboard_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY, switchboard_switchboard_app_properties[SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY] = g_param_spec_object ("search-box", "search-box", "search-box", gtk_search_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
switchboard_switchboard_app_instance_init (SwitchboardSwitchboardApp * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = switchboard_switchboard_app_get_instance_private (self);
	_tmp0_ = g_strdup (N_ ("All Settings"));
	self->priv->all_settings_label = _tmp0_;
}

static void
switchboard_switchboard_app_finalize (GObject * obj)
{
	SwitchboardSwitchboardApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	_g_object_unref0 (self->priv->_search_box);
	_g_free0 (self->priv->all_settings_label);
	_g_hash_table_unref0 (self->priv->plug_widgets);
	_g_object_unref0 (self->priv->navigation_button);
	_g_object_unref0 (self->priv->deck);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->category_view);
	G_OBJECT_CLASS (switchboard_switchboard_app_parent_class)->finalize (obj);
}

static GType
switchboard_switchboard_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardSwitchboardAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_switchboard_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardSwitchboardApp), 0, (GInstanceInitFunc) switchboard_switchboard_app_instance_init, NULL };
	GType switchboard_switchboard_app_type_id;
	switchboard_switchboard_app_type_id = g_type_register_static (gtk_application_get_type (), "SwitchboardSwitchboardApp", &g_define_type_info, 0);
	SwitchboardSwitchboardApp_private_offset = g_type_add_instance_private (switchboard_switchboard_app_type_id, sizeof (SwitchboardSwitchboardAppPrivate));
	return switchboard_switchboard_app_type_id;
}

GType
switchboard_switchboard_app_get_type (void)
{
	static volatile gsize switchboard_switchboard_app_type_id__once = 0;
	if (g_once_init_enter (&switchboard_switchboard_app_type_id__once)) {
		GType switchboard_switchboard_app_type_id;
		switchboard_switchboard_app_type_id = switchboard_switchboard_app_get_type_once ();
		g_once_init_leave (&switchboard_switchboard_app_type_id__once, switchboard_switchboard_app_type_id);
	}
	return switchboard_switchboard_app_type_id__once;
}

static void
_vala_switchboard_switchboard_app_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SwitchboardSwitchboardApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	switch (property_id) {
		case SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY:
		g_value_set_object (value, switchboard_switchboard_app_get_search_box (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_switchboard_app_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SwitchboardSwitchboardApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	switch (property_id) {
		case SWITCHBOARD_SWITCHBOARD_APP_SEARCH_BOX_PROPERTY:
		switchboard_switchboard_app_set_search_box (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

