/* PlugsManager.c generated by valac 0.56.17, the Vala compiler
 * generated from PlugsManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2012-2014 Switchboard Developers (http://launchpad.net/switchboard)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "switchboard.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUGS_MANAGER_0_PROPERTY,
	SWITCHBOARD_PLUGS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* switchboard_plugs_manager_properties[SWITCHBOARD_PLUGS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef SwitchboardPlug* (*SwitchboardPlugsManagerRegisterPluginFunction) (GModule* module);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SWITCHBOARD_PLUGS_MANAGER_PLUG_ADDED_SIGNAL,
	SWITCHBOARD_PLUGS_MANAGER_NUM_SIGNALS
};
static guint switchboard_plugs_manager_signals[SWITCHBOARD_PLUGS_MANAGER_NUM_SIGNALS] = {0};

struct _SwitchboardPlugsManagerPrivate {
	GeeLinkedList* plugs;
};

static gint SwitchboardPlugsManager_private_offset;
static gpointer switchboard_plugs_manager_parent_class = NULL;
static SwitchboardPlugsManager* switchboard_plugs_manager_plugs_manager;
static SwitchboardPlugsManager* switchboard_plugs_manager_plugs_manager = NULL;

static SwitchboardPlugsManager* switchboard_plugs_manager_new (void);
static SwitchboardPlugsManager* switchboard_plugs_manager_construct (GType object_type);
static void switchboard_plugs_manager_find_plugins (SwitchboardPlugsManager* self,
                                             GFile* base_folder);
static void switchboard_plugs_manager_load (SwitchboardPlugsManager* self,
                                     const gchar* path);
static void switchboard_plugs_manager_register_plug (SwitchboardPlugsManager* self,
                                              SwitchboardPlug* plug);
static void switchboard_plugs_manager_finalize (GObject * obj);
static GType switchboard_plugs_manager_get_type_once (void);

static inline gpointer
switchboard_plugs_manager_get_instance_private (SwitchboardPlugsManager* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugsManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SwitchboardPlugsManager*
switchboard_plugs_manager_get_default (void)
{
	SwitchboardPlugsManager* _tmp0_;
	SwitchboardPlugsManager* _tmp2_;
	SwitchboardPlugsManager* _tmp3_;
	SwitchboardPlugsManager* result;
	_tmp0_ = switchboard_plugs_manager_plugs_manager;
	if (_tmp0_ == NULL) {
		SwitchboardPlugsManager* _tmp1_;
		_tmp1_ = switchboard_plugs_manager_new ();
		_g_object_unref0 (switchboard_plugs_manager_plugs_manager);
		switchboard_plugs_manager_plugs_manager = _tmp1_;
	}
	_tmp2_ = switchboard_plugs_manager_plugs_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static SwitchboardPlugsManager*
switchboard_plugs_manager_construct (GType object_type)
{
	SwitchboardPlugsManager * self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* base_folder = NULL;
	GFile* _tmp1_;
	self = (SwitchboardPlugsManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (SWITCHBOARD_TYPE_PLUG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->plugs);
	self->priv->plugs = _tmp0_;
	_tmp1_ = g_file_new_for_path (PLUGS_DIR);
	base_folder = _tmp1_;
	switchboard_plugs_manager_find_plugins (self, base_folder);
	_g_object_unref0 (base_folder);
	return self;
}

static SwitchboardPlugsManager*
switchboard_plugs_manager_new (void)
{
	return switchboard_plugs_manager_construct (SWITCHBOARD_TYPE_PLUGS_MANAGER);
}

static void
switchboard_plugs_manager_load (SwitchboardPlugsManager* self,
                                const gchar* path)
{
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* function = NULL;
	GModule* _tmp3_;
	void* _tmp4_ = NULL;
	void* _tmp5_;
	SwitchboardPlugsManagerRegisterPluginFunction register_plugin = NULL;
	void* _tmp6_;
	SwitchboardPlug* plug = NULL;
	SwitchboardPlugsManagerRegisterPluginFunction _tmp7_;
	GModule* _tmp8_;
	SwitchboardPlug* _tmp9_;
	SwitchboardPlug* _tmp10_;
	GModule* _tmp11_;
	SwitchboardPlug* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (g_module_supported () == FALSE) {
		g_error ("PlugsManager.vala:45: Switchboard is not supported by this system!");
	}
	_tmp0_ = g_module_open (path, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = g_module_error ();
		g_critical ("PlugsManager.vala:50: %s", _tmp2_);
		_g_module_close0 (module);
		return;
	}
	_tmp3_ = module;
	g_module_symbol (_tmp3_, "get_plug", &_tmp4_);
	function = _tmp4_;
	_tmp5_ = function;
	if (_tmp5_ == NULL) {
		g_critical ("PlugsManager.vala:57: get_plug () not found in %s", path);
		_g_module_close0 (module);
		return;
	}
	_tmp6_ = function;
	register_plugin = (SwitchboardPlugsManagerRegisterPluginFunction) _tmp6_;
	_tmp7_ = register_plugin;
	_tmp8_ = module;
	_tmp9_ = _tmp7_ (_tmp8_);
	plug = _tmp9_;
	_tmp10_ = plug;
	if (_tmp10_ == NULL) {
		g_critical ("PlugsManager.vala:64: Unknown plugin type for %s !", path);
		_g_object_unref0 (plug);
		_g_module_close0 (module);
		return;
	}
	_tmp11_ = module;
	g_module_make_resident (_tmp11_);
	_tmp12_ = plug;
	switchboard_plugs_manager_register_plug (self, _tmp12_);
	_g_object_unref0 (plug);
	_g_module_close0 (module);
}

static void
switchboard_plugs_manager_find_plugins (SwitchboardPlugsManager* self,
                                        GFile* base_folder)
{
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_folder != NULL);
	file_info = NULL;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (base_folder, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* file = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GFileInfo* _tmp10_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_file_get_child (base_folder, _tmp7_);
			file = _tmp8_;
			_tmp10_ = file_info;
			if (g_file_info_get_file_type (_tmp10_) == G_FILE_TYPE_REGULAR) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp9_ = g_content_type_equals (_tmp12_, "application/x-sharedlib");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* path = NULL;
				GFile* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = file;
				_tmp14_ = g_file_get_path (_tmp13_);
				path = _tmp14_;
				_tmp15_ = path;
				if (g_str_has_suffix (_tmp15_, G_MODULE_SUFFIX)) {
					const gchar* _tmp16_;
					_tmp16_ = path;
					switchboard_plugs_manager_load (self, _tmp16_);
				}
				_g_free0 (path);
			} else {
				GFileInfo* _tmp17_;
				_tmp17_ = file_info;
				if (g_file_info_get_file_type (_tmp17_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp18_;
					_tmp18_ = file;
					switchboard_plugs_manager_find_plugins (self, _tmp18_);
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = g_file_get_path (base_folder);
		_tmp20_ = _tmp19_;
		_tmp21_ = err;
		_tmp22_ = _tmp21_->message;
		g_warning ("PlugsManager.vala:88: Unable to scan plugs folder %s: %s\n", _tmp20_, _tmp22_);
		_g_free0 (_tmp20_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_info);
}

static void
switchboard_plugs_manager_register_plug (SwitchboardPlugsManager* self,
                                         SwitchboardPlug* plug)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plug != NULL);
	_tmp0_ = switchboard_plug_get_code_name (plug);
	_tmp1_ = _tmp0_;
	g_debug ("PlugsManager.vala:93: %s registered", _tmp1_);
	_tmp2_ = self->priv->plugs;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, plug)) {
		return;
	}
	_tmp3_ = self->priv->plugs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, plug);
	g_signal_emit (self, switchboard_plugs_manager_signals[SWITCHBOARD_PLUGS_MANAGER_PLUG_ADDED_SIGNAL], 0, plug);
}

gboolean
switchboard_plugs_manager_has_plugs (SwitchboardPlugsManager* self)
{
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->plugs;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}

GeeCollection*
switchboard_plugs_manager_get_plugs (SwitchboardPlugsManager* self)
{
	GeeLinkedList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->plugs;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeCollection*) _tmp2_;
	return result;
}

static void
switchboard_plugs_manager_class_init (SwitchboardPlugsManagerClass * klass,
                                      gpointer klass_data)
{
	switchboard_plugs_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugsManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = switchboard_plugs_manager_finalize;
	switchboard_plugs_manager_signals[SWITCHBOARD_PLUGS_MANAGER_PLUG_ADDED_SIGNAL] = g_signal_new ("plug-added", SWITCHBOARD_TYPE_PLUGS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SWITCHBOARD_TYPE_PLUG);
}

static void
switchboard_plugs_manager_instance_init (SwitchboardPlugsManager * self,
                                         gpointer klass)
{
	self->priv = switchboard_plugs_manager_get_instance_private (self);
}

static void
switchboard_plugs_manager_finalize (GObject * obj)
{
	SwitchboardPlugsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_PLUGS_MANAGER, SwitchboardPlugsManager);
	_g_object_unref0 (self->priv->plugs);
	G_OBJECT_CLASS (switchboard_plugs_manager_parent_class)->finalize (obj);
}

static GType
switchboard_plugs_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plugs_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugsManager), 0, (GInstanceInitFunc) switchboard_plugs_manager_instance_init, NULL };
	GType switchboard_plugs_manager_type_id;
	switchboard_plugs_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugsManager", &g_define_type_info, 0);
	SwitchboardPlugsManager_private_offset = g_type_add_instance_private (switchboard_plugs_manager_type_id, sizeof (SwitchboardPlugsManagerPrivate));
	return switchboard_plugs_manager_type_id;
}

GType
switchboard_plugs_manager_get_type (void)
{
	static volatile gsize switchboard_plugs_manager_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plugs_manager_type_id__once)) {
		GType switchboard_plugs_manager_type_id;
		switchboard_plugs_manager_type_id = switchboard_plugs_manager_get_type_once ();
		g_once_init_leave (&switchboard_plugs_manager_type_id__once, switchboard_plugs_manager_type_id);
	}
	return switchboard_plugs_manager_type_id__once;
}

