/* window.c generated by valac 0.56.16, the Vala compiler
 * generated from window.vala, do not modify */

/*
   This file is part of Swell-Foop.

   Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
   Copyright (C) 2023 Ben Corby

   Swell-Foop is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   Swell-Foop is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Swell-Foop.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SWELL_FOOP_WINDOW (swell_foop_window_get_type ())
#define SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow))
#define SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))
#define IS_SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWELL_FOOP_WINDOW))
#define IS_SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWELL_FOOP_WINDOW))
#define SWELL_FOOP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))

typedef struct _SwellFoopWindow SwellFoopWindow;
typedef struct _SwellFoopWindowClass SwellFoopWindowClass;
typedef struct _SwellFoopWindowPrivate SwellFoopWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
enum  {
	SWELL_FOOP_WINDOW_0_PROPERTY,
	SWELL_FOOP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* swell_foop_window_properties[SWELL_FOOP_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SWELL_FOOP_WINDOW_TYPE_SIZE (swell_foop_window_size_get_type ())
typedef struct _SwellFoopWindowSize SwellFoopWindowSize;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SwellFoopWindow {
	GtkApplicationWindow parent_instance;
	SwellFoopWindowPrivate * priv;
	GtkMenuButton* hamburger_button;
};

struct _SwellFoopWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _SwellFoopWindowPrivate {
	GtkOverlay* overlay;
	GtkStack* stack;
	GtkLabel* current_score_label;
	GtkRevealer* score_revealer;
	GtkAspectFrame* aspect_frame;
	GtkLabel* score_label;
	GtkLabel* to_high_score_label;
	GtkBox* game_over_box;
	GSettings* settings;
	Game* game;
	GameView* view;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GamesScoresContext* scores_context;
};

struct _SwellFoopWindowSize {
	gchar* id;
	gchar* name;
	guint8 columns;
	guint8 rows;
};

struct _Block2Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GtkBox* box;
};

struct _Block3Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GamesScoresCategory* category;
};

struct _Block4Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GtkAlertDialog* dialog;
};

static gint SwellFoopWindow_private_offset;
static gpointer swell_foop_window_parent_class = NULL;
static SwellFoopWindowSize* swell_foop_window_sizes;
static gint swell_foop_window_sizes_length1;
static SwellFoopWindowSize* swell_foop_window_sizes = NULL;
static gint swell_foop_window_sizes_length1 = 0;
static gint _swell_foop_window_sizes_size_ = 0;
static GHashTable* swell_foop_window_score_categories;
static GHashTable* swell_foop_window_score_categories = NULL;

VALA_EXTERN GType swell_foop_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwellFoopWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static inline void swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                        GSimpleAction* action,
                                        GVariant* variant);
static void _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self);
static inline void swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                         GSimpleAction* action,
                                         GVariant* variant);
static void _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                               GVariant* value,
                                                                               gpointer self);
static inline void swell_foop_window_new_game_cb (SwellFoopWindow* self);
static void _swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static inline void swell_foop_window_scores_cb (SwellFoopWindow* self);
static void _swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static inline void swell_foop_window_toggle_hamburger (SwellFoopWindow* self);
static void _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static inline void swell_foop_window_undo (SwellFoopWindow* self);
static void _swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static inline void swell_foop_window_redo (SwellFoopWindow* self);
static void _swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static GType swell_foop_window_size_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SwellFoopWindowSize* swell_foop_window_size_dup (const SwellFoopWindowSize* self);
static void swell_foop_window_size_free (SwellFoopWindowSize* self);
static void swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                                  SwellFoopWindowSize* dest);
static void swell_foop_window_size_destroy (SwellFoopWindowSize* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwellFoopWindowSize, swell_foop_window_size_destroy)
static inline void swell_foop_window_class_init_sizes (void);
static void _vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                           gssize array_length);
VALA_EXTERN SwellFoopWindow* swell_foop_window_new (GtkApplication* application);
VALA_EXTERN SwellFoopWindow* swell_foop_window_construct (GType object_type,
                                              GtkApplication* application);
static void swell_foop_window_new_game (SwellFoopWindow* self,
                                 GVariant* saved_game);
static inline GtkBox* swell_foop_window_build_first_run_view (SwellFoopWindow* self);
static void __lambda18_ (SwellFoopWindow* self);
static void ___lambda18__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static inline GtkBox* swell_foop_window_build_game_over_view (SwellFoopWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void swell_foop_window_update_score_cb (SwellFoopWindow* self);
VALA_EXTERN guint game_get_score (Game* self);
static void swell_foop_window_complete_cb (SwellFoopWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void swell_foop_window_get_board_size (SwellFoopWindow* self,
                                       SwellFoopWindowSize* result);
VALA_EXTERN guint8 game_get_color_num (Game* self);
static gboolean __lambda16_ (Block3Data* _data3_);
static inline void swell_foop_window_add_score (SwellFoopWindow* self,
                                  GamesScoresCategory* category);
static gboolean ___lambda16__gsource_func (gpointer self);
static inline void swell_foop_window_started_cb (SwellFoopWindow* self);
VALA_EXTERN Game* game_new (guint8 rows,
                guint8 columns,
                guint8 color_num,
                GameView* view,
                GVariant* saved_game);
VALA_EXTERN Game* game_construct (GType object_type,
                      guint8 rows,
                      guint8 columns,
                      guint8 color_num,
                      GameView* view,
                      GVariant* saved_game);
static void _swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                           gint points_awarded,
                                                           gpointer self);
static void _swell_foop_window_complete_cb_game_complete (Game* _sender,
                                                   gpointer self);
static void _swell_foop_window_started_cb_game_started (Game* _sender,
                                                 gpointer self);
VALA_EXTERN void game_view_set_theme_name (GameView* self,
                               const gchar* theme_name);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* game);
VALA_EXTERN gboolean game_get_is_started (Game* self);
static inline void swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda15_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_redo (Game* self);
static inline void swell_foop_window_class_init_scores (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static inline void swell_foop_window_init_scores (SwellFoopWindow* self);
static inline GamesScoresCategory* swell_foop_window_category_request (SwellFoopWindow* self,
                                                         const gchar* key);
static GamesScoresCategory* _swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                     gpointer self);
static inline void swell_foop_window_parse_old_score (SwellFoopWindow* self,
                                        const gchar* line,
                                        GamesScoresScore** score,
                                        GamesScoresCategory** category);
static void _swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                                 GamesScoresScore** score,
                                                                                                 GamesScoresCategory** category,
                                                                                                 gpointer self);
static void __lambda17_ (SwellFoopWindow* self,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GObject * swell_foop_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _swell_foop_window___lambda20_ (SwellFoopWindow* self);
static void __swell_foop_window___lambda20__gtk_popover_closed (GtkPopover* _sender,
                                                         gpointer self);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static gboolean _swell_foop_window___lambda21_ (SwellFoopWindow* self);
VALA_EXTERN GVariant* game_get_saved_game (Game* self);
VALA_EXTERN guint8 game_get_rows (Game* self);
VALA_EXTERN guint8 game_get_columns (Game* self);
static gboolean __swell_foop_window___lambda21__gtk_window_close_request (GtkWindow* _sender,
                                                                   gpointer self);
static void swell_foop_window_finalize (GObject * obj);
static GType swell_foop_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry SWELL_FOOP_WINDOW_win_actions[7] = {{"change-theme", NULL, "s", "'shapesandcolors'", _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback}, {"change-colors", NULL, "s", "'3'", _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback}, {"new-game", _swell_foop_window_new_game_cb_gsimple_action_activate_callback}, {"scores", _swell_foop_window_scores_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback}, {"undo", _swell_foop_window_undo_gsimple_action_activate_callback}, {"redo", _swell_foop_window_redo_gsimple_action_activate_callback}};

static inline gpointer
swell_foop_window_get_instance_private (SwellFoopWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SwellFoopWindow_private_offset);
}

static void
_swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self)
{
	swell_foop_window_change_theme_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self)
{
	swell_foop_window_change_colors_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	swell_foop_window_new_game_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	swell_foop_window_scores_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	swell_foop_window_toggle_hamburger ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_undo ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_redo ((SwellFoopWindow*) self);
}

static void
_vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                      gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			swell_foop_window_size_destroy (&array[i]);
		}
	}
	g_free (array);
}

static inline void
swell_foop_window_class_init_sizes (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	SwellFoopWindowSize _tmp5_ = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	SwellFoopWindowSize _tmp8_ = {0};
	SwellFoopWindowSize* _tmp9_;
	_tmp0_ = g_strdup ("small");
	_tmp1_ = g_strdup (_ ("Small"));
	memset (&_tmp2_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp2_.id);
	_tmp2_.id = _tmp0_;
	_g_free0 (_tmp2_.name);
	_tmp2_.name = _tmp1_;
	_tmp2_.columns = (guint8) 6;
	_tmp2_.rows = (guint8) 5;
	_tmp3_ = g_strdup ("normal");
	_tmp4_ = g_strdup (_ ("Normal"));
	memset (&_tmp5_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp5_.id);
	_tmp5_.id = _tmp3_;
	_g_free0 (_tmp5_.name);
	_tmp5_.name = _tmp4_;
	_tmp5_.columns = (guint8) 15;
	_tmp5_.rows = (guint8) 10;
	_tmp6_ = g_strdup ("large");
	_tmp7_ = g_strdup (_ ("Large"));
	memset (&_tmp8_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp8_.id);
	_tmp8_.id = _tmp6_;
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _tmp7_;
	_tmp8_.columns = (guint8) 20;
	_tmp8_.rows = (guint8) 15;
	_tmp9_ = g_new0 (SwellFoopWindowSize, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	swell_foop_window_sizes = (_vala_SwellFoopWindowSize_array_free (swell_foop_window_sizes, swell_foop_window_sizes_length1), NULL);
	swell_foop_window_sizes = _tmp9_;
	swell_foop_window_sizes_length1 = 3;
	_swell_foop_window_sizes_size_ = swell_foop_window_sizes_length1;
}

SwellFoopWindow*
swell_foop_window_construct (GType object_type,
                             GtkApplication* application)
{
	SwellFoopWindow * self = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (SwellFoopWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "saved-game");
	_tmp2_ = _tmp1_;
	swell_foop_window_new_game (self, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	return self;
}

SwellFoopWindow*
swell_foop_window_new (GtkApplication* application)
{
	return swell_foop_window_construct (TYPE_SWELL_FOOP_WINDOW, application);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda18_ (SwellFoopWindow* self)
{
	GtkStack* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "game");
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "first-run", FALSE);
}

static void
___lambda18__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda18_ ((SwellFoopWindow*) self);
}

static inline GtkBox*
swell_foop_window_build_first_run_view (SwellFoopWindow* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkBox* box = NULL;
	GObject* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* tip_label = NULL;
	GObject* _tmp3_;
	GtkLabel* _tmp4_;
	GtkButton* play_button = NULL;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/SwellFoop/ui/first-run.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "first_run_box");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_box_get_type (), GtkBox));
	box = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "tip_label");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
	tip_label = _tmp4_;
	gtk_label_set_label (tip_label, _ ("Clear as many blocks as you can.\nFewer clicks means more points."));
	_tmp5_ = gtk_builder_get_object (builder, "play_button");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	play_button = _tmp6_;
	g_signal_connect_object (play_button, "clicked", (GCallback) ___lambda18__gtk_button_clicked, self, 0);
	result = box;
	_g_object_unref0 (play_button);
	_g_object_unref0 (tip_label);
	_g_object_unref0 (builder);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->box);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda19_ (Block2Data* _data2_)
{
	SwellFoopWindow* self;
	self = _data2_->self;
	gtk_widget_set_visible ((GtkWidget*) _data2_->box, FALSE);
}

static void
___lambda19__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda19_ (self);
}

static inline GtkBox*
swell_foop_window_build_game_over_view (SwellFoopWindow* self)
{
	Block2Data* _data2_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkBox* _tmp2_;
	GObject* _tmp3_;
	GtkLabel* _tmp4_;
	GObject* _tmp5_;
	GtkLabel* _tmp6_;
	GtkButton* play_button = NULL;
	GObject* _tmp7_;
	GtkButton* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/SwellFoop/ui/game-over.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "game_over");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_box_get_type (), GtkBox));
	_data2_->box = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "score_label");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->score_label);
	self->priv->score_label = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "to_high_score_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->to_high_score_label);
	self->priv->to_high_score_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "play_button");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton));
	play_button = _tmp8_;
	g_signal_connect_data (play_button, "clicked", (GCallback) ___lambda19__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp9_ = _g_object_ref0 (_data2_->box);
	result = _tmp9_;
	_g_object_unref0 (play_button);
	_g_object_unref0 (builder);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
swell_foop_window_update_score_cb (SwellFoopWindow* self)
{
	guint score = 0U;
	Game* _tmp0_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	score = (guint) 0;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = game_get_score (_tmp1_);
		_tmp3_ = _tmp2_;
		score = _tmp3_;
	}
	_tmp4_ = self->priv->current_score_label;
	_tmp5_ = g_strdup_printf ("%u", score);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->category);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
__lambda16_ (Block3Data* _data3_)
{
	SwellFoopWindow* self;
	gboolean result;
	self = _data3_->self;
	swell_foop_window_add_score (self, _data3_->category);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ (self);
	return result;
}

static void
swell_foop_window_complete_cb (SwellFoopWindow* self)
{
	Block3Data* _data3_;
	GSimpleAction* _tmp0_;
	gchar* id = NULL;
	SwellFoopWindowSize _tmp1_ = {0};
	SwellFoopWindowSize _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Game* _tmp5_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	GamesScoresCategory* _tmp14_;
	GtkLabel* _tmp15_;
	Game* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp21_;
	GeeList* _tmp22_;
	glong _tmp23_ = 0L;
	GeeList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	glong lowest_high_score = 0L;
	gboolean _tmp32_ = FALSE;
	GtkBox* _tmp40_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	swell_foop_window_get_board_size (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_color_num (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%hhu", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp4_, "-", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	swell_foop_window_size_destroy (&_tmp2_);
	id = _tmp11_;
	_tmp12_ = swell_foop_window_score_categories;
	_tmp13_ = g_hash_table_lookup (_tmp12_, id);
	_tmp14_ = _g_object_ref0 ((GamesScoresCategory*) _tmp13_);
	_data3_->category = _tmp14_;
	if (_data3_->category == NULL) {
		g_assert_not_reached ();
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	_tmp15_ = self->priv->score_label;
	_tmp16_ = self->priv->game;
	_tmp17_ = game_get_score (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf (_ ("%u Points"), _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_label_set_label (_tmp15_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->scores_context;
	_tmp22_ = games_scores_context_get_high_scores (_tmp21_, _data3_->category, 10);
	scores = _tmp22_;
	_tmp24_ = scores;
	_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == 10) {
		GeeList* _tmp27_;
		gpointer _tmp28_;
		GamesScoresScore* _tmp29_;
		glong _tmp30_;
		glong _tmp31_;
		_tmp27_ = scores;
		_tmp28_ = gee_list_last (_tmp27_);
		_tmp29_ = (GamesScoresScore*) _tmp28_;
		_tmp30_ = games_scores_score_get_score (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp23_ = _tmp31_;
		_g_object_unref0 (_tmp29_);
	} else {
		_tmp23_ = (glong) -1;
	}
	lowest_high_score = _tmp23_;
	if (lowest_high_score != ((glong) -1)) {
		Game* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		_tmp33_ = self->priv->game;
		_tmp34_ = game_get_score (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp32_ = lowest_high_score > ((glong) _tmp35_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GtkLabel* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp36_ = self->priv->to_high_score_label;
		_tmp37_ = g_strdup_printf (_ ("%u points to reach the leaderboard"), (guint) lowest_high_score);
		_tmp38_ = _tmp37_;
		gtk_label_set_label (_tmp36_, _tmp38_);
		_g_free0 (_tmp38_);
	} else {
		GtkLabel* _tmp39_;
		_tmp39_ = self->priv->to_high_score_label;
		gtk_label_set_label (_tmp39_, "");
	}
	_tmp40_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp40_, TRUE);
	_g_object_unref0 (scores);
	_g_free0 (id);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static inline void
swell_foop_window_started_cb (SwellFoopWindow* self)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_score_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
}

static void
swell_foop_window_get_board_size (SwellFoopWindow* self,
                                  SwellFoopWindowSize* result)
{
	gchar* current_size = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize* _tmp13_;
	gint _tmp13__length1;
	SwellFoopWindowSize _tmp14_;
	SwellFoopWindowSize _tmp15_;
	SwellFoopWindowSize _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "size");
	current_size = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp4_;
				gint _tmp4__length1;
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				SwellFoopWindowSize _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = swell_foop_window_sizes;
				_tmp4__length1 = swell_foop_window_sizes_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = _tmp6_.id;
				_tmp8_ = current_size;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					SwellFoopWindowSize* _tmp9_;
					gint _tmp9__length1;
					SwellFoopWindowSize _tmp10_;
					SwellFoopWindowSize _tmp11_;
					SwellFoopWindowSize _tmp12_ = {0};
					_tmp9_ = swell_foop_window_sizes;
					_tmp9__length1 = swell_foop_window_sizes_length1;
					_tmp10_ = _tmp9_[i];
					_tmp11_ = _tmp10_;
					swell_foop_window_size_copy (&_tmp11_, &_tmp12_);
					*result = _tmp12_;
					_g_free0 (current_size);
					return;
				}
			}
		}
	}
	_tmp13_ = swell_foop_window_sizes;
	_tmp13__length1 = swell_foop_window_sizes_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = _tmp14_;
	swell_foop_window_size_copy (&_tmp15_, &_tmp16_);
	*result = _tmp16_;
	_g_free0 (current_size);
	return;
}

static void
_swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                      gint points_awarded,
                                                      gpointer self)
{
	swell_foop_window_update_score_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_complete_cb_game_complete (Game* _sender,
                                              gpointer self)
{
	swell_foop_window_complete_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_started_cb_game_started (Game* _sender,
                                            gpointer self)
{
	swell_foop_window_started_cb ((SwellFoopWindow*) self);
}

static void
swell_foop_window_new_game (SwellFoopWindow* self,
                            GVariant* saved_game)
{
	SwellFoopWindowSize size = {0};
	SwellFoopWindowSize _tmp0_ = {0};
	GtkAspectFrame* _tmp1_;
	SwellFoopWindowSize _tmp2_;
	SwellFoopWindowSize _tmp3_;
	SwellFoopWindowSize _tmp4_;
	SwellFoopWindowSize _tmp5_;
	GSettings* _tmp6_;
	GameView* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	GtkRevealer* _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	GameView* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GameView* _tmp18_;
	Game* _tmp19_;
	GtkBox* _tmp20_;
	GAction* _tmp21_;
	GSimpleAction* _tmp22_;
	Game* _tmp23_;
	GSimpleAction* _tmp24_;
	GAction* _tmp25_;
	GSimpleAction* _tmp26_;
	Game* _tmp27_;
	GSimpleAction* _tmp28_;
	GameView* _tmp29_;
	g_return_if_fail (self != NULL);
	swell_foop_window_get_board_size (self, &_tmp0_);
	size = _tmp0_;
	_tmp1_ = self->priv->aspect_frame;
	_tmp2_ = size;
	_tmp3_ = size;
	gtk_aspect_frame_set_ratio (_tmp1_, ((gfloat) _tmp2_.columns) / _tmp3_.rows);
	_tmp4_ = size;
	_tmp5_ = size;
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->view;
	_tmp8_ = game_new (_tmp4_.rows, _tmp5_.columns, (guint8) g_settings_get_int (_tmp6_, "colors"), _tmp7_, saved_game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp8_;
	_tmp9_ = self->priv->game;
	_tmp10_ = self->priv->score_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "is-started", (GObject*) _tmp10_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	swell_foop_window_update_score_cb (self);
	_tmp11_ = self->priv->game;
	g_signal_connect_object (_tmp11_, "update-score", (GCallback) _swell_foop_window_update_score_cb_game_update_score, self, 0);
	_tmp12_ = self->priv->game;
	g_signal_connect_object (_tmp12_, "complete", (GCallback) _swell_foop_window_complete_cb_game_complete, self, 0);
	_tmp13_ = self->priv->game;
	g_signal_connect_object (_tmp13_, "started", (GCallback) _swell_foop_window_started_cb_game_started, self, 0);
	_tmp14_ = self->priv->view;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "theme");
	_tmp17_ = _tmp16_;
	game_view_set_theme_name (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->view;
	_tmp19_ = self->priv->game;
	game_view_set_game (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_GAME, Game));
	_tmp20_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp22_;
	_tmp23_ = self->priv->game;
	_tmp24_ = self->priv->undo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp23_, "can-undo", (GObject*) _tmp24_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp25_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp26_;
	_tmp27_ = self->priv->game;
	_tmp28_ = self->priv->redo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp27_, "can-redo", (GObject*) _tmp28_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp29_ = self->priv->view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp29_);
	swell_foop_window_size_destroy (&size);
}

static inline void
swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                   GSimpleAction* action,
                                   GVariant* variant)
{
	gchar* new_theme = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GameView* _tmp2_;
	const gchar* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	new_theme = _tmp1_;
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp2_ = self->priv->view;
	_tmp3_ = new_theme;
	game_view_set_theme_name (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "theme");
	_tmp6_ = _tmp5_;
	_tmp7_ = new_theme;
	_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	_g_free0 (_tmp6_);
	if (_tmp8_) {
		GSettings* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->settings;
		_tmp10_ = new_theme;
		g_settings_set_string (_tmp9_, "theme", _tmp10_);
	}
	_g_free0 (new_theme);
}

static inline void
swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                    GSimpleAction* action,
                                    GVariant* variant)
{
	gint32 new_colors = 0;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	new_colors = (gint32) atoi (_tmp0_);
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp1_ = self->priv->settings;
	if (g_settings_get_int (_tmp1_, "colors") != ((gint) new_colors)) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "colors", (gint) new_colors);
	}
}

static inline void
swell_foop_window_scores_cb (SwellFoopWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp0_);
}

static inline void
swell_foop_window_new_game_cb (SwellFoopWindow* self)
{
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_is_started (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		swell_foop_window_show_new_game_confirmation_dialog (self);
	} else {
		swell_foop_window_new_game (self, NULL);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda15_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	SwellFoopWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		gint _result_ = 0;
		_result_ = gtk_alert_dialog_choose_finish (_data4_->dialog, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_result_ == 1) {
			swell_foop_window_new_game (self, NULL);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("window.vala:369: Failed to get result of warning dialog: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block4_data_unref (self);
}

static inline void
swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self)
{
	Block4Data* _data4_;
	GtkAlertDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = gtk_alert_dialog_new ("%s", _ ("Abandon this game to start a new one?"));
	_data4_->dialog = _tmp0_;
	gtk_alert_dialog_set_modal (_data4_->dialog, TRUE);
	_tmp1_ = g_strdup (_ ("_Cancel"));
	_tmp2_ = g_strdup (_ ("_New Game"));
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	gtk_alert_dialog_set_buttons (_data4_->dialog, _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	gtk_alert_dialog_set_default_button (_data4_->dialog, 1);
	gtk_alert_dialog_set_cancel_button (_data4_->dialog, 0);
	gtk_alert_dialog_choose (_data4_->dialog, (GtkWindow*) self, NULL, ___lambda15__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static inline void
swell_foop_window_toggle_hamburger (SwellFoopWindow* self)
{
	g_return_if_fail (self != NULL);
}

static inline void
swell_foop_window_undo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_undo (_tmp0_);
}

static inline void
swell_foop_window_redo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_redo (_tmp0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
swell_foop_window_class_init_scores (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (swell_foop_window_score_categories);
	swell_foop_window_score_categories = _tmp2_;
	{
		guint8 i = 0U;
		i = (guint8) 2;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gint) i) <= 4)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				{
					SwellFoopWindowSize* size_collection = NULL;
					gint size_collection_length1 = 0;
					gint _size_collection_size_ = 0;
					gint size_it = 0;
					size_collection = _tmp5_;
					size_collection_length1 = _tmp5__length1;
					for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
						SwellFoopWindowSize size = {0};
						size = size_collection[size_it];
						{
							gchar* id = NULL;
							SwellFoopWindowSize _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* name = NULL;
							SwellFoopWindowSize _tmp13_;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							GamesScoresCategory* category = NULL;
							const gchar* _tmp16_;
							const gchar* _tmp17_;
							GamesScoresCategory* _tmp18_;
							GHashTable* _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							GamesScoresCategory* _tmp22_;
							_tmp6_ = size;
							_tmp7_ = _tmp6_.id;
							_tmp8_ = string_to_string (_tmp7_);
							_tmp9_ = g_strdup_printf ("%hhu", i);
							_tmp10_ = _tmp9_;
							_tmp11_ = g_strconcat (_tmp8_, "-", _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_g_free0 (_tmp10_);
							id = _tmp12_;
							_tmp13_ = size;
							_tmp14_ = _tmp13_.name;
							_tmp15_ = g_strdup_printf (ngettext ("%s, %d color", "%s, %d colors", (gulong) i), _tmp14_, (gint) i);
							name = _tmp15_;
							_tmp16_ = id;
							_tmp17_ = name;
							_tmp18_ = games_scores_category_new (_tmp16_, _tmp17_);
							category = _tmp18_;
							_tmp19_ = swell_foop_window_score_categories;
							_tmp20_ = id;
							_tmp21_ = g_strdup (_tmp20_);
							_tmp22_ = category;
							category = NULL;
							g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
							_g_object_unref0 (category);
							_g_free0 (name);
							_g_free0 (id);
						}
					}
				}
			}
		}
	}
}

static GamesScoresCategory*
_swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                gpointer self)
{
	GamesScoresCategory* result;
	result = swell_foop_window_category_request ((SwellFoopWindow*) self, category_key);
	return result;
}

static void
_swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                            GamesScoresScore** score,
                                                                                            GamesScoresCategory** category,
                                                                                            gpointer self)
{
	swell_foop_window_parse_old_score ((SwellFoopWindow*) self, line, score, category);
}

static inline void
swell_foop_window_init_scores (SwellFoopWindow* self)
{
	GamesScoresHistoryFileImporter* _tmp0_;
	GamesScoresHistoryFileImporter* _tmp1_;
	GamesScoresContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_history_file_importer_new (_swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_context_new_with_importer_and_icon_name ("swell-foop", _ ("Type"), (GtkWindow*) self, _swell_foop_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp1_, "org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp2_;
	_g_object_unref0 (_tmp1_);
}

static inline GamesScoresCategory*
swell_foop_window_category_request (SwellFoopWindow* self,
                                    const gchar* key)
{
	GamesScoresCategory* category = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = swell_foop_window_score_categories;
	_tmp1_ = g_hash_table_lookup (_tmp0_, key);
	_tmp2_ = _g_object_ref0 ((GamesScoresCategory*) _tmp1_);
	category = _tmp2_;
	if (category == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory));
	result = _tmp3_;
	_g_object_unref0 (category);
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static inline void
swell_foop_window_parse_old_score (SwellFoopWindow* self,
                                   const gchar* line,
                                   GamesScoresScore** score,
                                   GamesScoresCategory** category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint64 date = 0LL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	guint64 number_64 = 0ULL;
	guint8 cols = 0U;
	guint8 rows = 0U;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	guint64 _tmp7_ = 0ULL;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	guint64 _tmp12_ = 0ULL;
	gboolean _tmp13_;
	gboolean _tmp14_ = FALSE;
	gchar* id = NULL;
	gchar* _tmp15_;
	SwellFoopWindowSize* _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp23_;
	guint8 colors = 0U;
	glong score_value = 0L;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	guint64 _tmp26_ = 0ULL;
	gboolean _tmp27_;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	guint64 _tmp31_ = 0ULL;
	gboolean _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GamesScoresCategory* _tmp39_;
	GamesScoresScore* _tmp40_;
	GamesScoresScore* _tmp41_;
	const gchar* _tmp42_;
	GamesScoresScore* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	if (_tmp2__length1 != 5) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	date = games_scores_history_file_importer_parse_date (_tmp4_);
	if (date == ((gint64) 0)) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	_tmp6_ = _tmp5_[1];
	_tmp8_ = uint64_try_parse (_tmp6_, &_tmp7_, NULL, (guint) 0);
	number_64 = _tmp7_;
	if (!_tmp8_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = number_64 > ((guint64) 255);
	}
	if (_tmp9_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	cols = (guint8) number_64;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp10_[2];
	_tmp13_ = uint64_try_parse (_tmp11_, &_tmp12_, NULL, (guint) 0);
	number_64 = _tmp12_;
	if (!_tmp13_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = number_64 > ((guint64) 255);
	}
	if (_tmp14_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	rows = (guint8) number_64;
	_tmp15_ = g_strdup ("");
	id = _tmp15_;
	_tmp16_ = swell_foop_window_sizes;
	_tmp16__length1 = swell_foop_window_sizes_length1;
	{
		SwellFoopWindowSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp16_;
		size_collection_length1 = _tmp16__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			SwellFoopWindowSize size = {0};
			size = size_collection[size_it];
			{
				gboolean _tmp17_ = FALSE;
				SwellFoopWindowSize _tmp18_;
				_tmp18_ = size;
				if (_tmp18_.rows == rows) {
					SwellFoopWindowSize _tmp19_;
					_tmp19_ = size;
					_tmp17_ = _tmp19_.columns == cols;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					SwellFoopWindowSize _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = size;
					_tmp21_ = _tmp20_.id;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (id);
					id = _tmp22_;
					break;
				}
			}
		}
	}
	_tmp23_ = id;
	if (g_strcmp0 (_tmp23_, "") == 0) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp24_ = tokens;
	_tmp24__length1 = tokens_length1;
	_tmp25_ = _tmp24_[3];
	_tmp27_ = uint64_try_parse (_tmp25_, &_tmp26_, NULL, (guint) 0);
	number_64 = _tmp26_;
	if (!_tmp27_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 < ((guint64) 2)) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = number_64 > ((guint64) 4);
	}
	if (_tmp28_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	colors = (guint8) number_64;
	_tmp29_ = tokens;
	_tmp29__length1 = tokens_length1;
	_tmp30_ = _tmp29_[4];
	_tmp32_ = uint64_try_parse (_tmp30_, &_tmp31_, NULL, (guint) 0);
	number_64 = _tmp31_;
	if (!_tmp32_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 > ((guint64) G_MAXLONG)) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	score_value = (glong) number_64;
	_tmp33_ = id;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = g_strdup_printf ("%hhu", colors);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp34_, "-", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = swell_foop_window_category_request (self, _tmp38_);
	_g_object_unref0 (_vala_category);
	_vala_category = _tmp39_;
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp40_ = games_scores_score_new (score_value, date, NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp40_;
	_tmp41_ = _vala_score;
	_tmp42_ = g_get_real_name ();
	games_scores_score_set_user (_tmp41_, _tmp42_);
	_tmp43_ = _vala_score;
	_tmp44_ = games_scores_score_get_user (_tmp43_);
	_tmp45_ = _tmp44_;
	if (g_strcmp0 (_tmp45_, "Unknown") == 0) {
		GamesScoresScore* _tmp46_;
		const gchar* _tmp47_;
		_tmp46_ = _vala_score;
		_tmp47_ = g_get_user_name ();
		games_scores_score_set_user (_tmp46_, _tmp47_);
	}
	_g_free0 (id);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}

static void
__lambda17_ (SwellFoopWindow* self,
             GObject* object,
             GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:506: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((SwellFoopWindow*) self, source_object, res);
	g_object_unref (self);
}

static inline void
swell_foop_window_add_score (SwellFoopWindow* self,
                             GamesScoresCategory* category)
{
	GamesScoresContext* _tmp0_;
	Game* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->scores_context;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_score (_tmp1_);
	_tmp3_ = _tmp2_;
	games_scores_context_add_score (_tmp0_, (glong) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory), NULL, ___lambda17__gasync_ready_callback, g_object_ref (self));
}

static void
swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                             SwellFoopWindowSize* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	(*dest).columns = (*self).columns;
	(*dest).rows = (*self).rows;
}

static void
swell_foop_window_size_destroy (SwellFoopWindowSize* self)
{
	_g_free0 ((*self).id);
	_g_free0 ((*self).name);
}

static SwellFoopWindowSize*
swell_foop_window_size_dup (const SwellFoopWindowSize* self)
{
	SwellFoopWindowSize* dup;
	dup = g_new0 (SwellFoopWindowSize, 1);
	swell_foop_window_size_copy (self, dup);
	return dup;
}

static void
swell_foop_window_size_free (SwellFoopWindowSize* self)
{
	swell_foop_window_size_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
swell_foop_window_size_get_type_once (void)
{
	GType swell_foop_window_size_type_id;
	swell_foop_window_size_type_id = g_boxed_type_register_static ("SwellFoopWindowSize", (GBoxedCopyFunc) swell_foop_window_size_dup, (GBoxedFreeFunc) swell_foop_window_size_free);
	return swell_foop_window_size_type_id;
}

static GType
swell_foop_window_size_get_type (void)
{
	static gsize swell_foop_window_size_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_size_type_id__once)) {
		GType swell_foop_window_size_type_id;
		swell_foop_window_size_type_id = swell_foop_window_size_get_type_once ();
		g_once_init_leave (&swell_foop_window_size_type_id__once, swell_foop_window_size_type_id);
	}
	return swell_foop_window_size_type_id__once;
}

static void
_swell_foop_window___lambda20_ (SwellFoopWindow* self)
{
	GameView* _tmp0_;
	_tmp0_ = self->priv->view;
	if (NULL != _tmp0_) {
		GameView* _tmp1_;
		_tmp1_ = self->priv->view;
		gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp1_);
	}
}

static void
__swell_foop_window___lambda20__gtk_popover_closed (GtkPopover* _sender,
                                                    gpointer self)
{
	_swell_foop_window___lambda20_ ((SwellFoopWindow*) self);
}

static gboolean
_swell_foop_window___lambda21_ (SwellFoopWindow* self)
{
	GSettings* _tmp0_;
	gint window_width = 0;
	gint window_height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	Game* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GSettings* _tmp12_;
	Game* _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	GSettings* _tmp34_;
	gboolean result;
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	window_width = _tmp1_;
	window_height = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "window-width", window_width);
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, "window-height", window_height);
	_tmp5_ = self->priv->settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp5_, "window-is-maximized", _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->game;
	_tmp10_ = game_get_saved_game (_tmp9_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "saved-game", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->game;
	_tmp14_ = game_get_color_num (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_int (_tmp12_, "colors", (gint) _tmp15_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp18_;
				gint _tmp18__length1;
				gboolean _tmp19_ = FALSE;
				Game* _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				SwellFoopWindowSize* _tmp23_;
				gint _tmp23__length1;
				SwellFoopWindowSize _tmp24_;
				if (!_tmp16_) {
					guint8 _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = swell_foop_window_sizes;
				_tmp18__length1 = swell_foop_window_sizes_length1;
				if (!(((gint) i) < _tmp18__length1)) {
					break;
				}
				_tmp20_ = self->priv->game;
				_tmp21_ = game_get_rows (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = swell_foop_window_sizes;
				_tmp23__length1 = swell_foop_window_sizes_length1;
				_tmp24_ = _tmp23_[i];
				if (_tmp22_ == _tmp24_.rows) {
					Game* _tmp25_;
					guint8 _tmp26_;
					guint8 _tmp27_;
					SwellFoopWindowSize* _tmp28_;
					gint _tmp28__length1;
					SwellFoopWindowSize _tmp29_;
					_tmp25_ = self->priv->game;
					_tmp26_ = game_get_columns (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = swell_foop_window_sizes;
					_tmp28__length1 = swell_foop_window_sizes_length1;
					_tmp29_ = _tmp28_[i];
					_tmp19_ = _tmp27_ == _tmp29_.columns;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					GSettings* _tmp30_;
					SwellFoopWindowSize* _tmp31_;
					gint _tmp31__length1;
					SwellFoopWindowSize _tmp32_;
					const gchar* _tmp33_;
					_tmp30_ = self->priv->settings;
					_tmp31_ = swell_foop_window_sizes;
					_tmp31__length1 = swell_foop_window_sizes_length1;
					_tmp32_ = _tmp31_[i];
					_tmp33_ = _tmp32_.id;
					g_settings_set_string (_tmp30_, "size", _tmp33_);
					break;
				}
			}
		}
	}
	_tmp34_ = self->priv->settings;
	g_settings_apply (_tmp34_);
	result = FALSE;
	return result;
}

static gboolean
__swell_foop_window___lambda21__gtk_window_close_request (GtkWindow* _sender,
                                                          gpointer self)
{
	gboolean result;
	result = _swell_foop_window___lambda21_ ((SwellFoopWindow*) self);
	return result;
}

static GObject *
swell_foop_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwellFoopWindow * self;
	GSettings* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkPopover* _tmp2_;
	GSettings* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	gchar* theme = NULL;
	GSettings* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	GSimpleAction* theme_action = NULL;
	GAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GSimpleAction* _tmp19_;
	const gchar* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	gint32 colors = 0;
	GSettings* _tmp23_;
	GSimpleAction* colors_action = NULL;
	GAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleAction* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GameView* _tmp31_;
	GameView* _tmp32_;
	SwellFoopWindowSize size = {0};
	SwellFoopWindowSize _tmp33_ = {0};
	SwellFoopWindowSize _tmp34_;
	SwellFoopWindowSize _tmp35_;
	GtkAspectFrame* _tmp36_;
	GtkAspectFrame* _tmp37_;
	GtkAspectFrame* _tmp38_;
	GtkAspectFrame* _tmp39_;
	GtkAspectFrame* _tmp40_;
	GameView* _tmp41_;
	gboolean first_run = FALSE;
	GSettings* _tmp42_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp43_;
	GtkCssProvider* _tmp44_;
	GdkDisplay* gdk_screen = NULL;
	GdkDisplay* _tmp45_;
	GdkDisplay* _tmp46_;
	GdkDisplay* _tmp47_;
	GtkBox* first_run_view = NULL;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkBox* _tmp52_;
	GtkOverlay* _tmp53_;
	GtkBox* _tmp54_;
	GtkStack* _tmp55_;
	GtkBox* _tmp56_;
	GtkStack* _tmp57_;
	GtkAspectFrame* _tmp58_;
	const gchar* _tmp59_ = NULL;
	GtkStack* _tmp60_;
	parent_class = G_OBJECT_CLASS (swell_foop_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_tmp0_ = g_settings_new ("org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->hamburger_button;
	_tmp2_ = gtk_menu_button_get_popover (_tmp1_);
	g_signal_connect_object (_tmp2_, "closed", (GCallback) __swell_foop_window___lambda20__gtk_popover_closed, self, 0);
	g_action_map_add_action_entries ((GActionMap*) self, SWELL_FOOP_WINDOW_win_actions, (gint) G_N_ELEMENTS (SWELL_FOOP_WINDOW_win_actions), self);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_create_action (_tmp3_, "size");
	_tmp5_ = _tmp4_;
	g_action_map_add_action ((GActionMap*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp6_, "window-width"), g_settings_get_int (_tmp7_, "window-height"));
	_tmp8_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp8_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_string (_tmp9_, "theme");
	theme = _tmp10_;
	_tmp13_ = theme;
	if (g_strcmp0 (_tmp13_, "colors") != 0) {
		const gchar* _tmp14_;
		_tmp14_ = theme;
		_tmp12_ = g_strcmp0 (_tmp14_, "shapesandcolors") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_;
		_tmp15_ = theme;
		_tmp11_ = g_strcmp0 (_tmp15_, "boringshapes") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("shapesandcolors");
		_g_free0 (theme);
		theme = _tmp16_;
	}
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "change-theme");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_simple_action_get_type (), GSimpleAction));
	theme_action = _tmp18_;
	_tmp19_ = theme_action;
	_tmp20_ = theme;
	_tmp21_ = g_variant_new_string (_tmp20_);
	g_variant_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	g_simple_action_set_state (_tmp19_, _tmp22_);
	_g_variant_unref0 (_tmp22_);
	_tmp23_ = self->priv->settings;
	colors = (gint32) g_settings_get_int (_tmp23_, "colors");
	_tmp24_ = g_action_map_lookup_action ((GActionMap*) self, "change-colors");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_simple_action_get_type (), GSimpleAction));
	colors_action = _tmp25_;
	_tmp26_ = colors_action;
	_tmp27_ = g_strdup_printf ("%i", colors);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_variant_new_string (_tmp28_);
	g_variant_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	g_simple_action_set_state (_tmp26_, _tmp30_);
	_g_variant_unref0 (_tmp30_);
	_g_free0 (_tmp28_);
	swell_foop_window_init_scores (self);
	_tmp31_ = game_view_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp31_;
	_tmp32_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	swell_foop_window_get_board_size (self, &_tmp33_);
	size = _tmp33_;
	_tmp34_ = size;
	_tmp35_ = size;
	_tmp36_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, ((gfloat) _tmp34_.columns) / _tmp35_.rows, FALSE);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->aspect_frame);
	self->priv->aspect_frame = _tmp36_;
	_tmp37_ = self->priv->aspect_frame;
	gtk_widget_show ((GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->aspect_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp38_, TRUE);
	_tmp39_ = self->priv->aspect_frame;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp39_, TRUE);
	_tmp40_ = self->priv->aspect_frame;
	_tmp41_ = self->priv->view;
	gtk_aspect_frame_set_child (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->settings;
	first_run = g_settings_get_boolean (_tmp42_, "first-run");
	_tmp43_ = gtk_css_provider_new ();
	css_provider = _tmp43_;
	_tmp44_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp44_, "/org/gnome/SwellFoop/ui/swell-foop.css");
	_tmp45_ = gdk_display_get_default ();
	_tmp46_ = _g_object_ref0 (_tmp45_);
	gdk_screen = _tmp46_;
	_tmp47_ = gdk_screen;
	if (_tmp47_ != NULL) {
		GdkDisplay* _tmp48_;
		GtkCssProvider* _tmp49_;
		_tmp48_ = gdk_screen;
		_tmp49_ = css_provider;
		gtk_style_context_add_provider_for_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gdk_display_get_type (), GdkDisplay), (GtkStyleProvider*) _tmp49_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp50_ = swell_foop_window_build_first_run_view (self);
	first_run_view = _tmp50_;
	_tmp51_ = swell_foop_window_build_game_over_view (self);
	_g_object_unref0 (self->priv->game_over_box);
	self->priv->game_over_box = _tmp51_;
	_tmp52_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp52_, FALSE);
	_tmp53_ = self->priv->overlay;
	_tmp54_ = self->priv->game_over_box;
	gtk_overlay_add_overlay (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->stack;
	_tmp56_ = first_run_view;
	gtk_stack_add_named (_tmp55_, (GtkWidget*) _tmp56_, "first_run");
	_tmp57_ = self->priv->stack;
	_tmp58_ = self->priv->aspect_frame;
	gtk_stack_add_named (_tmp57_, (GtkWidget*) _tmp58_, "game");
	if (first_run) {
		_tmp59_ = "first_run";
	} else {
		_tmp59_ = "game";
	}
	_tmp60_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp60_, _tmp59_);
	g_signal_connect_object ((GtkWindow*) self, "close-request", (GCallback) __swell_foop_window___lambda21__gtk_window_close_request, self, 0);
	_g_object_unref0 (first_run_view);
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (css_provider);
	swell_foop_window_size_destroy (&size);
	_g_object_unref0 (colors_action);
	_g_object_unref0 (theme_action);
	_g_free0 (theme);
	return obj;
}

static void
swell_foop_window_base_init (SwellFoopWindowClass * klass)
{
	swell_foop_window_class_init_sizes ();
	swell_foop_window_class_init_scores ();
}

static void
swell_foop_window_class_init (SwellFoopWindowClass * klass,
                              gpointer klass_data)
{
	swell_foop_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwellFoopWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = swell_foop_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = swell_foop_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SwellFoop/ui/swell-foop.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_button", FALSE, G_STRUCT_OFFSET (SwellFoopWindow, hamburger_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "current_score_label", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, current_score_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_revealer", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, score_revealer));
}

static void
swell_foop_window_instance_init (SwellFoopWindow * self,
                                 gpointer klass)
{
	self->priv = swell_foop_window_get_instance_private (self);
	self->priv->game = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
swell_foop_window_finalize (GObject * obj)
{
	SwellFoopWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_g_object_unref0 (self->priv->aspect_frame);
	_g_object_unref0 (self->priv->score_label);
	_g_object_unref0 (self->priv->to_high_score_label);
	_g_object_unref0 (self->priv->game_over_box);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->scores_context);
	G_OBJECT_CLASS (swell_foop_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
swell_foop_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwellFoopWindowClass), (GBaseInitFunc) swell_foop_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swell_foop_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwellFoopWindow), 0, (GInstanceInitFunc) swell_foop_window_instance_init, NULL };
	GType swell_foop_window_type_id;
	swell_foop_window_type_id = g_type_register_static (gtk_application_window_get_type (), "SwellFoopWindow", &g_define_type_info, 0);
	SwellFoopWindow_private_offset = g_type_add_instance_private (swell_foop_window_type_id, sizeof (SwellFoopWindowPrivate));
	return swell_foop_window_type_id;
}

GType
swell_foop_window_get_type (void)
{
	static gsize swell_foop_window_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_type_id__once)) {
		GType swell_foop_window_type_id;
		swell_foop_window_type_id = swell_foop_window_get_type_once ();
		g_once_init_leave (&swell_foop_window_type_id__once, swell_foop_window_type_id);
	}
	return swell_foop_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

