/* game-view.c generated by valac 0.56.16, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * This file is part of Swell-Foop.
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2023 Ben Corby
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <librsvg/rsvg.h>
#include <gio/gio.h>

#define GAME_VIEW_animation_length 240
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define GAME_VIEW_TYPE_ORDERED_LIST (game_view_ordered_list_get_type ())
#define GAME_VIEW_ORDERED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_VIEW_TYPE_ORDERED_LIST, GameViewOrderedList))
#define GAME_VIEW_ORDERED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_VIEW_TYPE_ORDERED_LIST, GameViewOrderedListClass))
#define GAME_VIEW_IS_ORDERED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_VIEW_TYPE_ORDERED_LIST))
#define GAME_VIEW_IS_ORDERED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_VIEW_TYPE_ORDERED_LIST))
#define GAME_VIEW_ORDERED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_VIEW_TYPE_ORDERED_LIST, GameViewOrderedListClass))

typedef struct _GameViewOrderedList GameViewOrderedList;
typedef struct _GameViewOrderedListClass GameViewOrderedListClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define GAME_VIEW_TYPE_ANIMATION (game_view_animation_get_type ())
#define GAME_VIEW_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_VIEW_TYPE_ANIMATION, GameViewAnimation))
#define GAME_VIEW_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_VIEW_TYPE_ANIMATION, GameViewAnimationClass))
#define GAME_VIEW_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_VIEW_TYPE_ANIMATION))
#define GAME_VIEW_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_VIEW_TYPE_ANIMATION))
#define GAME_VIEW_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_VIEW_TYPE_ANIMATION, GameViewAnimationClass))

typedef struct _GameViewAnimation GameViewAnimation;
typedef struct _GameViewAnimationClass GameViewAnimationClass;
typedef struct _GameViewAnimationPrivate GameViewAnimationPrivate;
typedef enum  {
	GAME_VIEW_ANIMATION_ETYPE_APPEAR,
	GAME_VIEW_ANIMATION_ETYPE_DESTROY,
	GAME_VIEW_ANIMATION_ETYPE_MOVE,
	GAME_VIEW_ANIMATION_ETYPE_SELECT
} GameViewAnimationeType;

#define GAME_VIEW_ANIMATION_TYPE_ETYPE (game_view_animation_etype_get_type ())

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _GamePrivate GamePrivate;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	GAME_VIEW_ANIMATION_0_PROPERTY,
	GAME_VIEW_ANIMATION_NUM_PROPERTIES
};
static GParamSpec* game_view_animation_properties[GAME_VIEW_ANIMATION_NUM_PROPERTIES];
typedef struct _GameViewOrderedListPrivate GameViewOrderedListPrivate;
enum  {
	GAME_VIEW_ORDERED_LIST_0_PROPERTY,
	GAME_VIEW_ORDERED_LIST_NUM_PROPERTIES
};
static GParamSpec* game_view_ordered_list_properties[GAME_VIEW_ORDERED_LIST_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	GameViewOrderedList* animations;
	Game* game;
	gchar* theme;
	gboolean game_complete;
	gboolean draw_highlight;
	GDateTime* animate_score_delta;
	guint score_delta;
	gint width;
	gint height;
	guint x_offset;
	guint y_offset;
	guint x_delta;
	guint y_delta;
	gboolean first_draw;
	guint16 mouse_segment;
	gboolean mouse_pressed;
	guint x_cursor;
	guint y_cursor;
	gboolean frozen_board_initialized;
	guint8* frozen_board;
	gint frozen_board_length1;
	gint frozen_board_length2;
	gboolean frozen;
};

struct _GameViewAnimation {
	GObject parent_instance;
	GameViewAnimationPrivate * priv;
	GDateTime* start_time;
	GameViewAnimationeType animation_type;
	guint8 x;
	guint8 y;
	guint8 dx;
	guint8 dy;
	guint8 block_type;
	Tile* tile;
};

struct _GameViewAnimationClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Tile** current_board;
	gint current_board_length1;
	gint current_board_length2;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameViewOrderedList {
	GeeArrayList parent_instance;
	GameViewOrderedListPrivate * priv;
};

struct _GameViewOrderedListClass {
	GeeArrayListClass parent_class;
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;
static gpointer game_view_animation_parent_class = NULL;
static gpointer game_view_ordered_list_parent_class = NULL;

VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static GType game_view_ordered_list_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameViewOrderedList, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static GameViewOrderedList* game_view_ordered_list_new (void);
static GameViewOrderedList* game_view_ordered_list_construct (GType object_type);
VALA_EXTERN gboolean game_view_keypress (GameView* self,
                             guint keyval,
                             guint keycode);
VALA_EXTERN void game_view_cursor_move (GameView* self,
                            gint x,
                            gint y);
VALA_EXTERN void game_view_cursor_click (GameView* self,
                             guint8 x,
                             guint8 y);
VALA_EXTERN GType game_view_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameViewAnimation, g_object_unref)
static gboolean game_view_do_animation (GameView* self,
                                 cairo_t* c,
                                 GameViewAnimation* a,
                                 GDateTime* now);
VALA_EXTERN GType game_view_animation_etype_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
static void game_view_draw_block (GameView* self,
                           cairo_t* c,
                           gdouble x,
                           gdouble y,
                           guint x_size,
                           guint y_size,
                           guint8 block_id,
                           const gchar* theme);
VALA_EXTERN guint8 game_get_rows (Game* self);
static gboolean game_view_animate_score (GameView* self,
                                  cairo_t* c,
                                  GDateTime* now,
                                  gint width,
                                  gint height);
static void game_view_draw_text_font_size (GameView* self,
                                    cairo_t* C,
                                    gint x,
                                    gint y,
                                    const gchar* text,
                                    gint font_size,
                                    gdouble a);
static void game_view_get_text_offsets (GameView* self,
                                 cairo_t* C,
                                 const gchar* text,
                                 gint font_size,
                                 gint* x_offset,
                                 gint* y_offset,
                                 gint* width,
                                 gint* height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* game);
static void __lambda6_ (GameView* self,
                 gint points);
VALA_EXTERN void game_view_redraw (GameView* self);
static void ___lambda6__game_update_score (Game* _sender,
                                    gint points_awarded,
                                    gpointer self);
static void __lambda7_ (GameView* self);
static void ___lambda7__game_complete (Game* _sender,
                                gpointer self);
static void __lambda8_ (GameView* self);
static void ___lambda8__game_started (Game* _sender,
                               gpointer self);
VALA_EXTERN void game_view_set_theme_name (GameView* self,
                               const gchar* theme_name);
static gboolean game_view_is_uninitialized (GameView* self);
VALA_EXTERN guint8 game_get_columns (Game* self);
static void game_view_add_select_animations (GameView* self,
                                      guint8 x,
                                      guint8 y);
static gboolean game_view_ordered_list_contain_only (GameViewOrderedList* self,
                                              GameViewAnimationeType t);
VALA_EXTERN void game_remove_connected_tiles (Game* self,
                                  Tile* given_tile);
VALA_EXTERN void game_view_freeze (GameView* self);
VALA_EXTERN guint8 tile_get_color (Tile* self);
VALA_EXTERN void game_view_unfreeze (GameView* self);
VALA_EXTERN void game_view_close (GameView* self,
                      guint8 grid_x,
                      guint8 grid_y,
                      guint8 block_type);
static gboolean game_view_ordered_list_add (GameViewOrderedList* self,
                                     GameViewAnimation* a);
VALA_EXTERN GameViewAnimation* game_view_animation_new (GameViewAnimationeType type,
                                            guint8 x,
                                            guint8 y,
                                            guint8 block_type,
                                            guint8 dx,
                                            guint8 dy,
                                            Tile* t);
VALA_EXTERN GameViewAnimation* game_view_animation_construct (GType object_type,
                                                  GameViewAnimationeType type,
                                                  guint8 x,
                                                  guint8 y,
                                                  guint8 block_type,
                                                  guint8 dx,
                                                  guint8 dy,
                                                  Tile* t);
VALA_EXTERN void game_view_appear (GameView* self,
                       guint8 grid_x,
                       guint8 grid_y,
                       guint8 block_type);
VALA_EXTERN void game_view_move (GameView* self,
                     guint8 old_x,
                     guint8 old_y,
                     guint8 new_x,
                     guint8 new_y,
                     guint8 block_type,
                     Tile* t);
static gboolean game_view_merge_moves (GameView* self,
                                guint8 old_x,
                                guint8 old_y,
                                guint8 new_x,
                                guint8 new_y,
                                guint8 block_type,
                                Tile* t);
static void game_view_merge_moves2 (GameView* self,
                             Tile* t);
VALA_EXTERN gboolean game_view_animation_less_than (GameViewAnimation* self,
                                        GameViewAnimation* source);
static void game_view_new_position (GameView* self,
                             gint x,
                             gint y);
static guint16 game_view_segment (GameView* self,
                           gint x,
                           gint y);
static void game_view_ordered_list_remove_type (GameViewOrderedList* self,
                                         GameViewAnimationeType t);
VALA_EXTERN GList* game_connected_tiles (Game* self,
                             Tile* given_tile);
VALA_EXTERN guint8 tile_get_grid_x (Tile* self);
VALA_EXTERN guint8 tile_get_grid_y (Tile* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void game_view_render_svg (GameView* self,
                           cairo_t* c,
                           gdouble x,
                           gdouble y,
                           guint width,
                           guint height,
                           const gchar* path,
                           GError** error);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
static gchar* game_view_get_block_name (GameView* self,
                                 guint8 block_id);
static void game_view_draw_cursor (GameView* self,
                            cairo_t* c,
                            gdouble x,
                            gdouble y,
                            guint x_size,
                            guint y_size,
                            const gchar* theme);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static void game_view_animation_finalize (GObject * obj);
static GType game_view_animation_get_type_once (void);
static GType game_view_ordered_list_get_type_once (void);
static GObject * game_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void _game_view___lambda9_ (GameView* self,
                            GtkDrawingArea* area,
                            cairo_t* c,
                            gint width,
                            gint height);
VALA_EXTERN gboolean tile_get_closed (Tile* self);
static void _vala_array_add1 (GameViewAnimation** * array,
                       gint* length,
                       gint* size,
                       GameViewAnimation* value);
static void _game_view_redraw_gsource_once_func (gpointer self);
static void __game_view___lambda9__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                        cairo_t* cr,
                                                        gint width,
                                                        gint height,
                                                        gpointer self);
static void _game_view___lambda10_ (GameView* self,
                             gdouble x,
                             gdouble y);
static void __game_view___lambda10__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self);
static void _game_view___lambda11_ (GameView* self,
                             gdouble x,
                             gdouble y);
static void __game_view___lambda11__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static void _game_view___lambda12_ (GameView* self);
static void __game_view___lambda12__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                gpointer self);
static gboolean _game_view___lambda13_ (GameView* self,
                                 GtkEventControllerKey* controller,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state);
static gboolean __game_view___lambda13__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self);
static gboolean _game_view___lambda14_ (GameView* self,
                                 GdkEvent* event);
static gboolean __game_view___lambda14__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                    GdkEvent* event,
                                                                    gpointer self);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

gboolean
game_view_keypress (GameView* self,
                    guint keyval,
                    guint keycode)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (keyval) {
		case GDK_KEY_Up:
		case GDK_KEY_W:
		case GDK_KEY_w:
		{
			game_view_cursor_move (self, 0, 1);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Down:
		case GDK_KEY_S:
		case GDK_KEY_s:
		{
			game_view_cursor_move (self, 0, -1);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Left:
		case GDK_KEY_A:
		case GDK_KEY_a:
		{
			game_view_cursor_move (self, -1, 0);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Right:
		case GDK_KEY_D:
		case GDK_KEY_d:
		{
			game_view_cursor_move (self, 1, 0);
			result = TRUE;
			return result;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			game_view_cursor_click (self, (guint8) 0xff, (guint8) 0xff);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
game_view_do_animation (GameView* self,
                        cairo_t* c,
                        GameViewAnimation* a,
                        GDateTime* now)
{
	static const gint total_steps = GAME_VIEW_animation_length;
	static const gint segment_steps = GAME_VIEW_animation_length / 5;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp0_;
	guint steps = 0U;
	guint animation = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (now != NULL, FALSE);
	_tmp0_ = a->start_time;
	diff = g_date_time_difference (now, _tmp0_);
	steps = (guint) (diff / (G_TIME_SPAN_MILLISECOND * 3));
	if (steps >= ((guint) (total_steps - 1))) {
		animation = (guint) 0;
	} else {
		animation = (total_steps - 1) - steps;
	}
	if (a->animation_type == GAME_VIEW_ANIMATION_ETYPE_MOVE) {
		guint range = 0U;
		guint p = 0U;
		Game* _tmp1_;
		guint8 _tmp2_;
		guint8 _tmp3_;
		Game* _tmp4_;
		guint8 _tmp5_;
		guint8 _tmp6_;
		Game* _tmp7_;
		guint8 _tmp8_;
		guint8 _tmp9_;
		const gchar* _tmp10_;
		if (animation >= ((guint) (total_steps - segment_steps))) {
			range = (guint) segment_steps;
			p = total_steps - animation;
		} else {
			if (animation >= ((guint) (total_steps - (segment_steps * 2)))) {
				range = (guint) (segment_steps * 3);
				p = animation - segment_steps;
			} else {
				if (animation >= ((guint) (total_steps - (segment_steps * 3)))) {
					range = (guint) (segment_steps * 3);
					p = total_steps - animation;
				} else {
					if (animation >= ((guint) segment_steps)) {
						range = (guint) (segment_steps * 6);
						p = animation + (segment_steps * 4);
					} else {
						range = (guint) (segment_steps * 6);
						p = (segment_steps * 6) - animation;
					}
				}
			}
		}
		_tmp1_ = self->priv->game;
		_tmp2_ = game_get_rows (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->game;
		_tmp5_ = game_get_rows (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_rows (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->theme;
		game_view_draw_block (self, c, (gdouble) (((((self->priv->x_delta * (((glong) a->x) - a->dx)) * p) / range) + self->priv->x_offset) + (self->priv->x_delta * a->dx)), (gdouble) (((((self->priv->y_delta * (((glong) ((_tmp3_ - 1) - a->y)) - ((_tmp6_ - 1) - a->dy))) * p) / range) + self->priv->y_offset) + (self->priv->y_delta * ((_tmp9_ - 1) - a->dy))), self->priv->x_delta, self->priv->y_delta, a->block_type, _tmp10_);
		result = animation > ((guint) 0);
		return result;
	} else {
		if (a->animation_type == GAME_VIEW_ANIMATION_ETYPE_DESTROY) {
			if (animation >= ((guint) (total_steps - segment_steps))) {
				guint p = 0U;
				Game* _tmp11_;
				guint8 _tmp12_;
				guint8 _tmp13_;
				const gchar* _tmp14_;
				p = total_steps - animation;
				_tmp11_ = self->priv->game;
				_tmp12_ = game_get_rows (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = self->priv->theme;
				game_view_draw_block (self, c, (gdouble) ((self->priv->x_offset + (self->priv->x_delta * a->x)) + ((self->priv->x_delta * p) / (segment_steps * 2))), (gdouble) ((self->priv->y_offset + (self->priv->y_delta * ((_tmp13_ - 1) - a->y))) + ((self->priv->y_delta * p) / (segment_steps * 2))), (self->priv->x_delta * (segment_steps - p)) / segment_steps, (self->priv->y_delta * (segment_steps - p)) / segment_steps, a->block_type, _tmp14_);
			}
			result = animation >= ((guint) (total_steps - segment_steps));
			return result;
		} else {
			if (a->animation_type == GAME_VIEW_ANIMATION_ETYPE_APPEAR) {
				if (animation < ((guint) segment_steps)) {
					guint p = 0U;
					Game* _tmp15_;
					guint8 _tmp16_;
					guint8 _tmp17_;
					const gchar* _tmp18_;
					p = animation;
					_tmp15_ = self->priv->game;
					_tmp16_ = game_get_rows (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = self->priv->theme;
					game_view_draw_block (self, c, (gdouble) ((self->priv->x_offset + (self->priv->x_delta * a->x)) + ((self->priv->x_delta * p) / (segment_steps * 2))), (gdouble) ((self->priv->y_offset + (self->priv->y_delta * ((_tmp17_ - 1) - a->y))) + ((self->priv->y_delta * p) / (segment_steps * 2))), (self->priv->x_delta * (segment_steps - p)) / segment_steps, (self->priv->y_delta * (segment_steps - p)) / segment_steps, a->block_type, _tmp18_);
				}
				result = animation > ((guint) 0);
				return result;
			} else {
				if (a->animation_type == GAME_VIEW_ANIMATION_ETYPE_SELECT) {
					gdouble degrees = 0.0;
					static const gdouble wobble_size = 1.0 / 25;
					Game* _tmp19_;
					guint8 _tmp20_;
					guint8 _tmp21_;
					const gchar* _tmp22_;
					degrees = (gdouble) (((gint) (steps % 360)) - 180);
					_tmp19_ = self->priv->game;
					_tmp20_ = game_get_rows (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = self->priv->theme;
					game_view_draw_block (self, c, (((self->priv->x_offset + (((glong) self->priv->x_delta) * a->x)) + (self->priv->x_delta * wobble_size)) + (self->priv->x_delta / 50)) + (sin ((degrees / 180) * G_PI) * (self->priv->x_delta * wobble_size)), ((self->priv->y_offset + (((glong) self->priv->y_delta) * ((_tmp21_ - 1) - a->y))) + (self->priv->y_delta * wobble_size)) + (self->priv->y_delta / 50), (guint) (self->priv->x_delta * (1 - (wobble_size * 2))), (guint) (self->priv->y_delta * (1 - (wobble_size * 2))), a->block_type, _tmp22_);
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

static gboolean
game_view_animate_score (GameView* self,
                         cairo_t* c,
                         GDateTime* now,
                         gint width,
                         gint height)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	g_return_val_if_fail (now != NULL, FALSE);
	if (self->priv->score_delta > ((guint) 0)) {
		GTimeSpan diff = 0LL;
		GDateTime* _tmp0_;
		guint steps = 0U;
		_tmp0_ = self->priv->animate_score_delta;
		diff = g_date_time_difference (now, _tmp0_);
		steps = (guint) (diff / (G_TIME_SPAN_MILLISECOND * 3));
		if (steps < ((guint) GAME_VIEW_animation_length)) {
			gchar* text = NULL;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = g_strdup_printf ("%u", self->priv->score_delta);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat ("+", _tmp2_, NULL);
			_tmp4_ = _tmp3_;
			_g_free0 (_tmp2_);
			text = _tmp4_;
			_tmp5_ = text;
			game_view_draw_text_font_size (self, c, width / 2, (gint) (((height / 2) * (GAME_VIEW_animation_length - steps)) / ((gfloat) GAME_VIEW_animation_length)), _tmp5_, (gint) steps, (gdouble) ((GAME_VIEW_animation_length - steps) / ((gfloat) GAME_VIEW_animation_length)));
			result = TRUE;
			_g_free0 (text);
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		result = FALSE;
		return result;
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
game_view_draw_text_font_size (GameView* self,
                               cairo_t* C,
                               gint x,
                               gint y,
                               const gchar* text,
                               gint font_size,
                               gdouble a)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp4_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	PangoFontDescription* _tmp13_;
	PangoLayout* _tmp14_;
	PangoLayout* _tmp15_;
	PangoLayout* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	game_view_get_text_offsets (self, C, text, font_size, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	width = _tmp2_;
	height = _tmp3_;
	cairo_move_to (C, (gdouble) ((x - x_offset) - (width / 2)), (gdouble) ((y - y_offset) - (height / 2)));
	cairo_set_source_rgba (C, (gdouble) 1, (gdouble) 1, (gdouble) 1, a);
	_tmp4_ = pango_cairo_create_layout (C);
	layout = _tmp4_;
	_tmp5_ = layout;
	_tmp6_ = pango_layout_get_font_description (_tmp5_);
	if (NULL == _tmp6_) {
		PangoFontDescription* _tmp7_;
		_tmp7_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp7_;
	} else {
		PangoLayout* _tmp8_;
		PangoFontDescription* _tmp9_;
		PangoFontDescription* _tmp10_;
		_tmp8_ = layout;
		_tmp9_ = pango_layout_get_font_description (_tmp8_);
		_tmp10_ = pango_font_description_copy (_tmp9_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp10_;
	}
	_tmp11_ = font;
	pango_font_description_set_size (_tmp11_, PANGO_SCALE * font_size);
	_tmp12_ = layout;
	_tmp13_ = font;
	pango_layout_set_font_description (_tmp12_, _tmp13_);
	_tmp14_ = layout;
	pango_layout_set_text (_tmp14_, text, -1);
	_tmp15_ = layout;
	pango_cairo_update_layout (C, _tmp15_);
	_tmp16_ = layout;
	pango_cairo_show_layout (C, _tmp16_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

static void
game_view_get_text_offsets (GameView* self,
                            cairo_t* C,
                            const gchar* text,
                            gint font_size,
                            gint* x_offset,
                            gint* y_offset,
                            gint* width,
                            gint* height)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp7_;
	PangoLayout* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoLayout* _tmp11_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp12_;
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_ = {0};
	PangoRectangle _tmp15_;
	PangoRectangle _tmp16_;
	PangoRectangle _tmp17_;
	PangoRectangle _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = pango_cairo_create_layout (C);
	layout = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = pango_layout_get_font_description (_tmp1_);
	if (NULL == _tmp2_) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp3_;
	} else {
		PangoLayout* _tmp4_;
		PangoFontDescription* _tmp5_;
		PangoFontDescription* _tmp6_;
		_tmp4_ = layout;
		_tmp5_ = pango_layout_get_font_description (_tmp4_);
		_tmp6_ = pango_font_description_copy (_tmp5_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp6_;
	}
	_tmp7_ = font;
	pango_font_description_set_size (_tmp7_, PANGO_SCALE * font_size);
	_tmp8_ = layout;
	_tmp9_ = font;
	pango_layout_set_font_description (_tmp8_, _tmp9_);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_cairo_update_layout (C, _tmp11_);
	_tmp12_ = layout;
	pango_layout_get_extents (_tmp12_, &_tmp13_, &_tmp14_);
	a = _tmp13_;
	b = _tmp14_;
	_tmp15_ = a;
	_vala_x_offset = _tmp15_.x / PANGO_SCALE;
	_tmp16_ = a;
	_vala_y_offset = _tmp16_.y / PANGO_SCALE;
	_tmp17_ = a;
	_vala_width = _tmp17_.width / PANGO_SCALE;
	_tmp18_ = a;
	_vala_height = _tmp18_.height / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (GameView* self,
            gint points)
{
	if (points > 0) {
		GDateTime* _tmp0_;
		_tmp0_ = g_date_time_new_now_utc ();
		_g_date_time_unref0 (self->priv->animate_score_delta);
		self->priv->animate_score_delta = _tmp0_;
		self->priv->score_delta = (guint) points;
		game_view_redraw (self);
	}
}

static void
___lambda6__game_update_score (Game* _sender,
                               gint points_awarded,
                               gpointer self)
{
	__lambda6_ ((GameView*) self, points_awarded);
}

static void
__lambda7_ (GameView* self)
{
	self->priv->game_complete = TRUE;
	self->priv->draw_highlight = FALSE;
}

static void
___lambda7__game_complete (Game* _sender,
                           gpointer self)
{
	__lambda7_ ((GameView*) self);
}

static void
__lambda8_ (GameView* self)
{
	self->priv->game_complete = FALSE;
}

static void
___lambda8__game_started (Game* _sender,
                          gpointer self)
{
	__lambda8_ ((GameView*) self);
}

void
game_view_set_game (GameView* self,
                    Game* game)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	g_signal_connect_object (game, "update-score", (GCallback) ___lambda6__game_update_score, self, 0);
	g_signal_connect_object (game, "complete", (GCallback) ___lambda7__game_complete, self, 0);
	g_signal_connect_object (game, "started", (GCallback) ___lambda8__game_started, self, 0);
}

void
game_view_set_theme_name (GameView* self,
                          const gchar* theme_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	if (g_strcmp0 (theme_name, "colors") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("colors");
		_g_free0 (self->priv->theme);
		self->priv->theme = _tmp0_;
	} else {
		if (g_strcmp0 (theme_name, "boringshapes") == 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("boringshapes");
			_g_free0 (self->priv->theme);
			self->priv->theme = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("shapesandcolors");
			_g_free0 (self->priv->theme);
			self->priv->theme = _tmp2_;
		}
	}
}

void
game_view_cursor_move (GameView* self,
                       gint x,
                       gint y)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->draw_highlight = TRUE;
	if (!game_view_is_uninitialized (self)) {
		_tmp0_ = !self->priv->game_complete;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if (self->priv->x_cursor == ((guint) -1)) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = self->priv->y_cursor == ((guint) -1);
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			Game* _tmp4_;
			guint8 _tmp5_;
			guint8 _tmp6_;
			_tmp4_ = self->priv->game;
			_tmp5_ = game_get_columns (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = self->priv->x_cursor > ((guint) (_tmp6_ - 1));
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			Game* _tmp7_;
			guint8 _tmp8_;
			guint8 _tmp9_;
			_tmp7_ = self->priv->game;
			_tmp8_ = game_get_rows (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp1_ = self->priv->y_cursor > ((guint) (_tmp9_ - 1));
		}
		if (_tmp1_) {
			Game* _tmp10_;
			guint8 _tmp11_;
			guint8 _tmp12_;
			Game* _tmp13_;
			guint8 _tmp14_;
			guint8 _tmp15_;
			_tmp10_ = self->priv->game;
			_tmp11_ = game_get_columns (_tmp10_);
			_tmp12_ = _tmp11_;
			self->priv->x_cursor = (guint) (_tmp12_ / 2);
			_tmp13_ = self->priv->game;
			_tmp14_ = game_get_rows (_tmp13_);
			_tmp15_ = _tmp14_;
			self->priv->y_cursor = (guint) (_tmp15_ / 2);
			game_view_redraw (self);
		} else {
			gboolean r = FALSE;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			r = FALSE;
			if (self->priv->x_cursor > ((guint) 0)) {
				_tmp17_ = x == -1;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				_tmp16_ = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				Game* _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp19_ = self->priv->game;
				_tmp20_ = game_get_columns (_tmp19_);
				_tmp21_ = _tmp20_;
				if (self->priv->x_cursor < ((guint) (_tmp21_ - 1))) {
					_tmp18_ = x == 1;
				} else {
					_tmp18_ = FALSE;
				}
				_tmp16_ = _tmp18_;
			}
			if (_tmp16_) {
				self->priv->x_cursor = self->priv->x_cursor + x;
				r = TRUE;
			}
			if (self->priv->y_cursor > ((guint) 0)) {
				_tmp23_ = y == -1;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				_tmp22_ = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				Game* _tmp25_;
				guint8 _tmp26_;
				guint8 _tmp27_;
				_tmp25_ = self->priv->game;
				_tmp26_ = game_get_rows (_tmp25_);
				_tmp27_ = _tmp26_;
				if (self->priv->y_cursor < ((guint) (_tmp27_ - 1))) {
					_tmp24_ = y == 1;
				} else {
					_tmp24_ = FALSE;
				}
				_tmp22_ = _tmp24_;
			}
			if (_tmp22_) {
				self->priv->y_cursor = self->priv->y_cursor + y;
				r = TRUE;
			}
			if (r) {
				game_view_add_select_animations (self, (guint8) self->priv->x_cursor, (guint8) self->priv->y_cursor);
			}
		}
	}
}

void
game_view_cursor_click (GameView* self,
                        guint8 x,
                        guint8 y)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!self->priv->frozen) {
		gboolean _tmp1_ = FALSE;
		GameViewOrderedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->animations;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == 0) {
			_tmp1_ = TRUE;
		} else {
			GameViewOrderedList* _tmp5_;
			_tmp5_ = self->priv->animations;
			_tmp1_ = game_view_ordered_list_contain_only (_tmp5_, GAME_VIEW_ANIMATION_ETYPE_SELECT);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GameViewOrderedList* _tmp6_;
		Game* _tmp7_;
		_tmp6_ = self->priv->animations;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
		_tmp7_ = self->priv->game;
		if (NULL != _tmp7_) {
			gboolean _tmp8_ = FALSE;
			if (((gint) x) == 0xff) {
				_tmp8_ = ((gint) y) == 0xff;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				Game* _tmp11_;
				Tile** _tmp12_;
				gint _tmp12__length1;
				gint _tmp12__length2;
				gint _tmp13_;
				_tmp11_ = self->priv->game;
				_tmp12_ = _tmp11_->current_board;
				_tmp12__length1 = _tmp11_->current_board_length1;
				_tmp12__length2 = _tmp11_->current_board_length2;
				_tmp13_ = _tmp12__length1;
				if (self->priv->y_cursor < ((guint) _tmp13_)) {
					Game* _tmp14_;
					Tile** _tmp15_;
					gint _tmp15__length1;
					gint _tmp15__length2;
					gint _tmp16_;
					_tmp14_ = self->priv->game;
					_tmp15_ = _tmp14_->current_board;
					_tmp15__length1 = _tmp14_->current_board_length1;
					_tmp15__length2 = _tmp14_->current_board_length2;
					_tmp16_ = _tmp15__length2;
					_tmp10_ = self->priv->x_cursor < ((guint) _tmp16_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					Game* _tmp17_;
					Tile** _tmp18_;
					gint _tmp18__length1;
					gint _tmp18__length2;
					Tile* _tmp19_;
					_tmp17_ = self->priv->game;
					_tmp18_ = _tmp17_->current_board;
					_tmp18__length1 = _tmp17_->current_board_length1;
					_tmp18__length2 = _tmp17_->current_board_length2;
					_tmp19_ = _tmp18_[(self->priv->y_cursor * _tmp18__length2) + self->priv->x_cursor];
					_tmp9_ = NULL != _tmp19_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					Game* _tmp20_;
					Game* _tmp21_;
					Tile** _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					Tile* _tmp23_;
					_tmp20_ = self->priv->game;
					_tmp21_ = self->priv->game;
					_tmp22_ = _tmp21_->current_board;
					_tmp22__length1 = _tmp21_->current_board_length1;
					_tmp22__length2 = _tmp21_->current_board_length2;
					_tmp23_ = _tmp22_[(self->priv->y_cursor * _tmp22__length2) + self->priv->x_cursor];
					game_remove_connected_tiles (_tmp20_, _tmp23_);
				}
			} else {
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				Game* _tmp26_;
				Tile** _tmp27_;
				gint _tmp27__length1;
				gint _tmp27__length2;
				gint _tmp28_;
				_tmp26_ = self->priv->game;
				_tmp27_ = _tmp26_->current_board;
				_tmp27__length1 = _tmp26_->current_board_length1;
				_tmp27__length2 = _tmp26_->current_board_length2;
				_tmp28_ = _tmp27__length1;
				if (((gint) y) < _tmp28_) {
					Game* _tmp29_;
					Tile** _tmp30_;
					gint _tmp30__length1;
					gint _tmp30__length2;
					gint _tmp31_;
					_tmp29_ = self->priv->game;
					_tmp30_ = _tmp29_->current_board;
					_tmp30__length1 = _tmp29_->current_board_length1;
					_tmp30__length2 = _tmp29_->current_board_length2;
					_tmp31_ = _tmp30__length2;
					_tmp25_ = ((gint) x) < _tmp31_;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					Game* _tmp32_;
					Tile** _tmp33_;
					gint _tmp33__length1;
					gint _tmp33__length2;
					Tile* _tmp34_;
					_tmp32_ = self->priv->game;
					_tmp33_ = _tmp32_->current_board;
					_tmp33__length1 = _tmp32_->current_board_length1;
					_tmp33__length2 = _tmp32_->current_board_length2;
					_tmp34_ = _tmp33_[(y * _tmp33__length2) + x];
					_tmp24_ = NULL != _tmp34_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					Game* _tmp35_;
					Game* _tmp36_;
					Tile** _tmp37_;
					gint _tmp37__length1;
					gint _tmp37__length2;
					Tile* _tmp38_;
					_tmp35_ = self->priv->game;
					_tmp36_ = self->priv->game;
					_tmp37_ = _tmp36_->current_board;
					_tmp37__length1 = _tmp36_->current_board_length1;
					_tmp37__length2 = _tmp36_->current_board_length2;
					_tmp38_ = _tmp37_[(y * _tmp37__length2) + x];
					game_remove_connected_tiles (_tmp35_, _tmp38_);
				}
			}
		}
	}
}

void
game_view_freeze (GameView* self)
{
	g_return_if_fail (self != NULL);
	if (!game_view_is_uninitialized (self)) {
		Game* _tmp0_;
		guint8 _tmp1_;
		guint8 _tmp2_;
		Game* _tmp3_;
		guint8 _tmp4_;
		guint8 _tmp5_;
		guint8* _tmp6_;
		_tmp0_ = self->priv->game;
		_tmp1_ = game_get_columns (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_rows (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_new0 (guint8, _tmp2_ * _tmp5_);
		self->priv->frozen_board = (g_free (self->priv->frozen_board), NULL);
		self->priv->frozen_board = _tmp6_;
		self->priv->frozen_board_length1 = _tmp2_;
		self->priv->frozen_board_length2 = _tmp5_;
		{
			gint y = 0;
			Game* _tmp7_;
			guint8 _tmp8_;
			guint8 _tmp9_;
			_tmp7_ = self->priv->game;
			_tmp8_ = game_get_rows (_tmp7_);
			_tmp9_ = _tmp8_;
			y = _tmp9_ - 1;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					if (!_tmp10_) {
						gint _tmp11_;
						y = y - 1;
						_tmp11_ = y;
					}
					_tmp10_ = FALSE;
					if (!(y >= 0)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								Game* _tmp14_;
								guint8 _tmp15_;
								guint8 _tmp16_;
								guint8 _tmp17_ = 0U;
								Game* _tmp18_;
								Tile** _tmp19_;
								gint _tmp19__length1;
								gint _tmp19__length2;
								Tile* _tmp20_;
								guint8* _tmp26_;
								gint _tmp26__length1;
								gint _tmp26__length2;
								if (!_tmp12_) {
									gint _tmp13_;
									x = x + 1;
									_tmp13_ = x;
								}
								_tmp12_ = FALSE;
								_tmp14_ = self->priv->game;
								_tmp15_ = game_get_columns (_tmp14_);
								_tmp16_ = _tmp15_;
								if (!(x < ((gint) _tmp16_))) {
									break;
								}
								_tmp18_ = self->priv->game;
								_tmp19_ = _tmp18_->current_board;
								_tmp19__length1 = _tmp18_->current_board_length1;
								_tmp19__length2 = _tmp18_->current_board_length2;
								_tmp20_ = _tmp19_[(y * _tmp19__length2) + x];
								if (NULL != _tmp20_) {
									Game* _tmp21_;
									Tile** _tmp22_;
									gint _tmp22__length1;
									gint _tmp22__length2;
									Tile* _tmp23_;
									guint8 _tmp24_;
									guint8 _tmp25_;
									_tmp21_ = self->priv->game;
									_tmp22_ = _tmp21_->current_board;
									_tmp22__length1 = _tmp21_->current_board_length1;
									_tmp22__length2 = _tmp21_->current_board_length2;
									_tmp23_ = _tmp22_[(y * _tmp22__length2) + x];
									_tmp24_ = tile_get_color (_tmp23_);
									_tmp25_ = _tmp24_;
									_tmp17_ = _tmp25_;
								} else {
									_tmp17_ = (guint8) 0;
								}
								_tmp26_ = self->priv->frozen_board;
								_tmp26__length1 = self->priv->frozen_board_length1;
								_tmp26__length2 = self->priv->frozen_board_length2;
								_tmp26_[(x * _tmp26__length2) + y] = _tmp17_;
							}
						}
					}
				}
			}
		}
		self->priv->frozen_board_initialized = TRUE;
	}
	self->priv->frozen = TRUE;
}

void
game_view_unfreeze (GameView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->frozen = FALSE;
	game_view_redraw (self);
}

void
game_view_close (GameView* self,
                 guint8 grid_x,
                 guint8 grid_y,
                 guint8 block_type)
{
	GameViewOrderedList* _tmp0_;
	GameViewAnimation* _tmp1_;
	GameViewAnimation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animations;
	_tmp1_ = game_view_animation_new (GAME_VIEW_ANIMATION_ETYPE_DESTROY, grid_x, grid_y, block_type, (guint8) 0xff, (guint8) 0xff, NULL);
	_tmp2_ = _tmp1_;
	game_view_ordered_list_add (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

void
game_view_appear (GameView* self,
                  guint8 grid_x,
                  guint8 grid_y,
                  guint8 block_type)
{
	GameViewOrderedList* _tmp0_;
	GameViewAnimation* _tmp1_;
	GameViewAnimation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animations;
	_tmp1_ = game_view_animation_new (GAME_VIEW_ANIMATION_ETYPE_APPEAR, grid_x, grid_y, block_type, (guint8) 0xff, (guint8) 0xff, NULL);
	_tmp2_ = _tmp1_;
	game_view_ordered_list_add (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

void
game_view_move (GameView* self,
                guint8 old_x,
                guint8 old_y,
                guint8 new_x,
                guint8 new_y,
                guint8 block_type,
                Tile* t)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if (game_view_merge_moves (self, old_x, old_y, new_x, new_y, block_type, t)) {
		game_view_merge_moves2 (self, t);
	} else {
		GameViewOrderedList* _tmp0_;
		GameViewAnimation* _tmp1_;
		GameViewAnimation* _tmp2_;
		_tmp0_ = self->priv->animations;
		_tmp1_ = game_view_animation_new (GAME_VIEW_ANIMATION_ETYPE_MOVE, new_x, new_y, block_type, old_x, old_y, t);
		_tmp2_ = _tmp1_;
		game_view_ordered_list_add (_tmp0_, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
}

void
game_view_redraw (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
game_view_is_uninitialized (GameView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Game* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->game;
	if (NULL == _tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Game* _tmp4_;
		Tile** _tmp5_;
		gint _tmp5__length1;
		gint _tmp5__length2;
		_tmp4_ = self->priv->game;
		_tmp5_ = _tmp4_->current_board;
		_tmp5__length1 = _tmp4_->current_board_length1;
		_tmp5__length2 = _tmp4_->current_board_length2;
		_tmp2_ = NULL == _tmp5_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		Game* _tmp6_;
		Tile** _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		Game* _tmp9_;
		guint8 _tmp10_;
		guint8 _tmp11_;
		_tmp6_ = self->priv->game;
		_tmp7_ = _tmp6_->current_board;
		_tmp7__length1 = _tmp6_->current_board_length1;
		_tmp7__length2 = _tmp6_->current_board_length2;
		_tmp8_ = _tmp7__length1;
		_tmp9_ = self->priv->game;
		_tmp10_ = game_get_rows (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp8_ != ((gint) _tmp11_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp12_;
		Tile** _tmp13_;
		gint _tmp13__length1;
		gint _tmp13__length2;
		gint _tmp14_;
		Game* _tmp15_;
		guint8 _tmp16_;
		guint8 _tmp17_;
		_tmp12_ = self->priv->game;
		_tmp13_ = _tmp12_->current_board;
		_tmp13__length1 = _tmp12_->current_board_length1;
		_tmp13__length2 = _tmp12_->current_board_length2;
		_tmp14_ = _tmp13__length2;
		_tmp15_ = self->priv->game;
		_tmp16_ = game_get_columns (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp0_ = _tmp14_ != ((gint) _tmp17_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
game_view_merge_moves (GameView* self,
                       guint8 old_x,
                       guint8 old_y,
                       guint8 new_x,
                       guint8 new_y,
                       guint8 block_type,
                       Tile* t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GameViewOrderedList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gboolean _tmp5_ = FALSE;
				GameViewOrderedList* _tmp6_;
				gpointer _tmp7_;
				GameViewAnimation* _tmp8_;
				gboolean _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->animations;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp6_ = self->priv->animations;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i);
				_tmp8_ = (GameViewAnimation*) _tmp7_;
				_tmp9_ = _tmp8_->animation_type == GAME_VIEW_ANIMATION_ETYPE_MOVE;
				_g_object_unref0 (_tmp8_);
				if (_tmp9_) {
					GameViewOrderedList* _tmp10_;
					gpointer _tmp11_;
					GameViewAnimation* _tmp12_;
					Tile* _tmp13_;
					_tmp10_ = self->priv->animations;
					_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
					_tmp12_ = (GameViewAnimation*) _tmp11_;
					_tmp13_ = _tmp12_->tile;
					_tmp5_ = _tmp13_ == t;
					_g_object_unref0 (_tmp12_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gboolean _tmp14_ = FALSE;
					GameViewOrderedList* _tmp15_;
					gpointer _tmp16_;
					GameViewAnimation* _tmp17_;
					gboolean _tmp18_;
					_tmp15_ = self->priv->animations;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
					_tmp17_ = (GameViewAnimation*) _tmp16_;
					_tmp18_ = new_x == _tmp17_->dx;
					_g_object_unref0 (_tmp17_);
					if (_tmp18_) {
						GameViewOrderedList* _tmp19_;
						gpointer _tmp20_;
						GameViewAnimation* _tmp21_;
						_tmp19_ = self->priv->animations;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, i);
						_tmp21_ = (GameViewAnimation*) _tmp20_;
						_tmp14_ = new_y == _tmp21_->dy;
						_g_object_unref0 (_tmp21_);
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						GameViewOrderedList* _tmp22_;
						gpointer _tmp23_;
						GameViewAnimation* _tmp24_;
						GameViewOrderedList* _tmp25_;
						gpointer _tmp26_;
						GameViewAnimation* _tmp27_;
						_tmp22_ = self->priv->animations;
						_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, i);
						_tmp24_ = (GameViewAnimation*) _tmp23_;
						_tmp24_->dx = old_x;
						_g_object_unref0 (_tmp24_);
						_tmp25_ = self->priv->animations;
						_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, i);
						_tmp27_ = (GameViewAnimation*) _tmp26_;
						_tmp27_->dy = old_y;
						_g_object_unref0 (_tmp27_);
						result = TRUE;
						return result;
					} else {
						gboolean _tmp28_ = FALSE;
						GameViewOrderedList* _tmp29_;
						gpointer _tmp30_;
						GameViewAnimation* _tmp31_;
						gboolean _tmp32_;
						_tmp29_ = self->priv->animations;
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, i);
						_tmp31_ = (GameViewAnimation*) _tmp30_;
						_tmp32_ = old_x == _tmp31_->x;
						_g_object_unref0 (_tmp31_);
						if (_tmp32_) {
							GameViewOrderedList* _tmp33_;
							gpointer _tmp34_;
							GameViewAnimation* _tmp35_;
							_tmp33_ = self->priv->animations;
							_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, i);
							_tmp35_ = (GameViewAnimation*) _tmp34_;
							_tmp28_ = old_y == _tmp35_->y;
							_g_object_unref0 (_tmp35_);
						} else {
							_tmp28_ = FALSE;
						}
						if (_tmp28_) {
							GameViewOrderedList* _tmp36_;
							gpointer _tmp37_;
							GameViewAnimation* _tmp38_;
							GameViewOrderedList* _tmp39_;
							gpointer _tmp40_;
							GameViewAnimation* _tmp41_;
							gboolean _tmp42_ = FALSE;
							_tmp36_ = self->priv->animations;
							_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, i);
							_tmp38_ = (GameViewAnimation*) _tmp37_;
							_tmp38_->x = new_x;
							_g_object_unref0 (_tmp38_);
							_tmp39_ = self->priv->animations;
							_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, i);
							_tmp41_ = (GameViewAnimation*) _tmp40_;
							_tmp41_->y = new_y;
							_g_object_unref0 (_tmp41_);
							if (i > 0) {
								GameViewOrderedList* _tmp43_;
								gpointer _tmp44_;
								GameViewAnimation* _tmp45_;
								GameViewOrderedList* _tmp46_;
								gpointer _tmp47_;
								GameViewAnimation* _tmp48_;
								_tmp43_ = self->priv->animations;
								_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, i - 1);
								_tmp45_ = (GameViewAnimation*) _tmp44_;
								_tmp46_ = self->priv->animations;
								_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, i);
								_tmp48_ = (GameViewAnimation*) _tmp47_;
								_tmp42_ = !game_view_animation_less_than (_tmp45_, _tmp48_);
								_g_object_unref0 (_tmp48_);
								_g_object_unref0 (_tmp45_);
							} else {
								_tmp42_ = FALSE;
							}
							if (_tmp42_) {
								GameViewOrderedList* _tmp49_;
								GameViewOrderedList* _tmp50_;
								gpointer _tmp51_;
								GameViewAnimation* _tmp52_;
								_tmp49_ = self->priv->animations;
								_tmp50_ = self->priv->animations;
								_tmp51_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp50_, i);
								_tmp52_ = (GameViewAnimation*) _tmp51_;
								game_view_ordered_list_add (_tmp49_, _tmp52_);
								_g_object_unref0 (_tmp52_);
							} else {
								gboolean _tmp53_ = FALSE;
								GameViewOrderedList* _tmp54_;
								gint _tmp55_;
								gint _tmp56_;
								_tmp54_ = self->priv->animations;
								_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
								_tmp56_ = _tmp55_;
								if (i < (_tmp56_ - 1)) {
									GameViewOrderedList* _tmp57_;
									gpointer _tmp58_;
									GameViewAnimation* _tmp59_;
									GameViewOrderedList* _tmp60_;
									gpointer _tmp61_;
									GameViewAnimation* _tmp62_;
									_tmp57_ = self->priv->animations;
									_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, i);
									_tmp59_ = (GameViewAnimation*) _tmp58_;
									_tmp60_ = self->priv->animations;
									_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, i + 1);
									_tmp62_ = (GameViewAnimation*) _tmp61_;
									_tmp53_ = !game_view_animation_less_than (_tmp59_, _tmp62_);
									_g_object_unref0 (_tmp62_);
									_g_object_unref0 (_tmp59_);
								} else {
									_tmp53_ = FALSE;
								}
								if (_tmp53_) {
									GameViewOrderedList* _tmp63_;
									GameViewOrderedList* _tmp64_;
									gpointer _tmp65_;
									GameViewAnimation* _tmp66_;
									_tmp63_ = self->priv->animations;
									_tmp64_ = self->priv->animations;
									_tmp65_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp64_, i);
									_tmp66_ = (GameViewAnimation*) _tmp65_;
									game_view_ordered_list_add (_tmp63_, _tmp66_);
									_g_object_unref0 (_tmp66_);
								}
							}
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
game_view_merge_moves2 (GameView* self,
                        Tile* t)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint i = 0;
			GameViewOrderedList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			{
				gboolean _tmp1_ = FALSE;
				i = 0;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_ = FALSE;
					GameViewOrderedList* _tmp4_;
					gint _tmp5_;
					gint _tmp6_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = self->priv->animations;
					_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
					_tmp6_ = _tmp5_;
					if (i < _tmp6_) {
						GameViewOrderedList* _tmp7_;
						gpointer _tmp8_;
						GameViewAnimation* _tmp9_;
						Tile* _tmp10_;
						_tmp7_ = self->priv->animations;
						_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, i);
						_tmp9_ = (GameViewAnimation*) _tmp8_;
						_tmp10_ = _tmp9_->tile;
						_tmp3_ = _tmp10_ != t;
						_g_object_unref0 (_tmp9_);
					} else {
						_tmp3_ = FALSE;
					}
					if (!_tmp3_) {
						break;
					}
				}
			}
			_tmp11_ = self->priv->animations;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (i < _tmp13_) {
				gboolean done_merge = FALSE;
				gint o = 0;
				done_merge = FALSE;
				{
					gboolean _tmp14_ = FALSE;
					o = i + 1;
					_tmp14_ = TRUE;
					while (TRUE) {
						GameViewOrderedList* _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						GameViewOrderedList* _tmp19_;
						gpointer _tmp20_;
						GameViewAnimation* _tmp21_;
						Tile* _tmp22_;
						gboolean _tmp23_;
						if (!_tmp14_) {
							gint _tmp15_;
							_tmp15_ = o;
							o = _tmp15_ + 1;
						}
						_tmp14_ = FALSE;
						_tmp16_ = self->priv->animations;
						_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
						_tmp18_ = _tmp17_;
						if (!(o < _tmp18_)) {
							break;
						}
						_tmp19_ = self->priv->animations;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, o);
						_tmp21_ = (GameViewAnimation*) _tmp20_;
						_tmp22_ = _tmp21_->tile;
						_tmp23_ = _tmp22_ == t;
						_g_object_unref0 (_tmp21_);
						if (_tmp23_) {
							gboolean _tmp24_ = FALSE;
							GameViewOrderedList* _tmp25_;
							gpointer _tmp26_;
							GameViewAnimation* _tmp27_;
							GameViewOrderedList* _tmp28_;
							gpointer _tmp29_;
							GameViewAnimation* _tmp30_;
							gboolean _tmp31_;
							_tmp25_ = self->priv->animations;
							_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, o);
							_tmp27_ = (GameViewAnimation*) _tmp26_;
							_tmp28_ = self->priv->animations;
							_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, i);
							_tmp30_ = (GameViewAnimation*) _tmp29_;
							_tmp31_ = _tmp27_->x == _tmp30_->dx;
							_g_object_unref0 (_tmp30_);
							_g_object_unref0 (_tmp27_);
							if (_tmp31_) {
								GameViewOrderedList* _tmp32_;
								gpointer _tmp33_;
								GameViewAnimation* _tmp34_;
								GameViewOrderedList* _tmp35_;
								gpointer _tmp36_;
								GameViewAnimation* _tmp37_;
								_tmp32_ = self->priv->animations;
								_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, o);
								_tmp34_ = (GameViewAnimation*) _tmp33_;
								_tmp35_ = self->priv->animations;
								_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, i);
								_tmp37_ = (GameViewAnimation*) _tmp36_;
								_tmp24_ = _tmp34_->y == _tmp37_->dy;
								_g_object_unref0 (_tmp37_);
								_g_object_unref0 (_tmp34_);
							} else {
								_tmp24_ = FALSE;
							}
							if (_tmp24_) {
								GameViewOrderedList* _tmp38_;
								gpointer _tmp39_;
								GameViewAnimation* _tmp40_;
								GameViewOrderedList* _tmp41_;
								gpointer _tmp42_;
								GameViewAnimation* _tmp43_;
								GameViewOrderedList* _tmp44_;
								gpointer _tmp45_;
								GameViewAnimation* _tmp46_;
								GameViewOrderedList* _tmp47_;
								gpointer _tmp48_;
								GameViewAnimation* _tmp49_;
								GameViewOrderedList* _tmp50_;
								gpointer _tmp51_;
								GameViewAnimation* _tmp52_;
								_tmp38_ = self->priv->animations;
								_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, i);
								_tmp40_ = (GameViewAnimation*) _tmp39_;
								_tmp41_ = self->priv->animations;
								_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, o);
								_tmp43_ = (GameViewAnimation*) _tmp42_;
								_tmp40_->dx = _tmp43_->dx;
								_g_object_unref0 (_tmp43_);
								_g_object_unref0 (_tmp40_);
								_tmp44_ = self->priv->animations;
								_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, i);
								_tmp46_ = (GameViewAnimation*) _tmp45_;
								_tmp47_ = self->priv->animations;
								_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, o);
								_tmp49_ = (GameViewAnimation*) _tmp48_;
								_tmp46_->dy = _tmp49_->dy;
								_g_object_unref0 (_tmp49_);
								_g_object_unref0 (_tmp46_);
								_tmp50_ = self->priv->animations;
								_tmp51_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp50_, o);
								_tmp52_ = (GameViewAnimation*) _tmp51_;
								_g_object_unref0 (_tmp52_);
								done_merge = TRUE;
								break;
							} else {
								gboolean _tmp53_ = FALSE;
								GameViewOrderedList* _tmp54_;
								gpointer _tmp55_;
								GameViewAnimation* _tmp56_;
								GameViewOrderedList* _tmp57_;
								gpointer _tmp58_;
								GameViewAnimation* _tmp59_;
								gboolean _tmp60_;
								_tmp54_ = self->priv->animations;
								_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, i);
								_tmp56_ = (GameViewAnimation*) _tmp55_;
								_tmp57_ = self->priv->animations;
								_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, o);
								_tmp59_ = (GameViewAnimation*) _tmp58_;
								_tmp60_ = _tmp56_->x == _tmp59_->dx;
								_g_object_unref0 (_tmp59_);
								_g_object_unref0 (_tmp56_);
								if (_tmp60_) {
									GameViewOrderedList* _tmp61_;
									gpointer _tmp62_;
									GameViewAnimation* _tmp63_;
									GameViewOrderedList* _tmp64_;
									gpointer _tmp65_;
									GameViewAnimation* _tmp66_;
									_tmp61_ = self->priv->animations;
									_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, i);
									_tmp63_ = (GameViewAnimation*) _tmp62_;
									_tmp64_ = self->priv->animations;
									_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, o);
									_tmp66_ = (GameViewAnimation*) _tmp65_;
									_tmp53_ = _tmp63_->y == _tmp66_->dy;
									_g_object_unref0 (_tmp66_);
									_g_object_unref0 (_tmp63_);
								} else {
									_tmp53_ = FALSE;
								}
								if (_tmp53_) {
									GameViewOrderedList* _tmp67_;
									gpointer _tmp68_;
									GameViewAnimation* _tmp69_;
									GameViewOrderedList* _tmp70_;
									gpointer _tmp71_;
									GameViewAnimation* _tmp72_;
									GameViewOrderedList* _tmp73_;
									gpointer _tmp74_;
									GameViewAnimation* _tmp75_;
									GameViewOrderedList* _tmp76_;
									gpointer _tmp77_;
									GameViewAnimation* _tmp78_;
									GameViewOrderedList* _tmp79_;
									gpointer _tmp80_;
									GameViewAnimation* _tmp81_;
									_tmp67_ = self->priv->animations;
									_tmp68_ = gee_abstract_list_get ((GeeAbstractList*) _tmp67_, o);
									_tmp69_ = (GameViewAnimation*) _tmp68_;
									_tmp70_ = self->priv->animations;
									_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, i);
									_tmp72_ = (GameViewAnimation*) _tmp71_;
									_tmp69_->dx = _tmp72_->dx;
									_g_object_unref0 (_tmp72_);
									_g_object_unref0 (_tmp69_);
									_tmp73_ = self->priv->animations;
									_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, o);
									_tmp75_ = (GameViewAnimation*) _tmp74_;
									_tmp76_ = self->priv->animations;
									_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, i);
									_tmp78_ = (GameViewAnimation*) _tmp77_;
									_tmp75_->dy = _tmp78_->dy;
									_g_object_unref0 (_tmp78_);
									_g_object_unref0 (_tmp75_);
									_tmp79_ = self->priv->animations;
									_tmp80_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp79_, i);
									_tmp81_ = (GameViewAnimation*) _tmp80_;
									_g_object_unref0 (_tmp81_);
									done_merge = TRUE;
									break;
								}
							}
						}
					}
				}
				if (!done_merge) {
					return;
				}
			} else {
				_vala_assert (FALSE, "false");
			}
		}
	}
}

static void
game_view_new_position (GameView* self,
                        gint x,
                        gint y)
{
	guint16 new_segment = 0U;
	g_return_if_fail (self != NULL);
	new_segment = game_view_segment (self, x, y);
	if (new_segment != self->priv->mouse_segment) {
		self->priv->mouse_segment = new_segment;
		if (((gint) self->priv->mouse_segment) != 0xffff) {
			game_view_add_select_animations (self, (guint8) (self->priv->mouse_segment >> 8), (guint8) self->priv->mouse_segment);
		} else {
			GameViewOrderedList* _tmp0_;
			_tmp0_ = self->priv->animations;
			game_view_ordered_list_remove_type (_tmp0_, GAME_VIEW_ANIMATION_ETYPE_SELECT);
		}
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
game_view_add_select_animations (GameView* self,
                                 guint8 x,
                                 guint8 y)
{
	GameViewOrderedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animations;
	game_view_ordered_list_remove_type (_tmp0_, GAME_VIEW_ANIMATION_ETYPE_SELECT);
	_tmp4_ = self->priv->game;
	if (NULL != _tmp4_) {
		Game* _tmp5_;
		Tile** _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		gint _tmp7_;
		_tmp5_ = self->priv->game;
		_tmp6_ = _tmp5_->current_board;
		_tmp6__length1 = _tmp5_->current_board_length1;
		_tmp6__length2 = _tmp5_->current_board_length2;
		_tmp7_ = _tmp6__length1;
		_tmp3_ = ((gint) y) < _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Game* _tmp8_;
		Tile** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		gint _tmp10_;
		_tmp8_ = self->priv->game;
		_tmp9_ = _tmp8_->current_board;
		_tmp9__length1 = _tmp8_->current_board_length1;
		_tmp9__length2 = _tmp8_->current_board_length2;
		_tmp10_ = _tmp9__length2;
		_tmp2_ = ((gint) x) < _tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Game* _tmp11_;
		Tile** _tmp12_;
		gint _tmp12__length1;
		gint _tmp12__length2;
		Tile* _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = _tmp11_->current_board;
		_tmp12__length1 = _tmp11_->current_board_length1;
		_tmp12__length2 = _tmp11_->current_board_length2;
		_tmp13_ = _tmp12_[(y * _tmp12__length2) + x];
		_tmp1_ = NULL != _tmp13_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GList* tiles = NULL;
		Game* _tmp14_;
		Game* _tmp15_;
		Tile** _tmp16_;
		gint _tmp16__length1;
		gint _tmp16__length2;
		Tile* _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		_tmp14_ = self->priv->game;
		_tmp15_ = self->priv->game;
		_tmp16_ = _tmp15_->current_board;
		_tmp16__length1 = _tmp15_->current_board_length1;
		_tmp16__length2 = _tmp15_->current_board_length2;
		_tmp17_ = _tmp16_[(y * _tmp16__length2) + x];
		_tmp18_ = game_connected_tiles (_tmp14_, _tmp17_);
		tiles = _tmp18_;
		_tmp19_ = tiles;
		{
			GList* tile_collection = NULL;
			GList* tile_it = NULL;
			tile_collection = _tmp19_;
			for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
				Tile* _tmp20_;
				Tile* tile = NULL;
				_tmp20_ = _g_object_ref0 ((Tile*) tile_it->data);
				tile = _tmp20_;
				{
					GameViewOrderedList* _tmp21_;
					Tile* _tmp22_;
					guint8 _tmp23_;
					guint8 _tmp24_;
					Tile* _tmp25_;
					guint8 _tmp26_;
					guint8 _tmp27_;
					Tile* _tmp28_;
					guint8 _tmp29_;
					guint8 _tmp30_;
					GameViewAnimation* _tmp31_;
					GameViewAnimation* _tmp32_;
					_tmp21_ = self->priv->animations;
					_tmp22_ = tile;
					_tmp23_ = tile_get_grid_x (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = tile;
					_tmp26_ = tile_get_grid_y (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = tile;
					_tmp29_ = tile_get_color (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = game_view_animation_new (GAME_VIEW_ANIMATION_ETYPE_SELECT, _tmp24_, _tmp27_, _tmp30_, (guint8) 0xff, (guint8) 0xff, NULL);
					_tmp32_ = _tmp31_;
					game_view_ordered_list_add (_tmp21_, _tmp32_);
					_g_object_unref0 (_tmp32_);
					_g_object_unref0 (tile);
				}
			}
		}
		(tiles == NULL) ? NULL : (tiles = (_g_list_free__g_object_unref0_ (tiles), NULL));
	}
	game_view_redraw (self);
}

static guint16
game_view_segment (GameView* self,
                   gint x,
                   gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	if (x < 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = x >= self->priv->width;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y >= self->priv->height;
	}
	if (_tmp0_) {
		result = (guint16) 0xffff;
		return result;
	} else {
		Game* _tmp3_;
		guint8 _tmp4_;
		guint8 _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_rows (_tmp3_);
		_tmp5_ = _tmp4_;
		result = (guint16) ((((guint16) ((guint8) ((x - self->priv->x_offset) / self->priv->x_delta))) << 8) | ((guint8) ((_tmp5_ - 1) - ((y - self->priv->y_offset) / self->priv->y_delta))));
		return result;
	}
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
game_view_render_svg (GameView* self,
                      cairo_t* c,
                      gdouble x,
                      gdouble y,
                      guint width,
                      guint height,
                      const gchar* path,
                      GError** error)
{
	RsvgRectangle viewport = {0};
	GBytes* bytes = NULL;
	GBytes* _tmp0_;
	guint8* data = NULL;
	GBytes* _tmp1_;
	gsize _tmp2_ = 0;
	guint8* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint data_length1;
	gint _data_size_;
	RsvgHandle* handle = NULL;
	guint8* _tmp5_;
	gint _tmp5__length1;
	RsvgHandle* _tmp6_;
	RsvgHandle* _tmp7_;
	RsvgRectangle _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (path != NULL);
	memset (&viewport, 0, sizeof (RsvgRectangle));
	viewport.x = x;
	viewport.y = y;
	viewport.width = (gdouble) width;
	viewport.height = (gdouble) height;
	_tmp0_ = g_resources_lookup_data (path, 0, &_inner_error0_);
	bytes = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = bytes;
	_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup4 (_tmp3_, _tmp2_) : _tmp3_;
	_tmp4__length1 = _tmp2_;
	data = _tmp4_;
	data_length1 = _tmp4__length1;
	_data_size_ = data_length1;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	_tmp6_ = rsvg_handle_new_from_data (_tmp5_, _tmp5__length1, &_inner_error0_);
	handle = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		data = (g_free (data), NULL);
		_g_bytes_unref0 (bytes);
		return;
	}
	_tmp7_ = handle;
	_tmp8_ = viewport;
	rsvg_handle_render_document (_tmp7_, c, &_tmp8_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (handle);
		data = (g_free (data), NULL);
		_g_bytes_unref0 (bytes);
		return;
	}
	_g_object_unref0 (handle);
	data = (g_free (data), NULL);
	_g_bytes_unref0 (bytes);
}

static gchar*
game_view_get_block_name (GameView* self,
                          guint8 block_id)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (block_id) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("blue");
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("green");
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("yellow");
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("red");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
	}
}

static void
game_view_draw_block (GameView* self,
                      cairo_t* c,
                      gdouble x,
                      gdouble y,
                      guint x_size,
                      guint y_size,
                      guint8 block_id,
                      const gchar* theme)
{
	gchar* block_name = NULL;
	gchar* _tmp0_;
	gchar* name = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = game_view_get_block_name (self, block_id);
	block_name = _tmp0_;
	_tmp1_ = g_strdup_printf ("/org/gnome/SwellFoop/themes/%s/%s.svg", theme, block_name);
	name = _tmp1_;
	{
		game_view_render_svg (self, c, x, y, x_size, y_size, name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		_g_free0 (block_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (name);
	_g_free0 (block_name);
}

static void
game_view_draw_cursor (GameView* self,
                       cairo_t* c,
                       gdouble x,
                       gdouble y,
                       guint x_size,
                       guint y_size,
                       const gchar* theme)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/SwellFoop/themes/%s/%s.svg", theme, "highlight");
	name = _tmp0_;
	{
		game_view_render_svg (self, c, x, y, x_size, y_size, name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (name);
}

GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	return self;
}

GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}

 G_GNUC_NO_INLINE static GType
game_view_animation_etype_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_VIEW_ANIMATION_ETYPE_APPEAR, "GAME_VIEW_ANIMATION_ETYPE_APPEAR", "appear"}, {GAME_VIEW_ANIMATION_ETYPE_DESTROY, "GAME_VIEW_ANIMATION_ETYPE_DESTROY", "destroy"}, {GAME_VIEW_ANIMATION_ETYPE_MOVE, "GAME_VIEW_ANIMATION_ETYPE_MOVE", "move"}, {GAME_VIEW_ANIMATION_ETYPE_SELECT, "GAME_VIEW_ANIMATION_ETYPE_SELECT", "select"}, {0, NULL, NULL}};
	GType game_view_animation_etype_type_id;
	game_view_animation_etype_type_id = g_enum_register_static ("GameViewAnimationeType", values);
	return game_view_animation_etype_type_id;
}

GType
game_view_animation_etype_get_type (void)
{
	static gsize game_view_animation_etype_type_id__once = 0;
	if (g_once_init_enter (&game_view_animation_etype_type_id__once)) {
		GType game_view_animation_etype_type_id;
		game_view_animation_etype_type_id = game_view_animation_etype_get_type_once ();
		g_once_init_leave (&game_view_animation_etype_type_id__once, game_view_animation_etype_type_id);
	}
	return game_view_animation_etype_type_id__once;
}

GameViewAnimation*
game_view_animation_construct (GType object_type,
                               GameViewAnimationeType type,
                               guint8 x,
                               guint8 y,
                               guint8 block_type,
                               guint8 dx,
                               guint8 dy,
                               Tile* t)
{
	GameViewAnimation * self = NULL;
	GDateTime* _tmp1_;
	self = (GameViewAnimation*) g_object_new (object_type, NULL);
	self->animation_type = type;
	self->x = x;
	self->y = y;
	self->block_type = block_type;
	self->dx = dx;
	self->dy = dy;
	if (NULL != t) {
		Tile* _tmp0_;
		_tmp0_ = _g_object_ref0 (t);
		_g_object_unref0 (self->tile);
		self->tile = _tmp0_;
	}
	_tmp1_ = g_date_time_new_now_utc ();
	_g_date_time_unref0 (self->start_time);
	self->start_time = _tmp1_;
	return self;
}

GameViewAnimation*
game_view_animation_new (GameViewAnimationeType type,
                         guint8 x,
                         guint8 y,
                         guint8 block_type,
                         guint8 dx,
                         guint8 dy,
                         Tile* t)
{
	return game_view_animation_construct (GAME_VIEW_TYPE_ANIMATION, type, x, y, block_type, dx, dy, t);
}

gboolean
game_view_animation_less_than (GameViewAnimation* self,
                               GameViewAnimation* source)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (self->y > source->y) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (self->y == source->y) {
			_tmp0_ = self->x < source->x;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}

static void
game_view_animation_class_init (GameViewAnimationClass * klass,
                                gpointer klass_data)
{
	game_view_animation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = game_view_animation_finalize;
}

static void
game_view_animation_instance_init (GameViewAnimation * self,
                                   gpointer klass)
{
}

static void
game_view_animation_finalize (GObject * obj)
{
	GameViewAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_VIEW_TYPE_ANIMATION, GameViewAnimation);
	_g_date_time_unref0 (self->start_time);
	_g_object_unref0 (self->tile);
	G_OBJECT_CLASS (game_view_animation_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
game_view_animation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewAnimationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_animation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameViewAnimation), 0, (GInstanceInitFunc) game_view_animation_instance_init, NULL };
	GType game_view_animation_type_id;
	game_view_animation_type_id = g_type_register_static (G_TYPE_OBJECT, "GameViewAnimation", &g_define_type_info, 0);
	return game_view_animation_type_id;
}

GType
game_view_animation_get_type (void)
{
	static gsize game_view_animation_type_id__once = 0;
	if (g_once_init_enter (&game_view_animation_type_id__once)) {
		GType game_view_animation_type_id;
		game_view_animation_type_id = game_view_animation_get_type_once ();
		g_once_init_leave (&game_view_animation_type_id__once, game_view_animation_type_id);
	}
	return game_view_animation_type_id__once;
}

static gboolean
game_view_ordered_list_add (GameViewOrderedList* self,
                            GameViewAnimation* a)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
			gint _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) self);
			_tmp4_ = _tmp3_;
			if (i < _tmp4_) {
				gpointer _tmp5_;
				GameViewAnimation* _tmp6_;
				_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) self, i);
				_tmp6_ = (GameViewAnimation*) _tmp5_;
				_tmp2_ = !game_view_animation_less_than (a, _tmp6_);
				_g_object_unref0 (_tmp6_);
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	gee_abstract_list_insert ((GeeAbstractList*) self, i, a);
	result = TRUE;
	return result;
}

static gboolean
game_view_ordered_list_contain_only (GameViewOrderedList* self,
                                     GameViewAnimationeType t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gpointer _tmp4_;
				GameViewAnimation* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) self);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) self, i);
				_tmp5_ = (GameViewAnimation*) _tmp4_;
				_tmp6_ = _tmp5_->animation_type != t;
				_g_object_unref0 (_tmp5_);
				if (_tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static void
game_view_ordered_list_remove_type (GameViewOrderedList* self,
                                    GameViewAnimationeType t)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) self);
		_tmp1_ = _tmp0_;
		i = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gpointer _tmp4_;
				GameViewAnimation* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					i = i - 1;
					_tmp3_ = i;
				}
				_tmp2_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) self, i - 1);
				_tmp5_ = (GameViewAnimation*) _tmp4_;
				_tmp6_ = _tmp5_->animation_type == t;
				_g_object_unref0 (_tmp5_);
				if (_tmp6_) {
					gpointer _tmp7_;
					GameViewAnimation* _tmp8_;
					_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, i - 1);
					_tmp8_ = (GameViewAnimation*) _tmp7_;
					_g_object_unref0 (_tmp8_);
				}
			}
		}
	}
}

static GameViewOrderedList*
game_view_ordered_list_construct (GType object_type)
{
	GameViewOrderedList * self = NULL;
	self = (GameViewOrderedList*) gee_array_list_construct (object_type, GAME_VIEW_TYPE_ANIMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}

static GameViewOrderedList*
game_view_ordered_list_new (void)
{
	return game_view_ordered_list_construct (GAME_VIEW_TYPE_ORDERED_LIST);
}

static void
game_view_ordered_list_class_init (GameViewOrderedListClass * klass,
                                   gpointer klass_data)
{
	game_view_ordered_list_parent_class = g_type_class_peek_parent (klass);
}

static void
game_view_ordered_list_instance_init (GameViewOrderedList * self,
                                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
game_view_ordered_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewOrderedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_ordered_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameViewOrderedList), 0, (GInstanceInitFunc) game_view_ordered_list_instance_init, NULL };
	GType game_view_ordered_list_type_id;
	game_view_ordered_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GameViewOrderedList", &g_define_type_info, 0);
	return game_view_ordered_list_type_id;
}

static GType
game_view_ordered_list_get_type (void)
{
	static gsize game_view_ordered_list_type_id__once = 0;
	if (g_once_init_enter (&game_view_ordered_list_type_id__once)) {
		GType game_view_ordered_list_type_id;
		game_view_ordered_list_type_id = game_view_ordered_list_get_type_once ();
		g_once_init_leave (&game_view_ordered_list_type_id__once, game_view_ordered_list_type_id);
	}
	return game_view_ordered_list_type_id__once;
}

static void
_vala_array_add1 (GameViewAnimation** * array,
                  gint* length,
                  gint* size,
                  GameViewAnimation* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GameViewAnimation*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_game_view_redraw_gsource_once_func (gpointer self)
{
	game_view_redraw ((GameView*) self);
}

static void
_game_view___lambda9_ (GameView* self,
                       GtkDrawingArea* area,
                       cairo_t* c,
                       gint width,
                       gint height)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (area != NULL);
	g_return_if_fail (c != NULL);
	self->priv->width = width;
	self->priv->height = height;
	if (!game_view_is_uninitialized (self)) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->frozen) {
			_tmp1_ = !self->priv->frozen_board_initialized;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Game* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		Game* _tmp5_;
		guint8 _tmp6_;
		guint8 _tmp7_;
		Game* _tmp8_;
		guint8 _tmp9_;
		guint8 _tmp10_;
		Game* _tmp11_;
		guint8 _tmp12_;
		guint8 _tmp13_;
		GDateTime* now = NULL;
		GDateTime* _tmp14_;
		gint animation_index = 0;
		GameViewAnimation** moves_to_do = NULL;
		GameViewAnimation** _tmp15_;
		gint moves_to_do_length1;
		gint _moves_to_do_size_;
		gboolean _tmp130_ = FALSE;
		GDateTime* _tmp131_;
		_tmp2_ = self->priv->game;
		_tmp3_ = game_get_columns (_tmp2_);
		_tmp4_ = _tmp3_;
		self->priv->x_delta = (guint) (width / _tmp4_);
		_tmp5_ = self->priv->game;
		_tmp6_ = game_get_rows (_tmp5_);
		_tmp7_ = _tmp6_;
		self->priv->y_delta = (guint) (height / _tmp7_);
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_columns (_tmp8_);
		_tmp10_ = _tmp9_;
		self->priv->x_offset = (width - (self->priv->x_delta * _tmp10_)) / 2;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_rows (_tmp11_);
		_tmp13_ = _tmp12_;
		self->priv->y_offset = (height - (self->priv->y_delta * _tmp13_)) / 2;
		_tmp14_ = g_date_time_new_now_utc ();
		now = _tmp14_;
		animation_index = 0;
		_tmp15_ = g_new0 (GameViewAnimation*, 0 + 1);
		moves_to_do = _tmp15_;
		moves_to_do_length1 = 0;
		_moves_to_do_size_ = moves_to_do_length1;
		if (self->priv->first_draw) {
			GameViewOrderedList* _tmp16_;
			self->priv->first_draw = FALSE;
			_tmp16_ = self->priv->animations;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp16_);
			{
				gint y = 0;
				Game* _tmp17_;
				guint8 _tmp18_;
				guint8 _tmp19_;
				_tmp17_ = self->priv->game;
				_tmp18_ = game_get_rows (_tmp17_);
				_tmp19_ = _tmp18_;
				y = _tmp19_ - 1;
				{
					gboolean _tmp20_ = FALSE;
					_tmp20_ = TRUE;
					while (TRUE) {
						if (!_tmp20_) {
							gint _tmp21_;
							y = y - 1;
							_tmp21_ = y;
						}
						_tmp20_ = FALSE;
						if (!(y >= 0)) {
							break;
						}
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp22_ = FALSE;
								_tmp22_ = TRUE;
								while (TRUE) {
									Game* _tmp24_;
									guint8 _tmp25_;
									guint8 _tmp26_;
									gboolean _tmp27_ = FALSE;
									Game* _tmp28_;
									Tile** _tmp29_;
									gint _tmp29__length1;
									gint _tmp29__length2;
									Tile* _tmp30_;
									if (!_tmp22_) {
										gint _tmp23_;
										x = x + 1;
										_tmp23_ = x;
									}
									_tmp22_ = FALSE;
									_tmp24_ = self->priv->game;
									_tmp25_ = game_get_columns (_tmp24_);
									_tmp26_ = _tmp25_;
									if (!(x < ((gint) _tmp26_))) {
										break;
									}
									_tmp28_ = self->priv->game;
									_tmp29_ = _tmp28_->current_board;
									_tmp29__length1 = _tmp28_->current_board_length1;
									_tmp29__length2 = _tmp28_->current_board_length2;
									_tmp30_ = _tmp29_[(y * _tmp29__length2) + x];
									if (NULL != _tmp30_) {
										Game* _tmp31_;
										Tile** _tmp32_;
										gint _tmp32__length1;
										gint _tmp32__length2;
										Tile* _tmp33_;
										gboolean _tmp34_;
										gboolean _tmp35_;
										_tmp31_ = self->priv->game;
										_tmp32_ = _tmp31_->current_board;
										_tmp32__length1 = _tmp31_->current_board_length1;
										_tmp32__length2 = _tmp31_->current_board_length2;
										_tmp33_ = _tmp32_[(y * _tmp32__length2) + x];
										_tmp34_ = tile_get_closed (_tmp33_);
										_tmp35_ = _tmp34_;
										_tmp27_ = !_tmp35_;
									} else {
										_tmp27_ = FALSE;
									}
									if (_tmp27_) {
										GameViewOrderedList* _tmp36_;
										Game* _tmp37_;
										Tile** _tmp38_;
										gint _tmp38__length1;
										gint _tmp38__length2;
										Tile* _tmp39_;
										guint8 _tmp40_;
										guint8 _tmp41_;
										GameViewAnimation* _tmp42_;
										GameViewAnimation* _tmp43_;
										_tmp36_ = self->priv->animations;
										_tmp37_ = self->priv->game;
										_tmp38_ = _tmp37_->current_board;
										_tmp38__length1 = _tmp37_->current_board_length1;
										_tmp38__length2 = _tmp37_->current_board_length2;
										_tmp39_ = _tmp38_[(y * _tmp38__length2) + x];
										_tmp40_ = tile_get_color (_tmp39_);
										_tmp41_ = _tmp40_;
										_tmp42_ = game_view_animation_new (GAME_VIEW_ANIMATION_ETYPE_APPEAR, (guint8) x, (guint8) y, _tmp41_, (guint8) 0xff, (guint8) 0xff, NULL);
										_tmp43_ = _tmp42_;
										game_view_ordered_list_add (_tmp36_, _tmp43_);
										_g_object_unref0 (_tmp43_);
									}
								}
							}
						}
					}
				}
			}
		}
		{
			gint y = 0;
			Game* _tmp44_;
			guint8 _tmp45_;
			guint8 _tmp46_;
			_tmp44_ = self->priv->game;
			_tmp45_ = game_get_rows (_tmp44_);
			_tmp46_ = _tmp45_;
			y = _tmp46_ - 1;
			{
				gboolean _tmp47_ = FALSE;
				_tmp47_ = TRUE;
				while (TRUE) {
					if (!_tmp47_) {
						gint _tmp48_;
						y = y - 1;
						_tmp48_ = y;
					}
					_tmp47_ = FALSE;
					if (!(y >= 0)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp49_ = FALSE;
							_tmp49_ = TRUE;
							while (TRUE) {
								Game* _tmp51_;
								guint8 _tmp52_;
								guint8 _tmp53_;
								if (!_tmp49_) {
									gint _tmp50_;
									x = x + 1;
									_tmp50_ = x;
								}
								_tmp49_ = FALSE;
								_tmp51_ = self->priv->game;
								_tmp52_ = game_get_columns (_tmp51_);
								_tmp53_ = _tmp52_;
								if (!(x < ((gint) _tmp53_))) {
									break;
								}
								if (self->priv->frozen) {
									Game* _tmp54_;
									guint8 _tmp55_;
									guint8 _tmp56_;
									guint8* _tmp57_;
									gint _tmp57__length1;
									gint _tmp57__length2;
									guint8 _tmp58_;
									const gchar* _tmp59_;
									_tmp54_ = self->priv->game;
									_tmp55_ = game_get_rows (_tmp54_);
									_tmp56_ = _tmp55_;
									_tmp57_ = self->priv->frozen_board;
									_tmp57__length1 = self->priv->frozen_board_length1;
									_tmp57__length2 = self->priv->frozen_board_length2;
									_tmp58_ = _tmp57_[(x * _tmp57__length2) + y];
									_tmp59_ = self->priv->theme;
									game_view_draw_block (self, c, (gdouble) (self->priv->x_offset + (self->priv->x_delta * x)), (gdouble) (self->priv->y_offset + (self->priv->y_delta * ((_tmp56_ - 1) - y))), self->priv->x_delta, self->priv->y_delta, _tmp58_, _tmp59_);
								} else {
									gboolean _tmp60_ = FALSE;
									gboolean _tmp61_ = FALSE;
									GameViewOrderedList* _tmp62_;
									gint _tmp63_;
									gint _tmp64_;
									_tmp62_ = self->priv->animations;
									_tmp63_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp62_);
									_tmp64_ = _tmp63_;
									if (_tmp64_ > animation_index) {
										GameViewOrderedList* _tmp65_;
										gpointer _tmp66_;
										GameViewAnimation* _tmp67_;
										_tmp65_ = self->priv->animations;
										_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, animation_index);
										_tmp67_ = (GameViewAnimation*) _tmp66_;
										_tmp61_ = x == ((gint) _tmp67_->x);
										_g_object_unref0 (_tmp67_);
									} else {
										_tmp61_ = FALSE;
									}
									if (_tmp61_) {
										GameViewOrderedList* _tmp68_;
										gpointer _tmp69_;
										GameViewAnimation* _tmp70_;
										_tmp68_ = self->priv->animations;
										_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, animation_index);
										_tmp70_ = (GameViewAnimation*) _tmp69_;
										_tmp60_ = y == ((gint) _tmp70_->y);
										_g_object_unref0 (_tmp70_);
									} else {
										_tmp60_ = FALSE;
									}
									if (_tmp60_) {
										{
											gboolean _tmp71_ = FALSE;
											_tmp71_ = TRUE;
											while (TRUE) {
												gboolean _tmp72_ = FALSE;
												gboolean _tmp73_ = FALSE;
												GameViewOrderedList* _tmp74_;
												gint _tmp75_;
												gint _tmp76_;
												GameViewOrderedList* _tmp83_;
												gpointer _tmp84_;
												GameViewAnimation* _tmp85_;
												gboolean _tmp86_;
												if (!_tmp71_) {
												}
												_tmp71_ = FALSE;
												_tmp74_ = self->priv->animations;
												_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
												_tmp76_ = _tmp75_;
												if (_tmp76_ > animation_index) {
													GameViewOrderedList* _tmp77_;
													gpointer _tmp78_;
													GameViewAnimation* _tmp79_;
													_tmp77_ = self->priv->animations;
													_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp77_, animation_index);
													_tmp79_ = (GameViewAnimation*) _tmp78_;
													_tmp73_ = x == ((gint) _tmp79_->x);
													_g_object_unref0 (_tmp79_);
												} else {
													_tmp73_ = FALSE;
												}
												if (_tmp73_) {
													GameViewOrderedList* _tmp80_;
													gpointer _tmp81_;
													GameViewAnimation* _tmp82_;
													_tmp80_ = self->priv->animations;
													_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp80_, animation_index);
													_tmp82_ = (GameViewAnimation*) _tmp81_;
													_tmp72_ = y == ((gint) _tmp82_->y);
													_g_object_unref0 (_tmp82_);
												} else {
													_tmp72_ = FALSE;
												}
												if (!_tmp72_) {
													break;
												}
												_tmp83_ = self->priv->animations;
												_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp83_, animation_index);
												_tmp85_ = (GameViewAnimation*) _tmp84_;
												_tmp86_ = _tmp85_->animation_type != GAME_VIEW_ANIMATION_ETYPE_MOVE;
												_g_object_unref0 (_tmp85_);
												if (_tmp86_) {
													GameViewOrderedList* _tmp87_;
													gpointer _tmp88_;
													GameViewAnimation* _tmp89_;
													GDateTime* _tmp90_;
													gboolean _tmp91_;
													_tmp87_ = self->priv->animations;
													_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, animation_index);
													_tmp89_ = (GameViewAnimation*) _tmp88_;
													_tmp90_ = now;
													_tmp91_ = game_view_do_animation (self, c, _tmp89_, _tmp90_);
													_g_object_unref0 (_tmp89_);
													if (_tmp91_) {
														gint _tmp92_;
														animation_index = animation_index + 1;
														_tmp92_ = animation_index;
													} else {
														GameViewOrderedList* _tmp93_;
														gpointer _tmp94_;
														GameViewAnimation* _tmp95_;
														_tmp93_ = self->priv->animations;
														_tmp94_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp93_, animation_index);
														_tmp95_ = (GameViewAnimation*) _tmp94_;
														_g_object_unref0 (_tmp95_);
													}
												} else {
													GameViewOrderedList* _tmp96_;
													gpointer _tmp97_;
													gint _tmp98_;
													_tmp96_ = self->priv->animations;
													_tmp97_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, animation_index);
													_vala_array_add1 (&moves_to_do, &moves_to_do_length1, &_moves_to_do_size_, (GameViewAnimation*) _tmp97_);
													animation_index = animation_index + 1;
													_tmp98_ = animation_index;
												}
											}
										}
									} else {
										gboolean _tmp99_ = FALSE;
										Game* _tmp100_;
										Tile** _tmp101_;
										gint _tmp101__length1;
										gint _tmp101__length2;
										Tile* _tmp102_;
										_tmp100_ = self->priv->game;
										_tmp101_ = _tmp100_->current_board;
										_tmp101__length1 = _tmp100_->current_board_length1;
										_tmp101__length2 = _tmp100_->current_board_length2;
										_tmp102_ = _tmp101_[(y * _tmp101__length2) + x];
										if (NULL != _tmp102_) {
											Game* _tmp103_;
											Tile** _tmp104_;
											gint _tmp104__length1;
											gint _tmp104__length2;
											Tile* _tmp105_;
											gboolean _tmp106_;
											gboolean _tmp107_;
											_tmp103_ = self->priv->game;
											_tmp104_ = _tmp103_->current_board;
											_tmp104__length1 = _tmp103_->current_board_length1;
											_tmp104__length2 = _tmp103_->current_board_length2;
											_tmp105_ = _tmp104_[(y * _tmp104__length2) + x];
											_tmp106_ = tile_get_closed (_tmp105_);
											_tmp107_ = _tmp106_;
											_tmp99_ = !_tmp107_;
										} else {
											_tmp99_ = FALSE;
										}
										if (_tmp99_) {
											Game* _tmp108_;
											guint8 _tmp109_;
											guint8 _tmp110_;
											Game* _tmp111_;
											Tile** _tmp112_;
											gint _tmp112__length1;
											gint _tmp112__length2;
											Tile* _tmp113_;
											guint8 _tmp114_;
											guint8 _tmp115_;
											const gchar* _tmp116_;
											_tmp108_ = self->priv->game;
											_tmp109_ = game_get_rows (_tmp108_);
											_tmp110_ = _tmp109_;
											_tmp111_ = self->priv->game;
											_tmp112_ = _tmp111_->current_board;
											_tmp112__length1 = _tmp111_->current_board_length1;
											_tmp112__length2 = _tmp111_->current_board_length2;
											_tmp113_ = _tmp112_[(y * _tmp112__length2) + x];
											_tmp114_ = tile_get_color (_tmp113_);
											_tmp115_ = _tmp114_;
											_tmp116_ = self->priv->theme;
											game_view_draw_block (self, c, (gdouble) (self->priv->x_offset + (self->priv->x_delta * x)), (gdouble) (self->priv->y_offset + (self->priv->y_delta * ((_tmp110_ - 1) - y))), self->priv->x_delta, self->priv->y_delta, _tmp115_, _tmp116_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp117_ = FALSE;
				_tmp117_ = TRUE;
				while (TRUE) {
					GameViewAnimation** _tmp119_;
					gint _tmp119__length1;
					GameViewAnimation** _tmp120_;
					gint _tmp120__length1;
					GameViewAnimation* _tmp121_;
					GDateTime* _tmp122_;
					if (!_tmp117_) {
						gint _tmp118_;
						i = i + 1;
						_tmp118_ = i;
					}
					_tmp117_ = FALSE;
					_tmp119_ = moves_to_do;
					_tmp119__length1 = moves_to_do_length1;
					if (!(i < _tmp119__length1)) {
						break;
					}
					_tmp120_ = moves_to_do;
					_tmp120__length1 = moves_to_do_length1;
					_tmp121_ = _tmp120_[i];
					_tmp122_ = now;
					if (!game_view_do_animation (self, c, _tmp121_, _tmp122_)) {
						GameViewOrderedList* _tmp123_;
						GameViewAnimation** _tmp124_;
						gint _tmp124__length1;
						GameViewAnimation* _tmp125_;
						_tmp123_ = self->priv->animations;
						_tmp124_ = moves_to_do;
						_tmp124__length1 = moves_to_do_length1;
						_tmp125_ = _tmp124_[i];
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp123_, _tmp125_);
					}
				}
			}
		}
		if (self->priv->draw_highlight) {
			Game* _tmp126_;
			guint8 _tmp127_;
			guint8 _tmp128_;
			const gchar* _tmp129_;
			_tmp126_ = self->priv->game;
			_tmp127_ = game_get_rows (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = self->priv->theme;
			game_view_draw_cursor (self, c, (gdouble) (self->priv->x_offset + (self->priv->x_delta * self->priv->x_cursor)), (gdouble) (self->priv->y_offset + (self->priv->y_delta * ((_tmp128_ - 1) - self->priv->y_cursor))), self->priv->x_delta, self->priv->y_delta, _tmp129_);
		}
		_tmp131_ = now;
		if (game_view_animate_score (self, c, _tmp131_, width, height)) {
			_tmp130_ = TRUE;
		} else {
			GameViewOrderedList* _tmp132_;
			gint _tmp133_;
			gint _tmp134_;
			_tmp132_ = self->priv->animations;
			_tmp133_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp130_ = _tmp134_ > 0;
		}
		if (_tmp130_) {
			g_timeout_add_once ((guint) 3, _game_view_redraw_gsource_once_func, self);
		}
		moves_to_do = (_vala_array_free (moves_to_do, moves_to_do_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_date_time_unref0 (now);
	}
}

static void
__game_view___lambda9__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                   cairo_t* cr,
                                                   gint width,
                                                   gint height,
                                                   gpointer self)
{
	_game_view___lambda9_ ((GameView*) self, drawing_area, cr, width, height);
}

static void
_game_view___lambda10_ (GameView* self,
                        gdouble x,
                        gdouble y)
{
	game_view_new_position (self, (gint) x, (gint) y);
}

static void
__game_view___lambda10__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self)
{
	_game_view___lambda10_ ((GameView*) self, x, y);
}

static void
_game_view___lambda11_ (GameView* self,
                        gdouble x,
                        gdouble y)
{
	game_view_new_position (self, (gint) x, (gint) y);
}

static void
__game_view___lambda11__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	_game_view___lambda11_ ((GameView*) self, x, y);
}

static void
_game_view___lambda12_ (GameView* self)
{
	game_view_new_position (self, -1, -1);
}

static void
__game_view___lambda12__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                           gpointer self)
{
	_game_view___lambda12_ ((GameView*) self);
}

static gboolean
_game_view___lambda13_ (GameView* self,
                        GtkEventControllerKey* controller,
                        guint keyval,
                        guint keycode,
                        GdkModifierType state)
{
	g_return_val_if_fail (controller != NULL, FALSE);
	game_view_keypress (self, keyval, keycode);
}

static gboolean
__game_view___lambda13__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                              guint keyval,
                                                              guint keycode,
                                                              GdkModifierType state,
                                                              gpointer self)
{
	gboolean result;
	result = _game_view___lambda13_ ((GameView*) self, _sender, keyval, keycode, state);
	return result;
}

static gboolean
_game_view___lambda14_ (GameView* self,
                        GdkEvent* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (gdk_event_get_event_type (event)) {
		case GDK_BUTTON_PRESS:
		{
			self->priv->mouse_pressed = TRUE;
			game_view_redraw (self);
			result = TRUE;
			return result;
		}
		case GDK_BUTTON_RELEASE:
		{
			self->priv->mouse_pressed = FALSE;
			if (((gint) self->priv->mouse_segment) == 0xffff) {
				game_view_redraw (self);
			} else {
				game_view_cursor_click (self, (guint8) (self->priv->mouse_segment >> 8), (guint8) self->priv->mouse_segment);
			}
			self->priv->draw_highlight = FALSE;
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
__game_view___lambda14__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                           GdkEvent* event,
                                                           gpointer self)
{
	gboolean result;
	result = _game_view___lambda14_ ((GameView*) self, event);
	return result;
}

static GObject *
game_view_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameView * self;
	GtkEventControllerMotion* mouse_position = NULL;
	GtkEventControllerMotion* _tmp0_;
	GtkEventControllerMotion* _tmp1_;
	GtkEventControllerMotion* _tmp2_;
	GtkEventControllerMotion* _tmp3_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp4_;
	GtkEventControllerLegacy* mouse_click = NULL;
	GtkEventControllerLegacy* _tmp5_;
	GtkEventControllerKey* _tmp6_;
	GtkEventControllerLegacy* _tmp7_;
	GtkEventControllerLegacy* _tmp8_;
	GtkEventController* _tmp9_;
	GtkEventControllerKey* _tmp10_;
	GtkEventController* _tmp11_;
	GtkEventControllerMotion* _tmp12_;
	GtkEventController* _tmp13_;
	parent_class = G_OBJECT_CLASS (game_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, __game_view___lambda9__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp0_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	mouse_position = _tmp0_;
	_tmp1_ = mouse_position;
	g_signal_connect_object (_tmp1_, "motion", (GCallback) __game_view___lambda10__gtk_event_controller_motion_motion, self, 0);
	_tmp2_ = mouse_position;
	g_signal_connect_object (_tmp2_, "enter", (GCallback) __game_view___lambda11__gtk_event_controller_motion_enter, self, 0);
	_tmp3_ = mouse_position;
	g_signal_connect_object (_tmp3_, "leave", (GCallback) __game_view___lambda12__gtk_event_controller_motion_leave, self, 0);
	_tmp4_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp4_;
	_tmp5_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
	mouse_click = _tmp5_;
	_tmp6_ = key_controller;
	g_signal_connect_object (_tmp6_, "key-pressed", (GCallback) __game_view___lambda13__gtk_event_controller_key_key_pressed, self, 0);
	_tmp7_ = mouse_click;
	g_signal_connect_object (_tmp7_, "event", (GCallback) __game_view___lambda14__gtk_event_controller_legacy_event, self, 0);
	_tmp8_ = mouse_click;
	_tmp9_ = _g_object_ref0 ((GtkEventController*) _tmp8_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp9_);
	_tmp10_ = key_controller;
	_tmp11_ = _g_object_ref0 ((GtkEventController*) _tmp10_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp11_);
	_tmp12_ = mouse_position;
	_tmp13_ = _g_object_ref0 ((GtkEventController*) _tmp12_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp13_);
	_g_object_unref0 (mouse_click);
	_g_object_unref0 (key_controller);
	_g_object_unref0 (mouse_position);
	return obj;
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = game_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	GameViewOrderedList* _tmp0_;
	self->priv = game_view_get_instance_private (self);
	_tmp0_ = game_view_ordered_list_new ();
	self->priv->animations = _tmp0_;
	self->priv->game_complete = FALSE;
	self->priv->draw_highlight = FALSE;
	self->priv->score_delta = (guint) 0;
	self->priv->first_draw = TRUE;
	self->priv->mouse_segment = (guint16) 0xffff;
	self->priv->mouse_pressed = FALSE;
	self->priv->x_cursor = (guint) -1;
	self->priv->y_cursor = (guint) -1;
	self->priv->frozen_board_initialized = FALSE;
	self->priv->frozen = FALSE;
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->animations);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->theme);
	_g_date_time_unref0 (self->priv->animate_score_delta);
	self->priv->frozen_board = (g_free (self->priv->frozen_board), NULL);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

