/* NotificationController.c generated by valac 0.56.4, the Vala compiler
 * generated from NotificationController.vala, do not modify */

/*
    NotificationController.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libnotify/notify.h>
#include <stdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER (steadyflow_notification_controller_get_type ())
#define STEADYFLOW_NOTIFICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER, SteadyflowNotificationController))
#define STEADYFLOW_NOTIFICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER, SteadyflowNotificationControllerClass))
#define STEADYFLOW_IS_NOTIFICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER))
#define STEADYFLOW_IS_NOTIFICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER))
#define STEADYFLOW_NOTIFICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER, SteadyflowNotificationControllerClass))

typedef struct _SteadyflowNotificationController SteadyflowNotificationController;
typedef struct _SteadyflowNotificationControllerClass SteadyflowNotificationControllerClass;
typedef struct _SteadyflowNotificationControllerPrivate SteadyflowNotificationControllerPrivate;

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())
enum  {
	STEADYFLOW_NOTIFICATION_CONTROLLER_0_PROPERTY,
	STEADYFLOW_NOTIFICATION_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* steadyflow_notification_controller_properties[STEADYFLOW_NOTIFICATION_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE (steadyflow_core_idownload_service_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadService))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadServiceIface))

typedef struct _SteadyflowCoreIDownloadService SteadyflowCoreIDownloadService;
typedef struct _SteadyflowCoreIDownloadServiceIface SteadyflowCoreIDownloadServiceIface;

#define STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE (steadyflow_core_isettings_service_get_type ())
#define STEADYFLOW_CORE_ISETTINGS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE, SteadyflowCoreISettingsService))
#define STEADYFLOW_CORE_IS_ISETTINGS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE))
#define STEADYFLOW_CORE_ISETTINGS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE, SteadyflowCoreISettingsServiceIface))

typedef struct _SteadyflowCoreISettingsService SteadyflowCoreISettingsService;
typedef struct _SteadyflowCoreISettingsServiceIface SteadyflowCoreISettingsServiceIface;

struct _SteadyflowNotificationController {
	GObject parent_instance;
	SteadyflowNotificationControllerPrivate * priv;
};

struct _SteadyflowNotificationControllerClass {
	GObjectClass parent_class;
};

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowNotificationControllerPrivate {
	GeeSet* start_notified;
	GeeSet* finished_notified;
};

struct _SteadyflowCoreIDownloadServiceIface {
	GTypeInterface parent_iface;
	SteadyflowCoreIDownloadFile* (*get_file_by_uid) (SteadyflowCoreIDownloadService* self, gint uid);
	SteadyflowCoreIDownloadFile* (*add_file) (SteadyflowCoreIDownloadService* self, const gchar* url, const gchar* local_name, SteadyflowCoreIDownloadFileFinishAction finish_action, const gchar* finish_command, GError** error);
	void (*remove_file) (SteadyflowCoreIDownloadService* self, SteadyflowCoreIDownloadFile* file);
	GeeList* (*get_files) (SteadyflowCoreIDownloadService* self);
};

struct _SteadyflowCoreISettingsServiceIface {
	GTypeInterface parent_iface;
	gboolean (*get_boolean) (SteadyflowCoreISettingsService* self, const gchar* key);
	gint (*get_int) (SteadyflowCoreISettingsService* self, const gchar* key);
	gint (*get_enum) (SteadyflowCoreISettingsService* self, const gchar* key);
	gchar* (*get_string) (SteadyflowCoreISettingsService* self, const gchar* key);
	void (*set_boolean) (SteadyflowCoreISettingsService* self, const gchar* key, gboolean value);
	void (*set_int) (SteadyflowCoreISettingsService* self, const gchar* key, gint value);
	void (*set_enum) (SteadyflowCoreISettingsService* self, const gchar* key, gint value);
	void (*set_string) (SteadyflowCoreISettingsService* self, const gchar* key, const gchar* value);
	void (*save) (SteadyflowCoreISettingsService* self);
};

static gint SteadyflowNotificationController_private_offset;
static gpointer steadyflow_notification_controller_parent_class = NULL;

VALA_EXTERN GType steadyflow_notification_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowNotificationController, g_object_unref)
VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
VALA_EXTERN SteadyflowNotificationController* steadyflow_notification_controller_new (void);
VALA_EXTERN SteadyflowNotificationController* steadyflow_notification_controller_construct (GType object_type);
VALA_EXTERN GType steadyflow_core_idownload_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadService, g_object_unref)
VALA_EXTERN SteadyflowCoreIDownloadService* steadyflow_services_get_download (void);
static void steadyflow_notification_controller_on_file_added (SteadyflowNotificationController* self,
                                                       SteadyflowCoreIDownloadFile* file);
static void _steadyflow_notification_controller_on_file_added_steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                                                                     SteadyflowCoreIDownloadFile* file,
                                                                                                     gpointer self);
static void steadyflow_notification_controller_on_file_removed (SteadyflowNotificationController* self,
                                                         SteadyflowCoreIDownloadFile* file);
static void _steadyflow_notification_controller_on_file_removed_steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                                                                         SteadyflowCoreIDownloadFile* file,
                                                                                                         gpointer self);
VALA_EXTERN GeeList* steadyflow_core_idownload_service_get_files (SteadyflowCoreIDownloadService* self);
static void steadyflow_notification_controller_on_status_changed (SteadyflowNotificationController* self,
                                                           SteadyflowCoreIDownloadFile* sender,
                                                           SteadyflowCoreIDownloadFileStatus old_status);
static void _steadyflow_notification_controller_on_status_changed_steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                                                          SteadyflowCoreIDownloadFileStatus old_status,
                                                                                                          gpointer self);
VALA_EXTERN GType steadyflow_core_isettings_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreISettingsService, g_object_unref)
VALA_EXTERN SteadyflowCoreISettingsService* steadyflow_services_get_settings (void);
VALA_EXTERN gboolean steadyflow_core_isettings_service_get_boolean (SteadyflowCoreISettingsService* self,
                                                        const gchar* key);
VALA_EXTERN SteadyflowCoreIDownloadFileStatus steadyflow_core_idownload_file_get_status (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_basename (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_icon_name (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN SteadyflowCoreIDownloadFileFinishAction steadyflow_core_idownload_file_get_finish_action (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN void steadyflow_ui_ui_util_open_file (SteadyflowCoreIDownloadFile* file);
VALA_EXTERN void steadyflow_ui_ui_util_open_folder (SteadyflowCoreIDownloadFile* file);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_finish_command (SteadyflowCoreIDownloadFile* self);
static void steadyflow_notification_controller_finalize (GObject * obj);
static GType steadyflow_notification_controller_get_type_once (void);

static inline gpointer
steadyflow_notification_controller_get_instance_private (SteadyflowNotificationController* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowNotificationController_private_offset);
}

static void
_steadyflow_notification_controller_on_file_added_steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                                                                SteadyflowCoreIDownloadFile* file,
                                                                                                gpointer self)
{
	steadyflow_notification_controller_on_file_added ((SteadyflowNotificationController*) self, file);
}

static void
_steadyflow_notification_controller_on_file_removed_steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                                                                    SteadyflowCoreIDownloadFile* file,
                                                                                                    gpointer self)
{
	steadyflow_notification_controller_on_file_removed ((SteadyflowNotificationController*) self, file);
}

static void
_steadyflow_notification_controller_on_status_changed_steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                                                     SteadyflowCoreIDownloadFileStatus old_status,
                                                                                                     gpointer self)
{
	steadyflow_notification_controller_on_status_changed ((SteadyflowNotificationController*) self, _sender, old_status);
}

SteadyflowNotificationController*
steadyflow_notification_controller_construct (GType object_type)
{
	SteadyflowNotificationController * self = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	SteadyflowCoreIDownloadService* _tmp2_;
	SteadyflowCoreIDownloadService* _tmp3_;
	SteadyflowCoreIDownloadService* _tmp4_;
	SteadyflowCoreIDownloadService* _tmp5_;
	self = (SteadyflowNotificationController*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->start_notified);
	self->priv->start_notified = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_set_new (STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->finished_notified);
	self->priv->finished_notified = (GeeSet*) _tmp1_;
	_tmp2_ = steadyflow_services_get_download ();
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "file-added", (GCallback) _steadyflow_notification_controller_on_file_added_steadyflow_core_idownload_service_file_added, self, 0);
	_tmp4_ = steadyflow_services_get_download ();
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "file-removed", (GCallback) _steadyflow_notification_controller_on_file_removed_steadyflow_core_idownload_service_file_removed, self, 0);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp6_;
		SteadyflowCoreIDownloadService* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _file_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _file_index = 0;
		_tmp6_ = steadyflow_services_get_download ();
		_tmp7_ = _tmp6_;
		_tmp8_ = steadyflow_core_idownload_service_get_files (_tmp7_);
		_tmp9_ = _tmp8_;
		_file_list = _tmp9_;
		_tmp10_ = _file_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_file_size = _tmp12_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			SteadyflowCoreIDownloadFile* _tmp17_;
			GeeSet* _tmp18_;
			SteadyflowCoreIDownloadFile* _tmp19_;
			GeeSet* _tmp20_;
			SteadyflowCoreIDownloadFile* _tmp21_;
			_file_index = _file_index + 1;
			_tmp13_ = _file_index;
			_tmp14_ = _file_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _file_list;
			_tmp16_ = gee_list_get (_tmp15_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp16_;
			_tmp17_ = file;
			g_signal_connect_object (_tmp17_, "status-changed", (GCallback) _steadyflow_notification_controller_on_status_changed_steadyflow_core_idownload_file_status_changed, self, 0);
			_tmp18_ = self->priv->start_notified;
			_tmp19_ = file;
			gee_collection_add ((GeeCollection*) _tmp18_, _tmp19_);
			_tmp20_ = self->priv->finished_notified;
			_tmp21_ = file;
			gee_collection_add ((GeeCollection*) _tmp20_, _tmp21_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	return self;
}

SteadyflowNotificationController*
steadyflow_notification_controller_new (void)
{
	return steadyflow_notification_controller_construct (STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER);
}

static void
steadyflow_notification_controller_on_file_added (SteadyflowNotificationController* self,
                                                  SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_signal_connect_object (file, "status-changed", (GCallback) _steadyflow_notification_controller_on_status_changed_steadyflow_core_idownload_file_status_changed, self, 0);
}

static void
steadyflow_notification_controller_on_file_removed (SteadyflowNotificationController* self,
                                                    SteadyflowCoreIDownloadFile* file)
{
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->start_notified;
	gee_collection_remove ((GeeCollection*) _tmp0_, file);
	_tmp1_ = self->priv->finished_notified;
	gee_collection_remove ((GeeCollection*) _tmp1_, file);
}

static void
steadyflow_notification_controller_on_status_changed (SteadyflowNotificationController* self,
                                                      SteadyflowCoreIDownloadFile* sender,
                                                      SteadyflowCoreIDownloadFileStatus old_status)
{
	SteadyflowCoreISettingsService* _tmp0_;
	SteadyflowCoreISettingsService* _tmp1_;
	SteadyflowCoreIDownloadFileStatus _tmp25_;
	SteadyflowCoreIDownloadFileStatus _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = steadyflow_services_get_settings ();
	_tmp1_ = _tmp0_;
	if (steadyflow_core_isettings_service_get_boolean (_tmp1_, "show-notifications")) {
		{
			gboolean _tmp2_ = FALSE;
			SteadyflowCoreIDownloadFileStatus _tmp3_;
			SteadyflowCoreIDownloadFileStatus _tmp4_;
			_tmp3_ = steadyflow_core_idownload_file_get_status (sender);
			_tmp4_ = _tmp3_;
			if (_tmp4_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING) {
				GeeSet* _tmp5_;
				_tmp5_ = self->priv->start_notified;
				_tmp2_ = !gee_collection_contains ((GeeCollection*) _tmp5_, sender);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				NotifyNotification* _tmp10_;
				NotifyNotification* _tmp11_;
				GeeSet* _tmp12_;
				_tmp6_ = steadyflow_core_idownload_file_get_local_basename (sender);
				_tmp7_ = _tmp6_;
				_tmp8_ = steadyflow_core_idownload_file_get_icon_name (sender);
				_tmp9_ = _tmp8_;
				_tmp10_ = notify_notification_new (_ ("Download Started"), _tmp7_, _tmp9_);
				_tmp11_ = _tmp10_;
				notify_notification_show (_tmp11_, &_inner_error0_);
				_g_object_unref0 (_tmp11_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp12_ = self->priv->start_notified;
				gee_collection_add ((GeeCollection*) _tmp12_, sender);
			} else {
				gboolean _tmp13_ = FALSE;
				SteadyflowCoreIDownloadFileStatus _tmp14_;
				SteadyflowCoreIDownloadFileStatus _tmp15_;
				_tmp14_ = steadyflow_core_idownload_file_get_status (sender);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED) {
					GeeSet* _tmp16_;
					_tmp16_ = self->priv->finished_notified;
					_tmp13_ = !gee_collection_contains ((GeeCollection*) _tmp16_, sender);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					NotifyNotification* _tmp21_;
					NotifyNotification* _tmp22_;
					GeeSet* _tmp23_;
					_tmp17_ = steadyflow_core_idownload_file_get_local_basename (sender);
					_tmp18_ = _tmp17_;
					_tmp19_ = steadyflow_core_idownload_file_get_icon_name (sender);
					_tmp20_ = _tmp19_;
					_tmp21_ = notify_notification_new (_ ("Download Complete"), _tmp18_, _tmp20_);
					_tmp22_ = _tmp21_;
					notify_notification_show (_tmp22_, &_inner_error0_);
					_g_object_unref0 (_tmp22_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp23_ = self->priv->finished_notified;
					gee_collection_add ((GeeCollection*) _tmp23_, sender);
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			FILE* _tmp24_;
			g_clear_error (&_inner_error0_);
			_tmp24_ = stderr;
			fprintf (_tmp24_, "Could not display notification\n");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp25_ = steadyflow_core_idownload_file_get_status (sender);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED) {
		SteadyflowCoreIDownloadFileFinishAction _tmp27_;
		SteadyflowCoreIDownloadFileFinishAction _tmp28_;
		_tmp27_ = steadyflow_core_idownload_file_get_finish_action (sender);
		_tmp28_ = _tmp27_;
		switch (_tmp28_) {
			case STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE:
			{
				steadyflow_ui_ui_util_open_file (sender);
				break;
			}
			case STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER:
			{
				steadyflow_ui_ui_util_open_folder (sender);
				break;
			}
			case STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND:
			{
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp29_ = steadyflow_core_idownload_file_get_finish_command (sender);
				_tmp30_ = _tmp29_;
				if (_tmp30_ != NULL) {
					{
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = steadyflow_core_idownload_file_get_finish_command (sender);
						_tmp32_ = _tmp31_;
						g_spawn_command_line_async (_tmp32_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						FILE* _tmp33_;
						g_clear_error (&_inner_error0_);
						_tmp33_ = stderr;
						fprintf (_tmp33_, "Could not run process\n");
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			default:
			break;
		}
	}
}

static void
steadyflow_notification_controller_class_init (SteadyflowNotificationControllerClass * klass,
                                               gpointer klass_data)
{
	steadyflow_notification_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowNotificationController_private_offset);
	G_OBJECT_CLASS (klass)->finalize = steadyflow_notification_controller_finalize;
}

static void
steadyflow_notification_controller_instance_init (SteadyflowNotificationController * self,
                                                  gpointer klass)
{
	self->priv = steadyflow_notification_controller_get_instance_private (self);
}

static void
steadyflow_notification_controller_finalize (GObject * obj)
{
	SteadyflowNotificationController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_TYPE_NOTIFICATION_CONTROLLER, SteadyflowNotificationController);
	_g_object_unref0 (self->priv->start_notified);
	_g_object_unref0 (self->priv->finished_notified);
	G_OBJECT_CLASS (steadyflow_notification_controller_parent_class)->finalize (obj);
}

static GType
steadyflow_notification_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowNotificationControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_notification_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowNotificationController), 0, (GInstanceInitFunc) steadyflow_notification_controller_instance_init, NULL };
	GType steadyflow_notification_controller_type_id;
	steadyflow_notification_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SteadyflowNotificationController", &g_define_type_info, 0);
	SteadyflowNotificationController_private_offset = g_type_add_instance_private (steadyflow_notification_controller_type_id, sizeof (SteadyflowNotificationControllerPrivate));
	return steadyflow_notification_controller_type_id;
}

GType
steadyflow_notification_controller_get_type (void)
{
	static volatile gsize steadyflow_notification_controller_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_notification_controller_type_id__once)) {
		GType steadyflow_notification_controller_type_id;
		steadyflow_notification_controller_type_id = steadyflow_notification_controller_get_type_once ();
		g_once_init_leave (&steadyflow_notification_controller_type_id__once, steadyflow_notification_controller_type_id);
	}
	return steadyflow_notification_controller_type_id__once;
}

