/* IndicatorController.c generated by valac 0.56.4, the Vala compiler
 * generated from IndicatorController.vala, do not modify */

/*
    IndicatorController.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define STEADYFLOW_INDICATOR_MENU "\n" \
"<ui>\n" \
"\t<popup name=\"IndicatorMenu\">\n" \
"\t\t<menuitem action=\"ShowHide\" />\n" \
"\t\t<menuitem action=\"Add\" />\n" \
"\t\t<separator />\n" \
"\t\t<placeholder name=\"ItemMenus\" />\n" \
"\t\t<separator />\n" \
"\t\t<menuitem action=\"PauseAll\" />\n" \
"\t\t<menuitem action=\"ResumeAll\" />\n" \
"\t\t<separator />\n" \
"\t\t<menuitem action=\"Quit\" />\n" \
"\t</popup>\n" \
"</ui>\n"
#define STEADYFLOW_INSERT_TEMPLATE "\n" \
"<ui>\n" \
"\t<popup name=\"IndicatorMenu\">\n" \
"\t\t<placeholder name=\"ItemMenus\">%s</placeholder>\n" \
"\t</popup>\n" \
"</ui>\n"
#define STEADYFLOW_INDICATOR_CONTROLLER_MAX_FILE_MENU_ENTRIES 6
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_TYPE_INDICATOR_CONTROLLER (steadyflow_indicator_controller_get_type ())
#define STEADYFLOW_INDICATOR_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_TYPE_INDICATOR_CONTROLLER, SteadyflowIndicatorController))
#define STEADYFLOW_INDICATOR_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_TYPE_INDICATOR_CONTROLLER, SteadyflowIndicatorControllerClass))
#define STEADYFLOW_IS_INDICATOR_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_TYPE_INDICATOR_CONTROLLER))
#define STEADYFLOW_IS_INDICATOR_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_TYPE_INDICATOR_CONTROLLER))
#define STEADYFLOW_INDICATOR_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_TYPE_INDICATOR_CONTROLLER, SteadyflowIndicatorControllerClass))

typedef struct _SteadyflowIndicatorController SteadyflowIndicatorController;
typedef struct _SteadyflowIndicatorControllerClass SteadyflowIndicatorControllerClass;
typedef struct _SteadyflowIndicatorControllerPrivate SteadyflowIndicatorControllerPrivate;
enum  {
	STEADYFLOW_INDICATOR_CONTROLLER_0_PROPERTY,
	STEADYFLOW_INDICATOR_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* steadyflow_indicator_controller_properties[STEADYFLOW_INDICATOR_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define STEADYFLOW_UI_TYPE_IINDICATOR_SERVICE (steadyflow_ui_iindicator_service_get_type ())
#define STEADYFLOW_UI_IINDICATOR_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_UI_TYPE_IINDICATOR_SERVICE, SteadyflowUIIIndicatorService))
#define STEADYFLOW_UI_IS_IINDICATOR_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_UI_TYPE_IINDICATOR_SERVICE))
#define STEADYFLOW_UI_IINDICATOR_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_UI_TYPE_IINDICATOR_SERVICE, SteadyflowUIIIndicatorServiceIface))

typedef struct _SteadyflowUIIIndicatorService SteadyflowUIIIndicatorService;
typedef struct _SteadyflowUIIIndicatorServiceIface SteadyflowUIIIndicatorServiceIface;

#define STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE (steadyflow_core_isettings_service_get_type ())
#define STEADYFLOW_CORE_ISETTINGS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE, SteadyflowCoreISettingsService))
#define STEADYFLOW_CORE_IS_ISETTINGS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE))
#define STEADYFLOW_CORE_ISETTINGS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_ISETTINGS_SERVICE, SteadyflowCoreISettingsServiceIface))

typedef struct _SteadyflowCoreISettingsService SteadyflowCoreISettingsService;
typedef struct _SteadyflowCoreISettingsServiceIface SteadyflowCoreISettingsServiceIface;

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE (steadyflow_core_idownload_service_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadService))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadServiceIface))

typedef struct _SteadyflowCoreIDownloadService SteadyflowCoreIDownloadService;
typedef struct _SteadyflowCoreIDownloadServiceIface SteadyflowCoreIDownloadServiceIface;
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	STEADYFLOW_INDICATOR_CONTROLLER_SHOW_HIDE_TOGGLED_SIGNAL,
	STEADYFLOW_INDICATOR_CONTROLLER_ADD_DOWNLOAD_CLICKED_SIGNAL,
	STEADYFLOW_INDICATOR_CONTROLLER_QUIT_CLICKED_SIGNAL,
	STEADYFLOW_INDICATOR_CONTROLLER_NUM_SIGNALS
};
static guint steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_NUM_SIGNALS] = {0};

struct _SteadyflowIndicatorController {
	GObject parent_instance;
	SteadyflowIndicatorControllerPrivate * priv;
};

struct _SteadyflowIndicatorControllerClass {
	GObjectClass parent_class;
};

struct _SteadyflowIndicatorControllerPrivate {
	GtkActionEntry* actions;
	gint actions_length1;
	gint _actions_size_;
	GtkToggleActionEntry* toggle_actions;
	gint toggle_actions_length1;
	gint _toggle_actions_size_;
	GtkUIManager* ui_manager;
	GtkMenu* menu;
	GtkToggleAction* show_hide_action;
	GtkAction* pause_all_action;
	GtkAction* resume_all_action;
	GtkActionGroup* merged_action_group;
	guint merge_id;
};

struct _SteadyflowUIIIndicatorServiceIface {
	GTypeInterface parent_iface;
	void (*set_menu) (SteadyflowUIIIndicatorService* self, GtkMenu* menu);
	gchar* (*get_icon_name) (SteadyflowUIIIndicatorService* self);
	void (*set_icon_name) (SteadyflowUIIIndicatorService* self, const gchar* value);
	gboolean (*get_visible) (SteadyflowUIIIndicatorService* self);
	void (*set_visible) (SteadyflowUIIIndicatorService* self, gboolean value);
};

struct _SteadyflowCoreISettingsServiceIface {
	GTypeInterface parent_iface;
	gboolean (*get_boolean) (SteadyflowCoreISettingsService* self, const gchar* key);
	gint (*get_int) (SteadyflowCoreISettingsService* self, const gchar* key);
	gint (*get_enum) (SteadyflowCoreISettingsService* self, const gchar* key);
	gchar* (*get_string) (SteadyflowCoreISettingsService* self, const gchar* key);
	void (*set_boolean) (SteadyflowCoreISettingsService* self, const gchar* key, gboolean value);
	void (*set_int) (SteadyflowCoreISettingsService* self, const gchar* key, gint value);
	void (*set_enum) (SteadyflowCoreISettingsService* self, const gchar* key, gint value);
	void (*set_string) (SteadyflowCoreISettingsService* self, const gchar* key, const gchar* value);
	void (*save) (SteadyflowCoreISettingsService* self);
};

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowCoreIDownloadServiceIface {
	GTypeInterface parent_iface;
	SteadyflowCoreIDownloadFile* (*get_file_by_uid) (SteadyflowCoreIDownloadService* self, gint uid);
	SteadyflowCoreIDownloadFile* (*add_file) (SteadyflowCoreIDownloadService* self, const gchar* url, const gchar* local_name, SteadyflowCoreIDownloadFileFinishAction finish_action, const gchar* finish_command, GError** error);
	void (*remove_file) (SteadyflowCoreIDownloadService* self, SteadyflowCoreIDownloadFile* file);
	GeeList* (*get_files) (SteadyflowCoreIDownloadService* self);
};

struct _Block5Data {
	int _ref_count_;
	SteadyflowIndicatorController* self;
	SteadyflowCoreIDownloadFile* file;
};

static gint SteadyflowIndicatorController_private_offset;
static gpointer steadyflow_indicator_controller_parent_class = NULL;
static gchar* steadyflow_indicator_controller_stock_quit_label;
static gchar* steadyflow_indicator_controller_stock_quit_label = NULL;

VALA_EXTERN GType steadyflow_indicator_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowIndicatorController, g_object_unref)
VALA_EXTERN SteadyflowIndicatorController* steadyflow_indicator_controller_new (void);
VALA_EXTERN SteadyflowIndicatorController* steadyflow_indicator_controller_construct (GType object_type);
VALA_EXTERN void steadyflow_core_util_fatal_error (GError* e,
                                       const gchar* message);
VALA_EXTERN GType steadyflow_ui_iindicator_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowUIIIndicatorService, g_object_unref)
VALA_EXTERN SteadyflowUIIIndicatorService* steadyflow_services_get_indicator (void);
VALA_EXTERN void steadyflow_ui_iindicator_service_set_menu (SteadyflowUIIIndicatorService* self,
                                                GtkMenu* menu);
VALA_EXTERN GType steadyflow_core_isettings_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreISettingsService, g_object_unref)
VALA_EXTERN SteadyflowCoreISettingsService* steadyflow_services_get_settings (void);
VALA_EXTERN gboolean steadyflow_core_isettings_service_get_boolean (SteadyflowCoreISettingsService* self,
                                                        const gchar* key);
VALA_EXTERN void steadyflow_ui_iindicator_service_set_visible (SteadyflowUIIIndicatorService* self,
                                                   gboolean value);
static void __lambda16_ (SteadyflowIndicatorController* self);
static void ___lambda16__steadyflow_core_isettings_service_changed (SteadyflowCoreISettingsService* _sender,
                                                             gpointer self);
static void __lambda17_ (SteadyflowIndicatorController* self);
static void ___lambda17__gtk_toggle_action_toggled (GtkToggleAction* _sender,
                                             gpointer self);
static void __lambda18_ (SteadyflowIndicatorController* self);
VALA_EXTERN void steadyflow_indicator_controller_set_main_window_visible (SteadyflowIndicatorController* self,
                                                              gboolean visible);
static void ___lambda18__steadyflow_ui_iindicator_service_clicked (SteadyflowUIIIndicatorService* _sender,
                                                            gpointer self);
static void __lambda19_ (SteadyflowIndicatorController* self);
static void ___lambda19__gtk_action_activate (GtkAction* _sender,
                                       gpointer self);
static void __lambda20_ (SteadyflowIndicatorController* self);
static void ___lambda20__gtk_action_activate (GtkAction* _sender,
                                       gpointer self);
static void steadyflow_indicator_controller_pause_all (SteadyflowIndicatorController* self);
static void _steadyflow_indicator_controller_pause_all_gtk_action_activate (GtkAction* _sender,
                                                                     gpointer self);
static void steadyflow_indicator_controller_resume_all (SteadyflowIndicatorController* self);
static void _steadyflow_indicator_controller_resume_all_gtk_action_activate (GtkAction* _sender,
                                                                      gpointer self);
VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
VALA_EXTERN GType steadyflow_core_idownload_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadService, g_object_unref)
VALA_EXTERN SteadyflowCoreIDownloadService* steadyflow_services_get_download (void);
VALA_EXTERN GeeList* steadyflow_core_idownload_service_get_files (SteadyflowCoreIDownloadService* self);
static void steadyflow_indicator_controller_connect_file_signals (SteadyflowIndicatorController* self,
                                                           SteadyflowCoreIDownloadFile* file);
static void __lambda24_ (SteadyflowIndicatorController* self,
                  SteadyflowCoreIDownloadFile* file);
static void steadyflow_indicator_controller_update_file_menus (SteadyflowIndicatorController* self);
static void ___lambda24__steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                                SteadyflowCoreIDownloadFile* file,
                                                                gpointer self);
static void __lambda25_ (SteadyflowIndicatorController* self,
                  SteadyflowCoreIDownloadFile* file);
static void ___lambda25__steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                                  SteadyflowCoreIDownloadFile* file,
                                                                  gpointer self);
static void __lambda21_ (SteadyflowIndicatorController* self,
                  SteadyflowCoreIDownloadFileStatus old_status);
static void ___lambda21__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                 SteadyflowCoreIDownloadFileStatus old_status,
                                                                 gpointer self);
VALA_EXTERN gboolean steadyflow_core_idownload_file_can_pause (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gboolean steadyflow_core_idownload_file_can_start (SteadyflowCoreIDownloadFile* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN gint steadyflow_core_idownload_file_get_uid (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_basename (SteadyflowCoreIDownloadFile* self);
static void ______lambda22_ (Block5Data* _data5_);
VALA_EXTERN void steadyflow_core_idownload_file_start (SteadyflowCoreIDownloadFile* self,
                                           gboolean resume);
static void _______lambda22__gtk_action_activate (GtkAction* _sender,
                                           gpointer self);
static void ______lambda23_ (Block5Data* _data5_);
VALA_EXTERN void steadyflow_core_idownload_file_pause (SteadyflowCoreIDownloadFile* self);
static void _______lambda23__gtk_action_activate (GtkAction* _sender,
                                           gpointer self);
static void steadyflow_indicator_controller_finalize (GObject * obj);
static GType steadyflow_indicator_controller_get_type_once (void);

static inline gpointer
steadyflow_indicator_controller_get_instance_private (SteadyflowIndicatorController* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowIndicatorController_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda16_ (SteadyflowIndicatorController* self)
{
	SteadyflowUIIIndicatorService* _tmp0_;
	SteadyflowUIIIndicatorService* _tmp1_;
	SteadyflowCoreISettingsService* _tmp2_;
	SteadyflowCoreISettingsService* _tmp3_;
	_tmp0_ = steadyflow_services_get_indicator ();
	_tmp1_ = _tmp0_;
	_tmp2_ = steadyflow_services_get_settings ();
	_tmp3_ = _tmp2_;
	steadyflow_ui_iindicator_service_set_visible (_tmp1_, steadyflow_core_isettings_service_get_boolean (_tmp3_, "show-indicator"));
}

static void
___lambda16__steadyflow_core_isettings_service_changed (SteadyflowCoreISettingsService* _sender,
                                                        gpointer self)
{
	__lambda16_ ((SteadyflowIndicatorController*) self);
}

static void
__lambda17_ (SteadyflowIndicatorController* self)
{
	GtkToggleAction* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->show_hide_action;
	_tmp1_ = gtk_toggle_action_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_SHOW_HIDE_TOGGLED_SIGNAL], 0, _tmp2_);
}

static void
___lambda17__gtk_toggle_action_toggled (GtkToggleAction* _sender,
                                        gpointer self)
{
	__lambda17_ ((SteadyflowIndicatorController*) self);
}

static void
__lambda18_ (SteadyflowIndicatorController* self)
{
	GtkToggleAction* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->show_hide_action;
	_tmp1_ = gtk_toggle_action_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	steadyflow_indicator_controller_set_main_window_visible (self, !_tmp2_);
}

static void
___lambda18__steadyflow_ui_iindicator_service_clicked (SteadyflowUIIIndicatorService* _sender,
                                                       gpointer self)
{
	__lambda18_ ((SteadyflowIndicatorController*) self);
}

static void
__lambda19_ (SteadyflowIndicatorController* self)
{
	g_signal_emit (self, steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_ADD_DOWNLOAD_CLICKED_SIGNAL], 0);
}

static void
___lambda19__gtk_action_activate (GtkAction* _sender,
                                  gpointer self)
{
	__lambda19_ ((SteadyflowIndicatorController*) self);
}

static void
__lambda20_ (SteadyflowIndicatorController* self)
{
	g_signal_emit (self, steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_QUIT_CLICKED_SIGNAL], 0);
}

static void
___lambda20__gtk_action_activate (GtkAction* _sender,
                                  gpointer self)
{
	__lambda20_ ((SteadyflowIndicatorController*) self);
}

static void
_steadyflow_indicator_controller_pause_all_gtk_action_activate (GtkAction* _sender,
                                                                gpointer self)
{
	steadyflow_indicator_controller_pause_all ((SteadyflowIndicatorController*) self);
}

static void
_steadyflow_indicator_controller_resume_all_gtk_action_activate (GtkAction* _sender,
                                                                 gpointer self)
{
	steadyflow_indicator_controller_resume_all ((SteadyflowIndicatorController*) self);
}

static void
__lambda24_ (SteadyflowIndicatorController* self,
             SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (file != NULL);
	steadyflow_indicator_controller_connect_file_signals (self, file);
	steadyflow_indicator_controller_update_file_menus (self);
}

static void
___lambda24__steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                           SteadyflowCoreIDownloadFile* file,
                                                           gpointer self)
{
	__lambda24_ ((SteadyflowIndicatorController*) self, file);
}

static void
__lambda25_ (SteadyflowIndicatorController* self,
             SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (file != NULL);
	steadyflow_indicator_controller_update_file_menus (self);
}

static void
___lambda25__steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                             SteadyflowCoreIDownloadFile* file,
                                                             gpointer self)
{
	__lambda25_ ((SteadyflowIndicatorController*) self, file);
}

SteadyflowIndicatorController*
steadyflow_indicator_controller_construct (GType object_type)
{
	SteadyflowIndicatorController * self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* action_group = NULL;
	GtkActionGroup* _tmp1_;
	GtkActionEntry* _tmp2_;
	gint _tmp2__length1;
	GtkToggleActionEntry* _tmp3_;
	gint _tmp3__length1;
	GtkUIManager* _tmp4_;
	GtkUIManager* _tmp8_;
	GtkWidget* _tmp9_;
	GtkMenu* _tmp10_;
	SteadyflowUIIIndicatorService* _tmp11_;
	SteadyflowUIIIndicatorService* _tmp12_;
	GtkMenu* _tmp13_;
	SteadyflowUIIIndicatorService* _tmp14_;
	SteadyflowUIIIndicatorService* _tmp15_;
	SteadyflowCoreISettingsService* _tmp16_;
	SteadyflowCoreISettingsService* _tmp17_;
	SteadyflowCoreISettingsService* _tmp18_;
	SteadyflowCoreISettingsService* _tmp19_;
	GtkAction* _tmp20_;
	GtkToggleAction* _tmp21_;
	GtkToggleAction* _tmp22_;
	SteadyflowCoreISettingsService* _tmp23_;
	SteadyflowCoreISettingsService* _tmp24_;
	GtkToggleAction* _tmp25_;
	SteadyflowUIIIndicatorService* _tmp26_;
	SteadyflowUIIIndicatorService* _tmp27_;
	GtkAction* _tmp28_;
	GtkAction* _tmp29_;
	GtkAction* _tmp30_;
	GtkAction* _tmp31_;
	GtkAction* _tmp32_;
	GtkAction* _tmp33_;
	GtkAction* _tmp34_;
	GtkAction* _tmp35_;
	GtkAction* _tmp36_;
	GtkAction* _tmp37_;
	SteadyflowCoreIDownloadService* _tmp50_;
	SteadyflowCoreIDownloadService* _tmp51_;
	SteadyflowCoreIDownloadService* _tmp52_;
	SteadyflowCoreIDownloadService* _tmp53_;
	GError* _inner_error0_ = NULL;
	self = (SteadyflowIndicatorController*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp0_;
	_tmp1_ = gtk_action_group_new ("main");
	action_group = _tmp1_;
	_tmp2_ = self->priv->actions;
	_tmp2__length1 = self->priv->actions_length1;
	gtk_action_group_add_actions (action_group, _tmp2_, (guint) _tmp2__length1, NULL);
	_tmp3_ = self->priv->toggle_actions;
	_tmp3__length1 = self->priv->toggle_actions_length1;
	gtk_action_group_add_toggle_actions (action_group, _tmp3_, (guint) _tmp3__length1, NULL);
	_tmp4_ = self->priv->ui_manager;
	gtk_ui_manager_insert_action_group (_tmp4_, action_group, 0);
	{
		GtkUIManager* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->ui_manager;
		_tmp6_ = strlen (STEADYFLOW_INDICATOR_MENU);
		_tmp7_ = _tmp6_;
		gtk_ui_manager_add_ui_from_string (_tmp5_, STEADYFLOW_INDICATOR_MENU, (gssize) _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		steadyflow_core_util_fatal_error (e, NULL);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (action_group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = self->priv->ui_manager;
	_tmp9_ = gtk_ui_manager_get_widget (_tmp8_, "/ui/IndicatorMenu");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_menu_get_type (), GtkMenu));
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp10_;
	_tmp11_ = steadyflow_services_get_indicator ();
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->menu;
	steadyflow_ui_iindicator_service_set_menu (_tmp12_, _tmp13_);
	_tmp14_ = steadyflow_services_get_indicator ();
	_tmp15_ = _tmp14_;
	_tmp16_ = steadyflow_services_get_settings ();
	_tmp17_ = _tmp16_;
	steadyflow_ui_iindicator_service_set_visible (_tmp15_, steadyflow_core_isettings_service_get_boolean (_tmp17_, "show-indicator"));
	_tmp18_ = steadyflow_services_get_settings ();
	_tmp19_ = _tmp18_;
	g_signal_connect_object (_tmp19_, "changed::show-indicator", (GCallback) ___lambda16__steadyflow_core_isettings_service_changed, self, 0);
	_tmp20_ = gtk_action_group_get_action (action_group, "ShowHide");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (self->priv->show_hide_action);
	self->priv->show_hide_action = _tmp21_;
	_tmp22_ = self->priv->show_hide_action;
	_tmp23_ = steadyflow_services_get_settings ();
	_tmp24_ = _tmp23_;
	gtk_toggle_action_set_active (_tmp22_, !steadyflow_core_isettings_service_get_boolean (_tmp24_, "start-minimized"));
	_tmp25_ = self->priv->show_hide_action;
	g_signal_connect_object (_tmp25_, "toggled", (GCallback) ___lambda17__gtk_toggle_action_toggled, self, 0);
	_tmp26_ = steadyflow_services_get_indicator ();
	_tmp27_ = _tmp26_;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) ___lambda18__steadyflow_ui_iindicator_service_clicked, self, 0);
	_tmp28_ = gtk_action_group_get_action (action_group, "Add");
	g_signal_connect_object (_tmp28_, "activate", (GCallback) ___lambda19__gtk_action_activate, self, 0);
	_tmp29_ = gtk_action_group_get_action (action_group, "Quit");
	g_signal_connect_object (_tmp29_, "activate", (GCallback) ___lambda20__gtk_action_activate, self, 0);
	_tmp30_ = gtk_action_group_get_action (action_group, "PauseAll");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_action_get_type (), GtkAction));
	_g_object_unref0 (self->priv->pause_all_action);
	self->priv->pause_all_action = _tmp31_;
	_tmp32_ = self->priv->pause_all_action;
	gtk_action_set_sensitive (_tmp32_, FALSE);
	_tmp33_ = self->priv->pause_all_action;
	g_signal_connect_object (_tmp33_, "activate", (GCallback) _steadyflow_indicator_controller_pause_all_gtk_action_activate, self, 0);
	_tmp34_ = gtk_action_group_get_action (action_group, "ResumeAll");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_action_get_type (), GtkAction));
	_g_object_unref0 (self->priv->resume_all_action);
	self->priv->resume_all_action = _tmp35_;
	_tmp36_ = self->priv->resume_all_action;
	gtk_action_set_sensitive (_tmp36_, FALSE);
	_tmp37_ = self->priv->resume_all_action;
	g_signal_connect_object (_tmp37_, "activate", (GCallback) _steadyflow_indicator_controller_resume_all_gtk_action_activate, self, 0);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp38_;
		SteadyflowCoreIDownloadService* _tmp39_;
		GeeList* _tmp40_;
		GeeList* _tmp41_;
		gint _file_size = 0;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _file_index = 0;
		_tmp38_ = steadyflow_services_get_download ();
		_tmp39_ = _tmp38_;
		_tmp40_ = steadyflow_core_idownload_service_get_files (_tmp39_);
		_tmp41_ = _tmp40_;
		_file_list = _tmp41_;
		_tmp42_ = _file_list;
		_tmp43_ = gee_collection_get_size ((GeeCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_file_size = _tmp44_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp47_;
			gpointer _tmp48_;
			SteadyflowCoreIDownloadFile* _tmp49_;
			_file_index = _file_index + 1;
			_tmp45_ = _file_index;
			_tmp46_ = _file_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _file_list;
			_tmp48_ = gee_list_get (_tmp47_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp48_;
			_tmp49_ = file;
			steadyflow_indicator_controller_connect_file_signals (self, _tmp49_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp50_ = steadyflow_services_get_download ();
	_tmp51_ = _tmp50_;
	g_signal_connect_object (_tmp51_, "file-added", (GCallback) ___lambda24__steadyflow_core_idownload_service_file_added, self, 0);
	_tmp52_ = steadyflow_services_get_download ();
	_tmp53_ = _tmp52_;
	g_signal_connect_object (_tmp53_, "file-removed", (GCallback) ___lambda25__steadyflow_core_idownload_service_file_removed, self, 0);
	steadyflow_indicator_controller_update_file_menus (self);
	_g_object_unref0 (action_group);
	return self;
}

SteadyflowIndicatorController*
steadyflow_indicator_controller_new (void)
{
	return steadyflow_indicator_controller_construct (STEADYFLOW_TYPE_INDICATOR_CONTROLLER);
}

void
steadyflow_indicator_controller_set_main_window_visible (SteadyflowIndicatorController* self,
                                                         gboolean visible)
{
	GtkToggleAction* _tmp0_;
	SteadyflowUIIIndicatorService* _tmp1_;
	SteadyflowUIIIndicatorService* _tmp2_;
	GtkMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->show_hide_action;
	gtk_toggle_action_set_active (_tmp0_, visible);
	_tmp1_ = steadyflow_services_get_indicator ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->menu;
	steadyflow_ui_iindicator_service_set_menu (_tmp2_, _tmp3_);
}

static void
__lambda21_ (SteadyflowIndicatorController* self,
             SteadyflowCoreIDownloadFileStatus old_status)
{
	steadyflow_indicator_controller_update_file_menus (self);
}

static void
___lambda21__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                            SteadyflowCoreIDownloadFileStatus old_status,
                                                            gpointer self)
{
	__lambda21_ ((SteadyflowIndicatorController*) self, old_status);
}

static void
steadyflow_indicator_controller_connect_file_signals (SteadyflowIndicatorController* self,
                                                      SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_signal_connect_object (file, "status-changed", (GCallback) ___lambda21__steadyflow_core_idownload_file_status_changed, self, 0);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SteadyflowIndicatorController* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->file);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
______lambda22_ (Block5Data* _data5_)
{
	SteadyflowIndicatorController* self;
	SteadyflowCoreIDownloadFile* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->file;
	steadyflow_core_idownload_file_start (_tmp0_, TRUE);
}

static void
_______lambda22__gtk_action_activate (GtkAction* _sender,
                                      gpointer self)
{
	______lambda22_ (self);
}

static void
______lambda23_ (Block5Data* _data5_)
{
	SteadyflowIndicatorController* self;
	SteadyflowCoreIDownloadFile* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->file;
	steadyflow_core_idownload_file_pause (_tmp0_);
}

static void
_______lambda23__gtk_action_activate (GtkAction* _sender,
                                      gpointer self)
{
	______lambda23_ (self);
}

static void
steadyflow_indicator_controller_update_file_menus (SteadyflowIndicatorController* self)
{
	gboolean enable_pause_all = FALSE;
	gboolean enable_resume_all = FALSE;
	GeeArrayList* files_for_menu = NULL;
	GeeArrayList* _tmp0_;
	GtkAction* _tmp23_;
	GtkAction* _tmp24_;
	GtkActionGroup* _tmp25_;
	GeeArrayList* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	SteadyflowUIIIndicatorService* _tmp83_;
	SteadyflowUIIIndicatorService* _tmp84_;
	GtkMenu* _tmp85_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	enable_pause_all = FALSE;
	enable_resume_all = FALSE;
	_tmp0_ = gee_array_list_new (STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	files_for_menu = _tmp0_;
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp1_;
		SteadyflowCoreIDownloadService* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _file_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _file_index = 0;
		_tmp1_ = steadyflow_services_get_download ();
		_tmp2_ = _tmp1_;
		_tmp3_ = steadyflow_core_idownload_service_get_files (_tmp2_);
		_tmp4_ = _tmp3_;
		_file_list = _tmp4_;
		_tmp5_ = _file_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_file_size = _tmp7_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SteadyflowCoreIDownloadFile* _tmp12_;
			SteadyflowCoreIDownloadFile* _tmp13_;
			gboolean _tmp14_ = FALSE;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_file_index = _file_index + 1;
			_tmp8_ = _file_index;
			_tmp9_ = _file_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _file_list;
			_tmp11_ = gee_list_get (_tmp10_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp11_;
			_tmp12_ = file;
			if (steadyflow_core_idownload_file_can_pause (_tmp12_)) {
				enable_pause_all = TRUE;
			}
			_tmp13_ = file;
			if (steadyflow_core_idownload_file_can_start (_tmp13_)) {
				enable_resume_all = TRUE;
			}
			_tmp15_ = files_for_menu;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ < STEADYFLOW_INDICATOR_CONTROLLER_MAX_FILE_MENU_ENTRIES) {
				gboolean _tmp18_ = FALSE;
				SteadyflowCoreIDownloadFile* _tmp19_;
				_tmp19_ = file;
				if (steadyflow_core_idownload_file_can_start (_tmp19_)) {
					_tmp18_ = TRUE;
				} else {
					SteadyflowCoreIDownloadFile* _tmp20_;
					_tmp20_ = file;
					_tmp18_ = steadyflow_core_idownload_file_can_pause (_tmp20_);
				}
				_tmp14_ = _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				GeeArrayList* _tmp21_;
				SteadyflowCoreIDownloadFile* _tmp22_;
				_tmp21_ = files_for_menu;
				_tmp22_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp23_ = self->priv->pause_all_action;
	gtk_action_set_sensitive (_tmp23_, enable_pause_all);
	_tmp24_ = self->priv->resume_all_action;
	gtk_action_set_sensitive (_tmp24_, enable_resume_all);
	_tmp25_ = self->priv->merged_action_group;
	if (_tmp25_ != NULL) {
		GtkUIManager* _tmp26_;
		GtkActionGroup* _tmp27_;
		_tmp26_ = self->priv->ui_manager;
		_tmp27_ = self->priv->merged_action_group;
		gtk_ui_manager_remove_action_group (_tmp26_, _tmp27_);
	}
	if (self->priv->merge_id != ((guint) 0)) {
		GtkUIManager* _tmp28_;
		_tmp28_ = self->priv->ui_manager;
		gtk_ui_manager_remove_ui (_tmp28_, self->priv->merge_id);
	}
	_tmp29_ = files_for_menu;
	_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == 0) {
		_g_object_unref0 (self->priv->merged_action_group);
		self->priv->merged_action_group = NULL;
		self->priv->merge_id = (guint) 0;
	} else {
		GtkActionGroup* _tmp32_;
		GString* new_items = NULL;
		GString* _tmp33_;
		gchar* new_ui = NULL;
		GString* _tmp71_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		GtkUIManager* _tmp80_;
		GtkActionGroup* _tmp81_;
		GtkUIManager* _tmp82_;
		_tmp32_ = gtk_action_group_new ("fileitems");
		_g_object_unref0 (self->priv->merged_action_group);
		self->priv->merged_action_group = _tmp32_;
		_tmp33_ = g_string_new ("");
		new_items = _tmp33_;
		{
			GeeArrayList* _file_list = NULL;
			GeeArrayList* _tmp34_;
			gint _file_size = 0;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _file_index = 0;
			_tmp34_ = files_for_menu;
			_file_list = _tmp34_;
			_tmp35_ = _file_list;
			_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_file_size = _tmp37_;
			_file_index = -1;
			while (TRUE) {
				Block5Data* _data5_;
				gint _tmp38_;
				gint _tmp39_;
				GeeArrayList* _tmp40_;
				gpointer _tmp41_;
				gchar* action_name = NULL;
				SteadyflowCoreIDownloadFile* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gchar* _tmp45_;
				gchar* file_label = NULL;
				SteadyflowCoreIDownloadFile* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				GString* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				GtkAction* action = NULL;
				SteadyflowCoreIDownloadFile* _tmp54_;
				GtkActionGroup* _tmp69_;
				GtkAction* _tmp70_;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_data5_->self = g_object_ref (self);
				_file_index = _file_index + 1;
				_tmp38_ = _file_index;
				_tmp39_ = _file_size;
				if (!(_tmp38_ < _tmp39_)) {
					block5_data_unref (_data5_);
					_data5_ = NULL;
					break;
				}
				_tmp40_ = _file_list;
				_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _file_index);
				_data5_->file = (SteadyflowCoreIDownloadFile*) _tmp41_;
				_tmp42_ = _data5_->file;
				_tmp43_ = steadyflow_core_idownload_file_get_uid (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("FileAction%d", _tmp44_);
				action_name = _tmp45_;
				_tmp46_ = _data5_->file;
				_tmp47_ = steadyflow_core_idownload_file_get_local_basename (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = string_replace (_tmp48_, "_", "__");
				file_label = _tmp49_;
				_tmp50_ = new_items;
				_tmp51_ = action_name;
				_tmp52_ = g_strdup_printf ("<menuitem action='%s' />", _tmp51_);
				_tmp53_ = _tmp52_;
				g_string_append (_tmp50_, _tmp53_);
				_g_free0 (_tmp53_);
				_tmp54_ = _data5_->file;
				if (steadyflow_core_idownload_file_can_start (_tmp54_)) {
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					GtkAction* _tmp59_;
					GtkAction* _tmp60_;
					GtkAction* _tmp61_;
					_tmp55_ = action_name;
					_tmp56_ = file_label;
					_tmp57_ = g_strdup_printf (_ ("Start %s"), _tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = gtk_action_new (_tmp55_, _tmp58_, NULL, NULL);
					_g_object_unref0 (action);
					action = _tmp59_;
					_g_free0 (_tmp58_);
					_tmp60_ = action;
					gtk_action_set_icon_name (_tmp60_, "media-playback-start");
					_tmp61_ = action;
					g_signal_connect_data (_tmp61_, "activate", (GCallback) _______lambda22__gtk_action_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				} else {
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					GtkAction* _tmp66_;
					GtkAction* _tmp67_;
					GtkAction* _tmp68_;
					_tmp62_ = action_name;
					_tmp63_ = file_label;
					_tmp64_ = g_strdup_printf (_ ("Pause %s"), _tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = gtk_action_new (_tmp62_, _tmp65_, NULL, NULL);
					_g_object_unref0 (action);
					action = _tmp66_;
					_g_free0 (_tmp65_);
					_tmp67_ = action;
					gtk_action_set_icon_name (_tmp67_, "media-playback-pause");
					_tmp68_ = action;
					g_signal_connect_data (_tmp68_, "activate", (GCallback) _______lambda23__gtk_action_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				}
				_tmp69_ = self->priv->merged_action_group;
				_tmp70_ = action;
				gtk_action_group_add_action (_tmp69_, _tmp70_);
				_g_object_unref0 (action);
				_g_free0 (file_label);
				_g_free0 (action_name);
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
		}
		_tmp71_ = new_items;
		_tmp72_ = _tmp71_->str;
		_tmp73_ = g_strdup_printf (STEADYFLOW_INSERT_TEMPLATE, _tmp72_);
		new_ui = _tmp73_;
		{
			guint _tmp74_ = 0U;
			GtkUIManager* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			_tmp75_ = self->priv->ui_manager;
			_tmp76_ = new_ui;
			_tmp77_ = new_ui;
			_tmp78_ = strlen (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp74_ = gtk_ui_manager_add_ui_from_string (_tmp75_, _tmp76_, (gssize) _tmp79_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			self->priv->merge_id = _tmp74_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			steadyflow_core_util_fatal_error (e, NULL);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_ui);
			_g_string_free0 (new_items);
			_g_object_unref0 (files_for_menu);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp80_ = self->priv->ui_manager;
		_tmp81_ = self->priv->merged_action_group;
		gtk_ui_manager_insert_action_group (_tmp80_, _tmp81_, 1);
		_tmp82_ = self->priv->ui_manager;
		gtk_ui_manager_ensure_update (_tmp82_);
		_g_free0 (new_ui);
		_g_string_free0 (new_items);
	}
	_tmp83_ = steadyflow_services_get_indicator ();
	_tmp84_ = _tmp83_;
	_tmp85_ = self->priv->menu;
	steadyflow_ui_iindicator_service_set_menu (_tmp84_, _tmp85_);
	_g_object_unref0 (files_for_menu);
}

static void
steadyflow_indicator_controller_pause_all (SteadyflowIndicatorController* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp0_;
		SteadyflowCoreIDownloadService* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _file_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _file_index = 0;
		_tmp0_ = steadyflow_services_get_download ();
		_tmp1_ = _tmp0_;
		_tmp2_ = steadyflow_core_idownload_service_get_files (_tmp1_);
		_tmp3_ = _tmp2_;
		_file_list = _tmp3_;
		_tmp4_ = _file_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_file_size = _tmp6_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			SteadyflowCoreIDownloadFile* _tmp11_;
			_file_index = _file_index + 1;
			_tmp7_ = _file_index;
			_tmp8_ = _file_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _file_list;
			_tmp10_ = gee_list_get (_tmp9_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp10_;
			_tmp11_ = file;
			if (steadyflow_core_idownload_file_can_pause (_tmp11_)) {
				SteadyflowCoreIDownloadFile* _tmp12_;
				_tmp12_ = file;
				steadyflow_core_idownload_file_pause (_tmp12_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
}

static void
steadyflow_indicator_controller_resume_all (SteadyflowIndicatorController* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp0_;
		SteadyflowCoreIDownloadService* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _file_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _file_index = 0;
		_tmp0_ = steadyflow_services_get_download ();
		_tmp1_ = _tmp0_;
		_tmp2_ = steadyflow_core_idownload_service_get_files (_tmp1_);
		_tmp3_ = _tmp2_;
		_file_list = _tmp3_;
		_tmp4_ = _file_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_file_size = _tmp6_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			SteadyflowCoreIDownloadFile* _tmp11_;
			_file_index = _file_index + 1;
			_tmp7_ = _file_index;
			_tmp8_ = _file_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _file_list;
			_tmp10_ = gee_list_get (_tmp9_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp10_;
			_tmp11_ = file;
			if (steadyflow_core_idownload_file_can_start (_tmp11_)) {
				SteadyflowCoreIDownloadFile* _tmp12_;
				_tmp12_ = file;
				steadyflow_core_idownload_file_start (_tmp12_, TRUE);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
}

static void
steadyflow_indicator_controller_class_init (SteadyflowIndicatorControllerClass * klass,
                                            gpointer klass_data)
{
	GtkStockItem item = {0};
	GtkStockItem _tmp0_ = {0};
	GtkStockItem _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	steadyflow_indicator_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowIndicatorController_private_offset);
	G_OBJECT_CLASS (klass)->finalize = steadyflow_indicator_controller_finalize;
	steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_SHOW_HIDE_TOGGLED_SIGNAL] = g_signal_new ("show-hide-toggled", STEADYFLOW_TYPE_INDICATOR_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_ADD_DOWNLOAD_CLICKED_SIGNAL] = g_signal_new ("add-download-clicked", STEADYFLOW_TYPE_INDICATOR_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	steadyflow_indicator_controller_signals[STEADYFLOW_INDICATOR_CONTROLLER_QUIT_CLICKED_SIGNAL] = g_signal_new ("quit-clicked", STEADYFLOW_TYPE_INDICATOR_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_stock_lookup (GTK_STOCK_QUIT, &_tmp0_);
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = _tmp1_.label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (steadyflow_indicator_controller_stock_quit_label);
	steadyflow_indicator_controller_stock_quit_label = _tmp3_;
}

static void
steadyflow_indicator_controller_instance_init (SteadyflowIndicatorController * self,
                                               gpointer klass)
{
	GtkActionEntry _tmp0_ = {0};
	const gchar* _tmp1_;
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry _tmp3_ = {0};
	GtkActionEntry _tmp4_ = {0};
	GtkActionEntry* _tmp5_;
	GtkToggleActionEntry _tmp6_ = {0};
	GtkToggleActionEntry* _tmp7_;
	self->priv = steadyflow_indicator_controller_get_instance_private (self);
	memset (&_tmp0_, 0, sizeof (GtkActionEntry));
	_tmp0_.name = "Add";
	_tmp0_.stock_id = "list-add";
	_tmp0_.label = _ ("_Add download...");
	_tmp1_ = steadyflow_indicator_controller_stock_quit_label;
	memset (&_tmp2_, 0, sizeof (GtkActionEntry));
	_tmp2_.name = "Quit";
	_tmp2_.stock_id = "system-shutdown";
	_tmp2_.label = _tmp1_;
	memset (&_tmp3_, 0, sizeof (GtkActionEntry));
	_tmp3_.name = "PauseAll";
	_tmp3_.stock_id = "media-playback-pause";
	_tmp3_.label = _ ("_Pause all");
	memset (&_tmp4_, 0, sizeof (GtkActionEntry));
	_tmp4_.name = "ResumeAll";
	_tmp4_.stock_id = "media-playback-start";
	_tmp4_.label = _ ("_Resume all");
	_tmp5_ = g_new0 (GtkActionEntry, 4);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	self->priv->actions = _tmp5_;
	self->priv->actions_length1 = 4;
	self->priv->_actions_size_ = self->priv->actions_length1;
	memset (&_tmp6_, 0, sizeof (GtkToggleActionEntry));
	_tmp6_.name = "ShowHide";
	_tmp6_.label = _ ("Show download manager");
	_tmp7_ = g_new0 (GtkToggleActionEntry, 1);
	_tmp7_[0] = _tmp6_;
	self->priv->toggle_actions = _tmp7_;
	self->priv->toggle_actions_length1 = 1;
	self->priv->_toggle_actions_size_ = self->priv->toggle_actions_length1;
	self->priv->merged_action_group = NULL;
	self->priv->merge_id = (guint) 0;
}

static void
steadyflow_indicator_controller_finalize (GObject * obj)
{
	SteadyflowIndicatorController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_TYPE_INDICATOR_CONTROLLER, SteadyflowIndicatorController);
	self->priv->actions = (g_free (self->priv->actions), NULL);
	self->priv->toggle_actions = (g_free (self->priv->toggle_actions), NULL);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->show_hide_action);
	_g_object_unref0 (self->priv->pause_all_action);
	_g_object_unref0 (self->priv->resume_all_action);
	_g_object_unref0 (self->priv->merged_action_group);
	G_OBJECT_CLASS (steadyflow_indicator_controller_parent_class)->finalize (obj);
}

static GType
steadyflow_indicator_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowIndicatorControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_indicator_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowIndicatorController), 0, (GInstanceInitFunc) steadyflow_indicator_controller_instance_init, NULL };
	GType steadyflow_indicator_controller_type_id;
	steadyflow_indicator_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SteadyflowIndicatorController", &g_define_type_info, 0);
	SteadyflowIndicatorController_private_offset = g_type_add_instance_private (steadyflow_indicator_controller_type_id, sizeof (SteadyflowIndicatorControllerPrivate));
	return steadyflow_indicator_controller_type_id;
}

GType
steadyflow_indicator_controller_get_type (void)
{
	static volatile gsize steadyflow_indicator_controller_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_indicator_controller_type_id__once)) {
		GType steadyflow_indicator_controller_type_id;
		steadyflow_indicator_controller_type_id = steadyflow_indicator_controller_get_type_once ();
		g_once_init_leave (&steadyflow_indicator_controller_type_id__once, steadyflow_indicator_controller_type_id);
	}
	return steadyflow_indicator_controller_type_id__once;
}

