/* FileListController.c generated by valac 0.56.4, the Vala compiler
 * generated from FileListController.vala, do not modify */

/*
    FileListController.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define STEADYFLOW_FILE_LIST_CONTROLLER_REDRAW_SEC 0.2
#define STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT "<span weight='bold' size='larger'>%s</span>\n\n%s\n"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_TYPE_FILE_LIST_CONTROLLER (steadyflow_file_list_controller_get_type ())
#define STEADYFLOW_FILE_LIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, SteadyflowFileListController))
#define STEADYFLOW_FILE_LIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, SteadyflowFileListControllerClass))
#define STEADYFLOW_IS_FILE_LIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_TYPE_FILE_LIST_CONTROLLER))
#define STEADYFLOW_IS_FILE_LIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_TYPE_FILE_LIST_CONTROLLER))
#define STEADYFLOW_FILE_LIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, SteadyflowFileListControllerClass))

typedef struct _SteadyflowFileListController SteadyflowFileListController;
typedef struct _SteadyflowFileListControllerClass SteadyflowFileListControllerClass;
typedef struct _SteadyflowFileListControllerPrivate SteadyflowFileListControllerPrivate;
enum  {
	STEADYFLOW_FILE_LIST_CONTROLLER_0_PROPERTY,
	STEADYFLOW_FILE_LIST_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* steadyflow_file_list_controller_properties[STEADYFLOW_FILE_LIST_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER (steadyflow_ui_download_cell_renderer_get_type ())
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRenderer))
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRendererClass))
#define STEADYFLOW_UI_IS_DOWNLOAD_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER))
#define STEADYFLOW_UI_IS_DOWNLOAD_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER))
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRendererClass))

typedef struct _SteadyflowUIDownloadCellRenderer SteadyflowUIDownloadCellRenderer;
typedef struct _SteadyflowUIDownloadCellRendererClass SteadyflowUIDownloadCellRendererClass;

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE (steadyflow_core_idownload_service_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadService))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadServiceIface))

typedef struct _SteadyflowCoreIDownloadService SteadyflowCoreIDownloadService;
typedef struct _SteadyflowCoreIDownloadServiceIface SteadyflowCoreIDownloadServiceIface;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG (steadyflow_ui_gtk_builder_dialog_get_type ())
#define STEADYFLOW_UI_GTK_BUILDER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG, SteadyflowUIGtkBuilderDialog))
#define STEADYFLOW_UI_GTK_BUILDER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG, SteadyflowUIGtkBuilderDialogClass))
#define STEADYFLOW_UI_IS_GTK_BUILDER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG))
#define STEADYFLOW_UI_IS_GTK_BUILDER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG))
#define STEADYFLOW_UI_GTK_BUILDER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_UI_TYPE_GTK_BUILDER_DIALOG, SteadyflowUIGtkBuilderDialogClass))

typedef struct _SteadyflowUIGtkBuilderDialog SteadyflowUIGtkBuilderDialog;
typedef struct _SteadyflowUIGtkBuilderDialogClass SteadyflowUIGtkBuilderDialogClass;

#define STEADYFLOW_TYPE_ADD_FILE_DIALOG (steadyflow_add_file_dialog_get_type ())
#define STEADYFLOW_ADD_FILE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_TYPE_ADD_FILE_DIALOG, SteadyflowAddFileDialog))
#define STEADYFLOW_ADD_FILE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_TYPE_ADD_FILE_DIALOG, SteadyflowAddFileDialogClass))
#define STEADYFLOW_IS_ADD_FILE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_TYPE_ADD_FILE_DIALOG))
#define STEADYFLOW_IS_ADD_FILE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_TYPE_ADD_FILE_DIALOG))
#define STEADYFLOW_ADD_FILE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_TYPE_ADD_FILE_DIALOG, SteadyflowAddFileDialogClass))

typedef struct _SteadyflowAddFileDialog SteadyflowAddFileDialog;
typedef struct _SteadyflowAddFileDialogClass SteadyflowAddFileDialogClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	STEADYFLOW_FILE_LIST_CONTROLLER_FILELIST_CHANGED_SIGNAL,
	STEADYFLOW_FILE_LIST_CONTROLLER_SELECTION_CHANGED_SIGNAL,
	STEADYFLOW_FILE_LIST_CONTROLLER_NUM_SIGNALS
};
static guint steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_NUM_SIGNALS] = {0};

struct _SteadyflowFileListController {
	GObject parent_instance;
	SteadyflowFileListControllerPrivate * priv;
};

struct _SteadyflowFileListControllerClass {
	GObjectClass parent_class;
};

struct _SteadyflowFileListControllerPrivate {
	GtkTreeView* tree;
	GtkListStore* model;
	gchar* filter;
	GTimer* redraw_timer;
};

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowCoreIDownloadServiceIface {
	GTypeInterface parent_iface;
	SteadyflowCoreIDownloadFile* (*get_file_by_uid) (SteadyflowCoreIDownloadService* self, gint uid);
	SteadyflowCoreIDownloadFile* (*add_file) (SteadyflowCoreIDownloadService* self, const gchar* url, const gchar* local_name, SteadyflowCoreIDownloadFileFinishAction finish_action, const gchar* finish_command, GError** error);
	void (*remove_file) (SteadyflowCoreIDownloadService* self, SteadyflowCoreIDownloadFile* file);
	GeeList* (*get_files) (SteadyflowCoreIDownloadService* self);
};

static gint SteadyflowFileListController_private_offset;
static gpointer steadyflow_file_list_controller_parent_class = NULL;

VALA_EXTERN GType steadyflow_file_list_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowFileListController, g_object_unref)
VALA_EXTERN SteadyflowFileListController* steadyflow_file_list_controller_new (GtkTreeView* tree);
VALA_EXTERN SteadyflowFileListController* steadyflow_file_list_controller_construct (GType object_type,
                                                                         GtkTreeView* tree);
VALA_EXTERN SteadyflowUIDownloadCellRenderer* steadyflow_ui_download_cell_renderer_new (void);
VALA_EXTERN SteadyflowUIDownloadCellRenderer* steadyflow_ui_download_cell_renderer_construct (GType object_type);
VALA_EXTERN GType steadyflow_ui_download_cell_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowUIDownloadCellRenderer, g_object_unref)
static void steadyflow_file_list_controller_set_cell_data (SteadyflowFileListController* self,
                                                    GtkCellLayout* cell_layout,
                                                    GtkCellRenderer* renderer,
                                                    GtkTreeModel* model,
                                                    GtkTreeIter* iter);
static void _steadyflow_file_list_controller_set_cell_data_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                               GtkCellRenderer* cell,
                                                                               GtkTreeModel* tree_model,
                                                                               GtkTreeIter* iter,
                                                                               gpointer self);
VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
VALA_EXTERN GType steadyflow_core_idownload_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadService, g_object_unref)
VALA_EXTERN SteadyflowCoreIDownloadService* steadyflow_services_get_download (void);
VALA_EXTERN GeeList* steadyflow_core_idownload_service_get_files (SteadyflowCoreIDownloadService* self);
static void steadyflow_file_list_controller_connect_file_signals (SteadyflowFileListController* self,
                                                           SteadyflowCoreIDownloadFile* file);
static void steadyflow_file_list_controller_update_model (SteadyflowFileListController* self);
static void __lambda28_ (SteadyflowFileListController* self,
                  SteadyflowCoreIDownloadFile* file);
static void ___lambda28__steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                                SteadyflowCoreIDownloadFile* file,
                                                                gpointer self);
static void __lambda29_ (SteadyflowFileListController* self,
                  SteadyflowCoreIDownloadFile* file);
static void ___lambda29__steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                                  SteadyflowCoreIDownloadFile* file,
                                                                  gpointer self);
static void __lambda30_ (SteadyflowFileListController* self);
static void ___lambda30__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static SteadyflowCoreIDownloadFile* steadyflow_file_list_controller_file_from_iter (SteadyflowFileListController* self,
                                                                             GtkTreeIter* iter);
VALA_EXTERN void steadyflow_ui_download_cell_renderer_set_file (SteadyflowUIDownloadCellRenderer* self,
                                                    SteadyflowCoreIDownloadFile* value);
static void __lambda26_ (SteadyflowFileListController* self,
                  SteadyflowCoreIDownloadFileStatus status);
static void ___lambda26__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                 SteadyflowCoreIDownloadFileStatus old_status,
                                                                 gpointer self);
static void __lambda27_ (SteadyflowFileListController* self,
                  gint64 size);
static void steadyflow_file_list_controller_on_progress_notify (SteadyflowFileListController* self);
static void ___lambda27__steadyflow_core_idownload_file_download_progressed (SteadyflowCoreIDownloadFile* _sender,
                                                                      gint64 old_size,
                                                                      gpointer self);
static void steadyflow_file_list_controller_set_mount_operation (SteadyflowFileListController* self,
                                                          GMountOperation** mount_op);
static void _steadyflow_file_list_controller_set_mount_operation_steadyflow_core_idownload_file_get_mount_operation (SteadyflowCoreIDownloadFile* _sender,
                                                                                                              GMountOperation** mount_op,
                                                                                                              gpointer self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_basename (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint steadyflow_file_list_controller_get_selection_count (SteadyflowFileListController* self);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_file_list_controller_get_selected_file (SteadyflowFileListController* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN GeeList* steadyflow_file_list_controller_get_selected_files (SteadyflowFileListController* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_file_list_controller_get_file_at_widget_pos (SteadyflowFileListController* self,
                                                                                     gint x,
                                                                                     gint y);
VALA_EXTERN void steadyflow_file_list_controller_set_filter (SteadyflowFileListController* self,
                                                 const gchar* filter);
VALA_EXTERN GType steadyflow_ui_gtk_builder_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowUIGtkBuilderDialog, g_object_unref)
VALA_EXTERN GType steadyflow_add_file_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowAddFileDialog, g_object_unref)
VALA_EXTERN void steadyflow_file_list_controller_on_file_add_request (SteadyflowFileListController* self,
                                                          SteadyflowAddFileDialog* dlg);
VALA_EXTERN SteadyflowCoreIDownloadFileFinishAction steadyflow_add_file_dialog_get_finish_action (SteadyflowAddFileDialog* self);
VALA_EXTERN gchar* steadyflow_add_file_dialog_get_finish_command (SteadyflowAddFileDialog* self);
VALA_EXTERN gchar* steadyflow_add_file_dialog_get_save_path (SteadyflowAddFileDialog* self);
VALA_EXTERN gchar* steadyflow_add_file_dialog_get_url (SteadyflowAddFileDialog* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_url (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_core_idownload_service_add_file (SteadyflowCoreIDownloadService* self,
                                                                         const gchar* url,
                                                                         const gchar* local_name,
                                                                         SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                         const gchar* finish_command,
                                                                         GError** error);
static void steadyflow_file_list_controller_finalize (GObject * obj);
static GType steadyflow_file_list_controller_get_type_once (void);

static inline gpointer
steadyflow_file_list_controller_get_instance_private (SteadyflowFileListController* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowFileListController_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_steadyflow_file_list_controller_set_cell_data_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                          GtkCellRenderer* cell,
                                                                          GtkTreeModel* tree_model,
                                                                          GtkTreeIter* iter,
                                                                          gpointer self)
{
	steadyflow_file_list_controller_set_cell_data ((SteadyflowFileListController*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda28_ (SteadyflowFileListController* self,
             SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (file != NULL);
	steadyflow_file_list_controller_connect_file_signals (self, file);
	steadyflow_file_list_controller_update_model (self);
}

static void
___lambda28__steadyflow_core_idownload_service_file_added (SteadyflowCoreIDownloadService* _sender,
                                                           SteadyflowCoreIDownloadFile* file,
                                                           gpointer self)
{
	__lambda28_ ((SteadyflowFileListController*) self, file);
}

static void
__lambda29_ (SteadyflowFileListController* self,
             SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (file != NULL);
	steadyflow_file_list_controller_update_model (self);
}

static void
___lambda29__steadyflow_core_idownload_service_file_removed (SteadyflowCoreIDownloadService* _sender,
                                                             SteadyflowCoreIDownloadFile* file,
                                                             gpointer self)
{
	__lambda29_ ((SteadyflowFileListController*) self, file);
}

static void
__lambda30_ (SteadyflowFileListController* self)
{
	g_signal_emit (self, steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_SELECTION_CHANGED_SIGNAL], 0);
}

static void
___lambda30__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda30_ ((SteadyflowFileListController*) self);
}

SteadyflowFileListController*
steadyflow_file_list_controller_construct (GType object_type,
                                           GtkTreeView* tree)
{
	SteadyflowFileListController * self = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GTimer* _tmp2_;
	GTimer* _tmp3_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkCellRenderer* renderer = NULL;
	SteadyflowUIDownloadCellRenderer* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkCellRenderer* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkCellRenderer* _tmp11_;
	GType* _tmp12_;
	GType* _tmp13_;
	gint _tmp13__length1;
	GtkListStore* _tmp14_;
	GtkListStore* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	SteadyflowCoreIDownloadService* _tmp29_;
	SteadyflowCoreIDownloadService* _tmp30_;
	SteadyflowCoreIDownloadService* _tmp31_;
	SteadyflowCoreIDownloadService* _tmp32_;
	GtkTreeSelection* _tmp33_;
	g_return_val_if_fail (tree != NULL, NULL);
	self = (SteadyflowFileListController*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (tree);
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = _tmp0_;
	_tmp1_ = gtk_tree_view_get_selection (tree);
	gtk_tree_selection_set_mode (_tmp1_, GTK_SELECTION_MULTIPLE);
	_tmp2_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->redraw_timer);
	self->priv->redraw_timer = _tmp2_;
	_tmp3_ = self->priv->redraw_timer;
	g_timer_start (_tmp3_);
	_tmp4_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp4_);
	column = _tmp4_;
	_tmp5_ = column;
	gtk_tree_view_column_set_expand (_tmp5_, TRUE);
	_tmp6_ = column;
	gtk_tree_view_column_set_clickable (_tmp6_, FALSE);
	_tmp7_ = steadyflow_ui_download_cell_renderer_new ();
	g_object_ref_sink (_tmp7_);
	renderer = (GtkCellRenderer*) _tmp7_;
	_tmp8_ = column;
	_tmp9_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, _tmp9_, TRUE);
	_tmp10_ = column;
	_tmp11_ = renderer;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp10_, _tmp11_, _steadyflow_file_list_controller_set_cell_data_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp12_ = g_new0 (GType, 1);
	_tmp12_[0] = STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	_tmp14_ = gtk_list_store_newv (1, _tmp13_);
	_g_object_unref0 (self->priv->model);
	self->priv->model = _tmp14_;
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp15_ = self->priv->model;
	gtk_tree_view_set_model (tree, (GtkTreeModel*) _tmp15_);
	_tmp16_ = column;
	gtk_tree_view_append_column (tree, _tmp16_);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp17_;
		SteadyflowCoreIDownloadService* _tmp18_;
		GeeList* _tmp19_;
		GeeList* _tmp20_;
		gint _file_size = 0;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _file_index = 0;
		_tmp17_ = steadyflow_services_get_download ();
		_tmp18_ = _tmp17_;
		_tmp19_ = steadyflow_core_idownload_service_get_files (_tmp18_);
		_tmp20_ = _tmp19_;
		_file_list = _tmp20_;
		_tmp21_ = _file_list;
		_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_file_size = _tmp23_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp26_;
			gpointer _tmp27_;
			SteadyflowCoreIDownloadFile* _tmp28_;
			_file_index = _file_index + 1;
			_tmp24_ = _file_index;
			_tmp25_ = _file_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _file_list;
			_tmp27_ = gee_list_get (_tmp26_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp27_;
			_tmp28_ = file;
			steadyflow_file_list_controller_connect_file_signals (self, _tmp28_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	steadyflow_file_list_controller_update_model (self);
	_tmp29_ = steadyflow_services_get_download ();
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "file-added", (GCallback) ___lambda28__steadyflow_core_idownload_service_file_added, self, 0);
	_tmp31_ = steadyflow_services_get_download ();
	_tmp32_ = _tmp31_;
	g_signal_connect_object (_tmp32_, "file-removed", (GCallback) ___lambda29__steadyflow_core_idownload_service_file_removed, self, 0);
	_tmp33_ = gtk_tree_view_get_selection (tree);
	g_signal_connect_object (_tmp33_, "changed", (GCallback) ___lambda30__gtk_tree_selection_changed, self, 0);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	return self;
}

SteadyflowFileListController*
steadyflow_file_list_controller_new (GtkTreeView* tree)
{
	return steadyflow_file_list_controller_construct (STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, tree);
}

static SteadyflowCoreIDownloadFile*
steadyflow_file_list_controller_file_from_iter (SteadyflowFileListController* self,
                                                GtkTreeIter* iter)
{
	GValue value = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	GObject* _tmp3_;
	SteadyflowCoreIDownloadFile* _tmp4_;
	SteadyflowCoreIDownloadFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = self->priv->model;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 0, &_tmp2_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp2_;
	_tmp3_ = g_value_get_object (&value);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile));
	result = _tmp4_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}

static void
steadyflow_file_list_controller_set_cell_data (SteadyflowFileListController* self,
                                               GtkCellLayout* cell_layout,
                                               GtkCellRenderer* renderer,
                                               GtkTreeModel* model,
                                               GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	SteadyflowCoreIDownloadFile* _tmp1_;
	SteadyflowCoreIDownloadFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = steadyflow_file_list_controller_file_from_iter (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	steadyflow_ui_download_cell_renderer_set_file (STEADYFLOW_UI_IS_DOWNLOAD_CELL_RENDERER (renderer) ? ((SteadyflowUIDownloadCellRenderer*) renderer) : NULL, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
__lambda26_ (SteadyflowFileListController* self,
             SteadyflowCoreIDownloadFileStatus status)
{
	GtkTreeView* _tmp0_;
	g_signal_emit (self, steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_SELECTION_CHANGED_SIGNAL], 0);
	g_signal_emit (self, steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_FILELIST_CHANGED_SIGNAL], 0);
	_tmp0_ = self->priv->tree;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
}

static void
___lambda26__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                            SteadyflowCoreIDownloadFileStatus old_status,
                                                            gpointer self)
{
	__lambda26_ ((SteadyflowFileListController*) self, old_status);
}

static void
__lambda27_ (SteadyflowFileListController* self,
             gint64 size)
{
	steadyflow_file_list_controller_on_progress_notify (self);
}

static void
___lambda27__steadyflow_core_idownload_file_download_progressed (SteadyflowCoreIDownloadFile* _sender,
                                                                 gint64 old_size,
                                                                 gpointer self)
{
	__lambda27_ ((SteadyflowFileListController*) self, old_size);
}

static void
_steadyflow_file_list_controller_set_mount_operation_steadyflow_core_idownload_file_get_mount_operation (SteadyflowCoreIDownloadFile* _sender,
                                                                                                         GMountOperation** mount_op,
                                                                                                         gpointer self)
{
	steadyflow_file_list_controller_set_mount_operation ((SteadyflowFileListController*) self, mount_op);
}

static void
steadyflow_file_list_controller_connect_file_signals (SteadyflowFileListController* self,
                                                      SteadyflowCoreIDownloadFile* file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_signal_connect_object (file, "status-changed", (GCallback) ___lambda26__steadyflow_core_idownload_file_status_changed, self, 0);
	g_signal_connect_object (file, "download-progressed", (GCallback) ___lambda27__steadyflow_core_idownload_file_download_progressed, self, 0);
	g_signal_connect_object (file, "get-mount-operation", (GCallback) _steadyflow_file_list_controller_set_mount_operation_steadyflow_core_idownload_file_get_mount_operation, self, 0);
}

static void
steadyflow_file_list_controller_set_mount_operation (SteadyflowFileListController* self,
                                                     GMountOperation** mount_op)
{
	GMountOperation* _vala_mount_op = NULL;
	GtkMountOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMountOperation*) gtk_mount_operation_new (NULL);
	_g_object_unref0 (_vala_mount_op);
	_vala_mount_op = (GMountOperation*) _tmp0_;
	if (mount_op) {
		*mount_op = _vala_mount_op;
	} else {
		_g_object_unref0 (_vala_mount_op);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
steadyflow_file_list_controller_update_model (SteadyflowFileListController* self)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->model;
	gtk_list_store_clear (_tmp0_);
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp1_;
		SteadyflowCoreIDownloadService* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _file_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _file_index = 0;
		_tmp1_ = steadyflow_services_get_download ();
		_tmp2_ = _tmp1_;
		_tmp3_ = steadyflow_core_idownload_service_get_files (_tmp2_);
		_tmp4_ = _tmp3_;
		_file_list = _tmp4_;
		_tmp5_ = _file_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_file_size = _tmp7_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SteadyflowCoreIDownloadFile* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp19_;
			GtkTreeIter _tmp20_ = {0};
			GtkListStore* _tmp21_;
			GtkTreeIter _tmp22_;
			SteadyflowCoreIDownloadFile* _tmp23_;
			_file_index = _file_index + 1;
			_tmp8_ = _file_index;
			_tmp9_ = _file_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _file_list;
			_tmp11_ = gee_list_get (_tmp10_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp11_;
			_tmp12_ = file;
			_tmp13_ = steadyflow_core_idownload_file_get_local_basename (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) -1);
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->filter;
			_tmp18_ = !string_contains (_tmp16_, _tmp17_);
			_g_free0 (_tmp16_);
			if (_tmp18_) {
				_g_object_unref0 (file);
				continue;
			}
			_tmp19_ = self->priv->model;
			gtk_list_store_prepend (_tmp19_, &_tmp20_);
			iter = _tmp20_;
			_tmp21_ = self->priv->model;
			_tmp22_ = iter;
			_tmp23_ = file;
			gtk_list_store_set (_tmp21_, &_tmp22_, 0, _tmp23_, -1, -1);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	g_signal_emit (self, steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_FILELIST_CHANGED_SIGNAL], 0);
}

static void
steadyflow_file_list_controller_on_progress_notify (SteadyflowFileListController* self)
{
	GtkTreeView* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GTimer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp0_);
	_tmp2_ = gtk_widget_get_visible (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->redraw_timer;
	if (g_timer_elapsed (_tmp4_, NULL) >= STEADYFLOW_FILE_LIST_CONTROLLER_REDRAW_SEC) {
		GTimer* _tmp5_;
		GtkTreeView* _tmp6_;
		_tmp5_ = self->priv->redraw_timer;
		g_timer_start (_tmp5_);
		_tmp6_ = self->priv->tree;
		gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
	}
}

gint
steadyflow_file_list_controller_get_selection_count (SteadyflowFileListController* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tree;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	result = gtk_tree_selection_count_selected_rows (_tmp1_);
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

SteadyflowCoreIDownloadFile*
steadyflow_file_list_controller_get_selected_file (SteadyflowFileListController* self)
{
	GtkTreePath* path = NULL;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	SteadyflowCoreIDownloadFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (steadyflow_file_list_controller_get_selection_count (self) != 1) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->tree;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		result = NULL;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	_tmp3_ = self->priv->model;
	_tmp4_ = path;
	_tmp6_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp3_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	if (_tmp6_) {
		GtkTreeIter _tmp7_;
		SteadyflowCoreIDownloadFile* _tmp8_;
		_tmp7_ = iter;
		_tmp8_ = steadyflow_file_list_controller_file_from_iter (self, &_tmp7_);
		result = _tmp8_;
		__vala_GtkTreePath_free0 (path);
		return result;
	} else {
		result = NULL;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

GeeList*
steadyflow_file_list_controller_get_selected_files (SteadyflowFileListController* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = self->priv->tree;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = gtk_tree_selection_get_selected_rows (_tmp2_, NULL);
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp3_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp4_;
			GtkTreePath* path = NULL;
			_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp4_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp5_;
				GtkTreePath* _tmp6_;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_;
				_tmp5_ = self->priv->model;
				_tmp6_ = path;
				_tmp8_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
				iter = _tmp7_;
				if (_tmp8_) {
					GeeArrayList* _tmp9_;
					GtkTreeIter _tmp10_;
					SteadyflowCoreIDownloadFile* _tmp11_;
					SteadyflowCoreIDownloadFile* _tmp12_;
					_tmp9_ = list;
					_tmp10_ = iter;
					_tmp11_ = steadyflow_file_list_controller_file_from_iter (self, &_tmp10_);
					_tmp12_ = _tmp11_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
					_g_object_unref0 (_tmp12_);
				}
				__vala_GtkTreePath_free0 (path);
			}
		}
		(path_collection == NULL) ? NULL : (path_collection = (_g_list_free___vala_GtkTreePath_free0_ (path_collection), NULL));
	}
	result = (GeeList*) list;
	return result;
}

SteadyflowCoreIDownloadFile*
steadyflow_file_list_controller_get_file_at_widget_pos (SteadyflowFileListController* self,
                                                        gint x,
                                                        gint y)
{
	gint bx = 0;
	gint by = 0;
	GtkTreeView* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkTreePath* path = NULL;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp3_;
	GtkTreePath* _tmp4_ = NULL;
	gboolean _tmp5_;
	SteadyflowCoreIDownloadFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tree;
	gtk_tree_view_convert_widget_to_bin_window_coords (_tmp0_, x, y, &_tmp1_, &_tmp2_);
	bx = _tmp1_;
	by = _tmp2_;
	_tmp3_ = self->priv->tree;
	_tmp5_ = gtk_tree_view_get_path_at_pos (_tmp3_, bx, by, &_tmp4_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp4_;
	if (_tmp5_) {
		GtkListStore* _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		gboolean _tmp9_;
		_tmp6_ = self->priv->model;
		_tmp7_ = path;
		_tmp9_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp6_, &_tmp8_, _tmp7_);
		iter = _tmp8_;
		if (_tmp9_) {
			GtkTreeIter _tmp10_;
			SteadyflowCoreIDownloadFile* _tmp11_;
			_tmp10_ = iter;
			_tmp11_ = steadyflow_file_list_controller_file_from_iter (self, &_tmp10_);
			result = _tmp11_;
			__vala_GtkTreePath_free0 (path);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreePath_free0 (path);
	return result;
}

void
steadyflow_file_list_controller_set_filter (SteadyflowFileListController* self,
                                            const gchar* filter)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	_tmp0_ = g_utf8_casefold (filter, (gssize) -1);
	_g_free0 (self->priv->filter);
	self->priv->filter = _tmp0_;
	steadyflow_file_list_controller_update_model (self);
}

void
steadyflow_file_list_controller_on_file_add_request (SteadyflowFileListController* self,
                                                     SteadyflowAddFileDialog* dlg)
{
	gchar* save_to = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* url = NULL;
	gchar* _tmp11_;
	const gchar* _tmp30_;
	GFile* _tmp31_;
	GFile* _tmp32_;
	gboolean _tmp33_;
	SteadyflowCoreIDownloadFileFinishAction finish_action = 0;
	gchar* finish_command = NULL;
	gchar* _tmp39_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	save_to = NULL;
	if (steadyflow_add_file_dialog_get_finish_action (dlg) == STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = steadyflow_add_file_dialog_get_finish_command (dlg);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == NULL;
		_g_free0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMessageDialog* md = NULL;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) dlg, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT, _ ("Please enter a command to run"), _ ("You have specified that Steadyflow should run a command when the downl" \
"oad finishes, " "but have not entered a command to run. Please specify it."));
		g_object_ref_sink (_tmp3_);
		md = _tmp3_;
		_tmp4_ = md;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = md;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (md);
		_g_free0 (save_to);
		return;
	}
	_tmp6_ = steadyflow_add_file_dialog_get_save_path (dlg);
	_g_free0 (save_to);
	save_to = _tmp6_;
	_tmp7_ = save_to;
	if (_tmp7_ == NULL) {
		GtkMessageDialog* md = NULL;
		GtkMessageDialog* _tmp8_;
		GtkMessageDialog* _tmp9_;
		GtkMessageDialog* _tmp10_;
		_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) dlg, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT, _ ("Invalid file name"), _ ("The file name you have entered is not valid. Please correct it."));
		g_object_ref_sink (_tmp8_);
		md = _tmp8_;
		_tmp9_ = md;
		gtk_dialog_run ((GtkDialog*) _tmp9_);
		_tmp10_ = md;
		gtk_widget_destroy ((GtkWidget*) _tmp10_);
		_g_object_unref0 (md);
		_g_free0 (save_to);
		return;
	}
	_tmp11_ = steadyflow_add_file_dialog_get_url (dlg);
	url = _tmp11_;
	{
		GeeList* _file_list = NULL;
		SteadyflowCoreIDownloadService* _tmp12_;
		SteadyflowCoreIDownloadService* _tmp13_;
		GeeList* _tmp14_;
		GeeList* _tmp15_;
		gint _file_size = 0;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _file_index = 0;
		_tmp12_ = steadyflow_services_get_download ();
		_tmp13_ = _tmp12_;
		_tmp14_ = steadyflow_core_idownload_service_get_files (_tmp13_);
		_tmp15_ = _tmp14_;
		_file_list = _tmp15_;
		_tmp16_ = _file_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_file_size = _tmp18_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp21_;
			gpointer _tmp22_;
			SteadyflowCoreIDownloadFile* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_file_index = _file_index + 1;
			_tmp19_ = _file_index;
			_tmp20_ = _file_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _file_list;
			_tmp22_ = gee_list_get (_tmp21_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp22_;
			_tmp23_ = file;
			_tmp24_ = steadyflow_core_idownload_file_get_url (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = url;
			if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
				GtkMessageDialog* md = NULL;
				GtkMessageDialog* _tmp27_;
				GtkMessageDialog* _tmp28_;
				GtkMessageDialog* _tmp29_;
				_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) dlg, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT, _ ("File already in list"), _ ("The address you are trying to add for download is already in the file " \
"list."));
				g_object_ref_sink (_tmp27_);
				md = _tmp27_;
				_tmp28_ = md;
				gtk_dialog_run ((GtkDialog*) _tmp28_);
				_tmp29_ = md;
				gtk_widget_destroy ((GtkWidget*) _tmp29_);
				_g_object_unref0 (md);
				_g_object_unref0 (file);
				_g_object_unref0 (_file_list);
				_g_free0 (url);
				_g_free0 (save_to);
				return;
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp30_ = save_to;
	_tmp31_ = g_file_new_for_path (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_file_query_exists (_tmp32_, NULL);
	_g_object_unref0 (_tmp32_);
	if (_tmp33_) {
		GtkMessageDialog* md = NULL;
		GtkMessageDialog* _tmp34_;
		GtkMessageDialog* _tmp35_;
		GtkMessageDialog* _tmp36_;
		gint response = 0;
		GtkMessageDialog* _tmp37_;
		GtkMessageDialog* _tmp38_;
		_tmp34_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) dlg, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT, _ ("File exists"), _ ("The file you are trying to save the download to already exists. " "Are you sure you want to overwrite it?"));
		g_object_ref_sink (_tmp34_);
		md = _tmp34_;
		_tmp35_ = md;
		gtk_dialog_add_button ((GtkDialog*) _tmp35_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
		_tmp36_ = md;
		gtk_dialog_add_button ((GtkDialog*) _tmp36_, _ ("Overwrite"), (gint) GTK_RESPONSE_OK);
		_tmp37_ = md;
		response = gtk_dialog_run ((GtkDialog*) _tmp37_);
		_tmp38_ = md;
		gtk_widget_destroy ((GtkWidget*) _tmp38_);
		if (response != ((gint) GTK_RESPONSE_OK)) {
			_g_object_unref0 (md);
			_g_free0 (url);
			_g_free0 (save_to);
			return;
		}
		_g_object_unref0 (md);
	}
	finish_action = steadyflow_add_file_dialog_get_finish_action (dlg);
	_tmp39_ = steadyflow_add_file_dialog_get_finish_command (dlg);
	finish_command = _tmp39_;
	gtk_widget_destroy ((GtkWidget*) dlg);
	{
		SteadyflowCoreIDownloadService* _tmp40_;
		SteadyflowCoreIDownloadService* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		SteadyflowCoreIDownloadFile* _tmp45_;
		SteadyflowCoreIDownloadFile* _tmp46_;
		_tmp40_ = steadyflow_services_get_download ();
		_tmp41_ = _tmp40_;
		_tmp42_ = url;
		_tmp43_ = save_to;
		_tmp44_ = finish_command;
		_tmp45_ = steadyflow_core_idownload_service_add_file (_tmp41_, _tmp42_, _tmp43_, finish_action, _tmp44_, &_inner_error0_);
		_tmp46_ = _tmp45_;
		_g_object_unref0 (_tmp46_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* md = NULL;
		gchar* _tmp47_;
		gchar* _tmp48_;
		GError* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		GtkMessageDialog* _tmp53_;
		GtkMessageDialog* _tmp54_;
		GtkMessageDialog* _tmp55_;
		GtkMessageDialog* _tmp56_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = g_strconcat (_ ("An error has occurred while trying to start the download."), "\n\n", NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		_tmp51_ = g_strconcat (_tmp48_, _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, STEADYFLOW_UI_UI_UTIL_MESSAGE_FORMAT, _ ("Error adding download"), _tmp52_);
		g_object_ref_sink (_tmp53_);
		_tmp54_ = _tmp53_;
		_g_free0 (_tmp52_);
		_g_free0 (_tmp48_);
		md = _tmp54_;
		_tmp55_ = md;
		gtk_dialog_run ((GtkDialog*) _tmp55_);
		_tmp56_ = md;
		gtk_widget_destroy ((GtkWidget*) _tmp56_);
		_g_object_unref0 (md);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (finish_command);
		_g_free0 (url);
		_g_free0 (save_to);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (finish_command);
	_g_free0 (url);
	_g_free0 (save_to);
}

static void
steadyflow_file_list_controller_class_init (SteadyflowFileListControllerClass * klass,
                                            gpointer klass_data)
{
	steadyflow_file_list_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowFileListController_private_offset);
	G_OBJECT_CLASS (klass)->finalize = steadyflow_file_list_controller_finalize;
	steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_FILELIST_CHANGED_SIGNAL] = g_signal_new ("filelist-changed", STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	steadyflow_file_list_controller_signals[STEADYFLOW_FILE_LIST_CONTROLLER_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
steadyflow_file_list_controller_instance_init (SteadyflowFileListController * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = steadyflow_file_list_controller_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->filter = _tmp0_;
}

static void
steadyflow_file_list_controller_finalize (GObject * obj)
{
	SteadyflowFileListController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_TYPE_FILE_LIST_CONTROLLER, SteadyflowFileListController);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->model);
	_g_free0 (self->priv->filter);
	_g_timer_destroy0 (self->priv->redraw_timer);
	G_OBJECT_CLASS (steadyflow_file_list_controller_parent_class)->finalize (obj);
}

static GType
steadyflow_file_list_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowFileListControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_file_list_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowFileListController), 0, (GInstanceInitFunc) steadyflow_file_list_controller_instance_init, NULL };
	GType steadyflow_file_list_controller_type_id;
	steadyflow_file_list_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SteadyflowFileListController", &g_define_type_info, 0);
	SteadyflowFileListController_private_offset = g_type_add_instance_private (steadyflow_file_list_controller_type_id, sizeof (SteadyflowFileListControllerPrivate));
	return steadyflow_file_list_controller_type_id;
}

GType
steadyflow_file_list_controller_get_type (void)
{
	static volatile gsize steadyflow_file_list_controller_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_file_list_controller_type_id__once)) {
		GType steadyflow_file_list_controller_type_id;
		steadyflow_file_list_controller_type_id = steadyflow_file_list_controller_get_type_once ();
		g_once_init_leave (&steadyflow_file_list_controller_type_id__once, steadyflow_file_list_controller_type_id);
	}
	return steadyflow_file_list_controller_type_id__once;
}

