/* QuickTimeAtom.c generated by valac 0.56.17, the Vala compiler
 * generated from QuickTimeAtom.vala, do not modify */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-internal-video-metadata-handling.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_QUICK_TIME_ATOM (quick_time_atom_get_type ())
#define QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtom))
#define QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))
#define IS_QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_ATOM))
#define IS_QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_ATOM))
#define QUICK_TIME_ATOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))

typedef struct _QuickTimeAtom QuickTimeAtom;
typedef struct _QuickTimeAtomClass QuickTimeAtomClass;
typedef struct _QuickTimeAtomPrivate QuickTimeAtomPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _quick_time_atom_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_atom_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecQuickTimeAtom ParamSpecQuickTimeAtom;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _QuickTimeAtom {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeAtomPrivate * priv;
};

struct _QuickTimeAtomClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeAtom *self);
};

struct _QuickTimeAtomPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	QuickTimeAtom* parent;
};

struct _ParamSpecQuickTimeAtom {
	GParamSpec parent_instance;
};

static gint QuickTimeAtom_private_offset;
static gpointer quick_time_atom_parent_class = NULL;

VALA_EXTERN gpointer quick_time_atom_ref (gpointer instance);
VALA_EXTERN void quick_time_atom_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_quick_time_atom (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_quick_time_atom (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_quick_time_atom (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_quick_time_atom (const GValue* value);
VALA_EXTERN GType quick_time_atom_get_type (void) G_GNUC_CONST ;
VALA_EXTERN QuickTimeAtom* quick_time_atom_new (GFile* file);
VALA_EXTERN QuickTimeAtom* quick_time_atom_construct (GType object_type,
                                          GFile* file);
static QuickTimeAtom* quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                                      QuickTimeAtom* parent);
static QuickTimeAtom* quick_time_atom_construct_with_input_stream (GType object_type,
                                                            GDataInputStream* input,
                                                            QuickTimeAtom* parent);
VALA_EXTERN void quick_time_atom_open_file (QuickTimeAtom* self,
                                GError** error);
VALA_EXTERN void quick_time_atom_close_file (QuickTimeAtom* self,
                                 GError** error);
static void quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                             guint64 amount);
VALA_EXTERN QuickTimeAtom* quick_time_atom_get_first_child_atom (QuickTimeAtom* self);
VALA_EXTERN guchar quick_time_atom_read_byte (QuickTimeAtom* self,
                                  GError** error);
VALA_EXTERN guint32 quick_time_atom_read_uint32 (QuickTimeAtom* self,
                                     GError** error);
VALA_EXTERN guint64 quick_time_atom_read_uint64 (QuickTimeAtom* self,
                                     GError** error);
VALA_EXTERN void quick_time_atom_read_atom (QuickTimeAtom* self,
                                GError** error);
static void quick_time_atom_skip (QuickTimeAtom* self,
                           guint64 skip_amount,
                           GError** error);
VALA_EXTERN guint64 quick_time_atom_section_size_remaining (QuickTimeAtom* self);
VALA_EXTERN void quick_time_atom_next_atom (QuickTimeAtom* self,
                                GError** error);
VALA_EXTERN gchar* quick_time_atom_get_current_atom_name (QuickTimeAtom* self);
VALA_EXTERN gboolean quick_time_atom_is_last_atom (QuickTimeAtom* self);
static void quick_time_atom_finalize (QuickTimeAtom * obj);
static GType quick_time_atom_get_type_once (void);

static inline gpointer
quick_time_atom_get_instance_private (QuickTimeAtom* self)
{
	return G_STRUCT_MEMBER_P (self, QuickTimeAtom_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

QuickTimeAtom*
quick_time_atom_construct (GType object_type,
                           GFile* file)
{
	QuickTimeAtom* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

QuickTimeAtom*
quick_time_atom_new (GFile* file)
{
	return quick_time_atom_construct (TYPE_QUICK_TIME_ATOM, file);
}

static gpointer
_quick_time_atom_ref0 (gpointer self)
{
	return self ? quick_time_atom_ref (self) : NULL;
}

static QuickTimeAtom*
quick_time_atom_construct_with_input_stream (GType object_type,
                                             GDataInputStream* input,
                                             QuickTimeAtom* parent)
{
	QuickTimeAtom* self = NULL;
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (input, g_data_input_stream_get_type ()), NULL);
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (parent), NULL);
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (input);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = _quick_time_atom_ref0 (parent);
	_quick_time_atom_unref0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}

static QuickTimeAtom*
quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                       QuickTimeAtom* parent)
{
	return quick_time_atom_construct_with_input_stream (TYPE_QUICK_TIME_ATOM, input, parent);
}

void
quick_time_atom_open_file (QuickTimeAtom* self,
                           GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	quick_time_atom_close_file (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp3_;
	_tmp4_ = self->priv->input;
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp5_;
	_g_object_unref0 (_tmp0_);
}

void
quick_time_atom_close_file (QuickTimeAtom* self,
                            GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	_tmp0_ = self->priv->input;
	if (NULL != _tmp0_) {
		GDataInputStream* _tmp1_;
		_tmp1_ = self->priv->input;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->input);
		self->priv->input = NULL;
	}
}

static void
quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                        guint64 amount)
{
	QuickTimeAtom* _tmp0_;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	self->priv->section_offset = self->priv->section_offset + amount;
	_tmp0_ = self->priv->parent;
	if (NULL != _tmp0_) {
		QuickTimeAtom* _tmp1_;
		_tmp1_ = self->priv->parent;
		quick_time_atom_advance_section_offset (_tmp1_, amount);
	}
}

QuickTimeAtom*
quick_time_atom_get_first_child_atom (QuickTimeAtom* self)
{
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
	QuickTimeAtom* result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
	_tmp0_ = self->priv->input;
	_tmp1_ = quick_time_atom_new_with_input_stream (_tmp0_, self);
	result = _tmp1_;
	return result;
}

guchar
quick_time_atom_read_byte (QuickTimeAtom* self,
                           GError** error)
{
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guchar result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), '\0');
	quick_time_atom_advance_section_offset (self, (guint64) 1);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guchar _tmp2_ = '\0';
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = (guchar) _tmp0_;
	return result;
}

guint32
quick_time_atom_read_uint32 (QuickTimeAtom* self,
                             GError** error)
{
	guint32 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0U);
	quick_time_atom_advance_section_offset (self, (guint64) 4);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint32 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp2_ = 0U;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

guint64
quick_time_atom_read_uint64 (QuickTimeAtom* self,
                             GError** error)
{
	guint64 _tmp0_ = 0ULL;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
	quick_time_atom_advance_section_offset (self, (guint64) 8);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint64 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp2_ = 0ULL;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

void
quick_time_atom_read_atom (QuickTimeAtom* self,
                           GError** error)
{
	guint32 _tmp0_ = 0U;
	GString* sb = NULL;
	GString* _tmp1_;
	guchar _tmp2_ = '\0';
	GString* _tmp3_;
	guchar _tmp4_ = '\0';
	GString* _tmp5_;
	guchar _tmp6_ = '\0';
	GString* _tmp7_;
	guchar _tmp8_ = '\0';
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	_tmp0_ = quick_time_atom_read_uint32 (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) _tmp0_;
	_tmp1_ = g_string_new ("");
	sb = _tmp1_;
	_tmp2_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp3_ = sb;
	g_string_append_c (_tmp3_, (gchar) _tmp2_);
	_tmp4_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp5_ = sb;
	g_string_append_c (_tmp5_, (gchar) _tmp4_);
	_tmp6_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp7_ = sb;
	g_string_append_c (_tmp7_, (gchar) _tmp6_);
	_tmp8_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp9_ = sb;
	g_string_append_c (_tmp9_, (gchar) _tmp8_);
	_tmp10_ = sb;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp12_;
	_tmp13_ = self->priv->section_name;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 4) {
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		GError* _tmp20_;
		_tmp16_ = self->priv->file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "QuickTime atom name length is invalid for %s", _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_inner_error0_ = _tmp20_;
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				const gchar* _tmp26_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = self->priv->section_name;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				if (!(i < _tmp25_)) {
					break;
				}
				_tmp26_ = self->priv->section_name;
				if (!g_ascii_isprint (string_get (_tmp26_, (glong) i))) {
					GFile* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					GError* _tmp30_;
					GError* _tmp31_;
					_tmp27_ = self->priv->file;
					_tmp28_ = g_file_get_path (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Bad QuickTime atom in file %s", _tmp29_);
					_tmp31_ = _tmp30_;
					_g_free0 (_tmp29_);
					_inner_error0_ = _tmp31_;
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (sb);
					return;
				}
			}
		}
	}
	if (((guint64) 1) == self->priv->section_size) {
		guint64 _tmp32_ = 0ULL;
		_tmp32_ = quick_time_atom_read_uint64 (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return;
		}
		self->priv->section_size = _tmp32_;
	}
	_g_string_free0 (sb);
}

static void
quick_time_atom_skip (QuickTimeAtom* self,
                      guint64 skip_amount,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	_tmp0_ = self->priv->input;
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

guint64
quick_time_atom_section_size_remaining (QuickTimeAtom* self)
{
	guint64 result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
	_vala_assert (self->priv->section_size >= self->priv->section_offset, "section_size >= section_offset");
	result = self->priv->section_size - self->priv->section_offset;
	return result;
}

void
quick_time_atom_next_atom (QuickTimeAtom* self,
                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
	quick_time_atom_skip (self, quick_time_atom_section_size_remaining (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
}

gchar*
quick_time_atom_get_current_atom_name (QuickTimeAtom* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
	_tmp0_ = self->priv->section_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
quick_time_atom_is_last_atom (QuickTimeAtom* self)
{
	gboolean result;
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), FALSE);
	result = ((guint64) 0) == self->priv->section_size;
	return result;
}

static void
value_quick_time_atom_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_quick_time_atom_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		quick_time_atom_unref (value->data[0].v_pointer);
	}
}

static void
value_quick_time_atom_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = quick_time_atom_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_quick_time_atom_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_quick_time_atom_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QuickTimeAtom * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = quick_time_atom_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_quick_time_atom_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	QuickTimeAtom ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = quick_time_atom_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_quick_time_atom (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecQuickTimeAtom* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_ATOM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_quick_time_atom (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_quick_time_atom (GValue* value,
                           gpointer v_object)
{
	QuickTimeAtom * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		quick_time_atom_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_atom_unref (old);
	}
}

void
value_take_quick_time_atom (GValue* value,
                            gpointer v_object)
{
	QuickTimeAtom * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_atom_unref (old);
	}
}

static void
quick_time_atom_class_init (QuickTimeAtomClass * klass,
                            gpointer klass_data)
{
	quick_time_atom_parent_class = g_type_class_peek_parent (klass);
	((QuickTimeAtomClass *) klass)->finalize = quick_time_atom_finalize;
	g_type_class_adjust_private_offset (klass, &QuickTimeAtom_private_offset);
}

static void
quick_time_atom_instance_init (QuickTimeAtom * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = quick_time_atom_get_instance_private (self);
	self->priv->file = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->section_name = _tmp0_;
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	self->priv->input = NULL;
	self->priv->parent = NULL;
	self->ref_count = 1;
}

static void
quick_time_atom_finalize (QuickTimeAtom * obj)
{
	QuickTimeAtom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_ATOM, QuickTimeAtom);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->section_name);
	_g_object_unref0 (self->priv->input);
	_quick_time_atom_unref0 (self->priv->parent);
}

static GType
quick_time_atom_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_quick_time_atom_init, value_quick_time_atom_free_value, value_quick_time_atom_copy_value, value_quick_time_atom_peek_pointer, "p", value_quick_time_atom_collect_value, "p", value_quick_time_atom_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QuickTimeAtomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_atom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeAtom), 0, (GInstanceInitFunc) quick_time_atom_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType quick_time_atom_type_id;
	quick_time_atom_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeAtom", &g_define_type_info, &g_define_type_fundamental_info, 0);
	QuickTimeAtom_private_offset = g_type_add_instance_private (quick_time_atom_type_id, sizeof (QuickTimeAtomPrivate));
	return quick_time_atom_type_id;
}

GType
quick_time_atom_get_type (void)
{
	static volatile gsize quick_time_atom_type_id__once = 0;
	if (g_once_init_enter (&quick_time_atom_type_id__once)) {
		GType quick_time_atom_type_id;
		quick_time_atom_type_id = quick_time_atom_get_type_once ();
		g_once_init_leave (&quick_time_atom_type_id__once, quick_time_atom_type_id);
	}
	return quick_time_atom_type_id__once;
}

gpointer
quick_time_atom_ref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
quick_time_atom_unref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QUICK_TIME_ATOM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

