/* AVIMetadataLoader.c generated by valac 0.56.17, the Vala compiler
 * generated from AVIMetadataLoader.vala, do not modify */

#include "shotwell-internal-video-metadata-handling.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include "metadata.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH 19
#define AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER ((guint16) 0x13)
#define AVI_METADATA_LOADER_MAX_STRD_LENGTH 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_AVI_CHUNK (avi_chunk_get_type ())
#define AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_CHUNK, AVIChunk))
#define AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_CHUNK, AVIChunkClass))
#define IS_AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_CHUNK))
#define IS_AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_CHUNK))
#define AVI_CHUNK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_CHUNK, AVIChunkClass))

typedef struct _AVIChunk AVIChunk;
typedef struct _AVIChunkClass AVIChunkClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _avi_chunk_unref0(var) ((var == NULL) ? NULL : (var = (avi_chunk_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecAVIMetadataLoader ParamSpecAVIMetadataLoader;

struct _AVIMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecAVIMetadataLoader {
	GParamSpec parent_instance;
};

static gint AVIMetadataLoader_private_offset;
static gpointer avi_metadata_loader_parent_class = NULL;

static GDateTime* avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self);
VALA_EXTERN gpointer avi_chunk_ref (gpointer instance);
VALA_EXTERN void avi_chunk_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_avi_chunk (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_avi_chunk (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_avi_chunk (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_avi_chunk (const GValue* value);
VALA_EXTERN GType avi_chunk_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AVIChunk* avi_chunk_new (GFile* file);
VALA_EXTERN AVIChunk* avi_chunk_construct (GType object_type,
                               GFile* file);
VALA_EXTERN void avi_chunk_open_file (AVIChunk* self,
                          GError** error);
VALA_EXTERN void avi_chunk_read_chunk (AVIChunk* self,
                           GError** error);
VALA_EXTERN gchar* avi_chunk_get_current_chunk_name (AVIChunk* self);
VALA_EXTERN gchar* avi_chunk_read_name (AVIChunk* self,
                            GError** error);
VALA_EXTERN void avi_chunk_close_file (AVIChunk* self,
                           GError** error);
static gchar* avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                                AVIChunk* chunk,
                                                GError** error);
VALA_EXTERN guint64 avi_chunk_section_size_remaining (AVIChunk* self);
VALA_EXTERN guint16 avi_chunk_read_uint16 (AVIChunk* self,
                               GError** error);
VALA_EXTERN void avi_chunk_skip (AVIChunk* self,
                     guint64 skip_amount,
                     GError** error);
VALA_EXTERN guchar avi_chunk_read_byte (AVIChunk* self,
                            GError** error);
static gchar* avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                               AVIChunk* chunk,
                                               GError** error);
static gchar* avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error);
VALA_EXTERN gchar* avi_chunk_section_to_string (AVIChunk* self,
                                    GError** error);
VALA_EXTERN AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self);
VALA_EXTERN gboolean avi_chunk_is_last_chunk (AVIChunk* self);
VALA_EXTERN void avi_chunk_next_chunk (AVIChunk* self,
                           GError** error);
static GDateTime* avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                           const gchar* sdate);
static GDateMonth avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                                  const gchar* s);
VALA_EXTERN void avi_chunk_nonsection_skip (AVIChunk* self,
                                guint64 skip_amount,
                                GError** error);
static void avi_metadata_loader_finalize (AVIMetadataLoader * obj);
static GType avi_metadata_loader_get_type_once (void);

static inline gpointer
avi_metadata_loader_get_instance_private (AVIMetadataLoader* self)
{
	return G_STRUCT_MEMBER_P (self, AVIMetadataLoader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AVIMetadataLoader*
avi_metadata_loader_construct (GType object_type,
                               GFile* file)
{
	AVIMetadataLoader* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (AVIMetadataLoader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

AVIMetadataLoader*
avi_metadata_loader_new (GFile* file)
{
	return avi_metadata_loader_construct (TYPE_AVI_METADATA_LOADER, file);
}

MetadataDateTime*
avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	MetadataDateTime* _tmp2_;
	MetadataDateTime* _tmp3_;
	MetadataDateTime* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	_tmp0_ = avi_metadata_loader_get_creation_date_time_for_avi (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = metadata_date_time_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
avi_metadata_loader_get_title (AVIMetadataLoader* self)
{
	gchar* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	result = NULL;
	return result;
}

gboolean
avi_metadata_loader_is_supported (AVIMetadataLoader* self)
{
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = avi_chunk_new (_tmp0_);
	chunk = _tmp1_;
	ret = FALSE;
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gboolean _tmp4_ = FALSE;
		AVIChunk* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp2_ = chunk;
		avi_chunk_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = chunk;
		avi_chunk_read_chunk (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = chunk;
		_tmp6_ = avi_chunk_get_current_chunk_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 ("RIFF", _tmp7_) == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_ = NULL;
			AVIChunk* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = chunk;
			_tmp11_ = avi_chunk_read_name (_tmp10_, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = g_strcmp0 ("AVI ", _tmp9_) == 0;
			_g_free0 (_tmp9_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ret = TRUE;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_debug ("AVIMetadataLoader.vala:40: Error while testing for AVI file: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	{
		AVIChunk* _tmp15_;
		_tmp15_ = chunk;
		avi_chunk_close_file (_tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("AVIMetadataLoader.vala:46: Error while closing AVI file: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = ret;
	_avi_chunk_unref0 (chunk);
	return result;
}

static gchar*
avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error)
{
	gboolean found_date = FALSE;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
	found_date = FALSE;
	while (TRUE) {
		guint16 tag = 0U;
		guint16 size = 0U;
		if (!(avi_chunk_section_size_remaining (chunk) > ((guint64) (sizeof (guint16) * 2)))) {
			break;
		}
		tag = avi_chunk_read_uint16 (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		size = avi_chunk_read_uint16 (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		if (AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER == tag) {
			found_date = TRUE;
			break;
		}
		avi_chunk_skip (chunk, (guint64) size, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
	}
	if (found_date) {
		GString* sb = NULL;
		GString* _tmp0_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = g_string_new ("");
		sb = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					guchar _tmp3_ = '\0';
					GString* _tmp4_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH)) {
						break;
					}
					_tmp3_ = avi_chunk_read_byte (chunk, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (sb);
						return NULL;
					}
					_tmp4_ = sb;
					g_string_append_c (_tmp4_, (gchar) _tmp3_);
				}
			}
		}
		_tmp5_ = sb;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_string_free0 (sb);
		return result;
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                        AVIChunk* chunk,
                                        GError** error)
{
	gint colons = 0;
	gint post_colons = 0;
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
	avi_chunk_skip (chunk, (guint64) 98, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	avi_chunk_skip (chunk, (guint64) 8, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	colons = 0;
	post_colons = 0;
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		guchar _tmp2_ = '\0';
		gchar c = '\0';
		GString* _tmp6_;
		if (colons <= 4) {
			_tmp1_ = post_colons < 2;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = avi_chunk_read_byte (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return NULL;
		}
		c = (gchar) _tmp2_;
		if (4 == colons) {
			gint _tmp3_;
			_tmp3_ = post_colons;
			post_colons = _tmp3_ + 1;
		}
		if (':' == c) {
			gint _tmp4_;
			_tmp4_ = colons;
			colons = _tmp4_ + 1;
		}
		if (g_ascii_isprint (c)) {
			GString* _tmp5_;
			_tmp5_ = sb;
			g_string_append_c (_tmp5_, c);
		}
		_tmp6_ = sb;
		if (_tmp6_->len > ((gssize) AVI_METADATA_LOADER_MAX_STRD_LENGTH)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			result = _tmp7_;
			_g_string_free0 (sb);
			return result;
		}
	}
	_tmp8_ = sb;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		_g_string_free0 (sb);
		return result;
	}
	_tmp13_ = sb;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = sb;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = strlen (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_substring (_tmp14_, (glong) (_tmp18_ - AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH), (glong) -1);
	result = _tmp19_;
	_g_string_free0 (sb);
	return result;
}

static gchar*
avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                  AVIChunk* chunk,
                                  GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
	while (TRUE) {
		gchar* name = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp13_;
		avi_chunk_read_chunk (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp0_ = avi_chunk_get_current_chunk_name (chunk);
		name = _tmp0_;
		_tmp1_ = name;
		if (g_strcmp0 ("IDIT", _tmp1_) == 0) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = avi_chunk_section_to_string (chunk, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			result = _tmp4_;
			_g_free0 (_tmp2_);
			_g_free0 (name);
			return result;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = name;
			if (g_strcmp0 ("nctg", _tmp5_) == 0) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = avi_metadata_loader_read_nikon_nctg_tag (self, chunk, &_inner_error0_);
				_tmp6_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (name);
					return NULL;
				}
				_tmp8_ = _tmp6_;
				_tmp6_ = NULL;
				result = _tmp8_;
				_g_free0 (_tmp6_);
				_g_free0 (name);
				return result;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = name;
				if (g_strcmp0 ("strd", _tmp9_) == 0) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = avi_metadata_loader_read_fuji_strd_tag (self, chunk, &_inner_error0_);
					_tmp10_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						return NULL;
					}
					_tmp12_ = _tmp10_;
					_tmp10_ = NULL;
					result = _tmp12_;
					_g_free0 (_tmp10_);
					_g_free0 (name);
					return result;
				}
			}
		}
		_tmp13_ = name;
		if (g_strcmp0 ("LIST", _tmp13_) == 0) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _result_ = NULL;
			AVIChunk* _tmp16_;
			AVIChunk* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = avi_chunk_read_name (chunk, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp16_ = avi_chunk_get_first_child_chunk (chunk);
			_tmp17_ = _tmp16_;
			_tmp18_ = avi_metadata_loader_read_section (self, _tmp17_, &_inner_error0_);
			_tmp19_ = _tmp18_;
			_avi_chunk_unref0 (_tmp17_);
			_result_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp20_ = _result_;
			if (NULL != _tmp20_) {
				result = _result_;
				_g_free0 (name);
				return result;
			}
			_g_free0 (_result_);
		}
		if (avi_chunk_is_last_chunk (chunk)) {
			_g_free0 (name);
			break;
		}
		avi_chunk_next_chunk (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (name);
			return NULL;
		}
		_g_free0 (name);
	}
	result = NULL;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static GDateTime*
avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                const gchar* sdate)
{
	gint _tmp0_;
	gint _tmp1_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint min = 0;
	gint sec = 0;
	gchar weekday[4] = {0};
	gchar monthstr[4] = {0};
	GDateTime* parsed_date = NULL;
	GDateTime* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	g_return_val_if_fail (sdate != NULL, NULL);
	_tmp0_ = strlen (sdate);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	if (g_ascii_isdigit (string_get (sdate, (glong) 0))) {
		gchar* tmp = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _result_ = 0;
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_;
		GDateTime* _tmp12_;
		_tmp2_ = g_strdup (sdate);
		tmp = _tmp2_;
		_tmp3_ = tmp;
		g_strcanon (_tmp3_, "0123456789 ", ' ');
		sec = 0;
		_tmp4_ = tmp;
		_tmp11_ = sscanf (_tmp4_, "%d %d %d %d %d %d", &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
		year = _tmp5_;
		month = _tmp6_;
		day = _tmp7_;
		hour = _tmp8_;
		min = _tmp9_;
		sec = _tmp10_;
		_result_ = _tmp11_;
		if (_result_ < 5) {
			result = NULL;
			_g_free0 (tmp);
			_g_date_time_unref0 (parsed_date);
			return result;
		}
		_tmp12_ = g_date_time_new_utc (year, month, day, hour, min, (gdouble) sec);
		_g_date_time_unref0 (parsed_date);
		parsed_date = _tmp12_;
		_g_free0 (tmp);
	} else {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_;
		GDateTime* _tmp19_;
		_tmp18_ = sscanf (sdate, "%3s %3s %d %d:%d:%d %d", weekday, monthstr, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
		day = _tmp13_;
		hour = _tmp14_;
		min = _tmp15_;
		sec = _tmp16_;
		year = _tmp17_;
		if (7 != _tmp18_) {
			result = NULL;
			_g_date_time_unref0 (parsed_date);
			return result;
		}
		_tmp19_ = g_date_time_new_local (year, (gint) avi_metadata_loader_month_from_string (self, (const gchar*) monthstr), day, hour, min, (gdouble) sec);
		_g_date_time_unref0 (parsed_date);
		parsed_date = _tmp19_;
	}
	result = parsed_date;
	return result;
}

static GDateMonth
avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                       const gchar* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	GDateMonth result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0);
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jan")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JANUARY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("feb")))) {
		switch (0) {
			default:
			{
				result = G_DATE_FEBRUARY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("mar")))) {
		switch (0) {
			default:
			{
				result = G_DATE_MARCH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("apr")))) {
		switch (0) {
			default:
			{
				result = G_DATE_APRIL;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("may")))) {
		switch (0) {
			default:
			{
				result = G_DATE_MAY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("jun")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JUNE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("jul")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JULY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("aug")))) {
		switch (0) {
			default:
			{
				result = G_DATE_AUGUST;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("sep")))) {
		switch (0) {
			default:
			{
				result = G_DATE_SEPTEMBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("oct")))) {
		switch (0) {
			default:
			{
				result = G_DATE_OCTOBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("nov")))) {
		switch (0) {
			default:
			{
				result = G_DATE_NOVEMBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("dec")))) {
		switch (0) {
			default:
			{
				result = G_DATE_DECEMBER;
				return result;
			}
		}
	}
	result = G_DATE_BAD_MONTH;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GDateTime*
avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self)
{
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	GDateTime* timestamp = NULL;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = avi_chunk_new (_tmp0_);
	chunk = _tmp1_;
	timestamp = NULL;
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gchar* sdate = NULL;
		AVIChunk* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = chunk;
		avi_chunk_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = chunk;
		avi_chunk_nonsection_skip (_tmp3_, (guint64) 12, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = chunk;
		_tmp5_ = avi_metadata_loader_read_section (self, _tmp4_, &_inner_error0_);
		sdate = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = sdate;
		if (NULL != _tmp6_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GDateTime* _tmp10_;
			_tmp7_ = sdate;
			_tmp8_ = string_strip (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = avi_metadata_loader_parse_date (self, _tmp9_);
			_g_date_time_unref0 (timestamp);
			timestamp = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_g_free0 (sdate);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("AVIMetadataLoader.vala:217: Error while reading AVI file: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (timestamp);
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		AVIChunk* _tmp13_;
		_tmp13_ = chunk;
		avi_chunk_close_file (_tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_debug ("AVIMetadataLoader.vala:223: Error while closing AVI file: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (timestamp);
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = timestamp;
	_avi_chunk_unref0 (chunk);
	return result;
}

static void
value_avi_metadata_loader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_avi_metadata_loader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		avi_metadata_loader_unref (value->data[0].v_pointer);
	}
}

static void
value_avi_metadata_loader_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = avi_metadata_loader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_avi_metadata_loader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_avi_metadata_loader_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AVIMetadataLoader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = avi_metadata_loader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_avi_metadata_loader_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	AVIMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = avi_metadata_loader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_avi_metadata_loader (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecAVIMetadataLoader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_METADATA_LOADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_avi_metadata_loader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_avi_metadata_loader (GValue* value,
                               gpointer v_object)
{
	AVIMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		avi_metadata_loader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_metadata_loader_unref (old);
	}
}

void
value_take_avi_metadata_loader (GValue* value,
                                gpointer v_object)
{
	AVIMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_metadata_loader_unref (old);
	}
}

static void
avi_metadata_loader_class_init (AVIMetadataLoaderClass * klass,
                                gpointer klass_data)
{
	avi_metadata_loader_parent_class = g_type_class_peek_parent (klass);
	((AVIMetadataLoaderClass *) klass)->finalize = avi_metadata_loader_finalize;
	g_type_class_adjust_private_offset (klass, &AVIMetadataLoader_private_offset);
}

static void
avi_metadata_loader_instance_init (AVIMetadataLoader * self,
                                   gpointer klass)
{
	self->priv = avi_metadata_loader_get_instance_private (self);
	self->priv->file = NULL;
	self->ref_count = 1;
}

static void
avi_metadata_loader_finalize (AVIMetadataLoader * obj)
{
	AVIMetadataLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_METADATA_LOADER, AVIMetadataLoader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
}

static GType
avi_metadata_loader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_avi_metadata_loader_init, value_avi_metadata_loader_free_value, value_avi_metadata_loader_copy_value, value_avi_metadata_loader_peek_pointer, "p", value_avi_metadata_loader_collect_value, "p", value_avi_metadata_loader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AVIMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIMetadataLoader), 0, (GInstanceInitFunc) avi_metadata_loader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType avi_metadata_loader_type_id;
	avi_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AVIMetadataLoader_private_offset = g_type_add_instance_private (avi_metadata_loader_type_id, sizeof (AVIMetadataLoaderPrivate));
	return avi_metadata_loader_type_id;
}

GType
avi_metadata_loader_get_type (void)
{
	static volatile gsize avi_metadata_loader_type_id__once = 0;
	if (g_once_init_enter (&avi_metadata_loader_type_id__once)) {
		GType avi_metadata_loader_type_id;
		avi_metadata_loader_type_id = avi_metadata_loader_get_type_once ();
		g_once_init_leave (&avi_metadata_loader_type_id__once, avi_metadata_loader_type_id);
	}
	return avi_metadata_loader_type_id__once;
}

gpointer
avi_metadata_loader_ref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
avi_metadata_loader_unref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AVI_METADATA_LOADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

