/* AVIChunk.c generated by valac 0.56.17, the Vala compiler
 * generated from AVIChunk.vala, do not modify */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-internal-video-metadata-handling.h"
#include <gobject/gvaluecollector.h>

#define AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH 1024
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_AVI_CHUNK (avi_chunk_get_type ())
#define AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_CHUNK, AVIChunk))
#define AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_CHUNK, AVIChunkClass))
#define IS_AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_CHUNK))
#define IS_AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_CHUNK))
#define AVI_CHUNK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_CHUNK, AVIChunkClass))

typedef struct _AVIChunk AVIChunk;
typedef struct _AVIChunkClass AVIChunkClass;
typedef struct _AVIChunkPrivate AVIChunkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _avi_chunk_unref0(var) ((var == NULL) ? NULL : (var = (avi_chunk_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecAVIChunk ParamSpecAVIChunk;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AVIChunk {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIChunkPrivate * priv;
};

struct _AVIChunkClass {
	GTypeClass parent_class;
	void (*finalize) (AVIChunk *self);
};

struct _AVIChunkPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	AVIChunk* parent;
};

struct _ParamSpecAVIChunk {
	GParamSpec parent_instance;
};

static gint AVIChunk_private_offset;
static gpointer avi_chunk_parent_class = NULL;

VALA_EXTERN gpointer avi_chunk_ref (gpointer instance);
VALA_EXTERN void avi_chunk_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_avi_chunk (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_avi_chunk (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_avi_chunk (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_avi_chunk (const GValue* value);
VALA_EXTERN GType avi_chunk_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AVIChunk* avi_chunk_new (GFile* file);
VALA_EXTERN AVIChunk* avi_chunk_construct (GType object_type,
                               GFile* file);
static AVIChunk* avi_chunk_new_with_input_stream (GDataInputStream* input,
                                           AVIChunk* parent);
static AVIChunk* avi_chunk_construct_with_input_stream (GType object_type,
                                                 GDataInputStream* input,
                                                 AVIChunk* parent);
VALA_EXTERN void avi_chunk_open_file (AVIChunk* self,
                          GError** error);
VALA_EXTERN void avi_chunk_close_file (AVIChunk* self,
                           GError** error);
VALA_EXTERN void avi_chunk_nonsection_skip (AVIChunk* self,
                                guint64 skip_amount,
                                GError** error);
VALA_EXTERN void avi_chunk_skip (AVIChunk* self,
                     guint64 skip_amount,
                     GError** error);
static void avi_chunk_advance_section_offset (AVIChunk* self,
                                       guint64 amount);
VALA_EXTERN AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self);
VALA_EXTERN guchar avi_chunk_read_byte (AVIChunk* self,
                            GError** error);
VALA_EXTERN guint16 avi_chunk_read_uint16 (AVIChunk* self,
                               GError** error);
VALA_EXTERN void avi_chunk_read_chunk (AVIChunk* self,
                           GError** error);
VALA_EXTERN gchar* avi_chunk_read_name (AVIChunk* self,
                            GError** error);
VALA_EXTERN void avi_chunk_next_chunk (AVIChunk* self,
                           GError** error);
VALA_EXTERN guint64 avi_chunk_section_size_remaining (AVIChunk* self);
VALA_EXTERN gchar* avi_chunk_get_current_chunk_name (AVIChunk* self);
VALA_EXTERN gboolean avi_chunk_is_last_chunk (AVIChunk* self);
VALA_EXTERN gchar* avi_chunk_section_to_string (AVIChunk* self,
                                    GError** error);
static void avi_chunk_finalize (AVIChunk * obj);
static GType avi_chunk_get_type_once (void);

static inline gpointer
avi_chunk_get_instance_private (AVIChunk* self)
{
	return G_STRUCT_MEMBER_P (self, AVIChunk_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AVIChunk*
avi_chunk_construct (GType object_type,
                     GFile* file)
{
	AVIChunk* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (AVIChunk*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

AVIChunk*
avi_chunk_new (GFile* file)
{
	return avi_chunk_construct (TYPE_AVI_CHUNK, file);
}

static gpointer
_avi_chunk_ref0 (gpointer self)
{
	return self ? avi_chunk_ref (self) : NULL;
}

static AVIChunk*
avi_chunk_construct_with_input_stream (GType object_type,
                                       GDataInputStream* input,
                                       AVIChunk* parent)
{
	AVIChunk* self = NULL;
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (input, g_data_input_stream_get_type ()), NULL);
	g_return_val_if_fail (IS_AVI_CHUNK (parent), NULL);
	self = (AVIChunk*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (input);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = _avi_chunk_ref0 (parent);
	_avi_chunk_unref0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}

static AVIChunk*
avi_chunk_new_with_input_stream (GDataInputStream* input,
                                 AVIChunk* parent)
{
	return avi_chunk_construct_with_input_stream (TYPE_AVI_CHUNK, input, parent);
}

void
avi_chunk_open_file (AVIChunk* self,
                     GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	avi_chunk_close_file (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp3_;
	_tmp4_ = self->priv->input;
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp5_;
	_g_object_unref0 (_tmp0_);
}

void
avi_chunk_close_file (AVIChunk* self,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	_tmp0_ = self->priv->input;
	if (NULL != _tmp0_) {
		GDataInputStream* _tmp1_;
		_tmp1_ = self->priv->input;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->input);
		self->priv->input = NULL;
	}
}

void
avi_chunk_nonsection_skip (AVIChunk* self,
                           guint64 skip_amount,
                           GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	_tmp0_ = self->priv->input;
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
avi_chunk_skip (AVIChunk* self,
                guint64 skip_amount,
                GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	avi_chunk_advance_section_offset (self, skip_amount);
	_tmp0_ = self->priv->input;
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

AVIChunk*
avi_chunk_get_first_child_chunk (AVIChunk* self)
{
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
	AVIChunk* result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
	_tmp0_ = self->priv->input;
	_tmp1_ = avi_chunk_new_with_input_stream (_tmp0_, self);
	result = _tmp1_;
	return result;
}

static void
avi_chunk_advance_section_offset (AVIChunk* self,
                                  guint64 amount)
{
	AVIChunk* _tmp0_;
	g_return_if_fail (IS_AVI_CHUNK (self));
	if ((self->priv->section_offset + amount) > self->priv->section_size) {
		amount = self->priv->section_size - self->priv->section_offset;
	}
	self->priv->section_offset = self->priv->section_offset + amount;
	_tmp0_ = self->priv->parent;
	if (NULL != _tmp0_) {
		AVIChunk* _tmp1_;
		_tmp1_ = self->priv->parent;
		avi_chunk_advance_section_offset (_tmp1_, amount);
	}
}

guchar
avi_chunk_read_byte (AVIChunk* self,
                     GError** error)
{
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guchar result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), '\0');
	avi_chunk_advance_section_offset (self, (guint64) 1);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guchar _tmp2_ = '\0';
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = (guchar) _tmp0_;
	return result;
}

guint16
avi_chunk_read_uint16 (AVIChunk* self,
                       GError** error)
{
	guint16 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint16 result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0U);
	avi_chunk_advance_section_offset (self, (guint64) 2);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint16 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint16 _tmp2_ = 0U;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

void
avi_chunk_read_chunk (AVIChunk* self,
                      GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guint8 _tmp1_ = 0U;
	GDataInputStream* _tmp2_;
	GString* _tmp3_;
	guint8 _tmp4_ = 0U;
	GDataInputStream* _tmp5_;
	GString* _tmp6_;
	guint8 _tmp7_ = 0U;
	GDataInputStream* _tmp8_;
	GString* _tmp9_;
	guint8 _tmp10_ = 0U;
	GDataInputStream* _tmp11_;
	GString* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint32 _tmp16_ = 0U;
	GDataInputStream* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	_tmp2_ = self->priv->input;
	_tmp1_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp3_ = sb;
	g_string_append_c (_tmp3_, (gchar) _tmp1_);
	_tmp5_ = self->priv->input;
	_tmp4_ = g_data_input_stream_read_byte (_tmp5_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp6_ = sb;
	g_string_append_c (_tmp6_, (gchar) _tmp4_);
	_tmp8_ = self->priv->input;
	_tmp7_ = g_data_input_stream_read_byte (_tmp8_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp9_ = sb;
	g_string_append_c (_tmp9_, (gchar) _tmp7_);
	_tmp11_ = self->priv->input;
	_tmp10_ = g_data_input_stream_read_byte (_tmp11_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp12_ = sb;
	g_string_append_c (_tmp12_, (gchar) _tmp10_);
	_tmp13_ = sb;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp15_;
	_tmp17_ = self->priv->input;
	_tmp16_ = g_data_input_stream_read_uint32 (_tmp17_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	self->priv->section_size = (guint64) _tmp16_;
	self->priv->section_offset = (guint64) 0;
	_g_string_free0 (sb);
}

gchar*
avi_chunk_read_name (AVIChunk* self,
                     GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guchar _tmp1_ = '\0';
	GString* _tmp2_;
	guchar _tmp3_ = '\0';
	GString* _tmp4_;
	guchar _tmp5_ = '\0';
	GString* _tmp6_;
	guchar _tmp7_ = '\0';
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	_tmp1_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp2_ = sb;
	g_string_append_c (_tmp2_, (gchar) _tmp1_);
	_tmp3_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp4_ = sb;
	g_string_append_c (_tmp4_, (gchar) _tmp3_);
	_tmp5_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp6_ = sb;
	g_string_append_c (_tmp6_, (gchar) _tmp5_);
	_tmp7_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp8_ = sb;
	g_string_append_c (_tmp8_, (gchar) _tmp7_);
	_tmp9_ = sb;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (sb);
	return result;
}

void
avi_chunk_next_chunk (AVIChunk* self,
                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_AVI_CHUNK (self));
	avi_chunk_skip (self, avi_chunk_section_size_remaining (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
}

gchar*
avi_chunk_get_current_chunk_name (AVIChunk* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
	_tmp0_ = self->priv->section_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
avi_chunk_is_last_chunk (AVIChunk* self)
{
	gboolean result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), FALSE);
	result = self->priv->section_size == ((guint64) 0);
	return result;
}

guint64
avi_chunk_section_size_remaining (AVIChunk* self)
{
	guint64 result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0ULL);
	_vala_assert (self->priv->section_size >= self->priv->section_offset, "section_size >= section_offset");
	result = self->priv->section_size - self->priv->section_offset;
	return result;
}

gchar*
avi_chunk_section_to_string (AVIChunk* self,
                             GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	while (TRUE) {
		guchar _tmp1_ = '\0';
		GString* _tmp2_;
		GString* _tmp3_;
		if (!(self->priv->section_offset < self->priv->section_size)) {
			break;
		}
		_tmp1_ = avi_chunk_read_byte (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return NULL;
		}
		_tmp2_ = sb;
		g_string_append_c (_tmp2_, (gchar) _tmp1_);
		_tmp3_ = sb;
		if (_tmp3_->len > ((gssize) AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH)) {
			GString* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = sb;
			_tmp5_ = _tmp4_->str;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			_g_string_free0 (sb);
			return result;
		}
	}
	_tmp7_ = sb;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (sb);
	return result;
}

static void
value_avi_chunk_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_avi_chunk_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		avi_chunk_unref (value->data[0].v_pointer);
	}
}

static void
value_avi_chunk_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = avi_chunk_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_avi_chunk_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_avi_chunk_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AVIChunk * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = avi_chunk_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_avi_chunk_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	AVIChunk ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = avi_chunk_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_avi_chunk (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecAVIChunk* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_CHUNK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_avi_chunk (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_avi_chunk (GValue* value,
                     gpointer v_object)
{
	AVIChunk * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		avi_chunk_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_chunk_unref (old);
	}
}

void
value_take_avi_chunk (GValue* value,
                      gpointer v_object)
{
	AVIChunk * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_chunk_unref (old);
	}
}

static void
avi_chunk_class_init (AVIChunkClass * klass,
                      gpointer klass_data)
{
	avi_chunk_parent_class = g_type_class_peek_parent (klass);
	((AVIChunkClass *) klass)->finalize = avi_chunk_finalize;
	g_type_class_adjust_private_offset (klass, &AVIChunk_private_offset);
}

static void
avi_chunk_instance_init (AVIChunk * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = avi_chunk_get_instance_private (self);
	self->priv->file = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->section_name = _tmp0_;
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	self->priv->input = NULL;
	self->priv->parent = NULL;
	self->ref_count = 1;
}

static void
avi_chunk_finalize (AVIChunk * obj)
{
	AVIChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_CHUNK, AVIChunk);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->section_name);
	_g_object_unref0 (self->priv->input);
	_avi_chunk_unref0 (self->priv->parent);
}

static GType
avi_chunk_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_avi_chunk_init, value_avi_chunk_free_value, value_avi_chunk_copy_value, value_avi_chunk_peek_pointer, "p", value_avi_chunk_collect_value, "p", value_avi_chunk_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AVIChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIChunk), 0, (GInstanceInitFunc) avi_chunk_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType avi_chunk_type_id;
	avi_chunk_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIChunk", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AVIChunk_private_offset = g_type_add_instance_private (avi_chunk_type_id, sizeof (AVIChunkPrivate));
	return avi_chunk_type_id;
}

GType
avi_chunk_get_type (void)
{
	static volatile gsize avi_chunk_type_id__once = 0;
	if (g_once_init_enter (&avi_chunk_type_id__once)) {
		GType avi_chunk_type_id;
		avi_chunk_type_id = avi_chunk_get_type_once ();
		g_once_init_leave (&avi_chunk_type_id__once, avi_chunk_type_id);
	}
	return avi_chunk_type_id__once;
}

gpointer
avi_chunk_ref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
avi_chunk_unref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AVI_CHUNK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

