/* VideoSourceCollection.c generated by valac 0.56.17, the Vala compiler
 * generated from VideoSourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>

#define VIDEO_TYPENAME "video"
#define VIDEO_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;
typedef struct _VideoSourceCollectionPrivate VideoSourceCollectionPrivate;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, gpointer user_data);

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _EventID {
	gint64 id;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _VideoSourceCollection {
	MediaSourceCollection parent_instance;
	VideoSourceCollectionPrivate * priv;
};

struct _VideoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
};

struct _VideoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeMultiMap* filesize_to_video;
};

struct _VideoID {
	gint64 id;
};

static gint VideoSourceCollection_private_offset;
static gpointer video_source_collection_parent_class = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType database_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType media_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN GType video_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSourceCollection, data_collection_unref)
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_trashcan (MediaSourceCollection* self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_offline_bin (MediaSourceCollection* self);
VALA_EXTERN MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self,
                                                            Workers* workers,
                                                            GCancellable* cancellable);
VALA_EXTERN gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
VALA_EXTERN gchar* media_source_collection_get_typename (MediaSourceCollection* self);
VALA_EXTERN gboolean media_source_collection_is_file_recognized (MediaSourceCollection* self,
                                                     GFile* file);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self,
                                                          gint64 numeric_id);
VALA_EXTERN GeeCollection* media_source_collection_get_event_source_ids (MediaSourceCollection* self,
                                                             EventID* event_id);
VALA_EXTERN void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
VALA_EXTERN TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
VALA_EXTERN GType video_source_collection_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint uint64_compare (guint64* a,
                     guint64* b);
static gint _uint64_compare_gcompare_data_func (gconstpointer a,
                                         gconstpointer b,
                                         gpointer self);
static guint64* _uint64_dup (guint64* self);
VALA_EXTERN VideoSourceCollection* video_source_collection_new (void);
VALA_EXTERN VideoSourceCollection* video_source_collection_construct (GType object_type);
VALA_EXTERN gint64 video_source_collection_get_video_key (DataSource* source);
static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                       gpointer self);
VALA_EXTERN MediaSourceCollection* media_source_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          GetSourceDatabaseKey source_key_func,
                                                          gpointer source_key_func_target);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                           GeeCollection* added,
                                                           GeeCollection* removed);
static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                 GeeCollection* added,
                                                                                                 GeeCollection* removed,
                                                                                                 gpointer self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                          GeeCollection* added,
                                                          GeeCollection* removed);
static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                GeeCollection* added,
                                                                                                GeeCollection* removed,
                                                                                                gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base);
VALA_EXTERN gboolean video_source_collection_is_video_trashed (DataSource* source);
static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources,
                                                       SourceHoldingTankCheckToKeep check_to_keep,
                                                       gpointer check_to_keep_target,
                                                       GetSourceDatabaseKey get_key,
                                                       gpointer get_key_target);
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type,
                                                             MediaSourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             gpointer check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             gpointer get_key_target);
static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base);
VALA_EXTERN gboolean video_source_collection_is_video_offline (DataSource* source);
static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                 Workers* workers,
                                                                 GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_new (GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
VALA_EXTERN GType video_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMonitor, g_object_unref)
static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                            DataSource* source);
static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                          GFile* file);
VALA_EXTERN gboolean video_reader_is_supported_video_file (GFile* file);
static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                               gint64 numeric_id);
VALA_EXTERN GType video_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoID* video_id_dup (const VideoID* self);
VALA_EXTERN void video_id_free (VideoID* self);
VALA_EXTERN Video* video_source_collection_fetch (VideoSourceCollection* self,
                                      VideoID* video_id);
VALA_EXTERN void video_id_init (VideoID *self,
                    gint64 id);
VALA_EXTERN void video_get_video_id (Video* self,
                         VideoID* result);
VALA_EXTERN gboolean media_source_is_trashed (MediaSource* self);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
VALA_EXTERN DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                  EventID* event_id);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType video_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoTable, database_table_unref)
VALA_EXTERN VideoTable* video_table_get_instance (void);
VALA_EXTERN GeeArrayList* video_table_get_event_source_ids (VideoTable* self,
                                                EventID* event_id);
VALA_EXTERN Video* video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                                  GFile* file,
                                                  VideoSourceCollectionState* state);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                                           GFile* file);
VALA_EXTERN MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                             GFile* file);
static void video_source_collection_compare_backing (VideoSourceCollection* self,
                                              Video* video,
                                              GFileInfo* info,
                                              GeeCollection* matching_master);
VALA_EXTERN guint64 media_source_get_filesize (MediaSource* self);
VALA_EXTERN GDateTime* media_source_get_timestamp (MediaSource* self);
VALA_EXTERN GDateTime* coarsify_date_time (GDateTime* dt);
VALA_EXTERN void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                        GFileInfo* info,
                                                        GeeCollection* matching_master);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
static void video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                           GeeIterable* added,
                                                           GeeIterable* removed);
VALA_EXTERN guint64 media_source_get_master_filesize (MediaSource* self);
VALA_EXTERN void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self,
                                                              const gchar* basename,
                                                              guint64 filesize,
                                                              VideoID* result);
VALA_EXTERN gint utf8_ci_compare (const gchar* a,
                      const gchar* b);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self,
                                                                  const gchar* basename,
                                                                  guint64 filesize);
VALA_EXTERN gboolean video_id_is_valid (VideoID *self);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type,
                                                                                 MediaSourceCollection* sources);
VALA_EXTERN GType media_source_transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceTransactionController, transaction_controller_unref)
static void video_source_collection_finalize (DataCollection * obj);
static GType video_source_collection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
video_source_collection_get_instance_private (VideoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, VideoSourceCollection_private_offset);
}

static GType
video_source_collection_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN, "VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {VIDEO_SOURCE_COLLECTION_STATE_ONLINE, "VIDEO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {VIDEO_SOURCE_COLLECTION_STATE_OFFLINE, "VIDEO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {VIDEO_SOURCE_COLLECTION_STATE_TRASH, "VIDEO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {0, NULL, NULL}};
	GType video_source_collection_state_type_id;
	video_source_collection_state_type_id = g_enum_register_static ("VideoSourceCollectionState", values);
	return video_source_collection_state_type_id;
}

GType
video_source_collection_state_get_type (void)
{
	static volatile gsize video_source_collection_state_type_id__once = 0;
	if (g_once_init_enter (&video_source_collection_state_type_id__once)) {
		GType video_source_collection_state_type_id;
		video_source_collection_state_type_id = video_source_collection_state_get_type_once ();
		g_once_init_leave (&video_source_collection_state_type_id__once, video_source_collection_state_type_id);
	}
	return video_source_collection_state_type_id__once;
}

static gint
_uint64_compare_gcompare_data_func (gconstpointer a,
                                    gconstpointer b,
                                    gpointer self)
{
	gint result;
	result = uint64_compare ((guint64*) a, (guint64*) b);
	return result;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gint64
_video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                gpointer self)
{
	gint64 result;
	result = video_source_collection_get_video_key (source);
	return result;
}

static void
_video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                            GeeCollection* added,
                                                                                            GeeCollection* removed,
                                                                                            gpointer self)
{
	video_source_collection_on_trashcan_contents_altered ((VideoSourceCollection*) self, added, removed);
}

static void
_video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                           GeeCollection* added,
                                                                                           GeeCollection* removed,
                                                                                           gpointer self)
{
	video_source_collection_on_offline_contents_altered ((VideoSourceCollection*) self, added, removed);
}

VideoSourceCollection*
video_source_collection_construct (GType object_type)
{
	VideoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = (VideoSourceCollection*) media_source_collection_construct (object_type, "VideoSourceCollection", _video_source_collection_get_video_key_get_source_database_key, NULL);
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp3_ = _tmp2_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp3_);
	return self;
}

VideoSourceCollection*
video_source_collection_new (void)
{
	return video_source_collection_construct (TYPE_VIDEO_SOURCE_COLLECTION);
}

static gboolean
_video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_trashed (source);
	return result;
}

static MediaSourceHoldingTank*
video_source_collection_real_create_trashcan (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
	result = _tmp0_;
	return result;
}

static gboolean
_video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_offline (source);
	return result;
}

static MediaSourceHoldingTank*
video_source_collection_real_create_offline_bin (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_offline_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
	result = _tmp0_;
	return result;
}

static MediaMonitor*
video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                   Workers* workers,
                                                   GCancellable* cancellable)
{
	VideoSourceCollection * self;
	VideoMonitor* _tmp0_;
	MediaMonitor* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = video_monitor_new (cancellable);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_MONITOR, MediaMonitor);
	return result;
}

static gboolean
video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                   DataSource* source)
{
	VideoSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = IS_VIDEO (source);
	return result;
}

static gchar*
video_source_collection_real_get_typename (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gboolean
video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                 GFile* file)
{
	VideoSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	result = video_reader_is_supported_video_file (file);
	return result;
}

static void
video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                      GeeCollection* added,
                                                      GeeCollection* removed)
{
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static void
video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                     GeeCollection* added,
                                                     GeeCollection* removed)
{
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static MediaSource*
video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                  gint64 numeric_id)
{
	VideoSourceCollection * self;
	VideoID _tmp0_ = {0};
	Video* _tmp1_;
	MediaSource* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	video_id_init (&_tmp0_, numeric_id);
	_tmp1_ = video_source_collection_fetch (self, &_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_SOURCE, MediaSource);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint64
video_source_collection_get_video_key (DataSource* source)
{
	Video* video = NULL;
	Video* _tmp0_;
	VideoID video_id = {0};
	VideoID _tmp1_ = {0};
	VideoID _tmp2_;
	gint64 result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video));
	video = _tmp0_;
	video_get_video_id (video, &_tmp1_);
	video_id = _tmp1_;
	_tmp2_ = video_id;
	result = _tmp2_.id;
	_g_object_unref0 (video);
	return result;
}

gboolean
video_source_collection_is_video_trashed (DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

gboolean
video_source_collection_is_video_offline (DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

Video*
video_source_collection_fetch (VideoSourceCollection* self,
                               VideoID* video_id)
{
	VideoID _tmp0_;
	DataSource* _tmp1_;
	Video* result;
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = *video_id;
	_tmp1_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_VIDEO, Video);
	return result;
}

static GeeCollection*
video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                   EventID* event_id)
{
	VideoSourceCollection * self;
	VideoTable* _tmp0_;
	VideoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = video_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = *event_id;
	_tmp3_ = video_table_get_event_source_ids (_tmp1_, &_tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	_database_table_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

Video*
video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                           GFile* file,
                                           VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	Video* video = NULL;
	MediaSource* _tmp0_;
	Video* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSource* _tmp4_;
	Video* _tmp5_;
	MediaSourceHoldingTank* _tmp6_;
	MediaSourceHoldingTank* _tmp7_;
	MediaSource* _tmp8_;
	Video* _tmp9_;
	Video* result;
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = media_source_collection_fetch_by_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), file);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video);
	_tmp1_ = video;
	if (_tmp1_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_ONLINE;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp2_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp3_ = _tmp2_;
	_tmp4_ = media_source_holding_tank_fetch_by_master_file (_tmp3_, file);
	_g_object_unref0 (video);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video);
	_source_holding_tank_unref0 (_tmp3_);
	_tmp5_ = video;
	if (_tmp5_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_TRASH;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp6_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp7_ = _tmp6_;
	_tmp8_ = media_source_holding_tank_fetch_by_master_file (_tmp7_, file);
	_g_object_unref0 (video);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video);
	_source_holding_tank_unref0 (_tmp7_);
	_tmp9_ = video;
	if (_tmp9_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_OFFLINE;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_vala_state = VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN;
	result = NULL;
	_g_object_unref0 (video);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

static void
video_source_collection_compare_backing (VideoSourceCollection* self,
                                         Video* video,
                                         GFileInfo* info,
                                         GeeCollection* matching_master)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_VIDEO (video));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matching_master, GEE_TYPE_COLLECTION));
	if (media_source_get_filesize (G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MEDIA_SOURCE, MediaSource)) != ((guint64) g_file_info_get_size (info))) {
		return;
	}
	_tmp0_ = media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_info_get_modification_date_time (info);
	_tmp3_ = _tmp2_;
	_tmp4_ = coarsify_date_time (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_equal (_tmp1_, _tmp5_);
	_g_date_time_unref0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	_g_date_time_unref0 (_tmp1_);
	if (_tmp6_) {
		gee_collection_add (matching_master, video);
	}
}

void
video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                   GFileInfo* info,
                                                   GeeCollection* matching_master)
{
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matching_master, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataObject* _tmp7_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video), info, matching_master);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp8_ = media_source_collection_get_offline_bin_contents (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_media_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			MediaSource* media = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			MediaSource* _tmp15_;
			_tmp12_ = _media_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _media_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			media = (MediaSource*) _tmp14_;
			_tmp15_ = media;
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_VIDEO, Video), info, matching_master);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
}

static void
video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                      GeeIterable* added,
                                                      GeeIterable* removed)
{
	VideoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Video* video = NULL;
				DataObject* _tmp4_;
				Video* _tmp5_;
				GeeMultiMap* _tmp6_;
				Video* _tmp7_;
				guint64 _tmp8_;
				Video* _tmp9_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video));
				video = _tmp5_;
				_tmp6_ = self->priv->filesize_to_video;
				_tmp7_ = video;
				_tmp8_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
				_tmp9_ = video;
				gee_multi_map_set (_tmp6_, &_tmp8_, _tmp9_);
				_g_object_unref0 (video);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp10_;
			_tmp10_ = gee_iterable_iterator (removed);
			_object_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				DataObject* object = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				Video* video = NULL;
				DataObject* _tmp14_;
				Video* _tmp15_;
				GeeMultiMap* _tmp16_;
				Video* _tmp17_;
				guint64 _tmp18_;
				Video* _tmp19_;
				_tmp11_ = _object_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _object_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				object = (DataObject*) _tmp13_;
				_tmp14_ = object;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_VIDEO, Video));
				video = _tmp15_;
				_tmp16_ = self->priv->filesize_to_video;
				_tmp17_ = video;
				_tmp18_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_SOURCE, MediaSource));
				_tmp19_ = video;
				gee_multi_map_remove (_tmp16_, &_tmp18_, _tmp19_);
				_g_object_unref0 (video);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added, removed);
}

void
video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize,
                                                         VideoID* result)
{
	VideoID _tmp16_ = {0};
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
	g_return_if_fail (basename != NULL);
	{
		GeeIterator* _video_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->filesize_to_video;
		_tmp1_ = gee_multi_map_get (_tmp0_, &filesize);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_video_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			Video* video = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Video* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _video_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _video_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			video = (Video*) _tmp7_;
			_tmp8_ = video;
			_tmp9_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_get_basename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = utf8_ci_compare (_tmp12_, basename) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				Video* _tmp14_;
				VideoID _tmp15_ = {0};
				_tmp14_ = video;
				video_get_video_id (_tmp14_, &_tmp15_);
				*result = _tmp15_;
				_g_object_unref0 (video);
				_g_object_unref0 (_video_it);
				return;
			}
			_g_object_unref0 (video);
		}
		_g_object_unref0 (_video_it);
	}
	video_id_init (&_tmp16_, VIDEO_ID_INVALID);
	*result = _tmp16_;
	return;
}

gboolean
video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize)
{
	VideoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (basename != NULL, FALSE);
	video_source_collection_get_basename_filesize_duplicate (self, basename, filesize, &_tmp0_);
	result = video_id_is_valid (&_tmp0_);
	return result;
}

static TransactionController*
video_source_collection_real_get_transaction_controller (MediaSourceCollection* base)
{
	TransactionController* result;
	VideoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_tmp0_ = self->priv->_transaction_controller;
	if (_tmp0_ == NULL) {
		MediaSourceTransactionController* _tmp1_;
		_tmp1_ = media_source_transaction_controller_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_transaction_controller_unref0 (self->priv->_transaction_controller);
		self->priv->_transaction_controller = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TRANSACTION_CONTROLLER, TransactionController);
	}
	_tmp2_ = self->priv->_transaction_controller;
	result = _tmp2_;
	return result;
}

static void
video_source_collection_class_init (VideoSourceCollectionClass * klass,
                                    gpointer klass_data)
{
	video_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = video_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &VideoSourceCollection_private_offset);
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) video_source_collection_real_create_trashcan;
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) video_source_collection_real_create_offline_bin;
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection*, Workers*, GCancellable*)) video_source_collection_real_create_media_monitor;
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) video_source_collection_real_holds_type_of_source;
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection*)) video_source_collection_real_get_typename;
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection*, GFile*)) video_source_collection_real_is_file_recognized;
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection*, gint64)) video_source_collection_real_fetch_by_numeric_id;
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection*, EventID*)) video_source_collection_real_get_event_source_ids;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) video_source_collection_real_notify_contents_altered;
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = (TransactionController* (*) (MediaSourceCollection*)) video_source_collection_real_get_transaction_controller;
}

static void
video_source_collection_instance_init (VideoSourceCollection * self,
                                       gpointer klass)
{
	GeeTreeMultiMap* _tmp0_;
	self->priv = video_source_collection_get_instance_private (self);
	self->priv->_transaction_controller = NULL;
	_tmp0_ = gee_tree_multi_map_new (G_TYPE_UINT64, (GBoxedCopyFunc) _uint64_dup, (GDestroyNotify) g_free, TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _uint64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->filesize_to_video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
}

static void
video_source_collection_finalize (DataCollection * obj)
{
	VideoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_transaction_controller_unref0 (self->priv->_transaction_controller);
	_g_object_unref0 (self->priv->filesize_to_video);
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->finalize (obj);
}

static GType
video_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSourceCollection), 0, (GInstanceInitFunc) video_source_collection_instance_init, NULL };
	GType video_source_collection_type_id;
	video_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "VideoSourceCollection", &g_define_type_info, 0);
	VideoSourceCollection_private_offset = g_type_add_instance_private (video_source_collection_type_id, sizeof (VideoSourceCollectionPrivate));
	return video_source_collection_type_id;
}

GType
video_source_collection_get_type (void)
{
	static volatile gsize video_source_collection_type_id__once = 0;
	if (g_once_init_enter (&video_source_collection_type_id__once)) {
		GType video_source_collection_type_id;
		video_source_collection_type_id = video_source_collection_get_type_once ();
		g_once_init_leave (&video_source_collection_type_id__once, video_source_collection_type_id);
	}
	return video_source_collection_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

