/* VideoMetadata.c generated by valac 0.56.17, the Vala compiler
 * generated from VideoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "metadata.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "shotwell-internal-video-metadata-handling.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
typedef struct _VideoMetadataPrivate VideoMetadataPrivate;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _quick_time_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_metadata_loader_unref (var), NULL)))
#define _avi_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (avi_metadata_loader_unref (var), NULL)))

struct _VideoMetadata {
	MediaMetadata parent_instance;
	VideoMetadataPrivate * priv;
};

struct _VideoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _VideoMetadataPrivate {
	MetadataDateTime* timestamp;
	gchar* title;
	gchar* comment;
};

static gint VideoMetadata_private_offset;
static gpointer video_metadata_parent_class = NULL;

VALA_EXTERN GType video_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMetadata, media_metadata_unref)
VALA_EXTERN VideoMetadata* video_metadata_new (void);
VALA_EXTERN VideoMetadata* video_metadata_construct (GType object_type);
static void video_metadata_real_read_from_file (MediaMetadata* base,
                                         GFile* file,
                                         GError** error);
static MetadataDateTime* video_metadata_real_get_creation_date_time (MediaMetadata* base);
static gchar* video_metadata_real_get_title (MediaMetadata* base);
static gchar* video_metadata_real_get_comment (MediaMetadata* base);
static void video_metadata_finalize (MediaMetadata * obj);
static GType video_metadata_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
video_metadata_get_instance_private (VideoMetadata* self)
{
	return G_STRUCT_MEMBER_P (self, VideoMetadata_private_offset);
}

VideoMetadata*
video_metadata_construct (GType object_type)
{
	VideoMetadata* self = NULL;
	self = (VideoMetadata*) media_metadata_construct (object_type);
	return self;
}

VideoMetadata*
video_metadata_new (void)
{
	return video_metadata_construct (TYPE_VIDEO_METADATA);
}

static void
video_metadata_real_read_from_file (MediaMetadata* base,
                                    GFile* file,
                                    GError** error)
{
	VideoMetadata * self;
	QuickTimeMetadataLoader* quicktime = NULL;
	QuickTimeMetadataLoader* _tmp0_;
	QuickTimeMetadataLoader* _tmp1_;
	AVIMetadataLoader* avi = NULL;
	AVIMetadataLoader* _tmp6_;
	AVIMetadataLoader* _tmp7_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = quick_time_metadata_loader_new (file);
	quicktime = _tmp0_;
	_tmp1_ = quicktime;
	if (quick_time_metadata_loader_is_supported (_tmp1_)) {
		QuickTimeMetadataLoader* _tmp2_;
		MetadataDateTime* _tmp3_;
		QuickTimeMetadataLoader* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = quicktime;
		_tmp3_ = quick_time_metadata_loader_get_creation_date_time (_tmp2_);
		_metadata_date_time_unref0 (self->priv->timestamp);
		self->priv->timestamp = _tmp3_;
		_tmp4_ = quicktime;
		_tmp5_ = quick_time_metadata_loader_get_title (_tmp4_);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp5_;
		_g_free0 (self->priv->comment);
		self->priv->comment = NULL;
		_quick_time_metadata_loader_unref0 (quicktime);
		return;
	}
	_tmp6_ = avi_metadata_loader_new (file);
	avi = _tmp6_;
	_tmp7_ = avi;
	if (avi_metadata_loader_is_supported (_tmp7_)) {
		AVIMetadataLoader* _tmp8_;
		MetadataDateTime* _tmp9_;
		AVIMetadataLoader* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = avi;
		_tmp9_ = avi_metadata_loader_get_creation_date_time (_tmp8_);
		_metadata_date_time_unref0 (self->priv->timestamp);
		self->priv->timestamp = _tmp9_;
		_tmp10_ = avi;
		_tmp11_ = avi_metadata_loader_get_title (_tmp10_);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp11_;
		_g_free0 (self->priv->comment);
		self->priv->comment = NULL;
		_avi_metadata_loader_unref0 (avi);
		_quick_time_metadata_loader_unref0 (quicktime);
		return;
	}
	_tmp12_ = g_file_get_path (file);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "File %s is not a supported video format", _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_inner_error0_ = _tmp15_;
	g_propagate_error (error, _inner_error0_);
	_avi_metadata_loader_unref0 (avi);
	_quick_time_metadata_loader_unref0 (quicktime);
	return;
}

static gpointer
_metadata_date_time_ref0 (gpointer self)
{
	return self ? metadata_date_time_ref (self) : NULL;
}

static MetadataDateTime*
video_metadata_real_get_creation_date_time (MediaMetadata* base)
{
	VideoMetadata * self;
	MetadataDateTime* _tmp0_;
	MetadataDateTime* _tmp1_;
	MetadataDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
video_metadata_real_get_title (MediaMetadata* base)
{
	VideoMetadata * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
	_tmp0_ = self->priv->title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
video_metadata_real_get_comment (MediaMetadata* base)
{
	VideoMetadata * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
	_tmp0_ = self->priv->comment;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
video_metadata_class_init (VideoMetadataClass * klass,
                           gpointer klass_data)
{
	video_metadata_parent_class = g_type_class_peek_parent (klass);
	((MediaMetadataClass *) klass)->finalize = video_metadata_finalize;
	g_type_class_adjust_private_offset (klass, &VideoMetadata_private_offset);
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata*, GFile*, GError**)) video_metadata_real_read_from_file;
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata*)) video_metadata_real_get_creation_date_time;
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata*)) video_metadata_real_get_title;
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata*)) video_metadata_real_get_comment;
}

static void
video_metadata_instance_init (VideoMetadata * self,
                              gpointer klass)
{
	self->priv = video_metadata_get_instance_private (self);
	self->priv->timestamp = NULL;
	self->priv->title = NULL;
	self->priv->comment = NULL;
}

static void
video_metadata_finalize (MediaMetadata * obj)
{
	VideoMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_METADATA, VideoMetadata);
	_metadata_date_time_unref0 (self->priv->timestamp);
	_g_free0 (self->priv->title);
	_g_free0 (self->priv->comment);
	MEDIA_METADATA_CLASS (video_metadata_parent_class)->finalize (obj);
}

static GType
video_metadata_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMetadata), 0, (GInstanceInitFunc) video_metadata_instance_init, NULL };
	GType video_metadata_type_id;
	video_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "VideoMetadata", &g_define_type_info, 0);
	VideoMetadata_private_offset = g_type_add_instance_private (video_metadata_type_id, sizeof (VideoMetadataPrivate));
	return video_metadata_type_id;
}

GType
video_metadata_get_type (void)
{
	static volatile gsize video_metadata_type_id__once = 0;
	if (g_once_init_enter (&video_metadata_type_id__once)) {
		GType video_metadata_type_id;
		video_metadata_type_id = video_metadata_get_type_once ();
		g_once_init_leave (&video_metadata_type_id__once, video_metadata_type_id);
	}
	return video_metadata_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

