/* ui.c generated by valac 0.56.17, the Vala compiler
 * generated from ui.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ADJUSTMENT_RELATION_BELOW,
	ADJUSTMENT_RELATION_IN_RANGE,
	ADJUSTMENT_RELATION_ABOVE
} AdjustmentRelation;

#define TYPE_ADJUSTMENT_RELATION (adjustment_relation_get_type ())
typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

#define TYPE_COMPASS_POINT (compass_point_get_type ())
typedef enum  {
	DIRECTION_FORWARD,
	DIRECTION_BACKWARD
} Direction;

#define TYPE_DIRECTION (direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN GType adjustment_relation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType compass_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SpitTransitionsDirection direction_to_transition_direction (Direction self);
VALA_EXTERN void spin_event_loop (void);
VALA_EXTERN AdjustmentRelation get_adjustment_relation (GtkAdjustment* adjustment,
                                            gint value);
VALA_EXTERN void get_adjustment_page (GtkAdjustment* hadj,
                          GtkAdjustment* vadj,
                          GdkRectangle* result);
VALA_EXTERN gboolean has_only_key_modifier (GdkModifierType field,
                                GdkModifierType mask);
VALA_EXTERN gboolean is_pointer_over (GdkWindow* window);

static GType
adjustment_relation_get_type_once (void)
{
	static const GEnumValue values[] = {{ADJUSTMENT_RELATION_BELOW, "ADJUSTMENT_RELATION_BELOW", "below"}, {ADJUSTMENT_RELATION_IN_RANGE, "ADJUSTMENT_RELATION_IN_RANGE", "in-range"}, {ADJUSTMENT_RELATION_ABOVE, "ADJUSTMENT_RELATION_ABOVE", "above"}, {0, NULL, NULL}};
	GType adjustment_relation_type_id;
	adjustment_relation_type_id = g_enum_register_static ("AdjustmentRelation", values);
	return adjustment_relation_type_id;
}

GType
adjustment_relation_get_type (void)
{
	static volatile gsize adjustment_relation_type_id__once = 0;
	if (g_once_init_enter (&adjustment_relation_type_id__once)) {
		GType adjustment_relation_type_id;
		adjustment_relation_type_id = adjustment_relation_get_type_once ();
		g_once_init_leave (&adjustment_relation_type_id__once, adjustment_relation_type_id);
	}
	return adjustment_relation_type_id__once;
}

static GType
compass_point_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPASS_POINT_NORTH, "COMPASS_POINT_NORTH", "north"}, {COMPASS_POINT_SOUTH, "COMPASS_POINT_SOUTH", "south"}, {COMPASS_POINT_EAST, "COMPASS_POINT_EAST", "east"}, {COMPASS_POINT_WEST, "COMPASS_POINT_WEST", "west"}, {0, NULL, NULL}};
	GType compass_point_type_id;
	compass_point_type_id = g_enum_register_static ("CompassPoint", values);
	return compass_point_type_id;
}

GType
compass_point_get_type (void)
{
	static volatile gsize compass_point_type_id__once = 0;
	if (g_once_init_enter (&compass_point_type_id__once)) {
		GType compass_point_type_id;
		compass_point_type_id = compass_point_get_type_once ();
		g_once_init_leave (&compass_point_type_id__once, compass_point_type_id);
	}
	return compass_point_type_id__once;
}

SpitTransitionsDirection
direction_to_transition_direction (Direction self)
{
	SpitTransitionsDirection result;
	switch (self) {
		case DIRECTION_FORWARD:
		{
			result = SPIT_TRANSITIONS_DIRECTION_FORWARD;
			return result;
		}
		case DIRECTION_BACKWARD:
		{
			result = SPIT_TRANSITIONS_DIRECTION_BACKWARD;
			return result;
		}
		default:
		{
			GEnumValue* _tmp0_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (TYPE_DIRECTION), self);
			g_error ("ui.vala:33: Unknown Direction %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
		}
	}
}

static GType
direction_get_type_once (void)
{
	static const GEnumValue values[] = {{DIRECTION_FORWARD, "DIRECTION_FORWARD", "forward"}, {DIRECTION_BACKWARD, "DIRECTION_BACKWARD", "backward"}, {0, NULL, NULL}};
	GType direction_type_id;
	direction_type_id = g_enum_register_static ("Direction", values);
	return direction_type_id;
}

GType
direction_get_type (void)
{
	static volatile gsize direction_type_id__once = 0;
	if (g_once_init_enter (&direction_type_id__once)) {
		GType direction_type_id;
		direction_type_id = direction_get_type_once ();
		g_once_init_leave (&direction_type_id__once, direction_type_id);
	}
	return direction_type_id__once;
}

void
spin_event_loop (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}

AdjustmentRelation
get_adjustment_relation (GtkAdjustment* adjustment,
                         gint value)
{
	AdjustmentRelation result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (adjustment, gtk_adjustment_get_type ()), 0);
	if (value < ((gint) gtk_adjustment_get_value (adjustment))) {
		result = ADJUSTMENT_RELATION_BELOW;
		return result;
	} else {
		if (value > ((gint) (gtk_adjustment_get_value (adjustment) + gtk_adjustment_get_page_size (adjustment)))) {
			result = ADJUSTMENT_RELATION_ABOVE;
			return result;
		} else {
			result = ADJUSTMENT_RELATION_IN_RANGE;
			return result;
		}
	}
}

void
get_adjustment_page (GtkAdjustment* hadj,
                     GtkAdjustment* vadj,
                     GdkRectangle* result)
{
	GdkRectangle rect = {0};
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hadj, gtk_adjustment_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (vadj, gtk_adjustment_get_type ()));
	memset (&rect, 0, sizeof (GdkRectangle));
	rect.x = (gint) gtk_adjustment_get_value (hadj);
	rect.y = (gint) gtk_adjustment_get_value (vadj);
	rect.width = (gint) gtk_adjustment_get_page_size (hadj);
	rect.height = (gint) gtk_adjustment_get_page_size (vadj);
	*result = rect;
	return;
}

gboolean
has_only_key_modifier (GdkModifierType field,
                       GdkModifierType mask)
{
	gboolean result;
	result = (field & ((((((((GDK_SHIFT_MASK | GDK_CONTROL_MASK) | GDK_MOD1_MASK) | GDK_MOD3_MASK) | GDK_MOD4_MASK) | GDK_MOD5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK)) == mask;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
is_pointer_over (GdkWindow* window)
{
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	gint x = 0;
	gint y = 0;
	GdkSeat* _tmp4_;
	GdkDevice* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (window, gdk_window_get_type ()), FALSE);
	_tmp0_ = gdk_window_get_display (window);
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = seat;
	if (_tmp3_ == NULL) {
		g_debug ("ui.vala:92: No seat for display");
		result = FALSE;
		_g_object_unref0 (seat);
		return result;
	}
	_tmp4_ = seat;
	_tmp5_ = gdk_seat_get_pointer (_tmp4_);
	gdk_device_get_position (_tmp5_, NULL, &_tmp6_, &_tmp7_);
	x = _tmp6_;
	y = _tmp7_;
	if (x >= 0) {
		_tmp10_ = y >= 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = x < gdk_window_get_width (window);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = y < gdk_window_get_height (window);
	} else {
		_tmp8_ = FALSE;
	}
	result = _tmp8_;
	_g_object_unref0 (seat);
	return result;
}

