/* Workers.c generated by valac 0.56.17, the Vala compiler
 * generated from Workers.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define WORKERS_UNLIMITED_THREADS -1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef struct _SortedListPrivate SortedListPrivate;

#define TYPE_BACKGROUND_JOB_BATCH (background_job_batch_get_type ())
#define BACKGROUND_JOB_BATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatch))
#define BACKGROUND_JOB_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatchClass))
#define IS_BACKGROUND_JOB_BATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB_BATCH))
#define IS_BACKGROUND_JOB_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB_BATCH))
#define BACKGROUND_JOB_BATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatchClass))

typedef struct _BackgroundJobBatch BackgroundJobBatch;
typedef struct _BackgroundJobBatchClass BackgroundJobBatchClass;
typedef struct _BackgroundJobBatchPrivate BackgroundJobBatchPrivate;
enum  {
	BACKGROUND_JOB_BATCH_0_PROPERTY,
	BACKGROUND_JOB_BATCH_NUM_PROPERTIES
};
static GParamSpec* background_job_batch_properties[BACKGROUND_JOB_BATCH_NUM_PROPERTIES];
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
typedef struct _WorkersPrivate WorkersPrivate;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_EVENT_SEMAPHORE (event_semaphore_get_type ())
#define EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphore))
#define EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))
#define IS_EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SEMAPHORE))
#define IS_EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SEMAPHORE))
#define EVENT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))

typedef struct _EventSemaphore EventSemaphore;
typedef struct _EventSemaphoreClass EventSemaphoreClass;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecWorkers ParamSpecWorkers;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SortedList {
	GObject parent_instance;
	SortedListPrivate * priv;
};

struct _SortedListClass {
	GObjectClass parent_class;
};

struct _BackgroundJobBatch {
	SortedList parent_instance;
	BackgroundJobBatchPrivate * priv;
};

struct _BackgroundJobBatchClass {
	SortedListClass parent_class;
};

struct _Workers {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WorkersPrivate * priv;
};

struct _WorkersClass {
	GTypeClass parent_class;
	void (*finalize) (Workers *self);
};

struct _WorkersPrivate {
	GThreadPool* thread_pool;
	GAsyncQueue* queue;
	EventSemaphore* empty_event;
};

struct _ParamSpecWorkers {
	GParamSpec parent_instance;
};

static gpointer background_job_batch_parent_class = NULL;
static gint Workers_private_offset;
static gpointer workers_parent_class = NULL;

VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
VALA_EXTERN GType background_job_batch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJobBatch, g_object_unref)
VALA_EXTERN BackgroundJobBatch* background_job_batch_new (void);
VALA_EXTERN BackgroundJobBatch* background_job_batch_construct (GType object_type);
VALA_EXTERN gint64 background_job_priority_comparator (void* a,
                                           void* b);
static gint64 _background_job_priority_comparator_comparator (void* a,
                                                       void* b,
                                                       gpointer self);
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
static GType background_job_batch_get_type_once (void);
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN GType event_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSemaphore, abstract_semaphore_unref)
static void _background_job_unref0_ (gpointer var);
VALA_EXTERN EventSemaphore* event_semaphore_new (void);
VALA_EXTERN EventSemaphore* event_semaphore_construct (GType object_type);
VALA_EXTERN Workers* workers_new (guint max_threads,
                      gboolean exclusive);
VALA_EXTERN Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
VALA_EXTERN void abstract_semaphore_notify (AbstractSemaphore* self);
static void workers_thread_start (Workers* self,
                           void* ignored);
static void _workers_thread_start_gfunc (gpointer data,
                                  gpointer self);
VALA_EXTERN guint workers_threads_per_cpu (gint per,
                               gint max);
VALA_EXTERN guint workers_thread_per_cpu_minus_one (void);
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
VALA_EXTERN gboolean abstract_semaphore_reset (AbstractSemaphore* self);
VALA_EXTERN gint background_job_priority_compare_func (BackgroundJob* a,
                                           BackgroundJob* b);
static gint _background_job_priority_compare_func_gcompare_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self);
VALA_EXTERN void workers_enqueue_many (Workers* self,
                           BackgroundJobBatch* batch);
VALA_EXTERN void workers_wait_for_empty_queue (Workers* self);
VALA_EXTERN void abstract_semaphore_wait (AbstractSemaphore* self);
VALA_EXTERN gint workers_get_pending_job_count (Workers* self);
VALA_EXTERN gboolean background_job_is_cancelled (BackgroundJob* self);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
VALA_EXTERN void background_job_internal_notify_completion (BackgroundJob* self);
static void workers_finalize (Workers * obj);
static GType workers_get_type_once (void);

static gint64
_background_job_priority_comparator_comparator (void* a,
                                                void* b,
                                                gpointer self)
{
	gint64 result;
	result = background_job_priority_comparator (a, b);
	return result;
}

BackgroundJobBatch*
background_job_batch_construct (GType object_type)
{
	BackgroundJobBatch * self = NULL;
	self = (BackgroundJobBatch*) sorted_list_construct (object_type, TYPE_BACKGROUND_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, _background_job_priority_comparator_comparator, NULL);
	return self;
}

BackgroundJobBatch*
background_job_batch_new (void)
{
	return background_job_batch_construct (TYPE_BACKGROUND_JOB_BATCH);
}

static void
background_job_batch_class_init (BackgroundJobBatchClass * klass,
                                 gpointer klass_data)
{
	background_job_batch_parent_class = g_type_class_peek_parent (klass);
}

static void
background_job_batch_instance_init (BackgroundJobBatch * self,
                                    gpointer klass)
{
}

static GType
background_job_batch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobBatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_batch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJobBatch), 0, (GInstanceInitFunc) background_job_batch_instance_init, NULL };
	GType background_job_batch_type_id;
	background_job_batch_type_id = g_type_register_static (TYPE_SORTED_LIST, "BackgroundJobBatch", &g_define_type_info, 0);
	return background_job_batch_type_id;
}

GType
background_job_batch_get_type (void)
{
	static volatile gsize background_job_batch_type_id__once = 0;
	if (g_once_init_enter (&background_job_batch_type_id__once)) {
		GType background_job_batch_type_id;
		background_job_batch_type_id = background_job_batch_get_type_once ();
		g_once_init_leave (&background_job_batch_type_id__once, background_job_batch_type_id);
	}
	return background_job_batch_type_id__once;
}

static inline gpointer
workers_get_instance_private (Workers* self)
{
	return G_STRUCT_MEMBER_P (self, Workers_private_offset);
}

static void
_background_job_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (background_job_unref (var), NULL));
}

static void
_workers_thread_start_gfunc (gpointer data,
                             gpointer self)
{
	workers_thread_start ((Workers*) self, data);
}

Workers*
workers_construct (GType object_type,
                   guint max_threads,
                   gboolean exclusive)
{
	Workers* self = NULL;
	gboolean _tmp0_ = FALSE;
	EventSemaphore* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (Workers*) g_type_create_instance (object_type);
	if (max_threads <= ((guint) 0)) {
		_tmp0_ = max_threads != ((guint) WORKERS_UNLIMITED_THREADS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		max_threads = (guint) 1;
	}
	_tmp1_ = self->priv->empty_event;
	abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
	{
		GThreadPool* _tmp2_ = NULL;
		GThreadPool* _tmp3_;
		GThreadPool* _tmp4_;
		_tmp3_ = g_thread_pool_new (_workers_thread_start_gfunc, self, (gint) max_threads, exclusive, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_thread_pool_free0 (self->priv->thread_pool);
		self->priv->thread_pool = _tmp4_;
		_g_thread_pool_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* err = NULL;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err->message;
		g_error ("Workers.vala:32: Unable to create thread pool: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

Workers*
workers_new (guint max_threads,
             gboolean exclusive)
{
	return workers_construct (TYPE_WORKERS, max_threads, exclusive);
}

guint
workers_threads_per_cpu (gint per,
                         gint max)
{
	guint count = 0U;
	guint _tmp0_ = 0U;
	guint result;
	_vala_return_val_if_fail (per > 0, "per > 0", 0U);
	count = g_get_num_processors () * per;
	if (max < 0) {
		_tmp0_ = count;
	} else {
		_tmp0_ = CLAMP (count, (guint) 0, (guint) max);
	}
	result = _tmp0_;
	_vala_warn_if_fail (result > ((guint) 0), "result > 0");
	return result;
}

guint
workers_thread_per_cpu_minus_one (void)
{
	guint result;
	result = CLAMP (g_get_num_processors () - 1, (guint) 1, (guint) G_MAXINT);
	_vala_warn_if_fail (result > ((guint) 0), "result > 0");
	return result;
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static gint
_background_job_priority_compare_func_gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self)
{
	gint result;
	result = background_job_priority_compare_func ((BackgroundJob*) a, (BackgroundJob*) b);
	return result;
}

void
workers_enqueue (Workers* self,
                 BackgroundJob* job)
{
	EventSemaphore* _tmp0_;
	GAsyncQueue* _tmp1_;
	BackgroundJob* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_WORKERS (self));
	g_return_if_fail (IS_BACKGROUND_JOB (job));
	_tmp0_ = self->priv->empty_event;
	abstract_semaphore_reset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
	_tmp1_ = self->priv->queue;
	_tmp2_ = _background_job_ref0 (job);
	g_async_queue_push_sorted (_tmp1_, _tmp2_, _background_job_priority_compare_func_gcompare_data_func, NULL);
	{
		GThreadPool* _tmp3_;
		_tmp3_ = self->priv->thread_pool;
		g_thread_pool_push (_tmp3_, job, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("Workers.vala:60: Unable to create worker thread: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
workers_enqueue_many (Workers* self,
                      BackgroundJobBatch* batch)
{
	g_return_if_fail (IS_WORKERS (self));
	g_return_if_fail (IS_BACKGROUND_JOB_BATCH (batch));
	{
		GeeIterator* _job_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (batch, GEE_TYPE_ITERABLE, GeeIterable));
		_job_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			BackgroundJob* job = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			BackgroundJob* _tmp4_;
			_tmp1_ = _job_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _job_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			job = (BackgroundJob*) _tmp3_;
			_tmp4_ = job;
			workers_enqueue (self, _tmp4_);
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
}

void
workers_wait_for_empty_queue (Workers* self)
{
	EventSemaphore* _tmp0_;
	g_return_if_fail (IS_WORKERS (self));
	_tmp0_ = self->priv->empty_event;
	abstract_semaphore_wait (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
}

gint
workers_get_pending_job_count (Workers* self)
{
	GAsyncQueue* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_WORKERS (self), 0);
	_tmp0_ = self->priv->queue;
	result = g_async_queue_length (_tmp0_);
	return result;
}

static void
workers_thread_start (Workers* self,
                      void* ignored)
{
	BackgroundJob* job = NULL;
	gboolean empty = FALSE;
	GAsyncQueue* _tmp0_;
	GAsyncQueue* _tmp1_;
	gpointer _tmp2_;
	BackgroundJob* _tmp3_;
	GAsyncQueue* _tmp4_;
	GAsyncQueue* _tmp5_;
	BackgroundJob* _tmp6_;
	BackgroundJob* _tmp8_;
	g_return_if_fail (IS_WORKERS (self));
	_tmp0_ = self->priv->queue;
	g_async_queue_lock (_tmp0_);
	_tmp1_ = self->priv->queue;
	_tmp2_ = g_async_queue_try_pop_unlocked (_tmp1_);
	_background_job_unref0 (job);
	job = (BackgroundJob*) _tmp2_;
	_tmp3_ = job;
	_vala_assert (_tmp3_ != NULL, "job != null");
	_tmp4_ = self->priv->queue;
	empty = g_async_queue_length_unlocked (_tmp4_) == 0;
	_tmp5_ = self->priv->queue;
	g_async_queue_unlock (_tmp5_);
	_tmp6_ = job;
	if (!background_job_is_cancelled (_tmp6_)) {
		BackgroundJob* _tmp7_;
		_tmp7_ = job;
		background_job_execute (_tmp7_);
	}
	_tmp8_ = job;
	background_job_internal_notify_completion (_tmp8_);
	if (empty) {
		EventSemaphore* _tmp9_;
		_tmp9_ = self->priv->empty_event;
		abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
	}
	_background_job_unref0 (job);
}

static void
value_workers_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_workers_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		workers_unref (value->data[0].v_pointer);
	}
}

static void
value_workers_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = workers_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_workers_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_workers_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Workers * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = workers_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_workers_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Workers ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = workers_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_workers (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecWorkers* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WORKERS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_workers (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_workers (GValue* value,
                   gpointer v_object)
{
	Workers * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WORKERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		workers_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		workers_unref (old);
	}
}

void
value_take_workers (GValue* value,
                    gpointer v_object)
{
	Workers * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WORKERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		workers_unref (old);
	}
}

static void
workers_class_init (WorkersClass * klass,
                    gpointer klass_data)
{
	workers_parent_class = g_type_class_peek_parent (klass);
	((WorkersClass *) klass)->finalize = workers_finalize;
	g_type_class_adjust_private_offset (klass, &Workers_private_offset);
}

static void
workers_instance_init (Workers * self,
                       gpointer klass)
{
	GAsyncQueue* _tmp0_;
	EventSemaphore* _tmp1_;
	self->priv = workers_get_instance_private (self);
	_tmp0_ = g_async_queue_new_full (_background_job_unref0_);
	self->priv->queue = _tmp0_;
	_tmp1_ = event_semaphore_new ();
	self->priv->empty_event = _tmp1_;
	self->ref_count = 1;
}

static void
workers_finalize (Workers * obj)
{
	Workers * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORKERS, Workers);
	g_signal_handlers_destroy (self);
	_g_thread_pool_free0 (self->priv->thread_pool);
	_g_async_queue_unref0 (self->priv->queue);
	_abstract_semaphore_unref0 (self->priv->empty_event);
}

static GType
workers_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_workers_init, value_workers_free_value, value_workers_copy_value, value_workers_peek_pointer, "p", value_workers_collect_value, "p", value_workers_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (WorkersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Workers), 0, (GInstanceInitFunc) workers_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType workers_type_id;
	workers_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Workers", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Workers_private_offset = g_type_add_instance_private (workers_type_id, sizeof (WorkersPrivate));
	return workers_type_id;
}

GType
workers_get_type (void)
{
	static volatile gsize workers_type_id__once = 0;
	if (g_once_init_enter (&workers_type_id__once)) {
		GType workers_type_id;
		workers_type_id = workers_get_type_once ();
		g_once_init_leave (&workers_type_id__once, workers_type_id);
	}
	return workers_type_id__once;
}

gpointer
workers_ref (gpointer instance)
{
	Workers * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
workers_unref (gpointer instance)
{
	Workers * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		WORKERS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

