/* Semaphore.c generated by valac 0.56.17, the Vala compiler
 * generated from Semaphore.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Semaphores may be used to be notified when a job is completed.  This provides an alternate*/
/* mechanism (essentially, a blocking mechanism) to the system of callbacks that BackgroundJob*/
/* offers.  They can also be used for other job-dependent notification mechanisms.*/

#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
typedef struct _AbstractSemaphorePrivate AbstractSemaphorePrivate;
typedef enum  {
	ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE,
	ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL
} AbstractSemaphoreNotifyAction;

#define ABSTRACT_SEMAPHORE_TYPE_NOTIFY_ACTION (abstract_semaphore_notify_action_get_type ())
typedef enum  {
	ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP,
	ABSTRACT_SEMAPHORE_WAIT_ACTION_READY
} AbstractSemaphoreWaitAction;

#define ABSTRACT_SEMAPHORE_TYPE_WAIT_ACTION (abstract_semaphore_wait_action_get_type ())
typedef enum  {
	ABSTRACT_SEMAPHORE_TYPE_SERIAL,
	ABSTRACT_SEMAPHORE_TYPE_BROADCAST
} AbstractSemaphoreType;

#define ABSTRACT_SEMAPHORE_TYPE_TYPE (abstract_semaphore_type_get_type ())
typedef struct _ParamSpecAbstractSemaphore ParamSpecAbstractSemaphore;

#define TYPE_SEMAPHORE (semaphore_get_type ())
#define SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEMAPHORE, Semaphore))
#define SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEMAPHORE, SemaphoreClass))
#define IS_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEMAPHORE))
#define IS_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEMAPHORE))
#define SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEMAPHORE, SemaphoreClass))

typedef struct _Semaphore Semaphore;
typedef struct _SemaphoreClass SemaphoreClass;
typedef struct _SemaphorePrivate SemaphorePrivate;

#define TYPE_COUNTDOWN_SEMAPHORE (countdown_semaphore_get_type ())
#define COUNTDOWN_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore))
#define COUNTDOWN_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphoreClass))
#define IS_COUNTDOWN_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COUNTDOWN_SEMAPHORE))
#define IS_COUNTDOWN_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COUNTDOWN_SEMAPHORE))
#define COUNTDOWN_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphoreClass))

typedef struct _CountdownSemaphore CountdownSemaphore;
typedef struct _CountdownSemaphoreClass CountdownSemaphoreClass;
typedef struct _CountdownSemaphorePrivate CountdownSemaphorePrivate;

#define TYPE_EVENT_SEMAPHORE (event_semaphore_get_type ())
#define EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphore))
#define EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))
#define IS_EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SEMAPHORE))
#define IS_EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SEMAPHORE))
#define EVENT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))

typedef struct _EventSemaphore EventSemaphore;
typedef struct _EventSemaphoreClass EventSemaphoreClass;
typedef struct _EventSemaphorePrivate EventSemaphorePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AbstractSemaphore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AbstractSemaphorePrivate * priv;
};

struct _AbstractSemaphoreClass {
	GTypeClass parent_class;
	void (*finalize) (AbstractSemaphore *self);
	AbstractSemaphoreNotifyAction (*do_notify) (AbstractSemaphore* self);
	AbstractSemaphoreWaitAction (*do_wait) (AbstractSemaphore* self);
	gboolean (*do_reset) (AbstractSemaphore* self);
};

struct _AbstractSemaphorePrivate {
	AbstractSemaphoreType type;
	GMutex mutex;
	GCond monitor;
};

struct _ParamSpecAbstractSemaphore {
	GParamSpec parent_instance;
};

struct _Semaphore {
	AbstractSemaphore parent_instance;
	SemaphorePrivate * priv;
};

struct _SemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _SemaphorePrivate {
	gboolean passed;
};

struct _CountdownSemaphore {
	AbstractSemaphore parent_instance;
	CountdownSemaphorePrivate * priv;
};

struct _CountdownSemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _CountdownSemaphorePrivate {
	gint total;
	gint passed;
};

struct _EventSemaphore {
	AbstractSemaphore parent_instance;
	EventSemaphorePrivate * priv;
};

struct _EventSemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _EventSemaphorePrivate {
	gboolean fired;
};

static gint AbstractSemaphore_private_offset;
static gpointer abstract_semaphore_parent_class = NULL;
static gint Semaphore_private_offset;
static gpointer semaphore_parent_class = NULL;
static gint CountdownSemaphore_private_offset;
static gpointer countdown_semaphore_parent_class = NULL;
static gint EventSemaphore_private_offset;
static gpointer event_semaphore_parent_class = NULL;

VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN GType abstract_semaphore_notify_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType abstract_semaphore_wait_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType abstract_semaphore_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AbstractSemaphoreNotifyAction abstract_semaphore_do_notify (AbstractSemaphore* self);
VALA_EXTERN AbstractSemaphoreWaitAction abstract_semaphore_do_wait (AbstractSemaphore* self);
VALA_EXTERN gboolean abstract_semaphore_do_reset (AbstractSemaphore* self);
VALA_EXTERN AbstractSemaphore* abstract_semaphore_construct (GType object_type,
                                                 AbstractSemaphoreType type);
static void abstract_semaphore_trigger (AbstractSemaphore* self);
VALA_EXTERN void abstract_semaphore_notify (AbstractSemaphore* self);
static AbstractSemaphoreNotifyAction abstract_semaphore_real_do_notify (AbstractSemaphore* self);
VALA_EXTERN void abstract_semaphore_wait (AbstractSemaphore* self);
static AbstractSemaphoreWaitAction abstract_semaphore_real_do_wait (AbstractSemaphore* self);
VALA_EXTERN gboolean abstract_semaphore_reset (AbstractSemaphore* self);
static gboolean abstract_semaphore_real_do_reset (AbstractSemaphore* self);
static void abstract_semaphore_finalize (AbstractSemaphore * obj);
static GType abstract_semaphore_get_type_once (void);
VALA_EXTERN GType semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Semaphore, abstract_semaphore_unref)
VALA_EXTERN Semaphore* semaphore_new (void);
VALA_EXTERN Semaphore* semaphore_construct (GType object_type);
static AbstractSemaphoreNotifyAction semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction semaphore_real_do_wait (AbstractSemaphore* base);
static void semaphore_finalize (AbstractSemaphore * obj);
static GType semaphore_get_type_once (void);
VALA_EXTERN GType countdown_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CountdownSemaphore, abstract_semaphore_unref)
VALA_EXTERN CountdownSemaphore* countdown_semaphore_new (gint total);
VALA_EXTERN CountdownSemaphore* countdown_semaphore_construct (GType object_type,
                                                   gint total);
static AbstractSemaphoreNotifyAction countdown_semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction countdown_semaphore_real_do_wait (AbstractSemaphore* base);
static void countdown_semaphore_finalize (AbstractSemaphore * obj);
static GType countdown_semaphore_get_type_once (void);
VALA_EXTERN GType event_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSemaphore, abstract_semaphore_unref)
VALA_EXTERN EventSemaphore* event_semaphore_new (void);
VALA_EXTERN EventSemaphore* event_semaphore_construct (GType object_type);
static AbstractSemaphoreNotifyAction event_semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction event_semaphore_real_do_wait (AbstractSemaphore* base);
static gboolean event_semaphore_real_do_reset (AbstractSemaphore* base);
static void event_semaphore_finalize (AbstractSemaphore * obj);
static GType event_semaphore_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
abstract_semaphore_get_instance_private (AbstractSemaphore* self)
{
	return G_STRUCT_MEMBER_P (self, AbstractSemaphore_private_offset);
}

static GType
abstract_semaphore_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_TYPE_SERIAL, "ABSTRACT_SEMAPHORE_TYPE_SERIAL", "serial"}, {ABSTRACT_SEMAPHORE_TYPE_BROADCAST, "ABSTRACT_SEMAPHORE_TYPE_BROADCAST", "broadcast"}, {0, NULL, NULL}};
	GType abstract_semaphore_type_type_id;
	abstract_semaphore_type_type_id = g_enum_register_static ("AbstractSemaphoreType", values);
	return abstract_semaphore_type_type_id;
}

GType
abstract_semaphore_type_get_type (void)
{
	static volatile gsize abstract_semaphore_type_type_id__once = 0;
	if (g_once_init_enter (&abstract_semaphore_type_type_id__once)) {
		GType abstract_semaphore_type_type_id;
		abstract_semaphore_type_type_id = abstract_semaphore_type_get_type_once ();
		g_once_init_leave (&abstract_semaphore_type_type_id__once, abstract_semaphore_type_type_id);
	}
	return abstract_semaphore_type_type_id__once;
}

static GType
abstract_semaphore_notify_action_get_type_once (void)
{
	static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE, "ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE", "none"}, {ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL, "ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL", "signal"}, {0, NULL, NULL}};
	GType abstract_semaphore_notify_action_type_id;
	abstract_semaphore_notify_action_type_id = g_enum_register_static ("AbstractSemaphoreNotifyAction", values);
	return abstract_semaphore_notify_action_type_id;
}

GType
abstract_semaphore_notify_action_get_type (void)
{
	static volatile gsize abstract_semaphore_notify_action_type_id__once = 0;
	if (g_once_init_enter (&abstract_semaphore_notify_action_type_id__once)) {
		GType abstract_semaphore_notify_action_type_id;
		abstract_semaphore_notify_action_type_id = abstract_semaphore_notify_action_get_type_once ();
		g_once_init_leave (&abstract_semaphore_notify_action_type_id__once, abstract_semaphore_notify_action_type_id);
	}
	return abstract_semaphore_notify_action_type_id__once;
}

static GType
abstract_semaphore_wait_action_get_type_once (void)
{
	static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP, "ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP", "sleep"}, {ABSTRACT_SEMAPHORE_WAIT_ACTION_READY, "ABSTRACT_SEMAPHORE_WAIT_ACTION_READY", "ready"}, {0, NULL, NULL}};
	GType abstract_semaphore_wait_action_type_id;
	abstract_semaphore_wait_action_type_id = g_enum_register_static ("AbstractSemaphoreWaitAction", values);
	return abstract_semaphore_wait_action_type_id;
}

GType
abstract_semaphore_wait_action_get_type (void)
{
	static volatile gsize abstract_semaphore_wait_action_type_id__once = 0;
	if (g_once_init_enter (&abstract_semaphore_wait_action_type_id__once)) {
		GType abstract_semaphore_wait_action_type_id;
		abstract_semaphore_wait_action_type_id = abstract_semaphore_wait_action_get_type_once ();
		g_once_init_leave (&abstract_semaphore_wait_action_type_id__once, abstract_semaphore_wait_action_type_id);
	}
	return abstract_semaphore_wait_action_type_id__once;
}

AbstractSemaphore*
abstract_semaphore_construct (GType object_type,
                              AbstractSemaphoreType type)
{
	AbstractSemaphore* self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (AbstractSemaphore*) g_type_create_instance (object_type);
	if (type == ABSTRACT_SEMAPHORE_TYPE_SERIAL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == ABSTRACT_SEMAPHORE_TYPE_BROADCAST;
	}
	_vala_assert (_tmp0_, "type == Type.SERIAL || type == Type.BROADCAST");
	self->priv->type = type;
	return self;
}

static void
abstract_semaphore_trigger (AbstractSemaphore* self)
{
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
	if (self->priv->type == ABSTRACT_SEMAPHORE_TYPE_SERIAL) {
		g_cond_signal (&self->priv->monitor);
	} else {
		g_cond_broadcast (&self->priv->monitor);
	}
}

void
abstract_semaphore_notify (AbstractSemaphore* self)
{
	AbstractSemaphoreNotifyAction action = 0;
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
	g_mutex_lock (&self->priv->mutex);
	action = abstract_semaphore_do_notify (self);
	switch (action) {
		case ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE:
		{
			break;
		}
		case ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL:
		{
			abstract_semaphore_trigger (self);
			break;
		}
		default:
		{
			GEnumValue* _tmp0_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (ABSTRACT_SEMAPHORE_TYPE_NOTIFY_ACTION), action);
			g_error ("Semaphore.vala:57: Unknown semaphore action: %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
		}
	}
	g_mutex_unlock (&self->priv->mutex);
}

static AbstractSemaphoreNotifyAction
abstract_semaphore_real_do_notify (AbstractSemaphore* self)
{
	g_critical ("Type `%s' does not implement abstract method `abstract_semaphore_do_notify'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

AbstractSemaphoreNotifyAction
abstract_semaphore_do_notify (AbstractSemaphore* self)
{
	AbstractSemaphoreClass* _klass_;
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), 0);
	_klass_ = ABSTRACT_SEMAPHORE_GET_CLASS (self);
	if (_klass_->do_notify) {
		return _klass_->do_notify (self);
	}
	return 0;
}

void
abstract_semaphore_wait (AbstractSemaphore* self)
{
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
	g_mutex_lock (&self->priv->mutex);
	while (TRUE) {
		if (!(abstract_semaphore_do_wait (self) == ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP)) {
			break;
		}
		g_cond_wait (&self->priv->monitor, &self->priv->mutex);
	}
	g_mutex_unlock (&self->priv->mutex);
}

static AbstractSemaphoreWaitAction
abstract_semaphore_real_do_wait (AbstractSemaphore* self)
{
	g_critical ("Type `%s' does not implement abstract method `abstract_semaphore_do_wait'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

AbstractSemaphoreWaitAction
abstract_semaphore_do_wait (AbstractSemaphore* self)
{
	AbstractSemaphoreClass* _klass_;
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), 0);
	_klass_ = ABSTRACT_SEMAPHORE_GET_CLASS (self);
	if (_klass_->do_wait) {
		return _klass_->do_wait (self);
	}
	return 0;
}

gboolean
abstract_semaphore_reset (AbstractSemaphore* self)
{
	gboolean is_reset = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), FALSE);
	g_mutex_lock (&self->priv->mutex);
	is_reset = abstract_semaphore_do_reset (self);
	g_mutex_unlock (&self->priv->mutex);
	result = is_reset;
	return result;
}

static gboolean
abstract_semaphore_real_do_reset (AbstractSemaphore* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
abstract_semaphore_do_reset (AbstractSemaphore* self)
{
	AbstractSemaphoreClass* _klass_;
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), FALSE);
	_klass_ = ABSTRACT_SEMAPHORE_GET_CLASS (self);
	if (_klass_->do_reset) {
		return _klass_->do_reset (self);
	}
	return FALSE;
}

static void
value_abstract_semaphore_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_abstract_semaphore_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		abstract_semaphore_unref (value->data[0].v_pointer);
	}
}

static void
value_abstract_semaphore_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = abstract_semaphore_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_abstract_semaphore_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_abstract_semaphore_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AbstractSemaphore * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = abstract_semaphore_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_abstract_semaphore_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	AbstractSemaphore ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = abstract_semaphore_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_abstract_semaphore (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecAbstractSemaphore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ABSTRACT_SEMAPHORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_abstract_semaphore (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_abstract_semaphore (GValue* value,
                              gpointer v_object)
{
	AbstractSemaphore * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ABSTRACT_SEMAPHORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		abstract_semaphore_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		abstract_semaphore_unref (old);
	}
}

void
value_take_abstract_semaphore (GValue* value,
                               gpointer v_object)
{
	AbstractSemaphore * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ABSTRACT_SEMAPHORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		abstract_semaphore_unref (old);
	}
}

static void
abstract_semaphore_class_init (AbstractSemaphoreClass * klass,
                               gpointer klass_data)
{
	abstract_semaphore_parent_class = g_type_class_peek_parent (klass);
	((AbstractSemaphoreClass *) klass)->finalize = abstract_semaphore_finalize;
	g_type_class_adjust_private_offset (klass, &AbstractSemaphore_private_offset);
	((AbstractSemaphoreClass *) klass)->do_notify = (AbstractSemaphoreNotifyAction (*) (AbstractSemaphore*)) abstract_semaphore_real_do_notify;
	((AbstractSemaphoreClass *) klass)->do_wait = (AbstractSemaphoreWaitAction (*) (AbstractSemaphore*)) abstract_semaphore_real_do_wait;
	((AbstractSemaphoreClass *) klass)->do_reset = (gboolean (*) (AbstractSemaphore*)) abstract_semaphore_real_do_reset;
}

static void
abstract_semaphore_instance_init (AbstractSemaphore * self,
                                  gpointer klass)
{
	self->priv = abstract_semaphore_get_instance_private (self);
	g_mutex_init (&self->priv->mutex);
	g_cond_init (&self->priv->monitor);
	self->ref_count = 1;
}

static void
abstract_semaphore_finalize (AbstractSemaphore * obj)
{
	AbstractSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore);
	g_signal_handlers_destroy (self);
	_vala_clear_GMutex (&self->priv->mutex);
	_vala_clear_GCond (&self->priv->monitor);
}

static GType
abstract_semaphore_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_abstract_semaphore_init, value_abstract_semaphore_free_value, value_abstract_semaphore_copy_value, value_abstract_semaphore_peek_pointer, "p", value_abstract_semaphore_collect_value, "p", value_abstract_semaphore_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AbstractSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) abstract_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbstractSemaphore), 0, (GInstanceInitFunc) abstract_semaphore_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType abstract_semaphore_type_id;
	abstract_semaphore_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AbstractSemaphore", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	AbstractSemaphore_private_offset = g_type_add_instance_private (abstract_semaphore_type_id, sizeof (AbstractSemaphorePrivate));
	return abstract_semaphore_type_id;
}

GType
abstract_semaphore_get_type (void)
{
	static volatile gsize abstract_semaphore_type_id__once = 0;
	if (g_once_init_enter (&abstract_semaphore_type_id__once)) {
		GType abstract_semaphore_type_id;
		abstract_semaphore_type_id = abstract_semaphore_get_type_once ();
		g_once_init_leave (&abstract_semaphore_type_id__once, abstract_semaphore_type_id);
	}
	return abstract_semaphore_type_id__once;
}

gpointer
abstract_semaphore_ref (gpointer instance)
{
	AbstractSemaphore * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
abstract_semaphore_unref (gpointer instance)
{
	AbstractSemaphore * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ABSTRACT_SEMAPHORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
semaphore_get_instance_private (Semaphore* self)
{
	return G_STRUCT_MEMBER_P (self, Semaphore_private_offset);
}

Semaphore*
semaphore_construct (GType object_type)
{
	Semaphore* self = NULL;
	self = (Semaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
	return self;
}

Semaphore*
semaphore_new (void)
{
	return semaphore_construct (TYPE_SEMAPHORE);
}

static AbstractSemaphoreNotifyAction
semaphore_real_do_notify (AbstractSemaphore* base)
{
	Semaphore * self;
	AbstractSemaphoreNotifyAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEMAPHORE, Semaphore);
	if (self->priv->passed) {
		result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE;
		return result;
	}
	self->priv->passed = TRUE;
	result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
	return result;
}

static AbstractSemaphoreWaitAction
semaphore_real_do_wait (AbstractSemaphore* base)
{
	Semaphore * self;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	AbstractSemaphoreWaitAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEMAPHORE, Semaphore);
	if (self->priv->passed) {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
	} else {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
	}
	result = _tmp0_;
	return result;
}

static void
semaphore_class_init (SemaphoreClass * klass,
                      gpointer klass_data)
{
	semaphore_parent_class = g_type_class_peek_parent (klass);
	((AbstractSemaphoreClass *) klass)->finalize = semaphore_finalize;
	g_type_class_adjust_private_offset (klass, &Semaphore_private_offset);
	((AbstractSemaphoreClass *) klass)->do_notify = (AbstractSemaphoreNotifyAction (*) (AbstractSemaphore*)) semaphore_real_do_notify;
	((AbstractSemaphoreClass *) klass)->do_wait = (AbstractSemaphoreWaitAction (*) (AbstractSemaphore*)) semaphore_real_do_wait;
}

static void
semaphore_instance_init (Semaphore * self,
                         gpointer klass)
{
	self->priv = semaphore_get_instance_private (self);
	self->priv->passed = FALSE;
}

static void
semaphore_finalize (AbstractSemaphore * obj)
{
	Semaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEMAPHORE, Semaphore);
	ABSTRACT_SEMAPHORE_CLASS (semaphore_parent_class)->finalize (obj);
}

static GType
semaphore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Semaphore), 0, (GInstanceInitFunc) semaphore_instance_init, NULL };
	GType semaphore_type_id;
	semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "Semaphore", &g_define_type_info, 0);
	Semaphore_private_offset = g_type_add_instance_private (semaphore_type_id, sizeof (SemaphorePrivate));
	return semaphore_type_id;
}

GType
semaphore_get_type (void)
{
	static volatile gsize semaphore_type_id__once = 0;
	if (g_once_init_enter (&semaphore_type_id__once)) {
		GType semaphore_type_id;
		semaphore_type_id = semaphore_get_type_once ();
		g_once_init_leave (&semaphore_type_id__once, semaphore_type_id);
	}
	return semaphore_type_id__once;
}

static inline gpointer
countdown_semaphore_get_instance_private (CountdownSemaphore* self)
{
	return G_STRUCT_MEMBER_P (self, CountdownSemaphore_private_offset);
}

CountdownSemaphore*
countdown_semaphore_construct (GType object_type,
                               gint total)
{
	CountdownSemaphore* self = NULL;
	self = (CountdownSemaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
	self->priv->total = total;
	return self;
}

CountdownSemaphore*
countdown_semaphore_new (gint total)
{
	return countdown_semaphore_construct (TYPE_COUNTDOWN_SEMAPHORE, total);
}

static AbstractSemaphoreNotifyAction
countdown_semaphore_real_do_notify (AbstractSemaphore* base)
{
	CountdownSemaphore * self;
	AbstractSemaphoreNotifyAction _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	AbstractSemaphoreNotifyAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
	if (self->priv->passed >= self->priv->total) {
		g_critical ("Semaphore.vala:127: CountdownSemaphore overrun: %d/%d", self->priv->passed + 1, self->priv->total);
	}
	self->priv->passed = self->priv->passed + 1;
	_tmp1_ = self->priv->passed;
	_tmp2_ = self->priv->total;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
	} else {
		_tmp0_ = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE;
	}
	result = _tmp0_;
	return result;
}

static AbstractSemaphoreWaitAction
countdown_semaphore_real_do_wait (AbstractSemaphore* base)
{
	CountdownSemaphore * self;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	AbstractSemaphoreWaitAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
	if (self->priv->passed < self->priv->total) {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
	} else {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
	}
	result = _tmp0_;
	return result;
}

static void
countdown_semaphore_class_init (CountdownSemaphoreClass * klass,
                                gpointer klass_data)
{
	countdown_semaphore_parent_class = g_type_class_peek_parent (klass);
	((AbstractSemaphoreClass *) klass)->finalize = countdown_semaphore_finalize;
	g_type_class_adjust_private_offset (klass, &CountdownSemaphore_private_offset);
	((AbstractSemaphoreClass *) klass)->do_notify = (AbstractSemaphoreNotifyAction (*) (AbstractSemaphore*)) countdown_semaphore_real_do_notify;
	((AbstractSemaphoreClass *) klass)->do_wait = (AbstractSemaphoreWaitAction (*) (AbstractSemaphore*)) countdown_semaphore_real_do_wait;
}

static void
countdown_semaphore_instance_init (CountdownSemaphore * self,
                                   gpointer klass)
{
	self->priv = countdown_semaphore_get_instance_private (self);
	self->priv->passed = 0;
}

static void
countdown_semaphore_finalize (AbstractSemaphore * obj)
{
	CountdownSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
	ABSTRACT_SEMAPHORE_CLASS (countdown_semaphore_parent_class)->finalize (obj);
}

static GType
countdown_semaphore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CountdownSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) countdown_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CountdownSemaphore), 0, (GInstanceInitFunc) countdown_semaphore_instance_init, NULL };
	GType countdown_semaphore_type_id;
	countdown_semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "CountdownSemaphore", &g_define_type_info, 0);
	CountdownSemaphore_private_offset = g_type_add_instance_private (countdown_semaphore_type_id, sizeof (CountdownSemaphorePrivate));
	return countdown_semaphore_type_id;
}

GType
countdown_semaphore_get_type (void)
{
	static volatile gsize countdown_semaphore_type_id__once = 0;
	if (g_once_init_enter (&countdown_semaphore_type_id__once)) {
		GType countdown_semaphore_type_id;
		countdown_semaphore_type_id = countdown_semaphore_get_type_once ();
		g_once_init_leave (&countdown_semaphore_type_id__once, countdown_semaphore_type_id);
	}
	return countdown_semaphore_type_id__once;
}

static inline gpointer
event_semaphore_get_instance_private (EventSemaphore* self)
{
	return G_STRUCT_MEMBER_P (self, EventSemaphore_private_offset);
}

EventSemaphore*
event_semaphore_construct (GType object_type)
{
	EventSemaphore* self = NULL;
	self = (EventSemaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
	return self;
}

EventSemaphore*
event_semaphore_new (void)
{
	return event_semaphore_construct (TYPE_EVENT_SEMAPHORE);
}

static AbstractSemaphoreNotifyAction
event_semaphore_real_do_notify (AbstractSemaphore* base)
{
	EventSemaphore * self;
	AbstractSemaphoreNotifyAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
	self->priv->fired = TRUE;
	result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
	return result;
}

static AbstractSemaphoreWaitAction
event_semaphore_real_do_wait (AbstractSemaphore* base)
{
	EventSemaphore * self;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	AbstractSemaphoreWaitAction result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
	if (self->priv->fired) {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
	} else {
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
	}
	result = _tmp0_;
	return result;
}

static gboolean
event_semaphore_real_do_reset (AbstractSemaphore* base)
{
	EventSemaphore * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
	self->priv->fired = FALSE;
	result = TRUE;
	return result;
}

static void
event_semaphore_class_init (EventSemaphoreClass * klass,
                            gpointer klass_data)
{
	event_semaphore_parent_class = g_type_class_peek_parent (klass);
	((AbstractSemaphoreClass *) klass)->finalize = event_semaphore_finalize;
	g_type_class_adjust_private_offset (klass, &EventSemaphore_private_offset);
	((AbstractSemaphoreClass *) klass)->do_notify = (AbstractSemaphoreNotifyAction (*) (AbstractSemaphore*)) event_semaphore_real_do_notify;
	((AbstractSemaphoreClass *) klass)->do_wait = (AbstractSemaphoreWaitAction (*) (AbstractSemaphore*)) event_semaphore_real_do_wait;
	((AbstractSemaphoreClass *) klass)->do_reset = (gboolean (*) (AbstractSemaphore*)) event_semaphore_real_do_reset;
}

static void
event_semaphore_instance_init (EventSemaphore * self,
                               gpointer klass)
{
	self->priv = event_semaphore_get_instance_private (self);
	self->priv->fired = FALSE;
}

static void
event_semaphore_finalize (AbstractSemaphore * obj)
{
	EventSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_SEMAPHORE, EventSemaphore);
	ABSTRACT_SEMAPHORE_CLASS (event_semaphore_parent_class)->finalize (obj);
}

static GType
event_semaphore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSemaphore), 0, (GInstanceInitFunc) event_semaphore_instance_init, NULL };
	GType event_semaphore_type_id;
	event_semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "EventSemaphore", &g_define_type_info, 0);
	EventSemaphore_private_offset = g_type_add_instance_private (event_semaphore_type_id, sizeof (EventSemaphorePrivate));
	return event_semaphore_type_id;
}

GType
event_semaphore_get_type (void)
{
	static volatile gsize event_semaphore_type_id__once = 0;
	if (g_once_init_enter (&event_semaphore_type_id__once)) {
		GType event_semaphore_type_id;
		event_semaphore_type_id = event_semaphore_get_type_once ();
		g_once_init_leave (&event_semaphore_type_id__once, event_semaphore_type_id);
	}
	return event_semaphore_type_id__once;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

