/* BackgroundJob.c generated by valac 0.56.17, the Vala compiler
 * generated from BackgroundJob.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* This callback is executed when an associated BackgroundJob completes.  It is called from within*/
/* the Gtk event loop, *not* the background thread's context.*/

#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_NOTIFICATION_OBJECT (notification_object_get_type ())
#define NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_OBJECT, NotificationObject))
#define NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_OBJECT, NotificationObjectClass))
#define IS_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_OBJECT))
#define IS_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_OBJECT))
#define NOTIFICATION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_OBJECT, NotificationObjectClass))

typedef struct _NotificationObject NotificationObject;
typedef struct _NotificationObjectClass NotificationObjectClass;
typedef struct _NotificationObjectPrivate NotificationObjectPrivate;
typedef struct _ParamSpecNotificationObject ParamSpecNotificationObject;

#define TYPE_INTERLOCKED_NOTIFICATION_OBJECT (interlocked_notification_object_get_type ())
#define INTERLOCKED_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObject))
#define INTERLOCKED_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObjectClass))
#define IS_INTERLOCKED_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT))
#define IS_INTERLOCKED_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INTERLOCKED_NOTIFICATION_OBJECT))
#define INTERLOCKED_NOTIFICATION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObjectClass))

typedef struct _InterlockedNotificationObject InterlockedNotificationObject;
typedef struct _InterlockedNotificationObjectClass InterlockedNotificationObjectClass;
typedef struct _InterlockedNotificationObjectPrivate InterlockedNotificationObjectPrivate;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_SEMAPHORE (semaphore_get_type ())
#define SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEMAPHORE, Semaphore))
#define SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEMAPHORE, SemaphoreClass))
#define IS_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEMAPHORE))
#define IS_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEMAPHORE))
#define SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEMAPHORE, SemaphoreClass))

typedef struct _Semaphore Semaphore;
typedef struct _SemaphoreClass SemaphoreClass;
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
typedef void (*NotificationCallback) (BackgroundJob* job, NotificationObject* user, gpointer user_data);
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())

#define BACKGROUND_JOB_TYPE_NOTIFICATION_JOB (background_job_notification_job_get_type ())
#define BACKGROUND_JOB_NOTIFICATION_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJob))
#define BACKGROUND_JOB_NOTIFICATION_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJobClass))
#define BACKGROUND_JOB_IS_NOTIFICATION_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB))
#define BACKGROUND_JOB_IS_NOTIFICATION_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB))
#define BACKGROUND_JOB_NOTIFICATION_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJobClass))

typedef struct _BackgroundJobNotificationJob BackgroundJobNotificationJob;
typedef struct _BackgroundJobNotificationJobClass BackgroundJobNotificationJobClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _background_job_notification_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_notification_job_unref (var), NULL)))
#define _notification_object_unref0(var) ((var == NULL) ? NULL : (var = (notification_object_unref (var), NULL)))
typedef struct _BackgroundJobNotificationJobPrivate BackgroundJobNotificationJobPrivate;
typedef struct _BackgroundJobParamSpecNotificationJob BackgroundJobParamSpecNotificationJob;
typedef struct _ParamSpecBackgroundJob ParamSpecBackgroundJob;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NotificationObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotificationObjectPrivate * priv;
};

struct _NotificationObjectClass {
	GTypeClass parent_class;
	void (*finalize) (NotificationObject *self);
};

struct _ParamSpecNotificationObject {
	GParamSpec parent_instance;
};

struct _InterlockedNotificationObject {
	NotificationObject parent_instance;
	InterlockedNotificationObjectPrivate * priv;
};

struct _InterlockedNotificationObjectClass {
	NotificationObjectClass parent_class;
};

struct _InterlockedNotificationObjectPrivate {
	Semaphore* semaphore;
};

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _BackgroundJobPrivate {
	GObject* owner;
	CompletionCallback callback;
	gpointer callback_target;
	GCancellable* cancellable;
	CancellationCallback cancellation;
	gpointer cancellation_target;
	BackgroundJob* self;
	AbstractSemaphore* semaphore;
	gint completion_priority;
	gint notification_priority;
};

struct _BackgroundJobNotificationJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobNotificationJobPrivate * priv;
	NotificationCallback callback;
	gpointer callback_target;
	BackgroundJob* background_job;
	NotificationObject* user;
};

struct _BackgroundJobNotificationJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJobNotificationJob *self);
};

struct _BackgroundJobParamSpecNotificationJob {
	GParamSpec parent_instance;
};

struct _ParamSpecBackgroundJob {
	GParamSpec parent_instance;
};

static gpointer notification_object_parent_class = NULL;
static gint InterlockedNotificationObject_private_offset;
static gpointer interlocked_notification_object_parent_class = NULL;
static gint BackgroundJob_private_offset;
static gpointer background_job_parent_class = NULL;
static GeeArrayList* background_job_notify_queue;
static GRecMutex __lock_background_job_background_job_notify_queue = {0};
static GeeArrayList* background_job_notify_queue = NULL;
static gpointer background_job_notification_job_parent_class = NULL;

VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
VALA_EXTERN gpointer notification_object_ref (gpointer instance);
VALA_EXTERN void notification_object_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_notification_object (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_notification_object (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_notification_object (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_notification_object (const GValue* value);
VALA_EXTERN GType notification_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationObject, notification_object_unref)
VALA_EXTERN NotificationObject* notification_object_construct (GType object_type);
static void notification_object_finalize (NotificationObject * obj);
static GType notification_object_get_type_once (void);
VALA_EXTERN GType interlocked_notification_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (InterlockedNotificationObject, notification_object_unref)
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN GType semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Semaphore, abstract_semaphore_unref)
VALA_EXTERN Semaphore* semaphore_new (void);
VALA_EXTERN Semaphore* semaphore_construct (GType object_type);
VALA_EXTERN void interlocked_notification_object_internal_wait_for_completion (InterlockedNotificationObject* self);
VALA_EXTERN void abstract_semaphore_wait (AbstractSemaphore* self);
VALA_EXTERN void interlocked_notification_object_internal_completed (InterlockedNotificationObject* self);
VALA_EXTERN void abstract_semaphore_notify (AbstractSemaphore* self);
VALA_EXTERN InterlockedNotificationObject* interlocked_notification_object_construct (GType object_type);
static void interlocked_notification_object_finalize (NotificationObject * obj);
static GType interlocked_notification_object_get_type_once (void);
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void background_job_execute (BackgroundJob* self);
VALA_EXTERN BackgroundJobJobPriority background_job_get_priority (BackgroundJob* self);
VALA_EXTERN gint background_job_job_priority_compare (BackgroundJobJobPriority self,
                                          BackgroundJobJobPriority other);
VALA_EXTERN gint background_job_job_priority_compare_func (BackgroundJobJobPriority a,
                                               BackgroundJobJobPriority b);
static gpointer background_job_notification_job_ref (gpointer instance);
static void background_job_notification_job_unref (gpointer instance);
static GParamSpec* background_job_param_spec_notification_job (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED ;
static void background_job_value_set_notification_job (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static void background_job_value_take_notification_job (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static gpointer background_job_value_get_notification_job (const GValue* value) G_GNUC_UNUSED ;
static GType background_job_notification_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJobNotificationJob, background_job_notification_job_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void background_job_real_execute (BackgroundJob* self);
static BackgroundJobJobPriority background_job_real_get_priority (BackgroundJob* self);
VALA_EXTERN gint background_job_priority_compare_func (BackgroundJob* a,
                                           BackgroundJob* b);
VALA_EXTERN gint64 background_job_priority_comparator (void* a,
                                           void* b);
VALA_EXTERN void background_job_set_completion_priority (BackgroundJob* self,
                                             gint priority);
VALA_EXTERN void background_job_set_notification_priority (BackgroundJob* self,
                                               gint priority);
VALA_EXTERN void background_job_wait_for_completion (BackgroundJob* self);
VALA_EXTERN GCancellable* background_job_get_cancellable (BackgroundJob* self);
VALA_EXTERN gboolean background_job_is_cancelled (BackgroundJob* self);
VALA_EXTERN void background_job_cancel (BackgroundJob* self);
VALA_EXTERN void background_job_internal_notify_completion (BackgroundJob* self);
static gboolean background_job_on_notify_completion (BackgroundJob* self);
static gboolean _background_job_on_notify_completion_gsource_func (gpointer self);
VALA_EXTERN void background_job_notify (BackgroundJob* self,
                            NotificationCallback callback,
                            gpointer callback_target,
                            NotificationObject* user);
static BackgroundJobNotificationJob* background_job_notification_job_new (NotificationCallback callback,
                                                                   gpointer callback_target,
                                                                   BackgroundJob* background_job,
                                                                   NotificationObject* user);
static BackgroundJobNotificationJob* background_job_notification_job_construct (GType object_type,
                                                                         NotificationCallback callback,
                                                                         gpointer callback_target,
                                                                         BackgroundJob* background_job,
                                                                         NotificationObject* user);
static gboolean background_job_on_notification_ready (BackgroundJob* self);
static gboolean _background_job_on_notification_ready_gsource_func (gpointer self);
static void background_job_notification_job_finalize (BackgroundJobNotificationJob * obj);
static GType background_job_notification_job_get_type_once (void);
static void background_job_finalize (BackgroundJob * obj);
static GType background_job_get_type_once (void);

NotificationObject*
notification_object_construct (GType object_type)
{
	NotificationObject* self = NULL;
	self = (NotificationObject*) g_type_create_instance (object_type);
	return self;
}

static void
value_notification_object_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_notification_object_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		notification_object_unref (value->data[0].v_pointer);
	}
}

static void
value_notification_object_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = notification_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_notification_object_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_notification_object_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NotificationObject * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = notification_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_notification_object_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	NotificationObject ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = notification_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_notification_object (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecNotificationObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFICATION_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_notification_object (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_notification_object (GValue* value,
                               gpointer v_object)
{
	NotificationObject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFICATION_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		notification_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notification_object_unref (old);
	}
}

void
value_take_notification_object (GValue* value,
                                gpointer v_object)
{
	NotificationObject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFICATION_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notification_object_unref (old);
	}
}

static void
notification_object_class_init (NotificationObjectClass * klass,
                                gpointer klass_data)
{
	notification_object_parent_class = g_type_class_peek_parent (klass);
	((NotificationObjectClass *) klass)->finalize = notification_object_finalize;
}

static void
notification_object_instance_init (NotificationObject * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
notification_object_finalize (NotificationObject * obj)
{
	NotificationObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATION_OBJECT, NotificationObject);
	g_signal_handlers_destroy (self);
}

static GType
notification_object_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_notification_object_init, value_notification_object_free_value, value_notification_object_copy_value, value_notification_object_peek_pointer, "p", value_notification_object_collect_value, "p", value_notification_object_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NotificationObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationObject), 0, (GInstanceInitFunc) notification_object_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType notification_object_type_id;
	notification_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NotificationObject", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return notification_object_type_id;
}

GType
notification_object_get_type (void)
{
	static volatile gsize notification_object_type_id__once = 0;
	if (g_once_init_enter (&notification_object_type_id__once)) {
		GType notification_object_type_id;
		notification_object_type_id = notification_object_get_type_once ();
		g_once_init_leave (&notification_object_type_id__once, notification_object_type_id);
	}
	return notification_object_type_id__once;
}

gpointer
notification_object_ref (gpointer instance)
{
	NotificationObject * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
notification_object_unref (gpointer instance)
{
	NotificationObject * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTIFICATION_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
interlocked_notification_object_get_instance_private (InterlockedNotificationObject* self)
{
	return G_STRUCT_MEMBER_P (self, InterlockedNotificationObject_private_offset);
}

void
interlocked_notification_object_internal_wait_for_completion (InterlockedNotificationObject* self)
{
	Semaphore* _tmp0_;
	g_return_if_fail (IS_INTERLOCKED_NOTIFICATION_OBJECT (self));
	_tmp0_ = self->priv->semaphore;
	abstract_semaphore_wait (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
}

void
interlocked_notification_object_internal_completed (InterlockedNotificationObject* self)
{
	Semaphore* _tmp0_;
	g_return_if_fail (IS_INTERLOCKED_NOTIFICATION_OBJECT (self));
	_tmp0_ = self->priv->semaphore;
	abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
}

InterlockedNotificationObject*
interlocked_notification_object_construct (GType object_type)
{
	InterlockedNotificationObject* self = NULL;
	self = (InterlockedNotificationObject*) notification_object_construct (object_type);
	return self;
}

static void
interlocked_notification_object_class_init (InterlockedNotificationObjectClass * klass,
                                            gpointer klass_data)
{
	interlocked_notification_object_parent_class = g_type_class_peek_parent (klass);
	((NotificationObjectClass *) klass)->finalize = interlocked_notification_object_finalize;
	g_type_class_adjust_private_offset (klass, &InterlockedNotificationObject_private_offset);
}

static void
interlocked_notification_object_instance_init (InterlockedNotificationObject * self,
                                               gpointer klass)
{
	Semaphore* _tmp0_;
	self->priv = interlocked_notification_object_get_instance_private (self);
	_tmp0_ = semaphore_new ();
	self->priv->semaphore = _tmp0_;
}

static void
interlocked_notification_object_finalize (NotificationObject * obj)
{
	InterlockedNotificationObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObject);
	_abstract_semaphore_unref0 (self->priv->semaphore);
	NOTIFICATION_OBJECT_CLASS (interlocked_notification_object_parent_class)->finalize (obj);
}

static GType
interlocked_notification_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (InterlockedNotificationObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) interlocked_notification_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InterlockedNotificationObject), 0, (GInstanceInitFunc) interlocked_notification_object_instance_init, NULL };
	GType interlocked_notification_object_type_id;
	interlocked_notification_object_type_id = g_type_register_static (TYPE_NOTIFICATION_OBJECT, "InterlockedNotificationObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	InterlockedNotificationObject_private_offset = g_type_add_instance_private (interlocked_notification_object_type_id, sizeof (InterlockedNotificationObjectPrivate));
	return interlocked_notification_object_type_id;
}

GType
interlocked_notification_object_get_type (void)
{
	static volatile gsize interlocked_notification_object_type_id__once = 0;
	if (g_once_init_enter (&interlocked_notification_object_type_id__once)) {
		GType interlocked_notification_object_type_id;
		interlocked_notification_object_type_id = interlocked_notification_object_get_type_once ();
		g_once_init_leave (&interlocked_notification_object_type_id__once, interlocked_notification_object_type_id);
	}
	return interlocked_notification_object_type_id__once;
}

static inline gpointer
background_job_get_instance_private (BackgroundJob* self)
{
	return G_STRUCT_MEMBER_P (self, BackgroundJob_private_offset);
}

gint
background_job_job_priority_compare (BackgroundJobJobPriority self,
                                     BackgroundJobJobPriority other)
{
	gint result;
	result = ((gint) other) - ((gint) self);
	return result;
}

gint
background_job_job_priority_compare_func (BackgroundJobJobPriority a,
                                          BackgroundJobJobPriority b)
{
	gint result;
	result = ((gint) b) - ((gint) a);
	return result;
}

static GType
background_job_job_priority_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKGROUND_JOB_JOB_PRIORITY_HIGHEST, "BACKGROUND_JOB_JOB_PRIORITY_HIGHEST", "highest"}, {BACKGROUND_JOB_JOB_PRIORITY_HIGH, "BACKGROUND_JOB_JOB_PRIORITY_HIGH", "high"}, {BACKGROUND_JOB_JOB_PRIORITY_NORMAL, "BACKGROUND_JOB_JOB_PRIORITY_NORMAL", "normal"}, {BACKGROUND_JOB_JOB_PRIORITY_LOW, "BACKGROUND_JOB_JOB_PRIORITY_LOW", "low"}, {BACKGROUND_JOB_JOB_PRIORITY_LOWEST, "BACKGROUND_JOB_JOB_PRIORITY_LOWEST", "lowest"}, {0, NULL, NULL}};
	GType background_job_job_priority_type_id;
	background_job_job_priority_type_id = g_enum_register_static ("BackgroundJobJobPriority", values);
	return background_job_job_priority_type_id;
}

GType
background_job_job_priority_get_type (void)
{
	static volatile gsize background_job_job_priority_type_id__once = 0;
	if (g_once_init_enter (&background_job_job_priority_type_id__once)) {
		GType background_job_job_priority_type_id;
		background_job_job_priority_type_id = background_job_job_priority_get_type_once ();
		g_once_init_leave (&background_job_job_priority_type_id__once, background_job_job_priority_type_id);
	}
	return background_job_job_priority_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_abstract_semaphore_ref0 (gpointer self)
{
	return self ? abstract_semaphore_ref (self) : NULL;
}

BackgroundJob*
background_job_construct (GType object_type,
                          GObject* owner,
                          CompletionCallback callback,
                          gpointer callback_target,
                          GCancellable* cancellable,
                          CancellationCallback cancellation,
                          gpointer cancellation_target,
                          AbstractSemaphore* completion_semaphore)
{
	BackgroundJob* self = NULL;
	GObject* _tmp0_;
	GCancellable* _tmp1_;
	AbstractSemaphore* _tmp2_;
	g_return_val_if_fail ((owner == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (owner, G_TYPE_OBJECT), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	g_return_val_if_fail ((completion_semaphore == NULL) || IS_ABSTRACT_SEMAPHORE (completion_semaphore), NULL);
	self = (BackgroundJob*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->owner);
	self->priv->owner = _tmp0_;
	self->priv->callback = callback;
	self->priv->callback_target = callback_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	self->priv->cancellation = cancellation;
	self->priv->cancellation_target = cancellation_target;
	_tmp2_ = _abstract_semaphore_ref0 (completion_semaphore);
	_abstract_semaphore_unref0 (self->priv->semaphore);
	self->priv->semaphore = _tmp2_;
	return self;
}

static void
background_job_real_execute (BackgroundJob* self)
{
	g_critical ("Type `%s' does not implement abstract method `background_job_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
background_job_execute (BackgroundJob* self)
{
	BackgroundJobClass* _klass_;
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	_klass_ = BACKGROUND_JOB_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self);
	}
}

static BackgroundJobJobPriority
background_job_real_get_priority (BackgroundJob* self)
{
	BackgroundJobJobPriority result;
	result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
	return result;
}

BackgroundJobJobPriority
background_job_get_priority (BackgroundJob* self)
{
	BackgroundJobClass* _klass_;
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), 0);
	_klass_ = BACKGROUND_JOB_GET_CLASS (self);
	if (_klass_->get_priority) {
		return _klass_->get_priority (self);
	}
	return 0;
}

gint
background_job_priority_compare_func (BackgroundJob* a,
                                      BackgroundJob* b)
{
	gint result;
	g_return_val_if_fail (IS_BACKGROUND_JOB (a), 0);
	g_return_val_if_fail (IS_BACKGROUND_JOB (b), 0);
	result = background_job_job_priority_compare (background_job_get_priority (a), background_job_get_priority (b));
	return result;
}

gint64
background_job_priority_comparator (void* a,
                                    void* b)
{
	gint64 result;
	result = (gint64) background_job_priority_compare_func (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_BACKGROUND_JOB, BackgroundJob), G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_BACKGROUND_JOB, BackgroundJob));
	return result;
}

void
background_job_set_completion_priority (BackgroundJob* self,
                                        gint priority)
{
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	self->priv->completion_priority = priority;
}

void
background_job_set_notification_priority (BackgroundJob* self,
                                          gint priority)
{
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	self->priv->notification_priority = priority;
}

void
background_job_wait_for_completion (BackgroundJob* self)
{
	AbstractSemaphore* _tmp0_;
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	_tmp0_ = self->priv->semaphore;
	if (_tmp0_ != NULL) {
		AbstractSemaphore* _tmp1_;
		_tmp1_ = self->priv->semaphore;
		abstract_semaphore_wait (_tmp1_);
	}
}

GCancellable*
background_job_get_cancellable (BackgroundJob* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* result;
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), NULL);
	_tmp0_ = self->priv->cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
background_job_is_cancelled (BackgroundJob* self)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
	_tmp1_ = self->priv->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = self->priv->cancellable;
		_tmp0_ = g_cancellable_is_cancelled (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
background_job_cancel (BackgroundJob* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static gboolean
_background_job_on_notify_completion_gsource_func (gpointer self)
{
	gboolean result;
	result = background_job_on_notify_completion ((BackgroundJob*) self);
	return result;
}

void
background_job_internal_notify_completion (BackgroundJob* self)
{
	AbstractSemaphore* _tmp0_;
	gboolean _tmp2_ = FALSE;
	CompletionCallback _tmp3_;
	gpointer _tmp3__target;
	gboolean _tmp5_ = FALSE;
	BackgroundJob* _tmp7_;
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	_tmp0_ = self->priv->semaphore;
	if (_tmp0_ != NULL) {
		AbstractSemaphore* _tmp1_;
		_tmp1_ = self->priv->semaphore;
		abstract_semaphore_notify (_tmp1_);
	}
	_tmp3_ = self->priv->callback;
	_tmp3__target = self->priv->callback_target;
	if (_tmp3_ == NULL) {
		CancellationCallback _tmp4_;
		gpointer _tmp4__target;
		_tmp4_ = self->priv->cancellation;
		_tmp4__target = self->priv->cancellation_target;
		_tmp2_ = _tmp4_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	if (background_job_is_cancelled (self)) {
		CancellationCallback _tmp6_;
		gpointer _tmp6__target;
		_tmp6_ = self->priv->cancellation;
		_tmp6__target = self->priv->cancellation_target;
		_tmp5_ = _tmp6_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		return;
	}
	_tmp7_ = _background_job_ref0 (self);
	_background_job_unref0 (self->priv->self);
	self->priv->self = _tmp7_;
	g_idle_add_full (self->priv->completion_priority, _background_job_on_notify_completion_gsource_func, background_job_ref (self), background_job_unref);
}

static gboolean
background_job_on_notify_completion (BackgroundJob* self)
{
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
	if (background_job_is_cancelled (self)) {
		CancellationCallback _tmp0_;
		gpointer _tmp0__target;
		_tmp0_ = self->priv->cancellation;
		_tmp0__target = self->priv->cancellation_target;
		if (_tmp0_ != NULL) {
			CancellationCallback _tmp1_;
			gpointer _tmp1__target;
			_tmp1_ = self->priv->cancellation;
			_tmp1__target = self->priv->cancellation_target;
			_tmp1_ (self, _tmp1__target);
		}
	} else {
		CompletionCallback _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->callback;
		_tmp2__target = self->priv->callback_target;
		if (_tmp2_ != NULL) {
			CompletionCallback _tmp3_;
			gpointer _tmp3__target;
			_tmp3_ = self->priv->callback;
			_tmp3__target = self->priv->callback_target;
			_tmp3_ (self, _tmp3__target);
		}
	}
	_background_job_unref0 (self->priv->self);
	self->priv->self = NULL;
	result = FALSE;
	return result;
}

static gboolean
_background_job_on_notification_ready_gsource_func (gpointer self)
{
	gboolean result;
	result = background_job_on_notification_ready ((BackgroundJob*) self);
	return result;
}

static gpointer
_notification_object_ref0 (gpointer self)
{
	return self ? notification_object_ref (self) : NULL;
}

void
background_job_notify (BackgroundJob* self,
                       NotificationCallback callback,
                       gpointer callback_target,
                       NotificationObject* user)
{
	InterlockedNotificationObject* interlocked = NULL;
	InterlockedNotificationObject* _tmp5_;
	InterlockedNotificationObject* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKGROUND_JOB (self));
	g_return_if_fail ((user == NULL) || IS_NOTIFICATION_OBJECT (user));
	{
		GeeArrayList* _tmp0_;
		_tmp0_ = background_job_notify_queue;
		g_rec_mutex_lock (&__lock_background_job_background_job_notify_queue);
		{
			GeeArrayList* _tmp1_;
			BackgroundJobNotificationJob* _tmp2_;
			BackgroundJobNotificationJob* _tmp3_;
			_tmp1_ = background_job_notify_queue;
			_tmp2_ = background_job_notification_job_new (callback, callback_target, self, user);
			_tmp3_ = _tmp2_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp3_);
			_background_job_notification_job_unref0 (_tmp3_);
		}
		__finally0:
		{
			GeeArrayList* _tmp4_;
			_tmp4_ = background_job_notify_queue;
			g_rec_mutex_unlock (&__lock_background_job_background_job_notify_queue);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_idle_add_full (self->priv->notification_priority, _background_job_on_notification_ready_gsource_func, background_job_ref (self), background_job_unref);
	_tmp5_ = _notification_object_ref0 (IS_INTERLOCKED_NOTIFICATION_OBJECT (user) ? ((InterlockedNotificationObject*) user) : NULL);
	interlocked = _tmp5_;
	_tmp6_ = interlocked;
	if (_tmp6_ != NULL) {
		InterlockedNotificationObject* _tmp7_;
		_tmp7_ = interlocked;
		interlocked_notification_object_internal_wait_for_completion (_tmp7_);
	}
	_notification_object_unref0 (interlocked);
}

static gboolean
background_job_on_notification_ready (BackgroundJob* self)
{
	BackgroundJobNotificationJob* notification_job = NULL;
	BackgroundJobNotificationJob* _tmp8_;
	BackgroundJobNotificationJob* _tmp9_;
	NotificationCallback _tmp10_;
	gpointer _tmp10__target;
	BackgroundJobNotificationJob* _tmp11_;
	BackgroundJob* _tmp12_;
	BackgroundJobNotificationJob* _tmp13_;
	NotificationObject* _tmp14_;
	InterlockedNotificationObject* interlocked = NULL;
	BackgroundJobNotificationJob* _tmp15_;
	NotificationObject* _tmp16_;
	InterlockedNotificationObject* _tmp17_;
	InterlockedNotificationObject* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
	notification_job = NULL;
	{
		GeeArrayList* _tmp0_;
		_tmp0_ = background_job_notify_queue;
		g_rec_mutex_lock (&__lock_background_job_background_job_notify_queue);
		{
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			_tmp1_ = background_job_notify_queue;
			_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				GeeArrayList* _tmp4_;
				gpointer _tmp5_;
				_tmp4_ = background_job_notify_queue;
				_tmp5_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
				_background_job_notification_job_unref0 (notification_job);
				notification_job = (BackgroundJobNotificationJob*) _tmp5_;
			}
		}
		__finally0:
		{
			GeeArrayList* _tmp6_;
			_tmp6_ = background_job_notify_queue;
			g_rec_mutex_unlock (&__lock_background_job_background_job_notify_queue);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			_background_job_notification_job_unref0 (notification_job);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	_tmp8_ = notification_job;
	_vala_assert (_tmp8_ != NULL, "notification_job != null");
	_tmp9_ = notification_job;
	_tmp10_ = _tmp9_->callback;
	_tmp10__target = _tmp9_->callback_target;
	_tmp11_ = notification_job;
	_tmp12_ = _tmp11_->background_job;
	_tmp13_ = notification_job;
	_tmp14_ = _tmp13_->user;
	_tmp10_ (_tmp12_, _tmp14_, _tmp10__target);
	_tmp15_ = notification_job;
	_tmp16_ = _tmp15_->user;
	_tmp17_ = _notification_object_ref0 (IS_INTERLOCKED_NOTIFICATION_OBJECT (_tmp16_) ? ((InterlockedNotificationObject*) _tmp16_) : NULL);
	interlocked = _tmp17_;
	_tmp18_ = interlocked;
	if (_tmp18_ != NULL) {
		InterlockedNotificationObject* _tmp19_;
		_tmp19_ = interlocked;
		interlocked_notification_object_internal_completed (_tmp19_);
	}
	result = FALSE;
	_notification_object_unref0 (interlocked);
	_background_job_notification_job_unref0 (notification_job);
	return result;
}

static BackgroundJobNotificationJob*
background_job_notification_job_construct (GType object_type,
                                           NotificationCallback callback,
                                           gpointer callback_target,
                                           BackgroundJob* background_job,
                                           NotificationObject* user)
{
	BackgroundJobNotificationJob* self = NULL;
	BackgroundJob* _tmp0_;
	NotificationObject* _tmp1_;
	g_return_val_if_fail (IS_BACKGROUND_JOB (background_job), NULL);
	g_return_val_if_fail ((user == NULL) || IS_NOTIFICATION_OBJECT (user), NULL);
	self = (BackgroundJobNotificationJob*) g_type_create_instance (object_type);
	self->callback = callback;
	self->callback_target = callback_target;
	_tmp0_ = _background_job_ref0 (background_job);
	_background_job_unref0 (self->background_job);
	self->background_job = _tmp0_;
	_tmp1_ = _notification_object_ref0 (user);
	_notification_object_unref0 (self->user);
	self->user = _tmp1_;
	return self;
}

static BackgroundJobNotificationJob*
background_job_notification_job_new (NotificationCallback callback,
                                     gpointer callback_target,
                                     BackgroundJob* background_job,
                                     NotificationObject* user)
{
	return background_job_notification_job_construct (BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, callback, callback_target, background_job, user);
}

static void
background_job_value_notification_job_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
background_job_value_notification_job_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		background_job_notification_job_unref (value->data[0].v_pointer);
	}
}

static void
background_job_value_notification_job_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = background_job_notification_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
background_job_value_notification_job_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
background_job_value_notification_job_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BackgroundJobNotificationJob * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = background_job_notification_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
background_job_value_notification_job_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	BackgroundJobNotificationJob ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = background_job_notification_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
background_job_param_spec_notification_job (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	BackgroundJobParamSpecNotificationJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
background_job_value_get_notification_job (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB), NULL);
	return value->data[0].v_pointer;
}

static void
background_job_value_set_notification_job (GValue* value,
                                           gpointer v_object)
{
	BackgroundJobNotificationJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		background_job_notification_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_job_notification_job_unref (old);
	}
}

static void
background_job_value_take_notification_job (GValue* value,
                                            gpointer v_object)
{
	BackgroundJobNotificationJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_job_notification_job_unref (old);
	}
}

static void
background_job_notification_job_class_init (BackgroundJobNotificationJobClass * klass,
                                            gpointer klass_data)
{
	background_job_notification_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobNotificationJobClass *) klass)->finalize = background_job_notification_job_finalize;
}

static void
background_job_notification_job_instance_init (BackgroundJobNotificationJob * self,
                                               gpointer klass)
{
	self->ref_count = 1;
}

static void
background_job_notification_job_finalize (BackgroundJobNotificationJob * obj)
{
	BackgroundJobNotificationJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJob);
	g_signal_handlers_destroy (self);
	_background_job_unref0 (self->background_job);
	_notification_object_unref0 (self->user);
}

static GType
background_job_notification_job_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { background_job_value_notification_job_init, background_job_value_notification_job_free_value, background_job_value_notification_job_copy_value, background_job_value_notification_job_peek_pointer, "p", background_job_value_notification_job_collect_value, "p", background_job_value_notification_job_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobNotificationJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_notification_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJobNotificationJob), 0, (GInstanceInitFunc) background_job_notification_job_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType background_job_notification_job_type_id;
	background_job_notification_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackgroundJobNotificationJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return background_job_notification_job_type_id;
}

static GType
background_job_notification_job_get_type (void)
{
	static volatile gsize background_job_notification_job_type_id__once = 0;
	if (g_once_init_enter (&background_job_notification_job_type_id__once)) {
		GType background_job_notification_job_type_id;
		background_job_notification_job_type_id = background_job_notification_job_get_type_once ();
		g_once_init_leave (&background_job_notification_job_type_id__once, background_job_notification_job_type_id);
	}
	return background_job_notification_job_type_id__once;
}

static gpointer
background_job_notification_job_ref (gpointer instance)
{
	BackgroundJobNotificationJob * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
background_job_notification_job_unref (gpointer instance)
{
	BackgroundJobNotificationJob * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKGROUND_JOB_NOTIFICATION_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_background_job_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_background_job_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		background_job_unref (value->data[0].v_pointer);
	}
}

static void
value_background_job_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = background_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_background_job_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_background_job_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BackgroundJob * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = background_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_background_job_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	BackgroundJob ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = background_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_background_job (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecBackgroundJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKGROUND_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_background_job (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB), NULL);
	return value->data[0].v_pointer;
}

void
value_set_background_job (GValue* value,
                          gpointer v_object)
{
	BackgroundJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		background_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_job_unref (old);
	}
}

void
value_take_background_job (GValue* value,
                           gpointer v_object)
{
	BackgroundJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_job_unref (old);
	}
}

static void
background_job_class_init (BackgroundJobClass * klass,
                           gpointer klass_data)
{
	GeeArrayList* _tmp0_;
	background_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = background_job_finalize;
	g_type_class_adjust_private_offset (klass, &BackgroundJob_private_offset);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) background_job_real_execute;
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*) (BackgroundJob*)) background_job_real_get_priority;
	g_rec_mutex_init (&__lock_background_job_background_job_notify_queue);
	_tmp0_ = gee_array_list_new (BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, (GBoxedCopyFunc) background_job_notification_job_ref, (GDestroyNotify) background_job_notification_job_unref, NULL, NULL, NULL);
	background_job_notify_queue = _tmp0_;
}

static void
background_job_instance_init (BackgroundJob * self,
                              gpointer klass)
{
	self->priv = background_job_get_instance_private (self);
	self->priv->self = NULL;
	self->priv->semaphore = NULL;
	self->priv->completion_priority = G_PRIORITY_HIGH;
	self->priv->notification_priority = G_PRIORITY_DEFAULT_IDLE;
	self->ref_count = 1;
}

static void
background_job_finalize (BackgroundJob * obj)
{
	BackgroundJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND_JOB, BackgroundJob);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->cancellable);
	_background_job_unref0 (self->priv->self);
	_abstract_semaphore_unref0 (self->priv->semaphore);
}

static GType
background_job_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_background_job_init, value_background_job_free_value, value_background_job_copy_value, value_background_job_peek_pointer, "p", value_background_job_collect_value, "p", value_background_job_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJob), 0, (GInstanceInitFunc) background_job_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType background_job_type_id;
	background_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackgroundJob", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	BackgroundJob_private_offset = g_type_add_instance_private (background_job_type_id, sizeof (BackgroundJobPrivate));
	return background_job_type_id;
}

GType
background_job_get_type (void)
{
	static volatile gsize background_job_type_id__once = 0;
	if (g_once_init_enter (&background_job_type_id__once)) {
		GType background_job_type_id;
		background_job_type_id = background_job_get_type_once ();
		g_once_init_leave (&background_job_type_id__once, background_job_type_id);
	}
	return background_job_type_id__once;
}

gpointer
background_job_ref (gpointer instance)
{
	BackgroundJob * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
background_job_unref (gpointer instance)
{
	BackgroundJob * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKGROUND_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

