/* HierarchicalTagIndex.c generated by valac 0.56.17, the Vala compiler
 * generated from HierarchicalTagIndex.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define TAG_PATH_SEPARATOR_STRING "/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
typedef struct _HierarchicalTagIndexPrivate HierarchicalTagIndexPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
typedef struct _ParamSpecHierarchicalTagIndex ParamSpecHierarchicalTagIndex;

struct _HierarchicalTagIndex {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalTagIndexPrivate * priv;
};

struct _HierarchicalTagIndexClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalTagIndex *self);
};

struct _HierarchicalTagIndexPrivate {
	GeeMap* tag_table;
	GeeSortedSet* known_paths;
};

struct _ParamSpecHierarchicalTagIndex {
	GParamSpec parent_instance;
};

static gint HierarchicalTagIndex_private_offset;
static gpointer hierarchical_tag_index_parent_class = NULL;
VALA_EXTERN TagSourceCollection* tag_global;

VALA_EXTERN gpointer hierarchical_tag_index_ref (gpointer instance);
VALA_EXTERN void hierarchical_tag_index_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_hierarchical_tag_index (const GValue* value);
VALA_EXTERN GType hierarchical_tag_index_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HierarchicalTagIndex, hierarchical_tag_index_unref)
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_new (void);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_from_paths (GeeCollection* client_paths);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
VALA_EXTERN void hierarchical_tag_index_add_path (HierarchicalTagIndex* self,
                                      const gchar* tag,
                                      const gchar* path);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN GeeCollection* tag_source_collection_get_all_names (TagSourceCollection* self);
VALA_EXTERN GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
VALA_EXTERN gboolean hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self,
                                                 const gchar* tag);
VALA_EXTERN GeeCollection* hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self);
VALA_EXTERN gboolean hierarchical_tag_index_is_path_known (HierarchicalTagIndex* self,
                                               const gchar* path);
VALA_EXTERN gchar* hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self,
                                                 const gchar* name);
VALA_EXTERN gchar** hierarchical_tag_index_get_paths_for_names_array (HierarchicalTagIndex* self,
                                                          gchar** names,
                                                          gint names_length1,
                                                          gint* result_length1);
static void _vala_array_add65 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void hierarchical_tag_index_finalize (HierarchicalTagIndex * obj);
static GType hierarchical_tag_index_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
hierarchical_tag_index_get_instance_private (HierarchicalTagIndex* self)
{
	return G_STRUCT_MEMBER_P (self, HierarchicalTagIndex_private_offset);
}

HierarchicalTagIndex*
hierarchical_tag_index_construct (GType object_type)
{
	HierarchicalTagIndex* self = NULL;
	GeeHashMap* _tmp0_;
	GeeTreeSet* _tmp1_;
	self = (HierarchicalTagIndex*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tag_table);
	self->priv->tag_table = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->known_paths);
	self->priv->known_paths = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	return self;
}

HierarchicalTagIndex*
hierarchical_tag_index_new (void)
{
	return hierarchical_tag_index_construct (TYPE_HIERARCHICAL_TAG_INDEX);
}

HierarchicalTagIndex*
hierarchical_tag_index_from_paths (GeeCollection* client_paths)
{
	GeeCollection* paths = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	HierarchicalTagIndex* _result_ = NULL;
	HierarchicalTagIndex* _tmp2_;
	HierarchicalTagIndex* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (client_paths, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_collection_get_read_only_view (client_paths);
	_tmp1_ = _tmp0_;
	paths = _tmp1_;
	_tmp2_ = hierarchical_tag_index_new ();
	_result_ = _tmp2_;
	{
		GeeIterator* _path_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = paths;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_path_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* path = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = _path_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _path_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			path = (gchar*) _tmp7_;
			_tmp8_ = path;
			if (g_str_has_prefix (_tmp8_, TAG_PATH_SEPARATOR_STRING)) {
				GeeCollection* components = NULL;
				const gchar* _tmp9_;
				GeeList* _tmp10_;
				_tmp9_ = path;
				_tmp10_ = hierarchical_tag_utilities_enumerate_path_components (_tmp9_);
				components = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection);
				{
					GeeIterator* _component_it = NULL;
					GeeCollection* _tmp11_;
					GeeIterator* _tmp12_;
					_tmp11_ = components;
					_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
					_component_it = _tmp12_;
					while (TRUE) {
						GeeIterator* _tmp13_;
						gchar* component = NULL;
						GeeIterator* _tmp14_;
						gpointer _tmp15_;
						HierarchicalTagIndex* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						_tmp13_ = _component_it;
						if (!gee_iterator_next (_tmp13_)) {
							break;
						}
						_tmp14_ = _component_it;
						_tmp15_ = gee_iterator_get (_tmp14_);
						component = (gchar*) _tmp15_;
						_tmp16_ = _result_;
						_tmp17_ = component;
						_tmp18_ = path;
						hierarchical_tag_index_add_path (_tmp16_, _tmp17_, _tmp18_);
						_g_free0 (component);
					}
					_g_object_unref0 (_component_it);
				}
				_g_object_unref0 (components);
			} else {
				HierarchicalTagIndex* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp19_ = _result_;
				_tmp20_ = path;
				_tmp21_ = path;
				hierarchical_tag_index_add_path (_tmp19_, _tmp20_, _tmp21_);
			}
			_g_free0 (path);
		}
		_g_object_unref0 (_path_it);
	}
	result = _result_;
	_g_object_unref0 (paths);
	return result;
}

HierarchicalTagIndex*
hierarchical_tag_index_get_global_index (void)
{
	TagSourceCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	HierarchicalTagIndex* _tmp3_;
	HierarchicalTagIndex* _tmp4_;
	HierarchicalTagIndex* result;
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_get_all_names (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = hierarchical_tag_index_from_paths (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

void
hierarchical_tag_index_add_path (HierarchicalTagIndex* self,
                                 const gchar* tag,
                                 const gchar* path)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp4_;
	gpointer _tmp5_;
	GeeCollection* _tmp6_;
	GeeSortedSet* _tmp7_;
	g_return_if_fail (IS_HIERARCHICAL_TAG_INDEX (self));
	g_return_if_fail (tag != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->tag_table;
	if (!gee_map_has_key (_tmp0_, tag)) {
		GeeMap* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		_tmp1_ = self->priv->tag_table;
		_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_tmp3_ = _tmp2_;
		gee_map_set (_tmp1_, tag, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp3_);
	}
	_tmp4_ = self->priv->tag_table;
	_tmp5_ = gee_map_get (_tmp4_, tag);
	_tmp6_ = (GeeCollection*) _tmp5_;
	gee_collection_add (_tmp6_, path);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->known_paths;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), path);
}

GeeCollection*
hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), NULL);
	_tmp0_ = self->priv->known_paths;
	_tmp1_ = gee_sorted_set_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

gboolean
hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self,
                                        const gchar* tag)
{
	GeeMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	_tmp0_ = self->priv->tag_table;
	result = gee_map_has_key (_tmp0_, tag);
	return result;
}

GeeCollection*
hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self)
{
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), NULL);
	_tmp0_ = self->priv->tag_table;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

gboolean
hierarchical_tag_index_is_path_known (HierarchicalTagIndex* self,
                                      const gchar* path)
{
	GeeSortedSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->known_paths;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), path);
	return result;
}

gchar*
hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self,
                                          const gchar* name)
{
	GeeCollection* paths = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	gchar* result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (!hierarchical_tag_index_is_tag_in_index (self, name)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (name);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->tag_table;
	_tmp2_ = gee_map_get (_tmp1_, name);
	paths = (GeeCollection*) _tmp2_;
	{
		GeeIterator* _path_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = paths;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_path_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* path = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeList* components = NULL;
			const gchar* _tmp8_;
			GeeList* _tmp9_;
			GeeList* _tmp10_;
			GeeList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			gchar* _tmp15_;
			gboolean _tmp16_;
			_tmp5_ = _path_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _path_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			path = (gchar*) _tmp7_;
			_tmp8_ = path;
			_tmp9_ = hierarchical_tag_utilities_enumerate_path_components (_tmp8_);
			components = _tmp9_;
			_tmp10_ = components;
			_tmp11_ = components;
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_list_get (_tmp10_, _tmp13_ - 1);
			_tmp15_ = (gchar*) _tmp14_;
			_tmp16_ = g_strcmp0 (_tmp15_, name) == 0;
			_g_free0 (_tmp15_);
			if (_tmp16_) {
				result = path;
				_g_object_unref0 (components);
				_g_object_unref0 (_path_it);
				_g_object_unref0 (paths);
				return result;
			}
			_g_object_unref0 (components);
			_g_free0 (path);
		}
		_g_object_unref0 (_path_it);
	}
	g_assert_not_reached ();
}

static void
_vala_array_add65 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
hierarchical_tag_index_get_paths_for_names_array (HierarchicalTagIndex* self,
                                                  gchar** names,
                                                  gint names_length1,
                                                  gint* result_length1)
{
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** result;
	g_return_val_if_fail (IS_HIERARCHICAL_TAG_INDEX (self), NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp1_;
			gchar* name = NULL;
			_tmp1_ = g_strdup (name_collection[name_it]);
			name = _tmp1_;
			{
				const gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp2_ = name;
				_tmp3_ = hierarchical_tag_index_get_path_for_name (self, _tmp2_);
				_vala_array_add65 (&_result_, &_result__length1, &__result__size_, _tmp3_);
				_g_free0 (name);
			}
		}
	}
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
value_hierarchical_tag_index_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_hierarchical_tag_index_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		hierarchical_tag_index_unref (value->data[0].v_pointer);
	}
}

static void
value_hierarchical_tag_index_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = hierarchical_tag_index_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_hierarchical_tag_index_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_hierarchical_tag_index_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HierarchicalTagIndex * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = hierarchical_tag_index_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_hierarchical_tag_index_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	HierarchicalTagIndex ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = hierarchical_tag_index_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_hierarchical_tag_index (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ParamSpecHierarchicalTagIndex* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_TAG_INDEX), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_hierarchical_tag_index (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_INDEX), NULL);
	return value->data[0].v_pointer;
}

void
value_set_hierarchical_tag_index (GValue* value,
                                  gpointer v_object)
{
	HierarchicalTagIndex * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_INDEX));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_INDEX));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		hierarchical_tag_index_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hierarchical_tag_index_unref (old);
	}
}

void
value_take_hierarchical_tag_index (GValue* value,
                                   gpointer v_object)
{
	HierarchicalTagIndex * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_INDEX));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_INDEX));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hierarchical_tag_index_unref (old);
	}
}

static void
hierarchical_tag_index_class_init (HierarchicalTagIndexClass * klass,
                                   gpointer klass_data)
{
	hierarchical_tag_index_parent_class = g_type_class_peek_parent (klass);
	((HierarchicalTagIndexClass *) klass)->finalize = hierarchical_tag_index_finalize;
	g_type_class_adjust_private_offset (klass, &HierarchicalTagIndex_private_offset);
}

static void
hierarchical_tag_index_instance_init (HierarchicalTagIndex * self,
                                      gpointer klass)
{
	self->priv = hierarchical_tag_index_get_instance_private (self);
	self->ref_count = 1;
}

static void
hierarchical_tag_index_finalize (HierarchicalTagIndex * obj)
{
	HierarchicalTagIndex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->tag_table);
	_g_object_unref0 (self->priv->known_paths);
}

static GType
hierarchical_tag_index_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_hierarchical_tag_index_init, value_hierarchical_tag_index_free_value, value_hierarchical_tag_index_copy_value, value_hierarchical_tag_index_peek_pointer, "p", value_hierarchical_tag_index_collect_value, "p", value_hierarchical_tag_index_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HierarchicalTagIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_tag_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalTagIndex), 0, (GInstanceInitFunc) hierarchical_tag_index_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType hierarchical_tag_index_type_id;
	hierarchical_tag_index_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalTagIndex", &g_define_type_info, &g_define_type_fundamental_info, 0);
	HierarchicalTagIndex_private_offset = g_type_add_instance_private (hierarchical_tag_index_type_id, sizeof (HierarchicalTagIndexPrivate));
	return hierarchical_tag_index_type_id;
}

GType
hierarchical_tag_index_get_type (void)
{
	static volatile gsize hierarchical_tag_index_type_id__once = 0;
	if (g_once_init_enter (&hierarchical_tag_index_type_id__once)) {
		GType hierarchical_tag_index_type_id;
		hierarchical_tag_index_type_id = hierarchical_tag_index_get_type_once ();
		g_once_init_leave (&hierarchical_tag_index_type_id__once, hierarchical_tag_index_type_id);
	}
	return hierarchical_tag_index_type_id__once;
}

gpointer
hierarchical_tag_index_ref (gpointer instance)
{
	HierarchicalTagIndex * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
hierarchical_tag_index_unref (gpointer instance)
{
	HierarchicalTagIndex * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HIERARCHICAL_TAG_INDEX_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

