/* RawSupport.c generated by valac 0.56.17, the Vala compiler
 * generated from RawSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "metadata.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;

#define TYPE_RAW_FILE_FORMAT_DRIVER (raw_file_format_driver_get_type ())
#define RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver))
#define RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))
#define IS_RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_DRIVER))
#define IS_RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_DRIVER))
#define RAW_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))

typedef struct _RawFileFormatDriver RawFileFormatDriver;
typedef struct _RawFileFormatDriverClass RawFileFormatDriverClass;
typedef struct _RawFileFormatDriverPrivate RawFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

#define TYPE_RAW_FILE_FORMAT_PROPERTIES (raw_file_format_properties_get_type ())
#define RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties))
#define RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))
#define IS_RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define IS_RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define RAW_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))

typedef struct _RawFileFormatProperties RawFileFormatProperties;
typedef struct _RawFileFormatPropertiesClass RawFileFormatPropertiesClass;

#define TYPE_RAW_READER (raw_reader_get_type ())
#define RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_READER, RawReader))
#define RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_READER, RawReaderClass))
#define IS_RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_READER))
#define IS_RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_READER))
#define RAW_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_READER, RawReaderClass))

typedef struct _RawReader RawReader;
typedef struct _RawReaderClass RawReaderClass;

#define TYPE_RAW_SNIFFER (raw_sniffer_get_type ())
#define RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_SNIFFER, RawSniffer))
#define RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_SNIFFER, RawSnifferClass))
#define IS_RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_SNIFFER))
#define IS_RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_SNIFFER))
#define RAW_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_SNIFFER, RawSnifferClass))

typedef struct _RawSniffer RawSniffer;
typedef struct _RawSnifferClass RawSnifferClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())
typedef struct _RawFileFormatPropertiesPrivate RawFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef struct _RawSnifferPrivate RawSnifferPrivate;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;
typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

#define GRAW_TYPE_FLIP (graw_flip_get_type ())

#define GRAW_TYPE_EXCEPTION (graw_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _graw_processor_unref0(var) ((var == NULL) ? NULL : (var = (graw_processor_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;
typedef struct _RawReaderPrivate RawReaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))
typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _RawFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	RawFileFormatDriverPrivate * priv;
};

struct _RawFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _RawFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	RawFileFormatPropertiesPrivate * priv;
};

struct _RawFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _RawSniffer {
	PhotoFileSniffer parent_instance;
	RawSnifferPrivate * priv;
};

struct _RawSnifferClass {
	PhotoFileSnifferClass parent_class;
};

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _RawReader {
	PhotoFileReader parent_instance;
	RawReaderPrivate * priv;
};

struct _RawReaderClass {
	PhotoFileReaderClass parent_class;
};

struct _RawReaderPrivate {
	PhotoMetadata* cached_metadata;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

static gpointer raw_file_format_driver_parent_class = NULL;
static RawFileFormatDriver* raw_file_format_driver_instance;
static RawFileFormatDriver* raw_file_format_driver_instance = NULL;
static gpointer raw_file_format_properties_parent_class = NULL;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _raw_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _raw_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static RawFileFormatProperties* raw_file_format_properties_instance;
static RawFileFormatProperties* raw_file_format_properties_instance = NULL;
static gpointer raw_sniffer_parent_class = NULL;
static gint RawReader_private_offset;
static gpointer raw_reader_parent_class = NULL;

VALA_EXTERN gpointer photo_file_format_driver_ref (gpointer instance);
VALA_EXTERN void photo_file_format_driver_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_driver (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_driver (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_driver (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_driver (const GValue* value);
VALA_EXTERN GType photo_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN gpointer photo_file_format_properties_ref (gpointer instance);
VALA_EXTERN void photo_file_format_properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_properties (const GValue* value);
VALA_EXTERN GType photo_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType photo_file_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileWriter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer photo_file_sniffer_ref (gpointer instance);
VALA_EXTERN void photo_file_sniffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_sniffer (const GValue* value);
VALA_EXTERN GType photo_file_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileSniffer, photo_file_sniffer_unref)
VALA_EXTERN GType raw_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RawFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_driver_get_properties (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileReader* photo_file_format_driver_create_reader (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN PhotoMetadata* photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN gboolean photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self);
VALA_EXTERN gboolean photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileWriter* photo_file_format_driver_create_writer (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self,
                                                                          const gchar* filepath);
VALA_EXTERN PhotoFileSniffer* photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self,
                                                           GFile* file,
                                                           PhotoFileSnifferOptions options);
VALA_EXTERN void raw_file_format_driver_init (void);
VALA_EXTERN RawFileFormatDriver* raw_file_format_driver_new (void);
VALA_EXTERN RawFileFormatDriver* raw_file_format_driver_construct (GType object_type);
VALA_EXTERN void raw_file_format_properties_init (void);
VALA_EXTERN RawFileFormatDriver* raw_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
VALA_EXTERN GType raw_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RawFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN RawFileFormatProperties* raw_file_format_properties_get_instance (void);
static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
VALA_EXTERN RawReader* raw_reader_new (const gchar* filepath);
VALA_EXTERN RawReader* raw_reader_construct (GType object_type,
                                 const gchar* filepath);
VALA_EXTERN GType raw_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RawReader, photo_file_adapter_unref)
static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                             const gchar* filepath);
static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                              GFile* file,
                                                              PhotoFileSnifferOptions options);
VALA_EXTERN RawSniffer* raw_sniffer_new (GFile* file,
                             PhotoFileSnifferOptions options);
VALA_EXTERN RawSniffer* raw_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
VALA_EXTERN GType raw_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RawSniffer, photo_file_sniffer_unref)
VALA_EXTERN PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void raw_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType raw_file_format_driver_get_type_once (void);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
VALA_EXTERN PhotoFileFormatFlags photo_file_format_properties_get_flags (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self,
                                                           gint* result_length1);
VALA_EXTERN gchar* photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self,
                                                     gint* result_length1);
VALA_EXTERN RawFileFormatProperties* raw_file_format_properties_new (void);
VALA_EXTERN RawFileFormatProperties* raw_file_format_properties_construct (GType object_type);
static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                              gint* result_length1);
static gchar** _vala_array_dup11 (gchar** self,
                           gssize length);
static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                        gint* result_length1);
static gchar** _vala_array_dup12 (gchar** self,
                           gssize length);
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void raw_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType raw_file_format_properties_get_type_once (void);
VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self,
                                                    gboolean* is_corrupted,
                                                    GError** error);
VALA_EXTERN PhotoFileSniffer* photo_file_sniffer_construct (GType object_type,
                                                GFile* file,
                                                PhotoFileSnifferOptions options);
static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  gboolean* is_corrupted,
                                                  GError** error);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_new (void);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
VALA_EXTERN gpointer graw_processor_ref (gpointer instance);
VALA_EXTERN void graw_processor_unref (gpointer instance);
VALA_EXTERN GParamSpec* graw_param_spec_processor (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void graw_value_set_processor (GValue* value,
                               gpointer v_object);
VALA_EXTERN void graw_value_take_processor (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer graw_value_get_processor (const GValue* value);
VALA_EXTERN GType graw_processor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GRawProcessor, graw_processor_unref)
VALA_EXTERN GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
VALA_EXTERN GRawProcessor* graw_processor_construct (GType object_type,
                                         enum LibRaw_constructor_flags options);
VALA_EXTERN libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
VALA_EXTERN GType graw_flip_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark graw_exception_quark (void);
VALA_EXTERN GType graw_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void graw_processor_open_file (GRawProcessor* self,
                               const gchar* filename,
                               GError** error);
VALA_EXTERN void graw_processor_adjust_sizes_info_only (GRawProcessor* self,
                                            GError** error);
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
VALA_EXTERN gchar* photo_metadata_exif_hash (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
VALA_EXTERN gchar* md5_file (GFile* file,
                 GError** error);
static GType raw_sniffer_get_type_once (void);
VALA_EXTERN GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
VALA_EXTERN PhotoFileReader* photo_file_reader_construct (GType object_type,
                                              const gchar* filepath,
                                              PhotoFileFormat file_format);
static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base,
                                              GError** error);
VALA_EXTERN GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base,
                                          GError** error);
VALA_EXTERN void graw_processor_configure_for_rgb_display (GRawProcessor* self,
                                               gboolean half_size);
VALA_EXTERN gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
VALA_EXTERN void graw_processor_unpack (GRawProcessor* self,
                            GError** error);
VALA_EXTERN void graw_processor_process (GRawProcessor* self,
                             GError** error);
VALA_EXTERN gpointer graw_processed_image_ref (gpointer instance);
VALA_EXTERN void graw_processed_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* graw_param_spec_processed_image (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void graw_value_set_processed_image (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void graw_value_take_processed_image (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer graw_value_get_processed_image (const GValue* value);
VALA_EXTERN GType graw_processed_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GRawProcessedImage, graw_processed_image_unref)
VALA_EXTERN GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self,
                                                   GError** error);
VALA_EXTERN GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
VALA_EXTERN GType photo_file_reader_role_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileReaderRole photo_file_reader_get_role (PhotoFileReader* self);
VALA_EXTERN void graw_processor_unpack_thumb (GRawProcessor* self,
                                  GError** error);
VALA_EXTERN GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self,
                                                     GError** error);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void raw_reader_finalize (PhotoFileAdapter * obj);
static GType raw_reader_get_type_once (void);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RawDeveloper* raw_developer_as_array (gint* result_length1);
VALA_EXTERN gchar* raw_developer_to_string (RawDeveloper self);
VALA_EXTERN RawDeveloper raw_developer_from_string (const gchar* value);
VALA_EXTERN gchar* raw_developer_get_label (RawDeveloper self);
VALA_EXTERN gboolean raw_developer_is_equivalent (RawDeveloper self,
                                      RawDeveloper d);
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self,
                                                                   const gchar* raw_filepath,
                                                                   const gchar* camera_development_filename,
                                                                   GError** error);
VALA_EXTERN BackingPhotoRow* backing_photo_row_new (void);
VALA_EXTERN BackingPhotoRow* backing_photo_row_construct (GType object_type);
VALA_EXTERN void disassemble_filename (const gchar* basename,
                           gchar** name,
                           gchar** ext);
VALA_EXTERN gchar* library_files_convert_basename (const gchar* basename);
VALA_EXTERN GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GeeCollection* used,
                             GError** error);
VALA_EXTERN gboolean claim_file (GFile* file,
                     GError** error);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
raw_file_format_driver_init (void)
{
	RawFileFormatDriver* _tmp0_;
	_tmp0_ = raw_file_format_driver_new ();
	_photo_file_format_driver_unref0 (raw_file_format_driver_instance);
	raw_file_format_driver_instance = _tmp0_;
	raw_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

RawFileFormatDriver*
raw_file_format_driver_get_instance (void)
{
	RawFileFormatDriver* _tmp0_;
	RawFileFormatDriver* _tmp1_;
	RawFileFormatDriver* result;
	_tmp0_ = raw_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	RawFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	_tmp0_ = raw_file_format_properties_get_instance ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
	return result;
}

static PhotoFileReader*
raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	RawFileFormatDriver * self;
	RawReader* _tmp0_;
	PhotoFileReader* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = raw_reader_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
	return result;
}

static PhotoMetadata*
raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

static gboolean
raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	result = FALSE;
	return result;
}

static gboolean
raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	result = FALSE;
	return result;
}

static PhotoFileWriter*
raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	RawFileFormatDriver * self;
	PhotoFileWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileMetadataWriter*
raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                    const gchar* filepath)
{
	RawFileFormatDriver * self;
	PhotoFileMetadataWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileSniffer*
raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                            GFile* file,
                                            PhotoFileSnifferOptions options)
{
	RawFileFormatDriver * self;
	RawSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = raw_sniffer_new (file, options);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
	return result;
}

RawFileFormatDriver*
raw_file_format_driver_construct (GType object_type)
{
	RawFileFormatDriver* self = NULL;
	self = (RawFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

RawFileFormatDriver*
raw_file_format_driver_new (void)
{
	return raw_file_format_driver_construct (TYPE_RAW_FILE_FORMAT_DRIVER);
}

static void
raw_file_format_driver_class_init (RawFileFormatDriverClass * klass,
                                   gpointer klass_data)
{
	raw_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = raw_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_create_metadata;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) raw_file_format_driver_real_create_sniffer;
}

static void
raw_file_format_driver_instance_init (RawFileFormatDriver * self,
                                      gpointer klass)
{
}

static void
raw_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	RawFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (raw_file_format_driver_parent_class)->finalize (obj);
}

static GType
raw_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatDriver), 0, (GInstanceInitFunc) raw_file_format_driver_instance_init, NULL };
	GType raw_file_format_driver_type_id;
	raw_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "RawFileFormatDriver", &g_define_type_info, 0);
	return raw_file_format_driver_type_id;
}

GType
raw_file_format_driver_get_type (void)
{
	static volatile gsize raw_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&raw_file_format_driver_type_id__once)) {
		GType raw_file_format_driver_type_id;
		raw_file_format_driver_type_id = raw_file_format_driver_get_type_once ();
		g_once_init_leave (&raw_file_format_driver_type_id__once, raw_file_format_driver_type_id);
	}
	return raw_file_format_driver_type_id__once;
}

void
raw_file_format_properties_init (void)
{
	RawFileFormatProperties* _tmp0_;
	_tmp0_ = raw_file_format_properties_new ();
	_photo_file_format_properties_unref0 (raw_file_format_properties_instance);
	raw_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

RawFileFormatProperties*
raw_file_format_properties_get_instance (void)
{
	RawFileFormatProperties* _tmp0_;
	RawFileFormatProperties* _tmp1_;
	RawFileFormatProperties* result;
	_tmp0_ = raw_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	PhotoFileFormat result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	result = PHOTO_FILE_FORMAT_RAW;
	return result;
}

static gchar*
raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	_tmp0_ = g_strdup (_ ("RAW"));
	result = _tmp0_;
	return result;
}

static PhotoFileFormatFlags
raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	_tmp0_ = g_strdup ("raw");
	result = _tmp0_;
	return result;
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                      gint* result_length1)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	_tmp0_ = raw_file_format_properties_KNOWN_EXTENSIONS;
	_tmp0__length1 = raw_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup11 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                gint* result_length1)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup12 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

RawFileFormatProperties*
raw_file_format_properties_construct (GType object_type)
{
	RawFileFormatProperties* self = NULL;
	self = (RawFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

RawFileFormatProperties*
raw_file_format_properties_new (void)
{
	return raw_file_format_properties_construct (TYPE_RAW_FILE_FORMAT_PROPERTIES);
}

static void
raw_file_format_properties_class_init (RawFileFormatPropertiesClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar** _tmp91_;
	raw_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = raw_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) raw_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) raw_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("3fr");
	_tmp1_ = g_strdup ("arw");
	_tmp2_ = g_strdup ("srf");
	_tmp3_ = g_strdup ("sr2");
	_tmp4_ = g_strdup ("bay");
	_tmp5_ = g_strdup ("crw");
	_tmp6_ = g_strdup ("cr2");
	_tmp7_ = g_strdup ("cr3");
	_tmp8_ = g_strdup ("cap");
	_tmp9_ = g_strdup ("iiq");
	_tmp10_ = g_strdup ("eip");
	_tmp11_ = g_strdup ("dcs");
	_tmp12_ = g_strdup ("dcr");
	_tmp13_ = g_strdup ("drf");
	_tmp14_ = g_strdup ("k25");
	_tmp15_ = g_strdup ("kdc");
	_tmp16_ = g_strdup ("dng");
	_tmp17_ = g_strdup ("erf");
	_tmp18_ = g_strdup ("fff");
	_tmp19_ = g_strdup ("mef");
	_tmp20_ = g_strdup ("mos");
	_tmp21_ = g_strdup ("mrw");
	_tmp22_ = g_strdup ("nef");
	_tmp23_ = g_strdup ("nrw");
	_tmp24_ = g_strdup ("orf");
	_tmp25_ = g_strdup ("ptx");
	_tmp26_ = g_strdup ("pef");
	_tmp27_ = g_strdup ("pxn");
	_tmp28_ = g_strdup ("r3d");
	_tmp29_ = g_strdup ("raf");
	_tmp30_ = g_strdup ("raw");
	_tmp31_ = g_strdup ("rw2");
	_tmp32_ = g_strdup ("raw");
	_tmp33_ = g_strdup ("rwl");
	_tmp34_ = g_strdup ("rwz");
	_tmp35_ = g_strdup ("x3f");
	_tmp36_ = g_strdup ("srw");
	_tmp37_ = g_new0 (gchar*, 37 + 1);
	_tmp37_[0] = _tmp0_;
	_tmp37_[1] = _tmp1_;
	_tmp37_[2] = _tmp2_;
	_tmp37_[3] = _tmp3_;
	_tmp37_[4] = _tmp4_;
	_tmp37_[5] = _tmp5_;
	_tmp37_[6] = _tmp6_;
	_tmp37_[7] = _tmp7_;
	_tmp37_[8] = _tmp8_;
	_tmp37_[9] = _tmp9_;
	_tmp37_[10] = _tmp10_;
	_tmp37_[11] = _tmp11_;
	_tmp37_[12] = _tmp12_;
	_tmp37_[13] = _tmp13_;
	_tmp37_[14] = _tmp14_;
	_tmp37_[15] = _tmp15_;
	_tmp37_[16] = _tmp16_;
	_tmp37_[17] = _tmp17_;
	_tmp37_[18] = _tmp18_;
	_tmp37_[19] = _tmp19_;
	_tmp37_[20] = _tmp20_;
	_tmp37_[21] = _tmp21_;
	_tmp37_[22] = _tmp22_;
	_tmp37_[23] = _tmp23_;
	_tmp37_[24] = _tmp24_;
	_tmp37_[25] = _tmp25_;
	_tmp37_[26] = _tmp26_;
	_tmp37_[27] = _tmp27_;
	_tmp37_[28] = _tmp28_;
	_tmp37_[29] = _tmp29_;
	_tmp37_[30] = _tmp30_;
	_tmp37_[31] = _tmp31_;
	_tmp37_[32] = _tmp32_;
	_tmp37_[33] = _tmp33_;
	_tmp37_[34] = _tmp34_;
	_tmp37_[35] = _tmp35_;
	_tmp37_[36] = _tmp36_;
	raw_file_format_properties_KNOWN_EXTENSIONS = _tmp37_;
	raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 37;
	_raw_file_format_properties_KNOWN_EXTENSIONS_size_ = raw_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp38_ = g_strdup ("image/x-dcraw");
	_tmp39_ = g_strdup ("image/x-canon-cr2");
	_tmp40_ = g_strdup ("image/x-canon-cr3");
	_tmp41_ = g_strdup ("image/x-canon-crw");
	_tmp42_ = g_strdup ("image/x-fuji-raf");
	_tmp43_ = g_strdup ("image/x-adobe-dng");
	_tmp44_ = g_strdup ("image/x-panasonic-raw");
	_tmp45_ = g_strdup ("image/x-raw");
	_tmp46_ = g_strdup ("image/x-minolta-mrw");
	_tmp47_ = g_strdup ("image/x-nikon-nef");
	_tmp48_ = g_strdup ("image/x-olympus-orf");
	_tmp49_ = g_strdup ("image/x-pentax-pef");
	_tmp50_ = g_strdup ("image/x-sony-arw");
	_tmp51_ = g_strdup ("image/x-sony-srf");
	_tmp52_ = g_strdup ("image/x-sony-sr2");
	_tmp53_ = g_strdup ("image/x-samsung-raw");
	_tmp54_ = g_strdup ("image/x-3fr");
	_tmp55_ = g_strdup ("image/x-arw");
	_tmp56_ = g_strdup ("image/x-srf");
	_tmp57_ = g_strdup ("image/x-sr2");
	_tmp58_ = g_strdup ("image/x-bay");
	_tmp59_ = g_strdup ("image/x-crw");
	_tmp60_ = g_strdup ("image/x-cr2");
	_tmp61_ = g_strdup ("image/x-cr3");
	_tmp62_ = g_strdup ("image/x-cap");
	_tmp63_ = g_strdup ("image/x-iiq");
	_tmp64_ = g_strdup ("image/x-eip");
	_tmp65_ = g_strdup ("image/x-dcs");
	_tmp66_ = g_strdup ("image/x-dcr");
	_tmp67_ = g_strdup ("image/x-drf");
	_tmp68_ = g_strdup ("image/x-k25");
	_tmp69_ = g_strdup ("image/x-kdc");
	_tmp70_ = g_strdup ("image/x-dng");
	_tmp71_ = g_strdup ("image/x-erf");
	_tmp72_ = g_strdup ("image/x-fff");
	_tmp73_ = g_strdup ("image/x-mef");
	_tmp74_ = g_strdup ("image/x-mos");
	_tmp75_ = g_strdup ("image/x-mrw");
	_tmp76_ = g_strdup ("image/x-nef");
	_tmp77_ = g_strdup ("image/x-nrw");
	_tmp78_ = g_strdup ("image/x-orf");
	_tmp79_ = g_strdup ("image/x-ptx");
	_tmp80_ = g_strdup ("image/x-pef");
	_tmp81_ = g_strdup ("image/x-pxn");
	_tmp82_ = g_strdup ("image/x-r3d");
	_tmp83_ = g_strdup ("image/x-raf");
	_tmp84_ = g_strdup ("image/x-raw");
	_tmp85_ = g_strdup ("image/x-rw2");
	_tmp86_ = g_strdup ("image/x-raw");
	_tmp87_ = g_strdup ("image/x-rwl");
	_tmp88_ = g_strdup ("image/x-rwz");
	_tmp89_ = g_strdup ("image/x-x3f");
	_tmp90_ = g_strdup ("image/x-srw");
	_tmp91_ = g_new0 (gchar*, 53 + 1);
	_tmp91_[0] = _tmp38_;
	_tmp91_[1] = _tmp39_;
	_tmp91_[2] = _tmp40_;
	_tmp91_[3] = _tmp41_;
	_tmp91_[4] = _tmp42_;
	_tmp91_[5] = _tmp43_;
	_tmp91_[6] = _tmp44_;
	_tmp91_[7] = _tmp45_;
	_tmp91_[8] = _tmp46_;
	_tmp91_[9] = _tmp47_;
	_tmp91_[10] = _tmp48_;
	_tmp91_[11] = _tmp49_;
	_tmp91_[12] = _tmp50_;
	_tmp91_[13] = _tmp51_;
	_tmp91_[14] = _tmp52_;
	_tmp91_[15] = _tmp53_;
	_tmp91_[16] = _tmp54_;
	_tmp91_[17] = _tmp55_;
	_tmp91_[18] = _tmp56_;
	_tmp91_[19] = _tmp57_;
	_tmp91_[20] = _tmp58_;
	_tmp91_[21] = _tmp59_;
	_tmp91_[22] = _tmp60_;
	_tmp91_[23] = _tmp61_;
	_tmp91_[24] = _tmp62_;
	_tmp91_[25] = _tmp63_;
	_tmp91_[26] = _tmp64_;
	_tmp91_[27] = _tmp65_;
	_tmp91_[28] = _tmp66_;
	_tmp91_[29] = _tmp67_;
	_tmp91_[30] = _tmp68_;
	_tmp91_[31] = _tmp69_;
	_tmp91_[32] = _tmp70_;
	_tmp91_[33] = _tmp71_;
	_tmp91_[34] = _tmp72_;
	_tmp91_[35] = _tmp73_;
	_tmp91_[36] = _tmp74_;
	_tmp91_[37] = _tmp75_;
	_tmp91_[38] = _tmp76_;
	_tmp91_[39] = _tmp77_;
	_tmp91_[40] = _tmp78_;
	_tmp91_[41] = _tmp79_;
	_tmp91_[42] = _tmp80_;
	_tmp91_[43] = _tmp81_;
	_tmp91_[44] = _tmp82_;
	_tmp91_[45] = _tmp83_;
	_tmp91_[46] = _tmp84_;
	_tmp91_[47] = _tmp85_;
	_tmp91_[48] = _tmp86_;
	_tmp91_[49] = _tmp87_;
	_tmp91_[50] = _tmp88_;
	_tmp91_[51] = _tmp89_;
	_tmp91_[52] = _tmp90_;
	raw_file_format_properties_KNOWN_MIME_TYPES = _tmp91_;
	raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 53;
	_raw_file_format_properties_KNOWN_MIME_TYPES_size_ = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
}

static void
raw_file_format_properties_instance_init (RawFileFormatProperties * self,
                                          gpointer klass)
{
}

static void
raw_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	RawFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (raw_file_format_properties_parent_class)->finalize (obj);
}

static GType
raw_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatProperties), 0, (GInstanceInitFunc) raw_file_format_properties_instance_init, NULL };
	GType raw_file_format_properties_type_id;
	raw_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "RawFileFormatProperties", &g_define_type_info, 0);
	return raw_file_format_properties_type_id;
}

GType
raw_file_format_properties_get_type (void)
{
	static volatile gsize raw_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&raw_file_format_properties_type_id__once)) {
		GType raw_file_format_properties_type_id;
		raw_file_format_properties_type_id = raw_file_format_properties_get_type_once ();
		g_once_init_leave (&raw_file_format_properties_type_id__once, raw_file_format_properties_type_id);
	}
	return raw_file_format_properties_type_id__once;
}

RawSniffer*
raw_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	RawSniffer* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (RawSniffer*) photo_file_sniffer_construct (object_type, file, options);
	return self;
}

RawSniffer*
raw_sniffer_new (GFile* file,
                 PhotoFileSnifferOptions options)
{
	return raw_sniffer_construct (TYPE_RAW_SNIFFER, file, options);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static DetectedPhotoInformation*
raw_sniffer_real_sniff (PhotoFileSniffer* base,
                        gboolean* is_corrupted,
                        GError** error)
{
	RawSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp0_;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	DetectedPhotoInformation* _tmp13_;
	GRawProcessor* _tmp14_;
	GRawProcessor* _tmp15_;
	DetectedPhotoInformation* _tmp16_;
	DetectedPhotoInformation* _tmp17_;
	DetectedPhotoInformation* _tmp18_;
	RawReader* reader = NULL;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	RawReader* _tmp22_;
	RawReader* _tmp23_;
	gboolean _tmp29_ = FALSE;
	DetectedPhotoInformation* _tmp45_;
	gchar* _tmp46_;
	DetectedPhotoInformation* _tmp47_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_SNIFFER, RawSniffer);
	_vala_is_corrupted = FALSE;
	_tmp0_ = detected_photo_information_new ();
	detected = _tmp0_;
	_tmp1_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp1_;
	_tmp2_ = processor;
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
	_tmp4_ = _tmp3_;
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
	{
		GRawProcessor* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRawProcessor* _tmp9_;
		_tmp5_ = processor;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		graw_processor_open_file (_tmp5_, _tmp8_, &_inner_error0_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				goto __catch0_graw_exception;
			}
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp9_ = processor;
		graw_processor_adjust_sizes_info_only (_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				goto __catch0_graw_exception;
			}
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_graw_exception:
	{
		GError* exception = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		exception = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = exception;
		if (g_error_matches (_tmp10_, GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE)) {
			result = NULL;
			_g_error_free0 (exception);
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			if (is_corrupted) {
				*is_corrupted = _vala_is_corrupted;
			}
			return result;
		}
		_tmp11_ = exception;
		_tmp12_ = _g_error_copy0 (_tmp11_);
		_inner_error0_ = _tmp12_;
		_g_error_free0 (exception);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		_detected_photo_information_unref0 (detected);
		return NULL;
	}
	_tmp13_ = detected;
	_tmp14_ = processor;
	_tmp15_ = processor;
	dimensions_init (&_tmp13_->image_dim, (gint) graw_processor_get_sizes (_tmp14_).iwidth, (gint) graw_processor_get_sizes (_tmp15_).iheight);
	_tmp16_ = detected;
	_tmp16_->colorspace = GDK_COLORSPACE_RGB;
	_tmp17_ = detected;
	_tmp17_->channels = 3;
	_tmp18_ = detected;
	_tmp18_->bits_per_channel = 8;
	_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
	_tmp20_ = g_file_get_path (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = raw_reader_new (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	reader = _tmp23_;
	{
		PhotoMetadata* _tmp24_ = NULL;
		RawReader* _tmp25_;
		PhotoMetadata* _tmp26_;
		DetectedPhotoInformation* _tmp27_;
		PhotoMetadata* _tmp28_;
		_tmp25_ = reader;
		_tmp26_ = photo_file_reader_read_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO_FILE_READER, PhotoFileReader), &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp27_ = detected;
		_tmp28_ = _tmp24_;
		_tmp24_ = NULL;
		_media_metadata_unref0 (_tmp27_->metadata);
		_tmp27_->metadata = _tmp28_;
		_media_metadata_unref0 (_tmp24_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (reader);
		_graw_processor_unref0 (processor);
		_detected_photo_information_unref0 (detected);
		return NULL;
	}
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		DetectedPhotoInformation* _tmp30_;
		PhotoMetadata* _tmp31_;
		_tmp30_ = detected;
		_tmp31_ = _tmp30_->metadata;
		_tmp29_ = _tmp31_ != NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		DetectedPhotoInformation* _tmp32_;
		DetectedPhotoInformation* _tmp33_;
		PhotoMetadata* _tmp34_;
		gchar* _tmp35_;
		DetectedPhotoInformation* _tmp36_;
		DetectedPhotoInformation* _tmp37_;
		PhotoMetadata* _tmp38_;
		gchar* _tmp39_;
		_tmp32_ = detected;
		_tmp33_ = detected;
		_tmp34_ = _tmp33_->metadata;
		_tmp35_ = photo_metadata_exif_hash (_tmp34_);
		_g_free0 (_tmp32_->exif_md5);
		_tmp32_->exif_md5 = _tmp35_;
		_tmp36_ = detected;
		_tmp37_ = detected;
		_tmp38_ = _tmp37_->metadata;
		_tmp39_ = photo_metadata_thumbnail_hash (_tmp38_);
		_g_free0 (_tmp36_->thumbnail_md5);
		_tmp36_->thumbnail_md5 = _tmp39_;
	}
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		gchar* _tmp40_ = NULL;
		GFile* _tmp41_;
		gchar* _tmp42_;
		DetectedPhotoInformation* _tmp43_;
		gchar* _tmp44_;
		_tmp41_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
		_tmp42_ = md5_file (_tmp41_, &_inner_error0_);
		_tmp40_ = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (reader);
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			return NULL;
		}
		_tmp43_ = detected;
		_tmp44_ = _tmp40_;
		_tmp40_ = NULL;
		_g_free0 (_tmp43_->md5);
		_tmp43_->md5 = _tmp44_;
		_g_free0 (_tmp40_);
	}
	_tmp45_ = detected;
	_tmp46_ = g_strdup ("raw");
	_g_free0 (_tmp45_->format_name);
	_tmp45_->format_name = _tmp46_;
	_tmp47_ = detected;
	_tmp47_->file_format = PHOTO_FILE_FORMAT_RAW;
	result = detected;
	_photo_file_adapter_unref0 (reader);
	_graw_processor_unref0 (processor);
	if (is_corrupted) {
		*is_corrupted = _vala_is_corrupted;
	}
	return result;
}

static void
raw_sniffer_class_init (RawSnifferClass * klass,
                        gpointer klass_data)
{
	raw_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, gboolean*, GError**)) raw_sniffer_real_sniff;
}

static void
raw_sniffer_instance_init (RawSniffer * self,
                           gpointer klass)
{
}

static GType
raw_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawSniffer), 0, (GInstanceInitFunc) raw_sniffer_instance_init, NULL };
	GType raw_sniffer_type_id;
	raw_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "RawSniffer", &g_define_type_info, 0);
	return raw_sniffer_type_id;
}

GType
raw_sniffer_get_type (void)
{
	static volatile gsize raw_sniffer_type_id__once = 0;
	if (g_once_init_enter (&raw_sniffer_type_id__once)) {
		GType raw_sniffer_type_id;
		raw_sniffer_type_id = raw_sniffer_get_type_once ();
		g_once_init_leave (&raw_sniffer_type_id__once, raw_sniffer_type_id);
	}
	return raw_sniffer_type_id__once;
}

static inline gpointer
raw_reader_get_instance_private (RawReader* self)
{
	return G_STRUCT_MEMBER_P (self, RawReader_private_offset);
}

RawReader*
raw_reader_construct (GType object_type,
                      const gchar* filepath)
{
	RawReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (RawReader*) photo_file_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_RAW);
	return self;
}

RawReader*
raw_reader_new (const gchar* filepath)
{
	return raw_reader_construct (TYPE_RAW_READER, filepath);
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

static PhotoMetadata*
raw_reader_real_read_metadata (PhotoFileReader* base,
                               GError** error)
{
	RawReader * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp7_;
	PhotoMetadata* _tmp8_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
	_tmp0_ = self->priv->cached_metadata;
	if (_tmp0_ == NULL) {
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp1_;
		PhotoMetadata* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		PhotoMetadata* _tmp5_;
		PhotoMetadata* _tmp6_;
		_tmp1_ = photo_metadata_new ();
		metadata = _tmp1_;
		_tmp2_ = metadata;
		_tmp3_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp4_ = _tmp3_;
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp4_, &_inner_error0_);
		_g_object_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_media_metadata_unref0 (metadata);
			return NULL;
		}
		_tmp5_ = metadata;
		_tmp6_ = _media_metadata_ref0 (_tmp5_);
		_media_metadata_unref0 (self->priv->cached_metadata);
		self->priv->cached_metadata = _tmp6_;
		_media_metadata_unref0 (metadata);
	}
	_tmp7_ = self->priv->cached_metadata;
	_tmp8_ = _media_metadata_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

static GdkPixbuf*
raw_reader_real_unscaled_read (PhotoFileReader* base,
                               GError** error)
{
	RawReader * self;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp0_;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	GRawProcessor* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GRawProcessor* _tmp8_;
	GRawProcessor* _tmp9_;
	GRawProcessedImage* _tmp10_ = NULL;
	GRawProcessor* _tmp11_;
	GRawProcessedImage* _tmp12_;
	GdkPixbuf* _tmp13_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
	_tmp0_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp0_;
	_tmp1_ = processor;
	graw_processor_configure_for_rgb_display (_tmp1_, FALSE);
	_tmp2_ = processor;
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
	_tmp4_ = _tmp3_;
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
	_tmp5_ = processor;
	_tmp6_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp7_ = _tmp6_;
	graw_processor_open_file (_tmp5_, _tmp7_, &_inner_error0_);
	_g_free0 (_tmp7_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp8_ = processor;
	graw_processor_unpack (_tmp8_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp9_ = processor;
	graw_processor_process (_tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp11_ = processor;
	_tmp12_ = graw_processor_make_mem_image (_tmp11_, &_inner_error0_);
	_tmp10_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp13_ = graw_processed_image_get_pixbuf_copy (_tmp10_);
	result = _tmp13_;
	_graw_processed_image_unref0 (_tmp10_);
	_graw_processor_unref0 (processor);
	return result;
}

static GdkPixbuf*
raw_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	RawReader * self;
	gdouble width_proportion = 0.0;
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	gdouble height_proportion = 0.0;
	Dimensions _tmp2_;
	Dimensions _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean half_size = FALSE;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp5_;
	GRawProcessor* _tmp6_;
	GRawProcessor* _tmp7_;
	libraw_output_params_t* _tmp8_;
	libraw_output_params_t* _tmp9_;
	GRawProcessor* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GRawProcessor* _tmp22_;
	GRawProcessor* _tmp23_;
	GRawProcessedImage* image = NULL;
	GRawProcessor* _tmp24_;
	GRawProcessedImage* _tmp25_;
	GRawProcessedImage* _tmp26_;
	GdkPixbuf* _tmp27_;
	GdkPixbuf* _tmp28_;
	Dimensions _tmp29_;
	GdkPixbuf* _tmp30_;
	GdkPixbuf* _tmp31_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_tmp0_ = *scaled;
	_tmp1_ = *full;
	width_proportion = ((gdouble) _tmp0_.width) / ((gdouble) _tmp1_.width);
	_tmp2_ = *scaled;
	_tmp3_ = *full;
	height_proportion = ((gdouble) _tmp2_.height) / ((gdouble) _tmp3_.height);
	if (width_proportion < 0.5) {
		_tmp4_ = height_proportion < 0.5;
	} else {
		_tmp4_ = FALSE;
	}
	half_size = _tmp4_;
	_tmp5_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp5_;
	_tmp6_ = processor;
	graw_processor_configure_for_rgb_display (_tmp6_, half_size);
	_tmp7_ = processor;
	_tmp8_ = graw_processor_get_output_params (_tmp7_);
	_tmp9_ = _tmp8_;
	(*_tmp9_).user_flip = (gint) GRAW_FLIP_NONE;
	_tmp10_ = processor;
	_tmp11_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp12_ = _tmp11_;
	graw_processor_open_file (_tmp10_, _tmp12_, &_inner_error0_);
	_g_free0 (_tmp12_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	{
		if (photo_file_reader_get_role (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_READER, PhotoFileReader)) == PHOTO_FILE_READER_ROLE_THUMBNAIL) {
			GRawProcessor* _tmp13_;
			GRawProcessedImage* image = NULL;
			GRawProcessor* _tmp14_;
			GRawProcessedImage* _tmp15_;
			GRawProcessedImage* _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkPixbuf* _tmp18_;
			Dimensions _tmp19_;
			GdkPixbuf* _tmp20_;
			GdkPixbuf* _tmp21_;
			_tmp13_ = processor;
			graw_processor_unpack_thumb (_tmp13_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp14_ = processor;
			_tmp15_ = graw_processor_make_thumb_image (_tmp14_, &_inner_error0_);
			image = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp16_ = image;
			_tmp17_ = graw_processed_image_get_pixbuf_copy (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = *scaled;
			_tmp20_ = resize_pixbuf (_tmp18_, &_tmp19_, GDK_INTERP_BILINEAR);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp18_);
			result = _tmp21_;
			_graw_processed_image_unref0 (image);
			_graw_processor_unref0 (processor);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp22_ = processor;
	graw_processor_unpack (_tmp22_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp23_ = processor;
	graw_processor_process (_tmp23_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp24_ = processor;
	_tmp25_ = graw_processor_make_mem_image (_tmp24_, &_inner_error0_);
	image = _tmp25_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp26_ = image;
	_tmp27_ = graw_processed_image_get_pixbuf_copy (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = *scaled;
	_tmp30_ = resize_pixbuf (_tmp28_, &_tmp29_, GDK_INTERP_BILINEAR);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (_tmp28_);
	result = _tmp31_;
	_graw_processed_image_unref0 (image);
	_graw_processor_unref0 (processor);
	return result;
}

static void
raw_reader_class_init (RawReaderClass * klass,
                       gpointer klass_data)
{
	raw_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileAdapterClass *) klass)->finalize = raw_reader_finalize;
	g_type_class_adjust_private_offset (klass, &RawReader_private_offset);
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) raw_reader_real_read_metadata;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) raw_reader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) raw_reader_real_scaled_read;
}

static void
raw_reader_instance_init (RawReader * self,
                          gpointer klass)
{
	self->priv = raw_reader_get_instance_private (self);
	self->priv->cached_metadata = NULL;
}

static void
raw_reader_finalize (PhotoFileAdapter * obj)
{
	RawReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_READER, RawReader);
	_media_metadata_unref0 (self->priv->cached_metadata);
	PHOTO_FILE_ADAPTER_CLASS (raw_reader_parent_class)->finalize (obj);
}

static GType
raw_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawReader), 0, (GInstanceInitFunc) raw_reader_instance_init, NULL };
	GType raw_reader_type_id;
	raw_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "RawReader", &g_define_type_info, 0);
	RawReader_private_offset = g_type_add_instance_private (raw_reader_type_id, sizeof (RawReaderPrivate));
	return raw_reader_type_id;
}

GType
raw_reader_get_type (void)
{
	static volatile gsize raw_reader_type_id__once = 0;
	if (g_once_init_enter (&raw_reader_type_id__once)) {
		GType raw_reader_type_id;
		raw_reader_type_id = raw_reader_get_type_once ();
		g_once_init_leave (&raw_reader_type_id__once, raw_reader_type_id);
	}
	return raw_reader_type_id__once;
}

RawDeveloper*
raw_developer_as_array (gint* result_length1)
{
	RawDeveloper* _tmp0_;
	RawDeveloper* _tmp1_;
	gint _tmp1__length1;
	RawDeveloper* result;
	_tmp0_ = g_new0 (RawDeveloper, 3);
	_tmp0_[0] = RAW_DEVELOPER_SHOTWELL;
	_tmp0_[1] = RAW_DEVELOPER_CAMERA;
	_tmp0_[2] = RAW_DEVELOPER_EMBEDDED;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
raw_developer_to_string (RawDeveloper self)
{
	gchar* result;
	switch (self) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SHOTWELL");
			result = _tmp0_;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("CAMERA");
			result = _tmp1_;
			return result;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("EMBEDDED");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

RawDeveloper
raw_developer_from_string (const gchar* value)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	RawDeveloper result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = value;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("SHOTWELL")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_SHOTWELL;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("CAMERA")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_CAMERA;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("EMBEDDED")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_EMBEDDED;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

gchar*
raw_developer_get_label (RawDeveloper self)
{
	gchar* result;
	switch (self) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Shotwell"));
			result = _tmp0_;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Camera"));
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gboolean
raw_developer_is_equivalent (RawDeveloper self,
                             RawDeveloper d)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (self == d) {
		result = TRUE;
		return result;
	}
	if (self == RAW_DEVELOPER_CAMERA) {
		_tmp1_ = d == RAW_DEVELOPER_EMBEDDED;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self == RAW_DEVELOPER_EMBEDDED) {
			_tmp2_ = d == RAW_DEVELOPER_CAMERA;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

BackingPhotoRow*
raw_developer_create_backing_row_for_development (RawDeveloper self,
                                                  const gchar* raw_filepath,
                                                  const gchar* camera_development_filename,
                                                  GError** error)
{
	BackingPhotoRow* ns = NULL;
	BackingPhotoRow* _tmp0_;
	GFile* master = NULL;
	GFile* _tmp1_;
	gchar* name = NULL;
	gchar* ext = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* basename = NULL;
	gchar* newbasename = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean c = FALSE;
	GFile* new_back = NULL;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GFile* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	BackingPhotoRow* _tmp34_;
	BackingPhotoRow* _tmp35_;
	GFile* _tmp36_;
	gchar* _tmp37_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (raw_filepath != NULL, NULL);
	_tmp0_ = backing_photo_row_new ();
	ns = _tmp0_;
	_tmp1_ = g_file_new_for_path (raw_filepath);
	master = _tmp1_;
	_tmp2_ = master;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	disassemble_filename (_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (name);
	name = _tmp5_;
	_g_free0 (ext);
	ext = _tmp6_;
	_g_free0 (_tmp4_);
	if (camera_development_filename == NULL) {
		gchar* _tmp7_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		if (self != RAW_DEVELOPER_CAMERA) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = raw_developer_to_string (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("_", _tmp11_, NULL);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp13_;
		}
		_tmp14_ = name;
		_tmp15_ = g_strconcat (_tmp14_, "_", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = ext;
		_tmp18_ = g_strconcat (_tmp16_, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, _tmp7_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ".jpg", NULL);
		_g_free0 (basename);
		basename = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp7_);
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup (camera_development_filename);
		_g_free0 (basename);
		basename = _tmp23_;
	}
	_tmp24_ = basename;
	_tmp25_ = library_files_convert_basename (_tmp24_);
	newbasename = _tmp25_;
	_tmp26_ = master;
	_tmp27_ = g_file_get_parent (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = newbasename;
	_tmp31_ = generate_unique_file (_tmp28_, _tmp29_, &_tmp30_, NULL, &_inner_error0_);
	c = _tmp30_;
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp28_);
	new_back = _tmp32_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (newbasename);
		_g_free0 (basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (master);
		_backing_photo_row_unref0 (ns);
		return NULL;
	}
	_tmp33_ = new_back;
	claim_file (_tmp33_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (new_back);
		_g_free0 (newbasename);
		_g_free0 (basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (master);
		_backing_photo_row_unref0 (ns);
		return NULL;
	}
	_tmp34_ = ns;
	_tmp34_->file_format = PHOTO_FILE_FORMAT_JFIF;
	_tmp35_ = ns;
	_tmp36_ = new_back;
	_tmp37_ = g_file_get_path (_tmp36_);
	_g_free0 (_tmp35_->filepath);
	_tmp35_->filepath = _tmp37_;
	result = ns;
	_g_object_unref0 (new_back);
	_g_free0 (newbasename);
	_g_free0 (basename);
	_g_free0 (ext);
	_g_free0 (name);
	_g_object_unref0 (master);
	return result;
}

static GType
raw_developer_get_type_once (void)
{
	static const GEnumValue values[] = {{RAW_DEVELOPER_SHOTWELL, "RAW_DEVELOPER_SHOTWELL", "shotwell"}, {RAW_DEVELOPER_CAMERA, "RAW_DEVELOPER_CAMERA", "camera"}, {RAW_DEVELOPER_EMBEDDED, "RAW_DEVELOPER_EMBEDDED", "embedded"}, {0, NULL, NULL}};
	GType raw_developer_type_id;
	raw_developer_type_id = g_enum_register_static ("RawDeveloper", values);
	return raw_developer_type_id;
}

GType
raw_developer_get_type (void)
{
	static volatile gsize raw_developer_type_id__once = 0;
	if (g_once_init_enter (&raw_developer_type_id__once)) {
		GType raw_developer_type_id;
		raw_developer_type_id = raw_developer_get_type_once ();
		g_once_init_leave (&raw_developer_type_id__once, raw_developer_type_id);
	}
	return raw_developer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

