/* PngSupport.c generated by valac 0.56.17, the Vala compiler
 * generated from PngSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "metadata.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())

#define TYPE_PNG_FILE_FORMAT_PROPERTIES (png_file_format_properties_get_type ())
#define PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties))
#define PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))
#define IS_PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define IS_PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define PNG_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))

typedef struct _PngFileFormatProperties PngFileFormatProperties;
typedef struct _PngFileFormatPropertiesClass PngFileFormatPropertiesClass;
typedef struct _PngFileFormatPropertiesPrivate PngFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;

#define TYPE_PNG_SNIFFER (png_sniffer_get_type ())
#define PNG_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_SNIFFER, PngSniffer))
#define PNG_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_SNIFFER, PngSnifferClass))
#define IS_PNG_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_SNIFFER))
#define IS_PNG_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_SNIFFER))
#define PNG_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_SNIFFER, PngSnifferClass))

typedef struct _PngSniffer PngSniffer;
typedef struct _PngSnifferClass PngSnifferClass;
typedef struct _PngSnifferPrivate PngSnifferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;

#define TYPE_PNG_READER (png_reader_get_type ())
#define PNG_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_READER, PngReader))
#define PNG_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_READER, PngReaderClass))
#define IS_PNG_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_READER))
#define IS_PNG_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_READER))
#define PNG_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_READER, PngReaderClass))

typedef struct _PngReader PngReader;
typedef struct _PngReaderClass PngReaderClass;
typedef struct _PngReaderPrivate PngReaderPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
typedef struct _PhotoFileWriterPrivate PhotoFileWriterPrivate;
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PNG_WRITER (png_writer_get_type ())
#define PNG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_WRITER, PngWriter))
#define PNG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_WRITER, PngWriterClass))
#define IS_PNG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_WRITER))
#define IS_PNG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_WRITER))
#define PNG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_WRITER, PngWriterClass))

typedef struct _PngWriter PngWriter;
typedef struct _PngWriterClass PngWriterClass;
typedef struct _PngWriterPrivate PngWriterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
typedef struct _PhotoFileMetadataWriterPrivate PhotoFileMetadataWriterPrivate;

#define TYPE_PNG_METADATA_WRITER (png_metadata_writer_get_type ())
#define PNG_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_METADATA_WRITER, PngMetadataWriter))
#define PNG_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_METADATA_WRITER, PngMetadataWriterClass))
#define IS_PNG_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_METADATA_WRITER))
#define IS_PNG_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_METADATA_WRITER))
#define PNG_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_METADATA_WRITER, PngMetadataWriterClass))

typedef struct _PngMetadataWriter PngMetadataWriter;
typedef struct _PngMetadataWriterClass PngMetadataWriterClass;
typedef struct _PngMetadataWriterPrivate PngMetadataWriterPrivate;

#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PNG_FILE_FORMAT_DRIVER (png_file_format_driver_get_type ())
#define PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver))
#define PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))
#define IS_PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_DRIVER))
#define IS_PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_DRIVER))
#define PNG_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))

typedef struct _PngFileFormatDriver PngFileFormatDriver;
typedef struct _PngFileFormatDriverClass PngFileFormatDriverClass;
typedef struct _PngFileFormatDriverPrivate PngFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _PngFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	PngFileFormatPropertiesPrivate * priv;
};

struct _PngFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _PngSniffer {
	GdkSniffer parent_instance;
	PngSnifferPrivate * priv;
};

struct _PngSnifferClass {
	GdkSnifferClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

struct _PngReader {
	GdkReader parent_instance;
	PngReaderPrivate * priv;
};

struct _PngReaderClass {
	GdkReaderClass parent_class;
};

struct _PhotoFileWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileWriterPrivate * priv;
};

struct _PhotoFileWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write) (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
};

struct _PngWriter {
	PhotoFileWriter parent_instance;
	PngWriterPrivate * priv;
};

struct _PngWriterClass {
	PhotoFileWriterClass parent_class;
};

struct _PhotoFileMetadataWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileMetadataWriterPrivate * priv;
};

struct _PhotoFileMetadataWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write_metadata) (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
};

struct _PngMetadataWriter {
	PhotoFileMetadataWriter parent_instance;
	PngMetadataWriterPrivate * priv;
};

struct _PngMetadataWriterClass {
	PhotoFileMetadataWriterClass parent_class;
};

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _PngFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	PngFileFormatDriverPrivate * priv;
};

struct _PngFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};

static gpointer png_file_format_properties_parent_class = NULL;
static gchar** png_file_format_properties_KNOWN_EXTENSIONS;
static gint png_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** png_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint png_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _png_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** png_file_format_properties_KNOWN_MIME_TYPES;
static gint png_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** png_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint png_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _png_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static PngFileFormatProperties* png_file_format_properties_instance;
static PngFileFormatProperties* png_file_format_properties_instance = NULL;
static gpointer png_sniffer_parent_class = NULL;
static gpointer png_reader_parent_class = NULL;
static gpointer png_writer_parent_class = NULL;
static gpointer png_metadata_writer_parent_class = NULL;
static gpointer png_file_format_driver_parent_class = NULL;
static PngFileFormatDriver* png_file_format_driver_instance;
static PngFileFormatDriver* png_file_format_driver_instance = NULL;

VALA_EXTERN gpointer photo_file_format_properties_ref (gpointer instance);
VALA_EXTERN void photo_file_format_properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_properties (const GValue* value);
VALA_EXTERN GType photo_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType png_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN PhotoFileFormat photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self);
VALA_EXTERN PhotoFileFormatFlags photo_file_format_properties_get_flags (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self,
                                                           gint* result_length1);
VALA_EXTERN gchar* photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self,
                                                     gint* result_length1);
VALA_EXTERN void png_file_format_properties_init (void);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_new (void);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_construct (GType object_type);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_get_instance (void);
static PhotoFileFormat png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                              gint* result_length1);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static gchar* png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                        gint* result_length1);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void png_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType png_file_format_properties_get_type_once (void);
VALA_EXTERN gpointer photo_file_sniffer_ref (gpointer instance);
VALA_EXTERN void photo_file_sniffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_sniffer (const GValue* value);
VALA_EXTERN GType photo_file_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileSniffer, photo_file_sniffer_unref)
VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gdk_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkSniffer, photo_file_sniffer_unref)
VALA_EXTERN GType png_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngSniffer, photo_file_sniffer_unref)
VALA_EXTERN DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self,
                                                    gboolean* is_corrupted,
                                                    GError** error);
VALA_EXTERN PngSniffer* png_sniffer_new (GFile* file,
                             PhotoFileSnifferOptions options);
VALA_EXTERN PngSniffer* png_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
VALA_EXTERN GdkSniffer* gdk_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
static gboolean png_sniffer_is_png_file (GFile* file,
                                  GError** error);
static DetectedPhotoInformation* png_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  gboolean* is_corrupted,
                                                  GError** error);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
static GType png_sniffer_get_type_once (void);
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType gdk_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkReader, photo_file_adapter_unref)
VALA_EXTERN GType png_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngReader, photo_file_adapter_unref)
VALA_EXTERN PngReader* png_reader_new (const gchar* filepath);
VALA_EXTERN PngReader* png_reader_construct (GType object_type,
                                 const gchar* filepath);
VALA_EXTERN GdkReader* gdk_reader_construct (GType object_type,
                                 const gchar* filepath,
                                 PhotoFileFormat file_format);
static GType png_reader_get_type_once (void);
VALA_EXTERN GType photo_file_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileWriter, photo_file_adapter_unref)
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType png_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngWriter, photo_file_adapter_unref)
VALA_EXTERN void photo_file_writer_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error);
VALA_EXTERN PngWriter* png_writer_new (const gchar* filepath);
VALA_EXTERN PngWriter* png_writer_construct (GType object_type,
                                 const gchar* filepath);
VALA_EXTERN PhotoFileWriter* photo_file_writer_construct (GType object_type,
                                              const gchar* filepath,
                                              PhotoFileFormat file_format);
static void png_writer_real_write (PhotoFileWriter* base,
                            GdkPixbuf* pixbuf,
                            JpegQuality quality,
                            GError** error);
VALA_EXTERN gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static GType png_writer_get_type_once (void);
VALA_EXTERN GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN GType png_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self,
                                                PhotoMetadata* metadata,
                                                GError** error);
VALA_EXTERN PngMetadataWriter* png_metadata_writer_new (const gchar* filepath);
VALA_EXTERN PngMetadataWriter* png_metadata_writer_construct (GType object_type,
                                                  const gchar* filepath);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_metadata_writer_construct (GType object_type,
                                                               const gchar* filepath,
                                                               PhotoFileFormat file_format);
static void png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                              PhotoMetadata* metadata,
                                              GError** error);
VALA_EXTERN void photo_metadata_write_to_file (PhotoMetadata* self,
                                   GFile* file,
                                   GError** error);
VALA_EXTERN GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GType png_metadata_writer_get_type_once (void);
VALA_EXTERN gpointer photo_file_format_driver_ref (gpointer instance);
VALA_EXTERN void photo_file_format_driver_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_driver (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_driver (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_driver (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_driver (const GValue* value);
VALA_EXTERN GType photo_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN GType png_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PngFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_driver_get_properties (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileReader* photo_file_format_driver_create_reader (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN gboolean photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self);
VALA_EXTERN gboolean photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileWriter* photo_file_format_driver_create_writer (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self,
                                                                          const gchar* filepath);
VALA_EXTERN PhotoFileSniffer* photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self,
                                                           GFile* file,
                                                           PhotoFileSnifferOptions options);
VALA_EXTERN PhotoMetadata* photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN void png_file_format_driver_init (void);
VALA_EXTERN PngFileFormatDriver* png_file_format_driver_new (void);
VALA_EXTERN PngFileFormatDriver* png_file_format_driver_construct (GType object_type);
VALA_EXTERN PngFileFormatDriver* png_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static gboolean png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static PhotoFileMetadataWriter* png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                             const gchar* filepath);
static PhotoFileSniffer* png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                              GFile* file,
                                                              PhotoFileSnifferOptions options);
static PhotoMetadata* png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
VALA_EXTERN PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void png_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType png_file_format_driver_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const guint8 PNG_SNIFFER_MAGIC_SEQUENCE[8] = {(guint8) 137, (guint8) 80, (guint8) 78, (guint8) 71, (guint8) 13, (guint8) 10, (guint8) 26, (guint8) 10};

void
png_file_format_properties_init (void)
{
	PngFileFormatProperties* _tmp0_;
	_tmp0_ = png_file_format_properties_new ();
	_photo_file_format_properties_unref0 (png_file_format_properties_instance);
	png_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

PngFileFormatProperties*
png_file_format_properties_get_instance (void)
{
	PngFileFormatProperties* _tmp0_;
	PngFileFormatProperties* _tmp1_;
	PngFileFormatProperties* result;
	_tmp0_ = png_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	PhotoFileFormat result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	result = PHOTO_FILE_FORMAT_PNG;
	return result;
}

static PhotoFileFormatFlags
png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	_tmp0_ = g_strdup (_ ("PNG"));
	result = _tmp0_;
	return result;
}

static gchar*
png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	_tmp0_ = png_file_format_properties_KNOWN_EXTENSIONS;
	_tmp0__length1 = png_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                      gint* result_length1)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	_tmp0_ = png_file_format_properties_KNOWN_EXTENSIONS;
	_tmp0__length1 = png_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup13 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	_tmp0_ = png_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = png_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                gint* result_length1)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	_tmp0_ = png_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = png_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup14 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PngFileFormatProperties*
png_file_format_properties_construct (GType object_type)
{
	PngFileFormatProperties* self = NULL;
	self = (PngFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

PngFileFormatProperties*
png_file_format_properties_new (void)
{
	return png_file_format_properties_construct (TYPE_PNG_FILE_FORMAT_PROPERTIES);
}

static void
png_file_format_properties_class_init (PngFileFormatPropertiesClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	png_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = png_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) png_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) png_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("png");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	png_file_format_properties_KNOWN_EXTENSIONS = _tmp1_;
	png_file_format_properties_KNOWN_EXTENSIONS_length1 = 1;
	_png_file_format_properties_KNOWN_EXTENSIONS_size_ = png_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp2_ = g_strdup ("image/png");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	png_file_format_properties_KNOWN_MIME_TYPES = _tmp3_;
	png_file_format_properties_KNOWN_MIME_TYPES_length1 = 1;
	_png_file_format_properties_KNOWN_MIME_TYPES_size_ = png_file_format_properties_KNOWN_MIME_TYPES_length1;
}

static void
png_file_format_properties_instance_init (PngFileFormatProperties * self,
                                          gpointer klass)
{
}

static void
png_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	PngFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (png_file_format_properties_parent_class)->finalize (obj);
}

static GType
png_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatProperties), 0, (GInstanceInitFunc) png_file_format_properties_instance_init, NULL };
	GType png_file_format_properties_type_id;
	png_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "PngFileFormatProperties", &g_define_type_info, 0);
	return png_file_format_properties_type_id;
}

GType
png_file_format_properties_get_type (void)
{
	static volatile gsize png_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&png_file_format_properties_type_id__once)) {
		GType png_file_format_properties_type_id;
		png_file_format_properties_type_id = png_file_format_properties_get_type_once ();
		g_once_init_leave (&png_file_format_properties_type_id__once, png_file_format_properties_type_id);
	}
	return png_file_format_properties_type_id__once;
}

PngSniffer*
png_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	PngSniffer* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (PngSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

PngSniffer*
png_sniffer_new (GFile* file,
                 PhotoFileSnifferOptions options)
{
	return png_sniffer_construct (TYPE_PNG_SNIFFER, file, options);
}

static gboolean
png_sniffer_is_png_file (GFile* file,
                         GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp2_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	GFileInputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_new0 (guint8, G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE));
	file_lead_sequence = _tmp2_;
	file_lead_sequence_length1 = G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp3_ = instream;
	_tmp4_ = file_lead_sequence;
	_tmp4__length1 = file_lead_sequence_length1;
	g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_input_stream_get_type (), GInputStream), _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp5_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8 _tmp9_;
				guint8 _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE))) {
					break;
				}
				_tmp8_ = file_lead_sequence;
				_tmp8__length1 = file_lead_sequence_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = PNG_SNIFFER_MAGIC_SEQUENCE[i];
				if (_tmp9_ != _tmp10_) {
					result = FALSE;
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
					_g_object_unref0 (instream);
					return result;
				}
			}
		}
	}
	result = TRUE;
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	_g_object_unref0 (instream);
	return result;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
png_sniffer_real_sniff (PhotoFileSniffer* base,
                        gboolean* is_corrupted,
                        GError** error)
{
	PngSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	gboolean _tmp2_ = FALSE;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_;
	DetectedPhotoInformation* _tmp5_ = NULL;
	DetectedPhotoInformation* _tmp6_;
	DetectedPhotoInformation* _tmp8_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_SNIFFER, PngSniffer);
	_vala_is_corrupted = FALSE;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
	_tmp0_ = png_sniffer_is_png_file (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		if (is_corrupted) {
			*is_corrupted = _vala_is_corrupted;
		}
		return result;
	}
	_tmp3_ = PHOTO_FILE_SNIFFER_CLASS (png_sniffer_parent_class)->sniff (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer), &_tmp2_, &_inner_error0_);
	_vala_is_corrupted = _tmp2_;
	detected = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = detected;
	if (_tmp4_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		if (is_corrupted) {
			*is_corrupted = _vala_is_corrupted;
		}
		return result;
	}
	_tmp6_ = detected;
	if (_tmp6_->file_format == PHOTO_FILE_FORMAT_PNG) {
		DetectedPhotoInformation* _tmp7_;
		_tmp7_ = detected;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = NULL;
	}
	_tmp8_ = _detected_photo_information_ref0 (_tmp5_);
	result = _tmp8_;
	_detected_photo_information_unref0 (detected);
	if (is_corrupted) {
		*is_corrupted = _vala_is_corrupted;
	}
	return result;
}

static void
png_sniffer_class_init (PngSnifferClass * klass,
                        gpointer klass_data)
{
	png_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, gboolean*, GError**)) png_sniffer_real_sniff;
}

static void
png_sniffer_instance_init (PngSniffer * self,
                           gpointer klass)
{
}

static GType
png_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngSniffer), 0, (GInstanceInitFunc) png_sniffer_instance_init, NULL };
	GType png_sniffer_type_id;
	png_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "PngSniffer", &g_define_type_info, 0);
	return png_sniffer_type_id;
}

GType
png_sniffer_get_type (void)
{
	static volatile gsize png_sniffer_type_id__once = 0;
	if (g_once_init_enter (&png_sniffer_type_id__once)) {
		GType png_sniffer_type_id;
		png_sniffer_type_id = png_sniffer_get_type_once ();
		g_once_init_leave (&png_sniffer_type_id__once, png_sniffer_type_id);
	}
	return png_sniffer_type_id__once;
}

PngReader*
png_reader_construct (GType object_type,
                      const gchar* filepath)
{
	PngReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngReader*
png_reader_new (const gchar* filepath)
{
	return png_reader_construct (TYPE_PNG_READER, filepath);
}

static void
png_reader_class_init (PngReaderClass * klass,
                       gpointer klass_data)
{
	png_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
png_reader_instance_init (PngReader * self,
                          gpointer klass)
{
}

static GType
png_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngReader), 0, (GInstanceInitFunc) png_reader_instance_init, NULL };
	GType png_reader_type_id;
	png_reader_type_id = g_type_register_static (TYPE_GDK_READER, "PngReader", &g_define_type_info, 0);
	return png_reader_type_id;
}

GType
png_reader_get_type (void)
{
	static volatile gsize png_reader_type_id__once = 0;
	if (g_once_init_enter (&png_reader_type_id__once)) {
		GType png_reader_type_id;
		png_reader_type_id = png_reader_get_type_once ();
		g_once_init_leave (&png_reader_type_id__once, png_reader_type_id);
	}
	return png_reader_type_id__once;
}

PngWriter*
png_writer_construct (GType object_type,
                      const gchar* filepath)
{
	PngWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngWriter*) photo_file_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngWriter*
png_writer_new (const gchar* filepath)
{
	return png_writer_construct (TYPE_PNG_WRITER, filepath);
}

static void
png_writer_real_write (PhotoFileWriter* base,
                       GdkPixbuf* pixbuf,
                       JpegQuality quality,
                       GError** error)
{
	PngWriter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_WRITER, PngWriter);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	_tmp0_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp1_ = _tmp0_;
	gdk_pixbuf_save (pixbuf, _tmp1_, "png", &_inner_error0_, "compression", "9", NULL, NULL);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
png_writer_class_init (PngWriterClass * klass,
                       gpointer klass_data)
{
	png_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) png_writer_real_write;
}

static void
png_writer_instance_init (PngWriter * self,
                          gpointer klass)
{
}

static GType
png_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngWriter), 0, (GInstanceInitFunc) png_writer_instance_init, NULL };
	GType png_writer_type_id;
	png_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "PngWriter", &g_define_type_info, 0);
	return png_writer_type_id;
}

GType
png_writer_get_type (void)
{
	static volatile gsize png_writer_type_id__once = 0;
	if (g_once_init_enter (&png_writer_type_id__once)) {
		GType png_writer_type_id;
		png_writer_type_id = png_writer_get_type_once ();
		g_once_init_leave (&png_writer_type_id__once, png_writer_type_id);
	}
	return png_writer_type_id__once;
}

PngMetadataWriter*
png_metadata_writer_construct (GType object_type,
                               const gchar* filepath)
{
	PngMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngMetadataWriter*
png_metadata_writer_new (const gchar* filepath)
{
	return png_metadata_writer_construct (TYPE_PNG_METADATA_WRITER, filepath);
}

static void
png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                         PhotoMetadata* metadata,
                                         GError** error)
{
	PngMetadataWriter * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_METADATA_WRITER, PngMetadataWriter);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
	_tmp0_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp1_ = _tmp0_;
	photo_metadata_write_to_file (metadata, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
png_metadata_writer_class_init (PngMetadataWriterClass * klass,
                                gpointer klass_data)
{
	png_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) png_metadata_writer_real_write_metadata;
}

static void
png_metadata_writer_instance_init (PngMetadataWriter * self,
                                   gpointer klass)
{
}

static GType
png_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngMetadataWriter), 0, (GInstanceInitFunc) png_metadata_writer_instance_init, NULL };
	GType png_metadata_writer_type_id;
	png_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "PngMetadataWriter", &g_define_type_info, 0);
	return png_metadata_writer_type_id;
}

GType
png_metadata_writer_get_type (void)
{
	static volatile gsize png_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&png_metadata_writer_type_id__once)) {
		GType png_metadata_writer_type_id;
		png_metadata_writer_type_id = png_metadata_writer_get_type_once ();
		g_once_init_leave (&png_metadata_writer_type_id__once, png_metadata_writer_type_id);
	}
	return png_metadata_writer_type_id__once;
}

void
png_file_format_driver_init (void)
{
	PngFileFormatDriver* _tmp0_;
	_tmp0_ = png_file_format_driver_new ();
	_photo_file_format_driver_unref0 (png_file_format_driver_instance);
	png_file_format_driver_instance = _tmp0_;
	png_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

PngFileFormatDriver*
png_file_format_driver_get_instance (void)
{
	PngFileFormatDriver* _tmp0_;
	PngFileFormatDriver* _tmp1_;
	PngFileFormatDriver* result;
	_tmp0_ = png_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	PngFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	_tmp0_ = png_file_format_properties_get_instance ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
	return result;
}

static PhotoFileReader*
png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngReader* _tmp0_;
	PhotoFileReader* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_reader_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
	return result;
}

static gboolean
png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	result = TRUE;
	return result;
}

static gboolean
png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	result = TRUE;
	return result;
}

static PhotoFileWriter*
png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngWriter* _tmp0_;
	PhotoFileWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_writer_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_WRITER, PhotoFileWriter);
	return result;
}

static PhotoFileMetadataWriter*
png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                    const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_metadata_writer_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter);
	return result;
}

static PhotoFileSniffer*
png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                            GFile* file,
                                            PhotoFileSnifferOptions options)
{
	PngFileFormatDriver * self;
	PngSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = png_sniffer_new (file, options);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
	return result;
}

static PhotoMetadata*
png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

PngFileFormatDriver*
png_file_format_driver_construct (GType object_type)
{
	PngFileFormatDriver* self = NULL;
	self = (PngFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

PngFileFormatDriver*
png_file_format_driver_new (void)
{
	return png_file_format_driver_construct (TYPE_PNG_FILE_FORMAT_DRIVER);
}

static void
png_file_format_driver_class_init (PngFileFormatDriverClass * klass,
                                   gpointer klass_data)
{
	png_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = png_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) png_file_format_driver_real_create_sniffer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_create_metadata;
}

static void
png_file_format_driver_instance_init (PngFileFormatDriver * self,
                                      gpointer klass)
{
}

static void
png_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	PngFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (png_file_format_driver_parent_class)->finalize (obj);
}

static GType
png_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatDriver), 0, (GInstanceInitFunc) png_file_format_driver_instance_init, NULL };
	GType png_file_format_driver_type_id;
	png_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "PngFileFormatDriver", &g_define_type_info, 0);
	return png_file_format_driver_type_id;
}

GType
png_file_format_driver_get_type (void)
{
	static volatile gsize png_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&png_file_format_driver_type_id__once)) {
		GType png_file_format_driver_type_id;
		png_file_format_driver_type_id = png_file_format_driver_get_type_once ();
		g_once_init_leave (&png_file_format_driver_type_id__once, png_file_format_driver_type_id);
	}
	return png_file_format_driver_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

