/* GdkSupport.c generated by valac 0.56.17, the Vala compiler
 * generated from GdkSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "metadata.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _GdkSnifferPrivate {
	DetectedPhotoInformation* detected;
	gboolean size_ready;
	gboolean area_prepared;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

static gpointer gdk_reader_parent_class = NULL;
static gint GdkSniffer_private_offset;
static gpointer gdk_sniffer_parent_class = NULL;

VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType gdk_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkReader, photo_file_adapter_unref)
VALA_EXTERN PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GdkReader* gdk_reader_construct (GType object_type,
                                 const gchar* filepath,
                                 PhotoFileFormat file_format);
VALA_EXTERN PhotoFileReader* photo_file_reader_construct (GType object_type,
                                              const gchar* filepath,
                                              PhotoFileFormat file_format);
static PhotoMetadata* gdk_reader_real_read_metadata (PhotoFileReader* base,
                                              GError** error);
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
VALA_EXTERN GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_unscaled_read (PhotoFileReader* base,
                                          GError** error);
VALA_EXTERN gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void dimensions_get_scaled_by_constraint (Dimensions *self,
                                          gint scale,
                                          ScaleConstraint constraint,
                                          Dimensions* result);
static GType gdk_reader_get_type_once (void);
VALA_EXTERN gpointer photo_file_sniffer_ref (gpointer instance);
VALA_EXTERN void photo_file_sniffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_sniffer (const GValue* value);
VALA_EXTERN GType photo_file_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileSniffer, photo_file_sniffer_unref)
VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gdk_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkSniffer, photo_file_sniffer_unref)
VALA_EXTERN DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self,
                                                    gboolean* is_corrupted,
                                                    GError** error);
VALA_EXTERN GdkSniffer* gdk_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
VALA_EXTERN PhotoFileSniffer* photo_file_sniffer_construct (GType object_type,
                                                GFile* file,
                                                PhotoFileSnifferOptions options);
static DetectedPhotoInformation* gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  gboolean* is_corrupted,
                                                  GError** error);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_new (void);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
static void gdk_sniffer_on_size_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* loader,
                                   gint width,
                                   gint height);
static void _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                                    gint width,
                                                                    gint height,
                                                                    gpointer self);
static void gdk_sniffer_on_area_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* pixbuf_loader);
static void _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                                    gpointer self);
VALA_EXTERN gchar* photo_metadata_exif_hash (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN PhotoFileFormat photo_file_format_from_pixbuf_name (const gchar* name);
static void gdk_sniffer_finalize (PhotoFileSniffer * obj);
static GType gdk_sniffer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GdkReader*
gdk_reader_construct (GType object_type,
                      const gchar* filepath,
                      PhotoFileFormat file_format)
{
	GdkReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (GdkReader*) photo_file_reader_construct (object_type, filepath, file_format);
	return self;
}

static PhotoMetadata*
gdk_reader_real_read_metadata (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
	_tmp0_ = photo_metadata_new ();
	metadata = _tmp0_;
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp2_ = _tmp1_;
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp2_, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = metadata;
	return result;
}

static GdkPixbuf*
gdk_reader_real_unscaled_read (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GdkPixbuf*
gdk_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	GdkReader * self;
	GdkPixbuf* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_result_ = NULL;
	_tmp2_ = *full;
	if (_tmp2_.width > 9999) {
		_tmp1_ = TRUE;
	} else {
		Dimensions _tmp3_;
		_tmp3_ = *full;
		_tmp1_ = _tmp3_.height > 9999;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		Dimensions _tmp5_;
		_tmp5_ = *scaled;
		if (_tmp5_.width < 100) {
			_tmp4_ = TRUE;
		} else {
			Dimensions _tmp6_;
			_tmp6_ = *scaled;
			_tmp4_ = _tmp6_.height < 100;
		}
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Dimensions prefetch_dimensions = {0};
		Dimensions _tmp7_ = {0};
		GdkPixbuf* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		Dimensions _tmp11_;
		Dimensions _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		Dimensions _tmp17_;
		Dimensions _tmp18_;
		GdkPixbuf* _tmp19_;
		dimensions_get_scaled_by_constraint (full, 1000, SCALE_CONSTRAINT_DIMENSIONS, &_tmp7_);
		prefetch_dimensions = _tmp7_;
		_tmp9_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp10_ = _tmp9_;
		_tmp11_ = prefetch_dimensions;
		_tmp12_ = prefetch_dimensions;
		_tmp13_ = gdk_pixbuf_new_from_file_at_scale (_tmp10_, _tmp11_.width, _tmp12_.height, FALSE, &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp10_);
		_tmp8_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp15_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp15_;
		_tmp16_ = _result_;
		_tmp17_ = *scaled;
		_tmp18_ = *scaled;
		_tmp19_ = gdk_pixbuf_scale_simple (_tmp16_, _tmp17_.width, _tmp18_.height, GDK_INTERP_HYPER);
		_g_object_unref0 (_result_);
		_result_ = _tmp19_;
		_g_object_unref0 (_tmp8_);
	} else {
		GdkPixbuf* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		Dimensions _tmp23_;
		Dimensions _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		GdkPixbuf* _tmp27_;
		_tmp21_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp22_ = _tmp21_;
		_tmp23_ = *scaled;
		_tmp24_ = *scaled;
		_tmp25_ = gdk_pixbuf_new_from_file_at_scale (_tmp22_, _tmp23_.width, _tmp24_.height, FALSE, &_inner_error0_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp22_);
		_tmp20_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp27_ = _tmp20_;
		_tmp20_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp27_;
		_g_object_unref0 (_tmp20_);
	}
	result = _result_;
	return result;
}

static void
gdk_reader_class_init (GdkReaderClass * klass,
                       gpointer klass_data)
{
	gdk_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) gdk_reader_real_read_metadata;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) gdk_reader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) gdk_reader_real_scaled_read;
}

static void
gdk_reader_instance_init (GdkReader * self,
                          gpointer klass)
{
}

static GType
gdk_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GdkReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkReader), 0, (GInstanceInitFunc) gdk_reader_instance_init, NULL };
	GType gdk_reader_type_id;
	gdk_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "GdkReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return gdk_reader_type_id;
}

GType
gdk_reader_get_type (void)
{
	static volatile gsize gdk_reader_type_id__once = 0;
	if (g_once_init_enter (&gdk_reader_type_id__once)) {
		GType gdk_reader_type_id;
		gdk_reader_type_id = gdk_reader_get_type_once ();
		g_once_init_leave (&gdk_reader_type_id__once, gdk_reader_type_id);
	}
	return gdk_reader_type_id__once;
}

static inline gpointer
gdk_sniffer_get_instance_private (GdkSniffer* self)
{
	return G_STRUCT_MEMBER_P (self, GdkSniffer_private_offset);
}

GdkSniffer*
gdk_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	GdkSniffer* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (GdkSniffer*) photo_file_sniffer_construct (object_type, file, options);
	return self;
}

static void
_gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                               gint width,
                                                               gint height,
                                                               gpointer self)
{
	gdk_sniffer_on_size_prepared ((GdkSniffer*) self, _sender, width, height);
}

static void
_gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                               gpointer self)
{
	gdk_sniffer_on_area_prepared ((GdkSniffer*) self, _sender);
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                        gboolean* is_corrupted,
                        GError** error)
{
	GdkSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* _tmp0_;
	GdkPixbufLoader* pixbuf_loader = NULL;
	GdkPixbufLoader* _tmp1_;
	GdkPixbufLoader* _tmp2_;
	GdkPixbufLoader* _tmp3_;
	GChecksum* md5_checksum = NULL;
	DetectedPhotoInformation* _tmp5_;
	PhotoMetadata* _tmp6_;
	gboolean _tmp11_ = FALSE;
	guint8* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint __tmp22__size_ = 0;
	guint8* buffer = NULL;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gint buffer_length1;
	gint _buffer_size_;
	gsize count = 0UL;
	GFileInputStream* fins = NULL;
	GFile* _tmp26_;
	GFileInputStream* _tmp27_;
	GFileInputStream* _tmp39_;
	gboolean _tmp45_ = FALSE;
	DetectedPhotoInformation* _tmp46_;
	DetectedPhotoInformation* _tmp47_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_SNIFFER, GdkSniffer);
	_tmp0_ = detected_photo_information_new ();
	_detected_photo_information_unref0 (self->priv->detected);
	self->priv->detected = _tmp0_;
	_tmp1_ = gdk_pixbuf_loader_new ();
	pixbuf_loader = _tmp1_;
	_tmp2_ = pixbuf_loader;
	g_signal_connect (_tmp2_, "size-prepared", (GCallback) _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared, self);
	_tmp3_ = pixbuf_loader;
	g_signal_connect (_tmp3_, "area-prepared", (GCallback) _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared, self);
	md5_checksum = NULL;
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		GChecksum* _tmp4_;
		_tmp4_ = g_checksum_new (G_CHECKSUM_MD5);
		_g_checksum_free0 (md5_checksum);
		md5_checksum = _tmp4_;
	}
	_tmp5_ = self->priv->detected;
	_tmp6_ = photo_metadata_new ();
	_media_metadata_unref0 (_tmp5_->metadata);
	_tmp5_->metadata = _tmp6_;
	{
		DetectedPhotoInformation* _tmp7_;
		PhotoMetadata* _tmp8_;
		GFile* _tmp9_;
		_tmp7_ = self->priv->detected;
		_tmp8_ = _tmp7_->metadata;
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		DetectedPhotoInformation* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp10_ = self->priv->detected;
		_media_metadata_unref0 (_tmp10_->metadata);
		_tmp10_->metadata = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		DetectedPhotoInformation* _tmp12_;
		PhotoMetadata* _tmp13_;
		_tmp12_ = self->priv->detected;
		_tmp13_ = _tmp12_->metadata;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		DetectedPhotoInformation* _tmp14_;
		DetectedPhotoInformation* _tmp15_;
		PhotoMetadata* _tmp16_;
		gchar* _tmp17_;
		DetectedPhotoInformation* _tmp18_;
		DetectedPhotoInformation* _tmp19_;
		PhotoMetadata* _tmp20_;
		gchar* _tmp21_;
		_tmp14_ = self->priv->detected;
		_tmp15_ = self->priv->detected;
		_tmp16_ = _tmp15_->metadata;
		_tmp17_ = photo_metadata_exif_hash (_tmp16_);
		_g_free0 (_tmp14_->exif_md5);
		_tmp14_->exif_md5 = _tmp17_;
		_tmp18_ = self->priv->detected;
		_tmp19_ = self->priv->detected;
		_tmp20_ = _tmp19_->metadata;
		_tmp21_ = photo_metadata_thumbnail_hash (_tmp20_);
		_g_free0 (_tmp18_->thumbnail_md5);
		_tmp18_->thumbnail_md5 = _tmp21_;
	}
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		guint8* _tmp23_;
		_tmp23_ = g_new0 (guint8, 64 * 1024);
		_tmp22_ = (g_free (_tmp22_), NULL);
		_tmp22_ = _tmp23_;
		_tmp22__length1 = 64 * 1024;
		__tmp22__size_ = _tmp22__length1;
	} else {
		guint8* _tmp24_;
		_tmp24_ = g_new0 (guint8, 8 * 1024);
		_tmp22_ = (g_free (_tmp22_), NULL);
		_tmp22_ = _tmp24_;
		_tmp22__length1 = 8 * 1024;
		__tmp22__size_ = _tmp22__length1;
	}
	_tmp25_ = (_tmp22_ != NULL) ? _vala_array_dup4 (_tmp22_, _tmp22__length1) : _tmp22_;
	_tmp25__length1 = _tmp22__length1;
	buffer = _tmp25_;
	buffer_length1 = _tmp25__length1;
	_buffer_size_ = buffer_length1;
	count = (gsize) 0;
	_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
	_tmp27_ = g_file_read (_tmp26_, NULL, &_inner_error0_);
	fins = _tmp27_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_tmp22_ = (g_free (_tmp22_), NULL);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	{
		gboolean _tmp28_ = FALSE;
		_tmp28_ = TRUE;
		while (TRUE) {
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp29_;
			guint8* _tmp30_;
			gint _tmp30__length1;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gboolean _tmp37_ = FALSE;
			if (!_tmp28_) {
			}
			_tmp28_ = FALSE;
			_tmp29_ = fins;
			_tmp30_ = buffer;
			_tmp30__length1 = buffer_length1;
			bytes_read = (gsize) g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_input_stream_get_type (), GInputStream), _tmp30_, (gsize) _tmp30__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (fins);
				buffer = (g_free (buffer), NULL);
				_tmp22_ = (g_free (_tmp22_), NULL);
				_g_checksum_free0 (md5_checksum);
				_g_object_unref0 (pixbuf_loader);
				return NULL;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			count += bytes_read;
			if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
				GChecksum* _tmp31_;
				guint8* _tmp32_;
				gint _tmp32__length1;
				_tmp31_ = md5_checksum;
				_tmp32_ = buffer;
				_tmp32__length1 = buffer_length1;
				g_checksum_update (_tmp31_, _tmp32_, bytes_read);
			}
			if (!self->priv->size_ready) {
				_tmp33_ = TRUE;
			} else {
				_tmp33_ = !self->priv->area_prepared;
			}
			if (_tmp33_) {
				GdkPixbufLoader* _tmp34_;
				guint8* _tmp35_;
				gint _tmp35__length1;
				_tmp34_ = pixbuf_loader;
				_tmp35_ = buffer;
				_tmp35__length1 = buffer_length1;
				gdk_pixbuf_loader_write (_tmp34_, _tmp35_ + 0, (gsize) (((gint) bytes_read) - 0), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (fins);
					buffer = (g_free (buffer), NULL);
					_tmp22_ = (g_free (_tmp22_), NULL);
					_g_checksum_free0 (md5_checksum);
					_g_object_unref0 (pixbuf_loader);
					return NULL;
				}
			}
			if (!G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
				_tmp37_ = self->priv->size_ready;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				_tmp36_ = self->priv->area_prepared;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				break;
			}
		}
	}
	{
		GdkPixbufLoader* _tmp38_;
		_tmp38_ = pixbuf_loader;
		gdk_pixbuf_loader_close (_tmp38_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fins);
		buffer = (g_free (buffer), NULL);
		_tmp22_ = (g_free (_tmp22_), NULL);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	_tmp39_ = fins;
	if (_tmp39_ != NULL) {
		GFileInputStream* _tmp40_;
		_tmp40_ = fins;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (fins);
			buffer = (g_free (buffer), NULL);
			_tmp22_ = (g_free (_tmp22_), NULL);
			_g_checksum_free0 (md5_checksum);
			_g_object_unref0 (pixbuf_loader);
			return NULL;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5) {
		DetectedPhotoInformation* _tmp41_;
		GChecksum* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp41_ = self->priv->detected;
		_tmp42_ = md5_checksum;
		_tmp43_ = g_checksum_get_string (_tmp42_);
		_tmp44_ = g_strdup (_tmp43_);
		_g_free0 (_tmp41_->md5);
		_tmp41_->md5 = _tmp44_;
	}
	if (!self->priv->size_ready) {
		_tmp45_ = TRUE;
	} else {
		_tmp45_ = !self->priv->area_prepared;
	}
	_vala_is_corrupted = _tmp45_;
	_tmp46_ = self->priv->detected;
	_tmp47_ = _detected_photo_information_ref0 (_tmp46_);
	result = _tmp47_;
	_g_object_unref0 (fins);
	buffer = (g_free (buffer), NULL);
	_tmp22_ = (g_free (_tmp22_), NULL);
	_g_checksum_free0 (md5_checksum);
	_g_object_unref0 (pixbuf_loader);
	if (is_corrupted) {
		*is_corrupted = _vala_is_corrupted;
	}
	return result;
}

static void
gdk_sniffer_on_size_prepared (GdkSniffer* self,
                              GdkPixbufLoader* loader,
                              gint width,
                              gint height)
{
	DetectedPhotoInformation* _tmp0_;
	g_return_if_fail (IS_GDK_SNIFFER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (loader, gdk_pixbuf_loader_get_type ()));
	_tmp0_ = self->priv->detected;
	dimensions_init (&_tmp0_->image_dim, width, height);
	self->priv->size_ready = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gdk_sniffer_on_area_prepared (GdkSniffer* self,
                              GdkPixbufLoader* pixbuf_loader)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	GdkPixbuf* _tmp4_;
	DetectedPhotoInformation* _tmp5_;
	GdkPixbuf* _tmp6_;
	DetectedPhotoInformation* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbufFormat* format = NULL;
	GdkPixbufFormat* _tmp9_;
	DetectedPhotoInformation* _tmp10_;
	GdkPixbufFormat* _tmp11_;
	gchar* _tmp12_;
	DetectedPhotoInformation* _tmp13_;
	const gchar* _tmp14_;
	DetectedPhotoInformation* _tmp15_;
	DetectedPhotoInformation* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (IS_GDK_SNIFFER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf_loader, gdk_pixbuf_loader_get_type ()));
	_tmp0_ = gdk_pixbuf_loader_get_pixbuf (pixbuf_loader);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	pixbuf = _tmp1_;
	_tmp2_ = pixbuf;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp3_ = self->priv->detected;
	_tmp4_ = pixbuf;
	_tmp3_->colorspace = gdk_pixbuf_get_colorspace (_tmp4_);
	_tmp5_ = self->priv->detected;
	_tmp6_ = pixbuf;
	_tmp5_->channels = gdk_pixbuf_get_n_channels (_tmp6_);
	_tmp7_ = self->priv->detected;
	_tmp8_ = pixbuf;
	_tmp7_->bits_per_channel = gdk_pixbuf_get_bits_per_sample (_tmp8_);
	_tmp9_ = gdk_pixbuf_loader_get_format (pixbuf_loader);
	format = _tmp9_;
	_tmp10_ = self->priv->detected;
	_tmp11_ = format;
	_tmp12_ = gdk_pixbuf_format_get_name (_tmp11_);
	_g_free0 (_tmp10_->format_name);
	_tmp10_->format_name = _tmp12_;
	_tmp13_ = self->priv->detected;
	_tmp14_ = _tmp13_->format_name;
	g_debug ("GdkSupport.vala:145: Pixbuf detected format name: %s", _tmp14_);
	_tmp15_ = self->priv->detected;
	_tmp16_ = self->priv->detected;
	_tmp17_ = _tmp16_->format_name;
	_tmp15_->file_format = photo_file_format_from_pixbuf_name (_tmp17_);
	self->priv->area_prepared = TRUE;
	_g_object_unref0 (pixbuf);
}

static void
gdk_sniffer_class_init (GdkSnifferClass * klass,
                        gpointer klass_data)
{
	gdk_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->finalize = gdk_sniffer_finalize;
	g_type_class_adjust_private_offset (klass, &GdkSniffer_private_offset);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, gboolean*, GError**)) gdk_sniffer_real_sniff;
}

static void
gdk_sniffer_instance_init (GdkSniffer * self,
                           gpointer klass)
{
	self->priv = gdk_sniffer_get_instance_private (self);
	self->priv->detected = NULL;
	self->priv->size_ready = FALSE;
	self->priv->area_prepared = FALSE;
}

static void
gdk_sniffer_finalize (PhotoFileSniffer * obj)
{
	GdkSniffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GDK_SNIFFER, GdkSniffer);
	_detected_photo_information_unref0 (self->priv->detected);
	PHOTO_FILE_SNIFFER_CLASS (gdk_sniffer_parent_class)->finalize (obj);
}

static GType
gdk_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GdkSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkSniffer), 0, (GInstanceInitFunc) gdk_sniffer_instance_init, NULL };
	GType gdk_sniffer_type_id;
	gdk_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "GdkSniffer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GdkSniffer_private_offset = g_type_add_instance_private (gdk_sniffer_type_id, sizeof (GdkSnifferPrivate));
	return gdk_sniffer_type_id;
}

GType
gdk_sniffer_get_type (void)
{
	static volatile gsize gdk_sniffer_type_id__once = 0;
	if (g_once_init_enter (&gdk_sniffer_type_id__once)) {
		GType gdk_sniffer_type_id;
		gdk_sniffer_type_id = gdk_sniffer_get_type_once ();
		g_once_init_leave (&gdk_sniffer_type_id__once, gdk_sniffer_type_id);
	}
	return gdk_sniffer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

