/* GRaw.c generated by valac 0.56.17, the Vala compiler
 * generated from GRaw.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define GRAW_HD_POWER 2.222
#define GRAW_HD_SLOPE 4.5
#define GRAW_SRGB_POWER 2.4
#define GRAW_SRGB_SLOPE 12.92
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GRAW_COLORSPACE_RAW = 0,
	GRAW_COLORSPACE_SRGB = 1,
	GRAW_COLORSPACE_ADOBE = 2,
	GRAW_COLORSPACE_WIDE = 3,
	GRAW_COLORSPACE_PROPHOTO = 4,
	GRAW_COLORSPACE_XYZ = 5
} GRawColorspace;

#define GRAW_TYPE_COLORSPACE (graw_colorspace_get_type ())

#define GRAW_TYPE_EXCEPTION (graw_exception_get_type ())
typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

#define GRAW_TYPE_FLIP (graw_flip_get_type ())
typedef enum  {
	GRAW_FUJI_ROTATE_USE = -1,
	GRAW_FUJI_ROTATE_DONT_USE = 0
} GRawFujiRotate;

#define GRAW_TYPE_FUJI_ROTATE (graw_fuji_rotate_get_type ())
typedef enum  {
	GRAW_HIGHLIGHT_MODE_CLIP = 0,
	GRAW_HIGHLIGHT_MODE_UNCLIP = 1,
	GRAW_HIGHLIGHT_MODE_BLEND = 2,
	GRAW_HIGHLIGHT_MODE_REBUILD = 3
} GRawHighlightMode;

#define GRAW_TYPE_HIGHLIGHT_MODE (graw_highlight_mode_get_type ())
typedef enum  {
	GRAW_INTERPOLATION_QUALITY_LINEAR = 0,
	GRAW_INTERPOLATION_QUALITY_VNG = 1,
	GRAW_INTERPOLATION_QUALITY_PPG = 2,
	GRAW_INTERPOLATION_QUALITY_AHD = 3
} GRawInterpolationQuality;

#define GRAW_TYPE_INTERPOLATION_QUALITY (graw_interpolation_quality_get_type ())
typedef enum  {
	GRAW_USE_CAMERA_MATRIX_IGNORE = 0,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE = 1,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA = 3
} GRawUseCameraMatrix;

#define GRAW_TYPE_USE_CAMERA_MATRIX (graw_use_camera_matrix_get_type ())

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
typedef struct _GRawProcessedImagePrivate GRawProcessedImagePrivate;
#define _free0(var) ((var == NULL) ? NULL : (var = (free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GRawParamSpecProcessedImage GRawParamSpecProcessedImage;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;
typedef struct _GRawProcessorPrivate GRawProcessorPrivate;
#define _libraw_close0(var) ((var == NULL) ? NULL : (var = (libraw_close (var), NULL)))
typedef struct _GRawParamSpecProcessor GRawParamSpecProcessor;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()

struct _GRawProcessedImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessedImagePrivate * priv;
};

struct _GRawProcessedImageClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessedImage *self);
};

struct _GRawProcessedImagePrivate {
	libraw_processed_image_t* image;
	GdkPixbuf* pixbuf;
};

struct _GRawParamSpecProcessedImage {
	GParamSpec parent_instance;
};

struct _GRawProcessor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessorPrivate * priv;
};

struct _GRawProcessorClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessor *self);
};

struct _GRawProcessorPrivate {
	libraw_data_t* proc;
};

struct _GRawParamSpecProcessor {
	GParamSpec parent_instance;
};

static gint GRawProcessedImage_private_offset;
static gpointer graw_processed_image_parent_class = NULL;
static gint GRawProcessor_private_offset;
static gpointer graw_processor_parent_class = NULL;

VALA_EXTERN GType graw_colorspace_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark graw_exception_quark (void);
VALA_EXTERN GType graw_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType graw_flip_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType graw_fuji_rotate_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType graw_highlight_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType graw_interpolation_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType graw_use_camera_matrix_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer graw_processed_image_ref (gpointer instance);
VALA_EXTERN void graw_processed_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* graw_param_spec_processed_image (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void graw_value_set_processed_image (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void graw_value_take_processed_image (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer graw_value_get_processed_image (const GValue* value);
VALA_EXTERN GType graw_processed_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GRawProcessedImage, graw_processed_image_unref)
VALA_EXTERN GRawProcessedImage* graw_processed_image_new (libraw_data_t* proc,
                                              GError** error);
VALA_EXTERN GRawProcessedImage* graw_processed_image_construct (GType object_type,
                                                    libraw_data_t* proc,
                                                    GError** error);
VALA_EXTERN void graw_throw_exception (const gchar* caller,
                           enum LibRaw_errors _result_,
                           GError** error);
VALA_EXTERN GRawProcessedImage* graw_processed_image_new_from_thumb (libraw_data_t* proc,
                                                         GError** error);
VALA_EXTERN GRawProcessedImage* graw_processed_image_construct_from_thumb (GType object_type,
                                                               libraw_data_t* proc,
                                                               GError** error);
VALA_EXTERN GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
VALA_EXTERN gushort graw_processed_image_get_width (GRawProcessedImage* self);
VALA_EXTERN gushort graw_processed_image_get_height (GRawProcessedImage* self);
VALA_EXTERN gushort graw_processed_image_get_colors (GRawProcessedImage* self);
VALA_EXTERN gushort graw_processed_image_get_bits (GRawProcessedImage* self);
VALA_EXTERN guint8* graw_processed_image_get_data (GRawProcessedImage* self);
VALA_EXTERN guint graw_processed_image_get_data_size (GRawProcessedImage* self);
static void graw_processed_image_finalize (GRawProcessedImage * obj);
static GType graw_processed_image_get_type_once (void);
VALA_EXTERN gpointer graw_processor_ref (gpointer instance);
VALA_EXTERN void graw_processor_unref (gpointer instance);
VALA_EXTERN GParamSpec* graw_param_spec_processor (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void graw_value_set_processor (GValue* value,
                               gpointer v_object);
VALA_EXTERN void graw_value_take_processor (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer graw_value_get_processor (const GValue* value);
VALA_EXTERN GType graw_processor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GRawProcessor, graw_processor_unref)
VALA_EXTERN GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
VALA_EXTERN GRawProcessor* graw_processor_construct (GType object_type,
                                         enum LibRaw_constructor_flags options);
VALA_EXTERN void graw_processor_adjust_sizes_info_only (GRawProcessor* self,
                                            GError** error);
VALA_EXTERN libraw_imgother_t graw_processor_get_image_other (GRawProcessor* self);
VALA_EXTERN libraw_iparams_t graw_processor_get_image_params (GRawProcessor* self);
VALA_EXTERN libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
VALA_EXTERN libraw_thumbnail_t graw_processor_get_thumbnail (GRawProcessor* self);
VALA_EXTERN GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self,
                                                   GError** error);
VALA_EXTERN GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self,
                                                     GError** error);
VALA_EXTERN void graw_processor_open_buffer (GRawProcessor* self,
                                 guint8* buffer,
                                 gint buffer_length1,
                                 GError** error);
VALA_EXTERN void graw_processor_open_file (GRawProcessor* self,
                               const gchar* filename,
                               GError** error);
VALA_EXTERN void graw_processor_process (GRawProcessor* self,
                             GError** error);
VALA_EXTERN void graw_processor_ppm_tiff_writer (GRawProcessor* self,
                                     const gchar* filename,
                                     GError** error);
VALA_EXTERN void graw_processor_thumb_writer (GRawProcessor* self,
                                  const gchar* filename,
                                  GError** error);
VALA_EXTERN void graw_processor_recycle (GRawProcessor* self);
VALA_EXTERN void graw_processor_unpack (GRawProcessor* self,
                            GError** error);
VALA_EXTERN void graw_processor_unpack_thumb (GRawProcessor* self,
                                  GError** error);
VALA_EXTERN void graw_processor_configure_for_rgb_display (GRawProcessor* self,
                                               gboolean half_size);
VALA_EXTERN libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
static void graw_processor_finalize (GRawProcessor * obj);
static GType graw_processor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
graw_colorspace_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_COLORSPACE_RAW, "GRAW_COLORSPACE_RAW", "raw"}, {GRAW_COLORSPACE_SRGB, "GRAW_COLORSPACE_SRGB", "srgb"}, {GRAW_COLORSPACE_ADOBE, "GRAW_COLORSPACE_ADOBE", "adobe"}, {GRAW_COLORSPACE_WIDE, "GRAW_COLORSPACE_WIDE", "wide"}, {GRAW_COLORSPACE_PROPHOTO, "GRAW_COLORSPACE_PROPHOTO", "prophoto"}, {GRAW_COLORSPACE_XYZ, "GRAW_COLORSPACE_XYZ", "xyz"}, {0, NULL, NULL}};
	GType graw_colorspace_type_id;
	graw_colorspace_type_id = g_enum_register_static ("GRawColorspace", values);
	return graw_colorspace_type_id;
}

GType
graw_colorspace_get_type (void)
{
	static volatile gsize graw_colorspace_type_id__once = 0;
	if (g_once_init_enter (&graw_colorspace_type_id__once)) {
		GType graw_colorspace_type_id;
		graw_colorspace_type_id = graw_colorspace_get_type_once ();
		g_once_init_leave (&graw_colorspace_type_id__once, graw_colorspace_type_id);
	}
	return graw_colorspace_type_id__once;
}

GQuark
graw_exception_quark (void)
{
	return g_quark_from_static_string ("graw-exception-quark");
}

static GType
graw_exception_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_EXCEPTION_UNSPECIFIED, "GRAW_EXCEPTION_UNSPECIFIED", "unspecified"}, {GRAW_EXCEPTION_UNSUPPORTED_FILE, "GRAW_EXCEPTION_UNSUPPORTED_FILE", "unsupported-file"}, {GRAW_EXCEPTION_NONEXISTANT_IMAGE, "GRAW_EXCEPTION_NONEXISTANT_IMAGE", "nonexistant-image"}, {GRAW_EXCEPTION_OUT_OF_ORDER_CALL, "GRAW_EXCEPTION_OUT_OF_ORDER_CALL", "out-of-order-call"}, {GRAW_EXCEPTION_NO_THUMBNAIL, "GRAW_EXCEPTION_NO_THUMBNAIL", "no-thumbnail"}, {GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, "GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL", "unsupported-thumbnail"}, {GRAW_EXCEPTION_OUT_OF_MEMORY, "GRAW_EXCEPTION_OUT_OF_MEMORY", "out-of-memory"}, {GRAW_EXCEPTION_DATA_ERROR, "GRAW_EXCEPTION_DATA_ERROR", "data-error"}, {GRAW_EXCEPTION_IO_ERROR, "GRAW_EXCEPTION_IO_ERROR", "io-error"}, {GRAW_EXCEPTION_CANCELLED_BY_CALLBACK, "GRAW_EXCEPTION_CANCELLED_BY_CALLBACK", "cancelled-by-callback"}, {GRAW_EXCEPTION_BAD_CROP, "GRAW_EXCEPTION_BAD_CROP", "bad-crop"}, {GRAW_EXCEPTION_SYSTEM_ERROR, "GRAW_EXCEPTION_SYSTEM_ERROR", "system-error"}, {0, NULL, NULL}};
	GType graw_exception_type_id;
	graw_exception_type_id = g_enum_register_static ("GRawException", values);
	return graw_exception_type_id;
}

GType
graw_exception_get_type (void)
{
	static volatile gsize graw_exception_type_id__once = 0;
	if (g_once_init_enter (&graw_exception_type_id__once)) {
		GType graw_exception_type_id;
		graw_exception_type_id = graw_exception_get_type_once ();
		g_once_init_leave (&graw_exception_type_id__once, graw_exception_type_id);
	}
	return graw_exception_type_id__once;
}

static GType
graw_flip_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_FLIP_FROM_SOURCE, "GRAW_FLIP_FROM_SOURCE", "from-source"}, {GRAW_FLIP_NONE, "GRAW_FLIP_NONE", "none"}, {GRAW_FLIP_UPSIDE_DOWN, "GRAW_FLIP_UPSIDE_DOWN", "upside-down"}, {GRAW_FLIP_COUNTERCLOCKWISE, "GRAW_FLIP_COUNTERCLOCKWISE", "counterclockwise"}, {GRAW_FLIP_CLOCKWISE, "GRAW_FLIP_CLOCKWISE", "clockwise"}, {0, NULL, NULL}};
	GType graw_flip_type_id;
	graw_flip_type_id = g_enum_register_static ("GRawFlip", values);
	return graw_flip_type_id;
}

GType
graw_flip_get_type (void)
{
	static volatile gsize graw_flip_type_id__once = 0;
	if (g_once_init_enter (&graw_flip_type_id__once)) {
		GType graw_flip_type_id;
		graw_flip_type_id = graw_flip_get_type_once ();
		g_once_init_leave (&graw_flip_type_id__once, graw_flip_type_id);
	}
	return graw_flip_type_id__once;
}

static GType
graw_fuji_rotate_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_FUJI_ROTATE_USE, "GRAW_FUJI_ROTATE_USE", "use"}, {GRAW_FUJI_ROTATE_DONT_USE, "GRAW_FUJI_ROTATE_DONT_USE", "dont-use"}, {0, NULL, NULL}};
	GType graw_fuji_rotate_type_id;
	graw_fuji_rotate_type_id = g_enum_register_static ("GRawFujiRotate", values);
	return graw_fuji_rotate_type_id;
}

GType
graw_fuji_rotate_get_type (void)
{
	static volatile gsize graw_fuji_rotate_type_id__once = 0;
	if (g_once_init_enter (&graw_fuji_rotate_type_id__once)) {
		GType graw_fuji_rotate_type_id;
		graw_fuji_rotate_type_id = graw_fuji_rotate_get_type_once ();
		g_once_init_leave (&graw_fuji_rotate_type_id__once, graw_fuji_rotate_type_id);
	}
	return graw_fuji_rotate_type_id__once;
}

static GType
graw_highlight_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_HIGHLIGHT_MODE_CLIP, "GRAW_HIGHLIGHT_MODE_CLIP", "clip"}, {GRAW_HIGHLIGHT_MODE_UNCLIP, "GRAW_HIGHLIGHT_MODE_UNCLIP", "unclip"}, {GRAW_HIGHLIGHT_MODE_BLEND, "GRAW_HIGHLIGHT_MODE_BLEND", "blend"}, {GRAW_HIGHLIGHT_MODE_REBUILD, "GRAW_HIGHLIGHT_MODE_REBUILD", "rebuild"}, {0, NULL, NULL}};
	GType graw_highlight_mode_type_id;
	graw_highlight_mode_type_id = g_enum_register_static ("GRawHighlightMode", values);
	return graw_highlight_mode_type_id;
}

GType
graw_highlight_mode_get_type (void)
{
	static volatile gsize graw_highlight_mode_type_id__once = 0;
	if (g_once_init_enter (&graw_highlight_mode_type_id__once)) {
		GType graw_highlight_mode_type_id;
		graw_highlight_mode_type_id = graw_highlight_mode_get_type_once ();
		g_once_init_leave (&graw_highlight_mode_type_id__once, graw_highlight_mode_type_id);
	}
	return graw_highlight_mode_type_id__once;
}

static GType
graw_interpolation_quality_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_INTERPOLATION_QUALITY_LINEAR, "GRAW_INTERPOLATION_QUALITY_LINEAR", "linear"}, {GRAW_INTERPOLATION_QUALITY_VNG, "GRAW_INTERPOLATION_QUALITY_VNG", "vng"}, {GRAW_INTERPOLATION_QUALITY_PPG, "GRAW_INTERPOLATION_QUALITY_PPG", "ppg"}, {GRAW_INTERPOLATION_QUALITY_AHD, "GRAW_INTERPOLATION_QUALITY_AHD", "ahd"}, {0, NULL, NULL}};
	GType graw_interpolation_quality_type_id;
	graw_interpolation_quality_type_id = g_enum_register_static ("GRawInterpolationQuality", values);
	return graw_interpolation_quality_type_id;
}

GType
graw_interpolation_quality_get_type (void)
{
	static volatile gsize graw_interpolation_quality_type_id__once = 0;
	if (g_once_init_enter (&graw_interpolation_quality_type_id__once)) {
		GType graw_interpolation_quality_type_id;
		graw_interpolation_quality_type_id = graw_interpolation_quality_get_type_once ();
		g_once_init_leave (&graw_interpolation_quality_type_id__once, graw_interpolation_quality_type_id);
	}
	return graw_interpolation_quality_type_id__once;
}

static GType
graw_use_camera_matrix_get_type_once (void)
{
	static const GEnumValue values[] = {{GRAW_USE_CAMERA_MATRIX_IGNORE, "GRAW_USE_CAMERA_MATRIX_IGNORE", "ignore"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE", "embedded-color-profile"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA", "embedded-color-data"}, {0, NULL, NULL}};
	GType graw_use_camera_matrix_type_id;
	graw_use_camera_matrix_type_id = g_enum_register_static ("GRawUseCameraMatrix", values);
	return graw_use_camera_matrix_type_id;
}

GType
graw_use_camera_matrix_get_type (void)
{
	static volatile gsize graw_use_camera_matrix_type_id__once = 0;
	if (g_once_init_enter (&graw_use_camera_matrix_type_id__once)) {
		GType graw_use_camera_matrix_type_id;
		graw_use_camera_matrix_type_id = graw_use_camera_matrix_get_type_once ();
		g_once_init_leave (&graw_use_camera_matrix_type_id__once, graw_use_camera_matrix_type_id);
	}
	return graw_use_camera_matrix_type_id__once;
}

static inline gpointer
graw_processed_image_get_instance_private (GRawProcessedImage* self)
{
	return G_STRUCT_MEMBER_P (self, GRawProcessedImage_private_offset);
}

GRawProcessedImage*
graw_processed_image_construct (GType object_type,
                                libraw_data_t* proc,
                                GError** error)
{
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_processed_image_t* _tmp0_;
	libraw_processed_image_t* _tmp1_;
	libraw_processed_image_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	libraw_processed_image_t* _tmp4_;
	libraw_processed_image_t* _tmp5_;
	libraw_processed_image_t* _tmp6_;
	libraw_processed_image_t* _tmp7_;
	libraw_processed_image_t* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (proc != NULL, NULL);
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
	_result_ = LIBRAW_SUCCESS;
	_tmp0_ = libraw_dcraw_make_mem_image (proc, &_result_);
	_free0 (self->priv->image);
	self->priv->image = _tmp0_;
	graw_throw_exception ("ProcessedImage", _result_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			_graw_processed_image_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = self->priv->image;
	_vala_assert (_tmp1_ != NULL, "image != null");
	_tmp2_ = self->priv->image;
	_tmp3_ = _tmp2_->data;
	_tmp3__length1 = _tmp2_->data_size;
	_tmp4_ = self->priv->image;
	_tmp5_ = self->priv->image;
	_tmp6_ = self->priv->image;
	_tmp7_ = self->priv->image;
	_tmp8_ = self->priv->image;
	_tmp9_ = gdk_pixbuf_new_from_data (_tmp3_, GDK_COLORSPACE_RGB, FALSE, (gint) _tmp4_->bits, (gint) _tmp5_->width, (gint) _tmp6_->height, (gint) (_tmp7_->width * _tmp8_->colors), (GdkPixbufDestroyNotify) NULL, NULL);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = _tmp9_;
	return self;
}

GRawProcessedImage*
graw_processed_image_new (libraw_data_t* proc,
                          GError** error)
{
	return graw_processed_image_construct (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
}

GRawProcessedImage*
graw_processed_image_construct_from_thumb (GType object_type,
                                           libraw_data_t* proc,
                                           GError** error)
{
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_processed_image_t* _tmp0_;
	libraw_processed_image_t* _tmp1_;
	libraw_processed_image_t* _tmp15_;
	GdkPixbuf* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	libraw_processed_image_t* _tmp19_;
	GdkPixbuf* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	libraw_processed_image_t* _tmp23_;
	GdkPixbuf* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	libraw_processed_image_t* _tmp27_;
	GdkPixbuf* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (proc != NULL, NULL);
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
	_result_ = LIBRAW_SUCCESS;
	_tmp0_ = libraw_dcraw_make_mem_thumb (proc, &_result_);
	_free0 (self->priv->image);
	self->priv->image = _tmp0_;
	graw_throw_exception ("ProcessedImage.from_thumb", _result_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			_graw_processed_image_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = self->priv->image;
	_vala_assert (_tmp1_ != NULL, "image != null");
	{
		GBytes* bytes = NULL;
		libraw_processed_image_t* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		GBytes* _tmp4_;
		GdkPixbuf* _tmp5_ = NULL;
		GBytes* _tmp6_;
		GMemoryInputStream* _tmp7_;
		GMemoryInputStream* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp2_ = self->priv->image;
		_tmp3_ = _tmp2_->data;
		_tmp3__length1 = _tmp2_->data_size;
		_tmp4_ = g_bytes_new_static (_tmp3_, _tmp3__length1);
		bytes = _tmp4_;
		_tmp6_ = bytes;
		_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp5_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_bytes_unref0 (bytes);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->priv->pixbuf);
		self->priv->pixbuf = _tmp11_;
		_g_object_unref0 (_tmp5_);
		_g_bytes_unref0 (bytes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp13_);
		_inner_error0_ = _tmp14_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			_graw_processed_image_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = self->priv->image;
	_tmp16_ = self->priv->pixbuf;
	_tmp17_ = gdk_pixbuf_get_width (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp15_->width = (gushort) _tmp18_;
	_tmp19_ = self->priv->image;
	_tmp20_ = self->priv->pixbuf;
	_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp19_->height = (gushort) _tmp22_;
	_tmp23_ = self->priv->image;
	_tmp24_ = self->priv->pixbuf;
	_tmp25_ = gdk_pixbuf_get_n_channels (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp23_->colors = (gushort) _tmp26_;
	_tmp27_ = self->priv->image;
	_tmp28_ = self->priv->pixbuf;
	_tmp29_ = gdk_pixbuf_get_bits_per_sample (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp27_->bits = (gushort) _tmp30_;
	return self;
}

GRawProcessedImage*
graw_processed_image_new_from_thumb (libraw_data_t* proc,
                                     GError** error)
{
	return graw_processed_image_construct_from_thumb (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
}

GdkPixbuf*
graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
	_tmp0_ = self->priv->pixbuf;
	_tmp1_ = gdk_pixbuf_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

gushort
graw_processed_image_get_width (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
	_tmp0_ = self->priv->image;
	result = _tmp0_->width;
	return result;
}

gushort
graw_processed_image_get_height (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
	_tmp0_ = self->priv->image;
	result = _tmp0_->height;
	return result;
}

gushort
graw_processed_image_get_colors (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
	_tmp0_ = self->priv->image;
	result = _tmp0_->colors;
	return result;
}

gushort
graw_processed_image_get_bits (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
	_tmp0_ = self->priv->image;
	result = _tmp0_->bits;
	return result;
}

guint8*
graw_processed_image_get_data (GRawProcessedImage* self)
{
	guint8* result;
	libraw_processed_image_t* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
	_tmp0_ = self->priv->image;
	_tmp1_ = _tmp0_->data;
	_tmp1__length1 = _tmp0_->data_size;
	result = _tmp1_;
	return result;
}

guint
graw_processed_image_get_data_size (GRawProcessedImage* self)
{
	guint result;
	libraw_processed_image_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
	_tmp0_ = self->priv->image;
	result = _tmp0_->data_size;
	return result;
}

static void
graw_value_processed_image_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
graw_value_processed_image_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		graw_processed_image_unref (value->data[0].v_pointer);
	}
}

static void
graw_value_processed_image_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = graw_processed_image_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
graw_value_processed_image_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
graw_value_processed_image_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GRawProcessedImage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = graw_processed_image_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
graw_value_processed_image_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	GRawProcessedImage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = graw_processed_image_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
graw_param_spec_processed_image (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	GRawParamSpecProcessedImage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSED_IMAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
graw_value_get_processed_image (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE), NULL);
	return value->data[0].v_pointer;
}

void
graw_value_set_processed_image (GValue* value,
                                gpointer v_object)
{
	GRawProcessedImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		graw_processed_image_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graw_processed_image_unref (old);
	}
}

void
graw_value_take_processed_image (GValue* value,
                                 gpointer v_object)
{
	GRawProcessedImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graw_processed_image_unref (old);
	}
}

static void
graw_processed_image_class_init (GRawProcessedImageClass * klass,
                                 gpointer klass_data)
{
	graw_processed_image_parent_class = g_type_class_peek_parent (klass);
	((GRawProcessedImageClass *) klass)->finalize = graw_processed_image_finalize;
	g_type_class_adjust_private_offset (klass, &GRawProcessedImage_private_offset);
}

static void
graw_processed_image_instance_init (GRawProcessedImage * self,
                                    gpointer klass)
{
	self->priv = graw_processed_image_get_instance_private (self);
	self->priv->pixbuf = NULL;
	self->ref_count = 1;
}

static void
graw_processed_image_finalize (GRawProcessedImage * obj)
{
	GRawProcessedImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage);
	g_signal_handlers_destroy (self);
	_free0 (self->priv->image);
	_g_object_unref0 (self->priv->pixbuf);
}

static GType
graw_processed_image_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { graw_value_processed_image_init, graw_value_processed_image_free_value, graw_value_processed_image_copy_value, graw_value_processed_image_peek_pointer, "p", graw_value_processed_image_collect_value, "p", graw_value_processed_image_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GRawProcessedImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processed_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessedImage), 0, (GInstanceInitFunc) graw_processed_image_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType graw_processed_image_type_id;
	graw_processed_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessedImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GRawProcessedImage_private_offset = g_type_add_instance_private (graw_processed_image_type_id, sizeof (GRawProcessedImagePrivate));
	return graw_processed_image_type_id;
}

GType
graw_processed_image_get_type (void)
{
	static volatile gsize graw_processed_image_type_id__once = 0;
	if (g_once_init_enter (&graw_processed_image_type_id__once)) {
		GType graw_processed_image_type_id;
		graw_processed_image_type_id = graw_processed_image_get_type_once ();
		g_once_init_leave (&graw_processed_image_type_id__once, graw_processed_image_type_id);
	}
	return graw_processed_image_type_id__once;
}

gpointer
graw_processed_image_ref (gpointer instance)
{
	GRawProcessedImage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
graw_processed_image_unref (gpointer instance)
{
	GRawProcessedImage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRAW_PROCESSED_IMAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
graw_processor_get_instance_private (GRawProcessor* self)
{
	return G_STRUCT_MEMBER_P (self, GRawProcessor_private_offset);
}

GRawProcessor*
graw_processor_construct (GType object_type,
                          enum LibRaw_constructor_flags options)
{
	GRawProcessor* self = NULL;
	libraw_data_t* _tmp0_;
	self = (GRawProcessor*) g_type_create_instance (object_type);
	_tmp0_ = libraw_init (options);
	_libraw_close0 (self->priv->proc);
	self->priv->proc = _tmp0_;
	return self;
}

GRawProcessor*
graw_processor_new (enum LibRaw_constructor_flags options)
{
	return graw_processor_construct (GRAW_TYPE_PROCESSOR, options);
}

void
graw_processor_adjust_sizes_info_only (GRawProcessor* self,
                                       GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("adjust_sizes_info_only", libraw_adjust_sizes_info_only (_tmp0_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static libraw_imgother_t
libraw_get_image_other (libraw_data_t* self)
{
	libraw_imgother_t result;
	result = self->other;
	return result;
}

libraw_imgother_t
graw_processor_get_image_other (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
	libraw_imgother_t result;
	_tmp0_ = self->priv->proc;
	result = libraw_get_image_other (_tmp0_);
	return result;
}

static libraw_iparams_t
libraw_get_image_params (libraw_data_t* self)
{
	libraw_iparams_t result;
	result = self->idata;
	return result;
}

libraw_iparams_t
graw_processor_get_image_params (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
	libraw_iparams_t result;
	_tmp0_ = self->priv->proc;
	result = libraw_get_image_params (_tmp0_);
	return result;
}

static libraw_image_sizes_t
libraw_get_sizes (libraw_data_t* self)
{
	libraw_image_sizes_t result;
	result = self->sizes;
	return result;
}

libraw_image_sizes_t
graw_processor_get_sizes (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
	libraw_image_sizes_t result;
	_tmp0_ = self->priv->proc;
	result = libraw_get_sizes (_tmp0_);
	return result;
}

static libraw_thumbnail_t
libraw_get_thumbnail (libraw_data_t* self)
{
	libraw_thumbnail_t result;
	result = self->thumbnail;
	return result;
}

libraw_thumbnail_t
graw_processor_get_thumbnail (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
	libraw_thumbnail_t result;
	_tmp0_ = self->priv->proc;
	result = libraw_get_thumbnail (_tmp0_);
	return result;
}

GRawProcessedImage*
graw_processor_make_mem_image (GRawProcessor* self,
                               GError** error)
{
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError* _inner_error0_ = NULL;
	GRawProcessedImage* result;
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
	_tmp1_ = self->priv->proc;
	_tmp2_ = graw_processed_image_new (_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_graw_processed_image_unref0 (_tmp0_);
	return result;
}

GRawProcessedImage*
graw_processor_make_thumb_image (GRawProcessor* self,
                                 GError** error)
{
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError* _inner_error0_ = NULL;
	GRawProcessedImage* result;
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
	_tmp1_ = self->priv->proc;
	_tmp2_ = graw_processed_image_new_from_thumb (_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_graw_processed_image_unref0 (_tmp0_);
	return result;
}

void
graw_processor_open_buffer (GRawProcessor* self,
                            guint8* buffer,
                            gint buffer_length1,
                            GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("open_buffer", libraw_open_buffer (_tmp0_, buffer, (gint) buffer_length1), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_open_file (GRawProcessor* self,
                          const gchar* filename,
                          GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("open_file", libraw_open_file (_tmp0_, filename), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_process (GRawProcessor* self,
                        GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("process", libraw_dcraw_process (_tmp0_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_ppm_tiff_writer (GRawProcessor* self,
                                const gchar* filename,
                                GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("ppm_tiff_writer", libraw_dcraw_ppm_tiff_writer (_tmp0_, filename), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_thumb_writer (GRawProcessor* self,
                             const gchar* filename,
                             GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("thumb_writer", libraw_dcraw_thumb_writer (_tmp0_, filename), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_recycle (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	libraw_recycle (_tmp0_);
}

void
graw_processor_unpack (GRawProcessor* self,
                       GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("unpack", libraw_unpack (_tmp0_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
graw_processor_unpack_thumb (GRawProcessor* self,
                             GError** error)
{
	libraw_data_t* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = self->priv->proc;
	graw_throw_exception ("unpack_thumb", libraw_unpack_thumb (_tmp0_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GRAW_EXCEPTION) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
lib_raw_output_params_set_chromatic_aberrations (libraw_output_params_t* params,
                                                 gdouble red_multiplier,
                                                 gdouble green_multiplier)
{
	(*params).aber[0] = red_multiplier;
	(*params).aber[2] = green_multiplier;
}

static void
lib_raw_output_params_set_gamma_curve (libraw_output_params_t* params,
                                       gdouble power,
                                       gdouble slope)
{
	(*params).gamm[0] = 1.0 / power;
	(*params).gamm[1] = slope;
}

void
graw_processor_configure_for_rgb_display (GRawProcessor* self,
                                          gboolean half_size)
{
	libraw_output_params_t* _tmp0_;
	libraw_output_params_t* _tmp1_;
	libraw_output_params_t* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	libraw_output_params_t* _tmp5_;
	libraw_output_params_t* _tmp6_;
	libraw_output_params_t* _tmp7_;
	libraw_output_params_t* _tmp8_;
	libraw_output_params_t* _tmp9_;
	libraw_output_params_t* _tmp10_;
	libraw_output_params_t* _tmp11_;
	libraw_output_params_t* _tmp12_;
	libraw_output_params_t* _tmp13_;
	libraw_output_params_t* _tmp14_;
	libraw_output_params_t* _tmp15_;
	libraw_output_params_t* _tmp16_;
	libraw_output_params_t* _tmp17_;
	libraw_output_params_t* _tmp18_;
	libraw_output_params_t* _tmp19_;
	libraw_output_params_t* _tmp20_;
	libraw_output_params_t* _tmp21_;
	libraw_output_params_t* _tmp22_;
	libraw_output_params_t* _tmp23_;
	libraw_output_params_t* _tmp24_;
	libraw_output_params_t* _tmp25_;
	libraw_output_params_t* _tmp26_;
	libraw_output_params_t* _tmp27_;
	libraw_output_params_t* _tmp28_;
	libraw_output_params_t* _tmp29_;
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
	_tmp0_ = graw_processor_get_output_params (self);
	_tmp1_ = _tmp0_;
	lib_raw_output_params_set_chromatic_aberrations (_tmp1_, 1.0, 1.0);
	_tmp2_ = graw_processor_get_output_params (self);
	_tmp3_ = _tmp2_;
	lib_raw_output_params_set_gamma_curve (_tmp3_, GRAW_SRGB_POWER, GRAW_SRGB_SLOPE);
	_tmp4_ = graw_processor_get_output_params (self);
	_tmp5_ = _tmp4_;
	(*_tmp5_).bright = 1.0f;
	_tmp6_ = graw_processor_get_output_params (self);
	_tmp7_ = _tmp6_;
	(*_tmp7_).half_size = half_size;
	_tmp8_ = graw_processor_get_output_params (self);
	_tmp9_ = _tmp8_;
	(*_tmp9_).highlight = (gint) GRAW_HIGHLIGHT_MODE_CLIP;
	_tmp10_ = graw_processor_get_output_params (self);
	_tmp11_ = _tmp10_;
	(*_tmp11_).use_auto_wb = TRUE;
	_tmp12_ = graw_processor_get_output_params (self);
	_tmp13_ = _tmp12_;
	(*_tmp13_).use_camera_wb = TRUE;
	_tmp14_ = graw_processor_get_output_params (self);
	_tmp15_ = _tmp14_;
	(*_tmp15_).use_camera_matrix = (gint) GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE;
	_tmp16_ = graw_processor_get_output_params (self);
	_tmp17_ = _tmp16_;
	(*_tmp17_).output_color = (gint) GRAW_COLORSPACE_SRGB;
	_tmp18_ = graw_processor_get_output_params (self);
	_tmp19_ = _tmp18_;
	(*_tmp19_).output_bps = 8;
	_tmp20_ = graw_processor_get_output_params (self);
	_tmp21_ = _tmp20_;
	(*_tmp21_).user_flip = (gint) GRAW_FLIP_FROM_SOURCE;
	_tmp22_ = graw_processor_get_output_params (self);
	_tmp23_ = _tmp22_;
	(*_tmp23_).user_qual = (gint) GRAW_INTERPOLATION_QUALITY_PPG;
	_tmp24_ = graw_processor_get_output_params (self);
	_tmp25_ = _tmp24_;
	(*_tmp25_).no_auto_bright = TRUE;
	_tmp26_ = graw_processor_get_output_params (self);
	_tmp27_ = _tmp26_;
	(*_tmp27_).auto_bright_thr = 0.01f;
	_tmp28_ = graw_processor_get_output_params (self);
	_tmp29_ = _tmp28_;
	(*_tmp29_).use_fuji_rotate = (gint) GRAW_FUJI_ROTATE_USE;
}

libraw_output_params_t*
graw_processor_get_output_params (GRawProcessor* self)
{
	libraw_output_params_t* result;
	libraw_data_t* _tmp0_;
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
	_tmp0_ = self->priv->proc;
	result = &_tmp0_->params;
	return result;
}

static void
graw_value_processor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
graw_value_processor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		graw_processor_unref (value->data[0].v_pointer);
	}
}

static void
graw_value_processor_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = graw_processor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
graw_value_processor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
graw_value_processor_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GRawProcessor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = graw_processor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
graw_value_processor_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	GRawProcessor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = graw_processor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
graw_param_spec_processor (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	GRawParamSpecProcessor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
graw_value_get_processor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR), NULL);
	return value->data[0].v_pointer;
}

void
graw_value_set_processor (GValue* value,
                          gpointer v_object)
{
	GRawProcessor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		graw_processor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graw_processor_unref (old);
	}
}

void
graw_value_take_processor (GValue* value,
                           gpointer v_object)
{
	GRawProcessor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graw_processor_unref (old);
	}
}

static void
graw_processor_class_init (GRawProcessorClass * klass,
                           gpointer klass_data)
{
	graw_processor_parent_class = g_type_class_peek_parent (klass);
	((GRawProcessorClass *) klass)->finalize = graw_processor_finalize;
	g_type_class_adjust_private_offset (klass, &GRawProcessor_private_offset);
}

static void
graw_processor_instance_init (GRawProcessor * self,
                              gpointer klass)
{
	self->priv = graw_processor_get_instance_private (self);
	self->ref_count = 1;
}

static void
graw_processor_finalize (GRawProcessor * obj)
{
	GRawProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSOR, GRawProcessor);
	g_signal_handlers_destroy (self);
	_libraw_close0 (self->priv->proc);
}

static GType
graw_processor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { graw_value_processor_init, graw_value_processor_free_value, graw_value_processor_copy_value, graw_value_processor_peek_pointer, "p", graw_value_processor_collect_value, "p", graw_value_processor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GRawProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessor), 0, (GInstanceInitFunc) graw_processor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType graw_processor_type_id;
	graw_processor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GRawProcessor_private_offset = g_type_add_instance_private (graw_processor_type_id, sizeof (GRawProcessorPrivate));
	return graw_processor_type_id;
}

GType
graw_processor_get_type (void)
{
	static volatile gsize graw_processor_type_id__once = 0;
	if (g_once_init_enter (&graw_processor_type_id__once)) {
		GType graw_processor_type_id;
		graw_processor_type_id = graw_processor_get_type_once ();
		g_once_init_leave (&graw_processor_type_id__once, graw_processor_type_id);
	}
	return graw_processor_type_id__once;
}

gpointer
graw_processor_ref (gpointer instance)
{
	GRawProcessor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
graw_processor_unref (gpointer instance)
{
	GRawProcessor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRAW_PROCESSOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
graw_throw_exception (const gchar* caller,
                      enum LibRaw_errors _result_,
                      GError** error)
{
	gchar* msg = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (caller != NULL);
	if (_result_ == LIBRAW_SUCCESS) {
		return;
	} else {
		if (_result_ > 0) {
			const gchar* _tmp0_;
			GError* _tmp1_;
			_tmp0_ = g_strerror ((gint) _result_);
			_tmp1_ = g_error_new (GRAW_EXCEPTION, GRAW_EXCEPTION_SYSTEM_ERROR, "%s: System error %d: %s", caller, (gint) _result_, _tmp0_);
			_inner_error0_ = _tmp1_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp2_ = libraw_strerror (_result_);
	_tmp3_ = g_strdup_printf ("%s: %s", caller, _tmp2_);
	msg = _tmp3_;
	switch (_result_) {
		case LIBRAW_UNSPECIFIED_ERROR:
		{
			const gchar* _tmp4_;
			GError* _tmp5_;
			_tmp4_ = msg;
			_tmp5_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSPECIFIED, _tmp4_);
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_FILE_UNSUPPORTED:
		{
			const gchar* _tmp6_;
			GError* _tmp7_;
			_tmp6_ = msg;
			_tmp7_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE, _tmp6_);
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_REQUEST_FOR_NONEXISTENT_IMAGE:
		{
			const gchar* _tmp8_;
			GError* _tmp9_;
			_tmp8_ = msg;
			_tmp9_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NONEXISTANT_IMAGE, _tmp8_);
			_inner_error0_ = _tmp9_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_OUT_OF_ORDER_CALL:
		{
			const gchar* _tmp10_;
			GError* _tmp11_;
			_tmp10_ = msg;
			_tmp11_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_ORDER_CALL, _tmp10_);
			_inner_error0_ = _tmp11_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_NO_THUMBNAIL:
		{
			const gchar* _tmp12_;
			GError* _tmp13_;
			_tmp12_ = msg;
			_tmp13_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NO_THUMBNAIL, _tmp12_);
			_inner_error0_ = _tmp13_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_UNSUPPORTED_THUMBNAIL:
		{
			const gchar* _tmp14_;
			GError* _tmp15_;
			_tmp14_ = msg;
			_tmp15_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp14_);
			_inner_error0_ = _tmp15_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_UNSUFFICIENT_MEMORY:
		{
			const gchar* _tmp16_;
			GError* _tmp17_;
			_tmp16_ = msg;
			_tmp17_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_MEMORY, _tmp16_);
			_inner_error0_ = _tmp17_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_DATA_ERROR:
		{
			const gchar* _tmp18_;
			GError* _tmp19_;
			_tmp18_ = msg;
			_tmp19_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_DATA_ERROR, _tmp18_);
			_inner_error0_ = _tmp19_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_IO_ERROR:
		{
			const gchar* _tmp20_;
			GError* _tmp21_;
			_tmp20_ = msg;
			_tmp21_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_IO_ERROR, _tmp20_);
			_inner_error0_ = _tmp21_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_CANCELLED_BY_CALLBACK:
		{
			const gchar* _tmp22_;
			GError* _tmp23_;
			_tmp22_ = msg;
			_tmp23_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_CANCELLED_BY_CALLBACK, _tmp22_);
			_inner_error0_ = _tmp23_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case LIBRAW_BAD_CROP:
		{
			const gchar* _tmp24_;
			GError* _tmp25_;
			_tmp24_ = msg;
			_tmp25_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_BAD_CROP, _tmp24_);
			_inner_error0_ = _tmp25_;
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		default:
		{
			_g_free0 (msg);
			return;
		}
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

