/* DirectPhoto.c generated by valac 0.56.17, the Vala compiler
 * generated from DirectPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include "metadata.h"
#include <float.h>
#include <math.h>
#include <gee.h>
#include "shotwell-graphics-processor.h"

#define DIRECT_PHOTO_PREVIEW_BEST_FIT 360
#define DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_POSITIONABLE (positionable_get_type ())
#define POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITIONABLE, Positionable))
#define IS_POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITIONABLE))
#define POSITIONABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POSITIONABLE, PositionableIface))

typedef struct _Positionable Positionable;
typedef struct _PositionableIface PositionableIface;

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;
typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_DIRECT_PHOTO (direct_photo_get_type ())
#define DIRECT_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_PHOTO, DirectPhoto))
#define DIRECT_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_PHOTO, DirectPhotoClass))
#define IS_DIRECT_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_PHOTO))
#define IS_DIRECT_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_PHOTO))
#define DIRECT_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_PHOTO, DirectPhotoClass))

typedef struct _DirectPhoto DirectPhoto;
typedef struct _DirectPhotoClass DirectPhotoClass;
typedef struct _DirectPhotoPrivate DirectPhotoPrivate;
enum  {
	DIRECT_PHOTO_0_PROPERTY,
	DIRECT_PHOTO_NUM_PROPERTIES
};
static GParamSpec* direct_photo_properties[DIRECT_PHOTO_NUM_PROPERTIES];

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_DIRECT_PHOTO_SOURCE_COLLECTION (direct_photo_source_collection_get_type ())
#define DIRECT_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection))
#define DIRECT_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollectionClass))
#define IS_DIRECT_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION))
#define IS_DIRECT_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION))
#define DIRECT_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollectionClass))

typedef struct _DirectPhotoSourceCollection DirectPhotoSourceCollection;
typedef struct _DirectPhotoSourceCollectionClass DirectPhotoSourceCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())
typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _photo_import_params_unref0(var) ((var == NULL) ? NULL : (var = (photo_import_params_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
enum  {
	DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL,
	DIRECT_PHOTO_NUM_SIGNALS
};
static guint direct_photo_signals[DIRECT_PHOTO_NUM_SIGNALS] = {0};
typedef struct _DataCollectionPrivate DataCollectionPrivate;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _DirectPhotoSourceCollectionPrivate DirectPhotoSourceCollectionPrivate;

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	GDateTime* (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, gint* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	GDateTime* (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, GDateTime* target_time);
	GDateTime* (*get_exposure_time) (Dateable* self);
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _PositionableIface {
	GTypeInterface parent_iface;
	void (*get_gps_coords) (Positionable* self, GpsCoords* result);
	void (*set_gps_coords) (Positionable* self, GpsCoords* gps_coords);
};

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

struct _DirectPhoto {
	Photo parent_instance;
	DirectPhotoPrivate * priv;
};

struct _DirectPhotoClass {
	PhotoClass parent_class;
};

struct _DirectPhotoPrivate {
	GdkPixbuf* preview;
	gboolean loaded;
};

struct _PhotoID {
	gint64 id;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	gint64 time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	GpsCoords gps_coords;
	gchar* comment;
	gchar* backlinks;
	gint64 time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _DirectPhotoSourceCollection {
	DatabaseSourceCollection parent_instance;
	DirectPhotoSourceCollectionPrivate * priv;
};

struct _DirectPhotoSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
};

struct _DirectPhotoSourceCollectionPrivate {
	GeeCollection* prepared_photos;
	GeeHashMap* file_map;
	DirectoryMonitor* monitor;
};

static gint DirectPhoto_private_offset;
static gpointer direct_photo_parent_class = NULL;
VALA_EXTERN DirectPhotoSourceCollection* direct_photo_global;
DirectPhotoSourceCollection* direct_photo_global = NULL;
static gint DirectPhotoSourceCollection_private_offset;
static gpointer direct_photo_source_collection_parent_class = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN gpointer backing_file_state_ref (gpointer instance);
VALA_EXTERN void backing_file_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_backing_file_state (const GValue* value);
VALA_EXTERN GType backing_file_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingFileState, backing_file_state_unref)
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dateable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Dateable, g_object_unref)
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN GType positionable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Positionable, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType rotation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer photo_row_ref (gpointer instance);
VALA_EXTERN void photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_photo_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_photo_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_photo_row (const GValue* value);
VALA_EXTERN GType photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoRow, photo_row_unref)
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN GType direct_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectPhoto, g_object_unref)
VALA_EXTERN GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
VALA_EXTERN void photo_rotate (Photo* self,
                   Rotation rotation);
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN gboolean photo_has_user_generated_metadata (Photo* self);
VALA_EXTERN void photo_set_user_metadata_for_export (Photo* self,
                                         PhotoMetadata* metadata);
VALA_EXTERN void photo_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata);
VALA_EXTERN gboolean media_source_is_trashed (MediaSource* self);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
VALA_EXTERN void media_source_trash (MediaSource* self);
VALA_EXTERN void media_source_untrash (MediaSource* self);
VALA_EXTERN void media_source_mark_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_online (MediaSource* self);
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType direct_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectPhotoSourceCollection, data_collection_unref)
static DirectPhoto* direct_photo_new (PhotoRow* row);
static DirectPhoto* direct_photo_construct (GType object_type,
                                     PhotoRow* row);
VALA_EXTERN Photo* photo_construct (GType object_type,
                        PhotoRow* row);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void direct_photo_fixup_orientation_after_reimport (DirectPhoto* self,
                                                    Orientation dest);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void direct_photo_init (GFile* initial_file);
VALA_EXTERN void photo_init_photo (void);
VALA_EXTERN DirectPhotoSourceCollection* direct_photo_source_collection_new (GFile* initial_file);
VALA_EXTERN DirectPhotoSourceCollection* direct_photo_source_collection_construct (GType object_type,
                                                                       GFile* initial_file);
VALA_EXTERN gchar* direct_photo_source_collection_fetch (DirectPhotoSourceCollection* self,
                                             GFile* file,
                                             DirectPhoto** photo,
                                             gboolean reimport);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN void direct_photo_terminate (void);
VALA_EXTERN void photo_terminate_photo (void);
static void direct_photo_save_dims (DirectPhoto* self);
VALA_EXTERN GType backing_fetch_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GdkPixbuf* photo_get_pixbuf_with_options (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          BackingFetchMode fetch_mode,
                                          GError** error);
VALA_EXTERN void scaling_for_original (Scaling* result);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN GType import_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportResult direct_photo_demand_load (DirectPhoto* self);
VALA_EXTERN gpointer photo_reimport_master_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_master_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_master_state (const GValue* value);
VALA_EXTERN GType photo_reimport_master_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportMasterState, photo_reimport_master_state_unref)
VALA_EXTERN gboolean photo_prepare_for_reimport_master (Photo* self,
                                            PhotoReimportMasterState** reimport_state,
                                            GError** error);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_finish_reimport_master (Photo* self,
                                   PhotoReimportMasterState* state,
                                   GError** error);
VALA_EXTERN ImportResult direct_photo_internal_import (GFile* file,
                                           DirectPhoto** photo);
VALA_EXTERN gpointer photo_import_params_ref (gpointer instance);
VALA_EXTERN void photo_import_params_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_photo_import_params (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_photo_import_params (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_photo_import_params (const GValue* value);
VALA_EXTERN GType photo_import_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoImportParams, photo_import_params_unref)
VALA_EXTERN void import_id_generate (ImportID* result);
VALA_EXTERN PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file,
                                                               ImportID* import_id);
VALA_EXTERN PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type,
                                                                     GFile* file,
                                                                     ImportID* import_id);
VALA_EXTERN void photo_create_pre_import (PhotoImportParams* params);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoTable, database_table_unref)
VALA_EXTERN PhotoTable* photo_table_get_instance (void);
VALA_EXTERN void photo_table_add (PhotoTable* self,
                      PhotoRow* photo_row,
                      PhotoID* result);
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer thumbnails_ref (gpointer instance);
VALA_EXTERN void thumbnails_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_thumbnails (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_thumbnails (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_thumbnails (const GValue* value);
VALA_EXTERN GType thumbnails_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnails, thumbnails_unref)
static GdkPixbuf* direct_photo_real_get_preview_pixbuf (MediaSource* base,
                                                 Scaling* scaling,
                                                 GError** error);
VALA_EXTERN GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static void direct_photo_real_rotate (Photo* base,
                               Rotation rotation);
static GdkPixbuf* direct_photo_real_get_pixbuf (PhotoSource* base,
                                         Scaling* scaling,
                                         GError** error);
static GdkPixbuf* direct_photo_real_get_thumbnail (ThumbnailSource* base,
                                            gint scale,
                                            GError** error);
VALA_EXTERN PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
VALA_EXTERN guint photo_metadata_get_preview_count (PhotoMetadata* self);
VALA_EXTERN gpointer photo_preview_ref (gpointer instance);
VALA_EXTERN void photo_preview_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_photo_preview (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_photo_preview (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_photo_preview (const GValue* value);
VALA_EXTERN GType photo_preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoPreview, photo_preview_unref)
VALA_EXTERN PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
VALA_EXTERN GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self,
                                     GError** error);
VALA_EXTERN Orientation photo_get_orientation (Photo* self);
VALA_EXTERN GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
static void direct_photo_real_notify_altered (DataObject* base,
                                       Alteration* alteration);
static gboolean direct_photo_real_has_user_generated_metadata (Photo* base);
static void direct_photo_real_set_user_metadata_for_export (Photo* base,
                                                     PhotoMetadata* metadata);
static void direct_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                         PhotoMetadata* metadata);
static gboolean direct_photo_real_is_trashed (MediaSource* base);
static gboolean direct_photo_real_is_offline (MediaSource* base);
static void direct_photo_real_trash (MediaSource* base);
static void direct_photo_real_untrash (MediaSource* base);
static void direct_photo_real_mark_offline (MediaSource* base);
static void direct_photo_real_mark_online (MediaSource* base);
static void direct_photo_finalize (GObject * obj);
static GType direct_photo_get_type_once (void);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType directory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitor, g_object_unref)
VALA_EXTERN gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
VALA_EXTERN void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
VALA_EXTERN void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
VALA_EXTERN guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
VALA_EXTERN gboolean file_equal (GFile* a,
                     GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint64 direct_photo_source_collection_get_direct_key (DataSource* source);
static gint64 _direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source,
                                                                               gpointer self);
VALA_EXTERN DatabaseSourceCollection* database_source_collection_construct (GType object_type,
                                                                const gchar* name,
                                                                GetSourceDatabaseKey source_key_func,
                                                                gpointer source_key_func_target);
VALA_EXTERN DirectoryMonitor* directory_monitor_new (GFile* root,
                                         gboolean recurse,
                                         gboolean monitoring);
VALA_EXTERN DirectoryMonitor* directory_monitor_construct (GType object_type,
                                               GFile* root,
                                               gboolean recurse,
                                               gboolean monitoring);
static void direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self,
                                                        GFile* file,
                                                        GFileInfo* info);
static void _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender,
                                                                                           GFile* file,
                                                                                           GFileInfo* info,
                                                                                           gpointer self);
static void direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self);
static void _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                                   gpointer self);
VALA_EXTERN void directory_monitor_start_discovery (DirectoryMonitor* self);
static gboolean direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                   DataSource* source);
VALA_EXTERN void photo_get_photo_id (Photo* self,
                         PhotoID* result);
static void direct_photo_source_collection_real_notify_items_added (DataCollection* base,
                                                             GeeIterable* added);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
static void direct_photo_source_collection_real_notify_items_removed (DataCollection* base,
                                                               GeeIterable* removed);
VALA_EXTERN gboolean direct_photo_source_collection_has_source_for_file (DirectPhotoSourceCollection* self,
                                                             GFile* file);
VALA_EXTERN gboolean photo_file_format_is_file_supported (GFile* file);
static void direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
VALA_EXTERN gboolean direct_photo_source_collection_has_file (DirectPhotoSourceCollection* self,
                                                  GFile* file);
VALA_EXTERN void direct_photo_source_collection_reimport_photo (DirectPhotoSourceCollection* self,
                                                    DirectPhoto* photo);
VALA_EXTERN void photo_discard_prefetched (Photo* self);
VALA_EXTERN gboolean photo_only_metadata_changed (Photo* self);
VALA_EXTERN PhotoFileFormat photo_get_file_format (Photo* self);
VALA_EXTERN gchar* import_result_to_string (ImportResult self);
VALA_EXTERN gboolean direct_photo_source_collection_has_file_source (DirectPhotoSourceCollection* self,
                                                         GFile* file);
VALA_EXTERN DirectPhoto* direct_photo_source_collection_get_file_source (DirectPhotoSourceCollection* self,
                                                             GFile* file);
static void direct_photo_source_collection_finalize (DataCollection * obj);
static GType direct_photo_source_collection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
direct_photo_get_instance_private (DirectPhoto* self)
{
	return G_STRUCT_MEMBER_P (self, DirectPhoto_private_offset);
}

static DirectPhoto*
direct_photo_construct (GType object_type,
                        PhotoRow* row)
{
	DirectPhoto * self = NULL;
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
	self = (DirectPhoto*) photo_construct (object_type, row);
	return self;
}

static DirectPhoto*
direct_photo_new (PhotoRow* row)
{
	return direct_photo_construct (TYPE_DIRECT_PHOTO, row);
}

/**
     * @brief Because all transformations are discarded on reimport by design, including
     * Orientation, a JFIF file that is only rotated or flipped, then saved, has the orientation
     * change the user made before saving removed (recall that fetch() remembers which images it
     * has seen before and will only add a file to the file map once; every time it sees it
     * again after this is considered a reimport). This will set the orientation to the
     * specified value, fixing up both the row and the backing row.
     *
     * @warning Only reimported JFIF files should need this; non-lossy image types have their
     * actual pixels physically rotated in the file when they're exported.
     *
     * @param dest The orientation to set the photo to; usually, this should be a value
     * obtained by calling get_orientation() prior to export()ing a DirectPhoto.
     */
void
direct_photo_fixup_orientation_after_reimport (DirectPhoto* self,
                                               Orientation dest)
{
	PhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	g_return_if_fail (IS_DIRECT_PHOTO (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->row;
	_tmp0_->orientation = dest;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->backing_photo_row;
	_tmp1_->original_orientation = dest;
}

void
direct_photo_init (GFile* initial_file)
{
	DirectPhotoSourceCollection* _tmp0_;
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	DirectPhotoSourceCollection* _tmp1_;
	DirectPhoto* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	DirectPhotoSourceCollection* _tmp6_;
	DirectPhoto* _tmp7_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (initial_file, g_file_get_type ()));
	photo_init_photo ();
	_tmp0_ = direct_photo_source_collection_new (initial_file);
	_data_collection_unref0 (direct_photo_global);
	direct_photo_global = _tmp0_;
	_tmp1_ = direct_photo_global;
	_tmp3_ = direct_photo_source_collection_fetch (_tmp1_, initial_file, &_tmp2_, FALSE);
	_g_object_unref0 (photo);
	photo = _tmp2_;
	reason = _tmp3_;
	_tmp4_ = reason;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = reason;
		g_warning ("DirectPhoto.vala:47: fetch error: %s", _tmp5_);
	}
	_tmp6_ = direct_photo_global;
	_tmp7_ = photo;
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
	_g_free0 (reason);
	_g_object_unref0 (photo);
}

void
direct_photo_terminate (void)
{
	photo_terminate_photo ();
}

static void
direct_photo_save_dims (DirectPhoto* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DIRECT_PHOTO (self));
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_ = {0};
		GdkPixbuf* _tmp2_;
		BackingPhotoRow* _tmp3_;
		Dimensions _tmp4_ = {0};
		scaling_for_original (&_tmp1_);
		_tmp2_ = photo_get_pixbuf_with_options (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp1_, (PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_STRAIGHTEN) | PHOTO_EXCEPTION_ORIENTATION, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->backing_photo_row;
		dimensions_for_pixbuf (_tmp0_, &_tmp4_);
		_tmp3_->dim = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp6_ = _tmp5_;
		g_warning ("DirectPhoto.vala:62: Dimensions for image %s could not be gotten.", _tmp6_);
		_g_free0 (_tmp6_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

ImportResult
direct_photo_demand_load (DirectPhoto* self)
{
	PhotoReimportMasterState* reimport_state = NULL;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (IS_DIRECT_PHOTO (self), 0);
	if (self->priv->loaded) {
		direct_photo_save_dims (self);
		result = IMPORT_RESULT_SUCCESS;
		return result;
	}
	{
		PhotoReimportMasterState* _tmp0_ = NULL;
		PhotoReimportMasterState* _tmp1_;
		photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp0_, &_inner_error0_);
		_photo_reimport_master_state_unref0 (reimport_state);
		reimport_state = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = reimport_state;
		photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("DirectPhoto.vala:78: Database error on re-importing image: %s", _tmp3_);
		result = IMPORT_RESULT_DATABASE_ERROR;
		_g_error_free0 (err);
		_photo_reimport_master_state_unref0 (reimport_state);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_reimport_master_state_unref0 (reimport_state);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	self->priv->loaded = TRUE;
	direct_photo_save_dims (self);
	result = IMPORT_RESULT_SUCCESS;
	_photo_reimport_master_state_unref0 (reimport_state);
	return result;
}

ImportResult
direct_photo_internal_import (GFile* file,
                              DirectPhoto** photo)
{
	DirectPhoto* _vala_photo = NULL;
	PhotoImportParams* params = NULL;
	ImportID _tmp0_ = {0};
	PhotoImportParams* _tmp1_;
	PhotoTable* _tmp2_;
	PhotoTable* _tmp3_;
	PhotoRow* _tmp4_;
	PhotoID _tmp5_ = {0};
	PhotoRow* _tmp6_;
	DirectPhoto* _tmp7_;
	ImportResult result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0);
	import_id_generate (&_tmp0_);
	_tmp1_ = photo_import_params_new_create_placeholder (file, &_tmp0_);
	params = _tmp1_;
	photo_create_pre_import (params);
	_tmp2_ = photo_table_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = params->row;
	photo_table_add (_tmp3_, _tmp4_, &_tmp5_);
	_database_table_unref0 (_tmp3_);
	_tmp6_ = params->row;
	_tmp7_ = direct_photo_new (_tmp6_);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp7_;
	result = IMPORT_RESULT_SUCCESS;
	_photo_import_params_unref0 (params);
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

static GdkPixbuf*
direct_photo_real_get_preview_pixbuf (MediaSource* base,
                                      Scaling* scaling,
                                      GError** error)
{
	DirectPhoto * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = self->priv->preview;
	if (_tmp0_ == NULL) {
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), DIRECT_PHOTO_PREVIEW_BEST_FIT, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->preview);
		self->priv->preview = _tmp3_;
		_tmp4_ = self->priv->preview;
		if (_tmp4_ == NULL) {
			GdkPixbuf* _tmp5_ = NULL;
			Scaling _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp6_ = *scaling;
			_tmp7_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp6_, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp1_);
				return NULL;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (self->priv->preview);
			self->priv->preview = _tmp8_;
			_g_object_unref0 (_tmp5_);
		}
		_g_object_unref0 (_tmp1_);
	}
	_tmp9_ = self->priv->preview;
	_tmp10_ = scaling_perform_on_pixbuf (scaling, _tmp9_, GDK_INTERP_BILINEAR, TRUE);
	result = _tmp10_;
	return result;
}

static void
direct_photo_real_rotate (Photo* base,
                          Rotation rotation)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->can_rotate_now = FALSE;
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, FALSE);
	PHOTO_CLASS (direct_photo_parent_class)->rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), rotation);
}

static GdkPixbuf*
direct_photo_real_get_pixbuf (PhotoSource* base,
                              Scaling* scaling,
                              GError** error)
{
	DirectPhoto * self;
	GdkPixbuf* ret = NULL;
	Scaling _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = *scaling;
	_tmp1_ = PHOTO_SOURCE_CLASS (direct_photo_parent_class)->get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_PHOTO_SOURCE, PhotoSource), &_tmp0_, &_inner_error0_);
	ret = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, TRUE);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->can_rotate_now = TRUE;
	result = ret;
	return result;
}

static GdkPixbuf*
direct_photo_real_get_thumbnail (ThumbnailSource* base,
                                 gint scale,
                                 GError** error)
{
	DirectPhoto * self;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoMetadata* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	metadata = _tmp0_;
	_tmp3_ = metadata;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PhotoMetadata* _tmp4_;
		_tmp4_ = metadata;
		_tmp2_ = photo_metadata_get_preview_count (_tmp4_) == ((guint) 0);
	}
	if (_tmp2_) {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	} else {
		GdkPixbuf* _tmp5_ = NULL;
		PhotoMetadata* _tmp6_;
		PhotoPreview* _tmp7_;
		PhotoPreview* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp6_ = metadata;
		_tmp7_ = photo_metadata_get_preview (_tmp6_, (guint) 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = photo_preview_get_pixbuf (_tmp8_, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_photo_preview_unref0 (_tmp8_);
		_tmp5_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp1_);
			_media_metadata_unref0 (metadata);
			return NULL;
		}
		_tmp11_ = orientation_rotate_pixbuf (photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)), _tmp5_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp11_;
		_g_object_unref0 (_tmp5_);
	}
	result = _tmp1_;
	_media_metadata_unref0 (metadata);
	return result;
}

static void
direct_photo_real_notify_altered (DataObject* base,
                                  Alteration* alteration)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	g_return_if_fail (IS_ALTERATION (alteration));
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = NULL;
	DATA_OBJECT_CLASS (direct_photo_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_DATA_OBJECT, DataObject), alteration);
}

static gboolean
direct_photo_real_has_user_generated_metadata (Photo* base)
{
	DirectPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	result = FALSE;
	return result;
}

static void
direct_photo_real_set_user_metadata_for_export (Photo* base,
                                                PhotoMetadata* metadata)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
}

static void
direct_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                    PhotoMetadata* metadata)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
}

static gboolean
direct_photo_real_is_trashed (MediaSource* base)
{
	DirectPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	result = FALSE;
	return result;
}

static gboolean
direct_photo_real_is_offline (MediaSource* base)
{
	DirectPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
	result = FALSE;
	return result;
}

static void
direct_photo_real_trash (MediaSource* base)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
}

static void
direct_photo_real_untrash (MediaSource* base)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
}

static void
direct_photo_real_mark_offline (MediaSource* base)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
}

static void
direct_photo_real_mark_online (MediaSource* base)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
}

static void
direct_photo_class_init (DirectPhotoClass * klass,
                         gpointer klass_data)
{
	direct_photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectPhoto_private_offset);
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) direct_photo_real_get_preview_pixbuf;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) direct_photo_real_rotate;
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource*, Scaling*, GError**)) direct_photo_real_get_pixbuf;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) direct_photo_real_get_thumbnail;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) direct_photo_real_notify_altered;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) direct_photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) direct_photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) direct_photo_real_apply_user_metadata_for_reimport;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) direct_photo_real_is_trashed;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) direct_photo_real_is_offline;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) direct_photo_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) direct_photo_real_untrash;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) direct_photo_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) direct_photo_real_mark_online;
	G_OBJECT_CLASS (klass)->finalize = direct_photo_finalize;
	direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL] = g_signal_new ("can-rotate-changed", TYPE_DIRECT_PHOTO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
direct_photo_instance_init (DirectPhoto * self,
                            gpointer klass)
{
	self->priv = direct_photo_get_instance_private (self);
	self->priv->preview = NULL;
	self->priv->loaded = FALSE;
}

static void
direct_photo_finalize (GObject * obj)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO, DirectPhoto);
	_g_object_unref0 (self->priv->preview);
	G_OBJECT_CLASS (direct_photo_parent_class)->finalize (obj);
}

static GType
direct_photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhoto), 0, (GInstanceInitFunc) direct_photo_instance_init, NULL };
	GType direct_photo_type_id;
	direct_photo_type_id = g_type_register_static (TYPE_PHOTO, "DirectPhoto", &g_define_type_info, 0);
	DirectPhoto_private_offset = g_type_add_instance_private (direct_photo_type_id, sizeof (DirectPhotoPrivate));
	return direct_photo_type_id;
}

GType
direct_photo_get_type (void)
{
	static volatile gsize direct_photo_type_id__once = 0;
	if (g_once_init_enter (&direct_photo_type_id__once)) {
		GType direct_photo_type_id;
		direct_photo_type_id = direct_photo_get_type_once ();
		g_once_init_leave (&direct_photo_type_id__once, direct_photo_type_id);
	}
	return direct_photo_type_id__once;
}

static inline gpointer
direct_photo_source_collection_get_instance_private (DirectPhotoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, DirectPhotoSourceCollection_private_offset);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gint64
_direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source,
                                                                        gpointer self)
{
	gint64 result;
	result = direct_photo_source_collection_get_direct_key (source);
	return result;
}

static void
_direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender,
                                                                                      GFile* file,
                                                                                      GFileInfo* info,
                                                                                      gpointer self)
{
	direct_photo_source_collection_on_file_discovered ((DirectPhotoSourceCollection*) self, file, info);
}

static void
_direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                              gpointer self)
{
	direct_photo_source_collection_on_discovery_completed ((DirectPhotoSourceCollection*) self);
}

DirectPhotoSourceCollection*
direct_photo_source_collection_construct (GType object_type,
                                          GFile* initial_file)
{
	DirectPhotoSourceCollection* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DirectoryMonitor* _tmp2_;
	DirectoryMonitor* _tmp3_;
	DirectoryMonitor* _tmp4_;
	DirectoryMonitor* _tmp5_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (initial_file, g_file_get_type ()), NULL);
	self = (DirectPhotoSourceCollection*) database_source_collection_construct (object_type, "DirectPhotoSourceCollection", _direct_photo_source_collection_get_direct_key_get_source_database_key, NULL);
	_tmp0_ = g_file_get_parent (initial_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = directory_monitor_new (_tmp1_, FALSE, FALSE);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->monitor;
	g_signal_connect (_tmp3_, "file-discovered", (GCallback) _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered, self);
	_tmp4_ = self->priv->monitor;
	g_signal_connect (_tmp4_, "discovery-completed", (GCallback) _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed, self);
	_tmp5_ = self->priv->monitor;
	directory_monitor_start_discovery (_tmp5_);
	return self;
}

DirectPhotoSourceCollection*
direct_photo_source_collection_new (GFile* initial_file)
{
	return direct_photo_source_collection_construct (TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, initial_file);
}

static gboolean
direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                          DataSource* source)
{
	DirectPhotoSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = IS_DIRECT_PHOTO (source);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint64
direct_photo_source_collection_get_direct_key (DataSource* source)
{
	DirectPhoto* photo = NULL;
	DirectPhoto* _tmp0_;
	PhotoID photo_id = {0};
	PhotoID _tmp1_ = {0};
	PhotoID _tmp2_;
	gint64 result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DIRECT_PHOTO, DirectPhoto));
	photo = _tmp0_;
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo), &_tmp1_);
	photo_id = _tmp1_;
	_tmp2_ = photo_id;
	result = _tmp2_.id;
	_g_object_unref0 (photo);
	return result;
}

static void
direct_photo_source_collection_real_notify_items_added (DataCollection* base,
                                                        GeeIterable* added)
{
	DirectPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp4_;
			DirectPhoto* _tmp5_;
			GFile* file = NULL;
			DirectPhoto* _tmp6_;
			GFile* _tmp7_;
			GeeHashMap* _tmp8_;
			GFile* _tmp9_;
			GeeHashMap* _tmp10_;
			GFile* _tmp11_;
			DirectPhoto* _tmp12_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DIRECT_PHOTO, DirectPhoto));
			photo = _tmp5_;
			_tmp6_ = photo;
			_tmp7_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
			file = _tmp7_;
			_tmp8_ = self->priv->file_map;
			_tmp9_ = file;
			_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_), "!file_map.has_key(file)");
			_tmp10_ = self->priv->file_map;
			_tmp11_ = file;
			_tmp12_ = photo;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, _tmp12_);
			_g_object_unref0 (file);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added);
}

static void
direct_photo_source_collection_real_notify_items_removed (DataCollection* base,
                                                          GeeIterable* removed)
{
	DirectPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp4_;
			DirectPhoto* _tmp5_;
			GFile* file = NULL;
			DirectPhoto* _tmp6_;
			GFile* _tmp7_;
			gboolean is_removed = FALSE;
			GeeHashMap* _tmp8_;
			GFile* _tmp9_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DIRECT_PHOTO, DirectPhoto));
			photo = _tmp5_;
			_tmp6_ = photo;
			_tmp7_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
			file = _tmp7_;
			_tmp8_ = self->priv->file_map;
			_tmp9_ = file;
			is_removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, NULL);
			_vala_assert (is_removed, "is_removed");
			_g_object_unref0 (file);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), removed);
}

gboolean
direct_photo_source_collection_has_source_for_file (DirectPhotoSourceCollection* self,
                                                    GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	return result;
}

static void
direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self,
                                                   GFile* file,
                                                   GFileInfo* info)
{
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	DirectPhoto* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeCollection* _tmp4_;
	DirectPhoto* _tmp5_;
	GeeCollection* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (direct_photo_source_collection_has_source_for_file (self, file)) {
		return;
	}
	if (!photo_file_format_is_file_supported (file)) {
		return;
	}
	_tmp1_ = direct_photo_source_collection_fetch (self, file, &_tmp0_, FALSE);
	_g_object_unref0 (photo);
	photo = _tmp0_;
	reason = _tmp1_;
	_tmp2_ = reason;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = reason;
		g_warning ("DirectPhoto.vala:245: Error fetching file: %s", _tmp3_);
	}
	_tmp4_ = self->priv->prepared_photos;
	_tmp5_ = photo;
	gee_collection_add (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->prepared_photos;
	_tmp7_ = gee_collection_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ >= DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD) {
		direct_photo_source_collection_flush_prepared_photos (self);
	}
	_g_free0 (reason);
	_g_object_unref0 (photo);
}

static void
direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self)
{
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
	direct_photo_source_collection_flush_prepared_photos (self);
}

static void
direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
	_tmp0_ = self->priv->prepared_photos;
	_tmp1_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp0_, NULL, NULL);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->prepared_photos;
	gee_collection_clear (_tmp3_);
}

gboolean
direct_photo_source_collection_has_file (DirectPhotoSourceCollection* self,
                                         GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	return result;
}

void
direct_photo_source_collection_reimport_photo (DirectPhotoSourceCollection* self,
                                               DirectPhoto* photo)
{
	DirectPhoto* reimported_photo = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DirectPhoto* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_DIRECT_PHOTO (photo));
	photo_discard_prefetched (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = _tmp0_;
	_tmp3_ = direct_photo_source_collection_fetch (self, _tmp1_, &_tmp2_, TRUE);
	_g_object_unref0 (reimported_photo);
	reimported_photo = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (reimported_photo);
}

gchar*
direct_photo_source_collection_fetch (DirectPhotoSourceCollection* self,
                                      GFile* file,
                                      DirectPhoto** photo,
                                      gboolean reimport)
{
	DirectPhoto* _vala_photo = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DirectPhoto* _tmp2_;
	ImportResult _result_ = 0;
	DirectPhoto* _tmp18_ = NULL;
	ImportResult _tmp19_;
	gchar* _tmp20_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->file_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	_g_object_unref0 (_vala_photo);
	_vala_photo = (DirectPhoto*) _tmp1_;
	_tmp2_ = _vala_photo;
	if (_tmp2_ != NULL) {
		gchar* reason = NULL;
		reason = NULL;
		if (reimport) {
			{
				Orientation ori_tmp = 0;
				gboolean should_restore_ori = FALSE;
				gboolean _tmp3_ = FALSE;
				DirectPhoto* _tmp4_;
				PhotoReimportMasterState* reimport_state = NULL;
				gboolean _tmp7_ = FALSE;
				DirectPhoto* _tmp8_;
				PhotoReimportMasterState* _tmp9_ = NULL;
				gboolean _tmp10_;
				ori_tmp = ORIENTATION_TOP_LEFT;
				should_restore_ori = FALSE;
				_tmp4_ = _vala_photo;
				if (photo_only_metadata_changed (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO, Photo))) {
					_tmp3_ = TRUE;
				} else {
					DirectPhoto* _tmp5_;
					_tmp5_ = _vala_photo;
					_tmp3_ = photo_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_JFIF;
				}
				if (_tmp3_) {
					DirectPhoto* _tmp6_;
					_tmp6_ = _vala_photo;
					ori_tmp = photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
					should_restore_ori = TRUE;
				}
				_tmp8_ = _vala_photo;
				_tmp10_ = photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo), &_tmp9_, &_inner_error0_);
				_photo_reimport_master_state_unref0 (reimport_state);
				reimport_state = _tmp9_;
				_tmp7_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_reimport_master_state_unref0 (reimport_state);
					goto __catch0_g_error;
				}
				if (_tmp7_) {
					DirectPhoto* _tmp11_;
					PhotoReimportMasterState* _tmp12_;
					_tmp11_ = _vala_photo;
					_tmp12_ = reimport_state;
					photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PHOTO, Photo), _tmp12_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_photo_reimport_master_state_unref0 (reimport_state);
						goto __catch0_g_error;
					}
					if (should_restore_ori) {
						DirectPhoto* _tmp13_;
						_tmp13_ = _vala_photo;
						direct_photo_fixup_orientation_after_reimport (_tmp13_, ori_tmp);
					}
				} else {
					gchar* _tmp14_;
					_tmp14_ = import_result_to_string (IMPORT_RESULT_FILE_ERROR);
					_g_free0 (reason);
					reason = _tmp14_;
				}
				_photo_reimport_master_state_unref0 (reimport_state);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = err;
				_tmp16_ = _tmp15_->message;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (reason);
				reason = _tmp17_;
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (reason);
				_g_object_unref0 (_vala_photo);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = reason;
		if (photo) {
			*photo = _vala_photo;
		} else {
			_g_object_unref0 (_vala_photo);
		}
		return result;
	}
	_tmp19_ = direct_photo_internal_import (file, &_tmp18_);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp18_;
	_result_ = _tmp19_;
	if (_result_ == IMPORT_RESULT_SUCCESS) {
		_g_free0 (_tmp20_);
		_tmp20_ = NULL;
	} else {
		gchar* _tmp21_;
		_tmp21_ = import_result_to_string (_result_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp21_;
	}
	result = _tmp20_;
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

gboolean
direct_photo_source_collection_has_file_source (DirectPhotoSourceCollection* self,
                                                GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	return result;
}

DirectPhoto*
direct_photo_source_collection_get_file_source (DirectPhotoSourceCollection* self,
                                                GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DirectPhoto* result;
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->file_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (DirectPhoto*) _tmp1_;
	return result;
}

static void
direct_photo_source_collection_class_init (DirectPhotoSourceCollectionClass * klass,
                                           gpointer klass_data)
{
	direct_photo_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = direct_photo_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &DirectPhotoSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) direct_photo_source_collection_real_holds_type_of_source;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) direct_photo_source_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) direct_photo_source_collection_real_notify_items_removed;
}

static void
direct_photo_source_collection_instance_init (DirectPhotoSourceCollection * self,
                                              gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = direct_photo_source_collection_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->prepared_photos = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->file_map = _tmp1_;
}

static void
direct_photo_source_collection_finalize (DataCollection * obj)
{
	DirectPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
	_g_object_unref0 (self->priv->prepared_photos);
	_g_object_unref0 (self->priv->file_map);
	_g_object_unref0 (self->priv->monitor);
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->finalize (obj);
}

static GType
direct_photo_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhotoSourceCollection), 0, (GInstanceInitFunc) direct_photo_source_collection_instance_init, NULL };
	GType direct_photo_source_collection_type_id;
	direct_photo_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "DirectPhotoSourceCollection", &g_define_type_info, 0);
	DirectPhotoSourceCollection_private_offset = g_type_add_instance_private (direct_photo_source_collection_type_id, sizeof (DirectPhotoSourceCollectionPrivate));
	return direct_photo_source_collection_type_id;
}

GType
direct_photo_source_collection_get_type (void)
{
	static volatile gsize direct_photo_source_collection_type_id__once = 0;
	if (g_once_init_enter (&direct_photo_source_collection_type_id__once)) {
		GType direct_photo_source_collection_type_id;
		direct_photo_source_collection_type_id = direct_photo_source_collection_get_type_once ();
		g_once_init_leave (&direct_photo_source_collection_type_id__once, direct_photo_source_collection_type_id);
	}
	return direct_photo_source_collection_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

