/* AdjustDateTimeDialog.c generated by valac 0.56.17, the Vala compiler
 * generated from AdjustDateTimeDialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_DAY ((gint64) ((60 * 60) * 24))
#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_HOUR ((gint64) (60 * 60))
#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_MINUTE ((gint64) 60)
#define ADJUST_DATE_TIME_DIALOG_YEAR_OFFSET 1900
#define ADJUST_DATE_TIME_DIALOG_CALENDAR_THUMBNAIL_SCALE 1
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_OK_LABEL _ ("_OK")
#define RESOURCES_ADJUST_DATE_TIME_LABEL _ ("Adjust Date and Time")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADJUST_DATE_TIME_DIALOG (adjust_date_time_dialog_get_type ())
#define ADJUST_DATE_TIME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialog))
#define ADJUST_DATE_TIME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialogClass))
#define IS_ADJUST_DATE_TIME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADJUST_DATE_TIME_DIALOG))
#define IS_ADJUST_DATE_TIME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADJUST_DATE_TIME_DIALOG))
#define ADJUST_DATE_TIME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialogClass))

typedef struct _AdjustDateTimeDialog AdjustDateTimeDialog;
typedef struct _AdjustDateTimeDialogClass AdjustDateTimeDialogClass;
typedef struct _AdjustDateTimeDialogPrivate AdjustDateTimeDialogPrivate;
typedef enum  {
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM,
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM,
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR
} AdjustDateTimeDialogTimeSystem;

#define ADJUST_DATE_TIME_DIALOG_TYPE_TIME_SYSTEM (adjust_date_time_dialog_time_system_get_type ())
enum  {
	ADJUST_DATE_TIME_DIALOG_0_PROPERTY,
	ADJUST_DATE_TIME_DIALOG_NUM_PROPERTIES
};
static GParamSpec* adjust_date_time_dialog_properties[ADJUST_DATE_TIME_DIALOG_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdjustDateTimeDialog {
	GtkDialog parent_instance;
	AdjustDateTimeDialogPrivate * priv;
};

struct _AdjustDateTimeDialogClass {
	GtkDialogClass parent_class;
};

struct _AdjustDateTimeDialogPrivate {
	gboolean no_original_time;
	GDateTime* original_time;
	GtkLabel* original_time_label;
	GtkCalendar* calendar;
	GtkSpinButton* hour;
	GtkSpinButton* minute;
	GtkSpinButton* second;
	GtkComboBoxText* system;
	GtkRadioButton* relativity_radio_button;
	GtkRadioButton* batch_radio_button;
	GtkCheckButton* modify_originals_check_button;
	GtkLabel* notification;
	AdjustDateTimeDialogTimeSystem previous_time_system;
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, GDateTime* target_time);
	GDateTime* (*get_exposure_time) (Dateable* self);
};

static gint AdjustDateTimeDialog_private_offset;
static gpointer adjust_date_time_dialog_parent_class = NULL;

VALA_EXTERN GType adjust_date_time_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdjustDateTimeDialog, g_object_unref)
static GType adjust_date_time_dialog_time_system_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType dateable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Dateable, g_object_unref)
VALA_EXTERN AdjustDateTimeDialog* adjust_date_time_dialog_new (Dateable* source,
                                                   gint photo_count,
                                                   gboolean display_options,
                                                   gboolean contains_video,
                                                   gboolean only_video);
VALA_EXTERN AdjustDateTimeDialog* adjust_date_time_dialog_construct (GType object_type,
                                                         Dateable* source,
                                                         gint photo_count,
                                                         gboolean display_options,
                                                         gboolean contains_video,
                                                         gboolean only_video);
VALA_EXTERN gint resources_use_header_bar (void);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
static void adjust_date_time_dialog_on_time_changed (AdjustDateTimeDialog* self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                         gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed (GtkCalendar* _sender,
                                                                          gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year (GtkCalendar* _sender,
                                                                      gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year (GtkCalendar* _sender,
                                                                      gpointer self);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
static gboolean adjust_date_time_dialog_on_spin_button_output (AdjustDateTimeDialog* self,
                                                        GtkSpinButton* button);
static gboolean _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                                gpointer self);
static void adjust_date_time_dialog_on_time_system_changed (AdjustDateTimeDialog* self);
static void _adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self);
VALA_EXTERN gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
static void _adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
VALA_EXTERN gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
VALA_EXTERN GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN GDateTime* dateable_get_exposure_time (Dateable* self);
static void adjust_date_time_dialog_set_time (AdjustDateTimeDialog* self,
                                       GDateTime* time);
static void adjust_date_time_dialog_set_original_time_label (AdjustDateTimeDialog* self,
                                                      gboolean use_24_hr_format);
static GDateTime* adjust_date_time_dialog_get_time (AdjustDateTimeDialog* self);
VALA_EXTERN gboolean adjust_date_time_dialog_execute (AdjustDateTimeDialog* self,
                                          GTimeSpan* time_shift,
                                          gboolean* keep_relativity,
                                          gboolean* modify_originals);
VALA_EXTERN void configuration_facade_set_keep_relativity (ConfigurationFacade* self,
                                               gboolean keep_relativity);
VALA_EXTERN void configuration_facade_set_modify_originals (ConfigurationFacade* self,
                                                gboolean modify_originals);
VALA_EXTERN void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self,
                                                gboolean use_24_hour_time);
static void adjust_date_time_dialog_finalize (GObject * obj);
static GType adjust_date_time_dialog_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
adjust_date_time_dialog_get_instance_private (AdjustDateTimeDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustDateTimeDialog_private_offset);
}

static GType
adjust_date_time_dialog_time_system_get_type_once (void)
{
	static const GEnumValue values[] = {{ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM", "am"}, {ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM", "pm"}, {ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR", "24hr"}, {0, NULL, NULL}};
	GType adjust_date_time_dialog_time_system_type_id;
	adjust_date_time_dialog_time_system_type_id = g_enum_register_static ("AdjustDateTimeDialogTimeSystem", values);
	return adjust_date_time_dialog_time_system_type_id;
}

static GType
adjust_date_time_dialog_time_system_get_type (void)
{
	static volatile gsize adjust_date_time_dialog_time_system_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_dialog_time_system_type_id__once)) {
		GType adjust_date_time_dialog_time_system_type_id;
		adjust_date_time_dialog_time_system_type_id = adjust_date_time_dialog_time_system_get_type_once ();
		g_once_init_leave (&adjust_date_time_dialog_time_system_type_id__once, adjust_date_time_dialog_time_system_type_id);
	}
	return adjust_date_time_dialog_time_system_type_id__once;
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                    gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed (GtkCalendar* _sender,
                                                                     gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year (GtkCalendar* _sender,
                                                                 gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year (GtkCalendar* _sender,
                                                                 gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static gboolean
_adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                       gpointer self)
{
	gboolean result;
	result = adjust_date_time_dialog_on_spin_button_output ((AdjustDateTimeDialog*) self, _sender);
	return result;
}

static void
_adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self)
{
	adjust_date_time_dialog_on_time_system_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AdjustDateTimeDialog*
adjust_date_time_dialog_construct (GType object_type,
                                   Dateable* source,
                                   gint photo_count,
                                   gboolean display_options,
                                   gboolean contains_video,
                                   gboolean only_video)
{
	AdjustDateTimeDialog * self = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GtkCalendar* _tmp2_;
	GtkCalendar* _tmp3_;
	GtkCalendar* _tmp4_;
	GtkCalendar* _tmp5_;
	GtkCalendar* _tmp6_;
	GtkCalendar* _tmp7_;
	ConfigFacade* _tmp8_;
	ConfigFacade* _tmp9_;
	gboolean _tmp10_;
	GtkSpinButton* _tmp13_;
	GtkSpinButton* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkSpinButton* _tmp16_;
	GtkSpinButton* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkSpinButton* _tmp20_;
	GtkSpinButton* _tmp21_;
	GtkSpinButton* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkComboBoxText* _tmp24_;
	GtkComboBoxText* _tmp25_;
	GtkComboBoxText* _tmp26_;
	GtkComboBoxText* _tmp27_;
	GtkComboBoxText* _tmp28_;
	GtkBox* clock = NULL;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkSpinButton* _tmp31_;
	GtkBox* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkBox* _tmp35_;
	GtkSpinButton* _tmp36_;
	GtkBox* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkBox* _tmp40_;
	GtkSpinButton* _tmp41_;
	GtkBox* _tmp42_;
	GtkComboBoxText* _tmp43_;
	GtkRadioButton* _tmp44_;
	GtkRadioButton* _tmp45_;
	ConfigFacade* _tmp46_;
	ConfigFacade* _tmp47_;
	gboolean _tmp48_ = FALSE;
	GtkRadioButton* _tmp49_;
	GtkRadioButton* _tmp50_;
	GSList* _tmp51_;
	GtkRadioButton* _tmp52_;
	GtkRadioButton* _tmp53_;
	ConfigFacade* _tmp54_;
	ConfigFacade* _tmp55_;
	gboolean _tmp56_ = FALSE;
	GtkRadioButton* _tmp57_;
	GtkRadioButton* _tmp58_;
	gboolean _tmp65_ = FALSE;
	ConfigFacade* _tmp66_;
	ConfigFacade* _tmp67_;
	gboolean _tmp68_;
	GtkCheckButton* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GtkCheckButton* _tmp75_;
	GtkBox* time_content = NULL;
	GtkBox* _tmp76_;
	GtkBox* picker = NULL;
	GtkBox* _tmp77_;
	GtkComboBoxText* combo = NULL;
	GtkComboBoxText* _tmp78_;
	GtkBox* _tmp89_;
	GtkComboBoxText* _tmp90_;
	GtkSpinButton* spin = NULL;
	GtkSpinButton* _tmp91_;
	GtkBox* _tmp92_;
	GtkSpinButton* _tmp93_;
	GtkSpinButton* _tmp94_;
	GtkCalendar* _tmp95_;
	GtkComboBoxText* _tmp96_;
	GtkCalendar* _tmp97_;
	GtkBox* _tmp98_;
	GtkBox* _tmp99_;
	GtkBox* _tmp100_;
	GtkCalendar* _tmp101_;
	GtkBox* _tmp102_;
	GtkBox* _tmp103_;
	GdkPixbuf* preview = NULL;
	GtkBox* image_content = NULL;
	GtkBox* _tmp115_;
	GtkBox* _tmp116_;
	GtkBox* _tmp117_;
	GtkImage* _tmp118_ = NULL;
	GdkPixbuf* _tmp119_;
	GtkImage* image = NULL;
	GtkImage* _tmp123_;
	GtkLabel* _tmp124_;
	GtkBox* _tmp125_;
	GtkImage* _tmp126_;
	GtkBox* _tmp127_;
	GtkLabel* _tmp128_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp129_;
	GtkBox* _tmp130_;
	GtkBox* _tmp131_;
	GtkBox* _tmp132_;
	GtkBox* _tmp133_;
	GtkBox* _tmp134_;
	GtkBox* _tmp135_;
	GtkBox* _tmp136_;
	GtkBox* _tmp137_;
	GtkBox* _tmp138_;
	GtkBox* _tmp139_;
	GtkBox* _tmp140_;
	GtkLabel* _tmp141_;
	GtkLabel* _tmp142_;
	GtkLabel* _tmp143_;
	GtkBox* _tmp144_;
	GtkLabel* _tmp145_;
	GDateTime* _tmp146_;
	GDateTime* _tmp147_;
	GDateTime* _tmp149_;
	GDateTime* _tmp150_;
	GDateTime* _tmp151_;
	ConfigFacade* _tmp152_;
	ConfigFacade* _tmp153_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (IS_DATEABLE (source), NULL);
	_vala_assert (source != NULL, "source != null");
	self = (AdjustDateTimeDialog*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_window_set_resizable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), FALSE);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_g_object_unref0 (_tmp1_);
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_CANCEL_LABEL, GTK_RESPONSE_CANCEL, RESOURCES_OK_LABEL, GTK_RESPONSE_OK, NULL);
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), RESOURCES_ADJUST_DATE_TIME_LABEL);
	_tmp2_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->calendar);
	self->priv->calendar = _tmp2_;
	_tmp3_ = self->priv->calendar;
	g_object_set (_tmp3_, "show-heading", FALSE, NULL);
	_tmp4_ = self->priv->calendar;
	g_signal_connect_object (_tmp4_, "day-selected", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected, self, 0);
	_tmp5_ = self->priv->calendar;
	g_signal_connect_object (_tmp5_, "month-changed", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed, self, 0);
	_tmp6_ = self->priv->calendar;
	g_signal_connect_object (_tmp6_, "next-year", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year, self, 0);
	_tmp7_ = self->priv->calendar;
	g_signal_connect_object (_tmp7_, "prev-year", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year, self, 0);
	_tmp8_ = config_facade_get_instance ();
	_tmp9_ = _tmp8_;
	_tmp10_ = configuration_facade_get_use_24_hour_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp9_);
	if (_tmp10_) {
		GtkSpinButton* _tmp11_;
		_tmp11_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 23, (gdouble) 1);
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (self->priv->hour);
		self->priv->hour = _tmp11_;
	} else {
		GtkSpinButton* _tmp12_;
		_tmp12_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 12, (gdouble) 1);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->hour);
		self->priv->hour = _tmp12_;
	}
	_tmp13_ = self->priv->hour;
	g_signal_connect_object (_tmp13_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp14_ = self->priv->hour;
	gtk_entry_set_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp15_ = self->priv->hour;
	gtk_entry_set_max_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp16_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 59, (gdouble) 1);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->minute);
	self->priv->minute = _tmp16_;
	_tmp17_ = self->priv->minute;
	gtk_entry_set_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp18_ = self->priv->minute;
	gtk_entry_set_max_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp19_ = self->priv->minute;
	g_signal_connect_object (_tmp19_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp20_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 59, (gdouble) 1);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->second);
	self->priv->second = _tmp20_;
	_tmp21_ = self->priv->second;
	gtk_entry_set_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp22_ = self->priv->second;
	gtk_entry_set_max_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_entry_get_type (), GtkEntry), 2);
	_tmp23_ = self->priv->second;
	g_signal_connect_object (_tmp23_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp24_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->system);
	self->priv->system = _tmp24_;
	_tmp25_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp25_, _ ("AM"));
	_tmp26_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp26_, _ ("PM"));
	_tmp27_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp27_, _ ("24 Hr"));
	_tmp28_ = self->priv->system;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed, self, 0);
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp29_);
	clock = _tmp29_;
	_tmp30_ = clock;
	_tmp31_ = self->priv->hour;
	gtk_box_pack_start (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp32_ = clock;
	_tmp33_ = (GtkLabel*) gtk_label_new (":");
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	gtk_box_pack_start (_tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = clock;
	_tmp36_ = self->priv->minute;
	gtk_box_pack_start (_tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp37_ = clock;
	_tmp38_ = (GtkLabel*) gtk_label_new (":");
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	gtk_box_pack_start (_tmp37_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = clock;
	_tmp41_ = self->priv->second;
	gtk_box_pack_start (_tmp40_, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp42_ = clock;
	_tmp43_ = self->priv->system;
	gtk_box_pack_start (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
	_tmp44_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _ ("_Shift photos/videos by the same amount"));
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->relativity_radio_button);
	self->priv->relativity_radio_button = _tmp44_;
	_tmp45_ = self->priv->relativity_radio_button;
	_tmp46_ = config_facade_get_instance ();
	_tmp47_ = _tmp46_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_toggle_button_get_type (), GtkToggleButton), configuration_facade_get_keep_relativity (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
	_g_object_unref0 (_tmp47_);
	if (display_options) {
		_tmp48_ = photo_count > 1;
	} else {
		_tmp48_ = FALSE;
	}
	_tmp49_ = self->priv->relativity_radio_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget), _tmp48_);
	_tmp50_ = self->priv->relativity_radio_button;
	_tmp51_ = gtk_radio_button_get_group (_tmp50_);
	_tmp52_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (_tmp51_, _ ("Set _all photos/videos to this time"));
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->batch_radio_button);
	self->priv->batch_radio_button = _tmp52_;
	_tmp53_ = self->priv->batch_radio_button;
	_tmp54_ = config_facade_get_instance ();
	_tmp55_ = _tmp54_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_toggle_button_get_type (), GtkToggleButton), !configuration_facade_get_keep_relativity (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
	_g_object_unref0 (_tmp55_);
	if (display_options) {
		_tmp56_ = photo_count > 1;
	} else {
		_tmp56_ = FALSE;
	}
	_tmp57_ = self->priv->batch_radio_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), _tmp56_);
	_tmp58_ = self->priv->batch_radio_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled, self, 0);
	if (!contains_video) {
		gchar* text = NULL;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		GtkCheckButton* _tmp61_;
		_tmp59_ = g_strdup (ngettext ("_Modify original photo file", "_Modify original photo files", (gulong) photo_count));
		text = _tmp59_;
		_tmp60_ = text;
		_tmp61_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp60_);
		g_object_ref_sink (_tmp61_);
		_g_object_unref0 (self->priv->modify_originals_check_button);
		self->priv->modify_originals_check_button = _tmp61_;
		_g_free0 (text);
	} else {
		gchar* text = NULL;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		GtkCheckButton* _tmp64_;
		_tmp62_ = g_strdup (ngettext ("_Modify original file", "_Modify original files", (gulong) photo_count));
		text = _tmp62_;
		_tmp63_ = text;
		_tmp64_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp63_);
		g_object_ref_sink (_tmp64_);
		_g_object_unref0 (self->priv->modify_originals_check_button);
		self->priv->modify_originals_check_button = _tmp64_;
		_g_free0 (text);
	}
	_tmp66_ = config_facade_get_instance ();
	_tmp67_ = _tmp66_;
	_tmp68_ = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp67_);
	if (_tmp68_) {
		_tmp65_ = display_options;
	} else {
		_tmp65_ = FALSE;
	}
	_tmp69_ = self->priv->modify_originals_check_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp65_);
	if (!only_video) {
		gboolean _tmp71_ = FALSE;
		ConfigFacade* _tmp72_;
		ConfigFacade* _tmp73_;
		gboolean _tmp74_;
		_tmp72_ = config_facade_get_instance ();
		_tmp73_ = _tmp72_;
		_tmp74_ = !configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
		_g_object_unref0 (_tmp73_);
		if (_tmp74_) {
			_tmp71_ = display_options;
		} else {
			_tmp71_ = FALSE;
		}
		_tmp70_ = _tmp71_;
	} else {
		_tmp70_ = FALSE;
	}
	_tmp75_ = self->priv->modify_originals_check_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_widget_get_type (), GtkWidget), _tmp70_);
	_tmp76_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp76_);
	time_content = _tmp76_;
	_tmp77_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp77_);
	picker = _tmp77_;
	_tmp78_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp78_);
	combo = _tmp78_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp79_ = FALSE;
			_tmp79_ = TRUE;
			while (TRUE) {
				GDateTime* dt = NULL;
				GDateTime* _tmp81_;
				gchar* month_string = NULL;
				GDateTime* _tmp82_;
				gchar* _tmp83_;
				const gchar* _tmp84_;
				GtkComboBoxText* _tmp87_;
				const gchar* _tmp88_;
				if (!_tmp79_) {
					gint _tmp80_;
					_tmp80_ = i;
					i = _tmp80_ + 1;
				}
				_tmp79_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp81_ = g_date_time_new_from_unix_utc ((gint64) (i * 2764800));
				dt = _tmp81_;
				_tmp82_ = dt;
				_tmp83_ = g_date_time_format (_tmp82_, "%OB");
				month_string = _tmp83_;
				_tmp84_ = month_string;
				if (string_index_of (_tmp84_, "%OB", 0) != -1) {
					GDateTime* _tmp85_;
					gchar* _tmp86_;
					_tmp85_ = dt;
					_tmp86_ = g_date_time_format (_tmp85_, "%B");
					_g_free0 (month_string);
					month_string = _tmp86_;
				}
				_tmp87_ = combo;
				_tmp88_ = month_string;
				gtk_combo_box_text_append_text (_tmp87_, _tmp88_);
				_g_free0 (month_string);
				_g_date_time_unref0 (dt);
			}
		}
	}
	_tmp89_ = picker;
	_tmp90_ = combo;
	gtk_box_pack_start (_tmp89_, G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp91_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) (G_MAXINT >> 9), (gdouble) 1);
	g_object_ref_sink (_tmp91_);
	spin = _tmp91_;
	_tmp92_ = picker;
	_tmp93_ = spin;
	gtk_box_pack_end (_tmp92_, G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp94_ = spin;
	_tmp95_ = self->priv->calendar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, G_TYPE_OBJECT, GObject), "value", G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, G_TYPE_OBJECT, GObject), "year", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp96_ = combo;
	_tmp97_ = self->priv->calendar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, G_TYPE_OBJECT, GObject), "active", G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, G_TYPE_OBJECT, GObject), "month", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp98_ = time_content;
	_tmp99_ = picker;
	gtk_box_pack_start (_tmp98_, G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp100_ = time_content;
	_tmp101_ = self->priv->calendar;
	gtk_box_pack_start (_tmp100_, G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp102_ = time_content;
	_tmp103_ = clock;
	gtk_box_pack_start (_tmp102_, G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	if (display_options) {
		GtkBox* _tmp104_;
		GtkRadioButton* _tmp105_;
		GtkBox* _tmp106_;
		GtkRadioButton* _tmp107_;
		GtkBox* _tmp108_;
		GtkCheckButton* _tmp109_;
		_tmp104_ = time_content;
		_tmp105_ = self->priv->relativity_radio_button;
		gtk_box_pack_start (_tmp104_, G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
		_tmp106_ = time_content;
		_tmp107_ = self->priv->batch_radio_button;
		gtk_box_pack_start (_tmp106_, G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
		_tmp108_ = time_content;
		_tmp109_ = self->priv->modify_originals_check_button;
		gtk_box_pack_start (_tmp108_, G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	}
	preview = NULL;
	{
		GdkPixbuf* _tmp110_ = NULL;
		GdkPixbuf* _tmp111_;
		GdkPixbuf* _tmp112_;
		_tmp111_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), ADJUST_DATE_TIME_DIALOG_CALENDAR_THUMBNAIL_SCALE, &_inner_error0_);
		_tmp110_ = _tmp111_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp112_ = _tmp110_;
		_tmp110_ = NULL;
		_g_object_unref0 (preview);
		preview = _tmp112_;
		_g_object_unref0 (_tmp110_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp113_;
		gchar* _tmp114_;
		g_clear_error (&_inner_error0_);
		_tmp113_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
		_tmp114_ = _tmp113_;
		g_warning ("AdjustDateTimeDialog.vala:155: Unable to fetch preview for %s", _tmp114_);
		_g_free0 (_tmp114_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview);
		_g_object_unref0 (spin);
		_g_object_unref0 (combo);
		_g_object_unref0 (picker);
		_g_object_unref0 (time_content);
		_g_object_unref0 (clock);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp115_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp115_);
	image_content = _tmp115_;
	_tmp116_ = image_content;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp117_ = image_content;
	gtk_box_set_homogeneous (_tmp117_, TRUE);
	_tmp119_ = preview;
	if (_tmp119_ != NULL) {
		GdkPixbuf* _tmp120_;
		GtkImage* _tmp121_;
		_tmp120_ = preview;
		_tmp121_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp120_);
		g_object_ref_sink (_tmp121_);
		_g_object_unref0 (_tmp118_);
		_tmp118_ = _tmp121_;
	} else {
		GtkImage* _tmp122_;
		_tmp122_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp122_);
		_g_object_unref0 (_tmp118_);
		_tmp118_ = _tmp122_;
	}
	_tmp123_ = _g_object_ref0 (_tmp118_);
	image = _tmp123_;
	_tmp124_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp124_);
	_g_object_unref0 (self->priv->original_time_label);
	self->priv->original_time_label = _tmp124_;
	_tmp125_ = image_content;
	_tmp126_ = image;
	gtk_box_pack_start (_tmp125_, G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp127_ = image_content;
	_tmp128_ = self->priv->original_time_label;
	gtk_box_pack_start (_tmp127_, G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp129_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp129_);
	hbox = _tmp129_;
	_tmp130_ = hbox;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, gtk_container_get_type (), GtkContainer), (guint) 3);
	_tmp131_ = hbox;
	_tmp132_ = image_content;
	gtk_box_pack_start (_tmp131_, G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp133_ = hbox;
	_tmp134_ = time_content;
	gtk_box_pack_start (_tmp133_, G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp135_ = hbox;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp136_ = hbox;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp137_ = hbox;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp138_ = hbox;
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp139_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp140_ = hbox;
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp141_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp141_);
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp141_;
	_tmp142_ = self->priv->notification;
	gtk_label_set_line_wrap (_tmp142_, TRUE);
	_tmp143_ = self->priv->notification;
	gtk_label_set_justify (_tmp143_, GTK_JUSTIFY_CENTER);
	_tmp144_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp145_ = self->priv->notification;
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp146_ = dateable_get_exposure_time (source);
	_g_date_time_unref0 (self->priv->original_time);
	self->priv->original_time = _tmp146_;
	_tmp147_ = self->priv->original_time;
	if (_tmp147_ == NULL) {
		GDateTime* _tmp148_;
		_tmp148_ = g_date_time_new_now_utc ();
		_g_date_time_unref0 (self->priv->original_time);
		self->priv->original_time = _tmp148_;
		self->priv->no_original_time = TRUE;
	}
	_tmp149_ = self->priv->original_time;
	_tmp150_ = g_date_time_to_local (_tmp149_);
	_tmp151_ = _tmp150_;
	adjust_date_time_dialog_set_time (self, _tmp151_);
	_g_date_time_unref0 (_tmp151_);
	_tmp152_ = config_facade_get_instance ();
	_tmp153_ = _tmp152_;
	adjust_date_time_dialog_set_original_time_label (self, configuration_facade_get_use_24_hour_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
	_g_object_unref0 (_tmp153_);
	_g_object_unref0 (hbox);
	_g_object_unref0 (image);
	_g_object_unref0 (_tmp118_);
	_g_object_unref0 (image_content);
	_g_object_unref0 (preview);
	_g_object_unref0 (spin);
	_g_object_unref0 (combo);
	_g_object_unref0 (picker);
	_g_object_unref0 (time_content);
	_g_object_unref0 (clock);
	return self;
}

AdjustDateTimeDialog*
adjust_date_time_dialog_new (Dateable* source,
                             gint photo_count,
                             gboolean display_options,
                             gboolean contains_video,
                             gboolean only_video)
{
	return adjust_date_time_dialog_construct (TYPE_ADJUST_DATE_TIME_DIALOG, source, photo_count, display_options, contains_video, only_video);
}

static void
adjust_date_time_dialog_set_time (AdjustDateTimeDialog* self,
                                  GDateTime* time)
{
	GtkCalendar* _tmp0_;
	GtkCalendar* _tmp1_;
	GtkCalendar* _tmp2_;
	GtkCalendar* _tmp3_;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	gboolean _tmp6_;
	GtkSpinButton* _tmp13_;
	GtkSpinButton* _tmp14_;
	GtkComboBoxText* _tmp15_;
	g_return_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self));
	g_return_if_fail (time != NULL);
	_tmp0_ = self->priv->calendar;
	gtk_calendar_select_month (_tmp0_, (guint) (g_date_time_get_month (time) - 1), (guint) g_date_time_get_year (time));
	_tmp1_ = self->priv->calendar;
	gtk_calendar_select_day (_tmp1_, (guint) g_date_time_get_day_of_month (time));
	_tmp2_ = self->priv->calendar;
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "year");
	_tmp3_ = self->priv->calendar;
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "month");
	_tmp4_ = config_facade_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp6_ = configuration_facade_get_use_24_hour_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		GtkComboBoxText* _tmp7_;
		GtkSpinButton* _tmp8_;
		_tmp7_ = self->priv->system;
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_combo_box_get_type (), GtkComboBox), (gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR);
		_tmp8_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp8_, (gdouble) g_date_time_get_hour (time));
	} else {
		gint AMPM_hour = 0;
		gint _tmp9_ = 0;
		GtkSpinButton* _tmp10_;
		AdjustDateTimeDialogTimeSystem _tmp11_ = 0;
		GtkComboBoxText* _tmp12_;
		AMPM_hour = g_date_time_get_hour (time) % 12;
		if (AMPM_hour == 0) {
			_tmp9_ = 12;
		} else {
			_tmp9_ = AMPM_hour;
		}
		_tmp10_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp10_, (gdouble) _tmp9_);
		if (g_date_time_get_hour (time) >= 12) {
			_tmp11_ = ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM;
		} else {
			_tmp11_ = ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM;
		}
		_tmp12_ = self->priv->system;
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_combo_box_get_type (), GtkComboBox), (gint) _tmp11_);
	}
	_tmp13_ = self->priv->minute;
	gtk_spin_button_set_value (_tmp13_, (gdouble) g_date_time_get_minute (time));
	_tmp14_ = self->priv->second;
	gtk_spin_button_set_value (_tmp14_, (gdouble) g_date_time_get_second (time));
	_tmp15_ = self->priv->system;
	self->priv->previous_time_system = (AdjustDateTimeDialogTimeSystem) gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
}

static void
adjust_date_time_dialog_set_original_time_label (AdjustDateTimeDialog* self,
                                                 gboolean use_24_hr_format)
{
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self));
	if (self->priv->no_original_time) {
		return;
	}
	if (use_24_hr_format) {
		_tmp0_ = _ ("%m/%d/%Y, %H:%M:%S");
	} else {
		_tmp0_ = _ ("%m/%d/%Y, %I:%M:%S %p");
	}
	_tmp1_ = self->priv->original_time_label;
	_tmp2_ = self->priv->original_time;
	_tmp3_ = g_date_time_to_local (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_format (_tmp4_, _tmp0_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_ ("Original: "), _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp1_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_date_time_unref0 (_tmp4_);
}

static GDateTime*
adjust_date_time_dialog_get_time (AdjustDateTimeDialog* self)
{
	gint hour = 0;
	GtkSpinButton* _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp4_ = 0;
	GtkComboBoxText* _tmp5_;
	guint year = 0U;
	guint month = 0U;
	guint day = 0U;
	GtkCalendar* _tmp6_;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GtkSpinButton* _tmp10_;
	GtkSpinButton* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* result;
	g_return_val_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self), NULL);
	_tmp0_ = self->priv->hour;
	hour = (gint) gtk_spin_button_get_value (_tmp0_);
	if (hour == 12) {
		GtkComboBoxText* _tmp3_;
		_tmp3_ = self->priv->system;
		_tmp2_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_combo_box_get_type (), GtkComboBox)) != ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = hour;
	}
	hour = _tmp1_;
	_tmp5_ = self->priv->system;
	if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_combo_box_get_type (), GtkComboBox)) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM)) {
		_tmp4_ = 12;
	} else {
		_tmp4_ = 0;
	}
	hour += _tmp4_;
	_tmp6_ = self->priv->calendar;
	gtk_calendar_get_date (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	year = _tmp7_;
	month = _tmp8_;
	day = _tmp9_;
	_tmp10_ = self->priv->minute;
	_tmp11_ = self->priv->second;
	_tmp12_ = g_date_time_new_local ((gint) year, ((gint) month) + 1, (gint) day, hour, (gint) gtk_spin_button_get_value (_tmp10_), (gdouble) ((gint) gtk_spin_button_get_value (_tmp11_)));
	result = _tmp12_;
	return result;
}

gboolean
adjust_date_time_dialog_execute (AdjustDateTimeDialog* self,
                                 GTimeSpan* time_shift,
                                 gboolean* keep_relativity,
                                 gboolean* modify_originals)
{
	GTimeSpan _vala_time_shift = 0LL;
	gboolean _vala_keep_relativity = FALSE;
	gboolean _vala_modify_originals = FALSE;
	gboolean response = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self), FALSE);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	response = FALSE;
	if (gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog)) == ((gint) GTK_RESPONSE_OK)) {
		GtkRadioButton* _tmp7_;
		GtkRadioButton* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		GtkCheckButton* _tmp13_;
		GtkCheckButton* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		if (self->priv->no_original_time) {
			GDateTime* _tmp0_;
			GDateTime* _tmp1_;
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp0_ = adjust_date_time_dialog_get_time (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_date_time_new_from_unix_utc ((gint64) 0);
			_tmp3_ = _tmp2_;
			_vala_time_shift = (g_date_time_difference (_tmp1_, _tmp3_) / 1000) / 1000;
			_g_date_time_unref0 (_tmp3_);
			_g_date_time_unref0 (_tmp1_);
		} else {
			GDateTime* _tmp4_;
			GDateTime* _tmp5_;
			GDateTime* _tmp6_;
			_tmp4_ = adjust_date_time_dialog_get_time (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->original_time;
			_vala_time_shift = (g_date_time_difference (_tmp5_, _tmp6_) / 1000) / 1000;
			_g_date_time_unref0 (_tmp5_);
		}
		_tmp7_ = self->priv->relativity_radio_button;
		_vala_keep_relativity = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_toggle_button_get_type (), GtkToggleButton));
		_tmp8_ = self->priv->relativity_radio_button;
		_tmp9_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			ConfigFacade* _tmp11_;
			ConfigFacade* _tmp12_;
			_tmp11_ = config_facade_get_instance ();
			_tmp12_ = _tmp11_;
			configuration_facade_set_keep_relativity (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _vala_keep_relativity);
			_g_object_unref0 (_tmp12_);
		}
		_tmp13_ = self->priv->modify_originals_check_button;
		_vala_modify_originals = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_toggle_button_get_type (), GtkToggleButton));
		_tmp14_ = self->priv->modify_originals_check_button;
		_tmp15_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			ConfigFacade* _tmp17_;
			ConfigFacade* _tmp18_;
			_tmp17_ = config_facade_get_instance ();
			_tmp18_ = _tmp17_;
			configuration_facade_set_modify_originals (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _vala_modify_originals);
			_g_object_unref0 (_tmp18_);
		}
		response = TRUE;
	} else {
		_vala_time_shift = (GTimeSpan) 0;
		_vala_keep_relativity = TRUE;
		_vala_modify_originals = FALSE;
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = response;
	if (time_shift) {
		*time_shift = _vala_time_shift;
	}
	if (keep_relativity) {
		*keep_relativity = _vala_keep_relativity;
	}
	if (modify_originals) {
		*modify_originals = _vala_modify_originals;
	}
	return result;
}

static gboolean
adjust_date_time_dialog_on_spin_button_output (AdjustDateTimeDialog* self,
                                               GtkSpinButton* button)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (button, gtk_spin_button_get_type ()), FALSE);
	_tmp0_ = g_strdup_printf ("%02d", (gint) gtk_spin_button_get_value (button));
	_tmp1_ = _tmp0_;
	gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_entry_get_type (), GtkEntry), _tmp1_);
	_g_free0 (_tmp1_);
	adjust_date_time_dialog_on_time_changed (self);
	result = TRUE;
	return result;
}

static void
adjust_date_time_dialog_on_time_changed (AdjustDateTimeDialog* self)
{
	GTimeSpan time_shift = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GTimeSpan _tmp3_;
	GtkCalendar* _tmp4_;
	GtkCalendar* _tmp5_;
	GtkComboBoxText* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self));
	_tmp0_ = adjust_date_time_dialog_get_time (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->original_time;
	_tmp3_ = g_date_time_difference (_tmp1_, _tmp2_);
	_g_date_time_unref0 (_tmp1_);
	time_shift = _tmp3_;
	_tmp4_ = self->priv->calendar;
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "year");
	_tmp5_ = self->priv->calendar;
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject), "month");
	_tmp6_ = self->priv->system;
	self->priv->previous_time_system = (AdjustDateTimeDialogTimeSystem) gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_combo_box_get_type (), GtkComboBox));
	if (time_shift == ((GTimeSpan) 0)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = self->priv->no_original_time;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		GtkRadioButton* _tmp10_;
		_tmp10_ = self->priv->batch_radio_button;
		if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_toggle_button_get_type (), GtkToggleButton))) {
			GtkRadioButton* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->batch_radio_button;
			_tmp12_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp7_ = _tmp9_;
	}
	if (_tmp7_) {
		GtkLabel* _tmp14_;
		_tmp14_ = self->priv->notification;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	} else {
		gboolean forward = FALSE;
		gint days = 0;
		gint hours = 0;
		gint minutes = 0;
		gint seconds = 0;
		const gchar* _tmp15_ = NULL;
		gchar* shift_status = NULL;
		gchar* _tmp16_;
		GtkLabel* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GtkLabel* _tmp21_;
		forward = time_shift > ((GTimeSpan) 0);
		time_shift = (GTimeSpan) llabs ((gint64) time_shift);
		days = (gint) (time_shift / G_TIME_SPAN_DAY);
		time_shift = time_shift % G_TIME_SPAN_DAY;
		hours = (gint) (time_shift / G_TIME_SPAN_HOUR);
		time_shift = time_shift % G_TIME_SPAN_HOUR;
		minutes = (gint) (time_shift / G_TIME_SPAN_MINUTE);
		seconds = (gint) ((time_shift % G_TIME_SPAN_MINUTE) / G_TIME_SPAN_SECOND);
		if (forward) {
			_tmp15_ = _ ("Exposure time will be shifted forward by\n" \
"%d %s, %d %s, %d %s, and %d %s.");
		} else {
			_tmp15_ = _ ("Exposure time will be shifted backward by\n" \
"%d %s, %d %s, %d %s, and %d %s.");
		}
		_tmp16_ = g_strdup (_tmp15_);
		shift_status = _tmp16_;
		_tmp17_ = self->priv->notification;
		_tmp18_ = shift_status;
		_tmp19_ = g_strdup_printf (_tmp18_, days, ngettext ("day", "days", (gulong) days), hours, ngettext ("hour", "hours", (gulong) hours), minutes, ngettext ("minute", "minutes", (gulong) minutes), seconds, ngettext ("second", "seconds", (gulong) seconds));
		_tmp20_ = _tmp19_;
		gtk_label_set_text (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->notification;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_g_free0 (shift_status);
	}
}

static void
adjust_date_time_dialog_on_time_system_changed (AdjustDateTimeDialog* self)
{
	GtkComboBoxText* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkComboBoxText* _tmp4_;
	g_return_if_fail (IS_ADJUST_DATE_TIME_DIALOG (self));
	_tmp0_ = self->priv->system;
	if (self->priv->previous_time_system == gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox))) {
		return;
	}
	_tmp1_ = config_facade_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->system;
	configuration_facade_set_use_24_hour_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_combo_box_get_type (), GtkComboBox)) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR));
	_g_object_unref0 (_tmp2_);
	_tmp4_ = self->priv->system;
	if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_combo_box_get_type (), GtkComboBox)) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR)) {
		gint _tmp5_ = 0;
		GtkSpinButton* _tmp6_;
		gint time = 0;
		gint _tmp8_ = 0;
		GtkSpinButton* _tmp9_;
		GtkSpinButton* _tmp10_;
		_tmp6_ = self->priv->hour;
		if (gtk_spin_button_get_value (_tmp6_) == 12.0) {
			_tmp5_ = 0;
		} else {
			GtkSpinButton* _tmp7_;
			_tmp7_ = self->priv->hour;
			_tmp5_ = (gint) gtk_spin_button_get_value (_tmp7_);
		}
		time = _tmp5_;
		if (self->priv->previous_time_system == ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM) {
			_tmp8_ = 12;
		} else {
			_tmp8_ = 0;
		}
		time = time + _tmp8_;
		_tmp9_ = self->priv->hour;
		gtk_spin_button_set_range (_tmp9_, (gdouble) 0, (gdouble) 23);
		adjust_date_time_dialog_set_original_time_label (self, TRUE);
		_tmp10_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp10_, (gdouble) time);
	} else {
		gint AMPM_hour = 0;
		GtkSpinButton* _tmp11_;
		GtkSpinButton* _tmp12_;
		gint _tmp13_ = 0;
		GtkSpinButton* _tmp14_;
		_tmp11_ = self->priv->hour;
		AMPM_hour = ((gint) gtk_spin_button_get_value (_tmp11_)) % 12;
		_tmp12_ = self->priv->hour;
		gtk_spin_button_set_range (_tmp12_, (gdouble) 1, (gdouble) 12);
		adjust_date_time_dialog_set_original_time_label (self, FALSE);
		if (AMPM_hour == 0) {
			_tmp13_ = 12;
		} else {
			_tmp13_ = AMPM_hour;
		}
		_tmp14_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp14_, (gdouble) _tmp13_);
	}
	adjust_date_time_dialog_on_time_changed (self);
}

static void
adjust_date_time_dialog_class_init (AdjustDateTimeDialogClass * klass,
                                    gpointer klass_data)
{
	adjust_date_time_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustDateTimeDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = adjust_date_time_dialog_finalize;
}

static void
adjust_date_time_dialog_instance_init (AdjustDateTimeDialog * self,
                                       gpointer klass)
{
	self->priv = adjust_date_time_dialog_get_instance_private (self);
	self->priv->no_original_time = FALSE;
}

static void
adjust_date_time_dialog_finalize (GObject * obj)
{
	AdjustDateTimeDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialog);
	_g_date_time_unref0 (self->priv->original_time);
	_g_object_unref0 (self->priv->original_time_label);
	_g_object_unref0 (self->priv->calendar);
	_g_object_unref0 (self->priv->hour);
	_g_object_unref0 (self->priv->minute);
	_g_object_unref0 (self->priv->second);
	_g_object_unref0 (self->priv->system);
	_g_object_unref0 (self->priv->relativity_radio_button);
	_g_object_unref0 (self->priv->batch_radio_button);
	_g_object_unref0 (self->priv->modify_originals_check_button);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (adjust_date_time_dialog_parent_class)->finalize (obj);
}

static GType
adjust_date_time_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustDateTimeDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_date_time_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustDateTimeDialog), 0, (GInstanceInitFunc) adjust_date_time_dialog_instance_init, NULL };
	GType adjust_date_time_dialog_type_id;
	adjust_date_time_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "AdjustDateTimeDialog", &g_define_type_info, 0);
	AdjustDateTimeDialog_private_offset = g_type_add_instance_private (adjust_date_time_dialog_type_id, sizeof (AdjustDateTimeDialogPrivate));
	return adjust_date_time_dialog_type_id;
}

GType
adjust_date_time_dialog_get_type (void)
{
	static volatile gsize adjust_date_time_dialog_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_dialog_type_id__once)) {
		GType adjust_date_time_dialog_type_id;
		adjust_date_time_dialog_type_id = adjust_date_time_dialog_get_type_once ();
		g_once_init_leave (&adjust_date_time_dialog_type_id__once, adjust_date_time_dialog_type_id);
	}
	return adjust_date_time_dialog_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

