/* VideoTable.c generated by valac 0.56.17, the Vala compiler
 * generated from VideoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>
#include <gio/gio.h>

#define VIDEO_ID_INVALID ((gint64) -1)
#define VIDEO_TYPENAME "video"
#define EVENT_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecVideoRow ParamSpecVideoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
typedef struct _VideoTablePrivate VideoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VideoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	gint64 time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	gint64 time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _VideoTable {
	DatabaseTable parent_instance;
	VideoTablePrivate * priv;
};

struct _VideoTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer video_row_parent_class = NULL;
static gpointer video_table_parent_class = NULL;
static VideoTable* video_table_instance;
static VideoTable* video_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN GType video_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoID* video_id_dup (const VideoID* self);
VALA_EXTERN void video_id_free (VideoID* self);
VALA_EXTERN void video_id_init (VideoID *self,
                    gint64 id);
VALA_EXTERN gboolean video_id_is_invalid (VideoID *self);
VALA_EXTERN gboolean video_id_is_valid (VideoID *self);
VALA_EXTERN guint video_id_hash (VideoID* a);
VALA_EXTERN guint int64_hash (gint64* n);
VALA_EXTERN gboolean video_id_equal (void* a,
                         void* b);
VALA_EXTERN gchar* video_id_upgrade_video_id_to_source_id (VideoID* video_id);
VALA_EXTERN gpointer video_row_ref (gpointer instance);
VALA_EXTERN void video_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_video_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_video_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_video_row (const GValue* value);
VALA_EXTERN GType video_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoRow, video_row_unref)
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoRow* video_row_new (void);
VALA_EXTERN VideoRow* video_row_construct (GType object_type);
static void video_row_finalize (VideoRow * obj);
static GType video_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType video_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoTable, database_table_unref)
static VideoTable* video_table_new (void);
static VideoTable* video_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN VideoTable* video_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void video_table_add (VideoTable* self,
                      VideoRow* video_row,
                      VideoID* result,
                      GError** error);
VALA_EXTERN gint64 now_sec (void);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN gboolean video_table_drop_event (VideoTable* self,
                                 EventID* event_id);
VALA_EXTERN VideoRow* video_table_get_row (VideoTable* self,
                               VideoID* video_id);
VALA_EXTERN Rating rating_unserialize (gint value);
VALA_EXTERN GeeArrayList* video_table_get_all (VideoTable* self);
VALA_EXTERN void video_table_set_filepath (VideoTable* self,
                               VideoID* video_id,
                               const gchar* filepath,
                               GError** error);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
VALA_EXTERN void video_table_set_title (VideoTable* self,
                            VideoID* video_id,
                            const gchar* new_title,
                            GError** error);
VALA_EXTERN void video_table_set_comment (VideoTable* self,
                              VideoID* video_id,
                              const gchar* new_comment,
                              GError** error);
VALA_EXTERN void video_table_set_exposure_time (VideoTable* self,
                                    VideoID* video_id,
                                    GDateTime* time,
                                    GError** error);
VALA_EXTERN void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
VALA_EXTERN void video_table_set_rating (VideoTable* self,
                             VideoID* video_id,
                             Rating rating,
                             GError** error);
VALA_EXTERN gint rating_serialize (Rating self);
VALA_EXTERN void video_table_set_flags (VideoTable* self,
                            VideoID* video_id,
                            guint64 flags,
                            GError** error);
VALA_EXTERN void video_table_update_backlinks (VideoTable* self,
                                   VideoID* video_id,
                                   const gchar* backlinks,
                                   GError** error);
VALA_EXTERN void video_table_update_is_interpretable (VideoTable* self,
                                          VideoID* video_id,
                                          gboolean is_interpretable,
                                          GError** error);
VALA_EXTERN void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
VALA_EXTERN gboolean video_table_set_event (VideoTable* self,
                                VideoID* video_id,
                                EventID* event_id);
VALA_EXTERN gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
VALA_EXTERN void video_table_remove_by_file (VideoTable* self,
                                 GFile* file,
                                 GError** error);
VALA_EXTERN void video_table_remove (VideoTable* self,
                         VideoID* videoID,
                         GError** error);
VALA_EXTERN gboolean video_table_is_video_stored (VideoTable* self,
                                      GFile* file);
VALA_EXTERN void video_table_get_id (VideoTable* self,
                         GFile* file,
                         VideoID* result);
VALA_EXTERN GeeArrayList* video_table_get_videos (VideoTable* self,
                                      GError** error);
static sqlite3_stmt* video_table_get_duplicate_stmt (VideoTable* self,
                                              GFile* file,
                                              const gchar* md5);
VALA_EXTERN gboolean video_table_has_duplicate (VideoTable* self,
                                    GFile* file,
                                    const gchar* md5);
VALA_EXTERN VideoID* video_table_get_duplicate_ids (VideoTable* self,
                                        GFile* file,
                                        const gchar* md5,
                                        gint* result_length1);
static void _vala_array_add4 (VideoID* * array,
                       gint* length,
                       gint* size,
                       const VideoID* value);
VALA_EXTERN GeeArrayList* video_table_get_event_source_ids (VideoTable* self,
                                                EventID* event_id);
VALA_EXTERN void video_table_set_timestamp (VideoTable* self,
                                VideoID* video_id,
                                GDateTime* timestamp,
                                GError** error);
VALA_EXTERN void video_table_upgrade_for_unset_timestamp (GError** error);
static void video_table_finalize (DatabaseTable * obj);
static GType video_table_get_type_once (void);

void
video_id_init (VideoID *self,
               gint64 id)
{
	memset (self, 0, sizeof (VideoID));
	(*self).id = id;
}

gboolean
video_id_is_invalid (VideoID *self)
{
	gboolean result;
	result = (*self).id == VIDEO_ID_INVALID;
	return result;
}

gboolean
video_id_is_valid (VideoID *self)
{
	gboolean result;
	result = (*self).id != VIDEO_ID_INVALID;
	return result;
}

guint
video_id_hash (VideoID* a)
{
	guint result;
	result = int64_hash (&(*a).id);
	return result;
}

gboolean
video_id_equal (void* a,
                void* b)
{
	gboolean result;
	result = (*((VideoID*) a)).id == (*((VideoID*) b)).id;
	return result;
}

gchar*
video_id_upgrade_video_id_to_source_id (VideoID* video_id)
{
	VideoID _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = *video_id;
	_tmp1_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", VIDEO_TYPENAME, _tmp0_.id);
	result = _tmp1_;
	return result;
}

VideoID*
video_id_dup (const VideoID* self)
{
	VideoID* dup;
	dup = g_new0 (VideoID, 1);
	memcpy (dup, self, sizeof (VideoID));
	return dup;
}

void
video_id_free (VideoID* self)
{
	g_free (self);
}

static GType
video_id_get_type_once (void)
{
	GType video_id_type_id;
	video_id_type_id = g_boxed_type_register_static ("VideoID", (GBoxedCopyFunc) video_id_dup, (GBoxedFreeFunc) video_id_free);
	return video_id_type_id;
}

GType
video_id_get_type (void)
{
	static volatile gsize video_id_type_id__once = 0;
	if (g_once_init_enter (&video_id_type_id__once)) {
		GType video_id_type_id;
		video_id_type_id = video_id_get_type_once ();
		g_once_init_leave (&video_id_type_id__once, video_id_type_id);
	}
	return video_id_type_id__once;
}

VideoRow*
video_row_construct (GType object_type)
{
	VideoRow* self = NULL;
	self = (VideoRow*) g_type_create_instance (object_type);
	return self;
}

VideoRow*
video_row_new (void)
{
	return video_row_construct (TYPE_VIDEO_ROW);
}

static void
value_video_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_video_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_row_unref (value->data[0].v_pointer);
	}
}

static void
value_video_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_video_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_video_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_video_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	VideoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_video_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecVideoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_video_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_video_row (GValue* value,
                     gpointer v_object)
{
	VideoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_row_unref (old);
	}
}

void
value_take_video_row (GValue* value,
                      gpointer v_object)
{
	VideoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_row_unref (old);
	}
}

static void
video_row_class_init (VideoRowClass * klass,
                      gpointer klass_data)
{
	video_row_parent_class = g_type_class_peek_parent (klass);
	((VideoRowClass *) klass)->finalize = video_row_finalize;
}

static void
video_row_instance_init (VideoRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
video_row_finalize (VideoRow * obj)
{
	VideoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_ROW, VideoRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
	_g_date_time_unref0 (self->timestamp);
	_g_date_time_unref0 (self->exposure_time);
	_g_free0 (self->md5);
	_g_free0 (self->title);
	_g_free0 (self->backlinks);
	_g_free0 (self->comment);
}

static GType
video_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_video_row_init, value_video_row_free_value, value_video_row_copy_value, value_video_row_peek_pointer, "p", value_video_row_collect_value, "p", value_video_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoRow), 0, (GInstanceInitFunc) video_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_row_type_id;
	video_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return video_row_type_id;
}

GType
video_row_get_type (void)
{
	static volatile gsize video_row_type_id__once = 0;
	if (g_once_init_enter (&video_row_type_id__once)) {
		GType video_row_type_id;
		video_row_type_id = video_row_get_type_once ();
		g_once_init_leave (&video_row_type_id__once, video_row_type_id);
	}
	return video_row_type_id__once;
}

gpointer
video_row_ref (gpointer instance)
{
	VideoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_row_unref (gpointer instance)
{
	VideoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static VideoTable*
video_table_construct (GType object_type)
{
	VideoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	self = (VideoTable*) database_table_construct (object_type);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VideoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "clip_duration REAL, " "is_interpretable INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "md5 TEXT, " "time_created INTEGER, " "rating INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "flags INTEGER DEFAULT 0, " "comment TEXT " ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("VideoTable constructor", res);
	}
	_tmp4_ = database_table_db;
	_tmp6_ = sqlite3_prepare_v2 (_tmp4_, "CREATE INDEX IF NOT EXISTS VideoEventIDIndex ON VideoTable (event_id)", -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (stmt2);
	stmt2 = _tmp5_;
	res2 = _tmp6_;
	_vala_assert (res2 == SQLITE_OK, "res2 == Sqlite.OK");
	_tmp7_ = stmt2;
	res2 = sqlite3_step (_tmp7_);
	if (res2 != SQLITE_DONE) {
		database_table_fatal ("VideoTable constructor", res2);
	}
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "VideoTable");
	_sqlite3_finalize0 (stmt2);
	_sqlite3_finalize0 (stmt);
	return self;
}

static VideoTable*
video_table_new (void)
{
	return video_table_construct (TYPE_VIDEO_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

VideoTable*
video_table_get_instance (void)
{
	VideoTable* _tmp0_;
	VideoTable* _tmp2_;
	VideoTable* _tmp3_;
	VideoTable* result;
	_tmp0_ = video_table_instance;
	if (_tmp0_ == NULL) {
		VideoTable* _tmp1_;
		_tmp1_ = video_table_new ();
		_database_table_unref0 (video_table_instance);
		video_table_instance = _tmp1_;
	}
	_tmp2_ = video_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
video_table_add (VideoTable* self,
                 VideoRow* video_row,
                 VideoID* result,
                 GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	sqlite3_stmt* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	sqlite3_stmt* _tmp19_;
	ImportID _tmp20_;
	sqlite3_stmt* _tmp21_;
	sqlite3_stmt* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GDestroyNotify _tmp25_;
	sqlite3_stmt* _tmp26_;
	sqlite3_stmt* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GDestroyNotify _tmp30_;
	sqlite3_stmt* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GDestroyNotify _tmp34_;
	sqlite3_stmt* _tmp35_;
	sqlite3* _tmp36_;
	VideoID _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (IS_VIDEO_ROW (video_row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO VideoTable (filename, width, height, clip_duration, is_int" \
"erpretable, " "filesize, timestamp, exposure_time, import_id, event_id, md5, time_cre" \
"ated, title, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_created = now_sec ();
	_tmp3_ = stmt;
	_tmp4_ = video_row->filepath;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int (_tmp7_, 2, video_row->width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_bind_int (_tmp8_, 3, video_row->height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	res = sqlite3_bind_double (_tmp9_, 4, video_row->clip_duration);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	if (video_row->is_interpretable) {
		_tmp10_ = 1;
	} else {
		_tmp10_ = 0;
	}
	_tmp11_ = stmt;
	res = sqlite3_bind_int (_tmp11_, 5, _tmp10_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	res = sqlite3_bind_int64 (_tmp12_, 6, video_row->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp13_ = stmt;
	_tmp14_ = video_row->timestamp;
	res = sqlite3_bind_int64 (_tmp13_, 7, g_date_time_to_unix (_tmp14_));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp15_ = video_row->exposure_time;
	if (_tmp15_ == NULL) {
		sqlite3_stmt* _tmp16_;
		_tmp16_ = stmt;
		sqlite3_bind_null (_tmp16_, 8);
	} else {
		sqlite3_stmt* _tmp17_;
		GDateTime* _tmp18_;
		_tmp17_ = stmt;
		_tmp18_ = video_row->exposure_time;
		res = sqlite3_bind_int64 (_tmp17_, 8, g_date_time_to_unix (_tmp18_));
	}
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp19_ = stmt;
	_tmp20_ = video_row->import_id;
	res = sqlite3_bind_int64 (_tmp19_, 9, _tmp20_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp21_ = stmt;
	res = sqlite3_bind_int64 (_tmp21_, 10, EVENT_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp22_ = stmt;
	_tmp23_ = video_row->md5;
	_tmp24_ = g_strdup (_tmp23_);
	_tmp25_ = g_free;
	res = sqlite3_bind_text (_tmp22_, 11, _tmp24_, -1, _tmp25_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp26_ = stmt;
	res = sqlite3_bind_int64 (_tmp26_, 12, time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp27_ = stmt;
	_tmp28_ = video_row->title;
	_tmp29_ = g_strdup (_tmp28_);
	_tmp30_ = g_free;
	res = sqlite3_bind_text (_tmp27_, 13, _tmp29_, -1, _tmp30_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp31_ = stmt;
	_tmp32_ = video_row->comment;
	_tmp33_ = g_strdup (_tmp32_);
	_tmp34_ = g_free;
	res = sqlite3_bind_text (_tmp31_, 14, _tmp33_, -1, _tmp34_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp35_ = stmt;
	res = sqlite3_step (_tmp35_);
	if (res != SQLITE_DONE) {
		if (res != SQLITE_CONSTRAINT) {
			database_table_throw_error ("VideoTable.add", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	_tmp36_ = database_table_db;
	video_id_init (&video_row->video_id, sqlite3_last_insert_rowid (_tmp36_));
	event_id_init (&video_row->event_id, EVENT_ID_INVALID);
	video_row->time_created = time_created;
	video_row->flags = (guint64) 0;
	_tmp37_ = video_row->video_id;
	*result = _tmp37_;
	_sqlite3_finalize0 (stmt);
	return;
}

gboolean
video_table_drop_event (VideoTable* self,
                        EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE VideoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int64 (_tmp3_, 1, EVENT_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	_tmp5_ = *event_id;
	res = sqlite3_bind_int64 (_tmp4_, 2, _tmp5_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("VideoTable.drop_event", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

VideoRow*
video_table_get_row (VideoTable* self,
                     VideoID* video_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	VideoID _tmp4_;
	sqlite3_stmt* _tmp5_;
	VideoRow* row = NULL;
	VideoRow* _tmp6_;
	VideoRow* _tmp7_;
	VideoID _tmp8_;
	VideoRow* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	VideoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	VideoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	VideoRow* _tmp17_;
	sqlite3_stmt* _tmp18_;
	VideoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	VideoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	sqlite3_stmt* _tmp23_;
	VideoRow* _tmp28_;
	sqlite3_stmt* _tmp29_;
	VideoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	VideoRow* _tmp32_;
	sqlite3_stmt* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	VideoRow* _tmp36_;
	sqlite3_stmt* _tmp37_;
	VideoRow* _tmp38_;
	sqlite3_stmt* _tmp39_;
	VideoRow* _tmp40_;
	sqlite3_stmt* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	VideoRow* _tmp44_;
	sqlite3_stmt* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	VideoRow* _tmp48_;
	sqlite3_stmt* _tmp49_;
	VideoRow* _tmp50_;
	sqlite3_stmt* _tmp51_;
	VideoRow* _tmp52_;
	sqlite3_stmt* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	VideoRow* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, clip_duration, is_interpretable, files" \
"ize, timestamp, " "exposure_time, import_id, event_id, md5, time_created, rating, title, " \
"backlinks, " "time_reimported, flags, comment FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *video_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	if (sqlite3_step (_tmp5_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp6_ = video_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *video_id;
	_tmp7_->video_id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = stmt;
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 0);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp9_->filepath);
	_tmp9_->filepath = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp13_->width = sqlite3_column_int (_tmp14_, 1);
	_tmp15_ = row;
	_tmp16_ = stmt;
	_tmp15_->height = sqlite3_column_int (_tmp16_, 2);
	_tmp17_ = row;
	_tmp18_ = stmt;
	_tmp17_->clip_duration = sqlite3_column_double (_tmp18_, 3);
	_tmp19_ = row;
	_tmp20_ = stmt;
	_tmp19_->is_interpretable = sqlite3_column_int (_tmp20_, 4) == 1;
	_tmp21_ = row;
	_tmp22_ = stmt;
	_tmp21_->filesize = sqlite3_column_int64 (_tmp22_, 5);
	_tmp23_ = stmt;
	if (sqlite3_column_type (_tmp23_, 6) == SQLITE_NULL) {
		VideoRow* _tmp24_;
		_tmp24_ = row;
		_g_date_time_unref0 (_tmp24_->exposure_time);
		_tmp24_->exposure_time = NULL;
	} else {
		VideoRow* _tmp25_;
		sqlite3_stmt* _tmp26_;
		GDateTime* _tmp27_;
		_tmp25_ = row;
		_tmp26_ = stmt;
		_tmp27_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp26_, 6));
		_g_date_time_unref0 (_tmp25_->exposure_time);
		_tmp25_->exposure_time = _tmp27_;
	}
	_tmp28_ = row;
	_tmp29_ = stmt;
	_tmp28_->import_id.id = sqlite3_column_int64 (_tmp29_, 8);
	_tmp30_ = row;
	_tmp31_ = stmt;
	_tmp30_->event_id.id = sqlite3_column_int64 (_tmp31_, 9);
	_tmp32_ = row;
	_tmp33_ = stmt;
	_tmp34_ = (const gchar*) sqlite3_column_text (_tmp33_, 10);
	_tmp35_ = g_strdup (_tmp34_);
	_g_free0 (_tmp32_->md5);
	_tmp32_->md5 = _tmp35_;
	_tmp36_ = row;
	_tmp37_ = stmt;
	_tmp36_->time_created = sqlite3_column_int64 (_tmp37_, 11);
	_tmp38_ = row;
	_tmp39_ = stmt;
	_tmp38_->rating = rating_unserialize (sqlite3_column_int (_tmp39_, 12));
	_tmp40_ = row;
	_tmp41_ = stmt;
	_tmp42_ = (const gchar*) sqlite3_column_text (_tmp41_, 13);
	_tmp43_ = g_strdup (_tmp42_);
	_g_free0 (_tmp40_->title);
	_tmp40_->title = _tmp43_;
	_tmp44_ = row;
	_tmp45_ = stmt;
	_tmp46_ = (const gchar*) sqlite3_column_text (_tmp45_, 14);
	_tmp47_ = g_strdup (_tmp46_);
	_g_free0 (_tmp44_->backlinks);
	_tmp44_->backlinks = _tmp47_;
	_tmp48_ = row;
	_tmp49_ = stmt;
	_tmp48_->time_reimported = sqlite3_column_int64 (_tmp49_, 15);
	_tmp50_ = row;
	_tmp51_ = stmt;
	_tmp50_->flags = (guint64) sqlite3_column_int64 (_tmp51_, 16);
	_tmp52_ = row;
	_tmp53_ = stmt;
	_tmp54_ = (const gchar*) sqlite3_column_text (_tmp53_, 17);
	_tmp55_ = g_strdup (_tmp54_);
	_g_free0 (_tmp52_->comment);
	_tmp52_->comment = _tmp55_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
video_table_get_all (VideoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, clip_duration, is_interpretable, f" \
"ilesize, " "timestamp, exposure_time, import_id, event_id, md5, time_created, rati" \
"ng, title, " "backlinks, time_reimported, flags, comment FROM VideoTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_VIDEO_ROW, (GBoxedCopyFunc) video_row_ref, (GDestroyNotify) video_row_unref, NULL, NULL, NULL);
	all = _tmp3_;
	while (TRUE) {
		sqlite3_stmt* _tmp4_;
		VideoRow* row = NULL;
		VideoRow* _tmp5_;
		VideoRow* _tmp6_;
		sqlite3_stmt* _tmp7_;
		VideoRow* _tmp8_;
		sqlite3_stmt* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		VideoRow* _tmp12_;
		sqlite3_stmt* _tmp13_;
		VideoRow* _tmp14_;
		sqlite3_stmt* _tmp15_;
		VideoRow* _tmp16_;
		sqlite3_stmt* _tmp17_;
		VideoRow* _tmp18_;
		sqlite3_stmt* _tmp19_;
		VideoRow* _tmp20_;
		sqlite3_stmt* _tmp21_;
		VideoRow* _tmp22_;
		sqlite3_stmt* _tmp23_;
		GDateTime* _tmp24_;
		sqlite3_stmt* _tmp25_;
		VideoRow* _tmp30_;
		sqlite3_stmt* _tmp31_;
		VideoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		VideoRow* _tmp34_;
		sqlite3_stmt* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		VideoRow* _tmp38_;
		sqlite3_stmt* _tmp39_;
		VideoRow* _tmp40_;
		sqlite3_stmt* _tmp41_;
		VideoRow* _tmp42_;
		sqlite3_stmt* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		VideoRow* _tmp46_;
		sqlite3_stmt* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		VideoRow* _tmp50_;
		sqlite3_stmt* _tmp51_;
		VideoRow* _tmp52_;
		sqlite3_stmt* _tmp53_;
		VideoRow* _tmp54_;
		sqlite3_stmt* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		GeeArrayList* _tmp58_;
		VideoRow* _tmp59_;
		_tmp4_ = stmt;
		res = sqlite3_step (_tmp4_);
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp5_ = video_row_new ();
		row = _tmp5_;
		_tmp6_ = row;
		_tmp7_ = stmt;
		_tmp6_->video_id.id = sqlite3_column_int64 (_tmp7_, 0);
		_tmp8_ = row;
		_tmp9_ = stmt;
		_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp8_->filepath);
		_tmp8_->filepath = _tmp11_;
		_tmp12_ = row;
		_tmp13_ = stmt;
		_tmp12_->width = sqlite3_column_int (_tmp13_, 2);
		_tmp14_ = row;
		_tmp15_ = stmt;
		_tmp14_->height = sqlite3_column_int (_tmp15_, 3);
		_tmp16_ = row;
		_tmp17_ = stmt;
		_tmp16_->clip_duration = sqlite3_column_double (_tmp17_, 4);
		_tmp18_ = row;
		_tmp19_ = stmt;
		_tmp18_->is_interpretable = sqlite3_column_int (_tmp19_, 5) == 1;
		_tmp20_ = row;
		_tmp21_ = stmt;
		_tmp20_->filesize = sqlite3_column_int64 (_tmp21_, 6);
		_tmp22_ = row;
		_tmp23_ = stmt;
		_tmp24_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp23_, 7));
		_g_date_time_unref0 (_tmp22_->timestamp);
		_tmp22_->timestamp = _tmp24_;
		_tmp25_ = stmt;
		if (sqlite3_column_type (_tmp25_, 8) == SQLITE_NULL) {
			VideoRow* _tmp26_;
			_tmp26_ = row;
			_g_date_time_unref0 (_tmp26_->exposure_time);
			_tmp26_->exposure_time = NULL;
		} else {
			VideoRow* _tmp27_;
			sqlite3_stmt* _tmp28_;
			GDateTime* _tmp29_;
			_tmp27_ = row;
			_tmp28_ = stmt;
			_tmp29_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp28_, 8));
			_g_date_time_unref0 (_tmp27_->exposure_time);
			_tmp27_->exposure_time = _tmp29_;
		}
		_tmp30_ = row;
		_tmp31_ = stmt;
		_tmp30_->import_id.id = sqlite3_column_int64 (_tmp31_, 9);
		_tmp32_ = row;
		_tmp33_ = stmt;
		_tmp32_->event_id.id = sqlite3_column_int64 (_tmp33_, 10);
		_tmp34_ = row;
		_tmp35_ = stmt;
		_tmp36_ = (const gchar*) sqlite3_column_text (_tmp35_, 11);
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (_tmp34_->md5);
		_tmp34_->md5 = _tmp37_;
		_tmp38_ = row;
		_tmp39_ = stmt;
		_tmp38_->time_created = sqlite3_column_int64 (_tmp39_, 12);
		_tmp40_ = row;
		_tmp41_ = stmt;
		_tmp40_->rating = rating_unserialize (sqlite3_column_int (_tmp41_, 13));
		_tmp42_ = row;
		_tmp43_ = stmt;
		_tmp44_ = (const gchar*) sqlite3_column_text (_tmp43_, 14);
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (_tmp42_->title);
		_tmp42_->title = _tmp45_;
		_tmp46_ = row;
		_tmp47_ = stmt;
		_tmp48_ = (const gchar*) sqlite3_column_text (_tmp47_, 15);
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_tmp46_->backlinks);
		_tmp46_->backlinks = _tmp49_;
		_tmp50_ = row;
		_tmp51_ = stmt;
		_tmp50_->time_reimported = sqlite3_column_int64 (_tmp51_, 16);
		_tmp52_ = row;
		_tmp53_ = stmt;
		_tmp52_->flags = (guint64) sqlite3_column_int64 (_tmp53_, 17);
		_tmp54_ = row;
		_tmp55_ = stmt;
		_tmp56_ = (const gchar*) sqlite3_column_text (_tmp55_, 18);
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (_tmp54_->comment);
		_tmp54_->comment = _tmp57_;
		_tmp58_ = all;
		_tmp59_ = row;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp59_);
		_video_row_unref0 (row);
	}
	result = all;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
video_table_set_filepath (VideoTable* self,
                          VideoID* video_id,
                          const gchar* filepath,
                          GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *video_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "filename", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_title (VideoTable* self,
                       VideoID* video_id,
                       const gchar* new_title,
                       GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	if (new_title != NULL) {
		_tmp0_ = new_title;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "title", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_comment (VideoTable* self,
                         VideoID* video_id,
                         const gchar* new_comment,
                         GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "comment", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_exposure_time (VideoTable* self,
                               VideoID* video_id,
                               GDateTime* time,
                               GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	g_return_if_fail (time != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "exposure_time", g_date_time_to_unix (time), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_rating (VideoTable* self,
                        VideoID* video_id,
                        Rating rating,
                        GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "rating", (gint64) rating_serialize (rating), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_set_flags (VideoTable* self,
                       VideoID* video_id,
                       guint64 flags,
                       GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "flags", (gint64) flags, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_update_backlinks (VideoTable* self,
                              VideoID* video_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	if (backlinks != NULL) {
		_tmp0_ = backlinks;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *video_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "backlinks", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_update_is_interpretable (VideoTable* self,
                                     VideoID* video_id,
                                     gboolean is_interpretable,
                                     GError** error)
{
	gint _tmp0_ = 0;
	VideoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	if (is_interpretable) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = *video_id;
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "is_interpretable", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
video_table_set_event (VideoTable* self,
                       VideoID* video_id,
                       EventID* event_id)
{
	VideoID _tmp0_;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
	g_return_val_if_fail (video_id != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = *video_id;
	_tmp1_ = *event_id;
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "event_id", _tmp1_.id);
	return result;
}

void
video_table_remove_by_file (VideoTable* self,
                            GFile* file,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = g_file_get_path (file);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("VideoTable.remove_by_file", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
video_table_remove (VideoTable* self,
                    VideoID* videoID,
                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	VideoID _tmp4_;
	sqlite3_stmt* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (videoID != NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *videoID;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("VideoTable.remove", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

gboolean
video_table_is_video_stored (VideoTable* self,
                             GFile* file)
{
	VideoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	video_table_get_id (self, file, &_tmp0_);
	result = video_id_is_valid (&_tmp0_);
	return result;
}

void
video_table_get_id (VideoTable* self,
                    GFile* file,
                    VideoID* result)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	VideoID _tmp7_ = {0};
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT ID FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = g_file_get_path (file);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res == SQLITE_ROW) {
		sqlite3_stmt* _tmp8_;
		_tmp8_ = stmt;
		video_id_init (&_tmp7_, sqlite3_column_int64 (_tmp8_, 0));
	} else {
		video_id_init (&_tmp7_, VIDEO_ID_INVALID);
	}
	*result = _tmp7_;
	_sqlite3_finalize0 (stmt);
	return;
}

GeeArrayList*
video_table_get_videos (VideoTable* self,
                        GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeArrayList* video_ids = NULL;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_VIDEO_ID, (GBoxedCopyFunc) video_id_dup, (GDestroyNotify) video_id_free, NULL, NULL, NULL);
	video_ids = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			GeeArrayList* _tmp6_;
			sqlite3_stmt* _tmp7_;
			VideoID _tmp8_ = {0};
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("VideoTable.get_videos", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (video_ids);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (video_ids);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = video_ids;
			_tmp7_ = stmt;
			video_id_init (&_tmp8_, sqlite3_column_int64 (_tmp7_, 0));
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp8_);
		}
	}
	result = video_ids;
	_sqlite3_finalize0 (stmt);
	return result;
}

static sqlite3_stmt*
video_table_get_duplicate_stmt (VideoTable* self,
                                GFile* file,
                                const gchar* md5)
{
	gboolean _tmp0_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp1_;
	gboolean first = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	gint col = 0;
	sqlite3_stmt* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	if (file != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || md5 != null");
	_tmp1_ = g_strdup ("SELECT id FROM VideoTable WHERE");
	sql = _tmp1_;
	first = TRUE;
	if (file != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sql;
		_tmp3_ = g_strconcat (_tmp2_, " filename=?", NULL);
		_g_free0 (sql);
		sql = _tmp3_;
		first = FALSE;
	}
	if (md5 != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		if (!first) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = sql;
			_tmp5_ = g_strconcat (_tmp4_, " OR ", NULL);
			_g_free0 (sql);
			sql = _tmp5_;
		}
		_tmp6_ = sql;
		_tmp7_ = g_strconcat (_tmp6_, " md5=?", NULL);
		_g_free0 (sql);
		sql = _tmp7_;
	}
	_tmp8_ = database_table_db;
	_tmp9_ = sql;
	_tmp11_ = sqlite3_prepare_v2 (_tmp8_, _tmp9_, -1, &_tmp10_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp10_;
	res = _tmp11_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	col = 1;
	if (file != NULL) {
		sqlite3_stmt* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		GDestroyNotify _tmp15_;
		_tmp12_ = stmt;
		_tmp13_ = col;
		col = _tmp13_ + 1;
		_tmp14_ = g_file_get_path (file);
		_tmp15_ = g_free;
		res = sqlite3_bind_text (_tmp12_, _tmp13_, _tmp14_, -1, _tmp15_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	if (md5 != NULL) {
		sqlite3_stmt* _tmp16_;
		gint _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		GDestroyNotify _tmp20_;
		_tmp16_ = stmt;
		_tmp17_ = col;
		col = _tmp17_ + 1;
		_tmp18_ = md5;
		_tmp19_ = g_strdup (_tmp18_);
		_tmp20_ = g_free;
		res = sqlite3_bind_text (_tmp16_, _tmp17_, _tmp19_, -1, _tmp20_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	result = stmt;
	_g_free0 (sql);
	return result;
}

gboolean
video_table_has_duplicate (VideoTable* self,
                           GFile* file,
                           const gchar* md5)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res == SQLITE_ROW) {
			result = TRUE;
			_sqlite3_finalize0 (stmt);
			return result;
		} else {
			database_table_fatal ("VideoTable.has_duplicate", res);
		}
	}
	result = FALSE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
_vala_array_add4 (VideoID* * array,
                  gint* length,
                  gint* size,
                  const VideoID* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (VideoID, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

VideoID*
video_table_get_duplicate_ids (VideoTable* self,
                               GFile* file,
                               const gchar* md5,
                               gint* result_length1)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	VideoID* ids = NULL;
	VideoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	VideoID* _tmp6_;
	gint _tmp6__length1;
	VideoID* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
	stmt = _tmp0_;
	_tmp1_ = g_new0 (VideoID, 0);
	ids = _tmp1_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		VideoID _tmp4_ = {0};
		sqlite3_stmt* _tmp5_;
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = stmt;
		video_id_init (&_tmp4_, sqlite3_column_int64 (_tmp3_, 0));
		_vala_array_add4 (&ids, &ids_length1, &_ids_size_, &_tmp4_);
		_tmp5_ = stmt;
		res = sqlite3_step (_tmp5_);
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
video_table_get_event_source_ids (VideoTable* self,
                                  EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventID _tmp4_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *event_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp7_;
			GeeArrayList* _tmp8_;
			sqlite3_stmt* _tmp9_;
			VideoID _tmp10_ = {0};
			gchar* _tmp11_;
			gchar* _tmp12_;
			if (!_tmp6_) {
			}
			_tmp6_ = FALSE;
			_tmp7_ = stmt;
			res = sqlite3_step (_tmp7_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_source_ids", res);
					break;
				}
			}
			_tmp8_ = _result_;
			_tmp9_ = stmt;
			video_id_init (&_tmp10_, sqlite3_column_int64 (_tmp9_, 0));
			_tmp11_ = video_id_upgrade_video_id_to_source_id (&_tmp10_);
			_tmp12_ = _tmp11_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	result = _result_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
video_table_set_timestamp (VideoTable* self,
                           VideoID* video_id,
                           GDateTime* timestamp,
                           GError** error)
{
	VideoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_TABLE (self));
	g_return_if_fail (video_id != NULL);
	g_return_if_fail (timestamp != NULL);
	_tmp0_ = *video_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "timestamp", g_date_time_to_unix (timestamp), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
video_table_upgrade_for_unset_timestamp (GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE VideoTable SET exposure_time = NULL WHERE exposure_time = '0'", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("VideoTable.upgrade_for_unset_timestamp", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

static void
video_table_class_init (VideoTableClass * klass,
                        gpointer klass_data)
{
	video_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = video_table_finalize;
}

static void
video_table_instance_init (VideoTable * self,
                           gpointer klass)
{
}

static void
video_table_finalize (DatabaseTable * obj)
{
	VideoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_TABLE, VideoTable);
	DATABASE_TABLE_CLASS (video_table_parent_class)->finalize (obj);
}

static GType
video_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoTable), 0, (GInstanceInitFunc) video_table_instance_init, NULL };
	GType video_table_type_id;
	video_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VideoTable", &g_define_type_info, 0);
	return video_table_type_id;
}

GType
video_table_get_type (void)
{
	static volatile gsize video_table_type_id__once = 0;
	if (g_once_init_enter (&video_table_type_id__once)) {
		GType video_table_type_id;
		video_table_type_id = video_table_get_type_once ();
		g_once_init_leave (&video_table_type_id__once, video_table_type_id);
	}
	return video_table_type_id__once;
}

