/* PhotoTable.c generated by valac 0.56.17, the Vala compiler
 * generated from PhotoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>
#include "shotwell-graphics-processor.h"
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gio/gio.h>

#define PHOTO_ID_INVALID ((gint64) -1)
#define PHOTO_TYPENAME "thumb"
#define IMPORT_ID_INVALID ((gint64) 0)
#define UTIL_USEC_PER_SEC ((gint64) 1000000)
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
#define EVENT_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPhotoRow ParamSpecPhotoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
typedef struct _PhotoTablePrivate PhotoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBackingPhotoRow ParamSpecBackingPhotoRow;

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;
typedef struct _BackingPhotoTablePrivate BackingPhotoTablePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PhotoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	gint64 time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	GpsCoords gps_coords;
	gchar* comment;
	gchar* backlinks;
	gint64 time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _ParamSpecPhotoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _PhotoTable {
	DatabaseTable parent_instance;
	PhotoTablePrivate * priv;
};

struct _PhotoTableClass {
	DatabaseTableClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _ParamSpecBackingPhotoRow {
	GParamSpec parent_instance;
};

struct _BackingPhotoTable {
	DatabaseTable parent_instance;
	BackingPhotoTablePrivate * priv;
};

struct _BackingPhotoTableClass {
	DatabaseTableClass parent_class;
};

static gpointer photo_row_parent_class = NULL;
static gpointer photo_table_parent_class = NULL;
static PhotoTable* photo_table_instance;
static PhotoTable* photo_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;
static gpointer backing_photo_row_parent_class = NULL;
static gpointer backing_photo_table_parent_class = NULL;
static BackingPhotoTable* backing_photo_table_instance;
static BackingPhotoTable* backing_photo_table_instance = NULL;

VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN void photo_id_init (PhotoID *self,
                    gint64 id);
VALA_EXTERN gboolean photo_id_is_invalid (PhotoID *self);
VALA_EXTERN gboolean photo_id_is_valid (PhotoID *self);
VALA_EXTERN guint photo_id_hash (PhotoID *self);
VALA_EXTERN guint int64_hash (gint64* n);
VALA_EXTERN gboolean photo_id_equal (void* a,
                         void* b);
VALA_EXTERN gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN void import_id_init (ImportID *self,
                     gint64 id);
VALA_EXTERN void import_id_generate (ImportID* result);
VALA_EXTERN gboolean import_id_is_invalid (ImportID *self);
VALA_EXTERN gboolean import_id_is_valid (ImportID *self);
VALA_EXTERN gint import_id_compare_func (ImportID* a,
                             ImportID* b);
VALA_EXTERN gint64 import_id_comparator (void* a,
                             void* b);
VALA_EXTERN gpointer photo_row_ref (gpointer instance);
VALA_EXTERN void photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_photo_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_photo_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_photo_row (const GValue* value);
VALA_EXTERN GType photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoRow, photo_row_unref)
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoRow* photo_row_new (void);
VALA_EXTERN PhotoRow* photo_row_construct (GType object_type);
VALA_EXTERN BackingPhotoRow* backing_photo_row_new (void);
VALA_EXTERN BackingPhotoRow* backing_photo_row_construct (GType object_type);
VALA_EXTERN void backing_photo_id_init (BackingPhotoID *self,
                            gint64 id);
VALA_EXTERN RawDeveloper* raw_developer_as_array (gint* result_length1);
static void photo_row_finalize (PhotoRow * obj);
static GType photo_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoTable, database_table_unref)
static PhotoTable* photo_table_new (void);
static PhotoTable* photo_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_warning (const gchar* op,
                             gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN PhotoTable* photo_table_get_instance (void);
VALA_EXTERN void photo_table_add (PhotoTable* self,
                      PhotoRow* photo_row,
                      PhotoID* result);
VALA_EXTERN gint64 now_sec (void);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN gint photo_file_format_serialize (PhotoFileFormat self);
VALA_EXTERN gint rating_serialize (Rating self);
VALA_EXTERN gchar* raw_developer_to_string (RawDeveloper self);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_table_reimport (PhotoTable* self,
                           PhotoRow* row,
                           GError** error);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN gboolean photo_table_master_exif_updated (PhotoTable* self,
                                          PhotoID* photoID,
                                          gint64 filesize,
                                          GDateTime* timestamp,
                                          const gchar* md5,
                                          const gchar* exif_md5,
                                          const gchar* thumbnail_md5,
                                          PhotoRow* row);
static void photo_table_validate_orientation (PhotoTable* self,
                                       PhotoRow* row);
VALA_EXTERN gboolean photo_table_set_orientation (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation);
VALA_EXTERN PhotoRow* photo_table_get_row (PhotoTable* self,
                               PhotoID* photo_id);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN GeeHashMap* photo_table_marshall_all_transformations (const gchar* trans);
VALA_EXTERN Rating rating_unserialize (gint value);
VALA_EXTERN PhotoFileFormat photo_file_format_unserialize (gint value);
VALA_EXTERN RawDeveloper raw_developer_from_string (const gchar* value);
VALA_EXTERN GeeArrayList* photo_table_get_all (PhotoTable* self);
VALA_EXTERN void photo_table_duplicate (PhotoTable* self,
                            PhotoID* photo_id,
                            const gchar* new_filename,
                            BackingPhotoID* editable_id,
                            BackingPhotoID* develop_shotwell,
                            BackingPhotoID* develop_camera_id,
                            BackingPhotoID* develop_embedded_id,
                            PhotoID* result);
VALA_EXTERN gchar* photo_table_unmarshall_all_transformations (GeeHashMap* transformations);
VALA_EXTERN gboolean photo_table_set_title (PhotoTable* self,
                                PhotoID* photo_id,
                                const gchar* new_title);
VALA_EXTERN gboolean database_table_update_text_by_id (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           const gchar* text);
VALA_EXTERN void photo_table_set_gps_coords (PhotoTable* self,
                                 PhotoID* photo_id,
                                 GpsCoords* new_gps_coords,
                                 GError** error);
VALA_EXTERN void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
VALA_EXTERN void database_table_update_double_by_id_2 (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           gdouble value,
                                           GError** error);
VALA_EXTERN gboolean photo_table_set_comment (PhotoTable* self,
                                  PhotoID* photo_id,
                                  const gchar* new_comment);
VALA_EXTERN void photo_table_set_filepath (PhotoTable* self,
                               PhotoID* photo_id,
                               const gchar* filepath,
                               GError** error);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
VALA_EXTERN void photo_table_update_timestamp (PhotoTable* self,
                                   PhotoID* photo_id,
                                   GDateTime* timestamp,
                                   GError** error);
VALA_EXTERN void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
VALA_EXTERN gboolean photo_table_set_exposure_time (PhotoTable* self,
                                        PhotoID* photo_id,
                                        GDateTime* time);
VALA_EXTERN gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
VALA_EXTERN void photo_table_set_import_id (PhotoTable* self,
                                PhotoID* photo_id,
                                ImportID* import_id,
                                GError** error);
VALA_EXTERN gboolean photo_table_remove_by_file (PhotoTable* self,
                                     GFile* file);
VALA_EXTERN void photo_table_remove (PhotoTable* self,
                         PhotoID* photo_id,
                         GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN GeeArrayList* photo_table_get_photos (PhotoTable* self);
VALA_EXTERN gboolean database_table_update_int_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint value);
VALA_EXTERN gboolean photo_table_replace_flags (PhotoTable* self,
                                    PhotoID* photo_id,
                                    guint64 flags);
VALA_EXTERN gboolean photo_table_set_rating (PhotoTable* self,
                                 PhotoID* photo_id,
                                 Rating rating);
VALA_EXTERN gint photo_table_get_event_photo_count (PhotoTable* self,
                                        EventID* event_id);
VALA_EXTERN GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self,
                                                EventID* event_id);
VALA_EXTERN gboolean photo_table_event_has_photos (PhotoTable* self,
                                       EventID* event_id);
VALA_EXTERN gboolean photo_table_drop_event (PhotoTable* self,
                                 EventID* event_id);
VALA_EXTERN gboolean photo_table_set_event (PhotoTable* self,
                                PhotoID* photo_id,
                                EventID* event_id);
static gchar* photo_table_get_raw_transformations (PhotoTable* self,
                                            PhotoID* photo_id);
VALA_EXTERN gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt** stmt);
static gboolean photo_table_set_raw_transformations (PhotoTable* self,
                                              PhotoID* photo_id,
                                              const gchar* trans);
VALA_EXTERN gboolean photo_table_set_transformation_state (PhotoTable* self,
                                               PhotoID* photo_id,
                                               Orientation orientation,
                                               GeeHashMap* transformations);
VALA_EXTERN gboolean photo_table_set_transformation (PhotoTable* self,
                                         PhotoID* photo_id,
                                         KeyValueMap* map);
VALA_EXTERN gboolean photo_table_remove_transformation (PhotoTable* self,
                                            PhotoID* photo_id,
                                            const gchar* object);
VALA_EXTERN gboolean photo_table_remove_all_transformations (PhotoTable* self,
                                                 PhotoID* photo_id);
static sqlite3_stmt* photo_table_get_duplicate_stmt (PhotoTable* self,
                                              GFile* file,
                                              const gchar* thumbnail_md5,
                                              const gchar* md5,
                                              PhotoFileFormat file_format);
VALA_EXTERN gboolean photo_table_has_duplicate (PhotoTable* self,
                                    GFile* file,
                                    const gchar* thumbnail_md5,
                                    const gchar* md5,
                                    PhotoFileFormat file_format);
VALA_EXTERN PhotoID* photo_table_get_duplicate_ids (PhotoTable* self,
                                        GFile* file,
                                        const gchar* thumbnail_md5,
                                        const gchar* md5,
                                        PhotoFileFormat file_format,
                                        gint* result_length1);
static void _vala_array_add2 (PhotoID* * array,
                       gint* length,
                       gint* size,
                       const PhotoID* value);
VALA_EXTERN void photo_table_update_backlinks (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* backlinks,
                                   GError** error);
VALA_EXTERN void photo_table_attach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  BackingPhotoID* editable_id,
                                  GError** error);
VALA_EXTERN void photo_table_detach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  GError** error);
VALA_EXTERN void photo_table_set_metadata_dirty (PhotoTable* self,
                                     PhotoID* photo_id,
                                     gboolean dirty,
                                     GError** error);
VALA_EXTERN void photo_table_update_raw_development (PhotoTable* self,
                                         PhotoRow* row,
                                         RawDeveloper rd,
                                         BackingPhotoID* backing_photo_id,
                                         GError** error);
VALA_EXTERN void photo_table_remove_development (PhotoTable* self,
                                     PhotoRow* row,
                                     RawDeveloper rd,
                                     GError** error);
VALA_EXTERN void photo_table_upgrade_for_unset_timestamp (GError** error);
static void photo_table_finalize (DatabaseTable * obj);
static GType photo_table_get_type_once (void);
VALA_EXTERN gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
VALA_EXTERN gboolean backing_photo_id_is_valid (BackingPhotoID *self);
VALA_EXTERN gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
VALA_EXTERN GDateTime* coarsify_date_time (GDateTime* dt);
VALA_EXTERN gboolean backing_photo_row_is_touched (BackingPhotoRow* self,
                                       GFileInfo* info);
VALA_EXTERN void backing_photo_row_copy_from (BackingPhotoRow* self,
                                  BackingPhotoRow* from);
static void backing_photo_row_finalize (BackingPhotoRow * obj);
static GType backing_photo_row_get_type_once (void);
VALA_EXTERN GType backing_photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoTable, database_table_unref)
static BackingPhotoTable* backing_photo_table_new (void);
static BackingPhotoTable* backing_photo_table_construct (GType object_type);
VALA_EXTERN BackingPhotoTable* backing_photo_table_get_instance (void);
VALA_EXTERN void backing_photo_table_add (BackingPhotoTable* self,
                              BackingPhotoRow* state,
                              GError** error);
VALA_EXTERN BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GError** error);
VALA_EXTERN void backing_photo_table_update (BackingPhotoTable* self,
                                 BackingPhotoRow* row,
                                 GError** error);
VALA_EXTERN void backing_photo_table_update_attributes (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GDateTime* timestamp,
                                            gint64 filesize,
                                            GError** error);
VALA_EXTERN void backing_photo_table_remove (BackingPhotoTable* self,
                                 BackingPhotoID* backing_id,
                                 GError** error);
VALA_EXTERN void backing_photo_table_set_filepath (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       const gchar* filepath,
                                       GError** error);
VALA_EXTERN void backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                           BackingPhotoID* id,
                                           GDateTime* timestamp,
                                           GError** error);
static void backing_photo_table_finalize (DatabaseTable * obj);
static GType backing_photo_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
photo_id_init (PhotoID *self,
               gint64 id)
{
	memset (self, 0, sizeof (PhotoID));
	(*self).id = id;
}

gboolean
photo_id_is_invalid (PhotoID *self)
{
	gboolean result;
	result = (*self).id == PHOTO_ID_INVALID;
	return result;
}

gboolean
photo_id_is_valid (PhotoID *self)
{
	gboolean result;
	result = (*self).id != PHOTO_ID_INVALID;
	return result;
}

guint
photo_id_hash (PhotoID *self)
{
	guint result;
	result = int64_hash (&(*self).id);
	return result;
}

gboolean
photo_id_equal (void* a,
                void* b)
{
	gboolean result;
	result = (*((PhotoID*) a)).id == (*((PhotoID*) b)).id;
	return result;
}

gchar*
photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id)
{
	PhotoID _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", PHOTO_TYPENAME, _tmp0_.id);
	result = _tmp1_;
	return result;
}

PhotoID*
photo_id_dup (const PhotoID* self)
{
	PhotoID* dup;
	dup = g_new0 (PhotoID, 1);
	memcpy (dup, self, sizeof (PhotoID));
	return dup;
}

void
photo_id_free (PhotoID* self)
{
	g_free (self);
}

static GType
photo_id_get_type_once (void)
{
	GType photo_id_type_id;
	photo_id_type_id = g_boxed_type_register_static ("PhotoID", (GBoxedCopyFunc) photo_id_dup, (GBoxedFreeFunc) photo_id_free);
	return photo_id_type_id;
}

GType
photo_id_get_type (void)
{
	static volatile gsize photo_id_type_id__once = 0;
	if (g_once_init_enter (&photo_id_type_id__once)) {
		GType photo_id_type_id;
		photo_id_type_id = photo_id_get_type_once ();
		g_once_init_leave (&photo_id_type_id__once, photo_id_type_id);
	}
	return photo_id_type_id__once;
}

void
import_id_init (ImportID *self,
                gint64 id)
{
	memset (self, 0, sizeof (ImportID));
	(*self).id = id;
}

void
import_id_generate (ImportID* result)
{
	gint64 id = 0LL;
	ImportID _tmp0_ = {0};
	id = g_get_real_time () / UTIL_USEC_PER_SEC;
	import_id_init (&_tmp0_, id);
	*result = _tmp0_;
	return;
}

gboolean
import_id_is_invalid (ImportID *self)
{
	gboolean result;
	result = (*self).id == IMPORT_ID_INVALID;
	return result;
}

gboolean
import_id_is_valid (ImportID *self)
{
	gboolean result;
	result = (*self).id != IMPORT_ID_INVALID;
	return result;
}

gint
import_id_compare_func (ImportID* a,
                        ImportID* b)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	if (a != NULL) {
		_tmp0_ = b != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "a != null && b != null");
	result = (gint) ((*a).id - (*b).id);
	return result;
}

gint64
import_id_comparator (void* a,
                      void* b)
{
	gint64 result;
	result = (*((ImportID*) a)).id - (*((ImportID*) b)).id;
	return result;
}

ImportID*
import_id_dup (const ImportID* self)
{
	ImportID* dup;
	dup = g_new0 (ImportID, 1);
	memcpy (dup, self, sizeof (ImportID));
	return dup;
}

void
import_id_free (ImportID* self)
{
	g_free (self);
}

static GType
import_id_get_type_once (void)
{
	GType import_id_type_id;
	import_id_type_id = g_boxed_type_register_static ("ImportID", (GBoxedCopyFunc) import_id_dup, (GBoxedFreeFunc) import_id_free);
	return import_id_type_id;
}

GType
import_id_get_type (void)
{
	static volatile gsize import_id_type_id__once = 0;
	if (g_once_init_enter (&import_id_type_id__once)) {
		GType import_id_type_id;
		import_id_type_id = import_id_get_type_once ();
		g_once_init_leave (&import_id_type_id__once, import_id_type_id);
	}
	return import_id_type_id__once;
}

PhotoRow*
photo_row_construct (GType object_type)
{
	PhotoRow* self = NULL;
	BackingPhotoRow* _tmp0_;
	gint _tmp1_ = 0;
	RawDeveloper* _tmp2_;
	RawDeveloper* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID* _tmp4_;
	gint _tmp5_ = 0;
	RawDeveloper* _tmp6_;
	gint _tmp9_ = 0;
	RawDeveloper* _tmp10_;
	RawDeveloper* _tmp11_;
	gint _tmp11__length1;
	BackingPhotoID* _tmp12_;
	gint _tmp13_ = 0;
	RawDeveloper* _tmp14_;
	self = (PhotoRow*) g_type_create_instance (object_type);
	_tmp0_ = backing_photo_row_new ();
	_backing_photo_row_unref0 (self->master);
	self->master = _tmp0_;
	backing_photo_id_init (&self->editable_id, BACKING_PHOTO_ID_INVALID);
	_tmp2_ = raw_developer_as_array (&_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = g_new0 (BackingPhotoID, _tmp1_);
	self->development_ids = (g_free (self->development_ids), NULL);
	self->development_ids = _tmp4_;
	self->development_ids_length1 = _tmp1_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = raw_developer_as_array (&_tmp5_);
	{
		RawDeveloper* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp6_;
		d_collection_length1 = _tmp5_;
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			RawDeveloper d = 0;
			d = d_collection[d_it];
			{
				BackingPhotoID* _tmp7_;
				gint _tmp7__length1;
				BackingPhotoID _tmp8_ = {0};
				_tmp7_ = self->development_ids;
				_tmp7__length1 = self->development_ids_length1;
				backing_photo_id_init (&_tmp8_, BACKING_PHOTO_ID_INVALID);
				_tmp7_[d] = _tmp8_;
			}
		}
		d_collection = (g_free (d_collection), NULL);
	}
	memset (&self->gps_coords, 0, sizeof (GpsCoords));
	_tmp10_ = raw_developer_as_array (&_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp12_ = g_new0 (BackingPhotoID, _tmp9_);
	self->development_ids = (g_free (self->development_ids), NULL);
	self->development_ids = _tmp12_;
	self->development_ids_length1 = _tmp9_;
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp14_ = raw_developer_as_array (&_tmp13_);
	{
		RawDeveloper* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp14_;
		d_collection_length1 = _tmp13_;
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			RawDeveloper d = 0;
			d = d_collection[d_it];
			{
				BackingPhotoID* _tmp15_;
				gint _tmp15__length1;
				BackingPhotoID _tmp16_ = {0};
				_tmp15_ = self->development_ids;
				_tmp15__length1 = self->development_ids_length1;
				backing_photo_id_init (&_tmp16_, BACKING_PHOTO_ID_INVALID);
				_tmp15_[d] = _tmp16_;
			}
		}
		d_collection = (g_free (d_collection), NULL);
	}
	return self;
}

PhotoRow*
photo_row_new (void)
{
	return photo_row_construct (TYPE_PHOTO_ROW);
}

static void
value_photo_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_row_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	PhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecPhotoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_row (GValue* value,
                     gpointer v_object)
{
	PhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_row_unref (old);
	}
}

void
value_take_photo_row (GValue* value,
                      gpointer v_object)
{
	PhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_row_unref (old);
	}
}

static void
photo_row_class_init (PhotoRowClass * klass,
                      gpointer klass_data)
{
	photo_row_parent_class = g_type_class_peek_parent (klass);
	((PhotoRowClass *) klass)->finalize = photo_row_finalize;
}

static void
photo_row_instance_init (PhotoRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_row_finalize (PhotoRow * obj)
{
	PhotoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_ROW, PhotoRow);
	g_signal_handlers_destroy (self);
	_backing_photo_row_unref0 (self->master);
	_g_date_time_unref0 (self->exposure_time);
	_g_object_unref0 (self->transformations);
	_g_free0 (self->md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->exif_md5);
	_g_free0 (self->title);
	_g_free0 (self->comment);
	_g_free0 (self->backlinks);
	self->development_ids = (g_free (self->development_ids), NULL);
}

static GType
photo_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_row_init, value_photo_row_free_value, value_photo_row_copy_value, value_photo_row_peek_pointer, "p", value_photo_row_collect_value, "p", value_photo_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoRow), 0, (GInstanceInitFunc) photo_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_row_type_id;
	photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_row_type_id;
}

GType
photo_row_get_type (void)
{
	static volatile gsize photo_row_type_id__once = 0;
	if (g_once_init_enter (&photo_row_type_id__once)) {
		GType photo_row_type_id;
		photo_row_type_id = photo_row_get_type_once ();
		g_once_init_leave (&photo_row_type_id__once, photo_row_type_id);
	}
	return photo_row_type_id__once;
}

gpointer
photo_row_ref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_row_unref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoTable*
photo_table_construct (GType object_type)
{
	PhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3_stmt* _tmp13_ = NULL;
	gint _tmp14_;
	sqlite3_stmt* _tmp15_;
	sqlite3* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3* _tmp20_;
	sqlite3_stmt* _tmp21_ = NULL;
	gint _tmp22_;
	sqlite3_stmt* _tmp23_;
	self = (PhotoTable*) database_table_construct (object_type);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS PhotoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "orientation INTEGER, " "original_orientation INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "transformations TEXT, " "md5 TEXT, " "thumbnail_md5 TEXT, " "exif_md5 TEXT, " "time_created INTEGER, " "flags INTEGER DEFAULT 0, " "rating INTEGER DEFAULT 0, " "file_format INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "editable_id INTEGER DEFAULT -1, " "metadata_dirty INTEGER DEFAULT 0, " "developer TEXT, " "develop_shotwell_id INTEGER DEFAULT -1, " "develop_camera_id INTEGER DEFAULT -1, " "develop_embedded_id INTEGER DEFAULT -1, " "has_gps INTEGER DEFAULT -1, " "gps_lat REAL, " "gps_lon REAL, " "comment TEXT" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create photo table", res);
	}
	_tmp4_ = database_table_db;
	_tmp6_ = sqlite3_prepare_v2 (_tmp4_, "CREATE INDEX IF NOT EXISTS PhotoEventIDIndex ON PhotoTable (event_id)", -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (stmt2);
	stmt2 = _tmp5_;
	res2 = _tmp6_;
	_vala_assert (res2 == SQLITE_OK, "res2 == Sqlite.OK");
	_tmp7_ = stmt2;
	res2 = sqlite3_step (_tmp7_);
	if (res2 != SQLITE_DONE) {
		database_table_fatal ("create photo table", res2);
	}
	_tmp8_ = database_table_db;
	_tmp10_ = sqlite3_prepare_v2 (_tmp8_, "DROP INDEX IF EXISTS PhotoTableMD5Format", -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	res = _tmp10_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	res = sqlite3_step (_tmp11_);
	if (res != SQLITE_DONE) {
		database_table_warning ("Failed to drop old PhotoTable index", res);
	}
	_tmp12_ = database_table_db;
	_tmp14_ = sqlite3_prepare_v2 (_tmp12_, "CREATE INDEX IF NOT EXISTS PhotoTableMD5FormatV2 on PhotoTable(md5, fi" \
"le_format)", -1, &_tmp13_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp13_;
	res = _tmp14_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp15_ = stmt;
	res = sqlite3_step (_tmp15_);
	if (res != SQLITE_DONE) {
		database_table_warning ("Failed to create index on md5 and file_format", res);
	}
	_tmp16_ = database_table_db;
	_tmp18_ = sqlite3_prepare_v2 (_tmp16_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5Format on PhotoTable(" \
"thumbnail_md5, file_format)", -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp17_;
	res = _tmp18_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp19_ = stmt;
	res = sqlite3_step (_tmp19_);
	if (res != SQLITE_DONE) {
		database_table_warning ("Failed to create index on md5 and file_format", res);
	}
	_tmp20_ = database_table_db;
	_tmp22_ = sqlite3_prepare_v2 (_tmp20_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5MD5 on PhotoTable(thu" \
"mbnail_md5, md5)", -1, &_tmp21_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp21_;
	res = _tmp22_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp23_ = stmt;
	res = sqlite3_step (_tmp23_);
	if (res != SQLITE_DONE) {
		database_table_warning ("Failed to create index on thumbnail_md5 and md5", res);
	}
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "PhotoTable");
	_sqlite3_finalize0 (stmt2);
	_sqlite3_finalize0 (stmt);
	return self;
}

static PhotoTable*
photo_table_new (void)
{
	return photo_table_construct (TYPE_PHOTO_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

PhotoTable*
photo_table_get_instance (void)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp2_;
	PhotoTable* _tmp3_;
	PhotoTable* result;
	_tmp0_ = photo_table_instance;
	if (_tmp0_ == NULL) {
		PhotoTable* _tmp1_;
		_tmp1_ = photo_table_new ();
		_database_table_unref0 (photo_table_instance);
		photo_table_instance = _tmp1_;
	}
	_tmp2_ = photo_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
photo_table_add (PhotoTable* self,
                 PhotoRow* photo_row,
                 PhotoID* result)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp3_;
	BackingPhotoRow* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	BackingPhotoRow* _tmp9_;
	Dimensions _tmp10_;
	sqlite3_stmt* _tmp11_;
	BackingPhotoRow* _tmp12_;
	Dimensions _tmp13_;
	sqlite3_stmt* _tmp14_;
	BackingPhotoRow* _tmp15_;
	BackingPhotoRow* _tmp16_;
	GDateTime* _tmp17_;
	GDateTime* _tmp22_;
	sqlite3_stmt* _tmp26_;
	BackingPhotoRow* _tmp27_;
	sqlite3_stmt* _tmp28_;
	BackingPhotoRow* _tmp29_;
	sqlite3_stmt* _tmp30_;
	ImportID _tmp31_;
	sqlite3_stmt* _tmp32_;
	sqlite3_stmt* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GDestroyNotify _tmp36_;
	sqlite3_stmt* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GDestroyNotify _tmp40_;
	sqlite3_stmt* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GDestroyNotify _tmp44_;
	sqlite3_stmt* _tmp45_;
	sqlite3_stmt* _tmp46_;
	BackingPhotoRow* _tmp47_;
	sqlite3_stmt* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	GDestroyNotify _tmp51_;
	sqlite3_stmt* _tmp52_;
	sqlite3_stmt* _tmp53_;
	sqlite3_stmt* _tmp54_;
	gchar* _tmp55_;
	GDestroyNotify _tmp56_;
	sqlite3_stmt* _tmp57_;
	GpsCoords _tmp58_;
	sqlite3_stmt* _tmp59_;
	GpsCoords _tmp60_;
	sqlite3_stmt* _tmp61_;
	GpsCoords _tmp62_;
	sqlite3_stmt* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	GDestroyNotify _tmp66_;
	sqlite3_stmt* _tmp67_;
	sqlite3* _tmp69_;
	BackingPhotoRow* _tmp70_;
	PhotoID _tmp71_;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (photo_row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO PhotoTable (filename, width, height, filesize, timestamp, " \
"exposure_time, " "orientation, original_orientation, import_id, event_id, md5, thumbnail" \
"_md5, " "exif_md5, time_created, file_format, title, rating, editable_id, devel" \
"oper, has_gps, gps_lat, gps_lon, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," \
" ?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_created = now_sec ();
	_tmp3_ = stmt;
	_tmp4_ = photo_row->master;
	_tmp5_ = _tmp4_->filepath;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp6_, -1, _tmp7_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = photo_row->master;
	_tmp10_ = _tmp9_->dim;
	res = sqlite3_bind_int (_tmp8_, 2, _tmp10_.width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	_tmp12_ = photo_row->master;
	_tmp13_ = _tmp12_->dim;
	res = sqlite3_bind_int (_tmp11_, 3, _tmp13_.height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = stmt;
	_tmp15_ = photo_row->master;
	res = sqlite3_bind_int64 (_tmp14_, 4, _tmp15_->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp16_ = photo_row->master;
	_tmp17_ = _tmp16_->timestamp;
	if (_tmp17_ == NULL) {
		sqlite3_stmt* _tmp18_;
		_tmp18_ = stmt;
		res = sqlite3_bind_null (_tmp18_, 5);
	} else {
		sqlite3_stmt* _tmp19_;
		BackingPhotoRow* _tmp20_;
		GDateTime* _tmp21_;
		_tmp19_ = stmt;
		_tmp20_ = photo_row->master;
		_tmp21_ = _tmp20_->timestamp;
		res = sqlite3_bind_int64 (_tmp19_, 5, g_date_time_to_unix (_tmp21_));
	}
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp22_ = photo_row->exposure_time;
	if (_tmp22_ == NULL) {
		sqlite3_stmt* _tmp23_;
		_tmp23_ = stmt;
		res = sqlite3_bind_null (_tmp23_, 6);
	} else {
		sqlite3_stmt* _tmp24_;
		GDateTime* _tmp25_;
		_tmp24_ = stmt;
		_tmp25_ = photo_row->exposure_time;
		res = sqlite3_bind_int64 (_tmp24_, 6, g_date_time_to_unix (_tmp25_));
	}
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp26_ = stmt;
	_tmp27_ = photo_row->master;
	res = sqlite3_bind_int (_tmp26_, 7, (gint) _tmp27_->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp28_ = stmt;
	_tmp29_ = photo_row->master;
	res = sqlite3_bind_int (_tmp28_, 8, (gint) _tmp29_->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp30_ = stmt;
	_tmp31_ = photo_row->import_id;
	res = sqlite3_bind_int64 (_tmp30_, 9, _tmp31_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp32_ = stmt;
	res = sqlite3_bind_int64 (_tmp32_, 10, EVENT_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp33_ = stmt;
	_tmp34_ = photo_row->md5;
	_tmp35_ = g_strdup (_tmp34_);
	_tmp36_ = g_free;
	res = sqlite3_bind_text (_tmp33_, 11, _tmp35_, -1, _tmp36_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp37_ = stmt;
	_tmp38_ = photo_row->thumbnail_md5;
	_tmp39_ = g_strdup (_tmp38_);
	_tmp40_ = g_free;
	res = sqlite3_bind_text (_tmp37_, 12, _tmp39_, -1, _tmp40_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp41_ = stmt;
	_tmp42_ = photo_row->exif_md5;
	_tmp43_ = g_strdup (_tmp42_);
	_tmp44_ = g_free;
	res = sqlite3_bind_text (_tmp41_, 13, _tmp43_, -1, _tmp44_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp45_ = stmt;
	res = sqlite3_bind_int64 (_tmp45_, 14, time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp46_ = stmt;
	_tmp47_ = photo_row->master;
	res = sqlite3_bind_int (_tmp46_, 15, photo_file_format_serialize (_tmp47_->file_format));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp48_ = stmt;
	_tmp49_ = photo_row->title;
	_tmp50_ = g_strdup (_tmp49_);
	_tmp51_ = g_free;
	res = sqlite3_bind_text (_tmp48_, 16, _tmp50_, -1, _tmp51_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp52_ = stmt;
	res = sqlite3_bind_int64 (_tmp52_, 17, (gint64) rating_serialize (photo_row->rating));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp53_ = stmt;
	res = sqlite3_bind_int64 (_tmp53_, 18, BACKING_PHOTO_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp54_ = stmt;
	_tmp55_ = raw_developer_to_string (photo_row->developer);
	_tmp56_ = g_free;
	res = sqlite3_bind_text (_tmp54_, 19, _tmp55_, -1, _tmp56_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp57_ = stmt;
	_tmp58_ = photo_row->gps_coords;
	res = sqlite3_bind_int (_tmp57_, 20, _tmp58_.has_gps);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp59_ = stmt;
	_tmp60_ = photo_row->gps_coords;
	res = sqlite3_bind_double (_tmp59_, 21, _tmp60_.latitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp61_ = stmt;
	_tmp62_ = photo_row->gps_coords;
	res = sqlite3_bind_double (_tmp61_, 22, _tmp62_.longitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp63_ = stmt;
	_tmp64_ = photo_row->comment;
	_tmp65_ = g_strdup (_tmp64_);
	_tmp66_ = g_free;
	res = sqlite3_bind_text (_tmp63_, 23, _tmp65_, -1, _tmp66_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp67_ = stmt;
	res = sqlite3_step (_tmp67_);
	if (res != SQLITE_DONE) {
		PhotoID _tmp68_ = {0};
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("add_photo", res);
		}
		photo_id_init (&_tmp68_, PHOTO_ID_INVALID);
		*result = _tmp68_;
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp69_ = database_table_db;
	photo_id_init (&photo_row->photo_id, sqlite3_last_insert_rowid (_tmp69_));
	_tmp70_ = photo_row->master;
	photo_row->orientation = _tmp70_->original_orientation;
	event_id_init (&photo_row->event_id, EVENT_ID_INVALID);
	photo_row->time_created = time_created;
	photo_row->flags = (guint64) 0;
	_tmp71_ = photo_row->photo_id;
	*result = _tmp71_;
	_sqlite3_finalize0 (stmt);
	return;
}

void
photo_table_reimport (PhotoTable* self,
                      PhotoRow* row,
                      GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint64 time_reimported = 0LL;
	sqlite3_stmt* _tmp3_;
	BackingPhotoRow* _tmp4_;
	Dimensions _tmp5_;
	sqlite3_stmt* _tmp6_;
	BackingPhotoRow* _tmp7_;
	Dimensions _tmp8_;
	sqlite3_stmt* _tmp9_;
	BackingPhotoRow* _tmp10_;
	sqlite3_stmt* _tmp11_;
	BackingPhotoRow* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	sqlite3_stmt* _tmp18_;
	BackingPhotoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	BackingPhotoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GDestroyNotify _tmp25_;
	sqlite3_stmt* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GDestroyNotify _tmp29_;
	sqlite3_stmt* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GDestroyNotify _tmp33_;
	sqlite3_stmt* _tmp34_;
	BackingPhotoRow* _tmp35_;
	sqlite3_stmt* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	GDestroyNotify _tmp39_;
	sqlite3_stmt* _tmp40_;
	GpsCoords _tmp41_;
	sqlite3_stmt* _tmp42_;
	GpsCoords _tmp43_;
	sqlite3_stmt* _tmp44_;
	GpsCoords _tmp45_;
	sqlite3_stmt* _tmp46_;
	sqlite3_stmt* _tmp47_;
	PhotoID _tmp48_;
	sqlite3_stmt* _tmp49_;
	BackingPhotoRow* _tmp50_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET width = ?, height = ?, filesize = ?, timestamp =" \
" ?, " "exposure_time = ?, orientation = ?, original_orientation = ?, md5 = ?," \
" " "exif_md5 = ?, thumbnail_md5 = ?, file_format = ?, title = ?, " "has_gps = ?, gps_lat = ?, gps_lon = ?, time_reimported = ? " "WHERE id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_reimported = now_sec ();
	_tmp3_ = stmt;
	_tmp4_ = row->master;
	_tmp5_ = _tmp4_->dim;
	res = sqlite3_bind_int (_tmp3_, 1, _tmp5_.width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	_tmp7_ = row->master;
	_tmp8_ = _tmp7_->dim;
	res = sqlite3_bind_int (_tmp6_, 2, _tmp8_.height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	_tmp10_ = row->master;
	res = sqlite3_bind_int64 (_tmp9_, 3, _tmp10_->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	_tmp12_ = row->master;
	_tmp13_ = _tmp12_->timestamp;
	res = sqlite3_bind_int64 (_tmp11_, 4, g_date_time_to_unix (_tmp13_));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = row->exposure_time;
	if (_tmp14_ == NULL) {
		sqlite3_stmt* _tmp15_;
		_tmp15_ = stmt;
		res = sqlite3_bind_null (_tmp15_, 5);
	} else {
		sqlite3_stmt* _tmp16_;
		GDateTime* _tmp17_;
		_tmp16_ = stmt;
		_tmp17_ = row->exposure_time;
		res = sqlite3_bind_int64 (_tmp16_, 5, g_date_time_to_unix (_tmp17_));
	}
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp18_ = stmt;
	_tmp19_ = row->master;
	res = sqlite3_bind_int (_tmp18_, 6, (gint) _tmp19_->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp20_ = stmt;
	_tmp21_ = row->master;
	res = sqlite3_bind_int (_tmp20_, 7, (gint) _tmp21_->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp22_ = stmt;
	_tmp23_ = row->md5;
	_tmp24_ = g_strdup (_tmp23_);
	_tmp25_ = g_free;
	res = sqlite3_bind_text (_tmp22_, 8, _tmp24_, -1, _tmp25_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp26_ = stmt;
	_tmp27_ = row->exif_md5;
	_tmp28_ = g_strdup (_tmp27_);
	_tmp29_ = g_free;
	res = sqlite3_bind_text (_tmp26_, 9, _tmp28_, -1, _tmp29_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp30_ = stmt;
	_tmp31_ = row->thumbnail_md5;
	_tmp32_ = g_strdup (_tmp31_);
	_tmp33_ = g_free;
	res = sqlite3_bind_text (_tmp30_, 10, _tmp32_, -1, _tmp33_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp34_ = stmt;
	_tmp35_ = row->master;
	res = sqlite3_bind_int (_tmp34_, 11, photo_file_format_serialize (_tmp35_->file_format));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp36_ = stmt;
	_tmp37_ = row->title;
	_tmp38_ = g_strdup (_tmp37_);
	_tmp39_ = g_free;
	res = sqlite3_bind_text (_tmp36_, 12, _tmp38_, -1, _tmp39_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp40_ = stmt;
	_tmp41_ = row->gps_coords;
	res = sqlite3_bind_int (_tmp40_, 13, _tmp41_.has_gps);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp42_ = stmt;
	_tmp43_ = row->gps_coords;
	res = sqlite3_bind_double (_tmp42_, 14, _tmp43_.latitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp44_ = stmt;
	_tmp45_ = row->gps_coords;
	res = sqlite3_bind_double (_tmp44_, 15, _tmp45_.longitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp46_ = stmt;
	res = sqlite3_bind_int64 (_tmp46_, 16, time_reimported);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp47_ = stmt;
	_tmp48_ = row->photo_id;
	res = sqlite3_bind_int64 (_tmp47_, 17, _tmp48_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp49_ = stmt;
	res = sqlite3_step (_tmp49_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("PhotoTable.reimport_master", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	row->time_reimported = time_reimported;
	_tmp50_ = row->master;
	row->orientation = _tmp50_->original_orientation;
	_sqlite3_finalize0 (stmt);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

gboolean
photo_table_master_exif_updated (PhotoTable* self,
                                 PhotoID* photoID,
                                 gint64 filesize,
                                 GDateTime* timestamp,
                                 const gchar* md5,
                                 const gchar* exif_md5,
                                 const gchar* thumbnail_md5,
                                 PhotoRow* row)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	GDestroyNotify _tmp10_;
	sqlite3_stmt* _tmp11_;
	gchar* _tmp12_;
	GDestroyNotify _tmp13_;
	sqlite3_stmt* _tmp14_;
	PhotoID _tmp15_;
	sqlite3_stmt* _tmp16_;
	BackingPhotoRow* _tmp17_;
	BackingPhotoRow* _tmp18_;
	GDateTime* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photoID != NULL, FALSE);
	g_return_val_if_fail (timestamp != NULL, FALSE);
	g_return_val_if_fail (md5 != NULL, FALSE);
	g_return_val_if_fail (IS_PHOTO_ROW (row), FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET filesize = ?, timestamp = ?, md5 = ?, exif_md5 =" \
" ?," "thumbnail_md5 =? WHERE id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int64 (_tmp3_, 1, filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	res = sqlite3_bind_int64 (_tmp4_, 2, g_date_time_to_unix (timestamp));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = g_strdup (md5);
	_tmp7_ = g_free;
	res = sqlite3_bind_text (_tmp5_, 3, _tmp6_, -1, _tmp7_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = g_strdup (exif_md5);
	_tmp10_ = g_free;
	res = sqlite3_bind_text (_tmp8_, 4, _tmp9_, -1, _tmp10_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	_tmp12_ = g_strdup (thumbnail_md5);
	_tmp13_ = g_free;
	res = sqlite3_bind_text (_tmp11_, 5, _tmp12_, -1, _tmp13_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = stmt;
	_tmp15_ = *photoID;
	res = sqlite3_bind_int64 (_tmp14_, 6, _tmp15_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp16_ = stmt;
	res = sqlite3_step (_tmp16_);
	if (res != SQLITE_DONE) {
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("write_update_photo", res);
		}
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp17_ = row->master;
	_tmp17_->filesize = filesize;
	_tmp18_ = row->master;
	_tmp19_ = _g_date_time_ref0 (timestamp);
	_g_date_time_unref0 (_tmp18_->timestamp);
	_tmp18_->timestamp = _tmp19_;
	_tmp20_ = g_strdup (md5);
	_g_free0 (row->md5);
	row->md5 = _tmp20_;
	_tmp21_ = g_strdup (exif_md5);
	_g_free0 (row->exif_md5);
	row->exif_md5 = _tmp21_;
	_tmp22_ = g_strdup (thumbnail_md5);
	_g_free0 (row->thumbnail_md5);
	row->thumbnail_md5 = _tmp22_;
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
photo_table_validate_orientation (PhotoTable* self,
                                  PhotoRow* row)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	if (row->orientation < ORIENTATION_MIN) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = row->orientation > ORIENTATION_MAX;
	}
	if (_tmp0_) {
		PhotoID _tmp1_;
		_tmp1_ = row->photo_id;
		photo_table_set_orientation (self, &_tmp1_, ORIENTATION_MIN);
		row->orientation = ORIENTATION_MIN;
	}
}

PhotoRow*
photo_table_get_row (PhotoTable* self,
                     PhotoID* photo_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	PhotoID _tmp4_;
	sqlite3_stmt* _tmp5_;
	PhotoRow* row = NULL;
	PhotoRow* _tmp6_;
	PhotoRow* _tmp7_;
	PhotoID _tmp8_;
	PhotoRow* _tmp9_;
	BackingPhotoRow* _tmp10_;
	sqlite3_stmt* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	PhotoRow* _tmp14_;
	BackingPhotoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	PhotoRow* _tmp18_;
	BackingPhotoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	PhotoRow* _tmp21_;
	BackingPhotoRow* _tmp22_;
	sqlite3_stmt* _tmp23_;
	GDateTime* _tmp24_;
	sqlite3_stmt* _tmp25_;
	PhotoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	PhotoRow* _tmp32_;
	BackingPhotoRow* _tmp33_;
	sqlite3_stmt* _tmp34_;
	PhotoRow* _tmp35_;
	sqlite3_stmt* _tmp36_;
	PhotoRow* _tmp37_;
	sqlite3_stmt* _tmp38_;
	PhotoRow* _tmp39_;
	sqlite3_stmt* _tmp40_;
	const gchar* _tmp41_;
	GeeHashMap* _tmp42_;
	PhotoRow* _tmp43_;
	sqlite3_stmt* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	PhotoRow* _tmp47_;
	sqlite3_stmt* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	PhotoRow* _tmp51_;
	sqlite3_stmt* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	PhotoRow* _tmp55_;
	sqlite3_stmt* _tmp56_;
	PhotoRow* _tmp57_;
	sqlite3_stmt* _tmp58_;
	PhotoRow* _tmp59_;
	sqlite3_stmt* _tmp60_;
	PhotoRow* _tmp61_;
	BackingPhotoRow* _tmp62_;
	sqlite3_stmt* _tmp63_;
	PhotoRow* _tmp64_;
	sqlite3_stmt* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	PhotoRow* _tmp68_;
	sqlite3_stmt* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	PhotoRow* _tmp72_;
	sqlite3_stmt* _tmp73_;
	PhotoRow* _tmp74_;
	sqlite3_stmt* _tmp75_;
	PhotoRow* _tmp76_;
	sqlite3_stmt* _tmp77_;
	RawDeveloper _tmp78_ = 0;
	sqlite3_stmt* _tmp79_;
	const gchar* _tmp80_;
	PhotoRow* _tmp83_;
	PhotoRow* _tmp84_;
	BackingPhotoID* _tmp85_;
	gint _tmp85__length1;
	sqlite3_stmt* _tmp86_;
	BackingPhotoID _tmp87_ = {0};
	PhotoRow* _tmp88_;
	BackingPhotoID* _tmp89_;
	gint _tmp89__length1;
	sqlite3_stmt* _tmp90_;
	BackingPhotoID _tmp91_ = {0};
	PhotoRow* _tmp92_;
	BackingPhotoID* _tmp93_;
	gint _tmp93__length1;
	sqlite3_stmt* _tmp94_;
	BackingPhotoID _tmp95_ = {0};
	PhotoRow* _tmp96_;
	sqlite3_stmt* _tmp97_;
	PhotoRow* _tmp98_;
	sqlite3_stmt* _tmp99_;
	PhotoRow* _tmp100_;
	sqlite3_stmt* _tmp101_;
	PhotoRow* _tmp102_;
	sqlite3_stmt* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	PhotoRow* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, filesize, timestamp, exposure_time, or" \
"ientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " "time_reimported, editable_id, metadata_dirty, developer, develop_shotw" \
"ell_id, " "develop_camera_id, develop_embedded_id, has_gps, gps_lat, gps_lon, com" \
"ment " "FROM PhotoTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *photo_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	if (sqlite3_step (_tmp5_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp6_ = photo_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *photo_id;
	_tmp7_->photo_id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = _tmp9_->master;
	_tmp11_ = stmt;
	_tmp12_ = (const gchar*) sqlite3_column_text (_tmp11_, 0);
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (_tmp10_->filepath);
	_tmp10_->filepath = _tmp13_;
	_tmp14_ = row;
	_tmp15_ = _tmp14_->master;
	_tmp16_ = stmt;
	_tmp17_ = stmt;
	dimensions_init (&_tmp15_->dim, sqlite3_column_int (_tmp16_, 1), sqlite3_column_int (_tmp17_, 2));
	_tmp18_ = row;
	_tmp19_ = _tmp18_->master;
	_tmp20_ = stmt;
	_tmp19_->filesize = sqlite3_column_int64 (_tmp20_, 3);
	_tmp21_ = row;
	_tmp22_ = _tmp21_->master;
	_tmp23_ = stmt;
	_tmp24_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp23_, 4));
	_g_date_time_unref0 (_tmp22_->timestamp);
	_tmp22_->timestamp = _tmp24_;
	_tmp25_ = stmt;
	if (sqlite3_column_type (_tmp25_, 5) == SQLITE_NULL) {
		PhotoRow* _tmp26_;
		_tmp26_ = row;
		_g_date_time_unref0 (_tmp26_->exposure_time);
		_tmp26_->exposure_time = NULL;
	} else {
		PhotoRow* _tmp27_;
		sqlite3_stmt* _tmp28_;
		GDateTime* _tmp29_;
		_tmp27_ = row;
		_tmp28_ = stmt;
		_tmp29_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp28_, 5));
		_g_date_time_unref0 (_tmp27_->exposure_time);
		_tmp27_->exposure_time = _tmp29_;
	}
	_tmp30_ = row;
	_tmp31_ = stmt;
	_tmp30_->orientation = (Orientation) sqlite3_column_int (_tmp31_, 6);
	_tmp32_ = row;
	_tmp33_ = _tmp32_->master;
	_tmp34_ = stmt;
	_tmp33_->original_orientation = (Orientation) sqlite3_column_int (_tmp34_, 7);
	_tmp35_ = row;
	_tmp36_ = stmt;
	_tmp35_->import_id.id = sqlite3_column_int64 (_tmp36_, 8);
	_tmp37_ = row;
	_tmp38_ = stmt;
	_tmp37_->event_id.id = sqlite3_column_int64 (_tmp38_, 9);
	_tmp39_ = row;
	_tmp40_ = stmt;
	_tmp41_ = (const gchar*) sqlite3_column_text (_tmp40_, 10);
	_tmp42_ = photo_table_marshall_all_transformations (_tmp41_);
	_g_object_unref0 (_tmp39_->transformations);
	_tmp39_->transformations = _tmp42_;
	_tmp43_ = row;
	_tmp44_ = stmt;
	_tmp45_ = (const gchar*) sqlite3_column_text (_tmp44_, 11);
	_tmp46_ = g_strdup (_tmp45_);
	_g_free0 (_tmp43_->md5);
	_tmp43_->md5 = _tmp46_;
	_tmp47_ = row;
	_tmp48_ = stmt;
	_tmp49_ = (const gchar*) sqlite3_column_text (_tmp48_, 12);
	_tmp50_ = g_strdup (_tmp49_);
	_g_free0 (_tmp47_->thumbnail_md5);
	_tmp47_->thumbnail_md5 = _tmp50_;
	_tmp51_ = row;
	_tmp52_ = stmt;
	_tmp53_ = (const gchar*) sqlite3_column_text (_tmp52_, 13);
	_tmp54_ = g_strdup (_tmp53_);
	_g_free0 (_tmp51_->exif_md5);
	_tmp51_->exif_md5 = _tmp54_;
	_tmp55_ = row;
	_tmp56_ = stmt;
	_tmp55_->time_created = sqlite3_column_int64 (_tmp56_, 14);
	_tmp57_ = row;
	_tmp58_ = stmt;
	_tmp57_->flags = (guint64) sqlite3_column_int64 (_tmp58_, 15);
	_tmp59_ = row;
	_tmp60_ = stmt;
	_tmp59_->rating = rating_unserialize (sqlite3_column_int (_tmp60_, 16));
	_tmp61_ = row;
	_tmp62_ = _tmp61_->master;
	_tmp63_ = stmt;
	_tmp62_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp63_, 17));
	_tmp64_ = row;
	_tmp65_ = stmt;
	_tmp66_ = (const gchar*) sqlite3_column_text (_tmp65_, 18);
	_tmp67_ = g_strdup (_tmp66_);
	_g_free0 (_tmp64_->title);
	_tmp64_->title = _tmp67_;
	_tmp68_ = row;
	_tmp69_ = stmt;
	_tmp70_ = (const gchar*) sqlite3_column_text (_tmp69_, 19);
	_tmp71_ = g_strdup (_tmp70_);
	_g_free0 (_tmp68_->backlinks);
	_tmp68_->backlinks = _tmp71_;
	_tmp72_ = row;
	_tmp73_ = stmt;
	_tmp72_->time_reimported = sqlite3_column_int64 (_tmp73_, 20);
	_tmp74_ = row;
	_tmp75_ = stmt;
	backing_photo_id_init (&_tmp74_->editable_id, sqlite3_column_int64 (_tmp75_, 21));
	_tmp76_ = row;
	_tmp77_ = stmt;
	_tmp76_->metadata_dirty = sqlite3_column_int (_tmp77_, 22) != 0;
	_tmp79_ = stmt;
	_tmp80_ = (const gchar*) sqlite3_column_text (_tmp79_, 23);
	if (_tmp80_ != NULL) {
		sqlite3_stmt* _tmp81_;
		const gchar* _tmp82_;
		_tmp81_ = stmt;
		_tmp82_ = (const gchar*) sqlite3_column_text (_tmp81_, 23);
		_tmp78_ = raw_developer_from_string (_tmp82_);
	} else {
		_tmp78_ = RAW_DEVELOPER_CAMERA;
	}
	_tmp83_ = row;
	_tmp83_->developer = _tmp78_;
	_tmp84_ = row;
	_tmp85_ = _tmp84_->development_ids;
	_tmp85__length1 = _tmp84_->development_ids_length1;
	_tmp86_ = stmt;
	backing_photo_id_init (&_tmp87_, sqlite3_column_int64 (_tmp86_, 24));
	_tmp85_[RAW_DEVELOPER_SHOTWELL] = _tmp87_;
	_tmp88_ = row;
	_tmp89_ = _tmp88_->development_ids;
	_tmp89__length1 = _tmp88_->development_ids_length1;
	_tmp90_ = stmt;
	backing_photo_id_init (&_tmp91_, sqlite3_column_int64 (_tmp90_, 25));
	_tmp89_[RAW_DEVELOPER_CAMERA] = _tmp91_;
	_tmp92_ = row;
	_tmp93_ = _tmp92_->development_ids;
	_tmp93__length1 = _tmp92_->development_ids_length1;
	_tmp94_ = stmt;
	backing_photo_id_init (&_tmp95_, sqlite3_column_int64 (_tmp94_, 26));
	_tmp93_[RAW_DEVELOPER_EMBEDDED] = _tmp95_;
	_tmp96_ = row;
	_tmp97_ = stmt;
	_tmp96_->gps_coords.has_gps = sqlite3_column_int (_tmp97_, 27);
	_tmp98_ = row;
	_tmp99_ = stmt;
	_tmp98_->gps_coords.latitude = sqlite3_column_double (_tmp99_, 28);
	_tmp100_ = row;
	_tmp101_ = stmt;
	_tmp100_->gps_coords.longitude = sqlite3_column_double (_tmp101_, 29);
	_tmp102_ = row;
	_tmp103_ = stmt;
	_tmp104_ = (const gchar*) sqlite3_column_text (_tmp103_, 30);
	_tmp105_ = g_strdup (_tmp104_);
	_g_free0 (_tmp102_->comment);
	_tmp102_->comment = _tmp105_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
photo_table_get_all (PhotoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, filesize, timestamp, exposure_time" \
", orientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " \
"time_reimported, " "editable_id, metadata_dirty, developer, develop_shotwell_id, develop_c" \
"amera_id, " "develop_embedded_id, has_gps, gps_lat, gps_lon, comment FROM PhotoTabl" \
"e", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_PHOTO_ROW, (GBoxedCopyFunc) photo_row_ref, (GDestroyNotify) photo_row_unref, NULL, NULL, NULL);
	all = _tmp3_;
	while (TRUE) {
		sqlite3_stmt* _tmp4_;
		PhotoRow* row = NULL;
		PhotoRow* _tmp5_;
		PhotoRow* _tmp6_;
		sqlite3_stmt* _tmp7_;
		PhotoRow* _tmp8_;
		BackingPhotoRow* _tmp9_;
		sqlite3_stmt* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		PhotoRow* _tmp13_;
		BackingPhotoRow* _tmp14_;
		sqlite3_stmt* _tmp15_;
		sqlite3_stmt* _tmp16_;
		PhotoRow* _tmp17_;
		BackingPhotoRow* _tmp18_;
		sqlite3_stmt* _tmp19_;
		PhotoRow* _tmp20_;
		BackingPhotoRow* _tmp21_;
		sqlite3_stmt* _tmp22_;
		GDateTime* _tmp23_;
		sqlite3_stmt* _tmp24_;
		PhotoRow* _tmp29_;
		sqlite3_stmt* _tmp30_;
		PhotoRow* _tmp31_;
		BackingPhotoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		PhotoRow* _tmp34_;
		sqlite3_stmt* _tmp35_;
		PhotoRow* _tmp36_;
		sqlite3_stmt* _tmp37_;
		PhotoRow* _tmp38_;
		sqlite3_stmt* _tmp39_;
		const gchar* _tmp40_;
		GeeHashMap* _tmp41_;
		PhotoRow* _tmp42_;
		sqlite3_stmt* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		PhotoRow* _tmp46_;
		sqlite3_stmt* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		PhotoRow* _tmp50_;
		sqlite3_stmt* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		PhotoRow* _tmp54_;
		sqlite3_stmt* _tmp55_;
		PhotoRow* _tmp56_;
		sqlite3_stmt* _tmp57_;
		PhotoRow* _tmp58_;
		sqlite3_stmt* _tmp59_;
		PhotoRow* _tmp60_;
		BackingPhotoRow* _tmp61_;
		sqlite3_stmt* _tmp62_;
		PhotoRow* _tmp63_;
		sqlite3_stmt* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		PhotoRow* _tmp67_;
		sqlite3_stmt* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		PhotoRow* _tmp71_;
		sqlite3_stmt* _tmp72_;
		PhotoRow* _tmp73_;
		sqlite3_stmt* _tmp74_;
		PhotoRow* _tmp75_;
		sqlite3_stmt* _tmp76_;
		RawDeveloper _tmp77_ = 0;
		sqlite3_stmt* _tmp78_;
		const gchar* _tmp79_;
		PhotoRow* _tmp82_;
		PhotoRow* _tmp83_;
		BackingPhotoID* _tmp84_;
		gint _tmp84__length1;
		sqlite3_stmt* _tmp85_;
		BackingPhotoID _tmp86_ = {0};
		PhotoRow* _tmp87_;
		BackingPhotoID* _tmp88_;
		gint _tmp88__length1;
		sqlite3_stmt* _tmp89_;
		BackingPhotoID _tmp90_ = {0};
		PhotoRow* _tmp91_;
		BackingPhotoID* _tmp92_;
		gint _tmp92__length1;
		sqlite3_stmt* _tmp93_;
		BackingPhotoID _tmp94_ = {0};
		PhotoRow* _tmp95_;
		sqlite3_stmt* _tmp96_;
		PhotoRow* _tmp97_;
		sqlite3_stmt* _tmp98_;
		PhotoRow* _tmp99_;
		sqlite3_stmt* _tmp100_;
		PhotoRow* _tmp101_;
		sqlite3_stmt* _tmp102_;
		const gchar* _tmp103_;
		gchar* _tmp104_;
		PhotoRow* _tmp105_;
		GeeArrayList* _tmp106_;
		PhotoRow* _tmp107_;
		_tmp4_ = stmt;
		res = sqlite3_step (_tmp4_);
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp5_ = photo_row_new ();
		row = _tmp5_;
		_tmp6_ = row;
		_tmp7_ = stmt;
		_tmp6_->photo_id.id = sqlite3_column_int64 (_tmp7_, 0);
		_tmp8_ = row;
		_tmp9_ = _tmp8_->master;
		_tmp10_ = stmt;
		_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp9_->filepath);
		_tmp9_->filepath = _tmp12_;
		_tmp13_ = row;
		_tmp14_ = _tmp13_->master;
		_tmp15_ = stmt;
		_tmp16_ = stmt;
		dimensions_init (&_tmp14_->dim, sqlite3_column_int (_tmp15_, 2), sqlite3_column_int (_tmp16_, 3));
		_tmp17_ = row;
		_tmp18_ = _tmp17_->master;
		_tmp19_ = stmt;
		_tmp18_->filesize = sqlite3_column_int64 (_tmp19_, 4);
		_tmp20_ = row;
		_tmp21_ = _tmp20_->master;
		_tmp22_ = stmt;
		_tmp23_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp22_, 5));
		_g_date_time_unref0 (_tmp21_->timestamp);
		_tmp21_->timestamp = _tmp23_;
		_tmp24_ = stmt;
		if (sqlite3_column_type (_tmp24_, 6) == SQLITE_NULL) {
			PhotoRow* _tmp25_;
			_tmp25_ = row;
			_g_date_time_unref0 (_tmp25_->exposure_time);
			_tmp25_->exposure_time = NULL;
		} else {
			PhotoRow* _tmp26_;
			sqlite3_stmt* _tmp27_;
			GDateTime* _tmp28_;
			_tmp26_ = row;
			_tmp27_ = stmt;
			_tmp28_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp27_, 6));
			_g_date_time_unref0 (_tmp26_->exposure_time);
			_tmp26_->exposure_time = _tmp28_;
		}
		_tmp29_ = row;
		_tmp30_ = stmt;
		_tmp29_->orientation = (Orientation) sqlite3_column_int (_tmp30_, 7);
		_tmp31_ = row;
		_tmp32_ = _tmp31_->master;
		_tmp33_ = stmt;
		_tmp32_->original_orientation = (Orientation) sqlite3_column_int (_tmp33_, 8);
		_tmp34_ = row;
		_tmp35_ = stmt;
		_tmp34_->import_id.id = sqlite3_column_int64 (_tmp35_, 9);
		_tmp36_ = row;
		_tmp37_ = stmt;
		_tmp36_->event_id.id = sqlite3_column_int64 (_tmp37_, 10);
		_tmp38_ = row;
		_tmp39_ = stmt;
		_tmp40_ = (const gchar*) sqlite3_column_text (_tmp39_, 11);
		_tmp41_ = photo_table_marshall_all_transformations (_tmp40_);
		_g_object_unref0 (_tmp38_->transformations);
		_tmp38_->transformations = _tmp41_;
		_tmp42_ = row;
		_tmp43_ = stmt;
		_tmp44_ = (const gchar*) sqlite3_column_text (_tmp43_, 12);
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (_tmp42_->md5);
		_tmp42_->md5 = _tmp45_;
		_tmp46_ = row;
		_tmp47_ = stmt;
		_tmp48_ = (const gchar*) sqlite3_column_text (_tmp47_, 13);
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_tmp46_->thumbnail_md5);
		_tmp46_->thumbnail_md5 = _tmp49_;
		_tmp50_ = row;
		_tmp51_ = stmt;
		_tmp52_ = (const gchar*) sqlite3_column_text (_tmp51_, 14);
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (_tmp50_->exif_md5);
		_tmp50_->exif_md5 = _tmp53_;
		_tmp54_ = row;
		_tmp55_ = stmt;
		_tmp54_->time_created = sqlite3_column_int64 (_tmp55_, 15);
		_tmp56_ = row;
		_tmp57_ = stmt;
		_tmp56_->flags = (guint64) sqlite3_column_int64 (_tmp57_, 16);
		_tmp58_ = row;
		_tmp59_ = stmt;
		_tmp58_->rating = rating_unserialize (sqlite3_column_int (_tmp59_, 17));
		_tmp60_ = row;
		_tmp61_ = _tmp60_->master;
		_tmp62_ = stmt;
		_tmp61_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp62_, 18));
		_tmp63_ = row;
		_tmp64_ = stmt;
		_tmp65_ = (const gchar*) sqlite3_column_text (_tmp64_, 19);
		_tmp66_ = g_strdup (_tmp65_);
		_g_free0 (_tmp63_->title);
		_tmp63_->title = _tmp66_;
		_tmp67_ = row;
		_tmp68_ = stmt;
		_tmp69_ = (const gchar*) sqlite3_column_text (_tmp68_, 20);
		_tmp70_ = g_strdup (_tmp69_);
		_g_free0 (_tmp67_->backlinks);
		_tmp67_->backlinks = _tmp70_;
		_tmp71_ = row;
		_tmp72_ = stmt;
		_tmp71_->time_reimported = sqlite3_column_int64 (_tmp72_, 21);
		_tmp73_ = row;
		_tmp74_ = stmt;
		backing_photo_id_init (&_tmp73_->editable_id, sqlite3_column_int64 (_tmp74_, 22));
		_tmp75_ = row;
		_tmp76_ = stmt;
		_tmp75_->metadata_dirty = sqlite3_column_int (_tmp76_, 23) != 0;
		_tmp78_ = stmt;
		_tmp79_ = (const gchar*) sqlite3_column_text (_tmp78_, 24);
		if (_tmp79_ != NULL) {
			sqlite3_stmt* _tmp80_;
			const gchar* _tmp81_;
			_tmp80_ = stmt;
			_tmp81_ = (const gchar*) sqlite3_column_text (_tmp80_, 24);
			_tmp77_ = raw_developer_from_string (_tmp81_);
		} else {
			_tmp77_ = RAW_DEVELOPER_CAMERA;
		}
		_tmp82_ = row;
		_tmp82_->developer = _tmp77_;
		_tmp83_ = row;
		_tmp84_ = _tmp83_->development_ids;
		_tmp84__length1 = _tmp83_->development_ids_length1;
		_tmp85_ = stmt;
		backing_photo_id_init (&_tmp86_, sqlite3_column_int64 (_tmp85_, 25));
		_tmp84_[RAW_DEVELOPER_SHOTWELL] = _tmp86_;
		_tmp87_ = row;
		_tmp88_ = _tmp87_->development_ids;
		_tmp88__length1 = _tmp87_->development_ids_length1;
		_tmp89_ = stmt;
		backing_photo_id_init (&_tmp90_, sqlite3_column_int64 (_tmp89_, 26));
		_tmp88_[RAW_DEVELOPER_CAMERA] = _tmp90_;
		_tmp91_ = row;
		_tmp92_ = _tmp91_->development_ids;
		_tmp92__length1 = _tmp91_->development_ids_length1;
		_tmp93_ = stmt;
		backing_photo_id_init (&_tmp94_, sqlite3_column_int64 (_tmp93_, 27));
		_tmp92_[RAW_DEVELOPER_EMBEDDED] = _tmp94_;
		_tmp95_ = row;
		_tmp96_ = stmt;
		_tmp95_->gps_coords.has_gps = sqlite3_column_int (_tmp96_, 28);
		_tmp97_ = row;
		_tmp98_ = stmt;
		_tmp97_->gps_coords.latitude = sqlite3_column_double (_tmp98_, 29);
		_tmp99_ = row;
		_tmp100_ = stmt;
		_tmp99_->gps_coords.longitude = sqlite3_column_double (_tmp100_, 30);
		_tmp101_ = row;
		_tmp102_ = stmt;
		_tmp103_ = (const gchar*) sqlite3_column_text (_tmp102_, 31);
		_tmp104_ = g_strdup (_tmp103_);
		_g_free0 (_tmp101_->comment);
		_tmp101_->comment = _tmp104_;
		_tmp105_ = row;
		photo_table_validate_orientation (self, _tmp105_);
		_tmp106_ = all;
		_tmp107_ = row;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp107_);
		_photo_row_unref0 (row);
	}
	result = all;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_duplicate (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_filename,
                       BackingPhotoID* editable_id,
                       BackingPhotoID* develop_shotwell,
                       BackingPhotoID* develop_camera_id,
                       BackingPhotoID* develop_embedded_id,
                       PhotoID* result)
{
	PhotoRow* original = NULL;
	PhotoID _tmp0_;
	PhotoRow* _tmp1_;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	sqlite3_stmt* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	PhotoRow* _tmp9_;
	BackingPhotoRow* _tmp10_;
	Dimensions _tmp11_;
	sqlite3_stmt* _tmp12_;
	PhotoRow* _tmp13_;
	BackingPhotoRow* _tmp14_;
	Dimensions _tmp15_;
	sqlite3_stmt* _tmp16_;
	PhotoRow* _tmp17_;
	BackingPhotoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	PhotoRow* _tmp20_;
	BackingPhotoRow* _tmp21_;
	GDateTime* _tmp22_;
	PhotoRow* _tmp23_;
	GDateTime* _tmp24_;
	sqlite3_stmt* _tmp29_;
	PhotoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	PhotoRow* _tmp32_;
	BackingPhotoRow* _tmp33_;
	sqlite3_stmt* _tmp34_;
	PhotoRow* _tmp35_;
	ImportID _tmp36_;
	sqlite3_stmt* _tmp37_;
	PhotoRow* _tmp38_;
	EventID _tmp39_;
	sqlite3_stmt* _tmp40_;
	PhotoRow* _tmp41_;
	GeeHashMap* _tmp42_;
	gchar* _tmp43_;
	GDestroyNotify _tmp44_;
	sqlite3_stmt* _tmp45_;
	PhotoRow* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	GDestroyNotify _tmp49_;
	sqlite3_stmt* _tmp50_;
	PhotoRow* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	GDestroyNotify _tmp54_;
	sqlite3_stmt* _tmp55_;
	PhotoRow* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	GDestroyNotify _tmp59_;
	sqlite3_stmt* _tmp60_;
	sqlite3_stmt* _tmp61_;
	PhotoRow* _tmp62_;
	sqlite3_stmt* _tmp63_;
	PhotoRow* _tmp64_;
	sqlite3_stmt* _tmp65_;
	PhotoRow* _tmp66_;
	BackingPhotoRow* _tmp67_;
	sqlite3_stmt* _tmp68_;
	PhotoRow* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	GDestroyNotify _tmp72_;
	sqlite3_stmt* _tmp73_;
	PhotoRow* _tmp74_;
	GpsCoords _tmp75_;
	sqlite3_stmt* _tmp76_;
	PhotoRow* _tmp77_;
	GpsCoords _tmp78_;
	sqlite3_stmt* _tmp79_;
	PhotoRow* _tmp80_;
	GpsCoords _tmp81_;
	sqlite3_stmt* _tmp82_;
	BackingPhotoID _tmp83_;
	sqlite3_stmt* _tmp84_;
	PhotoRow* _tmp85_;
	gchar* _tmp86_;
	GDestroyNotify _tmp87_;
	sqlite3_stmt* _tmp88_;
	BackingPhotoID _tmp89_;
	sqlite3_stmt* _tmp90_;
	BackingPhotoID _tmp91_;
	sqlite3_stmt* _tmp92_;
	BackingPhotoID _tmp93_;
	sqlite3_stmt* _tmp94_;
	PhotoRow* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	GDestroyNotify _tmp98_;
	sqlite3_stmt* _tmp99_;
	sqlite3* _tmp101_;
	PhotoID _tmp102_ = {0};
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (new_filename != NULL);
	g_return_if_fail (editable_id != NULL);
	g_return_if_fail (develop_shotwell != NULL);
	g_return_if_fail (develop_camera_id != NULL);
	g_return_if_fail (develop_embedded_id != NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_row (self, &_tmp0_);
	original = _tmp1_;
	_tmp2_ = database_table_db;
	_tmp4_ = sqlite3_prepare_v2 (_tmp2_, "INSERT INTO PhotoTable (filename, width, height, filesize, " "timestamp, exposure_time, orientation, original_orientation, import_id" \
", event_id, " "transformations, md5, thumbnail_md5, exif_md5, time_created, flags, ra" \
"ting, " "file_format, title, has_gps, gps_lat, gps_lon, editable_id, developer," \
" " "develop_shotwell_id, develop_camera_id, develop_embedded_id, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," \
" ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	res = _tmp4_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = g_strdup (new_filename);
	_tmp7_ = g_free;
	res = sqlite3_bind_text (_tmp5_, 1, _tmp6_, -1, _tmp7_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = original;
	_tmp10_ = _tmp9_->master;
	_tmp11_ = _tmp10_->dim;
	res = sqlite3_bind_int (_tmp8_, 2, _tmp11_.width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	_tmp13_ = original;
	_tmp14_ = _tmp13_->master;
	_tmp15_ = _tmp14_->dim;
	res = sqlite3_bind_int (_tmp12_, 3, _tmp15_.height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp16_ = stmt;
	_tmp17_ = original;
	_tmp18_ = _tmp17_->master;
	res = sqlite3_bind_int64 (_tmp16_, 4, _tmp18_->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp19_ = stmt;
	_tmp20_ = original;
	_tmp21_ = _tmp20_->master;
	_tmp22_ = _tmp21_->timestamp;
	res = sqlite3_bind_int64 (_tmp19_, 5, g_date_time_to_unix (_tmp22_));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp23_ = original;
	_tmp24_ = _tmp23_->exposure_time;
	if (_tmp24_ == NULL) {
		sqlite3_stmt* _tmp25_;
		_tmp25_ = stmt;
		res = sqlite3_bind_null (_tmp25_, 6);
	} else {
		sqlite3_stmt* _tmp26_;
		PhotoRow* _tmp27_;
		GDateTime* _tmp28_;
		_tmp26_ = stmt;
		_tmp27_ = original;
		_tmp28_ = _tmp27_->exposure_time;
		res = sqlite3_bind_int64 (_tmp26_, 6, g_date_time_to_unix (_tmp28_));
	}
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp29_ = stmt;
	_tmp30_ = original;
	res = sqlite3_bind_int (_tmp29_, 7, (gint) _tmp30_->orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp31_ = stmt;
	_tmp32_ = original;
	_tmp33_ = _tmp32_->master;
	res = sqlite3_bind_int (_tmp31_, 8, (gint) _tmp33_->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp34_ = stmt;
	_tmp35_ = original;
	_tmp36_ = _tmp35_->import_id;
	res = sqlite3_bind_int64 (_tmp34_, 9, _tmp36_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp37_ = stmt;
	_tmp38_ = original;
	_tmp39_ = _tmp38_->event_id;
	res = sqlite3_bind_int64 (_tmp37_, 10, _tmp39_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp40_ = stmt;
	_tmp41_ = original;
	_tmp42_ = _tmp41_->transformations;
	_tmp43_ = photo_table_unmarshall_all_transformations (_tmp42_);
	_tmp44_ = g_free;
	res = sqlite3_bind_text (_tmp40_, 11, _tmp43_, -1, _tmp44_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp45_ = stmt;
	_tmp46_ = original;
	_tmp47_ = _tmp46_->md5;
	_tmp48_ = g_strdup (_tmp47_);
	_tmp49_ = g_free;
	res = sqlite3_bind_text (_tmp45_, 12, _tmp48_, -1, _tmp49_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp50_ = stmt;
	_tmp51_ = original;
	_tmp52_ = _tmp51_->thumbnail_md5;
	_tmp53_ = g_strdup (_tmp52_);
	_tmp54_ = g_free;
	res = sqlite3_bind_text (_tmp50_, 13, _tmp53_, -1, _tmp54_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp55_ = stmt;
	_tmp56_ = original;
	_tmp57_ = _tmp56_->exif_md5;
	_tmp58_ = g_strdup (_tmp57_);
	_tmp59_ = g_free;
	res = sqlite3_bind_text (_tmp55_, 14, _tmp58_, -1, _tmp59_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp60_ = stmt;
	res = sqlite3_bind_int64 (_tmp60_, 15, now_sec ());
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp61_ = stmt;
	_tmp62_ = original;
	res = sqlite3_bind_int64 (_tmp61_, 16, (gint64) _tmp62_->flags);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp63_ = stmt;
	_tmp64_ = original;
	res = sqlite3_bind_int64 (_tmp63_, 17, (gint64) rating_serialize (_tmp64_->rating));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp65_ = stmt;
	_tmp66_ = original;
	_tmp67_ = _tmp66_->master;
	res = sqlite3_bind_int (_tmp65_, 18, photo_file_format_serialize (_tmp67_->file_format));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp68_ = stmt;
	_tmp69_ = original;
	_tmp70_ = _tmp69_->title;
	_tmp71_ = g_strdup (_tmp70_);
	_tmp72_ = g_free;
	res = sqlite3_bind_text (_tmp68_, 19, _tmp71_, -1, _tmp72_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp73_ = stmt;
	_tmp74_ = original;
	_tmp75_ = _tmp74_->gps_coords;
	res = sqlite3_bind_int (_tmp73_, 20, _tmp75_.has_gps);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp76_ = stmt;
	_tmp77_ = original;
	_tmp78_ = _tmp77_->gps_coords;
	res = sqlite3_bind_double (_tmp76_, 21, _tmp78_.latitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp79_ = stmt;
	_tmp80_ = original;
	_tmp81_ = _tmp80_->gps_coords;
	res = sqlite3_bind_double (_tmp79_, 22, _tmp81_.longitude);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp82_ = stmt;
	_tmp83_ = *editable_id;
	res = sqlite3_bind_int64 (_tmp82_, 23, _tmp83_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp84_ = stmt;
	_tmp85_ = original;
	_tmp86_ = raw_developer_to_string (_tmp85_->developer);
	_tmp87_ = g_free;
	res = sqlite3_bind_text (_tmp84_, 24, _tmp86_, -1, _tmp87_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp88_ = stmt;
	_tmp89_ = *develop_shotwell;
	res = sqlite3_bind_int64 (_tmp88_, 25, _tmp89_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp90_ = stmt;
	_tmp91_ = *develop_camera_id;
	res = sqlite3_bind_int64 (_tmp90_, 26, _tmp91_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp92_ = stmt;
	_tmp93_ = *develop_embedded_id;
	res = sqlite3_bind_int64 (_tmp92_, 27, _tmp93_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp94_ = stmt;
	_tmp95_ = original;
	_tmp96_ = _tmp95_->comment;
	_tmp97_ = g_strdup (_tmp96_);
	_tmp98_ = g_free;
	res = sqlite3_bind_text (_tmp94_, 28, _tmp97_, -1, _tmp98_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp99_ = stmt;
	res = sqlite3_step (_tmp99_);
	if (res != SQLITE_DONE) {
		PhotoID _tmp100_ = {0};
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("duplicate", res);
		}
		photo_id_init (&_tmp100_, PHOTO_ID_INVALID);
		*result = _tmp100_;
		_sqlite3_finalize0 (stmt);
		_photo_row_unref0 (original);
		return;
	}
	_tmp101_ = database_table_db;
	photo_id_init (&_tmp102_, sqlite3_last_insert_rowid (_tmp101_));
	*result = _tmp102_;
	_sqlite3_finalize0 (stmt);
	_photo_row_unref0 (original);
	return;
}

gboolean
photo_table_set_title (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_title)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (new_title != NULL) {
		_tmp0_ = new_title;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "title", _tmp0_);
	return result;
}

void
photo_table_set_gps_coords (PhotoTable* self,
                            PhotoID* photo_id,
                            GpsCoords* new_gps_coords,
                            GError** error)
{
	PhotoID _tmp0_;
	GpsCoords _tmp1_;
	GpsCoords _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (new_gps_coords != NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = *new_gps_coords;
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "has_gps", _tmp1_.has_gps, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = *new_gps_coords;
	if (_tmp2_.has_gps > 0) {
		PhotoID _tmp3_;
		GpsCoords _tmp4_;
		PhotoID _tmp5_;
		GpsCoords _tmp6_;
		_tmp3_ = *photo_id;
		_tmp4_ = *new_gps_coords;
		database_table_update_double_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp3_.id, "gps_lat", _tmp4_.latitude, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp5_ = *photo_id;
		_tmp6_ = *new_gps_coords;
		database_table_update_double_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp5_.id, "gps_lon", _tmp6_.longitude, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

gboolean
photo_table_set_comment (PhotoTable* self,
                         PhotoID* photo_id,
                         const gchar* new_comment)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "comment", _tmp0_);
	return result;
}

void
photo_table_set_filepath (PhotoTable* self,
                          PhotoID* photo_id,
                          const gchar* filepath,
                          GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *photo_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "filename", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_update_timestamp (PhotoTable* self,
                              PhotoID* photo_id,
                              GDateTime* timestamp,
                              GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (timestamp != NULL);
	_tmp0_ = *photo_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "timestamp", g_date_time_to_unix (timestamp), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_table_set_exposure_time (PhotoTable* self,
                               PhotoID* photo_id,
                               GDateTime* time)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (time != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "exposure_time", g_date_time_to_unix (time));
	return result;
}

void
photo_table_set_import_id (PhotoTable* self,
                           PhotoID* photo_id,
                           ImportID* import_id,
                           GError** error)
{
	PhotoID _tmp0_;
	ImportID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (import_id != NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = *import_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "import_id", _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_table_remove_by_file (PhotoTable* self,
                            GFile* file)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM PhotoTable WHERE filename=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = g_file_get_path (file);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_warning ("remove", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_remove (PhotoTable* self,
                    PhotoID* photo_id,
                    GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = *photo_id;
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeArrayList*
photo_table_get_photos (PhotoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeArrayList* photo_ids = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
	photo_ids = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			GeeArrayList* _tmp6_;
			sqlite3_stmt* _tmp7_;
			PhotoID _tmp8_ = {0};
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_photos", res);
					break;
				}
			}
			_tmp6_ = photo_ids;
			_tmp7_ = stmt;
			photo_id_init (&_tmp8_, sqlite3_column_int64 (_tmp7_, 0));
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp8_);
		}
	}
	result = photo_ids;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_set_orientation (PhotoTable* self,
                             PhotoID* photo_id,
                             Orientation orientation)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "orientation", (gint) orientation);
	return result;
}

gboolean
photo_table_replace_flags (PhotoTable* self,
                           PhotoID* photo_id,
                           guint64 flags)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "flags", (gint64) flags);
	return result;
}

gboolean
photo_table_set_rating (PhotoTable* self,
                        PhotoID* photo_id,
                        Rating rating)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "rating", rating_serialize (rating));
	return result;
}

gint
photo_table_get_event_photo_count (PhotoTable* self,
                                   EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventID _tmp4_;
	gint count = 0;
	gint result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), 0);
	g_return_val_if_fail (event_id != NULL, 0);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *event_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	count = 0;
	{
		gboolean _tmp5_ = FALSE;
		_tmp5_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp6_;
			gint _tmp7_;
			if (!_tmp5_) {
			}
			_tmp5_ = FALSE;
			_tmp6_ = stmt;
			res = sqlite3_step (_tmp6_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_photo_count", res);
					break;
				}
			}
			_tmp7_ = count;
			count = _tmp7_ + 1;
		}
	}
	result = count;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
photo_table_get_event_source_ids (PhotoTable* self,
                                  EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventID _tmp4_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *event_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp7_;
			GeeArrayList* _tmp8_;
			sqlite3_stmt* _tmp9_;
			PhotoID _tmp10_ = {0};
			gchar* _tmp11_;
			gchar* _tmp12_;
			if (!_tmp6_) {
			}
			_tmp6_ = FALSE;
			_tmp7_ = stmt;
			res = sqlite3_step (_tmp7_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_source_ids", res);
					break;
				}
			}
			_tmp8_ = _result_;
			_tmp9_ = stmt;
			photo_id_init (&_tmp10_, sqlite3_column_int64 (_tmp9_, 0));
			_tmp11_ = photo_id_upgrade_photo_id_to_source_id (&_tmp10_);
			_tmp12_ = _tmp11_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	result = _result_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_event_has_photos (PhotoTable* self,
                              EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventID _tmp4_;
	sqlite3_stmt* _tmp5_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ? LIMIT 1", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *event_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_fatal ("event_has_photos", res);
			result = FALSE;
			_sqlite3_finalize0 (stmt);
			return result;
		}
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_drop_event (PhotoTable* self,
                        EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int64 (_tmp3_, 1, EVENT_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	_tmp5_ = *event_id;
	res = sqlite3_bind_int64 (_tmp4_, 2, _tmp5_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("drop_event", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_set_event (PhotoTable* self,
                       PhotoID* photo_id,
                       EventID* event_id)
{
	PhotoID _tmp0_;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = *event_id;
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "event_id", _tmp1_.id);
	return result;
}

static gchar*
photo_table_get_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id)
{
	sqlite3_stmt* stmt = NULL;
	PhotoID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* trans = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp2_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "transformations", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	trans = _tmp5_;
	_tmp7_ = trans;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = trans;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == 0;
	}
	if (_tmp6_) {
		result = NULL;
		_g_free0 (trans);
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = trans;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gboolean
photo_table_set_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id,
                                     const gchar* trans)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (trans != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "transformations", trans);
	return result;
}

gboolean
photo_table_set_transformation_state (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation,
                                      GeeHashMap* transformations)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	PhotoID _tmp8_;
	sqlite3_stmt* _tmp9_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail ((transformations == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (transformations, GEE_TYPE_HASH_MAP), FALSE);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET orientation = ?, transformations = ? WHERE id = " \
"?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int (_tmp3_, 1, (gint) orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	_tmp5_ = photo_table_unmarshall_all_transformations (transformations);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp4_, 2, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	_tmp8_ = *photo_id;
	res = sqlite3_bind_int64 (_tmp7_, 3, _tmp8_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	res = sqlite3_step (_tmp9_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("set_transformation_state", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeHashMap*
photo_table_marshall_all_transformations (const gchar* trans)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	GeeHashMap* result;
	if (trans == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (trans);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp8_;
		gchar** objects = NULL;
		GKeyFile* _tmp9_;
		gsize _tmp10_ = 0;
		gchar** _tmp11_;
		gint objects_length1;
		gint _objects_size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp3_ = g_key_file_new ();
		keyfile = _tmp3_;
		_tmp5_ = keyfile;
		_tmp6_ = strlen (trans);
		_tmp7_ = _tmp6_;
		_tmp4_ = g_key_file_load_from_data (_tmp5_, trans, (gsize) _tmp7_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		if (!_tmp4_) {
			result = NULL;
			_g_key_file_unref0 (keyfile);
			return result;
		}
		_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		map = _tmp8_;
		_tmp9_ = keyfile;
		_tmp11_ = g_key_file_get_groups (_tmp9_, &_tmp10_);
		objects = _tmp11_;
		objects_length1 = _tmp10_;
		_objects_size_ = objects_length1;
		_tmp12_ = objects;
		_tmp12__length1 = objects_length1;
		{
			gchar** object_collection = NULL;
			gint object_collection_length1 = 0;
			gint _object_collection_size_ = 0;
			gint object_it = 0;
			object_collection = _tmp12_;
			object_collection_length1 = _tmp12__length1;
			for (object_it = 0; object_it < object_collection_length1; object_it = object_it + 1) {
				gchar* _tmp13_;
				gchar* object = NULL;
				_tmp13_ = g_strdup (object_collection[object_it]);
				object = _tmp13_;
				{
					gchar** keys = NULL;
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gsize _tmp16_ = 0;
					gchar** _tmp17_;
					gint keys_length1;
					gint _keys_size_;
					gboolean _tmp18_ = FALSE;
					gchar** _tmp19_;
					gint _tmp19__length1;
					KeyValueMap* key_map = NULL;
					const gchar* _tmp21_;
					KeyValueMap* _tmp22_;
					GeeHashMap* _tmp35_;
					const gchar* _tmp36_;
					KeyValueMap* _tmp37_;
					_tmp14_ = keyfile;
					_tmp15_ = object;
					_tmp17_ = g_key_file_get_keys (_tmp14_, _tmp15_, &_tmp16_, &_inner_error0_);
					keys = _tmp17_;
					keys_length1 = _tmp16_;
					_keys_size_ = keys_length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (object);
						objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (map);
						_g_key_file_unref0 (keyfile);
						goto __catch0_g_error;
					}
					_tmp19_ = keys;
					_tmp19__length1 = keys_length1;
					if (_tmp19_ == NULL) {
						_tmp18_ = TRUE;
					} else {
						gchar** _tmp20_;
						gint _tmp20__length1;
						_tmp20_ = keys;
						_tmp20__length1 = keys_length1;
						_tmp18_ = _tmp20__length1 == 0;
					}
					if (_tmp18_) {
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (object);
						continue;
					}
					_tmp21_ = object;
					_tmp22_ = key_value_map_new (_tmp21_);
					key_map = _tmp22_;
					{
						gint ctr = 0;
						ctr = 0;
						{
							gboolean _tmp23_ = FALSE;
							_tmp23_ = TRUE;
							while (TRUE) {
								gchar** _tmp25_;
								gint _tmp25__length1;
								gchar* _tmp26_ = NULL;
								GKeyFile* _tmp27_;
								const gchar* _tmp28_;
								gchar** _tmp29_;
								gint _tmp29__length1;
								const gchar* _tmp30_;
								gchar* _tmp31_;
								KeyValueMap* _tmp32_;
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								if (!_tmp23_) {
									gint _tmp24_;
									_tmp24_ = ctr;
									ctr = _tmp24_ + 1;
								}
								_tmp23_ = FALSE;
								_tmp25_ = keys;
								_tmp25__length1 = keys_length1;
								if (!(ctr < _tmp25__length1)) {
									break;
								}
								_tmp27_ = keyfile;
								_tmp28_ = object;
								_tmp29_ = keys;
								_tmp29__length1 = keys_length1;
								_tmp30_ = _tmp29_[ctr];
								_tmp31_ = g_key_file_get_string (_tmp27_, _tmp28_, _tmp30_, &_inner_error0_);
								_tmp26_ = _tmp31_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_key_value_map_unref0 (key_map);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (object);
									objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (map);
									_g_key_file_unref0 (keyfile);
									goto __catch0_g_error;
								}
								_tmp32_ = key_map;
								_tmp33_ = keys;
								_tmp33__length1 = keys_length1;
								_tmp34_ = _tmp33_[ctr];
								key_value_map_set_string (_tmp32_, _tmp34_, _tmp26_);
								_g_free0 (_tmp26_);
							}
						}
					}
					_tmp35_ = map;
					_tmp36_ = object;
					_tmp37_ = key_map;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp36_, _tmp37_);
					_key_value_map_unref0 (key_map);
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (object);
				}
			}
		}
		result = map;
		objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_unref0 (keyfile);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp38_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = err->message;
		g_error ("PhotoTable.vala:874: %s", _tmp38_);
		_g_error_free0 (err);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
photo_table_unmarshall_all_transformations (GeeHashMap* transformations)
{
	gboolean _tmp0_ = FALSE;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp6_;
	gsize length = 0UL;
	gchar* unmarshalled = NULL;
	GKeyFile* _tmp33_;
	gsize _tmp34_ = 0UL;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gchar* result;
	g_return_val_if_fail ((transformations == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (transformations, GEE_TYPE_HASH_MAP), NULL);
	if (transformations == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == 0;
		_g_object_unref0 (_tmp3_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp6_ = g_key_file_new ();
	keyfile = _tmp6_;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp7_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_object_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* object = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			KeyValueMap* map = NULL;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			_tmp12_ = _object_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _object_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			object = (gchar*) _tmp14_;
			_tmp15_ = object;
			_tmp16_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_);
			map = (KeyValueMap*) _tmp16_;
			{
				GeeIterator* _key_it = NULL;
				KeyValueMap* _tmp17_;
				GeeSet* _tmp18_;
				GeeSet* _tmp19_;
				GeeIterator* _tmp20_;
				GeeIterator* _tmp21_;
				_tmp17_ = map;
				_tmp18_ = key_value_map_get_keys (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp19_);
				_key_it = _tmp21_;
				while (TRUE) {
					GeeIterator* _tmp22_;
					gchar* key = NULL;
					GeeIterator* _tmp23_;
					gpointer _tmp24_;
					gchar* value = NULL;
					KeyValueMap* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					GKeyFile* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					_tmp22_ = _key_it;
					if (!gee_iterator_next (_tmp22_)) {
						break;
					}
					_tmp23_ = _key_it;
					_tmp24_ = gee_iterator_get (_tmp23_);
					key = (gchar*) _tmp24_;
					_tmp25_ = map;
					_tmp26_ = key;
					_tmp27_ = key_value_map_get_string (_tmp25_, _tmp26_, NULL);
					value = _tmp27_;
					_tmp28_ = value;
					_vala_assert (_tmp28_ != NULL, "value != null");
					_tmp29_ = keyfile;
					_tmp30_ = object;
					_tmp31_ = key;
					_tmp32_ = value;
					g_key_file_set_string (_tmp29_, _tmp30_, _tmp31_, _tmp32_);
					_g_free0 (value);
					_g_free0 (key);
				}
				_g_object_unref0 (_key_it);
			}
			_key_value_map_unref0 (map);
			_g_free0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp33_ = keyfile;
	_tmp35_ = g_key_file_to_data (_tmp33_, &_tmp34_, NULL);
	length = _tmp34_;
	unmarshalled = _tmp35_;
	_tmp36_ = unmarshalled;
	_vala_assert (_tmp36_ != NULL, "unmarshalled != null");
	_tmp37_ = unmarshalled;
	_tmp38_ = strlen (_tmp37_);
	_tmp39_ = _tmp38_;
	_vala_assert (_tmp39_ > 0, "unmarshalled.length > 0");
	result = unmarshalled;
	_g_key_file_unref0 (keyfile);
	return result;
}

gboolean
photo_table_set_transformation (PhotoTable* self,
                                PhotoID* photo_id,
                                KeyValueMap* map)
{
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	PhotoID _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, TYPE_KEY_VALUE_MAP), FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
	trans = _tmp1_;
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GeeSet* keys = NULL;
		GeeSet* _tmp10_;
		gsize length = 0UL;
		GKeyFile* _tmp24_;
		gsize _tmp25_ = 0UL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp2_ = g_key_file_new ();
		keyfile = _tmp2_;
		_tmp3_ = trans;
		if (_tmp3_ != NULL) {
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp5_ = keyfile;
			_tmp6_ = trans;
			_tmp7_ = trans;
			_tmp8_ = strlen (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (keyfile);
				goto __catch0_g_error;
			}
			if (!_tmp4_) {
				result = FALSE;
				_g_key_file_unref0 (keyfile);
				_g_free0 (trans);
				return result;
			}
		}
		_tmp10_ = key_value_map_get_keys (map);
		keys = _tmp10_;
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp11_;
			GeeIterator* _tmp12_;
			_tmp11_ = keys;
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
			_key_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_;
				gchar* key = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				gchar* value = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				GKeyFile* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp13_ = _key_it;
				if (!gee_iterator_next (_tmp13_)) {
					break;
				}
				_tmp14_ = _key_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				key = (gchar*) _tmp15_;
				_tmp16_ = key;
				_tmp17_ = key_value_map_get_string (map, _tmp16_, NULL);
				value = _tmp17_;
				_tmp18_ = value;
				_vala_assert (_tmp18_ != NULL, "value != null");
				_tmp19_ = keyfile;
				_tmp20_ = key_value_map_get_group (map);
				_tmp21_ = _tmp20_;
				_tmp22_ = key;
				_tmp23_ = value;
				g_key_file_set_string (_tmp19_, _tmp21_, _tmp22_, _tmp23_);
				_g_free0 (_tmp21_);
				_g_free0 (value);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp24_ = keyfile;
		_tmp26_ = g_key_file_to_data (_tmp24_, &_tmp25_, NULL);
		length = _tmp25_;
		_g_free0 (trans);
		trans = _tmp26_;
		_tmp27_ = trans;
		_vala_assert (_tmp27_ != NULL, "trans != null");
		_tmp28_ = trans;
		_tmp29_ = strlen (_tmp28_);
		_tmp30_ = _tmp29_;
		_vala_assert (_tmp30_ > 0, "trans.length > 0");
		_g_object_unref0 (keys);
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp31_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err->message;
		g_error ("PhotoTable.vala:926: %s", _tmp31_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		_g_free0 (trans);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp32_;
	}
	_tmp33_ = *photo_id;
	_tmp34_ = trans;
	result = photo_table_set_raw_transformations (self, &_tmp33_, _tmp34_);
	_g_free0 (trans);
	return result;
}

gboolean
photo_table_remove_transformation (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* object)
{
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	PhotoID _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
	trans = _tmp1_;
	_tmp2_ = trans;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_free0 (trans);
		return result;
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		gsize length = 0UL;
		GKeyFile* _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp3_ = g_key_file_new ();
		keyfile = _tmp3_;
		_tmp5_ = keyfile;
		_tmp6_ = trans;
		_tmp7_ = trans;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		if (!_tmp4_) {
			result = FALSE;
			_g_key_file_unref0 (keyfile);
			_g_free0 (trans);
			return result;
		}
		_tmp10_ = keyfile;
		if (!g_key_file_has_group (_tmp10_, object)) {
			result = TRUE;
			_g_key_file_unref0 (keyfile);
			_g_free0 (trans);
			return result;
		}
		_tmp11_ = keyfile;
		g_key_file_remove_group (_tmp11_, object, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		_tmp12_ = keyfile;
		_tmp14_ = g_key_file_to_data (_tmp12_, &_tmp13_, NULL);
		length = _tmp13_;
		_g_free0 (trans);
		trans = _tmp14_;
		_tmp15_ = trans;
		_vala_assert (_tmp15_ != NULL, "trans != null");
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = err->message;
		g_error ("PhotoTable.vala:951: %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_free0 (trans);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = *photo_id;
	_tmp19_ = trans;
	result = photo_table_set_raw_transformations (self, &_tmp18_, _tmp19_);
	_g_free0 (trans);
	return result;
}

gboolean
photo_table_remove_all_transformations (PhotoTable* self,
                                        PhotoID* photo_id)
{
	PhotoID _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	PhotoID _tmp4_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = *photo_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_.id, "transformations", "");
	return result;
}

static sqlite3_stmt*
photo_table_get_duplicate_stmt (PhotoTable* self,
                                GFile* file,
                                const gchar* thumbnail_md5,
                                const gchar* md5,
                                PhotoFileFormat file_format)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp2_;
	gboolean first = FALSE;
	gboolean _tmp5_ = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp22_;
	const gchar* _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_;
	gint col = 0;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	sqlite3_stmt* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	if (file != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = thumbnail_md5 != NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || thumbnail_md5 != null || md5 != null");
	_tmp2_ = g_strdup ("SELECT id FROM PhotoTable WHERE");
	sql = _tmp2_;
	first = TRUE;
	if (file != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = sql;
		_tmp4_ = g_strconcat (_tmp3_, " filename=?", NULL);
		_g_free0 (sql);
		sql = _tmp4_;
		first = FALSE;
	}
	if (thumbnail_md5 != NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = md5 != NULL;
	}
	if (_tmp5_) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		if (first) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = sql;
			_tmp7_ = g_strconcat (_tmp6_, " ((", NULL);
			_g_free0 (sql);
			sql = _tmp7_;
		} else {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = sql;
			_tmp9_ = g_strconcat (_tmp8_, " OR ((", NULL);
			_g_free0 (sql);
			sql = _tmp9_;
		}
		first = FALSE;
		if (md5 != NULL) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = sql;
			_tmp11_ = g_strconcat (_tmp10_, " md5=?", NULL);
			_g_free0 (sql);
			sql = _tmp11_;
		}
		if (thumbnail_md5 != NULL) {
			if (md5 == NULL) {
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp12_ = sql;
				_tmp13_ = g_strconcat (_tmp12_, " thumbnail_md5=?", NULL);
				_g_free0 (sql);
				sql = _tmp13_;
			} else {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = sql;
				_tmp15_ = g_strconcat (_tmp14_, " OR (md5 IS NULL AND thumbnail_md5=?)", NULL);
				_g_free0 (sql);
				sql = _tmp15_;
			}
		}
		_tmp16_ = sql;
		_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
		_g_free0 (sql);
		sql = _tmp17_;
		if (file_format != PHOTO_FILE_FORMAT_UNKNOWN) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = sql;
			_tmp19_ = g_strconcat (_tmp18_, " AND file_format=?", NULL);
			_g_free0 (sql);
			sql = _tmp19_;
		}
		_tmp20_ = sql;
		_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
		_g_free0 (sql);
		sql = _tmp21_;
	}
	_tmp22_ = database_table_db;
	_tmp23_ = sql;
	_tmp25_ = sqlite3_prepare_v2 (_tmp22_, _tmp23_, -1, &_tmp24_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp24_;
	res = _tmp25_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	col = 1;
	if (file != NULL) {
		sqlite3_stmt* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		GDestroyNotify _tmp29_;
		_tmp26_ = stmt;
		_tmp27_ = col;
		col = _tmp27_ + 1;
		_tmp28_ = g_file_get_path (file);
		_tmp29_ = g_free;
		res = sqlite3_bind_text (_tmp26_, _tmp27_, _tmp28_, -1, _tmp29_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	if (thumbnail_md5 != NULL) {
		sqlite3_stmt* _tmp30_;
		gint _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		GDestroyNotify _tmp34_;
		_tmp30_ = stmt;
		_tmp31_ = col;
		col = _tmp31_ + 1;
		_tmp32_ = thumbnail_md5;
		_tmp33_ = g_strdup (_tmp32_);
		_tmp34_ = g_free;
		res = sqlite3_bind_text (_tmp30_, _tmp31_, _tmp33_, -1, _tmp34_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	if (md5 != NULL) {
		sqlite3_stmt* _tmp35_;
		gint _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		GDestroyNotify _tmp39_;
		_tmp35_ = stmt;
		_tmp36_ = col;
		col = _tmp36_ + 1;
		_tmp37_ = md5;
		_tmp38_ = g_strdup (_tmp37_);
		_tmp39_ = g_free;
		res = sqlite3_bind_text (_tmp35_, _tmp36_, _tmp38_, -1, _tmp39_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	if (thumbnail_md5 != NULL) {
		_tmp41_ = TRUE;
	} else {
		_tmp41_ = md5 != NULL;
	}
	if (_tmp41_) {
		_tmp40_ = file_format != PHOTO_FILE_FORMAT_UNKNOWN;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		sqlite3_stmt* _tmp42_;
		gint _tmp43_;
		_tmp42_ = stmt;
		_tmp43_ = col;
		col = _tmp43_ + 1;
		res = sqlite3_bind_int (_tmp42_, _tmp43_, photo_file_format_serialize (file_format));
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	result = stmt;
	_g_free0 (sql);
	return result;
}

gboolean
photo_table_has_duplicate (PhotoTable* self,
                           GFile* file,
                           const gchar* thumbnail_md5,
                           const gchar* md5,
                           PhotoFileFormat file_format)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res == SQLITE_ROW) {
			result = TRUE;
			_sqlite3_finalize0 (stmt);
			return result;
		} else {
			database_table_fatal ("has_duplicate", res);
			result = FALSE;
			_sqlite3_finalize0 (stmt);
			return result;
		}
	}
}

static void
_vala_array_add2 (PhotoID* * array,
                  gint* length,
                  gint* size,
                  const PhotoID* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PhotoID, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

PhotoID*
photo_table_get_duplicate_ids (PhotoTable* self,
                               GFile* file,
                               const gchar* thumbnail_md5,
                               const gchar* md5,
                               PhotoFileFormat file_format,
                               gint* result_length1)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	PhotoID* ids = NULL;
	PhotoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	PhotoID* _tmp6_;
	gint _tmp6__length1;
	PhotoID* result;
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
	stmt = _tmp0_;
	_tmp1_ = g_new0 (PhotoID, 0);
	ids = _tmp1_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		PhotoID _tmp4_ = {0};
		sqlite3_stmt* _tmp5_;
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = stmt;
		photo_id_init (&_tmp4_, sqlite3_column_int64 (_tmp3_, 0));
		_vala_array_add2 (&ids, &ids_length1, &_ids_size_, &_tmp4_);
		_tmp5_ = stmt;
		res = sqlite3_step (_tmp5_);
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_update_backlinks (PhotoTable* self,
                              PhotoID* photo_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	if (backlinks != NULL) {
		_tmp0_ = backlinks;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "backlinks", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_attach_editable (PhotoTable* self,
                             PhotoRow* row,
                             BackingPhotoID* editable_id,
                             GError** error)
{
	PhotoID _tmp0_;
	BackingPhotoID _tmp1_;
	BackingPhotoID _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	g_return_if_fail (editable_id != NULL);
	_tmp0_ = row->photo_id;
	_tmp1_ = *editable_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "editable_id", _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = *editable_id;
	row->editable_id = _tmp2_;
}

void
photo_table_detach_editable (PhotoTable* self,
                             PhotoRow* row,
                             GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	_tmp0_ = row->photo_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "editable_id", BACKING_PHOTO_ID_INVALID, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	backing_photo_id_init (&row->editable_id, BACKING_PHOTO_ID_INVALID);
}

void
photo_table_set_metadata_dirty (PhotoTable* self,
                                PhotoID* photo_id,
                                gboolean dirty,
                                GError** error)
{
	gint _tmp0_ = 0;
	PhotoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (photo_id != NULL);
	if (dirty) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = *photo_id;
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "metadata_dirty", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_update_raw_development (PhotoTable* self,
                                    PhotoRow* row,
                                    RawDeveloper rd,
                                    BackingPhotoID* backing_photo_id,
                                    GError** error)
{
	gchar* col = NULL;
	BackingPhotoID* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID _tmp4_;
	PhotoID _tmp5_;
	const gchar* _tmp6_;
	BackingPhotoID _tmp7_;
	BackingPhotoID _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	g_return_if_fail (backing_photo_id != NULL);
	switch (rd) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("develop_shotwell_id");
			_g_free0 (col);
			col = _tmp0_;
			break;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("develop_camera_id");
			_g_free0 (col);
			col = _tmp1_;
			break;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("develop_embedded_id");
			_g_free0 (col);
			col = _tmp2_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp3_ = row->development_ids;
	_tmp3__length1 = row->development_ids_length1;
	_tmp4_ = *backing_photo_id;
	_tmp3_[rd] = _tmp4_;
	_tmp5_ = row->photo_id;
	_tmp6_ = col;
	_tmp7_ = *backing_photo_id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp5_.id, _tmp6_, _tmp7_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (col);
			return;
		} else {
			_g_free0 (col);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = *backing_photo_id;
	if (_tmp8_.id != BACKING_PHOTO_ID_INVALID) {
		PhotoID _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = row->photo_id;
		_tmp10_ = raw_developer_to_string (rd);
		_tmp11_ = _tmp10_;
		database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp9_.id, "developer", _tmp11_, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (col);
				return;
			} else {
				_g_free0 (col);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_free0 (col);
}

void
photo_table_remove_development (PhotoTable* self,
                                PhotoRow* row,
                                RawDeveloper rd,
                                GError** error)
{
	BackingPhotoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_TABLE (self));
	g_return_if_fail (IS_PHOTO_ROW (row));
	backing_photo_id_init (&_tmp0_, BACKING_PHOTO_ID_INVALID);
	photo_table_update_raw_development (self, row, rd, &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_upgrade_for_unset_timestamp (GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET exposure_time = NULL WHERE exposure_time = '0'", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("PhotoTable.upgrade_for_unset_timestamp", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

static void
photo_table_class_init (PhotoTableClass * klass,
                        gpointer klass_data)
{
	photo_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = photo_table_finalize;
}

static void
photo_table_instance_init (PhotoTable * self,
                           gpointer klass)
{
}

static void
photo_table_finalize (DatabaseTable * obj)
{
	PhotoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TABLE, PhotoTable);
	DATABASE_TABLE_CLASS (photo_table_parent_class)->finalize (obj);
}

static GType
photo_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTable), 0, (GInstanceInitFunc) photo_table_instance_init, NULL };
	GType photo_table_type_id;
	photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "PhotoTable", &g_define_type_info, 0);
	return photo_table_type_id;
}

GType
photo_table_get_type (void)
{
	static volatile gsize photo_table_type_id__once = 0;
	if (g_once_init_enter (&photo_table_type_id__once)) {
		GType photo_table_type_id;
		photo_table_type_id = photo_table_get_type_once ();
		g_once_init_leave (&photo_table_type_id__once, photo_table_type_id);
	}
	return photo_table_type_id__once;
}

void
backing_photo_id_init (BackingPhotoID *self,
                       gint64 id)
{
	memset (self, 0, sizeof (BackingPhotoID));
	(*self).id = id;
}

gboolean
backing_photo_id_is_invalid (BackingPhotoID *self)
{
	gboolean result;
	result = (*self).id == BACKING_PHOTO_ID_INVALID;
	return result;
}

gboolean
backing_photo_id_is_valid (BackingPhotoID *self)
{
	gboolean result;
	result = (*self).id != BACKING_PHOTO_ID_INVALID;
	return result;
}

BackingPhotoID*
backing_photo_id_dup (const BackingPhotoID* self)
{
	BackingPhotoID* dup;
	dup = g_new0 (BackingPhotoID, 1);
	memcpy (dup, self, sizeof (BackingPhotoID));
	return dup;
}

void
backing_photo_id_free (BackingPhotoID* self)
{
	g_free (self);
}

static GType
backing_photo_id_get_type_once (void)
{
	GType backing_photo_id_type_id;
	backing_photo_id_type_id = g_boxed_type_register_static ("BackingPhotoID", (GBoxedCopyFunc) backing_photo_id_dup, (GBoxedFreeFunc) backing_photo_id_free);
	return backing_photo_id_type_id;
}

GType
backing_photo_id_get_type (void)
{
	static volatile gsize backing_photo_id_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_id_type_id__once)) {
		GType backing_photo_id_type_id;
		backing_photo_id_type_id = backing_photo_id_get_type_once ();
		g_once_init_leave (&backing_photo_id_type_id__once, backing_photo_id_type_id);
	}
	return backing_photo_id_type_id__once;
}

gboolean
backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                     GFileInfo* info)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	if (self->filesize != g_file_info_get_size (info)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->timestamp;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->timestamp;
	_tmp2_ = g_file_info_get_modification_date_time (info);
	_tmp3_ = _tmp2_;
	_tmp4_ = coarsify_date_time (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_equal (_tmp1_, _tmp5_);
	_g_date_time_unref0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

gboolean
backing_photo_row_is_touched (BackingPhotoRow* self,
                              GFileInfo* info)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	if (self->filesize != g_file_info_get_size (info)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->timestamp;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->timestamp;
	_tmp2_ = g_file_info_get_modification_date_time (info);
	_tmp3_ = _tmp2_;
	_tmp4_ = coarsify_date_time (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = !g_date_time_equal (_tmp1_, _tmp5_);
	_g_date_time_unref0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

void
backing_photo_row_copy_from (BackingPhotoRow* self,
                             BackingPhotoRow* from)
{
	BackingPhotoID _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	Dimensions _tmp5_;
	g_return_if_fail (IS_BACKING_PHOTO_ROW (self));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (from));
	_tmp0_ = from->id;
	self->id = _tmp0_;
	self->time_created = from->time_created;
	_tmp1_ = from->filepath;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->filepath);
	self->filepath = _tmp2_;
	self->filesize = from->filesize;
	_tmp3_ = from->timestamp;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_g_date_time_unref0 (self->timestamp);
	self->timestamp = _tmp4_;
	self->file_format = from->file_format;
	_tmp5_ = from->dim;
	self->dim = _tmp5_;
	self->original_orientation = from->original_orientation;
}

BackingPhotoRow*
backing_photo_row_construct (GType object_type)
{
	BackingPhotoRow* self = NULL;
	self = (BackingPhotoRow*) g_type_create_instance (object_type);
	return self;
}

BackingPhotoRow*
backing_photo_row_new (void)
{
	return backing_photo_row_construct (TYPE_BACKING_PHOTO_ROW);
}

static void
value_backing_photo_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_backing_photo_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		backing_photo_row_unref (value->data[0].v_pointer);
	}
}

static void
value_backing_photo_row_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = backing_photo_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_backing_photo_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_backing_photo_row_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BackingPhotoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = backing_photo_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_backing_photo_row_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BackingPhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = backing_photo_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_backing_photo_row (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecBackingPhotoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_PHOTO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_backing_photo_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_backing_photo_row (GValue* value,
                             gpointer v_object)
{
	BackingPhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		backing_photo_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_photo_row_unref (old);
	}
}

void
value_take_backing_photo_row (GValue* value,
                              gpointer v_object)
{
	BackingPhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_photo_row_unref (old);
	}
}

static void
backing_photo_row_class_init (BackingPhotoRowClass * klass,
                              gpointer klass_data)
{
	backing_photo_row_parent_class = g_type_class_peek_parent (klass);
	((BackingPhotoRowClass *) klass)->finalize = backing_photo_row_finalize;
}

static void
backing_photo_row_instance_init (BackingPhotoRow * self,
                                 gpointer klass)
{
	self->filepath = NULL;
	self->ref_count = 1;
}

static void
backing_photo_row_finalize (BackingPhotoRow * obj)
{
	BackingPhotoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_ROW, BackingPhotoRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
	_g_date_time_unref0 (self->timestamp);
}

static GType
backing_photo_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_backing_photo_row_init, value_backing_photo_row_free_value, value_backing_photo_row_copy_value, value_backing_photo_row_peek_pointer, "p", value_backing_photo_row_collect_value, "p", value_backing_photo_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoRow), 0, (GInstanceInitFunc) backing_photo_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType backing_photo_row_type_id;
	backing_photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingPhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return backing_photo_row_type_id;
}

GType
backing_photo_row_get_type (void)
{
	static volatile gsize backing_photo_row_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_row_type_id__once)) {
		GType backing_photo_row_type_id;
		backing_photo_row_type_id = backing_photo_row_get_type_once ();
		g_once_init_leave (&backing_photo_row_type_id__once, backing_photo_row_type_id);
	}
	return backing_photo_row_type_id__once;
}

gpointer
backing_photo_row_ref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
backing_photo_row_unref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKING_PHOTO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static BackingPhotoTable*
backing_photo_table_construct (GType object_type)
{
	BackingPhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (BackingPhotoTable*) database_table_construct (object_type);
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "BackingPhotoTable");
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "BackingPhotoTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT UNIQUE NOT NULL, " "timestamp INTEGER, " "filesize INTEGER, " "width INTEGER, " "height INTEGER, " "original_orientation INTEGER, " "file_format INTEGER, " "time_created INTEGER " ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create PhotoBackingTable", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static BackingPhotoTable*
backing_photo_table_new (void)
{
	return backing_photo_table_construct (TYPE_BACKING_PHOTO_TABLE);
}

BackingPhotoTable*
backing_photo_table_get_instance (void)
{
	BackingPhotoTable* _tmp0_;
	BackingPhotoTable* _tmp2_;
	BackingPhotoTable* _tmp3_;
	BackingPhotoTable* result;
	_tmp0_ = backing_photo_table_instance;
	if (_tmp0_ == NULL) {
		BackingPhotoTable* _tmp1_;
		_tmp1_ = backing_photo_table_new ();
		_database_table_unref0 (backing_photo_table_instance);
		backing_photo_table_instance = _tmp1_;
	}
	_tmp2_ = backing_photo_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
backing_photo_table_add (BackingPhotoTable* self,
                         BackingPhotoRow* state,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	GDateTime* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	Dimensions _tmp11_;
	sqlite3_stmt* _tmp12_;
	Dimensions _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	sqlite3* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (state));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO BackingPhotoTable " "(filepath, timestamp, filesize, width, height, original_orientation, " "file_format, time_created) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_created = now_sec ();
	_tmp3_ = stmt;
	_tmp4_ = state->filepath;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	_tmp8_ = state->timestamp;
	res = sqlite3_bind_int64 (_tmp7_, 2, g_date_time_to_unix (_tmp8_));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	res = sqlite3_bind_int64 (_tmp9_, 3, state->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp10_ = stmt;
	_tmp11_ = state->dim;
	res = sqlite3_bind_int (_tmp10_, 4, _tmp11_.width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	_tmp13_ = state->dim;
	res = sqlite3_bind_int (_tmp12_, 5, _tmp13_.height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = stmt;
	res = sqlite3_bind_int (_tmp14_, 6, (gint) state->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp15_ = stmt;
	res = sqlite3_bind_int (_tmp15_, 7, photo_file_format_serialize (state->file_format));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp16_ = stmt;
	res = sqlite3_bind_int64 (_tmp16_, 8, (gint64) time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp17_ = stmt;
	res = sqlite3_step (_tmp17_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("PhotoBackingTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp18_ = database_table_db;
	backing_photo_id_init (&state->id, sqlite3_last_insert_rowid (_tmp18_));
	state->time_created = time_created;
	_sqlite3_finalize0 (stmt);
}

BackingPhotoRow*
backing_photo_table_fetch (BackingPhotoTable* self,
                           BackingPhotoID* id,
                           GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	BackingPhotoID _tmp4_;
	sqlite3_stmt* _tmp5_;
	BackingPhotoRow* row = NULL;
	BackingPhotoRow* _tmp6_;
	BackingPhotoRow* _tmp7_;
	BackingPhotoID _tmp8_;
	BackingPhotoRow* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	GDateTime* _tmp15_;
	BackingPhotoRow* _tmp16_;
	sqlite3_stmt* _tmp17_;
	BackingPhotoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3_stmt* _tmp20_;
	BackingPhotoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	BackingPhotoRow* _tmp23_;
	sqlite3_stmt* _tmp24_;
	BackingPhotoRow* _tmp25_;
	sqlite3_stmt* _tmp26_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_BACKING_PHOTO_TABLE (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filepath, timestamp, filesize, width, height, " "original_orientation, file_format, time_created FROM BackingPhotoTable" \
" WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("BackingPhotoTable.fetch_for_photo", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp6_ = backing_photo_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *id;
	_tmp7_->id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = stmt;
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 0);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp9_->filepath);
	_tmp9_->filepath = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp15_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp14_, 1));
	_g_date_time_unref0 (_tmp13_->timestamp);
	_tmp13_->timestamp = _tmp15_;
	_tmp16_ = row;
	_tmp17_ = stmt;
	_tmp16_->filesize = sqlite3_column_int64 (_tmp17_, 2);
	_tmp18_ = row;
	_tmp19_ = stmt;
	_tmp20_ = stmt;
	dimensions_init (&_tmp18_->dim, sqlite3_column_int (_tmp19_, 3), sqlite3_column_int (_tmp20_, 4));
	_tmp21_ = row;
	_tmp22_ = stmt;
	_tmp21_->original_orientation = (Orientation) sqlite3_column_int (_tmp22_, 5);
	_tmp23_ = row;
	_tmp24_ = stmt;
	_tmp23_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp24_, 6));
	_tmp25_ = row;
	_tmp26_ = stmt;
	_tmp25_->time_created = sqlite3_column_int64 (_tmp26_, 7);
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
backing_photo_table_update (BackingPhotoTable* self,
                            BackingPhotoRow* row,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	GDateTime* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	Dimensions _tmp7_;
	sqlite3_stmt* _tmp8_;
	Dimensions _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	BackingPhotoID _tmp13_;
	sqlite3_stmt* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=?, " "width=?, height=?, original_orientation=?, file_format=? " "WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = row->timestamp;
	res = sqlite3_bind_int64 (_tmp3_, 1, g_date_time_to_unix (_tmp4_));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_bind_int64 (_tmp5_, 2, row->filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	_tmp7_ = row->dim;
	res = sqlite3_bind_int (_tmp6_, 3, _tmp7_.width);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = row->dim;
	res = sqlite3_bind_int (_tmp8_, 4, _tmp9_.height);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp10_ = stmt;
	res = sqlite3_bind_int (_tmp10_, 5, (gint) row->original_orientation);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	res = sqlite3_bind_int (_tmp11_, 6, photo_file_format_serialize (row->file_format));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	_tmp13_ = row->id;
	res = sqlite3_bind_int64 (_tmp12_, 7, _tmp13_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp14_ = stmt;
	res = sqlite3_step (_tmp14_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("BackingPhotoTable.update", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
backing_photo_table_update_attributes (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       GDateTime* timestamp,
                                       gint64 filesize,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	BackingPhotoID _tmp6_;
	sqlite3_stmt* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (timestamp != NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=? WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int64 (_tmp3_, 1, g_date_time_to_unix (timestamp));
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	res = sqlite3_bind_int64 (_tmp4_, 2, filesize);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = *id;
	res = sqlite3_bind_int64 (_tmp5_, 3, _tmp6_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("BackingPhotoTable.update_attributes", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
backing_photo_table_remove (BackingPhotoTable* self,
                            BackingPhotoID* backing_id,
                            GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (backing_id != NULL);
	_tmp0_ = *backing_id;
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
backing_photo_table_set_filepath (BackingPhotoTable* self,
                                  BackingPhotoID* id,
                                  const gchar* filepath,
                                  GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "filepath", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                      BackingPhotoID* id,
                                      GDateTime* timestamp,
                                      GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (timestamp != NULL);
	_tmp0_ = *id;
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "timestamp", g_date_time_to_unix (timestamp), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
backing_photo_table_class_init (BackingPhotoTableClass * klass,
                                gpointer klass_data)
{
	backing_photo_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = backing_photo_table_finalize;
}

static void
backing_photo_table_instance_init (BackingPhotoTable * self,
                                   gpointer klass)
{
}

static void
backing_photo_table_finalize (DatabaseTable * obj)
{
	BackingPhotoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable);
	DATABASE_TABLE_CLASS (backing_photo_table_parent_class)->finalize (obj);
}

static GType
backing_photo_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoTable), 0, (GInstanceInitFunc) backing_photo_table_instance_init, NULL };
	GType backing_photo_table_type_id;
	backing_photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "BackingPhotoTable", &g_define_type_info, 0);
	return backing_photo_table_type_id;
}

GType
backing_photo_table_get_type (void)
{
	static volatile gsize backing_photo_table_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_table_type_id__once)) {
		GType backing_photo_table_type_id;
		backing_photo_table_type_id = backing_photo_table_get_type_once ();
		g_once_init_leave (&backing_photo_table_type_id__once, backing_photo_table_type_id);
	}
	return backing_photo_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

