/* EventTable.c generated by valac 0.56.17, the Vala compiler
 * generated from EventTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>

#define EVENT_ID_INVALID ((gint64) -1)
#define PHOTO_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_EVENT_ROW (event_row_get_type ())
#define EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_ROW, EventRow))
#define EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_ROW, EventRowClass))
#define IS_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_ROW))
#define IS_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_ROW))
#define EVENT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_ROW, EventRowClass))

typedef struct _EventRow EventRow;
typedef struct _EventRowClass EventRowClass;
typedef struct _EventRowPrivate EventRowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecEventRow ParamSpecEventRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_EVENT_TABLE (event_table_get_type ())
#define EVENT_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_TABLE, EventTable))
#define EVENT_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_TABLE, EventTableClass))
#define IS_EVENT_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_TABLE))
#define IS_EVENT_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_TABLE))
#define EVENT_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_TABLE, EventTableClass))

typedef struct _EventTable EventTable;
typedef struct _EventTableClass EventTableClass;
typedef struct _EventTablePrivate EventTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _event_row_unref0(var) ((var == NULL) ? NULL : (var = (event_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EventID {
	gint64 id;
};

struct _EventRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventRowPrivate * priv;
	EventID event_id;
	gchar* name;
	gint64 time_created;
	gchar* primary_source_id;
	gchar* comment;
};

struct _EventRowClass {
	GTypeClass parent_class;
	void (*finalize) (EventRow *self);
};

struct _ParamSpecEventRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _EventTable {
	DatabaseTable parent_instance;
	EventTablePrivate * priv;
};

struct _EventTableClass {
	DatabaseTableClass parent_class;
};

struct _PhotoID {
	gint64 id;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer event_row_parent_class = NULL;
static gpointer event_table_parent_class = NULL;
static EventTable* event_table_instance;
static EventTable* event_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN gboolean event_id_is_invalid (EventID *self);
VALA_EXTERN gboolean event_id_is_valid (EventID *self);
VALA_EXTERN gpointer event_row_ref (gpointer instance);
VALA_EXTERN void event_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_event_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_event_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_event_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_event_row (const GValue* value);
VALA_EXTERN GType event_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventRow, event_row_unref)
VALA_EXTERN EventRow* event_row_new (void);
VALA_EXTERN EventRow* event_row_construct (GType object_type);
static void event_row_finalize (EventRow * obj);
static GType event_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType event_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventTable, database_table_unref)
static EventTable* event_table_new (void);
static EventTable* event_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN EventTable* event_table_get_instance (void);
static gchar* event_table_source_id_upgrade (EventTable* self,
                                      gint64 primary_photo_id,
                                      const gchar* primary_source_id);
VALA_EXTERN gpointer media_collection_registry_ref (gpointer instance);
VALA_EXTERN void media_collection_registry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_media_collection_registry (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void value_set_media_collection_registry (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void value_take_media_collection_registry (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer value_get_media_collection_registry (const GValue* value);
VALA_EXTERN GType media_collection_registry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaCollectionRegistry, media_collection_registry_unref)
VALA_EXTERN MediaCollectionRegistry* media_collection_registry_get_instance (void);
VALA_EXTERN gboolean media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self,
                                                       const gchar* source_id);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
VALA_EXTERN void photo_id_init (PhotoID *self,
                    gint64 id);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventRow* event_table_create (EventTable* self,
                              const gchar* primary_source_id,
                              const gchar* comment,
                              GError** error);
VALA_EXTERN gint64 now_sec (void);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN void event_table_create_from_row (EventTable* self,
                                  EventRow* row,
                                  EventID* result);
VALA_EXTERN EventRow* event_table_get_row (EventTable* self,
                               EventID* event_id);
VALA_EXTERN void event_table_remove (EventTable* self,
                         EventID* event_id,
                         GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN GeeArrayList* event_table_get_events (EventTable* self);
VALA_EXTERN gboolean event_table_rename (EventTable* self,
                             EventID* event_id,
                             const gchar* name);
VALA_EXTERN gboolean database_table_update_text_by_id (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           const gchar* text);
VALA_EXTERN gchar* event_table_get_name (EventTable* self,
                             EventID* event_id);
VALA_EXTERN gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt** stmt);
VALA_EXTERN gchar* event_table_get_primary_source_id (EventTable* self,
                                          EventID* event_id);
VALA_EXTERN gboolean event_table_set_primary_source_id (EventTable* self,
                                            EventID* event_id,
                                            const gchar* primary_source_id);
VALA_EXTERN GDateTime* event_table_get_time_created (EventTable* self,
                                         EventID* event_id);
VALA_EXTERN gboolean event_table_set_comment (EventTable* self,
                                  EventID* event_id,
                                  const gchar* new_comment);
static void event_table_finalize (DatabaseTable * obj);
static GType event_table_get_type_once (void);

void
event_id_init (EventID *self,
               gint64 id)
{
	memset (self, 0, sizeof (EventID));
	(*self).id = id;
}

gboolean
event_id_is_invalid (EventID *self)
{
	gboolean result;
	result = (*self).id == EVENT_ID_INVALID;
	return result;
}

gboolean
event_id_is_valid (EventID *self)
{
	gboolean result;
	result = (*self).id != EVENT_ID_INVALID;
	return result;
}

EventID*
event_id_dup (const EventID* self)
{
	EventID* dup;
	dup = g_new0 (EventID, 1);
	memcpy (dup, self, sizeof (EventID));
	return dup;
}

void
event_id_free (EventID* self)
{
	g_free (self);
}

static GType
event_id_get_type_once (void)
{
	GType event_id_type_id;
	event_id_type_id = g_boxed_type_register_static ("EventID", (GBoxedCopyFunc) event_id_dup, (GBoxedFreeFunc) event_id_free);
	return event_id_type_id;
}

GType
event_id_get_type (void)
{
	static volatile gsize event_id_type_id__once = 0;
	if (g_once_init_enter (&event_id_type_id__once)) {
		GType event_id_type_id;
		event_id_type_id = event_id_get_type_once ();
		g_once_init_leave (&event_id_type_id__once, event_id_type_id);
	}
	return event_id_type_id__once;
}

EventRow*
event_row_construct (GType object_type)
{
	EventRow* self = NULL;
	self = (EventRow*) g_type_create_instance (object_type);
	return self;
}

EventRow*
event_row_new (void)
{
	return event_row_construct (TYPE_EVENT_ROW);
}

static void
value_event_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_event_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		event_row_unref (value->data[0].v_pointer);
	}
}

static void
value_event_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_event_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_event_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		EventRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_event_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	EventRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_event_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecEventRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_event_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_event_row (GValue* value,
                     gpointer v_object)
{
	EventRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_row_unref (old);
	}
}

void
value_take_event_row (GValue* value,
                      gpointer v_object)
{
	EventRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_row_unref (old);
	}
}

static void
event_row_class_init (EventRowClass * klass,
                      gpointer klass_data)
{
	event_row_parent_class = g_type_class_peek_parent (klass);
	((EventRowClass *) klass)->finalize = event_row_finalize;
}

static void
event_row_instance_init (EventRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
event_row_finalize (EventRow * obj)
{
	EventRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_ROW, EventRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->primary_source_id);
	_g_free0 (self->comment);
}

static GType
event_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_event_row_init, value_event_row_free_value, value_event_row_copy_value, value_event_row_peek_pointer, "p", value_event_row_collect_value, "p", value_event_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EventRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventRow), 0, (GInstanceInitFunc) event_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType event_row_type_id;
	event_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EventRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return event_row_type_id;
}

GType
event_row_get_type (void)
{
	static volatile gsize event_row_type_id__once = 0;
	if (g_once_init_enter (&event_row_type_id__once)) {
		GType event_row_type_id;
		event_row_type_id = event_row_get_type_once ();
		g_once_init_leave (&event_row_type_id__once, event_row_type_id);
	}
	return event_row_type_id__once;
}

gpointer
event_row_ref (gpointer instance)
{
	EventRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
event_row_unref (gpointer instance)
{
	EventRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static EventTable*
event_table_construct (GType object_type)
{
	EventTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (EventTable*) database_table_construct (object_type);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS EventTable (" "id INTEGER PRIMARY KEY, " "name TEXT, " "primary_photo_id INTEGER, " "time_created INTEGER," "primary_source_id TEXT," "comment TEXT" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create photo table", res);
	}
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "EventTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static EventTable*
event_table_new (void)
{
	return event_table_construct (TYPE_EVENT_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

EventTable*
event_table_get_instance (void)
{
	EventTable* _tmp0_;
	EventTable* _tmp2_;
	EventTable* _tmp3_;
	EventTable* result;
	_tmp0_ = event_table_instance;
	if (_tmp0_ == NULL) {
		EventTable* _tmp1_;
		_tmp1_ = event_table_new ();
		_database_table_unref0 (event_table_instance);
		event_table_instance = _tmp1_;
	}
	_tmp2_ = event_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
event_table_source_id_upgrade (EventTable* self,
                               gint64 primary_photo_id,
                               const gchar* primary_source_id)
{
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	_tmp0_ = media_collection_registry_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = media_collection_registry_is_valid_source_id (_tmp1_, primary_source_id);
	_media_collection_registry_unref0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (primary_source_id);
		result = _tmp3_;
		return result;
	}
	if (primary_photo_id != PHOTO_ID_INVALID) {
		PhotoID _tmp4_ = {0};
		gchar* _tmp5_;
		photo_id_init (&_tmp4_, primary_photo_id);
		_tmp5_ = photo_id_upgrade_photo_id_to_source_id (&_tmp4_);
		result = _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

EventRow*
event_table_create (EventTable* self,
                    const gchar* primary_source_id,
                    const gchar* comment,
                    GError** error)
{
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	GDestroyNotify _tmp10_;
	sqlite3_stmt* _tmp11_;
	EventRow* row = NULL;
	EventRow* _tmp12_;
	EventRow* _tmp13_;
	sqlite3* _tmp14_;
	EventRow* _tmp15_;
	EventRow* _tmp16_;
	gchar* _tmp17_;
	EventRow* _tmp18_;
	EventRow* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	EventRow* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	if (primary_source_id != NULL) {
		_tmp0_ = g_strcmp0 (primary_source_id, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "primary_source_id != null && primary_source_id != \"\"");
	_tmp1_ = database_table_db;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "INSERT INTO EventTable (primary_source_id, time_created, comment) VALU" \
"ES (?, ?, ?)", -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	res = _tmp3_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_created = now_sec ();
	_tmp4_ = stmt;
	_tmp5_ = g_strdup (primary_source_id);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int64 (_tmp7_, 2, time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = g_strdup (comment);
	_tmp10_ = g_free;
	res = sqlite3_bind_text (_tmp8_, 3, _tmp9_, -1, _tmp10_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	res = sqlite3_step (_tmp11_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("EventTable.create", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp12_ = event_row_new ();
	row = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = database_table_db;
	event_id_init (&_tmp13_->event_id, sqlite3_last_insert_rowid (_tmp14_));
	_tmp15_ = row;
	_g_free0 (_tmp15_->name);
	_tmp15_->name = NULL;
	_tmp16_ = row;
	_tmp17_ = g_strdup (primary_source_id);
	_g_free0 (_tmp16_->primary_source_id);
	_tmp16_->primary_source_id = _tmp17_;
	_tmp18_ = row;
	_tmp18_->time_created = time_created;
	_tmp19_ = row;
	_tmp20_ = g_strdup (comment);
	_g_free0 (_tmp19_->comment);
	_tmp19_->comment = _tmp20_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
event_table_create_from_row (EventTable* self,
                             EventRow* row,
                             EventID* result)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GDestroyNotify _tmp11_;
	sqlite3_stmt* _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GDestroyNotify _tmp16_;
	sqlite3_stmt* _tmp17_;
	sqlite3* _tmp19_;
	EventID _tmp20_ = {0};
	g_return_if_fail (IS_EVENT_TABLE (self));
	g_return_if_fail (IS_EVENT_ROW (row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO EventTable (name, primary_photo_id, primary_source_id, tim" \
"e_created, comment) VALUES (?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = row->name;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int64 (_tmp7_, 2, PHOTO_ID_INVALID);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	_tmp9_ = row->primary_source_id;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_free;
	res = sqlite3_bind_text (_tmp8_, 3, _tmp10_, -1, _tmp11_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	res = sqlite3_bind_int64 (_tmp12_, 4, row->time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp13_ = stmt;
	_tmp14_ = row->comment;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = g_free;
	res = sqlite3_bind_text (_tmp13_, 5, _tmp15_, -1, _tmp16_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp17_ = stmt;
	res = sqlite3_step (_tmp17_);
	if (res != SQLITE_DONE) {
		EventID _tmp18_ = {0};
		database_table_fatal ("Event create_from_row", res);
		event_id_init (&_tmp18_, EVENT_ID_INVALID);
		*result = _tmp18_;
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp19_ = database_table_db;
	event_id_init (&_tmp20_, sqlite3_last_insert_rowid (_tmp19_));
	*result = _tmp20_;
	_sqlite3_finalize0 (stmt);
	return;
}

EventRow*
event_table_get_row (EventTable* self,
                     EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventID _tmp4_;
	sqlite3_stmt* _tmp5_;
	EventRow* row = NULL;
	EventRow* _tmp6_;
	EventRow* _tmp7_;
	EventID _tmp8_;
	EventRow* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	EventRow* _tmp14_;
	const gchar* _tmp15_;
	EventRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	sqlite3_stmt* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	EventRow* _tmp26_;
	sqlite3_stmt* _tmp27_;
	EventRow* _tmp28_;
	sqlite3_stmt* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	EventRow* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, primary_photo_id, primary_source_id, time_created, commen" \
"t FROM EventTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *event_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	if (sqlite3_step (_tmp5_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp6_ = event_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *event_id;
	_tmp7_->event_id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = stmt;
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 0);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp9_->name);
	_tmp9_->name = _tmp12_;
	_tmp14_ = row;
	_tmp15_ = _tmp14_->name;
	if (_tmp15_ != NULL) {
		EventRow* _tmp16_;
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp16_ = row;
		_tmp17_ = _tmp16_->name;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		EventRow* _tmp20_;
		_tmp20_ = row;
		_g_free0 (_tmp20_->name);
		_tmp20_->name = NULL;
	}
	_tmp21_ = row;
	_tmp22_ = stmt;
	_tmp23_ = stmt;
	_tmp24_ = (const gchar*) sqlite3_column_text (_tmp23_, 2);
	_tmp25_ = event_table_source_id_upgrade (self, sqlite3_column_int64 (_tmp22_, 1), _tmp24_);
	_g_free0 (_tmp21_->primary_source_id);
	_tmp21_->primary_source_id = _tmp25_;
	_tmp26_ = row;
	_tmp27_ = stmt;
	_tmp26_->time_created = sqlite3_column_int64 (_tmp27_, 3);
	_tmp28_ = row;
	_tmp29_ = stmt;
	_tmp30_ = (const gchar*) sqlite3_column_text (_tmp29_, 4);
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp28_->comment);
	_tmp28_->comment = _tmp31_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
event_table_remove (EventTable* self,
                    EventID* event_id,
                    GError** error)
{
	EventID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_EVENT_TABLE (self));
	g_return_if_fail (event_id != NULL);
	_tmp0_ = *event_id;
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeArrayList*
event_table_get_events (EventTable* self)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeArrayList* event_rows = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, primary_photo_id, primary_source_id, time_created, co" \
"mment FROM EventTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_EVENT_ROW, (GBoxedCopyFunc) event_row_ref, (GDestroyNotify) event_row_unref, NULL, NULL, NULL);
	event_rows = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			EventRow* row = NULL;
			EventRow* _tmp6_;
			EventRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			EventRow* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			EventRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			sqlite3_stmt* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			EventRow* _tmp18_;
			sqlite3_stmt* _tmp19_;
			EventRow* _tmp20_;
			sqlite3_stmt* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			GeeArrayList* _tmp24_;
			EventRow* _tmp25_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_events", res);
					break;
				}
			}
			_tmp6_ = event_row_new ();
			row = _tmp6_;
			_tmp7_ = row;
			_tmp8_ = stmt;
			event_id_init (&_tmp7_->event_id, sqlite3_column_int64 (_tmp8_, 0));
			_tmp9_ = row;
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp9_->name);
			_tmp9_->name = _tmp12_;
			_tmp13_ = row;
			_tmp14_ = stmt;
			_tmp15_ = stmt;
			_tmp16_ = (const gchar*) sqlite3_column_text (_tmp15_, 3);
			_tmp17_ = event_table_source_id_upgrade (self, sqlite3_column_int64 (_tmp14_, 2), _tmp16_);
			_g_free0 (_tmp13_->primary_source_id);
			_tmp13_->primary_source_id = _tmp17_;
			_tmp18_ = row;
			_tmp19_ = stmt;
			_tmp18_->time_created = sqlite3_column_int64 (_tmp19_, 4);
			_tmp20_ = row;
			_tmp21_ = stmt;
			_tmp22_ = (const gchar*) sqlite3_column_text (_tmp21_, 5);
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (_tmp20_->comment);
			_tmp20_->comment = _tmp23_;
			_tmp24_ = event_rows;
			_tmp25_ = row;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp25_);
			_event_row_unref0 (row);
		}
	}
	result = event_rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_rename (EventTable* self,
                    EventID* event_id,
                    const gchar* name)
{
	const gchar* _tmp0_ = NULL;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	if (name != NULL) {
		_tmp0_ = name;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *event_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "name", _tmp0_);
	return result;
}

gchar*
event_table_get_name (EventTable* self,
                      EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* name = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "name", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	name = _tmp5_;
	_tmp8_ = name;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = name;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp12_;
		_tmp12_ = name;
		_tmp6_ = _tmp12_;
	} else {
		_tmp6_ = NULL;
	}
	_tmp13_ = g_strdup (_tmp6_);
	result = _tmp13_;
	_g_free0 (name);
	_sqlite3_finalize0 (stmt);
	return result;
}

gchar*
event_table_get_primary_source_id (EventTable* self,
                                   EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "primary_source_id", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_set_primary_source_id (EventTable* self,
                                   EventID* event_id,
                                   const gchar* primary_source_id)
{
	EventID _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	g_return_val_if_fail (primary_source_id != NULL, FALSE);
	_tmp0_ = *event_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "primary_source_id", primary_source_id);
	return result;
}

GDateTime*
event_table_get_time_created (EventTable* self,
                              EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	sqlite3_stmt* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "time_created", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = g_date_time_new_from_unix_utc (sqlite3_column_int64 (_tmp3_, 0));
	result = _tmp4_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_set_comment (EventTable* self,
                         EventID* event_id,
                         const gchar* new_comment)
{
	const gchar* _tmp0_ = NULL;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	g_return_val_if_fail (new_comment != NULL, FALSE);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *event_id;
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, "comment", _tmp0_);
	return result;
}

static void
event_table_class_init (EventTableClass * klass,
                        gpointer klass_data)
{
	event_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = event_table_finalize;
}

static void
event_table_instance_init (EventTable * self,
                           gpointer klass)
{
}

static void
event_table_finalize (DatabaseTable * obj)
{
	EventTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_TABLE, EventTable);
	DATABASE_TABLE_CLASS (event_table_parent_class)->finalize (obj);
}

static GType
event_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventTable), 0, (GInstanceInitFunc) event_table_instance_init, NULL };
	GType event_table_type_id;
	event_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "EventTable", &g_define_type_info, 0);
	return event_table_type_id;
}

GType
event_table_get_type (void)
{
	static volatile gsize event_table_type_id__once = 0;
	if (g_once_init_enter (&event_table_type_id__once)) {
		GType event_table_type_id;
		event_table_type_id = event_table_get_type_once ();
		g_once_init_leave (&event_table_type_id__once, event_table_type_id);
	}
	return event_table_type_id__once;
}

