/* DatabaseTable.c generated by valac 0.56.17, the Vala compiler
 * generated from DatabaseTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define DATABASE_TABLE_SCHEMA_VERSION 24
#define DB_IN_MEMORY_NAME ":memory:"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATABASE_ERROR (database_error_get_type ())

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef void (*SqliteTraceCallback) (gpointer user_data, const gchar* message);
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _ParamSpecDatabaseTable ParamSpecDatabaseTable;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ParamSpecDatabaseTable {
	GParamSpec parent_instance;
};

static gpointer database_table_parent_class = NULL;
VALA_EXTERN sqlite3* database_table_db;
sqlite3* database_table_db = NULL;
static gint database_table_in_transaction;
static gint database_table_in_transaction = 0;

VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
static void database_table_prepare_db (const gchar* filename);
VALA_EXTERN void app_window_panic (const gchar* msg);
VALA_EXTERN void database_table_on_trace (const gchar* message);
static void _database_table_on_trace_sqlite_trace_callback (gpointer self,
                                                     const gchar* message);
VALA_EXTERN void database_table_init (const gchar* filename);
VALA_EXTERN void database_table_warning (const gchar* op,
                             gint res);
VALA_EXTERN void database_table_terminate (void);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN gboolean database_table_exists_by_id (DatabaseTable* self,
                                      gint64 id);
VALA_EXTERN gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt** stmt);
static void database_table_prepare_update_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          sqlite3_stmt** stmt);
static gboolean database_table_execute_update_by_id (DatabaseTable* self,
                                              sqlite3_stmt* stmt);
VALA_EXTERN gboolean database_table_update_text_by_id (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           const gchar* text);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
VALA_EXTERN gboolean database_table_update_int_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint value);
VALA_EXTERN void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
VALA_EXTERN gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
VALA_EXTERN void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
VALA_EXTERN void database_table_update_double_by_id_2 (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           gdouble value,
                                           GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN gboolean database_table_has_column (const gchar* table_name,
                                    const gchar* column_name);
VALA_EXTERN gboolean database_table_has_table (const gchar* table_name);
VALA_EXTERN gboolean database_table_add_column (const gchar* table_name,
                                    const gchar* column_name,
                                    const gchar* column_constraints);
VALA_EXTERN gboolean database_table_ensure_column (const gchar* table_name,
                                       const gchar* column_name,
                                       const gchar* column_constraints,
                                       const gchar* upgrade_msg);
VALA_EXTERN gint database_table_get_row_count (DatabaseTable* self);
VALA_EXTERN void database_table_begin_transaction (void);
VALA_EXTERN void database_table_commit_transaction (GError** error);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
static void database_table_finalize (DatabaseTable * obj);
static GType database_table_get_type_once (void);

GQuark
database_error_quark (void)
{
	return g_quark_from_static_string ("database-error-quark");
}

static GType
database_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DATABASE_ERROR_ERROR, "DATABASE_ERROR_ERROR", "error"}, {DATABASE_ERROR_BACKING, "DATABASE_ERROR_BACKING", "backing"}, {DATABASE_ERROR_MEMORY, "DATABASE_ERROR_MEMORY", "memory"}, {DATABASE_ERROR_ABORT, "DATABASE_ERROR_ABORT", "abort"}, {DATABASE_ERROR_LIMITS, "DATABASE_ERROR_LIMITS", "limits"}, {DATABASE_ERROR_TYPESPEC, "DATABASE_ERROR_TYPESPEC", "typespec"}, {0, NULL, NULL}};
	GType database_error_type_id;
	database_error_type_id = g_enum_register_static ("DatabaseError", values);
	return database_error_type_id;
}

GType
database_error_get_type (void)
{
	static volatile gsize database_error_type_id__once = 0;
	if (g_once_init_enter (&database_error_type_id__once)) {
		GType database_error_type_id;
		database_error_type_id = database_error_get_type_once ();
		g_once_init_leave (&database_error_type_id__once, database_error_type_id);
	}
	return database_error_type_id__once;
}

static void
_database_table_on_trace_sqlite_trace_callback (gpointer self,
                                                const gchar* message)
{
	database_table_on_trace (message);
}

static void
database_table_prepare_db (const gchar* filename)
{
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* sql_debug = NULL;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp1_ = sqlite3_open_v2 (filename, &_tmp0_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (database_table_db);
	database_table_db = _tmp0_;
	res = _tmp1_;
	if (res != SQLITE_OK) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf (_ ("Unable to open/create photo database %s: error code %d"), filename, res);
		_tmp3_ = _tmp2_;
		app_window_panic (_tmp3_);
		_g_free0 (_tmp3_);
	}
	if (g_strcmp0 (filename, DB_IN_MEMORY_NAME) != 0) {
		{
			GFile* file_db = NULL;
			GFile* _tmp4_;
			GFileInfo* info = NULL;
			GFile* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			_tmp4_ = g_file_new_for_path (filename);
			file_db = _tmp4_;
			_tmp5_ = file_db;
			_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_db);
				goto __catch0_g_error;
			}
			_tmp7_ = info;
			if (!g_file_info_get_attribute_boolean (_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE)) {
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = g_strdup_printf (_ ("Unable to write to photo database file:\n %s"), filename);
				_tmp9_ = _tmp8_;
				app_window_panic (_tmp9_);
				_g_free0 (_tmp9_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (file_db);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			_tmp12_ = g_strdup_printf (_ ("Error accessing database file:\n %s\n\nError was: \n%s"), filename, _tmp11_);
			_tmp13_ = _tmp12_;
			app_window_panic (_tmp13_);
			_g_free0 (_tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = g_getenv ("SHOTWELL_SQL_DEBUG");
	sql_debug = _tmp14_;
	_tmp16_ = sql_debug;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = sql_debug;
		_tmp15_ = g_strcmp0 (_tmp17_, "") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		sqlite3* _tmp18_;
		_tmp18_ = database_table_db;
		sqlite3_trace (_tmp18_, _database_table_on_trace_sqlite_trace_callback, NULL);
	}
}

void
database_table_on_trace (const gchar* message)
{
	g_return_if_fail (message != NULL);
	g_debug ("DatabaseTable.vala:62: SQLITE: %s", message);
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
database_table_init (const gchar* filename)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	database_table_prepare_db (filename);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	if (res != SQLITE_OK) {
		gchar* backup_path = NULL;
		gchar* _tmp3_;
		_sqlite3_close0 (database_table_db);
		database_table_db = NULL;
		_tmp3_ = g_strconcat (filename, ".bak", NULL);
		backup_path = _tmp3_;
		{
			GFile* src = NULL;
			const gchar* _tmp4_;
			GFile* _tmp5_;
			GFile* dest = NULL;
			GFile* _tmp6_;
			GFile* _tmp7_;
			GFile* _tmp8_;
			_tmp4_ = backup_path;
			_tmp5_ = g_file_new_for_commandline_arg (_tmp4_);
			src = _tmp5_;
			_tmp6_ = g_file_new_for_commandline_arg (filename);
			dest = _tmp6_;
			_tmp7_ = src;
			_tmp8_ = dest;
			g_file_copy (_tmp7_, _tmp8_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dest);
				_g_object_unref0 (src);
				goto __catch0_g_error;
			}
			database_table_prepare_db (filename);
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = _error_;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup_printf (_ ("Unable to restore photo database %s"), _tmp10_);
			_tmp12_ = _tmp11_;
			app_window_panic (_tmp12_);
			_g_free0 (_tmp12_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (backup_path);
			_sqlite3_finalize0 (stmt);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (backup_path);
	}
	_tmp13_ = database_table_db;
	res = _sqlite3_exec (_tmp13_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
	if (res != SQLITE_OK) {
		database_table_warning ("Unable to disable synchronous mode", res);
	}
	_sqlite3_finalize0 (stmt);
}

void
database_table_terminate (void)
{
	_sqlite3_close0 (database_table_db);
	database_table_db = NULL;
}

void
database_table_fatal (const gchar* op,
                      gint res)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (op != NULL);
	_tmp0_ = database_table_db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	g_error ("DatabaseTable.vala:110: %s: [%d] %s", op, res, _tmp1_);
}

void
database_table_warning (const gchar* op,
                        gint res)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (op != NULL);
	_tmp0_ = database_table_db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	g_warning ("DatabaseTable.vala:115: %s: [%d] %s", op, res, _tmp1_);
}

void
database_table_set_table_name (DatabaseTable* self,
                               const gchar* table_name)
{
	gchar* _tmp0_;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (table_name != NULL);
	_tmp0_ = g_strdup (table_name);
	_g_free0 (self->table_name);
	self->table_name = _tmp0_;
}

void
database_table_throw_error (const gchar* method,
                            gint res,
                            GError** error)
{
	gchar* msg = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (method != NULL);
	_tmp0_ = database_table_db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	_tmp2_ = g_strdup_printf ("(%s) [%d] - %s", method, res, _tmp1_);
	msg = _tmp2_;
	switch (res) {
		case SQLITE_OK:
		case SQLITE_DONE:
		case SQLITE_ROW:
		{
			_g_free0 (msg);
			return;
		}
		case SQLITE_PERM:
		case SQLITE_BUSY:
		case SQLITE_READONLY:
		case SQLITE_IOERR:
		case SQLITE_CORRUPT:
		case SQLITE_CANTOPEN:
		case SQLITE_NOLFS:
		case SQLITE_AUTH:
		case SQLITE_FORMAT:
		case SQLITE_NOTADB:
		{
			const gchar* _tmp3_;
			GError* _tmp4_;
			_tmp3_ = msg;
			_tmp4_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_BACKING, _tmp3_);
			_inner_error0_ = _tmp4_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case SQLITE_NOMEM:
		{
			const gchar* _tmp5_;
			GError* _tmp6_;
			_tmp5_ = msg;
			_tmp6_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_MEMORY, _tmp5_);
			_inner_error0_ = _tmp6_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case SQLITE_ABORT:
		case SQLITE_LOCKED:
		case SQLITE_INTERRUPT:
		{
			const gchar* _tmp7_;
			GError* _tmp8_;
			_tmp7_ = msg;
			_tmp8_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ABORT, _tmp7_);
			_inner_error0_ = _tmp8_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case SQLITE_FULL:
		case SQLITE_EMPTY:
		case SQLITE_TOOBIG:
		case SQLITE_CONSTRAINT:
		case SQLITE_RANGE:
		{
			const gchar* _tmp9_;
			GError* _tmp10_;
			_tmp9_ = msg;
			_tmp10_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_LIMITS, _tmp9_);
			_inner_error0_ = _tmp10_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case SQLITE_SCHEMA:
		case SQLITE_MISMATCH:
		{
			const gchar* _tmp11_;
			GError* _tmp12_;
			_tmp11_ = msg;
			_tmp12_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_TYPESPEC, _tmp11_);
			_inner_error0_ = _tmp12_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		default:
		case SQLITE_ERROR:
		case SQLITE_INTERNAL:
		case SQLITE_MISUSE:
		{
			const gchar* _tmp13_;
			GError* _tmp14_;
			_tmp13_ = msg;
			_tmp14_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ERROR, _tmp13_);
			_inner_error0_ = _tmp14_;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

gboolean
database_table_exists_by_id (DatabaseTable* self,
                             gint64 id)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	_tmp0_ = database_table_db;
	_tmp1_ = self->table_name;
	_tmp2_ = g_strdup_printf ("SELECT id FROM %s WHERE id=?", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	res = _tmp6_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int64 (_tmp7_, 1, id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_ROW) {
		_tmp9_ = res != SQLITE_DONE;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->table_name;
		_tmp13_ = g_strdup_printf ("exists_by_id [%s] %s", _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		database_table_fatal (_tmp14_, res);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp11_);
	}
	result = res == SQLITE_ROW;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
database_table_select_by_id (DatabaseTable* self,
                             gint64 id,
                             const gchar* columns,
                             sqlite3_stmt** stmt)
{
	sqlite3_stmt* _vala_stmt = NULL;
	gchar* sql = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint res = 0;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	g_return_val_if_fail (columns != NULL, FALSE);
	_tmp0_ = self->table_name;
	_tmp1_ = g_strdup_printf ("SELECT %s FROM %s WHERE id=?", columns, _tmp0_);
	sql = _tmp1_;
	_tmp2_ = database_table_db;
	_tmp3_ = sql;
	_tmp5_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (_vala_stmt);
	_vala_stmt = _tmp4_;
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = _vala_stmt;
	res = sqlite3_bind_int64 (_tmp6_, 1, id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = _vala_stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_ROW) {
		_tmp8_ = res != SQLITE_DONE;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->table_name;
		_tmp12_ = g_strdup_printf ("select_by_id [%s] %s %s", _tmp10_, _tmp11_, columns);
		_tmp13_ = _tmp12_;
		database_table_fatal (_tmp13_, res);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
	}
	result = res == SQLITE_ROW;
	_g_free0 (sql);
	if (stmt) {
		*stmt = _vala_stmt;
	} else {
		_sqlite3_finalize0 (_vala_stmt);
	}
	return result;
}

static void
database_table_prepare_update_by_id (DatabaseTable* self,
                                     gint64 id,
                                     const gchar* column,
                                     sqlite3_stmt** stmt)
{
	sqlite3_stmt* _vala_stmt = NULL;
	gchar* sql = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint res = 0;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (column != NULL);
	_tmp0_ = self->table_name;
	_tmp1_ = g_strdup_printf ("UPDATE %s SET %s=? WHERE id=?", _tmp0_, column);
	sql = _tmp1_;
	_tmp2_ = database_table_db;
	_tmp4_ = sqlite3_prepare_v2 (_tmp2_, sql, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (_vala_stmt);
	_vala_stmt = _tmp3_;
	res = _tmp4_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	res = sqlite3_bind_int64 (_vala_stmt, 2, id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_g_free0 (sql);
	if (stmt) {
		*stmt = _vala_stmt;
	} else {
		_sqlite3_finalize0 (_vala_stmt);
	}
}

static gboolean
database_table_execute_update_by_id (DatabaseTable* self,
                                     sqlite3_stmt* stmt)
{
	gint res = 0;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	g_return_val_if_fail (stmt != NULL, FALSE);
	res = sqlite3_step (stmt);
	if (res != SQLITE_DONE) {
		database_table_fatal ("execute_update_by_id", res);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
database_table_update_text_by_id (DatabaseTable* self,
                                  gint64 id,
                                  const gchar* column,
                                  const gchar* text)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gchar* _tmp1_;
	GDestroyNotify _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	g_return_val_if_fail (column != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	_tmp1_ = g_strdup (text);
	_tmp2_ = g_free;
	res = sqlite3_bind_text (stmt, 1, _tmp1_, -1, _tmp2_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	result = database_table_execute_update_by_id (self, stmt);
	_sqlite3_finalize0 (stmt);
	return result;
}

void
database_table_update_text_by_id_2 (DatabaseTable* self,
                                    gint64 id,
                                    const gchar* column,
                                    const gchar* text,
                                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	GDestroyNotify _tmp3_;
	sqlite3_stmt* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (column != NULL);
	g_return_if_fail (text != NULL);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = g_strdup (text);
	_tmp3_ = g_free;
	res = sqlite3_bind_text (_tmp1_, 1, _tmp2_, -1, _tmp3_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res != SQLITE_DONE) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->table_name;
		_tmp6_ = g_strdup_printf ("DatabaseTable.update_text_by_id_2 %s.%s", _tmp5_, column);
		_tmp7_ = _tmp6_;
		database_table_throw_error (_tmp7_, res, &_inner_error0_);
		_g_free0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

gboolean
database_table_update_int_by_id (DatabaseTable* self,
                                 gint64 id,
                                 const gchar* column,
                                 gint value)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	g_return_val_if_fail (column != NULL, FALSE);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	res = sqlite3_bind_int (stmt, 1, value);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	result = database_table_execute_update_by_id (self, stmt);
	_sqlite3_finalize0 (stmt);
	return result;
}

void
database_table_update_int_by_id_2 (DatabaseTable* self,
                                   gint64 id,
                                   const gchar* column,
                                   gint value,
                                   GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (column != NULL);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_bind_int (_tmp1_, 1, value);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	if (res != SQLITE_DONE) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->table_name;
		_tmp4_ = g_strdup_printf ("DatabaseTable.update_int_by_id_2 %s.%s", _tmp3_, column);
		_tmp5_ = _tmp4_;
		database_table_throw_error (_tmp5_, res, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

gboolean
database_table_update_int64_by_id (DatabaseTable* self,
                                   gint64 id,
                                   const gchar* column,
                                   gint64 value)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gboolean result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
	g_return_val_if_fail (column != NULL, FALSE);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	res = sqlite3_bind_int64 (stmt, 1, value);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	result = database_table_execute_update_by_id (self, stmt);
	_sqlite3_finalize0 (stmt);
	return result;
}

void
database_table_update_int64_by_id_2 (DatabaseTable* self,
                                     gint64 id,
                                     const gchar* column,
                                     gint64 value,
                                     GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (column != NULL);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_bind_int64 (_tmp1_, 1, value);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	if (res != SQLITE_DONE) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->table_name;
		_tmp4_ = g_strdup_printf ("DatabaseTable.update_int64_by_id_2 %s.%s", _tmp3_, column);
		_tmp5_ = _tmp4_;
		database_table_throw_error (_tmp5_, res, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
database_table_update_double_by_id_2 (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* column,
                                      gdouble value,
                                      GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	g_return_if_fail (column != NULL);
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_bind_double (_tmp1_, 1, value);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	if (res != SQLITE_DONE) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->table_name;
		_tmp4_ = g_strdup_printf ("DatabaseTable.update_double_by_id_2 %s.%s", _tmp3_, column);
		_tmp5_ = _tmp4_;
		database_table_throw_error (_tmp5_, res, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
database_table_delete_by_id (DatabaseTable* self,
                             gint64 id,
                             GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_DATABASE_TABLE (self));
	_tmp0_ = database_table_db;
	_tmp1_ = self->table_name;
	_tmp2_ = g_strdup_printf ("DELETE FROM %s WHERE id=?", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	res = _tmp6_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int64 (_tmp7_, 1, id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_DONE) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->table_name;
		_tmp10_ = g_strdup_printf ("%s.remove", _tmp9_);
		_tmp11_ = _tmp10_;
		database_table_throw_error (_tmp11_, res, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

gboolean
database_table_has_column (const gchar* table_name,
                           const gchar* column_name)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (table_name != NULL, FALSE);
	g_return_val_if_fail (column_name != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp1_ = g_strdup_printf ("PRAGMA table_info(%s)", table_name);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp7_;
			if (!_tmp6_) {
			}
			_tmp6_ = FALSE;
			_tmp7_ = stmt;
			res = sqlite3_step (_tmp7_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = g_strdup_printf ("has_column %s", table_name);
					_tmp9_ = _tmp8_;
					database_table_fatal (_tmp9_, res);
					_g_free0 (_tmp9_);
					break;
				} else {
					gchar* column = NULL;
					sqlite3_stmt* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_;
					_tmp10_ = stmt;
					_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
					_tmp12_ = g_strdup (_tmp11_);
					column = _tmp12_;
					_tmp14_ = column;
					if (_tmp14_ != NULL) {
						const gchar* _tmp15_;
						_tmp15_ = column;
						_tmp13_ = g_strcmp0 (_tmp15_, column_name) == 0;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						result = TRUE;
						_g_free0 (column);
						_sqlite3_finalize0 (stmt);
						return result;
					}
					_g_free0 (column);
				}
			}
		}
	}
	result = FALSE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
database_table_has_table (const gchar* table_name)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (table_name != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp1_ = g_strdup_printf ("PRAGMA table_info(%s)", table_name);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	res = sqlite3_step (stmt);
	result = res != SQLITE_DONE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
database_table_add_column (const gchar* table_name,
                           const gchar* column_name,
                           const gchar* column_constraints)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
	g_return_val_if_fail (table_name != NULL, FALSE);
	g_return_val_if_fail (column_name != NULL, FALSE);
	g_return_val_if_fail (column_constraints != NULL, FALSE);
	_tmp0_ = database_table_db;
	_tmp1_ = g_strdup_printf ("ALTER TABLE %s ADD COLUMN %s %s", table_name, column_name, column_constraints);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		sqlite3* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = database_table_db;
		_tmp8_ = sqlite3_errmsg (_tmp7_);
		g_critical ("DatabaseTable.vala:357: Unable to add column %s %s %s: (%d) %s", table_name, column_name, column_constraints, res, _tmp8_);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
database_table_ensure_column (const gchar* table_name,
                              const gchar* column_name,
                              const gchar* column_constraints,
                              const gchar* upgrade_msg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (table_name != NULL, FALSE);
	g_return_val_if_fail (column_name != NULL, FALSE);
	g_return_val_if_fail (column_constraints != NULL, FALSE);
	g_return_val_if_fail (upgrade_msg != NULL, FALSE);
	if (!database_table_has_table (table_name)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = database_table_has_column (table_name, column_name);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	g_message ("DatabaseTable.vala:374: %s", upgrade_msg);
	result = database_table_add_column (table_name, column_name, column_constraints);
	return result;
}

gint
database_table_get_row_count (DatabaseTable* self)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp11_;
	gint result;
	g_return_val_if_fail (IS_DATABASE_TABLE (self), 0);
	_tmp0_ = database_table_db;
	_tmp1_ = self->table_name;
	_tmp2_ = g_strdup_printf ("SELECT COUNT(id) AS RowCount FROM %s", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	res = _tmp6_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_ROW) {
		const gchar* _tmp8_;
		sqlite3* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = self->table_name;
		_tmp9_ = database_table_db;
		_tmp10_ = sqlite3_errmsg (_tmp9_);
		g_critical ("DatabaseTable.vala:386: Unable to retrieve row count on %s: (%d) %s", _tmp8_, res, _tmp10_);
		result = 0;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp11_ = stmt;
	result = sqlite3_column_int (_tmp11_, 0);
	_sqlite3_finalize0 (stmt);
	return result;
}

void
database_table_begin_transaction (void)
{
	gint _tmp0_;
	gint res = 0;
	sqlite3* _tmp1_;
	_tmp0_ = database_table_in_transaction;
	database_table_in_transaction = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
	_tmp1_ = database_table_db;
	res = _sqlite3_exec (_tmp1_, "BEGIN TRANSACTION", NULL, NULL, NULL);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
}

void
database_table_commit_transaction (GError** error)
{
	gint _tmp0_;
	gint res = 0;
	sqlite3* _tmp1_;
	GError* _inner_error0_ = NULL;
	_vala_assert (database_table_in_transaction > 0, "in_transaction > 0");
	database_table_in_transaction = database_table_in_transaction - 1;
	_tmp0_ = database_table_in_transaction;
	if (_tmp0_ != 0) {
		return;
	}
	_tmp1_ = database_table_db;
	res = _sqlite3_exec (_tmp1_, "COMMIT TRANSACTION", NULL, NULL, NULL);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("commit_transaction", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

DatabaseTable*
database_table_construct (GType object_type)
{
	DatabaseTable* self = NULL;
	self = (DatabaseTable*) g_type_create_instance (object_type);
	return self;
}

static void
value_database_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_database_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		database_table_unref (value->data[0].v_pointer);
	}
}

static void
value_database_table_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = database_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_database_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_database_table_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DatabaseTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = database_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_database_table_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	DatabaseTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = database_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_database_table (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecDatabaseTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATABASE_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_database_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_database_table (GValue* value,
                          gpointer v_object)
{
	DatabaseTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		database_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		database_table_unref (old);
	}
}

void
value_take_database_table (GValue* value,
                           gpointer v_object)
{
	DatabaseTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		database_table_unref (old);
	}
}

static void
database_table_class_init (DatabaseTableClass * klass,
                           gpointer klass_data)
{
	database_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = database_table_finalize;
}

static void
database_table_instance_init (DatabaseTable * self,
                              gpointer klass)
{
	self->table_name = NULL;
	self->ref_count = 1;
}

static void
database_table_finalize (DatabaseTable * obj)
{
	DatabaseTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_TABLE, DatabaseTable);
	g_signal_handlers_destroy (self);
	_g_free0 (self->table_name);
}

static GType
database_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_database_table_init, value_database_table_free_value, value_database_table_copy_value, value_database_table_peek_pointer, "p", value_database_table_collect_value, "p", value_database_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DatabaseTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseTable), 0, (GInstanceInitFunc) database_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType database_table_type_id;
	database_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DatabaseTable", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return database_table_type_id;
}

GType
database_table_get_type (void)
{
	static volatile gsize database_table_type_id__once = 0;
	if (g_once_init_enter (&database_table_type_id__once)) {
		GType database_table_type_id;
		database_table_type_id = database_table_get_type_once ();
		g_once_init_leave (&database_table_type_id__once, database_table_type_id);
	}
	return database_table_type_id__once;
}

gpointer
database_table_ref (gpointer instance)
{
	DatabaseTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
database_table_unref (gpointer instance)
{
	DatabaseTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DATABASE_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

