/* SourceInterfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from SourceInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* See the note in MediaInterfaces.vala for some thoughts on the theory of expanding Shotwell's*/
/* features via interfaces rather than class hierarchies.*/
/* Indexable DataSources provide raw strings that may be searched against (and, in the future,*/
/* indexed) for free-text search queries.  DataSources implementing Indexable must prepare and*/
/* store (i.e. cache) these strings using prepare_indexable_string(s), as preparing the strings*/
/* for each call is expensive.*/
/**/
/* When the indexable string has changed, the object should fire an alteration of*/
/* "indexable:keywords".  The prepare methods will not do this.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_POSITIONABLE (positionable_get_type ())
#define POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITIONABLE, Positionable))
#define IS_POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITIONABLE))
#define POSITIONABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POSITIONABLE, PositionableIface))

typedef struct _Positionable Positionable;
typedef struct _PositionableIface PositionableIface;

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _PositionableIface {
	GTypeInterface parent_iface;
	void (*get_gps_coords) (Positionable* self, GpsCoords* result);
	void (*set_gps_coords) (Positionable* self, GpsCoords* gps_coords);
};

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN const gchar* indexable_get_indexable_keywords (Indexable* self);
VALA_EXTERN gchar* indexable_prepare_indexable_string (const gchar* str);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN gchar* string_remove_diacritics (const gchar* istring);
VALA_EXTERN gchar* indexable_prepare_indexable_strings (gchar** strs,
                                            gint strs_length1);
static GType indexable_get_type_once (void);
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN gboolean gps_coords_equals (GpsCoords *self,
                            GpsCoords* gps);
VALA_EXTERN GType positionable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Positionable, g_object_unref)
VALA_EXTERN void positionable_get_gps_coords (Positionable* self,
                                  GpsCoords* result);
VALA_EXTERN void positionable_set_gps_coords (Positionable* self,
                                  GpsCoords* gps_coords);
static GType positionable_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar*
indexable_get_indexable_keywords (Indexable* self)
{
	IndexableIface* _iface_;
	g_return_val_if_fail (IS_INDEXABLE (self), NULL);
	_iface_ = INDEXABLE_GET_INTERFACE (self);
	if (_iface_->get_indexable_keywords) {
		return _iface_->get_indexable_keywords (self);
	}
	return NULL;
}

gchar*
indexable_prepare_indexable_string (const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	if (is_string_empty (str)) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_utf8_strdown (str, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_remove_diacritics (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
indexable_prepare_indexable_strings (gchar** strs,
                                     gint strs_length1)
{
	gboolean _tmp0_ = FALSE;
	GString* builder = NULL;
	GString* _tmp1_;
	gint ctr = 0;
	const gchar* _tmp10_ = NULL;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp15_;
	gchar* result;
	if (strs == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = strs_length1 == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	ctr = 0;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			if (!_tmp2_) {
				gint _tmp3_;
				ctr = ctr + 1;
				_tmp3_ = ctr;
				if (!(_tmp3_ < strs_length1)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = strs[ctr];
			if (!is_string_empty (_tmp4_)) {
				GString* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp5_ = builder;
				_tmp6_ = strs[ctr];
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				_tmp8_ = _tmp7_;
				g_string_append (_tmp5_, _tmp8_);
				_g_free0 (_tmp8_);
				if (ctr < (strs_length1 - 1)) {
					GString* _tmp9_;
					_tmp9_ = builder;
					g_string_append_c (_tmp9_, ' ');
				}
			}
		}
	}
	_tmp11_ = builder;
	_tmp12_ = _tmp11_->str;
	if (!is_string_empty (_tmp12_)) {
		GString* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = builder;
		_tmp14_ = _tmp13_->str;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp15_ = g_strdup (_tmp10_);
	result = _tmp15_;
	_g_string_free0 (builder);
	return result;
}

static void
indexable_default_init (IndexableIface * iface,
                        gpointer iface_data)
{
}

static GType
indexable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IndexableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indexable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType indexable_type_id;
	indexable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Indexable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (indexable_type_id, TYPE_DATA_SOURCE);
	return indexable_type_id;
}

GType
indexable_get_type (void)
{
	static volatile gsize indexable_type_id__once = 0;
	if (g_once_init_enter (&indexable_type_id__once)) {
		GType indexable_type_id;
		indexable_type_id = indexable_get_type_once ();
		g_once_init_leave (&indexable_type_id__once, indexable_type_id);
	}
	return indexable_type_id__once;
}

gboolean
gps_coords_equals (GpsCoords *self,
                   GpsCoords* gps)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (gps != NULL, FALSE);
	if ((*self).has_gps == 0) {
		GpsCoords _tmp2_;
		_tmp2_ = *gps;
		_tmp1_ = _tmp2_.has_gps == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		GpsCoords _tmp4_;
		_tmp4_ = *gps;
		if ((*self).latitude == _tmp4_.latitude) {
			GpsCoords _tmp5_;
			_tmp5_ = *gps;
			_tmp3_ = (*self).longitude == _tmp5_.longitude;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

GpsCoords*
gps_coords_dup (const GpsCoords* self)
{
	GpsCoords* dup;
	dup = g_new0 (GpsCoords, 1);
	memcpy (dup, self, sizeof (GpsCoords));
	return dup;
}

void
gps_coords_free (GpsCoords* self)
{
	g_free (self);
}

static GType
gps_coords_get_type_once (void)
{
	GType gps_coords_type_id;
	gps_coords_type_id = g_boxed_type_register_static ("GpsCoords", (GBoxedCopyFunc) gps_coords_dup, (GBoxedFreeFunc) gps_coords_free);
	return gps_coords_type_id;
}

GType
gps_coords_get_type (void)
{
	static volatile gsize gps_coords_type_id__once = 0;
	if (g_once_init_enter (&gps_coords_type_id__once)) {
		GType gps_coords_type_id;
		gps_coords_type_id = gps_coords_get_type_once ();
		g_once_init_leave (&gps_coords_type_id__once, gps_coords_type_id);
	}
	return gps_coords_type_id__once;
}

void
positionable_get_gps_coords (Positionable* self,
                             GpsCoords* result)
{
	PositionableIface* _iface_;
	g_return_if_fail (IS_POSITIONABLE (self));
	_iface_ = POSITIONABLE_GET_INTERFACE (self);
	if (_iface_->get_gps_coords) {
		_iface_->get_gps_coords (self, result);
	}
}

void
positionable_set_gps_coords (Positionable* self,
                             GpsCoords* gps_coords)
{
	PositionableIface* _iface_;
	g_return_if_fail (IS_POSITIONABLE (self));
	_iface_ = POSITIONABLE_GET_INTERFACE (self);
	if (_iface_->set_gps_coords) {
		_iface_->set_gps_coords (self, gps_coords);
	}
}

static void
positionable_default_init (PositionableIface * iface,
                           gpointer iface_data)
{
}

static GType
positionable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PositionableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) positionable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType positionable_type_id;
	positionable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Positionable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (positionable_type_id, TYPE_DATA_SOURCE);
	return positionable_type_id;
}

GType
positionable_get_type (void)
{
	static volatile gsize positionable_type_id__once = 0;
	if (g_once_init_enter (&positionable_type_id__once)) {
		GType positionable_type_id;
		positionable_type_id = positionable_get_type_once ();
		g_once_init_leave (&positionable_type_id__once, positionable_type_id);
	}
	return positionable_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

