/* DataView.c generated by valac 0.56.17, the Vala compiler
 * generated from DataView.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
enum  {
	DATA_VIEW_0_PROPERTY,
	DATA_VIEW_NUM_PROPERTIES
};
static GParamSpec* data_view_properties[DATA_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
enum  {
	DATA_VIEW_STATE_CHANGED_SIGNAL,
	DATA_VIEW_VISIBILITY_CHANGED_SIGNAL,
	DATA_VIEW_VIEW_ALTERED_SIGNAL,
	DATA_VIEW_GEOMETRY_ALTERED_SIGNAL,
	DATA_VIEW_UNSUBSCRIBED_SIGNAL,
	DATA_VIEW_NUM_SIGNALS
};
static guint data_view_signals[DATA_VIEW_NUM_SIGNALS] = {0};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _DataViewPrivate {
	DataSource* source;
	gboolean selected;
	gboolean visible;
};

static gint DataView_private_offset;
static gpointer data_view_parent_class = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN void data_view_notify_view_altered (DataView* self);
VALA_EXTERN void data_view_notify_geometry_altered (DataView* self);
VALA_EXTERN void data_view_notify_unsubscribed (DataView* self,
                                    DataSource* source);
VALA_EXTERN void data_source_internal_unsubscribe (DataSource* self,
                                       DataView* view);
VALA_EXTERN DataView* data_view_new (DataSource* source);
VALA_EXTERN DataView* data_view_construct (GType object_type,
                               DataSource* source);
VALA_EXTERN DataObject* data_object_construct (GType object_type,
                                   gint64 object_id);
VALA_EXTERN void data_source_internal_subscribe (DataSource* self,
                                     DataView* view);
static gchar* data_view_real_get_name (DataObject* base);
static gchar* data_view_real_to_string (DataObject* base);
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN gboolean data_view_is_selected (DataView* self);
VALA_EXTERN void data_view_internal_set_selected (DataView* self,
                                      gboolean selected);
VALA_EXTERN gboolean data_view_internal_toggle (DataView* self);
VALA_EXTERN gboolean data_view_is_visible (DataView* self);
VALA_EXTERN void data_view_internal_set_visible (DataView* self,
                                     gboolean visible);
static void data_view_real_notify_view_altered (DataView* self);
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN DataCollection* data_object_get_membership (DataObject* self);
VALA_EXTERN gboolean data_collection_are_notifications_frozen (DataCollection* self);
VALA_EXTERN void view_collection_internal_notify_view_altered (ViewCollection* self,
                                                   DataView* view);
static void data_view_real_notify_geometry_altered (DataView* self);
VALA_EXTERN void view_collection_internal_notify_geometry_altered (ViewCollection* self,
                                                       DataView* view);
static void data_view_real_notify_unsubscribed (DataView* self,
                                         DataSource* source);
static void data_view_real_state_changed (DataView* self,
                                   gboolean selected);
static void data_view_real_visibility_changed (DataView* self,
                                        gboolean visible);
static void data_view_real_view_altered (DataView* self);
static void data_view_real_geometry_altered (DataView* self);
static void data_view_real_unsubscribed (DataView* self,
                                  DataSource* source);
static void data_view_finalize (GObject * obj);
static GType data_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
data_view_get_instance_private (DataView* self)
{
	return G_STRUCT_MEMBER_P (self, DataView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DataView*
data_view_construct (GType object_type,
                     DataSource* source)
{
	DataView * self = NULL;
	DataSource* _tmp0_;
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
	self = (DataView*) data_object_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	data_source_internal_subscribe (source, self);
	return self;
}

DataView*
data_view_new (DataSource* source)
{
	return data_view_construct (TYPE_DATA_VIEW, source);
}

static gchar*
data_view_real_get_name (DataObject* base)
{
	DataView * self;
	DataSource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_VIEW, DataView);
	_tmp0_ = self->priv->source;
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("View of %s", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gchar*
data_view_real_to_string (DataObject* base)
{
	DataView * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	DataSource* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_VIEW, DataView);
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->source;
	_tmp3_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("DataView %s [DataSource %s]", _tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	result = _tmp6_;
	return result;
}

DataSource*
data_view_get_source (DataView* self)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* result;
	g_return_val_if_fail (IS_DATA_VIEW (self), NULL);
	_tmp0_ = self->priv->source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
data_view_is_selected (DataView* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_VIEW (self), FALSE);
	result = self->priv->selected;
	return result;
}

void
data_view_internal_set_selected (DataView* self,
                                 gboolean selected)
{
	g_return_if_fail (IS_DATA_VIEW (self));
	if (self->priv->selected == selected) {
		return;
	}
	self->priv->selected = selected;
	g_signal_emit (self, data_view_signals[DATA_VIEW_STATE_CHANGED_SIGNAL], 0, selected);
}

gboolean
data_view_internal_toggle (DataView* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_VIEW (self), FALSE);
	self->priv->selected = !self->priv->selected;
	g_signal_emit (self, data_view_signals[DATA_VIEW_STATE_CHANGED_SIGNAL], 0, self->priv->selected);
	result = self->priv->selected;
	return result;
}

gboolean
data_view_is_visible (DataView* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_VIEW (self), FALSE);
	result = self->priv->visible;
	return result;
}

void
data_view_internal_set_visible (DataView* self,
                                gboolean visible)
{
	g_return_if_fail (IS_DATA_VIEW (self));
	if (self->priv->visible == visible) {
		return;
	}
	self->priv->visible = visible;
	g_signal_emit (self, data_view_signals[DATA_VIEW_VISIBILITY_CHANGED_SIGNAL], 0, visible);
}

static void
data_view_real_notify_view_altered (DataView* self)
{
	ViewCollection* vc = NULL;
	DataCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	if (!self->priv->visible) {
		return;
	}
	_tmp0_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = IS_VIEW_COLLECTION (_tmp0_) ? ((ViewCollection*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_data_collection_unref0 (_tmp0_);
	}
	vc = _tmp1_;
	_tmp2_ = vc;
	if (_tmp2_ != NULL) {
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		_tmp3_ = vc;
		if (!data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection))) {
			g_signal_emit (self, data_view_signals[DATA_VIEW_VIEW_ALTERED_SIGNAL], 0);
		}
		_tmp4_ = vc;
		view_collection_internal_notify_view_altered (_tmp4_, self);
	} else {
		g_signal_emit (self, data_view_signals[DATA_VIEW_VIEW_ALTERED_SIGNAL], 0);
	}
	_data_collection_unref0 (vc);
}

void
data_view_notify_view_altered (DataView* self)
{
	DataViewClass* _klass_;
	g_return_if_fail (IS_DATA_VIEW (self));
	_klass_ = DATA_VIEW_GET_CLASS (self);
	if (_klass_->notify_view_altered) {
		_klass_->notify_view_altered (self);
	}
}

static void
data_view_real_notify_geometry_altered (DataView* self)
{
	ViewCollection* vc = NULL;
	DataCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	if (!self->priv->visible) {
		return;
	}
	_tmp0_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = IS_VIEW_COLLECTION (_tmp0_) ? ((ViewCollection*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_data_collection_unref0 (_tmp0_);
	}
	vc = _tmp1_;
	_tmp2_ = vc;
	if (_tmp2_ != NULL) {
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		_tmp3_ = vc;
		if (!data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection))) {
			g_signal_emit (self, data_view_signals[DATA_VIEW_GEOMETRY_ALTERED_SIGNAL], 0);
		}
		_tmp4_ = vc;
		view_collection_internal_notify_geometry_altered (_tmp4_, self);
	} else {
		g_signal_emit (self, data_view_signals[DATA_VIEW_GEOMETRY_ALTERED_SIGNAL], 0);
	}
	_data_collection_unref0 (vc);
}

void
data_view_notify_geometry_altered (DataView* self)
{
	DataViewClass* _klass_;
	g_return_if_fail (IS_DATA_VIEW (self));
	_klass_ = DATA_VIEW_GET_CLASS (self);
	if (_klass_->notify_geometry_altered) {
		_klass_->notify_geometry_altered (self);
	}
}

static void
data_view_real_notify_unsubscribed (DataView* self,
                                    DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
	g_signal_emit (self, data_view_signals[DATA_VIEW_UNSUBSCRIBED_SIGNAL], 0, source);
}

void
data_view_notify_unsubscribed (DataView* self,
                               DataSource* source)
{
	DataViewClass* _klass_;
	g_return_if_fail (IS_DATA_VIEW (self));
	_klass_ = DATA_VIEW_GET_CLASS (self);
	if (_klass_->notify_unsubscribed) {
		_klass_->notify_unsubscribed (self, source);
	}
}

static void
data_view_real_state_changed (DataView* self,
                              gboolean selected)
{
}

static void
data_view_real_visibility_changed (DataView* self,
                                   gboolean visible)
{
}

static void
data_view_real_view_altered (DataView* self)
{
}

static void
data_view_real_geometry_altered (DataView* self)
{
}

static void
data_view_real_unsubscribed (DataView* self,
                             DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
}

static void
data_view_class_init (DataViewClass * klass,
                      gpointer klass_data)
{
	data_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DataView_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) data_view_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) data_view_real_to_string;
	((DataViewClass *) klass)->notify_view_altered = (void (*) (DataView*)) data_view_real_notify_view_altered;
	((DataViewClass *) klass)->notify_geometry_altered = (void (*) (DataView*)) data_view_real_notify_geometry_altered;
	((DataViewClass *) klass)->notify_unsubscribed = (void (*) (DataView*, DataSource*)) data_view_real_notify_unsubscribed;
	((DataViewClass *) klass)->state_changed = data_view_real_state_changed;
	((DataViewClass *) klass)->visibility_changed = data_view_real_visibility_changed;
	((DataViewClass *) klass)->view_altered = data_view_real_view_altered;
	((DataViewClass *) klass)->geometry_altered = data_view_real_geometry_altered;
	((DataViewClass *) klass)->unsubscribed = data_view_real_unsubscribed;
	G_OBJECT_CLASS (klass)->finalize = data_view_finalize;
	data_view_signals[DATA_VIEW_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", TYPE_DATA_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataViewClass, state_changed), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	data_view_signals[DATA_VIEW_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("visibility-changed", TYPE_DATA_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataViewClass, visibility_changed), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	data_view_signals[DATA_VIEW_VIEW_ALTERED_SIGNAL] = g_signal_new ("view-altered", TYPE_DATA_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataViewClass, view_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_view_signals[DATA_VIEW_GEOMETRY_ALTERED_SIGNAL] = g_signal_new ("geometry-altered", TYPE_DATA_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataViewClass, geometry_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_view_signals[DATA_VIEW_UNSUBSCRIBED_SIGNAL] = g_signal_new ("unsubscribed", TYPE_DATA_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataViewClass, unsubscribed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
}

static void
data_view_instance_init (DataView * self,
                         gpointer klass)
{
	self->priv = data_view_get_instance_private (self);
	self->priv->selected = FALSE;
	self->priv->visible = TRUE;
}

static void
data_view_finalize (GObject * obj)
{
	DataView * self;
	DataSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_VIEW, DataView);
	_tmp0_ = self->priv->source;
	data_source_internal_unsubscribe (_tmp0_, self);
	_g_object_unref0 (self->priv->source);
	G_OBJECT_CLASS (data_view_parent_class)->finalize (obj);
}

static GType
data_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DataViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataView), 0, (GInstanceInitFunc) data_view_instance_init, NULL };
	GType data_view_type_id;
	data_view_type_id = g_type_register_static (TYPE_DATA_OBJECT, "DataView", &g_define_type_info, 0);
	DataView_private_offset = g_type_add_instance_private (data_view_type_id, sizeof (DataViewPrivate));
	return data_view_type_id;
}

GType
data_view_get_type (void)
{
	static volatile gsize data_view_type_id__once = 0;
	if (g_once_init_enter (&data_view_type_id__once)) {
		GType data_view_type_id;
		data_view_type_id = data_view_get_type_once ();
		g_once_init_leave (&data_view_type_id__once, data_view_type_id);
	}
	return data_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

