/* DataSourceTypes.c generated by valac 0.56.17, the Vala compiler
 * generated from DataSourceTypes.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* Media sources*/
/**/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include "metadata.h"
#include <gee.h>

#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
enum  {
	THUMBNAIL_SOURCE_0_PROPERTY,
	THUMBNAIL_SOURCE_NUM_PROPERTIES
};
static GParamSpec* thumbnail_source_properties[THUMBNAIL_SOURCE_NUM_PROPERTIES];

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef void (*DataSourceContactSubscriber) (DataView* view, gpointer user_data);

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
enum  {
	THUMBNAIL_SOURCE_THUMBNAIL_ALTERED_SIGNAL,
	THUMBNAIL_SOURCE_NUM_SIGNALS
};
static guint thumbnail_source_signals[THUMBNAIL_SOURCE_NUM_SIGNALS] = {0};

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
enum  {
	PHOTO_SOURCE_0_PROPERTY,
	PHOTO_SOURCE_NUM_PROPERTIES
};
static GParamSpec* photo_source_properties[PHOTO_SOURCE_NUM_PROPERTIES];

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;
enum  {
	VIDEO_SOURCE_0_PROPERTY,
	VIDEO_SOURCE_NUM_PROPERTIES
};
static GParamSpec* video_source_properties[VIDEO_SOURCE_NUM_PROPERTIES];

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;
typedef struct _EventSourcePrivate EventSourcePrivate;
enum  {
	EVENT_SOURCE_0_PROPERTY,
	EVENT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* event_source_properties[EVENT_SOURCE_NUM_PROPERTIES];

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	GDateTime* (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, gint* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	GDateTime* (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _EventSource {
	ThumbnailSource parent_instance;
	EventSourcePrivate * priv;
};

struct _EventSourceClass {
	ThumbnailSourceClass parent_class;
	GDateTime* (*get_start_time) (EventSource* self);
	GDateTime* (*get_end_time) (EventSource* self);
	guint64 (*get_total_filesize) (EventSource* self);
	gint (*get_media_count) (EventSource* self);
	GeeCollection* (*get_media) (EventSource* self);
	gchar* (*get_comment) (EventSource* self);
	gboolean (*set_comment) (EventSource* self, const gchar* comment);
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

static gpointer thumbnail_source_parent_class = NULL;
static gpointer photo_source_parent_class = NULL;
static gpointer video_source_parent_class = NULL;
static gpointer event_source_parent_class = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
VALA_EXTERN GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                              gint scale,
                                              GError** error);
VALA_EXTERN gchar* thumbnail_source_get_representative_id (ThumbnailSource* self);
VALA_EXTERN PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
VALA_EXTERN ThumbnailSource* thumbnail_source_construct (GType object_type,
                                             gint64 object_id);
VALA_EXTERN DataSource* data_source_construct (GType object_type,
                                   gint64 object_id);
static void thumbnail_source_real_notify_thumbnail_altered (ThumbnailSource* self);
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN void data_source_contact_subscribers (DataSource* self,
                                      DataSourceContactSubscriber contact_subscriber,
                                      gpointer contact_subscriber_target);
static void thumbnail_source_subscriber_thumbnail_altered (ThumbnailSource* self,
                                                    DataView* view);
static void _thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber (DataView* view,
                                                                                    gpointer self);
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN void thumbnail_view_notify_thumbnail_altered (ThumbnailView* self);
static GdkPixbuf* thumbnail_source_real_get_thumbnail (ThumbnailSource* self,
                                                gint scale,
                                                GError** error);
static GdkPixbuf* thumbnail_source_real_create_thumbnail (ThumbnailSource* self,
                                                   gint scale,
                                                   GError** error);
static gchar* thumbnail_source_real_get_representative_id (ThumbnailSource* self);
VALA_EXTERN gchar* data_source_get_source_id (DataSource* self);
static PhotoFileFormat thumbnail_source_real_get_preferred_thumbnail_format (ThumbnailSource* self);
static void thumbnail_source_real_thumbnail_altered (ThumbnailSource* self);
static GType thumbnail_source_get_type_once (void);
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN gpointer backing_file_state_ref (gpointer instance);
VALA_EXTERN void backing_file_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_backing_file_state (const GValue* value);
VALA_EXTERN GType backing_file_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingFileState, backing_file_state_unref)
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
VALA_EXTERN PhotoSource* photo_source_construct (GType object_type,
                                     gint64 object_id);
VALA_EXTERN MediaSource* media_source_construct (GType object_type,
                                     gint64 object_id);
static PhotoMetadata* photo_source_real_get_metadata (PhotoSource* self);
static GdkPixbuf* photo_source_real_get_pixbuf (PhotoSource* self,
                                         Scaling* scaling,
                                         GError** error);
static GType photo_source_get_type_once (void);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN VideoSource* video_source_construct (GType object_type);
static GType video_source_get_type_once (void);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GDateTime* event_source_get_start_time (EventSource* self);
VALA_EXTERN GDateTime* event_source_get_end_time (EventSource* self);
VALA_EXTERN guint64 event_source_get_total_filesize (EventSource* self);
VALA_EXTERN gint event_source_get_media_count (EventSource* self);
VALA_EXTERN GeeCollection* event_source_get_media (EventSource* self);
VALA_EXTERN gchar* event_source_get_comment (EventSource* self);
VALA_EXTERN gboolean event_source_set_comment (EventSource* self,
                                   const gchar* comment);
VALA_EXTERN EventSource* event_source_construct (GType object_type,
                                     gint64 object_id);
static GDateTime* event_source_real_get_start_time (EventSource* self);
static GDateTime* event_source_real_get_end_time (EventSource* self);
static guint64 event_source_real_get_total_filesize (EventSource* self);
static gint event_source_real_get_media_count (EventSource* self);
static GeeCollection* event_source_real_get_media (EventSource* self);
static gchar* event_source_real_get_comment (EventSource* self);
static gboolean event_source_real_set_comment (EventSource* self,
                                        const gchar* comment);
static GType event_source_get_type_once (void);
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType container_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSource, g_object_unref)
VALA_EXTERN gboolean container_source_has_links (ContainerSource* self);
VALA_EXTERN SourceBacklink* container_source_get_backlink (ContainerSource* self);
VALA_EXTERN void container_source_break_link (ContainerSource* self,
                                  DataSource* source);
VALA_EXTERN void container_source_break_link_many (ContainerSource* self,
                                       GeeCollection* sources);
VALA_EXTERN void container_source_establish_link (ContainerSource* self,
                                      DataSource* source);
VALA_EXTERN void container_source_establish_link_many (ContainerSource* self,
                                           GeeCollection* sources);
static GType container_source_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ThumbnailSource*
thumbnail_source_construct (GType object_type,
                            gint64 object_id)
{
	ThumbnailSource * self = NULL;
	self = (ThumbnailSource*) data_source_construct (object_type, object_id);
	return self;
}

static void
_thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber (DataView* view,
                                                                               gpointer self)
{
	thumbnail_source_subscriber_thumbnail_altered ((ThumbnailSource*) self, view);
}

static void
thumbnail_source_real_notify_thumbnail_altered (ThumbnailSource* self)
{
	g_signal_emit (self, thumbnail_source_signals[THUMBNAIL_SOURCE_THUMBNAIL_ALTERED_SIGNAL], 0);
	data_source_contact_subscribers (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), _thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber, self);
}

void
thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self)
{
	ThumbnailSourceClass* _klass_;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (self));
	_klass_ = THUMBNAIL_SOURCE_GET_CLASS (self);
	if (_klass_->notify_thumbnail_altered) {
		_klass_->notify_thumbnail_altered (self);
	}
}

static void
thumbnail_source_subscriber_thumbnail_altered (ThumbnailSource* self,
                                               DataView* view)
{
	g_return_if_fail (IS_THUMBNAIL_SOURCE (self));
	g_return_if_fail (IS_DATA_VIEW (view));
	thumbnail_view_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_THUMBNAIL_VIEW, ThumbnailView));
}

static GdkPixbuf*
thumbnail_source_real_get_thumbnail (ThumbnailSource* self,
                                     gint scale,
                                     GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_get_thumbnail'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                gint scale,
                                GError** error)
{
	ThumbnailSourceClass* _klass_;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
	_klass_ = THUMBNAIL_SOURCE_GET_CLASS (self);
	if (_klass_->get_thumbnail) {
		return _klass_->get_thumbnail (self, scale, error);
	}
	return NULL;
}

static GdkPixbuf*
thumbnail_source_real_create_thumbnail (ThumbnailSource* self,
                                        gint scale,
                                        GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_create_thumbnail'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                   gint scale,
                                   GError** error)
{
	ThumbnailSourceClass* _klass_;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
	_klass_ = THUMBNAIL_SOURCE_GET_CLASS (self);
	if (_klass_->create_thumbnail) {
		return _klass_->create_thumbnail (self, scale, error);
	}
	return NULL;
}

static gchar*
thumbnail_source_real_get_representative_id (ThumbnailSource* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
	result = _tmp0_;
	return result;
}

gchar*
thumbnail_source_get_representative_id (ThumbnailSource* self)
{
	ThumbnailSourceClass* _klass_;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
	_klass_ = THUMBNAIL_SOURCE_GET_CLASS (self);
	if (_klass_->get_representative_id) {
		return _klass_->get_representative_id (self);
	}
	return NULL;
}

static PhotoFileFormat
thumbnail_source_real_get_preferred_thumbnail_format (ThumbnailSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_get_preferred_thumbnail_format'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

PhotoFileFormat
thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self)
{
	ThumbnailSourceClass* _klass_;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), 0);
	_klass_ = THUMBNAIL_SOURCE_GET_CLASS (self);
	if (_klass_->get_preferred_thumbnail_format) {
		return _klass_->get_preferred_thumbnail_format (self);
	}
	return 0;
}

static void
thumbnail_source_real_thumbnail_altered (ThumbnailSource* self)
{
}

static void
thumbnail_source_class_init (ThumbnailSourceClass * klass,
                             gpointer klass_data)
{
	thumbnail_source_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailSourceClass *) klass)->notify_thumbnail_altered = (void (*) (ThumbnailSource*)) thumbnail_source_real_notify_thumbnail_altered;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) thumbnail_source_real_get_thumbnail;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) thumbnail_source_real_create_thumbnail;
	((ThumbnailSourceClass *) klass)->get_representative_id = (gchar* (*) (ThumbnailSource*)) thumbnail_source_real_get_representative_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) thumbnail_source_real_get_preferred_thumbnail_format;
	((ThumbnailSourceClass *) klass)->thumbnail_altered = thumbnail_source_real_thumbnail_altered;
	thumbnail_source_signals[THUMBNAIL_SOURCE_THUMBNAIL_ALTERED_SIGNAL] = g_signal_new ("thumbnail-altered", TYPE_THUMBNAIL_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ThumbnailSourceClass, thumbnail_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
thumbnail_source_instance_init (ThumbnailSource * self,
                                gpointer klass)
{
}

static GType
thumbnail_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailSource), 0, (GInstanceInitFunc) thumbnail_source_instance_init, NULL };
	GType thumbnail_source_type_id;
	thumbnail_source_type_id = g_type_register_static (TYPE_DATA_SOURCE, "ThumbnailSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return thumbnail_source_type_id;
}

GType
thumbnail_source_get_type (void)
{
	static volatile gsize thumbnail_source_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_source_type_id__once)) {
		GType thumbnail_source_type_id;
		thumbnail_source_type_id = thumbnail_source_get_type_once ();
		g_once_init_leave (&thumbnail_source_type_id__once, thumbnail_source_type_id);
	}
	return thumbnail_source_type_id__once;
}

PhotoSource*
photo_source_construct (GType object_type,
                        gint64 object_id)
{
	PhotoSource * self = NULL;
	self = (PhotoSource*) media_source_construct (object_type, object_id);
	return self;
}

static PhotoMetadata*
photo_source_real_get_metadata (PhotoSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_source_get_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoMetadata*
photo_source_get_metadata (PhotoSource* self)
{
	PhotoSourceClass* _klass_;
	g_return_val_if_fail (IS_PHOTO_SOURCE (self), NULL);
	_klass_ = PHOTO_SOURCE_GET_CLASS (self);
	if (_klass_->get_metadata) {
		return _klass_->get_metadata (self);
	}
	return NULL;
}

static GdkPixbuf*
photo_source_real_get_pixbuf (PhotoSource* self,
                              Scaling* scaling,
                              GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_source_get_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
photo_source_get_pixbuf (PhotoSource* self,
                         Scaling* scaling,
                         GError** error)
{
	PhotoSourceClass* _klass_;
	g_return_val_if_fail (IS_PHOTO_SOURCE (self), NULL);
	_klass_ = PHOTO_SOURCE_GET_CLASS (self);
	if (_klass_->get_pixbuf) {
		return _klass_->get_pixbuf (self, scaling, error);
	}
	return NULL;
}

static void
photo_source_class_init (PhotoSourceClass * klass,
                         gpointer klass_data)
{
	photo_source_parent_class = g_type_class_peek_parent (klass);
	((PhotoSourceClass *) klass)->get_metadata = (PhotoMetadata* (*) (PhotoSource*)) photo_source_real_get_metadata;
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource*, Scaling*, GError**)) photo_source_real_get_pixbuf;
}

static void
photo_source_instance_init (PhotoSource * self,
                            gpointer klass)
{
}

static GType
photo_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoSource), 0, (GInstanceInitFunc) photo_source_instance_init, NULL };
	GType photo_source_type_id;
	photo_source_type_id = g_type_register_static (TYPE_MEDIA_SOURCE, "PhotoSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return photo_source_type_id;
}

GType
photo_source_get_type (void)
{
	static volatile gsize photo_source_type_id__once = 0;
	if (g_once_init_enter (&photo_source_type_id__once)) {
		GType photo_source_type_id;
		photo_source_type_id = photo_source_get_type_once ();
		g_once_init_leave (&photo_source_type_id__once, photo_source_type_id);
	}
	return photo_source_type_id__once;
}

VideoSource*
video_source_construct (GType object_type)
{
	VideoSource * self = NULL;
	self = (VideoSource*) media_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
	return self;
}

static void
video_source_class_init (VideoSourceClass * klass,
                         gpointer klass_data)
{
	video_source_parent_class = g_type_class_peek_parent (klass);
}

static void
video_source_instance_init (VideoSource * self,
                            gpointer klass)
{
}

static GType
video_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSource), 0, (GInstanceInitFunc) video_source_instance_init, NULL };
	GType video_source_type_id;
	video_source_type_id = g_type_register_static (TYPE_MEDIA_SOURCE, "VideoSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return video_source_type_id;
}

GType
video_source_get_type (void)
{
	static volatile gsize video_source_type_id__once = 0;
	if (g_once_init_enter (&video_source_type_id__once)) {
		GType video_source_type_id;
		video_source_type_id = video_source_get_type_once ();
		g_once_init_leave (&video_source_type_id__once, video_source_type_id);
	}
	return video_source_type_id__once;
}

EventSource*
event_source_construct (GType object_type,
                        gint64 object_id)
{
	EventSource * self = NULL;
	self = (EventSource*) thumbnail_source_construct (object_type, object_id);
	return self;
}

static GDateTime*
event_source_real_get_start_time (EventSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `event_source_get_start_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GDateTime*
event_source_get_start_time (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_start_time) {
		return _klass_->get_start_time (self);
	}
	return NULL;
}

static GDateTime*
event_source_real_get_end_time (EventSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `event_source_get_end_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GDateTime*
event_source_get_end_time (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_end_time) {
		return _klass_->get_end_time (self);
	}
	return NULL;
}

static guint64
event_source_real_get_total_filesize (EventSource* self)
{
	guint64 _tmp0_ = 0ULL;
	g_critical ("Type `%s' does not implement abstract method `event_source_get_total_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint64
event_source_get_total_filesize (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0ULL);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_total_filesize) {
		return _klass_->get_total_filesize (self);
	}
	return 0ULL;
}

static gint
event_source_real_get_media_count (EventSource* self)
{
	gint _tmp0_ = 0;
	g_critical ("Type `%s' does not implement abstract method `event_source_get_media_count'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint
event_source_get_media_count (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_media_count) {
		return _klass_->get_media_count (self);
	}
	return -1;
}

static GeeCollection*
event_source_real_get_media (EventSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `event_source_get_media'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
event_source_get_media (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_media) {
		return _klass_->get_media (self);
	}
	return NULL;
}

static gchar*
event_source_real_get_comment (EventSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `event_source_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
event_source_get_comment (EventSource* self)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->get_comment) {
		return _klass_->get_comment (self);
	}
	return NULL;
}

static gboolean
event_source_real_set_comment (EventSource* self,
                               const gchar* comment)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `event_source_set_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
event_source_set_comment (EventSource* self,
                          const gchar* comment)
{
	EventSourceClass* _klass_;
	g_return_val_if_fail (IS_EVENT_SOURCE (self), FALSE);
	_klass_ = EVENT_SOURCE_GET_CLASS (self);
	if (_klass_->set_comment) {
		return _klass_->set_comment (self, comment);
	}
	return FALSE;
}

static void
event_source_class_init (EventSourceClass * klass,
                         gpointer klass_data)
{
	event_source_parent_class = g_type_class_peek_parent (klass);
	((EventSourceClass *) klass)->get_start_time = (GDateTime* (*) (EventSource*)) event_source_real_get_start_time;
	((EventSourceClass *) klass)->get_end_time = (GDateTime* (*) (EventSource*)) event_source_real_get_end_time;
	((EventSourceClass *) klass)->get_total_filesize = (guint64 (*) (EventSource*)) event_source_real_get_total_filesize;
	((EventSourceClass *) klass)->get_media_count = (gint (*) (EventSource*)) event_source_real_get_media_count;
	((EventSourceClass *) klass)->get_media = (GeeCollection* (*) (EventSource*)) event_source_real_get_media;
	((EventSourceClass *) klass)->get_comment = (gchar* (*) (EventSource*)) event_source_real_get_comment;
	((EventSourceClass *) klass)->set_comment = (gboolean (*) (EventSource*, const gchar*)) event_source_real_set_comment;
}

static void
event_source_instance_init (EventSource * self,
                            gpointer klass)
{
}

static GType
event_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSource), 0, (GInstanceInitFunc) event_source_instance_init, NULL };
	GType event_source_type_id;
	event_source_type_id = g_type_register_static (TYPE_THUMBNAIL_SOURCE, "EventSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return event_source_type_id;
}

GType
event_source_get_type (void)
{
	static volatile gsize event_source_type_id__once = 0;
	if (g_once_init_enter (&event_source_type_id__once)) {
		GType event_source_type_id;
		event_source_type_id = event_source_get_type_once ();
		g_once_init_leave (&event_source_type_id__once, event_source_type_id);
	}
	return event_source_type_id__once;
}

gboolean
container_source_has_links (ContainerSource* self)
{
	ContainerSourceIface* _iface_;
	g_return_val_if_fail (IS_CONTAINER_SOURCE (self), FALSE);
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->has_links) {
		return _iface_->has_links (self);
	}
	return FALSE;
}

SourceBacklink*
container_source_get_backlink (ContainerSource* self)
{
	ContainerSourceIface* _iface_;
	g_return_val_if_fail (IS_CONTAINER_SOURCE (self), NULL);
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->get_backlink) {
		return _iface_->get_backlink (self);
	}
	return NULL;
}

void
container_source_break_link (ContainerSource* self,
                             DataSource* source)
{
	ContainerSourceIface* _iface_;
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->break_link) {
		_iface_->break_link (self, source);
	}
}

void
container_source_break_link_many (ContainerSource* self,
                                  GeeCollection* sources)
{
	ContainerSourceIface* _iface_;
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->break_link_many) {
		_iface_->break_link_many (self, sources);
	}
}

void
container_source_establish_link (ContainerSource* self,
                                 DataSource* source)
{
	ContainerSourceIface* _iface_;
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->establish_link) {
		_iface_->establish_link (self, source);
	}
}

void
container_source_establish_link_many (ContainerSource* self,
                                      GeeCollection* sources)
{
	ContainerSourceIface* _iface_;
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
	_iface_ = CONTAINER_SOURCE_GET_INTERFACE (self);
	if (_iface_->establish_link_many) {
		_iface_->establish_link_many (self, sources);
	}
}

static void
container_source_default_init (ContainerSourceIface * iface,
                               gpointer iface_data)
{
}

static GType
container_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContainerSourceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) container_source_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType container_source_type_id;
	container_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "ContainerSource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (container_source_type_id, TYPE_DATA_SOURCE);
	return container_source_type_id;
}

GType
container_source_get_type (void)
{
	static volatile gsize container_source_type_id__once = 0;
	if (g_once_init_enter (&container_source_type_id__once)) {
		GType container_source_type_id;
		container_source_type_id = container_source_get_type_once ();
		g_once_init_leave (&container_source_type_id__once, container_source_type_id);
	}
	return container_source_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

