/* DataObject.c generated by valac 0.56.17, the Vala compiler
 * generated from DataObject.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* DataObject*/
/**/
/* Object IDs are incremented for each DataObject, and therefore may be used to compare*/
/* creation order.  This behavior may be relied upon elsewhere.  Object IDs may be recycled when*/
/* DataObjects are reconstituted by a proxy.*/
/**/
/* Ordinal IDs are supplied by DataCollections to record the ordering of the object being added*/
/* to the collection.  This value is primarily only used by DataCollection, but may be used*/
/* elsewhere to resolve ordering questions (including stabilizing a sort).*/
/**/
/* Have to inherit from Object due to ContainerSource and this bug:*/
/* https://bugzilla.gnome.org/show_bug.cgi?id=615904*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#define DATA_COLLECTION_INVALID_OBJECT_ORDINAL ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
enum  {
	DATA_OBJECT_0_PROPERTY,
	DATA_OBJECT_NUM_PROPERTIES
};
static GParamSpec* data_object_properties[DATA_OBJECT_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataObjectPrivate {
	gint64 object_id;
	DataCollection* member_of;
	gint64 ordinal;
};

static gint DataObject_private_offset;
static gpointer data_object_parent_class = NULL;
static gint64 data_object_object_id_generator;
static gint64 data_object_object_id_generator = (gint64) 0;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
VALA_EXTERN void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
VALA_EXTERN void data_object_notify_collection_property_cleared (DataObject* self,
                                                     const gchar* name);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN DataObject* data_object_construct (GType object_type,
                                   gint64 object_id);
static void data_object_real_notify_altered (DataObject* self,
                                      Alteration* alteration);
VALA_EXTERN void data_collection_internal_notify_altered (DataCollection* self,
                                              DataObject* object,
                                              Alteration* alteration);
static void data_object_real_notify_membership_changed (DataObject* self,
                                                 DataCollection* collection);
static void data_object_real_notify_collection_property_set (DataObject* self,
                                                      const gchar* name,
                                                      GValue* old,
                                                      GValue* val);
static void data_object_real_notify_collection_property_cleared (DataObject* self,
                                                          const gchar* name);
static gchar* data_object_real_get_name (DataObject* self);
static gchar* data_object_real_to_string (DataObject* self);
VALA_EXTERN DataCollection* data_object_get_membership (DataObject* self);
VALA_EXTERN gboolean data_object_has_membership (DataObject* self);
VALA_EXTERN void data_object_internal_set_membership (DataObject* self,
                                          DataCollection* collection,
                                          gint64 ordinal);
VALA_EXTERN void data_object_internal_set_ordinal (DataObject* self,
                                       gint64 ordinal);
VALA_EXTERN void data_object_internal_clear_membership (DataObject* self);
VALA_EXTERN gint64 data_object_internal_get_ordinal (DataObject* self);
VALA_EXTERN gint64 data_object_get_object_id (DataObject* self);
VALA_EXTERN void data_object_get_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* def,
                                          GValue* result);
VALA_EXTERN GValue* data_collection_get_property (DataCollection* self,
                                      const gchar* name);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN void data_object_set_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* val,
                                          ValueEqualFunc value_equals,
                                          gpointer value_equals_target);
VALA_EXTERN void data_collection_set_property (DataCollection* self,
                                   const gchar* name,
                                   GValue* val,
                                   ValueEqualFunc value_equals,
                                   gpointer value_equals_target);
VALA_EXTERN void data_object_clear_collection_property (DataObject* self,
                                            const gchar* name);
VALA_EXTERN void data_collection_clear_property (DataCollection* self,
                                     const gchar* name);
static void data_object_finalize (GObject * obj);
static GType data_object_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
data_object_get_instance_private (DataObject* self)
{
	return G_STRUCT_MEMBER_P (self, DataObject_private_offset);
}

DataObject*
data_object_construct (GType object_type,
                       gint64 object_id)
{
	DataObject * self = NULL;
	gint64 _tmp0_ = 0LL;
	self = (DataObject*) g_object_new (object_type, NULL);
	if (object_id == DATA_OBJECT_INVALID_OBJECT_ID) {
		gint64 _tmp1_;
		_tmp1_ = data_object_object_id_generator;
		data_object_object_id_generator = _tmp1_ + 1;
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = object_id;
	}
	self->priv->object_id = _tmp0_;
	return self;
}

static void
data_object_real_notify_altered (DataObject* self,
                                 Alteration* alteration)
{
	DataCollection* _tmp0_;
	g_return_if_fail (IS_ALTERATION (alteration));
	_tmp0_ = self->priv->member_of;
	if (_tmp0_ != NULL) {
		DataCollection* _tmp1_;
		_tmp1_ = self->priv->member_of;
		data_collection_internal_notify_altered (_tmp1_, self, alteration);
	}
}

void
data_object_notify_altered (DataObject* self,
                            Alteration* alteration)
{
	DataObjectClass* _klass_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->notify_altered) {
		_klass_->notify_altered (self, alteration);
	}
}

static void
data_object_real_notify_membership_changed (DataObject* self,
                                            DataCollection* collection)
{
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
}

void
data_object_notify_membership_changed (DataObject* self,
                                       DataCollection* collection)
{
	DataObjectClass* _klass_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->notify_membership_changed) {
		_klass_->notify_membership_changed (self, collection);
	}
}

static void
data_object_real_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
}

void
data_object_notify_collection_property_set (DataObject* self,
                                            const gchar* name,
                                            GValue* old,
                                            GValue* val)
{
	DataObjectClass* _klass_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->notify_collection_property_set) {
		_klass_->notify_collection_property_set (self, name, old, val);
	}
}

static void
data_object_real_notify_collection_property_cleared (DataObject* self,
                                                     const gchar* name)
{
	g_return_if_fail (name != NULL);
}

void
data_object_notify_collection_property_cleared (DataObject* self,
                                                const gchar* name)
{
	DataObjectClass* _klass_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->notify_collection_property_cleared) {
		_klass_->notify_collection_property_cleared (self, name);
	}
}

static gchar*
data_object_real_get_name (DataObject* self)
{
	g_critical ("Type `%s' does not implement abstract method `data_object_get_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
data_object_get_name (DataObject* self)
{
	DataObjectClass* _klass_;
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->get_name) {
		return _klass_->get_name (self);
	}
	return NULL;
}

static gchar*
data_object_real_to_string (DataObject* self)
{
	g_critical ("Type `%s' does not implement abstract method `data_object_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
data_object_to_string (DataObject* self)
{
	DataObjectClass* _klass_;
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
	_klass_ = DATA_OBJECT_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

DataCollection*
data_object_get_membership (DataObject* self)
{
	DataCollection* _tmp0_;
	DataCollection* _tmp1_;
	DataCollection* result;
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
	_tmp0_ = self->priv->member_of;
	_tmp1_ = _data_collection_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
data_object_has_membership (DataObject* self)
{
	DataCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (self), FALSE);
	_tmp0_ = self->priv->member_of;
	result = _tmp0_ != NULL;
	return result;
}

void
data_object_internal_set_membership (DataObject* self,
                                     DataCollection* collection,
                                     gint64 ordinal)
{
	DataCollection* _tmp0_;
	DataCollection* _tmp1_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	g_return_if_fail (IS_DATA_COLLECTION (collection));
	_tmp0_ = self->priv->member_of;
	_vala_assert (_tmp0_ == NULL, "member_of == null");
	_tmp1_ = _data_collection_ref0 (collection);
	_data_collection_unref0 (self->priv->member_of);
	self->priv->member_of = _tmp1_;
	self->priv->ordinal = ordinal;
}

void
data_object_internal_set_ordinal (DataObject* self,
                                  gint64 ordinal)
{
	DataCollection* _tmp0_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	_tmp0_ = self->priv->member_of;
	_vala_assert (_tmp0_ == NULL, "member_of == null");
	self->priv->ordinal = ordinal;
}

void
data_object_internal_clear_membership (DataObject* self)
{
	g_return_if_fail (IS_DATA_OBJECT (self));
	_data_collection_unref0 (self->priv->member_of);
	self->priv->member_of = NULL;
	self->priv->ordinal = DATA_COLLECTION_INVALID_OBJECT_ORDINAL;
}

inline gint64
data_object_internal_get_ordinal (DataObject* self)
{
	gint64 result;
	g_return_val_if_fail (IS_DATA_OBJECT (self), 0LL);
	result = self->priv->ordinal;
	return result;
}

inline gint64
data_object_get_object_id (DataObject* self)
{
	gint64 result;
	g_return_val_if_fail (IS_DATA_OBJECT (self), 0LL);
	result = self->priv->object_id;
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

void
data_object_get_collection_property (DataObject* self,
                                     const gchar* name,
                                     GValue* def,
                                     GValue* result)
{
	DataCollection* _tmp0_;
	GValue* _result_ = NULL;
	DataCollection* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_ = NULL;
	GValue* _tmp6_;
	GValue _tmp8_;
	GValue _tmp9_ = {0};
	g_return_if_fail (IS_DATA_OBJECT (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->member_of;
	if (_tmp0_ == NULL) {
		GValue _tmp1_;
		GValue _tmp2_ = {0};
		_tmp1_ = *def;
		if (G_IS_VALUE (&_tmp1_)) {
			g_value_init (&_tmp2_, G_VALUE_TYPE (&_tmp1_));
			g_value_copy (&_tmp1_, &_tmp2_);
		} else {
			_tmp2_ = _tmp1_;
		}
		*result = _tmp2_;
		return;
	}
	_tmp3_ = self->priv->member_of;
	_tmp4_ = data_collection_get_property (_tmp3_, name);
	_result_ = _tmp4_;
	_tmp6_ = _result_;
	if (((gpointer) _tmp6_) != NULL) {
		GValue* _tmp7_;
		_tmp7_ = _result_;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = def;
	}
	_tmp8_ = *_tmp5_;
	if (G_IS_VALUE (&_tmp8_)) {
		g_value_init (&_tmp9_, G_VALUE_TYPE (&_tmp8_));
		g_value_copy (&_tmp8_, &_tmp9_);
	} else {
		_tmp9_ = _tmp8_;
	}
	*result = _tmp9_;
	__vala_GValue_free0 (_result_);
	return;
}

void
data_object_set_collection_property (DataObject* self,
                                     const gchar* name,
                                     GValue* val,
                                     ValueEqualFunc value_equals,
                                     gpointer value_equals_target)
{
	DataCollection* _tmp0_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->member_of;
	if (_tmp0_ != NULL) {
		DataCollection* _tmp1_;
		GValue _tmp2_;
		_tmp1_ = self->priv->member_of;
		_tmp2_ = *val;
		data_collection_set_property (_tmp1_, name, &_tmp2_, value_equals, value_equals_target);
	}
}

void
data_object_clear_collection_property (DataObject* self,
                                       const gchar* name)
{
	DataCollection* _tmp0_;
	g_return_if_fail (IS_DATA_OBJECT (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->member_of;
	if (_tmp0_ != NULL) {
		DataCollection* _tmp1_;
		_tmp1_ = self->priv->member_of;
		data_collection_clear_property (_tmp1_, name);
	}
}

static void
data_object_class_init (DataObjectClass * klass,
                        gpointer klass_data)
{
	data_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DataObject_private_offset);
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) data_object_real_notify_altered;
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject*, DataCollection*)) data_object_real_notify_membership_changed;
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject*, const gchar*, GValue*, GValue*)) data_object_real_notify_collection_property_set;
	((DataObjectClass *) klass)->notify_collection_property_cleared = (void (*) (DataObject*, const gchar*)) data_object_real_notify_collection_property_cleared;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) data_object_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) data_object_real_to_string;
	G_OBJECT_CLASS (klass)->finalize = data_object_finalize;
}

static void
data_object_instance_init (DataObject * self,
                           gpointer klass)
{
	self->priv = data_object_get_instance_private (self);
	self->priv->object_id = DATA_OBJECT_INVALID_OBJECT_ID;
	self->priv->member_of = NULL;
	self->priv->ordinal = DATA_COLLECTION_INVALID_OBJECT_ORDINAL;
}

static void
data_object_finalize (GObject * obj)
{
	DataObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_OBJECT, DataObject);
	_data_collection_unref0 (self->priv->member_of);
	G_OBJECT_CLASS (data_object_parent_class)->finalize (obj);
}

static GType
data_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DataObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataObject), 0, (GInstanceInitFunc) data_object_instance_init, NULL };
	GType data_object_type_id;
	data_object_type_id = g_type_register_static (G_TYPE_OBJECT, "DataObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	DataObject_private_offset = g_type_add_instance_private (data_object_type_id, sizeof (DataObjectPrivate));
	return data_object_type_id;
}

GType
data_object_get_type (void)
{
	static volatile gsize data_object_type_id__once = 0;
	if (g_once_init_enter (&data_object_type_id__once)) {
		GType data_object_type_id;
		data_object_type_id = data_object_get_type_once ();
		g_once_init_leave (&data_object_type_id__once, data_object_type_id);
	}
	return data_object_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

