/* Alteration.c generated by valac 0.56.17, the Vala compiler
 * generated from Alteration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* Alteration represents a description of what has changed in the DataObject (reported via the*/
/* "altered" signal).  Since the descriptions can vary wildly depending on the semantics of each*/
/* DataObject, no assumptions or requirements are placed on Alteration other than it must have*/
/* one or more "subjects", each with a "detail".  Subscribers to the "altered" signal can query*/
/* the Alteration object to determine if the change is important to them.*/
/**/
/* Alteration is an immutable type.  This means it's possible to store const Alterations of oft-used*/
/* values for reuse.*/
/**/
/* Alterations may be compressed, merging their subjects and details into a new aggregated*/
/* Alteration.  Generally this is handled automatically by DataObject and DataCollection, when*/
/* necessary.*/
/**/
/* NOTE: subjects and details should be ASCII labels (as in, plain-old ASCII, no code pages).*/
/* They are treated as case-sensitive strings.*/
/**/
/* Recommended subjects include: image, thumbnail, metadata.*/
/**/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _AlterationPrivate AlterationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecAlteration ParamSpecAlteration;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Alteration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlterationPrivate * priv;
};

struct _AlterationClass {
	GTypeClass parent_class;
	void (*finalize) (Alteration *self);
};

struct _AlterationPrivate {
	gchar* subject;
	gchar* detail;
	GeeMultiMap* map;
};

struct _ParamSpecAlteration {
	GParamSpec parent_instance;
};

static gint Alteration_private_offset;
static gpointer alteration_parent_class = NULL;

VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
VALA_EXTERN Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
static void alteration_add_detail (Alteration* self,
                            const gchar* sub,
                            const gchar* det);
VALA_EXTERN Alteration* alteration_new_from_list (const gchar* list);
VALA_EXTERN Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
VALA_EXTERN Alteration* alteration_new_from_array (gchar** array,
                                       gint array_length1);
VALA_EXTERN Alteration* alteration_construct_from_array (GType object_type,
                                             gchar** array,
                                             gint array_length1);
static Alteration* alteration_new_from_map (GeeMultiMap* map);
static Alteration* alteration_construct_from_map (GType object_type,
                                           GeeMultiMap* map);
static GeeMultiMap* alteration_create_map (Alteration* self);
static guint alteration_case_hash (const gchar* a);
static guint _alteration_case_hash_gee_hash_data_func (gconstpointer v,
                                                gpointer self);
static gboolean alteration_case_equal (const gchar* a,
                                const gchar* b);
static gboolean _alteration_case_equal_gee_equal_data_func (gconstpointer a,
                                                     gconstpointer b,
                                                     gpointer self);
static inline gboolean alteration_equal_values (const gchar* str1,
                                  const gchar* str2);
static inline guint alteration_hash_value (const gchar* str);
VALA_EXTERN gboolean alteration_has_subject (Alteration* self,
                                 const gchar* subject);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
VALA_EXTERN GeeCollection* alteration_get_details (Alteration* self,
                                       const gchar* subject);
VALA_EXTERN gchar* alteration_to_string (Alteration* self);
VALA_EXTERN gboolean alteration_contains_any (Alteration* self,
                                  Alteration* other);
VALA_EXTERN gboolean alteration_equals (Alteration* self,
                            Alteration* other);
static void alteration_multimap_add_all (GeeMultiMap* dest,
                                  GeeMultiMap* src);
VALA_EXTERN Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
static void alteration_finalize (Alteration * obj);
static GType alteration_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
alteration_get_instance_private (Alteration* self)
{
	return G_STRUCT_MEMBER_P (self, Alteration_private_offset);
}

Alteration*
alteration_construct (GType object_type,
                      const gchar* subject,
                      const gchar* detail)
{
	Alteration* self = NULL;
	g_return_val_if_fail (subject != NULL, NULL);
	g_return_val_if_fail (detail != NULL, NULL);
	self = (Alteration*) g_type_create_instance (object_type);
	alteration_add_detail (self, subject, detail);
	return self;
}

Alteration*
alteration_new (const gchar* subject,
                const gchar* detail)
{
	return alteration_construct (TYPE_ALTERATION, subject, detail);
}

Alteration*
alteration_construct_from_list (GType object_type,
                                const gchar* list)
{
	Alteration* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar** pairs = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint pairs_length1;
	gint _pairs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_val_if_fail (list != NULL, NULL);
	self = (Alteration*) g_type_create_instance (object_type);
	_tmp0_ = strlen (list);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ > 0, "list.length > 0", NULL);
	_tmp3_ = _tmp2_ = g_strsplit (list, ",", 0);
	pairs = _tmp3_;
	pairs_length1 = _vala_array_length (_tmp2_);
	_pairs_size_ = pairs_length1;
	_tmp4_ = pairs;
	_tmp4__length1 = pairs_length1;
	_vala_assert (_tmp4__length1 >= 1, "pairs.length >= 1");
	_tmp5_ = pairs;
	_tmp5__length1 = pairs_length1;
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
		pair_collection = _tmp5_;
		pair_collection_length1 = _tmp5__length1;
		for (pair_it = 0; pair_it < pair_collection_length1; pair_it = pair_it + 1) {
			gchar* _tmp6_;
			gchar* pair = NULL;
			_tmp6_ = g_strdup (pair_collection[pair_it]);
			pair = _tmp6_;
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_;
				gint subject_detail_length1;
				gint _subject_detail_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				_tmp7_ = pair;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 2);
				subject_detail = _tmp9_;
				subject_detail_length1 = _vala_array_length (_tmp8_);
				_subject_detail_size_ = subject_detail_length1;
				_tmp10_ = subject_detail;
				_tmp10__length1 = subject_detail_length1;
				_vala_assert (_tmp10__length1 == 2, "subject_detail.length == 2");
				_tmp11_ = subject_detail;
				_tmp11__length1 = subject_detail_length1;
				_tmp12_ = _tmp11_[0];
				_tmp13_ = subject_detail;
				_tmp13__length1 = subject_detail_length1;
				_tmp14_ = _tmp13_[1];
				alteration_add_detail (self, _tmp12_, _tmp14_);
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pair);
			}
		}
	}
	pairs = (_vala_array_free (pairs, pairs_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

Alteration*
alteration_new_from_list (const gchar* list)
{
	return alteration_construct_from_list (TYPE_ALTERATION, list);
}

Alteration*
alteration_construct_from_array (GType object_type,
                                 gchar** array,
                                 gint array_length1)
{
	Alteration* self = NULL;
	self = (Alteration*) g_type_create_instance (object_type);
	_vala_return_val_if_fail (array_length1 > 0, "array.length > 0", NULL);
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
		pair_collection = array;
		pair_collection_length1 = array_length1;
		for (pair_it = 0; pair_it < pair_collection_length1; pair_it = pair_it + 1) {
			gchar* _tmp0_;
			gchar* pair = NULL;
			_tmp0_ = g_strdup (pair_collection[pair_it]);
			pair = _tmp0_;
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp1_;
				gchar** _tmp2_;
				gchar** _tmp3_;
				gint subject_detail_length1;
				gint _subject_detail_size_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp1_ = pair;
				_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ":", 2);
				subject_detail = _tmp3_;
				subject_detail_length1 = _vala_array_length (_tmp2_);
				_subject_detail_size_ = subject_detail_length1;
				_tmp4_ = subject_detail;
				_tmp4__length1 = subject_detail_length1;
				_vala_assert (_tmp4__length1 == 2, "subject_detail.length == 2");
				_tmp5_ = subject_detail;
				_tmp5__length1 = subject_detail_length1;
				_tmp6_ = _tmp5_[0];
				_tmp7_ = subject_detail;
				_tmp7__length1 = subject_detail_length1;
				_tmp8_ = _tmp7_[1];
				alteration_add_detail (self, _tmp6_, _tmp8_);
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pair);
			}
		}
	}
	return self;
}

Alteration*
alteration_new_from_array (gchar** array,
                           gint array_length1)
{
	return alteration_construct_from_array (TYPE_ALTERATION, array, array_length1);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Alteration*
alteration_construct_from_map (GType object_type,
                               GeeMultiMap* map)
{
	Alteration* self = NULL;
	GeeMultiMap* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MULTI_MAP), NULL);
	self = (Alteration*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (map);
	_g_object_unref0 (self->priv->map);
	self->priv->map = _tmp0_;
	return self;
}

static Alteration*
alteration_new_from_map (GeeMultiMap* map)
{
	return alteration_construct_from_map (TYPE_ALTERATION, map);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
alteration_add_detail (Alteration* self,
                       const gchar* sub,
                       const gchar* det)
{
	gchar* subject = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* detail = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	GeeMultiMap* _tmp16_;
	const gchar* _tmp18_;
	GeeMultiMap* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (IS_ALTERATION (self));
	g_return_if_fail (sub != NULL);
	g_return_if_fail (det != NULL);
	_tmp0_ = string_strip (sub);
	subject = _tmp0_;
	_tmp1_ = subject;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ > 0, "subject.length > 0");
	_tmp4_ = string_strip (det);
	detail = _tmp4_;
	_tmp5_ = detail;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ > 0, "detail.length > 0");
	_tmp9_ = self->priv->subject;
	if (_tmp9_ == NULL) {
		GeeMultiMap* _tmp10_;
		_tmp10_ = self->priv->map;
		_tmp8_ = _tmp10_ == NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->priv->detail;
		_vala_assert (_tmp11_ == NULL, "this.detail == null");
		_tmp12_ = subject;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->subject);
		self->priv->subject = _tmp13_;
		_tmp14_ = detail;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (self->priv->detail);
		self->priv->detail = _tmp15_;
		_g_free0 (detail);
		_g_free0 (subject);
		return;
	}
	_tmp16_ = self->priv->map;
	if (_tmp16_ == NULL) {
		GeeMultiMap* _tmp17_;
		_tmp17_ = alteration_create_map (self);
		_g_object_unref0 (self->priv->map);
		self->priv->map = _tmp17_;
	}
	_tmp18_ = self->priv->subject;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		GeeMultiMap* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = self->priv->detail;
		_vala_assert (_tmp19_ != NULL, "this.detail != null");
		_tmp20_ = self->priv->map;
		_tmp21_ = self->priv->subject;
		_tmp22_ = self->priv->detail;
		gee_multi_map_set (_tmp20_, _tmp21_, _tmp22_);
		_g_free0 (self->priv->subject);
		self->priv->subject = NULL;
		_g_free0 (self->priv->detail);
		self->priv->detail = NULL;
	}
	_tmp23_ = self->priv->map;
	_tmp24_ = subject;
	_tmp25_ = detail;
	gee_multi_map_set (_tmp23_, _tmp24_, _tmp25_);
	_g_free0 (detail);
	_g_free0 (subject);
}

static guint
_alteration_case_hash_gee_hash_data_func (gconstpointer v,
                                          gpointer self)
{
	guint result;
	result = alteration_case_hash ((const gchar*) v);
	return result;
}

static gboolean
_alteration_case_equal_gee_equal_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self)
{
	gboolean result;
	result = alteration_case_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

static GeeMultiMap*
alteration_create_map (Alteration* self)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* result;
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	return result;
}

static gboolean
alteration_case_equal (const gchar* a,
                       const gchar* b)
{
	gboolean result;
	result = alteration_equal_values (a, b);
	return result;
}

static guint
alteration_case_hash (const gchar* a)
{
	guint result;
	result = alteration_hash_value (a);
	return result;
}

static inline gboolean
alteration_equal_values (const gchar* str1,
                         const gchar* str2)
{
	gboolean result;
	g_return_val_if_fail (str1 != NULL, FALSE);
	g_return_val_if_fail (str2 != NULL, FALSE);
	result = g_ascii_strcasecmp (str1, str2) == 0;
	return result;
}

static inline guint
alteration_hash_value (const gchar* str)
{
	GHashFunc _tmp0_;
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	_tmp0_ = g_str_hash;
	result = _tmp0_ (str);
	return result;
}

gboolean
alteration_has_subject (Alteration* self,
                        const gchar* subject)
{
	const gchar* _tmp0_;
	GeeMultiMap* _tmp2_;
	GeeSet* keys = NULL;
	GeeMultiMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gboolean result;
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
	g_return_val_if_fail (subject != NULL, FALSE);
	_tmp0_ = self->priv->subject;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->subject;
		result = alteration_equal_values (_tmp1_, subject);
		return result;
	}
	_tmp2_ = self->priv->map;
	_vala_assert (_tmp2_ != NULL, "map != null");
	_tmp3_ = self->priv->map;
	_tmp4_ = gee_multi_map_get_keys (_tmp3_);
	keys = _tmp4_;
	_tmp5_ = keys;
	if (_tmp5_ != NULL) {
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp6_ = keys;
			_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
			_key_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				gchar* key = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				const gchar* _tmp11_;
				_tmp8_ = _key_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _key_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				key = (gchar*) _tmp10_;
				_tmp11_ = key;
				if (alteration_equal_values (_tmp11_, subject)) {
					result = TRUE;
					_g_free0 (key);
					_g_object_unref0 (_key_it);
					_g_object_unref0 (keys);
					return result;
				}
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
	}
	result = FALSE;
	_g_object_unref0 (keys);
	return result;
}

gboolean
alteration_has_detail (Alteration* self,
                       const gchar* subject,
                       const gchar* detail)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GeeMultiMap* _tmp6_;
	GeeCollection* values = NULL;
	GeeMultiMap* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	gboolean result;
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
	g_return_val_if_fail (subject != NULL, FALSE);
	g_return_val_if_fail (detail != NULL, FALSE);
	_tmp1_ = self->priv->subject;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->detail;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		_tmp4_ = self->priv->subject;
		if (alteration_equal_values (_tmp4_, subject)) {
			const gchar* _tmp5_;
			_tmp5_ = self->priv->detail;
			_tmp3_ = alteration_equal_values (_tmp5_, detail);
		} else {
			_tmp3_ = FALSE;
		}
		result = _tmp3_;
		return result;
	}
	_tmp6_ = self->priv->map;
	_vala_assert (_tmp6_ != NULL, "map != null");
	_tmp7_ = self->priv->map;
	_tmp8_ = gee_multi_map_get (_tmp7_, subject);
	values = _tmp8_;
	_tmp9_ = values;
	if (_tmp9_ != NULL) {
		{
			GeeIterator* _value_it = NULL;
			GeeCollection* _tmp10_;
			GeeIterator* _tmp11_;
			_tmp10_ = values;
			_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
			_value_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				gchar* value = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				const gchar* _tmp15_;
				_tmp12_ = _value_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _value_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				value = (gchar*) _tmp14_;
				_tmp15_ = value;
				if (alteration_equal_values (_tmp15_, detail)) {
					result = TRUE;
					_g_free0 (value);
					_g_object_unref0 (_value_it);
					_g_object_unref0 (values);
					return result;
				}
				_g_free0 (value);
			}
			_g_object_unref0 (_value_it);
		}
	}
	result = FALSE;
	_g_object_unref0 (values);
	return result;
}

GeeCollection*
alteration_get_details (Alteration* self,
                        const gchar* subject)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GeeCollection* _tmp8_ = NULL;
	GeeMultiMap* _tmp9_;
	GeeCollection* result;
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
	g_return_val_if_fail (subject != NULL, NULL);
	_tmp2_ = self->priv->subject;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->detail;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->subject;
		_tmp0_ = alteration_equal_values (_tmp4_, subject);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeArrayList* details = NULL;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		details = _tmp5_;
		_tmp6_ = details;
		_tmp7_ = self->priv->detail;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
		result = G_TYPE_CHECK_INSTANCE_CAST (details, GEE_TYPE_COLLECTION, GeeCollection);
		return result;
	}
	_tmp9_ = self->priv->map;
	if (_tmp9_ != NULL) {
		GeeMultiMap* _tmp10_;
		GeeCollection* _tmp11_;
		_tmp10_ = self->priv->map;
		_tmp11_ = gee_multi_map_get (_tmp10_, subject);
		_g_object_unref0 (_tmp8_);
		_tmp8_ = _tmp11_;
	} else {
		_g_object_unref0 (_tmp8_);
		_tmp8_ = NULL;
	}
	result = _tmp8_;
	return result;
}

gchar*
alteration_to_string (Alteration* self)
{
	const gchar* _tmp0_;
	GeeMultiMap* _tmp5_;
	gchar* str = NULL;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
	_tmp0_ = self->priv->subject;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->detail;
		_vala_assert (_tmp1_ != NULL, "detail != null");
		_tmp2_ = self->priv->subject;
		_tmp3_ = self->priv->detail;
		_tmp4_ = g_strdup_printf ("%s:%s", _tmp2_, _tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->map;
	_vala_assert (_tmp5_ != NULL, "map != null");
	_tmp6_ = g_strdup ("");
	str = _tmp6_;
	{
		GeeIterator* _key_it = NULL;
		GeeMultiMap* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp7_ = self->priv->map;
		_tmp8_ = gee_multi_map_get_keys (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_key_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* key = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			_tmp12_ = _key_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _key_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			key = (gchar*) _tmp14_;
			{
				GeeIterator* _value_it = NULL;
				GeeMultiMap* _tmp15_;
				const gchar* _tmp16_;
				GeeCollection* _tmp17_;
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				GeeIterator* _tmp20_;
				_tmp15_ = self->priv->map;
				_tmp16_ = key;
				_tmp17_ = gee_multi_map_get (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp18_);
				_value_it = _tmp20_;
				while (TRUE) {
					GeeIterator* _tmp21_;
					gchar* value = NULL;
					GeeIterator* _tmp22_;
					gpointer _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp21_ = _value_it;
					if (!gee_iterator_next (_tmp21_)) {
						break;
					}
					_tmp22_ = _value_it;
					_tmp23_ = gee_iterator_get (_tmp22_);
					value = (gchar*) _tmp23_;
					_tmp24_ = str;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					if (_tmp26_ != 0) {
						const gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp27_ = str;
						_tmp28_ = g_strconcat (_tmp27_, ", ", NULL);
						_g_free0 (str);
						str = _tmp28_;
					}
					_tmp29_ = str;
					_tmp30_ = key;
					_tmp31_ = value;
					_tmp32_ = g_strdup_printf ("%s:%s", _tmp30_, _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
					_g_free0 (str);
					str = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (value);
				}
				_g_object_unref0 (_value_it);
			}
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	result = str;
	return result;
}

gboolean
alteration_contains_any (Alteration* self,
                         Alteration* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GeeMultiMap* _tmp14_;
	gboolean _tmp42_ = FALSE;
	GeeMultiMap* _tmp43_;
	gboolean result;
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->subject;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = other->priv->subject;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->detail;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		_tmp6_ = other->priv->detail;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->subject;
		_tmp9_ = other->priv->subject;
		if (alteration_equal_values (_tmp8_, _tmp9_)) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->detail;
			_tmp11_ = other->priv->detail;
			_tmp7_ = alteration_equal_values (_tmp10_, _tmp11_);
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		return result;
	}
	_tmp14_ = self->priv->map;
	if (_tmp14_ != NULL) {
		GeeMultiMap* _tmp15_;
		_tmp15_ = other->priv->map;
		_tmp13_ = _tmp15_ == NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp16_ = FALSE;
		GeeMultiMap* _tmp17_;
		_tmp17_ = self->priv->map;
		if (_tmp17_ == NULL) {
			GeeMultiMap* _tmp18_;
			_tmp18_ = other->priv->map;
			_tmp16_ = _tmp18_ != NULL;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp12_ = _tmp16_;
	}
	if (_tmp12_) {
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* single_subject = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		gchar* single_detail = NULL;
		gchar* _tmp28_;
		GeeMultiMap* _tmp29_ = NULL;
		GeeMultiMap* _tmp30_;
		GeeMultiMap* multimap = NULL;
		GeeMultiMap* _tmp33_;
		gboolean _tmp34_ = FALSE;
		GeeMultiMap* _tmp35_;
		const gchar* _tmp36_;
		_tmp20_ = self->priv->subject;
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = self->priv->subject;
			_tmp19_ = _tmp21_;
		} else {
			const gchar* _tmp22_;
			_tmp22_ = other->priv->subject;
			_tmp19_ = _tmp22_;
		}
		_tmp23_ = g_strdup (_tmp19_);
		single_subject = _tmp23_;
		_tmp25_ = self->priv->detail;
		if (_tmp25_ != NULL) {
			const gchar* _tmp26_;
			_tmp26_ = self->priv->detail;
			_tmp24_ = _tmp26_;
		} else {
			const gchar* _tmp27_;
			_tmp27_ = other->priv->detail;
			_tmp24_ = _tmp27_;
		}
		_tmp28_ = g_strdup (_tmp24_);
		single_detail = _tmp28_;
		_tmp30_ = self->priv->map;
		if (_tmp30_ != NULL) {
			GeeMultiMap* _tmp31_;
			_tmp31_ = self->priv->map;
			_tmp29_ = _tmp31_;
		} else {
			GeeMultiMap* _tmp32_;
			_tmp32_ = other->priv->map;
			_tmp29_ = _tmp32_;
		}
		_tmp33_ = _g_object_ref0 (_tmp29_);
		multimap = _tmp33_;
		_tmp35_ = multimap;
		_tmp36_ = single_subject;
		if (gee_multi_map_contains (_tmp35_, _tmp36_)) {
			GeeMultiMap* _tmp37_;
			const gchar* _tmp38_;
			GeeCollection* _tmp39_;
			GeeCollection* _tmp40_;
			const gchar* _tmp41_;
			_tmp37_ = self->priv->map;
			_tmp38_ = single_subject;
			_tmp39_ = gee_multi_map_get (_tmp37_, _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = single_detail;
			_tmp34_ = gee_collection_contains (_tmp40_, _tmp41_);
			_g_object_unref0 (_tmp40_);
		} else {
			_tmp34_ = FALSE;
		}
		result = _tmp34_;
		_g_object_unref0 (multimap);
		_g_free0 (single_detail);
		_g_free0 (single_subject);
		return result;
	}
	_tmp43_ = self->priv->map;
	if (_tmp43_ != NULL) {
		GeeMultiMap* _tmp44_;
		_tmp44_ = other->priv->map;
		_tmp42_ = _tmp44_ != NULL;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp45_;
		GeeSet* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* other_keys = NULL;
		GeeMultiMap* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
		_tmp45_ = self->priv->map;
		_tmp46_ = gee_multi_map_get_keys (_tmp45_);
		keys = _tmp46_;
		_tmp47_ = keys;
		_vala_assert (_tmp47_ != NULL, "keys != null");
		_tmp48_ = other->priv->map;
		_tmp49_ = gee_multi_map_get_keys (_tmp48_);
		other_keys = _tmp49_;
		_tmp50_ = other_keys;
		_vala_assert (_tmp50_ != NULL, "other_keys != null");
		{
			GeeIterator* _subject_it = NULL;
			GeeSet* _tmp51_;
			GeeIterator* _tmp52_;
			_tmp51_ = other_keys;
			_tmp52_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ITERABLE, GeeIterable));
			_subject_it = _tmp52_;
			while (TRUE) {
				GeeIterator* _tmp53_;
				gchar* subject = NULL;
				GeeIterator* _tmp54_;
				gpointer _tmp55_;
				GeeSet* _tmp56_;
				const gchar* _tmp57_;
				GeeCollection* details = NULL;
				GeeMultiMap* _tmp58_;
				const gchar* _tmp59_;
				GeeCollection* _tmp60_;
				GeeCollection* other_details = NULL;
				GeeMultiMap* _tmp61_;
				const gchar* _tmp62_;
				GeeCollection* _tmp63_;
				gboolean _tmp64_ = FALSE;
				GeeCollection* _tmp65_;
				_tmp53_ = _subject_it;
				if (!gee_iterator_next (_tmp53_)) {
					break;
				}
				_tmp54_ = _subject_it;
				_tmp55_ = gee_iterator_get (_tmp54_);
				subject = (gchar*) _tmp55_;
				_tmp56_ = keys;
				_tmp57_ = subject;
				if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_COLLECTION, GeeCollection), _tmp57_)) {
					_g_free0 (subject);
					continue;
				}
				_tmp58_ = self->priv->map;
				_tmp59_ = subject;
				_tmp60_ = gee_multi_map_get (_tmp58_, _tmp59_);
				details = _tmp60_;
				_tmp61_ = other->priv->map;
				_tmp62_ = subject;
				_tmp63_ = gee_multi_map_get (_tmp61_, _tmp62_);
				other_details = _tmp63_;
				_tmp65_ = details;
				if (_tmp65_ != NULL) {
					GeeCollection* _tmp66_;
					_tmp66_ = other_details;
					_tmp64_ = _tmp66_ != NULL;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					{
						GeeIterator* _detail_it = NULL;
						GeeCollection* _tmp67_;
						GeeIterator* _tmp68_;
						_tmp67_ = other_details;
						_tmp68_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_ITERABLE, GeeIterable));
						_detail_it = _tmp68_;
						while (TRUE) {
							GeeIterator* _tmp69_;
							gchar* detail = NULL;
							GeeIterator* _tmp70_;
							gpointer _tmp71_;
							GeeCollection* _tmp72_;
							const gchar* _tmp73_;
							_tmp69_ = _detail_it;
							if (!gee_iterator_next (_tmp69_)) {
								break;
							}
							_tmp70_ = _detail_it;
							_tmp71_ = gee_iterator_get (_tmp70_);
							detail = (gchar*) _tmp71_;
							_tmp72_ = details;
							_tmp73_ = detail;
							if (gee_collection_contains (_tmp72_, _tmp73_)) {
								result = TRUE;
								_g_free0 (detail);
								_g_object_unref0 (_detail_it);
								_g_object_unref0 (other_details);
								_g_object_unref0 (details);
								_g_free0 (subject);
								_g_object_unref0 (_subject_it);
								_g_object_unref0 (other_keys);
								_g_object_unref0 (keys);
								return result;
							}
							_g_free0 (detail);
						}
						_g_object_unref0 (_detail_it);
					}
				}
				_g_object_unref0 (other_details);
				_g_object_unref0 (details);
				_g_free0 (subject);
			}
			_g_object_unref0 (_subject_it);
		}
		_g_object_unref0 (other_keys);
		_g_object_unref0 (keys);
	}
	result = FALSE;
	return result;
}

gboolean
alteration_equals (Alteration* self,
                   Alteration* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp12_ = FALSE;
	GeeMultiMap* _tmp13_;
	gboolean result;
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->subject;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = other->priv->subject;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->detail;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		_tmp6_ = other->priv->detail;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->subject;
		_tmp9_ = other->priv->subject;
		if (alteration_equal_values (_tmp8_, _tmp9_)) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->detail;
			_tmp11_ = other->priv->detail;
			_tmp7_ = alteration_equal_values (_tmp10_, _tmp11_);
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		return result;
	}
	_tmp13_ = self->priv->map;
	if (_tmp13_ != NULL) {
		GeeMultiMap* _tmp14_;
		_tmp14_ = other->priv->map;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* other_keys = NULL;
		GeeMultiMap* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeSet* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		GeeSet* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
		_tmp15_ = self->priv->map;
		_tmp16_ = gee_multi_map_get_keys (_tmp15_);
		keys = _tmp16_;
		_tmp17_ = keys;
		_vala_assert (_tmp17_ != NULL, "keys != null");
		_tmp18_ = other->priv->map;
		_tmp19_ = gee_multi_map_get_keys (_tmp18_);
		other_keys = _tmp19_;
		_tmp20_ = other_keys;
		_vala_assert (_tmp20_ != NULL, "other_keys != null");
		_tmp21_ = keys;
		_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp23_ = _tmp22_;
		_tmp24_ = other_keys;
		_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp26_ = _tmp25_;
		if (_tmp23_ != _tmp26_) {
			result = FALSE;
			_g_object_unref0 (other_keys);
			_g_object_unref0 (keys);
			return result;
		}
		_tmp27_ = keys;
		_tmp28_ = other_keys;
		if (!gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection))) {
			result = FALSE;
			_g_object_unref0 (other_keys);
			_g_object_unref0 (keys);
			return result;
		}
		_tmp29_ = other_keys;
		_tmp30_ = keys;
		if (!gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection))) {
			result = FALSE;
			_g_object_unref0 (other_keys);
			_g_object_unref0 (keys);
			return result;
		}
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp31_;
			GeeIterator* _tmp32_;
			_tmp31_ = keys;
			_tmp32_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ITERABLE, GeeIterable));
			_key_it = _tmp32_;
			while (TRUE) {
				GeeIterator* _tmp33_;
				gchar* key = NULL;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				GeeCollection* values = NULL;
				GeeMultiMap* _tmp36_;
				const gchar* _tmp37_;
				GeeCollection* _tmp38_;
				GeeCollection* other_values = NULL;
				GeeMultiMap* _tmp39_;
				const gchar* _tmp40_;
				GeeCollection* _tmp41_;
				GeeCollection* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				GeeCollection* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				GeeCollection* _tmp48_;
				GeeCollection* _tmp49_;
				GeeCollection* _tmp50_;
				GeeCollection* _tmp51_;
				_tmp33_ = _key_it;
				if (!gee_iterator_next (_tmp33_)) {
					break;
				}
				_tmp34_ = _key_it;
				_tmp35_ = gee_iterator_get (_tmp34_);
				key = (gchar*) _tmp35_;
				_tmp36_ = self->priv->map;
				_tmp37_ = key;
				_tmp38_ = gee_multi_map_get (_tmp36_, _tmp37_);
				values = _tmp38_;
				_tmp39_ = other->priv->map;
				_tmp40_ = key;
				_tmp41_ = gee_multi_map_get (_tmp39_, _tmp40_);
				other_values = _tmp41_;
				_tmp42_ = values;
				_tmp43_ = gee_collection_get_size (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = other_values;
				_tmp46_ = gee_collection_get_size (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp44_ != _tmp47_) {
					result = FALSE;
					_g_object_unref0 (other_values);
					_g_object_unref0 (values);
					_g_free0 (key);
					_g_object_unref0 (_key_it);
					_g_object_unref0 (other_keys);
					_g_object_unref0 (keys);
					return result;
				}
				_tmp48_ = values;
				_tmp49_ = other_values;
				if (!gee_collection_contains_all (_tmp48_, _tmp49_)) {
					result = FALSE;
					_g_object_unref0 (other_values);
					_g_object_unref0 (values);
					_g_free0 (key);
					_g_object_unref0 (_key_it);
					_g_object_unref0 (other_keys);
					_g_object_unref0 (keys);
					return result;
				}
				_tmp50_ = other_values;
				_tmp51_ = values;
				if (!gee_collection_contains_all (_tmp50_, _tmp51_)) {
					result = FALSE;
					_g_object_unref0 (other_values);
					_g_object_unref0 (values);
					_g_free0 (key);
					_g_object_unref0 (_key_it);
					_g_object_unref0 (other_keys);
					_g_object_unref0 (keys);
					return result;
				}
				_g_object_unref0 (other_values);
				_g_object_unref0 (values);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		result = TRUE;
		_g_object_unref0 (other_keys);
		_g_object_unref0 (keys);
		return result;
	}
	result = FALSE;
	return result;
}

static void
alteration_multimap_add_all (GeeMultiMap* dest,
                             GeeMultiMap* src)
{
	GeeSet* keys = NULL;
	GeeSet* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, GEE_TYPE_MULTI_MAP));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (src, GEE_TYPE_MULTI_MAP));
	_tmp0_ = gee_multi_map_get_keys (src);
	keys = _tmp0_;
	{
		GeeIterator* _key_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = keys;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_key_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			gchar* key = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GeeCollection* values = NULL;
			const gchar* _tmp6_;
			GeeCollection* _tmp7_;
			_tmp3_ = _key_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _key_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			key = (gchar*) _tmp5_;
			_tmp6_ = key;
			_tmp7_ = gee_multi_map_get (src, _tmp6_);
			values = _tmp7_;
			{
				GeeIterator* _value_it = NULL;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_;
				_tmp8_ = values;
				_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
				_value_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					gchar* value = NULL;
					GeeIterator* _tmp11_;
					gpointer _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp10_ = _value_it;
					if (!gee_iterator_next (_tmp10_)) {
						break;
					}
					_tmp11_ = _value_it;
					_tmp12_ = gee_iterator_get (_tmp11_);
					value = (gchar*) _tmp12_;
					_tmp13_ = key;
					_tmp14_ = value;
					gee_multi_map_set (dest, _tmp13_, _tmp14_);
					_g_free0 (value);
				}
				_g_object_unref0 (_value_it);
			}
			_g_object_unref0 (values);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	_g_object_unref0 (keys);
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

Alteration*
alteration_compress (Alteration* self,
                     Alteration* other)
{
	GeeMultiMap* compressed = NULL;
	GeeMultiMap* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	GeeMultiMap* _tmp20_;
	Alteration* _tmp21_;
	Alteration* result;
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
	g_return_val_if_fail (IS_ALTERATION (other), NULL);
	if (alteration_equals (self, other)) {
		Alteration* _tmp0_;
		_tmp0_ = _alteration_ref0 (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = alteration_create_map (self);
	compressed = _tmp1_;
	_tmp3_ = self->priv->subject;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->detail;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeMultiMap* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = compressed;
		_tmp6_ = self->priv->subject;
		_tmp7_ = self->priv->detail;
		gee_multi_map_set (_tmp5_, _tmp6_, _tmp7_);
	} else {
		GeeMultiMap* _tmp8_;
		GeeMultiMap* _tmp9_;
		GeeMultiMap* _tmp10_;
		_tmp8_ = self->priv->map;
		_vala_assert (_tmp8_ != NULL, "map != null");
		_tmp9_ = compressed;
		_tmp10_ = self->priv->map;
		alteration_multimap_add_all (_tmp9_, _tmp10_);
	}
	_tmp12_ = other->priv->subject;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = other->priv->detail;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GeeMultiMap* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = compressed;
		_tmp15_ = other->priv->subject;
		_tmp16_ = other->priv->detail;
		gee_multi_map_set (_tmp14_, _tmp15_, _tmp16_);
	} else {
		GeeMultiMap* _tmp17_;
		GeeMultiMap* _tmp18_;
		GeeMultiMap* _tmp19_;
		_tmp17_ = other->priv->map;
		_vala_assert (_tmp17_ != NULL, "other.map != null");
		_tmp18_ = compressed;
		_tmp19_ = other->priv->map;
		alteration_multimap_add_all (_tmp18_, _tmp19_);
	}
	_tmp20_ = compressed;
	_tmp21_ = alteration_new_from_map (_tmp20_);
	result = _tmp21_;
	_g_object_unref0 (compressed);
	return result;
}

static void
value_alteration_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_alteration_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		alteration_unref (value->data[0].v_pointer);
	}
}

static void
value_alteration_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alteration_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_alteration_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_alteration_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Alteration * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alteration_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_alteration_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Alteration ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alteration_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_alteration (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecAlteration* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ALTERATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_alteration (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_alteration (GValue* value,
                      gpointer v_object)
{
	Alteration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alteration_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alteration_unref (old);
	}
}

void
value_take_alteration (GValue* value,
                       gpointer v_object)
{
	Alteration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alteration_unref (old);
	}
}

static void
alteration_class_init (AlterationClass * klass,
                       gpointer klass_data)
{
	alteration_parent_class = g_type_class_peek_parent (klass);
	((AlterationClass *) klass)->finalize = alteration_finalize;
	g_type_class_adjust_private_offset (klass, &Alteration_private_offset);
}

static void
alteration_instance_init (Alteration * self,
                          gpointer klass)
{
	self->priv = alteration_get_instance_private (self);
	self->priv->subject = NULL;
	self->priv->detail = NULL;
	self->priv->map = NULL;
	self->ref_count = 1;
}

static void
alteration_finalize (Alteration * obj)
{
	Alteration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ALTERATION, Alteration);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->subject);
	_g_free0 (self->priv->detail);
	_g_object_unref0 (self->priv->map);
}

static GType
alteration_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_alteration_init, value_alteration_free_value, value_alteration_copy_value, value_alteration_peek_pointer, "p", value_alteration_collect_value, "p", value_alteration_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AlterationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alteration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Alteration), 0, (GInstanceInitFunc) alteration_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType alteration_type_id;
	alteration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Alteration", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Alteration_private_offset = g_type_add_instance_private (alteration_type_id, sizeof (AlterationPrivate));
	return alteration_type_id;
}

GType
alteration_get_type (void)
{
	static volatile gsize alteration_type_id__once = 0;
	if (g_once_init_enter (&alteration_type_id__once)) {
		GType alteration_type_id;
		alteration_type_id = alteration_get_type_once ();
		g_once_init_leave (&alteration_type_id__once, alteration_type_id);
	}
	return alteration_type_id__once;
}

gpointer
alteration_ref (gpointer instance)
{
	Alteration * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
alteration_unref (gpointer instance)
{
	Alteration * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALTERATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

