/* DiscoveredCamera.c generated by valac 0.56.17, the Vala compiler
 * generated from DiscoveredCamera.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gphoto2/gphoto2-camera.h>
#include <shotwell-gphoto-helper.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gphoto2/gphoto2-abilities-list.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gio/gio.h>
#include <gudev/gudev.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DISCOVERED_CAMERA (discovered_camera_get_type ())
#define DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCamera))
#define DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))
#define IS_DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISCOVERED_CAMERA))
#define IS_DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISCOVERED_CAMERA))
#define DISCOVERED_CAMERA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))

typedef struct _DiscoveredCamera DiscoveredCamera;
typedef struct _DiscoveredCameraClass DiscoveredCameraClass;
typedef struct _DiscoveredCameraPrivate DiscoveredCameraPrivate;
#define _gp_camera_unref0(var) ((var == NULL) ? NULL : (var = (gp_camera_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GPHOTO_ERROR (gphoto_error_get_type ())
#define _discovered_camera_unref0(var) ((var == NULL) ? NULL : (var = (discovered_camera_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ParamSpecDiscoveredCamera ParamSpecDiscoveredCamera;

struct _DiscoveredCamera {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DiscoveredCameraPrivate * priv;
	Camera* gcamera;
	gchar* uri;
	gchar* display_name;
	gchar* icon;
};

struct _DiscoveredCameraClass {
	GTypeClass parent_class;
	void (*finalize) (DiscoveredCamera *self);
};

struct _DiscoveredCameraPrivate {
	gchar* port;
	gchar* camera_name;
	gchar** mount_uris;
	gint mount_uris_length1;
	gint _mount_uris_size_;
};

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()

struct _ParamSpecDiscoveredCamera {
	GParamSpec parent_instance;
};

static gint DiscoveredCamera_private_offset;
static gpointer discovered_camera_parent_class = NULL;

VALA_EXTERN gpointer discovered_camera_ref (gpointer instance);
VALA_EXTERN void discovered_camera_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_discovered_camera (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_discovered_camera (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_discovered_camera (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_discovered_camera (const GValue* value);
VALA_EXTERN GType discovered_camera_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DiscoveredCamera, discovered_camera_unref)
VALA_EXTERN GQuark gphoto_error_quark (void);
VALA_EXTERN GType gphoto_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN DiscoveredCamera* discovered_camera_new (const gchar* name,
                                         const gchar* port,
                                         GPPortInfo port_info,
                                         CameraAbilities camera_abilities,
                                         GError** error);
VALA_EXTERN DiscoveredCamera* discovered_camera_construct (GType object_type,
                                               const gchar* name,
                                               const gchar* port,
                                               GPPortInfo port_info,
                                               CameraAbilities camera_abilities,
                                               GError** error);
static void _vala_array_add67 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add68 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar* discovered_camera_get_port_path (DiscoveredCamera* self,
                                        const gchar* port);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_add69 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add70 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN GMount* discovered_camera_get_mount (DiscoveredCamera* self);
static void discovered_camera_finalize (DiscoveredCamera * obj);
static GType discovered_camera_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
discovered_camera_get_instance_private (DiscoveredCamera* self)
{
	return G_STRUCT_MEMBER_P (self, DiscoveredCamera_private_offset);
}

static void
_vala_array_add67 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add68 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_vala_array_add69 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add70 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

DiscoveredCamera*
discovered_camera_construct (GType object_type,
                             const gchar* name,
                             const gchar* port,
                             GPPortInfo port_info,
                             CameraAbilities camera_abilities,
                             GError** error)
{
	DiscoveredCamera* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	int res = 0;
	Camera* _tmp7_ = NULL;
	int _tmp8_;
	Camera* _tmp11_;
	Camera* _tmp14_;
	gchar* path = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp78_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (port != NULL, NULL);
	self = (DiscoveredCamera*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (port);
	_g_free0 (self->priv->port);
	self->priv->port = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->priv->camera_name);
	self->priv->camera_name = _tmp1_;
	_tmp2_ = g_strdup_printf ("gphoto2://[%s]", port);
	_g_free0 (self->uri);
	self->uri = _tmp2_;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->mount_uris = (_vala_array_free (self->priv->mount_uris, self->priv->mount_uris_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mount_uris = _tmp3_;
	self->priv->mount_uris_length1 = 0;
	self->priv->_mount_uris_size_ = self->priv->mount_uris_length1;
	_tmp4_ = self->uri;
	_tmp5_ = g_strdup (_tmp4_);
	_vala_array_add67 (&self->priv->mount_uris, &self->priv->mount_uris_length1, &self->priv->_mount_uris_size_, _tmp5_);
	_tmp6_ = g_strdup_printf ("mtp://[%s]", port);
	_vala_array_add68 (&self->priv->mount_uris, &self->priv->mount_uris_length1, &self->priv->_mount_uris_size_, _tmp6_);
	_tmp8_ = gp_camera_new (&_tmp7_);
	_gp_camera_unref0 (self->gcamera);
	self->gcamera = _tmp7_;
	res = _tmp8_;
	if (res != GP_OK) {
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp9_ = gp_port_result_as_string (res);
		_tmp10_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to create camera object for %s: %s", (gint) res, name, _tmp9_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_discovered_camera_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = self->gcamera;
	res = gp_camera_set_abilities (_tmp11_, camera_abilities);
	if (res != GP_OK) {
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp12_ = gp_port_result_as_string (res);
		_tmp13_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to set camera abilities for %s: %s", (gint) res, name, _tmp12_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_discovered_camera_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = self->gcamera;
	res = gp_camera_set_port_info (_tmp14_, port_info);
	if (res != GP_OK) {
		const gchar* _tmp15_;
		GError* _tmp16_;
		_tmp15_ = gp_port_result_as_string (res);
		_tmp16_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to set port infor for %s: %s", (gint) res, name, _tmp15_);
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_discovered_camera_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp17_ = discovered_camera_get_port_path (self, port);
	path = _tmp17_;
	_tmp18_ = path;
	if (_tmp18_ != NULL) {
		GVolumeMonitor* monitor = NULL;
		GVolumeMonitor* _tmp19_;
		GVolumeMonitor* _tmp20_;
		GList* _tmp21_;
		GUdevClient* client = NULL;
		GUdevClient* _tmp34_;
		GUdevDevice* device = NULL;
		GUdevClient* _tmp35_;
		const gchar* _tmp36_;
		GUdevDevice* _tmp37_;
		gchar* serial = NULL;
		GUdevDevice* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp49_;
		_tmp19_ = g_volume_monitor_get ();
		monitor = _tmp19_;
		_tmp20_ = monitor;
		_tmp21_ = g_volume_monitor_get_volumes (_tmp20_);
		{
			GList* volume_collection = NULL;
			GList* volume_it = NULL;
			volume_collection = _tmp21_;
			for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
				GVolume* _tmp22_;
				GVolume* volume = NULL;
				_tmp22_ = _g_object_ref0 ((GVolume*) volume_it->data);
				volume = _tmp22_;
				{
					GVolume* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					const gchar* _tmp26_;
					gboolean _tmp27_;
					_tmp23_ = volume;
					_tmp24_ = g_volume_get_identifier (_tmp23_, G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE);
					_tmp25_ = _tmp24_;
					_tmp26_ = path;
					_tmp27_ = g_strcmp0 (_tmp25_, _tmp26_) == 0;
					_g_free0 (_tmp25_);
					if (_tmp27_) {
						GVolume* _tmp28_;
						gchar* _tmp29_;
						GVolume* _tmp30_;
						GIcon* _tmp31_;
						GIcon* _tmp32_;
						gchar* _tmp33_;
						_tmp28_ = volume;
						_tmp29_ = g_volume_get_name (_tmp28_);
						_g_free0 (self->display_name);
						self->display_name = _tmp29_;
						_tmp30_ = volume;
						_tmp31_ = g_volume_get_symbolic_icon (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_icon_to_string (_tmp32_);
						_g_free0 (self->icon);
						self->icon = _tmp33_;
						_g_object_unref0 (_tmp32_);
					}
					_g_object_unref0 (volume);
				}
			}
			(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
		}
		_tmp34_ = g_udev_client_new (NULL);
		client = _tmp34_;
		_tmp35_ = client;
		_tmp36_ = path;
		_tmp37_ = g_udev_client_query_by_device_file (_tmp35_, _tmp36_);
		device = _tmp37_;
		_tmp38_ = device;
		_tmp39_ = g_udev_device_get_property (_tmp38_, "ID_SERIAL");
		_tmp40_ = g_strdup (_tmp39_);
		serial = _tmp40_;
		_tmp41_ = serial;
		_tmp42_ = g_strdup_printf ("gphoto2://%s", _tmp41_);
		_vala_array_add69 (&self->priv->mount_uris, &self->priv->mount_uris_length1, &self->priv->_mount_uris_size_, _tmp42_);
		_tmp43_ = serial;
		_tmp44_ = g_strdup_printf ("mtp://%s", _tmp43_);
		_vala_array_add70 (&self->priv->mount_uris, &self->priv->mount_uris_length1, &self->priv->_mount_uris_size_, _tmp44_);
		_tmp45_ = self->display_name;
		if (_tmp45_ == NULL) {
			GUdevDevice* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp46_ = device;
			_tmp47_ = g_udev_device_get_sysfs_attr (_tmp46_, "product");
			_tmp48_ = g_strdup (_tmp47_);
			_g_free0 (self->display_name);
			self->display_name = _tmp48_;
		}
		_tmp49_ = self->display_name;
		if (_tmp49_ == NULL) {
			GUdevDevice* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp50_ = device;
			_tmp51_ = g_udev_device_get_property (_tmp50_, "ID_MODEL");
			_tmp52_ = g_strdup (_tmp51_);
			_g_free0 (self->display_name);
			self->display_name = _tmp52_;
		}
		_g_free0 (serial);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_object_unref0 (monitor);
	}
	if (g_str_has_prefix (port, "disk:")) {
		{
			GMount* mount = NULL;
			gchar* _tmp53_;
			gchar* _tmp54_;
			GFile* _tmp55_;
			GFile* _tmp56_;
			GMount* _tmp57_;
			GMount* _tmp58_;
			GVolume* volume = NULL;
			GMount* _tmp59_;
			GVolume* _tmp60_;
			GVolume* _tmp61_;
			_tmp53_ = string_substring (port, (glong) 5, (glong) -1);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_file_new_for_path (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_file_find_enclosing_mount (_tmp56_, NULL, &_inner_error0_);
			_tmp58_ = _tmp57_;
			_g_object_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
			mount = _tmp58_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp59_ = mount;
			_tmp60_ = g_mount_get_volume (_tmp59_);
			volume = _tmp60_;
			_tmp61_ = volume;
			if (_tmp61_ != NULL) {
				GVolume* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				GVolume* _tmp66_;
				GIcon* _tmp67_;
				GIcon* _tmp68_;
				gchar* _tmp69_;
				_tmp62_ = volume;
				_tmp63_ = g_volume_get_name (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf (_ ("%s (%s)"), name, _tmp64_);
				_g_free0 (self->display_name);
				self->display_name = _tmp65_;
				_g_free0 (_tmp64_);
				_tmp66_ = volume;
				_tmp67_ = g_volume_get_symbolic_icon (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_icon_to_string (_tmp68_);
				_g_free0 (self->icon);
				self->icon = _tmp69_;
				_g_object_unref0 (_tmp68_);
			} else {
				GMount* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				GMount* _tmp74_;
				GIcon* _tmp75_;
				GIcon* _tmp76_;
				gchar* _tmp77_;
				_tmp70_ = mount;
				_tmp71_ = g_mount_get_name (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strdup_printf (_ ("%s (%s)"), name, _tmp72_);
				_g_free0 (self->display_name);
				self->display_name = _tmp73_;
				_g_free0 (_tmp72_);
				_tmp74_ = mount;
				_tmp75_ = g_mount_get_symbolic_icon (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_icon_to_string (_tmp76_);
				_g_free0 (self->icon);
				self->icon = _tmp77_;
				_g_object_unref0 (_tmp76_);
			}
			_g_object_unref0 (volume);
			_g_object_unref0 (mount);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (path);
				_discovered_camera_unref0 (self);
				return NULL;
			} else {
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp78_ = self->display_name;
	if (_tmp78_ == NULL) {
		const gchar* _tmp79_;
		gchar* _tmp80_;
		_tmp79_ = self->priv->camera_name;
		_tmp80_ = g_strdup (_tmp79_);
		_g_free0 (self->display_name);
		self->display_name = _tmp80_;
	}
	_g_free0 (path);
	return self;
}

DiscoveredCamera*
discovered_camera_new (const gchar* name,
                       const gchar* port,
                       GPPortInfo port_info,
                       CameraAbilities camera_abilities,
                       GError** error)
{
	return discovered_camera_construct (TYPE_DISCOVERED_CAMERA, name, port, port_info, camera_abilities, error);
}

GMount*
discovered_camera_get_mount (DiscoveredCamera* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	GMount* result;
	g_return_val_if_fail (IS_DISCOVERED_CAMERA (self), NULL);
	_tmp0_ = self->priv->mount_uris;
	_tmp0__length1 = self->priv->mount_uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp0_;
		uri_collection_length1 = _tmp0__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp1_;
			gchar* uri = NULL;
			_tmp1_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp1_;
			{
				GFile* f = NULL;
				const gchar* _tmp2_;
				GFile* _tmp3_;
				_tmp2_ = uri;
				_tmp3_ = g_file_new_for_uri (_tmp2_);
				f = _tmp3_;
				{
					GMount* mount = NULL;
					GFile* _tmp4_;
					GMount* _tmp5_;
					GMount* _tmp6_;
					_tmp4_ = f;
					_tmp5_ = g_file_find_enclosing_mount (_tmp4_, NULL, &_inner_error0_);
					mount = _tmp5_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp6_ = mount;
					if (_tmp6_ != NULL) {
						result = mount;
						_g_object_unref0 (f);
						_g_free0 (uri);
						return result;
					}
					_g_object_unref0 (mount);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (f);
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_object_unref0 (f);
				_g_free0 (uri);
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
discovered_camera_get_port_path (DiscoveredCamera* self,
                                 const gchar* port)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_DISCOVERED_CAMERA (self), NULL);
	g_return_val_if_fail (port != NULL, NULL);
	if (g_str_has_prefix (port, "usb:")) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = string_substring (port, (glong) 4, (glong) -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_replace (_tmp2_, ",", "/");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("/dev/bus/usb/%s", _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static void
value_discovered_camera_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_discovered_camera_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		discovered_camera_unref (value->data[0].v_pointer);
	}
}

static void
value_discovered_camera_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = discovered_camera_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_discovered_camera_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_discovered_camera_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DiscoveredCamera * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = discovered_camera_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_discovered_camera_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	DiscoveredCamera ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = discovered_camera_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_discovered_camera (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecDiscoveredCamera* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DISCOVERED_CAMERA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_discovered_camera (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA), NULL);
	return value->data[0].v_pointer;
}

void
value_set_discovered_camera (GValue* value,
                             gpointer v_object)
{
	DiscoveredCamera * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		discovered_camera_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		discovered_camera_unref (old);
	}
}

void
value_take_discovered_camera (GValue* value,
                              gpointer v_object)
{
	DiscoveredCamera * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		discovered_camera_unref (old);
	}
}

static void
discovered_camera_class_init (DiscoveredCameraClass * klass,
                              gpointer klass_data)
{
	discovered_camera_parent_class = g_type_class_peek_parent (klass);
	((DiscoveredCameraClass *) klass)->finalize = discovered_camera_finalize;
	g_type_class_adjust_private_offset (klass, &DiscoveredCamera_private_offset);
}

static void
discovered_camera_instance_init (DiscoveredCamera * self,
                                 gpointer klass)
{
	self->priv = discovered_camera_get_instance_private (self);
	self->ref_count = 1;
}

static void
discovered_camera_finalize (DiscoveredCamera * obj)
{
	DiscoveredCamera * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DISCOVERED_CAMERA, DiscoveredCamera);
	g_signal_handlers_destroy (self);
	_gp_camera_unref0 (self->gcamera);
	_g_free0 (self->uri);
	_g_free0 (self->display_name);
	_g_free0 (self->icon);
	_g_free0 (self->priv->port);
	_g_free0 (self->priv->camera_name);
	self->priv->mount_uris = (_vala_array_free (self->priv->mount_uris, self->priv->mount_uris_length1, (GDestroyNotify) g_free), NULL);
}

static GType
discovered_camera_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_discovered_camera_init, value_discovered_camera_free_value, value_discovered_camera_copy_value, value_discovered_camera_peek_pointer, "p", value_discovered_camera_collect_value, "p", value_discovered_camera_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DiscoveredCameraClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) discovered_camera_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DiscoveredCamera), 0, (GInstanceInitFunc) discovered_camera_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType discovered_camera_type_id;
	discovered_camera_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DiscoveredCamera", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DiscoveredCamera_private_offset = g_type_add_instance_private (discovered_camera_type_id, sizeof (DiscoveredCameraPrivate));
	return discovered_camera_type_id;
}

GType
discovered_camera_get_type (void)
{
	static volatile gsize discovered_camera_type_id__once = 0;
	if (g_once_init_enter (&discovered_camera_type_id__once)) {
		GType discovered_camera_type_id;
		discovered_camera_type_id = discovered_camera_get_type_once ();
		g_once_init_leave (&discovered_camera_type_id__once, discovered_camera_type_id);
	}
	return discovered_camera_type_id__once;
}

gpointer
discovered_camera_ref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
discovered_camera_unref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DISCOVERED_CAMERA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

