/* Upgrades.c generated by valac 0.56.17, the Vala compiler
 * generated from Upgrades.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Class for aggregating one-off "upgrade" tasks that occur at startup, such as*/
/* moving or deleting files. This occurs after the UI is shown, so it's not appropriate*/
/* for database updates and such.*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "shotwell-graphics-processor.h"
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UPGRADES (upgrades_get_type ())
#define UPGRADES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPGRADES, Upgrades))
#define UPGRADES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPGRADES, UpgradesClass))
#define IS_UPGRADES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPGRADES))
#define IS_UPGRADES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPGRADES))
#define UPGRADES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPGRADES, UpgradesClass))

typedef struct _Upgrades Upgrades;
typedef struct _UpgradesClass UpgradesClass;
typedef struct _UpgradesPrivate UpgradesPrivate;

#define TYPE_UPGRADE_TASK (upgrade_task_get_type ())
#define UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPGRADE_TASK, UpgradeTask))
#define IS_UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPGRADE_TASK))
#define UPGRADE_TASK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UPGRADE_TASK, UpgradeTaskIface))

typedef struct _UpgradeTask UpgradeTask;
typedef struct _UpgradeTaskIface UpgradeTaskIface;
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MIMICS_REMOVAL_TASK (mimics_removal_task_get_type ())
#define MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask))
#define MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))
#define IS_MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MIMICS_REMOVAL_TASK))
#define IS_MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MIMICS_REMOVAL_TASK))
#define MIMICS_REMOVAL_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))

typedef struct _MimicsRemovalTask MimicsRemovalTask;
typedef struct _MimicsRemovalTaskClass MimicsRemovalTaskClass;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_FIXUP_RAW_THUMBNAILS_TASK (fixup_raw_thumbnails_task_get_type ())
#define FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask))
#define FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))
#define IS_FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define IS_FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define FIXUP_RAW_THUMBNAILS_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))

typedef struct _FixupRawThumbnailsTask FixupRawThumbnailsTask;
typedef struct _FixupRawThumbnailsTaskClass FixupRawThumbnailsTaskClass;
#define _upgrades_unref0(var) ((var == NULL) ? NULL : (var = (upgrades_unref (var), NULL)))
typedef struct _ParamSpecUpgrades ParamSpecUpgrades;
typedef struct _MimicsRemovalTaskPrivate MimicsRemovalTaskPrivate;
enum  {
	MIMICS_REMOVAL_TASK_0_PROPERTY,
	MIMICS_REMOVAL_TASK_NUM_PROPERTIES
};
static GParamSpec* mimics_removal_task_properties[MIMICS_REMOVAL_TASK_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FixupRawThumbnailsTaskPrivate FixupRawThumbnailsTaskPrivate;
enum  {
	FIXUP_RAW_THUMBNAILS_TASK_0_PROPERTY,
	FIXUP_RAW_THUMBNAILS_TASK_NUM_PROPERTIES
};
static GParamSpec* fixup_raw_thumbnails_task_properties[FIXUP_RAW_THUMBNAILS_TASK_NUM_PROPERTIES];

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Upgrades {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UpgradesPrivate * priv;
};

struct _UpgradesClass {
	GTypeClass parent_class;
	void (*finalize) (Upgrades *self);
};

struct _UpgradeTaskIface {
	GTypeInterface parent_iface;
	guint64 (*get_step_count) (UpgradeTask* self);
	void (*execute) (UpgradeTask* self, ProgressMonitor monitor, gpointer monitor_target);
};

struct _UpgradesPrivate {
	guint64 total_steps;
	GeeLinkedList* task_list;
};

struct _ParamSpecUpgrades {
	GParamSpec parent_instance;
};

struct _MimicsRemovalTask {
	GObject parent_instance;
	MimicsRemovalTaskPrivate * priv;
};

struct _MimicsRemovalTaskClass {
	GObjectClass parent_class;
};

struct _MimicsRemovalTaskPrivate {
	GFile* mimic_dir;
	guint64 num_mimics;
};

struct _FixupRawThumbnailsTask {
	GObject parent_instance;
	FixupRawThumbnailsTaskPrivate * priv;
};

struct _FixupRawThumbnailsTaskClass {
	GObjectClass parent_class;
};

struct _PhotoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	gint64 time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	GpsCoords gps_coords;
	gchar* comment;
	gchar* backlinks;
	gint64 time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

static gint Upgrades_private_offset;
static gpointer upgrades_parent_class = NULL;
static Upgrades* upgrades_instance;
static Upgrades* upgrades_instance = NULL;
static gint MimicsRemovalTask_private_offset;
static gpointer mimics_removal_task_parent_class = NULL;
static UpgradeTaskIface * mimics_removal_task_upgrade_task_parent_iface = NULL;
static gpointer fixup_raw_thumbnails_task_parent_class = NULL;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
static UpgradeTaskIface * fixup_raw_thumbnails_task_upgrade_task_parent_iface = NULL;

VALA_EXTERN gpointer upgrades_ref (gpointer instance);
VALA_EXTERN void upgrades_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_upgrades (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_upgrades (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_upgrades (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_upgrades (const GValue* value);
VALA_EXTERN GType upgrades_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Upgrades, upgrades_unref)
VALA_EXTERN GType upgrade_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UpgradeTask, g_object_unref)
static Upgrades* upgrades_new (void);
static Upgrades* upgrades_construct (GType object_type);
static void upgrades_add (Upgrades* self,
                   UpgradeTask* task);
VALA_EXTERN MimicsRemovalTask* mimics_removal_task_new (void);
VALA_EXTERN MimicsRemovalTask* mimics_removal_task_construct (GType object_type);
VALA_EXTERN GType mimics_removal_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MimicsRemovalTask, g_object_unref)
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN Application* application_get_instance (void);
VALA_EXTERN gboolean application_get_raw_thumbs_fix_required (Application* self);
VALA_EXTERN FixupRawThumbnailsTask* fixup_raw_thumbnails_task_new (void);
VALA_EXTERN FixupRawThumbnailsTask* fixup_raw_thumbnails_task_construct (GType object_type);
VALA_EXTERN GType fixup_raw_thumbnails_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FixupRawThumbnailsTask, g_object_unref)
VALA_EXTERN void upgrades_init (void);
VALA_EXTERN Upgrades* upgrades_get_instance (void);
VALA_EXTERN guint64 upgrades_get_step_count (Upgrades* self);
VALA_EXTERN void upgrades_execute (Upgrades* self,
                       ProgressMonitor monitor,
                       gpointer monitor_target);
VALA_EXTERN void upgrade_task_execute (UpgradeTask* self,
                           ProgressMonitor monitor,
                           gpointer monitor_target);
VALA_EXTERN guint64 upgrade_task_get_step_count (UpgradeTask* self);
static void upgrades_finalize (Upgrades * obj);
static GType upgrades_get_type_once (void);
static GType upgrade_task_get_type_once (void);
VALA_EXTERN GFile* app_dirs_get_data_dir (void);
static guint64 mimics_removal_task_real_get_step_count (UpgradeTask* base);
VALA_EXTERN guint64 count_files_in_directory (GFile* dir,
                                  GError** error);
static void mimics_removal_task_real_execute (UpgradeTask* base,
                                       ProgressMonitor monitor,
                                       gpointer monitor_target);
VALA_EXTERN void delete_all_files (GFile* dir,
                       GeeSet* exceptions,
                       ProgressMonitor monitor,
                       gpointer monitor_target,
                       guint64 file_count,
                       GCancellable* cancellable,
                       GError** error);
static void mimics_removal_task_finalize (GObject * obj);
static GType mimics_removal_task_get_type_once (void);
static guint64 fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base);
VALA_EXTERN gpointer photo_row_ref (gpointer instance);
VALA_EXTERN void photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_photo_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_photo_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_photo_row (const GValue* value);
VALA_EXTERN GType photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoRow, photo_row_unref)
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoTable, database_table_unref)
VALA_EXTERN PhotoTable* photo_table_get_instance (void);
VALA_EXTERN GeeArrayList* photo_table_get_all (PhotoTable* self);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
static void fixup_raw_thumbnails_task_real_execute (UpgradeTask* base,
                                             ProgressMonitor monitor,
                                             gpointer monitor_target);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN void thumbnail_cache_remove (ThumbnailSource* source);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self,
                                                     PhotoID* photo_id);
static GType fixup_raw_thumbnails_task_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
upgrades_get_instance_private (Upgrades* self)
{
	return G_STRUCT_MEMBER_P (self, Upgrades_private_offset);
}

static Upgrades*
upgrades_construct (GType object_type)
{
	Upgrades* self = NULL;
	MimicsRemovalTask* _tmp0_;
	MimicsRemovalTask* _tmp1_;
	Application* _tmp2_;
	Application* _tmp3_;
	gboolean _tmp4_;
	self = (Upgrades*) g_type_create_instance (object_type);
	_tmp0_ = mimics_removal_task_new ();
	_tmp1_ = _tmp0_;
	upgrades_add (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_UPGRADE_TASK, UpgradeTask));
	_g_object_unref0 (_tmp1_);
	_tmp2_ = application_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = application_get_raw_thumbs_fix_required (_tmp3_);
	_application_unref0 (_tmp3_);
	if (_tmp4_) {
		FixupRawThumbnailsTask* _tmp5_;
		FixupRawThumbnailsTask* _tmp6_;
		_tmp5_ = fixup_raw_thumbnails_task_new ();
		_tmp6_ = _tmp5_;
		upgrades_add (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_UPGRADE_TASK, UpgradeTask));
		_g_object_unref0 (_tmp6_);
	}
	return self;
}

static Upgrades*
upgrades_new (void)
{
	return upgrades_construct (TYPE_UPGRADES);
}

void
upgrades_init (void)
{
	Upgrades* _tmp0_;
	Upgrades* _tmp1_;
	_tmp0_ = upgrades_instance;
	_vala_assert (_tmp0_ == NULL, "instance == null");
	_tmp1_ = upgrades_new ();
	_upgrades_unref0 (upgrades_instance);
	upgrades_instance = _tmp1_;
}

static gpointer
_upgrades_ref0 (gpointer self)
{
	return self ? upgrades_ref (self) : NULL;
}

Upgrades*
upgrades_get_instance (void)
{
	Upgrades* _tmp0_;
	Upgrades* _tmp1_;
	Upgrades* result;
	_tmp0_ = upgrades_instance;
	_tmp1_ = _upgrades_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

guint64
upgrades_get_step_count (Upgrades* self)
{
	guint64 result;
	g_return_val_if_fail (IS_UPGRADES (self), 0ULL);
	result = self->priv->total_steps;
	return result;
}

void
upgrades_execute (Upgrades* self,
                  ProgressMonitor monitor,
                  gpointer monitor_target)
{
	g_return_if_fail (IS_UPGRADES (self));
	{
		GeeLinkedList* _task_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _task_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _task_index = 0;
		_tmp0_ = self->priv->task_list;
		_task_list = _tmp0_;
		_tmp1_ = _task_list;
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp3_ = _tmp2_;
		_task_size = _tmp3_;
		_task_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			UpgradeTask* task = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			UpgradeTask* _tmp8_;
			_task_index = _task_index + 1;
			_tmp4_ = _task_index;
			_tmp5_ = _task_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _task_list;
			_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _task_index);
			task = (UpgradeTask*) _tmp7_;
			_tmp8_ = task;
			upgrade_task_execute (_tmp8_, monitor, monitor_target);
			_g_object_unref0 (task);
		}
	}
}

static void
upgrades_add (Upgrades* self,
              UpgradeTask* task)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (IS_UPGRADES (self));
	g_return_if_fail (IS_UPGRADE_TASK (task));
	self->priv->total_steps = self->priv->total_steps + upgrade_task_get_step_count (task);
	_tmp0_ = self->priv->task_list;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), task);
}

static void
value_upgrades_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_upgrades_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		upgrades_unref (value->data[0].v_pointer);
	}
}

static void
value_upgrades_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = upgrades_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_upgrades_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_upgrades_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Upgrades * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = upgrades_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_upgrades_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Upgrades ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = upgrades_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_upgrades (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecUpgrades* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UPGRADES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_upgrades (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_upgrades (GValue* value,
                    gpointer v_object)
{
	Upgrades * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		upgrades_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		upgrades_unref (old);
	}
}

void
value_take_upgrades (GValue* value,
                     gpointer v_object)
{
	Upgrades * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		upgrades_unref (old);
	}
}

static void
upgrades_class_init (UpgradesClass * klass,
                     gpointer klass_data)
{
	upgrades_parent_class = g_type_class_peek_parent (klass);
	((UpgradesClass *) klass)->finalize = upgrades_finalize;
	g_type_class_adjust_private_offset (klass, &Upgrades_private_offset);
}

static void
upgrades_instance_init (Upgrades * self,
                        gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = upgrades_get_instance_private (self);
	self->priv->total_steps = (guint64) 0;
	_tmp0_ = gee_linked_list_new (TYPE_UPGRADE_TASK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->task_list = _tmp0_;
	self->ref_count = 1;
}

static void
upgrades_finalize (Upgrades * obj)
{
	Upgrades * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UPGRADES, Upgrades);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->task_list);
}

static GType
upgrades_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_upgrades_init, value_upgrades_free_value, value_upgrades_copy_value, value_upgrades_peek_pointer, "p", value_upgrades_collect_value, "p", value_upgrades_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UpgradesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upgrades_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Upgrades), 0, (GInstanceInitFunc) upgrades_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType upgrades_type_id;
	upgrades_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Upgrades", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Upgrades_private_offset = g_type_add_instance_private (upgrades_type_id, sizeof (UpgradesPrivate));
	return upgrades_type_id;
}

GType
upgrades_get_type (void)
{
	static volatile gsize upgrades_type_id__once = 0;
	if (g_once_init_enter (&upgrades_type_id__once)) {
		GType upgrades_type_id;
		upgrades_type_id = upgrades_get_type_once ();
		g_once_init_leave (&upgrades_type_id__once, upgrades_type_id);
	}
	return upgrades_type_id__once;
}

gpointer
upgrades_ref (gpointer instance)
{
	Upgrades * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
upgrades_unref (gpointer instance)
{
	Upgrades * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UPGRADES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

guint64
upgrade_task_get_step_count (UpgradeTask* self)
{
	UpgradeTaskIface* _iface_;
	g_return_val_if_fail (IS_UPGRADE_TASK (self), 0ULL);
	_iface_ = UPGRADE_TASK_GET_INTERFACE (self);
	if (_iface_->get_step_count) {
		return _iface_->get_step_count (self);
	}
	return 0ULL;
}

void
upgrade_task_execute (UpgradeTask* self,
                      ProgressMonitor monitor,
                      gpointer monitor_target)
{
	UpgradeTaskIface* _iface_;
	g_return_if_fail (IS_UPGRADE_TASK (self));
	_iface_ = UPGRADE_TASK_GET_INTERFACE (self);
	if (_iface_->execute) {
		_iface_->execute (self, monitor, monitor_target);
	}
}

static void
upgrade_task_default_init (UpgradeTaskIface * iface,
                           gpointer iface_data)
{
}

static GType
upgrade_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UpgradeTaskIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upgrade_task_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType upgrade_task_type_id;
	upgrade_task_type_id = g_type_register_static (G_TYPE_INTERFACE, "UpgradeTask", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (upgrade_task_type_id, G_TYPE_OBJECT);
	return upgrade_task_type_id;
}

GType
upgrade_task_get_type (void)
{
	static volatile gsize upgrade_task_type_id__once = 0;
	if (g_once_init_enter (&upgrade_task_type_id__once)) {
		GType upgrade_task_type_id;
		upgrade_task_type_id = upgrade_task_get_type_once ();
		g_once_init_leave (&upgrade_task_type_id__once, upgrade_task_type_id);
	}
	return upgrade_task_type_id__once;
}

static inline gpointer
mimics_removal_task_get_instance_private (MimicsRemovalTask* self)
{
	return G_STRUCT_MEMBER_P (self, MimicsRemovalTask_private_offset);
}

static guint64
mimics_removal_task_real_get_step_count (UpgradeTask* base)
{
	MimicsRemovalTask * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
	{
		guint64 _tmp0_ = 0ULL;
		GFile* _tmp1_;
		_tmp1_ = self->priv->mimic_dir;
		_tmp0_ = count_files_in_directory (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->num_mimics = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("Upgrades.vala:75: Error on deleting mimics: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp4_ = 0ULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = self->priv->num_mimics;
	return result;
}

static void
mimics_removal_task_real_execute (UpgradeTask* base,
                                  ProgressMonitor monitor,
                                  gpointer monitor_target)
{
	MimicsRemovalTask * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
	{
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = self->priv->mimic_dir;
		delete_all_files (_tmp0_, NULL, monitor, monitor_target, self->priv->num_mimics, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->mimic_dir;
		g_file_delete (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("Upgrades.vala:85: Could not delete mimics: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

MimicsRemovalTask*
mimics_removal_task_construct (GType object_type)
{
	MimicsRemovalTask * self = NULL;
	self = (MimicsRemovalTask*) g_object_new (object_type, NULL);
	return self;
}

MimicsRemovalTask*
mimics_removal_task_new (void)
{
	return mimics_removal_task_construct (TYPE_MIMICS_REMOVAL_TASK);
}

static void
mimics_removal_task_class_init (MimicsRemovalTaskClass * klass,
                                gpointer klass_data)
{
	mimics_removal_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MimicsRemovalTask_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mimics_removal_task_finalize;
}

static void
mimics_removal_task_upgrade_task_interface_init (UpgradeTaskIface * iface,
                                                 gpointer iface_data)
{
	mimics_removal_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_step_count = (guint64 (*) (UpgradeTask*)) mimics_removal_task_real_get_step_count;
	iface->execute = (void (*) (UpgradeTask*, ProgressMonitor, gpointer)) mimics_removal_task_real_execute;
}

static void
mimics_removal_task_instance_init (MimicsRemovalTask * self,
                                   gpointer klass)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	self->priv = mimics_removal_task_get_instance_private (self);
	_tmp0_ = app_dirs_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "mimics");
	self->priv->mimic_dir = _tmp2_;
	_g_object_unref0 (_tmp1_);
	self->priv->num_mimics = (guint64) 0;
}

static void
mimics_removal_task_finalize (GObject * obj)
{
	MimicsRemovalTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
	_g_object_unref0 (self->priv->mimic_dir);
	G_OBJECT_CLASS (mimics_removal_task_parent_class)->finalize (obj);
}

static GType
mimics_removal_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MimicsRemovalTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mimics_removal_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MimicsRemovalTask), 0, (GInstanceInitFunc) mimics_removal_task_instance_init, NULL };
	static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) mimics_removal_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType mimics_removal_task_type_id;
	mimics_removal_task_type_id = g_type_register_static (G_TYPE_OBJECT, "MimicsRemovalTask", &g_define_type_info, 0);
	g_type_add_interface_static (mimics_removal_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
	MimicsRemovalTask_private_offset = g_type_add_instance_private (mimics_removal_task_type_id, sizeof (MimicsRemovalTaskPrivate));
	return mimics_removal_task_type_id;
}

GType
mimics_removal_task_get_type (void)
{
	static volatile gsize mimics_removal_task_type_id__once = 0;
	if (g_once_init_enter (&mimics_removal_task_type_id__once)) {
		GType mimics_removal_task_type_id;
		mimics_removal_task_type_id = mimics_removal_task_get_type_once ();
		g_once_init_leave (&mimics_removal_task_type_id__once, mimics_removal_task_type_id);
	}
	return mimics_removal_task_type_id__once;
}

static guint64
fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base)
{
	FixupRawThumbnailsTask * self;
	gint num_raw_files = 0;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask);
	num_raw_files = 0;
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _phr_index = 0;
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = photo_table_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_database_table_unref0 (_tmp1_);
		_phr_list = _tmp3_;
		_tmp4_ = _phr_list;
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp6_ = _tmp5_;
		_phr_size = _tmp6_;
		_phr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			PhotoRow* _tmp11_;
			BackingPhotoRow* _tmp12_;
			_phr_index = _phr_index + 1;
			_tmp7_ = _phr_index;
			_tmp8_ = _phr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _phr_list;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _phr_index);
			phr = (PhotoRow*) _tmp10_;
			_tmp11_ = phr;
			_tmp12_ = _tmp11_->master;
			if (_tmp12_->file_format == PHOTO_FILE_FORMAT_RAW) {
				gint _tmp13_;
				_tmp13_ = num_raw_files;
				num_raw_files = _tmp13_ + 1;
			}
			_photo_row_unref0 (phr);
		}
		_g_object_unref0 (_phr_list);
	}
	result = (guint64) num_raw_files;
	return result;
}

static void
fixup_raw_thumbnails_task_real_execute (UpgradeTask* base,
                                        ProgressMonitor monitor,
                                        gpointer monitor_target)
{
	FixupRawThumbnailsTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask);
	g_debug ("Upgrades.vala:105: Executing thumbnail deletion and fixup");
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _phr_index = 0;
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = photo_table_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_database_table_unref0 (_tmp1_);
		_phr_list = _tmp3_;
		_tmp4_ = _phr_list;
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp6_ = _tmp5_;
		_phr_size = _tmp6_;
		_phr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			PhotoRow* _tmp12_;
			BackingPhotoRow* _tmp13_;
			_phr_index = _phr_index + 1;
			_tmp7_ = _phr_index;
			_tmp8_ = _phr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _phr_list;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _phr_index);
			phr = (PhotoRow*) _tmp10_;
			_tmp12_ = phr;
			_tmp13_ = _tmp12_->master;
			if (_tmp13_->file_format == PHOTO_FILE_FORMAT_RAW) {
				PhotoRow* _tmp14_;
				_tmp14_ = phr;
				_tmp11_ = _tmp14_->developer == RAW_DEVELOPER_CAMERA;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				LibraryPhotoSourceCollection* _tmp15_;
				PhotoRow* _tmp16_;
				PhotoID _tmp17_;
				LibraryPhoto* _tmp18_;
				LibraryPhoto* _tmp19_;
				_tmp15_ = library_photo_global;
				_tmp16_ = phr;
				_tmp17_ = _tmp16_->photo_id;
				_tmp18_ = library_photo_source_collection_fetch (_tmp15_, &_tmp17_);
				_tmp19_ = _tmp18_;
				thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
				_g_object_unref0 (_tmp19_);
			}
			_photo_row_unref0 (phr);
		}
		_g_object_unref0 (_phr_list);
	}
}

FixupRawThumbnailsTask*
fixup_raw_thumbnails_task_construct (GType object_type)
{
	FixupRawThumbnailsTask * self = NULL;
	self = (FixupRawThumbnailsTask*) g_object_new (object_type, NULL);
	return self;
}

FixupRawThumbnailsTask*
fixup_raw_thumbnails_task_new (void)
{
	return fixup_raw_thumbnails_task_construct (TYPE_FIXUP_RAW_THUMBNAILS_TASK);
}

static void
fixup_raw_thumbnails_task_class_init (FixupRawThumbnailsTaskClass * klass,
                                      gpointer klass_data)
{
	fixup_raw_thumbnails_task_parent_class = g_type_class_peek_parent (klass);
}

static void
fixup_raw_thumbnails_task_upgrade_task_interface_init (UpgradeTaskIface * iface,
                                                       gpointer iface_data)
{
	fixup_raw_thumbnails_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_step_count = (guint64 (*) (UpgradeTask*)) fixup_raw_thumbnails_task_real_get_step_count;
	iface->execute = (void (*) (UpgradeTask*, ProgressMonitor, gpointer)) fixup_raw_thumbnails_task_real_execute;
}

static void
fixup_raw_thumbnails_task_instance_init (FixupRawThumbnailsTask * self,
                                         gpointer klass)
{
}

static GType
fixup_raw_thumbnails_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FixupRawThumbnailsTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fixup_raw_thumbnails_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FixupRawThumbnailsTask), 0, (GInstanceInitFunc) fixup_raw_thumbnails_task_instance_init, NULL };
	static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) fixup_raw_thumbnails_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType fixup_raw_thumbnails_task_type_id;
	fixup_raw_thumbnails_task_type_id = g_type_register_static (G_TYPE_OBJECT, "FixupRawThumbnailsTask", &g_define_type_info, 0);
	g_type_add_interface_static (fixup_raw_thumbnails_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
	return fixup_raw_thumbnails_task_type_id;
}

GType
fixup_raw_thumbnails_task_get_type (void)
{
	static volatile gsize fixup_raw_thumbnails_task_type_id__once = 0;
	if (g_once_init_enter (&fixup_raw_thumbnails_task_type_id__once)) {
		GType fixup_raw_thumbnails_task_type_id;
		fixup_raw_thumbnails_task_type_id = fixup_raw_thumbnails_task_get_type_once ();
		g_once_init_leave (&fixup_raw_thumbnails_task_type_id__once, fixup_raw_thumbnails_task_type_id);
	}
	return fixup_raw_thumbnails_task_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

