/* TimedQueue.c generated by valac 0.56.17, the Vala compiler
 * generated from TimedQueue.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* TimedQueue is a specialized collection class.  It holds items in order, but rather than being*/
/* manually dequeued, they are dequeued automatically after a specified amount of time has elapsed*/
/* for that item.  As of today, it's possible the item will be dequeued a bit later than asked*/
/* for, but it will never be early.  Future implementations might tighten up the lateness.*/
/**/
/* The original design was to use a signal to notify when an item has been dequeued, but Vala has*/
/* a bug with passing an unnamed type as a signal parameter:*/
/* https://bugzilla.gnome.org/show_bug.cgi?id=628639*/
/**/
/* The rate the items come off the queue can be spaced out.  Note that this can cause items to back*/
/* up.  As of today, TimedQueue makes no effort to combat this.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*DequeuedCallback) (gconstpointer item, gpointer user_data);

#define TYPE_TIMED_QUEUE (timed_queue_get_type ())
#define TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMED_QUEUE, TimedQueue))
#define TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMED_QUEUE, TimedQueueClass))
#define IS_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMED_QUEUE))
#define IS_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMED_QUEUE))
#define TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMED_QUEUE, TimedQueueClass))

typedef struct _TimedQueue TimedQueue;
typedef struct _TimedQueueClass TimedQueueClass;
typedef struct _TimedQueuePrivate TimedQueuePrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;

#define TIMED_QUEUE_TYPE_ELEMENT (timed_queue_element_get_type ())
#define TIMED_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement))
#define TIMED_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElementClass))
#define TIMED_QUEUE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TIMED_QUEUE_TYPE_ELEMENT))
#define TIMED_QUEUE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TIMED_QUEUE_TYPE_ELEMENT))
#define TIMED_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElementClass))

typedef struct _TimedQueueElement TimedQueueElement;
typedef struct _TimedQueueElementClass TimedQueueElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef struct _TimedQueueElementPrivate TimedQueueElementPrivate;
#define _timed_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (timed_queue_element_unref (var), NULL)))
typedef struct _TimedQueueParamSpecElement TimedQueueParamSpecElement;
typedef struct _ParamSpecTimedQueue ParamSpecTimedQueue;
enum  {
	TIMED_QUEUE_PAUSED_SIGNAL,
	TIMED_QUEUE_NUM_SIGNALS
};
static guint timed_queue_signals[TIMED_QUEUE_NUM_SIGNALS] = {0};

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;
typedef struct _HashTimedQueuePrivate HashTimedQueuePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TimedQueue {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimedQueuePrivate * priv;
};

struct _TimedQueueClass {
	GTypeClass parent_class;
	void (*finalize) (TimedQueue *self);
	void (*notify_dequeued) (TimedQueue* self, gconstpointer item);
	void (*clear) (TimedQueue* self);
	gboolean (*contains) (TimedQueue* self, gconstpointer item);
	gboolean (*enqueue) (TimedQueue* self, gconstpointer item);
	gboolean (*enqueue_many) (TimedQueue* self, GeeCollection* items);
	gboolean (*remove_first) (TimedQueue* self, gconstpointer item);
	void (*paused) (TimedQueue* self, gboolean is_paused);
	gint (*get_size) (TimedQueue* self);
};

struct _TimedQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	guint hold_msec;
	DequeuedCallback callback;
	gpointer callback_target;
	GeeEqualDataFunc equal_func;
	gpointer equal_func_target;
	GDestroyNotify equal_func_target_destroy_notify;
	gint priority;
	guint timer_id;
	SortedList* queue;
	guint dequeue_spacing_msec;
	gulong last_dequeue;
	gboolean paused_state;
};

struct _TimedQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimedQueueElementPrivate * priv;
	gpointer item;
	gulong ready;
};

struct _TimedQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (TimedQueueElement *self);
};

struct _TimedQueueElementPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _TimedQueueParamSpecElement {
	GParamSpec parent_instance;
};

struct _ParamSpecTimedQueue {
	GParamSpec parent_instance;
};

struct _HashTimedQueue {
	TimedQueue parent_instance;
	HashTimedQueuePrivate * priv;
};

struct _HashTimedQueueClass {
	TimedQueueClass parent_class;
};

struct _HashTimedQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashMap* item_count;
};

static gint TimedQueue_private_offset;
static gpointer timed_queue_parent_class = NULL;
static gint TimedQueueElement_private_offset;
static gpointer timed_queue_element_parent_class = NULL;
static gint HashTimedQueue_private_offset;
static gpointer hash_timed_queue_parent_class = NULL;

VALA_EXTERN gpointer timed_queue_ref (gpointer instance);
VALA_EXTERN void timed_queue_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_timed_queue (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_timed_queue (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_timed_queue (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_timed_queue (const GValue* value);
VALA_EXTERN GType timed_queue_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimedQueue, timed_queue_unref)
VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
static gpointer timed_queue_element_ref (gpointer instance);
static void timed_queue_element_unref (gpointer instance);
static GParamSpec* timed_queue_param_spec_element (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags) G_GNUC_UNUSED ;
static void timed_queue_value_set_element (GValue* value,
                                    gpointer v_object) G_GNUC_UNUSED ;
static void timed_queue_value_take_element (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static gpointer timed_queue_value_get_element (const GValue* value) G_GNUC_UNUSED ;
static GType timed_queue_element_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimedQueueElement, timed_queue_element_unref)
VALA_EXTERN void timed_queue_notify_dequeued (TimedQueue* self,
                                  gconstpointer item);
VALA_EXTERN void timed_queue_clear (TimedQueue* self);
VALA_EXTERN gboolean timed_queue_contains (TimedQueue* self,
                               gconstpointer item);
VALA_EXTERN gboolean timed_queue_enqueue (TimedQueue* self,
                              gconstpointer item);
VALA_EXTERN gboolean timed_queue_enqueue_many (TimedQueue* self,
                                   GeeCollection* items);
VALA_EXTERN gboolean timed_queue_remove_first (TimedQueue* self,
                                   gconstpointer item);
VALA_EXTERN gint timed_queue_get_size (TimedQueue* self);
VALA_EXTERN TimedQueue* timed_queue_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             guint hold_msec,
                             DequeuedCallback callback,
                             gpointer callback_target,
                             GeeEqualDataFunc equal_func,
                             gpointer equal_func_target,
                             GDestroyNotify equal_func_target_destroy_notify,
                             gint priority);
VALA_EXTERN TimedQueue* timed_queue_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   guint hold_msec,
                                   DequeuedCallback callback,
                                   gpointer callback_target,
                                   GeeEqualDataFunc equal_func,
                                   gpointer equal_func_target,
                                   GDestroyNotify equal_func_target_destroy_notify,
                                   gint priority);
static gint64 timed_queue_element_comparator (void* a,
                                       void* b);
static gint64 _timed_queue_element_comparator_comparator (void* a,
                                                   void* b,
                                                   gpointer self);
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
static guint timed_queue_get_heartbeat_timeout (TimedQueue* self);
static gboolean timed_queue_on_heartbeat (TimedQueue* self);
static gboolean _timed_queue_on_heartbeat_gsource_func (gpointer self);
VALA_EXTERN guint timed_queue_get_dequeue_spacing_msec (TimedQueue* self);
VALA_EXTERN void timed_queue_set_dequeue_spacing_msec (TimedQueue* self,
                                           guint msec);
static void timed_queue_real_notify_dequeued (TimedQueue* self,
                                       gconstpointer item);
VALA_EXTERN gboolean timed_queue_is_paused (TimedQueue* self);
VALA_EXTERN void timed_queue_pause (TimedQueue* self);
VALA_EXTERN void timed_queue_unpause (TimedQueue* self);
static void timed_queue_real_clear (TimedQueue* self);
static gboolean timed_queue_real_contains (TimedQueue* self,
                                    gconstpointer item);
static gboolean timed_queue_real_enqueue (TimedQueue* self,
                                   gconstpointer item);
static gulong timed_queue_calc_ready_time (TimedQueue* self);
static TimedQueueElement* timed_queue_element_new (GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            gconstpointer item,
                                            gulong ready);
static TimedQueueElement* timed_queue_element_construct (GType object_type,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  gconstpointer item,
                                                  gulong ready);
static gboolean timed_queue_real_enqueue_many (TimedQueue* self,
                                        GeeCollection* items);
VALA_EXTERN gboolean sorted_list_add_list (SortedList* self,
                               GeeList* items);
static gboolean timed_queue_real_remove_first (TimedQueue* self,
                                        gconstpointer item);
VALA_EXTERN gulong now_ms (void);
VALA_EXTERN gpointer sorted_list_get_at (SortedList* self,
                             gint index);
VALA_EXTERN gpointer sorted_list_remove_at (SortedList* self,
                                gint index);
static void timed_queue_real_paused (TimedQueue* self,
                              gboolean is_paused);
static void timed_queue_element_finalize (TimedQueueElement * obj);
static GType timed_queue_element_get_type_once (void);
static void timed_queue_finalize (TimedQueue * obj);
static GType timed_queue_get_type_once (void);
VALA_EXTERN GType hash_timed_queue_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HashTimedQueue, timed_queue_unref)
VALA_EXTERN HashTimedQueue* hash_timed_queue_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      guint hold_msec,
                                      DequeuedCallback callback,
                                      gpointer callback_target,
                                      GeeHashDataFunc hash_func,
                                      gpointer hash_func_target,
                                      GDestroyNotify hash_func_target_destroy_notify,
                                      GeeEqualDataFunc equal_func,
                                      gpointer equal_func_target,
                                      GDestroyNotify equal_func_target_destroy_notify,
                                      gint priority);
VALA_EXTERN HashTimedQueue* hash_timed_queue_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            guint hold_msec,
                                            DequeuedCallback callback,
                                            gpointer callback_target,
                                            GeeHashDataFunc hash_func,
                                            gpointer hash_func_target,
                                            GDestroyNotify hash_func_target_destroy_notify,
                                            GeeEqualDataFunc equal_func,
                                            gpointer equal_func_target,
                                            GDestroyNotify equal_func_target_destroy_notify,
                                            gint priority);
static void hash_timed_queue_real_notify_dequeued (TimedQueue* base,
                                            gconstpointer item);
static void hash_timed_queue_removed (HashTimedQueue* self,
                               gconstpointer item);
static void hash_timed_queue_real_clear (TimedQueue* base);
static gboolean hash_timed_queue_real_contains (TimedQueue* base,
                                         gconstpointer item);
static gboolean hash_timed_queue_real_enqueue (TimedQueue* base,
                                        gconstpointer item);
static gboolean hash_timed_queue_real_enqueue_many (TimedQueue* base,
                                             GeeCollection* items);
static gboolean hash_timed_queue_real_remove_first (TimedQueue* base,
                                             gconstpointer item);
static void hash_timed_queue_finalize (TimedQueue * obj);
static GType hash_timed_queue_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
timed_queue_get_instance_private (TimedQueue* self)
{
	return G_STRUCT_MEMBER_P (self, TimedQueue_private_offset);
}

static gint64
_timed_queue_element_comparator_comparator (void* a,
                                            void* b,
                                            gpointer self)
{
	gint64 result;
	result = timed_queue_element_comparator (a, b);
	return result;
}

static gboolean
_timed_queue_on_heartbeat_gsource_func (gpointer self)
{
	gboolean result;
	result = timed_queue_on_heartbeat ((TimedQueue*) self);
	return result;
}

TimedQueue*
timed_queue_construct (GType object_type,
                       GType g_type,
                       GBoxedCopyFunc g_dup_func,
                       GDestroyNotify g_destroy_func,
                       guint hold_msec,
                       DequeuedCallback callback,
                       gpointer callback_target,
                       GeeEqualDataFunc equal_func,
                       gpointer equal_func_target,
                       GDestroyNotify equal_func_target_destroy_notify,
                       gint priority)
{
	TimedQueue* self = NULL;
	SortedList* _tmp4_;
	self = (TimedQueue*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->hold_msec = hold_msec;
	self->priv->callback = callback;
	self->priv->callback_target = callback_target;
	if (equal_func != NULL) {
		GeeEqualDataFunc _tmp0_;
		gpointer _tmp0__target;
		GDestroyNotify _tmp0__target_destroy_notify;
		_tmp0_ = equal_func;
		_tmp0__target = equal_func_target;
		_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
		self->priv->equal_func = NULL;
		self->priv->equal_func_target = NULL;
		self->priv->equal_func_target_destroy_notify = NULL;
		self->priv->equal_func = _tmp0_;
		self->priv->equal_func_target = _tmp0__target;
		self->priv->equal_func_target_destroy_notify = _tmp0__target_destroy_notify;
	} else {
		gpointer _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_;
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
		self->priv->equal_func = NULL;
		self->priv->equal_func_target = NULL;
		self->priv->equal_func_target_destroy_notify = NULL;
		self->priv->equal_func = (GeeEqualDataFunc) _tmp3_;
		self->priv->equal_func_target = _tmp1_;
		self->priv->equal_func_target_destroy_notify = _tmp2_;
	}
	self->priv->priority = priority;
	_tmp4_ = sorted_list_new (TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) timed_queue_element_ref, (GDestroyNotify) timed_queue_element_unref, _timed_queue_element_comparator_comparator, NULL);
	_g_object_unref0 (self->priv->queue);
	self->priv->queue = _tmp4_;
	self->priv->timer_id = g_timeout_add_full (priority, timed_queue_get_heartbeat_timeout (self), _timed_queue_on_heartbeat_gsource_func, timed_queue_ref (self), timed_queue_unref);
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

TimedQueue*
timed_queue_new (GType g_type,
                 GBoxedCopyFunc g_dup_func,
                 GDestroyNotify g_destroy_func,
                 guint hold_msec,
                 DequeuedCallback callback,
                 gpointer callback_target,
                 GeeEqualDataFunc equal_func,
                 gpointer equal_func_target,
                 GDestroyNotify equal_func_target_destroy_notify,
                 gint priority)
{
	return timed_queue_construct (TYPE_TIMED_QUEUE, g_type, g_dup_func, g_destroy_func, hold_msec, callback, callback_target, equal_func, equal_func_target, equal_func_target_destroy_notify, priority);
}

guint
timed_queue_get_dequeue_spacing_msec (TimedQueue* self)
{
	guint result;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0U);
	result = self->priv->dequeue_spacing_msec;
	return result;
}

void
timed_queue_set_dequeue_spacing_msec (TimedQueue* self,
                                      guint msec)
{
	g_return_if_fail (IS_TIMED_QUEUE (self));
	if (msec == self->priv->dequeue_spacing_msec) {
		return;
	}
	if (self->priv->timer_id != ((guint) 0)) {
		g_source_remove (self->priv->timer_id);
	}
	self->priv->dequeue_spacing_msec = msec;
	self->priv->timer_id = g_timeout_add_full (self->priv->priority, timed_queue_get_heartbeat_timeout (self), _timed_queue_on_heartbeat_gsource_func, timed_queue_ref (self), timed_queue_unref);
}

static guint
timed_queue_get_heartbeat_timeout (TimedQueue* self)
{
	guint _tmp0_ = 0U;
	guint result;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0U);
	if (self->priv->dequeue_spacing_msec == ((guint) 0)) {
		_tmp0_ = self->priv->hold_msec / 10;
	} else {
		_tmp0_ = self->priv->dequeue_spacing_msec / 2;
	}
	result = CLAMP (_tmp0_, (guint) 10, G_MAXUINT);
	return result;
}

static void
timed_queue_real_notify_dequeued (TimedQueue* self,
                                  gconstpointer item)
{
	DequeuedCallback _tmp0_;
	gpointer _tmp0__target;
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	_tmp0_ (item, _tmp0__target);
}

void
timed_queue_notify_dequeued (TimedQueue* self,
                             gconstpointer item)
{
	TimedQueueClass* _klass_;
	g_return_if_fail (IS_TIMED_QUEUE (self));
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->notify_dequeued) {
		_klass_->notify_dequeued (self, item);
	}
}

gboolean
timed_queue_is_paused (TimedQueue* self)
{
	gboolean result;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	result = self->priv->paused_state;
	return result;
}

void
timed_queue_pause (TimedQueue* self)
{
	g_return_if_fail (IS_TIMED_QUEUE (self));
	if (self->priv->paused_state) {
		return;
	}
	self->priv->paused_state = TRUE;
	g_signal_emit (self, timed_queue_signals[TIMED_QUEUE_PAUSED_SIGNAL], 0, TRUE);
}

void
timed_queue_unpause (TimedQueue* self)
{
	g_return_if_fail (IS_TIMED_QUEUE (self));
	if (!self->priv->paused_state) {
		return;
	}
	self->priv->paused_state = FALSE;
	g_signal_emit (self, timed_queue_signals[TIMED_QUEUE_PAUSED_SIGNAL], 0, FALSE);
}

static void
timed_queue_real_clear (TimedQueue* self)
{
	SortedList* _tmp0_;
	_tmp0_ = self->priv->queue;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
}

void
timed_queue_clear (TimedQueue* self)
{
	TimedQueueClass* _klass_;
	g_return_if_fail (IS_TIMED_QUEUE (self));
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->clear) {
		_klass_->clear (self);
	}
}

static gboolean
timed_queue_real_contains (TimedQueue* self,
                           gconstpointer item)
{
	gboolean result;
	{
		GeeIterator* _e_it = NULL;
		SortedList* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->queue;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_e_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			TimedQueueElement* e = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeEqualDataFunc _tmp5_;
			gpointer _tmp5__target;
			TimedQueueElement* _tmp6_;
			gconstpointer _tmp7_;
			_tmp2_ = _e_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _e_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			e = (TimedQueueElement*) _tmp4_;
			_tmp5_ = self->priv->equal_func;
			_tmp5__target = self->priv->equal_func_target;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->item;
			if (_tmp5_ (item, _tmp7_, _tmp5__target)) {
				result = TRUE;
				_timed_queue_element_unref0 (e);
				_g_object_unref0 (_e_it);
				return result;
			}
			_timed_queue_element_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	result = FALSE;
	return result;
}

gboolean
timed_queue_contains (TimedQueue* self,
                      gconstpointer item)
{
	TimedQueueClass* _klass_;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->contains) {
		return _klass_->contains (self, item);
	}
	return FALSE;
}

static gboolean
timed_queue_real_enqueue (TimedQueue* self,
                          gconstpointer item)
{
	SortedList* _tmp0_;
	TimedQueueElement* _tmp1_;
	TimedQueueElement* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	_tmp0_ = self->priv->queue;
	_tmp1_ = timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, item, timed_queue_calc_ready_time (self));
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp2_);
	_timed_queue_element_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
timed_queue_enqueue (TimedQueue* self,
                     gconstpointer item)
{
	TimedQueueClass* _klass_;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->enqueue) {
		return _klass_->enqueue (self, item);
	}
	return FALSE;
}

static gboolean
timed_queue_real_enqueue_many (TimedQueue* self,
                               GeeCollection* items)
{
	gulong ready_time = 0UL;
	GeeArrayList* elements = NULL;
	GeeArrayList* _tmp0_;
	SortedList* _tmp9_;
	GeeArrayList* _tmp10_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_COLLECTION), FALSE);
	ready_time = timed_queue_calc_ready_time (self);
	_tmp0_ = gee_array_list_new (TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) timed_queue_element_ref, (GDestroyNotify) timed_queue_element_unref, NULL, NULL, NULL);
	elements = _tmp0_;
	{
		GeeIterator* _item_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_ITERABLE, GeeIterable));
		_item_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gpointer item = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			gconstpointer _tmp6_;
			TimedQueueElement* _tmp7_;
			TimedQueueElement* _tmp8_;
			_tmp2_ = _item_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _item_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			item = _tmp4_;
			_tmp5_ = elements;
			_tmp6_ = item;
			_tmp7_ = timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp6_, ready_time);
			_tmp8_ = _tmp7_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
			_timed_queue_element_unref0 (_tmp8_);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	_tmp9_ = self->priv->queue;
	_tmp10_ = elements;
	result = sorted_list_add_list (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_LIST, GeeList));
	_g_object_unref0 (elements);
	return result;
}

gboolean
timed_queue_enqueue_many (TimedQueue* self,
                          GeeCollection* items)
{
	TimedQueueClass* _klass_;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->enqueue_many) {
		return _klass_->enqueue_many (self, items);
	}
	return FALSE;
}

static gboolean
timed_queue_real_remove_first (TimedQueue* self,
                               gconstpointer item)
{
	GeeIterator* iter = NULL;
	SortedList* _tmp0_;
	GeeIterator* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->queue;
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		TimedQueueElement* e = NULL;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		GeeEqualDataFunc _tmp5_;
		gpointer _tmp5__target;
		TimedQueueElement* _tmp6_;
		gconstpointer _tmp7_;
		_tmp2_ = iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_iterator_get (_tmp3_);
		e = (TimedQueueElement*) _tmp4_;
		_tmp5_ = self->priv->equal_func;
		_tmp5__target = self->priv->equal_func_target;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->item;
		if (_tmp5_ (item, _tmp7_, _tmp5__target)) {
			GeeIterator* _tmp8_;
			_tmp8_ = iter;
			gee_iterator_remove (_tmp8_);
			result = TRUE;
			_timed_queue_element_unref0 (e);
			_g_object_unref0 (iter);
			return result;
		}
		_timed_queue_element_unref0 (e);
	}
	result = FALSE;
	_g_object_unref0 (iter);
	return result;
}

gboolean
timed_queue_remove_first (TimedQueue* self,
                          gconstpointer item)
{
	TimedQueueClass* _klass_;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->remove_first) {
		return _klass_->remove_first (self, item);
	}
	return FALSE;
}

static gulong
timed_queue_calc_ready_time (TimedQueue* self)
{
	gulong result;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0UL);
	result = now_ms () + ((gulong) self->priv->hold_msec);
	return result;
}

static gboolean
timed_queue_on_heartbeat (TimedQueue* self)
{
	gulong now = 0UL;
	gboolean result;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
	if (self->priv->paused_state) {
		result = TRUE;
		return result;
	}
	now = (gulong) 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			SortedList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			TimedQueueElement* head = NULL;
			SortedList* _tmp4_;
			gpointer _tmp5_;
			TimedQueueElement* _tmp6_;
			TimedQueueElement* _tmp7_;
			gboolean _tmp8_ = FALSE;
			TimedQueueElement* h = NULL;
			SortedList* _tmp9_;
			gpointer _tmp10_;
			TimedQueueElement* _tmp11_;
			TimedQueueElement* _tmp12_;
			TimedQueueElement* _tmp13_;
			gconstpointer _tmp14_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = self->priv->queue;
			_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp3_ = _tmp2_;
			if (_tmp3_ == 0) {
				break;
			}
			_tmp4_ = self->priv->queue;
			_tmp5_ = sorted_list_get_at (_tmp4_, 0);
			head = (TimedQueueElement*) _tmp5_;
			_tmp6_ = head;
			_vala_assert (_tmp6_ != NULL, "head != null");
			if (now == ((gulong) 0)) {
				now = now_ms ();
			}
			_tmp7_ = head;
			if (_tmp7_->ready > now) {
				_timed_queue_element_unref0 (head);
				break;
			}
			if (self->priv->dequeue_spacing_msec != ((guint) 0)) {
				_tmp8_ = (now - self->priv->last_dequeue) < ((gulong) self->priv->dequeue_spacing_msec);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_timed_queue_element_unref0 (head);
				break;
			}
			_tmp9_ = self->priv->queue;
			_tmp10_ = sorted_list_remove_at (_tmp9_, 0);
			h = (TimedQueueElement*) _tmp10_;
			_tmp11_ = head;
			_tmp12_ = h;
			_vala_assert (_tmp11_ == _tmp12_, "head == h");
			_tmp13_ = head;
			_tmp14_ = _tmp13_->item;
			timed_queue_notify_dequeued (self, _tmp14_);
			self->priv->last_dequeue = now;
			if (self->priv->dequeue_spacing_msec != ((guint) 0)) {
				_timed_queue_element_unref0 (h);
				_timed_queue_element_unref0 (head);
				break;
			}
			_timed_queue_element_unref0 (h);
			_timed_queue_element_unref0 (head);
		}
	}
	result = TRUE;
	return result;
}

gint
timed_queue_get_size (TimedQueue* self)
{
	TimedQueueClass* _klass_;
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0);
	_klass_ = TIMED_QUEUE_GET_CLASS (self);
	if (_klass_->get_size) {
		return _klass_->get_size (self);
	}
	return -1;
}

static gint
timed_queue_real_get_size (TimedQueue* base)
{
	gint result;
	TimedQueue* self;
	SortedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = base;
	_tmp0_ = self->priv->queue;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
timed_queue_real_paused (TimedQueue* self,
                         gboolean is_paused)
{
}

static inline gpointer
timed_queue_element_get_instance_private (TimedQueueElement* self)
{
	return G_STRUCT_MEMBER_P (self, TimedQueueElement_private_offset);
}

static TimedQueueElement*
timed_queue_element_construct (GType object_type,
                               GType g_type,
                               GBoxedCopyFunc g_dup_func,
                               GDestroyNotify g_destroy_func,
                               gconstpointer item,
                               gulong ready)
{
	TimedQueueElement* self = NULL;
	gpointer _tmp0_;
	self = (TimedQueueElement*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = ((item != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item) : ((gpointer) item);
	((self->item == NULL) || (g_destroy_func == NULL)) ? NULL : (self->item = (g_destroy_func (self->item), NULL));
	self->item = _tmp0_;
	self->ready = ready;
	return self;
}

static TimedQueueElement*
timed_queue_element_new (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         gconstpointer item,
                         gulong ready)
{
	return timed_queue_element_construct (TIMED_QUEUE_TYPE_ELEMENT, g_type, g_dup_func, g_destroy_func, item, ready);
}

static gint64
timed_queue_element_comparator (void* a,
                                void* b)
{
	gint64 result;
	result = ((gint64) G_TYPE_CHECK_INSTANCE_CAST ((TimedQueueElement*) a, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement)->ready) - ((gint64) G_TYPE_CHECK_INSTANCE_CAST ((TimedQueueElement*) b, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement)->ready);
	return result;
}

static void
timed_queue_value_element_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
timed_queue_value_element_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		timed_queue_element_unref (value->data[0].v_pointer);
	}
}

static void
timed_queue_value_element_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = timed_queue_element_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
timed_queue_value_element_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
timed_queue_value_element_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TimedQueueElement * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = timed_queue_element_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
timed_queue_value_element_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	TimedQueueElement ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = timed_queue_element_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
timed_queue_param_spec_element (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	TimedQueueParamSpecElement* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TIMED_QUEUE_TYPE_ELEMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
timed_queue_value_get_element (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT), NULL);
	return value->data[0].v_pointer;
}

static void
timed_queue_value_set_element (GValue* value,
                               gpointer v_object)
{
	TimedQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TIMED_QUEUE_TYPE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		timed_queue_element_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		timed_queue_element_unref (old);
	}
}

static void
timed_queue_value_take_element (GValue* value,
                                gpointer v_object)
{
	TimedQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TIMED_QUEUE_TYPE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		timed_queue_element_unref (old);
	}
}

static void
timed_queue_element_class_init (TimedQueueElementClass * klass,
                                gpointer klass_data)
{
	timed_queue_element_parent_class = g_type_class_peek_parent (klass);
	((TimedQueueElementClass *) klass)->finalize = timed_queue_element_finalize;
	g_type_class_adjust_private_offset (klass, &TimedQueueElement_private_offset);
}

static void
timed_queue_element_instance_init (TimedQueueElement * self,
                                   gpointer klass)
{
	self->priv = timed_queue_element_get_instance_private (self);
	self->ref_count = 1;
}

static void
timed_queue_element_finalize (TimedQueueElement * obj)
{
	TimedQueueElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement);
	g_signal_handlers_destroy (self);
	((self->item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->item = (self->priv->g_destroy_func (self->item), NULL));
}

static GType
timed_queue_element_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { timed_queue_value_element_init, timed_queue_value_element_free_value, timed_queue_value_element_copy_value, timed_queue_value_element_peek_pointer, "p", timed_queue_value_element_collect_value, "p", timed_queue_value_element_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TimedQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timed_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimedQueueElement), 0, (GInstanceInitFunc) timed_queue_element_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType timed_queue_element_type_id;
	timed_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TimedQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TimedQueueElement_private_offset = g_type_add_instance_private (timed_queue_element_type_id, sizeof (TimedQueueElementPrivate));
	return timed_queue_element_type_id;
}

static GType
timed_queue_element_get_type (void)
{
	static volatile gsize timed_queue_element_type_id__once = 0;
	if (g_once_init_enter (&timed_queue_element_type_id__once)) {
		GType timed_queue_element_type_id;
		timed_queue_element_type_id = timed_queue_element_get_type_once ();
		g_once_init_leave (&timed_queue_element_type_id__once, timed_queue_element_type_id);
	}
	return timed_queue_element_type_id__once;
}

static gpointer
timed_queue_element_ref (gpointer instance)
{
	TimedQueueElement * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
timed_queue_element_unref (gpointer instance)
{
	TimedQueueElement * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TIMED_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_timed_queue_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_timed_queue_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		timed_queue_unref (value->data[0].v_pointer);
	}
}

static void
value_timed_queue_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = timed_queue_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_timed_queue_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_timed_queue_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TimedQueue * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = timed_queue_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_timed_queue_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	TimedQueue ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = timed_queue_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_timed_queue (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecTimedQueue* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TIMED_QUEUE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_timed_queue (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_timed_queue (GValue* value,
                       gpointer v_object)
{
	TimedQueue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIMED_QUEUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		timed_queue_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		timed_queue_unref (old);
	}
}

void
value_take_timed_queue (GValue* value,
                        gpointer v_object)
{
	TimedQueue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIMED_QUEUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		timed_queue_unref (old);
	}
}

static void
timed_queue_class_init (TimedQueueClass * klass,
                        gpointer klass_data)
{
	timed_queue_parent_class = g_type_class_peek_parent (klass);
	((TimedQueueClass *) klass)->finalize = timed_queue_finalize;
	g_type_class_adjust_private_offset (klass, &TimedQueue_private_offset);
	((TimedQueueClass *) klass)->notify_dequeued = (void (*) (TimedQueue*, gconstpointer)) timed_queue_real_notify_dequeued;
	((TimedQueueClass *) klass)->clear = (void (*) (TimedQueue*)) timed_queue_real_clear;
	((TimedQueueClass *) klass)->contains = (gboolean (*) (TimedQueue*, gconstpointer)) timed_queue_real_contains;
	((TimedQueueClass *) klass)->enqueue = (gboolean (*) (TimedQueue*, gconstpointer)) timed_queue_real_enqueue;
	((TimedQueueClass *) klass)->enqueue_many = (gboolean (*) (TimedQueue*, GeeCollection*)) timed_queue_real_enqueue_many;
	((TimedQueueClass *) klass)->remove_first = (gboolean (*) (TimedQueue*, gconstpointer)) timed_queue_real_remove_first;
	((TimedQueueClass *) klass)->paused = timed_queue_real_paused;
	TIMED_QUEUE_CLASS (klass)->get_size = (gint (*) (TimedQueue*)) timed_queue_real_get_size;
	timed_queue_signals[TIMED_QUEUE_PAUSED_SIGNAL] = g_signal_new ("paused", TYPE_TIMED_QUEUE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (TimedQueueClass, paused), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
timed_queue_instance_init (TimedQueue * self,
                           gpointer klass)
{
	self->priv = timed_queue_get_instance_private (self);
	self->priv->timer_id = (guint) 0;
	self->priv->dequeue_spacing_msec = (guint) 0;
	self->priv->last_dequeue = (gulong) 0;
	self->priv->paused_state = FALSE;
	self->ref_count = 1;
}

static void
timed_queue_finalize (TimedQueue * obj)
{
	TimedQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMED_QUEUE, TimedQueue);
	g_signal_handlers_destroy (self);
	if (self->priv->timer_id != ((guint) 0)) {
		g_source_remove (self->priv->timer_id);
	}
	(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
	self->priv->equal_func = NULL;
	self->priv->equal_func_target = NULL;
	self->priv->equal_func_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->queue);
}

static GType
timed_queue_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_timed_queue_init, value_timed_queue_free_value, value_timed_queue_copy_value, value_timed_queue_peek_pointer, "p", value_timed_queue_collect_value, "p", value_timed_queue_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TimedQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timed_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimedQueue), 0, (GInstanceInitFunc) timed_queue_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType timed_queue_type_id;
	timed_queue_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TimedQueue", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TimedQueue_private_offset = g_type_add_instance_private (timed_queue_type_id, sizeof (TimedQueuePrivate));
	return timed_queue_type_id;
}

GType
timed_queue_get_type (void)
{
	static volatile gsize timed_queue_type_id__once = 0;
	if (g_once_init_enter (&timed_queue_type_id__once)) {
		GType timed_queue_type_id;
		timed_queue_type_id = timed_queue_get_type_once ();
		g_once_init_leave (&timed_queue_type_id__once, timed_queue_type_id);
	}
	return timed_queue_type_id__once;
}

gpointer
timed_queue_ref (gpointer instance)
{
	TimedQueue * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
timed_queue_unref (gpointer instance)
{
	TimedQueue * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TIMED_QUEUE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
hash_timed_queue_get_instance_private (HashTimedQueue* self)
{
	return G_STRUCT_MEMBER_P (self, HashTimedQueue_private_offset);
}

HashTimedQueue*
hash_timed_queue_construct (GType object_type,
                            GType g_type,
                            GBoxedCopyFunc g_dup_func,
                            GDestroyNotify g_destroy_func,
                            guint hold_msec,
                            DequeuedCallback callback,
                            gpointer callback_target,
                            GeeHashDataFunc hash_func,
                            gpointer hash_func_target,
                            GDestroyNotify hash_func_target_destroy_notify,
                            GeeEqualDataFunc equal_func,
                            gpointer equal_func_target,
                            GDestroyNotify equal_func_target_destroy_notify,
                            gint priority)
{
	HashTimedQueue* self = NULL;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeHashDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	GeeHashMap* _tmp3_;
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	self = (HashTimedQueue*) timed_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, hold_msec, callback, callback_target, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, priority);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp1_ = hash_func;
	_tmp1__target = hash_func_target;
	_tmp1__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	_tmp2_ = equal_func;
	_tmp2__target = equal_func_target;
	_tmp2__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp3_ = gee_hash_map_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_INT, NULL, NULL, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_count);
	self->priv->item_count = _tmp3_;
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

HashTimedQueue*
hash_timed_queue_new (GType g_type,
                      GBoxedCopyFunc g_dup_func,
                      GDestroyNotify g_destroy_func,
                      guint hold_msec,
                      DequeuedCallback callback,
                      gpointer callback_target,
                      GeeHashDataFunc hash_func,
                      gpointer hash_func_target,
                      GDestroyNotify hash_func_target_destroy_notify,
                      GeeEqualDataFunc equal_func,
                      gpointer equal_func_target,
                      GDestroyNotify equal_func_target_destroy_notify,
                      gint priority)
{
	return hash_timed_queue_construct (TYPE_HASH_TIMED_QUEUE, g_type, g_dup_func, g_destroy_func, hold_msec, callback, callback_target, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify, priority);
}

static void
hash_timed_queue_real_notify_dequeued (TimedQueue* base,
                                       gconstpointer item)
{
	HashTimedQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	hash_timed_queue_removed (self, item);
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->notify_dequeued (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), item);
}

static void
hash_timed_queue_real_clear (TimedQueue* base)
{
	HashTimedQueue * self;
	GeeHashMap* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	_tmp0_ = self->priv->item_count;
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue));
}

static gboolean
hash_timed_queue_real_contains (TimedQueue* base,
                                gconstpointer item)
{
	HashTimedQueue * self;
	GeeHashMap* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	_tmp0_ = self->priv->item_count;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
	return result;
}

static gboolean
hash_timed_queue_real_enqueue (TimedQueue* base,
                               gconstpointer item)
{
	HashTimedQueue * self;
	gint _tmp0_ = 0;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	if (!TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->enqueue (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), item)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->item_count;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item)) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->item_count;
		_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
		_tmp0_ = ((gint) ((gintptr) _tmp3_)) + 1;
	} else {
		_tmp0_ = 1;
	}
	_tmp4_ = self->priv->item_count;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, (gpointer) ((gintptr) _tmp0_));
	result = TRUE;
	return result;
}

static gboolean
hash_timed_queue_real_enqueue_many (TimedQueue* base,
                                    GeeCollection* items)
{
	HashTimedQueue * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_COLLECTION), FALSE);
	if (!TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->enqueue_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), items)) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _item_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_ITERABLE, GeeIterable));
		_item_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer item = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gint _tmp4_ = 0;
			GeeHashMap* _tmp5_;
			gconstpointer _tmp6_;
			GeeHashMap* _tmp10_;
			gconstpointer _tmp11_;
			_tmp1_ = _item_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _item_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			item = _tmp3_;
			_tmp5_ = self->priv->item_count;
			_tmp6_ = item;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_)) {
				GeeHashMap* _tmp7_;
				gconstpointer _tmp8_;
				gpointer _tmp9_;
				_tmp7_ = self->priv->item_count;
				_tmp8_ = item;
				_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
				_tmp4_ = ((gint) ((gintptr) _tmp9_)) + 1;
			} else {
				_tmp4_ = 1;
			}
			_tmp10_ = self->priv->item_count;
			_tmp11_ = item;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, (gpointer) ((gintptr) _tmp4_));
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = TRUE;
	return result;
}

static gboolean
hash_timed_queue_real_remove_first (TimedQueue* base,
                                    gconstpointer item)
{
	HashTimedQueue * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	if (!TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->remove_first (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), item)) {
		result = FALSE;
		return result;
	}
	hash_timed_queue_removed (self, item);
	result = TRUE;
	return result;
}

static void
hash_timed_queue_removed (HashTimedQueue* self,
                          gconstpointer item)
{
	GeeHashMap* _tmp0_;
	gint count = 0;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint _tmp3_;
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	_tmp0_ = self->priv->item_count;
	if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item)) {
		return;
	}
	_tmp1_ = self->priv->item_count;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
	count = (gint) ((gintptr) _tmp2_);
	_vala_assert (count > 0, "count > 0");
	count = count - 1;
	_tmp3_ = count;
	if (_tmp3_ == 0) {
		GeeHashMap* _tmp4_;
		_tmp4_ = self->priv->item_count;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, NULL);
	} else {
		GeeHashMap* _tmp5_;
		_tmp5_ = self->priv->item_count;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, (gpointer) ((gintptr) count));
	}
}

static void
hash_timed_queue_class_init (HashTimedQueueClass * klass,
                             gpointer klass_data)
{
	hash_timed_queue_parent_class = g_type_class_peek_parent (klass);
	((TimedQueueClass *) klass)->finalize = hash_timed_queue_finalize;
	g_type_class_adjust_private_offset (klass, &HashTimedQueue_private_offset);
	((TimedQueueClass *) klass)->notify_dequeued = (void (*) (TimedQueue*, gconstpointer)) hash_timed_queue_real_notify_dequeued;
	((TimedQueueClass *) klass)->clear = (void (*) (TimedQueue*)) hash_timed_queue_real_clear;
	((TimedQueueClass *) klass)->contains = (gboolean (*) (TimedQueue*, gconstpointer)) hash_timed_queue_real_contains;
	((TimedQueueClass *) klass)->enqueue = (gboolean (*) (TimedQueue*, gconstpointer)) hash_timed_queue_real_enqueue;
	((TimedQueueClass *) klass)->enqueue_many = (gboolean (*) (TimedQueue*, GeeCollection*)) hash_timed_queue_real_enqueue_many;
	((TimedQueueClass *) klass)->remove_first = (gboolean (*) (TimedQueue*, gconstpointer)) hash_timed_queue_real_remove_first;
}

static void
hash_timed_queue_instance_init (HashTimedQueue * self,
                                gpointer klass)
{
	self->priv = hash_timed_queue_get_instance_private (self);
}

static void
hash_timed_queue_finalize (TimedQueue * obj)
{
	HashTimedQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	_g_object_unref0 (self->priv->item_count);
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->finalize (obj);
}

static GType
hash_timed_queue_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HashTimedQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hash_timed_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HashTimedQueue), 0, (GInstanceInitFunc) hash_timed_queue_instance_init, NULL };
	GType hash_timed_queue_type_id;
	hash_timed_queue_type_id = g_type_register_static (TYPE_TIMED_QUEUE, "HashTimedQueue", &g_define_type_info, 0);
	HashTimedQueue_private_offset = g_type_add_instance_private (hash_timed_queue_type_id, sizeof (HashTimedQueuePrivate));
	return hash_timed_queue_type_id;
}

GType
hash_timed_queue_get_type (void)
{
	static volatile gsize hash_timed_queue_type_id__once = 0;
	if (g_once_init_enter (&hash_timed_queue_type_id__once)) {
		GType hash_timed_queue_type_id;
		hash_timed_queue_type_id = hash_timed_queue_get_type_once ();
		g_once_init_leave (&hash_timed_queue_type_id__once, hash_timed_queue_type_id);
	}
	return hash_timed_queue_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

