/* Thumbnail.c generated by valac 0.56.17, the Vala compiler
 * generated from Thumbnail.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gee.h>
#include <pango/pango.h>

#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define THUMBNAIL_PROP_SHOW_TAGS CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES
#define THUMBNAIL_PROP_SIZE "thumbnail-size"
#define THUMBNAIL_PROP_SHOW_RATINGS "show-ratings"
#define THUMBNAIL_LOW_QUALITY_INTERP GDK_INTERP_NEAREST
#define THUMBNAIL_HIGH_QUALITY_INTERP GDK_INTERP_BILINEAR
#define THUMBNAIL_HQ_IMPROVEMENT_MSEC 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_MEDIA_SOURCE_ITEM (media_source_item_get_type ())
#define MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem))
#define MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))
#define IS_MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_ITEM))
#define IS_MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_ITEM))
#define MEDIA_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))

typedef struct _MediaSourceItem MediaSourceItem;
typedef struct _MediaSourceItemClass MediaSourceItemClass;
typedef struct _MediaSourceItemPrivate MediaSourceItemPrivate;

#define TYPE_THUMBNAIL (thumbnail_get_type ())
#define THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL, Thumbnail))
#define THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL, ThumbnailClass))
#define IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL))
#define IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL))
#define THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL, ThumbnailClass))

typedef struct _Thumbnail Thumbnail;
typedef struct _ThumbnailClass ThumbnailClass;
typedef struct _ThumbnailPrivate ThumbnailPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	THUMBNAIL_0_PROPERTY,
	THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* thumbnail_properties[THUMBNAIL_NUM_PROPERTIES];

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 512,
	THUMBNAIL_CACHE_SIZE_LARGE = 512,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*handle_mouse_motion) (CheckerboardItem* self, gint x, gint y, gint height, gint width);
	void (*handle_mouse_leave) (CheckerboardItem* self);
	void (*handle_mouse_enter) (CheckerboardItem* self);
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _MediaSourceItem {
	CheckerboardItem parent_instance;
	MediaSourceItemPrivate * priv;
};

struct _MediaSourceItemClass {
	CheckerboardItemClass parent_class;
};

struct _Thumbnail {
	MediaSourceItem parent_instance;
	ThumbnailPrivate * priv;
};

struct _ThumbnailClass {
	MediaSourceItemClass parent_class;
};

struct _ThumbnailPrivate {
	MediaSource* media;
	gint scale;
	Dimensions original_dim;
	Dimensions dim;
	GdkPixbuf* unscaled_pixbuf;
	GCancellable* cancellable;
	gboolean hq_scheduled;
	gboolean hq_reschedule;
	gboolean exposure;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

static gint Thumbnail_private_offset;
static gpointer thumbnail_parent_class = NULL;
VALA_EXTERN TagSourceCollection* tag_global;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN GType checkerboard_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardItem, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType media_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceItem, g_object_unref)
VALA_EXTERN GType thumbnail_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnail, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN void thumbnail_view_thumbnail_altered (ThumbnailView* self);
VALA_EXTERN void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
VALA_EXTERN void checkerboard_item_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_unexposed (CheckerboardItem* self);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self,
                                                    gint scale);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self,
                                                      gint scale);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self,
                                                   gint scale);
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType container_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSource, g_object_unref)
static void thumbnail_on_tag_contents_altered (Thumbnail* self,
                                        ContainerSource* container,
                                        GeeCollection* added,
                                        gboolean relinking,
                                        GeeCollection* removed,
                                        gboolean unlinking);
static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                ContainerSource* container,
                                                                                                GeeCollection* added,
                                                                                                gboolean relinked,
                                                                                                GeeCollection* removed,
                                                                                                gboolean unlinked,
                                                                                                gpointer self);
static void thumbnail_on_tags_altered (Thumbnail* self,
                                GeeMap* altered);
static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                               GeeMap* items,
                                                               gpointer self);
VALA_EXTERN Thumbnail* thumbnail_new (MediaSource* media,
                          gint scale);
VALA_EXTERN Thumbnail* thumbnail_construct (GType object_type,
                                MediaSource* media,
                                gint scale);
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN void dimensions_get_scaled (Dimensions *self,
                            gint scale,
                            gboolean scale_up,
                            Dimensions* result);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN MediaSourceItem* media_source_item_new (ThumbnailSource* source,
                                        Dimensions* initial_pixbuf_dim,
                                        const gchar* title,
                                        const gchar* comment,
                                        gboolean marked_up,
                                        PangoAlignment alignment);
VALA_EXTERN MediaSourceItem* media_source_item_construct (GType object_type,
                                              ThumbnailSource* source,
                                              Dimensions* initial_pixbuf_dim,
                                              const gchar* title,
                                              const gchar* comment,
                                              gboolean marked_up,
                                              PangoAlignment alignment);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
static void thumbnail_update_title (Thumbnail* self,
                             gboolean init);
static void thumbnail_update_comment (Thumbnail* self,
                               gboolean init);
static void thumbnail_update_tags (Thumbnail* self,
                            gboolean init);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                                             MediaSource* photo);
VALA_EXTERN void checkerboard_item_clear_tags (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_tags (CheckerboardItem* self,
                                 GeeCollection* tags,
                                 PangoAlignment alignment);
VALA_EXTERN gboolean tag_contains (Tag* self,
                       MediaSource* source);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN void checkerboard_item_clear_title (CheckerboardItem* self);
VALA_EXTERN void media_source_item_set_title (MediaSourceItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
VALA_EXTERN void checkerboard_item_clear_comment (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
static void thumbnail_real_notify_altered (DataObject* base,
                                    Alteration* alteration);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
VALA_EXTERN MediaSource* thumbnail_get_media_source (Thumbnail* self);
VALA_EXTERN gint64 thumbnail_photo_id_ascending_comparator (void* a,
                                                void* b);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
VALA_EXTERN gint64 thumbnail_photo_id_descending_comparator (void* a,
                                                 void* b);
VALA_EXTERN gint64 thumbnail_title_ascending_comparator (void* a,
                                             void* b);
VALA_EXTERN gchar* media_source_item_get_natural_collation_key (MediaSourceItem* self);
VALA_EXTERN gint64 thumbnail_title_descending_comparator (void* a,
                                              void* b);
VALA_EXTERN gboolean thumbnail_title_comparator_predicate (DataObject* object,
                                               Alteration* alteration);
VALA_EXTERN gint64 thumbnail_exposure_time_ascending_comparator (void* a,
                                                     void* b);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN gint64 nullsafe_date_time_comperator (GDateTime* time_a,
                                      GDateTime* time_b);
VALA_EXTERN gint64 thumbnail_filename_ascending_comparator (void* a,
                                                void* b);
VALA_EXTERN gint64 thumbnail_exposure_time_descending_comparator (void* a,
                                                      void* b);
VALA_EXTERN gint64 thumbnail_filename_descending_comparator (void* a,
                                                 void* b);
VALA_EXTERN gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object,
                                                       Alteration* alteration);
VALA_EXTERN gboolean thumbnail_filename_comparator_predicate (DataObject* object,
                                                  Alteration* alteration);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN gint64 thumbnail_rating_ascending_comparator (void* a,
                                              void* b);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN gint64 thumbnail_rating_descending_comparator (void* a,
                                               void* b);
VALA_EXTERN gboolean thumbnail_rating_comparator_predicate (DataObject* object,
                                                Alteration* alteration);
static void thumbnail_real_thumbnail_altered (ThumbnailView* base);
static void thumbnail_delayed_high_quality_fetch (Thumbnail* self);
static void thumbnail_paint_empty (Thumbnail* self);
static void thumbnail_real_notify_collection_property_set (DataObject* base,
                                                    const gchar* name,
                                                    GValue* old,
                                                    GValue* val);
static void thumbnail_resize (Thumbnail* self,
                       gint new_scale);
VALA_EXTERN void data_view_notify_view_altered (DataView* self);
VALA_EXTERN gint thumbnail_get_MIN_SCALE (void);
VALA_EXTERN gint thumbnail_get_MAX_SCALE (void);
static void thumbnail_cancel_async_fetch (Thumbnail* self);
VALA_EXTERN gboolean checkerboard_item_has_image (CheckerboardItem* self);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
VALA_EXTERN void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
static void thumbnail_schedule_low_quality_fetch (Thumbnail* self);
VALA_EXTERN void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable);
VALA_EXTERN GType thumbnail_cache_size_get_type (void) G_GNUC_CONST ;
static void thumbnail_on_low_quality_fetched (Thumbnail* self,
                                       GdkPixbuf* pixbuf,
                                       GdkPixbuf* unscaled,
                                       Dimensions* dim,
                                       GdkInterpType interp,
                                       GError* err);
static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                             GdkPixbuf* unscaled,
                                                                             Dimensions* dim,
                                                                             GdkInterpType interp,
                                                                             GError* err,
                                                                             gpointer self);
static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self);
static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self);
static void thumbnail_on_high_quality_fetched (Thumbnail* self,
                                        GdkPixbuf* pixbuf,
                                        GdkPixbuf* unscaled,
                                        Dimensions* dim,
                                        GdkInterpType interp,
                                        GError* err);
static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                              GdkPixbuf* unscaled,
                                                                              Dimensions* dim,
                                                                              GdkInterpType interp,
                                                                              GError* err,
                                                                              gpointer self);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
static void thumbnail_real_exposed (CheckerboardItem* base);
static void thumbnail_real_unexposed (CheckerboardItem* base);
static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base,
                                                 gint scale);
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
VALA_EXTERN GdkPixbuf* resources_get_flagged_trinket (gint scale);
static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base,
                                                   gint scale);
VALA_EXTERN void data_object_get_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* def,
                                          GValue* result);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN GdkPixbuf* resources_get_rating_trinket (Rating rating,
                                         gint scale);
static GdkPixbuf* thumbnail_real_get_top_left_trinket (CheckerboardItem* base,
                                                gint scale);
VALA_EXTERN GdkPixbuf* resources_get_video_trinket (gint scale);
VALA_EXTERN gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
VALA_EXTERN gint thumbnail_get_DEFAULT_SCALE (void);
static void thumbnail_finalize (GObject * obj);
static GType thumbnail_get_type_once (void);
static void _vala_thumbnail_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
thumbnail_get_instance_private (Thumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, Thumbnail_private_offset);
}

static void
_thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                           ContainerSource* container,
                                                                                           GeeCollection* added,
                                                                                           gboolean relinked,
                                                                                           GeeCollection* removed,
                                                                                           gboolean unlinked,
                                                                                           gpointer self)
{
	thumbnail_on_tag_contents_altered ((Thumbnail*) self, container, added, relinked, removed, unlinked);
}

static void
_thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                          GeeMap* items,
                                                          gpointer self)
{
	thumbnail_on_tags_altered ((Thumbnail*) self, items);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Thumbnail*
thumbnail_construct (GType object_type,
                     MediaSource* media,
                     gint scale)
{
	Thumbnail * self = NULL;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	MediaSource* _tmp6_;
	TagSourceCollection* _tmp7_;
	TagSourceCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	Dimensions _tmp10_ = {0};
	Dimensions _tmp11_ = {0};
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp0_);
	dimensions_get_scaled (&_tmp0_, scale, TRUE, &_tmp1_);
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_DATA_OBJECT, DataObject));
	_tmp3_ = _tmp2_;
	_tmp4_ = media_source_get_comment (media);
	_tmp5_ = _tmp4_;
	self = (Thumbnail*) media_source_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp1_, _tmp3_, _tmp5_, FALSE, PANGO_ALIGN_LEFT);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = _g_object_ref0 (media);
	_g_object_unref0 (self->priv->media);
	self->priv->media = _tmp6_;
	self->priv->scale = scale;
	_tmp7_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
	_tmp8_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self, 0);
	if (IS_LIBRARY_PHOTO (media)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = IS_VIDEO (media);
	}
	_vala_assert (_tmp9_, "(media is LibraryPhoto) || (media is Video)");
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp10_);
	self->priv->original_dim = _tmp10_;
	dimensions_get_scaled (&self->priv->original_dim, scale, TRUE, &_tmp11_);
	self->priv->dim = _tmp11_;
	thumbnail_update_title (self, TRUE);
	thumbnail_update_comment (self, TRUE);
	thumbnail_update_tags (self, TRUE);
	return self;
}

Thumbnail*
thumbnail_new (MediaSource* media,
               gint scale)
{
	return thumbnail_construct (TYPE_THUMBNAIL, media, scale);
}

static void
thumbnail_update_tags (Thumbnail* self,
                       gboolean init)
{
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_;
	MediaSource* _tmp1_;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	g_return_if_fail (IS_THUMBNAIL (self));
	_tmp0_ = tag_global;
	_tmp1_ = self->priv->media;
	_tmp2_ = tag_source_collection_fetch_sorted_for_source (_tmp0_, _tmp1_);
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = tags;
		_tmp6_ = gee_collection_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		checkerboard_item_clear_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	} else {
		GeeCollection* _tmp8_;
		_tmp8_ = tags;
		checkerboard_item_set_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp8_, PANGO_ALIGN_LEFT);
	}
	_g_object_unref0 (tags);
}

static void
thumbnail_on_tag_contents_altered (Thumbnail* self,
                                   ContainerSource* container,
                                   GeeCollection* added,
                                   gboolean relinking,
                                   GeeCollection* removed,
                                   gboolean unlinking)
{
	gboolean _tmp0_ = FALSE;
	gboolean tag_added = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean tag_removed = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_THUMBNAIL (self));
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	if (!self->priv->exposure) {
		return;
	}
	if (added != NULL) {
		MediaSource* _tmp1_;
		_tmp1_ = self->priv->media;
		_tmp0_ = gee_collection_contains (added, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource));
	} else {
		_tmp0_ = FALSE;
	}
	tag_added = _tmp0_;
	if (removed != NULL) {
		MediaSource* _tmp3_;
		_tmp3_ = self->priv->media;
		_tmp2_ = gee_collection_contains (removed, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_SOURCE, DataSource));
	} else {
		_tmp2_ = FALSE;
	}
	tag_removed = _tmp2_;
	if (tag_added) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = tag_removed;
	}
	if (_tmp4_) {
		thumbnail_update_tags (self, FALSE);
	}
}

static void
thumbnail_on_tags_altered (Thumbnail* self,
                           GeeMap* altered)
{
	g_return_if_fail (IS_THUMBNAIL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (altered, GEE_TYPE_MAP));
	if (!self->priv->exposure) {
		return;
	}
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (altered);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Tag* tag = NULL;
			DataObject* _tmp8_;
			Tag* _tmp9_;
			Tag* _tmp10_;
			MediaSource* _tmp11_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TAG, Tag));
			tag = _tmp9_;
			_tmp10_ = tag;
			_tmp11_ = self->priv->media;
			if (tag_contains (_tmp10_, _tmp11_)) {
				thumbnail_update_tags (self, FALSE);
				_g_object_unref0 (tag);
				_g_object_unref0 (object);
				break;
			}
			_g_object_unref0 (tag);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
thumbnail_update_title (Thumbnail* self,
                        gboolean init)
{
	gchar* title = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (IS_THUMBNAIL (self));
	_tmp0_ = self->priv->media;
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
	title = _tmp1_;
	_tmp2_ = title;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = title;
			media_source_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (title);
}

static void
thumbnail_update_comment (Thumbnail* self,
                          gboolean init)
{
	gchar* comment = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (IS_THUMBNAIL (self));
	_tmp0_ = self->priv->media;
	_tmp1_ = media_source_get_comment (_tmp0_);
	comment = _tmp1_;
	_tmp2_ = comment;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = comment;
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (comment);
}

static void
thumbnail_real_notify_altered (DataObject* base,
                               Alteration* alteration)
{
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	g_return_if_fail (IS_ALTERATION (alteration));
	if (self->priv->exposure) {
		_tmp0_ = alteration_has_detail (alteration, "metadata", "name");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		thumbnail_update_title (self, FALSE);
	}
	if (self->priv->exposure) {
		_tmp1_ = alteration_has_detail (alteration, "metadata", "comment");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		thumbnail_update_comment (self, FALSE);
	}
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), alteration);
}

MediaSource*
thumbnail_get_media_source (Thumbnail* self)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* result;
	g_return_val_if_fail (IS_THUMBNAIL (self), NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gint64
thumbnail_photo_id_ascending_comparator (void* a,
                                         void* b)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	gint64 result;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	result = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource)) - data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource));
	return result;
}

gint64
thumbnail_photo_id_descending_comparator (void* a,
                                          void* b)
{
	gint64 result;
	result = thumbnail_photo_id_ascending_comparator (b, a);
	return result;
}

gint64
thumbnail_title_ascending_comparator (void* a,
                                      void* b)
{
	gint64 _result_ = 0LL;
	GCompareFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_ = 0LL;
	gint64 result;
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
	_tmp2_ = _tmp1_;
	_tmp3_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
	_tmp4_ = _tmp3_;
	_tmp5_ = (gint64) _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_result_ = _tmp5_;
	if (_result_ != ((gint64) 0)) {
		_tmp6_ = _result_;
	} else {
		_tmp6_ = thumbnail_photo_id_ascending_comparator (a, b);
	}
	result = _tmp6_;
	return result;
}

gint64
thumbnail_title_descending_comparator (void* a,
                                       void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_title_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_title_comparator_predicate (DataObject* object,
                                      Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = alteration_has_detail (alteration, "metadata", "title");
	return result;
}

gint64
thumbnail_exposure_time_ascending_comparator (void* a,
                                              void* b)
{
	GDateTime* time_a = NULL;
	MediaSource* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* time_b = NULL;
	MediaSource* _tmp2_;
	GDateTime* _tmp3_;
	gint64 _result_ = 0LL;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gint64 _tmp6_ = 0LL;
	gint64 result;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp1_ = media_source_get_exposure_time (_tmp0_);
	time_a = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp3_ = media_source_get_exposure_time (_tmp2_);
	time_b = _tmp3_;
	_tmp4_ = time_a;
	_tmp5_ = time_b;
	_result_ = nullsafe_date_time_comperator (_tmp4_, _tmp5_);
	if (_result_ != ((gint64) 0)) {
		_tmp6_ = _result_;
	} else {
		_tmp6_ = thumbnail_filename_ascending_comparator (a, b);
	}
	result = _tmp6_;
	_g_date_time_unref0 (time_b);
	_g_date_time_unref0 (time_a);
	return result;
}

gint64
thumbnail_exposure_time_descending_comparator (void* a,
                                               void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_exposure_time_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_filename_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_exposure_time_comparator_predicate (DataObject* object,
                                              Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = alteration_has_detail (alteration, "metadata", "exposure-time");
	return result;
}

gboolean
thumbnail_filename_comparator_predicate (DataObject* object,
                                         Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = alteration_has_detail (alteration, "metadata", "filename");
	return result;
}

gint64
thumbnail_filename_ascending_comparator (void* a,
                                         void* b)
{
	gchar* path_a = NULL;
	MediaSource* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* path_b = NULL;
	MediaSource* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gint64 _tmp27_;
	gint64 _tmp28_ = 0LL;
	gint64 result;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp1_ = media_source_get_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	path_a = _tmp6_;
	_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp8_ = media_source_get_file (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_basename (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	path_b = _tmp13_;
	_tmp14_ = path_a;
	if (!g_utf8_validate (_tmp14_, (gssize) -1, NULL)) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = path_a;
		_tmp16_ = g_uri_escape_string (_tmp15_, G_URI_RESERVED_CHARS_ALLOWED_IN_PATH, TRUE);
		_g_free0 (path_a);
		path_a = _tmp16_;
	}
	_tmp17_ = path_b;
	if (!g_utf8_validate (_tmp17_, (gssize) -1, NULL)) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = path_b;
		_tmp19_ = g_uri_escape_string (_tmp18_, G_URI_RESERVED_CHARS_ALLOWED_IN_PATH, TRUE);
		_g_free0 (path_b);
		path_b = _tmp19_;
	}
	_tmp20_ = ((GCompareFunc) g_strcmp0);
	_tmp21_ = path_a;
	_tmp22_ = g_utf8_collate_key_for_filename (_tmp21_, (gssize) -1);
	_tmp23_ = _tmp22_;
	_tmp24_ = path_b;
	_tmp25_ = g_utf8_collate_key_for_filename (_tmp24_, (gssize) -1);
	_tmp26_ = _tmp25_;
	_tmp27_ = (gint64) _tmp20_ (_tmp23_, _tmp26_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp23_);
	_result_ = _tmp27_;
	if (_result_ != ((gint64) 0)) {
		_tmp28_ = _result_;
	} else {
		_tmp28_ = thumbnail_photo_id_ascending_comparator (a, b);
	}
	result = _tmp28_;
	_g_free0 (path_b);
	_g_free0 (path_a);
	return result;
}

gint64
thumbnail_filename_descending_comparator (void* a,
                                          void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_filename_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gint64
thumbnail_rating_ascending_comparator (void* a,
                                       void* b)
{
	gint64 _result_ = 0LL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	gint64 _tmp2_ = 0LL;
	gint64 result;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
	_result_ = (gint64) (media_source_get_rating (_tmp0_) - media_source_get_rating (_tmp1_));
	if (_result_ != ((gint64) 0)) {
		_tmp2_ = _result_;
	} else {
		_tmp2_ = thumbnail_photo_id_ascending_comparator (a, b);
	}
	result = _tmp2_;
	return result;
}

gint64
thumbnail_rating_descending_comparator (void* a,
                                        void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_rating_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_rating_comparator_predicate (DataObject* object,
                                       Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = alteration_has_detail (alteration, "metadata", "rating");
	return result;
}

static void
thumbnail_real_thumbnail_altered (ThumbnailView* base)
{
	Thumbnail * self;
	MediaSource* _tmp0_;
	Dimensions _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	_tmp0_ = self->priv->media;
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
	self->priv->original_dim = _tmp1_;
	dimensions_get_scaled (&self->priv->original_dim, self->priv->scale, TRUE, &_tmp2_);
	self->priv->dim = _tmp2_;
	if (self->priv->exposure) {
		thumbnail_delayed_high_quality_fetch (self);
	} else {
		thumbnail_paint_empty (self);
	}
	THUMBNAIL_VIEW_CLASS (thumbnail_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
}

static void
thumbnail_real_notify_collection_property_set (DataObject* base,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val)
{
	Thumbnail * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GValue _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (THUMBNAIL_PROP_SIZE)))) {
		switch (0) {
			default:
			{
				GValue _tmp3_;
				_tmp3_ = *val;
				thumbnail_resize (self, g_value_get_int (&_tmp3_));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (THUMBNAIL_PROP_SHOW_RATINGS)))) {
		switch (0) {
			default:
			{
				data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
				break;
			}
		}
	}
	_tmp4_ = *val;
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), name, old, &_tmp4_);
}

static void
thumbnail_resize (Thumbnail* self,
                  gint new_scale)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	g_return_if_fail (IS_THUMBNAIL (self));
	_tmp0_ = thumbnail_get_MIN_SCALE ();
	_tmp1_ = _tmp0_;
	_vala_assert (new_scale >= _tmp1_, "new_scale >= MIN_SCALE");
	_tmp2_ = thumbnail_get_MAX_SCALE ();
	_tmp3_ = _tmp2_;
	_vala_assert (new_scale <= _tmp3_, "new_scale <= MAX_SCALE");
	if (self->priv->scale == new_scale) {
		return;
	}
	self->priv->scale = new_scale;
	dimensions_get_scaled (&self->priv->original_dim, self->priv->scale, TRUE, &_tmp4_);
	self->priv->dim = _tmp4_;
	thumbnail_cancel_async_fetch (self);
	if (self->priv->exposure) {
		GdkPixbuf* resizable = NULL;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp9_;
		resizable = NULL;
		_tmp5_ = self->priv->unscaled_pixbuf;
		if (_tmp5_ != NULL) {
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			_tmp6_ = self->priv->unscaled_pixbuf;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (resizable);
			resizable = _tmp7_;
		} else {
			if (checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
				GdkPixbuf* _tmp8_;
				_tmp8_ = checkerboard_item_get_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
				_g_object_unref0 (resizable);
				resizable = _tmp8_;
			}
		}
		_tmp9_ = resizable;
		if (_tmp9_ != NULL) {
			GdkPixbuf* _tmp10_;
			Dimensions _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp10_ = resizable;
			_tmp11_ = self->priv->dim;
			_tmp12_ = resize_pixbuf (_tmp10_, &_tmp11_, THUMBNAIL_LOW_QUALITY_INTERP);
			_tmp13_ = _tmp12_;
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp13_);
			_g_object_unref0 (_tmp13_);
		}
		thumbnail_delayed_high_quality_fetch (self);
		_g_object_unref0 (resizable);
	} else {
		Dimensions _tmp14_;
		_tmp14_ = self->priv->dim;
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp14_);
	}
}

static void
thumbnail_paint_empty (Thumbnail* self)
{
	Dimensions _tmp0_;
	g_return_if_fail (IS_THUMBNAIL (self));
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = self->priv->dim;
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp0_);
	_g_object_unref0 (self->priv->unscaled_pixbuf);
	self->priv->unscaled_pixbuf = NULL;
}

static void
_thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                        GdkPixbuf* unscaled,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        GError* err,
                                                                        gpointer self)
{
	thumbnail_on_low_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
}

static void
thumbnail_schedule_low_quality_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
	MediaSource* _tmp1_;
	Dimensions _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (IS_THUMBNAIL (self));
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = self->priv->media;
	_tmp2_ = self->priv->dim;
	_tmp3_ = self->priv->cancellable;
	thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_SMALLEST, &_tmp2_, THUMBNAIL_LOW_QUALITY_INTERP, _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
}

static gboolean
_thumbnail_on_schedule_high_quality_gsource_func (gpointer self)
{
	gboolean result;
	result = thumbnail_on_schedule_high_quality ((Thumbnail*) self);
	return result;
}

static void
thumbnail_delayed_high_quality_fetch (Thumbnail* self)
{
	g_return_if_fail (IS_THUMBNAIL (self));
	if (self->priv->hq_scheduled) {
		self->priv->hq_reschedule = TRUE;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) THUMBNAIL_HQ_IMPROVEMENT_MSEC, _thumbnail_on_schedule_high_quality_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->hq_scheduled = TRUE;
}

static void
_thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                         GdkPixbuf* unscaled,
                                                                         Dimensions* dim,
                                                                         GdkInterpType interp,
                                                                         GError* err,
                                                                         gpointer self)
{
	thumbnail_on_high_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
}

static gboolean
thumbnail_on_schedule_high_quality (Thumbnail* self)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_THUMBNAIL (self), FALSE);
	if (self->priv->hq_reschedule) {
		self->priv->hq_reschedule = FALSE;
		result = TRUE;
		return result;
	}
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	if (self->priv->exposure) {
		MediaSource* _tmp1_;
		Dimensions _tmp2_;
		GCancellable* _tmp3_;
		_tmp1_ = self->priv->media;
		_tmp2_ = self->priv->dim;
		_tmp3_ = self->priv->cancellable;
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), self->priv->scale, &_tmp2_, THUMBNAIL_HIGH_QUALITY_INTERP, _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
	}
	self->priv->hq_scheduled = FALSE;
	result = FALSE;
	return result;
}

static void
thumbnail_cancel_async_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (IS_THUMBNAIL (self));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
thumbnail_on_low_quality_fetched (Thumbnail* self,
                                  GdkPixbuf* pixbuf,
                                  GdkPixbuf* unscaled,
                                  Dimensions* dim,
                                  GdkInterpType interp,
                                  GError* err)
{
	g_return_if_fail (IS_THUMBNAIL (self));
	g_return_if_fail ((pixbuf == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail ((unscaled == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unscaled, gdk_pixbuf_get_type ()));
	g_return_if_fail (dim != NULL);
	if (err != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = _tmp0_;
		_tmp2_ = err->message;
		g_critical ("Thumbnail.vala:343: Unable to fetch low-quality thumbnail for %s (scal" \
"e: %d): %s", _tmp1_, self->priv->scale, _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (pixbuf != NULL) {
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), pixbuf);
	}
	if (unscaled != NULL) {
		GdkPixbuf* _tmp3_;
		_tmp3_ = _g_object_ref0 (unscaled);
		_g_object_unref0 (self->priv->unscaled_pixbuf);
		self->priv->unscaled_pixbuf = _tmp3_;
	}
	thumbnail_delayed_high_quality_fetch (self);
}

static void
thumbnail_on_high_quality_fetched (Thumbnail* self,
                                   GdkPixbuf* pixbuf,
                                   GdkPixbuf* unscaled,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   GError* err)
{
	g_return_if_fail (IS_THUMBNAIL (self));
	g_return_if_fail ((pixbuf == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail ((unscaled == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unscaled, gdk_pixbuf_get_type ()));
	g_return_if_fail (dim != NULL);
	if (err != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = _tmp0_;
		_tmp2_ = err->message;
		g_critical ("Thumbnail.vala:358: Unable to fetch high-quality thumbnail for %s (sca" \
"le: %d): %s", _tmp1_, self->priv->scale, _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (pixbuf != NULL) {
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), pixbuf);
	}
	if (unscaled != NULL) {
		GdkPixbuf* _tmp3_;
		_tmp3_ = _g_object_ref0 (unscaled);
		_g_object_unref0 (self->priv->unscaled_pixbuf);
		self->priv->unscaled_pixbuf = _tmp3_;
	}
}

static void
thumbnail_real_exposed (CheckerboardItem* base)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	self->priv->exposure = TRUE;
	if (!checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
		thumbnail_schedule_low_quality_fetch (self);
	}
	thumbnail_update_title (self, FALSE);
	thumbnail_update_comment (self, FALSE);
	thumbnail_update_tags (self, FALSE);
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
thumbnail_real_unexposed (CheckerboardItem* base)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	self->priv->exposure = FALSE;
	thumbnail_paint_empty (self);
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static GdkPixbuf*
thumbnail_real_get_top_right_trinket (CheckerboardItem* base,
                                      gint scale)
{
	Thumbnail * self;
	Flaggable* flaggable = NULL;
	MediaSource* _tmp0_;
	Flaggable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	Flaggable* _tmp3_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	_tmp0_ = self->priv->media;
	_tmp1_ = _g_object_ref0 (IS_FLAGGABLE (_tmp0_) ? ((Flaggable*) _tmp0_) : NULL);
	flaggable = _tmp1_;
	_tmp3_ = flaggable;
	if (_tmp3_ != NULL) {
		Flaggable* _tmp4_;
		_tmp4_ = flaggable;
		_tmp2_ = flaggable_is_flagged (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (!_tmp2_) {
		result = NULL;
		_g_object_unref0 (flaggable);
		return result;
	}
	_tmp5_ = resources_get_flagged_trinket (scale);
	result = _tmp5_;
	_g_object_unref0 (flaggable);
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static GdkPixbuf*
thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base,
                                        gint scale)
{
	Thumbnail * self;
	Rating rating = 0;
	MediaSource* _tmp0_;
	gboolean show_ratings = FALSE;
	GValue* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	gboolean _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	_tmp0_ = self->priv->media;
	rating = media_source_get_rating (_tmp0_);
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp1_, FALSE);
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), THUMBNAIL_PROP_SHOW_RATINGS, _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_value_get_boolean (&_tmp2_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	__vala_GValue_free0 (_tmp1_);
	show_ratings = _tmp4_;
	if (rating != RATING_UNRATED) {
		_tmp6_ = show_ratings;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GdkPixbuf* _tmp7_;
		_tmp7_ = resources_get_rating_trinket (rating, scale);
		_g_object_unref0 (_tmp5_);
		_tmp5_ = _tmp7_;
	} else {
		_g_object_unref0 (_tmp5_);
		_tmp5_ = NULL;
	}
	result = _tmp5_;
	return result;
}

static GdkPixbuf*
thumbnail_real_get_top_left_trinket (CheckerboardItem* base,
                                     gint scale)
{
	Thumbnail * self;
	GdkPixbuf* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
	_tmp1_ = self->priv->media;
	if (IS_VIDEO (_tmp1_)) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = resources_get_video_trinket (scale);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

gint
thumbnail_get_MIN_SCALE (void)
{
	gint result;
	result = 72;
	return result;
}

gint
thumbnail_get_MAX_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_LARGEST);
	return result;
}

gint
thumbnail_get_DEFAULT_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
	return result;
}

static void
thumbnail_class_init (ThumbnailClass * klass,
                      gpointer klass_data)
{
	thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Thumbnail_private_offset);
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) thumbnail_real_notify_altered;
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView*)) thumbnail_real_thumbnail_altered;
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject*, const gchar*, GValue*, GValue*)) thumbnail_real_notify_collection_property_set;
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) thumbnail_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) thumbnail_real_unexposed;
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) thumbnail_real_get_top_right_trinket;
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) thumbnail_real_get_bottom_left_trinket;
	((CheckerboardItemClass *) klass)->get_top_left_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) thumbnail_real_get_top_left_trinket;
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->finalize = thumbnail_finalize;
}

static void
thumbnail_instance_init (Thumbnail * self,
                         gpointer klass)
{
	self->priv = thumbnail_get_instance_private (self);
	self->priv->unscaled_pixbuf = NULL;
	self->priv->cancellable = NULL;
	self->priv->hq_scheduled = FALSE;
	self->priv->hq_reschedule = FALSE;
	self->priv->exposure = FALSE;
}

static void
thumbnail_finalize (GObject * obj)
{
	Thumbnail * self;
	GCancellable* _tmp0_;
	TagSourceCollection* _tmp2_;
	guint _tmp3_;
	TagSourceCollection* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL, Thumbnail);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = tag_global;
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
	_tmp4_ = tag_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->priv->media);
	_g_object_unref0 (self->priv->unscaled_pixbuf);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (thumbnail_parent_class)->finalize (obj);
}

static GType
thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnail), 0, (GInstanceInitFunc) thumbnail_instance_init, NULL };
	GType thumbnail_type_id;
	thumbnail_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_ITEM, "Thumbnail", &g_define_type_info, 0);
	Thumbnail_private_offset = g_type_add_instance_private (thumbnail_type_id, sizeof (ThumbnailPrivate));
	return thumbnail_type_id;
}

GType
thumbnail_get_type (void)
{
	static volatile gsize thumbnail_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_type_id__once)) {
		GType thumbnail_type_id;
		thumbnail_type_id = thumbnail_get_type_once ();
		g_once_init_leave (&thumbnail_type_id__once, thumbnail_type_id);
	}
	return thumbnail_type_id__once;
}

static void
_vala_thumbnail_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

