/* Resources.c generated by valac 0.56.17, the Vala compiler
 * generated from Resources.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <version.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gee.h>
#include <locale.h>
#include <langinfo.h>
#include <gio/gio.h>

#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_LIBRARY_ROLE _ ("Photo Manager")
#define RESOURCES_APP_DIRECT_ROLE _ ("Photo Viewer")
#define RESOURCES_APP_VERSION _VERSION
#define RESOURCES_GIT_VERSION _GIT_VERSION
#define RESOURCES_COPYRIGHT _ ("Copyright 2016 Software Freedom Conservancy Inc.")
#define RESOURCES_APP_GETTEXT_PACKAGE GETTEXT_PACKAGE
#define RESOURCES_HOME_URL "https://wiki.gnome.org/Apps/Shotwell"
#define RESOURCES_FAQ_URL "https://wiki.gnome.org/Apps/Shotwell/FAQ"
#define RESOURCES_BUG_DB_URL "https://wiki.gnome.org/Apps/Shotwell/ReportingABug"
#define RESOURCES_DIR_PATTERN_URI_SYSWIDE "help:shotwell/other-files"
#define RESOURCES_LIB _LIB
#define RESOURCES_LIBEXECDIR _LIBEXECDIR
#define RESOURCES_PREFIX _PREFIX
#define RESOURCES_PIXBUF_LOADER_PATH _PIXBUF_LOADER_PATH
#define RESOURCES_TRANSIENT_WINDOW_OPACITY 0.90
#define RESOURCES_DEFAULT_ICON_SCALE 24
#define RESOURCES_LICENSE "\n" \
"Shotwell is free software; you can redistribute it and/or modify it un" \
"der the \n" \
"terms of the GNU Lesser General Public License as published by the Fre" \
"e \n" \
"Software Foundation; either version 2.1 of the License, or (at your op" \
"tion) \n" \
"any later version.\n" \
"\n" \
"Shotwell is distributed in the hope that it will be useful, but WITHOU" \
"T \n" \
"ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or " \
"FITNESS\n" \
"FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License f" \
"or \n" \
"more details.\n" \
"\n" \
"You should have received a copy of the GNU Lesser General Public Licen" \
"se \n" \
"along with Shotwell; if not, write to the Free Software Foundation, In" \
"c., \n" \
"51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA\n"
#define RESOURCES_CLOCKWISE "object-rotate-right-symbolic"
#define RESOURCES_COUNTERCLOCKWISE "object-rotate-left-symbolic"
#define RESOURCES_HFLIP "object-flip-horizontal-symbolic"
#define RESOURCES_VFLIP "object-flip-vertical-symbolic"
#define RESOURCES_STRAIGHTEN "straighten-symbolic"
#define RESOURCES_ADJUST "image-adjust-color-symbolic"
#define RESOURCES_IMPORT "image-x-generic-symbolic"
#define RESOURCES_IMPORT_ALL "filter-photos-symbolic"
#define RESOURCES_ENHANCE "image-auto-adjust-symbolic"
#define RESOURCES_PUBLISH "send-to-symbolic"
#define RESOURCES_FACES_TOOL "avatar-default-symbolic"
#define RESOURCES_GO_NEXT "go-next-symbolic"
#define RESOURCES_GO_PREVIOUS "go-previous-symbolic"
#define RESOURCES_ICON_ABOUT_LOGO "Delmenhorst_Rathaus.jpg"
#define RESOURCES_ICON_GENERIC_PLUGIN "application-x-addon-symbolic"
#define RESOURCES_ICON_SLIDESHOW_EXTENSION_POINT "slideshow-extension-point"
#define RESOURCES_ICON_FILTER_REJECTED_OR_BETTER_FIXED_SIZE 32
#define RESOURCES_ICON_FILTER_UNRATED_OR_BETTER_FIXED_SIZE 16
#define RESOURCES_ICON_ZOOM_SCALE 16
#define RESOURCES_ICON_GPS_MARKER "gps-marker"
#define RESOURCES_ICON_GPS_MARKER_HIGHLIGHTED "gps-marker-highlighted"
#define RESOURCES_ICON_GPS_MARKER_SELECTED "gps-marker-selected"
#define RESOURCES_ICON_GPS_GROUP_MARKER "gps-markers-many"
#define RESOURCES_ICON_GPS_GROUP_MARKER_HIGHLIGHTED "gps-markers-many-highlighted"
#define RESOURCES_ICON_GPS_GROUP_MARKER_SELECTED "gps-markers-many-selected"
#define RESOURCES_ICON_MAP_EDIT_LOCKED "map-edit-locked"
#define RESOURCES_ICON_MAP_EDIT_UNLOCKED "map-edit-unlocked"
#define RESOURCES_ICON_CAMERAS "camera-photo-symbolic"
#define RESOURCES_ICON_EVENTS "multiple-events-symbolic"
#define RESOURCES_ICON_ONE_EVENT "one-event-symbolic"
#define RESOURCES_ICON_NO_EVENT "no-event-symbolic"
#define RESOURCES_ICON_ONE_TAG "one-tag-symbolic"
#define RESOURCES_ICON_TAGS "multiple-tags-symbolic"
#define RESOURCES_ICON_FOLDER "folder-symbolic"
#define RESOURCES_ICON_FOLDER_DOCUMENTS "folder-documents-symbolic"
#define RESOURCES_ICON_IMPORTING "go-down-symbolic"
#define RESOURCES_ICON_LAST_IMPORT "document-open-recent-symbolic"
#define RESOURCES_ICON_MISSING_FILES "process-stop-symbolic"
#define RESOURCES_ICON_PHOTOS "shotwell-symbolic"
#define RESOURCES_ICON_SINGLE_PHOTO "image-x-generic-symbolic"
#define RESOURCES_ICON_TRASH_EMPTY "user-trash-symbolic"
#define RESOURCES_ICON_TRASH_FULL "user-trash-full-symbolic"
#define RESOURCES_ICON_ONE_FACE "avatar-default-symbolic"
#define RESOURCES_ICON_FACES "avatar-default-symbolic"
#define RESOURCES_ROTATE_CW_MENU _ ("Rotate _Right")
#define RESOURCES_ROTATE_CW_LABEL _ ("Rotate")
#define RESOURCES_ROTATE_CW_FULL_LABEL _ ("Rotate Right")
#define RESOURCES_ROTATE_CW_TOOLTIP _ ("Rotate the photos right (press Ctrl to rotate left)")
#define RESOURCES_ROTATE_CCW_MENU _ ("Rotate _Left")
#define RESOURCES_ROTATE_CCW_LABEL _ ("Rotate")
#define RESOURCES_ROTATE_CCW_FULL_LABEL _ ("Rotate Left")
#define RESOURCES_ROTATE_CCW_TOOLTIP _ ("Rotate the photos left")
#define RESOURCES_HFLIP_MENU _ ("Flip Hori_zontally")
#define RESOURCES_HFLIP_LABEL _ ("Flip Horizontally")
#define RESOURCES_VFLIP_MENU _ ("Flip Verti_cally")
#define RESOURCES_VFLIP_LABEL _ ("Flip Vertically")
#define RESOURCES_ABOUT_LABEL _ ("_About")
#define RESOURCES_APPLY_LABEL _ ("_Apply")
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_DELETE_LABEL _ ("_Delete")
#define RESOURCES_EDIT_LABEL _ ("_Edit")
#define RESOURCES_FORWARD_LABEL _ ("_Forward")
#define RESOURCES_FULLSCREEN_LABEL _ ("Fulls_creen")
#define RESOURCES_HELP_LABEL _ ("_Help")
#define RESOURCES_LEAVE_FULLSCREEN_LABEL _ ("Leave _Fullscreen")
#define RESOURCES_NEW_LABEL _ ("_New")
#define RESOURCES_NEXT_LABEL _ ("_Next")
#define RESOURCES_OK_LABEL _ ("_OK")
#define RESOURCES_PLAY_LABEL _ ("_Play")
#define RESOURCES_PREFERENCES_LABEL _ ("_Preferences")
#define RESOURCES_PREVIOUS_LABEL _ ("_Previous")
#define RESOURCES_PRINT_LABEL _ ("_Print")
#define RESOURCES_QUIT_LABEL _ ("_Quit")
#define RESOURCES_REFRESH_LABEL _ ("_Refresh")
#define RESOURCES_REMOVE_LABEL _ ("_Remove")
#define RESOURCES_REVERT_TO_SAVED_LABEL _ ("_Revert")
#define RESOURCES_SAVE_LABEL _ ("_Save")
#define RESOURCES_SAVE_AS_LABEL _ ("Save _As")
#define RESOURCES_SORT_ASCENDING_LABEL _ ("Sort _Ascending")
#define RESOURCES_SORT_DESCENDING_LABEL _ ("Sort _Descending")
#define RESOURCES_STOP_LABEL _ ("_Stop")
#define RESOURCES_UNDELETE_LABEL _ ("_Undelete")
#define RESOURCES_ZOOM_100_LABEL _ ("_Normal Size")
#define RESOURCES_ZOOM_FIT_LABEL _ ("Best _Fit")
#define RESOURCES_ZOOM_IN_LABEL _ ("Zoom _In")
#define RESOURCES_ZOOM_OUT_LABEL _ ("Zoom _Out")
#define RESOURCES_ENHANCE_MENU _ ("_Enhance")
#define RESOURCES_ENHANCE_LABEL _ ("Enhance")
#define RESOURCES_ENHANCE_TOOLTIP _ ("Automatically improve the photo’s appearance")
#define RESOURCES_COPY_ADJUSTMENTS_MENU _ ("_Copy Color Adjustments")
#define RESOURCES_COPY_ADJUSTMENTS_LABEL _ ("Copy Color Adjustments")
#define RESOURCES_COPY_ADJUSTMENTS_TOOLTIP _ ("Copy the color adjustments applied to the photo")
#define RESOURCES_PASTE_ADJUSTMENTS_MENU _ ("_Paste Color Adjustments")
#define RESOURCES_PASTE_ADJUSTMENTS_LABEL _ ("Paste Color Adjustments")
#define RESOURCES_PASTE_ADJUSTMENTS_TOOLTIP _ ("Apply copied color adjustments to the selected photos")
#define RESOURCES_CROP_MENU _ ("_Crop")
#define RESOURCES_CROP_LABEL _ ("Crop")
#define RESOURCES_CROP_TOOLTIP _ ("Crop the photo’s size")
#define RESOURCES_STRAIGHTEN_MENU _ ("_Straighten")
#define RESOURCES_STRAIGHTEN_LABEL _ ("Straighten")
#define RESOURCES_STRAIGHTEN_TOOLTIP _ ("Straighten the photo")
#define RESOURCES_RED_EYE_MENU _ ("_Red-eye")
#define RESOURCES_RED_EYE_LABEL _ ("Red-eye")
#define RESOURCES_RED_EYE_TOOLTIP _ ("Reduce or eliminate any red-eye effects in the photo")
#define RESOURCES_ADJUST_MENU _ ("_Adjust")
#define RESOURCES_ADJUST_LABEL _ ("Adjust")
#define RESOURCES_ADJUST_TOOLTIP _ ("Adjust the photo’s color and tone")
#define RESOURCES_REVERT_MENU _ ("Re_vert to Original")
#define RESOURCES_REVERT_LABEL _ ("Revert to Original")
#define RESOURCES_REVERT_EDITABLE_MENU _ ("Revert External E_dits")
#define RESOURCES_REVERT_EDITABLE_TOOLTIP _ ("Revert to the master photo")
#define RESOURCES_SET_BACKGROUND_MENU _ ("Set as _Desktop Background")
#define RESOURCES_SET_BACKGROUND_TOOLTIP _ ("Set selected image to be the new desktop background")
#define RESOURCES_SET_BACKGROUND_SLIDESHOW_MENU _ ("Set as _Desktop Slideshow…")
#define RESOURCES_UNDO_MENU _ ("_Undo")
#define RESOURCES_UNDO_LABEL _ ("Undo")
#define RESOURCES_REDO_MENU _ ("_Redo")
#define RESOURCES_REDO_LABEL _ ("Redo")
#define RESOURCES_RENAME_EVENT_MENU _ ("Re_name Event…")
#define RESOURCES_RENAME_EVENT_LABEL _ ("Rename Event")
#define RESOURCES_MAKE_KEY_PHOTO_MENU _ ("Make _Key Photo for Event")
#define RESOURCES_MAKE_KEY_PHOTO_LABEL _ ("Make Key Photo for Event")
#define RESOURCES_NEW_EVENT_MENU _ ("_New Event")
#define RESOURCES_NEW_EVENT_LABEL _ ("New Event")
#define RESOURCES_SET_PHOTO_EVENT_LABEL _ ("Move Photos")
#define RESOURCES_SET_PHOTO_EVENT_TOOLTIP _ ("Move photos to an event")
#define RESOURCES_MERGE_MENU _ ("_Merge Events")
#define RESOURCES_MERGE_LABEL _ ("Merge")
#define RESOURCES_MERGE_TOOLTIP _ ("Combine events into a single event")
#define RESOURCES_RATING_MENU _ ("_Set Rating")
#define RESOURCES_RATING_LABEL _ ("Set Rating")
#define RESOURCES_RATING_TOOLTIP _ ("Change the rating of your photo")
#define RESOURCES_INCREASE_RATING_MENU _ ("_Increase")
#define RESOURCES_INCREASE_RATING_LABEL _ ("Increase Rating")
#define RESOURCES_DECREASE_RATING_MENU _ ("_Decrease")
#define RESOURCES_DECREASE_RATING_LABEL _ ("Decrease Rating")
#define RESOURCES_RATE_UNRATED_MENU _ ("_Unrated")
#define RESOURCES_RATE_UNRATED_COMBO_BOX _ ("Unrated")
#define RESOURCES_RATE_UNRATED_LABEL _ ("Rate Unrated")
#define RESOURCES_RATE_UNRATED_PROGRESS _ ("Setting as unrated")
#define RESOURCES_RATE_UNRATED_TOOLTIP _ ("Remove any ratings")
#define RESOURCES_RATE_REJECTED_MENU _ ("_Rejected")
#define RESOURCES_RATE_REJECTED_COMBO_BOX _ ("Rejected")
#define RESOURCES_RATE_REJECTED_LABEL _ ("Rate Rejected")
#define RESOURCES_RATE_REJECTED_PROGRESS _ ("Setting as rejected")
#define RESOURCES_RATE_REJECTED_TOOLTIP _ ("Set rating to rejected")
#define RESOURCES_DISPLAY_REJECTED_ONLY_MENU _ ("Rejected _Only")
#define RESOURCES_DISPLAY_REJECTED_ONLY_LABEL _ ("Rejected Only")
#define RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP _ ("Show only rejected photos")
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_MENU _ ("All + _Rejected")
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP NC_ ("Tooltip", "Show all photos, including rejected")
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_MENU _ ("_All Photos")
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP _ ("Show all photos")
#define RESOURCES_VIEW_RATINGS_MENU _ ("_Ratings")
#define RESOURCES_VIEW_RATINGS_TOOLTIP _ ("Display each photo’s rating")
#define RESOURCES_FILTER_PHOTOS_MENU _ ("_Filter Photos")
#define RESOURCES_FILTER_PHOTOS_LABEL _ ("Filter Photos")
#define RESOURCES_FILTER_PHOTOS_TOOLTIP _ ("Limit the number of photos displayed based on a filter")
#define RESOURCES_DUPLICATE_PHOTO_MENU _ ("_Duplicate")
#define RESOURCES_DUPLICATE_PHOTO_LABEL _ ("Duplicate")
#define RESOURCES_DUPLICATE_PHOTO_TOOLTIP _ ("Make a duplicate of the photo")
#define RESOURCES_EXPORT_MENU _ ("_Export…")
#define RESOURCES_PRINT_MENU _ ("_Print…")
#define RESOURCES_PUBLISH_MENU _ ("Pu_blish…")
#define RESOURCES_PUBLISH_LABEL _ ("Publish")
#define RESOURCES_PUBLISH_TOOLTIP _ ("Publish to various websites")
#define RESOURCES_EDIT_TITLE_MENU _ ("Edit _Title…")
#define RESOURCES_EDIT_TITLE_LABEL NC_ ("Button Label", "Edit Title")
#define RESOURCES_EDIT_COMMENT_MENU _ ("Edit _Comment…")
#define RESOURCES_EDIT_COMMENT_LABEL _ ("Edit Comment")
#define RESOURCES_EDIT_EVENT_COMMENT_MENU _ ("Edit Event _Comment…")
#define RESOURCES_EDIT_EVENT_COMMENT_LABEL _ ("Edit Event Comment")
#define RESOURCES_ADJUST_DATE_TIME_MENU _ ("_Adjust Date and Time…")
#define RESOURCES_ADJUST_DATE_TIME_LABEL _ ("Adjust Date and Time")
#define RESOURCES_ADD_TAGS_MENU _ ("Add _Tags…")
#define RESOURCES_ADD_TAGS_CONTEXT_MENU _ ("_Add Tags…")
#define RESOURCES_ADD_TAGS_TITLE NC_ ("Dialog Title", "Add Tags")
#define RESOURCES_PREFERENCES_MENU _ ("_Preferences")
#define RESOURCES_EXTERNAL_EDIT_MENU _ ("Open With E_xternal Editor")
#define RESOURCES_EXTERNAL_EDIT_RAW_MENU _ ("Open With RA_W Editor")
#define RESOURCES_SEND_TO_MENU _ ("Send _To…")
#define RESOURCES_SEND_TO_CONTEXT_MENU _ ("Send T_o…")
#define RESOURCES_FIND_MENU _ ("_Find…")
#define RESOURCES_FIND_LABEL _ ("Find")
#define RESOURCES_FIND_TOOLTIP _ ("Find an image by typing text that appears in its name or tags")
#define RESOURCES_FLAG_MENU _ ("_Flag")
#define RESOURCES_UNFLAG_MENU _ ("Un_flag")
#define RESOURCES_FACES_MENU _ ("Faces")
#define RESOURCES_FACES_LABEL _ ("Faces")
#define RESOURCES_FACES_TOOLTIP _ ("Mark faces of people in the photo")
#define RESOURCES_MODIFY_FACES_LABEL _ ("Modify Faces")
#define RESOURCES_DELETE_FACE_TITLE _ ("Delete Face")
#define RESOURCES_DELETE_FACE_SIDEBAR_MENU _ ("_Delete")
#define RESOURCES_RENAME_FACE_SIDEBAR_MENU _ ("_Rename…")
#define RESOURCES_FACES_MENU_SECTION "FacesMenuPlaceholder"
#define RESOURCES_DELETE_TAG_TITLE _ ("Delete Tag")
#define RESOURCES_DELETE_TAG_SIDEBAR_MENU _ ("_Delete")
#define RESOURCES_NEW_CHILD_TAG_SIDEBAR_MENU _ ("_New")
#define RESOURCES_RENAME_TAG_SIDEBAR_MENU _ ("_Rename…")
#define RESOURCES_MODIFY_TAGS_MENU _ ("Modif_y Tags…")
#define RESOURCES_MODIFY_TAGS_LABEL _ ("Modify Tags")
#define RESOURCES_DEFAULT_SAVED_SEARCH_NAME _ ("Saved Search")
#define RESOURCES_DELETE_SAVED_SEARCH_DIALOG_TITLE _ ("Delete Search")
#define RESOURCES_DELETE_SEARCH_MENU _ ("_Delete")
#define RESOURCES_EDIT_SEARCH_MENU _ ("_Edit…")
#define RESOURCES_RENAME_SEARCH_MENU _ ("Re_name…")
#define RESOURCES_DELETE_PHOTOS_MENU _ ("_Delete")
#define RESOURCES_DELETE_FROM_TRASH_TOOLTIP _ ("Remove the selected photos from the trash")
#define RESOURCES_DELETE_FROM_LIBRARY_TOOLTIP _ ("Remove the selected photos from the library")
#define RESOURCES_RESTORE_PHOTOS_MENU _ ("_Restore")
#define RESOURCES_RESTORE_PHOTOS_TOOLTIP _ ("Move the selected photos back into the library")
#define RESOURCES_JUMP_TO_FILE_MENU _ ("Show in File Mana_ger")
#define RESOURCES_JUMP_TO_FILE_TOOLTIP _ ("Open the selected photo’s directory in the file manager")
#define RESOURCES_REMOVE_FROM_LIBRARY_MENU _ ("R_emove From Library")
#define RESOURCES_MOVE_TO_TRASH_MENU _ ("_Move to Trash")
#define RESOURCES_SELECT_ALL_MENU _ ("Select _All")
#define RESOURCES_SELECT_ALL_TOOLTIP _ ("Select all items")
#define RESOURCES_NONINTERPRETABLE_BADGE_FILE "noninterpretable-video.png"
#define RESOURCES_ALL_DATA -1
#define RESOURCES_ONIMAGE_FONT_COLOR "#000000"
#define RESOURCES_ONIMAGE_FONT_BACKGROUND "rgba(255,255,255,0.5)"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	RATING_FILTER_NO_FILTER = 0,
	RATING_FILTER_REJECTED_OR_HIGHER = 1,
	RATING_FILTER_UNRATED_OR_HIGHER = 2,
	RATING_FILTER_ONE_OR_HIGHER = 3,
	RATING_FILTER_TWO_OR_HIGHER = 4,
	RATING_FILTER_THREE_OR_HIGHER = 5,
	RATING_FILTER_FOUR_OR_HIGHER = 6,
	RATING_FILTER_FIVE_OR_HIGHER = 7,
	RATING_FILTER_REJECTED_ONLY = 8,
	RATING_FILTER_UNRATED_ONLY = 9,
	RATING_FILTER_ONE_ONLY = 10,
	RATING_FILTER_TWO_ONLY = 11,
	RATING_FILTER_THREE_ONLY = 12,
	RATING_FILTER_FOUR_ONLY = 13,
	RATING_FILTER_FIVE_ONLY = 14
} RatingFilter;

#define TYPE_RATING_FILTER (rating_filter_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())

VALA_EXTERN gchar* resources_RATE_ONE_LABEL;
VALA_EXTERN gchar* resources_RATE_TWO_LABEL;
VALA_EXTERN gchar* resources_RATE_THREE_LABEL;
VALA_EXTERN gchar* resources_RATE_FOUR_LABEL;
VALA_EXTERN gchar* resources_RATE_FIVE_LABEL;
VALA_EXTERN gchar* resources_RATE_ONE_MENU;
VALA_EXTERN gchar* resources_RATE_TWO_MENU;
VALA_EXTERN gchar* resources_RATE_THREE_MENU;
VALA_EXTERN gchar* resources_RATE_FOUR_MENU;
VALA_EXTERN gchar* resources_RATE_FIVE_MENU;
VALA_EXTERN gchar* resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
VALA_EXTERN gchar* resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
VALA_EXTERN gchar* resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
VALA_EXTERN gchar* resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
VALA_EXTERN gchar* resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
VALA_EXTERN gchar* resources_RATE_ONE_PROGRESS;
VALA_EXTERN gchar* resources_RATE_TWO_PROGRESS;
VALA_EXTERN gchar* resources_RATE_THREE_PROGRESS;
VALA_EXTERN gchar* resources_RATE_FOUR_PROGRESS;
VALA_EXTERN gchar* resources_RATE_FIVE_PROGRESS;
VALA_EXTERN GHashTable* resources_trinket_cache;
GHashTable* resources_trinket_cache = NULL;
VALA_EXTERN gchar* resources_RATE_ONE_TOOLTIP;
VALA_EXTERN gchar* resources_RATE_TWO_TOOLTIP;
VALA_EXTERN gchar* resources_RATE_THREE_TOOLTIP;
VALA_EXTERN gchar* resources_RATE_FOUR_TOOLTIP;
VALA_EXTERN gchar* resources_RATE_FIVE_TOOLTIP;
VALA_EXTERN gchar* resources_DISPLAY_ONE_OR_HIGHER_MENU;
VALA_EXTERN gchar* resources_DISPLAY_TWO_OR_HIGHER_MENU;
VALA_EXTERN gchar* resources_DISPLAY_THREE_OR_HIGHER_MENU;
VALA_EXTERN gchar* resources_DISPLAY_FOUR_OR_HIGHER_MENU;
VALA_EXTERN gchar* resources_DISPLAY_FIVE_OR_HIGHER_MENU;
VALA_EXTERN gchar* resources_DISPLAY_ONE_OR_HIGHER_LABEL;
VALA_EXTERN gchar* resources_DISPLAY_TWO_OR_HIGHER_LABEL;
VALA_EXTERN gchar* resources_DISPLAY_THREE_OR_HIGHER_LABEL;
VALA_EXTERN gchar* resources_DISPLAY_FOUR_OR_HIGHER_LABEL;
VALA_EXTERN gchar* resources_DISPLAY_FIVE_OR_HIGHER_LABEL;
gchar* resources_RATE_ONE_MENU = NULL;
gchar* resources_RATE_ONE_LABEL = NULL;
gchar* resources_RATE_ONE_TOOLTIP = NULL;
gchar* resources_RATE_ONE_PROGRESS = NULL;
gchar* resources_RATE_TWO_MENU = NULL;
gchar* resources_RATE_TWO_LABEL = NULL;
gchar* resources_RATE_TWO_TOOLTIP = NULL;
gchar* resources_RATE_TWO_PROGRESS = NULL;
gchar* resources_RATE_THREE_MENU = NULL;
gchar* resources_RATE_THREE_LABEL = NULL;
gchar* resources_RATE_THREE_TOOLTIP = NULL;
gchar* resources_RATE_THREE_PROGRESS = NULL;
gchar* resources_RATE_FOUR_MENU = NULL;
gchar* resources_RATE_FOUR_LABEL = NULL;
gchar* resources_RATE_FOUR_TOOLTIP = NULL;
gchar* resources_RATE_FOUR_PROGRESS = NULL;
gchar* resources_RATE_FIVE_MENU = NULL;
gchar* resources_RATE_FIVE_LABEL = NULL;
gchar* resources_RATE_FIVE_TOOLTIP = NULL;
gchar* resources_RATE_FIVE_PROGRESS = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP = NULL;
VALA_EXTERN GeeHashMap* resources_icon_cache;
GeeHashMap* resources_icon_cache = NULL;
VALA_EXTERN GeeHashMap* resources_scaled_icon_cache;
GeeHashMap* resources_scaled_icon_cache = NULL;
VALA_EXTERN gchar* resources_HH_MM_FORMAT_STRING;
gchar* resources_HH_MM_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_HH_MM_SS_FORMAT_STRING;
gchar* resources_HH_MM_SS_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_LONG_DATE_FORMAT_STRING;
gchar* resources_LONG_DATE_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_START_MULTIDAY_DATE_FORMAT_STRING;
gchar* resources_START_MULTIDAY_DATE_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_END_MULTIDAY_DATE_FORMAT_STRING;
gchar* resources_END_MULTIDAY_DATE_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_START_MULTIMONTH_DATE_FORMAT_STRING;
gchar* resources_START_MULTIMONTH_DATE_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_END_MULTIMONTH_DATE_FORMAT_STRING;
gchar* resources_END_MULTIMONTH_DATE_FORMAT_STRING = NULL;
VALA_EXTERN gchar* resources_lc_measurement;
gchar* resources_lc_measurement = NULL;
VALA_EXTERN ResourcesUnitSystem resources_unit_system;
ResourcesUnitSystem resources_unit_system = RESOURCES_UNIT_SYSTEM_UNKNOWN;
VALA_EXTERN GdkPixbuf* resources_noninterpretable_badge_pixbuf;
GdkPixbuf* resources_noninterpretable_badge_pixbuf = NULL;

VALA_EXTERN gchar* resources_launch_editor_failed (GError* err);
VALA_EXTERN gchar* resources_add_tags_label (gchar** names,
                                 gint names_length1);
VALA_EXTERN gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
VALA_EXTERN gchar* resources_delete_tag_menu (const gchar* name);
VALA_EXTERN gchar* resources_delete_tag_label (const gchar* name);
VALA_EXTERN gchar* resources_rename_tag_menu (const gchar* name);
VALA_EXTERN gchar* resources_rename_tag_label (const gchar* old_name,
                                   const gchar* new_name);
VALA_EXTERN gchar* resources_tag_photos_label (const gchar* name,
                                   gint count);
VALA_EXTERN gchar* resources_tag_photos_tooltip (const gchar* name,
                                     gint count);
VALA_EXTERN gchar* resources_untag_photos_menu (const gchar* name,
                                    gint count);
VALA_EXTERN gchar* resources_untag_photos_label (const gchar* name,
                                     gint count);
VALA_EXTERN gchar* resources_rename_tag_exists_message (const gchar* name);
VALA_EXTERN gchar* resources_rename_search_exists_message (const gchar* name);
VALA_EXTERN gchar* resources_rename_search_label (const gchar* old_name,
                                      const gchar* new_name);
VALA_EXTERN gchar* resources_delete_search_label (const gchar* name);
VALA_EXTERN gchar* resources_rename_face_exists_message (const gchar* name);
VALA_EXTERN gchar* resources_remove_face_from_photos_menu (const gchar* name,
                                               gint count);
VALA_EXTERN gchar* resources_remove_face_from_photos_label (const gchar* name,
                                                gint count);
VALA_EXTERN gchar* resources_set_face_from_photo_menu (const gchar* name);
VALA_EXTERN gchar* resources_set_face_from_photo_label (const gchar* name);
VALA_EXTERN gchar* resources_set_face_from_photo_error (void);
VALA_EXTERN gchar* resources_rename_face_menu (const gchar* name);
VALA_EXTERN gchar* resources_rename_face_label (const gchar* old_name,
                                    const gchar* new_name);
VALA_EXTERN gchar* resources_delete_face_menu (const gchar* name);
VALA_EXTERN gchar* resources_delete_face_label (const gchar* name);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* resources_rating_label (Rating rating);
VALA_EXTERN const gchar* resources_rating_combo_box (Rating rating);
VALA_EXTERN GType rating_filter_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* resources_get_rating_filter_tooltip (RatingFilter filter);
VALA_EXTERN gchar* resources_rating_progress (Rating rating);
VALA_EXTERN gchar* resources_get_stars (Rating rating);
VALA_EXTERN GdkPixbuf* resources_get_cached_trinket (gint key);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GdkPixbuf* resources_get_video_trinket (gint scale);
static gint* _int_dup (gint* self);
VALA_EXTERN GdkPixbuf* resources_get_flagged_trinket (gint scale);
VALA_EXTERN GdkPixbuf* resources_get_rating_trinket (Rating rating,
                                         gint scale);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void resources_generate_rating_strings (void);
VALA_EXTERN gchar* resources_jump_to_file_failed (GError* err);
VALA_EXTERN void resources_init (void);
VALA_EXTERN void resources_init_icon_theme_engine (void);
VALA_EXTERN void resources_init_css_provider (void);
VALA_EXTERN void resources_terminate (void);
VALA_EXTERN void resources_fetch_lc_time_format (void);
VALA_EXTERN GType resources_unit_system_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ResourcesUnitSystem resources_get_default_measurement_unit (void);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
VALA_EXTERN gchar* resources_get_hh_mm_format_string (void);
VALA_EXTERN gchar* resources_get_hh_mm_ss_format_string (void);
VALA_EXTERN gchar* resources_get_long_date_format_string (void);
VALA_EXTERN gchar* resources_get_start_multiday_span_format_string (void);
VALA_EXTERN gchar* resources_get_end_multiday_span_format_string (void);
VALA_EXTERN gchar* resources_get_start_multimonth_span_format_string (void);
VALA_EXTERN gchar* resources_get_end_multimonth_span_format_string (void);
VALA_EXTERN gchar* resources_get_ui (const gchar* filename);
VALA_EXTERN GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
VALA_EXTERN GdkPixbuf* resources_get_icon (const gchar* name,
                               gint scale);
VALA_EXTERN GdkPixbuf* resources_load_icon (const gchar* name,
                                gint scale);
VALA_EXTERN GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
VALA_EXTERN gchar* resources_get_help_path (void);
VALA_EXTERN GFile* app_dirs_get_exec_dir (void);
VALA_EXTERN void resources_launch_help (GtkWindow* window,
                            const gchar* anchor,
                            GError** error);
VALA_EXTERN gint resources_use_header_bar (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* RESOURCES_AUTHORS[6] = {"Jim Nelson <jim@yorba.org>", "Lucas Beeler <lucas@yorba.org>", "Allison Barlow <allison@yorba.org>", "Eric Gregory <eric@yorba.org>", "Clinton Rogers <clinton@yorba.org>", NULL};
const gint RESOURCES_rating_thresholds[6] = {0, 1, 25, 50, 75, 99};
const gchar* RESOURCES_IMPERIAL_COUNTRIES[4] = {"unm_US", "es_US", "en_US", "yi_US"};

gchar*
resources_launch_editor_failed (GError* err)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (err != NULL, NULL);
	_tmp0_ = err->message;
	_tmp1_ = g_strdup_printf (_ ("Unable to launch editor: %s"), _tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
resources_add_tags_label (gchar** names,
                          gint names_length1)
{
	gchar* result;
	if (names_length1 == 1) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = names[0];
		_tmp1_ = hierarchical_tag_utilities_get_basename (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf (_ ("Add Tag “%s”"), _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	} else {
		if (names_length1 == 2) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = names[0];
			_tmp6_ = hierarchical_tag_utilities_get_basename (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = names[1];
			_tmp9_ = hierarchical_tag_utilities_get_basename (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf (_ ("Add Tags “%s” and “%s”"), _tmp7_, _tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			_g_free0 (_tmp7_);
			result = _tmp12_;
			return result;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup (C_ ("UndoRedo menu entry", "Add Tags"));
			result = _tmp13_;
			return result;
		}
	}
}

gchar*
resources_delete_tag_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("_Delete Tag “%s”"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_tag_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Delete Tag “%s”"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Re_name Tag “%s”…"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_label (const gchar* old_name,
                            const gchar* new_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (old_name != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Rename Tag “%s” to “%s”"), old_name, new_name);
	result = _tmp0_;
	return result;
}

gchar*
resources_tag_photos_label (const gchar* name,
                            gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Tag Photo as “%s”", "Tag Photos as “%s”", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_tag_photos_tooltip (const gchar* name,
                              gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Tag the selected photo as “%s”", "Tag the selected photos as “%s”", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_untag_photos_menu (const gchar* name,
                             gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Tag “%s” From _Photo", "Remove Tag “%s” From _Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_untag_photos_label (const gchar* name,
                              gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Tag “%s” From Photo", "Remove Tag “%s” From Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_exists_message (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Unable to rename tag to “%s” because the tag already exists."), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_search_exists_message (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Unable to rename search to “%s” because the search already exists."), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_search_label (const gchar* old_name,
                               const gchar* new_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (old_name != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Rename Search “%s” to “%s”"), old_name, new_name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_search_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Delete Search “%s”"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_face_exists_message (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Unable to rename face to “%s” because the face already exists."), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_remove_face_from_photos_menu (const gchar* name,
                                        gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Face “%s” From _Photo", "Remove Face “%s” From _Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_remove_face_from_photos_label (const gchar* name,
                                         gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Face “%s” From Photo", "Remove Face “%s” From Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_set_face_from_photo_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("_Train Face “%s” From Photo"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_set_face_from_photo_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("_Train Face “%s” From Photo"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_set_face_from_photo_error (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("Unable to set face as reference");
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_face_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Re_name Face “%s”…"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_face_label (const gchar* old_name,
                             const gchar* new_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (old_name != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Rename Face “%s” to “%s”"), old_name, new_name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_face_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("_Delete Face “%s”"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_face_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Delete Face “%s”"), name);
	result = _tmp0_;
	return result;
}

const gchar*
resources_rating_label (Rating rating)
{
	const gchar* result;
	switch (rating) {
		case RATING_REJECTED:
		{
			result = RESOURCES_RATE_REJECTED_LABEL;
			return result;
		}
		case RATING_UNRATED:
		{
			result = RESOURCES_RATE_UNRATED_LABEL;
			return result;
		}
		case RATING_ONE:
		{
			const gchar* _tmp0_;
			_tmp0_ = resources_RATE_ONE_LABEL;
			result = _tmp0_;
			return result;
		}
		case RATING_TWO:
		{
			const gchar* _tmp1_;
			_tmp1_ = resources_RATE_TWO_LABEL;
			result = _tmp1_;
			return result;
		}
		case RATING_THREE:
		{
			const gchar* _tmp2_;
			_tmp2_ = resources_RATE_THREE_LABEL;
			result = _tmp2_;
			return result;
		}
		case RATING_FOUR:
		{
			const gchar* _tmp3_;
			_tmp3_ = resources_RATE_FOUR_LABEL;
			result = _tmp3_;
			return result;
		}
		case RATING_FIVE:
		{
			const gchar* _tmp4_;
			_tmp4_ = resources_RATE_FIVE_LABEL;
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = RESOURCES_RATE_UNRATED_LABEL;
			return result;
		}
	}
}

const gchar*
resources_rating_combo_box (Rating rating)
{
	const gchar* result;
	switch (rating) {
		case RATING_REJECTED:
		{
			result = RESOURCES_RATE_REJECTED_COMBO_BOX;
			return result;
		}
		case RATING_UNRATED:
		{
			result = RESOURCES_RATE_UNRATED_COMBO_BOX;
			return result;
		}
		case RATING_ONE:
		{
			const gchar* _tmp0_;
			_tmp0_ = resources_RATE_ONE_MENU;
			result = _tmp0_;
			return result;
		}
		case RATING_TWO:
		{
			const gchar* _tmp1_;
			_tmp1_ = resources_RATE_TWO_MENU;
			result = _tmp1_;
			return result;
		}
		case RATING_THREE:
		{
			const gchar* _tmp2_;
			_tmp2_ = resources_RATE_THREE_MENU;
			result = _tmp2_;
			return result;
		}
		case RATING_FOUR:
		{
			const gchar* _tmp3_;
			_tmp3_ = resources_RATE_FOUR_MENU;
			result = _tmp3_;
			return result;
		}
		case RATING_FIVE:
		{
			const gchar* _tmp4_;
			_tmp4_ = resources_RATE_FIVE_MENU;
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = RESOURCES_RATE_UNRATED_MENU;
			return result;
		}
	}
}

gchar*
resources_get_rating_filter_tooltip (RatingFilter filter)
{
	gchar* result;
	switch (filter) {
		case RATING_FILTER_REJECTED_OR_HIGHER:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP);
			result = _tmp0_;
			return result;
		}
		case RATING_FILTER_ONE_OR_HIGHER:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case RATING_FILTER_TWO_OR_HIGHER:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case RATING_FILTER_THREE_OR_HIGHER:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case RATING_FILTER_FOUR_OR_HIGHER:
		{
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case RATING_FILTER_FIVE_ONLY:
		case RATING_FILTER_FIVE_OR_HIGHER:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case RATING_FILTER_REJECTED_ONLY:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP);
			result = _tmp11_;
			return result;
		}
		default:
		case RATING_FILTER_UNRATED_OR_HIGHER:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP);
			result = _tmp12_;
			return result;
		}
	}
}

gchar*
resources_rating_progress (Rating rating)
{
	gchar* result;
	switch (rating) {
		case RATING_REJECTED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (RESOURCES_RATE_REJECTED_PROGRESS);
			result = _tmp0_;
			return result;
		}
		case RATING_UNRATED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (RESOURCES_RATE_UNRATED_PROGRESS);
			result = _tmp1_;
			return result;
		}
		case RATING_ONE:
		{
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = resources_RATE_ONE_PROGRESS;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case RATING_TWO:
		{
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = resources_RATE_TWO_PROGRESS;
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case RATING_THREE:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = resources_RATE_THREE_PROGRESS;
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case RATING_FOUR:
		{
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = resources_RATE_FOUR_PROGRESS;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case RATING_FIVE:
		{
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = resources_RATE_FIVE_PROGRESS;
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		default:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (RESOURCES_RATE_UNRATED_PROGRESS);
			result = _tmp12_;
			return result;
		}
	}
}

gchar*
resources_get_stars (Rating rating)
{
	gchar* result;
	switch (rating) {
		case RATING_REJECTED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("\xE2\x9D\x8C");
			result = _tmp0_;
			return result;
		}
		case RATING_ONE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("\xE2\x98\x85");
			result = _tmp1_;
			return result;
		}
		case RATING_TWO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85");
			result = _tmp2_;
			return result;
		}
		case RATING_THREE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
			result = _tmp3_;
			return result;
		}
		case RATING_FOUR:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
			result = _tmp4_;
			return result;
		}
		case RATING_FIVE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			result = _tmp6_;
			return result;
		}
	}
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
resources_get_cached_trinket (gint key)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	GdkPixbuf* result;
	_tmp0_ = resources_trinket_cache;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_int_hash;
		_tmp2_ = g_int_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (resources_trinket_cache);
		resources_trinket_cache = _tmp3_;
	}
	_tmp4_ = resources_trinket_cache;
	_tmp5_ = g_hash_table_lookup (_tmp4_, &key);
	if (((GdkPixbuf*) _tmp5_) != NULL) {
		GHashTable* _tmp6_;
		gconstpointer _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp6_ = resources_trinket_cache;
		_tmp7_ = g_hash_table_lookup (_tmp6_, &key);
		_tmp8_ = _g_object_ref0 ((GdkPixbuf*) _tmp7_);
		result = _tmp8_;
		return result;
	}
	result = NULL;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

GdkPixbuf*
resources_get_video_trinket (gint scale)
{
	gint cache_key = 0;
	GdkPixbuf* cached_pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	cache_key = scale << 18;
	_tmp0_ = resources_get_cached_trinket (cache_key);
	cached_pixbuf = _tmp0_;
	_tmp1_ = cached_pixbuf;
	if (_tmp1_ != NULL) {
		result = cached_pixbuf;
		return result;
	}
	{
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp2_;
		GtkIconTheme* _tmp3_;
		GtkIconInfo* info = NULL;
		GtkIconTheme* _tmp4_;
		GtkIconInfo* _tmp5_;
		GdkPixbuf* icon = NULL;
		GtkIconInfo* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		GdkPixbuf* _tmp8_;
		cairo_surface_t* surface = NULL;
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkPixbuf* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		cairo_surface_t* _tmp15_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp16_;
		cairo_t* _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* _tmp19_;
		GdkPixbuf* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		cairo_t* _tmp26_;
		cairo_t* _tmp27_;
		GdkPixbuf* _tmp28_;
		cairo_t* _tmp29_;
		GHashTable* _tmp30_;
		gint* _tmp31_;
		cairo_surface_t* _tmp32_;
		GdkPixbuf* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		GdkPixbuf* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		GdkPixbuf* _tmp39_;
		GHashTable* _tmp40_;
		gconstpointer _tmp41_;
		GdkPixbuf* _tmp42_;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		theme = _tmp3_;
		_tmp4_ = theme;
		_tmp5_ = gtk_icon_theme_lookup_icon (_tmp4_, "filter-videos-symbolic", (gint) (scale * 2), GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		info = _tmp5_;
		_tmp6_ = info;
		_tmp7_.red = 0.8;
		_tmp7_.green = 0.8;
		_tmp7_.blue = 0.8;
		_tmp7_.alpha = 1.0;
		_tmp8_ = gtk_icon_info_load_symbolic (_tmp6_, &_tmp7_, NULL, NULL, NULL, NULL, &_inner_error0_);
		icon = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (theme);
			goto __catch0_g_error;
		}
		_tmp9_ = icon;
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = icon;
		_tmp13_ = gdk_pixbuf_get_height (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp11_, _tmp14_);
		surface = _tmp15_;
		_tmp16_ = surface;
		_tmp17_ = cairo_create (_tmp16_);
		ctx = _tmp17_;
		_tmp18_ = ctx;
		cairo_set_source_rgba (_tmp18_, 0.0, 0.0, 0.0, 0.35);
		_tmp19_ = ctx;
		_tmp20_ = icon;
		_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = icon;
		_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
		_tmp25_ = _tmp24_;
		cairo_rectangle (_tmp19_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp22_, (gdouble) _tmp25_);
		_tmp26_ = ctx;
		cairo_fill (_tmp26_);
		_tmp27_ = ctx;
		_tmp28_ = icon;
		gdk_cairo_set_source_pixbuf (_tmp27_, _tmp28_, (gdouble) 0, (gdouble) 0);
		_tmp29_ = ctx;
		cairo_paint (_tmp29_);
		_tmp30_ = resources_trinket_cache;
		_tmp31_ = __int_dup0 (&cache_key);
		_tmp32_ = surface;
		_tmp33_ = icon;
		_tmp34_ = gdk_pixbuf_get_width (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = icon;
		_tmp37_ = gdk_pixbuf_get_height (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = gdk_pixbuf_get_from_surface (_tmp32_, 0, 0, _tmp35_, _tmp38_);
		g_hash_table_insert (_tmp30_, _tmp31_, _tmp39_);
		_tmp40_ = resources_trinket_cache;
		_tmp41_ = g_hash_table_lookup (_tmp40_, &cache_key);
		_tmp42_ = _g_object_ref0 ((GdkPixbuf*) _tmp41_);
		result = _tmp42_;
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
		_g_object_unref0 (icon);
		_g_object_unref0 (info);
		_g_object_unref0 (theme);
		_g_object_unref0 (cached_pixbuf);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = err;
		_tmp44_ = _tmp43_->message;
		g_critical ("Resources.vala:595: %s", _tmp44_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (cached_pixbuf);
		return result;
	}
	__finally0:
	_g_object_unref0 (cached_pixbuf);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GdkPixbuf*
resources_get_flagged_trinket (gint scale)
{
	gint cache_key = 0;
	GdkPixbuf* cached_pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	cache_key = scale << 16;
	_tmp0_ = resources_get_cached_trinket (cache_key);
	cached_pixbuf = _tmp0_;
	_tmp1_ = cached_pixbuf;
	if (_tmp1_ != NULL) {
		result = cached_pixbuf;
		return result;
	}
	{
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp2_;
		GtkIconTheme* _tmp3_;
		GtkIconInfo* info = NULL;
		GtkIconTheme* _tmp4_;
		GtkIconInfo* _tmp5_;
		GdkPixbuf* icon = NULL;
		GtkIconInfo* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		GdkPixbuf* _tmp8_;
		cairo_surface_t* surface = NULL;
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkPixbuf* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		cairo_surface_t* _tmp15_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp16_;
		cairo_t* _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* _tmp19_;
		GdkPixbuf* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		cairo_t* _tmp26_;
		cairo_t* _tmp27_;
		GdkPixbuf* _tmp28_;
		cairo_t* _tmp29_;
		GHashTable* _tmp30_;
		gint* _tmp31_;
		cairo_surface_t* _tmp32_;
		GdkPixbuf* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		GdkPixbuf* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		GdkPixbuf* _tmp39_;
		GHashTable* _tmp40_;
		gconstpointer _tmp41_;
		GdkPixbuf* _tmp42_;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		theme = _tmp3_;
		_tmp4_ = theme;
		_tmp5_ = gtk_icon_theme_lookup_icon (_tmp4_, "filter-flagged-symbolic", (gint) (scale * 1.33), GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		info = _tmp5_;
		_tmp6_ = info;
		_tmp7_.red = 0.8;
		_tmp7_.green = 0.8;
		_tmp7_.blue = 0.8;
		_tmp7_.alpha = 1.0;
		_tmp8_ = gtk_icon_info_load_symbolic (_tmp6_, &_tmp7_, NULL, NULL, NULL, NULL, &_inner_error0_);
		icon = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (theme);
			goto __catch0_g_error;
		}
		_tmp9_ = icon;
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = icon;
		_tmp13_ = gdk_pixbuf_get_height (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp11_, _tmp14_);
		surface = _tmp15_;
		_tmp16_ = surface;
		_tmp17_ = cairo_create (_tmp16_);
		ctx = _tmp17_;
		_tmp18_ = ctx;
		cairo_set_source_rgba (_tmp18_, 0.0, 0.0, 0.0, 0.35);
		_tmp19_ = ctx;
		_tmp20_ = icon;
		_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = icon;
		_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
		_tmp25_ = _tmp24_;
		cairo_rectangle (_tmp19_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp22_, (gdouble) _tmp25_);
		_tmp26_ = ctx;
		cairo_fill (_tmp26_);
		_tmp27_ = ctx;
		_tmp28_ = icon;
		gdk_cairo_set_source_pixbuf (_tmp27_, _tmp28_, (gdouble) 0, (gdouble) 0);
		_tmp29_ = ctx;
		cairo_paint (_tmp29_);
		_tmp30_ = resources_trinket_cache;
		_tmp31_ = __int_dup0 (&cache_key);
		_tmp32_ = surface;
		_tmp33_ = icon;
		_tmp34_ = gdk_pixbuf_get_width (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = icon;
		_tmp37_ = gdk_pixbuf_get_height (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = gdk_pixbuf_get_from_surface (_tmp32_, 0, 0, _tmp35_, _tmp38_);
		g_hash_table_insert (_tmp30_, _tmp31_, _tmp39_);
		_tmp40_ = resources_trinket_cache;
		_tmp41_ = g_hash_table_lookup (_tmp40_, &cache_key);
		_tmp42_ = _g_object_ref0 ((GdkPixbuf*) _tmp41_);
		result = _tmp42_;
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
		_g_object_unref0 (icon);
		_g_object_unref0 (info);
		_g_object_unref0 (theme);
		_g_object_unref0 (cached_pixbuf);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = err;
		_tmp44_ = _tmp43_->message;
		g_critical ("Resources.vala:623: %s", _tmp44_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (cached_pixbuf);
		return result;
	}
	__finally0:
	_g_object_unref0 (cached_pixbuf);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GdkPixbuf*
resources_get_rating_trinket (Rating rating,
                              gint scale)
{
	gint rating_key = 0;
	GdkPixbuf* cached_pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	PangoLayout* layout = NULL;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PangoLayout* _tmp6_;
	PangoLayout* _tmp7_;
	PangoAttrList* att = NULL;
	PangoAttrList* _tmp8_;
	PangoAttribute* a = NULL;
	PangoAttribute* _tmp9_;
	PangoAttrList* _tmp10_;
	PangoAttribute* _tmp11_;
	PangoAttribute* _tmp12_;
	PangoLayout* _tmp13_;
	PangoAttrList* _tmp14_;
	gint width = 0;
	gint height = 0;
	PangoLayout* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp18_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	PangoLayout* _tmp28_;
	cairo_surface_t* _tmp29_;
	GdkPixbuf* _tmp30_;
	GHashTable* _tmp31_;
	gint* _tmp32_;
	GdkPixbuf* _tmp33_;
	GdkPixbuf* _tmp34_;
	GdkPixbuf* result;
	if (rating == RATING_UNRATED) {
		result = NULL;
		return result;
	}
	rating_key = (gint) ((rating << 8) + scale);
	_tmp0_ = resources_get_cached_trinket (rating_key);
	cached_pixbuf = _tmp0_;
	_tmp1_ = cached_pixbuf;
	if (_tmp1_ != NULL) {
		result = cached_pixbuf;
		return result;
	}
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = resources_get_stars (rating);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	layout = _tmp7_;
	_tmp8_ = pango_attr_list_new ();
	att = _tmp8_;
	_tmp9_ = pango_attr_scale_new (((gdouble) scale) / 12.0);
	a = _tmp9_;
	_tmp10_ = att;
	_tmp11_ = a;
	_tmp12_ = pango_attribute_copy (_tmp11_);
	pango_attr_list_insert (_tmp10_, _tmp12_);
	_tmp13_ = layout;
	_tmp14_ = att;
	pango_layout_set_attributes (_tmp13_, _tmp14_);
	_tmp15_ = layout;
	pango_layout_get_pixel_size (_tmp15_, &_tmp16_, &_tmp17_);
	width = _tmp16_;
	height = _tmp17_;
	_tmp18_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	surface = _tmp18_;
	_tmp19_ = surface;
	_tmp20_ = cairo_create (_tmp19_);
	ctx = _tmp20_;
	_tmp21_ = ctx;
	cairo_set_source_rgba (_tmp21_, 0.0, 0.0, 0.0, 0.35);
	_tmp22_ = ctx;
	cairo_rectangle (_tmp22_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	_tmp23_ = ctx;
	cairo_fill (_tmp23_);
	if (rating == RATING_REJECTED) {
		cairo_t* _tmp24_;
		_tmp24_ = ctx;
		cairo_set_source_rgba (_tmp24_, 0.8, 0.0, 0.0, 1.0);
	} else {
		cairo_t* _tmp25_;
		_tmp25_ = ctx;
		cairo_set_source_rgba (_tmp25_, 0.8, 0.8, 0.8, 1.0);
	}
	_tmp26_ = ctx;
	cairo_move_to (_tmp26_, (gdouble) 0, (gdouble) 0);
	_tmp27_ = ctx;
	_tmp28_ = layout;
	pango_cairo_show_layout (_tmp27_, _tmp28_);
	_tmp29_ = surface;
	_tmp30_ = gdk_pixbuf_get_from_surface (_tmp29_, 0, 0, width, height);
	_g_object_unref0 (cached_pixbuf);
	cached_pixbuf = _tmp30_;
	_tmp31_ = resources_trinket_cache;
	_tmp32_ = __int_dup0 (&rating_key);
	_tmp33_ = cached_pixbuf;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	g_hash_table_insert (_tmp31_, _tmp32_, _tmp34_);
	result = cached_pixbuf;
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (a);
	_pango_attr_list_unref0 (att);
	_g_object_unref0 (layout);
	return result;
}

void
resources_generate_rating_strings (void)
{
	gchar* menu_base = NULL;
	gchar* _tmp0_;
	gchar* label_base = NULL;
	gchar* _tmp1_;
	gchar* tooltip_base = NULL;
	gchar* _tmp2_;
	gchar* progress_base = NULL;
	gchar* _tmp3_;
	gchar* display_rating_menu_base = NULL;
	gchar* _tmp4_;
	gchar* display_rating_label_base = NULL;
	gchar* _tmp5_;
	gchar* display_rating_tooltip_base = NULL;
	gchar* _tmp6_;
	gchar* display_rating_or_higher_menu_base = NULL;
	gchar* _tmp7_;
	gchar* display_rating_or_higher_label_base = NULL;
	gchar* _tmp8_;
	gchar* display_rating_or_higher_tooltip_base = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	_tmp0_ = g_strdup ("%s");
	menu_base = _tmp0_;
	_tmp1_ = g_strdup (_ ("Rate %s"));
	label_base = _tmp1_;
	_tmp2_ = g_strdup (_ ("Set rating to %s"));
	tooltip_base = _tmp2_;
	_tmp3_ = g_strdup (_ ("Setting rating to %s"));
	progress_base = _tmp3_;
	_tmp4_ = g_strdup ("%s");
	display_rating_menu_base = _tmp4_;
	_tmp5_ = g_strdup (_ ("Display %s"));
	display_rating_label_base = _tmp5_;
	_tmp6_ = g_strdup (_ ("Only show photos with a rating of %s"));
	display_rating_tooltip_base = _tmp6_;
	_tmp7_ = g_strdup (_ ("%s or Better"));
	display_rating_or_higher_menu_base = _tmp7_;
	_tmp8_ = g_strdup (_ ("Display %s or Better"));
	display_rating_or_higher_label_base = _tmp8_;
	_tmp9_ = g_strdup (_ ("Only show photos with a rating of %s or better"));
	display_rating_or_higher_tooltip_base = _tmp9_;
	_tmp10_ = resources_get_stars (RATING_ONE);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (menu_base, _tmp11_);
	_g_free0 (resources_RATE_ONE_MENU);
	resources_RATE_ONE_MENU = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = resources_get_stars (RATING_TWO);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf (menu_base, _tmp14_);
	_g_free0 (resources_RATE_TWO_MENU);
	resources_RATE_TWO_MENU = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = resources_get_stars (RATING_THREE);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (menu_base, _tmp17_);
	_g_free0 (resources_RATE_THREE_MENU);
	resources_RATE_THREE_MENU = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = resources_get_stars (RATING_FOUR);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf (menu_base, _tmp20_);
	_g_free0 (resources_RATE_FOUR_MENU);
	resources_RATE_FOUR_MENU = _tmp21_;
	_g_free0 (_tmp20_);
	_tmp22_ = resources_get_stars (RATING_FIVE);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf (menu_base, _tmp23_);
	_g_free0 (resources_RATE_FIVE_MENU);
	resources_RATE_FIVE_MENU = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = resources_get_stars (RATING_ONE);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup_printf (label_base, _tmp26_);
	_g_free0 (resources_RATE_ONE_LABEL);
	resources_RATE_ONE_LABEL = _tmp27_;
	_g_free0 (_tmp26_);
	_tmp28_ = resources_get_stars (RATING_TWO);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf (label_base, _tmp29_);
	_g_free0 (resources_RATE_TWO_LABEL);
	resources_RATE_TWO_LABEL = _tmp30_;
	_g_free0 (_tmp29_);
	_tmp31_ = resources_get_stars (RATING_THREE);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf (label_base, _tmp32_);
	_g_free0 (resources_RATE_THREE_LABEL);
	resources_RATE_THREE_LABEL = _tmp33_;
	_g_free0 (_tmp32_);
	_tmp34_ = resources_get_stars (RATING_FOUR);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup_printf (label_base, _tmp35_);
	_g_free0 (resources_RATE_FOUR_LABEL);
	resources_RATE_FOUR_LABEL = _tmp36_;
	_g_free0 (_tmp35_);
	_tmp37_ = resources_get_stars (RATING_FIVE);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf (label_base, _tmp38_);
	_g_free0 (resources_RATE_FIVE_LABEL);
	resources_RATE_FIVE_LABEL = _tmp39_;
	_g_free0 (_tmp38_);
	_tmp40_ = resources_get_stars (RATING_ONE);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf (tooltip_base, _tmp41_);
	_g_free0 (resources_RATE_ONE_TOOLTIP);
	resources_RATE_ONE_TOOLTIP = _tmp42_;
	_g_free0 (_tmp41_);
	_tmp43_ = resources_get_stars (RATING_TWO);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strdup_printf (tooltip_base, _tmp44_);
	_g_free0 (resources_RATE_TWO_TOOLTIP);
	resources_RATE_TWO_TOOLTIP = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp46_ = resources_get_stars (RATING_THREE);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strdup_printf (tooltip_base, _tmp47_);
	_g_free0 (resources_RATE_THREE_TOOLTIP);
	resources_RATE_THREE_TOOLTIP = _tmp48_;
	_g_free0 (_tmp47_);
	_tmp49_ = resources_get_stars (RATING_FOUR);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf (tooltip_base, _tmp50_);
	_g_free0 (resources_RATE_FOUR_TOOLTIP);
	resources_RATE_FOUR_TOOLTIP = _tmp51_;
	_g_free0 (_tmp50_);
	_tmp52_ = resources_get_stars (RATING_FIVE);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_strdup_printf (tooltip_base, _tmp53_);
	_g_free0 (resources_RATE_FIVE_TOOLTIP);
	resources_RATE_FIVE_TOOLTIP = _tmp54_;
	_g_free0 (_tmp53_);
	_tmp55_ = resources_get_stars (RATING_ONE);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strdup_printf (progress_base, _tmp56_);
	_g_free0 (resources_RATE_ONE_PROGRESS);
	resources_RATE_ONE_PROGRESS = _tmp57_;
	_g_free0 (_tmp56_);
	_tmp58_ = resources_get_stars (RATING_TWO);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strdup_printf (progress_base, _tmp59_);
	_g_free0 (resources_RATE_TWO_PROGRESS);
	resources_RATE_TWO_PROGRESS = _tmp60_;
	_g_free0 (_tmp59_);
	_tmp61_ = resources_get_stars (RATING_THREE);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_strdup_printf (progress_base, _tmp62_);
	_g_free0 (resources_RATE_THREE_PROGRESS);
	resources_RATE_THREE_PROGRESS = _tmp63_;
	_g_free0 (_tmp62_);
	_tmp64_ = resources_get_stars (RATING_FOUR);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_strdup_printf (progress_base, _tmp65_);
	_g_free0 (resources_RATE_FOUR_PROGRESS);
	resources_RATE_FOUR_PROGRESS = _tmp66_;
	_g_free0 (_tmp65_);
	_tmp67_ = resources_get_stars (RATING_FIVE);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strdup_printf (progress_base, _tmp68_);
	_g_free0 (resources_RATE_FIVE_PROGRESS);
	resources_RATE_FIVE_PROGRESS = _tmp69_;
	_g_free0 (_tmp68_);
	_tmp70_ = resources_get_stars (RATING_ONE);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp71_);
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_MENU);
	resources_DISPLAY_ONE_OR_HIGHER_MENU = _tmp72_;
	_g_free0 (_tmp71_);
	_tmp73_ = resources_get_stars (RATING_TWO);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp74_);
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_MENU);
	resources_DISPLAY_TWO_OR_HIGHER_MENU = _tmp75_;
	_g_free0 (_tmp74_);
	_tmp76_ = resources_get_stars (RATING_THREE);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp77_);
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_MENU);
	resources_DISPLAY_THREE_OR_HIGHER_MENU = _tmp78_;
	_g_free0 (_tmp77_);
	_tmp79_ = resources_get_stars (RATING_FOUR);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp80_);
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_MENU);
	resources_DISPLAY_FOUR_OR_HIGHER_MENU = _tmp81_;
	_g_free0 (_tmp80_);
	_tmp82_ = resources_get_stars (RATING_FIVE);
	_tmp83_ = _tmp82_;
	_tmp84_ = g_strdup_printf (display_rating_menu_base, _tmp83_);
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_MENU);
	resources_DISPLAY_FIVE_OR_HIGHER_MENU = _tmp84_;
	_g_free0 (_tmp83_);
	_tmp85_ = resources_get_stars (RATING_ONE);
	_tmp86_ = _tmp85_;
	_tmp87_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp86_);
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_LABEL);
	resources_DISPLAY_ONE_OR_HIGHER_LABEL = _tmp87_;
	_g_free0 (_tmp86_);
	_tmp88_ = resources_get_stars (RATING_TWO);
	_tmp89_ = _tmp88_;
	_tmp90_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp89_);
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_LABEL);
	resources_DISPLAY_TWO_OR_HIGHER_LABEL = _tmp90_;
	_g_free0 (_tmp89_);
	_tmp91_ = resources_get_stars (RATING_THREE);
	_tmp92_ = _tmp91_;
	_tmp93_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp92_);
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_LABEL);
	resources_DISPLAY_THREE_OR_HIGHER_LABEL = _tmp93_;
	_g_free0 (_tmp92_);
	_tmp94_ = resources_get_stars (RATING_FOUR);
	_tmp95_ = _tmp94_;
	_tmp96_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp95_);
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_LABEL);
	resources_DISPLAY_FOUR_OR_HIGHER_LABEL = _tmp96_;
	_g_free0 (_tmp95_);
	_tmp97_ = resources_get_stars (RATING_FIVE);
	_tmp98_ = _tmp97_;
	_tmp99_ = g_strdup_printf (display_rating_label_base, _tmp98_);
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_LABEL);
	resources_DISPLAY_FIVE_OR_HIGHER_LABEL = _tmp99_;
	_g_free0 (_tmp98_);
	_tmp100_ = resources_get_stars (RATING_ONE);
	_tmp101_ = _tmp100_;
	_tmp102_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp101_);
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP);
	resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP = _tmp102_;
	_g_free0 (_tmp101_);
	_tmp103_ = resources_get_stars (RATING_TWO);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp104_);
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP);
	resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP = _tmp105_;
	_g_free0 (_tmp104_);
	_tmp106_ = resources_get_stars (RATING_THREE);
	_tmp107_ = _tmp106_;
	_tmp108_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp107_);
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP);
	resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP = _tmp108_;
	_g_free0 (_tmp107_);
	_tmp109_ = resources_get_stars (RATING_FOUR);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp110_);
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP);
	resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP = _tmp111_;
	_g_free0 (_tmp110_);
	_tmp112_ = resources_get_stars (RATING_FIVE);
	_tmp113_ = _tmp112_;
	_tmp114_ = g_strdup_printf (display_rating_tooltip_base, _tmp113_);
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP);
	resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP = _tmp114_;
	_g_free0 (_tmp113_);
	_g_free0 (display_rating_or_higher_tooltip_base);
	_g_free0 (display_rating_or_higher_label_base);
	_g_free0 (display_rating_or_higher_menu_base);
	_g_free0 (display_rating_tooltip_base);
	_g_free0 (display_rating_label_base);
	_g_free0 (display_rating_menu_base);
	_g_free0 (progress_base);
	_g_free0 (tooltip_base);
	_g_free0 (label_base);
	_g_free0 (menu_base);
}

gchar*
resources_jump_to_file_failed (GError* err)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (err != NULL, NULL);
	_tmp0_ = err->message;
	_tmp1_ = g_strdup_printf (_ ("Unable to open in file manager: %s"), _tmp0_);
	result = _tmp1_;
	return result;
}

void
resources_init (void)
{
	resources_init_icon_theme_engine ();
	resources_init_css_provider ();
	resources_generate_rating_strings ();
}

void
resources_terminate (void)
{
}

/**
     * @brief Helper for getting a format string that matches the
     * user's LC_TIME settings from the system.  This is intended 
     * to help support the use case where a user wants the text 
     * from one locale, but the timestamp format of another.
     * 
     * Stolen wholesale from code written for Geary by Jim Nelson
     * and from Marcel Stimberg's original patch to Shotwell to 
     * try to fix this; both are graciously thanked for their help.
     */
void
resources_fetch_lc_time_format (void)
{
	gchar* old_language = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* old_messages = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* lc_time = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp19_;
	_tmp0_ = g_getenv ("LANGUAGE");
	_tmp1_ = g_strdup (_tmp0_);
	old_language = _tmp1_;
	_tmp2_ = old_language;
	if (_tmp2_ != NULL) {
		g_unsetenv ("LANGUAGE");
	}
	_tmp3_ = setlocale (LC_MESSAGES, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	old_messages = _tmp4_;
	_tmp5_ = setlocale (LC_TIME, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	lc_time = _tmp6_;
	_tmp7_ = lc_time;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = lc_time;
		setlocale (LC_MESSAGES, _tmp8_);
	}
	_tmp9_ = g_strdup ("%X");
	_g_free0 (resources_HH_MM_FORMAT_STRING);
	resources_HH_MM_FORMAT_STRING = _tmp9_;
	_tmp10_ = nl_langinfo (T_FMT);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (resources_HH_MM_SS_FORMAT_STRING);
	resources_HH_MM_SS_FORMAT_STRING = _tmp11_;
	_tmp12_ = g_strdup (_ ("%a %b %d, %Y"));
	_g_free0 (resources_LONG_DATE_FORMAT_STRING);
	resources_LONG_DATE_FORMAT_STRING = _tmp12_;
	_tmp13_ = g_strdup (C_ ("MultidayFormat", "%a %b %d"));
	_g_free0 (resources_START_MULTIDAY_DATE_FORMAT_STRING);
	resources_START_MULTIDAY_DATE_FORMAT_STRING = _tmp13_;
	_tmp14_ = g_strdup (C_ ("MultidayFormat", "%d, %Y"));
	_g_free0 (resources_END_MULTIDAY_DATE_FORMAT_STRING);
	resources_END_MULTIDAY_DATE_FORMAT_STRING = _tmp14_;
	_tmp15_ = g_strdup (C_ ("MultimonthFormat", "%a %b %d"));
	_g_free0 (resources_START_MULTIMONTH_DATE_FORMAT_STRING);
	resources_START_MULTIMONTH_DATE_FORMAT_STRING = _tmp15_;
	_tmp16_ = g_strdup (C_ ("MultimonthFormat", "%a %b %d, %Y"));
	_g_free0 (resources_END_MULTIMONTH_DATE_FORMAT_STRING);
	resources_END_MULTIMONTH_DATE_FORMAT_STRING = _tmp16_;
	_tmp17_ = old_messages;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = old_messages;
		setlocale (LC_MESSAGES, _tmp18_);
	}
	_tmp19_ = old_language;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		_tmp20_ = old_language;
		g_setenv ("LANGUAGE", _tmp20_, TRUE);
	}
	_g_free0 (lc_time);
	_g_free0 (old_messages);
	_g_free0 (old_language);
}

static GType
resources_unit_system_get_type_once (void)
{
	static const GEnumValue values[] = {{RESOURCES_UNIT_SYSTEM_IMPERIAL, "RESOURCES_UNIT_SYSTEM_IMPERIAL", "imperial"}, {RESOURCES_UNIT_SYSTEM_METRIC, "RESOURCES_UNIT_SYSTEM_METRIC", "metric"}, {RESOURCES_UNIT_SYSTEM_UNKNOWN, "RESOURCES_UNIT_SYSTEM_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType resources_unit_system_type_id;
	resources_unit_system_type_id = g_enum_register_static ("ResourcesUnitSystem", values);
	return resources_unit_system_type_id;
}

GType
resources_unit_system_get_type (void)
{
	static volatile gsize resources_unit_system_type_id__once = 0;
	if (g_once_init_enter (&resources_unit_system_type_id__once)) {
		GType resources_unit_system_type_id;
		resources_unit_system_type_id = resources_unit_system_get_type_once ();
		g_once_init_leave (&resources_unit_system_type_id__once, resources_unit_system_type_id);
	}
	return resources_unit_system_type_id__once;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

ResourcesUnitSystem
resources_get_default_measurement_unit (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint index = 0;
	const gchar* _tmp7_;
	const gchar* _tmp10_;
	ResourcesUnitSystem result;
	if (resources_unit_system != RESOURCES_UNIT_SYSTEM_UNKNOWN) {
		result = resources_unit_system;
		return result;
	}
	_tmp0_ = g_getenv ("LC_MEASUREMENT");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (resources_lc_measurement);
	resources_lc_measurement = _tmp1_;
	_tmp2_ = resources_lc_measurement;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = _tmp3_ = g_get_language_names ();
		_tmp5_ = _tmp4_[0];
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (resources_lc_measurement);
		resources_lc_measurement = _tmp6_;
	}
	_tmp7_ = resources_lc_measurement;
	index = string_last_index_of_char (_tmp7_, (gunichar) '.', 0);
	if (index > 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = resources_lc_measurement;
		_tmp9_ = string_substring (_tmp8_, (glong) 0, (glong) index);
		_g_free0 (resources_lc_measurement);
		resources_lc_measurement = _tmp9_;
	}
	resources_unit_system = RESOURCES_UNIT_SYSTEM_METRIC;
	_tmp10_ = resources_lc_measurement;
	if (_vala_string_array_contains (RESOURCES_IMPERIAL_COUNTRIES, G_N_ELEMENTS (RESOURCES_IMPERIAL_COUNTRIES), _tmp10_)) {
		resources_unit_system = RESOURCES_UNIT_SYSTEM_IMPERIAL;
	}
	result = resources_unit_system;
	return result;
}

/**
     * @brief Returns a precached format string that matches the
     * user's LC_TIME settings.  
     */
gchar*
resources_get_hh_mm_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_HH_MM_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_HH_MM_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_hh_mm_ss_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_HH_MM_SS_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_HH_MM_SS_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_long_date_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_LONG_DATE_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_LONG_DATE_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_start_multiday_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_START_MULTIDAY_DATE_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_START_MULTIDAY_DATE_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_end_multiday_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_END_MULTIDAY_DATE_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_END_MULTIDAY_DATE_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_start_multimonth_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_START_MULTIMONTH_DATE_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_START_MULTIMONTH_DATE_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_end_multimonth_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_END_MULTIMONTH_DATE_FORMAT_STRING;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_END_MULTIMONTH_DATE_FORMAT_STRING;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_ui (const gchar* filename)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/Shotwell/ui/%s", filename);
	result = _tmp0_;
	return result;
}

GdkPixbuf*
resources_get_noninterpretable_badge_pixbuf (void)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	_tmp0_ = resources_noninterpretable_badge_pixbuf;
	if (_tmp0_ == NULL) {
		{
			gchar* path = NULL;
			gchar* _tmp1_;
			GdkPixbuf* _tmp2_ = NULL;
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			_tmp1_ = g_strdup ("/org/gnome/Shotwell/icons/" RESOURCES_NONINTERPRETABLE_BADGE_FILE);
			path = _tmp1_;
			_tmp3_ = path;
			_tmp4_ = gdk_pixbuf_new_from_resource (_tmp3_, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (resources_noninterpretable_badge_pixbuf);
			resources_noninterpretable_badge_pixbuf = _tmp5_;
			_g_object_unref0 (_tmp2_);
			_g_free0 (path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp6_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = err->message;
			g_error ("Resources.vala:990: VideoReader can't load noninterpretable badge imag" \
"e: %s", _tmp6_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = resources_noninterpretable_badge_pixbuf;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

void
resources_init_css_provider (void)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	gtk_css_provider_load_from_resource (provider, "/org/gnome/Shotwell/themes/org.gnome.Shotwell.css");
	_tmp1_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (provider, gtk_style_provider_get_type (), GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

void
resources_init_icon_theme_engine (void)
{
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/icons");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/icons/hicolor");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/Publishing/icons");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/Publishing/icons/hicolor");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/Transitions/icons");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/Transitions/icons/hicolor");
	_g_object_unref0 (icon_theme);
}

GdkPixbuf*
resources_get_icon (const gchar* name,
                    gint scale)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp7_;
	GdkPixbuf* pixbuf = NULL;
	GeeHashMap* _tmp9_;
	gpointer _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* scaled_pixbuf = NULL;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = resources_scaled_icon_cache;
	if (_tmp0_ != NULL) {
		gchar* scaled_name = NULL;
		gchar* _tmp1_;
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_strdup_printf ("%s-%d", name, scale);
		scaled_name = _tmp1_;
		_tmp2_ = resources_scaled_icon_cache;
		_tmp3_ = scaled_name;
		if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_)) {
			GeeHashMap* _tmp4_;
			const gchar* _tmp5_;
			gpointer _tmp6_;
			_tmp4_ = resources_scaled_icon_cache;
			_tmp5_ = scaled_name;
			_tmp6_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_);
			result = (GdkPixbuf*) _tmp6_;
			_g_free0 (scaled_name);
			return result;
		}
		_g_free0 (scaled_name);
	}
	_tmp7_ = resources_icon_cache;
	if (_tmp7_ == NULL) {
		GeeHashMap* _tmp8_;
		_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (resources_icon_cache);
		resources_icon_cache = _tmp8_;
	}
	_tmp9_ = resources_icon_cache;
	_tmp10_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
	pixbuf = (GdkPixbuf*) _tmp10_;
	_tmp11_ = pixbuf;
	if (_tmp11_ == NULL) {
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		GeeHashMap* _tmp14_;
		GdkPixbuf* _tmp15_;
		_tmp12_ = resources_load_icon (name, scale);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp12_;
		_tmp13_ = pixbuf;
		if (_tmp13_ == NULL) {
			result = NULL;
			_g_object_unref0 (pixbuf);
			return result;
		}
		_tmp14_ = resources_icon_cache;
		_tmp15_ = pixbuf;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, _tmp15_);
	}
	if (scale <= 0) {
		result = pixbuf;
		return result;
	}
	_tmp16_ = pixbuf;
	_tmp17_ = scale_pixbuf (_tmp16_, scale, GDK_INTERP_BILINEAR, FALSE);
	scaled_pixbuf = _tmp17_;
	_tmp18_ = resources_scaled_icon_cache;
	if (_tmp18_ == NULL) {
		GeeHashMap* _tmp19_;
		_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (resources_scaled_icon_cache);
		resources_scaled_icon_cache = _tmp19_;
	}
	_tmp20_ = resources_scaled_icon_cache;
	_tmp21_ = g_strdup_printf ("%s-%d", name, scale);
	_tmp22_ = _tmp21_;
	_tmp23_ = scaled_pixbuf;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_, _tmp23_);
	_g_free0 (_tmp22_);
	result = scaled_pixbuf;
	_g_object_unref0 (pixbuf);
	return result;
}

GdkPixbuf*
resources_load_icon (const gchar* name,
                     gint scale)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_ = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (name != NULL, NULL);
	pixbuf = NULL;
	{
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp0_;
		GtkIconTheme* _tmp1_;
		GtkIconInfo* info = NULL;
		GtkIconInfo* _tmp2_;
		GdkPixbuf* _tmp3_ = NULL;
		AppWindow* _tmp4_;
		AppWindow* _tmp5_;
		GtkStyleContext* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp0_ = gtk_icon_theme_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		theme = _tmp1_;
		_tmp2_ = gtk_icon_theme_lookup_icon (theme, name, scale, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		info = _tmp2_;
		_tmp4_ = app_window_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = gtk_icon_info_load_symbolic_for_context (info, _tmp6_, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
		_tmp3_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (theme);
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp9_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (info);
		_g_object_unref0 (theme);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_debug ("Resources.vala:1057: Failed to find icon %s in theme, falling back to " \
"resources", name);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = pixbuf;
	if (_tmp10_ == NULL) {
		{
			gchar* path = NULL;
			gchar* _tmp11_;
			GdkPixbuf* _tmp12_ = NULL;
			const gchar* _tmp13_;
			GdkPixbuf* _tmp14_;
			GdkPixbuf* _tmp15_;
			_tmp11_ = g_strdup_printf ("/org/gnome/Shotwell/icons/%s", name);
			path = _tmp11_;
			_tmp13_ = path;
			_tmp14_ = gdk_pixbuf_new_from_resource (_tmp13_, &_inner_error0_);
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				goto __catch1_g_error;
			}
			_tmp15_ = _tmp12_;
			_tmp12_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp15_;
			_g_object_unref0 (_tmp12_);
			_g_free0 (path);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = err;
			_tmp17_ = _tmp16_->message;
			g_critical ("Resources.vala:1065: Unable to load icon %s: %s", name, _tmp17_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = pixbuf;
	if (_tmp18_ == NULL) {
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	if (scale > 0) {
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_;
		_tmp20_ = pixbuf;
		_tmp21_ = scale_pixbuf (_tmp20_, scale, GDK_INTERP_BILINEAR, FALSE);
		_g_object_unref0 (_tmp19_);
		_tmp19_ = _tmp21_;
	} else {
		GdkPixbuf* _tmp22_;
		GdkPixbuf* _tmp23_;
		_tmp22_ = pixbuf;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_g_object_unref0 (_tmp19_);
		_tmp19_ = _tmp23_;
	}
	result = _tmp19_;
	_g_object_unref0 (pixbuf);
	return result;
}

gchar*
resources_get_help_path (void)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GFile* help_dir = NULL;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* help_index = NULL;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gchar* result;
	_tmp0_ = app_dirs_get_exec_dir ();
	dir = _tmp0_;
	_tmp1_ = dir;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_suffix (_tmp3_, "src");
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp5_ = dir;
		_tmp6_ = g_file_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_parent (_tmp7_);
		_g_object_unref0 (dir);
		dir = _tmp8_;
		_g_object_unref0 (_tmp7_);
	}
	_tmp9_ = dir;
	_tmp10_ = g_file_get_child (_tmp9_, "help");
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_child (_tmp11_, "C");
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	help_dir = _tmp13_;
	_tmp14_ = help_dir;
	_tmp15_ = g_file_get_child (_tmp14_, "index.page");
	help_index = _tmp15_;
	_tmp16_ = help_index;
	if (g_file_query_exists (_tmp16_, NULL)) {
		gchar* help_path = NULL;
		GFile* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = help_dir;
		_tmp18_ = g_file_get_path (_tmp17_);
		_g_free0 (help_path);
		help_path = _tmp18_;
		_tmp19_ = help_path;
		if (!g_str_has_suffix (_tmp19_, "/")) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = help_path;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_g_free0 (help_path);
			help_path = _tmp21_;
		}
		result = help_path;
		_g_object_unref0 (help_index);
		_g_object_unref0 (help_dir);
		_g_object_unref0 (dir);
		return result;
	}
	result = NULL;
	_g_object_unref0 (help_index);
	_g_object_unref0 (help_dir);
	_g_object_unref0 (dir);
	return result;
}

void
resources_launch_help (GtkWindow* window,
                       const gchar* anchor,
                       GError** error)
{
	gchar* help_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* uri = NULL;
	gchar* _tmp22_;
	const gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (window, gtk_window_get_type ()));
	_tmp0_ = resources_get_help_path ();
	help_path = _tmp0_;
	_tmp1_ = help_path;
	if (_tmp1_ != NULL) {
		gchar** argv = NULL;
		gchar** _tmp4_;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		GPid pid = 0;
		gboolean _tmp11_ = FALSE;
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		GPid _tmp17_ = 0;
		gboolean _tmp18_;
		gboolean _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		if (anchor != NULL) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = help_path;
			_tmp3_ = g_strconcat (_tmp2_, anchor, NULL);
			_g_free0 (help_path);
			help_path = _tmp3_;
		}
		_tmp4_ = g_new0 (gchar*, 3 + 1);
		argv = _tmp4_;
		argv_length1 = 3;
		_argv_size_ = argv_length1;
		_tmp5_ = argv;
		_tmp5__length1 = argv_length1;
		_tmp6_ = g_strdup ("yelp");
		_g_free0 (_tmp5_[0]);
		_tmp5_[0] = _tmp6_;
		_tmp7_ = argv;
		_tmp7__length1 = argv_length1;
		_tmp8_ = help_path;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_tmp7_[1]);
		_tmp7_[1] = _tmp9_;
		_tmp10_ = argv;
		_tmp10__length1 = argv_length1;
		_g_free0 (_tmp10_[2]);
		_tmp10_[2] = NULL;
		_tmp12_ = app_dirs_get_exec_dir ();
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = argv;
		_tmp16__length1 = argv_length1;
		_tmp18_ = g_spawn_async (_tmp15_, _tmp16_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp17_, &_inner_error0_);
		pid = _tmp17_;
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp15_);
		_g_object_unref0 (_tmp13_);
		_tmp11_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (help_path);
			return;
		}
		if (_tmp11_) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (help_path);
			return;
		}
		_tmp20_ = argv;
		_tmp20__length1 = argv_length1;
		_tmp21_ = _tmp20_[0];
		g_warning ("Resources.vala:1131: Unable to launch %s", _tmp21_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp22_ = g_strdup ("help:shotwell");
	uri = _tmp22_;
	if (anchor != NULL) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = uri;
		_tmp24_ = g_strconcat (_tmp23_, anchor, NULL);
		_g_free0 (uri);
		uri = _tmp24_;
	}
	_tmp25_ = uri;
	gtk_show_uri_on_window (window, _tmp25_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uri);
		_g_free0 (help_path);
		return;
	}
	_g_free0 (uri);
	_g_free0 (help_path);
}

gint
resources_use_header_bar (void)
{
	const gchar* _tmp0_;
	gboolean use_header = FALSE;
	GtkSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint result;
	_tmp0_ = g_getenv ("SHOTWELL_USE_HEADERBARS");
	if (_tmp0_ != NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "gtk-dialogs-use-header", &_tmp2_, NULL);
	use_header = _tmp2_;
	if (use_header) {
		_tmp3_ = 1;
	} else {
		_tmp3_ = 0;
	}
	result = _tmp3_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

