/* Properties.c generated by valac 0.56.17, the Vala compiler
 * generated from Properties.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include "metadata.h"
#include <gio/gio.h>
#include <locale.h>

#define EXTENDED_PROPERTIES_NO_VALUE ""
#define EXTENDED_PROPERTIES_OSM_LINK_TEMPLATE "https://www.openstreetmap.org/?mlat=%1$f&amp;mlon=%2$f#map=16/%1$f/%2$" \
"f"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROPERTIES (properties_get_type ())
#define PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES, Properties))
#define PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES, PropertiesClass))
#define IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES))
#define IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES))
#define PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES, PropertiesClass))

typedef struct _Properties Properties;
typedef struct _PropertiesClass PropertiesClass;
typedef struct _PropertiesPrivate PropertiesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
enum  {
	PROPERTIES_0_PROPERTY,
	PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* properties_properties[PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_BASIC_PROPERTIES (basic_properties_get_type ())
#define BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_PROPERTIES, BasicProperties))
#define BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))
#define IS_BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_PROPERTIES))
#define IS_BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_PROPERTIES))
#define BASIC_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))

typedef struct _BasicProperties BasicProperties;
typedef struct _BasicPropertiesClass BasicPropertiesClass;
typedef struct _BasicPropertiesPrivate BasicPropertiesPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
enum  {
	BASIC_PROPERTIES_0_PROPERTY,
	BASIC_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* basic_properties_properties[BASIC_PROPERTIES_NUM_PROPERTIES];

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_IMPORT_SOURCE (import_source_get_type ())
#define IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE, ImportSource))
#define IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE, ImportSourceClass))
#define IS_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE))
#define IS_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE))
#define IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE, ImportSourceClass))

typedef struct _ImportSource ImportSource;
typedef struct _ImportSourceClass ImportSourceClass;

#define TYPE_PHOTO_IMPORT_SOURCE (photo_import_source_get_type ())
#define PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource))
#define PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))
#define IS_PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_SOURCE))
#define IS_PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_SOURCE))
#define PHOTO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))

typedef struct _PhotoImportSource PhotoImportSource;
typedef struct _PhotoImportSourceClass PhotoImportSourceClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _dimensions_free0(var) ((var == NULL) ? NULL : (var = (dimensions_free (var), NULL)))
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO_IMPORT_SOURCE (video_import_source_get_type ())
#define VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource))
#define VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))
#define IS_VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_SOURCE))
#define IS_VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_SOURCE))
#define VIDEO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))

typedef struct _VideoImportSource VideoImportSource;
typedef struct _VideoImportSourceClass VideoImportSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;

#define TYPE_MEDIA_PAGE (media_page_get_type ())
#define MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_PAGE, MediaPage))
#define MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_PAGE, MediaPageClass))
#define IS_MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_PAGE))
#define IS_MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_PAGE))
#define MEDIA_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_PAGE, MediaPageClass))

typedef struct _MediaPage MediaPage;
typedef struct _MediaPageClass MediaPageClass;

#define TYPE_COLLECTION_PAGE (collection_page_get_type ())
#define COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_PAGE, CollectionPage))
#define COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_PAGE, CollectionPageClass))
#define IS_COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_PAGE))
#define IS_COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_PAGE))
#define COLLECTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_PAGE, CollectionPageClass))

typedef struct _CollectionPage CollectionPage;
typedef struct _CollectionPageClass CollectionPageClass;

#define TYPE_TAG_PAGE (tag_page_get_type ())
#define TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_PAGE, TagPage))
#define TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_PAGE, TagPageClass))
#define IS_TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_PAGE))
#define IS_TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_PAGE))
#define TAG_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_PAGE, TagPageClass))

typedef struct _TagPage TagPage;
typedef struct _TagPageClass TagPageClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_EXTENDED_PROPERTIES (extended_properties_get_type ())
#define EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTENDED_PROPERTIES, ExtendedProperties))
#define EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesClass))
#define IS_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTENDED_PROPERTIES))
#define IS_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesClass))

typedef struct _ExtendedProperties ExtendedProperties;
typedef struct _ExtendedPropertiesClass ExtendedPropertiesClass;
typedef struct _ExtendedPropertiesPrivate ExtendedPropertiesPrivate;
enum  {
	EXTENDED_PROPERTIES_0_PROPERTY,
	EXTENDED_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* extended_properties_properties[EXTENDED_PROPERTIES_NUM_PROPERTIES];
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_EVENTS_DIRECTORY_PAGE (events_directory_page_get_type ())
#define EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPage))
#define EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))
#define IS_EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENTS_DIRECTORY_PAGE))
#define IS_EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENTS_DIRECTORY_PAGE))
#define EVENTS_DIRECTORY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))

typedef struct _EventsDirectoryPage EventsDirectoryPage;
typedef struct _EventsDirectoryPageClass EventsDirectoryPageClass;

struct _Properties {
	GtkBox parent_instance;
	PropertiesPrivate * priv;
	GtkGrid* grid;
	guint line_count;
};

struct _PropertiesClass {
	GtkBoxClass parent_class;
	void (*get_single_properties) (Properties* self, DataView* view);
	void (*get_multiple_properties) (Properties* self, GeeIterable* iter);
	void (*get_properties) (Properties* self, Page* current_page);
	void (*clear_properties) (Properties* self);
	void (*internal_update_properties) (Properties* self, Page* page);
};

struct _BasicProperties {
	Properties parent_instance;
	BasicPropertiesPrivate * priv;
};

struct _BasicPropertiesClass {
	PropertiesClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BasicPropertiesPrivate {
	gchar* title;
	GDateTime* start_time;
	GDateTime* end_time;
	Dimensions dimensions;
	gint photo_count;
	gint event_count;
	gint video_count;
	gchar* exposure;
	gchar* aperture;
	gchar* iso;
	gdouble clip_duration;
	gchar* raw_developer;
	gchar* raw_assoc;
};

struct _ExtendedProperties {
	Properties parent_instance;
	ExtendedPropertiesPrivate * priv;
};

struct _ExtendedPropertiesClass {
	PropertiesClass parent_class;
};

struct _ExtendedPropertiesPrivate {
	gchar* file_path;
	guint64 filesize;
	Dimensions* original_dim;
	gchar* camera_make;
	gchar* camera_model;
	gchar* flash;
	gchar* focal_length;
	gdouble gps_lat;
	gchar* gps_lat_ref;
	gdouble gps_long;
	gchar* gps_long_ref;
	gdouble gps_alt;
	gchar* artist;
	gchar* copyright;
	gchar* software;
	gchar* exposure_bias;
	gchar* exposure_date;
	gchar* exposure_time;
	gboolean is_raw;
	gchar* development_path;
	gchar* comment;
};

static gpointer properties_parent_class = NULL;
static gint BasicProperties_private_offset;
static gpointer basic_properties_parent_class = NULL;
static gint ExtendedProperties_private_offset;
static gpointer extended_properties_parent_class = NULL;

VALA_EXTERN GType properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Properties, g_object_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN void properties_get_single_properties (Properties* self,
                                       DataView* view);
VALA_EXTERN void properties_get_multiple_properties (Properties* self,
                                         GeeIterable* iter);
VALA_EXTERN void properties_get_properties (Properties* self,
                                Page* current_page);
VALA_EXTERN void properties_clear_properties (Properties* self);
VALA_EXTERN void properties_internal_update_properties (Properties* self,
                                            Page* page);
VALA_EXTERN Properties* properties_construct (GType object_type);
VALA_EXTERN void properties_add_line (Properties* self,
                          const gchar* label_text,
                          const gchar* info_text,
                          gboolean multi_line,
                          const gchar* href);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN gchar* properties_get_prettyprint_time (Properties* self,
                                        GDateTime* time);
VALA_EXTERN gchar* resources_get_hh_mm_format_string (void);
VALA_EXTERN gchar* properties_get_prettyprint_time_with_seconds (Properties* self,
                                                     GDateTime* time);
VALA_EXTERN gchar* resources_get_hh_mm_ss_format_string (void);
VALA_EXTERN gchar* properties_get_prettyprint_date (Properties* self,
                                        GDateTime* date);
VALA_EXTERN gchar* format_local_date (GDateTime* date);
static void properties_real_get_single_properties (Properties* self,
                                            DataView* view);
static void properties_real_get_multiple_properties (Properties* self,
                                              GeeIterable* iter);
static void properties_real_get_properties (Properties* self,
                                     Page* current_page);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN ViewCollection* page_get_view (Page* self);
VALA_EXTERN gint view_collection_get_selected_count (ViewCollection* self);
VALA_EXTERN GeeList* view_collection_get_selected (ViewCollection* self);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
static void properties_real_clear_properties (Properties* self);
VALA_EXTERN void properties_update_properties (Properties* self,
                                   Page* page);
static void properties_real_internal_update_properties (Properties* self,
                                                 Page* page);
static void properties_finalize (GObject * obj);
static GType properties_get_type_once (void);
VALA_EXTERN GType basic_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BasicProperties, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN BasicProperties* basic_properties_new (void);
VALA_EXTERN BasicProperties* basic_properties_construct (GType object_type);
static void basic_properties_real_clear_properties (Properties* base);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static void basic_properties_real_get_single_properties (Properties* base,
                                                  DataView* view);
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType import_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImportSource, g_object_unref)
VALA_EXTERN GType photo_import_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoImportSource, g_object_unref)
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN GDateTime* import_source_get_exposure_time (ImportSource* self);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
VALA_EXTERN PhotoMetadata* photo_import_source_get_metadata (PhotoImportSource* self);
VALA_EXTERN gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_aperture_string (PhotoMetadata* self,
                                           gboolean pango_formatted);
VALA_EXTERN gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
VALA_EXTERN Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Orientation photo_metadata_get_orientation (PhotoMetadata* self);
VALA_EXTERN void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_get_master_file_format (Photo* self);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RawDeveloper photo_get_raw_developer (Photo* self);
VALA_EXTERN gchar* raw_developer_get_label (RawDeveloper self);
VALA_EXTERN gboolean photo_is_raw_developer_available (Photo* self,
                                           RawDeveloper d);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GDateTime* event_source_get_start_time (EventSource* self);
VALA_EXTERN GDateTime* event_source_get_end_time (EventSource* self);
VALA_EXTERN void media_source_collection_count_media (GeeCollection* media,
                                          gint* photo_count,
                                          gint* video_count);
VALA_EXTERN GeeCollection* event_source_get_media (EventSource* self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_import_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoImportSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN gdouble video_get_clip_duration (Video* self);
VALA_EXTERN gboolean video_get_is_interpretable (Video* self);
VALA_EXTERN void video_get_frame_dimensions (Video* self,
                                 Dimensions* result);
static void basic_properties_real_get_multiple_properties (Properties* base,
                                                    GeeIterable* iter);
static void basic_properties_real_get_properties (Properties* base,
                                           Page* current_page);
static void basic_properties_real_internal_update_properties (Properties* base,
                                                       Page* page);
VALA_EXTERN GType checkerboard_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardPage, g_object_unref)
VALA_EXTERN GType media_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaPage, g_object_unref)
VALA_EXTERN GType collection_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CollectionPage, g_object_unref)
VALA_EXTERN GType tag_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagPage, g_object_unref)
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN Tag* tag_page_get_tag (TagPage* self);
VALA_EXTERN gchar* tag_get_user_visible_name (Tag* self);
VALA_EXTERN gchar* guarded_markup_escape_text (const gchar* plain);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
static void basic_properties_finalize (GObject * obj);
static GType basic_properties_get_type_once (void);
VALA_EXTERN GType extended_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExtendedProperties, g_object_unref)
VALA_EXTERN ExtendedProperties* extended_properties_new (void);
VALA_EXTERN ExtendedProperties* extended_properties_construct (GType object_type);
static void extended_properties_real_clear_properties (Properties* base);
static void extended_properties_real_get_single_properties (Properties* base,
                                                     DataView* view);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN guint64 media_source_get_master_filesize (MediaSource* self);
VALA_EXTERN PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
VALA_EXTERN MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
VALA_EXTERN GType photo_metadata_set_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
VALA_EXTERN GDateTime* media_source_get_timestamp (MediaSource* self);
VALA_EXTERN gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
VALA_EXTERN gboolean photo_metadata_get_gps (PhotoMetadata* self,
                                 gdouble* longitude,
                                 gchar** long_ref,
                                 gdouble* latitude,
                                 gchar** lat_ref,
                                 gdouble* altitude);
VALA_EXTERN gchar* photo_metadata_get_artist (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_copyright (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_software (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN gchar* event_source_get_comment (EventSource* self);
static void extended_properties_real_internal_update_properties (Properties* base,
                                                          Page* page);
VALA_EXTERN GType events_directory_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventsDirectoryPage, g_object_unref)
static void extended_properties_finalize (GObject * obj);
static GType extended_properties_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

Properties*
properties_construct (GType object_type)
{
	Properties * self = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	self = (Properties*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "homogeneous", FALSE, NULL);
	_tmp0_ = self->grid;
	gtk_grid_set_row_spacing (_tmp0_, 6);
	_tmp1_ = self->grid;
	gtk_grid_set_column_spacing (_tmp1_, 12);
	_tmp2_ = self->grid;
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
properties_add_line (Properties* self,
                     const gchar* label_text,
                     const gchar* info_text,
                     gboolean multi_line,
                     const gchar* href)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkWidget* info = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	guint _tmp52_;
	g_return_if_fail (IS_PROPERTIES (self));
	g_return_if_fail (label_text != NULL);
	g_return_if_fail (info_text != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	_tmp1_ = label;
	gtk_label_set_justify (_tmp1_, GTK_JUSTIFY_RIGHT);
	_tmp2_ = label;
	_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp3_, "dim-label");
	_tmp4_ = label;
	_tmp5_ = g_markup_printf_escaped ("<span font_weight=\"bold\">%s</span>", label_text);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	if (multi_line) {
		GtkScrolledWindow* info_scroll = NULL;
		GtkScrolledWindow* _tmp7_;
		GtkScrolledWindow* _tmp8_;
		GtkTextView* view = NULL;
		GtkTextView* _tmp9_;
		GtkTextView* _tmp10_;
		GtkStyleContext* _tmp11_;
		GtkTextView* _tmp12_;
		GtkTextView* _tmp13_;
		GtkTextView* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GtkTextView* _tmp16_;
		GtkTextBuffer* _tmp17_;
		GtkTextBuffer* _tmp18_;
		GtkTextView* _tmp19_;
		GtkScrolledWindow* _tmp20_;
		GtkTextView* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		GtkScrolledWindow* _tmp24_;
		GtkWidget* _tmp25_;
		_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_ref_sink (_tmp7_);
		info_scroll = _tmp7_;
		_tmp8_ = info_scroll;
		gtk_scrolled_window_set_shadow_type (_tmp8_, GTK_SHADOW_NONE);
		_tmp9_ = (GtkTextView*) gtk_text_view_new ();
		g_object_ref_sink (_tmp9_);
		view = _tmp9_;
		_tmp10_ = view;
		_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp11_, "shotwell-static");
		_tmp12_ = view;
		gtk_text_view_set_wrap_mode (_tmp12_, GTK_WRAP_WORD);
		_tmp13_ = view;
		gtk_text_view_set_cursor_visible (_tmp13_, FALSE);
		_tmp14_ = view;
		gtk_text_view_set_editable (_tmp14_, FALSE);
		if (is_string_empty (info_text)) {
			_tmp15_ = "";
		} else {
			_tmp15_ = info_text;
		}
		_tmp16_ = view;
		_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
		_tmp18_ = _tmp17_;
		g_object_set (_tmp18_, "text", _tmp15_, NULL);
		_tmp19_ = view;
		gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp20_ = info_scroll;
		_tmp21_ = view;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_tmp22_ = label;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
		_tmp23_ = label;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
		_tmp24_ = info_scroll;
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (info);
		info = _tmp25_;
		_g_object_unref0 (view);
		_g_object_unref0 (info_scroll);
	} else {
		GtkLabel* info_label = NULL;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp35_;
		GtkLabel* _tmp36_;
		GtkLabel* _tmp37_;
		GtkLabel* _tmp38_;
		GtkLabel* _tmp39_;
		GtkLabel* _tmp40_;
		GtkLabel* _tmp41_;
		GtkLabel* _tmp42_;
		GtkLabel* _tmp43_;
		GtkLabel* _tmp44_;
		GtkWidget* _tmp45_;
		_tmp26_ = (GtkLabel*) gtk_label_new ("");
		g_object_ref_sink (_tmp26_);
		info_label = _tmp26_;
		if (!is_string_empty (info_text)) {
			GtkLabel* _tmp27_;
			_tmp27_ = info_label;
			gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), info_text);
		}
		if (href == NULL) {
			const gchar* _tmp28_ = NULL;
			GtkLabel* _tmp29_;
			if (is_string_empty (info_text)) {
				_tmp28_ = "";
			} else {
				_tmp28_ = info_text;
			}
			_tmp29_ = info_label;
			gtk_label_set_markup (_tmp29_, _tmp28_);
		} else {
			GtkLabel* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp30_ = info_label;
			_tmp31_ = g_markup_escape_text (info_text, (gssize) -1);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup_printf ("<a href=\"%s\">%s</a>", href, _tmp32_);
			_tmp34_ = _tmp33_;
			gtk_label_set_markup (_tmp30_, _tmp34_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
		}
		_tmp35_ = info_label;
		gtk_label_set_ellipsize (_tmp35_, PANGO_ELLIPSIZE_END);
		_tmp36_ = info_label;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
		_tmp37_ = info_label;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
		_tmp38_ = info_label;
		gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp39_ = info_label;
		gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp40_ = info_label;
		gtk_label_set_justify (_tmp40_, GTK_JUSTIFY_LEFT);
		_tmp41_ = info_label;
		gtk_label_set_selectable (_tmp41_, TRUE);
		_tmp42_ = label;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
		_tmp43_ = label;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
		_tmp44_ = info_label;
		_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (info);
		info = _tmp45_;
		_g_object_unref0 (info_label);
	}
	_tmp46_ = self->grid;
	_tmp47_ = label;
	gtk_grid_attach (_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), 0, (gint) self->line_count, 1, 1);
	if (multi_line) {
		GtkGrid* _tmp48_;
		GtkWidget* _tmp49_;
		_tmp48_ = self->grid;
		_tmp49_ = info;
		gtk_grid_attach (_tmp48_, _tmp49_, 1, (gint) self->line_count, 1, 3);
	} else {
		GtkGrid* _tmp50_;
		GtkWidget* _tmp51_;
		_tmp50_ = self->grid;
		_tmp51_ = info;
		gtk_grid_attach (_tmp50_, _tmp51_, 1, (gint) self->line_count, 1, 1);
	}
	_tmp52_ = self->line_count;
	self->line_count = _tmp52_ + 1;
	_g_object_unref0 (info);
	_g_object_unref0 (label);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
properties_get_prettyprint_time (Properties* self,
                                 GDateTime* time)
{
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = resources_get_hh_mm_format_string ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (time, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	timestring = _tmp3_;
	_tmp4_ = timestring;
	if (string_get (_tmp4_, (glong) 0) == '0') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = timestring;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
		_g_free0 (timestring);
		timestring = _tmp6_;
	}
	result = timestring;
	return result;
}

gchar*
properties_get_prettyprint_time_with_seconds (Properties* self,
                                              GDateTime* time)
{
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = resources_get_hh_mm_ss_format_string ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (time, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	timestring = _tmp3_;
	_tmp4_ = timestring;
	if (string_get (_tmp4_, (glong) 0) == '0') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = timestring;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
		_g_free0 (timestring);
		timestring = _tmp6_;
	}
	result = timestring;
	return result;
}

gchar*
properties_get_prettyprint_date (Properties* self,
                                 GDateTime* date)
{
	gchar* date_string = NULL;
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_;
	gchar* result;
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
	g_return_val_if_fail (date != NULL, NULL);
	date_string = NULL;
	_tmp0_ = g_date_time_new_now_local ();
	today = _tmp0_;
	_tmp2_ = today;
	if (g_date_time_get_day_of_year (date) == g_date_time_get_day_of_year (_tmp2_)) {
		GDateTime* _tmp3_;
		_tmp3_ = today;
		_tmp1_ = g_date_time_get_year (date) == g_date_time_get_year (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Today"));
		_g_free0 (date_string);
		date_string = _tmp4_;
	} else {
		gboolean _tmp5_ = FALSE;
		GDateTime* _tmp6_;
		_tmp6_ = today;
		if (g_date_time_get_day_of_year (date) == (g_date_time_get_day_of_year (_tmp6_) - 1)) {
			GDateTime* _tmp7_;
			_tmp7_ = today;
			_tmp5_ = g_date_time_get_year (date) == g_date_time_get_year (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Yesterday"));
			_g_free0 (date_string);
			date_string = _tmp8_;
		} else {
			gchar* _tmp9_;
			_tmp9_ = format_local_date (date);
			_g_free0 (date_string);
			date_string = _tmp9_;
		}
	}
	result = date_string;
	_g_date_time_unref0 (today);
	return result;
}

static void
properties_real_get_single_properties (Properties* self,
                                       DataView* view)
{
	g_return_if_fail (IS_DATA_VIEW (view));
}

void
properties_get_single_properties (Properties* self,
                                  DataView* view)
{
	PropertiesClass* _klass_;
	g_return_if_fail (IS_PROPERTIES (self));
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_single_properties) {
		_klass_->get_single_properties (self, view);
	}
}

static void
properties_real_get_multiple_properties (Properties* self,
                                         GeeIterable* iter)
{
	g_return_if_fail ((iter == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (iter, GEE_TYPE_ITERABLE));
}

void
properties_get_multiple_properties (Properties* self,
                                    GeeIterable* iter)
{
	PropertiesClass* _klass_;
	g_return_if_fail (IS_PROPERTIES (self));
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_multiple_properties) {
		_klass_->get_multiple_properties (self, iter);
	}
}

static void
properties_real_get_properties (Properties* self,
                                Page* current_page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gint count = 0;
	ViewCollection* _tmp2_;
	GeeIterable* iter = NULL;
	gboolean _tmp8_ = FALSE;
	GeeIterable* _tmp9_;
	g_return_if_fail (IS_PAGE (current_page));
	_tmp0_ = page_get_view (current_page);
	view = _tmp0_;
	_tmp1_ = view;
	if (_tmp1_ == NULL) {
		_data_collection_unref0 (view);
		return;
	}
	_tmp2_ = view;
	count = view_collection_get_selected_count (_tmp2_);
	iter = NULL;
	if (count != 0) {
		ViewCollection* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = view;
		_tmp4_ = view_collection_get_selected (_tmp3_);
		_g_object_unref0 (iter);
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable);
	} else {
		ViewCollection* _tmp5_;
		ViewCollection* _tmp6_;
		GeeCollection* _tmp7_;
		_tmp5_ = view;
		count = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection));
		_tmp6_ = view;
		_tmp7_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection));
		_g_object_unref0 (iter);
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable);
	}
	_tmp9_ = iter;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = count == 0;
	}
	if (_tmp8_) {
		_g_object_unref0 (iter);
		_data_collection_unref0 (view);
		return;
	}
	if (count == 1) {
		{
			GeeIterator* _item_it = NULL;
			GeeIterable* _tmp10_;
			GeeIterator* _tmp11_;
			_tmp10_ = iter;
			_tmp11_ = gee_iterable_iterator (_tmp10_);
			_item_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				DataView* item = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				DataView* _tmp15_;
				_tmp12_ = _item_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _item_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				item = (DataView*) _tmp14_;
				_tmp15_ = item;
				properties_get_single_properties (self, _tmp15_);
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (_item_it);
		}
	} else {
		GeeIterable* _tmp16_;
		_tmp16_ = iter;
		properties_get_multiple_properties (self, _tmp16_);
	}
	_g_object_unref0 (iter);
	_data_collection_unref0 (view);
}

void
properties_get_properties (Properties* self,
                           Page* current_page)
{
	PropertiesClass* _klass_;
	g_return_if_fail (IS_PROPERTIES (self));
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_properties) {
		_klass_->get_properties (self, current_page);
	}
}

static void
properties_real_clear_properties (Properties* self)
{
	GtkGrid* _tmp0_;
	GList* _tmp1_;
	_tmp0_ = self->grid;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* child = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp2_;
			{
				GtkGrid* _tmp3_;
				GtkWidget* _tmp4_;
				_tmp3_ = self->grid;
				_tmp4_ = child;
				gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), _tmp4_);
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	self->line_count = (guint) 0;
}

void
properties_clear_properties (Properties* self)
{
	PropertiesClass* _klass_;
	g_return_if_fail (IS_PROPERTIES (self));
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->clear_properties) {
		_klass_->clear_properties (self);
	}
}

void
properties_update_properties (Properties* self,
                              Page* page)
{
	g_return_if_fail (IS_PROPERTIES (self));
	g_return_if_fail (IS_PAGE (page));
	properties_clear_properties (self);
	properties_internal_update_properties (self, page);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
properties_real_internal_update_properties (Properties* self,
                                            Page* page)
{
	g_return_if_fail (IS_PAGE (page));
	properties_get_properties (self, page);
}

void
properties_internal_update_properties (Properties* self,
                                       Page* page)
{
	PropertiesClass* _klass_;
	g_return_if_fail (IS_PROPERTIES (self));
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->internal_update_properties) {
		_klass_->internal_update_properties (self, page);
	}
}

static void
properties_class_init (PropertiesClass * klass,
                       gpointer klass_data)
{
	properties_parent_class = g_type_class_peek_parent (klass);
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) properties_real_get_single_properties;
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties*, GeeIterable*)) properties_real_get_multiple_properties;
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties*, Page*)) properties_real_get_properties;
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) properties_real_clear_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) properties_real_internal_update_properties;
	G_OBJECT_CLASS (klass)->finalize = properties_finalize;
}

static void
properties_instance_init (Properties * self,
                          gpointer klass)
{
	GtkGrid* _tmp0_;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	self->grid = _tmp0_;
	self->line_count = (guint) 0;
}

static void
properties_finalize (GObject * obj)
{
	Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTIES, Properties);
	_g_object_unref0 (self->grid);
	G_OBJECT_CLASS (properties_parent_class)->finalize (obj);
}

static GType
properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Properties), 0, (GInstanceInitFunc) properties_instance_init, NULL };
	GType properties_type_id;
	properties_type_id = g_type_register_static (gtk_box_get_type (), "Properties", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return properties_type_id;
}

GType
properties_get_type (void)
{
	static volatile gsize properties_type_id__once = 0;
	if (g_once_init_enter (&properties_type_id__once)) {
		GType properties_type_id;
		properties_type_id = properties_get_type_once ();
		g_once_init_leave (&properties_type_id__once, properties_type_id);
	}
	return properties_type_id__once;
}

static inline gpointer
basic_properties_get_instance_private (BasicProperties* self)
{
	return G_STRUCT_MEMBER_P (self, BasicProperties_private_offset);
}

BasicProperties*
basic_properties_construct (GType object_type)
{
	BasicProperties * self = NULL;
	self = (BasicProperties*) properties_construct (object_type);
	return self;
}

BasicProperties*
basic_properties_new (void)
{
	return basic_properties_construct (TYPE_BASIC_PROPERTIES);
}

static void
basic_properties_real_clear_properties (Properties* base)
{
	BasicProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
	PROPERTIES_CLASS (basic_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->title);
	self->priv->title = _tmp0_;
	_g_date_time_unref0 (self->priv->start_time);
	self->priv->start_time = NULL;
	_g_date_time_unref0 (self->priv->end_time);
	self->priv->end_time = NULL;
	dimensions_init (&self->priv->dimensions, 0, 0);
	self->priv->photo_count = -1;
	self->priv->event_count = -1;
	self->priv->video_count = -1;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->exposure);
	self->priv->exposure = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->aperture);
	self->priv->aperture = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->iso);
	self->priv->iso = _tmp3_;
	self->priv->clip_duration = 0.0;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->raw_developer);
	self->priv->raw_developer = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->raw_assoc);
	self->priv->raw_assoc = _tmp5_;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

static void
basic_properties_real_get_single_properties (Properties* base,
                                             DataView* view)
{
	BasicProperties * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DataSource* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
	g_return_if_fail (IS_DATA_VIEW (view));
	PROPERTIES_CLASS (basic_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
	_tmp0_ = data_view_get_source (view);
	source = _tmp0_;
	_tmp1_ = source;
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
	_g_free0 (self->priv->title);
	self->priv->title = _tmp2_;
	_tmp4_ = source;
	if (IS_PHOTO_SOURCE (_tmp4_)) {
		_tmp3_ = TRUE;
	} else {
		DataSource* _tmp5_;
		_tmp5_ = source;
		_tmp3_ = IS_PHOTO_IMPORT_SOURCE (_tmp5_);
	}
	if (_tmp3_) {
		GDateTime* _tmp6_ = NULL;
		DataSource* _tmp7_;
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		PhotoMetadata* _tmp15_ = NULL;
		DataSource* _tmp16_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp21_;
		PhotoMetadata* _tmp22_;
		DataSource* _tmp46_;
		gboolean _tmp49_ = FALSE;
		DataSource* _tmp50_;
		_tmp7_ = source;
		if (IS_PHOTO_SOURCE (_tmp7_)) {
			DataSource* _tmp8_;
			GDateTime* _tmp9_;
			_tmp8_ = source;
			_tmp9_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
			_g_date_time_unref0 (_tmp6_);
			_tmp6_ = _tmp9_;
		} else {
			DataSource* _tmp10_;
			GDateTime* _tmp11_;
			_tmp10_ = source;
			_tmp11_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
			_g_date_time_unref0 (_tmp6_);
			_tmp6_ = _tmp11_;
		}
		_tmp12_ = _g_date_time_ref0 (_tmp6_);
		_g_date_time_unref0 (self->priv->start_time);
		self->priv->start_time = _tmp12_;
		_tmp13_ = self->priv->start_time;
		_tmp14_ = _g_date_time_ref0 (_tmp13_);
		_g_date_time_unref0 (self->priv->end_time);
		self->priv->end_time = _tmp14_;
		_tmp16_ = source;
		if (IS_PHOTO_SOURCE (_tmp16_)) {
			DataSource* _tmp17_;
			PhotoMetadata* _tmp18_;
			_tmp17_ = source;
			_tmp18_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_SOURCE, PhotoSource));
			_media_metadata_unref0 (_tmp15_);
			_tmp15_ = _tmp18_;
		} else {
			DataSource* _tmp19_;
			PhotoMetadata* _tmp20_;
			_tmp19_ = source;
			_tmp20_ = photo_import_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
			_media_metadata_unref0 (_tmp15_);
			_tmp15_ = _tmp20_;
		}
		_tmp21_ = _media_metadata_ref0 (_tmp15_);
		metadata = _tmp21_;
		_tmp22_ = metadata;
		if (_tmp22_ != NULL) {
			PhotoMetadata* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			PhotoMetadata* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			PhotoMetadata* _tmp31_;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			Dimensions _tmp35_ = {0};
			PhotoMetadata* _tmp36_;
			Dimensions* _tmp37_;
			Dimensions* _tmp38_;
			gboolean _tmp39_;
			_tmp23_ = metadata;
			_tmp24_ = photo_metadata_get_exposure_string (_tmp23_);
			_g_free0 (self->priv->exposure);
			self->priv->exposure = _tmp24_;
			_tmp25_ = self->priv->exposure;
			if (_tmp25_ == NULL) {
				gchar* _tmp26_;
				_tmp26_ = g_strdup ("");
				_g_free0 (self->priv->exposure);
				self->priv->exposure = _tmp26_;
			}
			_tmp27_ = metadata;
			_tmp28_ = photo_metadata_get_aperture_string (_tmp27_, TRUE);
			_g_free0 (self->priv->aperture);
			self->priv->aperture = _tmp28_;
			_tmp29_ = self->priv->aperture;
			if (_tmp29_ == NULL) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("");
				_g_free0 (self->priv->aperture);
				self->priv->aperture = _tmp30_;
			}
			_tmp31_ = metadata;
			_tmp32_ = photo_metadata_get_iso_string (_tmp31_);
			_g_free0 (self->priv->iso);
			self->priv->iso = _tmp32_;
			_tmp33_ = self->priv->iso;
			if (_tmp33_ == NULL) {
				gchar* _tmp34_;
				_tmp34_ = g_strdup ("");
				_g_free0 (self->priv->iso);
				self->priv->iso = _tmp34_;
			}
			_tmp36_ = metadata;
			_tmp37_ = photo_metadata_get_pixel_dimensions (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_ != NULL;
			_dimensions_free0 (_tmp38_);
			if (_tmp39_) {
				PhotoMetadata* _tmp40_;
				PhotoMetadata* _tmp41_;
				Dimensions* _tmp42_;
				Dimensions* _tmp43_;
				Dimensions _tmp44_;
				Dimensions _tmp45_ = {0};
				_tmp40_ = metadata;
				_tmp41_ = metadata;
				_tmp42_ = photo_metadata_get_pixel_dimensions (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = *_tmp43_;
				orientation_rotate_dimensions (photo_metadata_get_orientation (_tmp40_), &_tmp44_, &_tmp45_);
				_tmp35_ = _tmp45_;
				_dimensions_free0 (_tmp43_);
			} else {
				dimensions_init (&_tmp35_, 0, 0);
			}
			self->priv->dimensions = _tmp35_;
		}
		_tmp46_ = source;
		if (IS_PHOTO_SOURCE (_tmp46_)) {
			DataSource* _tmp47_;
			Dimensions _tmp48_ = {0};
			_tmp47_ = source;
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp48_);
			self->priv->dimensions = _tmp48_;
		}
		_tmp50_ = source;
		if (IS_PHOTO (_tmp50_)) {
			DataSource* _tmp51_;
			_tmp51_ = source;
			_tmp49_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_RAW;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			Photo* photo = NULL;
			DataSource* _tmp52_;
			Photo* _tmp53_;
			Photo* _tmp54_;
			gchar* _tmp55_;
			const gchar* _tmp56_ = NULL;
			Photo* _tmp57_;
			gchar* _tmp58_;
			_tmp52_ = source;
			_tmp53_ = _g_object_ref0 (IS_PHOTO (_tmp52_) ? ((Photo*) _tmp52_) : NULL);
			photo = _tmp53_;
			_tmp54_ = photo;
			_tmp55_ = raw_developer_get_label (photo_get_raw_developer (_tmp54_));
			_g_free0 (self->priv->raw_developer);
			self->priv->raw_developer = _tmp55_;
			_tmp57_ = photo;
			if (photo_is_raw_developer_available (_tmp57_, RAW_DEVELOPER_CAMERA)) {
				_tmp56_ = _ ("RAW+JPEG");
			} else {
				_tmp56_ = "";
			}
			_tmp58_ = g_strdup (_tmp56_);
			_g_free0 (self->priv->raw_assoc);
			self->priv->raw_assoc = _tmp58_;
			_g_object_unref0 (photo);
		}
		_media_metadata_unref0 (metadata);
		_media_metadata_unref0 (_tmp15_);
		_g_date_time_unref0 (_tmp6_);
	} else {
		DataSource* _tmp59_;
		_tmp59_ = source;
		if (IS_EVENT_SOURCE (_tmp59_)) {
			EventSource* event_source = NULL;
			DataSource* _tmp60_;
			EventSource* _tmp61_;
			EventSource* _tmp62_;
			GDateTime* _tmp63_;
			EventSource* _tmp64_;
			GDateTime* _tmp65_;
			gint event_photo_count = 0;
			gint event_video_count = 0;
			EventSource* _tmp66_;
			GeeCollection* _tmp67_;
			GeeCollection* _tmp68_;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			_tmp60_ = source;
			_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_EVENT_SOURCE, EventSource));
			event_source = _tmp61_;
			_tmp62_ = event_source;
			_tmp63_ = event_source_get_start_time (_tmp62_);
			_g_date_time_unref0 (self->priv->start_time);
			self->priv->start_time = _tmp63_;
			_tmp64_ = event_source;
			_tmp65_ = event_source_get_end_time (_tmp64_);
			_g_date_time_unref0 (self->priv->end_time);
			self->priv->end_time = _tmp65_;
			_tmp66_ = event_source;
			_tmp67_ = event_source_get_media (_tmp66_);
			_tmp68_ = _tmp67_;
			media_source_collection_count_media (_tmp68_, &_tmp69_, &_tmp70_);
			event_photo_count = _tmp69_;
			event_video_count = _tmp70_;
			_g_object_unref0 (_tmp68_);
			self->priv->photo_count = event_photo_count;
			self->priv->video_count = event_video_count;
			_g_object_unref0 (event_source);
		} else {
			gboolean _tmp71_ = FALSE;
			DataSource* _tmp72_;
			_tmp72_ = source;
			if (IS_VIDEO_SOURCE (_tmp72_)) {
				_tmp71_ = TRUE;
			} else {
				DataSource* _tmp73_;
				_tmp73_ = source;
				_tmp71_ = IS_VIDEO_IMPORT_SOURCE (_tmp73_);
			}
			if (_tmp71_) {
				DataSource* _tmp74_;
				GDateTime* _tmp85_;
				GDateTime* _tmp86_;
				_tmp74_ = source;
				if (IS_VIDEO_SOURCE (_tmp74_)) {
					Video* video = NULL;
					DataSource* _tmp75_;
					Video* _tmp76_;
					Video* _tmp77_;
					Video* _tmp78_;
					Video* _tmp81_;
					GDateTime* _tmp82_;
					_tmp75_ = source;
					_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, TYPE_VIDEO, Video));
					video = _tmp76_;
					_tmp77_ = video;
					self->priv->clip_duration = video_get_clip_duration (_tmp77_);
					_tmp78_ = video;
					if (video_get_is_interpretable (_tmp78_)) {
						Video* _tmp79_;
						Dimensions _tmp80_ = {0};
						_tmp79_ = video;
						video_get_frame_dimensions (_tmp79_, &_tmp80_);
						self->priv->dimensions = _tmp80_;
					}
					_tmp81_ = video;
					_tmp82_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, TYPE_MEDIA_SOURCE, MediaSource));
					_g_date_time_unref0 (self->priv->start_time);
					self->priv->start_time = _tmp82_;
					_g_object_unref0 (video);
				} else {
					DataSource* _tmp83_;
					GDateTime* _tmp84_;
					_tmp83_ = source;
					_tmp84_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
					_g_date_time_unref0 (self->priv->start_time);
					self->priv->start_time = _tmp84_;
				}
				_tmp85_ = self->priv->start_time;
				_tmp86_ = _g_date_time_ref0 (_tmp85_);
				_g_date_time_unref0 (self->priv->end_time);
				self->priv->end_time = _tmp86_;
			}
		}
	}
	_g_object_unref0 (source);
}

static void
basic_properties_real_get_multiple_properties (Properties* base,
                                               GeeIterable* iter)
{
	BasicProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
	g_return_if_fail ((iter == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (iter, GEE_TYPE_ITERABLE));
	PROPERTIES_CLASS (basic_properties_parent_class)->get_multiple_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), iter);
	self->priv->photo_count = 0;
	self->priv->video_count = 0;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (iter);
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* source = NULL;
			DataView* _tmp4_;
			DataSource* _tmp5_;
			gboolean _tmp6_ = FALSE;
			DataSource* _tmp7_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			_tmp5_ = data_view_get_source (_tmp4_);
			source = _tmp5_;
			_tmp7_ = source;
			if (IS_PHOTO_SOURCE (_tmp7_)) {
				_tmp6_ = TRUE;
			} else {
				DataSource* _tmp8_;
				_tmp8_ = source;
				_tmp6_ = IS_PHOTO_IMPORT_SOURCE (_tmp8_);
			}
			if (_tmp6_) {
				GDateTime* _tmp9_ = NULL;
				DataSource* _tmp10_;
				GDateTime* exposure_time = NULL;
				GDateTime* _tmp15_;
				GDateTime* _tmp16_;
				gint _tmp29_;
				_tmp10_ = source;
				if (IS_PHOTO_SOURCE (_tmp10_)) {
					DataSource* _tmp11_;
					GDateTime* _tmp12_;
					_tmp11_ = source;
					_tmp12_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
					_g_date_time_unref0 (_tmp9_);
					_tmp9_ = _tmp12_;
				} else {
					DataSource* _tmp13_;
					GDateTime* _tmp14_;
					_tmp13_ = source;
					_tmp14_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
					_g_date_time_unref0 (_tmp9_);
					_tmp9_ = _tmp14_;
				}
				_tmp15_ = _g_date_time_ref0 (_tmp9_);
				exposure_time = _tmp15_;
				_tmp16_ = exposure_time;
				if (_tmp16_ != NULL) {
					gboolean _tmp17_ = FALSE;
					GDateTime* _tmp18_;
					gboolean _tmp23_ = FALSE;
					GDateTime* _tmp24_;
					_tmp18_ = self->priv->start_time;
					if (_tmp18_ == NULL) {
						_tmp17_ = TRUE;
					} else {
						GDateTime* _tmp19_;
						GDateTime* _tmp20_;
						_tmp19_ = exposure_time;
						_tmp20_ = self->priv->start_time;
						_tmp17_ = g_date_time_compare (_tmp19_, _tmp20_) < 0;
					}
					if (_tmp17_) {
						GDateTime* _tmp21_;
						GDateTime* _tmp22_;
						_tmp21_ = exposure_time;
						_tmp22_ = _g_date_time_ref0 (_tmp21_);
						_g_date_time_unref0 (self->priv->start_time);
						self->priv->start_time = _tmp22_;
					}
					_tmp24_ = self->priv->end_time;
					if (_tmp24_ == NULL) {
						_tmp23_ = TRUE;
					} else {
						GDateTime* _tmp25_;
						GDateTime* _tmp26_;
						_tmp25_ = exposure_time;
						_tmp26_ = self->priv->end_time;
						_tmp23_ = g_date_time_compare (_tmp25_, _tmp26_) > 0;
					}
					if (_tmp23_) {
						GDateTime* _tmp27_;
						GDateTime* _tmp28_;
						_tmp27_ = exposure_time;
						_tmp28_ = _g_date_time_ref0 (_tmp27_);
						_g_date_time_unref0 (self->priv->end_time);
						self->priv->end_time = _tmp28_;
					}
				}
				_tmp29_ = self->priv->photo_count;
				self->priv->photo_count = _tmp29_ + 1;
				_g_date_time_unref0 (exposure_time);
				_g_date_time_unref0 (_tmp9_);
			} else {
				DataSource* _tmp30_;
				_tmp30_ = source;
				if (IS_EVENT_SOURCE (_tmp30_)) {
					EventSource* event_source = NULL;
					DataSource* _tmp31_;
					EventSource* _tmp32_;
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
					GDateTime* _tmp35_;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp46_ = FALSE;
					GDateTime* _tmp47_;
					gint event_photo_count = 0;
					gint event_video_count = 0;
					EventSource* _tmp65_;
					GeeCollection* _tmp66_;
					GeeCollection* _tmp67_;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					gint _tmp70_;
					_tmp31_ = source;
					_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_EVENT_SOURCE, EventSource));
					event_source = _tmp32_;
					if (self->priv->event_count == -1) {
						self->priv->event_count = 0;
					}
					_tmp35_ = self->priv->start_time;
					if (_tmp35_ == NULL) {
						_tmp34_ = TRUE;
					} else {
						EventSource* _tmp36_;
						GDateTime* _tmp37_;
						GDateTime* _tmp38_;
						GDateTime* _tmp39_;
						_tmp36_ = event_source;
						_tmp37_ = event_source_get_start_time (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = self->priv->start_time;
						_tmp34_ = g_date_time_compare (_tmp38_, _tmp39_) < 0;
						_g_date_time_unref0 (_tmp38_);
					}
					if (_tmp34_) {
						EventSource* _tmp40_;
						GDateTime* _tmp41_;
						GDateTime* _tmp42_;
						_tmp40_ = event_source;
						_tmp41_ = event_source_get_start_time (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp33_ = _tmp42_ != NULL;
						_g_date_time_unref0 (_tmp42_);
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						EventSource* _tmp43_;
						GDateTime* _tmp44_;
						_tmp43_ = event_source;
						_tmp44_ = event_source_get_start_time (_tmp43_);
						_g_date_time_unref0 (self->priv->start_time);
						self->priv->start_time = _tmp44_;
					}
					_tmp47_ = self->priv->end_time;
					if (_tmp47_ == NULL) {
						_tmp46_ = TRUE;
					} else {
						EventSource* _tmp48_;
						GDateTime* _tmp49_;
						GDateTime* _tmp50_;
						GDateTime* _tmp51_;
						_tmp48_ = event_source;
						_tmp49_ = event_source_get_end_time (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp51_ = self->priv->end_time;
						_tmp46_ = g_date_time_compare (_tmp50_, _tmp51_) > 0;
						_g_date_time_unref0 (_tmp50_);
					}
					if (_tmp46_) {
						EventSource* _tmp52_;
						GDateTime* _tmp53_;
						GDateTime* _tmp54_;
						_tmp52_ = event_source;
						_tmp53_ = event_source_get_end_time (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp45_ = _tmp54_ != NULL;
						_g_date_time_unref0 (_tmp54_);
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						EventSource* _tmp55_;
						GDateTime* _tmp56_;
						_tmp55_ = event_source;
						_tmp56_ = event_source_get_end_time (_tmp55_);
						_g_date_time_unref0 (self->priv->end_time);
						self->priv->end_time = _tmp56_;
					} else {
						gboolean _tmp57_ = FALSE;
						GDateTime* _tmp58_;
						_tmp58_ = self->priv->end_time;
						if (_tmp58_ == NULL) {
							_tmp57_ = TRUE;
						} else {
							EventSource* _tmp59_;
							GDateTime* _tmp60_;
							GDateTime* _tmp61_;
							GDateTime* _tmp62_;
							_tmp59_ = event_source;
							_tmp60_ = event_source_get_start_time (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = self->priv->end_time;
							_tmp57_ = g_date_time_compare (_tmp61_, _tmp62_) > 0;
							_g_date_time_unref0 (_tmp61_);
						}
						if (_tmp57_) {
							EventSource* _tmp63_;
							GDateTime* _tmp64_;
							_tmp63_ = event_source;
							_tmp64_ = event_source_get_start_time (_tmp63_);
							_g_date_time_unref0 (self->priv->end_time);
							self->priv->end_time = _tmp64_;
						}
					}
					_tmp65_ = event_source;
					_tmp66_ = event_source_get_media (_tmp65_);
					_tmp67_ = _tmp66_;
					media_source_collection_count_media (_tmp67_, &_tmp68_, &_tmp69_);
					event_photo_count = _tmp68_;
					event_video_count = _tmp69_;
					_g_object_unref0 (_tmp67_);
					self->priv->photo_count = self->priv->photo_count + event_photo_count;
					self->priv->video_count = self->priv->video_count + event_video_count;
					_tmp70_ = self->priv->event_count;
					self->priv->event_count = _tmp70_ + 1;
					_g_object_unref0 (event_source);
				} else {
					gboolean _tmp71_ = FALSE;
					DataSource* _tmp72_;
					_tmp72_ = source;
					if (IS_VIDEO_SOURCE (_tmp72_)) {
						_tmp71_ = TRUE;
					} else {
						DataSource* _tmp73_;
						_tmp73_ = source;
						_tmp71_ = IS_VIDEO_IMPORT_SOURCE (_tmp73_);
					}
					if (_tmp71_) {
						GDateTime* _tmp74_ = NULL;
						DataSource* _tmp75_;
						GDateTime* exposure_time = NULL;
						GDateTime* _tmp80_;
						GDateTime* _tmp81_;
						gint _tmp94_;
						_tmp75_ = source;
						if (IS_VIDEO_SOURCE (_tmp75_)) {
							DataSource* _tmp76_;
							GDateTime* _tmp77_;
							_tmp76_ = source;
							_tmp77_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_VIDEO_SOURCE, VideoSource), TYPE_MEDIA_SOURCE, MediaSource));
							_g_date_time_unref0 (_tmp74_);
							_tmp74_ = _tmp77_;
						} else {
							DataSource* _tmp78_;
							GDateTime* _tmp79_;
							_tmp78_ = source;
							_tmp79_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
							_g_date_time_unref0 (_tmp74_);
							_tmp74_ = _tmp79_;
						}
						_tmp80_ = _g_date_time_ref0 (_tmp74_);
						exposure_time = _tmp80_;
						_tmp81_ = exposure_time;
						if (_tmp81_ != NULL) {
							gboolean _tmp82_ = FALSE;
							GDateTime* _tmp83_;
							gboolean _tmp88_ = FALSE;
							GDateTime* _tmp89_;
							_tmp83_ = self->priv->start_time;
							if (_tmp83_ == NULL) {
								_tmp82_ = TRUE;
							} else {
								GDateTime* _tmp84_;
								GDateTime* _tmp85_;
								_tmp84_ = exposure_time;
								_tmp85_ = self->priv->start_time;
								_tmp82_ = g_date_time_compare (_tmp84_, _tmp85_) < 0;
							}
							if (_tmp82_) {
								GDateTime* _tmp86_;
								GDateTime* _tmp87_;
								_tmp86_ = exposure_time;
								_tmp87_ = _g_date_time_ref0 (_tmp86_);
								_g_date_time_unref0 (self->priv->start_time);
								self->priv->start_time = _tmp87_;
							}
							_tmp89_ = self->priv->end_time;
							if (_tmp89_ == NULL) {
								_tmp88_ = TRUE;
							} else {
								GDateTime* _tmp90_;
								GDateTime* _tmp91_;
								_tmp90_ = exposure_time;
								_tmp91_ = self->priv->end_time;
								_tmp88_ = g_date_time_compare (_tmp90_, _tmp91_) > 0;
							}
							if (_tmp88_) {
								GDateTime* _tmp92_;
								GDateTime* _tmp93_;
								_tmp92_ = exposure_time;
								_tmp93_ = _g_date_time_ref0 (_tmp92_);
								_g_date_time_unref0 (self->priv->end_time);
								self->priv->end_time = _tmp93_;
							}
						}
						_tmp94_ = self->priv->video_count;
						self->priv->video_count = _tmp94_ + 1;
						_g_date_time_unref0 (exposure_time);
						_g_date_time_unref0 (_tmp74_);
					}
				}
			}
			_g_object_unref0 (source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
}

static void
basic_properties_real_get_properties (Properties* base,
                                      Page* current_page)
{
	BasicProperties * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
	g_return_if_fail (IS_PAGE (current_page));
	PROPERTIES_CLASS (basic_properties_parent_class)->get_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), current_page);
	_tmp0_ = self->priv->end_time;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = self->priv->start_time;
		_tmp2_ = _g_date_time_ref0 (_tmp1_);
		_g_date_time_unref0 (self->priv->end_time);
		self->priv->end_time = _tmp2_;
	}
	_tmp3_ = self->priv->start_time;
	if (_tmp3_ == NULL) {
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp4_ = self->priv->end_time;
		_tmp5_ = _g_date_time_ref0 (_tmp4_);
		_g_date_time_unref0 (self->priv->start_time);
		self->priv->start_time = _tmp5_;
	}
}

static void
basic_properties_real_internal_update_properties (Properties* base,
                                                  Page* page)
{
	BasicProperties * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gboolean _tmp9_ = FALSE;
	GDateTime* _tmp23_;
	const gchar* _tmp63_;
	const gchar* _tmp65_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	const gchar* _tmp69_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
	g_return_if_fail (IS_PAGE (page));
	PROPERTIES_CLASS (basic_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
	_tmp1_ = self->priv->title;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		_tmp0_ = IS_TAG_PAGE (page);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Tag* _tmp2_;
		Tag* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = tag_page_get_tag (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_TAG_PAGE, TagPage));
		_tmp3_ = _tmp2_;
		_tmp4_ = tag_get_user_visible_name (_tmp3_);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp4_;
		_g_object_unref0 (_tmp3_);
	}
	_tmp5_ = self->priv->title;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->title;
		_tmp7_ = guarded_markup_escape_text (_tmp6_);
		_tmp8_ = _tmp7_;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Title:"), _tmp8_, FALSE, NULL);
		_g_free0 (_tmp8_);
	}
	if (self->priv->photo_count >= 0) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = self->priv->video_count >= 0;
	}
	if (_tmp9_) {
		gchar* label = NULL;
		gchar* _tmp10_;
		gchar* photo_num_string = NULL;
		gchar* _tmp15_;
		gchar* video_num_string = NULL;
		gchar* _tmp16_;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp10_ = g_strdup (_ ("Items:"));
		label = _tmp10_;
		if (self->priv->event_count >= 0) {
			gchar* event_num_string = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = g_strdup_printf (ngettext ("%d Event", "%d Events", (gulong) self->priv->event_count), self->priv->event_count);
			event_num_string = _tmp11_;
			_tmp12_ = label;
			_tmp13_ = event_num_string;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp12_, _tmp13_, FALSE, NULL);
			_tmp14_ = g_strdup ("");
			_g_free0 (label);
			label = _tmp14_;
			_g_free0 (event_num_string);
		}
		_tmp15_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) self->priv->photo_count), self->priv->photo_count);
		photo_num_string = _tmp15_;
		_tmp16_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) self->priv->video_count), self->priv->video_count);
		video_num_string = _tmp16_;
		if (self->priv->photo_count == 0) {
			_tmp17_ = self->priv->video_count > 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = label;
			_tmp19_ = video_num_string;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp18_, _tmp19_, FALSE, NULL);
			_g_free0 (video_num_string);
			_g_free0 (photo_num_string);
			_g_free0 (label);
			return;
		}
		_tmp20_ = label;
		_tmp21_ = photo_num_string;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp20_, _tmp21_, FALSE, NULL);
		if (self->priv->video_count > 0) {
			const gchar* _tmp22_;
			_tmp22_ = video_num_string;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp22_, FALSE, NULL);
		}
		_g_free0 (video_num_string);
		_g_free0 (photo_num_string);
		_g_free0 (label);
	}
	_tmp23_ = self->priv->start_time;
	if (_tmp23_ != NULL) {
		gchar* start_date = NULL;
		GDateTime* _tmp24_;
		GDateTime* _tmp25_;
		GDateTime* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* start_time = NULL;
		GDateTime* _tmp29_;
		GDateTime* _tmp30_;
		GDateTime* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* end_date = NULL;
		GDateTime* _tmp34_;
		GDateTime* _tmp35_;
		GDateTime* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* end_time = NULL;
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		GDateTime* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp24_ = self->priv->start_time;
		_tmp25_ = g_date_time_to_local (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp26_);
		_tmp28_ = _tmp27_;
		_g_date_time_unref0 (_tmp26_);
		start_date = _tmp28_;
		_tmp29_ = self->priv->start_time;
		_tmp30_ = g_date_time_to_local (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp31_);
		_tmp33_ = _tmp32_;
		_g_date_time_unref0 (_tmp31_);
		start_time = _tmp33_;
		_tmp34_ = self->priv->end_time;
		_tmp35_ = g_date_time_to_local (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp36_);
		_tmp38_ = _tmp37_;
		_g_date_time_unref0 (_tmp36_);
		end_date = _tmp38_;
		_tmp39_ = self->priv->end_time;
		_tmp40_ = g_date_time_to_local (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp41_);
		_tmp43_ = _tmp42_;
		_g_date_time_unref0 (_tmp41_);
		end_time = _tmp43_;
		_tmp44_ = start_date;
		_tmp45_ = end_date;
		if (g_strcmp0 (_tmp44_, _tmp45_) == 0) {
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp46_ = start_date;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Date:"), _tmp46_, FALSE, NULL);
			_tmp47_ = start_time;
			_tmp48_ = end_time;
			if (g_strcmp0 (_tmp47_, _tmp48_) == 0) {
				const gchar* _tmp49_;
				_tmp49_ = start_time;
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Time:"), _tmp49_, FALSE, NULL);
			} else {
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp50_ = start_time;
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("From:"), _tmp50_, FALSE, NULL);
				_tmp51_ = end_time;
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("To:"), _tmp51_, FALSE, NULL);
			}
		} else {
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			_tmp52_ = start_date;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("From:"), _tmp52_, FALSE, NULL);
			_tmp53_ = end_date;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("To:"), _tmp53_, FALSE, NULL);
		}
		_g_free0 (end_time);
		_g_free0 (end_date);
		_g_free0 (start_time);
		_g_free0 (start_date);
	}
	if (dimensions_has_area (&self->priv->dimensions)) {
		gchar* label = NULL;
		gchar* _tmp54_;
		_tmp54_ = g_strdup (_ ("Size:"));
		label = _tmp54_;
		if (dimensions_has_area (&self->priv->dimensions)) {
			const gchar* _tmp55_;
			Dimensions _tmp56_;
			Dimensions _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp55_ = label;
			_tmp56_ = self->priv->dimensions;
			_tmp57_ = self->priv->dimensions;
			_tmp58_ = g_strdup_printf ("%d &#215; %d", _tmp56_.width, _tmp57_.height);
			_tmp59_ = _tmp58_;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp55_, _tmp59_, FALSE, NULL);
			_g_free0 (_tmp59_);
			_tmp60_ = g_strdup ("");
			_g_free0 (label);
			label = _tmp60_;
		}
		_g_free0 (label);
	}
	if (self->priv->clip_duration > 0.0) {
		gchar* _tmp61_;
		gchar* _tmp62_;
		_tmp61_ = g_strdup_printf (_ ("%.1f seconds"), self->priv->clip_duration);
		_tmp62_ = _tmp61_;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Duration:"), _tmp62_, FALSE, NULL);
		_g_free0 (_tmp62_);
	}
	_tmp63_ = self->priv->raw_developer;
	if (g_strcmp0 (_tmp63_, "") != 0) {
		const gchar* _tmp64_;
		_tmp64_ = self->priv->raw_developer;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Developer:"), _tmp64_, FALSE, NULL);
	}
	_tmp65_ = self->priv->raw_assoc;
	if (g_strcmp0 (_tmp65_, "") != 0) {
		const gchar* _tmp66_;
		_tmp66_ = self->priv->raw_assoc;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp66_, FALSE, NULL);
	}
	_tmp69_ = self->priv->exposure;
	if (g_strcmp0 (_tmp69_, "") != 0) {
		_tmp68_ = TRUE;
	} else {
		const gchar* _tmp70_;
		_tmp70_ = self->priv->aperture;
		_tmp68_ = g_strcmp0 (_tmp70_, "") != 0;
	}
	if (_tmp68_) {
		_tmp67_ = TRUE;
	} else {
		const gchar* _tmp71_;
		_tmp71_ = self->priv->iso;
		_tmp67_ = g_strcmp0 (_tmp71_, "") != 0;
	}
	if (_tmp67_) {
		gchar* line = NULL;
		const gchar* _tmp72_;
		const gchar* _tmp75_;
		gboolean _tmp84_ = FALSE;
		gboolean _tmp85_ = FALSE;
		const gchar* _tmp86_;
		line = NULL;
		_tmp72_ = self->priv->exposure;
		if (g_strcmp0 (_tmp72_, "") != 0) {
			const gchar* _tmp73_;
			gchar* _tmp74_;
			_tmp73_ = self->priv->exposure;
			_tmp74_ = g_strdup (_tmp73_);
			_g_free0 (line);
			line = _tmp74_;
		}
		_tmp75_ = self->priv->aperture;
		if (g_strcmp0 (_tmp75_, "") != 0) {
			const gchar* _tmp76_;
			_tmp76_ = line;
			if (_tmp76_ != NULL) {
				const gchar* _tmp77_;
				const gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp77_ = line;
				_tmp78_ = self->priv->aperture;
				_tmp79_ = g_strconcat (", ", _tmp78_, NULL);
				_tmp80_ = _tmp79_;
				_tmp81_ = g_strconcat (_tmp77_, _tmp80_, NULL);
				_g_free0 (line);
				line = _tmp81_;
				_g_free0 (_tmp80_);
			} else {
				const gchar* _tmp82_;
				gchar* _tmp83_;
				_tmp82_ = self->priv->aperture;
				_tmp83_ = g_strdup (_tmp82_);
				_g_free0 (line);
				line = _tmp83_;
			}
		}
		_tmp86_ = self->priv->exposure;
		if (g_strcmp0 (_tmp86_, "") == 0) {
			_tmp85_ = TRUE;
		} else {
			const gchar* _tmp87_;
			_tmp87_ = self->priv->aperture;
			_tmp85_ = g_strcmp0 (_tmp87_, "") == 0;
		}
		if (_tmp85_) {
			const gchar* _tmp88_;
			_tmp88_ = self->priv->iso;
			_tmp84_ = g_strcmp0 (_tmp88_, "") != 0;
		} else {
			_tmp84_ = FALSE;
		}
		if (_tmp84_) {
			const gchar* _tmp89_;
			const gchar* _tmp97_;
			_tmp89_ = line;
			if (_tmp89_ != NULL) {
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				_tmp90_ = line;
				_tmp91_ = self->priv->iso;
				_tmp92_ = g_strconcat (", " "ISO ", _tmp91_, NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = g_strconcat (_tmp90_, _tmp93_, NULL);
				_g_free0 (line);
				line = _tmp94_;
				_g_free0 (_tmp93_);
			} else {
				const gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp95_ = self->priv->iso;
				_tmp96_ = g_strconcat ("ISO ", _tmp95_, NULL);
				_g_free0 (line);
				line = _tmp96_;
			}
			_tmp97_ = line;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp97_, FALSE, NULL);
		} else {
			const gchar* _tmp98_;
			const gchar* _tmp100_;
			_tmp98_ = line;
			if (_tmp98_ != NULL) {
				const gchar* _tmp99_;
				_tmp99_ = line;
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp99_, FALSE, NULL);
			}
			_tmp100_ = self->priv->iso;
			if (g_strcmp0 (_tmp100_, "") != 0) {
				const gchar* _tmp101_;
				_tmp101_ = line;
				if (_tmp101_ != NULL) {
					const gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					_tmp102_ = self->priv->iso;
					_tmp103_ = g_strconcat ("ISO ", _tmp102_, NULL);
					_tmp104_ = _tmp103_;
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp104_, FALSE, NULL);
					_g_free0 (_tmp104_);
				} else {
					const gchar* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					_tmp105_ = self->priv->iso;
					_tmp106_ = g_strconcat ("ISO ", _tmp105_, NULL);
					_tmp107_ = _tmp106_;
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp107_, FALSE, NULL);
					_g_free0 (_tmp107_);
				}
			}
		}
		_g_free0 (line);
	}
}

static void
basic_properties_class_init (BasicPropertiesClass * klass,
                             gpointer klass_data)
{
	basic_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BasicProperties_private_offset);
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) basic_properties_real_clear_properties;
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) basic_properties_real_get_single_properties;
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties*, GeeIterable*)) basic_properties_real_get_multiple_properties;
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties*, Page*)) basic_properties_real_get_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) basic_properties_real_internal_update_properties;
	G_OBJECT_CLASS (klass)->finalize = basic_properties_finalize;
}

static void
basic_properties_instance_init (BasicProperties * self,
                                gpointer klass)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self->priv = basic_properties_get_instance_private (self);
	_tmp0_ = g_date_time_new_now_utc ();
	self->priv->start_time = _tmp0_;
	_tmp1_ = g_date_time_new_now_utc ();
	self->priv->end_time = _tmp1_;
}

static void
basic_properties_finalize (GObject * obj)
{
	BasicProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASIC_PROPERTIES, BasicProperties);
	_g_free0 (self->priv->title);
	_g_date_time_unref0 (self->priv->start_time);
	_g_date_time_unref0 (self->priv->end_time);
	_g_free0 (self->priv->exposure);
	_g_free0 (self->priv->aperture);
	_g_free0 (self->priv->iso);
	_g_free0 (self->priv->raw_developer);
	_g_free0 (self->priv->raw_assoc);
	G_OBJECT_CLASS (basic_properties_parent_class)->finalize (obj);
}

static GType
basic_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BasicPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicProperties), 0, (GInstanceInitFunc) basic_properties_instance_init, NULL };
	GType basic_properties_type_id;
	basic_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "BasicProperties", &g_define_type_info, 0);
	BasicProperties_private_offset = g_type_add_instance_private (basic_properties_type_id, sizeof (BasicPropertiesPrivate));
	return basic_properties_type_id;
}

GType
basic_properties_get_type (void)
{
	static volatile gsize basic_properties_type_id__once = 0;
	if (g_once_init_enter (&basic_properties_type_id__once)) {
		GType basic_properties_type_id;
		basic_properties_type_id = basic_properties_get_type_once ();
		g_once_init_leave (&basic_properties_type_id__once, basic_properties_type_id);
	}
	return basic_properties_type_id__once;
}

static inline gpointer
extended_properties_get_instance_private (ExtendedProperties* self)
{
	return G_STRUCT_MEMBER_P (self, ExtendedProperties_private_offset);
}

ExtendedProperties*
extended_properties_construct (GType object_type)
{
	ExtendedProperties * self = NULL;
	GtkGrid* _tmp0_;
	self = (ExtendedProperties*) properties_construct (object_type);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties)->grid;
	gtk_grid_set_row_spacing (_tmp0_, 6);
	return self;
}

ExtendedProperties*
extended_properties_new (void)
{
	return extended_properties_construct (TYPE_EXTENDED_PROPERTIES);
}

static gpointer
_dimensions_dup0 (gpointer self)
{
	return self ? dimensions_dup (self) : NULL;
}

static void
extended_properties_real_clear_properties (Properties* base)
{
	ExtendedProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Dimensions _tmp2_ = {0};
	Dimensions* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES, ExtendedProperties);
	PROPERTIES_CLASS (extended_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->file_path);
	self->priv->file_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->development_path);
	self->priv->development_path = _tmp1_;
	self->priv->is_raw = FALSE;
	self->priv->filesize = (guint64) 0;
	dimensions_init (&_tmp2_, 0, 0);
	_tmp3_ = _dimensions_dup0 (&_tmp2_);
	_dimensions_free0 (self->priv->original_dim);
	self->priv->original_dim = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->camera_make);
	self->priv->camera_make = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->camera_model);
	self->priv->camera_model = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->flash);
	self->priv->flash = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->priv->focal_length);
	self->priv->focal_length = _tmp7_;
	self->priv->gps_lat = (gdouble) -1;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->priv->gps_lat_ref);
	self->priv->gps_lat_ref = _tmp8_;
	self->priv->gps_long = (gdouble) -1;
	_tmp9_ = g_strdup ("");
	_g_free0 (self->priv->gps_long_ref);
	self->priv->gps_long_ref = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (self->priv->artist);
	self->priv->artist = _tmp10_;
	_tmp11_ = g_strdup ("");
	_g_free0 (self->priv->copyright);
	self->priv->copyright = _tmp11_;
	_tmp12_ = g_strdup ("");
	_g_free0 (self->priv->software);
	self->priv->software = _tmp12_;
	_tmp13_ = g_strdup ("");
	_g_free0 (self->priv->exposure_bias);
	self->priv->exposure_bias = _tmp13_;
	_tmp14_ = g_strdup ("");
	_g_free0 (self->priv->exposure_date);
	self->priv->exposure_date = _tmp14_;
	_tmp15_ = g_strdup ("");
	_g_free0 (self->priv->exposure_time);
	self->priv->exposure_time = _tmp15_;
	_tmp16_ = g_strdup ("");
	_g_free0 (self->priv->comment);
	self->priv->comment = _tmp16_;
}

static void
extended_properties_real_get_single_properties (Properties* base,
                                                DataView* view)
{
	ExtendedProperties * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES, ExtendedProperties);
	g_return_if_fail (IS_DATA_VIEW (view));
	PROPERTIES_CLASS (extended_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
	_tmp0_ = data_view_get_source (view);
	source = _tmp0_;
	_tmp1_ = source;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (source);
		return;
	}
	_tmp2_ = source;
	if (IS_MEDIA_SOURCE (_tmp2_)) {
		MediaSource* media = NULL;
		DataSource* _tmp3_;
		MediaSource* _tmp4_;
		MediaSource* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		MediaSource* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		MediaSource* _tmp17_;
		Photo* photo = NULL;
		MediaSource* _tmp18_;
		Photo* _tmp19_;
		Photo* _tmp20_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp27_;
		PhotoMetadata* _tmp28_;
		MetadataDateTime* _tmp29_;
		MetadataDateTime* _tmp30_;
		gboolean _tmp31_;
		Photo* _tmp38_;
		PhotoMetadata* _tmp39_;
		Dimensions* _tmp40_;
		PhotoMetadata* _tmp41_;
		gchar* _tmp42_;
		PhotoMetadata* _tmp43_;
		gchar* _tmp44_;
		PhotoMetadata* _tmp45_;
		gchar* _tmp46_;
		PhotoMetadata* _tmp47_;
		gchar* _tmp48_;
		PhotoMetadata* _tmp49_;
		gdouble _tmp50_ = 0.0;
		gchar* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		gchar* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		PhotoMetadata* _tmp55_;
		gchar* _tmp56_;
		PhotoMetadata* _tmp57_;
		gchar* _tmp58_;
		PhotoMetadata* _tmp59_;
		gchar* _tmp60_;
		PhotoMetadata* _tmp61_;
		gchar* _tmp62_;
		GDateTime* exposure_time_obj = NULL;
		PhotoMetadata* _tmp63_;
		MetadataDateTime* _tmp64_;
		MetadataDateTime* _tmp65_;
		GDateTime* _tmp66_;
		GDateTime* _tmp67_;
		GDateTime* _tmp68_;
		GDateTime* _tmp69_;
		GDateTime* _tmp70_;
		gchar* _tmp71_;
		GDateTime* _tmp72_;
		GDateTime* _tmp73_;
		GDateTime* _tmp74_;
		gchar* _tmp75_;
		MediaSource* _tmp76_;
		gchar* _tmp77_;
		_tmp3_ = source;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE, MediaSource));
		media = _tmp4_;
		_tmp5_ = media;
		_tmp6_ = media_source_get_master_file (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_filename_display_name (_tmp9_);
		_g_free0 (self->priv->file_path);
		self->priv->file_path = _tmp10_;
		_g_free0 (_tmp9_);
		_g_object_unref0 (_tmp7_);
		_tmp11_ = media;
		_tmp12_ = media_source_get_file (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_filename_display_name (_tmp15_);
		_g_free0 (self->priv->development_path);
		self->priv->development_path = _tmp16_;
		_g_free0 (_tmp15_);
		_g_object_unref0 (_tmp13_);
		_tmp17_ = media;
		self->priv->filesize = media_source_get_master_filesize (_tmp17_);
		_tmp18_ = media;
		_tmp19_ = _g_object_ref0 (IS_PHOTO (_tmp18_) ? ((Photo*) _tmp18_) : NULL);
		photo = _tmp19_;
		_tmp20_ = photo;
		if (_tmp20_ == NULL) {
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			return;
		}
		{
			PhotoMetadata* _tmp21_ = NULL;
			Photo* _tmp22_;
			PhotoMetadata* _tmp23_;
			PhotoMetadata* _tmp24_;
			_tmp22_ = photo;
			_tmp23_ = photo_get_master_metadata (_tmp22_, &_inner_error0_);
			_tmp21_ = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp24_ = _tmp21_;
			_tmp21_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = _tmp24_;
			_media_metadata_unref0 (_tmp21_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			Photo* _tmp25_;
			PhotoMetadata* _tmp26_;
			g_clear_error (&_inner_error0_);
			_tmp25_ = photo;
			_tmp26_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO_SOURCE, PhotoSource));
			_media_metadata_unref0 (metadata);
			metadata = _tmp26_;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp27_ = metadata;
		if (_tmp27_ == NULL) {
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			return;
		}
		_tmp28_ = metadata;
		_tmp29_ = photo_metadata_get_exposure_date_time (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_ == NULL;
		_metadata_date_time_unref0 (_tmp30_);
		if (_tmp31_) {
			PhotoMetadata* _tmp32_;
			Photo* _tmp33_;
			GDateTime* _tmp34_;
			GDateTime* _tmp35_;
			MetadataDateTime* _tmp36_;
			MetadataDateTime* _tmp37_;
			_tmp32_ = metadata;
			_tmp33_ = photo;
			_tmp34_ = media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp35_ = _tmp34_;
			_tmp36_ = metadata_date_time_new (_tmp35_);
			_tmp37_ = _tmp36_;
			photo_metadata_set_exposure_date_time (_tmp32_, _tmp37_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
			_metadata_date_time_unref0 (_tmp37_);
			_g_date_time_unref0 (_tmp35_);
		}
		_tmp38_ = photo;
		self->priv->is_raw = photo_get_master_file_format (_tmp38_) == PHOTO_FILE_FORMAT_RAW;
		_tmp39_ = metadata;
		_tmp40_ = photo_metadata_get_pixel_dimensions (_tmp39_);
		_dimensions_free0 (self->priv->original_dim);
		self->priv->original_dim = _tmp40_;
		_tmp41_ = metadata;
		_tmp42_ = photo_metadata_get_camera_make (_tmp41_);
		_g_free0 (self->priv->camera_make);
		self->priv->camera_make = _tmp42_;
		_tmp43_ = metadata;
		_tmp44_ = photo_metadata_get_camera_model (_tmp43_);
		_g_free0 (self->priv->camera_model);
		self->priv->camera_model = _tmp44_;
		_tmp45_ = metadata;
		_tmp46_ = photo_metadata_get_flash_string (_tmp45_);
		_g_free0 (self->priv->flash);
		self->priv->flash = _tmp46_;
		_tmp47_ = metadata;
		_tmp48_ = photo_metadata_get_focal_length_string (_tmp47_);
		_g_free0 (self->priv->focal_length);
		self->priv->focal_length = _tmp48_;
		_tmp49_ = metadata;
		photo_metadata_get_gps (_tmp49_, &_tmp50_, &_tmp51_, &_tmp52_, &_tmp53_, &_tmp54_);
		self->priv->gps_long = _tmp50_;
		_g_free0 (self->priv->gps_long_ref);
		self->priv->gps_long_ref = _tmp51_;
		self->priv->gps_lat = _tmp52_;
		_g_free0 (self->priv->gps_lat_ref);
		self->priv->gps_lat_ref = _tmp53_;
		self->priv->gps_alt = _tmp54_;
		_tmp55_ = metadata;
		_tmp56_ = photo_metadata_get_artist (_tmp55_);
		_g_free0 (self->priv->artist);
		self->priv->artist = _tmp56_;
		_tmp57_ = metadata;
		_tmp58_ = photo_metadata_get_copyright (_tmp57_);
		_g_free0 (self->priv->copyright);
		self->priv->copyright = _tmp58_;
		_tmp59_ = metadata;
		_tmp60_ = photo_metadata_get_software (_tmp59_);
		_g_free0 (self->priv->software);
		self->priv->software = _tmp60_;
		_tmp61_ = metadata;
		_tmp62_ = photo_metadata_get_exposure_bias (_tmp61_);
		_g_free0 (self->priv->exposure_bias);
		self->priv->exposure_bias = _tmp62_;
		_tmp63_ = metadata;
		_tmp64_ = photo_metadata_get_exposure_date_time (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = metadata_date_time_get_timestamp (_tmp65_);
		_tmp67_ = _tmp66_;
		_metadata_date_time_unref0 (_tmp65_);
		exposure_time_obj = _tmp67_;
		_tmp68_ = exposure_time_obj;
		_tmp69_ = g_date_time_to_local (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp70_);
		_g_free0 (self->priv->exposure_date);
		self->priv->exposure_date = _tmp71_;
		_g_date_time_unref0 (_tmp70_);
		_tmp72_ = exposure_time_obj;
		_tmp73_ = g_date_time_to_local (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = properties_get_prettyprint_time_with_seconds (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp74_);
		_g_free0 (self->priv->exposure_time);
		self->priv->exposure_time = _tmp75_;
		_g_date_time_unref0 (_tmp74_);
		_tmp76_ = media;
		_tmp77_ = media_source_get_comment (_tmp76_);
		_g_free0 (self->priv->comment);
		self->priv->comment = _tmp77_;
		_g_date_time_unref0 (exposure_time_obj);
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (photo);
		_g_object_unref0 (media);
	} else {
		DataSource* _tmp78_;
		_tmp78_ = source;
		if (IS_EVENT_SOURCE (_tmp78_)) {
			Event* event = NULL;
			DataSource* _tmp79_;
			Event* _tmp80_;
			Event* _tmp81_;
			gchar* _tmp82_;
			_tmp79_ = source;
			_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_EVENT, Event));
			event = _tmp80_;
			_tmp81_ = event;
			_tmp82_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, TYPE_EVENT_SOURCE, EventSource));
			_g_free0 (self->priv->comment);
			self->priv->comment = _tmp82_;
			_g_object_unref0 (event);
		}
	}
	_g_object_unref0 (source);
}

static void
extended_properties_real_internal_update_properties (Properties* base,
                                                     Page* page)
{
	ExtendedProperties * self;
	gboolean _tmp98_ = FALSE;
	const gchar* _tmp99_;
	gboolean has_comment = FALSE;
	const gchar* _tmp101_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES, ExtendedProperties);
	g_return_if_fail (IS_PAGE (page));
	PROPERTIES_CLASS (extended_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
	if (IS_EVENTS_DIRECTORY_PAGE (page)) {
	} else {
		gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Dimensions* _tmp13_;
		const gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		const gchar* _tmp39_ = NULL;
		gboolean _tmp40_ = FALSE;
		const gchar* _tmp41_;
		const gchar* _tmp44_ = NULL;
		gboolean _tmp45_ = FALSE;
		const gchar* _tmp46_;
		const gchar* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		const gchar* _tmp51_;
		gchar* osm_link = NULL;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
		gchar* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		const gchar* _tmp71_;
		gchar* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		const gchar* _tmp80_;
		gchar* _tmp81_ = NULL;
		gboolean _tmp82_ = FALSE;
		const gchar* _tmp83_;
		const gchar* _tmp88_ = NULL;
		gboolean _tmp89_ = FALSE;
		const gchar* _tmp90_;
		const gchar* _tmp93_ = NULL;
		gboolean _tmp94_ = FALSE;
		const gchar* _tmp95_;
		_tmp2_ = self->priv->file_path;
		if (g_strcmp0 (_tmp2_, "") != 0) {
			const gchar* _tmp3_;
			_tmp3_ = self->priv->file_path;
			_tmp1_ = _tmp3_ != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->file_path;
			_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp5_;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp6_;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Location:"), _tmp0_, FALSE, NULL);
		if (self->priv->filesize > ((guint64) 0)) {
			gchar* _tmp8_;
			_tmp8_ = g_format_size_full ((guint64) ((gint64) self->priv->filesize), G_FORMAT_SIZE_DEFAULT);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp8_;
		} else {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp9_;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("File size:"), _tmp7_, FALSE, NULL);
		if (self->priv->is_raw) {
			const gchar* _tmp10_;
			_tmp10_ = self->priv->development_path;
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Current Development:"), _tmp10_, FALSE, NULL);
		}
		_tmp13_ = self->priv->original_dim;
		if (_tmp13_ != NULL) {
			Dimensions* _tmp14_;
			_tmp14_ = self->priv->original_dim;
			_tmp12_ = dimensions_has_area (_tmp14_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			Dimensions* _tmp15_;
			Dimensions* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = self->priv->original_dim;
			_tmp16_ = self->priv->original_dim;
			_tmp17_ = g_strdup_printf ("%d &#215; %d", (*_tmp15_).width, (*_tmp16_).height);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp17_;
		} else {
			gchar* _tmp18_;
			_tmp18_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp18_;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Original dimensions:"), _tmp11_, FALSE, NULL);
		_tmp21_ = self->priv->camera_make;
		if (g_strcmp0 (_tmp21_, "") != 0) {
			const gchar* _tmp22_;
			_tmp22_ = self->priv->camera_make;
			_tmp20_ = _tmp22_ != NULL;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			const gchar* _tmp23_;
			_tmp23_ = self->priv->camera_make;
			_tmp19_ = _tmp23_;
		} else {
			_tmp19_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Camera make:"), _tmp19_, FALSE, NULL);
		_tmp26_ = self->priv->camera_model;
		if (g_strcmp0 (_tmp26_, "") != 0) {
			const gchar* _tmp27_;
			_tmp27_ = self->priv->camera_model;
			_tmp25_ = _tmp27_ != NULL;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			const gchar* _tmp28_;
			_tmp28_ = self->priv->camera_model;
			_tmp24_ = _tmp28_;
		} else {
			_tmp24_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Camera model:"), _tmp24_, FALSE, NULL);
		_tmp31_ = self->priv->flash;
		if (g_strcmp0 (_tmp31_, "") != 0) {
			const gchar* _tmp32_;
			_tmp32_ = self->priv->flash;
			_tmp30_ = _tmp32_ != NULL;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp33_;
			_tmp33_ = self->priv->flash;
			_tmp29_ = _tmp33_;
		} else {
			_tmp29_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Flash:"), _tmp29_, FALSE, NULL);
		_tmp36_ = self->priv->focal_length;
		if (g_strcmp0 (_tmp36_, "") != 0) {
			const gchar* _tmp37_;
			_tmp37_ = self->priv->focal_length;
			_tmp35_ = _tmp37_ != NULL;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			const gchar* _tmp38_;
			_tmp38_ = self->priv->focal_length;
			_tmp34_ = _tmp38_;
		} else {
			_tmp34_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Focal length:"), _tmp34_, FALSE, NULL);
		_tmp41_ = self->priv->exposure_date;
		if (g_strcmp0 (_tmp41_, "") != 0) {
			const gchar* _tmp42_;
			_tmp42_ = self->priv->exposure_date;
			_tmp40_ = _tmp42_ != NULL;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			const gchar* _tmp43_;
			_tmp43_ = self->priv->exposure_date;
			_tmp39_ = _tmp43_;
		} else {
			_tmp39_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure date:"), _tmp39_, FALSE, NULL);
		_tmp46_ = self->priv->exposure_time;
		if (g_strcmp0 (_tmp46_, "") != 0) {
			const gchar* _tmp47_;
			_tmp47_ = self->priv->exposure_time;
			_tmp45_ = _tmp47_ != NULL;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			const gchar* _tmp48_;
			_tmp48_ = self->priv->exposure_time;
			_tmp44_ = _tmp48_;
		} else {
			_tmp44_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure time:"), _tmp44_, FALSE, NULL);
		_tmp51_ = self->priv->exposure_bias;
		if (g_strcmp0 (_tmp51_, "") != 0) {
			const gchar* _tmp52_;
			_tmp52_ = self->priv->exposure_bias;
			_tmp50_ = _tmp52_ != NULL;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			const gchar* _tmp53_;
			_tmp53_ = self->priv->exposure_bias;
			_tmp49_ = _tmp53_;
		} else {
			_tmp49_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure bias:"), _tmp49_, FALSE, NULL);
		osm_link = NULL;
		if (self->priv->gps_lat != ((gdouble) -1)) {
			const gchar* _tmp57_;
			_tmp57_ = self->priv->gps_lat_ref;
			_tmp56_ = g_strcmp0 (_tmp57_, "") != 0;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			_tmp55_ = self->priv->gps_long != ((gdouble) -1);
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			const gchar* _tmp58_;
			_tmp58_ = self->priv->gps_long_ref;
			_tmp54_ = g_strcmp0 (_tmp58_, "") != 0;
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			gchar* old_locale = NULL;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			_tmp59_ = setlocale (LC_NUMERIC, "C");
			_tmp60_ = g_strdup (_tmp59_);
			old_locale = _tmp60_;
			_tmp61_ = g_strdup_printf (EXTENDED_PROPERTIES_OSM_LINK_TEMPLATE, self->priv->gps_lat, self->priv->gps_long);
			_g_free0 (osm_link);
			osm_link = _tmp61_;
			_tmp62_ = old_locale;
			setlocale (LC_NUMERIC, _tmp62_);
			_g_free0 (old_locale);
		}
		if (self->priv->gps_lat != ((gdouble) -1)) {
			const gchar* _tmp66_;
			_tmp66_ = self->priv->gps_lat_ref;
			_tmp65_ = g_strcmp0 (_tmp66_, "") != 0;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			const gchar* _tmp67_;
			_tmp67_ = self->priv->gps_lat_ref;
			_tmp64_ = _tmp67_ != NULL;
		} else {
			_tmp64_ = FALSE;
		}
		if (_tmp64_) {
			const gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp68_ = self->priv->gps_lat_ref;
			_tmp69_ = g_strdup_printf ("%f °%s", self->priv->gps_lat, _tmp68_);
			_g_free0 (_tmp63_);
			_tmp63_ = _tmp69_;
		} else {
			gchar* _tmp70_;
			_tmp70_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp63_);
			_tmp63_ = _tmp70_;
		}
		_tmp71_ = osm_link;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("GPS latitude:"), _tmp63_, FALSE, _tmp71_);
		if (self->priv->gps_long != ((gdouble) -1)) {
			const gchar* _tmp75_;
			_tmp75_ = self->priv->gps_long_ref;
			_tmp74_ = g_strcmp0 (_tmp75_, "") != 0;
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			const gchar* _tmp76_;
			_tmp76_ = self->priv->gps_long_ref;
			_tmp73_ = _tmp76_ != NULL;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			const gchar* _tmp77_;
			gchar* _tmp78_;
			_tmp77_ = self->priv->gps_long_ref;
			_tmp78_ = g_strdup_printf ("%f °%s", self->priv->gps_long, _tmp77_);
			_g_free0 (_tmp72_);
			_tmp72_ = _tmp78_;
		} else {
			gchar* _tmp79_;
			_tmp79_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp72_);
			_tmp72_ = _tmp79_;
		}
		_tmp80_ = osm_link;
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("GPS longitude:"), _tmp72_, FALSE, _tmp80_);
		_tmp83_ = self->priv->artist;
		if (g_strcmp0 (_tmp83_, "") != 0) {
			const gchar* _tmp84_;
			_tmp84_ = self->priv->artist;
			_tmp82_ = _tmp84_ != NULL;
		} else {
			_tmp82_ = FALSE;
		}
		if (_tmp82_) {
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = self->priv->artist;
			_tmp86_ = g_markup_escape_text (_tmp85_, (gssize) -1);
			_g_free0 (_tmp81_);
			_tmp81_ = _tmp86_;
		} else {
			gchar* _tmp87_;
			_tmp87_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp81_);
			_tmp81_ = _tmp87_;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Artist:"), _tmp81_, FALSE, NULL);
		_tmp90_ = self->priv->copyright;
		if (g_strcmp0 (_tmp90_, "") != 0) {
			const gchar* _tmp91_;
			_tmp91_ = self->priv->copyright;
			_tmp89_ = _tmp91_ != NULL;
		} else {
			_tmp89_ = FALSE;
		}
		if (_tmp89_) {
			const gchar* _tmp92_;
			_tmp92_ = self->priv->copyright;
			_tmp88_ = _tmp92_;
		} else {
			_tmp88_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Copyright:"), _tmp88_, FALSE, NULL);
		_tmp95_ = self->priv->software;
		if (g_strcmp0 (_tmp95_, "") != 0) {
			const gchar* _tmp96_;
			_tmp96_ = self->priv->software;
			_tmp94_ = _tmp96_ != NULL;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			const gchar* _tmp97_;
			_tmp97_ = self->priv->software;
			_tmp93_ = _tmp97_;
		} else {
			_tmp93_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Software:"), _tmp93_, FALSE, NULL);
		_g_free0 (_tmp81_);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp63_);
		_g_free0 (osm_link);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp0_);
	}
	_tmp99_ = self->priv->comment;
	if (g_strcmp0 (_tmp99_, "") != 0) {
		const gchar* _tmp100_;
		_tmp100_ = self->priv->comment;
		_tmp98_ = _tmp100_ != NULL;
	} else {
		_tmp98_ = FALSE;
	}
	has_comment = _tmp98_;
	if (has_comment) {
		const gchar* _tmp102_;
		_tmp102_ = self->priv->comment;
		_tmp101_ = _tmp102_;
	} else {
		_tmp101_ = EXTENDED_PROPERTIES_NO_VALUE;
	}
	properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Comment:"), _tmp101_, has_comment, NULL);
}

static void
extended_properties_class_init (ExtendedPropertiesClass * klass,
                                gpointer klass_data)
{
	extended_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExtendedProperties_private_offset);
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) extended_properties_real_clear_properties;
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) extended_properties_real_get_single_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) extended_properties_real_internal_update_properties;
	G_OBJECT_CLASS (klass)->finalize = extended_properties_finalize;
}

static void
extended_properties_instance_init (ExtendedProperties * self,
                                   gpointer klass)
{
	self->priv = extended_properties_get_instance_private (self);
}

static void
extended_properties_finalize (GObject * obj)
{
	ExtendedProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTENDED_PROPERTIES, ExtendedProperties);
	_g_free0 (self->priv->file_path);
	_dimensions_free0 (self->priv->original_dim);
	_g_free0 (self->priv->camera_make);
	_g_free0 (self->priv->camera_model);
	_g_free0 (self->priv->flash);
	_g_free0 (self->priv->focal_length);
	_g_free0 (self->priv->gps_lat_ref);
	_g_free0 (self->priv->gps_long_ref);
	_g_free0 (self->priv->artist);
	_g_free0 (self->priv->copyright);
	_g_free0 (self->priv->software);
	_g_free0 (self->priv->exposure_bias);
	_g_free0 (self->priv->exposure_date);
	_g_free0 (self->priv->exposure_time);
	_g_free0 (self->priv->development_path);
	_g_free0 (self->priv->comment);
	G_OBJECT_CLASS (extended_properties_parent_class)->finalize (obj);
}

static GType
extended_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedProperties), 0, (GInstanceInitFunc) extended_properties_instance_init, NULL };
	GType extended_properties_type_id;
	extended_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "ExtendedProperties", &g_define_type_info, 0);
	ExtendedProperties_private_offset = g_type_add_instance_private (extended_properties_type_id, sizeof (ExtendedPropertiesPrivate));
	return extended_properties_type_id;
}

GType
extended_properties_get_type (void)
{
	static volatile gsize extended_properties_type_id__once = 0;
	if (g_once_init_enter (&extended_properties_type_id__once)) {
		GType extended_properties_type_id;
		extended_properties_type_id = extended_properties_get_type_once ();
		g_once_init_leave (&extended_properties_type_id__once, extended_properties_type_id);
	}
	return extended_properties_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

