/* Printing.c generated by valac 0.56.17, the Vala compiler
 * generated from Printing.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <langinfo.h>
#include <gee.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define PRINT_SETTINGS_MIN_CONTENT_PPI 72
#define PRINT_SETTINGS_MAX_CONTENT_PPI 1200
#define MEASUREMENT_CENTIMETERS_PER_INCH 2.54
#define MEASUREMENT_INCHES_PER_CENTIMETER (1.0 / 2.54)
#define CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE 0
#define CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE 1
#define PRINT_MANAGER_IMAGE_DISTANCE 0.24
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CONTENT_LAYOUT_STANDARD_SIZE,
	CONTENT_LAYOUT_CUSTOM_SIZE,
	CONTENT_LAYOUT_IMAGE_PER_PAGE
} ContentLayout;

#define TYPE_CONTENT_LAYOUT (content_layout_get_type ())

#define TYPE_PRINT_SETTINGS (print_settings_get_type ())
#define PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_SETTINGS, PrintSettings))
#define PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_SETTINGS, PrintSettingsClass))
#define IS_PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_SETTINGS))
#define IS_PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_SETTINGS))
#define PRINT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_SETTINGS, PrintSettingsClass))

typedef struct _PrintSettings PrintSettings;
typedef struct _PrintSettingsClass PrintSettingsClass;
typedef struct _PrintSettingsPrivate PrintSettingsPrivate;

#define TYPE_MEASUREMENT (measurement_get_type ())
typedef struct _Measurement Measurement;
typedef enum  {
	MEASUREMENT_UNIT_INCHES,
	MEASUREMENT_UNIT_CENTIMETERS
} MeasurementUnit;

#define TYPE_MEASUREMENT_UNIT (measurement_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PRINT_MANAGER (print_manager_get_type ())
#define PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_MANAGER, PrintManager))
#define PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_MANAGER, PrintManagerClass))
#define IS_PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_MANAGER))
#define IS_PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_MANAGER))
#define PRINT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_MANAGER, PrintManagerClass))

typedef struct _PrintManager PrintManager;
typedef struct _PrintManagerClass PrintManagerClass;

#define TYPE_STANDARD_PRINT_SIZE (standard_print_size_get_type ())
#define STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSize))
#define STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))
#define IS_STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STANDARD_PRINT_SIZE))
#define IS_STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STANDARD_PRINT_SIZE))
#define STANDARD_PRINT_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))

typedef struct _StandardPrintSize StandardPrintSize;
typedef struct _StandardPrintSizeClass StandardPrintSizeClass;
typedef struct _StandardPrintSizePrivate StandardPrintSizePrivate;
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
typedef struct _ParamSpecPrintSettings ParamSpecPrintSettings;
typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())

#define TYPE_CUSTOM_PRINT_TAB (custom_print_tab_get_type ())
#define CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTab))
#define CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))
#define IS_CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_PRINT_TAB))
#define IS_CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_PRINT_TAB))
#define CUSTOM_PRINT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))

typedef struct _CustomPrintTab CustomPrintTab;
typedef struct _CustomPrintTabClass CustomPrintTabClass;
typedef struct _CustomPrintTabPrivate CustomPrintTabPrivate;

#define TYPE_PRINT_JOB (print_job_get_type ())
#define PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_JOB, PrintJob))
#define PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_JOB, PrintJobClass))
#define IS_PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_JOB))
#define IS_PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_JOB))
#define PRINT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_JOB, PrintJobClass))

typedef struct _PrintJob PrintJob;
typedef struct _PrintJobClass PrintJobClass;
enum  {
	CUSTOM_PRINT_TAB_0_PROPERTY,
	CUSTOM_PRINT_TAB_NUM_PROPERTIES
};
static GParamSpec* custom_print_tab_properties[CUSTOM_PRINT_TAB_NUM_PROPERTIES];
#define _standard_print_size_unref0(var) ((var == NULL) ? NULL : (var = (standard_print_size_unref (var), NULL)))
typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef struct _PrintJobPrivate PrintJobPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
enum  {
	PRINT_JOB_0_PROPERTY,
	PRINT_JOB_NUM_PROPERTIES
};
static GParamSpec* print_job_properties[PRINT_JOB_NUM_PROPERTIES];
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _ParamSpecStandardPrintSize ParamSpecStandardPrintSize;
typedef struct _PrintManagerPrivate PrintManagerPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ParamSpecPrintManager ParamSpecPrintManager;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PrintSettings {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintSettingsPrivate * priv;
};

struct _PrintSettingsClass {
	GTypeClass parent_class;
	void (*finalize) (PrintSettings *self);
};

struct _Measurement {
	gdouble value;
	MeasurementUnit unit;
};

struct _PrintSettingsPrivate {
	ContentLayout content_layout;
	Measurement content_width;
	Measurement content_height;
	gint content_ppi;
	gint image_per_page_selection;
	gint size_selection;
	gboolean match_aspect_ratio;
	gboolean print_titles;
	gchar* print_titles_font;
};

struct _StandardPrintSize {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StandardPrintSizePrivate * priv;
	gchar* name;
	Measurement width;
	Measurement height;
};

struct _StandardPrintSizeClass {
	GTypeClass parent_class;
	void (*finalize) (StandardPrintSize *self);
};

struct _ParamSpecPrintSettings {
	GParamSpec parent_instance;
};

struct _CustomPrintTab {
	GtkBox parent_instance;
	CustomPrintTabPrivate * priv;
};

struct _CustomPrintTabClass {
	GtkBoxClass parent_class;
};

struct _CustomPrintTabPrivate {
	GtkRadioButton* standard_size_radio;
	GtkRadioButton* custom_size_radio;
	GtkRadioButton* image_per_page_radio;
	GtkComboBoxText* image_per_page_combo;
	GtkComboBoxText* standard_sizes_combo;
	GtkComboBoxText* units_combo;
	GtkEntry* custom_width_entry;
	GtkEntry* custom_height_entry;
	GtkEntry* ppi_entry;
	GtkCheckButton* aspect_ratio_check;
	GtkCheckButton* title_print_check;
	GtkFontButton* title_print_font;
	Measurement local_content_width;
	Measurement local_content_height;
	gint local_content_ppi;
	gboolean is_text_insertion_in_progress;
	PrintJob* source_job;
};

struct _PrintJob {
	GtkPrintOperation parent_instance;
	PrintJobPrivate * priv;
};

struct _PrintJobClass {
	GtkPrintOperationClass parent_class;
};

struct _PrintJobPrivate {
	PrintSettings* settings;
	GeeArrayList* photos;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _ParamSpecStandardPrintSize {
	GParamSpec parent_instance;
};

struct _PrintManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintManagerPrivate * priv;
};

struct _PrintManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PrintManager *self);
};

struct _PrintManagerPrivate {
	PrintSettings* settings;
	GtkPageSetup* user_page_setup;
	CustomPrintTab* custom_tab;
	ProgressDialog* progress_dialog;
	GCancellable* cancellable;
	StandardPrintSize** standard_sizes;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ParamSpecPrintManager {
	GParamSpec parent_instance;
};

static gint PrintSettings_private_offset;
static gpointer print_settings_parent_class = NULL;
static gint CustomPrintTab_private_offset;
static gpointer custom_print_tab_parent_class = NULL;
static gint PrintJob_private_offset;
static gpointer print_job_parent_class = NULL;
static gpointer standard_print_size_parent_class = NULL;
static gint PrintManager_private_offset;
static gpointer print_manager_parent_class = NULL;
static PrintManager* print_manager_instance;
static PrintManager* print_manager_instance = NULL;

VALA_EXTERN GType content_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer print_settings_ref (gpointer instance);
VALA_EXTERN void print_settings_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_print_settings (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_print_settings (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_print_settings (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_print_settings (const GValue* value);
VALA_EXTERN GType print_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintSettings, print_settings_unref)
VALA_EXTERN GType measurement_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType measurement_unit_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Measurement* measurement_dup (const Measurement* self);
VALA_EXTERN void measurement_free (Measurement* self);
VALA_EXTERN PrintSettings* print_settings_new (void);
VALA_EXTERN PrintSettings* print_settings_construct (GType object_type);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
VALA_EXTERN gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
VALA_EXTERN void measurement_init (Measurement *self,
                       gdouble value,
                       MeasurementUnit unit);
VALA_EXTERN gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
VALA_EXTERN gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
VALA_EXTERN gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
VALA_EXTERN gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
VALA_EXTERN gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
VALA_EXTERN gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
VALA_EXTERN gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
VALA_EXTERN gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
VALA_EXTERN void print_settings_save (PrintSettings* self);
VALA_EXTERN void configuration_facade_set_printing_content_units (ConfigurationFacade* self,
                                                      gint units_code);
VALA_EXTERN void configuration_facade_set_printing_content_width (ConfigurationFacade* self,
                                                      gdouble content_width);
VALA_EXTERN void configuration_facade_set_printing_content_height (ConfigurationFacade* self,
                                                       gdouble content_height);
VALA_EXTERN void configuration_facade_set_printing_size_selection (ConfigurationFacade* self,
                                                       gint size_code);
VALA_EXTERN void configuration_facade_set_printing_content_layout (ConfigurationFacade* self,
                                                       gint layout_code);
VALA_EXTERN void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                           gboolean match_aspect_ratio);
VALA_EXTERN void configuration_facade_set_printing_print_titles (ConfigurationFacade* self,
                                                     gboolean print_titles);
VALA_EXTERN void configuration_facade_set_printing_titles_font (ConfigurationFacade* self,
                                                    const gchar* font_name);
VALA_EXTERN void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self,
                                                        gint images_per_page_code);
VALA_EXTERN void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self,
                                                    gint content_ppi);
VALA_EXTERN void print_settings_get_content_width (PrintSettings* self,
                                       Measurement* result);
VALA_EXTERN ContentLayout print_settings_get_content_layout (PrintSettings* self);
VALA_EXTERN gpointer print_manager_ref (gpointer instance);
VALA_EXTERN void print_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_print_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_print_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_print_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_print_manager (const GValue* value);
VALA_EXTERN GType print_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintManager, print_manager_unref)
VALA_EXTERN PrintManager* print_manager_get_instance (void);
VALA_EXTERN gpointer standard_print_size_ref (gpointer instance);
VALA_EXTERN void standard_print_size_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_standard_print_size (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_standard_print_size (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_standard_print_size (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_standard_print_size (const GValue* value);
VALA_EXTERN GType standard_print_size_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StandardPrintSize, standard_print_size_unref)
VALA_EXTERN StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self,
                                                      gint* result_length1);
VALA_EXTERN gint print_settings_get_size_selection (PrintSettings* self);
VALA_EXTERN void print_settings_get_content_height (PrintSettings* self,
                                        Measurement* result);
VALA_EXTERN void print_settings_get_minimum_content_dimension (PrintSettings* self,
                                                   Measurement* result);
VALA_EXTERN void print_settings_get_maximum_content_dimension (PrintSettings* self,
                                                   Measurement* result);
VALA_EXTERN gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self);
VALA_EXTERN gboolean print_settings_is_print_titles_enabled (PrintSettings* self);
VALA_EXTERN gint print_settings_get_content_ppi (PrintSettings* self);
VALA_EXTERN gint print_settings_get_image_per_page_selection (PrintSettings* self);
VALA_EXTERN void print_settings_set_content_layout (PrintSettings* self,
                                        ContentLayout content_layout);
VALA_EXTERN void print_settings_set_content_width (PrintSettings* self,
                                       Measurement* content_width);
VALA_EXTERN void print_settings_set_content_height (PrintSettings* self,
                                        Measurement* content_height);
VALA_EXTERN void print_settings_set_content_ppi (PrintSettings* self,
                                     gint content_ppi);
VALA_EXTERN void print_settings_set_image_per_page_selection (PrintSettings* self,
                                                  gint image_per_page_selection);
VALA_EXTERN void print_settings_set_size_selection (PrintSettings* self,
                                        gint size_selection);
VALA_EXTERN void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self,
                                                    gboolean enable_state);
VALA_EXTERN void print_settings_set_print_titles_enabled (PrintSettings* self,
                                              gboolean print_titles);
VALA_EXTERN void print_settings_set_print_titles_font (PrintSettings* self,
                                           const gchar* fontname);
VALA_EXTERN gchar* print_settings_get_print_titles_font (PrintSettings* self);
static void print_settings_finalize (PrintSettings * obj);
static GType print_settings_get_type_once (void);
VALA_EXTERN void measurement_convert_to (Measurement *self,
                             MeasurementUnit to_unit,
                             Measurement* result);
VALA_EXTERN gboolean measurement_is_less_than (Measurement *self,
                                   Measurement* rhs);
VALA_EXTERN gboolean measurement_is_greater_than (Measurement *self,
                                      Measurement* rhs);
VALA_EXTERN GType print_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PrintLayout* print_layout_get_all (gint* result_length1);
VALA_EXTERN gint print_layout_get_per_page (PrintLayout self);
VALA_EXTERN gint print_layout_get_x (PrintLayout self);
VALA_EXTERN gint print_layout_get_y (PrintLayout self);
VALA_EXTERN gchar* print_layout_to_string (PrintLayout self);
VALA_EXTERN GType custom_print_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CustomPrintTab, g_object_unref)
VALA_EXTERN GType print_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintJob, g_object_unref)
VALA_EXTERN CustomPrintTab* custom_print_tab_new (PrintJob* source_job);
VALA_EXTERN CustomPrintTab* custom_print_tab_construct (GType object_type,
                                            PrintJob* source_job);
static void custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                            GtkButton* b);
static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                               GtkTreeIter* iter);
static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                                 GtkTreeIter* iter,
                                                                                                 gpointer self);
VALA_EXTERN GType resources_unit_system_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ResourcesUnitSystem resources_get_default_measurement_unit (void);
static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                            GtkEditable* editable,
                                            const gchar* text,
                                            gint length,
                                            gint* position);
static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                      const gchar* new_text,
                                                                      gint new_text_length,
                                                                      gint* position,
                                                                      gpointer self);
static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                                    GdkEventFocus* event);
static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                GdkEventFocus* event,
                                                                                gpointer self);
static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                                     GdkEventFocus* event);
static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                 GdkEventFocus* event,
                                                                                 gpointer self);
static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self);
static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                                GtkEditable* editable,
                                                const gchar* text,
                                                gint length,
                                                gint* position);
static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                          const gchar* new_text,
                                                                          gint new_text_length,
                                                                          gint* position,
                                                                          gpointer self);
static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self,
                                                  GdkEventFocus* event);
static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                              GdkEventFocus* event,
                                                                              gpointer self);
static void custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                           PrintJob* job);
static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self);
static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
VALA_EXTERN gdouble print_job_get_source_aspect_ratio (PrintJob* self);
static gchar* custom_print_tab_format_measurement (CustomPrintTab* self,
                                            Measurement* measurement);
static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                               Measurement* measurement,
                                               MeasurementUnit to_unit);
static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self);
static void custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                             Measurement* result);
VALA_EXTERN PrintSettings* print_job_get_local_settings (PrintJob* self);
static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self);
static void custom_print_tab_set_content_ppi (CustomPrintTab* self,
                                       gint content_ppi);
static void custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                              Measurement* result);
static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                            MeasurementUnit unit);
static void custom_print_tab_set_content_width (CustomPrintTab* self,
                                         Measurement* content_width);
static void custom_print_tab_set_content_height (CustomPrintTab* self,
                                          Measurement* content_height);
static void custom_print_tab_set_content_layout (CustomPrintTab* self,
                                          ContentLayout content_layout);
static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                                    gint image_per_page);
static void custom_print_tab_set_size_selection (CustomPrintTab* self,
                                          gint size_selection);
static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                      gboolean enable_state);
static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                                gboolean print_titles);
static void custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                             const gchar* fontname);
static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                        ContentLayout layout);
static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self);
static void custom_print_tab_get_content_width (CustomPrintTab* self,
                                         Measurement* result);
static void custom_print_tab_get_content_height (CustomPrintTab* self,
                                          Measurement* result);
static gint custom_print_tab_get_content_ppi (CustomPrintTab* self);
static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self);
static gint custom_print_tab_get_size_selection (CustomPrintTab* self);
static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self);
static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self);
VALA_EXTERN PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self);
VALA_EXTERN PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self);
static void custom_print_tab_finalize (GObject * obj);
static GType custom_print_tab_get_type_once (void);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN PrintJob* print_job_new (GeeCollection* to_print);
VALA_EXTERN PrintJob* print_job_construct (GType object_type,
                               GeeCollection* to_print);
VALA_EXTERN PrintSettings* print_manager_get_global_settings (PrintManager* self);
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN gdouble dimensions_get_aspect_ratio (Dimensions *self);
VALA_EXTERN GeeList* print_job_get_photos (PrintJob* self);
VALA_EXTERN Photo* print_job_get_source_photo (PrintJob* self);
VALA_EXTERN void print_job_set_local_settings (PrintJob* self,
                                   PrintSettings* settings);
static void print_job_finalize (GObject * obj);
static GType print_job_get_type_once (void);
VALA_EXTERN StandardPrintSize* standard_print_size_new (const gchar* name,
                                            Measurement* width,
                                            Measurement* height);
VALA_EXTERN StandardPrintSize* standard_print_size_construct (GType object_type,
                                                  const gchar* name,
                                                  Measurement* width,
                                                  Measurement* height);
static void standard_print_size_finalize (StandardPrintSize * obj);
static GType standard_print_size_get_type_once (void);
VALA_EXTERN GType progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgressDialog, g_object_unref)
static PrintManager* print_manager_new (void);
static PrintManager* print_manager_construct (GType object_type);
static void _vala_array_add108 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add109 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add110 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add111 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add112 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add113 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add114 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add115 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add116 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add117 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add118 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add119 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add120 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add121 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
static void _vala_array_add122 (StandardPrintSize** * array,
                         gint* length,
                         gint* size,
                         StandardPrintSize* value);
VALA_EXTERN void print_manager_spool_photo (PrintManager* self,
                                GeeCollection* to_print);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
static void print_manager_on_begin_print (PrintManager* self,
                                   GtkPrintOperation* emitting_object,
                                   GtkPrintContext* job_context);
static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                                    GtkPrintContext* context,
                                                                    gpointer self);
static void print_manager_on_draw_page (PrintManager* self,
                                 GtkPrintOperation* emitting_object,
                                 GtkPrintContext* job_context,
                                 gint page_num);
static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                                GtkPrintContext* context,
                                                                gint page_nr,
                                                                gpointer self);
static GObject* print_manager_on_create_custom_widget (PrintManager* self,
                                                GtkPrintOperation* emitting_object);
static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                          gpointer self);
static void print_manager_on_status_changed (PrintManager* self,
                                      GtkPrintOperation* job);
static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                          gpointer self);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
VALA_EXTERN ProgressDialog* progress_dialog_new (GtkWindow* owner,
                                     const gchar* text,
                                     GCancellable* cancellable);
VALA_EXTERN ProgressDialog* progress_dialog_construct (GType object_type,
                                           GtkWindow* owner,
                                           const gchar* text,
                                           GCancellable* cancellable);
VALA_EXTERN void progress_dialog_close (ProgressDialog* self);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
VALA_EXTERN void spin_event_loop (void);
VALA_EXTERN void progress_dialog_set_status (ProgressDialog* self,
                                 const gchar* text);
static void print_manager_fit_image_to_canvas (PrintManager* self,
                                        Photo* photo,
                                        gdouble x,
                                        gdouble y,
                                        gdouble canvas_width,
                                        gdouble canvas_height,
                                        gboolean crop,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
static void print_manager_add_title_to_canvas (PrintManager* self,
                                        gdouble x,
                                        gdouble y,
                                        const gchar* title,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
VALA_EXTERN gboolean progress_dialog_monitor (ProgressDialog* self,
                                  guint64 count,
                                  guint64 total,
                                  gboolean do_event_loop);
static void print_manager_on_custom_widget_apply (PrintManager* self,
                                           GtkWidget* custom_widget);
static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                                    GtkWidget* widget,
                                                                                    gpointer self);
VALA_EXTERN void print_manager_set_global_settings (PrintManager* self,
                                        PrintSettings* settings);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static gboolean print_manager_are_approximately_equal (PrintManager* self,
                                                gdouble val1,
                                                gdouble val2);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void scaling_to_fill_viewport (Dimensions* viewport,
                               Scaling* result);
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
VALA_EXTERN void scaling_for_viewport (Dimensions* viewport,
                           gboolean scale_up,
                           Scaling* result);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void print_manager_finalize (PrintManager * obj);
static GType print_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
content_layout_get_type_once (void)
{
	static const GEnumValue values[] = {{CONTENT_LAYOUT_STANDARD_SIZE, "CONTENT_LAYOUT_STANDARD_SIZE", "standard-size"}, {CONTENT_LAYOUT_CUSTOM_SIZE, "CONTENT_LAYOUT_CUSTOM_SIZE", "custom-size"}, {CONTENT_LAYOUT_IMAGE_PER_PAGE, "CONTENT_LAYOUT_IMAGE_PER_PAGE", "image-per-page"}, {0, NULL, NULL}};
	GType content_layout_type_id;
	content_layout_type_id = g_enum_register_static ("ContentLayout", values);
	return content_layout_type_id;
}

GType
content_layout_get_type (void)
{
	static volatile gsize content_layout_type_id__once = 0;
	if (g_once_init_enter (&content_layout_type_id__once)) {
		GType content_layout_type_id;
		content_layout_type_id = content_layout_get_type_once ();
		g_once_init_leave (&content_layout_type_id__once, content_layout_type_id);
	}
	return content_layout_type_id__once;
}

static inline gpointer
print_settings_get_instance_private (PrintSettings* self)
{
	return G_STRUCT_MEMBER_P (self, PrintSettings_private_offset);
}

PrintSettings*
print_settings_construct (GType object_type)
{
	PrintSettings* self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	MeasurementUnit units = 0;
	gchar* _tmp1_;
	self = (PrintSettings*) g_type_create_instance (object_type);
	_tmp0_ = config_facade_get_instance ();
	config = _tmp0_;
	units = (MeasurementUnit) configuration_facade_get_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	measurement_init (&self->priv->content_width, configuration_facade_get_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)), units);
	measurement_init (&self->priv->content_height, configuration_facade_get_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)), units);
	self->priv->size_selection = configuration_facade_get_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	self->priv->content_layout = (ContentLayout) configuration_facade_get_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	self->priv->match_aspect_ratio = configuration_facade_get_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	self->priv->print_titles = configuration_facade_get_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp1_ = configuration_facade_get_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_free0 (self->priv->print_titles_font);
	self->priv->print_titles_font = _tmp1_;
	self->priv->image_per_page_selection = configuration_facade_get_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	self->priv->content_ppi = configuration_facade_get_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (config);
	return self;
}

PrintSettings*
print_settings_new (void)
{
	return print_settings_construct (TYPE_PRINT_SETTINGS);
}

void
print_settings_save (PrintSettings* self)
{
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp2_;
	Measurement _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	_tmp0_ = config_facade_get_instance ();
	config = _tmp0_;
	_tmp1_ = self->priv->content_width;
	configuration_facade_set_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp1_.unit);
	_tmp2_ = self->priv->content_width;
	configuration_facade_set_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp2_.value);
	_tmp3_ = self->priv->content_height;
	configuration_facade_set_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_.value);
	configuration_facade_set_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->size_selection);
	configuration_facade_set_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) self->priv->content_layout);
	configuration_facade_set_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->match_aspect_ratio);
	configuration_facade_set_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->print_titles);
	_tmp4_ = self->priv->print_titles_font;
	configuration_facade_set_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp4_);
	configuration_facade_set_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->image_per_page_selection);
	configuration_facade_set_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->content_ppi);
	_g_object_unref0 (config);
}

void
print_settings_get_content_width (PrintSettings* self,
                                  Measurement* result)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	switch (print_settings_get_content_layout (self)) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_ = 0;
			StandardPrintSize** _tmp3_;
			StandardPrintSize* _tmp4_;
			Measurement _tmp5_;
			Measurement _tmp6_;
			_tmp0_ = print_manager_get_instance ();
			_tmp1_ = _tmp0_;
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
			_tmp4_ = _tmp3_[print_settings_get_size_selection (self)];
			_tmp5_ = _tmp4_->width;
			_tmp6_ = _tmp5_;
			_print_manager_unref0 (_tmp1_);
			*result = _tmp6_;
			return;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			Measurement _tmp7_;
			_tmp7_ = self->priv->content_width;
			*result = _tmp7_;
			return;
		}
		default:
		{
			g_error ("Printing.vala:73: unknown ContentLayout enumeration value");
		}
	}
}

void
print_settings_get_content_height (PrintSettings* self,
                                   Measurement* result)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	switch (print_settings_get_content_layout (self)) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_ = 0;
			StandardPrintSize** _tmp3_;
			StandardPrintSize* _tmp4_;
			Measurement _tmp5_;
			Measurement _tmp6_;
			_tmp0_ = print_manager_get_instance ();
			_tmp1_ = _tmp0_;
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
			_tmp4_ = _tmp3_[print_settings_get_size_selection (self)];
			_tmp5_ = _tmp4_->height;
			_tmp6_ = _tmp5_;
			_print_manager_unref0 (_tmp1_);
			*result = _tmp6_;
			return;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			Measurement _tmp7_;
			_tmp7_ = self->priv->content_height;
			*result = _tmp7_;
			return;
		}
		default:
		{
			g_error ("Printing.vala:88: unknown ContentLayout enumeration value");
		}
	}
}

void
print_settings_get_minimum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	measurement_init (&_tmp0_, 0.5, MEASUREMENT_UNIT_INCHES);
	*result = _tmp0_;
	return;
}

void
print_settings_get_maximum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	measurement_init (&_tmp0_, (gdouble) 30, MEASUREMENT_UNIT_INCHES);
	*result = _tmp0_;
	return;
}

gboolean
print_settings_is_match_aspect_ratio_enabled (PrintSettings* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
	result = self->priv->match_aspect_ratio;
	return result;
}

gboolean
print_settings_is_print_titles_enabled (PrintSettings* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
	result = self->priv->print_titles;
	return result;
}

gint
print_settings_get_content_ppi (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
	result = self->priv->content_ppi;
	return result;
}

gint
print_settings_get_image_per_page_selection (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
	result = self->priv->image_per_page_selection;
	return result;
}

gint
print_settings_get_size_selection (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
	result = self->priv->size_selection;
	return result;
}

ContentLayout
print_settings_get_content_layout (PrintSettings* self)
{
	ContentLayout result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
	result = self->priv->content_layout;
	return result;
}

void
print_settings_set_content_layout (PrintSettings* self,
                                   ContentLayout content_layout)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->content_layout = content_layout;
}

void
print_settings_set_content_width (PrintSettings* self,
                                  Measurement* content_width)
{
	Measurement _tmp0_;
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	g_return_if_fail (content_width != NULL);
	_tmp0_ = *content_width;
	self->priv->content_width = _tmp0_;
}

void
print_settings_set_content_height (PrintSettings* self,
                                   Measurement* content_height)
{
	Measurement _tmp0_;
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	g_return_if_fail (content_height != NULL);
	_tmp0_ = *content_height;
	self->priv->content_height = _tmp0_;
}

void
print_settings_set_content_ppi (PrintSettings* self,
                                gint content_ppi)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->content_ppi = content_ppi;
}

void
print_settings_set_image_per_page_selection (PrintSettings* self,
                                             gint image_per_page_selection)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->image_per_page_selection = image_per_page_selection;
}

void
print_settings_set_size_selection (PrintSettings* self,
                                   gint size_selection)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->size_selection = size_selection;
}

void
print_settings_set_match_aspect_ratio_enabled (PrintSettings* self,
                                               gboolean enable_state)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->match_aspect_ratio = enable_state;
}

void
print_settings_set_print_titles_enabled (PrintSettings* self,
                                         gboolean print_titles)
{
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	self->priv->print_titles = print_titles;
}

void
print_settings_set_print_titles_font (PrintSettings* self,
                                      const gchar* fontname)
{
	gchar* _tmp0_;
	g_return_if_fail (IS_PRINT_SETTINGS (self));
	g_return_if_fail (fontname != NULL);
	_tmp0_ = g_strdup (fontname);
	_g_free0 (self->priv->print_titles_font);
	self->priv->print_titles_font = _tmp0_;
}

gchar*
print_settings_get_print_titles_font (PrintSettings* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), NULL);
	_tmp0_ = self->priv->print_titles_font;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_print_settings_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_print_settings_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		print_settings_unref (value->data[0].v_pointer);
	}
}

static void
value_print_settings_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = print_settings_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_print_settings_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_print_settings_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PrintSettings * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = print_settings_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_print_settings_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	PrintSettings ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = print_settings_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_print_settings (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecPrintSettings* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_SETTINGS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_print_settings (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_print_settings (GValue* value,
                          gpointer v_object)
{
	PrintSettings * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		print_settings_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_settings_unref (old);
	}
}

void
value_take_print_settings (GValue* value,
                           gpointer v_object)
{
	PrintSettings * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_settings_unref (old);
	}
}

static void
print_settings_class_init (PrintSettingsClass * klass,
                           gpointer klass_data)
{
	print_settings_parent_class = g_type_class_peek_parent (klass);
	((PrintSettingsClass *) klass)->finalize = print_settings_finalize;
	g_type_class_adjust_private_offset (klass, &PrintSettings_private_offset);
}

static void
print_settings_instance_init (PrintSettings * self,
                              gpointer klass)
{
	self->priv = print_settings_get_instance_private (self);
	self->ref_count = 1;
}

static void
print_settings_finalize (PrintSettings * obj)
{
	PrintSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_SETTINGS, PrintSettings);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->print_titles_font);
}

static GType
print_settings_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_print_settings_init, value_print_settings_free_value, value_print_settings_copy_value, value_print_settings_peek_pointer, "p", value_print_settings_collect_value, "p", value_print_settings_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PrintSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintSettings), 0, (GInstanceInitFunc) print_settings_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType print_settings_type_id;
	print_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PrintSettings_private_offset = g_type_add_instance_private (print_settings_type_id, sizeof (PrintSettingsPrivate));
	return print_settings_type_id;
}

GType
print_settings_get_type (void)
{
	static volatile gsize print_settings_type_id__once = 0;
	if (g_once_init_enter (&print_settings_type_id__once)) {
		GType print_settings_type_id;
		print_settings_type_id = print_settings_get_type_once ();
		g_once_init_leave (&print_settings_type_id__once, print_settings_type_id);
	}
	return print_settings_type_id__once;
}

gpointer
print_settings_ref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
print_settings_unref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRINT_SETTINGS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
measurement_unit_get_type_once (void)
{
	static const GEnumValue values[] = {{MEASUREMENT_UNIT_INCHES, "MEASUREMENT_UNIT_INCHES", "inches"}, {MEASUREMENT_UNIT_CENTIMETERS, "MEASUREMENT_UNIT_CENTIMETERS", "centimeters"}, {0, NULL, NULL}};
	GType measurement_unit_type_id;
	measurement_unit_type_id = g_enum_register_static ("MeasurementUnit", values);
	return measurement_unit_type_id;
}

GType
measurement_unit_get_type (void)
{
	static volatile gsize measurement_unit_type_id__once = 0;
	if (g_once_init_enter (&measurement_unit_type_id__once)) {
		GType measurement_unit_type_id;
		measurement_unit_type_id = measurement_unit_get_type_once ();
		g_once_init_leave (&measurement_unit_type_id__once, measurement_unit_type_id);
	}
	return measurement_unit_type_id__once;
}

void
measurement_init (Measurement *self,
                  gdouble value,
                  MeasurementUnit unit)
{
	memset (self, 0, sizeof (Measurement));
	(*self).value = value;
	(*self).unit = unit;
}

void
measurement_convert_to (Measurement *self,
                        MeasurementUnit to_unit,
                        Measurement* result)
{
	if ((*self).unit == to_unit) {
		*result = (*self);
		return;
	}
	if (to_unit == MEASUREMENT_UNIT_INCHES) {
		Measurement _tmp0_ = {0};
		measurement_init (&_tmp0_, (*self).value * MEASUREMENT_INCHES_PER_CENTIMETER, MEASUREMENT_UNIT_INCHES);
		*result = _tmp0_;
		return;
	} else {
		if (to_unit == MEASUREMENT_UNIT_CENTIMETERS) {
			Measurement _tmp1_ = {0};
			measurement_init (&_tmp1_, (*self).value * MEASUREMENT_CENTIMETERS_PER_INCH, MEASUREMENT_UNIT_CENTIMETERS);
			*result = _tmp1_;
			return;
		} else {
			g_error ("Printing.vala:199: unrecognized unit");
		}
	}
}

gboolean
measurement_is_less_than (Measurement *self,
                          Measurement* rhs)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_rhs = {0};
	Measurement _tmp4_;
	gboolean result;
	g_return_val_if_fail (rhs != NULL, FALSE);
	_tmp1_ = *rhs;
	if ((*self).unit == _tmp1_.unit) {
		Measurement _tmp2_;
		_tmp2_ = *rhs;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (rhs, (*self).unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_rhs = _tmp0_;
	_tmp4_ = converted_rhs;
	result = (*self).value < _tmp4_.value;
	return result;
}

gboolean
measurement_is_greater_than (Measurement *self,
                             Measurement* rhs)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_rhs = {0};
	Measurement _tmp4_;
	gboolean result;
	g_return_val_if_fail (rhs != NULL, FALSE);
	_tmp1_ = *rhs;
	if ((*self).unit == _tmp1_.unit) {
		Measurement _tmp2_;
		_tmp2_ = *rhs;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (rhs, (*self).unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_rhs = _tmp0_;
	_tmp4_ = converted_rhs;
	result = (*self).value > _tmp4_.value;
	return result;
}

Measurement*
measurement_dup (const Measurement* self)
{
	Measurement* dup;
	dup = g_new0 (Measurement, 1);
	memcpy (dup, self, sizeof (Measurement));
	return dup;
}

void
measurement_free (Measurement* self)
{
	g_free (self);
}

static GType
measurement_get_type_once (void)
{
	GType measurement_type_id;
	measurement_type_id = g_boxed_type_register_static ("Measurement", (GBoxedCopyFunc) measurement_dup, (GBoxedFreeFunc) measurement_free);
	return measurement_type_id;
}

GType
measurement_get_type (void)
{
	static volatile gsize measurement_type_id__once = 0;
	if (g_once_init_enter (&measurement_type_id__once)) {
		GType measurement_type_id;
		measurement_type_id = measurement_get_type_once ();
		g_once_init_leave (&measurement_type_id__once, measurement_type_id);
	}
	return measurement_type_id__once;
}

PrintLayout*
print_layout_get_all (gint* result_length1)
{
	PrintLayout* _tmp0_;
	PrintLayout* _tmp1_;
	gint _tmp1__length1;
	PrintLayout* result;
	_tmp0_ = g_new0 (PrintLayout, 7);
	_tmp0_[0] = PRINT_LAYOUT_ENTIRE_PAGE;
	_tmp0_[1] = PRINT_LAYOUT_TWO_PER_PAGE;
	_tmp0_[2] = PRINT_LAYOUT_FOUR_PER_PAGE;
	_tmp0_[3] = PRINT_LAYOUT_SIX_PER_PAGE;
	_tmp0_[4] = PRINT_LAYOUT_EIGHT_PER_PAGE;
	_tmp0_[5] = PRINT_LAYOUT_SIXTEEN_PER_PAGE;
	_tmp0_[6] = PRINT_LAYOUT_THIRTY_TWO_PER_PAGE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 7;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gint
print_layout_get_per_page (PrintLayout self)
{
	gint* per_page = NULL;
	gint* _tmp0_;
	gint per_page_length1;
	gint _per_page_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 4;
	_tmp0_[3] = 6;
	_tmp0_[4] = 8;
	_tmp0_[5] = 16;
	_tmp0_[6] = 32;
	per_page = _tmp0_;
	per_page_length1 = 7;
	_per_page_size_ = per_page_length1;
	_tmp1_ = per_page[self];
	result = _tmp1_;
	per_page = (g_free (per_page), NULL);
	return result;
}

gint
print_layout_get_x (PrintLayout self)
{
	gint* x = NULL;
	gint* _tmp0_;
	gint x_length1;
	gint _x_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 1;
	_tmp0_[2] = 2;
	_tmp0_[3] = 2;
	_tmp0_[4] = 2;
	_tmp0_[5] = 4;
	_tmp0_[6] = 4;
	x = _tmp0_;
	x_length1 = 7;
	_x_size_ = x_length1;
	_tmp1_ = x[self];
	result = _tmp1_;
	x = (g_free (x), NULL);
	return result;
}

gint
print_layout_get_y (PrintLayout self)
{
	gint* y = NULL;
	gint* _tmp0_;
	gint y_length1;
	gint _y_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 2;
	_tmp0_[3] = 3;
	_tmp0_[4] = 4;
	_tmp0_[5] = 4;
	_tmp0_[6] = 8;
	y = _tmp0_;
	y_length1 = 7;
	_y_size_ = y_length1;
	_tmp1_ = y[self];
	result = _tmp1_;
	y = (g_free (y), NULL);
	return result;
}

gchar*
print_layout_to_string (PrintLayout self)
{
	gchar** labels = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint labels_length1;
	gint _labels_size_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	_tmp0_ = g_strdup (_ ("Fill the entire page"));
	_tmp1_ = g_strdup (_ ("2 images per page"));
	_tmp2_ = g_strdup (_ ("4 images per page"));
	_tmp3_ = g_strdup (_ ("6 images per page"));
	_tmp4_ = g_strdup (_ ("8 images per page"));
	_tmp5_ = g_strdup (_ ("16 images per page"));
	_tmp6_ = g_strdup (_ ("32 images per page"));
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	labels = _tmp7_;
	labels_length1 = 7;
	_labels_size_ = labels_length1;
	_tmp8_ = labels[self];
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static GType
print_layout_get_type_once (void)
{
	static const GEnumValue values[] = {{PRINT_LAYOUT_ENTIRE_PAGE, "PRINT_LAYOUT_ENTIRE_PAGE", "entire-page"}, {PRINT_LAYOUT_TWO_PER_PAGE, "PRINT_LAYOUT_TWO_PER_PAGE", "two-per-page"}, {PRINT_LAYOUT_FOUR_PER_PAGE, "PRINT_LAYOUT_FOUR_PER_PAGE", "four-per-page"}, {PRINT_LAYOUT_SIX_PER_PAGE, "PRINT_LAYOUT_SIX_PER_PAGE", "six-per-page"}, {PRINT_LAYOUT_EIGHT_PER_PAGE, "PRINT_LAYOUT_EIGHT_PER_PAGE", "eight-per-page"}, {PRINT_LAYOUT_SIXTEEN_PER_PAGE, "PRINT_LAYOUT_SIXTEEN_PER_PAGE", "sixteen-per-page"}, {PRINT_LAYOUT_THIRTY_TWO_PER_PAGE, "PRINT_LAYOUT_THIRTY_TWO_PER_PAGE", "thirty-two-per-page"}, {0, NULL, NULL}};
	GType print_layout_type_id;
	print_layout_type_id = g_enum_register_static ("PrintLayout", values);
	return print_layout_type_id;
}

GType
print_layout_get_type (void)
{
	static volatile gsize print_layout_type_id__once = 0;
	if (g_once_init_enter (&print_layout_type_id__once)) {
		GType print_layout_type_id;
		print_layout_type_id = print_layout_get_type_once ();
		g_once_init_leave (&print_layout_type_id__once, print_layout_type_id);
	}
	return print_layout_type_id__once;
}

static inline gpointer
custom_print_tab_get_instance_private (CustomPrintTab* self)
{
	return G_STRUCT_MEMBER_P (self, CustomPrintTab_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	custom_print_tab_on_radio_group_click ((CustomPrintTab*) self, _sender);
}

static gboolean
_custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_standard_sizes_combo_separator_func (model, iter);
	return result;
}

static gpointer
_standard_print_size_ref0 (gpointer self)
{
	return self ? standard_print_size_ref (self) : NULL;
}

static void
_custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                 const gchar* new_text,
                                                                 gint new_text_length,
                                                                 gint* position,
                                                                 gpointer self)
{
	custom_print_tab_on_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
}

static gboolean
_custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_width_entry_focus_out ((CustomPrintTab*) self, event);
	return result;
}

static gboolean
_custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_height_entry_focus_out ((CustomPrintTab*) self, event);
	return result;
}

static void
_custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
	custom_print_tab_on_units_combo_changed ((CustomPrintTab*) self);
}

static void
_custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gint* position,
                                                                     gpointer self)
{
	custom_print_tab_on_ppi_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
}

static gboolean
_custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                     GdkEventFocus* event,
                                                                     gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_ppi_entry_focus_out ((CustomPrintTab*) self, event);
	return result;
}

static void
_custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	custom_print_tab_on_aspect_ratio_check_clicked ((CustomPrintTab*) self);
}

CustomPrintTab*
custom_print_tab_construct (GType object_type,
                            PrintJob* source_job)
{
	CustomPrintTab * self = NULL;
	PrintJob* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	gint _tmp4_ = 0;
	PrintLayout* _tmp5_;
	StandardPrintSize** standard_sizes = NULL;
	PrintManager* _tmp9_;
	PrintManager* _tmp10_;
	gint _tmp11_ = 0;
	StandardPrintSize** _tmp12_;
	StandardPrintSize** _tmp13_;
	gint _tmp13__length1;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
	GtkComboBoxText* _tmp14_;
	StandardPrintSize** _tmp15_;
	gint _tmp15__length1;
	GtkComboBoxText* _tmp20_;
	GtkEntry* _tmp21_;
	GtkEntry* _tmp22_;
	GtkEntry* _tmp23_;
	GtkEntry* _tmp24_;
	GtkComboBoxText* _tmp25_;
	GtkComboBoxText* _tmp26_;
	GtkEntry* _tmp27_;
	GtkEntry* _tmp28_;
	GtkCheckButton* _tmp29_;
	g_return_val_if_fail (IS_PRINT_JOB (source_job), NULL);
	self = (CustomPrintTab*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (source_job);
	_g_object_unref0 (self->priv->source_job);
	self->priv->source_job = _tmp0_;
	_tmp1_ = self->priv->standard_size_radio;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp2_ = self->priv->custom_size_radio;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->image_per_page_radio;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp5_ = print_layout_get_all (&_tmp4_);
	{
		PrintLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
		layout_collection = _tmp5_;
		layout_collection_length1 = _tmp4_;
		for (layout_it = 0; layout_it < layout_collection_length1; layout_it = layout_it + 1) {
			PrintLayout layout = 0;
			layout = layout_collection[layout_it];
			{
				GtkComboBoxText* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = self->priv->image_per_page_combo;
				_tmp7_ = print_layout_to_string (layout);
				_tmp8_ = _tmp7_;
				gtk_combo_box_text_append_text (_tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
			}
		}
		layout_collection = (g_free (layout_collection), NULL);
	}
	_tmp9_ = print_manager_get_instance ();
	_tmp10_ = _tmp9_;
	_tmp12_ = print_manager_get_standard_sizes (_tmp10_, &_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp11_;
	_print_manager_unref0 (_tmp10_);
	standard_sizes = _tmp13_;
	standard_sizes_length1 = _tmp13__length1;
	_standard_sizes_size_ = standard_sizes_length1;
	_tmp14_ = self->priv->standard_sizes_combo;
	gtk_combo_box_set_row_separator_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_combo_box_get_type (), GtkComboBox), _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
	_tmp15_ = standard_sizes;
	_tmp15__length1 = standard_sizes_length1;
	{
		StandardPrintSize** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp15_;
		size_collection_length1 = _tmp15__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			StandardPrintSize* _tmp16_;
			StandardPrintSize* size = NULL;
			_tmp16_ = _standard_print_size_ref0 (size_collection[size_it]);
			size = _tmp16_;
			{
				GtkComboBoxText* _tmp17_;
				StandardPrintSize* _tmp18_;
				const gchar* _tmp19_;
				_tmp17_ = self->priv->standard_sizes_combo;
				_tmp18_ = size;
				_tmp19_ = _tmp18_->name;
				gtk_combo_box_text_append_text (_tmp17_, _tmp19_);
				_standard_print_size_unref0 (size);
			}
		}
	}
	_tmp20_ = self->priv->standard_sizes_combo;
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_combo_box_get_type (), GtkComboBox), 9 * resources_get_default_measurement_unit ());
	_tmp21_ = self->priv->custom_width_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp22_ = self->priv->custom_width_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp23_ = self->priv->custom_height_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp24_ = self->priv->custom_height_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp25_ = self->priv->units_combo;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed, self, 0);
	_tmp26_ = self->priv->units_combo;
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_combo_box_get_type (), GtkComboBox), (gint) resources_get_default_measurement_unit ());
	_tmp27_ = self->priv->ppi_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp28_ = self->priv->ppi_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	custom_print_tab_sync_state_from_job (self, source_job);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp29_ = self->priv->aspect_ratio_check;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked, self, 0);
	return self;
}

CustomPrintTab*
custom_print_tab_new (PrintJob* source_job)
{
	return custom_print_tab_construct (TYPE_CUSTOM_PRINT_TAB, source_job);
}

static void
custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->aspect_ratio_check;
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton))) {
		Measurement _tmp1_;
		PrintJob* _tmp2_;
		Measurement _tmp3_;
		GtkEntry* _tmp4_;
		Measurement _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->local_content_height;
		_tmp2_ = self->priv->source_job;
		_tmp3_ = self->priv->local_content_height;
		measurement_init (&self->priv->local_content_width, _tmp1_.value * print_job_get_source_aspect_ratio (_tmp2_), _tmp3_.unit);
		_tmp4_ = self->priv->custom_width_entry;
		_tmp5_ = self->priv->local_content_width;
		_tmp6_ = custom_print_tab_format_measurement (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_entry_set_text (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
}

static gboolean
custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                           GdkEventFocus* event)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_width = {0};
	Measurement _tmp6_ = {0};
	Measurement min_width = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_width = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp32_;
	GtkEntry* _tmp33_;
	Measurement _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->custom_width_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = self->priv->local_content_width;
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	custom_print_tab_get_width_entry_value (self, &_tmp6_);
	new_width = _tmp6_;
	_tmp7_ = self->priv->source_job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_print_settings_unref0 (_tmp9_);
	min_width = _tmp11_;
	_tmp12_ = self->priv->source_job;
	_tmp13_ = print_job_get_local_settings (_tmp12_);
	_tmp14_ = _tmp13_;
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_print_settings_unref0 (_tmp14_);
	max_width = _tmp16_;
	_tmp18_ = min_width;
	if (measurement_is_less_than (&new_width, &_tmp18_)) {
		_tmp17_ = TRUE;
	} else {
		Measurement _tmp19_;
		_tmp19_ = max_width;
		_tmp17_ = measurement_is_greater_than (&new_width, &_tmp19_);
	}
	if (_tmp17_) {
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->priv->custom_width_entry;
		_tmp21_ = self->priv->local_content_width;
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_entry_set_text (_tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		result = FALSE;
		return result;
	}
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
		Measurement new_height = {0};
		Measurement _tmp24_;
		PrintJob* _tmp25_;
		Measurement _tmp26_;
		Measurement _tmp27_;
		GtkEntry* _tmp28_;
		Measurement _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = new_width;
		_tmp25_ = self->priv->source_job;
		_tmp26_ = new_width;
		measurement_init (&new_height, _tmp24_.value / print_job_get_source_aspect_ratio (_tmp25_), _tmp26_.unit);
		_tmp27_ = new_height;
		self->priv->local_content_height = _tmp27_;
		_tmp28_ = self->priv->custom_height_entry;
		_tmp29_ = new_height;
		_tmp30_ = custom_print_tab_format_measurement (self, &_tmp29_);
		_tmp31_ = _tmp30_;
		gtk_entry_set_text (_tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = new_width;
	self->priv->local_content_width = _tmp32_;
	_tmp33_ = self->priv->custom_width_entry;
	_tmp34_ = new_width;
	_tmp35_ = custom_print_tab_format_measurement (self, &_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_entry_set_text (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	result = FALSE;
	return result;
}

static gchar*
custom_print_tab_format_measurement (CustomPrintTab* self,
                                     Measurement* measurement)
{
	Measurement _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
	g_return_val_if_fail (measurement != NULL, NULL);
	_tmp0_ = *measurement;
	_tmp1_ = g_strdup_printf ("%.2f", _tmp0_.value);
	result = _tmp1_;
	return result;
}

static gchar*
custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                        Measurement* measurement,
                                        MeasurementUnit to_unit)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_measurement = {0};
	Measurement _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
	g_return_val_if_fail (measurement != NULL, NULL);
	_tmp1_ = *measurement;
	if (_tmp1_.unit == to_unit) {
		Measurement _tmp2_;
		_tmp2_ = *measurement;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (measurement, to_unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_measurement = _tmp0_;
	_tmp4_ = converted_measurement;
	_tmp5_ = custom_print_tab_format_measurement (self, &_tmp4_);
	result = _tmp5_;
	return result;
}

static gboolean
custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self,
                                         GdkEventFocus* event)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->ppi_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	custom_print_tab_set_content_ppi (self, atoi (_tmp1_));
	result = FALSE;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                           GtkEditable* editable,
                                           const gchar* text,
                                           gint length,
                                           gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	gchar* new_text = NULL;
	gchar* _tmp3_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GtkEntry* _tmp18_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_editable_get_type ()));
	g_return_if_fail (text != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
	sender = _tmp0_;
	if (self->priv->is_text_insertion_in_progress) {
		_g_object_unref0 (sender);
		return;
	}
	self->priv->is_text_insertion_in_progress = TRUE;
	if (length == -1) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (text);
		_tmp2_ = _tmp1_;
		length = (gint) _tmp2_;
	}
	_tmp3_ = g_strdup ("");
	new_text = _tmp3_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = ctr;
					ctr = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp6_ = new_text;
					_tmp7_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_g_free0 (new_text);
					new_text = _tmp9_;
					_g_free0 (_tmp8_);
				}
			}
		}
	}
	_tmp10_ = new_text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ > 0) {
		GtkEntry* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = sender;
		_tmp14_ = new_text;
		_tmp15_ = new_text;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp14_, (gint) _tmp17_, position);
	}
	_tmp18_ = sender;
	g_signal_stop_emission_by_name (_tmp18_, "insert-text");
	self->priv->is_text_insertion_in_progress = FALSE;
	_g_free0 (new_text);
	_g_object_unref0 (sender);
}

static gboolean
custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                            GdkEventFocus* event)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_height = {0};
	Measurement _tmp6_ = {0};
	Measurement min_height = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_height = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp32_;
	GtkEntry* _tmp33_;
	Measurement _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = self->priv->local_content_height;
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	custom_print_tab_get_height_entry_value (self, &_tmp6_);
	new_height = _tmp6_;
	_tmp7_ = self->priv->source_job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_print_settings_unref0 (_tmp9_);
	min_height = _tmp11_;
	_tmp12_ = self->priv->source_job;
	_tmp13_ = print_job_get_local_settings (_tmp12_);
	_tmp14_ = _tmp13_;
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_print_settings_unref0 (_tmp14_);
	max_height = _tmp16_;
	_tmp18_ = min_height;
	if (measurement_is_less_than (&new_height, &_tmp18_)) {
		_tmp17_ = TRUE;
	} else {
		Measurement _tmp19_;
		_tmp19_ = max_height;
		_tmp17_ = measurement_is_greater_than (&new_height, &_tmp19_);
	}
	if (_tmp17_) {
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->priv->custom_height_entry;
		_tmp21_ = self->priv->local_content_height;
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_entry_set_text (_tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		result = FALSE;
		return result;
	}
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
		Measurement new_width = {0};
		Measurement _tmp24_;
		PrintJob* _tmp25_;
		Measurement _tmp26_;
		Measurement _tmp27_;
		GtkEntry* _tmp28_;
		Measurement _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = new_height;
		_tmp25_ = self->priv->source_job;
		_tmp26_ = new_height;
		measurement_init (&new_width, _tmp24_.value * print_job_get_source_aspect_ratio (_tmp25_), _tmp26_.unit);
		_tmp27_ = new_width;
		self->priv->local_content_width = _tmp27_;
		_tmp28_ = self->priv->custom_width_entry;
		_tmp29_ = new_width;
		_tmp30_ = custom_print_tab_format_measurement (self, &_tmp29_);
		_tmp31_ = _tmp30_;
		gtk_entry_set_text (_tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = new_height;
	self->priv->local_content_height = _tmp32_;
	_tmp33_ = self->priv->custom_height_entry;
	_tmp34_ = new_height;
	_tmp35_ = custom_print_tab_format_measurement (self, &_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_entry_set_text (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	result = FALSE;
	return result;
}

static MeasurementUnit
custom_print_tab_get_user_unit_choice (CustomPrintTab* self)
{
	GtkComboBoxText* _tmp0_;
	MeasurementUnit result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
	_tmp0_ = self->priv->units_combo;
	if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox)) == CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE) {
		result = MEASUREMENT_UNIT_INCHES;
		return result;
	} else {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = self->priv->units_combo;
		if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox)) == CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE) {
			result = MEASUREMENT_UNIT_CENTIMETERS;
			return result;
		} else {
			g_error ("Printing.vala:453: unknown unit combo box choice");
		}
	}
}

static void
custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                       MeasurementUnit unit)
{
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	if (unit == MEASUREMENT_UNIT_INCHES) {
		GtkComboBoxText* _tmp0_;
		_tmp0_ = self->priv->units_combo;
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE);
	} else {
		if (unit == MEASUREMENT_UNIT_CENTIMETERS) {
			GtkComboBoxText* _tmp1_;
			_tmp1_ = self->priv->units_combo;
			gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE);
		} else {
			g_error ("Printing.vala:463: unknown MeasurementUnit enumeration");
		}
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                        Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->custom_width_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
	*result = _tmp2_;
	return;
}

static void
custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                         Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
	*result = _tmp2_;
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                       GtkEditable* editable,
                                       const gchar* text,
                                       gint length,
                                       gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	const gchar* decimal_point = NULL;
	const gchar* _tmp3_;
	gboolean contains_decimal_point = FALSE;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* new_text = NULL;
	gchar* _tmp7_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GtkEntry* _tmp28_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_editable_get_type ()));
	g_return_if_fail (text != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
	sender = _tmp0_;
	if (self->priv->is_text_insertion_in_progress) {
		_g_object_unref0 (sender);
		return;
	}
	self->priv->is_text_insertion_in_progress = TRUE;
	if (length == -1) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (text);
		_tmp2_ = _tmp1_;
		length = (gint) _tmp2_;
	}
	_tmp3_ = nl_langinfo (RADIXCHAR);
	decimal_point = _tmp3_;
	_tmp4_ = sender;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = decimal_point;
	contains_decimal_point = string_contains (_tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("");
	new_text = _tmp7_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = ctr;
					ctr = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = new_text;
					_tmp11_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
					_g_free0 (new_text);
					new_text = _tmp13_;
					_g_free0 (_tmp12_);
				} else {
					gboolean _tmp14_ = FALSE;
					if (!contains_decimal_point) {
						const gchar* _tmp15_;
						_tmp15_ = decimal_point;
						_tmp14_ = string_get (text, (glong) ctr) == string_get (_tmp15_, (glong) 0);
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						const gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						_tmp16_ = new_text;
						_tmp17_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
						_tmp18_ = _tmp17_;
						_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
						_g_free0 (new_text);
						new_text = _tmp19_;
						_g_free0 (_tmp18_);
					}
				}
			}
		}
	}
	_tmp20_ = new_text;
	_tmp21_ = strlen (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		GtkEntry* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp23_ = sender;
		_tmp24_ = new_text;
		_tmp25_ = new_text;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp24_, (gint) _tmp27_, position);
	}
	_tmp28_ = sender;
	g_signal_stop_emission_by_name (_tmp28_, "insert-text");
	self->priv->is_text_insertion_in_progress = FALSE;
	_g_free0 (new_text);
	_g_object_unref0 (sender);
}

static void
custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                      PrintJob* job)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	Measurement _tmp2_ = {0};
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	Measurement _tmp5_ = {0};
	Measurement constrained_width = {0};
	PrintSettings* _tmp6_;
	PrintSettings* _tmp7_;
	Measurement _tmp8_ = {0};
	Measurement _tmp9_;
	PrintSettings* _tmp10_;
	PrintSettings* _tmp11_;
	gboolean _tmp12_;
	Measurement _tmp19_;
	PrintSettings* _tmp20_;
	PrintSettings* _tmp21_;
	Measurement _tmp22_ = {0};
	PrintSettings* _tmp23_;
	PrintSettings* _tmp24_;
	PrintSettings* _tmp25_;
	PrintSettings* _tmp26_;
	PrintSettings* _tmp27_;
	PrintSettings* _tmp28_;
	PrintSettings* _tmp29_;
	PrintSettings* _tmp30_;
	PrintSettings* _tmp31_;
	PrintSettings* _tmp32_;
	PrintSettings* _tmp33_;
	PrintSettings* _tmp34_;
	PrintSettings* _tmp35_;
	PrintSettings* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (IS_PRINT_JOB (job));
	_tmp0_ = print_job_get_local_settings (job);
	_tmp1_ = _tmp0_;
	print_settings_get_content_width (_tmp1_, &_tmp2_);
	_tmp3_ = print_job_get_local_settings (job);
	_tmp4_ = _tmp3_;
	print_settings_get_content_height (_tmp4_, &_tmp5_);
	_vala_assert (_tmp2_.unit == _tmp5_.unit, "job.get_local_settings().get_content_width().unit ==             job.get_local_settings().get_content_height().unit");
	_print_settings_unref0 (_tmp4_);
	_print_settings_unref0 (_tmp1_);
	_tmp6_ = print_job_get_local_settings (job);
	_tmp7_ = _tmp6_;
	print_settings_get_content_width (_tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	_print_settings_unref0 (_tmp7_);
	constrained_width = _tmp9_;
	_tmp10_ = print_job_get_local_settings (job);
	_tmp11_ = _tmp10_;
	_tmp12_ = print_settings_is_match_aspect_ratio_enabled (_tmp11_);
	_print_settings_unref0 (_tmp11_);
	if (_tmp12_) {
		PrintSettings* _tmp13_;
		PrintSettings* _tmp14_;
		Measurement _tmp15_ = {0};
		PrintSettings* _tmp16_;
		PrintSettings* _tmp17_;
		Measurement _tmp18_ = {0};
		_tmp13_ = print_job_get_local_settings (job);
		_tmp14_ = _tmp13_;
		print_settings_get_content_height (_tmp14_, &_tmp15_);
		_tmp16_ = print_job_get_local_settings (job);
		_tmp17_ = _tmp16_;
		print_settings_get_content_height (_tmp17_, &_tmp18_);
		measurement_init (&constrained_width, _tmp15_.value * print_job_get_source_aspect_ratio (job), _tmp18_.unit);
		_print_settings_unref0 (_tmp17_);
		_print_settings_unref0 (_tmp14_);
	}
	_tmp19_ = constrained_width;
	custom_print_tab_set_content_width (self, &_tmp19_);
	_tmp20_ = print_job_get_local_settings (job);
	_tmp21_ = _tmp20_;
	print_settings_get_content_height (_tmp21_, &_tmp22_);
	custom_print_tab_set_content_height (self, &_tmp22_);
	_print_settings_unref0 (_tmp21_);
	_tmp23_ = print_job_get_local_settings (job);
	_tmp24_ = _tmp23_;
	custom_print_tab_set_content_layout (self, print_settings_get_content_layout (_tmp24_));
	_print_settings_unref0 (_tmp24_);
	_tmp25_ = print_job_get_local_settings (job);
	_tmp26_ = _tmp25_;
	custom_print_tab_set_content_ppi (self, print_settings_get_content_ppi (_tmp26_));
	_print_settings_unref0 (_tmp26_);
	_tmp27_ = print_job_get_local_settings (job);
	_tmp28_ = _tmp27_;
	custom_print_tab_set_image_per_page_selection (self, print_settings_get_image_per_page_selection (_tmp28_));
	_print_settings_unref0 (_tmp28_);
	_tmp29_ = print_job_get_local_settings (job);
	_tmp30_ = _tmp29_;
	custom_print_tab_set_size_selection (self, print_settings_get_size_selection (_tmp30_));
	_print_settings_unref0 (_tmp30_);
	_tmp31_ = print_job_get_local_settings (job);
	_tmp32_ = _tmp31_;
	custom_print_tab_set_match_aspect_ratio_enabled (self, print_settings_is_match_aspect_ratio_enabled (_tmp32_));
	_print_settings_unref0 (_tmp32_);
	_tmp33_ = print_job_get_local_settings (job);
	_tmp34_ = _tmp33_;
	custom_print_tab_set_print_titles_enabled (self, print_settings_is_print_titles_enabled (_tmp34_));
	_print_settings_unref0 (_tmp34_);
	_tmp35_ = print_job_get_local_settings (job);
	_tmp36_ = _tmp35_;
	_tmp37_ = print_settings_get_print_titles_font (_tmp36_);
	_tmp38_ = _tmp37_;
	custom_print_tab_set_print_titles_font (self, _tmp38_);
	_g_free0 (_tmp38_);
	_print_settings_unref0 (_tmp36_);
}

static void
custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                       GtkButton* b)
{
	GtkRadioButton* sender = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, gtk_button_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, gtk_radio_button_get_type (), GtkRadioButton));
	sender = _tmp0_;
	_tmp1_ = sender;
	_tmp2_ = self->priv->standard_size_radio;
	if (_tmp1_ == _tmp2_) {
		GtkComboBoxText* _tmp3_;
		custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_STANDARD_SIZE);
		_tmp3_ = self->priv->standard_sizes_combo;
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkRadioButton* _tmp4_;
		GtkRadioButton* _tmp5_;
		_tmp4_ = sender;
		_tmp5_ = self->priv->custom_size_radio;
		if (_tmp4_ == _tmp5_) {
			GtkEntry* _tmp6_;
			custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_CUSTOM_SIZE);
			_tmp6_ = self->priv->custom_height_entry;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		} else {
			GtkRadioButton* _tmp7_;
			GtkRadioButton* _tmp8_;
			_tmp7_ = sender;
			_tmp8_ = self->priv->image_per_page_radio;
			if (_tmp7_ == _tmp8_) {
				custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_IMAGE_PER_PAGE);
			}
		}
	}
	_g_object_unref0 (sender);
}

static void
custom_print_tab_on_units_combo_changed (CustomPrintTab* self)
{
	GtkEntry* _tmp0_;
	Measurement _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkEntry* _tmp4_;
	Measurement _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = self->priv->local_content_height;
	_tmp2_ = custom_print_tab_format_measurement_as (self, &_tmp1_, custom_print_tab_get_user_unit_choice (self));
	_tmp3_ = _tmp2_;
	gtk_entry_set_text (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->custom_width_entry;
	_tmp5_ = self->priv->local_content_width;
	_tmp6_ = custom_print_tab_format_measurement_as (self, &_tmp5_, custom_print_tab_get_user_unit_choice (self));
	_tmp7_ = _tmp6_;
	gtk_entry_set_text (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
}

static void
custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                   ContentLayout layout)
{
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	switch (layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		{
			GtkComboBoxText* _tmp0_;
			GtkComboBoxText* _tmp1_;
			GtkEntry* _tmp2_;
			GtkEntry* _tmp3_;
			GtkCheckButton* _tmp4_;
			GtkComboBoxText* _tmp5_;
			_tmp0_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp1_ = self->priv->units_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp2_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp3_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp4_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp5_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
			break;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			GtkComboBoxText* _tmp6_;
			GtkComboBoxText* _tmp7_;
			GtkEntry* _tmp8_;
			GtkEntry* _tmp9_;
			GtkCheckButton* _tmp10_;
			GtkComboBoxText* _tmp11_;
			_tmp6_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp7_ = self->priv->units_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp8_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp9_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp10_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp11_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), FALSE);
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			GtkComboBoxText* _tmp12_;
			GtkComboBoxText* _tmp13_;
			GtkEntry* _tmp14_;
			GtkEntry* _tmp15_;
			GtkCheckButton* _tmp16_;
			GtkComboBoxText* _tmp17_;
			_tmp12_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp13_ = self->priv->units_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp14_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp15_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp16_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp17_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), TRUE);
			break;
		}
		default:
		{
			g_error ("Printing.vala:579: unknown ContentLayout enumeration value");
		}
	}
}

static gboolean
custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = g_value_get_string (&val);
	result = g_strcmp0 (_tmp2_, "-") == 0;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static void
custom_print_tab_set_content_layout (CustomPrintTab* self,
                                     ContentLayout content_layout)
{
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	custom_print_tab_set_content_layout_control_state (self, content_layout);
	switch (content_layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		{
			GtkRadioButton* _tmp0_;
			_tmp0_ = self->priv->standard_size_radio;
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
			break;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			GtkRadioButton* _tmp1_;
			_tmp1_ = self->priv->custom_size_radio;
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			GtkRadioButton* _tmp2_;
			_tmp2_ = self->priv->image_per_page_radio;
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
			break;
		}
		default:
		{
			g_error ("Printing.vala:607: unknown ContentLayout enumeration value");
		}
	}
}

static ContentLayout
custom_print_tab_get_content_layout (CustomPrintTab* self)
{
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	ContentLayout result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
	_tmp0_ = self->priv->standard_size_radio;
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton))) {
		result = CONTENT_LAYOUT_STANDARD_SIZE;
		return result;
	}
	_tmp1_ = self->priv->custom_size_radio;
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton))) {
		result = CONTENT_LAYOUT_CUSTOM_SIZE;
		return result;
	}
	_tmp2_ = self->priv->image_per_page_radio;
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton))) {
		result = CONTENT_LAYOUT_IMAGE_PER_PAGE;
		return result;
	}
	g_error ("Printing.vala:619: inconsistent content layout radio button group stat" \
"e");
}

static void
custom_print_tab_set_content_width (CustomPrintTab* self,
                                    Measurement* content_width)
{
	Measurement _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp9_;
	GtkEntry* _tmp10_;
	Measurement _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (content_width != NULL);
	_tmp0_ = *content_width;
	_tmp1_ = self->priv->local_content_height;
	if (_tmp0_.unit != _tmp1_.unit) {
		Measurement _tmp2_;
		Measurement _tmp3_;
		Measurement _tmp4_ = {0};
		GtkEntry* _tmp5_;
		Measurement _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = *content_width;
		custom_print_tab_set_user_unit_choice (self, _tmp2_.unit);
		_tmp3_ = *content_width;
		measurement_convert_to (&self->priv->local_content_height, _tmp3_.unit, &_tmp4_);
		self->priv->local_content_height = _tmp4_;
		_tmp5_ = self->priv->custom_height_entry;
		_tmp6_ = self->priv->local_content_height;
		_tmp7_ = custom_print_tab_format_measurement (self, &_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_entry_set_text (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_tmp9_ = *content_width;
	self->priv->local_content_width = _tmp9_;
	_tmp10_ = self->priv->custom_width_entry;
	_tmp11_ = *content_width;
	_tmp12_ = custom_print_tab_format_measurement (self, &_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_entry_set_text (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}

static void
custom_print_tab_get_content_width (CustomPrintTab* self,
                                    Measurement* result)
{
	Measurement _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->local_content_width;
	*result = _tmp0_;
	return;
}

static void
custom_print_tab_set_content_height (CustomPrintTab* self,
                                     Measurement* content_height)
{
	Measurement _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp9_;
	GtkEntry* _tmp10_;
	Measurement _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (content_height != NULL);
	_tmp0_ = *content_height;
	_tmp1_ = self->priv->local_content_width;
	if (_tmp0_.unit != _tmp1_.unit) {
		Measurement _tmp2_;
		Measurement _tmp3_;
		Measurement _tmp4_ = {0};
		GtkEntry* _tmp5_;
		Measurement _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = *content_height;
		custom_print_tab_set_user_unit_choice (self, _tmp2_.unit);
		_tmp3_ = *content_height;
		measurement_convert_to (&self->priv->local_content_width, _tmp3_.unit, &_tmp4_);
		self->priv->local_content_width = _tmp4_;
		_tmp5_ = self->priv->custom_width_entry;
		_tmp6_ = self->priv->local_content_width;
		_tmp7_ = custom_print_tab_format_measurement (self, &_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_entry_set_text (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_tmp9_ = *content_height;
	self->priv->local_content_height = _tmp9_;
	_tmp10_ = self->priv->custom_height_entry;
	_tmp11_ = *content_height;
	_tmp12_ = custom_print_tab_format_measurement (self, &_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_entry_set_text (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}

static void
custom_print_tab_get_content_height (CustomPrintTab* self,
                                     Measurement* result)
{
	Measurement _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->local_content_height;
	*result = _tmp0_;
	return;
}

static void
custom_print_tab_set_content_ppi (CustomPrintTab* self,
                                  gint content_ppi)
{
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	self->priv->local_content_ppi = CLAMP (content_ppi, PRINT_SETTINGS_MIN_CONTENT_PPI, PRINT_SETTINGS_MAX_CONTENT_PPI);
	_tmp0_ = self->priv->ppi_entry;
	_tmp1_ = g_strdup_printf ("%d", self->priv->local_content_ppi);
	_tmp2_ = _tmp1_;
	gtk_entry_set_text (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static gint
custom_print_tab_get_content_ppi (CustomPrintTab* self)
{
	gint result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
	result = self->priv->local_content_ppi;
	return result;
}

static void
custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                               gint image_per_page)
{
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->image_per_page_combo;
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), image_per_page);
}

static gint
custom_print_tab_get_image_per_page_selection (CustomPrintTab* self)
{
	GtkComboBoxText* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
	_tmp0_ = self->priv->image_per_page_combo;
	result = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
	return result;
}

static void
custom_print_tab_set_size_selection (CustomPrintTab* self,
                                     gint size_selection)
{
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->standard_sizes_combo;
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), size_selection);
}

static gint
custom_print_tab_get_size_selection (CustomPrintTab* self)
{
	GtkComboBoxText* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
	_tmp0_ = self->priv->standard_sizes_combo;
	result = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
	return result;
}

static void
custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                 gboolean enable_state)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->aspect_ratio_check;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), enable_state);
}

static void
custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                           gboolean print_titles)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	_tmp0_ = self->priv->title_print_check;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), print_titles);
}

static void
custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                        const gchar* fontname)
{
	GtkFontButton* _tmp0_;
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
	g_return_if_fail (fontname != NULL);
	_tmp0_ = self->priv->title_print_font;
	gtk_font_chooser_set_font (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_font_chooser_get_type (), GtkFontChooser), fontname);
}

static gboolean
custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
	_tmp0_ = self->priv->aspect_ratio_check;
	result = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	return result;
}

static gboolean
custom_print_tab_is_print_titles_enabled (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
	_tmp0_ = self->priv->title_print_check;
	result = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	return result;
}

static gchar*
custom_print_tab_get_print_titles_font (CustomPrintTab* self)
{
	GtkFontButton* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
	_tmp0_ = self->priv->title_print_font;
	_tmp1_ = gtk_font_chooser_get_font (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_font_chooser_get_type (), GtkFontChooser));
	result = _tmp1_;
	return result;
}

PrintJob*
custom_print_tab_get_source_job (CustomPrintTab* self)
{
	PrintJob* _tmp0_;
	PrintJob* _tmp1_;
	PrintJob* result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
	_tmp0_ = self->priv->source_job;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

PrintSettings*
custom_print_tab_get_local_settings (CustomPrintTab* self)
{
	PrintSettings* _result_ = NULL;
	PrintSettings* _tmp0_;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	PrintSettings* result;
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
	_tmp0_ = print_settings_new ();
	_result_ = _tmp0_;
	custom_print_tab_get_content_width (self, &_tmp1_);
	print_settings_set_content_width (_result_, &_tmp1_);
	custom_print_tab_get_content_height (self, &_tmp2_);
	print_settings_set_content_height (_result_, &_tmp2_);
	print_settings_set_content_layout (_result_, custom_print_tab_get_content_layout (self));
	print_settings_set_content_ppi (_result_, custom_print_tab_get_content_ppi (self));
	print_settings_set_image_per_page_selection (_result_, custom_print_tab_get_image_per_page_selection (self));
	print_settings_set_size_selection (_result_, custom_print_tab_get_size_selection (self));
	print_settings_set_match_aspect_ratio_enabled (_result_, custom_print_tab_is_match_aspect_ratio_enabled (self));
	print_settings_set_print_titles_enabled (_result_, custom_print_tab_is_print_titles_enabled (self));
	_tmp3_ = custom_print_tab_get_print_titles_font (self);
	_tmp4_ = _tmp3_;
	print_settings_set_print_titles_font (_result_, _tmp4_);
	_g_free0 (_tmp4_);
	result = _result_;
	return result;
}

static void
custom_print_tab_class_init (CustomPrintTabClass * klass,
                             gpointer klass_data)
{
	custom_print_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CustomPrintTab_private_offset);
	G_OBJECT_CLASS (klass)->finalize = custom_print_tab_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Shotwell/ui/printing_widget.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_size_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_size_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_sizes_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_sizes_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "units_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, units_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_width_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_width_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_height_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_height_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ppi_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, ppi_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aspect_ratio_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, aspect_ratio_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_font", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_font));
}

static void
custom_print_tab_instance_init (CustomPrintTab * self,
                                gpointer klass)
{
	self->priv = custom_print_tab_get_instance_private (self);
	measurement_init (&self->priv->local_content_width, 5.0, MEASUREMENT_UNIT_INCHES);
	measurement_init (&self->priv->local_content_height, 5.0, MEASUREMENT_UNIT_INCHES);
	self->priv->is_text_insertion_in_progress = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
custom_print_tab_finalize (GObject * obj)
{
	CustomPrintTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
	_g_object_unref0 (self->priv->source_job);
	G_OBJECT_CLASS (custom_print_tab_parent_class)->finalize (obj);
}

static GType
custom_print_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CustomPrintTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_print_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomPrintTab), 0, (GInstanceInitFunc) custom_print_tab_instance_init, NULL };
	GType custom_print_tab_type_id;
	custom_print_tab_type_id = g_type_register_static (gtk_box_get_type (), "CustomPrintTab", &g_define_type_info, 0);
	CustomPrintTab_private_offset = g_type_add_instance_private (custom_print_tab_type_id, sizeof (CustomPrintTabPrivate));
	return custom_print_tab_type_id;
}

GType
custom_print_tab_get_type (void)
{
	static volatile gsize custom_print_tab_type_id__once = 0;
	if (g_once_init_enter (&custom_print_tab_type_id__once)) {
		GType custom_print_tab_type_id;
		custom_print_tab_type_id = custom_print_tab_get_type_once ();
		g_once_init_leave (&custom_print_tab_type_id__once, custom_print_tab_type_id);
	}
	return custom_print_tab_type_id__once;
}

static inline gpointer
print_job_get_instance_private (PrintJob* self)
{
	return G_STRUCT_MEMBER_P (self, PrintJob_private_offset);
}

PrintJob*
print_job_construct (GType object_type,
                     GeeCollection* to_print)
{
	PrintJob * self = NULL;
	PrintManager* _tmp0_;
	PrintManager* _tmp1_;
	PrintSettings* _tmp2_;
	GeeArrayList* _tmp3_;
	gdouble photo_aspect_ratio = 0.0;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	Photo* _tmp6_;
	Dimensions _tmp7_ = {0};
	gdouble _tmp8_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_print, GEE_TYPE_COLLECTION), NULL);
	self = (PrintJob*) g_object_new (object_type, NULL);
	_tmp0_ = print_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = print_manager_get_global_settings (_tmp1_);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_print_manager_unref0 (_tmp1_);
	_tmp3_ = self->priv->photos;
	gee_array_list_add_all (_tmp3_, to_print);
	gtk_print_operation_set_embed_page_setup (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_print_operation_get_type (), GtkPrintOperation), TRUE);
	_tmp4_ = self->priv->photos;
	_tmp5_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
	_tmp6_ = (Photo*) _tmp5_;
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp7_);
	_tmp8_ = dimensions_get_aspect_ratio (&_tmp7_);
	_g_object_unref0 (_tmp6_);
	photo_aspect_ratio = _tmp8_;
	if (photo_aspect_ratio < 1.0) {
		photo_aspect_ratio = 1.0 / photo_aspect_ratio;
	}
	return self;
}

PrintJob*
print_job_new (GeeCollection* to_print)
{
	return print_job_construct (TYPE_PRINT_JOB, to_print);
}

GeeList*
print_job_get_photos (PrintJob* self)
{
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
	_tmp0_ = self->priv->photos;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList));
	result = _tmp1_;
	return result;
}

Photo*
print_job_get_source_photo (PrintJob* self)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	Photo* result;
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
	_tmp0_ = self->priv->photos;
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
	result = (Photo*) _tmp1_;
	return result;
}

gdouble
print_job_get_source_aspect_ratio (PrintJob* self)
{
	gdouble aspect_ratio = 0.0;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble result;
	g_return_val_if_fail (IS_PRINT_JOB (self), 0.0);
	_tmp0_ = self->priv->photos;
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
	_tmp2_ = (Photo*) _tmp1_;
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp3_);
	_tmp4_ = dimensions_get_aspect_ratio (&_tmp3_);
	_g_object_unref0 (_tmp2_);
	aspect_ratio = _tmp4_;
	if (aspect_ratio < 1.0) {
		_tmp5_ = 1.0 / aspect_ratio;
	} else {
		_tmp5_ = aspect_ratio;
	}
	result = _tmp5_;
	return result;
}

static gpointer
_print_settings_ref0 (gpointer self)
{
	return self ? print_settings_ref (self) : NULL;
}

PrintSettings*
print_job_get_local_settings (PrintJob* self)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	PrintSettings* result;
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _print_settings_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
print_job_set_local_settings (PrintJob* self,
                              PrintSettings* settings)
{
	PrintSettings* _tmp0_;
	g_return_if_fail (IS_PRINT_JOB (self));
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
	_tmp0_ = _print_settings_ref0 (settings);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
}

static void
print_job_class_init (PrintJobClass * klass,
                      gpointer klass_data)
{
	print_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintJob_private_offset);
	G_OBJECT_CLASS (klass)->finalize = print_job_finalize;
}

static void
print_job_instance_init (PrintJob * self,
                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = print_job_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->photos = _tmp0_;
}

static void
print_job_finalize (GObject * obj)
{
	PrintJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_JOB, PrintJob);
	_print_settings_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->photos);
	G_OBJECT_CLASS (print_job_parent_class)->finalize (obj);
}

static GType
print_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintJob), 0, (GInstanceInitFunc) print_job_instance_init, NULL };
	GType print_job_type_id;
	print_job_type_id = g_type_register_static (gtk_print_operation_get_type (), "PrintJob", &g_define_type_info, 0);
	PrintJob_private_offset = g_type_add_instance_private (print_job_type_id, sizeof (PrintJobPrivate));
	return print_job_type_id;
}

GType
print_job_get_type (void)
{
	static volatile gsize print_job_type_id__once = 0;
	if (g_once_init_enter (&print_job_type_id__once)) {
		GType print_job_type_id;
		print_job_type_id = print_job_get_type_once ();
		g_once_init_leave (&print_job_type_id__once, print_job_type_id);
	}
	return print_job_type_id__once;
}

StandardPrintSize*
standard_print_size_construct (GType object_type,
                               const gchar* name,
                               Measurement* width,
                               Measurement* height)
{
	StandardPrintSize* self = NULL;
	gchar* _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (width != NULL, NULL);
	g_return_val_if_fail (height != NULL, NULL);
	self = (StandardPrintSize*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = *width;
	self->width = _tmp1_;
	_tmp2_ = *height;
	self->height = _tmp2_;
	return self;
}

StandardPrintSize*
standard_print_size_new (const gchar* name,
                         Measurement* width,
                         Measurement* height)
{
	return standard_print_size_construct (TYPE_STANDARD_PRINT_SIZE, name, width, height);
}

static void
value_standard_print_size_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_standard_print_size_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		standard_print_size_unref (value->data[0].v_pointer);
	}
}

static void
value_standard_print_size_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = standard_print_size_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_standard_print_size_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_standard_print_size_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		StandardPrintSize * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = standard_print_size_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_standard_print_size_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	StandardPrintSize ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = standard_print_size_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_standard_print_size (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecStandardPrintSize* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STANDARD_PRINT_SIZE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_standard_print_size (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_standard_print_size (GValue* value,
                               gpointer v_object)
{
	StandardPrintSize * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		standard_print_size_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		standard_print_size_unref (old);
	}
}

void
value_take_standard_print_size (GValue* value,
                                gpointer v_object)
{
	StandardPrintSize * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		standard_print_size_unref (old);
	}
}

static void
standard_print_size_class_init (StandardPrintSizeClass * klass,
                                gpointer klass_data)
{
	standard_print_size_parent_class = g_type_class_peek_parent (klass);
	((StandardPrintSizeClass *) klass)->finalize = standard_print_size_finalize;
}

static void
standard_print_size_instance_init (StandardPrintSize * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
standard_print_size_finalize (StandardPrintSize * obj)
{
	StandardPrintSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANDARD_PRINT_SIZE, StandardPrintSize);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
}

static GType
standard_print_size_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_standard_print_size_init, value_standard_print_size_free_value, value_standard_print_size_copy_value, value_standard_print_size_peek_pointer, "p", value_standard_print_size_collect_value, "p", value_standard_print_size_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (StandardPrintSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) standard_print_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StandardPrintSize), 0, (GInstanceInitFunc) standard_print_size_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType standard_print_size_type_id;
	standard_print_size_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StandardPrintSize", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return standard_print_size_type_id;
}

GType
standard_print_size_get_type (void)
{
	static volatile gsize standard_print_size_type_id__once = 0;
	if (g_once_init_enter (&standard_print_size_type_id__once)) {
		GType standard_print_size_type_id;
		standard_print_size_type_id = standard_print_size_get_type_once ();
		g_once_init_leave (&standard_print_size_type_id__once, standard_print_size_type_id);
	}
	return standard_print_size_type_id__once;
}

gpointer
standard_print_size_ref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
standard_print_size_unref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STANDARD_PRINT_SIZE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
print_manager_get_instance_private (PrintManager* self)
{
	return G_STRUCT_MEMBER_P (self, PrintManager_private_offset);
}

static PrintManager*
print_manager_construct (GType object_type)
{
	PrintManager* self = NULL;
	GtkPageSetup* _tmp0_;
	PrintSettings* _tmp1_;
	self = (PrintManager*) g_type_create_instance (object_type);
	_tmp0_ = gtk_page_setup_new ();
	_g_object_unref0 (self->priv->user_page_setup);
	self->priv->user_page_setup = _tmp0_;
	_tmp1_ = print_settings_new ();
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	return self;
}

static PrintManager*
print_manager_new (void)
{
	return print_manager_construct (TYPE_PRINT_MANAGER);
}

static void
_vala_array_add108 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add109 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add110 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add111 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add112 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add113 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add114 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add115 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add116 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add117 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add118 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add119 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add120 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add121 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add122 (StandardPrintSize** * array,
                    gint* length,
                    gint* size,
                    StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

StandardPrintSize**
print_manager_get_standard_sizes (PrintManager* self,
                                  gint* result_length1)
{
	StandardPrintSize** _tmp0_;
	gint _tmp0__length1;
	StandardPrintSize** _tmp47_;
	gint _tmp47__length1;
	StandardPrintSize** _tmp48_;
	gint _tmp48__length1;
	StandardPrintSize** result;
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
	_tmp0_ = self->priv->standard_sizes;
	_tmp0__length1 = self->priv->standard_sizes_length1;
	if (_tmp0_ == NULL) {
		StandardPrintSize** _tmp1_;
		Measurement _tmp2_ = {0};
		Measurement _tmp3_ = {0};
		StandardPrintSize* _tmp4_;
		Measurement _tmp5_ = {0};
		Measurement _tmp6_ = {0};
		StandardPrintSize* _tmp7_;
		Measurement _tmp8_ = {0};
		Measurement _tmp9_ = {0};
		StandardPrintSize* _tmp10_;
		Measurement _tmp11_ = {0};
		Measurement _tmp12_ = {0};
		StandardPrintSize* _tmp13_;
		Measurement _tmp14_ = {0};
		Measurement _tmp15_ = {0};
		StandardPrintSize* _tmp16_;
		Measurement _tmp17_ = {0};
		Measurement _tmp18_ = {0};
		StandardPrintSize* _tmp19_;
		Measurement _tmp20_ = {0};
		Measurement _tmp21_ = {0};
		StandardPrintSize* _tmp22_;
		Measurement _tmp23_ = {0};
		Measurement _tmp24_ = {0};
		StandardPrintSize* _tmp25_;
		Measurement _tmp26_ = {0};
		Measurement _tmp27_ = {0};
		StandardPrintSize* _tmp28_;
		Measurement _tmp29_ = {0};
		Measurement _tmp30_ = {0};
		StandardPrintSize* _tmp31_;
		Measurement _tmp32_ = {0};
		Measurement _tmp33_ = {0};
		StandardPrintSize* _tmp34_;
		Measurement _tmp35_ = {0};
		Measurement _tmp36_ = {0};
		StandardPrintSize* _tmp37_;
		Measurement _tmp38_ = {0};
		Measurement _tmp39_ = {0};
		StandardPrintSize* _tmp40_;
		Measurement _tmp41_ = {0};
		Measurement _tmp42_ = {0};
		StandardPrintSize* _tmp43_;
		Measurement _tmp44_ = {0};
		Measurement _tmp45_ = {0};
		StandardPrintSize* _tmp46_;
		_tmp1_ = g_new0 (StandardPrintSize*, 0 + 1);
		self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
		self->priv->standard_sizes = _tmp1_;
		self->priv->standard_sizes_length1 = 0;
		self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
		measurement_init (&_tmp2_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp3_, (gdouble) 2, MEASUREMENT_UNIT_INCHES);
		_tmp4_ = standard_print_size_new (_ ("Wallet (2 × 3 in.)"), &_tmp2_, &_tmp3_);
		_vala_array_add108 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp4_);
		measurement_init (&_tmp5_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp6_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
		_tmp7_ = standard_print_size_new (_ ("Notecard (3 × 5 in.)"), &_tmp5_, &_tmp6_);
		_vala_array_add109 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp7_);
		measurement_init (&_tmp8_, (gdouble) 6, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp9_, (gdouble) 4, MEASUREMENT_UNIT_INCHES);
		_tmp10_ = standard_print_size_new (_ ("4 × 6 in."), &_tmp8_, &_tmp9_);
		_vala_array_add110 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp10_);
		measurement_init (&_tmp11_, (gdouble) 7, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp12_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
		_tmp13_ = standard_print_size_new (_ ("5 × 7 in."), &_tmp11_, &_tmp12_);
		_vala_array_add111 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp13_);
		measurement_init (&_tmp14_, (gdouble) 10, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp15_, (gdouble) 8, MEASUREMENT_UNIT_INCHES);
		_tmp16_ = standard_print_size_new (_ ("8 × 10 in."), &_tmp14_, &_tmp15_);
		_vala_array_add112 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp16_);
		measurement_init (&_tmp17_, (gdouble) 14, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp18_, (gdouble) 11, MEASUREMENT_UNIT_INCHES);
		_tmp19_ = standard_print_size_new (_ ("11 × 14 in."), &_tmp17_, &_tmp18_);
		_vala_array_add113 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp19_);
		measurement_init (&_tmp20_, (gdouble) 20, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp21_, (gdouble) 16, MEASUREMENT_UNIT_INCHES);
		_tmp22_ = standard_print_size_new (_ ("16 × 20 in."), &_tmp20_, &_tmp21_);
		_vala_array_add114 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp22_);
		measurement_init (&_tmp23_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
		measurement_init (&_tmp24_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
		_tmp25_ = standard_print_size_new ("-", &_tmp23_, &_tmp24_);
		_vala_array_add115 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp25_);
		measurement_init (&_tmp26_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp27_, (gdouble) 9, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp28_ = standard_print_size_new (_ ("Metric Wallet (9 × 13 cm)"), &_tmp26_, &_tmp27_);
		_vala_array_add116 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp28_);
		measurement_init (&_tmp29_, (gdouble) 15, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp30_, (gdouble) 10, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp31_ = standard_print_size_new (_ ("Postcard (10 × 15 cm)"), &_tmp29_, &_tmp30_);
		_vala_array_add117 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp31_);
		measurement_init (&_tmp32_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp33_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp34_ = standard_print_size_new (_ ("13 × 18 cm"), &_tmp32_, &_tmp33_);
		_vala_array_add118 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp34_);
		measurement_init (&_tmp35_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp36_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp37_ = standard_print_size_new (_ ("18 × 24 cm"), &_tmp35_, &_tmp36_);
		_vala_array_add119 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp37_);
		measurement_init (&_tmp38_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp39_, (gdouble) 20, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp40_ = standard_print_size_new (_ ("20 × 30 cm"), &_tmp38_, &_tmp39_);
		_vala_array_add120 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp40_);
		measurement_init (&_tmp41_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp42_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp43_ = standard_print_size_new (_ ("24 × 40 cm"), &_tmp41_, &_tmp42_);
		_vala_array_add121 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp43_);
		measurement_init (&_tmp44_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
		measurement_init (&_tmp45_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
		_tmp46_ = standard_print_size_new (_ ("30 × 40 cm"), &_tmp44_, &_tmp45_);
		_vala_array_add122 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp46_);
	}
	_tmp47_ = self->priv->standard_sizes;
	_tmp47__length1 = self->priv->standard_sizes_length1;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _tmp47__length1;
	if (result_length1) {
		*result_length1 = _tmp48__length1;
	}
	result = _tmp48_;
	return result;
}

static gpointer
_print_manager_ref0 (gpointer self)
{
	return self ? print_manager_ref (self) : NULL;
}

PrintManager*
print_manager_get_instance (void)
{
	PrintManager* _tmp0_;
	PrintManager* _tmp2_;
	PrintManager* _tmp3_;
	PrintManager* result;
	_tmp0_ = print_manager_instance;
	if (_tmp0_ == NULL) {
		PrintManager* _tmp1_;
		_tmp1_ = print_manager_new ();
		_print_manager_unref0 (print_manager_instance);
		print_manager_instance = _tmp1_;
	}
	_tmp2_ = print_manager_instance;
	_tmp3_ = _print_manager_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                               GtkPrintContext* context,
                                                               gpointer self)
{
	print_manager_on_begin_print ((PrintManager*) self, _sender, context);
}

static void
_print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                           GtkPrintContext* context,
                                                           gint page_nr,
                                                           gpointer self)
{
	print_manager_on_draw_page ((PrintManager*) self, _sender, context, page_nr);
}

static GObject*
_print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                 gpointer self)
{
	GObject* result;
	result = print_manager_on_create_custom_widget ((PrintManager*) self, _sender);
	return result;
}

static void
_print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                     gpointer self)
{
	print_manager_on_status_changed ((PrintManager*) self, _sender);
}

void
print_manager_spool_photo (PrintManager* self,
                           GeeCollection* to_print)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkPageSetup* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GCancellable* _tmp8_;
	AppWindow* _tmp9_;
	AppWindow* _tmp10_;
	GCancellable* _tmp11_;
	ProgressDialog* _tmp12_;
	gchar* err_msg = NULL;
	ProgressDialog* _tmp21_;
	AppWindow* _tmp22_;
	AppWindow* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_print, GEE_TYPE_COLLECTION));
	_tmp0_ = print_job_new (to_print);
	job = _tmp0_;
	gtk_print_operation_set_custom_tab_label (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _ ("Image Settings"));
	gtk_print_operation_set_unit (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_UNIT_INCH);
	gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), 1);
	_tmp1_ = print_job_get_source_photo (job);
	_tmp2_ = _tmp1_;
	_tmp3_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
	_tmp4_ = _tmp3_;
	gtk_print_operation_set_job_name (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = self->priv->user_page_setup;
	gtk_print_operation_set_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp5_);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "begin-print", (GCallback) _print_manager_on_begin_print_gtk_print_operation_begin_print, self);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "draw-page", (GCallback) _print_manager_on_draw_page_gtk_print_operation_draw_page, self);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "create-custom-widget", (GCallback) _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget, self);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "status-changed", (GCallback) _print_manager_on_status_changed_gtk_print_operation_status_changed, self);
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp7_);
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp8_;
	_tmp9_ = app_window_get_instance ();
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->cancellable;
	_tmp12_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), _ ("Printing…"), _tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp12_;
	_g_object_unref0 (_tmp10_);
	err_msg = NULL;
	{
		GtkPrintOperationResult _result_ = 0;
		AppWindow* _tmp13_;
		AppWindow* _tmp14_;
		GtkPrintOperationResult _tmp15_;
		_tmp13_ = app_window_get_instance ();
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_print_operation_run (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_window_get_type (), GtkWindow), &_inner_error0_);
		_g_object_unref0 (_tmp14_);
		_result_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_result_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
			GtkPageSetup* _tmp16_;
			GtkPageSetup* _tmp17_;
			_tmp16_ = gtk_print_operation_get_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
			_tmp17_ = _g_object_ref0 (_tmp16_);
			_g_object_unref0 (self->priv->user_page_setup);
			self->priv->user_page_setup = _tmp17_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (err_msg);
		err_msg = _tmp20_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (err_msg);
		_g_object_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp21_ = self->priv->progress_dialog;
	progress_dialog_close (_tmp21_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = NULL;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
	_tmp22_ = app_window_get_instance ();
	_tmp23_ = _tmp22_;
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp23_);
	_tmp24_ = err_msg;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = err_msg;
		_tmp26_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp25_);
		_tmp27_ = _tmp26_;
		app_window_error_message (_tmp27_, NULL);
		_g_free0 (_tmp27_);
	}
	_g_free0 (err_msg);
	_g_object_unref0 (job);
}

static void
print_manager_on_begin_print (PrintManager* self,
                              GtkPrintOperation* emitting_object,
                              GtkPrintContext* job_context)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GeeList* photos = NULL;
	PrintJob* _tmp5_;
	GeeList* _tmp6_;
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emitting_object, gtk_print_operation_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (job_context, gtk_print_context_get_type ()));
	g_debug ("Printing.vala:888: on_begin_print");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	job = _tmp0_;
	_tmp2_ = self->priv->cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->cancellable;
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PrintJob* _tmp4_;
		_tmp4_ = job;
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_print_operation_get_type (), GtkPrintOperation));
		_g_object_unref0 (job);
		return;
	}
	_tmp5_ = job;
	_tmp6_ = print_job_get_photos (_tmp5_);
	photos = _tmp6_;
	_tmp7_ = job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = print_settings_get_content_layout (_tmp9_) == CONTENT_LAYOUT_IMAGE_PER_PAGE;
	_print_settings_unref0 (_tmp9_);
	if (_tmp10_) {
		PrintLayout layout = 0;
		PrintJob* _tmp11_;
		PrintSettings* _tmp12_;
		PrintSettings* _tmp13_;
		PrintLayout _tmp14_;
		PrintJob* _tmp15_;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp11_ = job;
		_tmp12_ = print_job_get_local_settings (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp13_);
		_print_settings_unref0 (_tmp13_);
		layout = _tmp14_;
		_tmp15_ = job;
		_tmp16_ = photos;
		_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp18_ = _tmp17_;
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_print_operation_get_type (), GtkPrintOperation), (gint) ceil (((gdouble) _tmp18_) / ((gdouble) print_layout_get_per_page (layout))));
	} else {
		PrintJob* _tmp19_;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = job;
		_tmp20_ = photos;
		_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp22_ = _tmp21_;
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_print_operation_get_type (), GtkPrintOperation), _tmp22_);
	}
	spin_event_loop ();
	_g_object_unref0 (photos);
	_g_object_unref0 (job);
}

static void
print_manager_on_status_changed (PrintManager* self,
                                 GtkPrintOperation* job)
{
	const gchar* _tmp0_;
	ProgressDialog* _tmp1_;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (job, gtk_print_operation_get_type ()));
	_tmp0_ = gtk_print_operation_get_status_string (job);
	g_debug ("Printing.vala:911: on_status_changed: %s", _tmp0_);
	_tmp1_ = self->priv->progress_dialog;
	if (_tmp1_ != NULL) {
		ProgressDialog* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->progress_dialog;
		_tmp3_ = gtk_print_operation_get_status_string (job);
		progress_dialog_set_status (_tmp2_, _tmp3_);
		spin_event_loop ();
	}
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static void
print_manager_on_draw_page (PrintManager* self,
                            GtkPrintOperation* emitting_object,
                            GtkPrintContext* job_context,
                            gint page_num)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GtkPageSetup* page_setup = NULL;
	GtkPageSetup* _tmp5_;
	GtkPageSetup* _tmp6_;
	gdouble page_width = 0.0;
	GtkPageSetup* _tmp7_;
	gdouble page_height = 0.0;
	GtkPageSetup* _tmp8_;
	gdouble dpi = 0.0;
	PrintJob* _tmp9_;
	PrintSettings* _tmp10_;
	PrintSettings* _tmp11_;
	gdouble _tmp12_;
	gdouble inv_dpi = 0.0;
	cairo_t* dc = NULL;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	GeeList* photos = NULL;
	PrintJob* _tmp16_;
	GeeList* _tmp17_;
	ContentLayout content_layout = 0;
	PrintJob* _tmp18_;
	PrintSettings* _tmp19_;
	PrintSettings* _tmp20_;
	ContentLayout _tmp21_;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emitting_object, gtk_print_operation_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (job_context, gtk_print_context_get_type ()));
	g_debug ("Printing.vala:921: on_draw_page");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	job = _tmp0_;
	_tmp2_ = self->priv->cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->cancellable;
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PrintJob* _tmp4_;
		_tmp4_ = job;
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_print_operation_get_type (), GtkPrintOperation));
		_g_object_unref0 (job);
		return;
	}
	spin_event_loop ();
	_tmp5_ = gtk_print_context_get_page_setup (job_context);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	page_setup = _tmp6_;
	_tmp7_ = page_setup;
	page_width = gtk_page_setup_get_page_width (_tmp7_, GTK_UNIT_INCH);
	_tmp8_ = page_setup;
	page_height = gtk_page_setup_get_page_height (_tmp8_, GTK_UNIT_INCH);
	_tmp9_ = job;
	_tmp10_ = print_job_get_local_settings (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = (gdouble) print_settings_get_content_ppi (_tmp11_);
	_print_settings_unref0 (_tmp11_);
	dpi = _tmp12_;
	inv_dpi = 1.0 / dpi;
	_tmp13_ = gtk_print_context_get_cairo_context (job_context);
	_tmp14_ = _cairo_reference0 (_tmp13_);
	dc = _tmp14_;
	_tmp15_ = dc;
	cairo_scale (_tmp15_, inv_dpi, inv_dpi);
	_tmp16_ = job;
	_tmp17_ = print_job_get_photos (_tmp16_);
	photos = _tmp17_;
	_tmp18_ = job;
	_tmp19_ = print_job_get_local_settings (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = print_settings_get_content_layout (_tmp20_);
	_print_settings_unref0 (_tmp20_);
	content_layout = _tmp21_;
	switch (content_layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			GeeList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			ProgressDialog* _tmp68_;
			if (content_layout == CONTENT_LAYOUT_STANDARD_SIZE) {
				gint _tmp22_ = 0;
				StandardPrintSize** _tmp23_;
				PrintJob* _tmp24_;
				PrintSettings* _tmp25_;
				PrintSettings* _tmp26_;
				StandardPrintSize* _tmp27_;
				Measurement _tmp28_ = {0};
				gint _tmp29_ = 0;
				StandardPrintSize** _tmp30_;
				PrintJob* _tmp31_;
				PrintSettings* _tmp32_;
				PrintSettings* _tmp33_;
				StandardPrintSize* _tmp34_;
				Measurement _tmp35_ = {0};
				_tmp23_ = print_manager_get_standard_sizes (self, &_tmp22_);
				_tmp24_ = job;
				_tmp25_ = print_job_get_local_settings (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp23_[print_settings_get_size_selection (_tmp26_)];
				measurement_convert_to (&_tmp27_->width, MEASUREMENT_UNIT_INCHES, &_tmp28_);
				canvas_width = _tmp28_.value;
				_print_settings_unref0 (_tmp26_);
				_tmp30_ = print_manager_get_standard_sizes (self, &_tmp29_);
				_tmp31_ = job;
				_tmp32_ = print_job_get_local_settings (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp30_[print_settings_get_size_selection (_tmp33_)];
				measurement_convert_to (&_tmp34_->height, MEASUREMENT_UNIT_INCHES, &_tmp35_);
				canvas_height = _tmp35_.value;
				_print_settings_unref0 (_tmp33_);
			} else {
				PrintJob* _tmp36_;
				PrintSettings* _tmp37_;
				PrintSettings* _tmp38_;
				Measurement _tmp39_ = {0};
				Measurement _tmp40_ = {0};
				PrintJob* _tmp41_;
				PrintSettings* _tmp42_;
				PrintSettings* _tmp43_;
				Measurement _tmp44_ = {0};
				Measurement _tmp45_ = {0};
				_vala_assert (content_layout == CONTENT_LAYOUT_CUSTOM_SIZE, "content_layout == ContentLayout.CUSTOM_SIZE");
				_tmp36_ = job;
				_tmp37_ = print_job_get_local_settings (_tmp36_);
				_tmp38_ = _tmp37_;
				print_settings_get_content_width (_tmp38_, &_tmp39_);
				measurement_convert_to (&_tmp39_, MEASUREMENT_UNIT_INCHES, &_tmp40_);
				canvas_width = _tmp40_.value;
				_print_settings_unref0 (_tmp38_);
				_tmp41_ = job;
				_tmp42_ = print_job_get_local_settings (_tmp41_);
				_tmp43_ = _tmp42_;
				print_settings_get_content_height (_tmp43_, &_tmp44_);
				measurement_convert_to (&_tmp44_, MEASUREMENT_UNIT_INCHES, &_tmp45_);
				canvas_height = _tmp45_.value;
				_print_settings_unref0 (_tmp43_);
			}
			_tmp46_ = photos;
			_tmp47_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp48_ = _tmp47_;
			if (page_num < _tmp48_) {
				Dimensions photo_dimensions = {0};
				GeeList* _tmp49_;
				gpointer _tmp50_;
				Photo* _tmp51_;
				Dimensions _tmp52_ = {0};
				Dimensions _tmp53_;
				gdouble photo_aspect_ratio = 0.0;
				gdouble canvas_aspect_ratio = 0.0;
				gdouble dx = 0.0;
				gdouble dy = 0.0;
				GeeList* _tmp54_;
				gpointer _tmp55_;
				Photo* _tmp56_;
				PrintJob* _tmp57_;
				PrintJob* _tmp58_;
				PrintSettings* _tmp59_;
				PrintSettings* _tmp60_;
				gboolean _tmp61_;
				_tmp49_ = photos;
				_tmp50_ = gee_list_get (_tmp49_, page_num);
				_tmp51_ = (Photo*) _tmp50_;
				media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp52_);
				_tmp53_ = _tmp52_;
				_g_object_unref0 (_tmp51_);
				photo_dimensions = _tmp53_;
				photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
				canvas_aspect_ratio = ((gdouble) canvas_width) / canvas_height;
				if (floor (canvas_aspect_ratio) != floor (photo_aspect_ratio)) {
					gdouble canvas_tmp = 0.0;
					canvas_tmp = canvas_width;
					canvas_width = canvas_height;
					canvas_height = canvas_tmp;
				}
				dx = (page_width - canvas_width) / 2.0;
				dy = (page_height - canvas_height) / 2.0;
				_tmp54_ = photos;
				_tmp55_ = gee_list_get (_tmp54_, page_num);
				_tmp56_ = (Photo*) _tmp55_;
				_tmp57_ = job;
				print_manager_fit_image_to_canvas (self, _tmp56_, dx, dy, canvas_width, canvas_height, TRUE, _tmp57_, job_context);
				_g_object_unref0 (_tmp56_);
				_tmp58_ = job;
				_tmp59_ = print_job_get_local_settings (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = print_settings_is_print_titles_enabled (_tmp60_);
				_print_settings_unref0 (_tmp60_);
				if (_tmp61_) {
					GeeList* _tmp62_;
					gpointer _tmp63_;
					Photo* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					PrintJob* _tmp67_;
					_tmp62_ = photos;
					_tmp63_ = gee_list_get (_tmp62_, page_num);
					_tmp64_ = (Photo*) _tmp63_;
					_tmp65_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_DATA_OBJECT, DataObject));
					_tmp66_ = _tmp65_;
					_tmp67_ = job;
					print_manager_add_title_to_canvas (self, page_width / 2, page_height, _tmp66_, _tmp67_, job_context);
					_g_free0 (_tmp66_);
					_g_object_unref0 (_tmp64_);
				}
			}
			_tmp68_ = self->priv->progress_dialog;
			if (_tmp68_ != NULL) {
				ProgressDialog* _tmp69_;
				GeeList* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				_tmp69_ = self->priv->progress_dialog;
				_tmp70_ = photos;
				_tmp71_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp72_ = _tmp71_;
				progress_dialog_monitor (_tmp69_, (guint64) page_num, (guint64) _tmp72_, TRUE);
			}
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintLayout layout = 0;
			PrintJob* _tmp73_;
			PrintSettings* _tmp74_;
			PrintSettings* _tmp75_;
			PrintLayout _tmp76_;
			gint nx = 0;
			gint ny = 0;
			gint start = 0;
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			_tmp73_ = job;
			_tmp74_ = print_job_get_local_settings (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp75_);
			_print_settings_unref0 (_tmp75_);
			layout = _tmp76_;
			nx = print_layout_get_x (layout);
			ny = print_layout_get_y (layout);
			start = page_num * print_layout_get_per_page (layout);
			canvas_width = ((gdouble) (page_width - (PRINT_MANAGER_IMAGE_DISTANCE * (nx - 1)))) / nx;
			canvas_height = ((gdouble) (page_height - (PRINT_MANAGER_IMAGE_DISTANCE * (ny - 1)))) / ny;
			{
				gint y = 0;
				y = 0;
				{
					gboolean _tmp77_ = FALSE;
					_tmp77_ = TRUE;
					while (TRUE) {
						if (!_tmp77_) {
							gint _tmp78_;
							_tmp78_ = y;
							y = _tmp78_ + 1;
						}
						_tmp77_ = FALSE;
						if (!(y < ny)) {
							break;
						}
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp79_ = FALSE;
								_tmp79_ = TRUE;
								while (TRUE) {
									gint i = 0;
									GeeList* _tmp81_;
									gint _tmp82_;
									gint _tmp83_;
									ProgressDialog* _tmp98_;
									if (!_tmp79_) {
										gint _tmp80_;
										_tmp80_ = x;
										x = _tmp80_ + 1;
									}
									_tmp79_ = FALSE;
									if (!(x < nx)) {
										break;
									}
									i = (start + (y * nx)) + x;
									_tmp81_ = photos;
									_tmp82_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GEE_TYPE_COLLECTION, GeeCollection));
									_tmp83_ = _tmp82_;
									if (i < _tmp83_) {
										gdouble dx = 0.0;
										gdouble dy = 0.0;
										GeeList* _tmp84_;
										gpointer _tmp85_;
										Photo* _tmp86_;
										PrintJob* _tmp87_;
										PrintJob* _tmp88_;
										PrintSettings* _tmp89_;
										PrintSettings* _tmp90_;
										gboolean _tmp91_;
										dx = (x * canvas_width) + (x * PRINT_MANAGER_IMAGE_DISTANCE);
										dy = (y * canvas_height) + (y * PRINT_MANAGER_IMAGE_DISTANCE);
										_tmp84_ = photos;
										_tmp85_ = gee_list_get (_tmp84_, i);
										_tmp86_ = (Photo*) _tmp85_;
										_tmp87_ = job;
										print_manager_fit_image_to_canvas (self, _tmp86_, dx, dy, canvas_width, canvas_height, FALSE, _tmp87_, job_context);
										_g_object_unref0 (_tmp86_);
										_tmp88_ = job;
										_tmp89_ = print_job_get_local_settings (_tmp88_);
										_tmp90_ = _tmp89_;
										_tmp91_ = print_settings_is_print_titles_enabled (_tmp90_);
										_print_settings_unref0 (_tmp90_);
										if (_tmp91_) {
											GeeList* _tmp92_;
											gpointer _tmp93_;
											Photo* _tmp94_;
											gchar* _tmp95_;
											gchar* _tmp96_;
											PrintJob* _tmp97_;
											_tmp92_ = photos;
											_tmp93_ = gee_list_get (_tmp92_, i);
											_tmp94_ = (Photo*) _tmp93_;
											_tmp95_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, TYPE_DATA_OBJECT, DataObject));
											_tmp96_ = _tmp95_;
											_tmp97_ = job;
											print_manager_add_title_to_canvas (self, dx + (canvas_width / 2), dy + canvas_height, _tmp96_, _tmp97_, job_context);
											_g_free0 (_tmp96_);
											_g_object_unref0 (_tmp94_);
										}
									}
									_tmp98_ = self->priv->progress_dialog;
									if (_tmp98_ != NULL) {
										ProgressDialog* _tmp99_;
										GeeList* _tmp100_;
										gint _tmp101_;
										gint _tmp102_;
										_tmp99_ = self->priv->progress_dialog;
										_tmp100_ = photos;
										_tmp101_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, GEE_TYPE_COLLECTION, GeeCollection));
										_tmp102_ = _tmp101_;
										progress_dialog_monitor (_tmp99_, (guint64) i, (guint64) _tmp102_, TRUE);
									}
								}
							}
						}
					}
				}
			}
			break;
		}
		default:
		{
			g_error ("Printing.vala:1014: unknown or unsupported layout mode");
		}
	}
	_g_object_unref0 (photos);
	_cairo_destroy0 (dc);
	_g_object_unref0 (page_setup);
	_g_object_unref0 (job);
}

static void
_print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                               GtkWidget* widget,
                                                                               gpointer self)
{
	print_manager_on_custom_widget_apply ((PrintManager*) self, widget);
}

static GObject*
print_manager_on_create_custom_widget (PrintManager* self,
                                       GtkPrintOperation* emitting_object)
{
	CustomPrintTab* _tmp0_;
	CustomPrintTab* _tmp1_;
	GObject* result;
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emitting_object, gtk_print_operation_get_type ()), NULL);
	_tmp0_ = custom_print_tab_new (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->custom_tab);
	self->priv->custom_tab = _tmp0_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob), gtk_print_operation_get_type (), GtkPrintOperation), "custom-widget-apply", (GCallback) _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply, self);
	_tmp1_ = self->priv->custom_tab;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject);
	return result;
}

static void
print_manager_on_custom_widget_apply (PrintManager* self,
                                      GtkWidget* custom_widget)
{
	CustomPrintTab* tab = NULL;
	CustomPrintTab* _tmp0_;
	PrintJob* _tmp1_;
	PrintJob* _tmp2_;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (custom_widget, gtk_widget_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (custom_widget, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab));
	tab = _tmp0_;
	_tmp1_ = custom_print_tab_get_source_job (tab);
	_tmp2_ = _tmp1_;
	_tmp3_ = custom_print_tab_get_local_settings (tab);
	_tmp4_ = _tmp3_;
	print_job_set_local_settings (_tmp2_, _tmp4_);
	_print_settings_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = custom_print_tab_get_local_settings (tab);
	_tmp6_ = _tmp5_;
	print_manager_set_global_settings (self, _tmp6_);
	_print_settings_unref0 (_tmp6_);
	_g_object_unref0 (tab);
}

static void
print_manager_fit_image_to_canvas (PrintManager* self,
                                   Photo* photo,
                                   gdouble x,
                                   gdouble y,
                                   gdouble canvas_width,
                                   gdouble canvas_height,
                                   gboolean crop,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Dimensions photo_dimensions = {0};
	Dimensions _tmp2_ = {0};
	gdouble photo_aspect_ratio = 0.0;
	gdouble canvas_aspect_ratio = 0.0;
	gdouble target_width = 0.0;
	gdouble target_height = 0.0;
	gdouble dpi = 0.0;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	gdouble _tmp5_;
	gdouble x_offset = 0.0;
	gdouble y_offset = 0.0;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gint w = 0;
	gint h = 0;
	Dimensions viewport = {0};
	cairo_t* _tmp40_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (IS_PHOTO (photo));
	g_return_if_fail (IS_PRINT_JOB (job));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (job_context, gtk_print_context_get_type ()));
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	dc = _tmp1_;
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp2_);
	photo_dimensions = _tmp2_;
	photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
	canvas_aspect_ratio = ((gdouble) canvas_width) / canvas_height;
	target_width = 0.0;
	target_height = 0.0;
	_tmp3_ = print_job_get_local_settings (job);
	_tmp4_ = _tmp3_;
	_tmp5_ = (gdouble) print_settings_get_content_ppi (_tmp4_);
	_print_settings_unref0 (_tmp4_);
	dpi = _tmp5_;
	if (!crop) {
		if (canvas_aspect_ratio < photo_aspect_ratio) {
			target_width = canvas_width;
			target_height = target_width * (1.0 / photo_aspect_ratio);
		} else {
			target_height = canvas_height;
			target_width = target_height * photo_aspect_ratio;
		}
		x = x + ((canvas_width - target_width) / 2.0);
		y = y + ((canvas_height - target_height) / 2.0);
	}
	x_offset = dpi * x;
	y_offset = dpi * y;
	_tmp6_ = dc;
	cairo_save (_tmp6_);
	_tmp7_ = dc;
	cairo_translate (_tmp7_, x_offset, y_offset);
	w = (gint) (dpi * canvas_width);
	h = (gint) (dpi * canvas_height);
	dimensions_init (&viewport, w, h);
	{
		gboolean _tmp8_ = FALSE;
		cairo_t* _tmp35_;
		if (crop) {
			_tmp8_ = !print_manager_are_approximately_equal (self, canvas_aspect_ratio, photo_aspect_ratio);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp9_;
			Scaling _tmp10_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp11_;
			GdkPixbuf* _tmp12_;
			Dimensions scaled_photo_dimensions = {0};
			GdkPixbuf* _tmp13_;
			Dimensions _tmp14_ = {0};
			gint shave_vertical = 0;
			gint shave_horizontal = 0;
			GdkPixbuf* shaved_pixbuf = NULL;
			GdkPixbuf* _tmp19_;
			Dimensions _tmp20_;
			Dimensions _tmp21_;
			GdkPixbuf* _tmp22_;
			GdkPixbuf* _tmp23_;
			GdkPixbuf* _tmp24_;
			cairo_t* _tmp25_;
			GdkPixbuf* _tmp26_;
			_tmp9_ = viewport;
			scaling_to_fill_viewport (&_tmp9_, &_tmp10_);
			pixbuf_scaling = _tmp10_;
			_tmp11_ = pixbuf_scaling;
			_tmp12_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp11_, &_inner_error0_);
			photo_pixbuf = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = photo_pixbuf;
			dimensions_for_pixbuf (_tmp13_, &_tmp14_);
			scaled_photo_dimensions = _tmp14_;
			shave_vertical = 0;
			shave_horizontal = 0;
			if (canvas_aspect_ratio < photo_aspect_ratio) {
				Dimensions _tmp15_;
				Dimensions _tmp16_;
				_tmp15_ = scaled_photo_dimensions;
				_tmp16_ = scaled_photo_dimensions;
				shave_vertical = (gint) ((_tmp15_.width - (_tmp16_.height * canvas_aspect_ratio)) / 2.0);
			} else {
				Dimensions _tmp17_;
				Dimensions _tmp18_;
				_tmp17_ = scaled_photo_dimensions;
				_tmp18_ = scaled_photo_dimensions;
				shave_horizontal = (gint) ((_tmp17_.height - (_tmp18_.width * (1.0 / canvas_aspect_ratio))) / 2.0);
			}
			_tmp19_ = photo_pixbuf;
			_tmp20_ = scaled_photo_dimensions;
			_tmp21_ = scaled_photo_dimensions;
			_tmp22_ = gdk_pixbuf_new_subpixbuf (_tmp19_, shave_vertical, shave_horizontal, _tmp20_.width - (2 * shave_vertical), _tmp21_.height - (2 * shave_horizontal));
			shaved_pixbuf = _tmp22_;
			_tmp23_ = shaved_pixbuf;
			_tmp24_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp23_, GDK_INTERP_HYPER, TRUE);
			_g_object_unref0 (photo_pixbuf);
			photo_pixbuf = _tmp24_;
			_tmp25_ = dc;
			_tmp26_ = photo_pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp25_, _tmp26_, 0.0, 0.0);
			_g_object_unref0 (shaved_pixbuf);
			_g_object_unref0 (photo_pixbuf);
		} else {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp27_;
			Scaling _tmp28_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
			cairo_t* _tmp33_;
			GdkPixbuf* _tmp34_;
			_tmp27_ = viewport;
			scaling_for_viewport (&_tmp27_, TRUE, &_tmp28_);
			pixbuf_scaling = _tmp28_;
			_tmp29_ = pixbuf_scaling;
			_tmp30_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp29_, &_inner_error0_);
			photo_pixbuf = _tmp30_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp31_ = photo_pixbuf;
			_tmp32_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp31_, GDK_INTERP_HYPER, TRUE);
			_g_object_unref0 (photo_pixbuf);
			photo_pixbuf = _tmp32_;
			_tmp33_ = dc;
			_tmp34_ = photo_pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp33_, _tmp34_, 0.0, 0.0);
			_g_object_unref0 (photo_pixbuf);
		}
		_tmp35_ = dc;
		cairo_paint (_tmp35_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		_tmp38_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp37_);
		_tmp39_ = _tmp38_;
		app_window_error_message (_tmp39_, NULL);
		_g_free0 (_tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (dc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp40_ = dc;
	cairo_restore (_tmp40_);
	_cairo_destroy0 (dc);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
print_manager_add_title_to_canvas (PrintManager* self,
                                   gdouble x,
                                   gdouble y,
                                   const gchar* title,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble dpi = 0.0;
	PrintSettings* _tmp2_;
	PrintSettings* _tmp3_;
	gdouble _tmp4_;
	PangoFontDescription* title_font_description = NULL;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoLayout* title_layout = NULL;
	PangoLayout* _tmp11_;
	PangoContext* context = NULL;
	PangoContext* _tmp12_;
	PangoContext* _tmp13_;
	gint title_width = 0;
	gint title_height = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (title != NULL);
	g_return_if_fail (IS_PRINT_JOB (job));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (job_context, gtk_print_context_get_type ()));
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	dc = _tmp1_;
	_tmp2_ = print_job_get_local_settings (job);
	_tmp3_ = _tmp2_;
	_tmp4_ = (gdouble) print_settings_get_content_ppi (_tmp3_);
	_print_settings_unref0 (_tmp3_);
	dpi = _tmp4_;
	_tmp5_ = print_job_get_local_settings (job);
	_tmp6_ = _tmp5_;
	_tmp7_ = print_settings_get_print_titles_font (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = pango_font_description_from_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_print_settings_unref0 (_tmp6_);
	title_font_description = _tmp10_;
	_tmp11_ = pango_cairo_create_layout (dc);
	title_layout = _tmp11_;
	_tmp12_ = pango_layout_get_context (title_layout);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	context = _tmp13_;
	pango_cairo_context_set_resolution (context, dpi);
	pango_layout_set_font_description (title_layout, title_font_description);
	pango_layout_set_text (title_layout, title, -1);
	pango_layout_get_pixel_size (title_layout, &_tmp14_, &_tmp15_);
	title_width = _tmp14_;
	title_height = _tmp15_;
	tx = (dpi * x) - (title_width / 2);
	ty = (dpi * y) - title_height;
	cairo_rectangle (dc, tx - 10, ty + 2, (gdouble) (title_width + 20), (gdouble) title_height);
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_set_line_width (dc, (gdouble) 2);
	cairo_stroke_preserve (dc);
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
	cairo_fill (dc);
	cairo_set_source_rgba (dc, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_move_to (dc, tx, ty + 2);
	pango_cairo_show_layout (dc, title_layout);
	_g_object_unref0 (context);
	_g_object_unref0 (title_layout);
	__vala_PangoFontDescription_free0 (title_font_description);
	_cairo_destroy0 (dc);
}

static gboolean
print_manager_are_approximately_equal (PrintManager* self,
                                       gdouble val1,
                                       gdouble val2)
{
	gdouble accept_err = 0.0;
	gboolean result;
	g_return_val_if_fail (IS_PRINT_MANAGER (self), FALSE);
	accept_err = 0.005;
	result = fabs (val1 - val2) <= accept_err;
	return result;
}

PrintSettings*
print_manager_get_global_settings (PrintManager* self)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	PrintSettings* result;
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _print_settings_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
print_manager_set_global_settings (PrintManager* self,
                                   PrintSettings* settings)
{
	PrintSettings* _tmp0_;
	g_return_if_fail (IS_PRINT_MANAGER (self));
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
	_tmp0_ = _print_settings_ref0 (settings);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	print_settings_save (settings);
}

static void
value_print_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_print_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		print_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_print_manager_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = print_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_print_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_print_manager_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PrintManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = print_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_print_manager_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PrintManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = print_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_print_manager (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPrintManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_print_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_print_manager (GValue* value,
                         gpointer v_object)
{
	PrintManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		print_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_manager_unref (old);
	}
}

void
value_take_print_manager (GValue* value,
                          gpointer v_object)
{
	PrintManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_manager_unref (old);
	}
}

static void
print_manager_class_init (PrintManagerClass * klass,
                          gpointer klass_data)
{
	print_manager_parent_class = g_type_class_peek_parent (klass);
	((PrintManagerClass *) klass)->finalize = print_manager_finalize;
	g_type_class_adjust_private_offset (klass, &PrintManager_private_offset);
}

static void
print_manager_instance_init (PrintManager * self,
                             gpointer klass)
{
	self->priv = print_manager_get_instance_private (self);
	self->priv->progress_dialog = NULL;
	self->priv->cancellable = NULL;
	self->priv->standard_sizes = NULL;
	self->priv->standard_sizes_length1 = 0;
	self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
	self->ref_count = 1;
}

static void
print_manager_finalize (PrintManager * obj)
{
	PrintManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_MANAGER, PrintManager);
	g_signal_handlers_destroy (self);
	_print_settings_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->user_page_setup);
	_g_object_unref0 (self->priv->custom_tab);
	_g_object_unref0 (self->priv->progress_dialog);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
}

static GType
print_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_print_manager_init, value_print_manager_free_value, value_print_manager_copy_value, value_print_manager_peek_pointer, "p", value_print_manager_collect_value, "p", value_print_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PrintManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintManager), 0, (GInstanceInitFunc) print_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType print_manager_type_id;
	print_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PrintManager_private_offset = g_type_add_instance_private (print_manager_type_id, sizeof (PrintManagerPrivate));
	return print_manager_type_id;
}

GType
print_manager_get_type (void)
{
	static volatile gsize print_manager_type_id__once = 0;
	if (g_once_init_enter (&print_manager_type_id__once)) {
		GType print_manager_type_id;
		print_manager_type_id = print_manager_get_type_once ();
		g_once_init_leave (&print_manager_type_id__once, print_manager_type_id);
	}
	return print_manager_type_id__once;
}

gpointer
print_manager_ref (gpointer instance)
{
	PrintManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
print_manager_unref (gpointer instance)
{
	PrintManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRINT_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

