/* PhotoMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from PhotoMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE 20
#define PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE 5
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_UPDATES (photo_updates_get_type ())
#define PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_UPDATES, PhotoUpdates))
#define PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))
#define IS_PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_UPDATES))
#define IS_PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_UPDATES))
#define PHOTO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))

typedef struct _PhotoUpdates PhotoUpdates;
typedef struct _PhotoUpdatesClass PhotoUpdatesClass;
typedef struct _PhotoUpdatesPrivate PhotoUpdatesPrivate;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;
typedef struct _PhotoMonitorPrivate PhotoMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB (photo_monitor_reimport_master_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))

typedef struct _PhotoMonitorReimportMasterJob PhotoMonitorReimportMasterJob;
typedef struct _PhotoMonitorReimportMasterJobClass PhotoMonitorReimportMasterJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB (photo_monitor_reimport_editable_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))

typedef struct _PhotoMonitorReimportEditableJob PhotoMonitorReimportEditableJob;
typedef struct _PhotoMonitorReimportEditableJobClass PhotoMonitorReimportEditableJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB (photo_monitor_reimport_raw_development_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))

typedef struct _PhotoMonitorReimportRawDevelopmentJob PhotoMonitorReimportRawDevelopmentJob;
typedef struct _PhotoMonitorReimportRawDevelopmentJobClass PhotoMonitorReimportRawDevelopmentJobClass;
enum  {
	PHOTO_MONITOR_0_PROPERTY,
	PHOTO_MONITOR_NUM_PROPERTIES
};
static GParamSpec* photo_monitor_properties[PHOTO_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;
typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _PhotoMonitorReimportMasterJobPrivate PhotoMonitorReimportMasterJobPrivate;

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
typedef struct _PhotoMonitorReimportEditableJobPrivate PhotoMonitorReimportEditableJobPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
typedef struct _PhotoMonitorReimportRawDevelopmentJobPrivate PhotoMonitorReimportRawDevelopmentJobPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _PhotoUpdates {
	MonitorableUpdates parent_instance;
	PhotoUpdatesPrivate * priv;
	LibraryPhoto* photo;
	gboolean reimport_master;
	gboolean reimport_editable;
	gboolean reimport_raw_developments;
	GFile* editable_file;
	gboolean editable_file_info_altered;
	gboolean raw_developer_file_info_altered;
	GFileInfo* editable_file_info;
	gboolean editable_in_alteration;
	gboolean raw_development_in_alteration;
	gboolean revert_to_master;
	GeeCollection* developer_files;
};

struct _PhotoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_editable_file) (PhotoUpdates* self, GFile* file);
	void (*set_editable_file_info) (PhotoUpdates* self, GFileInfo* info);
	void (*set_editable_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_editable_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_development_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_developer_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_revert_to_master) (PhotoUpdates* self, gboolean revert);
	void (*add_raw_developer_file) (PhotoUpdates* self, GFile* file);
	void (*clear_raw_developer_files) (PhotoUpdates* self);
	void (*set_reimport_master) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_editable) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_raw_developments) (PhotoUpdates* self, gboolean reimport);
};

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, gint* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _PhotoMonitor {
	MediaMonitor parent_instance;
	PhotoMonitorPrivate * priv;
};

struct _PhotoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _PhotoMonitorPrivate {
	Workers* workers;
	GeeArrayList* matched_editables;
	GeeArrayList* matched_developments;
	GeeHashMap* master_reimport_pending;
	GeeHashMap* editable_reimport_pending;
	GeeHashMap* raw_developments_reimport_pending;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _PhotoMonitorReimportMasterJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportMasterJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportMasterState* reimport_state;
	gboolean mark_online;
	GError* err;
};

struct _PhotoMonitorReimportMasterJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportEditableJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportEditableJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportEditableState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportEditableJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportRawDevelopmentJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportRawDevelopmentJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportRawDevelopmentState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportRawDevelopmentJobClass {
	BackgroundJobClass parent_class;
};

static gpointer photo_updates_parent_class = NULL;
static gint PhotoMonitor_private_offset;
static gpointer photo_monitor_parent_class = NULL;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
static gpointer photo_monitor_reimport_master_job_parent_class = NULL;
static gpointer photo_monitor_reimport_editable_job_parent_class = NULL;
static gpointer photo_monitor_reimport_raw_development_job_parent_class = NULL;

VALA_EXTERN gpointer monitorable_updates_ref (gpointer instance);
VALA_EXTERN void monitorable_updates_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitorable_updates (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_monitorable_updates (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_monitorable_updates (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_monitorable_updates (const GValue* value);
VALA_EXTERN GType monitorable_updates_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MonitorableUpdates, monitorable_updates_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN GType photo_updates_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoUpdates, monitorable_updates_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN void monitorable_updates_mark_offline (MonitorableUpdates* self);
VALA_EXTERN gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self);
VALA_EXTERN void photo_updates_set_editable_file (PhotoUpdates* self,
                                      GFile* file);
VALA_EXTERN void photo_updates_set_editable_file_info (PhotoUpdates* self,
                                           GFileInfo* info);
VALA_EXTERN void photo_updates_set_editable_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered);
VALA_EXTERN void photo_updates_set_editable_in_alteration (PhotoUpdates* self,
                                               gboolean in_alteration);
VALA_EXTERN void photo_updates_set_raw_development_in_alteration (PhotoUpdates* self,
                                                      gboolean in_alteration);
VALA_EXTERN void photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered);
VALA_EXTERN void photo_updates_set_revert_to_master (PhotoUpdates* self,
                                         gboolean revert);
VALA_EXTERN void photo_updates_add_raw_developer_file (PhotoUpdates* self,
                                           GFile* file);
VALA_EXTERN void photo_updates_clear_raw_developer_files (PhotoUpdates* self);
VALA_EXTERN void photo_updates_set_reimport_master (PhotoUpdates* self,
                                        gboolean reimport);
VALA_EXTERN void photo_updates_set_reimport_editable (PhotoUpdates* self,
                                          gboolean reimport);
VALA_EXTERN void photo_updates_set_reimport_raw_developments (PhotoUpdates* self,
                                                  gboolean reimport);
VALA_EXTERN gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
VALA_EXTERN PhotoUpdates* photo_updates_new (LibraryPhoto* photo);
VALA_EXTERN PhotoUpdates* photo_updates_construct (GType object_type,
                                       LibraryPhoto* photo);
VALA_EXTERN MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* monitorable_updates_construct (GType object_type,
                                                   Monitorable* monitorable);
static void photo_updates_real_mark_offline (MonitorableUpdates* base);
VALA_EXTERN gboolean photo_updates_is_reimport_master (PhotoUpdates* self);
VALA_EXTERN gboolean photo_updates_is_reimport_editable (PhotoUpdates* self);
VALA_EXTERN GFile* photo_updates_get_editable_file (PhotoUpdates* self);
VALA_EXTERN GFileInfo* photo_updates_get_editable_file_info (PhotoUpdates* self);
VALA_EXTERN GeeCollection* photo_updates_get_raw_developer_files (PhotoUpdates* self);
static gboolean photo_updates_real_is_in_alteration (MonitorableUpdates* base);
VALA_EXTERN gboolean photo_updates_is_revert_to_master (PhotoUpdates* self);
static void photo_updates_real_set_editable_file (PhotoUpdates* self,
                                           GFile* file);
static void photo_updates_real_set_editable_file_info (PhotoUpdates* self,
                                                GFileInfo* info);
static void photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered);
static void photo_updates_real_set_editable_in_alteration (PhotoUpdates* self,
                                                    gboolean in_alteration);
static void photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self,
                                                           gboolean in_alteration);
static void photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                             gboolean altered);
static void photo_updates_real_set_revert_to_master (PhotoUpdates* self,
                                              gboolean revert);
static void photo_updates_real_add_raw_developer_file (PhotoUpdates* self,
                                                GFile* file);
static void photo_updates_real_clear_raw_developer_files (PhotoUpdates* self);
static void photo_updates_real_set_reimport_master (PhotoUpdates* self,
                                             gboolean reimport);
VALA_EXTERN void monitorable_updates_mark_online (MonitorableUpdates* self);
static void photo_updates_real_set_reimport_editable (PhotoUpdates* self,
                                               gboolean reimport);
VALA_EXTERN gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self);
static void photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self,
                                                       gboolean reimport);
static gboolean photo_updates_real_is_all_updated (MonitorableUpdates* base);
static void photo_updates_finalize (MonitorableUpdates * obj);
static GType photo_updates_get_type_once (void);
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN GType photo_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMonitor, g_object_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
static GType photo_monitor_reimport_master_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMonitorReimportMasterJob, background_job_unref)
static GType photo_monitor_reimport_editable_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMonitorReimportEditableJob, background_job_unref)
static GType photo_monitor_reimport_raw_development_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMonitorReimportRawDevelopmentJob, background_job_unref)
VALA_EXTERN MonitorableUpdates* media_monitor_create_updates (MediaMonitor* self,
                                                  Monitorable* monitorable);
VALA_EXTERN MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self);
VALA_EXTERN gboolean media_monitor_is_file_represented (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN void media_monitor_close (MediaMonitor* self);
VALA_EXTERN MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self,
                                                                 GFile* file,
                                                                 GFileInfo* info,
                                                                 Monitorable** monitorable);
VALA_EXTERN GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self,
                                                          GFile* file,
                                                          GFileInfo* info,
                                                          MediaMonitorDiscoveredFile* _result_);
VALA_EXTERN GFile** media_monitor_get_auxilliary_backing_files (MediaMonitor* self,
                                                    Monitorable* monitorable,
                                                    gint* result_length1);
VALA_EXTERN void media_monitor_update_backing_file_info (MediaMonitor* self,
                                             Monitorable* monitorable,
                                             GFile* file,
                                             GFileInfo* info);
VALA_EXTERN void media_monitor_notify_discovery_completing (MediaMonitor* self);
VALA_EXTERN gboolean media_monitor_notify_file_created (MediaMonitor* self,
                                            GFile* file,
                                            GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_moved (MediaMonitor* self,
                                          GFile* old_file,
                                          GFile* new_file,
                                          GFileInfo* new_file_info);
VALA_EXTERN gboolean media_monitor_notify_file_altered (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self,
                                                       GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self,
                                                         GFile* file,
                                                         GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_deleted (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN void media_monitor_on_media_source_destroyed (MediaMonitor* self,
                                              DataSource* source);
VALA_EXTERN void media_monitor_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error);
VALA_EXTERN PhotoMonitor* photo_monitor_new (Workers* workers,
                                 GCancellable* cancellable);
VALA_EXTERN PhotoMonitor* photo_monitor_construct (GType object_type,
                                       Workers* workers,
                                       GCancellable* cancellable);
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
VALA_EXTERN MediaMonitor* media_monitor_construct (GType object_type,
                                       MediaSourceCollection* sources,
                                       GCancellable* cancellable);
static MonitorableUpdates* photo_monitor_real_create_updates (MediaMonitor* base,
                                                       Monitorable* monitorable);
static MediaSourceCollection* photo_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean photo_monitor_real_is_file_represented (MediaMonitor* base,
                                                 GFile* file);
VALA_EXTERN GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST ;
static LibraryPhoto* photo_monitor_get_photo_state_by_file (PhotoMonitor* self,
                                                     GFile* file,
                                                     LibraryPhotoSourceCollectionState* state);
static void photo_monitor_real_close (MediaMonitor* base);
VALA_EXTERN void background_job_cancel (BackgroundJob* self);
static void photo_monitor_cancel_reimports (PhotoMonitor* self,
                                     LibraryPhoto* photo);
static MediaMonitorDiscoveredFile photo_monitor_real_notify_file_discovered (MediaMonitor* base,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable** monitorable);
static GeeCollection* photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
VALA_EXTERN void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                                GFileInfo* info,
                                                                GeeCollection* matches_master,
                                                                GeeCollection* matches_editable,
                                                                GeeCollection* matched_development);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN gboolean photo_does_editable_exist (Photo* self);
VALA_EXTERN void photo_revert_to_master (Photo* self,
                             gboolean notify);
VALA_EXTERN void photo_monitor_update_editable_file (PhotoMonitor* self,
                                         LibraryPhoto* photo,
                                         GFile* file);
VALA_EXTERN void photo_monitor_update_raw_development_file (PhotoMonitor* self,
                                                LibraryPhoto* photo,
                                                GFile* file);
static GFile** photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base,
                                                         Monitorable* monitorable,
                                                         gint* result_length1);
VALA_EXTERN gboolean photo_has_editable (Photo* self);
VALA_EXTERN GFile* photo_get_editable_file (Photo* self);
static void _vala_array_add127 (GFile** * array,
                         gint* length,
                         gint* size,
                         GFile* value);
VALA_EXTERN GeeCollection* photo_get_raw_developer_files (Photo* self);
static void _vala_array_add128 (GFile** * array,
                         gint* length,
                         gint* size,
                         GFile* value);
static GFile** _vala_array_dup35 (GFile** self,
                           gssize length);
static void photo_monitor_real_update_backing_file_info (MediaMonitor* base,
                                                  Monitorable* monitorable,
                                                  GFile* file,
                                                  GFileInfo* info);
VALA_EXTERN GFile* media_monitor_get_master_file (MediaMonitor* self,
                                      Monitorable* monitorable);
static void photo_monitor_check_for_master_changes (PhotoMonitor* self,
                                             LibraryPhoto* photo,
                                             GFileInfo* info);
VALA_EXTERN GFile* photo_monitor_get_editable_file (PhotoMonitor* self,
                                        LibraryPhoto* photo);
static void photo_monitor_check_for_editable_changes (PhotoMonitor* self,
                                               LibraryPhoto* photo,
                                               GFileInfo* info);
VALA_EXTERN GeeCollection* photo_monitor_get_raw_development_files (PhotoMonitor* self,
                                                        LibraryPhoto* photo);
static void photo_monitor_check_for_raw_development_changes (PhotoMonitor* self,
                                                      LibraryPhoto* photo,
                                                      GFileInfo* info);
static void photo_monitor_real_notify_discovery_completing (MediaMonitor* base);
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN BackingPhotoRow* photo_get_master_photo_row (Photo* self);
VALA_EXTERN gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
VALA_EXTERN gboolean backing_photo_row_is_touched (BackingPhotoRow* self,
                                       GFileInfo* info);
VALA_EXTERN void media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                                    Monitorable* monitorable);
VALA_EXTERN void media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                             Monitorable* monitorable,
                                                             GFileInfo* info);
VALA_EXTERN void photo_monitor_update_reimport_master (PhotoMonitor* self,
                                           LibraryPhoto* photo);
VALA_EXTERN void photo_monitor_update_revert_to_master (PhotoMonitor* self,
                                            LibraryPhoto* photo);
VALA_EXTERN BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
VALA_EXTERN void photo_monitor_update_editable_file_info_altered (PhotoMonitor* self,
                                                      LibraryPhoto* photo);
VALA_EXTERN void photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self,
                                                               LibraryPhoto* photo,
                                                               GFileInfo* info);
VALA_EXTERN void photo_monitor_update_reimport_editable (PhotoMonitor* self,
                                             LibraryPhoto* photo);
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_set_raw_developer (Photo* self,
                              RawDeveloper d,
                              gboolean notify);
VALA_EXTERN GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self,
                                                             LibraryPhoto* photo);
VALA_EXTERN void photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self,
                                                                      LibraryPhoto* photo);
VALA_EXTERN void photo_monitor_update_reimport_raw_developments (PhotoMonitor* self,
                                                     LibraryPhoto* photo);
static gboolean photo_monitor_real_notify_file_created (MediaMonitor* base,
                                                 GFile* file,
                                                 GFileInfo* info);
VALA_EXTERN void media_monitor_mdbg (const gchar* msg);
VALA_EXTERN void media_monitor_update_online (MediaMonitor* self,
                                  Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_moved (MediaMonitor* base,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* info);
VALA_EXTERN void media_monitor_update_master_file (MediaMonitor* self,
                                       Monitorable* monitorable,
                                       GFile* file);
VALA_EXTERN void media_monitor_update_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_altered (MediaMonitor* base,
                                                 GFile* file);
VALA_EXTERN void media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                     Monitorable* monitorable,
                                                     gboolean in_alteration);
VALA_EXTERN void photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self,
                                                       LibraryPhoto* photo,
                                                       gboolean in_alteration);
VALA_EXTERN void photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self,
                                                              LibraryPhoto* photo,
                                                              gboolean in_alteration);
static gboolean photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                            GFile* file);
static gboolean photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                              GFile* file,
                                                              GFileInfo* info);
static gboolean photo_monitor_real_notify_file_deleted (MediaMonitor* base,
                                                 GFile* file);
static void photo_monitor_real_on_media_source_destroyed (MediaMonitor* base,
                                                   DataSource* source);
VALA_EXTERN gboolean media_monitor_has_pending_updates (MediaMonitor* self);
VALA_EXTERN GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
VALA_EXTERN PhotoUpdates* photo_monitor_get_existing_photo_updates (PhotoMonitor* self,
                                                        LibraryPhoto* photo);
VALA_EXTERN GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                                 GFile* file,
                                                                 LibraryPhotoSourceCollectionState* state);
VALA_EXTERN PhotoUpdates* photo_monitor_fetch_photo_updates (PhotoMonitor* self,
                                                 LibraryPhoto* photo);
VALA_EXTERN MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self,
                                                 Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self,
                                                        Monitorable* monitorable);
static void photo_monitor_real_process_updates (MediaMonitor* base,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_set_many_editable_file (GeeMap* map,
                                   GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void photo_update_many_editable_timestamps (GeeMap* map,
                                            GError** error);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_new (PhotoMonitor* owner,
                                                                      LibraryPhoto* photo);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_construct (GType object_type,
                                                                            PhotoMonitor* owner,
                                                                            LibraryPhoto* photo);
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_new (PhotoMonitor* owner,
                                                                          LibraryPhoto* photo);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_construct (GType object_type,
                                                                                PhotoMonitor* owner,
                                                                                LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner,
                                                                                       LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_construct (GType object_type,
                                                                                             PhotoMonitor* owner,
                                                                                             LibraryPhoto* photo);
static void photo_monitor_on_master_reimported (PhotoMonitor* self,
                                         BackgroundJob* j);
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer photo_reimport_master_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_master_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_master_state (const GValue* value);
VALA_EXTERN GType photo_reimport_master_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportMasterState, photo_reimport_master_state_unref)
VALA_EXTERN void photo_finish_reimport_master (Photo* self,
                                   PhotoReimportMasterState* state,
                                   GError** error);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
static void photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self,
                                                 BackgroundJob* j);
static void photo_monitor_on_editable_reimported (PhotoMonitor* self,
                                           BackgroundJob* j);
VALA_EXTERN gpointer photo_reimport_editable_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_editable_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_editable_state (const GValue* value);
VALA_EXTERN GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportEditableState, photo_reimport_editable_state_unref)
VALA_EXTERN void photo_finish_reimport_editable (Photo* self,
                                     PhotoReimportEditableState* state,
                                     GError** error);
static void photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self,
                                                   BackgroundJob* j);
static void photo_monitor_on_raw_development_reimported (PhotoMonitor* self,
                                                  BackgroundJob* j);
VALA_EXTERN gpointer photo_reimport_raw_development_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_raw_development_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_raw_development_state (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_raw_development_state (GValue* value,
                                                      gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
VALA_EXTERN GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportRawDevelopmentState, photo_reimport_raw_development_state_unref)
VALA_EXTERN void photo_finish_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState* state,
                                            GError** error);
static void photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self,
                                                          BackgroundJob* j);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
static void _photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job,
                                                              gpointer self);
static void _photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                        gpointer self);
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void photo_monitor_reimport_master_job_real_execute (BackgroundJob* base);
VALA_EXTERN gboolean photo_prepare_for_reimport_master (Photo* self,
                                            PhotoReimportMasterState** reimport_state,
                                            GError** error);
static void photo_monitor_reimport_master_job_finalize (BackgroundJob * obj);
static GType photo_monitor_reimport_master_job_get_type_once (void);
static void _photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job,
                                                                gpointer self);
static void _photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                          gpointer self);
static void photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base);
VALA_EXTERN gboolean photo_prepare_for_reimport_editable (Photo* self,
                                              PhotoReimportEditableState** state,
                                              GError** error);
static void photo_monitor_reimport_editable_job_finalize (BackgroundJob * obj);
static GType photo_monitor_reimport_editable_job_get_type_once (void);
static void _photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job,
                                                                       gpointer self);
static void _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                                 gpointer self);
static void photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base);
VALA_EXTERN gboolean photo_prepare_for_reimport_raw_development (Photo* self,
                                                     PhotoReimportRawDevelopmentState** state,
                                                     GError** error);
static void photo_monitor_reimport_raw_development_job_finalize (BackgroundJob * obj);
static GType photo_monitor_reimport_raw_development_job_get_type_once (void);
static void photo_monitor_finalize (GObject * obj);
static GType photo_monitor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PhotoUpdates*
photo_updates_construct (GType object_type,
                         LibraryPhoto* photo)
{
	PhotoUpdates* self = NULL;
	LibraryPhoto* _tmp0_;
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	self = (PhotoUpdates*) monitorable_updates_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
	_tmp0_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp0_;
	return self;
}

PhotoUpdates*
photo_updates_new (LibraryPhoto* photo)
{
	return photo_updates_construct (TYPE_PHOTO_UPDATES, photo);
}

static void
photo_updates_real_mark_offline (MonitorableUpdates* base)
{
	PhotoUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->mark_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	self->reimport_master = FALSE;
	self->reimport_editable = FALSE;
	self->reimport_raw_developments = FALSE;
}

gboolean
photo_updates_is_reimport_master (PhotoUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
	result = self->reimport_master;
	return result;
}

gboolean
photo_updates_is_reimport_editable (PhotoUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
	result = self->reimport_editable;
	return result;
}

GFile*
photo_updates_get_editable_file (PhotoUpdates* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
	_tmp0_ = self->editable_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GFileInfo*
photo_updates_get_editable_file_info (PhotoUpdates* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
	_tmp0_ = self->editable_file_info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeCollection*
photo_updates_get_raw_developer_files (PhotoUpdates* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
	_tmp0_ = self->developer_files;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
photo_updates_real_is_in_alteration (MonitorableUpdates* base)
{
	PhotoUpdates * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
	if (MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates))) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->editable_in_alteration;
	}
	result = _tmp0_;
	return result;
}

gboolean
photo_updates_is_revert_to_master (PhotoUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
	result = self->revert_to_master;
	return result;
}

static void
photo_updates_real_set_editable_file (PhotoUpdates* self,
                                      GFile* file)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	g_return_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	if (file != NULL) {
		_tmp0_ = self->revert_to_master;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->editable_file);
	self->editable_file = _tmp1_;
}

void
photo_updates_set_editable_file (PhotoUpdates* self,
                                 GFile* file)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_editable_file) {
		_klass_->set_editable_file (self, file);
	}
}

static void
photo_updates_real_set_editable_file_info (PhotoUpdates* self,
                                           GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	GFileInfo* _tmp1_;
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (info != NULL) {
		_tmp0_ = self->revert_to_master;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = _g_object_ref0 (info);
	_g_object_unref0 (self->editable_file_info);
	self->editable_file_info = _tmp1_;
	if (info == NULL) {
		self->editable_file_info_altered = FALSE;
	}
}

void
photo_updates_set_editable_file_info (PhotoUpdates* self,
                                      GFileInfo* info)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_editable_file_info) {
		_klass_->set_editable_file_info (self, info);
	}
}

static void
photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered)
{
	gboolean _tmp0_ = FALSE;
	if (altered) {
		_tmp0_ = self->revert_to_master;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->editable_file_info_altered = altered;
}

void
photo_updates_set_editable_file_info_altered (PhotoUpdates* self,
                                              gboolean altered)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_editable_file_info_altered) {
		_klass_->set_editable_file_info_altered (self, altered);
	}
}

static void
photo_updates_real_set_editable_in_alteration (PhotoUpdates* self,
                                               gboolean in_alteration)
{
	self->editable_in_alteration = in_alteration;
}

void
photo_updates_set_editable_in_alteration (PhotoUpdates* self,
                                          gboolean in_alteration)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_editable_in_alteration) {
		_klass_->set_editable_in_alteration (self, in_alteration);
	}
}

static void
photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self,
                                                      gboolean in_alteration)
{
	self->raw_development_in_alteration = in_alteration;
}

void
photo_updates_set_raw_development_in_alteration (PhotoUpdates* self,
                                                 gboolean in_alteration)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_raw_development_in_alteration) {
		_klass_->set_raw_development_in_alteration (self, in_alteration);
	}
}

static void
photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered)
{
	self->raw_developer_file_info_altered = altered;
}

void
photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_raw_developer_file_info_altered) {
		_klass_->set_raw_developer_file_info_altered (self, altered);
	}
}

static void
photo_updates_real_set_revert_to_master (PhotoUpdates* self,
                                         gboolean revert)
{
	if (revert) {
		self->reimport_editable = FALSE;
		_g_object_unref0 (self->editable_file);
		self->editable_file = NULL;
		_g_object_unref0 (self->editable_file_info);
		self->editable_file_info = NULL;
	}
	self->revert_to_master = revert;
}

void
photo_updates_set_revert_to_master (PhotoUpdates* self,
                                    gboolean revert)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_revert_to_master) {
		_klass_->set_revert_to_master (self, revert);
	}
}

static void
photo_updates_real_add_raw_developer_file (PhotoUpdates* self,
                                           GFile* file)
{
	GeeCollection* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = self->developer_files;
	gee_collection_add (_tmp0_, file);
}

void
photo_updates_add_raw_developer_file (PhotoUpdates* self,
                                      GFile* file)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->add_raw_developer_file) {
		_klass_->add_raw_developer_file (self, file);
	}
}

static void
photo_updates_real_clear_raw_developer_files (PhotoUpdates* self)
{
	GeeCollection* _tmp0_;
	_tmp0_ = self->developer_files;
	gee_collection_clear (_tmp0_);
}

void
photo_updates_clear_raw_developer_files (PhotoUpdates* self)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->clear_raw_developer_files) {
		_klass_->clear_raw_developer_files (self);
	}
}

static void
photo_updates_real_set_reimport_master (PhotoUpdates* self,
                                        gboolean reimport)
{
	self->reimport_master = reimport;
	if (reimport) {
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	}
}

void
photo_updates_set_reimport_master (PhotoUpdates* self,
                                   gboolean reimport)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_reimport_master) {
		_klass_->set_reimport_master (self, reimport);
	}
}

static void
photo_updates_real_set_reimport_editable (PhotoUpdates* self,
                                          gboolean reimport)
{
	gboolean _tmp0_ = FALSE;
	if (reimport) {
		gboolean _tmp1_ = FALSE;
		if (self->revert_to_master) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = monitorable_updates_is_set_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->reimport_editable = reimport;
}

void
photo_updates_set_reimport_editable (PhotoUpdates* self,
                                     gboolean reimport)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_reimport_editable) {
		_klass_->set_reimport_editable (self, reimport);
	}
}

static void
photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self,
                                                  gboolean reimport)
{
	self->reimport_raw_developments = reimport;
	if (reimport) {
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	}
}

void
photo_updates_set_reimport_raw_developments (PhotoUpdates* self,
                                             gboolean reimport)
{
	PhotoUpdatesClass* _klass_;
	g_return_if_fail (IS_PHOTO_UPDATES (self));
	_klass_ = PHOTO_UPDATES_GET_CLASS (self);
	if (_klass_->set_reimport_raw_developments) {
		_klass_->set_reimport_raw_developments (self, reimport);
	}
}

static gboolean
photo_updates_real_is_all_updated (MonitorableUpdates* base)
{
	PhotoUpdates * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
	if (MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates))) {
		_tmp8_ = self->reimport_master == FALSE;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = self->reimport_editable == FALSE;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GFile* _tmp9_;
		_tmp9_ = self->editable_file;
		_tmp6_ = _tmp9_ == NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = self->editable_file_info_altered == FALSE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GFileInfo* _tmp10_;
		_tmp10_ = self->editable_file_info;
		_tmp4_ = _tmp10_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = self->editable_in_alteration == FALSE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeeCollection* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->developer_files;
		_tmp12_ = gee_collection_get_size (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp2_ = _tmp13_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->raw_developer_file_info_altered == FALSE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->revert_to_master == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
photo_updates_class_init (PhotoUpdatesClass * klass,
                          gpointer klass_data)
{
	photo_updates_parent_class = g_type_class_peek_parent (klass);
	((MonitorableUpdatesClass *) klass)->finalize = photo_updates_finalize;
	((MonitorableUpdatesClass *) klass)->mark_offline = (void (*) (MonitorableUpdates*)) photo_updates_real_mark_offline;
	((MonitorableUpdatesClass *) klass)->is_in_alteration = (gboolean (*) (MonitorableUpdates*)) photo_updates_real_is_in_alteration;
	((PhotoUpdatesClass *) klass)->set_editable_file = (void (*) (PhotoUpdates*, GFile*)) photo_updates_real_set_editable_file;
	((PhotoUpdatesClass *) klass)->set_editable_file_info = (void (*) (PhotoUpdates*, GFileInfo*)) photo_updates_real_set_editable_file_info;
	((PhotoUpdatesClass *) klass)->set_editable_file_info_altered = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_editable_file_info_altered;
	((PhotoUpdatesClass *) klass)->set_editable_in_alteration = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_editable_in_alteration;
	((PhotoUpdatesClass *) klass)->set_raw_development_in_alteration = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_raw_development_in_alteration;
	((PhotoUpdatesClass *) klass)->set_raw_developer_file_info_altered = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_raw_developer_file_info_altered;
	((PhotoUpdatesClass *) klass)->set_revert_to_master = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_revert_to_master;
	((PhotoUpdatesClass *) klass)->add_raw_developer_file = (void (*) (PhotoUpdates*, GFile*)) photo_updates_real_add_raw_developer_file;
	((PhotoUpdatesClass *) klass)->clear_raw_developer_files = (void (*) (PhotoUpdates*)) photo_updates_real_clear_raw_developer_files;
	((PhotoUpdatesClass *) klass)->set_reimport_master = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_reimport_master;
	((PhotoUpdatesClass *) klass)->set_reimport_editable = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_reimport_editable;
	((PhotoUpdatesClass *) klass)->set_reimport_raw_developments = (void (*) (PhotoUpdates*, gboolean)) photo_updates_real_set_reimport_raw_developments;
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates*)) photo_updates_real_is_all_updated;
}

static void
photo_updates_instance_init (PhotoUpdates * self,
                             gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->reimport_master = FALSE;
	self->reimport_editable = FALSE;
	self->reimport_raw_developments = FALSE;
	self->editable_file = NULL;
	self->editable_file_info_altered = FALSE;
	self->raw_developer_file_info_altered = FALSE;
	self->editable_file_info = NULL;
	self->editable_in_alteration = FALSE;
	self->raw_development_in_alteration = FALSE;
	self->revert_to_master = FALSE;
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
}

static void
photo_updates_finalize (MonitorableUpdates * obj)
{
	PhotoUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_UPDATES, PhotoUpdates);
	_g_object_unref0 (self->photo);
	_g_object_unref0 (self->editable_file);
	_g_object_unref0 (self->editable_file_info);
	_g_object_unref0 (self->developer_files);
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->finalize (obj);
}

static GType
photo_updates_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoUpdates), 0, (GInstanceInitFunc) photo_updates_instance_init, NULL };
	GType photo_updates_type_id;
	photo_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "PhotoUpdates", &g_define_type_info, 0);
	return photo_updates_type_id;
}

GType
photo_updates_get_type (void)
{
	static volatile gsize photo_updates_type_id__once = 0;
	if (g_once_init_enter (&photo_updates_type_id__once)) {
		GType photo_updates_type_id;
		photo_updates_type_id = photo_updates_get_type_once ();
		g_once_init_leave (&photo_updates_type_id__once, photo_updates_type_id);
	}
	return photo_updates_type_id__once;
}

static inline gpointer
photo_monitor_get_instance_private (PhotoMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoMonitor_private_offset);
}

static gpointer
_workers_ref0 (gpointer self)
{
	return self ? workers_ref (self) : NULL;
}

PhotoMonitor*
photo_monitor_construct (GType object_type,
                         Workers* workers,
                         GCancellable* cancellable)
{
	PhotoMonitor * self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	Workers* _tmp1_;
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = library_photo_global;
	self = (PhotoMonitor*) media_monitor_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), cancellable);
	_tmp1_ = _workers_ref0 (workers);
	_workers_unref0 (self->priv->workers);
	self->priv->workers = _tmp1_;
	return self;
}

PhotoMonitor*
photo_monitor_new (Workers* workers,
                   GCancellable* cancellable)
{
	return photo_monitor_construct (TYPE_PHOTO_MONITOR, workers, cancellable);
}

static MonitorableUpdates*
photo_monitor_real_create_updates (MediaMonitor* base,
                                   Monitorable* monitorable)
{
	PhotoMonitor * self;
	PhotoUpdates* _tmp0_;
	MonitorableUpdates* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_vala_assert (IS_LIBRARY_PHOTO (monitorable), "monitorable is LibraryPhoto");
	_tmp0_ = photo_updates_new (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
	return result;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static MediaSourceCollection*
photo_monitor_real_get_media_source_collection (MediaMonitor* base)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
	MediaSourceCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	_tmp0_ = library_photo_global;
	_tmp1_ = _data_collection_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	result = _tmp1_;
	return result;
}

static gboolean
photo_monitor_real_is_file_represented (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
photo_monitor_real_close (MediaMonitor* base)
{
	PhotoMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->master_reimport_pending;
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_job_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			PhotoMonitorReimportMasterJob* job = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PhotoMonitorReimportMasterJob* _tmp9_;
			_tmp6_ = _job_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _job_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			job = (PhotoMonitorReimportMasterJob*) _tmp8_;
			_tmp9_ = job;
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_;
		GeeIterator* _tmp15_;
		_tmp10_ = self->priv->editable_reimport_pending;
		_tmp11_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_job_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			PhotoMonitorReimportEditableJob* job = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			PhotoMonitorReimportEditableJob* _tmp19_;
			_tmp16_ = _job_it;
			if (!gee_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _job_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			job = (PhotoMonitorReimportEditableJob*) _tmp18_;
			_tmp19_ = job;
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_BACKGROUND_JOB, BackgroundJob));
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		GeeCollection* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _tmp25_;
		_tmp20_ = self->priv->raw_developments_reimport_pending;
		_tmp21_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_job_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			PhotoMonitorReimportRawDevelopmentJob* job = NULL;
			GeeIterator* _tmp27_;
			gpointer _tmp28_;
			PhotoMonitorReimportRawDevelopmentJob* _tmp29_;
			_tmp26_ = _job_it;
			if (!gee_iterator_next (_tmp26_)) {
				break;
			}
			_tmp27_ = _job_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			job = (PhotoMonitorReimportRawDevelopmentJob*) _tmp28_;
			_tmp29_ = job;
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_BACKGROUND_JOB, BackgroundJob));
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
}

static void
photo_monitor_cancel_reimports (PhotoMonitor* self,
                                LibraryPhoto* photo)
{
	PhotoMonitorReimportMasterJob* master_job = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PhotoMonitorReimportMasterJob* _tmp2_;
	PhotoMonitorReimportEditableJob* editable_job = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	PhotoMonitorReimportEditableJob* _tmp6_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = self->priv->master_reimport_pending;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
	master_job = (PhotoMonitorReimportMasterJob*) _tmp1_;
	_tmp2_ = master_job;
	if (_tmp2_ != NULL) {
		PhotoMonitorReimportMasterJob* _tmp3_;
		_tmp3_ = master_job;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_BACKGROUND_JOB, BackgroundJob));
	}
	_tmp4_ = self->priv->editable_reimport_pending;
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
	editable_job = (PhotoMonitorReimportEditableJob*) _tmp5_;
	_tmp6_ = editable_job;
	if (_tmp6_ != NULL) {
		PhotoMonitorReimportEditableJob* _tmp7_;
		_tmp7_ = editable_job;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_BACKGROUND_JOB, BackgroundJob));
	}
	_background_job_unref0 (editable_job);
	_background_job_unref0 (master_job);
}

static MediaMonitorDiscoveredFile
photo_monitor_real_notify_file_discovered (MediaMonitor* base,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable** monitorable)
{
	PhotoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	MediaMonitorDiscoveredFile result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), 0);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_vala_monitorable);
		_vala_monitorable = NULL;
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
		_g_object_unref0 (photo);
		if (monitorable) {
			*monitorable = _vala_monitorable;
		} else {
			_g_object_unref0 (_vala_monitorable);
		}
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			LibraryPhoto* _tmp3_;
			Monitorable* _tmp4_;
			_tmp3_ = photo;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = _tmp4_;
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
			_g_object_unref0 (photo);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
		default:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = NULL;
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
			_g_object_unref0 (photo);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
	}
}

static GeeCollection*
photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	PhotoMonitor * self;
	MediaMonitorDiscoveredFile _vala__result_ = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeCollection* matched_masters = NULL;
	GeeArrayList* _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeArrayList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), NULL);
	_tmp0_ = self->priv->matched_editables;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp1_ = self->priv->matched_developments;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	matched_masters = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp3_ = library_photo_global;
	_tmp4_ = matched_masters;
	_tmp5_ = self->priv->matched_editables;
	_tmp6_ = self->priv->matched_developments;
	library_photo_source_collection_fetch_by_matching_backing (_tmp3_, info, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp7_ = matched_masters;
	_tmp8_ = gee_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		_vala__result_ = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
		result = matched_masters;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		return result;
	}
	_tmp11_ = self->priv->matched_editables;
	_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp13_ = _tmp12_;
	if (_tmp13_ == 0) {
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = self->priv->matched_developments;
		_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp16_ = _tmp15_;
		_tmp10_ = _tmp16_ == 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_vala__result_ = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
		result = NULL;
		_g_object_unref0 (matched_masters);
		if (_result_) {
			*_result_ = _vala__result_;
		}
		return result;
	}
	_tmp17_ = self->priv->matched_editables;
	_tmp18_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		LibraryPhoto* match = NULL;
		GeeArrayList* _tmp20_;
		gpointer _tmp21_;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		LibraryPhoto* _tmp45_;
		_tmp20_ = self->priv->matched_editables;
		_tmp21_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		match = (LibraryPhoto*) _tmp21_;
		_tmp22_ = self->priv->matched_editables;
		_tmp23_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp24_ = _tmp23_;
		if (_tmp24_ > 1) {
			gchar* _tmp25_;
			gchar* _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			LibraryPhoto* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp25_ = g_file_get_path (file);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->matched_editables;
			_tmp28_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp29_ = _tmp28_;
			_tmp30_ = match;
			_tmp31_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_DATA_OBJECT, DataObject));
			_tmp32_ = _tmp31_;
			g_warning ("PhotoMonitor.vala:335: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp26_, _tmp29_, _tmp32_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp26_);
			{
				gint ctr = 0;
				ctr = 1;
				{
					gboolean _tmp33_ = FALSE;
					_tmp33_ = TRUE;
					while (TRUE) {
						GeeArrayList* _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						GeeArrayList* _tmp38_;
						gpointer _tmp39_;
						LibraryPhoto* _tmp40_;
						gboolean _tmp41_;
						if (!_tmp33_) {
							gint _tmp34_;
							_tmp34_ = ctr;
							ctr = _tmp34_ + 1;
						}
						_tmp33_ = FALSE;
						_tmp35_ = self->priv->matched_editables;
						_tmp36_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
						_tmp37_ = _tmp36_;
						if (!(ctr < _tmp37_)) {
							break;
						}
						_tmp38_ = self->priv->matched_editables;
						_tmp39_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
						_tmp40_ = (LibraryPhoto*) _tmp39_;
						_tmp41_ = !photo_does_editable_exist (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_PHOTO, Photo));
						_g_object_unref0 (_tmp40_);
						if (_tmp41_) {
							GeeArrayList* _tmp42_;
							gpointer _tmp43_;
							LibraryPhoto* _tmp44_;
							_tmp42_ = self->priv->matched_editables;
							_tmp43_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
							_tmp44_ = (LibraryPhoto*) _tmp43_;
							photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_PHOTO, Photo), TRUE);
							_g_object_unref0 (_tmp44_);
						}
					}
				}
			}
		}
		_tmp45_ = match;
		photo_monitor_update_editable_file (self, _tmp45_, file);
		_g_object_unref0 (match);
	}
	_tmp46_ = self->priv->matched_developments;
	_tmp47_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp48_ = _tmp47_;
	if (_tmp48_ > 0) {
		LibraryPhoto* match_raw = NULL;
		GeeArrayList* _tmp49_;
		gpointer _tmp50_;
		GeeArrayList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		LibraryPhoto* _tmp62_;
		_tmp49_ = self->priv->matched_developments;
		_tmp50_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		match_raw = (LibraryPhoto*) _tmp50_;
		_tmp51_ = self->priv->matched_developments;
		_tmp52_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp53_ = _tmp52_;
		if (_tmp53_ > 1) {
			gchar* _tmp54_;
			gchar* _tmp55_;
			GeeArrayList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			LibraryPhoto* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp54_ = g_file_get_path (file);
			_tmp55_ = _tmp54_;
			_tmp56_ = self->priv->matched_developments;
			_tmp57_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp58_ = _tmp57_;
			_tmp59_ = match_raw;
			_tmp60_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_DATA_OBJECT, DataObject));
			_tmp61_ = _tmp60_;
			g_warning ("PhotoMonitor.vala:349: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp55_, _tmp58_, _tmp61_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp55_);
		}
		_tmp62_ = match_raw;
		photo_monitor_update_raw_development_file (self, _tmp62_, file);
		_g_object_unref0 (match_raw);
	}
	_vala__result_ = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
	result = NULL;
	_g_object_unref0 (matched_masters);
	if (_result_) {
		*_result_ = _vala__result_;
	}
	return result;
}

static void
_vala_array_add127 (GFile** * array,
                    gint* length,
                    gint* size,
                    GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add128 (GFile** * array,
                    gint* length,
                    gint* size,
                    GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GFile**
_vala_array_dup35 (GFile** self,
                   gssize length)
{
	if (length >= 0) {
		GFile** result;
		gssize i;
		result = g_new0 (GFile*, length + 1);
		for (i = 0; i < length; i++) {
			GFile* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GFile**
photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base,
                                                 Monitorable* monitorable,
                                                 gint* result_length1)
{
	PhotoMonitor * self;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	LibraryPhoto* _tmp2_;
	GeeCollection* raw_files = NULL;
	LibraryPhoto* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GFile** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint __tmp15__size_ = 0;
	GFile** _tmp16_;
	gint _tmp16__length1;
	GFile** _tmp18_;
	gint _tmp18__length1;
	GFile** _tmp19_;
	gint _tmp19__length1;
	GFile** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = photo;
	if (photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo))) {
		LibraryPhoto* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = photo;
		_tmp4_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO, Photo));
		_vala_array_add127 (&files, &files_length1, &_files_size_, _tmp4_);
	}
	_tmp5_ = photo;
	_tmp6_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO, Photo));
	raw_files = _tmp6_;
	_tmp7_ = raw_files;
	if (_tmp7_ != NULL) {
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp8_ = raw_files;
			_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
			_f_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				GFile* f = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				_tmp10_ = _f_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _f_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				f = (GFile*) _tmp12_;
				_tmp13_ = f;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_vala_array_add128 (&files, &files_length1, &_files_size_, _tmp14_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	_tmp16_ = files;
	_tmp16__length1 = files_length1;
	if (_tmp16__length1 > 0) {
		GFile** _tmp17_;
		gint _tmp17__length1;
		_tmp17_ = files;
		_tmp17__length1 = files_length1;
		_tmp15_ = _tmp17_;
		_tmp15__length1 = _tmp17__length1;
		__tmp15__size_ = _tmp15__length1;
	} else {
		_tmp15_ = NULL;
		_tmp15__length1 = 0;
		__tmp15__size_ = _tmp15__length1;
	}
	_tmp18_ = (_tmp15_ != NULL) ? _vala_array_dup35 (_tmp15_, _tmp15__length1) : _tmp15_;
	_tmp18__length1 = _tmp15__length1;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	_g_object_unref0 (raw_files);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (photo);
	return result;
}

static void
photo_monitor_real_update_backing_file_info (MediaMonitor* base,
                                             Monitorable* monitorable,
                                             GFile* file,
                                             GFileInfo* info)
{
	PhotoMonitor * self;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_if_fail (IS_MONITORABLE (monitorable));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp0_;
	_tmp1_ = photo;
	_tmp2_ = media_monitor_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MONITORABLE, Monitorable));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_equal (_tmp3_, file);
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		LibraryPhoto* _tmp5_;
		_tmp5_ = photo;
		photo_monitor_check_for_master_changes (self, _tmp5_, info);
	} else {
		gboolean _tmp6_ = FALSE;
		LibraryPhoto* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = photo;
		_tmp8_ = photo_monitor_get_editable_file (self, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		_g_object_unref0 (_tmp9_);
		if (_tmp10_) {
			LibraryPhoto* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			_tmp11_ = photo;
			_tmp12_ = photo_monitor_get_editable_file (self, _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp6_ = g_file_equal (_tmp13_, file);
			_g_object_unref0 (_tmp13_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			LibraryPhoto* _tmp14_;
			_tmp14_ = photo;
			photo_monitor_check_for_editable_changes (self, _tmp14_, info);
		} else {
			LibraryPhoto* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gboolean _tmp18_;
			_tmp15_ = photo;
			_tmp16_ = photo_monitor_get_raw_development_files (self, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_ != NULL;
			_g_object_unref0 (_tmp17_);
			if (_tmp18_) {
				{
					GeeIterator* _f_it = NULL;
					LibraryPhoto* _tmp19_;
					GeeCollection* _tmp20_;
					GeeCollection* _tmp21_;
					GeeIterator* _tmp22_;
					GeeIterator* _tmp23_;
					_tmp19_ = photo;
					_tmp20_ = photo_monitor_get_raw_development_files (self, _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ITERABLE, GeeIterable));
					_tmp23_ = _tmp22_;
					_g_object_unref0 (_tmp21_);
					_f_it = _tmp23_;
					while (TRUE) {
						GeeIterator* _tmp24_;
						GFile* f = NULL;
						GeeIterator* _tmp25_;
						gpointer _tmp26_;
						GFile* _tmp27_;
						_tmp24_ = _f_it;
						if (!gee_iterator_next (_tmp24_)) {
							break;
						}
						_tmp25_ = _f_it;
						_tmp26_ = gee_iterator_get (_tmp25_);
						f = (GFile*) _tmp26_;
						_tmp27_ = f;
						if (g_file_equal (_tmp27_, file)) {
							LibraryPhoto* _tmp28_;
							_tmp28_ = photo;
							photo_monitor_check_for_raw_development_changes (self, _tmp28_, info);
						}
						_g_object_unref0 (f);
					}
					_g_object_unref0 (_f_it);
				}
			}
		}
	}
	_g_object_unref0 (photo);
}

static void
photo_monitor_real_notify_discovery_completing (MediaMonitor* base)
{
	PhotoMonitor * self;
	GeeArrayList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	_tmp0_ = self->priv->matched_editables;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
}

static void
photo_monitor_check_for_master_changes (PhotoMonitor* self,
                                        LibraryPhoto* photo,
                                        GFileInfo* info)
{
	BackingPhotoRow* state = NULL;
	BackingPhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	BackingPhotoRow* _tmp2_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (info == NULL) {
		return;
	}
	_tmp0_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	state = _tmp0_;
	_tmp1_ = state;
	if (backing_photo_row_matches_file_info (_tmp1_, info)) {
		_backing_photo_row_unref0 (state);
		return;
	}
	_tmp2_ = state;
	if (backing_photo_row_is_touched (_tmp2_, info)) {
		media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
		media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable), info);
	} else {
		photo_monitor_update_reimport_master (self, photo);
	}
	_backing_photo_row_unref0 (state);
}

static void
photo_monitor_check_for_editable_changes (PhotoMonitor* self,
                                          LibraryPhoto* photo,
                                          GFileInfo* info)
{
	BackingPhotoRow* state = NULL;
	BackingPhotoRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BackingPhotoRow* _tmp2_;
	BackingPhotoRow* _tmp4_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (info == NULL) {
		photo_monitor_update_revert_to_master (self, photo);
		return;
	}
	_tmp0_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	state = _tmp0_;
	_tmp2_ = state;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BackingPhotoRow* _tmp3_;
		_tmp3_ = state;
		_tmp1_ = backing_photo_row_matches_file_info (_tmp3_, info);
	}
	if (_tmp1_) {
		_backing_photo_row_unref0 (state);
		return;
	}
	_tmp4_ = state;
	if (backing_photo_row_is_touched (_tmp4_, info)) {
		photo_monitor_update_editable_file_info_altered (self, photo);
		photo_monitor_update_editable_file_alterations_completed (self, photo, info);
	} else {
		photo_monitor_update_reimport_editable (self, photo);
	}
	_backing_photo_row_unref0 (state);
}

static void
photo_monitor_check_for_raw_development_changes (PhotoMonitor* self,
                                                 LibraryPhoto* photo,
                                                 GFileInfo* info)
{
	GeeCollection* rows = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (info == NULL) {
		photo_set_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo), RAW_DEVELOPER_SHOTWELL, TRUE);
		return;
	}
	_tmp0_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	rows = _tmp0_;
	_tmp1_ = rows;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (rows);
		return;
	}
	{
		GeeIterator* _row_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = rows;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_row_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			BackingPhotoRow* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			BackingPhotoRow* _tmp7_;
			const gchar* _tmp8_;
			BackingPhotoRow* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = _row_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _row_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			row = (BackingPhotoRow*) _tmp6_;
			_tmp7_ = row;
			if (backing_photo_row_matches_file_info (_tmp7_, info)) {
				_backing_photo_row_unref0 (row);
				_g_object_unref0 (_row_it);
				_g_object_unref0 (rows);
				return;
			}
			_tmp8_ = g_file_info_get_name (info);
			_tmp9_ = row;
			_tmp10_ = _tmp9_->filepath;
			if (g_strcmp0 (_tmp8_, _tmp10_) == 0) {
				BackingPhotoRow* _tmp11_;
				_tmp11_ = row;
				if (backing_photo_row_is_touched (_tmp11_, info)) {
					photo_monitor_update_raw_development_file_info_altered (self, photo);
					photo_monitor_update_raw_development_file_alterations_completed (self, photo);
				} else {
					photo_monitor_update_reimport_raw_developments (self, photo);
				}
				_backing_photo_row_unref0 (row);
				break;
			}
			_backing_photo_row_unref0 (row);
		}
		_g_object_unref0 (_row_it);
	}
	_g_object_unref0 (rows);
}

static gboolean
photo_monitor_real_notify_file_created (MediaMonitor* base,
                                        GFile* file,
                                        GFileInfo* info)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			gchar* _tmp3_;
			gchar* _tmp4_;
			GEnumValue* _tmp5_;
			_tmp3_ = g_file_get_path (file);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_warning ("PhotoMonitor.vala:481: File %s created in %s state", _tmp4_, (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
			_g_free0 (_tmp4_);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			LibraryPhoto* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			LibraryPhoto* _tmp11_;
			_tmp6_ = photo;
			_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_OBJECT, DataObject));
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("Will mark %s online", _tmp8_);
			_tmp10_ = _tmp9_;
			media_monitor_mdbg (_tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_tmp11_ = photo;
			media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MONITORABLE, Monitorable));
			break;
		}
		default:
		{
			GEnumValue* _tmp12_;
			_tmp12_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_error ("PhotoMonitor.vala:490: Unknown LibraryPhoto collection state %s", (_tmp12_ != NULL) ? _tmp12_->value_name : NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	return result;
}

static gboolean
photo_monitor_real_notify_file_moved (MediaMonitor* base,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* info)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState old_state = 0;
	LibraryPhoto* old_photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhotoSourceCollectionState new_state = 0;
	LibraryPhoto* new_photo = NULL;
	LibraryPhotoSourceCollectionState _tmp2_ = 0;
	LibraryPhoto* _tmp3_;
	gboolean _tmp4_ = FALSE;
	LibraryPhoto* _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, old_file, &_tmp0_);
	old_state = _tmp0_;
	old_photo = _tmp1_;
	_tmp3_ = photo_monitor_get_photo_state_by_file (self, new_file, &_tmp2_);
	new_state = _tmp2_;
	new_photo = _tmp3_;
	_tmp5_ = old_photo;
	if (_tmp5_ != NULL) {
		LibraryPhoto* _tmp6_;
		_tmp6_ = new_photo;
		_tmp4_ = _tmp6_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		switch (old_state) {
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
			{
				LibraryPhoto* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				LibraryPhoto* _tmp14_;
				_tmp7_ = old_photo;
				_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
				_tmp9_ = _tmp8_;
				_tmp10_ = g_file_get_path (new_file);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup_printf ("Will set new master file for %s to %s", _tmp9_, _tmp11_);
				_tmp13_ = _tmp12_;
				media_monitor_mdbg (_tmp13_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				_tmp14_ = old_photo;
				media_monitor_update_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_MONITORABLE, Monitorable), new_file);
				break;
			}
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
			{
				LibraryPhoto* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				LibraryPhoto* _tmp22_;
				_tmp15_ = old_photo;
				_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_OBJECT, DataObject));
				_tmp17_ = _tmp16_;
				_tmp18_ = g_file_get_path (new_file);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup_printf ("Will set new editable file for %s to %s", _tmp17_, _tmp19_);
				_tmp21_ = _tmp20_;
				media_monitor_mdbg (_tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_tmp22_ = old_photo;
				photo_monitor_update_editable_file (self, _tmp22_, new_file);
				break;
			}
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
			{
				LibraryPhoto* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				LibraryPhoto* _tmp30_;
				_tmp23_ = old_photo;
				_tmp24_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DATA_OBJECT, DataObject));
				_tmp25_ = _tmp24_;
				_tmp26_ = g_file_get_path (new_file);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("Will set new raw development file for %s to %s", _tmp25_, _tmp27_);
				_tmp29_ = _tmp28_;
				media_monitor_mdbg (_tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_tmp30_ = old_photo;
				photo_monitor_update_raw_development_file (self, _tmp30_, new_file);
				break;
			}
			default:
			{
				GEnumValue* _tmp31_;
				_tmp31_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), old_state);
				g_error ("PhotoMonitor.vala:539: Unknown LibraryPhoto collection state %s", (_tmp31_ != NULL) ? _tmp31_->value_name : NULL);
			}
		}
	} else {
		gboolean _tmp32_ = FALSE;
		LibraryPhoto* _tmp33_;
		_tmp33_ = old_photo;
		if (_tmp33_ == NULL) {
			LibraryPhoto* _tmp34_;
			_tmp34_ = new_photo;
			_tmp32_ = _tmp34_ != NULL;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			switch (new_state) {
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
				{
					LibraryPhoto* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					LibraryPhoto* _tmp40_;
					_tmp35_ = new_photo;
					_tmp36_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_DATA_OBJECT, DataObject));
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strdup_printf ("Will reimport master file for %s", _tmp37_);
					_tmp39_ = _tmp38_;
					media_monitor_mdbg (_tmp39_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp37_);
					_tmp40_ = new_photo;
					photo_monitor_update_reimport_master (self, _tmp40_);
					break;
				}
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
				{
					LibraryPhoto* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					LibraryPhoto* _tmp46_;
					_tmp41_ = new_photo;
					_tmp42_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_DATA_OBJECT, DataObject));
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strdup_printf ("Will reimport editable file for %s", _tmp43_);
					_tmp45_ = _tmp44_;
					media_monitor_mdbg (_tmp45_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp43_);
					_tmp46_ = new_photo;
					photo_monitor_update_reimport_editable (self, _tmp46_);
					break;
				}
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
				{
					LibraryPhoto* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					LibraryPhoto* _tmp52_;
					_tmp47_ = new_photo;
					_tmp48_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_DATA_OBJECT, DataObject));
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp49_);
					_tmp51_ = _tmp50_;
					media_monitor_mdbg (_tmp51_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp49_);
					_tmp52_ = new_photo;
					photo_monitor_update_reimport_raw_developments (self, _tmp52_);
					break;
				}
				default:
				{
					GEnumValue* _tmp53_;
					_tmp53_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), new_state);
					g_error ("PhotoMonitor.vala:562: Unknown LibraryPhoto collection state %s", (_tmp53_ != NULL) ? _tmp53_->value_name : NULL);
				}
			}
		} else {
			gboolean _tmp54_ = FALSE;
			LibraryPhoto* _tmp55_;
			_tmp55_ = old_photo;
			if (_tmp55_ == NULL) {
				LibraryPhoto* _tmp56_;
				_tmp56_ = new_photo;
				_tmp54_ = _tmp56_ == NULL;
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				result = FALSE;
				_g_object_unref0 (new_photo);
				_g_object_unref0 (old_photo);
				return result;
			} else {
				gboolean _tmp57_ = FALSE;
				LibraryPhoto* _tmp58_;
				_tmp58_ = old_photo;
				if (_tmp58_ != NULL) {
					LibraryPhoto* _tmp59_;
					_tmp59_ = new_photo;
					_tmp57_ = _tmp59_ != NULL;
				} else {
					_tmp57_ = FALSE;
				}
				_vala_assert (_tmp57_, "old_photo != null && new_photo != null");
				switch (old_state) {
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
					{
						LibraryPhoto* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						LibraryPhoto* _tmp65_;
						_tmp60_ = old_photo;
						_tmp61_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_DATA_OBJECT, DataObject));
						_tmp62_ = _tmp61_;
						_tmp63_ = g_strdup_printf ("Will mark offline %s", _tmp62_);
						_tmp64_ = _tmp63_;
						media_monitor_mdbg (_tmp64_);
						_g_free0 (_tmp64_);
						_g_free0 (_tmp62_);
						_tmp65_ = old_photo;
						media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_MONITORABLE, Monitorable));
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
					{
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
					{
						LibraryPhoto* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						LibraryPhoto* _tmp71_;
						_tmp66_ = old_photo;
						_tmp67_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_DATA_OBJECT, DataObject));
						_tmp68_ = _tmp67_;
						_tmp69_ = g_strdup_printf ("Will revert %s to master", _tmp68_);
						_tmp70_ = _tmp69_;
						media_monitor_mdbg (_tmp70_);
						_g_free0 (_tmp70_);
						_g_free0 (_tmp68_);
						_tmp71_ = old_photo;
						photo_monitor_update_revert_to_master (self, _tmp71_);
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
					{
						break;
					}
					default:
					{
						GEnumValue* _tmp72_;
						_tmp72_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), old_state);
						g_error ("PhotoMonitor.vala:591: Unknown LibraryPhoto collection state %s", (_tmp72_ != NULL) ? _tmp72_->value_name : NULL);
					}
				}
				switch (new_state) {
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
					{
						LibraryPhoto* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						gchar* _tmp77_;
						LibraryPhoto* _tmp78_;
						_tmp73_ = new_photo;
						_tmp74_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_DATA_OBJECT, DataObject));
						_tmp75_ = _tmp74_;
						_tmp76_ = g_strdup_printf ("Will reimport master file for %s", _tmp75_);
						_tmp77_ = _tmp76_;
						media_monitor_mdbg (_tmp77_);
						_g_free0 (_tmp77_);
						_g_free0 (_tmp75_);
						_tmp78_ = new_photo;
						photo_monitor_update_reimport_master (self, _tmp78_);
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
					{
						LibraryPhoto* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
						LibraryPhoto* _tmp84_;
						_tmp79_ = new_photo;
						_tmp80_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_DATA_OBJECT, DataObject));
						_tmp81_ = _tmp80_;
						_tmp82_ = g_strdup_printf ("Will reimport editable file for %s", _tmp81_);
						_tmp83_ = _tmp82_;
						media_monitor_mdbg (_tmp83_);
						_g_free0 (_tmp83_);
						_g_free0 (_tmp81_);
						_tmp84_ = new_photo;
						photo_monitor_update_reimport_editable (self, _tmp84_);
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
					{
						LibraryPhoto* _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						LibraryPhoto* _tmp90_;
						_tmp85_ = new_photo;
						_tmp86_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, TYPE_DATA_OBJECT, DataObject));
						_tmp87_ = _tmp86_;
						_tmp88_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp87_);
						_tmp89_ = _tmp88_;
						media_monitor_mdbg (_tmp89_);
						_g_free0 (_tmp89_);
						_g_free0 (_tmp87_);
						_tmp90_ = new_photo;
						photo_monitor_update_reimport_raw_developments (self, _tmp90_);
						break;
					}
					default:
					{
						GEnumValue* _tmp91_;
						_tmp91_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), new_state);
						g_error ("PhotoMonitor.vala:613: Unknown LibraryPhoto collection state %s", (_tmp91_ != NULL) ? _tmp91_->value_name : NULL);
					}
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (new_photo);
	_g_object_unref0 (old_photo);
	return result;
}

static gboolean
photo_monitor_real_notify_file_altered (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		{
			LibraryPhoto* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			LibraryPhoto* _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp3_ = photo;
			_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("Will reimport master for %s", _tmp5_);
			_tmp7_ = _tmp6_;
			media_monitor_mdbg (_tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_tmp8_ = photo;
			photo_monitor_update_reimport_master (self, _tmp8_);
			_tmp9_ = photo;
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable), TRUE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		{
			LibraryPhoto* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			LibraryPhoto* _tmp15_;
			LibraryPhoto* _tmp16_;
			_tmp10_ = photo;
			_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("Will reimport editable for %s", _tmp12_);
			_tmp14_ = _tmp13_;
			media_monitor_mdbg (_tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_tmp15_ = photo;
			photo_monitor_update_reimport_editable (self, _tmp15_);
			_tmp16_ = photo;
			photo_monitor_update_editable_file_in_alteration (self, _tmp16_, TRUE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			LibraryPhoto* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			LibraryPhoto* _tmp22_;
			LibraryPhoto* _tmp23_;
			_tmp17_ = photo;
			_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject));
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("Will reimport raw development for %s", _tmp19_);
			_tmp21_ = _tmp20_;
			media_monitor_mdbg (_tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_tmp22_ = photo;
			photo_monitor_update_reimport_raw_developments (self, _tmp22_);
			_tmp23_ = photo;
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp23_, TRUE);
			break;
		}
		default:
		{
			GEnumValue* _tmp24_;
			_tmp24_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_error ("PhotoMonitor.vala:648: Unknown LibraryPhoto collection state %s", (_tmp24_ != NULL) ? _tmp24_->value_name : NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	return result;
}

static gboolean
photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                   GFile* file)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		{
			LibraryPhoto* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			LibraryPhoto* _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp3_ = photo;
			_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("Will update master file info for %s", _tmp5_);
			_tmp7_ = _tmp6_;
			media_monitor_mdbg (_tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_tmp8_ = photo;
			media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MONITORABLE, Monitorable));
			_tmp9_ = photo;
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable), TRUE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			gchar* _tmp10_;
			gchar* _tmp11_;
			GEnumValue* _tmp12_;
			LibraryPhoto* _tmp13_;
			_tmp10_ = g_file_get_path (file);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_warning ("PhotoMonitor.vala:670: File %s attributes altered in %s state", _tmp11_, (_tmp12_ != NULL) ? _tmp12_->value_name : NULL);
			_g_free0 (_tmp11_);
			_tmp13_ = photo;
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE, Monitorable), TRUE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		{
			LibraryPhoto* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			LibraryPhoto* _tmp19_;
			LibraryPhoto* _tmp20_;
			_tmp14_ = photo;
			_tmp15_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("Will update editable file info for %s", _tmp16_);
			_tmp18_ = _tmp17_;
			media_monitor_mdbg (_tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			_tmp19_ = photo;
			photo_monitor_update_editable_file_info_altered (self, _tmp19_);
			_tmp20_ = photo;
			photo_monitor_update_editable_file_in_alteration (self, _tmp20_, TRUE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			LibraryPhoto* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			LibraryPhoto* _tmp26_;
			LibraryPhoto* _tmp27_;
			_tmp21_ = photo;
			_tmp22_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf ("Will update raw development file info for %s", _tmp23_);
			_tmp25_ = _tmp24_;
			media_monitor_mdbg (_tmp25_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_tmp26_ = photo;
			photo_monitor_update_raw_development_file_info_altered (self, _tmp26_);
			_tmp27_ = photo;
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp27_, TRUE);
			break;
		}
		default:
		{
			GEnumValue* _tmp28_;
			_tmp28_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_error ("PhotoMonitor.vala:688: Unknown LibraryPhoto collection state %s", (_tmp28_ != NULL) ? _tmp28_->value_name : NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	return result;
}

static gboolean
photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			LibraryPhoto* _tmp3_;
			_tmp3_ = photo;
			media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable), info);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		{
			LibraryPhoto* _tmp4_;
			_tmp4_ = photo;
			photo_monitor_update_editable_file_alterations_completed (self, _tmp4_, info);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			LibraryPhoto* _tmp5_;
			_tmp5_ = photo;
			photo_monitor_update_raw_development_file_alterations_completed (self, _tmp5_);
			break;
		}
		default:
		{
			GEnumValue* _tmp6_;
			_tmp6_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_error ("PhotoMonitor.vala:716: Unknown LibraryPhoto collection state %s", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	return result;
}

static gboolean
photo_monitor_real_notify_file_deleted (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
	state = _tmp0_;
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	switch (state) {
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
		{
			LibraryPhoto* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			LibraryPhoto* _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp3_ = photo;
			_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("Will mark %s offline", _tmp5_);
			_tmp7_ = _tmp6_;
			media_monitor_mdbg (_tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_tmp8_ = photo;
			media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MONITORABLE, Monitorable));
			_tmp9_ = photo;
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable), FALSE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			LibraryPhoto* _tmp10_;
			_tmp10_ = photo;
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable), FALSE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
		{
			LibraryPhoto* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			LibraryPhoto* _tmp16_;
			LibraryPhoto* _tmp17_;
			_tmp11_ = photo;
			_tmp12_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Will revert %s to master", _tmp13_);
			_tmp15_ = _tmp14_;
			media_monitor_mdbg (_tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_tmp16_ = photo;
			photo_monitor_update_revert_to_master (self, _tmp16_);
			_tmp17_ = photo;
			photo_monitor_update_editable_file_in_alteration (self, _tmp17_, FALSE);
			break;
		}
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
		{
			LibraryPhoto* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			LibraryPhoto* _tmp23_;
			LibraryPhoto* _tmp24_;
			LibraryPhoto* _tmp25_;
			_tmp18_ = photo;
			_tmp19_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_OBJECT, DataObject));
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("Will revert %s to master", _tmp20_);
			_tmp22_ = _tmp21_;
			media_monitor_mdbg (_tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp23_ = photo;
			photo_monitor_update_revert_to_master (self, _tmp23_);
			_tmp24_ = photo;
			photo_monitor_update_editable_file_in_alteration (self, _tmp24_, FALSE);
			_tmp25_ = photo;
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp25_, FALSE);
			break;
		}
		default:
		{
			GEnumValue* _tmp26_;
			_tmp26_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), state);
			g_error ("PhotoMonitor.vala:755: Unknown LibraryPhoto collection state %s", (_tmp26_ != NULL) ? _tmp26_->value_name : NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	return result;
}

static void
photo_monitor_real_on_media_source_destroyed (MediaMonitor* base,
                                              DataSource* source)
{
	PhotoMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_if_fail (IS_DATA_SOURCE (source));
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->on_media_source_destroyed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), source);
	photo_monitor_cancel_reimports (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
}

static LibraryPhoto*
photo_monitor_get_photo_state_by_file (PhotoMonitor* self,
                                       GFile* file,
                                       LibraryPhotoSourceCollectionState* state)
{
	LibraryPhotoSourceCollectionState _vala_state = 0;
	GFile* real_file = NULL;
	GFile* _tmp57_ = NULL;
	GFile* _tmp58_;
	LibraryPhotoSourceCollection* _tmp59_;
	LibraryPhotoSourceCollectionState _tmp60_ = 0;
	LibraryPhoto* _tmp61_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	real_file = NULL;
	if (media_monitor_has_pending_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor))) {
		{
			GeeIterator* _monitorable_it = NULL;
			GeeCollection* _tmp0_;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_;
			GeeIterator* _tmp3_;
			_tmp0_ = media_monitor_get_monitorables (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_monitorable_it = _tmp3_;
			while (TRUE) {
				GeeIterator* _tmp4_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				LibraryPhoto* photo = NULL;
				Monitorable* _tmp7_;
				LibraryPhoto* _tmp8_;
				PhotoUpdates* updates = NULL;
				LibraryPhoto* _tmp9_;
				PhotoUpdates* _tmp10_;
				PhotoUpdates* _tmp11_;
				gboolean _tmp12_ = FALSE;
				PhotoUpdates* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp22_ = FALSE;
				PhotoUpdates* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				gboolean _tmp26_;
				PhotoUpdates* _tmp33_;
				GeeCollection* _tmp34_;
				GeeCollection* _tmp35_;
				gboolean _tmp36_;
				_tmp4_ = _monitorable_it;
				if (!gee_iterator_next (_tmp4_)) {
					break;
				}
				_tmp5_ = _monitorable_it;
				_tmp6_ = gee_iterator_get (_tmp5_);
				monitorable = (Monitorable*) _tmp6_;
				_tmp7_ = monitorable;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp8_;
				_tmp9_ = photo;
				_tmp10_ = photo_monitor_get_existing_photo_updates (self, _tmp9_);
				updates = _tmp10_;
				_tmp11_ = updates;
				if (_tmp11_ == NULL) {
					_monitorable_updates_unref0 (updates);
					_g_object_unref0 (photo);
					_g_object_unref0 (monitorable);
					continue;
				}
				_tmp13_ = updates;
				_tmp14_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_ != NULL;
				_g_object_unref0 (_tmp15_);
				if (_tmp16_) {
					PhotoUpdates* _tmp17_;
					GFile* _tmp18_;
					GFile* _tmp19_;
					_tmp17_ = updates;
					_tmp18_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
					_tmp19_ = _tmp18_;
					_tmp12_ = g_file_equal (_tmp19_, file);
					_g_object_unref0 (_tmp19_);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					LibraryPhoto* _tmp20_;
					GFile* _tmp21_;
					_tmp20_ = photo;
					_tmp21_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MEDIA_SOURCE, MediaSource));
					_g_object_unref0 (real_file);
					real_file = _tmp21_;
					_monitorable_updates_unref0 (updates);
					_g_object_unref0 (photo);
					_g_object_unref0 (monitorable);
					break;
				}
				_tmp23_ = updates;
				_tmp24_ = photo_updates_get_editable_file (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_ != NULL;
				_g_object_unref0 (_tmp25_);
				if (_tmp26_) {
					PhotoUpdates* _tmp27_;
					GFile* _tmp28_;
					GFile* _tmp29_;
					_tmp27_ = updates;
					_tmp28_ = photo_updates_get_editable_file (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp22_ = g_file_equal (_tmp29_, file);
					_g_object_unref0 (_tmp29_);
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					LibraryPhoto* _tmp30_;
					GFile* _tmp31_;
					GFile* _tmp32_;
					_tmp30_ = photo;
					_tmp31_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO, Photo));
					_g_object_unref0 (real_file);
					real_file = _tmp31_;
					_tmp32_ = real_file;
					if (_tmp32_ == NULL) {
						_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE;
						result = photo;
						_monitorable_updates_unref0 (updates);
						_g_object_unref0 (monitorable);
						_g_object_unref0 (_monitorable_it);
						_g_object_unref0 (real_file);
						if (state) {
							*state = _vala_state;
						}
						return result;
					}
					_monitorable_updates_unref0 (updates);
					_g_object_unref0 (photo);
					_g_object_unref0 (monitorable);
					break;
				}
				_tmp33_ = updates;
				_tmp34_ = photo_updates_get_raw_developer_files (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp35_ != NULL;
				_g_object_unref0 (_tmp35_);
				if (_tmp36_) {
					gboolean found = FALSE;
					found = FALSE;
					{
						GeeIterator* _raw_it = NULL;
						PhotoUpdates* _tmp37_;
						GeeCollection* _tmp38_;
						GeeCollection* _tmp39_;
						GeeIterator* _tmp40_;
						GeeIterator* _tmp41_;
						_tmp37_ = updates;
						_tmp38_ = photo_updates_get_raw_developer_files (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ITERABLE, GeeIterable));
						_tmp41_ = _tmp40_;
						_g_object_unref0 (_tmp39_);
						_raw_it = _tmp41_;
						while (TRUE) {
							GeeIterator* _tmp42_;
							GFile* raw = NULL;
							GeeIterator* _tmp43_;
							gpointer _tmp44_;
							GFile* _tmp45_;
							_tmp42_ = _raw_it;
							if (!gee_iterator_next (_tmp42_)) {
								break;
							}
							_tmp43_ = _raw_it;
							_tmp44_ = gee_iterator_get (_tmp43_);
							raw = (GFile*) _tmp44_;
							_tmp45_ = raw;
							if (g_file_equal (_tmp45_, file)) {
								found = TRUE;
								_g_object_unref0 (raw);
								break;
							}
							_g_object_unref0 (raw);
						}
						_g_object_unref0 (_raw_it);
					}
					if (found) {
						GeeCollection* developed = NULL;
						LibraryPhoto* _tmp46_;
						GeeCollection* _tmp47_;
						GeeCollection* _tmp48_;
						_tmp46_ = photo;
						_tmp47_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_PHOTO, Photo));
						developed = _tmp47_;
						_tmp48_ = developed;
						if (_tmp48_ != NULL) {
							{
								GeeIterator* _f_it = NULL;
								GeeCollection* _tmp49_;
								GeeIterator* _tmp50_;
								_tmp49_ = developed;
								_tmp50_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ITERABLE, GeeIterable));
								_f_it = _tmp50_;
								while (TRUE) {
									GeeIterator* _tmp51_;
									GFile* f = NULL;
									GeeIterator* _tmp52_;
									gpointer _tmp53_;
									GFile* _tmp54_;
									_tmp51_ = _f_it;
									if (!gee_iterator_next (_tmp51_)) {
										break;
									}
									_tmp52_ = _f_it;
									_tmp53_ = gee_iterator_get (_tmp52_);
									f = (GFile*) _tmp53_;
									_tmp54_ = f;
									if (g_file_equal (_tmp54_, file)) {
										GFile* _tmp55_;
										GFile* _tmp56_;
										_tmp55_ = f;
										_tmp56_ = _g_object_ref0 (_tmp55_);
										_g_object_unref0 (real_file);
										real_file = _tmp56_;
										_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER;
										_g_object_unref0 (f);
										break;
									}
									_g_object_unref0 (f);
								}
								_g_object_unref0 (_f_it);
							}
						}
						_g_object_unref0 (developed);
						_monitorable_updates_unref0 (updates);
						_g_object_unref0 (photo);
						_g_object_unref0 (monitorable);
						break;
					}
				}
				_monitorable_updates_unref0 (updates);
				_g_object_unref0 (photo);
				_g_object_unref0 (monitorable);
			}
			_g_object_unref0 (_monitorable_it);
		}
	}
	_tmp58_ = real_file;
	_tmp57_ = _tmp58_;
	if (_tmp57_ == NULL) {
		_tmp57_ = file;
	}
	_tmp59_ = library_photo_global;
	_tmp61_ = library_photo_source_collection_get_state_by_file (_tmp59_, _tmp57_, &_tmp60_);
	_vala_state = _tmp60_;
	result = _tmp61_;
	_g_object_unref0 (real_file);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

PhotoUpdates*
photo_monitor_fetch_photo_updates (PhotoMonitor* self,
                                   LibraryPhoto* photo)
{
	MonitorableUpdates* _tmp0_;
	PhotoUpdates* result;
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = media_monitor_fetch_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_UPDATES, PhotoUpdates);
	return result;
}

PhotoUpdates*
photo_monitor_get_existing_photo_updates (PhotoMonitor* self,
                                          LibraryPhoto* photo)
{
	MonitorableUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	PhotoUpdates* result;
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = media_monitor_get_existing_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
	_tmp1_ = IS_PHOTO_UPDATES (_tmp0_) ? ((PhotoUpdates*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_monitorable_updates_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

void
photo_monitor_update_reimport_master (PhotoMonitor* self,
                                      LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_reimport_master (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
	_tmp2_ = self->priv->master_reimport_pending;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportMasterJob* _tmp5_;
		_tmp3_ = self->priv->master_reimport_pending;
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
		_tmp5_ = (PhotoMonitorReimportMasterJob*) _tmp4_;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
		_background_job_unref0 (_tmp5_);
	}
}

void
photo_monitor_update_reimport_editable (PhotoMonitor* self,
                                        LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_reimport_editable (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
	_tmp2_ = self->priv->editable_reimport_pending;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportEditableJob* _tmp5_;
		_tmp3_ = self->priv->editable_reimport_pending;
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
		_tmp5_ = (PhotoMonitorReimportEditableJob*) _tmp4_;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
		_background_job_unref0 (_tmp5_);
	}
}

void
photo_monitor_update_reimport_raw_developments (PhotoMonitor* self,
                                                LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_reimport_raw_developments (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
	_tmp2_ = self->priv->raw_developments_reimport_pending;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp5_;
		_tmp3_ = self->priv->raw_developments_reimport_pending;
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
		_tmp5_ = (PhotoMonitorReimportRawDevelopmentJob*) _tmp4_;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
		_background_job_unref0 (_tmp5_);
	}
}

GFile*
photo_monitor_get_editable_file (PhotoMonitor* self,
                                 LibraryPhoto* photo)
{
	PhotoUpdates* updates = NULL;
	PhotoUpdates* _tmp0_;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoUpdates* _tmp3_;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = photo_monitor_get_existing_photo_updates (self, photo);
	updates = _tmp0_;
	_tmp3_ = updates;
	if (_tmp3_ != NULL) {
		PhotoUpdates* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = updates;
		_tmp5_ = photo_updates_get_editable_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PhotoUpdates* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = updates;
		_tmp8_ = photo_updates_get_editable_file (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp8_;
	} else {
		GFile* _tmp9_;
		_tmp9_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp9_;
	}
	result = _tmp1_;
	_monitorable_updates_unref0 (updates);
	return result;
}

GeeCollection*
photo_monitor_get_raw_development_files (PhotoMonitor* self,
                                         LibraryPhoto* photo)
{
	PhotoUpdates* updates = NULL;
	PhotoUpdates* _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoUpdates* _tmp3_;
	GeeCollection* result;
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = photo_monitor_get_existing_photo_updates (self, photo);
	updates = _tmp0_;
	_tmp3_ = updates;
	if (_tmp3_ != NULL) {
		PhotoUpdates* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		_tmp4_ = updates;
		_tmp5_ = photo_updates_get_raw_developer_files (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PhotoUpdates* _tmp7_;
		GeeCollection* _tmp8_;
		_tmp7_ = updates;
		_tmp8_ = photo_updates_get_raw_developer_files (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp8_;
	} else {
		GeeCollection* _tmp9_;
		_tmp9_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp9_;
	}
	result = _tmp1_;
	_monitorable_updates_unref0 (updates);
	return result;
}

void
photo_monitor_update_editable_file (PhotoMonitor* self,
                                    LibraryPhoto* photo,
                                    GFile* file)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_editable_file (_tmp1_, file);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_editable_file_info_altered (PhotoMonitor* self,
                                                 LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_editable_file_info_altered (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_raw_development_file (PhotoMonitor* self,
                                           LibraryPhoto* photo,
                                           GFile* file)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_add_raw_developer_file (_tmp1_, file);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self,
                                                        LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_raw_developer_file_info_altered (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self,
                                                  LibraryPhoto* photo,
                                                  gboolean in_alteration)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_editable_in_alteration (_tmp1_, in_alteration);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self,
                                                          LibraryPhoto* photo,
                                                          GFileInfo* info)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	PhotoUpdates* _tmp2_;
	PhotoUpdates* _tmp3_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_editable_file_info (_tmp1_, info);
	_monitorable_updates_unref0 (_tmp1_);
	_tmp2_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp3_ = _tmp2_;
	photo_updates_set_editable_in_alteration (_tmp3_, FALSE);
	_monitorable_updates_unref0 (_tmp3_);
}

void
photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self,
                                                         LibraryPhoto* photo,
                                                         gboolean in_alteration)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_raw_development_in_alteration (_tmp1_, in_alteration);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self,
                                                                 LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_raw_development_in_alteration (_tmp1_, FALSE);
	_monitorable_updates_unref0 (_tmp1_);
}

void
photo_monitor_update_revert_to_master (PhotoMonitor* self,
                                       LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
	_tmp1_ = _tmp0_;
	photo_updates_set_revert_to_master (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
}

static gpointer
_monitorable_updates_ref0 (gpointer self)
{
	return self ? monitorable_updates_ref (self) : NULL;
}

static void
photo_monitor_real_process_updates (MediaMonitor* base,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	PhotoMonitor * self;
	GeeMap* set_editable_file = NULL;
	GeeMap* set_editable_file_info = NULL;
	GeeMap* set_raw_developer_files = NULL;
	GeeArrayList* revert_to_master = NULL;
	GeeArrayList* reimport_master = NULL;
	GeeArrayList* reimport_editable = NULL;
	GeeArrayList* reimport_raw_developments = NULL;
	gint reimport_job_count = 0;
	GeeMap* _tmp80_;
	GeeMap* _tmp88_;
	GeeArrayList* _tmp96_;
	GeeArrayList* _tmp111_;
	GeeArrayList* _tmp134_;
	GeeArrayList* _tmp157_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (all_updates, GEE_TYPE_COLLECTION));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), all_updates, controller, op_count, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	set_editable_file = NULL;
	set_editable_file_info = NULL;
	set_raw_developer_files = NULL;
	revert_to_master = NULL;
	reimport_master = NULL;
	reimport_editable = NULL;
	reimport_raw_developments = NULL;
	reimport_job_count = 0;
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (all_updates, GEE_TYPE_ITERABLE, GeeIterable));
		_monitorable_updates_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			PhotoUpdates* updates = NULL;
			MonitorableUpdates* _tmp4_;
			PhotoUpdates* _tmp5_;
			PhotoUpdates* _tmp6_;
			PhotoUpdates* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			gboolean _tmp10_;
			PhotoUpdates* _tmp21_;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
			gboolean _tmp24_;
			PhotoUpdates* _tmp35_;
			GeeCollection* _tmp36_;
			GeeCollection* _tmp37_;
			gboolean _tmp38_;
			PhotoUpdates* _tmp49_;
			gboolean _tmp60_ = FALSE;
			PhotoUpdates* _tmp61_;
			gboolean _tmp70_ = FALSE;
			PhotoUpdates* _tmp71_;
			_tmp1_ = _monitorable_updates_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _monitorable_updates_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			monitorable_updates = (MonitorableUpdates*) _tmp3_;
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
				_monitorable_updates_unref0 (monitorable_updates);
				break;
			}
			_tmp4_ = monitorable_updates;
			_tmp5_ = _monitorable_updates_ref0 (IS_PHOTO_UPDATES (_tmp4_) ? ((PhotoUpdates*) _tmp4_) : NULL);
			updates = _tmp5_;
			_tmp6_ = updates;
			if (_tmp6_ == NULL) {
				_monitorable_updates_unref0 (updates);
				_monitorable_updates_unref0 (monitorable_updates);
				continue;
			}
			_tmp7_ = updates;
			_tmp8_ = photo_updates_get_editable_file (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_object_unref0 (_tmp9_);
			if (_tmp10_) {
				GeeMap* _tmp11_;
				GeeMap* _tmp13_;
				PhotoUpdates* _tmp14_;
				LibraryPhoto* _tmp15_;
				PhotoUpdates* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				PhotoUpdates* _tmp19_;
				gint _tmp20_;
				_tmp11_ = set_editable_file;
				if (_tmp11_ == NULL) {
					GeeHashMap* _tmp12_;
					_tmp12_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (set_editable_file);
					set_editable_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_MAP, GeeMap);
				}
				_tmp13_ = set_editable_file;
				_tmp14_ = updates;
				_tmp15_ = _tmp14_->photo;
				_tmp16_ = updates;
				_tmp17_ = photo_updates_get_editable_file (_tmp16_);
				_tmp18_ = _tmp17_;
				gee_map_set (_tmp13_, _tmp15_, _tmp18_);
				_g_object_unref0 (_tmp18_);
				_tmp19_ = updates;
				photo_updates_set_editable_file (_tmp19_, NULL);
				_tmp20_ = *op_count;
				*op_count = _tmp20_ + 1;
			}
			_tmp21_ = updates;
			_tmp22_ = photo_updates_get_editable_file_info (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_ != NULL;
			_g_object_unref0 (_tmp23_);
			if (_tmp24_) {
				GeeMap* _tmp25_;
				GeeMap* _tmp27_;
				PhotoUpdates* _tmp28_;
				LibraryPhoto* _tmp29_;
				PhotoUpdates* _tmp30_;
				GFileInfo* _tmp31_;
				GFileInfo* _tmp32_;
				PhotoUpdates* _tmp33_;
				gint _tmp34_;
				_tmp25_ = set_editable_file_info;
				if (_tmp25_ == NULL) {
					GeeHashMap* _tmp26_;
					_tmp26_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (set_editable_file_info);
					set_editable_file_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_MAP, GeeMap);
				}
				_tmp27_ = set_editable_file_info;
				_tmp28_ = updates;
				_tmp29_ = _tmp28_->photo;
				_tmp30_ = updates;
				_tmp31_ = photo_updates_get_editable_file_info (_tmp30_);
				_tmp32_ = _tmp31_;
				gee_map_set (_tmp27_, _tmp29_, _tmp32_);
				_g_object_unref0 (_tmp32_);
				_tmp33_ = updates;
				photo_updates_set_editable_file_info (_tmp33_, NULL);
				_tmp34_ = *op_count;
				*op_count = _tmp34_ + 1;
			}
			_tmp35_ = updates;
			_tmp36_ = photo_updates_get_raw_developer_files (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_ != NULL;
			_g_object_unref0 (_tmp37_);
			if (_tmp38_) {
				GeeMap* _tmp39_;
				GeeMap* _tmp41_;
				PhotoUpdates* _tmp42_;
				LibraryPhoto* _tmp43_;
				PhotoUpdates* _tmp44_;
				GeeCollection* _tmp45_;
				GeeCollection* _tmp46_;
				PhotoUpdates* _tmp47_;
				gint _tmp48_;
				_tmp39_ = set_raw_developer_files;
				if (_tmp39_ == NULL) {
					GeeHashMap* _tmp40_;
					_tmp40_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (set_raw_developer_files);
					set_raw_developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_MAP, GeeMap);
				}
				_tmp41_ = set_raw_developer_files;
				_tmp42_ = updates;
				_tmp43_ = _tmp42_->photo;
				_tmp44_ = updates;
				_tmp45_ = photo_updates_get_raw_developer_files (_tmp44_);
				_tmp46_ = _tmp45_;
				gee_map_set (_tmp41_, _tmp43_, _tmp46_);
				_g_object_unref0 (_tmp46_);
				_tmp47_ = updates;
				photo_updates_clear_raw_developer_files (_tmp47_);
				_tmp48_ = *op_count;
				*op_count = _tmp48_ + 1;
			}
			_tmp49_ = updates;
			if (photo_updates_is_revert_to_master (_tmp49_)) {
				GeeArrayList* _tmp50_;
				GeeArrayList* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp59_;
				_tmp50_ = revert_to_master;
				if (_tmp50_ == NULL) {
					GeeArrayList* _tmp51_;
					_tmp51_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (revert_to_master);
					revert_to_master = _tmp51_;
				}
				_tmp52_ = revert_to_master;
				_tmp53_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_tmp54_ = _tmp53_;
				if (_tmp54_ < PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE) {
					GeeArrayList* _tmp55_;
					PhotoUpdates* _tmp56_;
					LibraryPhoto* _tmp57_;
					PhotoUpdates* _tmp58_;
					_tmp55_ = revert_to_master;
					_tmp56_ = updates;
					_tmp57_ = _tmp56_->photo;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp57_);
					_tmp58_ = updates;
					photo_updates_set_revert_to_master (_tmp58_, FALSE);
				}
				_tmp59_ = *op_count;
				*op_count = _tmp59_ + 1;
			}
			_tmp61_ = updates;
			if (photo_updates_is_reimport_master (_tmp61_)) {
				_tmp60_ = reimport_job_count < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				GeeArrayList* _tmp62_;
				GeeArrayList* _tmp64_;
				PhotoUpdates* _tmp65_;
				LibraryPhoto* _tmp66_;
				PhotoUpdates* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				_tmp62_ = reimport_master;
				if (_tmp62_ == NULL) {
					GeeArrayList* _tmp63_;
					_tmp63_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (reimport_master);
					reimport_master = _tmp63_;
				}
				_tmp64_ = reimport_master;
				_tmp65_ = updates;
				_tmp66_ = _tmp65_->photo;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp66_);
				_tmp67_ = updates;
				photo_updates_set_reimport_master (_tmp67_, FALSE);
				_tmp68_ = reimport_job_count;
				reimport_job_count = _tmp68_ + 1;
				_tmp69_ = *op_count;
				*op_count = _tmp69_ + 1;
			}
			_tmp71_ = updates;
			if (photo_updates_is_reimport_editable (_tmp71_)) {
				_tmp70_ = reimport_job_count < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
			} else {
				_tmp70_ = FALSE;
			}
			if (_tmp70_) {
				GeeArrayList* _tmp72_;
				GeeArrayList* _tmp74_;
				PhotoUpdates* _tmp75_;
				LibraryPhoto* _tmp76_;
				PhotoUpdates* _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				_tmp72_ = reimport_editable;
				if (_tmp72_ == NULL) {
					GeeArrayList* _tmp73_;
					_tmp73_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (reimport_editable);
					reimport_editable = _tmp73_;
				}
				_tmp74_ = reimport_editable;
				_tmp75_ = updates;
				_tmp76_ = _tmp75_->photo;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp76_);
				_tmp77_ = updates;
				photo_updates_set_reimport_editable (_tmp77_, FALSE);
				_tmp78_ = reimport_job_count;
				reimport_job_count = _tmp78_ + 1;
				_tmp79_ = *op_count;
				*op_count = _tmp79_ + 1;
			}
			_monitorable_updates_unref0 (updates);
			_monitorable_updates_unref0 (monitorable_updates);
		}
		_g_object_unref0 (_monitorable_updates_it);
	}
	_tmp80_ = set_editable_file;
	if (_tmp80_ != NULL) {
		GeeMap* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp81_ = set_editable_file;
		_tmp82_ = gee_map_get_size (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strdup_printf ("Changing editable file of %d photos", _tmp83_);
		_tmp85_ = _tmp84_;
		media_monitor_mdbg (_tmp85_);
		_g_free0 (_tmp85_);
		{
			GeeMap* _tmp86_;
			_tmp86_ = set_editable_file;
			photo_set_many_editable_file (_tmp86_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				_g_object_unref0 (reimport_raw_developments);
				_g_object_unref0 (reimport_editable);
				_g_object_unref0 (reimport_master);
				_g_object_unref0 (revert_to_master);
				_g_object_unref0 (set_raw_developer_files);
				_g_object_unref0 (set_editable_file_info);
				_g_object_unref0 (set_editable_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_database_error:
		{
			GError* err = NULL;
			GError* _tmp87_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp87_ = err;
			app_window_database_error (_tmp87_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (reimport_raw_developments);
			_g_object_unref0 (reimport_editable);
			_g_object_unref0 (reimport_master);
			_g_object_unref0 (revert_to_master);
			_g_object_unref0 (set_raw_developer_files);
			_g_object_unref0 (set_editable_file_info);
			_g_object_unref0 (set_editable_file);
			return;
		}
	}
	_tmp88_ = set_editable_file_info;
	if (_tmp88_ != NULL) {
		GeeMap* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp89_ = set_editable_file_info;
		_tmp90_ = gee_map_get_size (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strdup_printf ("Updating %d editable files timestamps", _tmp91_);
		_tmp93_ = _tmp92_;
		media_monitor_mdbg (_tmp93_);
		_g_free0 (_tmp93_);
		{
			GeeMap* _tmp94_;
			_tmp94_ = set_editable_file_info;
			photo_update_many_editable_timestamps (_tmp94_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch1_database_error;
				}
				_g_object_unref0 (reimport_raw_developments);
				_g_object_unref0 (reimport_editable);
				_g_object_unref0 (reimport_master);
				_g_object_unref0 (revert_to_master);
				_g_object_unref0 (set_raw_developer_files);
				_g_object_unref0 (set_editable_file_info);
				_g_object_unref0 (set_editable_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally1;
		__catch1_database_error:
		{
			GError* err = NULL;
			GError* _tmp95_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp95_ = err;
			app_window_database_error (_tmp95_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (reimport_raw_developments);
			_g_object_unref0 (reimport_editable);
			_g_object_unref0 (reimport_master);
			_g_object_unref0 (revert_to_master);
			_g_object_unref0 (set_raw_developer_files);
			_g_object_unref0 (set_editable_file_info);
			_g_object_unref0 (set_editable_file);
			return;
		}
	}
	_tmp96_ = revert_to_master;
	if (_tmp96_ != NULL) {
		GeeArrayList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		_tmp97_ = revert_to_master;
		_tmp98_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp99_ = _tmp98_;
		_tmp100_ = g_strdup_printf ("Reverting %d photos to master", _tmp99_);
		_tmp101_ = _tmp100_;
		media_monitor_mdbg (_tmp101_);
		_g_free0 (_tmp101_);
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp102_;
			gint _photo_size = 0;
			GeeArrayList* _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			gint _photo_index = 0;
			_tmp102_ = revert_to_master;
			_photo_list = _tmp102_;
			_tmp103_ = _photo_list;
			_tmp104_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp105_ = _tmp104_;
			_photo_size = _tmp105_;
			_photo_index = -1;
			while (TRUE) {
				gint _tmp106_;
				gint _tmp107_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp108_;
				gpointer _tmp109_;
				LibraryPhoto* _tmp110_;
				_photo_index = _photo_index + 1;
				_tmp106_ = _photo_index;
				_tmp107_ = _photo_size;
				if (!(_tmp106_ < _tmp107_)) {
					break;
				}
				_tmp108_ = _photo_list;
				_tmp109_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _photo_index);
				photo = (LibraryPhoto*) _tmp109_;
				_tmp110_ = photo;
				photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, TYPE_PHOTO, Photo), TRUE);
				_g_object_unref0 (photo);
			}
		}
	}
	_tmp111_ = reimport_master;
	if (_tmp111_ != NULL) {
		GeeArrayList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		_tmp112_ = reimport_master;
		_tmp113_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp114_ = _tmp113_;
		_tmp115_ = g_strdup_printf ("Reimporting %d masters", _tmp114_);
		_tmp116_ = _tmp115_;
		media_monitor_mdbg (_tmp116_);
		_g_free0 (_tmp116_);
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp117_;
			gint _photo_size = 0;
			GeeArrayList* _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			gint _photo_index = 0;
			_tmp117_ = reimport_master;
			_photo_list = _tmp117_;
			_tmp118_ = _photo_list;
			_tmp119_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp120_ = _tmp119_;
			_photo_size = _tmp120_;
			_photo_index = -1;
			while (TRUE) {
				gint _tmp121_;
				gint _tmp122_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp123_;
				gpointer _tmp124_;
				GeeHashMap* _tmp125_;
				LibraryPhoto* _tmp126_;
				PhotoMonitorReimportMasterJob* job = NULL;
				LibraryPhoto* _tmp127_;
				PhotoMonitorReimportMasterJob* _tmp128_;
				GeeHashMap* _tmp129_;
				LibraryPhoto* _tmp130_;
				PhotoMonitorReimportMasterJob* _tmp131_;
				Workers* _tmp132_;
				PhotoMonitorReimportMasterJob* _tmp133_;
				_photo_index = _photo_index + 1;
				_tmp121_ = _photo_index;
				_tmp122_ = _photo_size;
				if (!(_tmp121_ < _tmp122_)) {
					break;
				}
				_tmp123_ = _photo_list;
				_tmp124_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _photo_index);
				photo = (LibraryPhoto*) _tmp124_;
				_tmp125_ = self->priv->master_reimport_pending;
				_tmp126_ = photo;
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp126_), "!master_reimport_pending.has_key(photo)");
				_tmp127_ = photo;
				_tmp128_ = photo_monitor_reimport_master_job_new (self, _tmp127_);
				job = _tmp128_;
				_tmp129_ = self->priv->master_reimport_pending;
				_tmp130_ = photo;
				_tmp131_ = job;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp130_, _tmp131_);
				_tmp132_ = self->priv->workers;
				_tmp133_ = job;
				workers_enqueue (_tmp132_, G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, TYPE_BACKGROUND_JOB, BackgroundJob));
				_background_job_unref0 (job);
				_g_object_unref0 (photo);
			}
		}
	}
	_tmp134_ = reimport_editable;
	if (_tmp134_ != NULL) {
		GeeArrayList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		_tmp135_ = reimport_editable;
		_tmp136_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp137_ = _tmp136_;
		_tmp138_ = g_strdup_printf ("Reimporting %d editables", _tmp137_);
		_tmp139_ = _tmp138_;
		media_monitor_mdbg (_tmp139_);
		_g_free0 (_tmp139_);
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp140_;
			gint _photo_size = 0;
			GeeArrayList* _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			gint _photo_index = 0;
			_tmp140_ = reimport_editable;
			_photo_list = _tmp140_;
			_tmp141_ = _photo_list;
			_tmp142_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp143_ = _tmp142_;
			_photo_size = _tmp143_;
			_photo_index = -1;
			while (TRUE) {
				gint _tmp144_;
				gint _tmp145_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp146_;
				gpointer _tmp147_;
				GeeHashMap* _tmp148_;
				LibraryPhoto* _tmp149_;
				PhotoMonitorReimportEditableJob* job = NULL;
				LibraryPhoto* _tmp150_;
				PhotoMonitorReimportEditableJob* _tmp151_;
				GeeHashMap* _tmp152_;
				LibraryPhoto* _tmp153_;
				PhotoMonitorReimportEditableJob* _tmp154_;
				Workers* _tmp155_;
				PhotoMonitorReimportEditableJob* _tmp156_;
				_photo_index = _photo_index + 1;
				_tmp144_ = _photo_index;
				_tmp145_ = _photo_size;
				if (!(_tmp144_ < _tmp145_)) {
					break;
				}
				_tmp146_ = _photo_list;
				_tmp147_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _photo_index);
				photo = (LibraryPhoto*) _tmp147_;
				_tmp148_ = self->priv->editable_reimport_pending;
				_tmp149_ = photo;
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp149_), "!editable_reimport_pending.has_key(photo)");
				_tmp150_ = photo;
				_tmp151_ = photo_monitor_reimport_editable_job_new (self, _tmp150_);
				job = _tmp151_;
				_tmp152_ = self->priv->editable_reimport_pending;
				_tmp153_ = photo;
				_tmp154_ = job;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp153_, _tmp154_);
				_tmp155_ = self->priv->workers;
				_tmp156_ = job;
				workers_enqueue (_tmp155_, G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, TYPE_BACKGROUND_JOB, BackgroundJob));
				_background_job_unref0 (job);
				_g_object_unref0 (photo);
			}
		}
	}
	_tmp157_ = reimport_raw_developments;
	if (_tmp157_ != NULL) {
		GeeArrayList* _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		gchar* _tmp161_;
		gchar* _tmp162_;
		_tmp158_ = reimport_raw_developments;
		_tmp159_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp160_ = _tmp159_;
		_tmp161_ = g_strdup_printf ("Reimporting %d raw developments", _tmp160_);
		_tmp162_ = _tmp161_;
		media_monitor_mdbg (_tmp162_);
		_g_free0 (_tmp162_);
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp163_;
			gint _photo_size = 0;
			GeeArrayList* _tmp164_;
			gint _tmp165_;
			gint _tmp166_;
			gint _photo_index = 0;
			_tmp163_ = reimport_raw_developments;
			_photo_list = _tmp163_;
			_tmp164_ = _photo_list;
			_tmp165_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp166_ = _tmp165_;
			_photo_size = _tmp166_;
			_photo_index = -1;
			while (TRUE) {
				gint _tmp167_;
				gint _tmp168_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp169_;
				gpointer _tmp170_;
				GeeHashMap* _tmp171_;
				LibraryPhoto* _tmp172_;
				PhotoMonitorReimportRawDevelopmentJob* job = NULL;
				LibraryPhoto* _tmp173_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp174_;
				GeeHashMap* _tmp175_;
				LibraryPhoto* _tmp176_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp177_;
				Workers* _tmp178_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp179_;
				_photo_index = _photo_index + 1;
				_tmp167_ = _photo_index;
				_tmp168_ = _photo_size;
				if (!(_tmp167_ < _tmp168_)) {
					break;
				}
				_tmp169_ = _photo_list;
				_tmp170_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _photo_index);
				photo = (LibraryPhoto*) _tmp170_;
				_tmp171_ = self->priv->raw_developments_reimport_pending;
				_tmp172_ = photo;
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp171_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp172_), "!raw_developments_reimport_pending.has_key(photo)");
				_tmp173_ = photo;
				_tmp174_ = photo_monitor_reimport_raw_development_job_new (self, _tmp173_);
				job = _tmp174_;
				_tmp175_ = self->priv->raw_developments_reimport_pending;
				_tmp176_ = photo;
				_tmp177_ = job;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp175_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp176_, _tmp177_);
				_tmp178_ = self->priv->workers;
				_tmp179_ = job;
				workers_enqueue (_tmp178_, G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, TYPE_BACKGROUND_JOB, BackgroundJob));
				_background_job_unref0 (job);
				_g_object_unref0 (photo);
			}
		}
	}
	_g_object_unref0 (reimport_raw_developments);
	_g_object_unref0 (reimport_editable);
	_g_object_unref0 (reimport_master);
	_g_object_unref0 (revert_to_master);
	_g_object_unref0 (set_raw_developer_files);
	_g_object_unref0 (set_editable_file_info);
	_g_object_unref0 (set_editable_file);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
photo_monitor_on_master_reimported (PhotoMonitor* self,
                                    BackgroundJob* j)
{
	PhotoMonitorReimportMasterJob* job = NULL;
	PhotoMonitorReimportMasterJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportMasterJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	PhotoMonitorReimportMasterJob* _tmp4_;
	GError* _tmp5_;
	PhotoMonitorReimportMasterJob* _tmp15_;
	PhotoMonitorReimportMasterJob* _tmp23_;
	LibraryPhoto* _tmp24_;
	PhotoMonitorReimportMasterJob* _tmp27_;
	LibraryPhoto* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob));
	job = _tmp0_;
	_tmp1_ = self->priv->master_reimport_pending;
	_tmp2_ = job;
	_tmp3_ = _tmp2_->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
	_vala_assert (removed, "removed");
	_tmp4_ = job;
	_tmp5_ = _tmp4_->err;
	if (_tmp5_ != NULL) {
		PhotoMonitorReimportMasterJob* _tmp6_;
		LibraryPhoto* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		PhotoMonitorReimportMasterJob* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		PhotoMonitorReimportMasterJob* _tmp13_;
		LibraryPhoto* _tmp14_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->photo;
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
		_tmp9_ = _tmp8_;
		_tmp10_ = job;
		_tmp11_ = _tmp10_->err;
		_tmp12_ = _tmp11_->message;
		g_critical ("PhotoMonitor.vala:1069: Unable to reimport %s due to master file chang" \
"ing: %s", _tmp9_, _tmp12_);
		_g_free0 (_tmp9_);
		_tmp13_ = job;
		_tmp14_ = _tmp13_->photo;
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_MONITORABLE, Monitorable));
		_background_job_unref0 (job);
		return;
	}
	_tmp15_ = job;
	if (!_tmp15_->mark_online) {
		PhotoMonitorReimportMasterJob* _tmp16_;
		LibraryPhoto* _tmp17_;
		_tmp16_ = job;
		_tmp17_ = _tmp16_->photo;
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE, Monitorable));
		_background_job_unref0 (job);
		return;
	}
	{
		PhotoMonitorReimportMasterJob* _tmp18_;
		LibraryPhoto* _tmp19_;
		PhotoMonitorReimportMasterJob* _tmp20_;
		PhotoReimportMasterState* _tmp21_;
		_tmp18_ = job;
		_tmp19_ = _tmp18_->photo;
		_tmp20_ = job;
		_tmp21_ = _tmp20_->reimport_state;
		photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO, Photo), _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_background_job_unref0 (job);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp22_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = err;
		app_window_database_error (_tmp22_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_background_job_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp23_ = job;
	_tmp24_ = _tmp23_->photo;
	if (media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_SOURCE, MediaSource))) {
		PhotoMonitorReimportMasterJob* _tmp25_;
		LibraryPhoto* _tmp26_;
		_tmp25_ = job;
		_tmp26_ = _tmp25_->photo;
		media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MONITORABLE, Monitorable));
	}
	_tmp27_ = job;
	_tmp28_ = _tmp27_->photo;
	_tmp29_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_DATA_OBJECT, DataObject));
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup_printf ("Reimported master for %s", _tmp30_);
	_tmp32_ = _tmp31_;
	media_monitor_mdbg (_tmp32_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_background_job_unref0 (job);
}

static void
photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self,
                                            BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = self->priv->master_reimport_pending;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob)->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
	_vala_assert (removed, "removed");
}

static void
photo_monitor_on_editable_reimported (PhotoMonitor* self,
                                      BackgroundJob* j)
{
	PhotoMonitorReimportEditableJob* job = NULL;
	PhotoMonitorReimportEditableJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportEditableJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	PhotoMonitorReimportEditableJob* _tmp4_;
	GError* _tmp5_;
	PhotoMonitorReimportEditableJob* _tmp18_;
	LibraryPhoto* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob));
	job = _tmp0_;
	_tmp1_ = self->priv->editable_reimport_pending;
	_tmp2_ = job;
	_tmp3_ = _tmp2_->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
	_vala_assert (removed, "removed");
	_tmp4_ = job;
	_tmp5_ = _tmp4_->err;
	if (_tmp5_ != NULL) {
		PhotoMonitorReimportEditableJob* _tmp6_;
		LibraryPhoto* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		PhotoMonitorReimportEditableJob* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->photo;
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
		_tmp9_ = _tmp8_;
		_tmp10_ = job;
		_tmp11_ = _tmp10_->err;
		_tmp12_ = _tmp11_->message;
		g_critical ("PhotoMonitor.vala:1110: Unable to reimport editable %s: %s", _tmp9_, _tmp12_);
		_g_free0 (_tmp9_);
		_background_job_unref0 (job);
		return;
	}
	{
		PhotoMonitorReimportEditableJob* _tmp13_;
		LibraryPhoto* _tmp14_;
		PhotoMonitorReimportEditableJob* _tmp15_;
		PhotoReimportEditableState* _tmp16_;
		_tmp13_ = job;
		_tmp14_ = _tmp13_->photo;
		_tmp15_ = job;
		_tmp16_ = _tmp15_->state;
		photo_finish_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo), _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_background_job_unref0 (job);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = err;
		app_window_database_error (_tmp17_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_background_job_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = job;
	_tmp19_ = _tmp18_->photo;
	_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("Reimported editable for %s", _tmp21_);
	_tmp23_ = _tmp22_;
	media_monitor_mdbg (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_background_job_unref0 (job);
}

static void
photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self,
                                              BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = self->priv->editable_reimport_pending;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob)->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
	_vala_assert (removed, "removed");
}

static void
photo_monitor_on_raw_development_reimported (PhotoMonitor* self,
                                             BackgroundJob* j)
{
	PhotoMonitorReimportRawDevelopmentJob* job = NULL;
	PhotoMonitorReimportRawDevelopmentJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp4_;
	GError* _tmp5_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp18_;
	LibraryPhoto* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob));
	job = _tmp0_;
	_tmp1_ = self->priv->raw_developments_reimport_pending;
	_tmp2_ = job;
	_tmp3_ = _tmp2_->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
	_vala_assert (removed, "removed");
	_tmp4_ = job;
	_tmp5_ = _tmp4_->err;
	if (_tmp5_ != NULL) {
		PhotoMonitorReimportRawDevelopmentJob* _tmp6_;
		LibraryPhoto* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->photo;
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
		_tmp9_ = _tmp8_;
		_tmp10_ = job;
		_tmp11_ = _tmp10_->err;
		_tmp12_ = _tmp11_->message;
		g_critical ("PhotoMonitor.vala:1137: Unable to reimport raw development %s: %s", _tmp9_, _tmp12_);
		_g_free0 (_tmp9_);
		_background_job_unref0 (job);
		return;
	}
	{
		PhotoMonitorReimportRawDevelopmentJob* _tmp13_;
		LibraryPhoto* _tmp14_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp15_;
		PhotoReimportRawDevelopmentState* _tmp16_;
		_tmp13_ = job;
		_tmp14_ = _tmp13_->photo;
		_tmp15_ = job;
		_tmp16_ = _tmp15_->state;
		photo_finish_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo), _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_background_job_unref0 (job);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = err;
		app_window_database_error (_tmp17_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_background_job_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = job;
	_tmp19_ = _tmp18_->photo;
	_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("Reimported raw development for %s", _tmp21_);
	_tmp23_ = _tmp22_;
	media_monitor_mdbg (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_background_job_unref0 (job);
}

static void
photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self,
                                                     BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	g_return_if_fail (IS_PHOTO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = self->priv->raw_developments_reimport_pending;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob)->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
	_vala_assert (removed, "removed");
}

static void
_photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job,
                                                         gpointer self)
{
	photo_monitor_on_master_reimported ((PhotoMonitor*) self, job);
}

static void
_photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                   gpointer self)
{
	photo_monitor_on_master_reimport_cancelled ((PhotoMonitor*) self, job);
}

static PhotoMonitorReimportMasterJob*
photo_monitor_reimport_master_job_construct (GType object_type,
                                             PhotoMonitor* owner,
                                             LibraryPhoto* photo)
{
	PhotoMonitorReimportMasterJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	self = (PhotoMonitorReimportMasterJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_master_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_master_reimport_cancelled_cancellation_callback, owner, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp2_;
	return self;
}

static PhotoMonitorReimportMasterJob*
photo_monitor_reimport_master_job_new (PhotoMonitor* owner,
                                       LibraryPhoto* photo)
{
	return photo_monitor_reimport_master_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, owner, photo);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
photo_monitor_reimport_master_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportMasterJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportMasterState* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp1_ = self->photo;
		_tmp3_ = photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error0_);
		_photo_reimport_master_state_unref0 (self->reimport_state);
		self->reimport_state = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->mark_online = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (self->err);
		self->err = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_monitor_reimport_master_job_class_init (PhotoMonitorReimportMasterJobClass * klass,
                                              gpointer klass_data)
{
	photo_monitor_reimport_master_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_master_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) photo_monitor_reimport_master_job_real_execute;
}

static void
photo_monitor_reimport_master_job_instance_init (PhotoMonitorReimportMasterJob * self,
                                                 gpointer klass)
{
	self->reimport_state = NULL;
	self->mark_online = FALSE;
	self->err = NULL;
}

static void
photo_monitor_reimport_master_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportMasterJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
	_g_object_unref0 (self->photo);
	_photo_reimport_master_state_unref0 (self->reimport_state);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_master_job_parent_class)->finalize (obj);
}

static GType
photo_monitor_reimport_master_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportMasterJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_master_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportMasterJob), 0, (GInstanceInitFunc) photo_monitor_reimport_master_job_instance_init, NULL };
	GType photo_monitor_reimport_master_job_type_id;
	photo_monitor_reimport_master_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportMasterJob", &g_define_type_info, 0);
	return photo_monitor_reimport_master_job_type_id;
}

static GType
photo_monitor_reimport_master_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_master_job_type_id__once = 0;
	if (g_once_init_enter (&photo_monitor_reimport_master_job_type_id__once)) {
		GType photo_monitor_reimport_master_job_type_id;
		photo_monitor_reimport_master_job_type_id = photo_monitor_reimport_master_job_get_type_once ();
		g_once_init_leave (&photo_monitor_reimport_master_job_type_id__once, photo_monitor_reimport_master_job_type_id);
	}
	return photo_monitor_reimport_master_job_type_id__once;
}

static void
_photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job,
                                                           gpointer self)
{
	photo_monitor_on_editable_reimported ((PhotoMonitor*) self, job);
}

static void
_photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                     gpointer self)
{
	photo_monitor_on_editable_reimport_cancelled ((PhotoMonitor*) self, job);
}

static PhotoMonitorReimportEditableJob*
photo_monitor_reimport_editable_job_construct (GType object_type,
                                               PhotoMonitor* owner,
                                               LibraryPhoto* photo)
{
	PhotoMonitorReimportEditableJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	self = (PhotoMonitorReimportEditableJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_editable_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_editable_reimport_cancelled_cancellation_callback, owner, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp2_;
	return self;
}

static PhotoMonitorReimportEditableJob*
photo_monitor_reimport_editable_job_new (PhotoMonitor* owner,
                                         LibraryPhoto* photo)
{
	return photo_monitor_reimport_editable_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, owner, photo);
}

static void
photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportEditableJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportEditableState* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp1_ = self->photo;
		_tmp3_ = photo_prepare_for_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error0_);
		_photo_reimport_editable_state_unref0 (self->state);
		self->state = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->success = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (self->err);
		self->err = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_monitor_reimport_editable_job_class_init (PhotoMonitorReimportEditableJobClass * klass,
                                                gpointer klass_data)
{
	photo_monitor_reimport_editable_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_editable_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) photo_monitor_reimport_editable_job_real_execute;
}

static void
photo_monitor_reimport_editable_job_instance_init (PhotoMonitorReimportEditableJob * self,
                                                   gpointer klass)
{
	self->state = NULL;
	self->success = FALSE;
	self->err = NULL;
}

static void
photo_monitor_reimport_editable_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportEditableJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
	_g_object_unref0 (self->photo);
	_photo_reimport_editable_state_unref0 (self->state);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_editable_job_parent_class)->finalize (obj);
}

static GType
photo_monitor_reimport_editable_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportEditableJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_editable_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportEditableJob), 0, (GInstanceInitFunc) photo_monitor_reimport_editable_job_instance_init, NULL };
	GType photo_monitor_reimport_editable_job_type_id;
	photo_monitor_reimport_editable_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportEditableJob", &g_define_type_info, 0);
	return photo_monitor_reimport_editable_job_type_id;
}

static GType
photo_monitor_reimport_editable_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_editable_job_type_id__once = 0;
	if (g_once_init_enter (&photo_monitor_reimport_editable_job_type_id__once)) {
		GType photo_monitor_reimport_editable_job_type_id;
		photo_monitor_reimport_editable_job_type_id = photo_monitor_reimport_editable_job_get_type_once ();
		g_once_init_leave (&photo_monitor_reimport_editable_job_type_id__once, photo_monitor_reimport_editable_job_type_id);
	}
	return photo_monitor_reimport_editable_job_type_id__once;
}

static void
_photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job,
                                                                  gpointer self)
{
	photo_monitor_on_raw_development_reimported ((PhotoMonitor*) self, job);
}

static void
_photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                            gpointer self)
{
	photo_monitor_on_raw_development_reimport_cancelled ((PhotoMonitor*) self, job);
}

static PhotoMonitorReimportRawDevelopmentJob*
photo_monitor_reimport_raw_development_job_construct (GType object_type,
                                                      PhotoMonitor* owner,
                                                      LibraryPhoto* photo)
{
	PhotoMonitorReimportRawDevelopmentJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	self = (PhotoMonitorReimportRawDevelopmentJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_raw_development_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback, owner, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp2_;
	return self;
}

static PhotoMonitorReimportRawDevelopmentJob*
photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner,
                                                LibraryPhoto* photo)
{
	return photo_monitor_reimport_raw_development_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, owner, photo);
}

static void
photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportRawDevelopmentJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportRawDevelopmentState* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp1_ = self->photo;
		_tmp3_ = photo_prepare_for_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error0_);
		_photo_reimport_raw_development_state_unref0 (self->state);
		self->state = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->success = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (self->err);
		self->err = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_monitor_reimport_raw_development_job_class_init (PhotoMonitorReimportRawDevelopmentJobClass * klass,
                                                       gpointer klass_data)
{
	photo_monitor_reimport_raw_development_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_raw_development_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) photo_monitor_reimport_raw_development_job_real_execute;
}

static void
photo_monitor_reimport_raw_development_job_instance_init (PhotoMonitorReimportRawDevelopmentJob * self,
                                                          gpointer klass)
{
	self->state = NULL;
	self->success = FALSE;
	self->err = NULL;
}

static void
photo_monitor_reimport_raw_development_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportRawDevelopmentJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
	_g_object_unref0 (self->photo);
	_photo_reimport_raw_development_state_unref0 (self->state);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_raw_development_job_parent_class)->finalize (obj);
}

static GType
photo_monitor_reimport_raw_development_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportRawDevelopmentJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_raw_development_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportRawDevelopmentJob), 0, (GInstanceInitFunc) photo_monitor_reimport_raw_development_job_instance_init, NULL };
	GType photo_monitor_reimport_raw_development_job_type_id;
	photo_monitor_reimport_raw_development_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportRawDevelopmentJob", &g_define_type_info, 0);
	return photo_monitor_reimport_raw_development_job_type_id;
}

static GType
photo_monitor_reimport_raw_development_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_raw_development_job_type_id__once = 0;
	if (g_once_init_enter (&photo_monitor_reimport_raw_development_job_type_id__once)) {
		GType photo_monitor_reimport_raw_development_job_type_id;
		photo_monitor_reimport_raw_development_job_type_id = photo_monitor_reimport_raw_development_job_get_type_once ();
		g_once_init_leave (&photo_monitor_reimport_raw_development_job_type_id__once, photo_monitor_reimport_raw_development_job_type_id);
	}
	return photo_monitor_reimport_raw_development_job_type_id__once;
}

static void
photo_monitor_class_init (PhotoMonitorClass * klass,
                          gpointer klass_data)
{
	photo_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoMonitor_private_offset);
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor*, Monitorable*)) photo_monitor_real_create_updates;
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor*)) photo_monitor_real_get_media_source_collection;
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor*, GFile*)) photo_monitor_real_is_file_represented;
	((MediaMonitorClass *) klass)->close = (void (*) (MediaMonitor*)) photo_monitor_real_close;
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor*, GFile*, GFileInfo*, Monitorable**)) photo_monitor_real_notify_file_discovered;
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor*, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) photo_monitor_real_candidates_for_unknown_file;
	((MediaMonitorClass *) klass)->get_auxilliary_backing_files = (GFile** (*) (MediaMonitor*, Monitorable*, gint*)) photo_monitor_real_get_auxilliary_backing_files;
	((MediaMonitorClass *) klass)->update_backing_file_info = (void (*) (MediaMonitor*, Monitorable*, GFile*, GFileInfo*)) photo_monitor_real_update_backing_file_info;
	((MediaMonitorClass *) klass)->notify_discovery_completing = (void (*) (MediaMonitor*)) photo_monitor_real_notify_discovery_completing;
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) photo_monitor_real_notify_file_created;
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor*, GFile*, GFile*, GFileInfo*)) photo_monitor_real_notify_file_moved;
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor*, GFile*)) photo_monitor_real_notify_file_altered;
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor*, GFile*)) photo_monitor_real_notify_file_attributes_altered;
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) photo_monitor_real_notify_file_alteration_completed;
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor*, GFile*)) photo_monitor_real_notify_file_deleted;
	((MediaMonitorClass *) klass)->on_media_source_destroyed = (void (*) (MediaMonitor*, DataSource*)) photo_monitor_real_on_media_source_destroyed;
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor*, GeeCollection*, TransactionController*, gint*, GError**)) photo_monitor_real_process_updates;
	G_OBJECT_CLASS (klass)->finalize = photo_monitor_finalize;
}

static void
photo_monitor_instance_init (PhotoMonitor * self,
                             gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	self->priv = photo_monitor_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->matched_editables = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->matched_developments = _tmp1_;
	_tmp2_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->master_reimport_pending = _tmp2_;
	_tmp3_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->editable_reimport_pending = _tmp3_;
	_tmp4_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->raw_developments_reimport_pending = _tmp4_;
}

static void
photo_monitor_finalize (GObject * obj)
{
	PhotoMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_MONITOR, PhotoMonitor);
	_workers_unref0 (self->priv->workers);
	_g_object_unref0 (self->priv->matched_editables);
	_g_object_unref0 (self->priv->matched_developments);
	_g_object_unref0 (self->priv->master_reimport_pending);
	_g_object_unref0 (self->priv->editable_reimport_pending);
	_g_object_unref0 (self->priv->raw_developments_reimport_pending);
	G_OBJECT_CLASS (photo_monitor_parent_class)->finalize (obj);
}

static GType
photo_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitor), 0, (GInstanceInitFunc) photo_monitor_instance_init, NULL };
	GType photo_monitor_type_id;
	photo_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "PhotoMonitor", &g_define_type_info, 0);
	PhotoMonitor_private_offset = g_type_add_instance_private (photo_monitor_type_id, sizeof (PhotoMonitorPrivate));
	return photo_monitor_type_id;
}

GType
photo_monitor_get_type (void)
{
	static volatile gsize photo_monitor_type_id__once = 0;
	if (g_once_init_enter (&photo_monitor_type_id__once)) {
		GType photo_monitor_type_id;
		photo_monitor_type_id = photo_monitor_get_type_once ();
		g_once_init_leave (&photo_monitor_type_id__once, photo_monitor_type_id);
	}
	return photo_monitor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

