/* Orientation.c generated by valac 0.56.17, the Vala compiler
 * generated from Orientation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* orientation_to_string (Orientation self);
VALA_EXTERN Orientation orientation_rotate_clockwise (Orientation self);
VALA_EXTERN Orientation orientation_rotate_counterclockwise (Orientation self);
VALA_EXTERN Orientation orientation_flip_top_to_bottom (Orientation self);
VALA_EXTERN Orientation orientation_flip_left_to_right (Orientation self);
VALA_EXTERN GType rotation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Orientation orientation_perform (Orientation self,
                                 Rotation rotation);
VALA_EXTERN Rotation* orientation_to_rotations (Orientation self,
                                    gint* result_length1);
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN void orientation_derotate_dimensions (Orientation self,
                                      Dimensions* dim,
                                      Dimensions* result);
VALA_EXTERN GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
VALA_EXTERN void orientation_rotate_point (Orientation self,
                               Dimensions* space,
                               GdkPoint* point,
                               GdkPoint* result);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
VALA_EXTERN void orientation_derotate_point (Orientation self,
                                 Dimensions* space,
                                 GdkPoint* point,
                                 GdkPoint* result);
VALA_EXTERN GType box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Box* box_dup (const Box* self);
VALA_EXTERN void box_free (Box* self);
VALA_EXTERN void orientation_rotate_box (Orientation self,
                             Dimensions* space,
                             Box* box,
                             Box* result);
VALA_EXTERN void box_get_points (Box *self,
                     GdkPoint* top_left,
                     GdkPoint* bottom_right);
VALA_EXTERN void box_from_points (GdkPoint* corner1,
                      GdkPoint* corner2,
                      Box* result);
VALA_EXTERN void orientation_derotate_box (Orientation self,
                               Dimensions* space,
                               Box* box,
                               Box* result);
VALA_EXTERN GdkPixbuf* rotation_perform (Rotation self,
                             GdkPixbuf* pixbuf);
VALA_EXTERN Rotation rotation_opposite (Rotation self);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
orientation_to_string (Orientation self)
{
	gchar* result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("top-left");
			result = _tmp0_;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("top-right");
			result = _tmp1_;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("bottom-right");
			result = _tmp2_;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("bottom-left");
			result = _tmp3_;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("left-top");
			result = _tmp4_;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("right-top");
			result = _tmp5_;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("right-bottom");
			result = _tmp6_;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("left-bottom");
			result = _tmp7_;
			return result;
		}
		default:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup_printf ("unknown orientation %d", (gint) self);
			result = _tmp8_;
			return result;
		}
	}
}

Orientation
orientation_rotate_clockwise (Orientation self)
{
	Orientation result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			result = ORIENTATION_RIGHT_TOP;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			result = ORIENTATION_RIGHT_BOTTOM;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			result = ORIENTATION_LEFT_BOTTOM;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			result = ORIENTATION_LEFT_TOP;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			result = ORIENTATION_TOP_RIGHT;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			result = ORIENTATION_BOTTOM_RIGHT;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			result = ORIENTATION_BOTTOM_LEFT;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			result = ORIENTATION_TOP_LEFT;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:77: rotate_clockwise: %d", (gint) self);
		}
	}
}

Orientation
orientation_rotate_counterclockwise (Orientation self)
{
	Orientation result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			result = ORIENTATION_LEFT_BOTTOM;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			result = ORIENTATION_LEFT_TOP;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			result = ORIENTATION_RIGHT_TOP;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			result = ORIENTATION_RIGHT_BOTTOM;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			result = ORIENTATION_BOTTOM_LEFT;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			result = ORIENTATION_TOP_LEFT;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			result = ORIENTATION_TOP_RIGHT;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			result = ORIENTATION_BOTTOM_RIGHT;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:108: rotate_counterclockwise: %d", (gint) self);
		}
	}
}

Orientation
orientation_flip_top_to_bottom (Orientation self)
{
	Orientation result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			result = ORIENTATION_BOTTOM_LEFT;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			result = ORIENTATION_BOTTOM_RIGHT;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			result = ORIENTATION_TOP_RIGHT;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			result = ORIENTATION_TOP_LEFT;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			result = ORIENTATION_LEFT_BOTTOM;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			result = ORIENTATION_RIGHT_BOTTOM;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			result = ORIENTATION_RIGHT_TOP;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			result = ORIENTATION_LEFT_TOP;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:139: flip_top_to_bottom: %d", (gint) self);
		}
	}
}

Orientation
orientation_flip_left_to_right (Orientation self)
{
	Orientation result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			result = ORIENTATION_TOP_RIGHT;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			result = ORIENTATION_TOP_LEFT;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			result = ORIENTATION_BOTTOM_LEFT;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			result = ORIENTATION_BOTTOM_RIGHT;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			result = ORIENTATION_RIGHT_TOP;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			result = ORIENTATION_LEFT_TOP;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			result = ORIENTATION_LEFT_BOTTOM;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			result = ORIENTATION_RIGHT_BOTTOM;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:170: flip_left_to_right: %d", (gint) self);
		}
	}
}

Orientation
orientation_perform (Orientation self,
                     Rotation rotation)
{
	Orientation result;
	switch (rotation) {
		case ROTATION_CLOCKWISE:
		{
			result = orientation_rotate_clockwise (self);
			return result;
		}
		case ROTATION_COUNTERCLOCKWISE:
		{
			result = orientation_rotate_counterclockwise (self);
			return result;
		}
		case ROTATION_MIRROR:
		{
			result = orientation_flip_left_to_right (self);
			return result;
		}
		case ROTATION_UPSIDE_DOWN:
		{
			result = orientation_flip_top_to_bottom (self);
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:189: perform: %d", (gint) rotation);
		}
	}
}

Rotation*
orientation_to_rotations (Orientation self,
                          gint* result_length1)
{
	Rotation* result;
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			Rotation* _tmp0_;
			Rotation* _tmp1_;
			gint _tmp1__length1;
			_tmp0_ = g_new0 (Rotation, 0);
			_tmp1_ = _tmp0_;
			_tmp1__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp1__length1;
			}
			result = _tmp1_;
			return result;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			Rotation* _tmp2_;
			Rotation* _tmp3_;
			gint _tmp3__length1;
			_tmp2_ = g_new0 (Rotation, 1);
			_tmp2_[0] = ROTATION_MIRROR;
			_tmp3_ = _tmp2_;
			_tmp3__length1 = 1;
			if (result_length1) {
				*result_length1 = _tmp3__length1;
			}
			result = _tmp3_;
			return result;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			Rotation* _tmp4_;
			Rotation* _tmp5_;
			gint _tmp5__length1;
			_tmp4_ = g_new0 (Rotation, 1);
			_tmp4_[0] = ROTATION_UPSIDE_DOWN;
			_tmp5_ = _tmp4_;
			_tmp5__length1 = 1;
			if (result_length1) {
				*result_length1 = _tmp5__length1;
			}
			result = _tmp5_;
			return result;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			Rotation* _tmp6_;
			Rotation* _tmp7_;
			gint _tmp7__length1;
			_tmp6_ = g_new0 (Rotation, 2);
			_tmp6_[0] = ROTATION_MIRROR;
			_tmp6_[1] = ROTATION_UPSIDE_DOWN;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 2;
			if (result_length1) {
				*result_length1 = _tmp7__length1;
			}
			result = _tmp7_;
			return result;
		}
		case ORIENTATION_LEFT_TOP:
		{
			Rotation* _tmp8_;
			Rotation* _tmp9_;
			gint _tmp9__length1;
			_tmp8_ = g_new0 (Rotation, 2);
			_tmp8_[0] = ROTATION_COUNTERCLOCKWISE;
			_tmp8_[1] = ROTATION_UPSIDE_DOWN;
			_tmp9_ = _tmp8_;
			_tmp9__length1 = 2;
			if (result_length1) {
				*result_length1 = _tmp9__length1;
			}
			result = _tmp9_;
			return result;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			Rotation* _tmp10_;
			Rotation* _tmp11_;
			gint _tmp11__length1;
			_tmp10_ = g_new0 (Rotation, 1);
			_tmp10_[0] = ROTATION_CLOCKWISE;
			_tmp11_ = _tmp10_;
			_tmp11__length1 = 1;
			if (result_length1) {
				*result_length1 = _tmp11__length1;
			}
			result = _tmp11_;
			return result;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			Rotation* _tmp12_;
			Rotation* _tmp13_;
			gint _tmp13__length1;
			_tmp12_ = g_new0 (Rotation, 2);
			_tmp12_[0] = ROTATION_CLOCKWISE;
			_tmp12_[1] = ROTATION_UPSIDE_DOWN;
			_tmp13_ = _tmp12_;
			_tmp13__length1 = 2;
			if (result_length1) {
				*result_length1 = _tmp13__length1;
			}
			result = _tmp13_;
			return result;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			Rotation* _tmp14_;
			Rotation* _tmp15_;
			gint _tmp15__length1;
			_tmp14_ = g_new0 (Rotation, 1);
			_tmp14_[0] = ROTATION_COUNTERCLOCKWISE;
			_tmp15_ = _tmp14_;
			_tmp15__length1 = 1;
			if (result_length1) {
				*result_length1 = _tmp15__length1;
			}
			result = _tmp15_;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:222: to_rotations: %d", (gint) self);
		}
	}
}

void
orientation_rotate_dimensions (Orientation self,
                               Dimensions* dim,
                               Dimensions* result)
{
	g_return_if_fail (dim != NULL);
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		case ORIENTATION_TOP_RIGHT:
		case ORIENTATION_BOTTOM_RIGHT:
		case ORIENTATION_BOTTOM_LEFT:
		{
			Dimensions _tmp0_;
			_tmp0_ = *dim;
			*result = _tmp0_;
			return;
		}
		case ORIENTATION_LEFT_TOP:
		case ORIENTATION_RIGHT_TOP:
		case ORIENTATION_RIGHT_BOTTOM:
		case ORIENTATION_LEFT_BOTTOM:
		{
			Dimensions _tmp1_;
			Dimensions _tmp2_;
			Dimensions _tmp3_ = {0};
			_tmp1_ = *dim;
			_tmp2_ = *dim;
			dimensions_init (&_tmp3_, _tmp1_.height, _tmp2_.width);
			*result = _tmp3_;
			return;
		}
		default:
		{
			g_error ("Orientation.vala:243: rotate_dimensions: %d", (gint) self);
		}
	}
}

void
orientation_derotate_dimensions (Orientation self,
                                 Dimensions* dim,
                                 Dimensions* result)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_ = {0};
	g_return_if_fail (dim != NULL);
	_tmp0_ = *dim;
	orientation_rotate_dimensions (self, &_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
orientation_rotate_pixbuf (Orientation self,
                           GdkPixbuf* pixbuf)
{
	GdkPixbuf* rotated = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			GdkPixbuf* _tmp0_;
			_tmp0_ = _g_object_ref0 (pixbuf);
			_g_object_unref0 (rotated);
			rotated = _tmp0_;
			break;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			GdkPixbuf* _tmp1_;
			_tmp1_ = gdk_pixbuf_flip (pixbuf, TRUE);
			_g_object_unref0 (rotated);
			rotated = _tmp1_;
			break;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			GdkPixbuf* _tmp2_;
			_tmp2_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
			_g_object_unref0 (rotated);
			rotated = _tmp2_;
			break;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			GdkPixbuf* _tmp3_;
			_tmp3_ = gdk_pixbuf_flip (pixbuf, FALSE);
			_g_object_unref0 (rotated);
			rotated = _tmp3_;
			break;
		}
		case ORIENTATION_LEFT_TOP:
		{
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			_tmp4_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
			_tmp5_ = _tmp4_;
			_tmp6_ = gdk_pixbuf_flip (_tmp5_, FALSE);
			_g_object_unref0 (rotated);
			rotated = _tmp6_;
			_g_object_unref0 (_tmp5_);
			break;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			GdkPixbuf* _tmp7_;
			_tmp7_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
			_g_object_unref0 (rotated);
			rotated = _tmp7_;
			break;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp8_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
			_tmp9_ = _tmp8_;
			_tmp10_ = gdk_pixbuf_flip (_tmp9_, FALSE);
			_g_object_unref0 (rotated);
			rotated = _tmp10_;
			_g_object_unref0 (_tmp9_);
			break;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			GdkPixbuf* _tmp11_;
			_tmp11_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
			_g_object_unref0 (rotated);
			rotated = _tmp11_;
			break;
		}
		default:
		{
			g_error ("Orientation.vala:290: rotate_pixbuf: %d", (gint) self);
		}
	}
	result = rotated;
	return result;
}

void
orientation_rotate_point (Orientation self,
                          Dimensions* space,
                          GdkPoint* point,
                          GdkPoint* result)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	Dimensions _tmp2_;
	GdkPoint _tmp3_;
	GdkPoint _tmp4_;
	Dimensions _tmp5_;
	GdkPoint rotated = {0};
	g_return_if_fail (space != NULL);
	g_return_if_fail (point != NULL);
	_vala_assert (dimensions_has_area (space), "space.has_area()");
	_tmp0_ = *point;
	_vala_assert (_tmp0_.x >= 0, "point.x >= 0");
	_tmp1_ = *point;
	_tmp2_ = *space;
	_vala_assert (_tmp1_.x < _tmp2_.width, "point.x < space.width");
	_tmp3_ = *point;
	_vala_assert (_tmp3_.y >= 0, "point.y >= 0");
	_tmp4_ = *point;
	_tmp5_ = *space;
	_vala_assert (_tmp4_.y < _tmp5_.height, "point.y < space.height");
	memset (&rotated, 0, sizeof (GdkPoint));
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			GdkPoint _tmp6_;
			_tmp6_ = *point;
			rotated = _tmp6_;
			break;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			Dimensions _tmp7_;
			GdkPoint _tmp8_;
			GdkPoint _tmp9_;
			_tmp7_ = *space;
			_tmp8_ = *point;
			rotated.x = (_tmp7_.width - _tmp8_.x) - 1;
			_tmp9_ = *point;
			rotated.y = _tmp9_.y;
			break;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			Dimensions _tmp10_;
			GdkPoint _tmp11_;
			Dimensions _tmp12_;
			GdkPoint _tmp13_;
			_tmp10_ = *space;
			_tmp11_ = *point;
			rotated.x = (_tmp10_.width - _tmp11_.x) - 1;
			_tmp12_ = *space;
			_tmp13_ = *point;
			rotated.y = (_tmp12_.height - _tmp13_.y) - 1;
			break;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			GdkPoint _tmp14_;
			Dimensions _tmp15_;
			GdkPoint _tmp16_;
			_tmp14_ = *point;
			rotated.x = _tmp14_.x;
			_tmp15_ = *space;
			_tmp16_ = *point;
			rotated.y = (_tmp15_.height - _tmp16_.y) - 1;
			break;
		}
		case ORIENTATION_LEFT_TOP:
		{
			GdkPoint _tmp17_;
			GdkPoint _tmp18_;
			_tmp17_ = *point;
			rotated.x = _tmp17_.y;
			_tmp18_ = *point;
			rotated.y = _tmp18_.x;
			break;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			Dimensions _tmp19_;
			GdkPoint _tmp20_;
			GdkPoint _tmp21_;
			_tmp19_ = *space;
			_tmp20_ = *point;
			rotated.x = (_tmp19_.height - _tmp20_.y) - 1;
			_tmp21_ = *point;
			rotated.y = _tmp21_.x;
			break;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			Dimensions _tmp22_;
			GdkPoint _tmp23_;
			Dimensions _tmp24_;
			GdkPoint _tmp25_;
			_tmp22_ = *space;
			_tmp23_ = *point;
			rotated.x = (_tmp22_.height - _tmp23_.y) - 1;
			_tmp24_ = *space;
			_tmp25_ = *point;
			rotated.y = (_tmp24_.width - _tmp25_.x) - 1;
			break;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			GdkPoint _tmp26_;
			Dimensions _tmp27_;
			GdkPoint _tmp28_;
			_tmp26_ = *point;
			rotated.x = _tmp26_.y;
			_tmp27_ = *space;
			_tmp28_ = *point;
			rotated.y = (_tmp27_.width - _tmp28_.x) - 1;
			break;
		}
		default:
		{
			g_error ("Orientation.vala:355: rotate_point: %d", (gint) self);
		}
	}
	*result = rotated;
	return;
}

void
orientation_derotate_point (Orientation self,
                            Dimensions* space,
                            GdkPoint* point,
                            GdkPoint* result)
{
	GdkPoint derotated = {0};
	g_return_if_fail (space != NULL);
	g_return_if_fail (point != NULL);
	_vala_assert (dimensions_has_area (space), "space.has_area()");
	memset (&derotated, 0, sizeof (GdkPoint));
	switch (self) {
		case ORIENTATION_TOP_LEFT:
		{
			GdkPoint _tmp0_;
			_tmp0_ = *point;
			derotated = _tmp0_;
			break;
		}
		case ORIENTATION_TOP_RIGHT:
		{
			Dimensions _tmp1_;
			GdkPoint _tmp2_;
			GdkPoint _tmp3_;
			_tmp1_ = *space;
			_tmp2_ = *point;
			derotated.x = (_tmp1_.width - _tmp2_.x) - 1;
			_tmp3_ = *point;
			derotated.y = _tmp3_.y;
			break;
		}
		case ORIENTATION_BOTTOM_RIGHT:
		{
			Dimensions _tmp4_;
			GdkPoint _tmp5_;
			Dimensions _tmp6_;
			GdkPoint _tmp7_;
			_tmp4_ = *space;
			_tmp5_ = *point;
			derotated.x = (_tmp4_.width - _tmp5_.x) - 1;
			_tmp6_ = *space;
			_tmp7_ = *point;
			derotated.y = (_tmp6_.height - _tmp7_.y) - 1;
			break;
		}
		case ORIENTATION_BOTTOM_LEFT:
		{
			GdkPoint _tmp8_;
			Dimensions _tmp9_;
			GdkPoint _tmp10_;
			_tmp8_ = *point;
			derotated.x = _tmp8_.x;
			_tmp9_ = *space;
			_tmp10_ = *point;
			derotated.y = (_tmp9_.height - _tmp10_.y) - 1;
			break;
		}
		case ORIENTATION_LEFT_TOP:
		{
			GdkPoint _tmp11_;
			GdkPoint _tmp12_;
			_tmp11_ = *point;
			derotated.x = _tmp11_.y;
			_tmp12_ = *point;
			derotated.y = _tmp12_.x;
			break;
		}
		case ORIENTATION_RIGHT_TOP:
		{
			GdkPoint _tmp13_;
			Dimensions _tmp14_;
			GdkPoint _tmp15_;
			_tmp13_ = *point;
			derotated.x = _tmp13_.y;
			_tmp14_ = *space;
			_tmp15_ = *point;
			derotated.y = (_tmp14_.height - _tmp15_.x) - 1;
			break;
		}
		case ORIENTATION_RIGHT_BOTTOM:
		{
			Dimensions _tmp16_;
			GdkPoint _tmp17_;
			Dimensions _tmp18_;
			GdkPoint _tmp19_;
			_tmp16_ = *space;
			_tmp17_ = *point;
			derotated.x = (_tmp16_.width - _tmp17_.y) - 1;
			_tmp18_ = *space;
			_tmp19_ = *point;
			derotated.y = (_tmp18_.height - _tmp19_.x) - 1;
			break;
		}
		case ORIENTATION_LEFT_BOTTOM:
		{
			Dimensions _tmp20_;
			GdkPoint _tmp21_;
			GdkPoint _tmp22_;
			_tmp20_ = *space;
			_tmp21_ = *point;
			derotated.x = (_tmp20_.width - _tmp21_.y) - 1;
			_tmp22_ = *point;
			derotated.y = _tmp22_.x;
			break;
		}
		default:
		{
			g_error ("Orientation.vala:416: rotate_point: %d", (gint) self);
		}
	}
	*result = derotated;
	return;
}

void
orientation_rotate_box (Orientation self,
                        Dimensions* space,
                        Box* box,
                        Box* result)
{
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	GdkPoint _tmp2_;
	Dimensions _tmp3_;
	GdkPoint _tmp4_;
	Dimensions _tmp5_;
	GdkPoint _tmp6_;
	Dimensions _tmp7_;
	GdkPoint _tmp8_;
	Dimensions _tmp9_;
	Dimensions _tmp10_;
	GdkPoint _tmp11_;
	GdkPoint _tmp12_ = {0};
	Dimensions _tmp13_;
	GdkPoint _tmp14_;
	GdkPoint _tmp15_ = {0};
	GdkPoint _tmp16_;
	GdkPoint _tmp17_;
	Box _tmp18_ = {0};
	g_return_if_fail (space != NULL);
	g_return_if_fail (box != NULL);
	box_get_points (box, &_tmp0_, &_tmp1_);
	top_left = _tmp0_;
	bottom_right = _tmp1_;
	_tmp2_ = top_left;
	_tmp3_ = *space;
	top_left.x = CLAMP (_tmp2_.x, 0, _tmp3_.width - 1);
	_tmp4_ = top_left;
	_tmp5_ = *space;
	top_left.y = CLAMP (_tmp4_.y, 0, _tmp5_.height - 1);
	_tmp6_ = bottom_right;
	_tmp7_ = *space;
	bottom_right.x = CLAMP (_tmp6_.x, 0, _tmp7_.width - 1);
	_tmp8_ = bottom_right;
	_tmp9_ = *space;
	bottom_right.y = CLAMP (_tmp8_.y, 0, _tmp9_.height - 1);
	_tmp10_ = *space;
	_tmp11_ = top_left;
	orientation_rotate_point (self, &_tmp10_, &_tmp11_, &_tmp12_);
	top_left = _tmp12_;
	_tmp13_ = *space;
	_tmp14_ = bottom_right;
	orientation_rotate_point (self, &_tmp13_, &_tmp14_, &_tmp15_);
	bottom_right = _tmp15_;
	_tmp16_ = top_left;
	_tmp17_ = bottom_right;
	box_from_points (&_tmp16_, &_tmp17_, &_tmp18_);
	*result = _tmp18_;
	return;
}

void
orientation_derotate_box (Orientation self,
                          Dimensions* space,
                          Box* box,
                          Box* result)
{
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	Dimensions _tmp2_;
	GdkPoint _tmp3_;
	GdkPoint _tmp4_ = {0};
	Dimensions _tmp5_;
	GdkPoint _tmp6_;
	GdkPoint _tmp7_ = {0};
	GdkPoint _tmp8_;
	GdkPoint _tmp9_;
	Box _tmp10_ = {0};
	g_return_if_fail (space != NULL);
	g_return_if_fail (box != NULL);
	box_get_points (box, &_tmp0_, &_tmp1_);
	top_left = _tmp0_;
	bottom_right = _tmp1_;
	_tmp2_ = *space;
	_tmp3_ = top_left;
	orientation_derotate_point (self, &_tmp2_, &_tmp3_, &_tmp4_);
	top_left = _tmp4_;
	_tmp5_ = *space;
	_tmp6_ = bottom_right;
	orientation_derotate_point (self, &_tmp5_, &_tmp6_, &_tmp7_);
	bottom_right = _tmp7_;
	_tmp8_ = top_left;
	_tmp9_ = bottom_right;
	box_from_points (&_tmp8_, &_tmp9_, &_tmp10_);
	*result = _tmp10_;
	return;
}

static GType
orientation_get_type_once (void)
{
	static const GEnumValue values[] = {{ORIENTATION_MIN, "ORIENTATION_MIN", "min"}, {ORIENTATION_TOP_LEFT, "ORIENTATION_TOP_LEFT", "top-left"}, {ORIENTATION_TOP_RIGHT, "ORIENTATION_TOP_RIGHT", "top-right"}, {ORIENTATION_BOTTOM_RIGHT, "ORIENTATION_BOTTOM_RIGHT", "bottom-right"}, {ORIENTATION_BOTTOM_LEFT, "ORIENTATION_BOTTOM_LEFT", "bottom-left"}, {ORIENTATION_LEFT_TOP, "ORIENTATION_LEFT_TOP", "left-top"}, {ORIENTATION_RIGHT_TOP, "ORIENTATION_RIGHT_TOP", "right-top"}, {ORIENTATION_RIGHT_BOTTOM, "ORIENTATION_RIGHT_BOTTOM", "right-bottom"}, {ORIENTATION_LEFT_BOTTOM, "ORIENTATION_LEFT_BOTTOM", "left-bottom"}, {ORIENTATION_MAX, "ORIENTATION_MAX", "max"}, {0, NULL, NULL}};
	GType orientation_type_id;
	orientation_type_id = g_enum_register_static ("Orientation", values);
	return orientation_type_id;
}

GType
orientation_get_type (void)
{
	static volatile gsize orientation_type_id__once = 0;
	if (g_once_init_enter (&orientation_type_id__once)) {
		GType orientation_type_id;
		orientation_type_id = orientation_get_type_once ();
		g_once_init_leave (&orientation_type_id__once, orientation_type_id);
	}
	return orientation_type_id__once;
}

GdkPixbuf*
rotation_perform (Rotation self,
                  GdkPixbuf* pixbuf)
{
	GdkPixbuf* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	switch (self) {
		case ROTATION_CLOCKWISE:
		{
			GdkPixbuf* _tmp0_;
			_tmp0_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
			result = _tmp0_;
			return result;
		}
		case ROTATION_COUNTERCLOCKWISE:
		{
			GdkPixbuf* _tmp1_;
			_tmp1_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
			result = _tmp1_;
			return result;
		}
		case ROTATION_MIRROR:
		{
			GdkPixbuf* _tmp2_;
			_tmp2_ = gdk_pixbuf_flip (pixbuf, TRUE);
			result = _tmp2_;
			return result;
		}
		case ROTATION_UPSIDE_DOWN:
		{
			GdkPixbuf* _tmp3_;
			_tmp3_ = gdk_pixbuf_flip (pixbuf, FALSE);
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:472: Unknown rotation: %d", (gint) self);
		}
	}
}

Rotation
rotation_opposite (Rotation self)
{
	Rotation result;
	switch (self) {
		case ROTATION_CLOCKWISE:
		{
			result = ROTATION_COUNTERCLOCKWISE;
			return result;
		}
		case ROTATION_COUNTERCLOCKWISE:
		{
			result = ROTATION_CLOCKWISE;
			return result;
		}
		case ROTATION_MIRROR:
		case ROTATION_UPSIDE_DOWN:
		{
			result = self;
			return result;
		}
		default:
		{
			g_error ("Orientation.vala:489: Unknown rotation: %d", (gint) self);
		}
	}
}

static GType
rotation_get_type_once (void)
{
	static const GEnumValue values[] = {{ROTATION_CLOCKWISE, "ROTATION_CLOCKWISE", "clockwise"}, {ROTATION_COUNTERCLOCKWISE, "ROTATION_COUNTERCLOCKWISE", "counterclockwise"}, {ROTATION_MIRROR, "ROTATION_MIRROR", "mirror"}, {ROTATION_UPSIDE_DOWN, "ROTATION_UPSIDE_DOWN", "upside-down"}, {0, NULL, NULL}};
	GType rotation_type_id;
	rotation_type_id = g_enum_register_static ("Rotation", values);
	return rotation_type_id;
}

GType
rotation_get_type (void)
{
	static volatile gsize rotation_type_id__once = 0;
	if (g_once_init_enter (&rotation_type_id__once)) {
		GType rotation_type_id;
		rotation_type_id = rotation_get_type_once ();
		g_once_init_leave (&rotation_type_id__once, rotation_type_id);
	}
	return rotation_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

