/* MetadataWriter.c generated by valac 0.56.17, the Vala compiler
 * generated from MetadataWriter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* MetadataWriter tracks LibraryPhotos for alterations to their metadata and commits those changes*/
/* in a timely manner to their backing files.  Because only the MetadataWriter knows when the*/
/* metadata has been properly committed, it is also responsible for updating the metadata-dirty*/
/* flag in Photo.  Thus, MetadataWriter should *always* be running, even if the user has turned off*/
/* the feature, so if they turn it on MetadataWriter can properly go out and update the backing*/
/* files.*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "metadata.h"
#include <float.h>
#include <math.h>
#include <config.h>

#define METADATA_WRITER_COMMIT_DELAY_MSEC ((guint) 3000)
#define METADATA_WRITER_COMMIT_SPACING_MSEC ((guint) 50)
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_METADATA_WRITER (metadata_writer_get_type ())
#define METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_WRITER, MetadataWriter))
#define METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_WRITER, MetadataWriterClass))
#define IS_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_WRITER))
#define IS_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_WRITER))
#define METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_WRITER, MetadataWriterClass))

typedef struct _MetadataWriter MetadataWriter;
typedef struct _MetadataWriterClass MetadataWriterClass;
typedef struct _MetadataWriterPrivate MetadataWriterPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_TIMED_QUEUE (timed_queue_get_type ())
#define TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMED_QUEUE, TimedQueue))
#define TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMED_QUEUE, TimedQueueClass))
#define IS_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMED_QUEUE))
#define IS_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMED_QUEUE))
#define TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMED_QUEUE, TimedQueueClass))

typedef struct _TimedQueue TimedQueue;
typedef struct _TimedQueueClass TimedQueueClass;

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define METADATA_WRITER_TYPE_COMMIT_JOB (metadata_writer_commit_job_get_type ())
#define METADATA_WRITER_COMMIT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob))
#define METADATA_WRITER_COMMIT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJobClass))
#define METADATA_WRITER_IS_COMMIT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), METADATA_WRITER_TYPE_COMMIT_JOB))
#define METADATA_WRITER_IS_COMMIT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), METADATA_WRITER_TYPE_COMMIT_JOB))
#define METADATA_WRITER_COMMIT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJobClass))

typedef struct _MetadataWriterCommitJob MetadataWriterCommitJob;
typedef struct _MetadataWriterCommitJobClass MetadataWriterCommitJobClass;
enum  {
	METADATA_WRITER_0_PROPERTY,
	METADATA_WRITER_NUM_PROPERTIES
};
static GParamSpec* metadata_writer_properties[METADATA_WRITER_NUM_PROPERTIES];

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_LIBRARY_MONITOR_POOL (library_monitor_pool_get_type ())
#define LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool))
#define LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))
#define IS_LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR_POOL))
#define IS_LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR_POOL))
#define LIBRARY_MONITOR_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))

typedef struct _LibraryMonitorPool LibraryMonitorPool;
typedef struct _LibraryMonitorPoolClass LibraryMonitorPoolClass;

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;

#define TYPE_LIBRARY_MONITOR (library_monitor_get_type ())
#define LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitor))
#define LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))
#define IS_LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR))
#define IS_LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR))
#define LIBRARY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))

typedef struct _LibraryMonitor LibraryMonitor;
typedef struct _LibraryMonitorClass LibraryMonitorClass;
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _timed_queue_unref0(var) ((var == NULL) ? NULL : (var = (timed_queue_unref (var), NULL)))
typedef void (*DequeuedCallback) (gconstpointer item, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _MetadataWriterCommitJobPrivate MetadataWriterCommitJobPrivate;

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_POSITIONABLE (positionable_get_type ())
#define POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITIONABLE, Positionable))
#define IS_POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITIONABLE))
#define POSITIONABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POSITIONABLE, PositionableIface))

typedef struct _Positionable Positionable;
typedef struct _PositionableIface PositionableIface;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
enum  {
	METADATA_WRITER_PROGRESS_SIGNAL,
	METADATA_WRITER_NUM_SIGNALS
};
static guint metadata_writer_signals[METADATA_WRITER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MetadataWriter {
	GObject parent_instance;
	MetadataWriterPrivate * priv;
};

struct _MetadataWriterClass {
	GObjectClass parent_class;
};

struct _MetadataWriterPrivate {
	Workers* workers;
	gboolean enabled;
	HashTimedQueue* dirty;
	GeeHashMap* pending;
	GeeHashSet* pending_cancel;
	GeeHashSet* interested_photo_details;
	LibraryPhoto* ignore_photo_alteration;
	guint outstanding_total;
	guint outstanding_completed;
	gboolean closed;
	gint pause_count;
	GeeHashSet* importing_photos;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _MetadataWriterCommitJob {
	BackgroundJob parent_instance;
	MetadataWriterCommitJobPrivate * priv;
	LibraryPhoto* photo;
	GeeSet* current_keywords;
	PhotoReimportMasterState* reimport_master_state;
	PhotoReimportEditableState* reimport_editable_state;
	GError* err;
	gboolean wrote_master;
	gboolean wrote_editable;
};

struct _MetadataWriterCommitJobClass {
	BackgroundJobClass parent_class;
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _PositionableIface {
	GTypeInterface parent_iface;
	void (*get_gps_coords) (Positionable* self, GpsCoords* result);
	void (*set_gps_coords) (Positionable* self, GpsCoords* gps_coords);
};

static gint MetadataWriter_private_offset;
static gpointer metadata_writer_parent_class = NULL;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
VALA_EXTERN TagSourceCollection* tag_global;
static MetadataWriter* metadata_writer_instance;
static MetadataWriter* metadata_writer_instance = NULL;
static gpointer metadata_writer_commit_job_parent_class = NULL;

VALA_EXTERN GType metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MetadataWriter, g_object_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN gpointer timed_queue_ref (gpointer instance);
VALA_EXTERN void timed_queue_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_timed_queue (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_timed_queue (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_timed_queue (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_timed_queue (const GValue* value);
VALA_EXTERN GType timed_queue_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimedQueue, timed_queue_unref)
VALA_EXTERN GType hash_timed_queue_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HashTimedQueue, timed_queue_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
static GType metadata_writer_commit_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MetadataWriterCommitJob, background_job_unref)
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
static void metadata_writer_on_config_changed (MetadataWriter* self);
static void _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed (ConfigurationFacade* _sender,
                                                                                                 gpointer self);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
static void metadata_writer_on_importing_photos (MetadataWriter* self,
                                          GeeCollection* media_sources);
static void _metadata_writer_on_importing_photos_media_source_collection_media_import_starting (MediaSourceCollection* _sender,
                                                                                         GeeCollection* media,
                                                                                         gpointer self);
static void metadata_writer_on_photos_imported (MetadataWriter* self,
                                         GeeCollection* media_sources);
static void _metadata_writer_on_photos_imported_media_source_collection_media_import_completed (MediaSourceCollection* _sender,
                                                                                         GeeCollection* media,
                                                                                         gpointer self);
static void metadata_writer_on_photos_added_removed (MetadataWriter* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void _metadata_writer_on_photos_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                                GeeIterable* added,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
static void metadata_writer_on_photos_altered (MetadataWriter* self,
                                        GeeMap* items);
static void _metadata_writer_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                       GeeMap* items,
                                                                       gpointer self);
static void metadata_writer_on_collection_frozen (MetadataWriter* self);
static void _metadata_writer_on_collection_frozen_data_collection_frozen (DataCollection* _sender,
                                                                   gpointer self);
static void metadata_writer_on_collection_thawed (MetadataWriter* self);
static void _metadata_writer_on_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                   gpointer self);
static void metadata_writer_on_photos_destroyed (MetadataWriter* self,
                                          GeeCollection* destroyed);
static void _metadata_writer_on_photos_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                             GeeCollection* destroyed,
                                                                             gpointer self);
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
static void metadata_writer_on_tags_altered (MetadataWriter* self,
                                      GeeMap* map);
static void _metadata_writer_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self);
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType container_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSource, g_object_unref)
static void metadata_writer_on_tag_contents_altered (MetadataWriter* self,
                                              ContainerSource* container,
                                              GeeCollection* added,
                                              gboolean relinking,
                                              GeeCollection* removed,
                                              gboolean unlinking);
static void _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                      ContainerSource* container,
                                                                                                      GeeCollection* added,
                                                                                                      gboolean relinked,
                                                                                                      GeeCollection* removed,
                                                                                                      gboolean unlinked,
                                                                                                      gpointer self);
static void metadata_writer_on_tag_backlink_removed (MetadataWriter* self,
                                              ContainerSource* container,
                                              GeeCollection* sources);
static void _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed (ContainerSourceCollection* _sender,
                                                                                                         ContainerSource* container,
                                                                                                         GeeCollection* sources,
                                                                                                         gpointer self);
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN Application* application_get_instance (void);
static void metadata_writer_on_application_exiting (MetadataWriter* self);
static void _metadata_writer_on_application_exiting_application_exiting (Application* _sender,
                                                                  gboolean panicked,
                                                                  gpointer self);
VALA_EXTERN gpointer library_monitor_pool_ref (gpointer instance);
VALA_EXTERN void library_monitor_pool_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_library_monitor_pool (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_library_monitor_pool (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_library_monitor_pool (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_library_monitor_pool (const GValue* value);
VALA_EXTERN GType library_monitor_pool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryMonitorPool, library_monitor_pool_unref)
VALA_EXTERN LibraryMonitorPool* library_monitor_pool_get_instance (void);
VALA_EXTERN GType directory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitor, g_object_unref)
VALA_EXTERN GType library_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryMonitor, g_object_unref)
static void metadata_writer_on_monitor_installed (MetadataWriter* self,
                                           LibraryMonitor* monitor);
static void _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                                   LibraryMonitor* monitor,
                                                                                   gpointer self);
static void metadata_writer_on_monitor_destroyed (MetadataWriter* self,
                                           LibraryMonitor* monitor);
static void _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                                   LibraryMonitor* monitor,
                                                                                   gpointer self);
VALA_EXTERN Workers* workers_new (guint max_threads,
                      gboolean exclusive);
VALA_EXTERN Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
static MetadataWriter* metadata_writer_new (void);
static MetadataWriter* metadata_writer_construct (GType object_type);
static void metadata_writer_on_photo_dequeued (MetadataWriter* self,
                                        LibraryPhoto* photo);
static void _metadata_writer_on_photo_dequeued_dequeued_callback (gconstpointer item,
                                                           gpointer self);
VALA_EXTERN HashTimedQueue* hash_timed_queue_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      guint hold_msec,
                                      DequeuedCallback callback,
                                      gpointer callback_target,
                                      GeeHashDataFunc hash_func,
                                      gpointer hash_func_target,
                                      GDestroyNotify hash_func_target_destroy_notify,
                                      GeeEqualDataFunc equal_func,
                                      gpointer equal_func_target,
                                      GDestroyNotify equal_func_target_destroy_notify,
                                      gint priority);
VALA_EXTERN HashTimedQueue* hash_timed_queue_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            guint hold_msec,
                                            DequeuedCallback callback,
                                            gpointer callback_target,
                                            GeeHashDataFunc hash_func,
                                            gpointer hash_func_target,
                                            GDestroyNotify hash_func_target_destroy_notify,
                                            GeeEqualDataFunc equal_func,
                                            gpointer equal_func_target,
                                            GDestroyNotify equal_func_target_destroy_notify,
                                            gint priority);
VALA_EXTERN void timed_queue_set_dequeue_spacing_msec (TimedQueue* self,
                                           guint msec);
VALA_EXTERN void metadata_writer_pause (MetadataWriter* self);
VALA_EXTERN gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
VALA_EXTERN void metadata_writer_force_rescan (MetadataWriter* self);
VALA_EXTERN void metadata_writer_init (void);
VALA_EXTERN void metadata_writer_terminate (void);
VALA_EXTERN void metadata_writer_close (MetadataWriter* self);
VALA_EXTERN MetadataWriter* metadata_writer_get_instance (void);
static void metadata_writer_schedule_if_dirty (MetadataWriter* self,
                                        GeeIterable* media_sources,
                                        const gchar* reason);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN void timed_queue_pause (TimedQueue* self);
VALA_EXTERN void metadata_writer_unpause (MetadataWriter* self);
VALA_EXTERN void timed_queue_unpause (TimedQueue* self);
static void metadata_writer_cancel_all (MetadataWriter* self,
                                 gboolean wait);
static void metadata_writer_on_discovery_completed (MetadataWriter* self);
static void _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                    gpointer self);
static gboolean metadata_writer_cancel_job (MetadataWriter* self,
                                     LibraryPhoto* photo);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
VALA_EXTERN GeeCollection* alteration_get_details (Alteration* self,
                                       const gchar* subject);
static void metadata_writer_photos_are_dirty (MetadataWriter* self,
                                       GeeCollection* photos,
                                       const gchar* reason,
                                       gboolean already_marked);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN GeeCollection* tag_get_sources (Tag* self);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
static void metadata_writer_count_enqueued_work (MetadataWriter* self,
                                          gint count,
                                          gboolean report);
static void metadata_writer_count_cancelled_work (MetadataWriter* self,
                                           gint count,
                                           gboolean report);
static void metadata_writer_count_completed_work (MetadataWriter* self,
                                           gint count,
                                           gboolean report);
VALA_EXTERN gboolean photo_is_master_metadata_dirty (Photo* self);
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
VALA_EXTERN void transaction_controller_begin (TransactionController* self);
VALA_EXTERN void photo_set_master_metadata_dirty (Photo* self,
                                      gboolean dirty,
                                      GError** error);
VALA_EXTERN void transaction_controller_commit (TransactionController* self);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN gboolean timed_queue_enqueue (TimedQueue* self,
                              gconstpointer item);
VALA_EXTERN void timed_queue_clear (TimedQueue* self);
VALA_EXTERN void background_job_cancel (BackgroundJob* self);
VALA_EXTERN void workers_wait_for_empty_queue (Workers* self);
VALA_EXTERN gboolean timed_queue_contains (TimedQueue* self,
                               gconstpointer item);
VALA_EXTERN gboolean timed_queue_remove_first (TimedQueue* self,
                                   gconstpointer item);
VALA_EXTERN GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
static MetadataWriterCommitJob* metadata_writer_commit_job_new (MetadataWriter* owner,
                                                         LibraryPhoto* photo,
                                                         GeeSet* keywords);
static MetadataWriterCommitJob* metadata_writer_commit_job_construct (GType object_type,
                                                               MetadataWriter* owner,
                                                               LibraryPhoto* photo,
                                                               GeeSet* keywords);
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static void metadata_writer_on_update_completed (MetadataWriter* self,
                                          BackgroundJob* j);
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer photo_reimport_master_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_master_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_master_state (const GValue* value);
VALA_EXTERN GType photo_reimport_master_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportMasterState, photo_reimport_master_state_unref)
VALA_EXTERN gpointer photo_reimport_editable_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_editable_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_editable_state (const GValue* value);
VALA_EXTERN GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportEditableState, photo_reimport_editable_state_unref)
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN GFile* photo_get_editable_file (Photo* self);
VALA_EXTERN void photo_finish_update_master_metadata (Photo* self,
                                          PhotoReimportMasterState* state,
                                          GError** error);
VALA_EXTERN void photo_finish_update_editable_metadata (Photo* self,
                                            PhotoReimportEditableState* state,
                                            GError** error);
static void metadata_writer_on_update_cancelled (MetadataWriter* self,
                                          BackgroundJob* j);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
static void _metadata_writer_on_update_completed_completion_callback (BackgroundJob* job,
                                                               gpointer self);
static void _metadata_writer_on_update_cancelled_cancellation_callback (BackgroundJob* job,
                                                                 gpointer self);
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void metadata_writer_commit_job_real_execute (BackgroundJob* base);
static void metadata_writer_commit_job_commit_master (MetadataWriterCommitJob* self,
                                               GError** error);
static void metadata_writer_commit_job_commit_editable (MetadataWriterCommitJob* self,
                                                 GError** error);
VALA_EXTERN gboolean photo_has_editable (Photo* self);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_get_master_file_format (Photo* self);
VALA_EXTERN gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
static gboolean metadata_writer_commit_job_update_metadata (MetadataWriterCommitJob* self,
                                                     PhotoMetadata* metadata,
                                                     gboolean skip_orientation);
VALA_EXTERN void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
VALA_EXTERN gboolean photo_persist_master_metadata (Photo* self,
                                        PhotoMetadata* metadata,
                                        PhotoReimportMasterState** state,
                                        GError** error);
VALA_EXTERN void library_monitor_unblacklist_file (GFile* file);
VALA_EXTERN PhotoFileFormat* photo_get_editable_file_format (Photo* self);
VALA_EXTERN PhotoMetadata* photo_get_editable_metadata (Photo* self,
                                            GError** error);
VALA_EXTERN gboolean photo_persist_editable_metadata (Photo* self,
                                          PhotoMetadata* metadata,
                                          PhotoReimportEditableState** state,
                                          GError** error);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN GType photo_metadata_set_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_metadata_set_title (PhotoMetadata* self,
                               const gchar* title,
                               PhotoMetadataSetOption option);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN void photo_metadata_set_comment (PhotoMetadata* self,
                                 const gchar* comment,
                                 PhotoMetadataSetOption option);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN Rating photo_metadata_get_rating (PhotoMetadata* self);
VALA_EXTERN void photo_metadata_set_rating (PhotoMetadata* self,
                                Rating rating);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
VALA_EXTERN gint64 nullsafe_date_time_comperator (GDateTime* time_a,
                                      GDateTime* time_b);
VALA_EXTERN void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN GType positionable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Positionable, g_object_unref)
VALA_EXTERN void positionable_get_gps_coords (Positionable* self,
                                  GpsCoords* result);
VALA_EXTERN void photo_metadata_get_gps_coords (PhotoMetadata* self,
                                    GpsCoords* result);
VALA_EXTERN gboolean gps_coords_equals (GpsCoords *self,
                            GpsCoords* gps);
VALA_EXTERN void photo_metadata_set_gps_coords (PhotoMetadata* self,
                                    GpsCoords* gps_coords);
VALA_EXTERN Tag* tag_for_path (const gchar* name);
VALA_EXTERN gchar* tag_get_user_visible_name (Tag* self);
VALA_EXTERN gboolean equal_sets (GeeSet* a,
                     GeeSet* b);
VALA_EXTERN GeeSet* photo_metadata_get_keywords (PhotoMetadata* self,
                                     GCompareDataFunc compare_func,
                                     gpointer compare_func_target,
                                     GDestroyNotify compare_func_target_destroy_notify);
VALA_EXTERN void photo_metadata_set_keywords (PhotoMetadata* self,
                                  GeeCollection* keywords,
                                  PhotoMetadataSetOption option);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Orientation photo_get_orientation (Photo* self);
VALA_EXTERN Orientation photo_metadata_get_orientation (PhotoMetadata* self);
VALA_EXTERN void photo_metadata_set_orientation (PhotoMetadata* self,
                                     Orientation orientation);
VALA_EXTERN void photo_metadata_set_software (PhotoMetadata* self,
                                  const gchar* software,
                                  const gchar* version);
static void metadata_writer_commit_job_finalize (BackgroundJob * obj);
static GType metadata_writer_commit_job_get_type_once (void);
static void metadata_writer_finalize (GObject * obj);
static GType metadata_writer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS[5] = {"name", "comment", "rating", "exposure-time", "gps"};

static inline gpointer
metadata_writer_get_instance_private (MetadataWriter* self)
{
	return G_STRUCT_MEMBER_P (self, MetadataWriter_private_offset);
}

static void
_metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed (ConfigurationFacade* _sender,
                                                                                            gpointer self)
{
	metadata_writer_on_config_changed ((MetadataWriter*) self);
}

static void
_metadata_writer_on_importing_photos_media_source_collection_media_import_starting (MediaSourceCollection* _sender,
                                                                                    GeeCollection* media,
                                                                                    gpointer self)
{
	metadata_writer_on_importing_photos ((MetadataWriter*) self, media);
}

static void
_metadata_writer_on_photos_imported_media_source_collection_media_import_completed (MediaSourceCollection* _sender,
                                                                                    GeeCollection* media,
                                                                                    gpointer self)
{
	metadata_writer_on_photos_imported ((MetadataWriter*) self, media);
}

static void
_metadata_writer_on_photos_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
	metadata_writer_on_photos_added_removed ((MetadataWriter*) self, added, removed);
}

static void
_metadata_writer_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                  GeeMap* items,
                                                                  gpointer self)
{
	metadata_writer_on_photos_altered ((MetadataWriter*) self, items);
}

static void
_metadata_writer_on_collection_frozen_data_collection_frozen (DataCollection* _sender,
                                                              gpointer self)
{
	metadata_writer_on_collection_frozen ((MetadataWriter*) self);
}

static void
_metadata_writer_on_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                              gpointer self)
{
	metadata_writer_on_collection_thawed ((MetadataWriter*) self);
}

static void
_metadata_writer_on_photos_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                        GeeCollection* destroyed,
                                                                        gpointer self)
{
	metadata_writer_on_photos_destroyed ((MetadataWriter*) self, destroyed);
}

static void
_metadata_writer_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                                GeeMap* items,
                                                                gpointer self)
{
	metadata_writer_on_tags_altered ((MetadataWriter*) self, items);
}

static void
_metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                 ContainerSource* container,
                                                                                                 GeeCollection* added,
                                                                                                 gboolean relinked,
                                                                                                 GeeCollection* removed,
                                                                                                 gboolean unlinked,
                                                                                                 gpointer self)
{
	metadata_writer_on_tag_contents_altered ((MetadataWriter*) self, container, added, relinked, removed, unlinked);
}

static void
_metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed (ContainerSourceCollection* _sender,
                                                                                                    ContainerSource* container,
                                                                                                    GeeCollection* sources,
                                                                                                    gpointer self)
{
	metadata_writer_on_tag_backlink_removed ((MetadataWriter*) self, container, sources);
}

static void
_metadata_writer_on_application_exiting_application_exiting (Application* _sender,
                                                             gboolean panicked,
                                                             gpointer self)
{
	metadata_writer_on_application_exiting ((MetadataWriter*) self);
}

static void
_metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                              LibraryMonitor* monitor,
                                                                              gpointer self)
{
	metadata_writer_on_monitor_installed ((MetadataWriter*) self, monitor);
}

static void
_metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                              LibraryMonitor* monitor,
                                                                              gpointer self)
{
	metadata_writer_on_monitor_destroyed ((MetadataWriter*) self, monitor);
}

static void
_metadata_writer_on_photo_dequeued_dequeued_callback (gconstpointer item,
                                                      gpointer self)
{
	metadata_writer_on_photo_dequeued ((MetadataWriter*) self, (LibraryPhoto*) item);
}

static MetadataWriter*
metadata_writer_construct (GType object_type)
{
	MetadataWriter * self = NULL;
	HashTimedQueue* _tmp0_;
	HashTimedQueue* _tmp1_;
	ConfigFacade* _tmp5_;
	ConfigFacade* _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	LibraryPhotoSourceCollection* _tmp9_;
	LibraryPhotoSourceCollection* _tmp10_;
	LibraryPhotoSourceCollection* _tmp11_;
	LibraryPhotoSourceCollection* _tmp12_;
	LibraryPhotoSourceCollection* _tmp13_;
	LibraryPhotoSourceCollection* _tmp14_;
	LibraryPhotoSourceCollection* _tmp15_;
	TagSourceCollection* _tmp16_;
	TagSourceCollection* _tmp17_;
	TagSourceCollection* _tmp18_;
	TagSourceCollection* _tmp19_;
	TagSourceCollection* _tmp20_;
	Application* _tmp21_;
	Application* _tmp22_;
	LibraryMonitorPool* _tmp23_;
	LibraryMonitorPool* _tmp24_;
	LibraryMonitorPool* _tmp25_;
	LibraryMonitorPool* _tmp26_;
	self = (MetadataWriter*) g_object_new (object_type, NULL);
	_tmp0_ = hash_timed_queue_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, METADATA_WRITER_COMMIT_DELAY_MSEC, _metadata_writer_on_photo_dequeued_dequeued_callback, self, NULL, NULL, NULL, NULL, NULL, NULL, G_PRIORITY_DEFAULT);
	_timed_queue_unref0 (self->priv->dirty);
	self->priv->dirty = _tmp0_;
	_tmp1_ = self->priv->dirty;
	timed_queue_set_dequeue_spacing_msec (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TIMED_QUEUE, TimedQueue), METADATA_WRITER_COMMIT_SPACING_MSEC);
	metadata_writer_pause (self);
	{
		const gchar** detail_collection = NULL;
		gint detail_collection_length1 = 0;
		gint _detail_collection_size_ = 0;
		gint detail_it = 0;
		detail_collection = METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS;
		detail_collection_length1 = G_N_ELEMENTS (METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS);
		for (detail_it = 0; detail_it < detail_collection_length1; detail_it = detail_it + 1) {
			gchar* _tmp2_;
			gchar* detail = NULL;
			_tmp2_ = g_strdup (detail_collection[detail_it]);
			detail = _tmp2_;
			{
				GeeHashSet* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->interested_photo_details;
				_tmp4_ = detail;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
				_g_free0 (detail);
			}
		}
	}
	_tmp5_ = config_facade_get_instance ();
	_tmp6_ = _tmp5_;
	self->priv->enabled = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp6_);
	_tmp7_ = config_facade_get_instance ();
	_tmp8_ = _tmp7_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "commit-metadata-to-masters-changed", (GCallback) _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed, self, 0);
	_g_object_unref0 (_tmp8_);
	metadata_writer_force_rescan (self);
	_tmp9_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "media-import-starting", (GCallback) _metadata_writer_on_importing_photos_media_source_collection_media_import_starting, self, 0);
	_tmp10_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "media-import-completed", (GCallback) _metadata_writer_on_photos_imported_media_source_collection_media_import_completed, self, 0);
	_tmp11_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _metadata_writer_on_photos_added_removed_data_collection_contents_altered, self, 0);
	_tmp12_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _metadata_writer_on_photos_altered_data_collection_items_altered, self, 0);
	_tmp13_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), "frozen", (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self, 0);
	_tmp14_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_COLLECTION, DataCollection), "thawed", (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self, 0);
	_tmp15_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_SOURCE_COLLECTION, SourceCollection), "items-destroyed", (GCallback) _metadata_writer_on_photos_destroyed_source_collection_items_destroyed, self, 0);
	_tmp16_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _metadata_writer_on_tags_altered_data_collection_items_altered, self, 0);
	_tmp17_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
	_tmp18_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "backlink-to-container-removed", (GCallback) _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed, self, 0);
	_tmp19_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_COLLECTION, DataCollection), "frozen", (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self, 0);
	_tmp20_ = tag_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_COLLECTION, DataCollection), "thawed", (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self, 0);
	_tmp21_ = application_get_instance ();
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "exiting", (GCallback) _metadata_writer_on_application_exiting_application_exiting, self, 0);
	_application_unref0 (_tmp22_);
	_tmp23_ = library_monitor_pool_get_instance ();
	_tmp24_ = _tmp23_;
	g_signal_connect_object (_tmp24_, "monitor-installed", (GCallback) _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed, self, 0);
	_library_monitor_pool_unref0 (_tmp24_);
	_tmp25_ = library_monitor_pool_get_instance ();
	_tmp26_ = _tmp25_;
	g_signal_connect_object (_tmp26_, "monitor-destroyed", (GCallback) _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed, self, 0);
	_library_monitor_pool_unref0 (_tmp26_);
	return self;
}

static MetadataWriter*
metadata_writer_new (void)
{
	return metadata_writer_construct (TYPE_METADATA_WRITER);
}

void
metadata_writer_init (void)
{
	MetadataWriter* _tmp0_;
	_tmp0_ = metadata_writer_new ();
	_g_object_unref0 (metadata_writer_instance);
	metadata_writer_instance = _tmp0_;
}

void
metadata_writer_terminate (void)
{
	MetadataWriter* _tmp0_;
	_tmp0_ = metadata_writer_instance;
	if (_tmp0_ != NULL) {
		MetadataWriter* _tmp1_;
		_tmp1_ = metadata_writer_instance;
		metadata_writer_close (_tmp1_);
	}
	_g_object_unref0 (metadata_writer_instance);
	metadata_writer_instance = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MetadataWriter*
metadata_writer_get_instance (void)
{
	MetadataWriter* _tmp0_;
	MetadataWriter* _tmp1_;
	MetadataWriter* result;
	_tmp0_ = metadata_writer_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
metadata_writer_force_rescan (MetadataWriter* self)
{
	LibraryPhotoSourceCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	_tmp0_ = library_photo_global;
	_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	metadata_writer_schedule_if_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable), "force rescan");
	_g_object_unref0 (_tmp2_);
}

void
metadata_writer_pause (MetadataWriter* self)
{
	gint _tmp0_;
	HashTimedQueue* _tmp1_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	_tmp0_ = self->priv->pause_count;
	self->priv->pause_count = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
	_tmp1_ = self->priv->dirty;
	timed_queue_pause (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TIMED_QUEUE, TimedQueue));
	g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, (guint) 0, (guint) 0);
}

void
metadata_writer_unpause (MetadataWriter* self)
{
	gboolean _tmp0_ = FALSE;
	HashTimedQueue* _tmp2_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	if (self->priv->pause_count == 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		self->priv->pause_count = self->priv->pause_count - 1;
		_tmp1_ = self->priv->pause_count;
		_tmp0_ = _tmp1_ != 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->dirty;
	timed_queue_unpause (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TIMED_QUEUE, TimedQueue));
}

void
metadata_writer_close (MetadataWriter* self)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	if (self->priv->closed) {
		return;
	}
	metadata_writer_cancel_all (self, TRUE);
	self->priv->closed = TRUE;
}

static void
metadata_writer_on_config_changed (MetadataWriter* self)
{
	gboolean value = FALSE;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp1_);
	value = _tmp2_;
	if (self->priv->enabled == value) {
		return;
	}
	self->priv->enabled = value;
	if (self->priv->enabled) {
		metadata_writer_force_rescan (self);
	} else {
		metadata_writer_cancel_all (self, FALSE);
	}
}

static void
metadata_writer_on_application_exiting (MetadataWriter* self)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	metadata_writer_close (self);
}

static void
_metadata_writer_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                               gpointer self)
{
	metadata_writer_on_discovery_completed ((MetadataWriter*) self);
}

static void
metadata_writer_on_monitor_installed (MetadataWriter* self,
                                      LibraryMonitor* monitor)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_LIBRARY_MONITOR (monitor));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (monitor, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), "discovery-completed", (GCallback) _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed, self, 0);
}

static void
metadata_writer_on_monitor_destroyed (MetadataWriter* self,
                                      LibraryMonitor* monitor)
{
	guint _tmp0_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_LIBRARY_MONITOR (monitor));
	g_signal_parse_name ("discovery-completed", TYPE_DIRECTORY_MONITOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (monitor, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed, self);
}

static void
metadata_writer_on_discovery_completed (MetadataWriter* self)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	metadata_writer_unpause (self);
}

static void
metadata_writer_on_collection_frozen (MetadataWriter* self)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	metadata_writer_pause (self);
}

static void
metadata_writer_on_collection_thawed (MetadataWriter* self)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	metadata_writer_unpause (self);
}

static void
metadata_writer_on_importing_photos (MetadataWriter* self,
                                     GeeCollection* media_sources)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media_sources, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->importing_photos;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_COLLECTION, GeeCollection));
}

static void
metadata_writer_on_photos_imported (MetadataWriter* self,
                                    GeeCollection* media_sources)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media_sources, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->importing_photos;
	gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_COLLECTION, GeeCollection));
}

static void
metadata_writer_on_photos_added_removed (MetadataWriter* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	if (added != NULL) {
		_tmp0_ = self->priv->enabled;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		metadata_writer_schedule_if_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable), "added to LibraryPhoto.global");
	}
	if (removed != NULL) {
		gboolean cancelled = FALSE;
		cancelled = FALSE;
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp1_;
			_tmp1_ = gee_iterable_iterator (removed);
			_object_it = _tmp1_;
			while (TRUE) {
				GeeIterator* _tmp2_;
				DataObject* object = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				gboolean _tmp5_ = FALSE;
				DataObject* _tmp6_;
				_tmp2_ = _object_it;
				if (!gee_iterator_next (_tmp2_)) {
					break;
				}
				_tmp3_ = _object_it;
				_tmp4_ = gee_iterator_get (_tmp3_);
				object = (DataObject*) _tmp4_;
				_tmp6_ = object;
				if (metadata_writer_cancel_job (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIBRARY_PHOTO, LibraryPhoto))) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = cancelled;
				}
				cancelled = _tmp5_;
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
		if (cancelled) {
			g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, self->priv->outstanding_completed, self->priv->outstanding_total);
		}
	}
}

static void
metadata_writer_on_photos_altered (MetadataWriter* self,
                                   GeeMap* items)
{
	GeeHashSet* photos = NULL;
	GeeHashSet* _tmp33_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
	photos = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			LibraryPhoto* photo = NULL;
			DataObject* _tmp8_;
			LibraryPhoto* _tmp9_;
			LibraryPhoto* _tmp10_;
			LibraryPhoto* _tmp11_;
			Alteration* alteration = NULL;
			DataObject* _tmp12_;
			gpointer _tmp13_;
			Alteration* _tmp14_;
			GeeCollection* details = NULL;
			Alteration* _tmp19_;
			GeeCollection* _tmp20_;
			GeeCollection* _tmp21_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp9_;
			_tmp10_ = photo;
			_tmp11_ = self->priv->ignore_photo_alteration;
			if (_tmp10_ == _tmp11_) {
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
				continue;
			}
			_tmp12_ = object;
			_tmp13_ = gee_map_get (items, _tmp12_);
			alteration = (Alteration*) _tmp13_;
			_tmp14_ = alteration;
			if (alteration_has_detail (_tmp14_, "image", "orientation")) {
				GeeHashSet* _tmp15_;
				GeeHashSet* _tmp17_;
				LibraryPhoto* _tmp18_;
				_tmp15_ = photos;
				if (_tmp15_ == NULL) {
					GeeHashSet* _tmp16_;
					_tmp16_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (photos);
					photos = _tmp16_;
				}
				_tmp17_ = photos;
				_tmp18_ = photo;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
				_alteration_unref0 (alteration);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
				continue;
			}
			_tmp19_ = alteration;
			_tmp20_ = alteration_get_details (_tmp19_, "metadata");
			details = _tmp20_;
			_tmp21_ = details;
			if (_tmp21_ == NULL) {
				_g_object_unref0 (details);
				_alteration_unref0 (alteration);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
				continue;
			}
			{
				GeeIterator* _detail_it = NULL;
				GeeCollection* _tmp22_;
				GeeIterator* _tmp23_;
				_tmp22_ = details;
				_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
				_detail_it = _tmp23_;
				while (TRUE) {
					GeeIterator* _tmp24_;
					gchar* detail = NULL;
					GeeIterator* _tmp25_;
					gpointer _tmp26_;
					GeeHashSet* _tmp27_;
					const gchar* _tmp28_;
					_tmp24_ = _detail_it;
					if (!gee_iterator_next (_tmp24_)) {
						break;
					}
					_tmp25_ = _detail_it;
					_tmp26_ = gee_iterator_get (_tmp25_);
					detail = (gchar*) _tmp26_;
					_tmp27_ = self->priv->interested_photo_details;
					_tmp28_ = detail;
					if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp28_)) {
						GeeHashSet* _tmp29_;
						GeeHashSet* _tmp31_;
						LibraryPhoto* _tmp32_;
						_tmp29_ = photos;
						if (_tmp29_ == NULL) {
							GeeHashSet* _tmp30_;
							_tmp30_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
							_g_object_unref0 (photos);
							photos = _tmp30_;
						}
						_tmp31_ = photos;
						_tmp32_ = photo;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp32_);
						_g_free0 (detail);
						break;
					}
					_g_free0 (detail);
				}
				_g_object_unref0 (_detail_it);
			}
			_g_object_unref0 (details);
			_alteration_unref0 (alteration);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp33_ = photos;
	if (_tmp33_ != NULL) {
		GeeHashSet* _tmp34_;
		_tmp34_ = photos;
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_COLLECTION, GeeCollection), "alteration", FALSE);
	}
	_g_object_unref0 (photos);
}

static void
metadata_writer_on_photos_destroyed (MetadataWriter* self,
                                     GeeCollection* destroyed)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destroyed, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (destroyed, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			LibraryPhoto* photo = NULL;
			DataSource* _tmp4_;
			LibraryPhoto* _tmp5_;
			LibraryPhoto* _tmp6_;
			GeeHashSet* _tmp7_;
			LibraryPhoto* _tmp8_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp5_;
			_tmp6_ = photo;
			metadata_writer_cancel_job (self, _tmp6_);
			_tmp7_ = self->priv->importing_photos;
			_tmp8_ = photo;
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
			_g_object_unref0 (photo);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
metadata_writer_on_tags_altered (MetadataWriter* self,
                                 GeeMap* map)
{
	GeeHashSet* photos = NULL;
	GeeHashSet* _tmp27_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	photos = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			Alteration* _tmp10_;
			gboolean _tmp11_;
			GeeHashSet* _tmp12_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (map, _tmp8_);
			_tmp10_ = (Alteration*) _tmp9_;
			_tmp11_ = !alteration_has_detail (_tmp10_, "metadata", "name");
			_alteration_unref0 (_tmp10_);
			if (_tmp11_) {
				_g_object_unref0 (object);
				continue;
			}
			_tmp12_ = photos;
			if (_tmp12_ == NULL) {
				GeeHashSet* _tmp13_;
				_tmp13_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (photos);
				photos = _tmp13_;
			}
			{
				GeeIterator* _media_it = NULL;
				DataObject* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeIterator* _tmp17_;
				GeeIterator* _tmp18_;
				_tmp14_ = object;
				_tmp15_ = tag_get_sources (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_TAG, Tag));
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_media_it = _tmp18_;
				while (TRUE) {
					GeeIterator* _tmp19_;
					MediaSource* media = NULL;
					GeeIterator* _tmp20_;
					gpointer _tmp21_;
					LibraryPhoto* photo = NULL;
					MediaSource* _tmp22_;
					LibraryPhoto* _tmp23_;
					LibraryPhoto* _tmp24_;
					_tmp19_ = _media_it;
					if (!gee_iterator_next (_tmp19_)) {
						break;
					}
					_tmp20_ = _media_it;
					_tmp21_ = gee_iterator_get (_tmp20_);
					media = (MediaSource*) _tmp21_;
					_tmp22_ = media;
					_tmp23_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_tmp22_) ? ((LibraryPhoto*) _tmp22_) : NULL);
					photo = _tmp23_;
					_tmp24_ = photo;
					if (_tmp24_ != NULL) {
						GeeHashSet* _tmp25_;
						LibraryPhoto* _tmp26_;
						_tmp25_ = photos;
						_tmp26_ = photo;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
					}
					_g_object_unref0 (photo);
					_g_object_unref0 (media);
				}
				_g_object_unref0 (_media_it);
			}
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp27_ = photos;
	if (_tmp27_ != NULL) {
		GeeHashSet* _tmp28_;
		_tmp28_ = photos;
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection), "tag renamed", FALSE);
	}
	_g_object_unref0 (photos);
}

static void
metadata_writer_on_tag_contents_altered (MetadataWriter* self,
                                         ContainerSource* container,
                                         GeeCollection* added,
                                         gboolean relinking,
                                         GeeCollection* removed,
                                         gboolean unlinking)
{
	Tag* tag = NULL;
	Tag* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_TAG, Tag));
	tag = _tmp0_;
	if (added != NULL) {
		_tmp1_ = !relinking;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeeArrayList* added_photos = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp15_;
		Tag* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		added_photos = _tmp2_;
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp3_;
			_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp3_;
			while (TRUE) {
				GeeIterator* _tmp4_;
				DataSource* source = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp7_;
				LibraryPhoto* _tmp8_;
				gboolean _tmp9_ = FALSE;
				LibraryPhoto* _tmp10_;
				_tmp4_ = _source_it;
				if (!gee_iterator_next (_tmp4_)) {
					break;
				}
				_tmp5_ = _source_it;
				_tmp6_ = gee_iterator_get (_tmp5_);
				source = (DataSource*) _tmp6_;
				_tmp7_ = source;
				_tmp8_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_tmp7_) ? ((LibraryPhoto*) _tmp7_) : NULL);
				photo = _tmp8_;
				_tmp10_ = photo;
				if (_tmp10_ != NULL) {
					GeeHashSet* _tmp11_;
					LibraryPhoto* _tmp12_;
					_tmp11_ = self->priv->importing_photos;
					_tmp12_ = photo;
					_tmp9_ = !gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GeeArrayList* _tmp13_;
					LibraryPhoto* _tmp14_;
					_tmp13_ = added_photos;
					_tmp14_ = photo;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
				}
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
		_tmp15_ = added_photos;
		_tmp16_ = tag;
		_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("added to %s", _tmp18_);
		_tmp20_ = _tmp19_;
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_, FALSE);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_object_unref0 (added_photos);
	}
	if (removed != NULL) {
		_tmp21_ = !unlinking;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GeeArrayList* removed_photos = NULL;
		GeeArrayList* _tmp22_;
		GeeArrayList* _tmp32_;
		Tag* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp22_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		removed_photos = _tmp22_;
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp23_;
			_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp23_;
			while (TRUE) {
				GeeIterator* _tmp24_;
				DataSource* source = NULL;
				GeeIterator* _tmp25_;
				gpointer _tmp26_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp27_;
				LibraryPhoto* _tmp28_;
				LibraryPhoto* _tmp29_;
				_tmp24_ = _source_it;
				if (!gee_iterator_next (_tmp24_)) {
					break;
				}
				_tmp25_ = _source_it;
				_tmp26_ = gee_iterator_get (_tmp25_);
				source = (DataSource*) _tmp26_;
				_tmp27_ = source;
				_tmp28_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_tmp27_) ? ((LibraryPhoto*) _tmp27_) : NULL);
				photo = _tmp28_;
				_tmp29_ = photo;
				if (_tmp29_ != NULL) {
					GeeArrayList* _tmp30_;
					LibraryPhoto* _tmp31_;
					_tmp30_ = removed_photos;
					_tmp31_ = photo;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp31_);
				}
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
		_tmp32_ = removed_photos;
		_tmp33_ = tag;
		_tmp34_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_DATA_OBJECT, DataObject));
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("removed from %s", _tmp35_);
		_tmp37_ = _tmp36_;
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_, FALSE);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_object_unref0 (removed_photos);
	}
	_g_object_unref0 (tag);
}

static void
metadata_writer_on_tag_backlink_removed (MetadataWriter* self,
                                         ContainerSource* container,
                                         GeeCollection* sources)
{
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			LibraryPhoto* photo = NULL;
			DataSource* _tmp5_;
			LibraryPhoto* _tmp6_;
			LibraryPhoto* _tmp7_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (DataSource*) _tmp4_;
			_tmp5_ = source;
			_tmp6_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_tmp5_) ? ((LibraryPhoto*) _tmp5_) : NULL);
			photo = _tmp6_;
			_tmp7_ = photo;
			if (_tmp7_ != NULL) {
				GeeArrayList* _tmp8_;
				LibraryPhoto* _tmp9_;
				_tmp8_ = photos;
				_tmp9_ = photo;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
			}
			_g_object_unref0 (photo);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp10_ = photos;
	_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_DATA_OBJECT, DataObject));
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("backlink removed from %s", _tmp12_);
	_tmp14_ = _tmp13_;
	metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp14_, FALSE);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_object_unref0 (photos);
}

static void
metadata_writer_count_enqueued_work (MetadataWriter* self,
                                     gint count,
                                     gboolean report)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	self->priv->outstanding_total = self->priv->outstanding_total + count;
	if (report) {
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, self->priv->outstanding_completed, self->priv->outstanding_total);
	}
}

static void
metadata_writer_count_cancelled_work (MetadataWriter* self,
                                      gint count,
                                      gboolean report)
{
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_METADATA_WRITER (self));
	if (self->priv->outstanding_total >= ((guint) count)) {
		_tmp0_ = self->priv->outstanding_total - count;
	} else {
		_tmp0_ = (guint) 0;
	}
	self->priv->outstanding_total = _tmp0_;
	if (self->priv->outstanding_completed >= self->priv->outstanding_total) {
		self->priv->outstanding_completed = (guint) 0;
		self->priv->outstanding_total = (guint) 0;
	}
	if (report) {
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, self->priv->outstanding_completed, self->priv->outstanding_total);
	}
}

static void
metadata_writer_count_completed_work (MetadataWriter* self,
                                      gint count,
                                      gboolean report)
{
	g_return_if_fail (IS_METADATA_WRITER (self));
	self->priv->outstanding_completed = self->priv->outstanding_completed + count;
	if (self->priv->outstanding_completed >= self->priv->outstanding_total) {
		self->priv->outstanding_completed = (guint) 0;
		self->priv->outstanding_total = (guint) 0;
	}
	if (report) {
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, self->priv->outstanding_completed, self->priv->outstanding_total);
	}
}

static void
metadata_writer_schedule_if_dirty (MetadataWriter* self,
                                   GeeIterable* media_sources,
                                   const gchar* reason)
{
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp14_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media_sources, GEE_TYPE_ITERABLE));
	g_return_if_fail (reason != NULL);
	photos = NULL;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (media_sources);
		_media_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MediaSource* media = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp4_;
			LibraryPhoto* _tmp5_;
			LibraryPhoto* _tmp6_;
			GeeHashSet* _tmp7_;
			LibraryPhoto* _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp1_ = _media_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _media_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			media = (MediaSource*) _tmp3_;
			_tmp4_ = media;
			_tmp5_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_tmp4_) ? ((LibraryPhoto*) _tmp4_) : NULL);
			photo = _tmp5_;
			_tmp6_ = photo;
			if (_tmp6_ == NULL) {
				_g_object_unref0 (photo);
				_g_object_unref0 (media);
				continue;
			}
			_tmp7_ = self->priv->importing_photos;
			_tmp8_ = photo;
			if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_)) {
				_g_object_unref0 (photo);
				_g_object_unref0 (media);
				continue;
			}
			_tmp9_ = photo;
			if (photo_is_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo))) {
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp12_;
				LibraryPhoto* _tmp13_;
				_tmp10_ = photos;
				if (_tmp10_ == NULL) {
					GeeArrayList* _tmp11_;
					_tmp11_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (photos);
					photos = _tmp11_;
				}
				_tmp12_ = photos;
				_tmp13_ = photo;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
			}
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	_tmp14_ = photos;
	if (_tmp14_ != NULL) {
		GeeArrayList* _tmp15_;
		_tmp15_ = photos;
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), reason, TRUE);
	}
	_g_object_unref0 (photos);
}

static void
metadata_writer_photos_are_dirty (MetadataWriter* self,
                                  GeeCollection* photos,
                                  const gchar* reason,
                                  gboolean already_marked)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp22_ = FALSE;
	gint _tmp29_;
	gint _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (photos, GEE_TYPE_COLLECTION));
	g_return_if_fail (reason != NULL);
	_tmp0_ = gee_collection_get_size (photos);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
		_photo_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			LibraryPhoto* _tmp6_;
			_tmp3_ = _photo_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _photo_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			photo = (LibraryPhoto*) _tmp5_;
			_tmp6_ = photo;
			metadata_writer_cancel_job (self, _tmp6_);
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	if (!already_marked) {
		{
			LibraryPhotoSourceCollection* _tmp7_;
			TransactionController* _tmp8_;
			TransactionController* _tmp9_;
			LibraryPhotoSourceCollection* _tmp15_;
			TransactionController* _tmp16_;
			TransactionController* _tmp17_;
			_tmp7_ = library_photo_global;
			_tmp8_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
			_tmp9_ = _tmp8_;
			transaction_controller_begin (_tmp9_);
			{
				GeeIterator* _photo_it = NULL;
				GeeIterator* _tmp10_;
				_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
				_photo_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_;
					LibraryPhoto* photo = NULL;
					GeeIterator* _tmp12_;
					gpointer _tmp13_;
					LibraryPhoto* _tmp14_;
					_tmp11_ = _photo_it;
					if (!gee_iterator_next (_tmp11_)) {
						break;
					}
					_tmp12_ = _photo_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					photo = (LibraryPhoto*) _tmp13_;
					_tmp14_ = photo;
					photo_set_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo), TRUE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (photo);
						_g_object_unref0 (_photo_it);
						goto __catch0_g_error;
					}
					_g_object_unref0 (photo);
				}
				_g_object_unref0 (_photo_it);
			}
			_tmp15_ = library_photo_global;
			_tmp16_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
			_tmp17_ = _tmp16_;
			transaction_controller_commit (_tmp17_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp18_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = err;
			if (_tmp18_->domain == DATABASE_ERROR) {
				GError* _tmp19_;
				_tmp19_ = err;
				app_window_database_error ((GError*) _tmp19_);
			} else {
				GError* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = err;
				_tmp21_ = _tmp20_->message;
				g_error ("MetadataWriter.vala:553: Unable to mark metadata as dirty: %s", _tmp21_);
			}
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (self->priv->closed) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = !self->priv->enabled;
	}
	if (_tmp22_) {
		return;
	}
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp23_;
		_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
		_photo_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			gboolean enqueued = FALSE;
			HashTimedQueue* _tmp27_;
			LibraryPhoto* _tmp28_;
			_tmp24_ = _photo_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _photo_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			photo = (LibraryPhoto*) _tmp26_;
			_tmp27_ = self->priv->dirty;
			_tmp28_ = photo;
			enqueued = timed_queue_enqueue (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_TIMED_QUEUE, TimedQueue), _tmp28_);
			_vala_assert (enqueued, "enqueued");
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	_tmp29_ = gee_collection_get_size (photos);
	_tmp30_ = _tmp29_;
	metadata_writer_count_enqueued_work (self, _tmp30_, TRUE);
}

static void
metadata_writer_cancel_all (MetadataWriter* self,
                            gboolean wait)
{
	HashTimedQueue* _tmp0_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	_tmp0_ = self->priv->dirty;
	timed_queue_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TIMED_QUEUE, TimedQueue));
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->pending;
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_job_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			MetadataWriterCommitJob* job = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			MetadataWriterCommitJob* _tmp10_;
			_tmp7_ = _job_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _job_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			job = (MetadataWriterCommitJob*) _tmp9_;
			_tmp10_ = job;
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_BACKGROUND_JOB, BackgroundJob));
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	if (wait) {
		Workers* _tmp11_;
		_tmp11_ = self->priv->workers;
		workers_wait_for_empty_queue (_tmp11_);
	}
	metadata_writer_count_cancelled_work (self, G_MAXINT, TRUE);
}

static gboolean
metadata_writer_cancel_job (MetadataWriter* self,
                            LibraryPhoto* photo)
{
	gboolean cancelled = FALSE;
	GeeHashMap* _tmp0_;
	HashTimedQueue* _tmp7_;
	gboolean result;
	g_return_val_if_fail (IS_METADATA_WRITER (self), FALSE);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), FALSE);
	cancelled = FALSE;
	_tmp0_ = self->priv->pending;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
		MetadataWriterCommitJob* j = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		GeeHashSet* _tmp3_;
		MetadataWriterCommitJob* _tmp4_;
		MetadataWriterCommitJob* _tmp5_;
		GeeHashMap* _tmp6_;
		_tmp1_ = self->priv->pending;
		_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
		j = G_TYPE_CHECK_INSTANCE_CAST ((MetadataWriterCommitJob*) _tmp2_, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
		_tmp3_ = self->priv->pending_cancel;
		_tmp4_ = j;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
		_tmp5_ = j;
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
		_tmp6_ = self->priv->pending;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo, NULL);
		cancelled = TRUE;
		_background_job_unref0 (j);
	}
	_tmp7_ = self->priv->dirty;
	if (timed_queue_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TIMED_QUEUE, TimedQueue), photo)) {
		gboolean removed = FALSE;
		HashTimedQueue* _tmp8_;
		HashTimedQueue* _tmp9_;
		_tmp8_ = self->priv->dirty;
		removed = timed_queue_remove_first (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TIMED_QUEUE, TimedQueue), photo);
		_vala_assert (removed, "removed");
		_tmp9_ = self->priv->dirty;
		_vala_assert (!timed_queue_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TIMED_QUEUE, TimedQueue), photo), "!dirty.contains(photo)");
		metadata_writer_count_cancelled_work (self, 1, FALSE);
		cancelled = TRUE;
	}
	result = cancelled;
	return result;
}

static void
metadata_writer_on_photo_dequeued (MetadataWriter* self,
                                   LibraryPhoto* photo)
{
	GeeSet* keywords = NULL;
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeCollection* _tmp2_;
	GeeHashMap* _tmp13_;
	MetadataWriterCommitJob* job = NULL;
	GeeSet* _tmp14_;
	MetadataWriterCommitJob* _tmp15_;
	GeeHashMap* _tmp16_;
	MetadataWriterCommitJob* _tmp17_;
	Workers* _tmp18_;
	MetadataWriterCommitJob* _tmp19_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	if (!self->priv->enabled) {
		metadata_writer_count_cancelled_work (self, 1, TRUE);
		return;
	}
	keywords = NULL;
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource));
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp2_ = tags;
	if (_tmp2_ != NULL) {
		GeeHashSet* _tmp3_;
		_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (keywords);
		keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp4_ = tags;
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
			_tag_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				Tag* tag = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				GeeSet* _tmp9_;
				Tag* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp6_ = _tag_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _tag_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				tag = (Tag*) _tmp8_;
				_tmp9_ = keywords;
				_tmp10_ = tag;
				_tmp11_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
				_tmp12_ = _tmp11_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
				_g_free0 (_tmp12_);
				_g_object_unref0 (tag);
			}
			_g_object_unref0 (_tag_it);
		}
	}
	_tmp13_ = self->priv->pending;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
		metadata_writer_cancel_job (self, photo);
	}
	_tmp14_ = keywords;
	_tmp15_ = metadata_writer_commit_job_new (self, photo, _tmp14_);
	job = _tmp15_;
	_tmp16_ = self->priv->pending;
	_tmp17_ = job;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo, _tmp17_);
	_tmp18_ = self->priv->workers;
	_tmp19_ = job;
	workers_enqueue (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_BACKGROUND_JOB, BackgroundJob));
	_background_job_unref0 (job);
	_g_object_unref0 (tags);
	_g_object_unref0 (keywords);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
metadata_writer_on_update_completed (MetadataWriter* self,
                                     BackgroundJob* j)
{
	MetadataWriterCommitJob* job = NULL;
	MetadataWriterCommitJob* _tmp0_;
	MetadataWriterCommitJob* _tmp1_;
	GError* _tmp2_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp41_;
	MetadataWriterCommitJob* _tmp42_;
	LibraryPhoto* _tmp43_;
	LibraryPhotoSourceCollection* _tmp44_;
	TransactionController* _tmp45_;
	TransactionController* _tmp46_;
	gboolean _tmp47_ = FALSE;
	MetadataWriterCommitJob* _tmp48_;
	PhotoReimportMasterState* _tmp49_;
	LibraryPhotoSourceCollection* _tmp75_;
	TransactionController* _tmp76_;
	TransactionController* _tmp77_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->err;
	if (_tmp2_ != NULL) {
		MetadataWriterCommitJob* _tmp3_;
		LibraryPhoto* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		MetadataWriterCommitJob* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_tmp3_ = job;
		_tmp4_ = _tmp3_->photo;
		_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
		_tmp6_ = _tmp5_;
		_tmp7_ = job;
		_tmp8_ = _tmp7_->err;
		_tmp9_ = _tmp8_->message;
		g_warning ("MetadataWriter.vala:643: Unable to write metadata to %s: %s", _tmp6_, _tmp9_);
		_g_free0 (_tmp6_);
	} else {
		MetadataWriterCommitJob* _tmp10_;
		MetadataWriterCommitJob* _tmp23_;
		LibraryPhoto* _tmp24_;
		GFile* _tmp25_;
		GFile* _tmp26_;
		gboolean _tmp27_;
		_tmp10_ = job;
		if (_tmp10_->wrote_master) {
			MetadataWriterCommitJob* _tmp11_;
			LibraryPhoto* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = job;
			_tmp12_ = _tmp11_->photo;
			_tmp13_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp14_ = _tmp13_;
			_tmp15_ = g_file_get_path (_tmp14_);
			_tmp16_ = _tmp15_;
			g_message ("MetadataWriter.vala:646: Completed writing metadata to %s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_object_unref0 (_tmp14_);
		} else {
			MetadataWriterCommitJob* _tmp17_;
			LibraryPhoto* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp17_ = job;
			_tmp18_ = _tmp17_->photo;
			_tmp19_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp20_ = _tmp19_;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			g_message ("MetadataWriter.vala:648: Unable to write metadata to %s", _tmp22_);
			_g_free0 (_tmp22_);
			_g_object_unref0 (_tmp20_);
		}
		_tmp23_ = job;
		_tmp24_ = _tmp23_->photo;
		_tmp25_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PHOTO, Photo));
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_ != NULL;
		_g_object_unref0 (_tmp26_);
		if (_tmp27_) {
			MetadataWriterCommitJob* _tmp28_;
			_tmp28_ = job;
			if (_tmp28_->wrote_editable) {
				MetadataWriterCommitJob* _tmp29_;
				LibraryPhoto* _tmp30_;
				GFile* _tmp31_;
				GFile* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp29_ = job;
				_tmp30_ = _tmp29_->photo;
				_tmp31_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO, Photo));
				_tmp32_ = _tmp31_;
				_tmp33_ = g_file_get_path (_tmp32_);
				_tmp34_ = _tmp33_;
				g_message ("MetadataWriter.vala:652: Completed writing metadata to %s", _tmp34_);
				_g_free0 (_tmp34_);
				_g_object_unref0 (_tmp32_);
			} else {
				MetadataWriterCommitJob* _tmp35_;
				LibraryPhoto* _tmp36_;
				GFile* _tmp37_;
				GFile* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp35_ = job;
				_tmp36_ = _tmp35_->photo;
				_tmp37_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_PHOTO, Photo));
				_tmp38_ = _tmp37_;
				_tmp39_ = g_file_get_path (_tmp38_);
				_tmp40_ = _tmp39_;
				g_message ("MetadataWriter.vala:654: Unable to write metadata to %s", _tmp40_);
				_g_free0 (_tmp40_);
				_g_object_unref0 (_tmp38_);
			}
		}
	}
	_tmp41_ = self->priv->pending;
	_tmp42_ = job;
	_tmp43_ = _tmp42_->photo;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp43_, NULL);
	_vala_assert (removed, "removed");
	_tmp44_ = library_photo_global;
	_tmp45_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp46_ = _tmp45_;
	transaction_controller_begin (_tmp46_);
	_tmp48_ = job;
	_tmp49_ = _tmp48_->reimport_master_state;
	if (_tmp49_ != NULL) {
		_tmp47_ = TRUE;
	} else {
		MetadataWriterCommitJob* _tmp50_;
		PhotoReimportEditableState* _tmp51_;
		_tmp50_ = job;
		_tmp51_ = _tmp50_->reimport_editable_state;
		_tmp47_ = _tmp51_ != NULL;
	}
	if (_tmp47_) {
		LibraryPhoto* _tmp52_;
		MetadataWriterCommitJob* _tmp53_;
		LibraryPhoto* _tmp54_;
		LibraryPhoto* _tmp55_;
		_tmp52_ = self->priv->ignore_photo_alteration;
		_vala_assert (_tmp52_ == NULL, "ignore_photo_alteration == null");
		_tmp53_ = job;
		_tmp54_ = _tmp53_->photo;
		_tmp55_ = _g_object_ref0 (_tmp54_);
		_g_object_unref0 (self->priv->ignore_photo_alteration);
		self->priv->ignore_photo_alteration = _tmp55_;
		{
			MetadataWriterCommitJob* _tmp56_;
			PhotoReimportMasterState* _tmp57_;
			MetadataWriterCommitJob* _tmp62_;
			PhotoReimportEditableState* _tmp63_;
			_tmp56_ = job;
			_tmp57_ = _tmp56_->reimport_master_state;
			if (_tmp57_ != NULL) {
				MetadataWriterCommitJob* _tmp58_;
				LibraryPhoto* _tmp59_;
				MetadataWriterCommitJob* _tmp60_;
				PhotoReimportMasterState* _tmp61_;
				_tmp58_ = job;
				_tmp59_ = _tmp58_->photo;
				_tmp60_ = job;
				_tmp61_ = _tmp60_->reimport_master_state;
				photo_finish_update_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_PHOTO, Photo), _tmp61_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch0_database_error;
					}
					_background_job_unref0 (job);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp62_ = job;
			_tmp63_ = _tmp62_->reimport_editable_state;
			if (_tmp63_ != NULL) {
				MetadataWriterCommitJob* _tmp64_;
				LibraryPhoto* _tmp65_;
				MetadataWriterCommitJob* _tmp66_;
				PhotoReimportEditableState* _tmp67_;
				_tmp64_ = job;
				_tmp65_ = _tmp64_->photo;
				_tmp66_ = job;
				_tmp67_ = _tmp66_->reimport_editable_state;
				photo_finish_update_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_PHOTO, Photo), _tmp67_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch0_database_error;
					}
					_background_job_unref0 (job);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally0;
		__catch0_database_error:
		{
			GError* err = NULL;
			GError* _tmp68_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp68_ = err;
			app_window_database_error (_tmp68_);
			_g_error_free0 (err);
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			LibraryPhoto* _tmp69_;
			MetadataWriterCommitJob* _tmp70_;
			LibraryPhoto* _tmp71_;
			_tmp69_ = self->priv->ignore_photo_alteration;
			_tmp70_ = job;
			_tmp71_ = _tmp70_->photo;
			_vala_assert (_tmp69_ == _tmp71_, "ignore_photo_alteration == job.photo");
			_g_object_unref0 (self->priv->ignore_photo_alteration);
			self->priv->ignore_photo_alteration = NULL;
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_background_job_unref0 (job);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
	}
	{
		MetadataWriterCommitJob* _tmp72_;
		LibraryPhoto* _tmp73_;
		_tmp72_ = job;
		_tmp73_ = _tmp72_->photo;
		photo_set_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_PHOTO, Photo), FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp74_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp74_ = err;
		app_window_database_error (_tmp74_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_background_job_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp75_ = library_photo_global;
	_tmp76_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp77_ = _tmp76_;
	transaction_controller_commit (_tmp77_);
	metadata_writer_count_completed_work (self, 1, TRUE);
	_background_job_unref0 (job);
}

static void
metadata_writer_on_update_cancelled (MetadataWriter* self,
                                     BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_METADATA_WRITER (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = self->priv->pending_cancel;
	removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (j, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob));
	_vala_assert (removed, "removed");
	metadata_writer_count_cancelled_work (self, 1, TRUE);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
_metadata_writer_on_update_completed_completion_callback (BackgroundJob* job,
                                                          gpointer self)
{
	metadata_writer_on_update_completed ((MetadataWriter*) self, job);
}

static void
_metadata_writer_on_update_cancelled_cancellation_callback (BackgroundJob* job,
                                                            gpointer self)
{
	metadata_writer_on_update_cancelled ((MetadataWriter*) self, job);
}

static MetadataWriterCommitJob*
metadata_writer_commit_job_construct (GType object_type,
                                      MetadataWriter* owner,
                                      LibraryPhoto* photo,
                                      GeeSet* keywords)
{
	MetadataWriterCommitJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
	GeeSet* _tmp3_;
	g_return_val_if_fail (IS_METADATA_WRITER (owner), NULL);
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
	g_return_val_if_fail ((keywords == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (keywords, GEE_TYPE_SET), NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	self = (MetadataWriterCommitJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _metadata_writer_on_update_completed_completion_callback, owner, _tmp1_, _metadata_writer_on_update_cancelled_cancellation_callback, owner, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp2_;
	_tmp3_ = _g_object_ref0 (keywords);
	_g_object_unref0 (self->current_keywords);
	self->current_keywords = _tmp3_;
	return self;
}

static MetadataWriterCommitJob*
metadata_writer_commit_job_new (MetadataWriter* owner,
                                LibraryPhoto* photo,
                                GeeSet* keywords)
{
	return metadata_writer_commit_job_construct (METADATA_WRITER_TYPE_COMMIT_JOB, owner, photo, keywords);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
metadata_writer_commit_job_real_execute (BackgroundJob* base)
{
	MetadataWriterCommitJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
	{
		metadata_writer_commit_job_commit_master (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		metadata_writer_commit_job_commit_editable (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _g_error_copy0 (_tmp0_);
		_g_error_free0 (self->err);
		self->err = _tmp1_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
metadata_writer_commit_job_commit_master (MetadataWriterCommitJob* self,
                                          GError** error)
{
	gboolean skip_orientation = FALSE;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	PhotoMetadata* metadata = NULL;
	LibraryPhoto* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self));
	_tmp0_ = self->photo;
	skip_orientation = photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo));
	_tmp1_ = self->photo;
	if (!photo_file_format_can_write_metadata (photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo)))) {
		return;
	}
	_tmp2_ = self->photo;
	_tmp3_ = photo_get_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo), &_inner_error0_);
	metadata = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = metadata;
	if (metadata_writer_commit_job_update_metadata (self, _tmp4_, skip_orientation)) {
		LibraryPhoto* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = self->photo;
		_tmp6_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp7_ = _tmp6_;
		library_monitor_blacklist_file (_tmp7_, "MetadataWriter.commit_master");
		_g_object_unref0 (_tmp7_);
		{
			LibraryPhoto* _tmp8_;
			PhotoMetadata* _tmp9_;
			PhotoReimportMasterState* _tmp10_ = NULL;
			_tmp8_ = self->photo;
			_tmp9_ = metadata;
			photo_persist_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo), _tmp9_, &_tmp10_, &_inner_error0_);
			_photo_reimport_master_state_unref0 (self->reimport_master_state);
			self->reimport_master_state = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __finally0;
			}
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			LibraryPhoto* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			_tmp11_ = self->photo;
			_tmp12_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp13_ = _tmp12_;
			library_monitor_unblacklist_file (_tmp13_);
			_g_object_unref0 (_tmp13_);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_media_metadata_unref0 (metadata);
			return;
		}
	}
	self->wrote_master = TRUE;
	_media_metadata_unref0 (metadata);
}

static void
metadata_writer_commit_job_commit_editable (MetadataWriterCommitJob* self,
                                            GError** error)
{
	gboolean _tmp0_ = FALSE;
	LibraryPhoto* _tmp1_;
	PhotoMetadata* metadata = NULL;
	LibraryPhoto* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoMetadata* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self));
	_tmp1_ = self->photo;
	if (!photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo))) {
		_tmp0_ = TRUE;
	} else {
		LibraryPhoto* _tmp2_;
		PhotoFileFormat* _tmp3_;
		PhotoFileFormat* _tmp4_;
		_tmp2_ = self->photo;
		_tmp3_ = photo_get_editable_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo));
		_tmp4_ = _tmp3_;
		_tmp0_ = !photo_file_format_can_write_metadata (*_tmp4_);
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->photo;
	_tmp6_ = photo_get_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO, Photo), &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp7_ = metadata;
	_vala_assert (_tmp7_ != NULL, "metadata != null");
	_tmp8_ = metadata;
	if (metadata_writer_commit_job_update_metadata (self, _tmp8_, FALSE)) {
		LibraryPhoto* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp9_ = self->photo;
		_tmp10_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo));
		_tmp11_ = _tmp10_;
		library_monitor_blacklist_file (_tmp11_, "MetadataWriter.commit_editable");
		_g_object_unref0 (_tmp11_);
		{
			LibraryPhoto* _tmp12_;
			PhotoMetadata* _tmp13_;
			PhotoReimportEditableState* _tmp14_ = NULL;
			_tmp12_ = self->photo;
			_tmp13_ = metadata;
			photo_persist_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO, Photo), _tmp13_, &_tmp14_, &_inner_error0_);
			_photo_reimport_editable_state_unref0 (self->reimport_editable_state);
			self->reimport_editable_state = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __finally0;
			}
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			LibraryPhoto* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			_tmp15_ = self->photo;
			_tmp16_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO, Photo));
			_tmp17_ = _tmp16_;
			library_monitor_unblacklist_file (_tmp17_);
			_g_object_unref0 (_tmp17_);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_media_metadata_unref0 (metadata);
			return;
		}
	}
	self->wrote_editable = TRUE;
	_media_metadata_unref0 (metadata);
}

static gboolean
metadata_writer_commit_job_update_metadata (MetadataWriterCommitJob* self,
                                            PhotoMetadata* metadata,
                                            gboolean skip_orientation)
{
	gboolean changed = FALSE;
	gchar* current_title = NULL;
	LibraryPhoto* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* current_comment = NULL;
	LibraryPhoto* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	Rating current_rating = 0;
	LibraryPhoto* _tmp14_;
	GDateTime* current_exposure_time = NULL;
	LibraryPhoto* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* metadata_exposure_time = NULL;
	MetadataDateTime* metadata_exposure_date_time = NULL;
	MetadataDateTime* _tmp17_;
	MetadataDateTime* _tmp18_;
	GDateTime* _tmp21_;
	GDateTime* _tmp22_;
	GpsCoords current_gps_coords = {0};
	LibraryPhoto* _tmp27_;
	GpsCoords _tmp28_ = {0};
	GpsCoords metadata_gps_coords = {0};
	GpsCoords _tmp29_ = {0};
	gboolean _tmp30_;
	GeeSet* safe_keywords = NULL;
	GeeHashSet* _tmp32_;
	GeeSet* _tmp33_;
	GeeSet* _tmp45_;
	GeeSet* _tmp46_;
	GeeSet* _tmp47_;
	gboolean _tmp48_;
	gboolean result;
	g_return_val_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self), FALSE);
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
	changed = FALSE;
	_tmp0_ = self->photo;
	_tmp1_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource));
	current_title = _tmp1_;
	_tmp2_ = current_title;
	_tmp3_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		const gchar* _tmp6_;
		_tmp6_ = current_title;
		photo_metadata_set_title (metadata, _tmp6_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		changed = TRUE;
	}
	_tmp7_ = self->photo;
	_tmp8_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
	current_comment = _tmp8_;
	_tmp9_ = current_comment;
	_tmp10_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp9_, _tmp11_) != 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		_tmp13_ = current_comment;
		photo_metadata_set_comment (metadata, _tmp13_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		changed = TRUE;
	}
	_tmp14_ = self->photo;
	current_rating = media_source_get_rating (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_MEDIA_SOURCE, MediaSource));
	if (current_rating != photo_metadata_get_rating (metadata)) {
		photo_metadata_set_rating (metadata, current_rating);
		changed = TRUE;
	}
	_tmp15_ = self->photo;
	_tmp16_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_SOURCE, MediaSource));
	current_exposure_time = _tmp16_;
	metadata_exposure_time = NULL;
	_tmp17_ = photo_metadata_get_exposure_date_time (metadata);
	metadata_exposure_date_time = _tmp17_;
	_tmp18_ = metadata_exposure_date_time;
	if (_tmp18_ != NULL) {
		MetadataDateTime* _tmp19_;
		GDateTime* _tmp20_;
		_tmp19_ = metadata_exposure_date_time;
		_tmp20_ = metadata_date_time_get_timestamp (_tmp19_);
		_g_date_time_unref0 (metadata_exposure_time);
		metadata_exposure_time = _tmp20_;
	}
	_tmp21_ = current_exposure_time;
	_tmp22_ = metadata_exposure_time;
	if (nullsafe_date_time_comperator (_tmp21_, _tmp22_) != ((gint64) 0)) {
		MetadataDateTime* _tmp23_ = NULL;
		GDateTime* _tmp24_;
		_tmp24_ = current_exposure_time;
		if (_tmp24_ != NULL) {
			GDateTime* _tmp25_;
			MetadataDateTime* _tmp26_;
			_tmp25_ = current_exposure_time;
			_tmp26_ = metadata_date_time_new (_tmp25_);
			_metadata_date_time_unref0 (_tmp23_);
			_tmp23_ = _tmp26_;
		} else {
			_metadata_date_time_unref0 (_tmp23_);
			_tmp23_ = NULL;
		}
		photo_metadata_set_exposure_date_time (metadata, _tmp23_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		changed = TRUE;
		_metadata_date_time_unref0 (_tmp23_);
	}
	_tmp27_ = self->photo;
	positionable_get_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_POSITIONABLE, Positionable), &_tmp28_);
	current_gps_coords = _tmp28_;
	photo_metadata_get_gps_coords (metadata, &_tmp29_);
	metadata_gps_coords = _tmp29_;
	_tmp30_ = gps_coords_equals (&current_gps_coords, &metadata_gps_coords);
	if (!_tmp30_) {
		GpsCoords _tmp31_;
		_tmp31_ = current_gps_coords;
		photo_metadata_set_gps_coords (metadata, &_tmp31_);
		changed = TRUE;
	}
	_tmp32_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	safe_keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_SET, GeeSet);
	_tmp33_ = self->current_keywords;
	if (_tmp33_ != NULL) {
		{
			GeeIterator* _tmp_it = NULL;
			GeeSet* _tmp34_;
			GeeIterator* _tmp35_;
			_tmp34_ = self->current_keywords;
			_tmp35_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp_it = _tmp35_;
			while (TRUE) {
				GeeIterator* _tmp36_;
				gchar* tmp = NULL;
				GeeIterator* _tmp37_;
				gpointer _tmp38_;
				Tag* tag = NULL;
				const gchar* _tmp39_;
				Tag* _tmp40_;
				GeeSet* _tmp41_;
				Tag* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp36_ = _tmp_it;
				if (!gee_iterator_next (_tmp36_)) {
					break;
				}
				_tmp37_ = _tmp_it;
				_tmp38_ = gee_iterator_get (_tmp37_);
				tmp = (gchar*) _tmp38_;
				_tmp39_ = tmp;
				_tmp40_ = tag_for_path (_tmp39_);
				tag = _tmp40_;
				_tmp41_ = safe_keywords;
				_tmp42_ = tag;
				_tmp43_ = tag_get_user_visible_name (_tmp42_);
				_tmp44_ = _tmp43_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_COLLECTION, GeeCollection), _tmp44_);
				_g_free0 (_tmp44_);
				_g_object_unref0 (tag);
				_g_free0 (tmp);
			}
			_g_object_unref0 (_tmp_it);
		}
	}
	_tmp45_ = safe_keywords;
	_tmp46_ = photo_metadata_get_keywords (metadata, NULL, NULL, NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = !equal_sets (_tmp45_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	if (_tmp48_) {
		GeeSet* _tmp49_;
		_tmp49_ = self->current_keywords;
		photo_metadata_set_keywords (metadata, G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		changed = TRUE;
	}
	if (!skip_orientation) {
		Orientation current_orientation = 0;
		LibraryPhoto* _tmp50_;
		_tmp50_ = self->photo;
		current_orientation = photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_PHOTO, Photo));
		if (current_orientation != photo_metadata_get_orientation (metadata)) {
			photo_metadata_set_orientation (metadata, current_orientation);
			changed = TRUE;
		}
	}
	if (changed) {
		photo_metadata_set_software (metadata, RESOURCES_APP_TITLE, RESOURCES_APP_VERSION);
	}
	result = changed;
	_g_object_unref0 (safe_keywords);
	_metadata_date_time_unref0 (metadata_exposure_date_time);
	_g_date_time_unref0 (metadata_exposure_time);
	_g_date_time_unref0 (current_exposure_time);
	_g_free0 (current_comment);
	_g_free0 (current_title);
	return result;
}

static void
metadata_writer_commit_job_class_init (MetadataWriterCommitJobClass * klass,
                                       gpointer klass_data)
{
	metadata_writer_commit_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = metadata_writer_commit_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) metadata_writer_commit_job_real_execute;
}

static void
metadata_writer_commit_job_instance_init (MetadataWriterCommitJob * self,
                                          gpointer klass)
{
	self->reimport_master_state = NULL;
	self->reimport_editable_state = NULL;
	self->err = NULL;
	self->wrote_master = FALSE;
	self->wrote_editable = FALSE;
}

static void
metadata_writer_commit_job_finalize (BackgroundJob * obj)
{
	MetadataWriterCommitJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
	_g_object_unref0 (self->photo);
	_g_object_unref0 (self->current_keywords);
	_photo_reimport_master_state_unref0 (self->reimport_master_state);
	_photo_reimport_editable_state_unref0 (self->reimport_editable_state);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (metadata_writer_commit_job_parent_class)->finalize (obj);
}

static GType
metadata_writer_commit_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MetadataWriterCommitJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_writer_commit_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataWriterCommitJob), 0, (GInstanceInitFunc) metadata_writer_commit_job_instance_init, NULL };
	GType metadata_writer_commit_job_type_id;
	metadata_writer_commit_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "MetadataWriterCommitJob", &g_define_type_info, 0);
	return metadata_writer_commit_job_type_id;
}

static GType
metadata_writer_commit_job_get_type (void)
{
	static volatile gsize metadata_writer_commit_job_type_id__once = 0;
	if (g_once_init_enter (&metadata_writer_commit_job_type_id__once)) {
		GType metadata_writer_commit_job_type_id;
		metadata_writer_commit_job_type_id = metadata_writer_commit_job_get_type_once ();
		g_once_init_leave (&metadata_writer_commit_job_type_id__once, metadata_writer_commit_job_type_id);
	}
	return metadata_writer_commit_job_type_id__once;
}

static void
metadata_writer_class_init (MetadataWriterClass * klass,
                            gpointer klass_data)
{
	metadata_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MetadataWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = metadata_writer_finalize;
	metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL] = g_signal_new ("progress", TYPE_METADATA_WRITER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
}

static void
metadata_writer_instance_init (MetadataWriter * self,
                               gpointer klass)
{
	Workers* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	self->priv = metadata_writer_get_instance_private (self);
	_tmp0_ = workers_new ((guint) 1, FALSE);
	self->priv->workers = _tmp0_;
	self->priv->enabled = FALSE;
	_tmp1_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, METADATA_WRITER_TYPE_COMMIT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pending = _tmp1_;
	_tmp2_ = gee_hash_set_new (METADATA_WRITER_TYPE_COMMIT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pending_cancel = _tmp2_;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->interested_photo_details = _tmp3_;
	self->priv->ignore_photo_alteration = NULL;
	self->priv->outstanding_total = (guint) 0;
	self->priv->outstanding_completed = (guint) 0;
	self->priv->closed = FALSE;
	self->priv->pause_count = 0;
	_tmp4_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->importing_photos = _tmp4_;
}

static void
metadata_writer_finalize (GObject * obj)
{
	MetadataWriter * self;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	guint _tmp4_;
	LibraryPhotoSourceCollection* _tmp5_;
	guint _tmp6_;
	LibraryPhotoSourceCollection* _tmp7_;
	guint _tmp8_;
	LibraryPhotoSourceCollection* _tmp9_;
	guint _tmp10_;
	LibraryPhotoSourceCollection* _tmp11_;
	guint _tmp12_;
	LibraryPhotoSourceCollection* _tmp13_;
	guint _tmp14_;
	LibraryPhotoSourceCollection* _tmp15_;
	guint _tmp16_;
	TagSourceCollection* _tmp17_;
	guint _tmp18_;
	TagSourceCollection* _tmp19_;
	guint _tmp20_;
	TagSourceCollection* _tmp21_;
	guint _tmp22_;
	TagSourceCollection* _tmp23_;
	guint _tmp24_;
	TagSourceCollection* _tmp25_;
	guint _tmp26_;
	Application* _tmp27_;
	Application* _tmp28_;
	guint _tmp29_;
	LibraryMonitorPool* _tmp30_;
	LibraryMonitorPool* _tmp31_;
	guint _tmp32_;
	LibraryMonitorPool* _tmp33_;
	LibraryMonitorPool* _tmp34_;
	guint _tmp35_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METADATA_WRITER, MetadataWriter);
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("commit-metadata-to-masters-changed", TYPE_CONFIGURATION_FACADE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed, self);
	_g_object_unref0 (_tmp1_);
	_tmp3_ = library_photo_global;
	g_signal_parse_name ("media-import-starting", TYPE_MEDIA_SOURCE_COLLECTION, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _metadata_writer_on_importing_photos_media_source_collection_media_import_starting, self);
	_tmp5_ = library_photo_global;
	g_signal_parse_name ("media-import-completed", TYPE_MEDIA_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _metadata_writer_on_photos_imported_media_source_collection_media_import_completed, self);
	_tmp7_ = library_photo_global;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _metadata_writer_on_photos_added_removed_data_collection_contents_altered, self);
	_tmp9_ = library_photo_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _metadata_writer_on_photos_altered_data_collection_items_altered, self);
	_tmp11_ = library_photo_global;
	g_signal_parse_name ("frozen", TYPE_DATA_COLLECTION, &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self);
	_tmp13_ = library_photo_global;
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self);
	_tmp15_ = library_photo_global;
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _metadata_writer_on_photos_destroyed_source_collection_items_destroyed, self);
	_tmp17_ = tag_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp18_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _metadata_writer_on_tags_altered_data_collection_items_altered, self);
	_tmp19_ = tag_global;
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp20_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
	_tmp21_ = tag_global;
	g_signal_parse_name ("backlink-to-container-removed", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp22_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp22_, 0, NULL, (GCallback) _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed, self);
	_tmp23_ = tag_global;
	g_signal_parse_name ("frozen", TYPE_DATA_COLLECTION, &_tmp24_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self);
	_tmp25_ = tag_global;
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp26_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp26_, 0, NULL, (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self);
	_tmp27_ = application_get_instance ();
	_tmp28_ = _tmp27_;
	g_signal_parse_name ("exiting", TYPE_APPLICATION, &_tmp29_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp28_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp29_, 0, NULL, (GCallback) _metadata_writer_on_application_exiting_application_exiting, self);
	_application_unref0 (_tmp28_);
	_tmp30_ = library_monitor_pool_get_instance ();
	_tmp31_ = _tmp30_;
	g_signal_parse_name ("monitor-installed", TYPE_LIBRARY_MONITOR_POOL, &_tmp32_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp31_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp32_, 0, NULL, (GCallback) _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed, self);
	_library_monitor_pool_unref0 (_tmp31_);
	_tmp33_ = library_monitor_pool_get_instance ();
	_tmp34_ = _tmp33_;
	g_signal_parse_name ("monitor-destroyed", TYPE_LIBRARY_MONITOR_POOL, &_tmp35_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp34_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp35_, 0, NULL, (GCallback) _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed, self);
	_library_monitor_pool_unref0 (_tmp34_);
	_workers_unref0 (self->priv->workers);
	_timed_queue_unref0 (self->priv->dirty);
	_g_object_unref0 (self->priv->pending);
	_g_object_unref0 (self->priv->pending_cancel);
	_g_object_unref0 (self->priv->interested_photo_details);
	_g_object_unref0 (self->priv->ignore_photo_alteration);
	_g_object_unref0 (self->priv->importing_photos);
	G_OBJECT_CLASS (metadata_writer_parent_class)->finalize (obj);
}

static GType
metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataWriter), 0, (GInstanceInitFunc) metadata_writer_instance_init, NULL };
	GType metadata_writer_type_id;
	metadata_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "MetadataWriter", &g_define_type_info, 0);
	MetadataWriter_private_offset = g_type_add_instance_private (metadata_writer_type_id, sizeof (MetadataWriterPrivate));
	return metadata_writer_type_id;
}

GType
metadata_writer_get_type (void)
{
	static volatile gsize metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&metadata_writer_type_id__once)) {
		GType metadata_writer_type_id;
		metadata_writer_type_id = metadata_writer_get_type_once ();
		g_once_init_leave (&metadata_writer_type_id__once, metadata_writer_type_id);
	}
	return metadata_writer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

