/* MediaMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from MediaMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
#define MEDIA_MONITOR_FLUSH_PENDING_UPDATES_MSEC 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecMonitorableUpdates ParamSpecMonitorableUpdates;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
enum  {
	MEDIA_MONITOR_0_PROPERTY,
	MEDIA_MONITOR_NUM_PROPERTIES
};
static GParamSpec* media_monitor_properties[MEDIA_MONITOR_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _MonitorableUpdatesPrivate {
	GFile* master_file;
	gboolean master_file_info_altered;
	GFileInfo* master_file_info;
	gboolean master_in_alteration;
	gboolean online;
	gboolean offline;
};

struct _ParamSpecMonitorableUpdates {
	GParamSpec parent_instance;
};

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, gint* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _MediaMonitorPrivate {
	MediaSourceCollection* sources;
	GCancellable* cancellable;
	GeeHashMap* pending_updates;
	guint pending_updates_timer_id;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gint MonitorableUpdates_private_offset;
static gpointer monitorable_updates_parent_class = NULL;
static gint MediaMonitor_private_offset;
static gpointer media_monitor_parent_class = NULL;

VALA_EXTERN gpointer monitorable_updates_ref (gpointer instance);
VALA_EXTERN void monitorable_updates_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitorable_updates (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_monitorable_updates (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_monitorable_updates (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_monitorable_updates (const GValue* value);
VALA_EXTERN GType monitorable_updates_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MonitorableUpdates, monitorable_updates_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self);
VALA_EXTERN void monitorable_updates_set_master_file (MonitorableUpdates* self,
                                          GFile* file);
VALA_EXTERN void monitorable_updates_set_master_file_info_altered (MonitorableUpdates* self,
                                                       gboolean altered);
VALA_EXTERN void monitorable_updates_set_master_file_info (MonitorableUpdates* self,
                                               GFileInfo* info);
VALA_EXTERN void monitorable_updates_set_master_in_alteration (MonitorableUpdates* self,
                                                   gboolean in_alteration);
VALA_EXTERN void monitorable_updates_set_master_alterations_complete (MonitorableUpdates* self,
                                                          GFileInfo* info);
VALA_EXTERN void monitorable_updates_mark_offline (MonitorableUpdates* self);
VALA_EXTERN void monitorable_updates_mark_online (MonitorableUpdates* self);
VALA_EXTERN void monitorable_updates_reset_online_offline (MonitorableUpdates* self);
VALA_EXTERN gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
VALA_EXTERN MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* monitorable_updates_construct (GType object_type,
                                                   Monitorable* monitorable);
VALA_EXTERN GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
VALA_EXTERN GFileInfo* monitorable_updates_get_master_file_info (MonitorableUpdates* self);
static gboolean monitorable_updates_real_is_in_alteration (MonitorableUpdates* self);
VALA_EXTERN gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self);
VALA_EXTERN gboolean monitorable_updates_is_set_online (MonitorableUpdates* self);
static void monitorable_updates_real_set_master_file (MonitorableUpdates* self,
                                               GFile* file);
static void monitorable_updates_real_set_master_file_info_altered (MonitorableUpdates* self,
                                                            gboolean altered);
static void monitorable_updates_real_set_master_file_info (MonitorableUpdates* self,
                                                    GFileInfo* info);
static void monitorable_updates_real_set_master_in_alteration (MonitorableUpdates* self,
                                                        gboolean in_alteration);
static void monitorable_updates_real_set_master_alterations_complete (MonitorableUpdates* self,
                                                               GFileInfo* info);
static void monitorable_updates_real_mark_offline (MonitorableUpdates* self);
static void monitorable_updates_real_mark_online (MonitorableUpdates* self);
static void monitorable_updates_real_reset_online_offline (MonitorableUpdates* self);
static gboolean monitorable_updates_real_is_all_updated (MonitorableUpdates* self);
static void monitorable_updates_finalize (MonitorableUpdates * obj);
static GType monitorable_updates_get_type_once (void);
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self);
VALA_EXTERN void media_monitor_close (MediaMonitor* self);
VALA_EXTERN gchar* media_monitor_to_string (MediaMonitor* self);
VALA_EXTERN MonitorableUpdates* media_monitor_create_updates (MediaMonitor* self,
                                                  Monitorable* monitorable);
VALA_EXTERN void media_monitor_on_media_source_destroyed (MediaMonitor* self,
                                              DataSource* source);
VALA_EXTERN void media_monitor_notify_discovery_started (MediaMonitor* self);
VALA_EXTERN MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self,
                                                                 GFile* file,
                                                                 GFileInfo* info,
                                                                 Monitorable** monitorable);
VALA_EXTERN GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self,
                                                          GFile* file,
                                                          GFileInfo* info,
                                                          MediaMonitorDiscoveredFile* _result_);
VALA_EXTERN GFile** media_monitor_get_auxilliary_backing_files (MediaMonitor* self,
                                                    Monitorable* monitorable,
                                                    gint* result_length1);
VALA_EXTERN void media_monitor_update_backing_file_info (MediaMonitor* self,
                                             Monitorable* monitorable,
                                             GFile* file,
                                             GFileInfo* info);
VALA_EXTERN void media_monitor_notify_discovery_completing (MediaMonitor* self);
VALA_EXTERN gboolean media_monitor_is_file_represented (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_created (MediaMonitor* self,
                                            GFile* file,
                                            GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_moved (MediaMonitor* self,
                                          GFile* old_file,
                                          GFile* new_file,
                                          GFileInfo* new_file_info);
VALA_EXTERN gboolean media_monitor_notify_file_altered (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self,
                                                       GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self,
                                                         GFile* file,
                                                         GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_deleted (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN void media_monitor_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error);
static void _media_monitor_on_media_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                DataSource* source,
                                                                                gpointer self);
static void _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                                    DataSource* source,
                                                                                    gpointer self);
VALA_EXTERN MediaMonitor* media_monitor_construct (GType object_type,
                                       MediaSourceCollection* sources,
                                       GCancellable* cancellable);
static gboolean media_monitor_on_flush_pending_updates (MediaMonitor* self);
static gboolean _media_monitor_on_flush_pending_updates_gsource_func (gpointer self);
static MediaSourceCollection* media_monitor_real_get_media_source_collection (MediaMonitor* self);
static void media_monitor_real_close (MediaMonitor* self);
static gchar* media_monitor_real_to_string (MediaMonitor* self);
VALA_EXTERN gchar* data_collection_to_string (DataCollection* self);
static MonitorableUpdates* media_monitor_real_create_updates (MediaMonitor* self,
                                                       Monitorable* monitorable);
static void media_monitor_real_on_media_source_destroyed (MediaMonitor* self,
                                                   DataSource* source);
VALA_EXTERN void media_monitor_remove_updates (MediaMonitor* self,
                                   Monitorable* monitorable);
static void media_monitor_real_notify_discovery_started (MediaMonitor* self);
static MediaMonitorDiscoveredFile media_monitor_real_notify_file_discovered (MediaMonitor* self,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable** monitorable);
static GeeCollection* media_monitor_real_candidates_for_unknown_file (MediaMonitor* self,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
static GFile** media_monitor_real_get_auxilliary_backing_files (MediaMonitor* self,
                                                         Monitorable* monitorable,
                                                         gint* result_length1);
static void media_monitor_real_update_backing_file_info (MediaMonitor* self,
                                                  Monitorable* monitorable,
                                                  GFile* file,
                                                  GFileInfo* info);
static void media_monitor_real_notify_discovery_completing (MediaMonitor* self);
static gboolean media_monitor_real_is_file_represented (MediaMonitor* self,
                                                 GFile* file);
static gboolean media_monitor_real_notify_file_created (MediaMonitor* self,
                                                 GFile* file,
                                                 GFileInfo* info);
static gboolean media_monitor_real_notify_file_moved (MediaMonitor* self,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* new_file_info);
static gboolean media_monitor_real_notify_file_altered (MediaMonitor* self,
                                                 GFile* file);
static gboolean media_monitor_real_notify_file_attributes_altered (MediaMonitor* self,
                                                            GFile* file);
static gboolean media_monitor_real_notify_file_alteration_completed (MediaMonitor* self,
                                                              GFile* file,
                                                              GFileInfo* info);
static gboolean media_monitor_real_notify_file_deleted (MediaMonitor* self,
                                                 GFile* file);
VALA_EXTERN void media_monitor_mdbg (const gchar* msg);
VALA_EXTERN gboolean media_monitor_has_pending_updates (MediaMonitor* self);
VALA_EXTERN GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
VALA_EXTERN MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self,
                                                 Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self,
                                                        Monitorable* monitorable);
VALA_EXTERN gboolean media_monitor_is_online (MediaMonitor* self,
                                  Monitorable* monitorable);
VALA_EXTERN gboolean monitorable_is_offline (Monitorable* self);
VALA_EXTERN gboolean media_monitor_is_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
VALA_EXTERN GFile* media_monitor_get_master_file (MediaMonitor* self,
                                      Monitorable* monitorable);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN void media_monitor_update_master_file (MediaMonitor* self,
                                       Monitorable* monitorable,
                                       GFile* file);
VALA_EXTERN void media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                                    Monitorable* monitorable);
VALA_EXTERN void media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                     Monitorable* monitorable,
                                                     gboolean in_alteration);
VALA_EXTERN void media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                             Monitorable* monitorable,
                                                             GFileInfo* info);
VALA_EXTERN void media_monitor_update_online (MediaMonitor* self,
                                  Monitorable* monitorable);
VALA_EXTERN void media_monitor_update_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
static void media_monitor_real_process_updates (MediaMonitor* self,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN void monitorable_set_many_master_file (GeeMap* map,
                                       TransactionController* controller,
                                       GError** error);
VALA_EXTERN void monitorable_set_many_master_timestamp (GeeMap* map,
                                            TransactionController* controller,
                                            GError** error);
VALA_EXTERN void monitorable_mark_many_online_offline (GeeCollection* online,
                                           GeeCollection* offline,
                                           TransactionController* controller,
                                           GError** error);
VALA_EXTERN TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
VALA_EXTERN void transaction_controller_begin (TransactionController* self);
VALA_EXTERN void transaction_controller_commit (TransactionController* self);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void app_window_panic (const gchar* msg);
static void media_monitor_finalize (GObject * obj);
static GType media_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
monitorable_updates_get_instance_private (MonitorableUpdates* self)
{
	return G_STRUCT_MEMBER_P (self, MonitorableUpdates_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MonitorableUpdates*
monitorable_updates_construct (GType object_type,
                               Monitorable* monitorable)
{
	MonitorableUpdates* self = NULL;
	Monitorable* _tmp0_;
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	self = (MonitorableUpdates*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (monitorable);
	_g_object_unref0 (self->monitorable);
	self->monitorable = _tmp0_;
	return self;
}

MonitorableUpdates*
monitorable_updates_new (Monitorable* monitorable)
{
	return monitorable_updates_construct (TYPE_MONITORABLE_UPDATES, monitorable);
}

GFile*
monitorable_updates_get_master_file (MonitorableUpdates* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), NULL);
	_tmp0_ = self->priv->master_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GFileInfo*
monitorable_updates_get_master_file_info (MonitorableUpdates* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* result;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), NULL);
	_tmp0_ = self->priv->master_file_info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
monitorable_updates_real_is_in_alteration (MonitorableUpdates* self)
{
	gboolean result;
	result = self->priv->master_in_alteration;
	return result;
}

gboolean
monitorable_updates_is_in_alteration (MonitorableUpdates* self)
{
	MonitorableUpdatesClass* _klass_;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->is_in_alteration) {
		return _klass_->is_in_alteration (self);
	}
	return FALSE;
}

gboolean
monitorable_updates_is_set_offline (MonitorableUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
	result = self->priv->offline;
	return result;
}

gboolean
monitorable_updates_is_set_online (MonitorableUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
	result = self->priv->online;
	return result;
}

static void
monitorable_updates_real_set_master_file (MonitorableUpdates* self,
                                          GFile* file)
{
	GFile* _tmp0_;
	g_return_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->master_file);
	self->priv->master_file = _tmp0_;
	if (file != NULL) {
		monitorable_updates_mark_online (self);
	}
}

void
monitorable_updates_set_master_file (MonitorableUpdates* self,
                                     GFile* file)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->set_master_file) {
		_klass_->set_master_file (self, file);
	}
}

static void
monitorable_updates_real_set_master_file_info_altered (MonitorableUpdates* self,
                                                       gboolean altered)
{
	self->priv->master_file_info_altered = altered;
	if (altered) {
		monitorable_updates_mark_online (self);
	}
}

void
monitorable_updates_set_master_file_info_altered (MonitorableUpdates* self,
                                                  gboolean altered)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->set_master_file_info_altered) {
		_klass_->set_master_file_info_altered (self, altered);
	}
}

static void
monitorable_updates_real_set_master_file_info (MonitorableUpdates* self,
                                               GFileInfo* info)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = _g_object_ref0 (info);
	_g_object_unref0 (self->priv->master_file_info);
	self->priv->master_file_info = _tmp0_;
	_tmp1_ = self->priv->master_file_info;
	if (_tmp1_ == NULL) {
		monitorable_updates_set_master_file_info_altered (self, FALSE);
	}
}

void
monitorable_updates_set_master_file_info (MonitorableUpdates* self,
                                          GFileInfo* info)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->set_master_file_info) {
		_klass_->set_master_file_info (self, info);
	}
}

static void
monitorable_updates_real_set_master_in_alteration (MonitorableUpdates* self,
                                                   gboolean in_alteration)
{
	self->priv->master_in_alteration = in_alteration;
}

void
monitorable_updates_set_master_in_alteration (MonitorableUpdates* self,
                                              gboolean in_alteration)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->set_master_in_alteration) {
		_klass_->set_master_in_alteration (self, in_alteration);
	}
}

static void
monitorable_updates_real_set_master_alterations_complete (MonitorableUpdates* self,
                                                          GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	monitorable_updates_set_master_in_alteration (self, FALSE);
	monitorable_updates_set_master_file_info (self, info);
	monitorable_updates_mark_online (self);
}

void
monitorable_updates_set_master_alterations_complete (MonitorableUpdates* self,
                                                     GFileInfo* info)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->set_master_alterations_complete) {
		_klass_->set_master_alterations_complete (self, info);
	}
}

static void
monitorable_updates_real_mark_offline (MonitorableUpdates* self)
{
	self->priv->online = FALSE;
	self->priv->offline = TRUE;
	self->priv->master_file_info_altered = FALSE;
	_g_object_unref0 (self->priv->master_file_info);
	self->priv->master_file_info = NULL;
	self->priv->master_in_alteration = FALSE;
}

void
monitorable_updates_mark_offline (MonitorableUpdates* self)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->mark_offline) {
		_klass_->mark_offline (self);
	}
}

static void
monitorable_updates_real_mark_online (MonitorableUpdates* self)
{
	self->priv->online = TRUE;
	self->priv->offline = FALSE;
}

void
monitorable_updates_mark_online (MonitorableUpdates* self)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->mark_online) {
		_klass_->mark_online (self);
	}
}

static void
monitorable_updates_real_reset_online_offline (MonitorableUpdates* self)
{
	self->priv->online = FALSE;
	self->priv->offline = FALSE;
}

void
monitorable_updates_reset_online_offline (MonitorableUpdates* self)
{
	MonitorableUpdatesClass* _klass_;
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->reset_online_offline) {
		_klass_->reset_online_offline (self);
	}
}

static gboolean
monitorable_updates_real_is_all_updated (MonitorableUpdates* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_;
	gboolean result;
	_tmp5_ = self->priv->master_file;
	if (_tmp5_ == NULL) {
		_tmp4_ = self->priv->master_file_info_altered == FALSE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GFileInfo* _tmp6_;
		_tmp6_ = self->priv->master_file_info;
		_tmp3_ = _tmp6_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = self->priv->master_in_alteration == FALSE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->online == FALSE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->offline == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
monitorable_updates_is_all_updated (MonitorableUpdates* self)
{
	MonitorableUpdatesClass* _klass_;
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
	_klass_ = MONITORABLE_UPDATES_GET_CLASS (self);
	if (_klass_->is_all_updated) {
		return _klass_->is_all_updated (self);
	}
	return FALSE;
}

static void
value_monitorable_updates_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_monitorable_updates_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		monitorable_updates_unref (value->data[0].v_pointer);
	}
}

static void
value_monitorable_updates_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = monitorable_updates_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_monitorable_updates_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_monitorable_updates_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MonitorableUpdates * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = monitorable_updates_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_monitorable_updates_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	MonitorableUpdates ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = monitorable_updates_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_monitorable_updates (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecMonitorableUpdates* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MONITORABLE_UPDATES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_monitorable_updates (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_monitorable_updates (GValue* value,
                               gpointer v_object)
{
	MonitorableUpdates * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITORABLE_UPDATES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		monitorable_updates_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		monitorable_updates_unref (old);
	}
}

void
value_take_monitorable_updates (GValue* value,
                                gpointer v_object)
{
	MonitorableUpdates * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITORABLE_UPDATES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		monitorable_updates_unref (old);
	}
}

static void
monitorable_updates_class_init (MonitorableUpdatesClass * klass,
                                gpointer klass_data)
{
	monitorable_updates_parent_class = g_type_class_peek_parent (klass);
	((MonitorableUpdatesClass *) klass)->finalize = monitorable_updates_finalize;
	g_type_class_adjust_private_offset (klass, &MonitorableUpdates_private_offset);
	((MonitorableUpdatesClass *) klass)->is_in_alteration = (gboolean (*) (MonitorableUpdates*)) monitorable_updates_real_is_in_alteration;
	((MonitorableUpdatesClass *) klass)->set_master_file = (void (*) (MonitorableUpdates*, GFile*)) monitorable_updates_real_set_master_file;
	((MonitorableUpdatesClass *) klass)->set_master_file_info_altered = (void (*) (MonitorableUpdates*, gboolean)) monitorable_updates_real_set_master_file_info_altered;
	((MonitorableUpdatesClass *) klass)->set_master_file_info = (void (*) (MonitorableUpdates*, GFileInfo*)) monitorable_updates_real_set_master_file_info;
	((MonitorableUpdatesClass *) klass)->set_master_in_alteration = (void (*) (MonitorableUpdates*, gboolean)) monitorable_updates_real_set_master_in_alteration;
	((MonitorableUpdatesClass *) klass)->set_master_alterations_complete = (void (*) (MonitorableUpdates*, GFileInfo*)) monitorable_updates_real_set_master_alterations_complete;
	((MonitorableUpdatesClass *) klass)->mark_offline = (void (*) (MonitorableUpdates*)) monitorable_updates_real_mark_offline;
	((MonitorableUpdatesClass *) klass)->mark_online = (void (*) (MonitorableUpdates*)) monitorable_updates_real_mark_online;
	((MonitorableUpdatesClass *) klass)->reset_online_offline = (void (*) (MonitorableUpdates*)) monitorable_updates_real_reset_online_offline;
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates*)) monitorable_updates_real_is_all_updated;
}

static void
monitorable_updates_instance_init (MonitorableUpdates * self,
                                   gpointer klass)
{
	self->priv = monitorable_updates_get_instance_private (self);
	self->priv->master_file = NULL;
	self->priv->master_file_info_altered = FALSE;
	self->priv->master_file_info = NULL;
	self->priv->master_in_alteration = FALSE;
	self->priv->online = FALSE;
	self->priv->offline = FALSE;
	self->ref_count = 1;
}

static void
monitorable_updates_finalize (MonitorableUpdates * obj)
{
	MonitorableUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->monitorable);
	_g_object_unref0 (self->priv->master_file);
	_g_object_unref0 (self->priv->master_file_info);
}

static GType
monitorable_updates_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_monitorable_updates_init, value_monitorable_updates_free_value, value_monitorable_updates_copy_value, value_monitorable_updates_peek_pointer, "p", value_monitorable_updates_collect_value, "p", value_monitorable_updates_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MonitorableUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitorable_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorableUpdates), 0, (GInstanceInitFunc) monitorable_updates_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType monitorable_updates_type_id;
	monitorable_updates_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MonitorableUpdates", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MonitorableUpdates_private_offset = g_type_add_instance_private (monitorable_updates_type_id, sizeof (MonitorableUpdatesPrivate));
	return monitorable_updates_type_id;
}

GType
monitorable_updates_get_type (void)
{
	static volatile gsize monitorable_updates_type_id__once = 0;
	if (g_once_init_enter (&monitorable_updates_type_id__once)) {
		GType monitorable_updates_type_id;
		monitorable_updates_type_id = monitorable_updates_get_type_once ();
		g_once_init_leave (&monitorable_updates_type_id__once, monitorable_updates_type_id);
	}
	return monitorable_updates_type_id__once;
}

gpointer
monitorable_updates_ref (gpointer instance)
{
	MonitorableUpdates * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
monitorable_updates_unref (gpointer instance)
{
	MonitorableUpdates * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MONITORABLE_UPDATES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
media_monitor_get_instance_private (MediaMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, MediaMonitor_private_offset);
}

static void
_media_monitor_on_media_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                           DataSource* source,
                                                                           gpointer self)
{
	media_monitor_on_media_source_destroyed ((MediaMonitor*) self, source);
}

static void
_media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                               DataSource* source,
                                                                               gpointer self)
{
	media_monitor_on_media_source_destroyed ((MediaMonitor*) self, source);
}

static GType
media_monitor_discovered_file_get_type_once (void)
{
	static const GEnumValue values[] = {{MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED, "MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED", "represented"}, {MEDIA_MONITOR_DISCOVERED_FILE_IGNORE, "MEDIA_MONITOR_DISCOVERED_FILE_IGNORE", "ignore"}, {MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN, "MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType media_monitor_discovered_file_type_id;
	media_monitor_discovered_file_type_id = g_enum_register_static ("MediaMonitorDiscoveredFile", values);
	return media_monitor_discovered_file_type_id;
}

GType
media_monitor_discovered_file_get_type (void)
{
	static volatile gsize media_monitor_discovered_file_type_id__once = 0;
	if (g_once_init_enter (&media_monitor_discovered_file_type_id__once)) {
		GType media_monitor_discovered_file_type_id;
		media_monitor_discovered_file_type_id = media_monitor_discovered_file_get_type_once ();
		g_once_init_leave (&media_monitor_discovered_file_type_id__once, media_monitor_discovered_file_type_id);
	}
	return media_monitor_discovered_file_type_id__once;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static gboolean
_media_monitor_on_flush_pending_updates_gsource_func (gpointer self)
{
	gboolean result;
	result = media_monitor_on_flush_pending_updates ((MediaMonitor*) self);
	return result;
}

MediaMonitor*
media_monitor_construct (GType object_type,
                         MediaSourceCollection* sources,
                         GCancellable* cancellable)
{
	MediaMonitor * self = NULL;
	MediaSourceCollection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (MediaMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_SOURCE_COLLECTION, SourceCollection), "item-destroyed", (GCallback) _media_monitor_on_media_source_destroyed_source_collection_item_destroyed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_SOURCE_COLLECTION, SourceCollection), "unlinked-destroyed", (GCallback) _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed, self, 0);
	self->priv->pending_updates_timer_id = g_timeout_add_full (G_PRIORITY_LOW, (guint) MEDIA_MONITOR_FLUSH_PENDING_UPDATES_MSEC, _media_monitor_on_flush_pending_updates_gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

static MediaSourceCollection*
media_monitor_real_get_media_source_collection (MediaMonitor* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_monitor_get_media_source_collection'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MediaSourceCollection*
media_monitor_get_media_source_collection (MediaMonitor* self)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->get_media_source_collection) {
		return _klass_->get_media_source_collection (self);
	}
	return NULL;
}

static void
media_monitor_real_close (MediaMonitor* self)
{
}

void
media_monitor_close (MediaMonitor* self)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static gchar*
media_monitor_real_to_string (MediaMonitor* self)
{
	MediaSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = media_monitor_get_media_source_collection (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("MediaMonitor for %s", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_data_collection_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
media_monitor_to_string (MediaMonitor* self)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static MonitorableUpdates*
media_monitor_real_create_updates (MediaMonitor* self,
                                   Monitorable* monitorable)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* result;
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = monitorable_updates_new (monitorable);
	result = _tmp0_;
	return result;
}

MonitorableUpdates*
media_monitor_create_updates (MediaMonitor* self,
                              Monitorable* monitorable)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->create_updates) {
		return _klass_->create_updates (self, monitorable);
	}
	return NULL;
}

static void
media_monitor_real_on_media_source_destroyed (MediaMonitor* self,
                                              DataSource* source)
{
	g_return_if_fail (IS_DATA_SOURCE (source));
	media_monitor_remove_updates (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MONITORABLE, Monitorable));
}

void
media_monitor_on_media_source_destroyed (MediaMonitor* self,
                                         DataSource* source)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->on_media_source_destroyed) {
		_klass_->on_media_source_destroyed (self, source);
	}
}

static void
media_monitor_real_notify_discovery_started (MediaMonitor* self)
{
}

void
media_monitor_notify_discovery_started (MediaMonitor* self)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_discovery_started) {
		_klass_->notify_discovery_started (self);
	}
}

static MediaMonitorDiscoveredFile
media_monitor_real_notify_file_discovered (MediaMonitor* self,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable** monitorable)
{
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_discovered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

MediaMonitorDiscoveredFile
media_monitor_notify_file_discovered (MediaMonitor* self,
                                      GFile* file,
                                      GFileInfo* info,
                                      Monitorable** monitorable)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), 0);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_discovered) {
		return _klass_->notify_file_discovered (self, file, info, monitorable);
	}
	return 0;
}

static GeeCollection*
media_monitor_real_candidates_for_unknown_file (MediaMonitor* self,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	g_critical ("Type `%s' does not implement abstract method `media_monitor_candidates_for_unknown_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
media_monitor_candidates_for_unknown_file (MediaMonitor* self,
                                           GFile* file,
                                           GFileInfo* info,
                                           MediaMonitorDiscoveredFile* _result_)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->candidates_for_unknown_file) {
		return _klass_->candidates_for_unknown_file (self, file, info, _result_);
	}
	return NULL;
}

static GFile**
media_monitor_real_get_auxilliary_backing_files (MediaMonitor* self,
                                                 Monitorable* monitorable,
                                                 gint* result_length1)
{
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** result;
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}

GFile**
media_monitor_get_auxilliary_backing_files (MediaMonitor* self,
                                            Monitorable* monitorable,
                                            gint* result_length1)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->get_auxilliary_backing_files) {
		return _klass_->get_auxilliary_backing_files (self, monitorable, result_length1);
	}
	return NULL;
}

static void
media_monitor_real_update_backing_file_info (MediaMonitor* self,
                                             Monitorable* monitorable,
                                             GFile* file,
                                             GFileInfo* info)
{
	g_return_if_fail (IS_MONITORABLE (monitorable));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

void
media_monitor_update_backing_file_info (MediaMonitor* self,
                                        Monitorable* monitorable,
                                        GFile* file,
                                        GFileInfo* info)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->update_backing_file_info) {
		_klass_->update_backing_file_info (self, monitorable, file, info);
	}
}

static void
media_monitor_real_notify_discovery_completing (MediaMonitor* self)
{
}

void
media_monitor_notify_discovery_completing (MediaMonitor* self)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_discovery_completing) {
		_klass_->notify_discovery_completing (self);
	}
}

static gboolean
media_monitor_real_is_file_represented (MediaMonitor* self,
                                        GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_is_file_represented'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_is_file_represented (MediaMonitor* self,
                                   GFile* file)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->is_file_represented) {
		return _klass_->is_file_represented (self, file);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_created (MediaMonitor* self,
                                        GFile* file,
                                        GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_created'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_created (MediaMonitor* self,
                                   GFile* file,
                                   GFileInfo* info)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_created) {
		return _klass_->notify_file_created (self, file, info);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_moved (MediaMonitor* self,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* new_file_info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_moved'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_moved (MediaMonitor* self,
                                 GFile* old_file,
                                 GFile* new_file,
                                 GFileInfo* new_file_info)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_moved) {
		return _klass_->notify_file_moved (self, old_file, new_file, new_file_info);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_altered (MediaMonitor* self,
                                        GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_altered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_altered (MediaMonitor* self,
                                   GFile* file)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_altered) {
		return _klass_->notify_file_altered (self, file);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_attributes_altered (MediaMonitor* self,
                                                   GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_attributes_altered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_attributes_altered (MediaMonitor* self,
                                              GFile* file)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_attributes_altered) {
		return _klass_->notify_file_attributes_altered (self, file);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_alteration_completed (MediaMonitor* self,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_alteration_completed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_alteration_completed (MediaMonitor* self,
                                                GFile* file,
                                                GFileInfo* info)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_alteration_completed) {
		return _klass_->notify_file_alteration_completed (self, file, info);
	}
	return FALSE;
}

static gboolean
media_monitor_real_notify_file_deleted (MediaMonitor* self,
                                        GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_deleted'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_monitor_notify_file_deleted (MediaMonitor* self,
                                   GFile* file)
{
	MediaMonitorClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_deleted) {
		return _klass_->notify_file_deleted (self, file);
	}
	return FALSE;
}

void
media_monitor_mdbg (const gchar* msg)
{
	g_return_if_fail (msg != NULL);
}

gboolean
media_monitor_has_pending_updates (MediaMonitor* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_tmp0_ = self->priv->pending_updates;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

GeeCollection*
media_monitor_get_monitorables (MediaMonitor* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	_tmp0_ = self->priv->pending_updates;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

MonitorableUpdates*
media_monitor_fetch_updates (MediaMonitor* self,
                             Monitorable* monitorable)
{
	MonitorableUpdates* updates = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MonitorableUpdates* _tmp2_;
	MonitorableUpdates* _tmp3_;
	GeeHashMap* _tmp4_;
	MonitorableUpdates* _tmp5_;
	MonitorableUpdates* result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = self->priv->pending_updates;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), monitorable);
	updates = (MonitorableUpdates*) _tmp1_;
	_tmp2_ = updates;
	if (_tmp2_ != NULL) {
		result = updates;
		return result;
	}
	_tmp3_ = media_monitor_create_updates (self, monitorable);
	_monitorable_updates_unref0 (updates);
	updates = _tmp3_;
	_tmp4_ = self->priv->pending_updates;
	_tmp5_ = updates;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), monitorable, _tmp5_);
	result = updates;
	return result;
}

MonitorableUpdates*
media_monitor_get_existing_updates (MediaMonitor* self,
                                    Monitorable* monitorable)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MonitorableUpdates* result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = self->priv->pending_updates;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), monitorable);
	result = (MonitorableUpdates*) _tmp1_;
	return result;
}

void
media_monitor_remove_updates (MediaMonitor* self,
                              Monitorable* monitorable)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	_tmp0_ = self->priv->pending_updates;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), monitorable, NULL);
}

gboolean
media_monitor_is_online (MediaMonitor* self,
                         Monitorable* monitorable)
{
	MonitorableUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MonitorableUpdates* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), FALSE);
	_tmp0_ = media_monitor_get_existing_updates (self, monitorable);
	updates = _tmp0_;
	_tmp2_ = updates;
	if (_tmp2_ != NULL) {
		MonitorableUpdates* _tmp3_;
		_tmp3_ = updates;
		_tmp1_ = monitorable_updates_is_set_online (_tmp3_);
	} else {
		_tmp1_ = !monitorable_is_offline (monitorable);
	}
	result = _tmp1_;
	_monitorable_updates_unref0 (updates);
	return result;
}

gboolean
media_monitor_is_offline (MediaMonitor* self,
                          Monitorable* monitorable)
{
	MonitorableUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MonitorableUpdates* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), FALSE);
	_tmp0_ = media_monitor_get_existing_updates (self, monitorable);
	updates = _tmp0_;
	_tmp2_ = updates;
	if (_tmp2_ != NULL) {
		MonitorableUpdates* _tmp3_;
		_tmp3_ = updates;
		_tmp1_ = monitorable_updates_is_set_offline (_tmp3_);
	} else {
		_tmp1_ = monitorable_is_offline (monitorable);
	}
	result = _tmp1_;
	_monitorable_updates_unref0 (updates);
	return result;
}

GFile*
media_monitor_get_master_file (MediaMonitor* self,
                               Monitorable* monitorable)
{
	MonitorableUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MonitorableUpdates* _tmp3_;
	GFile* result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_tmp0_ = media_monitor_get_existing_updates (self, monitorable);
	updates = _tmp0_;
	_tmp3_ = updates;
	if (_tmp3_ != NULL) {
		MonitorableUpdates* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = updates;
		_tmp5_ = monitorable_updates_get_master_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MonitorableUpdates* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = updates;
		_tmp8_ = monitorable_updates_get_master_file (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp8_;
	} else {
		GFile* _tmp9_;
		_tmp9_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_MEDIA_SOURCE, MediaSource));
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp9_;
	}
	result = _tmp1_;
	_monitorable_updates_unref0 (updates);
	return result;
}

void
media_monitor_update_master_file (MediaMonitor* self,
                                  Monitorable* monitorable,
                                  GFile* file)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_set_master_file (_tmp1_, file);
	_monitorable_updates_unref0 (_tmp1_);
}

void
media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                               Monitorable* monitorable)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_set_master_file_info_altered (_tmp1_, TRUE);
	_monitorable_updates_unref0 (_tmp1_);
}

void
media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                Monitorable* monitorable,
                                                gboolean in_alteration)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_set_master_in_alteration (_tmp1_, in_alteration);
	_monitorable_updates_unref0 (_tmp1_);
}

void
media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                        Monitorable* monitorable,
                                                        GFileInfo* info)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_set_master_alterations_complete (_tmp1_, info);
	_monitorable_updates_unref0 (_tmp1_);
}

void
media_monitor_update_online (MediaMonitor* self,
                             Monitorable* monitorable)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_mark_online (_tmp1_);
	_monitorable_updates_unref0 (_tmp1_);
}

void
media_monitor_update_offline (MediaMonitor* self,
                              Monitorable* monitorable)
{
	MonitorableUpdates* _tmp0_;
	MonitorableUpdates* _tmp1_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	g_return_if_fail (IS_MONITORABLE (monitorable));
	_tmp0_ = media_monitor_fetch_updates (self, monitorable);
	_tmp1_ = _tmp0_;
	monitorable_updates_mark_offline (_tmp1_);
	_monitorable_updates_unref0 (_tmp1_);
}

static void
media_monitor_real_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	GeeMap* set_master_file = NULL;
	GeeMap* set_master_file_info = NULL;
	GeeArrayList* to_offline = NULL;
	GeeArrayList* to_online = NULL;
	GeeMap* _tmp48_;
	GeeMap* _tmp57_;
	gboolean _tmp66_ = FALSE;
	GeeArrayList* _tmp67_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (all_updates, GEE_TYPE_COLLECTION));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	set_master_file = NULL;
	set_master_file_info = NULL;
	to_offline = NULL;
	to_online = NULL;
	{
		GeeIterator* _updates_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (all_updates, GEE_TYPE_ITERABLE, GeeIterable));
		_updates_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MonitorableUpdates* updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			MonitorableUpdates* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			gboolean _tmp7_;
			MonitorableUpdates* _tmp18_;
			GFileInfo* _tmp19_;
			GFileInfo* _tmp20_;
			gboolean _tmp21_;
			MonitorableUpdates* _tmp32_;
			MonitorableUpdates* _tmp40_;
			_tmp1_ = _updates_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _updates_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			updates = (MonitorableUpdates*) _tmp3_;
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
				_monitorable_updates_unref0 (updates);
				break;
			}
			_tmp4_ = updates;
			_tmp5_ = monitorable_updates_get_master_file (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_ != NULL;
			_g_object_unref0 (_tmp6_);
			if (_tmp7_) {
				GeeMap* _tmp8_;
				GeeMap* _tmp10_;
				MonitorableUpdates* _tmp11_;
				Monitorable* _tmp12_;
				MonitorableUpdates* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				MonitorableUpdates* _tmp16_;
				gint _tmp17_;
				_tmp8_ = set_master_file;
				if (_tmp8_ == NULL) {
					GeeHashMap* _tmp9_;
					_tmp9_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (set_master_file);
					set_master_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_MAP, GeeMap);
				}
				_tmp10_ = set_master_file;
				_tmp11_ = updates;
				_tmp12_ = _tmp11_->monitorable;
				_tmp13_ = updates;
				_tmp14_ = monitorable_updates_get_master_file (_tmp13_);
				_tmp15_ = _tmp14_;
				gee_map_set (_tmp10_, _tmp12_, _tmp15_);
				_g_object_unref0 (_tmp15_);
				_tmp16_ = updates;
				monitorable_updates_set_master_file (_tmp16_, NULL);
				_tmp17_ = *op_count;
				*op_count = _tmp17_ + 1;
			}
			_tmp18_ = updates;
			_tmp19_ = monitorable_updates_get_master_file_info (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_ != NULL;
			_g_object_unref0 (_tmp20_);
			if (_tmp21_) {
				GeeMap* _tmp22_;
				GeeMap* _tmp24_;
				MonitorableUpdates* _tmp25_;
				Monitorable* _tmp26_;
				MonitorableUpdates* _tmp27_;
				GFileInfo* _tmp28_;
				GFileInfo* _tmp29_;
				MonitorableUpdates* _tmp30_;
				gint _tmp31_;
				_tmp22_ = set_master_file_info;
				if (_tmp22_ == NULL) {
					GeeHashMap* _tmp23_;
					_tmp23_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (set_master_file_info);
					set_master_file_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_MAP, GeeMap);
				}
				_tmp24_ = set_master_file_info;
				_tmp25_ = updates;
				_tmp26_ = _tmp25_->monitorable;
				_tmp27_ = updates;
				_tmp28_ = monitorable_updates_get_master_file_info (_tmp27_);
				_tmp29_ = _tmp28_;
				gee_map_set (_tmp24_, _tmp26_, _tmp29_);
				_g_object_unref0 (_tmp29_);
				_tmp30_ = updates;
				monitorable_updates_set_master_file_info (_tmp30_, NULL);
				_tmp31_ = *op_count;
				*op_count = _tmp31_ + 1;
			}
			_tmp32_ = updates;
			if (monitorable_updates_is_set_offline (_tmp32_)) {
				GeeArrayList* _tmp33_;
				GeeArrayList* _tmp35_;
				MonitorableUpdates* _tmp36_;
				Monitorable* _tmp37_;
				MonitorableUpdates* _tmp38_;
				gint _tmp39_;
				_tmp33_ = to_offline;
				if (_tmp33_ == NULL) {
					GeeArrayList* _tmp34_;
					_tmp34_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_offline);
					to_offline = _tmp34_;
				}
				_tmp35_ = to_offline;
				_tmp36_ = updates;
				_tmp37_ = _tmp36_->monitorable;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp37_);
				_tmp38_ = updates;
				monitorable_updates_reset_online_offline (_tmp38_);
				_tmp39_ = *op_count;
				*op_count = _tmp39_ + 1;
			}
			_tmp40_ = updates;
			if (monitorable_updates_is_set_online (_tmp40_)) {
				GeeArrayList* _tmp41_;
				GeeArrayList* _tmp43_;
				MonitorableUpdates* _tmp44_;
				Monitorable* _tmp45_;
				MonitorableUpdates* _tmp46_;
				gint _tmp47_;
				_tmp41_ = to_online;
				if (_tmp41_ == NULL) {
					GeeArrayList* _tmp42_;
					_tmp42_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_online);
					to_online = _tmp42_;
				}
				_tmp43_ = to_online;
				_tmp44_ = updates;
				_tmp45_ = _tmp44_->monitorable;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp45_);
				_tmp46_ = updates;
				monitorable_updates_reset_online_offline (_tmp46_);
				_tmp47_ = *op_count;
				*op_count = _tmp47_ + 1;
			}
			_monitorable_updates_unref0 (updates);
		}
		_g_object_unref0 (_updates_it);
	}
	_tmp48_ = set_master_file;
	if (_tmp48_ != NULL) {
		GeeMap* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GeeMap* _tmp56_;
		_tmp49_ = set_master_file;
		_tmp50_ = gee_map_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = media_monitor_to_string (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf ("Changing master file of %d objects in %s", _tmp51_, _tmp53_);
		_tmp55_ = _tmp54_;
		media_monitor_mdbg (_tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_tmp56_ = set_master_file;
		monitorable_set_many_master_file (_tmp56_, controller, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (to_online);
			_g_object_unref0 (to_offline);
			_g_object_unref0 (set_master_file_info);
			_g_object_unref0 (set_master_file);
			return;
		}
	}
	_tmp57_ = set_master_file_info;
	if (_tmp57_ != NULL) {
		GeeMap* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		GeeMap* _tmp65_;
		_tmp58_ = set_master_file_info;
		_tmp59_ = gee_map_get_size (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = media_monitor_to_string (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strdup_printf ("Updating %d master files timestamps in %s", _tmp60_, _tmp62_);
		_tmp64_ = _tmp63_;
		media_monitor_mdbg (_tmp64_);
		_g_free0 (_tmp64_);
		_g_free0 (_tmp62_);
		_tmp65_ = set_master_file_info;
		monitorable_set_many_master_timestamp (_tmp65_, controller, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (to_online);
			_g_object_unref0 (to_offline);
			_g_object_unref0 (set_master_file_info);
			_g_object_unref0 (set_master_file);
			return;
		}
	}
	_tmp67_ = to_offline;
	if (_tmp67_ != NULL) {
		_tmp66_ = TRUE;
	} else {
		GeeArrayList* _tmp68_;
		_tmp68_ = to_online;
		_tmp66_ = _tmp68_ != NULL;
	}
	if (_tmp66_) {
		gint _tmp69_ = 0;
		GeeArrayList* _tmp70_;
		gint _tmp74_ = 0;
		GeeArrayList* _tmp75_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		GeeArrayList* _tmp83_;
		GeeArrayList* _tmp84_;
		_tmp70_ = to_online;
		if (_tmp70_ != NULL) {
			GeeArrayList* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			_tmp71_ = to_online;
			_tmp72_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp73_ = _tmp72_;
			_tmp69_ = _tmp73_;
		} else {
			_tmp69_ = 0;
		}
		_tmp75_ = to_offline;
		if (_tmp75_ != NULL) {
			GeeArrayList* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			_tmp76_ = to_offline;
			_tmp77_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp78_ = _tmp77_;
			_tmp74_ = _tmp78_;
		} else {
			_tmp74_ = 0;
		}
		_tmp79_ = media_monitor_to_string (self);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strdup_printf ("Marking %d online, %d offline in %s", _tmp69_, _tmp74_, _tmp80_);
		_tmp82_ = _tmp81_;
		media_monitor_mdbg (_tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
		_tmp83_ = to_online;
		_tmp84_ = to_offline;
		monitorable_mark_many_online_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GEE_TYPE_COLLECTION, GeeCollection), controller, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (to_online);
			_g_object_unref0 (to_offline);
			_g_object_unref0 (set_master_file_info);
			_g_object_unref0 (set_master_file);
			return;
		}
	}
	_g_object_unref0 (to_online);
	_g_object_unref0 (to_offline);
	_g_object_unref0 (set_master_file_info);
	_g_object_unref0 (set_master_file);
}

void
media_monitor_process_updates (MediaMonitor* self,
                               GeeCollection* all_updates,
                               TransactionController* controller,
                               gint* op_count,
                               GError** error)
{
	MediaMonitorClass* _klass_;
	g_return_if_fail (IS_MEDIA_MONITOR (self));
	_klass_ = MEDIA_MONITOR_GET_CLASS (self);
	if (_klass_->process_updates) {
		_klass_->process_updates (self, all_updates, controller, op_count, error);
	}
}

static gpointer
_transaction_controller_ref0 (gpointer self)
{
	return self ? transaction_controller_ref (self) : NULL;
}

static gboolean
media_monitor_on_flush_pending_updates (MediaMonitor* self)
{
	GCancellable* _tmp0_;
	GeeHashMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GTimer* timer = NULL;
	GTimer* _tmp4_;
	GeeArrayList* to_process = NULL;
	GeeArrayList* to_remove = NULL;
	gint op_count = 0;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp43_;
	gdouble elapsed = 0.0;
	GTimer* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
	_tmp0_ = self->priv->cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->pending_updates;
	_tmp2_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp4_ = g_timer_new ();
	timer = _tmp4_;
	to_process = NULL;
	to_remove = NULL;
	{
		GeeIterator* _updates_it = NULL;
		GeeHashMap* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp5_ = self->priv->pending_updates;
		_tmp6_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_updates_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			MonitorableUpdates* updates = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			MonitorableUpdates* _tmp14_;
			MonitorableUpdates* _tmp15_;
			GeeArrayList* _tmp21_;
			GeeArrayList* _tmp23_;
			MonitorableUpdates* _tmp24_;
			_tmp11_ = _updates_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _updates_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			updates = (MonitorableUpdates*) _tmp13_;
			_tmp14_ = updates;
			if (monitorable_updates_is_in_alteration (_tmp14_)) {
				_monitorable_updates_unref0 (updates);
				continue;
			}
			_tmp15_ = updates;
			if (monitorable_updates_is_all_updated (_tmp15_)) {
				GeeArrayList* _tmp16_;
				GeeArrayList* _tmp18_;
				MonitorableUpdates* _tmp19_;
				Monitorable* _tmp20_;
				_tmp16_ = to_remove;
				if (_tmp16_ == NULL) {
					GeeArrayList* _tmp17_;
					_tmp17_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_remove);
					to_remove = _tmp17_;
				}
				_tmp18_ = to_remove;
				_tmp19_ = updates;
				_tmp20_ = _tmp19_->monitorable;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_);
				_monitorable_updates_unref0 (updates);
				continue;
			}
			_tmp21_ = to_process;
			if (_tmp21_ == NULL) {
				GeeArrayList* _tmp22_;
				_tmp22_ = gee_array_list_new (TYPE_MONITORABLE_UPDATES, (GBoxedCopyFunc) monitorable_updates_ref, (GDestroyNotify) monitorable_updates_unref, NULL, NULL, NULL);
				_g_object_unref0 (to_process);
				to_process = _tmp22_;
			}
			_tmp23_ = to_process;
			_tmp24_ = updates;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
			_monitorable_updates_unref0 (updates);
		}
		_g_object_unref0 (_updates_it);
	}
	op_count = 0;
	_tmp25_ = to_process;
	if (_tmp25_ != NULL) {
		TransactionController* controller = NULL;
		MediaSourceCollection* _tmp26_;
		MediaSourceCollection* _tmp27_;
		TransactionController* _tmp28_;
		TransactionController* _tmp29_;
		TransactionController* _tmp30_;
		TransactionController* _tmp31_;
		_tmp26_ = media_monitor_get_media_source_collection (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = media_source_collection_get_transaction_controller (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _transaction_controller_ref0 (_tmp29_);
		_tmp31_ = _tmp30_;
		_data_collection_unref0 (_tmp27_);
		controller = _tmp31_;
		{
			TransactionController* _tmp32_;
			GeeArrayList* _tmp33_;
			TransactionController* _tmp34_;
			TransactionController* _tmp35_;
			_tmp32_ = controller;
			transaction_controller_begin (_tmp32_);
			_tmp33_ = to_process;
			_tmp34_ = controller;
			media_monitor_process_updates (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection), _tmp34_, &op_count, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp35_ = controller;
			transaction_controller_commit (_tmp35_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp36_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp36_ = err;
			if (_tmp36_->domain == DATABASE_ERROR) {
				GError* _tmp37_;
				_tmp37_ = err;
				app_window_database_error ((GError*) _tmp37_);
			} else {
				GError* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp38_ = err;
				_tmp39_ = _tmp38_->message;
				_tmp40_ = g_strdup_printf (_ ("Unable to process monitoring updates: %s"), _tmp39_);
				_tmp41_ = _tmp40_;
				app_window_panic (_tmp41_);
				_g_free0 (_tmp41_);
			}
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp42_ = FALSE;
			_transaction_controller_unref0 (controller);
			_g_object_unref0 (to_remove);
			_g_object_unref0 (to_process);
			_g_timer_destroy0 (timer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp42_;
		}
		_transaction_controller_unref0 (controller);
	}
	_tmp43_ = to_remove;
	if (_tmp43_ != NULL) {
		{
			GeeArrayList* _monitorable_list = NULL;
			GeeArrayList* _tmp44_;
			gint _monitorable_size = 0;
			GeeArrayList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _monitorable_index = 0;
			_tmp44_ = to_remove;
			_monitorable_list = _tmp44_;
			_tmp45_ = _monitorable_list;
			_tmp46_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp47_ = _tmp46_;
			_monitorable_size = _tmp47_;
			_monitorable_index = -1;
			while (TRUE) {
				gint _tmp48_;
				gint _tmp49_;
				Monitorable* monitorable = NULL;
				GeeArrayList* _tmp50_;
				gpointer _tmp51_;
				Monitorable* _tmp52_;
				_monitorable_index = _monitorable_index + 1;
				_tmp48_ = _monitorable_index;
				_tmp49_ = _monitorable_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _monitorable_list;
				_tmp51_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _monitorable_index);
				monitorable = (Monitorable*) _tmp51_;
				_tmp52_ = monitorable;
				media_monitor_remove_updates (self, _tmp52_);
				_g_object_unref0 (monitorable);
			}
		}
	}
	_tmp53_ = timer;
	elapsed = g_timer_elapsed (_tmp53_, NULL);
	if (elapsed > 0.01) {
		_tmp54_ = TRUE;
	} else {
		_tmp54_ = op_count > 0;
	}
	if (_tmp54_) {
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp55_ = media_monitor_to_string (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strdup_printf ("Total pending queue time for %s: %lf (%d ops)", _tmp56_, elapsed, op_count);
		_tmp58_ = _tmp57_;
		media_monitor_mdbg (_tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
	}
	result = TRUE;
	_g_object_unref0 (to_remove);
	_g_object_unref0 (to_process);
	_g_timer_destroy0 (timer);
	return result;
}

static void
media_monitor_class_init (MediaMonitorClass * klass,
                          gpointer klass_data)
{
	media_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MediaMonitor_private_offset);
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor*)) media_monitor_real_get_media_source_collection;
	((MediaMonitorClass *) klass)->close = (void (*) (MediaMonitor*)) media_monitor_real_close;
	((MediaMonitorClass *) klass)->to_string = (gchar* (*) (MediaMonitor*)) media_monitor_real_to_string;
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor*, Monitorable*)) media_monitor_real_create_updates;
	((MediaMonitorClass *) klass)->on_media_source_destroyed = (void (*) (MediaMonitor*, DataSource*)) media_monitor_real_on_media_source_destroyed;
	((MediaMonitorClass *) klass)->notify_discovery_started = (void (*) (MediaMonitor*)) media_monitor_real_notify_discovery_started;
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor*, GFile*, GFileInfo*, Monitorable**)) media_monitor_real_notify_file_discovered;
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor*, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) media_monitor_real_candidates_for_unknown_file;
	((MediaMonitorClass *) klass)->get_auxilliary_backing_files = (GFile** (*) (MediaMonitor*, Monitorable*, gint*)) media_monitor_real_get_auxilliary_backing_files;
	((MediaMonitorClass *) klass)->update_backing_file_info = (void (*) (MediaMonitor*, Monitorable*, GFile*, GFileInfo*)) media_monitor_real_update_backing_file_info;
	((MediaMonitorClass *) klass)->notify_discovery_completing = (void (*) (MediaMonitor*)) media_monitor_real_notify_discovery_completing;
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor*, GFile*)) media_monitor_real_is_file_represented;
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) media_monitor_real_notify_file_created;
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor*, GFile*, GFile*, GFileInfo*)) media_monitor_real_notify_file_moved;
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor*, GFile*)) media_monitor_real_notify_file_altered;
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor*, GFile*)) media_monitor_real_notify_file_attributes_altered;
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) media_monitor_real_notify_file_alteration_completed;
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor*, GFile*)) media_monitor_real_notify_file_deleted;
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor*, GeeCollection*, TransactionController*, gint*, GError**)) media_monitor_real_process_updates;
	G_OBJECT_CLASS (klass)->finalize = media_monitor_finalize;
}

static void
media_monitor_instance_init (MediaMonitor * self,
                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = media_monitor_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MONITORABLE_UPDATES, (GBoxedCopyFunc) monitorable_updates_ref, (GDestroyNotify) monitorable_updates_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pending_updates = _tmp0_;
	self->priv->pending_updates_timer_id = (guint) 0;
}

static void
media_monitor_finalize (GObject * obj)
{
	MediaMonitor * self;
	MediaSourceCollection* _tmp0_;
	guint _tmp1_;
	MediaSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_MONITOR, MediaMonitor);
	_tmp0_ = self->priv->sources;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _media_monitor_on_media_source_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = self->priv->sources;
	g_signal_parse_name ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed, self);
	_data_collection_unref0 (self->priv->sources);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->pending_updates);
	G_OBJECT_CLASS (media_monitor_parent_class)->finalize (obj);
}

static GType
media_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaMonitor), 0, (GInstanceInitFunc) media_monitor_instance_init, NULL };
	GType media_monitor_type_id;
	media_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaMonitor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MediaMonitor_private_offset = g_type_add_instance_private (media_monitor_type_id, sizeof (MediaMonitorPrivate));
	return media_monitor_type_id;
}

GType
media_monitor_get_type (void)
{
	static volatile gsize media_monitor_type_id__once = 0;
	if (g_once_init_enter (&media_monitor_type_id__once)) {
		GType media_monitor_type_id;
		media_monitor_type_id = media_monitor_get_type_once ();
		g_once_init_leave (&media_monitor_type_id__once, media_monitor_type_id);
	}
	return media_monitor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

