/* MediaDataRepresentation.c generated by valac 0.56.17, the Vala compiler
 * generated from MediaDataRepresentation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>

#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
#define EVENT_ID_INVALID ((gint64) -1)
#define MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC 1000
#define PHOTO_TYPENAME "thumb"
#define IMPORT_ID_INVALID ((gint64) 0)
#define VIDEO_TYPENAME "video"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef struct _BackingFileStatePrivate BackingFileStatePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef struct _ParamSpecBackingFileState ParamSpecBackingFileState;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
enum  {
	MEDIA_SOURCE_0_PROPERTY,
	MEDIA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* media_source_properties[MEDIA_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
enum  {
	MEDIA_SOURCE_MASTER_REPLACED_SIGNAL,
	MEDIA_SOURCE_NUM_SIGNALS
};
static guint media_source_signals[MEDIA_SOURCE_NUM_SIGNALS] = {0};
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, gpointer user_data);
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);
typedef struct _TransactionControllerPrivate TransactionControllerPrivate;

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
typedef struct _MediaSourceTransactionControllerPrivate MediaSourceTransactionControllerPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
typedef struct _DataCollectionPrivate DataCollectionPrivate;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _import_id_free0(var) ((var == NULL) ? NULL : (var = (import_id_free (var), NULL)))

#define TYPE_AGGREGATE_PROGRESS_MONITOR (aggregate_progress_monitor_get_type ())
#define AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor))
#define AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))
#define IS_AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define IS_AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define AGGREGATE_PROGRESS_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))

typedef struct _AggregateProgressMonitor AggregateProgressMonitor;
typedef struct _AggregateProgressMonitorClass AggregateProgressMonitorClass;
#define _aggregate_progress_monitor_unref0(var) ((var == NULL) ? NULL : (var = (aggregate_progress_monitor_unref (var), NULL)))
typedef enum  {
	TOMBSTONE_REASON_REMOVED_BY_USER = 0,
	TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE = 1
} TombstoneReason;

#define TOMBSTONE_TYPE_REASON (tombstone_reason_get_type ())
enum  {
	MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL,
	MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_TRASHCAN_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_OFFLINE_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint media_source_collection_signals[MEDIA_SOURCE_COLLECTION_NUM_SIGNALS] = {0};

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
typedef struct _MediaCollectionRegistryPrivate MediaCollectionRegistryPrivate;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;

#define TYPE_LIBRARY_MONITOR (library_monitor_get_type ())
#define LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitor))
#define LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))
#define IS_LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR))
#define IS_LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR))
#define LIBRARY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))

typedef struct _LibraryMonitor LibraryMonitor;
typedef struct _LibraryMonitorClass LibraryMonitorClass;

#define TYPE_LIBRARY_MONITOR_POOL (library_monitor_pool_get_type ())
#define LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool))
#define LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))
#define IS_LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR_POOL))
#define IS_LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR_POOL))
#define LIBRARY_MONITOR_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))

typedef struct _LibraryMonitorPool LibraryMonitorPool;
typedef struct _LibraryMonitorPoolClass LibraryMonitorPoolClass;
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef struct _ParamSpecMediaCollectionRegistry ParamSpecMediaCollectionRegistry;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BackingFileState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingFileStatePrivate * priv;
	gchar* filepath;
	gint64 filesize;
	GDateTime* modification_time;
	gchar* md5;
};

struct _BackingFileStateClass {
	GTypeClass parent_class;
	void (*finalize) (BackingFileState *self);
};

struct _BackingPhotoID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _ParamSpecBackingFileState {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	GDateTime* (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, gint* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	GDateTime* (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _MediaSourcePrivate {
	Event* event;
	gchar* indexable_keywords;
};

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTankPrivate {
	GeeHashMap* master_file_map;
};

struct _TransactionController {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TransactionControllerPrivate * priv;
};

struct _TransactionControllerClass {
	GTypeClass parent_class;
	void (*finalize) (TransactionController *self);
	void (*begin_impl) (TransactionController* self, GError** error);
	void (*commit_impl) (TransactionController* self, GError** error);
};

struct _MediaSourceTransactionController {
	TransactionController parent_instance;
	MediaSourceTransactionControllerPrivate * priv;
};

struct _MediaSourceTransactionControllerClass {
	TransactionControllerClass parent_class;
};

struct _MediaSourceTransactionControllerPrivate {
	MediaSourceCollection* sources;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _MediaSourceCollectionPrivate {
	MediaSourceHoldingTank* trashcan;
	MediaSourceHoldingTank* offline_bin;
	GeeHashMap* by_master_file;
	GeeMultiMap* import_rolls;
	GeeTreeSet* sorted_import_ids;
	GeeSet* flagged;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MediaCollectionRegistry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaCollectionRegistryPrivate * priv;
};

struct _MediaCollectionRegistryClass {
	GTypeClass parent_class;
	void (*finalize) (MediaCollectionRegistry *self);
};

struct _MediaCollectionRegistryPrivate {
	GeeArrayList* all;
	GeeHashMap* by_typename;
};

struct _ParamSpecMediaCollectionRegistry {
	GParamSpec parent_instance;
};

static gpointer backing_file_state_parent_class = NULL;
static gint MediaSource_private_offset;
static gpointer media_source_parent_class = NULL;
VALA_EXTERN EventSourceCollection* event_global;
static IndexableIface * media_source_indexable_parent_iface = NULL;
static gint MediaSourceHoldingTank_private_offset;
static gpointer media_source_holding_tank_parent_class = NULL;
static gint MediaSourceTransactionController_private_offset;
static gpointer media_source_transaction_controller_parent_class = NULL;
static gint MediaSourceCollection_private_offset;
static gpointer media_source_collection_parent_class = NULL;
static gint MediaCollectionRegistry_private_offset;
static gpointer media_collection_registry_parent_class = NULL;
static MediaCollectionRegistry* media_collection_registry_instance;
static MediaCollectionRegistry* media_collection_registry_instance = NULL;
VALA_EXTERN gboolean commandline_options_no_runtime_monitoring;

VALA_EXTERN gpointer backing_file_state_ref (gpointer instance);
VALA_EXTERN void backing_file_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_backing_file_state (const GValue* value);
VALA_EXTERN GType backing_file_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingFileState, backing_file_state_unref)
VALA_EXTERN BackingFileState* backing_file_state_new (const gchar* filepath,
                                          gint64 filesize,
                                          GDateTime* modification_time,
                                          const gchar* md5);
VALA_EXTERN BackingFileState* backing_file_state_construct (GType object_type,
                                                const gchar* filepath,
                                                gint64 filesize,
                                                GDateTime* modification_time,
                                                const gchar* md5);
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
VALA_EXTERN BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row,
                                                         const gchar* md5);
VALA_EXTERN BackingFileState* backing_file_state_construct_from_photo_row (GType object_type,
                                                               BackingPhotoRow* photo_row,
                                                               const gchar* md5);
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GFile* backing_file_state_get_file (BackingFileState* self);
static void backing_file_state_finalize (BackingFileState * obj);
static GType backing_file_state_get_type_once (void);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN void media_source_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file);
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
VALA_EXTERN gboolean media_source_set_event_id (MediaSource* self,
                                    EventID* id);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN guint64 media_source_get_master_filesize (MediaSource* self);
VALA_EXTERN guint64 media_source_get_filesize (MediaSource* self);
VALA_EXTERN GDateTime* media_source_get_timestamp (MediaSource* self);
VALA_EXTERN BackingFileState** media_source_get_backing_files_state (MediaSource* self,
                                                         gint* result_length1);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN void media_source_set_title (MediaSource* self,
                             const gchar* title);
VALA_EXTERN gboolean media_source_set_comment (MediaSource* self,
                                   const gchar* comment);
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN void media_source_set_rating (MediaSource* self,
                              Rating rating);
VALA_EXTERN void media_source_increase_rating (MediaSource* self);
VALA_EXTERN void media_source_decrease_rating (MediaSource* self);
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
VALA_EXTERN gboolean media_source_is_trashed (MediaSource* self);
VALA_EXTERN void media_source_trash (MediaSource* self);
VALA_EXTERN void media_source_untrash (MediaSource* self);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_online (MediaSource* self);
VALA_EXTERN gchar* media_source_get_master_md5 (MediaSource* self);
VALA_EXTERN void media_source_get_event_id (MediaSource* self,
                                EventID* result);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN void media_source_get_import_id (MediaSource* self,
                                 ImportID* result);
VALA_EXTERN MediaSource* media_source_construct (GType object_type,
                                     gint64 object_id);
VALA_EXTERN ThumbnailSource* thumbnail_source_construct (GType object_type,
                                             gint64 object_id);
VALA_EXTERN guint64 media_source_internal_add_flags (guint64 flags,
                                         guint64 selector);
VALA_EXTERN guint64 media_source_internal_remove_flags (guint64 flags,
                                            guint64 selector);
VALA_EXTERN gboolean media_source_internal_is_flag_set (guint64 flags,
                                            guint64 selector);
static void media_source_real_notify_master_replaced (MediaSource* self,
                                               GFile* old_file,
                                               GFile* new_file);
static void media_source_real_notify_altered (DataObject* base,
                                       Alteration* alteration);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
static void media_source_update_indexable_keywords (MediaSource* self);
VALA_EXTERN Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
VALA_EXTERN Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
VALA_EXTERN Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
static void media_source_real_notify_membership_changed (DataObject* base,
                                                  DataCollection* collection);
VALA_EXTERN gchar* indexable_prepare_indexable_strings (gchar** strs,
                                            gint strs_length1);
static const gchar* media_source_real_get_indexable_keywords (Indexable* base);
static gboolean media_source_real_set_event_id (MediaSource* self,
                                         EventID* id);
VALA_EXTERN gboolean media_source_delete_original_file (MediaSource* self);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
VALA_EXTERN gboolean query_is_directory_empty (GFile* dir,
                                   GError** error);
static gchar* media_source_real_get_name (DataObject* base);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
static gchar* media_source_real_get_basename (MediaSource* self);
static GFile* media_source_real_get_file (MediaSource* self);
static GFile* media_source_real_get_master_file (MediaSource* self);
static guint64 media_source_real_get_master_filesize (MediaSource* self);
static guint64 media_source_real_get_filesize (MediaSource* self);
static GDateTime* media_source_real_get_timestamp (MediaSource* self);
static BackingFileState** media_source_real_get_backing_files_state (MediaSource* self,
                                                              gint* result_length1);
static gchar* media_source_real_get_title (MediaSource* self);
static gchar* media_source_real_get_comment (MediaSource* self);
static void media_source_real_set_title (MediaSource* self,
                                  const gchar* title);
static gboolean media_source_real_set_comment (MediaSource* self,
                                        const gchar* comment);
VALA_EXTERN gchar* media_source_prep_title (const gchar* title);
VALA_EXTERN GType prepare_input_text_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
VALA_EXTERN gchar* media_source_prep_comment (const gchar* comment);
static Rating media_source_real_get_rating (MediaSource* self);
static void media_source_real_set_rating (MediaSource* self,
                                   Rating rating);
static void media_source_real_increase_rating (MediaSource* self);
static void media_source_real_decrease_rating (MediaSource* self);
static void media_source_real_get_dimensions (MediaSource* self,
                                       PhotoException disallowed_steps,
                                       Dimensions* result);
static GdkPixbuf* media_source_real_get_preview_pixbuf (MediaSource* self,
                                                 Scaling* scaling,
                                                 GError** error);
static gboolean media_source_real_is_trashed (MediaSource* self);
static void media_source_real_trash (MediaSource* self);
static void media_source_real_untrash (MediaSource* self);
static gboolean media_source_real_is_offline (MediaSource* self);
static void media_source_real_mark_offline (MediaSource* self);
static void media_source_real_mark_online (MediaSource* self);
static gchar* media_source_real_get_master_md5 (MediaSource* self);
static void media_source_real_get_event_id (MediaSource* self,
                                     EventID* result);
VALA_EXTERN Event* media_source_get_event (MediaSource* self);
VALA_EXTERN gboolean event_id_is_valid (EventID *self);
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType event_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSourceCollection, data_collection_unref)
VALA_EXTERN Event* event_source_collection_fetch (EventSourceCollection* self,
                                      EventID* event_id);
VALA_EXTERN gboolean media_source_set_event (MediaSource* self,
                                 Event* new_event);
VALA_EXTERN void event_get_event_id (Event* self,
                         EventID* result);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN void event_detach (Event* self,
                   MediaSource* source);
VALA_EXTERN void event_attach (Event* self,
                   MediaSource* source);
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN void media_source_set_many_to_event (GeeCollection* media_sources,
                                     Event* event,
                                     TransactionController* controller,
                                     GError** error);
VALA_EXTERN void transaction_controller_begin (TransactionController* self);
VALA_EXTERN void event_attach_many (Event* self,
                        GeeCollection* media);
VALA_EXTERN void transaction_controller_commit (TransactionController* self);
static GDateTime* media_source_real_get_exposure_time (MediaSource* self);
static void media_source_real_get_import_id (MediaSource* self,
                                      ImportID* result);
static void media_source_real_master_replaced (MediaSource* self,
                                        GFile* old_file,
                                        GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
VALA_EXTERN const gchar* indexable_get_indexable_keywords (Indexable* self);
static void media_source_finalize (GObject * obj);
static GType media_source_get_type_once (void);
VALA_EXTERN GType database_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType media_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN void source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed);
VALA_EXTERN guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
VALA_EXTERN gboolean file_equal (GFile* a,
                     GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources,
                                                       SourceHoldingTankCheckToKeep check_to_keep,
                                                       gpointer check_to_keep_target,
                                                       GetSourceDatabaseKey get_key,
                                                       gpointer get_key_target);
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type,
                                                             MediaSourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             gpointer check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             gpointer get_key_target);
VALA_EXTERN DatabaseSourceHoldingTank* database_source_holding_tank_new (SourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             gpointer check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             gpointer get_key_target);
VALA_EXTERN DatabaseSourceHoldingTank* database_source_holding_tank_construct (GType object_type,
                                                                   SourceCollection* sources,
                                                                   SourceHoldingTankCheckToKeep check_to_keep,
                                                                   gpointer check_to_keep_target,
                                                                   GetSourceDatabaseKey get_key,
                                                                   gpointer get_key_target);
VALA_EXTERN MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                             GFile* file);
VALA_EXTERN MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self,
                                                     const gchar* md5);
static void media_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                             GeeCollection* added,
                                                             GeeCollection* removed);
static void media_source_holding_tank_on_master_source_replaced (MediaSourceHoldingTank* self,
                                                          MediaSource* media_source,
                                                          GFile* old_file,
                                                          GFile* new_file);
static void _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced (MediaSource* _sender,
                                                                                        GFile* old_file,
                                                                                        GFile* new_file,
                                                                                        gpointer self);
static void media_source_holding_tank_finalize (SourceHoldingTank * obj);
static GType media_source_holding_tank_get_type_once (void);
VALA_EXTERN GType media_source_transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceTransactionController, transaction_controller_unref)
VALA_EXTERN void transaction_controller_begin_impl (TransactionController* self,
                                        GError** error);
VALA_EXTERN void transaction_controller_commit_impl (TransactionController* self,
                                         GError** error);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type,
                                                                                 MediaSourceCollection* sources);
VALA_EXTERN TransactionController* transaction_controller_construct (GType object_type);
static void media_source_transaction_controller_real_begin_impl (TransactionController* base,
                                                          GError** error);
VALA_EXTERN void database_table_begin_transaction (void);
VALA_EXTERN void data_collection_freeze_notifications (DataCollection* self);
static void media_source_transaction_controller_real_commit_impl (TransactionController* base,
                                                           GError** error);
VALA_EXTERN void data_collection_thaw_notifications (DataCollection* self);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void database_table_commit_transaction (GError** error);
static void media_source_transaction_controller_finalize (TransactionController * obj);
static GType media_source_transaction_controller_get_type_once (void);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_trashcan (MediaSourceCollection* self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_offline_bin (MediaSourceCollection* self);
VALA_EXTERN MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self,
                                                            Workers* workers,
                                                            GCancellable* cancellable);
VALA_EXTERN gchar* media_source_collection_get_typename (MediaSourceCollection* self);
VALA_EXTERN gboolean media_source_collection_is_file_recognized (MediaSourceCollection* self,
                                                     GFile* file);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self,
                                                          gint64 numeric_id);
VALA_EXTERN void media_source_collection_notify_import_roll_altered (MediaSourceCollection* self);
VALA_EXTERN void media_source_collection_notify_flagged_contents_altered (MediaSourceCollection* self);
VALA_EXTERN void media_source_collection_notify_media_import_starting (MediaSourceCollection* self,
                                                           GeeCollection* media);
VALA_EXTERN void media_source_collection_notify_media_import_completed (MediaSourceCollection* self,
                                                            GeeCollection* media);
VALA_EXTERN void data_collection_items_altered (DataCollection* self,
                                    GeeMap* items);
VALA_EXTERN void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_source_id (MediaSourceCollection* self,
                                                         const gchar* source_id);
VALA_EXTERN GeeCollection* media_source_collection_get_event_source_ids (MediaSourceCollection* self,
                                                             EventID* event_id);
VALA_EXTERN void media_source_collection_import_many (MediaSourceCollection* self,
                                          GeeCollection* media);
VALA_EXTERN void media_source_collection_postprocess_imported_media (MediaSourceCollection* self,
                                                         GeeCollection* media);
VALA_EXTERN gint import_id_compare_func (ImportID* a,
                             ImportID* b);
static gint _import_id_compare_func_gcompare_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self);
VALA_EXTERN MediaSourceCollection* media_source_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          GetSourceDatabaseKey source_key_func,
                                                          gpointer source_key_func_target);
VALA_EXTERN DatabaseSourceCollection* database_source_collection_construct (GType object_type,
                                                                const gchar* name,
                                                                GetSourceDatabaseKey source_key_func,
                                                                gpointer source_key_func_target);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN void media_source_collection_filter_media (GeeCollection* media,
                                           GeeCollection* photos,
                                           GeeCollection* videos);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN void media_source_collection_count_media (GeeCollection* media,
                                          gint* photo_count,
                                          gint* video_count);
VALA_EXTERN gboolean media_source_collection_has_photo (GeeCollection* media);
VALA_EXTERN gboolean media_source_collection_has_video (GeeCollection* media);
static MediaSourceHoldingTank* media_source_collection_real_create_trashcan (MediaSourceCollection* self);
static MediaSourceHoldingTank* media_source_collection_real_create_offline_bin (MediaSourceCollection* self);
static MediaMonitor* media_source_collection_real_create_media_monitor (MediaSourceCollection* self,
                                                                 Workers* workers,
                                                                 GCancellable* cancellable);
static gchar* media_source_collection_real_get_typename (MediaSourceCollection* self);
static gboolean media_source_collection_real_is_file_recognized (MediaSourceCollection* self,
                                                          GFile* file);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static MediaSource* media_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* self,
                                                               gint64 numeric_id);
static void media_source_collection_real_notify_import_roll_altered (MediaSourceCollection* self);
static void media_source_collection_real_notify_flagged_contents_altered (MediaSourceCollection* self);
static void media_source_collection_real_notify_media_import_starting (MediaSourceCollection* self,
                                                                GeeCollection* media);
static void media_source_collection_real_notify_media_import_completed (MediaSourceCollection* self,
                                                                 GeeCollection* media);
static void media_source_collection_real_items_altered (DataCollection* base,
                                                 GeeMap* items);
VALA_EXTERN gboolean alteration_has_subject (Alteration* self,
                                 const gchar* subject);
VALA_EXTERN gboolean source_holding_tank_contains (SourceHoldingTank* self,
                                       DataSource* source);
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
VALA_EXTERN void source_holding_tank_unlink_and_hold (SourceHoldingTank* self,
                                          GeeCollection* unlink);
static void media_source_collection_real_notify_contents_altered (DataCollection* base,
                                                           GeeIterable* added,
                                                           GeeIterable* removed);
static void media_source_collection_on_master_replaced (MediaSourceCollection* self,
                                                 MediaSource* media,
                                                 GFile* old_file,
                                                 GFile* new_file);
static void _media_source_collection_on_master_replaced_media_source_master_replaced (MediaSource* _sender,
                                                                               GFile* old_file,
                                                                               GFile* new_file,
                                                                               gpointer self);
VALA_EXTERN gboolean import_id_is_valid (ImportID *self);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                                           GFile* file);
static MediaSource* media_source_collection_real_fetch_by_source_id (MediaSourceCollection* self,
                                                              const gchar* source_id);
static GeeCollection* media_source_collection_real_get_event_source_ids (MediaSourceCollection* self,
                                                                  EventID* event_id);
VALA_EXTERN GeeCollection* media_source_collection_get_trashcan_contents (MediaSourceCollection* self);
VALA_EXTERN GeeCollection* source_holding_tank_get_all (SourceHoldingTank* self);
VALA_EXTERN GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
VALA_EXTERN GeeCollection* media_source_collection_get_flagged (MediaSourceCollection* self);
VALA_EXTERN GeeSortedSet* media_source_collection_get_import_roll_ids (MediaSourceCollection* self);
VALA_EXTERN ImportID* media_source_collection_get_last_import_id (MediaSourceCollection* self);
VALA_EXTERN GeeCollection* media_source_collection_get_import_roll (MediaSourceCollection* self,
                                                        ImportID* import_id);
VALA_EXTERN void media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                                GeeCollection* sources);
VALA_EXTERN void source_holding_tank_add_many (SourceHoldingTank* self,
                                   GeeCollection* many);
VALA_EXTERN void media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                                  GeeCollection* sources);
VALA_EXTERN gint media_source_collection_get_trashcan_count (MediaSourceCollection* self);
VALA_EXTERN gint source_holding_tank_get_count (SourceHoldingTank* self);
static void media_source_collection_real_import_many (MediaSourceCollection* self,
                                               GeeCollection* media);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
static void media_source_collection_real_postprocess_imported_media (MediaSourceCollection* self,
                                                              GeeCollection* media);
VALA_EXTERN void media_source_collection_remove_from_app (MediaSourceCollection* self,
                                              GeeCollection* sources,
                                              gboolean delete_backing,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target,
                                              GeeList* not_removed);
VALA_EXTERN gpointer aggregate_progress_monitor_ref (gpointer instance);
VALA_EXTERN void aggregate_progress_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_aggregate_progress_monitor (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_aggregate_progress_monitor (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_aggregate_progress_monitor (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_aggregate_progress_monitor (const GValue* value);
VALA_EXTERN GType aggregate_progress_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AggregateProgressMonitor, aggregate_progress_monitor_unref)
VALA_EXTERN AggregateProgressMonitor* aggregate_progress_monitor_new (guint64 grand_total,
                                                          ProgressMonitor wrapped_monitor,
                                                          gpointer wrapped_monitor_target);
VALA_EXTERN AggregateProgressMonitor* aggregate_progress_monitor_construct (GType object_type,
                                                                guint64 grand_total,
                                                                ProgressMonitor wrapped_monitor,
                                                                gpointer wrapped_monitor_target);
VALA_EXTERN gboolean aggregate_progress_monitor_monitor (AggregateProgressMonitor* self,
                                             guint64 count,
                                             guint64 total);
static gboolean _aggregate_progress_monitor_monitor_progress_monitor (guint64 current,
                                                               guint64 total,
                                                               gboolean do_event_loop,
                                                               gpointer self);
VALA_EXTERN void source_holding_tank_destroy_orphans (SourceHoldingTank* self,
                                          GeeList* destroy,
                                          gboolean delete_backing,
                                          ProgressMonitor monitor,
                                          gpointer monitor_target,
                                          GeeList* not_removed);
VALA_EXTERN gint source_collection_destroy_marked (SourceCollection* self,
                                       Marker* marker,
                                       gboolean delete_backing,
                                       ProgressMonitor monitor,
                                       gpointer monitor_target,
                                       GeeList* not_removed);
VALA_EXTERN Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
VALA_EXTERN GType tombstone_reason_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void tombstone_entomb_many_sources (GeeCollection* sources,
                                    TombstoneReason reason,
                                    GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void media_source_collection_delete_backing_files (MediaSourceCollection* self,
                                                   GeeCollection* sources,
                                                   ProgressMonitor monitor,
                                                   gpointer monitor_target,
                                                   GeeList* not_deleted);
VALA_EXTERN TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
static void media_source_collection_real_media_import_starting (MediaSourceCollection* self,
                                                         GeeCollection* media);
static void media_source_collection_real_media_import_completed (MediaSourceCollection* self,
                                                          GeeCollection* media);
static void media_source_collection_real_master_file_replaced (MediaSourceCollection* self,
                                                        MediaSource* media,
                                                        GFile* old_file,
                                                        GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void media_source_collection_real_trashcan_contents_altered (MediaSourceCollection* self,
                                                             GeeCollection* added,
                                                             GeeCollection* removed);
static void media_source_collection_real_import_roll_altered (MediaSourceCollection* self);
static void media_source_collection_real_offline_contents_altered (MediaSourceCollection* self,
                                                            GeeCollection* added,
                                                            GeeCollection* removed);
static void media_source_collection_real_flagged_contents_altered (MediaSourceCollection* self);
static void media_source_collection_finalize (DataCollection * obj);
static GType media_source_collection_get_type_once (void);
VALA_EXTERN gpointer media_collection_registry_ref (gpointer instance);
VALA_EXTERN void media_collection_registry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_media_collection_registry (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void value_set_media_collection_registry (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void value_take_media_collection_registry (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer value_get_media_collection_registry (const GValue* value);
VALA_EXTERN GType media_collection_registry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaCollectionRegistry, media_collection_registry_unref)
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN Application* application_get_instance (void);
static void media_collection_registry_on_init_done (MediaCollectionRegistry* self);
static void _media_collection_registry_on_init_done_application_init_done (Application* _sender,
                                                                    gpointer self);
static MediaCollectionRegistry* media_collection_registry_new (void);
static MediaCollectionRegistry* media_collection_registry_construct (GType object_type);
VALA_EXTERN GType directory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitor, g_object_unref)
VALA_EXTERN GType library_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryMonitor, g_object_unref)
VALA_EXTERN LibraryMonitor* library_monitor_new (GFile* root,
                                     gboolean recurse,
                                     gboolean monitoring);
VALA_EXTERN LibraryMonitor* library_monitor_construct (GType object_type,
                                           GFile* root,
                                           gboolean recurse,
                                           gboolean monitoring);
VALA_EXTERN gpointer library_monitor_pool_ref (gpointer instance);
VALA_EXTERN void library_monitor_pool_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_library_monitor_pool (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_library_monitor_pool (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_library_monitor_pool (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_library_monitor_pool (const GValue* value);
VALA_EXTERN GType library_monitor_pool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryMonitorPool, library_monitor_pool_unref)
VALA_EXTERN LibraryMonitorPool* library_monitor_pool_get_instance (void);
VALA_EXTERN void library_monitor_pool_replace (LibraryMonitorPool* self,
                                   LibraryMonitor* replacement,
                                   gint start_msec_delay);
VALA_EXTERN void media_collection_registry_init (void);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
static void media_collection_registry_on_import_directory_changed (void);
static void _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed (ConfigurationFacade* _sender,
                                                                                                           gpointer self);
VALA_EXTERN void media_collection_registry_terminate (void);
VALA_EXTERN LibraryMonitor* library_monitor_pool_get_monitor (LibraryMonitorPool* self);
VALA_EXTERN GFile* directory_monitor_get_root (DirectoryMonitor* self);
VALA_EXTERN void library_files_select_copy_function (void);
VALA_EXTERN MediaCollectionRegistry* media_collection_registry_get_instance (void);
VALA_EXTERN gchar* media_collection_registry_get_typename_from_source_id (const gchar* source_id);
VALA_EXTERN void media_collection_registry_register_collection (MediaCollectionRegistry* self,
                                                    MediaSourceCollection* collection);
VALA_EXTERN MediaSourceCollection* media_collection_registry_get_collection (MediaCollectionRegistry* self,
                                                                 const gchar* typename);
VALA_EXTERN GeeCollection* media_collection_registry_get_all (MediaCollectionRegistry* self);
VALA_EXTERN void media_collection_registry_freeze_all (MediaCollectionRegistry* self);
VALA_EXTERN void media_collection_registry_thaw_all (MediaCollectionRegistry* self);
VALA_EXTERN void media_collection_registry_begin_transaction_on_all (MediaCollectionRegistry* self);
VALA_EXTERN void media_collection_registry_commit_transaction_on_all (MediaCollectionRegistry* self);
VALA_EXTERN MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self,
                                                    const gchar* source_id);
VALA_EXTERN ImportID* media_collection_registry_get_last_import_id (MediaCollectionRegistry* self);
VALA_EXTERN void import_id_init (ImportID *self,
                     gint64 id);
VALA_EXTERN GeeCollection* media_collection_registry_get_source_ids_for_event_id (MediaCollectionRegistry* self,
                                                                      EventID* event_id);
VALA_EXTERN MediaSourceCollection* media_collection_registry_get_collection_for_file (MediaCollectionRegistry* self,
                                                                          GFile* file);
VALA_EXTERN gboolean media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self,
                                                       const gchar* source_id);
static void media_collection_registry_finalize (MediaCollectionRegistry * obj);
static GType media_collection_registry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

BackingFileState*
backing_file_state_construct (GType object_type,
                              const gchar* filepath,
                              gint64 filesize,
                              GDateTime* modification_time,
                              const gchar* md5)
{
	BackingFileState* self = NULL;
	gchar* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (filepath != NULL, NULL);
	g_return_val_if_fail (modification_time != NULL, NULL);
	self = (BackingFileState*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (filepath);
	_g_free0 (self->filepath);
	self->filepath = _tmp0_;
	self->filesize = filesize;
	_tmp1_ = _g_date_time_ref0 (modification_time);
	_g_date_time_unref0 (self->modification_time);
	self->modification_time = _tmp1_;
	_tmp2_ = g_strdup (md5);
	_g_free0 (self->md5);
	self->md5 = _tmp2_;
	return self;
}

BackingFileState*
backing_file_state_new (const gchar* filepath,
                        gint64 filesize,
                        GDateTime* modification_time,
                        const gchar* md5)
{
	return backing_file_state_construct (TYPE_BACKING_FILE_STATE, filepath, filesize, modification_time, md5);
}

BackingFileState*
backing_file_state_construct_from_photo_row (GType object_type,
                                             BackingPhotoRow* photo_row,
                                             const gchar* md5)
{
	BackingFileState* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (photo_row), NULL);
	self = (BackingFileState*) g_type_create_instance (object_type);
	_tmp0_ = photo_row->filepath;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->filepath);
	self->filepath = _tmp1_;
	self->filesize = photo_row->filesize;
	_tmp2_ = photo_row->timestamp;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	_g_date_time_unref0 (self->modification_time);
	self->modification_time = _tmp3_;
	_tmp4_ = g_strdup (md5);
	_g_free0 (self->md5);
	self->md5 = _tmp4_;
	return self;
}

BackingFileState*
backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row,
                                       const gchar* md5)
{
	return backing_file_state_construct_from_photo_row (TYPE_BACKING_FILE_STATE, photo_row, md5);
}

GFile*
backing_file_state_get_file (BackingFileState* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (IS_BACKING_FILE_STATE (self), NULL);
	_tmp0_ = self->filepath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_backing_file_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_backing_file_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		backing_file_state_unref (value->data[0].v_pointer);
	}
}

static void
value_backing_file_state_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = backing_file_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_backing_file_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_backing_file_state_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BackingFileState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = backing_file_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_backing_file_state_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	BackingFileState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = backing_file_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_backing_file_state (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecBackingFileState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_FILE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_backing_file_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_backing_file_state (GValue* value,
                              gpointer v_object)
{
	BackingFileState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_FILE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		backing_file_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_file_state_unref (old);
	}
}

void
value_take_backing_file_state (GValue* value,
                               gpointer v_object)
{
	BackingFileState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_FILE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_file_state_unref (old);
	}
}

static void
backing_file_state_class_init (BackingFileStateClass * klass,
                               gpointer klass_data)
{
	backing_file_state_parent_class = g_type_class_peek_parent (klass);
	((BackingFileStateClass *) klass)->finalize = backing_file_state_finalize;
}

static void
backing_file_state_instance_init (BackingFileState * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
backing_file_state_finalize (BackingFileState * obj)
{
	BackingFileState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_FILE_STATE, BackingFileState);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
	_g_date_time_unref0 (self->modification_time);
	_g_free0 (self->md5);
}

static GType
backing_file_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_backing_file_state_init, value_backing_file_state_free_value, value_backing_file_state_copy_value, value_backing_file_state_peek_pointer, "p", value_backing_file_state_collect_value, "p", value_backing_file_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BackingFileStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_file_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingFileState), 0, (GInstanceInitFunc) backing_file_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType backing_file_state_type_id;
	backing_file_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingFileState", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return backing_file_state_type_id;
}

GType
backing_file_state_get_type (void)
{
	static volatile gsize backing_file_state_type_id__once = 0;
	if (g_once_init_enter (&backing_file_state_type_id__once)) {
		GType backing_file_state_type_id;
		backing_file_state_type_id = backing_file_state_get_type_once ();
		g_once_init_leave (&backing_file_state_type_id__once, backing_file_state_type_id);
	}
	return backing_file_state_type_id__once;
}

gpointer
backing_file_state_ref (gpointer instance)
{
	BackingFileState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
backing_file_state_unref (gpointer instance)
{
	BackingFileState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKING_FILE_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
media_source_get_instance_private (MediaSource* self)
{
	return G_STRUCT_MEMBER_P (self, MediaSource_private_offset);
}

MediaSource*
media_source_construct (GType object_type,
                        gint64 object_id)
{
	MediaSource * self = NULL;
	self = (MediaSource*) thumbnail_source_construct (object_type, object_id);
	return self;
}

inline guint64
media_source_internal_add_flags (guint64 flags,
                                 guint64 selector)
{
	guint64 result;
	result = flags | selector;
	return result;
}

inline guint64
media_source_internal_remove_flags (guint64 flags,
                                    guint64 selector)
{
	guint64 result;
	result = flags & (~selector);
	return result;
}

inline gboolean
media_source_internal_is_flag_set (guint64 flags,
                                   guint64 selector)
{
	gboolean result;
	result = (flags & selector) != ((guint64) 0);
	return result;
}

static void
media_source_real_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	g_signal_emit (self, media_source_signals[MEDIA_SOURCE_MASTER_REPLACED_SIGNAL], 0, old_file, new_file);
}

void
media_source_notify_master_replaced (MediaSource* self,
                                     GFile* old_file,
                                     GFile* new_file)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_master_replaced) {
		_klass_->notify_master_replaced (self, old_file, new_file);
	}
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

static void
media_source_real_notify_altered (DataObject* base,
                                  Alteration* alteration)
{
	MediaSource * self;
	Alteration* local = NULL;
	Alteration* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Alteration* _tmp3_;
	Alteration* _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
	g_return_if_fail (IS_ALTERATION (alteration));
	_tmp0_ = _alteration_ref0 (alteration);
	local = _tmp0_;
	_tmp3_ = local;
	if (alteration_has_detail (_tmp3_, "metadata", "name")) {
		_tmp2_ = TRUE;
	} else {
		Alteration* _tmp4_;
		_tmp4_ = local;
		_tmp2_ = alteration_has_detail (_tmp4_, "metadata", "comment");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		Alteration* _tmp5_;
		_tmp5_ = local;
		_tmp1_ = alteration_has_detail (_tmp5_, "backing", "master");
	}
	if (_tmp1_) {
		Alteration* _tmp6_;
		Alteration* _tmp7_;
		Alteration* _tmp8_;
		Alteration* _tmp9_;
		media_source_update_indexable_keywords (self);
		_tmp6_ = local;
		_tmp7_ = alteration_new ("indexable", "keywords");
		_tmp8_ = _tmp7_;
		_tmp9_ = alteration_compress (_tmp6_, _tmp8_);
		_alteration_unref0 (local);
		local = _tmp9_;
		_alteration_unref0 (_tmp8_);
	}
	_tmp10_ = local;
	DATA_OBJECT_CLASS (media_source_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), TYPE_DATA_OBJECT, DataObject), _tmp10_);
	_alteration_unref0 (local);
}

static void
media_source_real_notify_membership_changed (DataObject* base,
                                             DataCollection* collection)
{
	MediaSource * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
	if (collection != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->indexable_keywords;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		media_source_update_indexable_keywords (self);
	}
	DATA_OBJECT_CLASS (media_source_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), TYPE_DATA_OBJECT, DataObject), collection);
}

static void
media_source_update_indexable_keywords (MediaSource* self)
{
	gchar** indexables = NULL;
	gchar** _tmp0_;
	gint indexables_length1;
	gint _indexables_size_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_tmp0_ = g_new0 (gchar*, 3 + 1);
	indexables = _tmp0_;
	indexables_length1 = 3;
	_indexables_size_ = indexables_length1;
	_tmp1_ = media_source_get_title (self);
	_g_free0 (indexables[0]);
	indexables[0] = _tmp1_;
	_tmp2_ = media_source_get_basename (self);
	_g_free0 (indexables[1]);
	indexables[1] = _tmp2_;
	_tmp3_ = media_source_get_comment (self);
	_g_free0 (indexables[2]);
	indexables[2] = _tmp3_;
	_tmp4_ = indexable_prepare_indexable_strings (indexables, (gint) indexables_length1);
	_g_free0 (self->priv->indexable_keywords);
	self->priv->indexable_keywords = _tmp4_;
	indexables = (_vala_array_free (indexables, indexables_length1, (GDestroyNotify) g_free), NULL);
}

static const gchar*
media_source_real_get_indexable_keywords (Indexable* base)
{
	MediaSource * self;
	const gchar* _tmp0_;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
	_tmp0_ = self->priv->indexable_keywords;
	result = _tmp0_;
	return result;
}

static gboolean
media_source_real_set_event_id (MediaSource* self,
                                EventID* id)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_source_set_event_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_source_set_event_id (MediaSource* self,
                           EventID* id)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->set_event_id) {
		return _klass_->set_event_id (self, id);
	}
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
media_source_delete_original_file (MediaSource* self)
{
	gboolean ret = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	ret = FALSE;
	_tmp0_ = media_source_get_master_file (self);
	file = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_;
		_tmp2_ = file;
		_tmp1_ = g_file_trash (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		ret = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_message ("MediaDataRepresentation.vala:108: Unable to move original photo %s to " \
"trash: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = file;
	_tmp10_ = app_dirs_get_import_dir ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_has_prefix (_tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GFile* parent = NULL;
		GFile* _tmp13_;
		GFile* _tmp14_;
		_tmp13_ = file;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		parent = _tmp14_;
		while (TRUE) {
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			gboolean _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GFile* _tmp22_;
			_tmp15_ = parent;
			_tmp16_ = app_dirs_get_import_dir ();
			_tmp17_ = _tmp16_;
			_tmp18_ = !(!g_file_equal (_tmp15_, _tmp17_));
			_g_object_unref0 (_tmp17_);
			if (_tmp18_) {
				break;
			}
			_tmp19_ = parent;
			_tmp20_ = g_file_get_parent (_tmp19_);
			_g_object_unref0 (parent);
			parent = _tmp20_;
			_tmp22_ = parent;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				GFile* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				_tmp23_ = parent;
				_tmp24_ = app_dirs_get_import_dir ();
				_tmp25_ = _tmp24_;
				_tmp21_ = g_file_equal (_tmp23_, _tmp25_);
				_g_object_unref0 (_tmp25_);
			}
			if (_tmp21_) {
				break;
			}
			{
				gboolean _tmp26_ = FALSE;
				GFile* _tmp27_;
				_tmp27_ = parent;
				_tmp26_ = query_is_directory_empty (_tmp27_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				if (!_tmp26_) {
					break;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				GFile* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				const gchar* _tmp32_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = parent;
				_tmp29_ = g_file_get_path (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = err;
				_tmp32_ = _tmp31_->message;
				g_warning ("MediaDataRepresentation.vala:124: Unable to query file info for %s: %s", _tmp30_, _tmp32_);
				_g_free0 (_tmp30_);
				_g_error_free0 (err);
				break;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp33_ = FALSE;
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp33_;
			}
			{
				GFile* _tmp34_;
				GFile* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp34_ = parent;
				g_file_delete (_tmp34_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp35_ = parent;
				_tmp36_ = g_file_get_path (_tmp35_);
				_tmp37_ = _tmp36_;
				g_debug ("MediaDataRepresentation.vala:131: Deleted empty directory %s", _tmp37_);
				_g_free0 (_tmp37_);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* err = NULL;
				GFile* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				GError* _tmp41_;
				const gchar* _tmp42_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp38_ = parent;
				_tmp39_ = g_file_get_path (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = err;
				_tmp42_ = _tmp41_->message;
				g_message ("MediaDataRepresentation.vala:134: Unable to delete empty directory %s:" \
" %s", _tmp40_, _tmp42_);
				_g_free0 (_tmp40_);
				_g_error_free0 (err);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp43_ = FALSE;
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp43_;
			}
		}
		_g_object_unref0 (parent);
	}
	result = ret;
	_g_object_unref0 (file);
	return result;
}

static gchar*
media_source_real_get_name (DataObject* base)
{
	MediaSource * self;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
	_tmp0_ = media_source_get_title (self);
	title = _tmp0_;
	_tmp2_ = title;
	if (is_string_empty (_tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = media_source_get_basename (self);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = title;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	result = _tmp1_;
	_g_free0 (title);
	return result;
}

static gchar*
media_source_real_get_basename (MediaSource* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = media_source_get_file (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
media_source_get_basename (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_basename) {
		return _klass_->get_basename (self);
	}
	return NULL;
}

static GFile*
media_source_real_get_file (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GFile*
media_source_get_file (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_file) {
		return _klass_->get_file (self);
	}
	return NULL;
}

static GFile*
media_source_real_get_master_file (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GFile*
media_source_get_master_file (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_master_file) {
		return _klass_->get_master_file (self);
	}
	return NULL;
}

static guint64
media_source_real_get_master_filesize (MediaSource* self)
{
	guint64 _tmp0_ = 0ULL;
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint64
media_source_get_master_filesize (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0ULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_master_filesize) {
		return _klass_->get_master_filesize (self);
	}
	return 0ULL;
}

static guint64
media_source_real_get_filesize (MediaSource* self)
{
	guint64 _tmp0_ = 0ULL;
	g_critical ("Type `%s' does not implement abstract method `media_source_get_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint64
media_source_get_filesize (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0ULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_filesize) {
		return _klass_->get_filesize (self);
	}
	return 0ULL;
}

static GDateTime*
media_source_real_get_timestamp (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_timestamp'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GDateTime*
media_source_get_timestamp (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_timestamp) {
		return _klass_->get_timestamp (self);
	}
	return NULL;
}

static BackingFileState**
media_source_real_get_backing_files_state (MediaSource* self,
                                           gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_backing_files_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

BackingFileState**
media_source_get_backing_files_state (MediaSource* self,
                                      gint* result_length1)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_backing_files_state) {
		return _klass_->get_backing_files_state (self, result_length1);
	}
	return NULL;
}

static gchar*
media_source_real_get_title (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_source_get_title (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_title) {
		return _klass_->get_title (self);
	}
	return NULL;
}

static gchar*
media_source_real_get_comment (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_source_get_comment (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_comment) {
		return _klass_->get_comment (self);
	}
	return NULL;
}

static void
media_source_real_set_title (MediaSource* self,
                             const gchar* title)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_set_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_set_title (MediaSource* self,
                        const gchar* title)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->set_title) {
		_klass_->set_title (self, title);
	}
}

static gboolean
media_source_real_set_comment (MediaSource* self,
                               const gchar* comment)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_source_set_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_source_set_comment (MediaSource* self,
                          const gchar* comment)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->set_comment) {
		return _klass_->set_comment (self, comment);
	}
	return FALSE;
}

gchar*
media_source_prep_title (const gchar* title)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = prepare_input_text (title, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL), DEFAULT_USER_TEXT_INPUT_LENGTH);
	result = _tmp0_;
	return result;
}

gchar*
media_source_prep_comment (const gchar* comment)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = prepare_input_text (comment, (PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF)) & (~PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL), -1);
	result = _tmp0_;
	return result;
}

static Rating
media_source_real_get_rating (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

Rating
media_source_get_rating (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_rating) {
		return _klass_->get_rating (self);
	}
	return 0;
}

static void
media_source_real_set_rating (MediaSource* self,
                              Rating rating)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_set_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_set_rating (MediaSource* self,
                         Rating rating)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->set_rating) {
		_klass_->set_rating (self, rating);
	}
}

static void
media_source_real_increase_rating (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_increase_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_increase_rating (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->increase_rating) {
		_klass_->increase_rating (self);
	}
}

static void
media_source_real_decrease_rating (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_decrease_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_decrease_rating (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->decrease_rating) {
		_klass_->decrease_rating (self);
	}
}

static void
media_source_real_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_dimensions'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_get_dimensions (MediaSource* self,
                             PhotoException disallowed_steps,
                             Dimensions* result)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_dimensions) {
		_klass_->get_dimensions (self, disallowed_steps, result);
	}
}

static GdkPixbuf*
media_source_real_get_preview_pixbuf (MediaSource* self,
                                      Scaling* scaling,
                                      GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_preview_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
media_source_get_preview_pixbuf (MediaSource* self,
                                 Scaling* scaling,
                                 GError** error)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_preview_pixbuf) {
		return _klass_->get_preview_pixbuf (self, scaling, error);
	}
	return NULL;
}

static gboolean
media_source_real_is_trashed (MediaSource* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_source_is_trashed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_source_is_trashed (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->is_trashed) {
		return _klass_->is_trashed (self);
	}
	return FALSE;
}

static void
media_source_real_trash (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_trash'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_trash (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->trash) {
		_klass_->trash (self);
	}
}

static void
media_source_real_untrash (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_untrash'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_untrash (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->untrash) {
		_klass_->untrash (self);
	}
}

static gboolean
media_source_real_is_offline (MediaSource* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_source_is_offline'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_source_is_offline (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->is_offline) {
		return _klass_->is_offline (self);
	}
	return FALSE;
}

static void
media_source_real_mark_offline (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_mark_offline'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_mark_offline (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->mark_offline) {
		_klass_->mark_offline (self);
	}
}

static void
media_source_real_mark_online (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_mark_online'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_mark_online (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->mark_online) {
		_klass_->mark_online (self);
	}
}

static gchar*
media_source_real_get_master_md5 (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_md5'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_source_get_master_md5 (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_master_md5) {
		return _klass_->get_master_md5 (self);
	}
	return NULL;
}

static void
media_source_real_get_event_id (MediaSource* self,
                                EventID* result)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_event_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_get_event_id (MediaSource* self,
                           EventID* result)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_event_id) {
		_klass_->get_event_id (self, result);
	}
}

Event*
media_source_get_event (MediaSource* self)
{
	Event* _tmp0_;
	EventID event_id = {0};
	EventID _tmp3_ = {0};
	EventSourceCollection* _tmp4_;
	EventID _tmp5_;
	Event* _tmp6_;
	Event* _tmp7_;
	Event* _tmp8_;
	Event* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_tmp0_ = self->priv->event;
	if (_tmp0_ != NULL) {
		Event* _tmp1_;
		Event* _tmp2_;
		_tmp1_ = self->priv->event;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	media_source_get_event_id (self, &_tmp3_);
	event_id = _tmp3_;
	if (!event_id_is_valid (&event_id)) {
		result = NULL;
		return result;
	}
	_tmp4_ = event_global;
	_tmp5_ = event_id;
	_tmp6_ = event_source_collection_fetch (_tmp4_, &_tmp5_);
	_g_object_unref0 (self->priv->event);
	self->priv->event = _tmp6_;
	_tmp7_ = self->priv->event;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

gboolean
media_source_set_event (MediaSource* self,
                        Event* new_event)
{
	EventID _tmp0_ = {0};
	EventID event_id = {0};
	EventID _tmp2_ = {0};
	EventID _tmp3_;
	gboolean committed = FALSE;
	EventID _tmp4_;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
	g_return_val_if_fail ((new_event == NULL) || IS_EVENT (new_event), FALSE);
	if (new_event != NULL) {
		EventID _tmp1_ = {0};
		event_get_event_id (new_event, &_tmp1_);
		_tmp0_ = _tmp1_;
	} else {
		event_id_init (&_tmp0_, EVENT_ID_INVALID);
	}
	event_id = _tmp0_;
	media_source_get_event_id (self, &_tmp2_);
	_tmp3_ = event_id;
	if (_tmp2_.id == _tmp3_.id) {
		result = TRUE;
		return result;
	}
	_tmp4_ = event_id;
	committed = media_source_set_event_id (self, &_tmp4_);
	if (committed) {
		Event* _tmp5_;
		Event* _tmp7_;
		Alteration* _tmp8_;
		Alteration* _tmp9_;
		_tmp5_ = self->priv->event;
		if (_tmp5_ != NULL) {
			Event* _tmp6_;
			_tmp6_ = self->priv->event;
			event_detach (_tmp6_, self);
		}
		if (new_event != NULL) {
			event_attach (new_event, self);
		}
		_tmp7_ = _g_object_ref0 (new_event);
		_g_object_unref0 (self->priv->event);
		self->priv->event = _tmp7_;
		_tmp8_ = alteration_new ("metadata", "event");
		_tmp9_ = _tmp8_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp9_);
		_alteration_unref0 (_tmp9_);
	}
	result = committed;
	return result;
}

void
media_source_set_many_to_event (GeeCollection* media_sources,
                                Event* event,
                                TransactionController* controller,
                                GError** error)
{
	EventID _tmp0_ = {0};
	EventID event_id = {0};
	Alteration* alteration = NULL;
	Alteration* _tmp15_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media_sources, GEE_TYPE_COLLECTION));
	g_return_if_fail ((event == NULL) || IS_EVENT (event));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	if (event != NULL) {
		EventID _tmp1_ = {0};
		event_get_event_id (event, &_tmp1_);
		_tmp0_ = _tmp1_;
	} else {
		event_id_init (&_tmp0_, EVENT_ID_INVALID);
	}
	event_id = _tmp0_;
	transaction_controller_begin (controller);
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_ITERABLE, GeeIterable));
		_media_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MediaSource* media = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			Event* old_event = NULL;
			MediaSource* _tmp6_;
			Event* _tmp7_;
			Event* _tmp8_;
			MediaSource* _tmp11_;
			EventID _tmp12_;
			MediaSource* _tmp13_;
			Event* _tmp14_;
			_tmp3_ = _media_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _media_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			media = (MediaSource*) _tmp5_;
			_tmp6_ = media;
			_tmp7_ = media_source_get_event (_tmp6_);
			old_event = _tmp7_;
			_tmp8_ = old_event;
			if (_tmp8_ != NULL) {
				Event* _tmp9_;
				MediaSource* _tmp10_;
				_tmp9_ = old_event;
				_tmp10_ = media;
				event_detach (_tmp9_, _tmp10_);
			}
			_tmp11_ = media;
			_tmp12_ = event_id;
			media_source_set_event_id (_tmp11_, &_tmp12_);
			_tmp13_ = media;
			_tmp14_ = _g_object_ref0 (event);
			_g_object_unref0 (_tmp13_->priv->event);
			_tmp13_->priv->event = _tmp14_;
			_g_object_unref0 (old_event);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	if (event != NULL) {
		event_attach_many (event, media_sources);
	}
	_tmp15_ = alteration_new ("metadata", "event");
	alteration = _tmp15_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp16_;
		_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_ITERABLE, GeeIterable));
		_media_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			MediaSource* media = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			MediaSource* _tmp20_;
			Alteration* _tmp21_;
			_tmp17_ = _media_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _media_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			media = (MediaSource*) _tmp19_;
			_tmp20_ = media;
			_tmp21_ = alteration;
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_OBJECT, DataObject), _tmp21_);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	transaction_controller_commit (controller);
	_alteration_unref0 (alteration);
}

static GDateTime*
media_source_real_get_exposure_time (MediaSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_exposure_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GDateTime*
media_source_get_exposure_time (MediaSource* self)
{
	MediaSourceClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_exposure_time) {
		return _klass_->get_exposure_time (self);
	}
	return NULL;
}

static void
media_source_real_get_import_id (MediaSource* self,
                                 ImportID* result)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_get_import_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_source_get_import_id (MediaSource* self,
                            ImportID* result)
{
	MediaSourceClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE (self));
	_klass_ = MEDIA_SOURCE_GET_CLASS (self);
	if (_klass_->get_import_id) {
		_klass_->get_import_id (self, result);
	}
}

static void
media_source_real_master_replaced (MediaSource* self,
                                   GFile* old_file,
                                   GFile* new_file)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
media_source_class_init (MediaSourceClass * klass,
                         gpointer klass_data)
{
	media_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MediaSource_private_offset);
	((MediaSourceClass *) klass)->notify_master_replaced = (void (*) (MediaSource*, GFile*, GFile*)) media_source_real_notify_master_replaced;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) media_source_real_notify_altered;
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject*, DataCollection*)) media_source_real_notify_membership_changed;
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource*, EventID*)) media_source_real_set_event_id;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) media_source_real_get_name;
	((MediaSourceClass *) klass)->get_basename = (gchar* (*) (MediaSource*)) media_source_real_get_basename;
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource*)) media_source_real_get_file;
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource*)) media_source_real_get_master_file;
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource*)) media_source_real_get_master_filesize;
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource*)) media_source_real_get_filesize;
	((MediaSourceClass *) klass)->get_timestamp = (GDateTime* (*) (MediaSource*)) media_source_real_get_timestamp;
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource*, gint*)) media_source_real_get_backing_files_state;
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource*)) media_source_real_get_title;
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource*)) media_source_real_get_comment;
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource*, const gchar*)) media_source_real_set_title;
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource*, const gchar*)) media_source_real_set_comment;
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource*)) media_source_real_get_rating;
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource*, Rating)) media_source_real_set_rating;
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource*)) media_source_real_increase_rating;
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource*)) media_source_real_decrease_rating;
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource*, PhotoException, Dimensions*)) media_source_real_get_dimensions;
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) media_source_real_get_preview_pixbuf;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) media_source_real_is_trashed;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) media_source_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) media_source_real_untrash;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) media_source_real_is_offline;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) media_source_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) media_source_real_mark_online;
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource*)) media_source_real_get_master_md5;
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource*, EventID*)) media_source_real_get_event_id;
	((MediaSourceClass *) klass)->get_exposure_time = (GDateTime* (*) (MediaSource*)) media_source_real_get_exposure_time;
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource*, ImportID*)) media_source_real_get_import_id;
	((MediaSourceClass *) klass)->master_replaced = media_source_real_master_replaced;
	G_OBJECT_CLASS (klass)->finalize = media_source_finalize;
	media_source_signals[MEDIA_SOURCE_MASTER_REPLACED_SIGNAL] = g_signal_new ("master-replaced", TYPE_MEDIA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceClass, master_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_get_type ());
}

static void
media_source_indexable_interface_init (IndexableIface * iface,
                                       gpointer iface_data)
{
	media_source_indexable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_indexable_keywords = (const gchar* (*) (Indexable*)) media_source_real_get_indexable_keywords;
}

static void
media_source_instance_init (MediaSource * self,
                            gpointer klass)
{
	self->priv = media_source_get_instance_private (self);
	self->priv->event = NULL;
	self->priv->indexable_keywords = NULL;
}

static void
media_source_finalize (GObject * obj)
{
	MediaSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE, MediaSource);
	_g_object_unref0 (self->priv->event);
	_g_free0 (self->priv->indexable_keywords);
	G_OBJECT_CLASS (media_source_parent_class)->finalize (obj);
}

static GType
media_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSource), 0, (GInstanceInitFunc) media_source_instance_init, NULL };
	static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) media_source_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType media_source_type_id;
	media_source_type_id = g_type_register_static (TYPE_THUMBNAIL_SOURCE, "MediaSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (media_source_type_id, TYPE_INDEXABLE, &indexable_info);
	MediaSource_private_offset = g_type_add_instance_private (media_source_type_id, sizeof (MediaSourcePrivate));
	return media_source_type_id;
}

GType
media_source_get_type (void)
{
	static volatile gsize media_source_type_id__once = 0;
	if (g_once_init_enter (&media_source_type_id__once)) {
		GType media_source_type_id;
		media_source_type_id = media_source_get_type_once ();
		g_once_init_leave (&media_source_type_id__once, media_source_type_id);
	}
	return media_source_type_id__once;
}

static inline gpointer
media_source_holding_tank_get_instance_private (MediaSourceHoldingTank* self)
{
	return G_STRUCT_MEMBER_P (self, MediaSourceHoldingTank_private_offset);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

MediaSourceHoldingTank*
media_source_holding_tank_construct (GType object_type,
                                     MediaSourceCollection* sources,
                                     SourceHoldingTankCheckToKeep check_to_keep,
                                     gpointer check_to_keep_target,
                                     GetSourceDatabaseKey get_key,
                                     gpointer get_key_target)
{
	MediaSourceHoldingTank* self = NULL;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
	self = (MediaSourceHoldingTank*) database_source_holding_tank_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_SOURCE_COLLECTION, SourceCollection), check_to_keep, check_to_keep_target, get_key, get_key_target);
	return self;
}

MediaSourceHoldingTank*
media_source_holding_tank_new (MediaSourceCollection* sources,
                               SourceHoldingTankCheckToKeep check_to_keep,
                               gpointer check_to_keep_target,
                               GetSourceDatabaseKey get_key,
                               gpointer get_key_target)
{
	return media_source_holding_tank_construct (TYPE_MEDIA_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
}

MediaSource*
media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MediaSource* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->master_file_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (MediaSource*) _tmp1_;
	return result;
}

MediaSource*
media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self,
                                        const gchar* md5)
{
	MediaSource* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self), NULL);
	g_return_val_if_fail (md5 != NULL, NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->master_file_map;
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_source_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MediaSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			MediaSource* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			_tmp6_ = _source_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _source_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			source = (MediaSource*) _tmp8_;
			_tmp9_ = source;
			_tmp10_ = media_source_get_master_md5 (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, md5) == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				result = source;
				_g_object_unref0 (_source_it);
				return result;
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	result = NULL;
	return result;
}

static void
_media_source_holding_tank_on_master_source_replaced_media_source_master_replaced (MediaSource* _sender,
                                                                                   GFile* old_file,
                                                                                   GFile* new_file,
                                                                                   gpointer self)
{
	media_source_holding_tank_on_master_source_replaced ((MediaSourceHoldingTank*) self, _sender, old_file, new_file);
}

static void
media_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                        GeeCollection* added,
                                                        GeeCollection* removed)
{
	MediaSourceHoldingTank * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	if (added != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				MediaSource* media_source = NULL;
				DataSource* _tmp4_;
				MediaSource* _tmp5_;
				GeeHashMap* _tmp6_;
				MediaSource* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				MediaSource* _tmp10_;
				MediaSource* _tmp11_;
				_tmp1_ = _source_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _source_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				source = (DataSource*) _tmp3_;
				_tmp4_ = source;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource));
				media_source = _tmp5_;
				_tmp6_ = self->priv->master_file_map;
				_tmp7_ = media_source;
				_tmp8_ = media_source_get_master_file (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = media_source;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
				_g_object_unref0 (_tmp9_);
				_tmp11_ = media_source;
				g_signal_connect (_tmp11_, "master-replaced", (GCallback) _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced, self);
				_g_object_unref0 (media_source);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp12_;
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_;
				DataSource* source = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				MediaSource* media_source = NULL;
				DataSource* _tmp16_;
				MediaSource* _tmp17_;
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp18_;
				MediaSource* _tmp19_;
				GFile* _tmp20_;
				GFile* _tmp21_;
				gboolean _tmp22_;
				MediaSource* _tmp23_;
				guint _tmp24_;
				_tmp13_ = _source_it;
				if (!gee_iterator_next (_tmp13_)) {
					break;
				}
				_tmp14_ = _source_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				source = (DataSource*) _tmp15_;
				_tmp16_ = source;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_MEDIA_SOURCE, MediaSource));
				media_source = _tmp17_;
				_tmp18_ = self->priv->master_file_map;
				_tmp19_ = media_source;
				_tmp20_ = media_source_get_master_file (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp21_, NULL);
				_g_object_unref0 (_tmp21_);
				is_removed = _tmp22_;
				_vala_assert (is_removed, "is_removed");
				_tmp23_ = media_source;
				g_signal_parse_name ("master-replaced", TYPE_MEDIA_SOURCE, &_tmp24_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced, self);
				_g_object_unref0 (media_source);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	SOURCE_HOLDING_TANK_CLASS (media_source_holding_tank_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), added, removed);
}

static void
media_source_holding_tank_on_master_source_replaced (MediaSourceHoldingTank* self,
                                                     MediaSource* media_source,
                                                     GFile* old_file,
                                                     GFile* new_file)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self));
	g_return_if_fail (IS_MEDIA_SOURCE (media_source));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	_tmp0_ = self->priv->master_file_map;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), old_file, NULL);
	_vala_assert (removed, "removed");
	_tmp1_ = self->priv->master_file_map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), new_file, media_source);
}

static void
media_source_holding_tank_class_init (MediaSourceHoldingTankClass * klass,
                                      gpointer klass_data)
{
	media_source_holding_tank_parent_class = g_type_class_peek_parent (klass);
	((SourceHoldingTankClass *) klass)->finalize = media_source_holding_tank_finalize;
	g_type_class_adjust_private_offset (klass, &MediaSourceHoldingTank_private_offset);
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank*, GeeCollection*, GeeCollection*)) media_source_holding_tank_real_notify_contents_altered;
}

static void
media_source_holding_tank_instance_init (MediaSourceHoldingTank * self,
                                         gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = media_source_holding_tank_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->master_file_map = _tmp0_;
}

static void
media_source_holding_tank_finalize (SourceHoldingTank * obj)
{
	MediaSourceHoldingTank * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
	_g_object_unref0 (self->priv->master_file_map);
	SOURCE_HOLDING_TANK_CLASS (media_source_holding_tank_parent_class)->finalize (obj);
}

static GType
media_source_holding_tank_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaSourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceHoldingTank), 0, (GInstanceInitFunc) media_source_holding_tank_instance_init, NULL };
	GType media_source_holding_tank_type_id;
	media_source_holding_tank_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_HOLDING_TANK, "MediaSourceHoldingTank", &g_define_type_info, 0);
	MediaSourceHoldingTank_private_offset = g_type_add_instance_private (media_source_holding_tank_type_id, sizeof (MediaSourceHoldingTankPrivate));
	return media_source_holding_tank_type_id;
}

GType
media_source_holding_tank_get_type (void)
{
	static volatile gsize media_source_holding_tank_type_id__once = 0;
	if (g_once_init_enter (&media_source_holding_tank_type_id__once)) {
		GType media_source_holding_tank_type_id;
		media_source_holding_tank_type_id = media_source_holding_tank_get_type_once ();
		g_once_init_leave (&media_source_holding_tank_type_id__once, media_source_holding_tank_type_id);
	}
	return media_source_holding_tank_type_id__once;
}

static inline gpointer
media_source_transaction_controller_get_instance_private (MediaSourceTransactionController* self)
{
	return G_STRUCT_MEMBER_P (self, MediaSourceTransactionController_private_offset);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

MediaSourceTransactionController*
media_source_transaction_controller_construct (GType object_type,
                                               MediaSourceCollection* sources)
{
	MediaSourceTransactionController* self = NULL;
	MediaSourceCollection* _tmp0_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
	self = (MediaSourceTransactionController*) transaction_controller_construct (object_type);
	_tmp0_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	return self;
}

MediaSourceTransactionController*
media_source_transaction_controller_new (MediaSourceCollection* sources)
{
	return media_source_transaction_controller_construct (TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, sources);
}

static void
media_source_transaction_controller_real_begin_impl (TransactionController* base,
                                                     GError** error)
{
	MediaSourceTransactionController * self;
	MediaSourceCollection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
	database_table_begin_transaction ();
	_tmp0_ = self->priv->sources;
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
}

static void
media_source_transaction_controller_real_commit_impl (TransactionController* base,
                                                      GError** error)
{
	MediaSourceTransactionController * self;
	MediaSourceCollection* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
	_tmp0_ = self->priv->sources;
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
media_source_transaction_controller_class_init (MediaSourceTransactionControllerClass * klass,
                                                gpointer klass_data)
{
	media_source_transaction_controller_parent_class = g_type_class_peek_parent (klass);
	((TransactionControllerClass *) klass)->finalize = media_source_transaction_controller_finalize;
	g_type_class_adjust_private_offset (klass, &MediaSourceTransactionController_private_offset);
	((TransactionControllerClass *) klass)->begin_impl = (void (*) (TransactionController*, GError**)) media_source_transaction_controller_real_begin_impl;
	((TransactionControllerClass *) klass)->commit_impl = (void (*) (TransactionController*, GError**)) media_source_transaction_controller_real_commit_impl;
}

static void
media_source_transaction_controller_instance_init (MediaSourceTransactionController * self,
                                                   gpointer klass)
{
	self->priv = media_source_transaction_controller_get_instance_private (self);
}

static void
media_source_transaction_controller_finalize (TransactionController * obj)
{
	MediaSourceTransactionController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
	_data_collection_unref0 (self->priv->sources);
	TRANSACTION_CONTROLLER_CLASS (media_source_transaction_controller_parent_class)->finalize (obj);
}

static GType
media_source_transaction_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaSourceTransactionControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_transaction_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceTransactionController), 0, (GInstanceInitFunc) media_source_transaction_controller_instance_init, NULL };
	GType media_source_transaction_controller_type_id;
	media_source_transaction_controller_type_id = g_type_register_static (TYPE_TRANSACTION_CONTROLLER, "MediaSourceTransactionController", &g_define_type_info, 0);
	MediaSourceTransactionController_private_offset = g_type_add_instance_private (media_source_transaction_controller_type_id, sizeof (MediaSourceTransactionControllerPrivate));
	return media_source_transaction_controller_type_id;
}

GType
media_source_transaction_controller_get_type (void)
{
	static volatile gsize media_source_transaction_controller_type_id__once = 0;
	if (g_once_init_enter (&media_source_transaction_controller_type_id__once)) {
		GType media_source_transaction_controller_type_id;
		media_source_transaction_controller_type_id = media_source_transaction_controller_get_type_once ();
		g_once_init_leave (&media_source_transaction_controller_type_id__once, media_source_transaction_controller_type_id);
	}
	return media_source_transaction_controller_type_id__once;
}

static inline gpointer
media_source_collection_get_instance_private (MediaSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, MediaSourceCollection_private_offset);
}

static gint
_import_id_compare_func_gcompare_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self)
{
	gint result;
	result = import_id_compare_func ((ImportID*) a, (ImportID*) b);
	return result;
}

MediaSourceCollection*
media_source_collection_construct (GType object_type,
                                   const gchar* name,
                                   GetSourceDatabaseKey source_key_func,
                                   gpointer source_key_func_target)
{
	MediaSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MediaSourceCollection*) database_source_collection_construct (object_type, name, source_key_func, source_key_func_target);
	_tmp0_ = media_source_collection_create_trashcan (self);
	_source_holding_tank_unref0 (self->priv->trashcan);
	self->priv->trashcan = _tmp0_;
	_tmp1_ = media_source_collection_create_offline_bin (self);
	_source_holding_tank_unref0 (self->priv->offline_bin);
	self->priv->offline_bin = _tmp1_;
	return self;
}

void
media_source_collection_filter_media (GeeCollection* media,
                                      GeeCollection* photos,
                                      GeeCollection* videos)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	g_return_if_fail ((photos == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (photos, GEE_TYPE_COLLECTION));
	g_return_if_fail ((videos == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (videos, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MediaSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (MediaSource*) _tmp3_;
			if (photos != NULL) {
				MediaSource* _tmp5_;
				_tmp5_ = source;
				_tmp4_ = IS_LIBRARY_PHOTO (_tmp5_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				MediaSource* _tmp6_;
				_tmp6_ = source;
				gee_collection_add (photos, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			} else {
				gboolean _tmp7_ = FALSE;
				if (videos != NULL) {
					MediaSource* _tmp8_;
					_tmp8_ = source;
					_tmp7_ = IS_VIDEO (_tmp8_);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					MediaSource* _tmp9_;
					_tmp9_ = source;
					gee_collection_add (videos, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_VIDEO, Video));
				} else {
					gboolean _tmp10_ = FALSE;
					if (photos != NULL) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = videos != NULL;
					}
					if (_tmp10_) {
						MediaSource* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp11_ = source;
						_tmp12_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
						_tmp13_ = _tmp12_;
						g_warning ("MediaDataRepresentation.vala:399: Unrecognized media: %s", _tmp13_);
						_g_free0 (_tmp13_);
					}
				}
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

void
media_source_collection_count_media (GeeCollection* media,
                                     gint* photo_count,
                                     gint* video_count)
{
	gint _vala_photo_count = 0;
	gint _vala_video_count = 0;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp1_;
	media_source_collection_filter_media (media, G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp3_ = _tmp2_;
	_vala_photo_count = _tmp3_;
	_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp5_ = _tmp4_;
	_vala_video_count = _tmp5_;
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
	if (photo_count) {
		*photo_count = _vala_photo_count;
	}
	if (video_count) {
		*video_count = _vala_video_count;
	}
}

gboolean
media_source_collection_has_photo (GeeCollection* media)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION), FALSE);
	{
		GeeIterator* _current_media_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_ITERABLE, GeeIterable));
		_current_media_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			MediaSource* _tmp4_;
			_tmp1_ = _current_media_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_media_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_media = (MediaSource*) _tmp3_;
			_tmp4_ = current_media;
			if (IS_PHOTO (_tmp4_)) {
				result = TRUE;
				_g_object_unref0 (current_media);
				_g_object_unref0 (_current_media_it);
				return result;
			}
			_g_object_unref0 (current_media);
		}
		_g_object_unref0 (_current_media_it);
	}
	result = FALSE;
	return result;
}

gboolean
media_source_collection_has_video (GeeCollection* media)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION), FALSE);
	{
		GeeIterator* _current_media_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_ITERABLE, GeeIterable));
		_current_media_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			MediaSource* _tmp4_;
			_tmp1_ = _current_media_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_media_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_media = (MediaSource*) _tmp3_;
			_tmp4_ = current_media;
			if (IS_VIDEO (_tmp4_)) {
				result = TRUE;
				_g_object_unref0 (current_media);
				_g_object_unref0 (_current_media_it);
				return result;
			}
			_g_object_unref0 (current_media);
		}
		_g_object_unref0 (_current_media_it);
	}
	result = FALSE;
	return result;
}

static MediaSourceHoldingTank*
media_source_collection_real_create_trashcan (MediaSourceCollection* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_trashcan'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MediaSourceHoldingTank*
media_source_collection_create_trashcan (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->create_trashcan) {
		return _klass_->create_trashcan (self);
	}
	return NULL;
}

static MediaSourceHoldingTank*
media_source_collection_real_create_offline_bin (MediaSourceCollection* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_offline_bin'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MediaSourceHoldingTank*
media_source_collection_create_offline_bin (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->create_offline_bin) {
		return _klass_->create_offline_bin (self);
	}
	return NULL;
}

static MediaMonitor*
media_source_collection_real_create_media_monitor (MediaSourceCollection* self,
                                                   Workers* workers,
                                                   GCancellable* cancellable)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_media_monitor'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MediaMonitor*
media_source_collection_create_media_monitor (MediaSourceCollection* self,
                                              Workers* workers,
                                              GCancellable* cancellable)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->create_media_monitor) {
		return _klass_->create_media_monitor (self, workers, cancellable);
	}
	return NULL;
}

static gchar*
media_source_collection_real_get_typename (MediaSourceCollection* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_get_typename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_source_collection_get_typename (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->get_typename) {
		return _klass_->get_typename (self);
	}
	return NULL;
}

static gboolean
media_source_collection_real_is_file_recognized (MediaSourceCollection* self,
                                                 GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_is_file_recognized'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
media_source_collection_is_file_recognized (MediaSourceCollection* self,
                                            GFile* file)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), FALSE);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->is_file_recognized) {
		return _klass_->is_file_recognized (self, file);
	}
	return FALSE;
}

static gpointer
_source_holding_tank_ref0 (gpointer self)
{
	return self ? source_holding_tank_ref (self) : NULL;
}

MediaSourceHoldingTank*
media_source_collection_get_trashcan (MediaSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->trashcan;
	_tmp1_ = _source_holding_tank_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

MediaSourceHoldingTank*
media_source_collection_get_offline_bin (MediaSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->offline_bin;
	_tmp1_ = _source_holding_tank_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static MediaSource*
media_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* self,
                                                  gint64 numeric_id)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_fetch_by_numeric_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MediaSource*
media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self,
                                             gint64 numeric_id)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->fetch_by_numeric_id) {
		return _klass_->fetch_by_numeric_id (self, numeric_id);
	}
	return NULL;
}

static void
media_source_collection_real_notify_import_roll_altered (MediaSourceCollection* self)
{
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL], 0);
}

void
media_source_collection_notify_import_roll_altered (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_import_roll_altered) {
		_klass_->notify_import_roll_altered (self);
	}
}

static void
media_source_collection_real_notify_flagged_contents_altered (MediaSourceCollection* self)
{
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL], 0);
}

void
media_source_collection_notify_flagged_contents_altered (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_flagged_contents_altered) {
		_klass_->notify_flagged_contents_altered (self);
	}
}

static void
media_source_collection_real_notify_media_import_starting (MediaSourceCollection* self,
                                                           GeeCollection* media)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL], 0, media);
}

void
media_source_collection_notify_media_import_starting (MediaSourceCollection* self,
                                                      GeeCollection* media)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_media_import_starting) {
		_klass_->notify_media_import_starting (self, media);
	}
}

static void
media_source_collection_real_notify_media_import_completed (MediaSourceCollection* self,
                                                            GeeCollection* media)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL], 0, media);
}

void
media_source_collection_notify_media_import_completed (MediaSourceCollection* self,
                                                       GeeCollection* media)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_media_import_completed) {
		_klass_->notify_media_import_completed (self, media);
	}
}

static void
media_source_collection_real_items_altered (DataCollection* base,
                                            GeeMap* items)
{
	MediaSourceCollection * self;
	GeeArrayList* to_trashcan = NULL;
	GeeArrayList* to_offline = NULL;
	gboolean flagged_altered = FALSE;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp45_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
	to_trashcan = NULL;
	to_offline = NULL;
	flagged_altered = FALSE;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			MediaSource* source = NULL;
			DataObject* _tmp10_;
			MediaSource* _tmp11_;
			Alteration* _tmp12_;
			gboolean _tmp13_ = FALSE;
			MediaSource* _tmp14_;
			gboolean _tmp22_ = FALSE;
			MediaSource* _tmp23_;
			Flaggable* flaggable = NULL;
			MediaSource* _tmp31_;
			Flaggable* _tmp32_;
			Flaggable* _tmp33_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
			source = _tmp11_;
			_tmp12_ = alteration;
			if (!alteration_has_subject (_tmp12_, "metadata")) {
				_g_object_unref0 (source);
				_alteration_unref0 (alteration);
				_g_object_unref0 (object);
				continue;
			}
			_tmp14_ = source;
			if (media_source_is_trashed (_tmp14_)) {
				MediaSourceHoldingTank* _tmp15_;
				MediaSourceHoldingTank* _tmp16_;
				MediaSource* _tmp17_;
				_tmp15_ = media_source_collection_get_trashcan (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = source;
				_tmp13_ = !source_holding_tank_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_SOURCE, DataSource));
				_source_holding_tank_unref0 (_tmp16_);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeArrayList* _tmp18_;
				GeeArrayList* _tmp20_;
				MediaSource* _tmp21_;
				_tmp18_ = to_trashcan;
				if (_tmp18_ == NULL) {
					GeeArrayList* _tmp19_;
					_tmp19_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_trashcan);
					to_trashcan = _tmp19_;
				}
				_tmp20_ = to_trashcan;
				_tmp21_ = source;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
				_g_object_unref0 (source);
				_alteration_unref0 (alteration);
				_g_object_unref0 (object);
				continue;
			}
			_tmp23_ = source;
			if (media_source_is_offline (_tmp23_)) {
				MediaSourceHoldingTank* _tmp24_;
				MediaSourceHoldingTank* _tmp25_;
				MediaSource* _tmp26_;
				_tmp24_ = media_source_collection_get_offline_bin (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = source;
				_tmp22_ = !source_holding_tank_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_DATA_SOURCE, DataSource));
				_source_holding_tank_unref0 (_tmp25_);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				GeeArrayList* _tmp27_;
				GeeArrayList* _tmp29_;
				MediaSource* _tmp30_;
				_tmp27_ = to_offline;
				if (_tmp27_ == NULL) {
					GeeArrayList* _tmp28_;
					_tmp28_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_offline);
					to_offline = _tmp28_;
				}
				_tmp29_ = to_offline;
				_tmp30_ = source;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp30_);
			}
			_tmp31_ = source;
			_tmp32_ = _g_object_ref0 (IS_FLAGGABLE (_tmp31_) ? ((Flaggable*) _tmp31_) : NULL);
			flaggable = _tmp32_;
			_tmp33_ = flaggable;
			if (_tmp33_ != NULL) {
				Flaggable* _tmp34_;
				_tmp34_ = flaggable;
				if (flaggable_is_flagged (_tmp34_)) {
					gboolean _tmp35_ = FALSE;
					GeeSet* _tmp36_;
					MediaSource* _tmp37_;
					_tmp36_ = self->priv->flagged;
					_tmp37_ = source;
					if (gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_)) {
						_tmp35_ = TRUE;
					} else {
						_tmp35_ = flagged_altered;
					}
					flagged_altered = _tmp35_;
				} else {
					gboolean _tmp38_ = FALSE;
					GeeSet* _tmp39_;
					MediaSource* _tmp40_;
					_tmp39_ = self->priv->flagged;
					_tmp40_ = source;
					if (gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), _tmp40_)) {
						_tmp38_ = TRUE;
					} else {
						_tmp38_ = flagged_altered;
					}
					flagged_altered = _tmp38_;
				}
			}
			_g_object_unref0 (flaggable);
			_g_object_unref0 (source);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp41_ = to_trashcan;
	if (_tmp41_ != NULL) {
		MediaSourceHoldingTank* _tmp42_;
		MediaSourceHoldingTank* _tmp43_;
		GeeArrayList* _tmp44_;
		_tmp42_ = media_source_collection_get_trashcan (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = to_trashcan;
		source_holding_tank_unlink_and_hold (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection));
		_source_holding_tank_unref0 (_tmp43_);
	}
	_tmp45_ = to_offline;
	if (_tmp45_ != NULL) {
		MediaSourceHoldingTank* _tmp46_;
		MediaSourceHoldingTank* _tmp47_;
		GeeArrayList* _tmp48_;
		_tmp46_ = media_source_collection_get_offline_bin (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = to_offline;
		source_holding_tank_unlink_and_hold (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_COLLECTION, GeeCollection));
		_source_holding_tank_unref0 (_tmp47_);
	}
	if (flagged_altered) {
		media_source_collection_notify_flagged_contents_altered (self);
	}
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), items);
	_g_object_unref0 (to_offline);
	_g_object_unref0 (to_trashcan);
}

static void
_media_source_collection_on_master_replaced_media_source_master_replaced (MediaSource* _sender,
                                                                          GFile* old_file,
                                                                          GFile* new_file,
                                                                          gpointer self)
{
	media_source_collection_on_master_replaced ((MediaSourceCollection*) self, _sender, old_file, new_file);
}

static void
media_source_collection_real_notify_contents_altered (DataCollection* base,
                                                      GeeIterable* added,
                                                      GeeIterable* removed)
{
	MediaSourceCollection * self;
	gboolean import_roll_changed = FALSE;
	gboolean flagged_altered = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	import_roll_changed = FALSE;
	flagged_altered = FALSE;
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				MediaSource* media = NULL;
				DataObject* _tmp4_;
				MediaSource* _tmp5_;
				GeeHashMap* _tmp6_;
				MediaSource* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				MediaSource* _tmp10_;
				MediaSource* _tmp11_;
				ImportID import_id = {0};
				MediaSource* _tmp12_;
				ImportID _tmp13_ = {0};
				Flaggable* flaggable = NULL;
				MediaSource* _tmp19_;
				Flaggable* _tmp20_;
				Flaggable* _tmp21_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource));
				media = _tmp5_;
				_tmp6_ = self->priv->by_master_file;
				_tmp7_ = media;
				_tmp8_ = media_source_get_master_file (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = media;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
				_g_object_unref0 (_tmp9_);
				_tmp11_ = media;
				g_signal_connect (_tmp11_, "master-replaced", (GCallback) _media_source_collection_on_master_replaced_media_source_master_replaced, self);
				_tmp12_ = media;
				media_source_get_import_id (_tmp12_, &_tmp13_);
				import_id = _tmp13_;
				if (import_id_is_valid (&import_id)) {
					GeeTreeSet* _tmp14_;
					ImportID _tmp15_;
					GeeMultiMap* _tmp16_;
					ImportID _tmp17_;
					MediaSource* _tmp18_;
					_tmp14_ = self->priv->sorted_import_ids;
					_tmp15_ = import_id;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp15_);
					_tmp16_ = self->priv->import_rolls;
					_tmp17_ = import_id;
					_tmp18_ = media;
					gee_multi_map_set (_tmp16_, &_tmp17_, _tmp18_);
					import_roll_changed = TRUE;
				}
				_tmp19_ = media;
				_tmp20_ = _g_object_ref0 (IS_FLAGGABLE (_tmp19_) ? ((Flaggable*) _tmp19_) : NULL);
				flaggable = _tmp20_;
				_tmp21_ = flaggable;
				if (_tmp21_ != NULL) {
					Flaggable* _tmp22_;
					_tmp22_ = flaggable;
					if (flaggable_is_flagged (_tmp22_)) {
						gboolean _tmp23_ = FALSE;
						GeeSet* _tmp24_;
						MediaSource* _tmp25_;
						_tmp24_ = self->priv->flagged;
						_tmp25_ = media;
						if (gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_)) {
							_tmp23_ = TRUE;
						} else {
							_tmp23_ = flagged_altered;
						}
						flagged_altered = _tmp23_;
					} else {
						gboolean _tmp26_ = FALSE;
						GeeSet* _tmp27_;
						MediaSource* _tmp28_;
						_tmp27_ = self->priv->flagged;
						_tmp28_ = media;
						if (gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_)) {
							_tmp26_ = TRUE;
						} else {
							_tmp26_ = flagged_altered;
						}
						flagged_altered = _tmp26_;
					}
				}
				_g_object_unref0 (flaggable);
				_g_object_unref0 (media);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp29_;
			_tmp29_ = gee_iterable_iterator (removed);
			_object_it = _tmp29_;
			while (TRUE) {
				GeeIterator* _tmp30_;
				DataObject* object = NULL;
				GeeIterator* _tmp31_;
				gpointer _tmp32_;
				MediaSource* media = NULL;
				DataObject* _tmp33_;
				MediaSource* _tmp34_;
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp35_;
				MediaSource* _tmp36_;
				GFile* _tmp37_;
				GFile* _tmp38_;
				gboolean _tmp39_;
				MediaSource* _tmp40_;
				guint _tmp41_;
				ImportID import_id = {0};
				MediaSource* _tmp42_;
				ImportID _tmp43_ = {0};
				gboolean _tmp51_ = FALSE;
				GeeSet* _tmp52_;
				MediaSource* _tmp53_;
				_tmp30_ = _object_it;
				if (!gee_iterator_next (_tmp30_)) {
					break;
				}
				_tmp31_ = _object_it;
				_tmp32_ = gee_iterator_get (_tmp31_);
				object = (DataObject*) _tmp32_;
				_tmp33_ = object;
				_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_MEDIA_SOURCE, MediaSource));
				media = _tmp34_;
				_tmp35_ = self->priv->by_master_file;
				_tmp36_ = media;
				_tmp37_ = media_source_get_master_file (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp38_, NULL);
				_g_object_unref0 (_tmp38_);
				is_removed = _tmp39_;
				_vala_assert (is_removed, "is_removed");
				_tmp40_ = media;
				g_signal_parse_name ("master-replaced", TYPE_MEDIA_SOURCE, &_tmp41_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp40_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp41_, 0, NULL, (GCallback) _media_source_collection_on_master_replaced_media_source_master_replaced, self);
				_tmp42_ = media;
				media_source_get_import_id (_tmp42_, &_tmp43_);
				import_id = _tmp43_;
				if (import_id_is_valid (&import_id)) {
					GeeMultiMap* _tmp44_;
					ImportID _tmp45_;
					MediaSource* _tmp46_;
					GeeMultiMap* _tmp47_;
					ImportID _tmp48_;
					_tmp44_ = self->priv->import_rolls;
					_tmp45_ = import_id;
					_tmp46_ = media;
					is_removed = gee_multi_map_remove (_tmp44_, &_tmp45_, _tmp46_);
					_vala_assert (is_removed, "is_removed");
					_tmp47_ = self->priv->import_rolls;
					_tmp48_ = import_id;
					if (!gee_multi_map_contains (_tmp47_, &_tmp48_)) {
						GeeTreeSet* _tmp49_;
						ImportID _tmp50_;
						_tmp49_ = self->priv->sorted_import_ids;
						_tmp50_ = import_id;
						gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp50_);
					}
					import_roll_changed = TRUE;
				}
				_tmp52_ = self->priv->flagged;
				_tmp53_ = media;
				if (gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_COLLECTION, GeeCollection), _tmp53_)) {
					_tmp51_ = TRUE;
				} else {
					_tmp51_ = flagged_altered;
				}
				flagged_altered = _tmp51_;
				_g_object_unref0 (media);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (import_roll_changed) {
		media_source_collection_notify_import_roll_altered (self);
	}
	if (flagged_altered) {
		media_source_collection_notify_flagged_contents_altered (self);
	}
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added, removed);
}

static void
media_source_collection_on_master_replaced (MediaSourceCollection* self,
                                            MediaSource* media,
                                            GFile* old_file,
                                            GFile* new_file)
{
	gboolean is_removed = FALSE;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_MEDIA_SOURCE (media));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	_tmp0_ = self->priv->by_master_file;
	is_removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), old_file, NULL);
	_vala_assert (is_removed, "is_removed");
	_tmp1_ = self->priv->by_master_file;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), new_file, media);
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL], 0, media, old_file, new_file);
}

MediaSource*
media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                              GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MediaSource* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->by_master_file;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (MediaSource*) _tmp1_;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static MediaSource*
media_source_collection_real_fetch_by_source_id (MediaSourceCollection* self,
                                                 const gchar* source_id)
{
	gchar** components = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint components_length1;
	gint _components_size_;
	const gchar* _tmp2_;
	MediaSource* _tmp3_;
	MediaSource* result;
	g_return_val_if_fail (source_id != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (source_id, "-", 0);
	components = _tmp1_;
	components_length1 = _vala_array_length (_tmp0_);
	_components_size_ = components_length1;
	_vala_assert (components_length1 == 2, "components.length == 2");
	_tmp2_ = components[1];
	_tmp3_ = media_source_collection_fetch_by_numeric_id (self, int64_parse (_tmp2_, (guint) 16));
	result = _tmp3_;
	components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

MediaSource*
media_source_collection_fetch_by_source_id (MediaSourceCollection* self,
                                            const gchar* source_id)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->fetch_by_source_id) {
		return _klass_->fetch_by_source_id (self, source_id);
	}
	return NULL;
}

static GeeCollection*
media_source_collection_real_get_event_source_ids (MediaSourceCollection* self,
                                                   EventID* event_id)
{
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_get_event_source_ids'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
media_source_collection_get_event_source_ids (MediaSourceCollection* self,
                                              EventID* event_id)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->get_event_source_ids) {
		return _klass_->get_event_source_ids (self, event_id);
	}
	return NULL;
}

GeeCollection*
media_source_collection_get_trashcan_contents (MediaSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = media_source_collection_get_trashcan (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GeeCollection*
media_source_collection_get_offline_bin_contents (MediaSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = media_source_collection_get_offline_bin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GeeCollection*
media_source_collection_get_flagged (MediaSourceCollection* self)
{
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->flagged;
	_tmp1_ = gee_set_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeSortedSet*
media_source_collection_get_import_roll_ids (MediaSourceCollection* self)
{
	GeeTreeSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->sorted_import_ids;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SORTED_SET, GeeSortedSet));
	result = _tmp1_;
	return result;
}

ImportID*
media_source_collection_get_last_import_id (MediaSourceCollection* self)
{
	ImportID* _tmp0_ = NULL;
	GeeTreeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ImportID* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_tmp1_ = self->priv->sorted_import_ids;
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 0) {
		GeeTreeSet* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->priv->sorted_import_ids;
		_tmp5_ = gee_abstract_sorted_set_last (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_SORTED_SET, GeeAbstractSortedSet));
		_import_id_free0 (_tmp0_);
		_tmp0_ = (ImportID*) _tmp5_;
	} else {
		_import_id_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

GeeCollection*
media_source_collection_get_import_roll (MediaSourceCollection* self,
                                         ImportID* import_id)
{
	GeeMultiMap* _tmp0_;
	ImportID _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	_tmp0_ = self->priv->import_rolls;
	_tmp1_ = *import_id;
	_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
	result = _tmp2_;
	return result;
}

void
media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                           GeeCollection* sources)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	_tmp0_ = media_source_collection_get_trashcan (self);
	_tmp1_ = _tmp0_;
	source_holding_tank_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), sources);
	_source_holding_tank_unref0 (_tmp1_);
}

void
media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                             GeeCollection* sources)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	_tmp0_ = media_source_collection_get_offline_bin (self);
	_tmp1_ = _tmp0_;
	source_holding_tank_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), sources);
	_source_holding_tank_unref0 (_tmp1_);
}

gint
media_source_collection_get_trashcan_count (MediaSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), 0);
	_tmp0_ = media_source_collection_get_trashcan (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
media_source_collection_real_import_many (MediaSourceCollection* self,
                                          GeeCollection* media)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	media_source_collection_notify_media_import_starting (self, media);
	_tmp0_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), media, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	media_source_collection_postprocess_imported_media (self, media);
	media_source_collection_notify_media_import_completed (self, media);
}

void
media_source_collection_import_many (MediaSourceCollection* self,
                                     GeeCollection* media)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->import_many) {
		_klass_->import_many (self, media);
	}
}

static void
media_source_collection_real_postprocess_imported_media (MediaSourceCollection* self,
                                                         GeeCollection* media)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
}

void
media_source_collection_postprocess_imported_media (MediaSourceCollection* self,
                                                    GeeCollection* media)
{
	MediaSourceCollectionClass* _klass_;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->postprocess_imported_media) {
		_klass_->postprocess_imported_media (self, media);
	}
}

static gboolean
_aggregate_progress_monitor_monitor_progress_monitor (guint64 current,
                                                      guint64 total,
                                                      gboolean do_event_loop,
                                                      gpointer self)
{
	gboolean result;
	result = aggregate_progress_monitor_monitor ((AggregateProgressMonitor*) self, current, total);
	return result;
}

void
media_source_collection_remove_from_app (MediaSourceCollection* self,
                                         GeeCollection* sources,
                                         gboolean delete_backing,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target,
                                         GeeList* not_removed)
{
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* to_tombstone = NULL;
	GeeHashSet* _tmp2_;
	GeeArrayList* trashed = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* offlined = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* not_trashed = NULL;
	GeeArrayList* _tmp5_;
	gint total_count = 0;
	gint _tmp21_;
	gint _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeArrayList* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	AggregateProgressMonitor* agg_monitor = NULL;
	GeeArrayList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeArrayList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GeeArrayList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp52_ = FALSE;
	GeeHashSet* _tmp53_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	g_return_if_fail ((sources == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	g_return_if_fail ((not_removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (not_removed, GEE_TYPE_LIST));
	_vala_assert (sources != NULL, "sources != null");
	if (!delete_backing) {
		GeeHashSet* _tmp1_;
		_tmp1_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp2_ = _g_object_ref0 (_tmp0_);
	to_tombstone = _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	trashed = _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	offlined = _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	not_trashed = _tmp5_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp6_;
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			MediaSource* source = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			MediaSource* _tmp10_;
			GeeHashSet* _tmp18_;
			_tmp7_ = _source_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _source_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			source = (MediaSource*) _tmp9_;
			_tmp10_ = source;
			if (media_source_is_trashed (_tmp10_)) {
				GeeArrayList* _tmp11_;
				MediaSource* _tmp12_;
				_tmp11_ = trashed;
				_tmp12_ = source;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			} else {
				MediaSource* _tmp13_;
				_tmp13_ = source;
				if (media_source_is_offline (_tmp13_)) {
					GeeArrayList* _tmp14_;
					MediaSource* _tmp15_;
					_tmp14_ = offlined;
					_tmp15_ = source;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
				} else {
					GeeArrayList* _tmp16_;
					MediaSource* _tmp17_;
					_tmp16_ = not_trashed;
					_tmp17_ = source;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
				}
			}
			_tmp18_ = to_tombstone;
			if (_tmp18_ != NULL) {
				GeeHashSet* _tmp19_;
				MediaSource* _tmp20_;
				_tmp19_ = to_tombstone;
				_tmp20_ = source;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp21_ = gee_collection_get_size (sources);
	_tmp22_ = _tmp21_;
	total_count = _tmp22_;
	_tmp23_ = trashed;
	_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp25_ = _tmp24_;
	_tmp26_ = offlined;
	_tmp27_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp28_ = _tmp27_;
	_tmp29_ = not_trashed;
	_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp31_ = _tmp30_;
	_vala_assert (total_count == ((_tmp25_ + _tmp28_) + _tmp31_), "total_count == (trashed.size + offlined.size + not_trashed.size)");
	agg_monitor = NULL;
	if (monitor != NULL) {
		AggregateProgressMonitor* _tmp32_;
		AggregateProgressMonitor* _tmp33_;
		_tmp32_ = aggregate_progress_monitor_new ((guint64) total_count, monitor, monitor_target);
		_aggregate_progress_monitor_unref0 (agg_monitor);
		agg_monitor = _tmp32_;
		_tmp33_ = agg_monitor;
		monitor = _aggregate_progress_monitor_monitor_progress_monitor;
		monitor_target = _tmp33_;
	}
	_tmp34_ = trashed;
	_tmp35_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp36_ = _tmp35_;
	if (_tmp36_ > 0) {
		MediaSourceHoldingTank* _tmp37_;
		MediaSourceHoldingTank* _tmp38_;
		GeeArrayList* _tmp39_;
		_tmp37_ = media_source_collection_get_trashcan (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = trashed;
		source_holding_tank_destroy_orphans (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_LIST, GeeList), delete_backing, monitor, monitor_target, not_removed);
		_source_holding_tank_unref0 (_tmp38_);
	}
	_tmp40_ = offlined;
	_tmp41_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		MediaSourceHoldingTank* _tmp43_;
		MediaSourceHoldingTank* _tmp44_;
		GeeArrayList* _tmp45_;
		_tmp43_ = media_source_collection_get_offline_bin (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = offlined;
		source_holding_tank_destroy_orphans (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_LIST, GeeList), delete_backing, monitor, monitor_target, not_removed);
		_source_holding_tank_unref0 (_tmp44_);
	}
	_tmp46_ = not_trashed;
	_tmp47_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp48_ = _tmp47_;
	if (_tmp48_ > 0) {
		GeeArrayList* _tmp49_;
		Marker* _tmp50_;
		Marker* _tmp51_;
		_tmp49_ = not_trashed;
		_tmp50_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp51_ = _tmp50_;
		source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp51_, delete_backing, monitor, monitor_target, not_removed);
		_g_object_unref0 (_tmp51_);
	}
	_tmp53_ = to_tombstone;
	if (_tmp53_ != NULL) {
		GeeHashSet* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp54_ = to_tombstone;
		_tmp55_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp56_ = _tmp55_;
		_tmp52_ = _tmp56_ > 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		{
			GeeHashSet* _tmp57_;
			_tmp57_ = to_tombstone;
			tombstone_entomb_many_sources (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEE_TYPE_COLLECTION, GeeCollection), TOMBSTONE_REASON_REMOVED_BY_USER, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				_aggregate_progress_monitor_unref0 (agg_monitor);
				_g_object_unref0 (not_trashed);
				_g_object_unref0 (offlined);
				_g_object_unref0 (trashed);
				_g_object_unref0 (to_tombstone);
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_database_error:
		{
			GError* err = NULL;
			GError* _tmp58_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp58_ = err;
			app_window_database_error (_tmp58_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_aggregate_progress_monitor_unref0 (agg_monitor);
			_g_object_unref0 (not_trashed);
			_g_object_unref0 (offlined);
			_g_object_unref0 (trashed);
			_g_object_unref0 (to_tombstone);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_aggregate_progress_monitor_unref0 (agg_monitor);
	_g_object_unref0 (not_trashed);
	_g_object_unref0 (offlined);
	_g_object_unref0 (trashed);
	_g_object_unref0 (to_tombstone);
	_g_object_unref0 (_tmp0_);
}

void
media_source_collection_delete_backing_files (MediaSourceCollection* self,
                                              GeeCollection* sources,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target,
                                              GeeList* not_deleted)
{
	gint total_count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint i = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	g_return_if_fail ((not_deleted == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (not_deleted, GEE_TYPE_LIST));
	_tmp0_ = gee_collection_get_size (sources);
	_tmp1_ = _tmp0_;
	total_count = _tmp1_;
	i = 1;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MediaSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GFile* file = NULL;
			MediaSource* _tmp6_;
			GFile* _tmp7_;
			GFile* masterfile = NULL;
			MediaSource* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			gboolean deleted = FALSE;
			GFile* _tmp24_;
			gboolean _tmp25_ = FALSE;
			gint _tmp27_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (MediaSource*) _tmp5_;
			_tmp6_ = source;
			_tmp7_ = media_source_get_file (_tmp6_);
			file = _tmp7_;
			{
				GFile* _tmp8_;
				_tmp8_ = file;
				g_file_delete (_tmp8_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GFile* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GError* _tmp12_;
				const gchar* _tmp13_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp9_ = file;
				_tmp10_ = g_file_get_path (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = err;
				_tmp13_ = _tmp12_->message;
				g_debug ("MediaDataRepresentation.vala:726: Exception deleting file %s: %s", _tmp11_, _tmp13_);
				_g_free0 (_tmp11_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (source);
				_g_object_unref0 (_source_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp14_ = source;
			_tmp15_ = media_source_get_master_file (_tmp14_);
			masterfile = _tmp15_;
			_tmp16_ = masterfile;
			if (_tmp16_ != NULL) {
				{
					GFile* _tmp17_;
					_tmp17_ = masterfile;
					g_file_delete (_tmp17_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* err = NULL;
					GError* _tmp18_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp18_ = err;
					if (!g_error_matches (_tmp18_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						GFile* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						GError* _tmp22_;
						const gchar* _tmp23_;
						_tmp19_ = masterfile;
						_tmp20_ = g_file_get_path (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = err;
						_tmp23_ = _tmp22_->message;
						g_debug ("MediaDataRepresentation.vala:735: Exception deleting master file %s: %" \
"s", _tmp21_, _tmp23_);
						_g_free0 (_tmp21_);
					}
					_g_error_free0 (err);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (masterfile);
					_g_object_unref0 (file);
					_g_object_unref0 (source);
					_g_object_unref0 (_source_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp24_ = file;
			deleted = !g_file_query_exists (_tmp24_, NULL);
			if (!deleted) {
				_tmp25_ = NULL != not_deleted;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				MediaSource* _tmp26_;
				_tmp26_ = source;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (not_deleted, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
			}
			if (monitor != NULL) {
				monitor ((guint64) i, (guint64) total_count, TRUE, monitor_target);
			}
			_tmp27_ = i;
			i = _tmp27_ + 1;
			_g_object_unref0 (masterfile);
			_g_object_unref0 (file);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

TransactionController*
media_source_collection_get_transaction_controller (MediaSourceCollection* self)
{
	MediaSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
	_klass_ = MEDIA_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->get_transaction_controller) {
		return _klass_->get_transaction_controller (self);
	}
	return NULL;
}

static void
media_source_collection_real_media_import_starting (MediaSourceCollection* self,
                                                    GeeCollection* media)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
}

static void
media_source_collection_real_media_import_completed (MediaSourceCollection* self,
                                                     GeeCollection* media)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
}

static void
media_source_collection_real_master_file_replaced (MediaSourceCollection* self,
                                                   MediaSource* media,
                                                   GFile* old_file,
                                                   GFile* new_file)
{
	g_return_if_fail (IS_MEDIA_SOURCE (media));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
media_source_collection_real_trashcan_contents_altered (MediaSourceCollection* self,
                                                        GeeCollection* added,
                                                        GeeCollection* removed)
{
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
}

static void
media_source_collection_real_import_roll_altered (MediaSourceCollection* self)
{
}

static void
media_source_collection_real_offline_contents_altered (MediaSourceCollection* self,
                                                       GeeCollection* added,
                                                       GeeCollection* removed)
{
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
}

static void
media_source_collection_real_flagged_contents_altered (MediaSourceCollection* self)
{
}

static void
media_source_collection_class_init (MediaSourceCollectionClass * klass,
                                    gpointer klass_data)
{
	media_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = media_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &MediaSourceCollection_private_offset);
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) media_source_collection_real_create_trashcan;
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) media_source_collection_real_create_offline_bin;
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection*, Workers*, GCancellable*)) media_source_collection_real_create_media_monitor;
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection*)) media_source_collection_real_get_typename;
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection*, GFile*)) media_source_collection_real_is_file_recognized;
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection*, gint64)) media_source_collection_real_fetch_by_numeric_id;
	((MediaSourceCollectionClass *) klass)->notify_import_roll_altered = (void (*) (MediaSourceCollection*)) media_source_collection_real_notify_import_roll_altered;
	((MediaSourceCollectionClass *) klass)->notify_flagged_contents_altered = (void (*) (MediaSourceCollection*)) media_source_collection_real_notify_flagged_contents_altered;
	((MediaSourceCollectionClass *) klass)->notify_media_import_starting = (void (*) (MediaSourceCollection*, GeeCollection*)) media_source_collection_real_notify_media_import_starting;
	((MediaSourceCollectionClass *) klass)->notify_media_import_completed = (void (*) (MediaSourceCollection*, GeeCollection*)) media_source_collection_real_notify_media_import_completed;
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection*, GeeMap*)) media_source_collection_real_items_altered;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) media_source_collection_real_notify_contents_altered;
	((MediaSourceCollectionClass *) klass)->fetch_by_source_id = (MediaSource* (*) (MediaSourceCollection*, const gchar*)) media_source_collection_real_fetch_by_source_id;
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection*, EventID*)) media_source_collection_real_get_event_source_ids;
	((MediaSourceCollectionClass *) klass)->import_many = (void (*) (MediaSourceCollection*, GeeCollection*)) media_source_collection_real_import_many;
	((MediaSourceCollectionClass *) klass)->postprocess_imported_media = (void (*) (MediaSourceCollection*, GeeCollection*)) media_source_collection_real_postprocess_imported_media;
	((MediaSourceCollectionClass *) klass)->media_import_starting = media_source_collection_real_media_import_starting;
	((MediaSourceCollectionClass *) klass)->media_import_completed = media_source_collection_real_media_import_completed;
	((MediaSourceCollectionClass *) klass)->master_file_replaced = media_source_collection_real_master_file_replaced;
	((MediaSourceCollectionClass *) klass)->trashcan_contents_altered = media_source_collection_real_trashcan_contents_altered;
	((MediaSourceCollectionClass *) klass)->import_roll_altered = media_source_collection_real_import_roll_altered;
	((MediaSourceCollectionClass *) klass)->offline_contents_altered = media_source_collection_real_offline_contents_altered;
	((MediaSourceCollectionClass *) klass)->flagged_contents_altered = media_source_collection_real_flagged_contents_altered;
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL] = g_signal_new ("media-import-starting", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, media_import_starting), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL] = g_signal_new ("media-import-completed", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, media_import_completed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL] = g_signal_new ("master-file-replaced", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, master_file_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, TYPE_MEDIA_SOURCE, g_file_get_type (), g_file_get_type ());
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_TRASHCAN_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("trashcan-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, trashcan_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL] = g_signal_new ("import-roll-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, import_roll_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_OFFLINE_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("offline-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, offline_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("flagged-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, flagged_contents_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
media_source_collection_instance_init (MediaSourceCollection * self,
                                       gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeTreeMultiMap* _tmp1_;
	GeeTreeSet* _tmp2_;
	GeeHashSet* _tmp3_;
	self->priv = media_source_collection_get_instance_private (self);
	self->priv->trashcan = NULL;
	self->priv->offline_bin = NULL;
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_master_file = _tmp0_;
	_tmp1_ = gee_tree_multi_map_new (TYPE_IMPORT_ID, (GBoxedCopyFunc) import_id_dup, (GDestroyNotify) import_id_free, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _import_id_compare_func_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->import_rolls = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	_tmp2_ = gee_tree_set_new (TYPE_IMPORT_ID, (GBoxedCopyFunc) import_id_dup, (GDestroyNotify) import_id_free, _import_id_compare_func_gcompare_data_func, NULL, NULL);
	self->priv->sorted_import_ids = _tmp2_;
	_tmp3_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->flagged = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
}

static void
media_source_collection_finalize (DataCollection * obj)
{
	MediaSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
	_source_holding_tank_unref0 (self->priv->trashcan);
	_source_holding_tank_unref0 (self->priv->offline_bin);
	_g_object_unref0 (self->priv->by_master_file);
	_g_object_unref0 (self->priv->import_rolls);
	_g_object_unref0 (self->priv->sorted_import_ids);
	_g_object_unref0 (self->priv->flagged);
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->finalize (obj);
}

static GType
media_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceCollection), 0, (GInstanceInitFunc) media_source_collection_instance_init, NULL };
	GType media_source_collection_type_id;
	media_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "MediaSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MediaSourceCollection_private_offset = g_type_add_instance_private (media_source_collection_type_id, sizeof (MediaSourceCollectionPrivate));
	return media_source_collection_type_id;
}

GType
media_source_collection_get_type (void)
{
	static volatile gsize media_source_collection_type_id__once = 0;
	if (g_once_init_enter (&media_source_collection_type_id__once)) {
		GType media_source_collection_type_id;
		media_source_collection_type_id = media_source_collection_get_type_once ();
		g_once_init_leave (&media_source_collection_type_id__once, media_source_collection_type_id);
	}
	return media_source_collection_type_id__once;
}

static inline gpointer
media_collection_registry_get_instance_private (MediaCollectionRegistry* self)
{
	return G_STRUCT_MEMBER_P (self, MediaCollectionRegistry_private_offset);
}

static void
_media_collection_registry_on_init_done_application_init_done (Application* _sender,
                                                               gpointer self)
{
	media_collection_registry_on_init_done ((MediaCollectionRegistry*) self);
}

static MediaCollectionRegistry*
media_collection_registry_construct (GType object_type)
{
	MediaCollectionRegistry* self = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
	self = (MediaCollectionRegistry*) g_type_create_instance (object_type);
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_connect (_tmp1_, "init-done", (GCallback) _media_collection_registry_on_init_done_application_init_done, self);
	_application_unref0 (_tmp1_);
	return self;
}

static MediaCollectionRegistry*
media_collection_registry_new (void)
{
	return media_collection_registry_construct (TYPE_MEDIA_COLLECTION_REGISTRY);
}

static void
media_collection_registry_on_init_done (MediaCollectionRegistry* self)
{
	LibraryMonitor* library_monitor = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	LibraryMonitor* _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitorPool* _tmp4_;
	LibraryMonitorPool* _tmp5_;
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	_tmp0_ = app_dirs_get_import_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = library_monitor_new (_tmp1_, TRUE, !commandline_options_no_runtime_monitoring);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	library_monitor = _tmp3_;
	_tmp4_ = library_monitor_pool_get_instance ();
	_tmp5_ = _tmp4_;
	library_monitor_pool_replace (_tmp5_, library_monitor, MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC);
	_library_monitor_pool_unref0 (_tmp5_);
	_g_object_unref0 (library_monitor);
}

static void
_media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed (ConfigurationFacade* _sender,
                                                                                                      gpointer self)
{
	media_collection_registry_on_import_directory_changed ();
}

void
media_collection_registry_init (void)
{
	MediaCollectionRegistry* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	_tmp0_ = media_collection_registry_new ();
	_media_collection_registry_unref0 (media_collection_registry_instance);
	media_collection_registry_instance = _tmp0_;
	_tmp1_ = config_facade_get_instance ();
	_tmp2_ = _tmp1_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "import-directory-changed", (GCallback) _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed, NULL);
	_g_object_unref0 (_tmp2_);
}

void
media_collection_registry_terminate (void)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("import-directory-changed", TYPE_CONFIGURATION_FACADE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed, NULL);
	_g_object_unref0 (_tmp1_);
}

static void
media_collection_registry_on_import_directory_changed (void)
{
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	LibraryMonitor* current = NULL;
	LibraryMonitorPool* _tmp1_;
	LibraryMonitorPool* _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitor* _tmp4_;
	gboolean _tmp5_ = FALSE;
	LibraryMonitor* _tmp6_;
	LibraryMonitor* replacement = NULL;
	GFile* _tmp11_;
	LibraryMonitor* _tmp12_;
	LibraryMonitorPool* _tmp13_;
	LibraryMonitorPool* _tmp14_;
	LibraryMonitor* _tmp15_;
	_tmp0_ = app_dirs_get_import_dir ();
	import_dir = _tmp0_;
	_tmp1_ = library_monitor_pool_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = library_monitor_pool_get_monitor (_tmp2_);
	_tmp4_ = _tmp3_;
	_library_monitor_pool_unref0 (_tmp2_);
	current = _tmp4_;
	_tmp6_ = current;
	if (_tmp6_ != NULL) {
		LibraryMonitor* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp7_ = current;
		_tmp8_ = directory_monitor_get_root (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
		_tmp9_ = _tmp8_;
		_tmp10_ = import_dir;
		_tmp5_ = g_file_equal (_tmp9_, _tmp10_);
		_g_object_unref0 (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_g_object_unref0 (current);
		_g_object_unref0 (import_dir);
		return;
	}
	_tmp11_ = import_dir;
	_tmp12_ = library_monitor_new (_tmp11_, TRUE, !commandline_options_no_runtime_monitoring);
	replacement = _tmp12_;
	_tmp13_ = library_monitor_pool_get_instance ();
	_tmp14_ = _tmp13_;
	_tmp15_ = replacement;
	library_monitor_pool_replace (_tmp14_, _tmp15_, MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC);
	_library_monitor_pool_unref0 (_tmp14_);
	library_files_select_copy_function ();
	_g_object_unref0 (replacement);
	_g_object_unref0 (current);
	_g_object_unref0 (import_dir);
}

static gpointer
_media_collection_registry_ref0 (gpointer self)
{
	return self ? media_collection_registry_ref (self) : NULL;
}

MediaCollectionRegistry*
media_collection_registry_get_instance (void)
{
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
	MediaCollectionRegistry* result;
	_tmp0_ = media_collection_registry_instance;
	_tmp1_ = _media_collection_registry_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
media_collection_registry_get_typename_from_source_id (const gchar* source_id)
{
	gchar* result;
	g_return_val_if_fail (source_id != NULL, NULL);
	if (g_str_has_prefix (source_id, PHOTO_TYPENAME)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (PHOTO_TYPENAME);
		result = _tmp0_;
		return result;
	} else {
		gchar** components = NULL;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = _tmp1_ = g_strsplit (source_id, "-", 0);
		components = _tmp2_;
		components_length1 = _vala_array_length (_tmp1_);
		_components_size_ = components_length1;
		_tmp3_ = components;
		_tmp3__length1 = components_length1;
		_vala_assert (_tmp3__length1 == 2, "components.length == 2");
		_tmp4_ = components;
		_tmp4__length1 = components_length1;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

void
media_collection_registry_register_collection (MediaCollectionRegistry* self,
                                               MediaSourceCollection* collection)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (collection));
	_tmp0_ = self->priv->all;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), collection);
	_tmp1_ = self->priv->by_typename;
	_tmp2_ = media_source_collection_get_typename (collection);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, collection);
	_g_free0 (_tmp3_);
}

MediaSourceCollection*
media_collection_registry_get_collection (MediaCollectionRegistry* self,
                                          const gchar* typename)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MediaSourceCollection* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	g_return_val_if_fail (typename != NULL, NULL);
	_tmp0_ = self->priv->by_typename;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), typename);
	result = (MediaSourceCollection*) _tmp1_;
	return result;
}

GeeCollection*
media_collection_registry_get_all (MediaCollectionRegistry* self)
{
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	_tmp0_ = self->priv->all;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

void
media_collection_registry_freeze_all (MediaCollectionRegistry* self)
{
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_sources_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSourceCollection* _tmp7_;
			_tmp4_ = _sources_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _sources_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			sources = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = sources;
			data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection));
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

void
media_collection_registry_thaw_all (MediaCollectionRegistry* self)
{
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_sources_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSourceCollection* _tmp7_;
			_tmp4_ = _sources_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _sources_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			sources = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = sources;
			data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection));
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

void
media_collection_registry_begin_transaction_on_all (MediaCollectionRegistry* self)
{
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_sources_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSourceCollection* _tmp7_;
			TransactionController* _tmp8_;
			TransactionController* _tmp9_;
			_tmp4_ = _sources_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _sources_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			sources = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = sources;
			_tmp8_ = media_source_collection_get_transaction_controller (_tmp7_);
			_tmp9_ = _tmp8_;
			transaction_controller_begin (_tmp9_);
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

void
media_collection_registry_commit_transaction_on_all (MediaCollectionRegistry* self)
{
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_sources_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSourceCollection* _tmp7_;
			TransactionController* _tmp8_;
			TransactionController* _tmp9_;
			_tmp4_ = _sources_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _sources_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			sources = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = sources;
			_tmp8_ = media_source_collection_get_transaction_controller (_tmp7_);
			_tmp9_ = _tmp8_;
			transaction_controller_commit (_tmp9_);
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

MediaSource*
media_collection_registry_fetch_media (MediaCollectionRegistry* self,
                                       const gchar* source_id)
{
	gchar* typename = NULL;
	gchar* _tmp0_;
	MediaSourceCollection* collection = NULL;
	const gchar* _tmp1_;
	MediaSourceCollection* _tmp2_;
	MediaSourceCollection* _tmp3_;
	MediaSourceCollection* _tmp5_;
	MediaSource* _tmp6_;
	MediaSource* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	g_return_val_if_fail (source_id != NULL, NULL);
	_tmp0_ = media_collection_registry_get_typename_from_source_id (source_id);
	typename = _tmp0_;
	_tmp1_ = typename;
	_tmp2_ = media_collection_registry_get_collection (self, _tmp1_);
	collection = _tmp2_;
	_tmp3_ = collection;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = typename;
		g_critical ("MediaDataRepresentation.vala:859: source id '%s' has unrecognized medi" \
"a type '%s'", source_id, _tmp4_);
		result = NULL;
		_data_collection_unref0 (collection);
		_g_free0 (typename);
		return result;
	}
	_tmp5_ = collection;
	_tmp6_ = media_source_collection_fetch_by_source_id (_tmp5_, source_id);
	result = _tmp6_;
	_data_collection_unref0 (collection);
	_g_free0 (typename);
	return result;
}

static gpointer
_import_id_dup0 (gpointer self)
{
	return self ? import_id_dup (self) : NULL;
}

ImportID*
media_collection_registry_get_last_import_id (MediaCollectionRegistry* self)
{
	ImportID last_import_id = {0};
	ImportID _tmp13_;
	ImportID* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	import_id_init (&last_import_id, IMPORT_ID_INVALID);
	{
		GeeIterator* _current_collection_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_current_collection_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* current_collection = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			ImportID* current_import_id = NULL;
			MediaSourceCollection* _tmp7_;
			ImportID* _tmp8_;
			ImportID* _tmp9_;
			ImportID* _tmp10_;
			ImportID _tmp11_;
			_tmp4_ = _current_collection_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _current_collection_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			current_collection = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = current_collection;
			_tmp8_ = media_source_collection_get_last_import_id (_tmp7_);
			current_import_id = _tmp8_;
			_tmp9_ = current_import_id;
			if (_tmp9_ == NULL) {
				_import_id_free0 (current_import_id);
				_data_collection_unref0 (current_collection);
				continue;
			}
			_tmp10_ = current_import_id;
			_tmp11_ = last_import_id;
			if ((*_tmp10_).id > _tmp11_.id) {
				ImportID* _tmp12_;
				_tmp12_ = current_import_id;
				last_import_id = *_tmp12_;
			}
			_import_id_free0 (current_import_id);
			_data_collection_unref0 (current_collection);
		}
		_g_object_unref0 (_current_collection_it);
	}
	_tmp13_ = last_import_id;
	if (_tmp13_.id == IMPORT_ID_INVALID) {
		result = NULL;
		return result;
	} else {
		ImportID* _tmp14_;
		_tmp14_ = _import_id_dup0 (&last_import_id);
		result = _tmp14_;
		return result;
	}
}

GeeCollection*
media_collection_registry_get_source_ids_for_event_id (MediaCollectionRegistry* self,
                                                       EventID* event_id)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		GeeIterator* _current_collection_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = media_collection_registry_get_all (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_current_collection_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			MediaSourceCollection* current_collection = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeArrayList* _tmp8_;
			MediaSourceCollection* _tmp9_;
			EventID _tmp10_;
			GeeCollection* _tmp11_;
			GeeCollection* _tmp12_;
			_tmp5_ = _current_collection_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _current_collection_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			current_collection = (MediaSourceCollection*) _tmp7_;
			_tmp8_ = _result_;
			_tmp9_ = current_collection;
			_tmp10_ = *event_id;
			_tmp11_ = media_source_collection_get_event_source_ids (_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			gee_array_list_add_all (_tmp8_, _tmp12_);
			_g_object_unref0 (_tmp12_);
			_data_collection_unref0 (current_collection);
		}
		_g_object_unref0 (_current_collection_it);
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

MediaSourceCollection*
media_collection_registry_get_collection_for_file (MediaCollectionRegistry* self,
                                                   GFile* file)
{
	MediaSourceCollection* result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_collection_registry_get_all (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_collection_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSourceCollection* collection = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSourceCollection* _tmp7_;
			_tmp4_ = _collection_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _collection_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			collection = (MediaSourceCollection*) _tmp6_;
			_tmp7_ = collection;
			if (media_source_collection_is_file_recognized (_tmp7_, file)) {
				result = collection;
				_g_object_unref0 (_collection_it);
				return result;
			}
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	result = NULL;
	return result;
}

gboolean
media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self,
                                              const gchar* source_id)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), FALSE);
	if (is_string_empty (source_id)) {
		result = FALSE;
		return result;
	}
	if (g_str_has_prefix (source_id, PHOTO_TYPENAME)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_prefix (source_id, VIDEO_TYPENAME "-");
	}
	result = _tmp0_;
	return result;
}

static void
value_media_collection_registry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_media_collection_registry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		media_collection_registry_unref (value->data[0].v_pointer);
	}
}

static void
value_media_collection_registry_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = media_collection_registry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_media_collection_registry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_media_collection_registry_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MediaCollectionRegistry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = media_collection_registry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_media_collection_registry_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	MediaCollectionRegistry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = media_collection_registry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_media_collection_registry (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	ParamSpecMediaCollectionRegistry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MEDIA_COLLECTION_REGISTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_media_collection_registry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_media_collection_registry (GValue* value,
                                     gpointer v_object)
{
	MediaCollectionRegistry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_COLLECTION_REGISTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		media_collection_registry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		media_collection_registry_unref (old);
	}
}

void
value_take_media_collection_registry (GValue* value,
                                      gpointer v_object)
{
	MediaCollectionRegistry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_COLLECTION_REGISTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		media_collection_registry_unref (old);
	}
}

static void
media_collection_registry_class_init (MediaCollectionRegistryClass * klass,
                                      gpointer klass_data)
{
	media_collection_registry_parent_class = g_type_class_peek_parent (klass);
	((MediaCollectionRegistryClass *) klass)->finalize = media_collection_registry_finalize;
	g_type_class_adjust_private_offset (klass, &MediaCollectionRegistry_private_offset);
}

static void
media_collection_registry_instance_init (MediaCollectionRegistry * self,
                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = media_collection_registry_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL);
	self->priv->all = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_MEDIA_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_typename = _tmp1_;
	self->ref_count = 1;
}

static void
media_collection_registry_finalize (MediaCollectionRegistry * obj)
{
	MediaCollectionRegistry * self;
	Application* _tmp0_;
	Application* _tmp1_;
	guint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry);
	g_signal_handlers_destroy (self);
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("init-done", TYPE_APPLICATION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_collection_registry_on_init_done_application_init_done, self);
	_application_unref0 (_tmp1_);
	_g_object_unref0 (self->priv->all);
	_g_object_unref0 (self->priv->by_typename);
}

static GType
media_collection_registry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_media_collection_registry_init, value_media_collection_registry_free_value, value_media_collection_registry_copy_value, value_media_collection_registry_peek_pointer, "p", value_media_collection_registry_collect_value, "p", value_media_collection_registry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MediaCollectionRegistryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_collection_registry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaCollectionRegistry), 0, (GInstanceInitFunc) media_collection_registry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType media_collection_registry_type_id;
	media_collection_registry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MediaCollectionRegistry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MediaCollectionRegistry_private_offset = g_type_add_instance_private (media_collection_registry_type_id, sizeof (MediaCollectionRegistryPrivate));
	return media_collection_registry_type_id;
}

GType
media_collection_registry_get_type (void)
{
	static volatile gsize media_collection_registry_type_id__once = 0;
	if (g_once_init_enter (&media_collection_registry_type_id__once)) {
		GType media_collection_registry_type_id;
		media_collection_registry_type_id = media_collection_registry_get_type_once ();
		g_once_init_leave (&media_collection_registry_type_id__once, media_collection_registry_type_id);
	}
	return media_collection_registry_type_id__once;
}

gpointer
media_collection_registry_ref (gpointer instance)
{
	MediaCollectionRegistry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
media_collection_registry_unref (gpointer instance)
{
	MediaCollectionRegistry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MEDIA_COLLECTION_REGISTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

