/* Exporter.c generated by valac 0.56.17, the Vala compiler
 * generated from Exporter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
typedef struct _ExporterPrivate ExporterPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, gpointer user_data);
typedef gboolean (*ExporterExportFailedCallback) (Exporter* exporter, GFile* file, gint remaining, GError* err, gpointer user_data);
typedef enum  {
	EXPORTER_OVERWRITE_YES,
	EXPORTER_OVERWRITE_NO,
	EXPORTER_OVERWRITE_SKIP_ALL,
	EXPORTER_OVERWRITE_CANCEL,
	EXPORTER_OVERWRITE_REPLACE_ALL,
	EXPORTER_OVERWRITE_RENAME,
	EXPORTER_OVERWRITE_RENAME_ALL
} ExporterOverwrite;

#define EXPORTER_TYPE_OVERWRITE (exporter_overwrite_get_type ())
typedef ExporterOverwrite (*ExporterOverwriteCallback) (Exporter* exporter, GFile* file, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
enum  {
	EXPORTER_0_PROPERTY,
	EXPORTER_NUM_PROPERTIES
};
static GParamSpec* exporter_properties[EXPORTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define EXPORTER_TYPE_EXPORT_JOB (exporter_export_job_get_type ())
#define EXPORTER_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob))
#define EXPORTER_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))
#define EXPORTER_IS_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_IS_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_EXPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))

typedef struct _ExporterExportJob ExporterExportJob;
typedef struct _ExporterExportJobClass ExporterExportJobClass;
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _ExporterExportJobPrivate ExporterExportJobPrivate;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scaling_free0(var) ((var == NULL) ? NULL : (var = (scaling_free (var), NULL)))
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;
typedef struct _ExporterUIPrivate ExporterUIPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecExporterUI ParamSpecExporterUI;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _Exporter {
	GObject parent_instance;
	ExporterPrivate * priv;
};

struct _ExporterClass {
	GObjectClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ExporterPrivate {
	GeeCollection* to_export;
	GFile** exported_files;
	gint exported_files_length1;
	gint _exported_files_size_;
	GFile* dir;
	Scaling scaling;
	gint completed_count;
	Workers* workers;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
	ExporterExportFailedCallback error_callback;
	gpointer error_callback_target;
	ExporterOverwriteCallback overwrite_callback;
	gpointer overwrite_callback_target;
	ProgressMonitor monitor;
	gpointer monitor_target;
	GCancellable* cancellable;
	gboolean replace_all;
	gboolean rename_all;
	gboolean aborted;
	ExportFormatParameters export_params;
};

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _ExporterExportJob {
	BackgroundJob parent_instance;
	ExporterExportJobPrivate * priv;
	MediaSource* media;
	GFile* dest;
	Scaling* scaling;
	JpegQuality* quality;
	PhotoFileFormat* format;
	GError* err;
	gboolean direct_copy_unmodified;
	gboolean export_metadata;
};

struct _ExporterExportJobClass {
	BackgroundJobClass parent_class;
};

struct _ExporterUI {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExporterUIPrivate * priv;
};

struct _ExporterUIClass {
	GTypeClass parent_class;
	void (*finalize) (ExporterUI *self);
};

struct _ExporterUIPrivate {
	Exporter* exporter;
	GCancellable* cancellable;
	ProgressDialog* progress_dialog;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
};

struct _ParamSpecExporterUI {
	GParamSpec parent_instance;
};

static gint Exporter_private_offset;
static gpointer exporter_parent_class = NULL;
static GFile* exporter_USE_TEMPORARY_EXPORT_FOLDER;
static GFile* exporter_USE_TEMPORARY_EXPORT_FOLDER = NULL;
static gpointer exporter_export_job_parent_class = NULL;
static gint ExporterUI_private_offset;
static gpointer exporter_ui_parent_class = NULL;

VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_free (ExportFormatParameters* self);
static void export_format_parameters_init (ExportFormatParameters *self,
                                    ExportFormatMode mode,
                                    PhotoFileFormat specified_format,
                                    JpegQuality quality);
VALA_EXTERN void export_format_parameters_current (ExportFormatParameters* result);
VALA_EXTERN PhotoFileFormat photo_file_format_get_system_default_format (void);
VALA_EXTERN void export_format_parameters_unmodified (ExportFormatParameters* result);
VALA_EXTERN void export_format_parameters_for_format (PhotoFileFormat format,
                                          ExportFormatParameters* result);
VALA_EXTERN void export_format_parameters_last (ExportFormatParameters* result);
VALA_EXTERN void export_format_parameters_for_JPEG (JpegQuality quality,
                                        ExportFormatParameters* result);
VALA_EXTERN GType exporter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exporter, g_object_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN GType exporter_overwrite_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint workers_threads_per_cpu (gint per,
                               gint max);
VALA_EXTERN Workers* workers_new (guint max_threads,
                      gboolean exclusive);
VALA_EXTERN Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
VALA_EXTERN Exporter* exporter_new (GeeCollection* to_export,
                        GFile* dir,
                        Scaling* scaling,
                        ExportFormatParameters* export_params,
                        gboolean auto_replace_all);
VALA_EXTERN Exporter* exporter_construct (GType object_type,
                              GeeCollection* to_export,
                              GFile* dir,
                              Scaling* scaling,
                              ExportFormatParameters* export_params,
                              gboolean auto_replace_all);
VALA_EXTERN Exporter* exporter_new_for_temp_file (GeeCollection* to_export,
                                      Scaling* scaling,
                                      ExportFormatParameters* export_params);
VALA_EXTERN Exporter* exporter_construct_for_temp_file (GType object_type,
                                            GeeCollection* to_export,
                                            Scaling* scaling,
                                            ExportFormatParameters* export_params);
VALA_EXTERN void exporter_export (Exporter* self,
                      ExporterCompletionCallback completion_callback,
                      gpointer completion_callback_target,
                      ExporterExportFailedCallback error_callback,
                      gpointer error_callback_target,
                      ExporterOverwriteCallback overwrite_callback,
                      gpointer overwrite_callback_target,
                      GCancellable* cancellable,
                      ProgressMonitor monitor,
                      gpointer monitor_target);
static gboolean exporter_process_queue (Exporter* self);
static void exporter_export_completed (Exporter* self,
                                gboolean is_cancelled);
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
static void exporter_on_exported (Exporter* self,
                           BackgroundJob* j);
static GType exporter_export_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExporterExportJob, background_job_unref)
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
static void _vala_array_add124 (GFile** * array,
                         gint* length,
                         gint* size,
                         GFile* value);
static void exporter_on_export_cancelled (Exporter* self,
                                   BackgroundJob* j);
VALA_EXTERN GFile** exporter_get_exported_files (Exporter* self,
                                     gint* result_length1);
static GFile** _vala_array_dup34 (GFile** self,
                           gssize length);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN PhotoFileFormat photo_get_export_format_for_parameters (Photo* self,
                                                        ExportFormatParameters* params);
VALA_EXTERN gchar* photo_get_export_basename_for_parameters (Photo* self,
                                                 ExportFormatParameters* params);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
static void _vala_array_add125 (GFile** * array,
                         gint* length,
                         gint* size,
                         GFile* value);
VALA_EXTERN GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GeeCollection* used,
                             GError** error);
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static ExporterExportJob* exporter_export_job_new (Exporter* owner,
                                            MediaSource* media,
                                            GFile* dest,
                                            Scaling* scaling,
                                            JpegQuality* quality,
                                            PhotoFileFormat* format,
                                            GCancellable* cancellable,
                                            gboolean direct_copy_unmodified,
                                            gboolean export_metadata);
static ExporterExportJob* exporter_export_job_construct (GType object_type,
                                                  Exporter* owner,
                                                  MediaSource* media,
                                                  GFile* dest,
                                                  Scaling* scaling,
                                                  JpegQuality* quality,
                                                  PhotoFileFormat* format,
                                                  GCancellable* cancellable,
                                                  gboolean direct_copy_unmodified,
                                                  gboolean export_metadata);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
static void _exporter_on_exported_completion_callback (BackgroundJob* job,
                                                gpointer self);
static void _exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job,
                                                          gpointer self);
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static JpegQuality* _jpeg_quality_dup (JpegQuality* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
static void exporter_export_job_real_execute (BackgroundJob* base);
VALA_EXTERN void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
VALA_EXTERN void video_export (Video* self,
                   GFile* dest_file,
                   GError** error);
static void exporter_export_job_finalize (BackgroundJob * obj);
static GType exporter_export_job_get_type_once (void);
static void exporter_finalize (GObject * obj);
static GType exporter_get_type_once (void);
VALA_EXTERN gpointer exporter_ui_ref (gpointer instance);
VALA_EXTERN void exporter_ui_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exporter_ui (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_exporter_ui (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_exporter_ui (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_exporter_ui (const GValue* value);
VALA_EXTERN GType exporter_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExporterUI, exporter_ui_unref)
VALA_EXTERN GType progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgressDialog, g_object_unref)
VALA_EXTERN ExporterUI* exporter_ui_new (Exporter* exporter);
VALA_EXTERN ExporterUI* exporter_ui_construct (GType object_type,
                                   Exporter* exporter);
VALA_EXTERN void exporter_ui_export (ExporterUI* self,
                         ExporterCompletionCallback completion_callback,
                         gpointer completion_callback_target);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
VALA_EXTERN ProgressDialog* progress_dialog_new (GtkWindow* owner,
                                     const gchar* text,
                                     GCancellable* cancellable);
VALA_EXTERN ProgressDialog* progress_dialog_construct (GType object_type,
                                           GtkWindow* owner,
                                           const gchar* text,
                                           GCancellable* cancellable);
static void exporter_ui_on_export_completed (ExporterUI* self,
                                      Exporter* exporter,
                                      gboolean is_cancelled);
static void _exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                    gboolean is_cancelled,
                                                                    gpointer self);
static gboolean exporter_ui_on_export_failed (ExporterUI* self,
                                       Exporter* exporter,
                                       GFile* file,
                                       gint remaining,
                                       GError* err);
static gboolean _exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter,
                                                                        GFile* file,
                                                                        gint remaining,
                                                                        GError* err,
                                                                        gpointer self);
static ExporterOverwrite exporter_ui_on_export_overwrite (ExporterUI* self,
                                                   Exporter* exporter,
                                                   GFile* file);
static ExporterOverwrite _exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter,
                                                                                GFile* file,
                                                                                gpointer self);
VALA_EXTERN gboolean progress_dialog_monitor (ProgressDialog* self,
                                  guint64 count,
                                  guint64 total,
                                  gboolean do_event_loop);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
VALA_EXTERN void progress_dialog_close (ProgressDialog* self);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
VALA_EXTERN gint app_window_export_overwrite_or_replace_question (const gchar* message,
                                                      const gchar* alt1,
                                                      const gchar* alt2,
                                                      const gchar* alt4,
                                                      const gchar* alt6,
                                                      const gchar* title,
                                                      GtkWindow* parent);
VALA_EXTERN GtkResponseType export_error_dialog (GFile* dest,
                                     gboolean photos_remaining);
static void exporter_ui_finalize (ExporterUI * obj);
static GType exporter_ui_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
export_format_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{EXPORT_FORMAT_MODE_UNMODIFIED, "EXPORT_FORMAT_MODE_UNMODIFIED", "unmodified"}, {EXPORT_FORMAT_MODE_CURRENT, "EXPORT_FORMAT_MODE_CURRENT", "current"}, {EXPORT_FORMAT_MODE_SPECIFIED, "EXPORT_FORMAT_MODE_SPECIFIED", "specified"}, {EXPORT_FORMAT_MODE_LAST, "EXPORT_FORMAT_MODE_LAST", "last"}, {0, NULL, NULL}};
	GType export_format_mode_type_id;
	export_format_mode_type_id = g_enum_register_static ("ExportFormatMode", values);
	return export_format_mode_type_id;
}

GType
export_format_mode_get_type (void)
{
	static volatile gsize export_format_mode_type_id__once = 0;
	if (g_once_init_enter (&export_format_mode_type_id__once)) {
		GType export_format_mode_type_id;
		export_format_mode_type_id = export_format_mode_get_type_once ();
		g_once_init_leave (&export_format_mode_type_id__once, export_format_mode_type_id);
	}
	return export_format_mode_type_id__once;
}

static void
export_format_parameters_init (ExportFormatParameters *self,
                               ExportFormatMode mode,
                               PhotoFileFormat specified_format,
                               JpegQuality quality)
{
	memset (self, 0, sizeof (ExportFormatParameters));
	(*self).mode = mode;
	(*self).specified_format = specified_format;
	(*self).quality = quality;
	(*self).export_metadata = TRUE;
}

void
export_format_parameters_current (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_CURRENT, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_unmodified (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_UNMODIFIED, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_for_format (PhotoFileFormat format,
                                     ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_SPECIFIED, format, JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_last (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_LAST, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_for_JPEG (JpegQuality quality,
                                   ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_SPECIFIED, PHOTO_FILE_FORMAT_JFIF, quality);
	*result = _tmp0_;
	return;
}

ExportFormatParameters*
export_format_parameters_dup (const ExportFormatParameters* self)
{
	ExportFormatParameters* dup;
	dup = g_new0 (ExportFormatParameters, 1);
	memcpy (dup, self, sizeof (ExportFormatParameters));
	return dup;
}

void
export_format_parameters_free (ExportFormatParameters* self)
{
	g_free (self);
}

static GType
export_format_parameters_get_type_once (void)
{
	GType export_format_parameters_type_id;
	export_format_parameters_type_id = g_boxed_type_register_static ("ExportFormatParameters", (GBoxedCopyFunc) export_format_parameters_dup, (GBoxedFreeFunc) export_format_parameters_free);
	return export_format_parameters_type_id;
}

GType
export_format_parameters_get_type (void)
{
	static volatile gsize export_format_parameters_type_id__once = 0;
	if (g_once_init_enter (&export_format_parameters_type_id__once)) {
		GType export_format_parameters_type_id;
		export_format_parameters_type_id = export_format_parameters_get_type_once ();
		g_once_init_leave (&export_format_parameters_type_id__once, export_format_parameters_type_id);
	}
	return export_format_parameters_type_id__once;
}

static inline gpointer
exporter_get_instance_private (Exporter* self)
{
	return G_STRUCT_MEMBER_P (self, Exporter_private_offset);
}

static GType
exporter_overwrite_get_type_once (void)
{
	static const GEnumValue values[] = {{EXPORTER_OVERWRITE_YES, "EXPORTER_OVERWRITE_YES", "yes"}, {EXPORTER_OVERWRITE_NO, "EXPORTER_OVERWRITE_NO", "no"}, {EXPORTER_OVERWRITE_SKIP_ALL, "EXPORTER_OVERWRITE_SKIP_ALL", "skip-all"}, {EXPORTER_OVERWRITE_CANCEL, "EXPORTER_OVERWRITE_CANCEL", "cancel"}, {EXPORTER_OVERWRITE_REPLACE_ALL, "EXPORTER_OVERWRITE_REPLACE_ALL", "replace-all"}, {EXPORTER_OVERWRITE_RENAME, "EXPORTER_OVERWRITE_RENAME", "rename"}, {EXPORTER_OVERWRITE_RENAME_ALL, "EXPORTER_OVERWRITE_RENAME_ALL", "rename-all"}, {0, NULL, NULL}};
	GType exporter_overwrite_type_id;
	exporter_overwrite_type_id = g_enum_register_static ("ExporterOverwrite", values);
	return exporter_overwrite_type_id;
}

GType
exporter_overwrite_get_type (void)
{
	static volatile gsize exporter_overwrite_type_id__once = 0;
	if (g_once_init_enter (&exporter_overwrite_type_id__once)) {
		GType exporter_overwrite_type_id;
		exporter_overwrite_type_id = exporter_overwrite_get_type_once ();
		g_once_init_leave (&exporter_overwrite_type_id__once, exporter_overwrite_type_id);
	}
	return exporter_overwrite_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Exporter*
exporter_construct (GType object_type,
                    GeeCollection* to_export,
                    GFile* dir,
                    Scaling* scaling,
                    ExportFormatParameters* export_params,
                    gboolean auto_replace_all)
{
	Exporter * self = NULL;
	GeeCollection* _tmp0_;
	GFile* _tmp1_;
	Scaling _tmp2_;
	ExportFormatParameters _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_export, GEE_TYPE_COLLECTION), NULL);
	g_return_val_if_fail ((dir == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	g_return_val_if_fail (export_params != NULL, NULL);
	self = (Exporter*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->to_export;
	gee_collection_add_all (_tmp0_, to_export);
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (self->priv->dir);
	self->priv->dir = _tmp1_;
	_tmp2_ = *scaling;
	self->priv->scaling = _tmp2_;
	_tmp3_ = *export_params;
	self->priv->export_params = _tmp3_;
	self->priv->replace_all = auto_replace_all;
	return self;
}

Exporter*
exporter_new (GeeCollection* to_export,
              GFile* dir,
              Scaling* scaling,
              ExportFormatParameters* export_params,
              gboolean auto_replace_all)
{
	return exporter_construct (TYPE_EXPORTER, to_export, dir, scaling, export_params, auto_replace_all);
}

Exporter*
exporter_construct_for_temp_file (GType object_type,
                                  GeeCollection* to_export,
                                  Scaling* scaling,
                                  ExportFormatParameters* export_params)
{
	Exporter * self = NULL;
	GeeCollection* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	Scaling _tmp3_;
	ExportFormatParameters _tmp4_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_export, GEE_TYPE_COLLECTION), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	g_return_val_if_fail (export_params != NULL, NULL);
	self = (Exporter*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->to_export;
	gee_collection_add_all (_tmp0_, to_export);
	_tmp1_ = exporter_USE_TEMPORARY_EXPORT_FOLDER;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->dir);
	self->priv->dir = _tmp2_;
	_tmp3_ = *scaling;
	self->priv->scaling = _tmp3_;
	_tmp4_ = *export_params;
	self->priv->export_params = _tmp4_;
	return self;
}

Exporter*
exporter_new_for_temp_file (GeeCollection* to_export,
                            Scaling* scaling,
                            ExportFormatParameters* export_params)
{
	return exporter_construct_for_temp_file (TYPE_EXPORTER, to_export, scaling, export_params);
}

void
exporter_export (Exporter* self,
                 ExporterCompletionCallback completion_callback,
                 gpointer completion_callback_target,
                 ExporterExportFailedCallback error_callback,
                 gpointer error_callback_target,
                 ExporterOverwriteCallback overwrite_callback,
                 gpointer overwrite_callback_target,
                 GCancellable* cancellable,
                 ProgressMonitor monitor,
                 gpointer monitor_target)
{
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	GCancellable* _tmp3_;
	g_return_if_fail (IS_EXPORTER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self->priv->completion_callback = completion_callback;
	self->priv->completion_callback_target = completion_callback_target;
	self->priv->error_callback = error_callback;
	self->priv->error_callback_target = error_callback_target;
	self->priv->overwrite_callback = overwrite_callback;
	self->priv->overwrite_callback_target = overwrite_callback_target;
	self->priv->monitor = monitor;
	self->priv->monitor_target = monitor_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = g_cancellable_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	if (!exporter_process_queue (self)) {
		exporter_export_completed (self, TRUE);
	}
	_g_object_unref0 (_tmp0_);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
_vala_array_add124 (GFile** * array,
                    gint* length,
                    gint* size,
                    GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
exporter_on_exported (Exporter* self,
                      BackgroundJob* j)
{
	ExporterExportJob* job = NULL;
	ExporterExportJob* _tmp0_;
	gint _tmp1_;
	gboolean completed = FALSE;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (IS_EXPORTER (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob));
	job = _tmp0_;
	_tmp1_ = self->priv->completed_count;
	self->priv->completed_count = _tmp1_ + 1;
	_tmp2_ = self->priv->to_export;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	completed = self->priv->completed_count == _tmp4_;
	if (!self->priv->aborted) {
		ExporterExportJob* _tmp6_;
		GError* _tmp7_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->err;
		_tmp5_ = _tmp7_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ExporterExportFailedCallback _tmp8_;
		gpointer _tmp8__target;
		ExporterExportJob* _tmp9_;
		GFile* _tmp10_;
		GeeCollection* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		ExporterExportJob* _tmp14_;
		GError* _tmp15_;
		_tmp8_ = self->priv->error_callback;
		_tmp8__target = self->priv->error_callback_target;
		_tmp9_ = job;
		_tmp10_ = _tmp9_->dest;
		_tmp11_ = self->priv->to_export;
		_tmp12_ = gee_collection_get_size (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = job;
		_tmp15_ = _tmp14_->err;
		if (!_tmp8_ (self, _tmp10_, _tmp13_ - self->priv->completed_count, _tmp15_, _tmp8__target)) {
			self->priv->aborted = TRUE;
			if (!completed) {
				_background_job_unref0 (job);
				return;
			}
		}
	}
	if (!self->priv->aborted) {
		ProgressMonitor _tmp17_;
		gpointer _tmp17__target;
		_tmp17_ = self->priv->monitor;
		_tmp17__target = self->priv->monitor_target;
		_tmp16_ = _tmp17_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ProgressMonitor _tmp18_;
		gpointer _tmp18__target;
		GeeCollection* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = self->priv->monitor;
		_tmp18__target = self->priv->monitor_target;
		_tmp19_ = self->priv->to_export;
		_tmp20_ = gee_collection_get_size (_tmp19_);
		_tmp21_ = _tmp20_;
		if (!_tmp18_ ((guint64) self->priv->completed_count, (guint64) _tmp21_, FALSE, _tmp18__target)) {
			self->priv->aborted = TRUE;
			if (!completed) {
				_background_job_unref0 (job);
				return;
			}
		} else {
			ExporterExportJob* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp22_ = job;
			_tmp23_ = _tmp22_->dest;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			_vala_array_add124 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp24_);
		}
	}
	if (completed) {
		exporter_export_completed (self, FALSE);
	}
	_background_job_unref0 (job);
}

static void
exporter_on_export_cancelled (Exporter* self,
                              BackgroundJob* j)
{
	gint _tmp0_;
	GeeCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (IS_EXPORTER (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	self->priv->completed_count = self->priv->completed_count + 1;
	_tmp0_ = self->priv->completed_count;
	_tmp1_ = self->priv->to_export;
	_tmp2_ = gee_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0_ == _tmp3_) {
		exporter_export_completed (self, TRUE);
	}
}

static GFile**
_vala_array_dup34 (GFile** self,
                   gssize length)
{
	if (length >= 0) {
		GFile** result;
		gssize i;
		result = g_new0 (GFile*, length + 1);
		for (i = 0; i < length; i++) {
			GFile* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GFile**
exporter_get_exported_files (Exporter* self,
                             gint* result_length1)
{
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GFile** _tmp2_;
	gint _tmp2__length1;
	GFile** result;
	g_return_val_if_fail (IS_EXPORTER (self), NULL);
	_tmp0_ = self->priv->exported_files;
	_tmp0__length1 = self->priv->exported_files_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup34 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_array_add125 (GFile** * array,
                    gint* length,
                    gint* size,
                    GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
exporter_process_queue (Exporter* self)
{
	gint submitted = 0;
	GeeHashSet* used = NULL;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_EXPORTER (self), FALSE);
	submitted = 0;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	used = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->to_export;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MediaSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GFile* use_source_file = NULL;
			PhotoFileFormat real_export_format = 0;
			gchar* basename = NULL;
			MediaSource* _tmp6_;
			const gchar* _tmp17_;
			GFile* _tmp18_;
			GFile* export_dir = NULL;
			GFile* _tmp28_;
			GFile* _tmp29_;
			GFile* dest = NULL;
			GFile* _tmp30_;
			GeeHashSet* _tmp94_;
			GFile* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			Workers* _tmp98_;
			MediaSource* _tmp99_;
			GFile* _tmp100_;
			Scaling _tmp101_;
			ExportFormatParameters _tmp102_;
			GCancellable* _tmp103_;
			ExportFormatParameters _tmp104_;
			ExportFormatParameters _tmp105_;
			ExporterExportJob* _tmp106_;
			ExporterExportJob* _tmp107_;
			gint _tmp108_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (MediaSource*) _tmp5_;
			use_source_file = NULL;
			real_export_format = photo_file_format_get_system_default_format ();
			basename = NULL;
			_tmp6_ = source;
			if (IS_PHOTO (_tmp6_)) {
				Photo* photo = NULL;
				MediaSource* _tmp7_;
				Photo* _tmp8_;
				Photo* _tmp9_;
				ExportFormatParameters _tmp10_;
				Photo* _tmp11_;
				ExportFormatParameters _tmp12_;
				gchar* _tmp13_;
				_tmp7_ = source;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO, Photo));
				photo = _tmp8_;
				_tmp9_ = photo;
				_tmp10_ = self->priv->export_params;
				real_export_format = photo_get_export_format_for_parameters (_tmp9_, &_tmp10_);
				_tmp11_ = photo;
				_tmp12_ = self->priv->export_params;
				_tmp13_ = photo_get_export_basename_for_parameters (_tmp11_, &_tmp12_);
				_g_free0 (basename);
				basename = _tmp13_;
				_g_object_unref0 (photo);
			} else {
				MediaSource* _tmp14_;
				_tmp14_ = source;
				if (IS_VIDEO (_tmp14_)) {
					MediaSource* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = source;
					_tmp16_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
					_g_free0 (basename);
					basename = _tmp16_;
				}
			}
			_tmp17_ = basename;
			_vala_assert (_tmp17_ != NULL, "basename != null");
			_tmp18_ = use_source_file;
			if (_tmp18_ != NULL) {
				GFile* _tmp19_;
				GFile* _tmp20_;
				gint _tmp21_;
				ProgressMonitor _tmp22_;
				gpointer _tmp22__target;
				_tmp19_ = use_source_file;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_vala_array_add125 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp20_);
				_tmp21_ = self->priv->completed_count;
				self->priv->completed_count = _tmp21_ + 1;
				_tmp22_ = self->priv->monitor;
				_tmp22__target = self->priv->monitor_target;
				if (_tmp22_ != NULL) {
					ProgressMonitor _tmp23_;
					gpointer _tmp23__target;
					GeeCollection* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					_tmp23_ = self->priv->monitor;
					_tmp23__target = self->priv->monitor_target;
					_tmp24_ = self->priv->to_export;
					_tmp25_ = gee_collection_get_size (_tmp24_);
					_tmp26_ = _tmp25_;
					if (!_tmp23_ ((guint64) self->priv->completed_count, (guint64) _tmp26_, TRUE, _tmp23__target)) {
						GCancellable* _tmp27_;
						_tmp27_ = self->priv->cancellable;
						g_cancellable_cancel (_tmp27_);
						result = FALSE;
						_g_free0 (basename);
						_g_object_unref0 (use_source_file);
						_g_object_unref0 (source);
						_g_object_unref0 (_source_it);
						_g_object_unref0 (used);
						return result;
					}
				}
				_g_free0 (basename);
				_g_object_unref0 (use_source_file);
				_g_object_unref0 (source);
				continue;
			}
			_tmp28_ = self->priv->dir;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			export_dir = _tmp29_;
			dest = NULL;
			_tmp30_ = export_dir;
			if (_tmp30_ == NULL) {
				{
					gboolean collision = FALSE;
					GFile* _tmp31_ = NULL;
					GFile* _tmp32_;
					GFile* _tmp33_;
					const gchar* _tmp34_;
					GeeHashSet* _tmp35_;
					gboolean _tmp36_ = FALSE;
					GFile* _tmp37_;
					GFile* _tmp38_;
					GFile* _tmp39_;
					_tmp32_ = app_dirs_get_temp_dir ();
					_tmp33_ = _tmp32_;
					_tmp34_ = basename;
					_tmp35_ = used;
					_tmp37_ = generate_unique_file (_tmp33_, _tmp34_, &_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_COLLECTION, GeeCollection), &_inner_error0_);
					collision = _tmp36_;
					_tmp38_ = _tmp37_;
					_g_object_unref0 (_tmp33_);
					_tmp31_ = _tmp38_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp39_ = _tmp31_;
					_tmp31_ = NULL;
					_g_object_unref0 (dest);
					dest = _tmp39_;
					_g_object_unref0 (_tmp31_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					MediaSource* _tmp40_;
					GFile* _tmp41_;
					GFile* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					GError* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp40_ = source;
					_tmp41_ = media_source_get_file (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_file_get_basename (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = err;
					_tmp46_ = _tmp45_->message;
					_tmp47_ = g_strdup_printf (_ ("Unable to generate a temporary file for %s: %s"), _tmp44_, _tmp46_);
					_tmp48_ = _tmp47_;
					app_window_error_message (_tmp48_, NULL);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp44_);
					_g_object_unref0 (_tmp42_);
					_g_error_free0 (err);
					_g_object_unref0 (dest);
					_g_object_unref0 (export_dir);
					_g_free0 (basename);
					_g_object_unref0 (use_source_file);
					_g_object_unref0 (source);
					break;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp49_ = FALSE;
					_g_object_unref0 (dest);
					_g_object_unref0 (export_dir);
					_g_free0 (basename);
					_g_object_unref0 (use_source_file);
					_g_object_unref0 (source);
					_g_object_unref0 (_source_it);
					_g_object_unref0 (used);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp49_;
				}
			} else {
				GFile* _tmp50_;
				const gchar* _tmp51_;
				GFile* _tmp52_;
				gboolean rename = FALSE;
				gboolean _tmp53_ = FALSE;
				_tmp50_ = self->priv->dir;
				_tmp51_ = basename;
				_tmp52_ = g_file_get_child (_tmp50_, _tmp51_);
				_g_object_unref0 (dest);
				dest = _tmp52_;
				rename = FALSE;
				if (!self->priv->replace_all) {
					gboolean _tmp54_ = FALSE;
					GFile* _tmp55_;
					_tmp55_ = dest;
					if (g_file_query_exists (_tmp55_, NULL)) {
						_tmp54_ = TRUE;
					} else {
						GeeHashSet* _tmp56_;
						const gchar* _tmp57_;
						_tmp56_ = used;
						_tmp57_ = basename;
						_tmp54_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp57_);
					}
					_tmp53_ = _tmp54_;
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					if (self->priv->rename_all) {
						rename = TRUE;
					} else {
						ExporterOverwriteCallback _tmp58_;
						gpointer _tmp58__target;
						GFile* _tmp59_;
						_tmp58_ = self->priv->overwrite_callback;
						_tmp58__target = self->priv->overwrite_callback_target;
						_tmp59_ = dest;
						switch (_tmp58_ (self, _tmp59_, _tmp58__target)) {
							case EXPORTER_OVERWRITE_YES:
							{
								break;
							}
							case EXPORTER_OVERWRITE_REPLACE_ALL:
							{
								self->priv->replace_all = TRUE;
								break;
							}
							case EXPORTER_OVERWRITE_RENAME:
							{
								rename = TRUE;
								break;
							}
							case EXPORTER_OVERWRITE_RENAME_ALL:
							{
								rename = TRUE;
								self->priv->rename_all = TRUE;
								break;
							}
							case EXPORTER_OVERWRITE_CANCEL:
							{
								GCancellable* _tmp60_;
								_tmp60_ = self->priv->cancellable;
								g_cancellable_cancel (_tmp60_);
								result = FALSE;
								_g_object_unref0 (dest);
								_g_object_unref0 (export_dir);
								_g_free0 (basename);
								_g_object_unref0 (use_source_file);
								_g_object_unref0 (source);
								_g_object_unref0 (_source_it);
								_g_object_unref0 (used);
								return result;
							}
							case EXPORTER_OVERWRITE_SKIP_ALL:
							{
								GeeCollection* _tmp61_;
								gint _tmp62_;
								gint _tmp63_;
								ProgressMonitor _tmp64_;
								gpointer _tmp64__target;
								_tmp61_ = self->priv->to_export;
								_tmp62_ = gee_collection_get_size (_tmp61_);
								_tmp63_ = _tmp62_;
								self->priv->completed_count = _tmp63_;
								_tmp64_ = self->priv->monitor;
								_tmp64__target = self->priv->monitor_target;
								if (_tmp64_ != NULL) {
									ProgressMonitor _tmp65_;
									gpointer _tmp65__target;
									GeeCollection* _tmp66_;
									gint _tmp67_;
									gint _tmp68_;
									_tmp65_ = self->priv->monitor;
									_tmp65__target = self->priv->monitor_target;
									_tmp66_ = self->priv->to_export;
									_tmp67_ = gee_collection_get_size (_tmp66_);
									_tmp68_ = _tmp67_;
									if (!_tmp65_ ((guint64) self->priv->completed_count, (guint64) _tmp68_, TRUE, _tmp65__target)) {
										GCancellable* _tmp69_;
										_tmp69_ = self->priv->cancellable;
										g_cancellable_cancel (_tmp69_);
									}
								}
								result = FALSE;
								_g_object_unref0 (dest);
								_g_object_unref0 (export_dir);
								_g_free0 (basename);
								_g_object_unref0 (use_source_file);
								_g_object_unref0 (source);
								_g_object_unref0 (_source_it);
								_g_object_unref0 (used);
								return result;
							}
							default:
							case EXPORTER_OVERWRITE_NO:
							{
								gint _tmp70_;
								ProgressMonitor _tmp71_;
								gpointer _tmp71__target;
								_tmp70_ = self->priv->completed_count;
								self->priv->completed_count = _tmp70_ + 1;
								_tmp71_ = self->priv->monitor;
								_tmp71__target = self->priv->monitor_target;
								if (_tmp71_ != NULL) {
									ProgressMonitor _tmp72_;
									gpointer _tmp72__target;
									GeeCollection* _tmp73_;
									gint _tmp74_;
									gint _tmp75_;
									_tmp72_ = self->priv->monitor;
									_tmp72__target = self->priv->monitor_target;
									_tmp73_ = self->priv->to_export;
									_tmp74_ = gee_collection_get_size (_tmp73_);
									_tmp75_ = _tmp74_;
									if (!_tmp72_ ((guint64) self->priv->completed_count, (guint64) _tmp75_, TRUE, _tmp72__target)) {
										GCancellable* _tmp76_;
										_tmp76_ = self->priv->cancellable;
										g_cancellable_cancel (_tmp76_);
										result = FALSE;
										_g_object_unref0 (dest);
										_g_object_unref0 (export_dir);
										_g_free0 (basename);
										_g_object_unref0 (use_source_file);
										_g_object_unref0 (source);
										_g_object_unref0 (_source_it);
										_g_object_unref0 (used);
										return result;
									}
								}
								_g_object_unref0 (dest);
								_g_object_unref0 (export_dir);
								_g_free0 (basename);
								_g_object_unref0 (use_source_file);
								_g_object_unref0 (source);
								continue;
							}
						}
					}
					if (rename) {
						{
							gboolean collision = FALSE;
							GFile* _tmp77_ = NULL;
							GFile* _tmp78_;
							const gchar* _tmp79_;
							GeeHashSet* _tmp80_;
							gboolean _tmp81_ = FALSE;
							GFile* _tmp82_;
							GFile* _tmp83_;
							_tmp78_ = self->priv->dir;
							_tmp79_ = basename;
							_tmp80_ = used;
							_tmp82_ = generate_unique_file (_tmp78_, _tmp79_, &_tmp81_, G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, GEE_TYPE_COLLECTION, GeeCollection), &_inner_error0_);
							collision = _tmp81_;
							_tmp77_ = _tmp82_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
							_tmp83_ = _tmp77_;
							_tmp77_ = NULL;
							_g_object_unref0 (dest);
							dest = _tmp83_;
							_g_object_unref0 (_tmp77_);
						}
						goto __finally1;
						__catch1_g_error:
						{
							GError* err = NULL;
							MediaSource* _tmp84_;
							GFile* _tmp85_;
							GFile* _tmp86_;
							gchar* _tmp87_;
							gchar* _tmp88_;
							GError* _tmp89_;
							const gchar* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							err = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp84_ = source;
							_tmp85_ = media_source_get_file (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = g_file_get_basename (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = err;
							_tmp90_ = _tmp89_->message;
							_tmp91_ = g_strdup_printf (_ ("Unable to generate a temporary file for %s: %s"), _tmp88_, _tmp90_);
							_tmp92_ = _tmp91_;
							app_window_error_message (_tmp92_, NULL);
							_g_free0 (_tmp92_);
							_g_free0 (_tmp88_);
							_g_object_unref0 (_tmp86_);
							_g_error_free0 (err);
							_g_object_unref0 (dest);
							_g_object_unref0 (export_dir);
							_g_free0 (basename);
							_g_object_unref0 (use_source_file);
							_g_object_unref0 (source);
							break;
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp93_ = FALSE;
							_g_object_unref0 (dest);
							_g_object_unref0 (export_dir);
							_g_free0 (basename);
							_g_object_unref0 (use_source_file);
							_g_object_unref0 (source);
							_g_object_unref0 (_source_it);
							_g_object_unref0 (used);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp93_;
						}
					}
				}
			}
			_tmp94_ = used;
			_tmp95_ = dest;
			_tmp96_ = g_file_get_basename (_tmp95_);
			_tmp97_ = _tmp96_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp97_);
			_g_free0 (_tmp97_);
			_tmp98_ = self->priv->workers;
			_tmp99_ = source;
			_tmp100_ = dest;
			_tmp101_ = self->priv->scaling;
			_tmp102_ = self->priv->export_params;
			_tmp103_ = self->priv->cancellable;
			_tmp104_ = self->priv->export_params;
			_tmp105_ = self->priv->export_params;
			_tmp106_ = exporter_export_job_new (self, _tmp99_, _tmp100_, &_tmp101_, &_tmp102_.quality, &real_export_format, _tmp103_, _tmp104_.mode == EXPORT_FORMAT_MODE_UNMODIFIED, _tmp105_.export_metadata);
			_tmp107_ = _tmp106_;
			workers_enqueue (_tmp98_, G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, TYPE_BACKGROUND_JOB, BackgroundJob));
			_background_job_unref0 (_tmp107_);
			_tmp108_ = submitted;
			submitted = _tmp108_ + 1;
			_g_object_unref0 (dest);
			_g_object_unref0 (export_dir);
			_g_free0 (basename);
			_g_object_unref0 (use_source_file);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	result = submitted > 0;
	_g_object_unref0 (used);
	return result;
}

static void
exporter_export_completed (Exporter* self,
                           gboolean is_cancelled)
{
	ExporterCompletionCallback _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (IS_EXPORTER (self));
	_tmp0_ = self->priv->completion_callback;
	_tmp0__target = self->priv->completion_callback_target;
	_tmp0_ (self, is_cancelled, _tmp0__target);
}

static void
_exporter_on_exported_completion_callback (BackgroundJob* job,
                                           gpointer self)
{
	exporter_on_exported ((Exporter*) self, job);
}

static void
_exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job,
                                                     gpointer self)
{
	exporter_on_export_cancelled ((Exporter*) self, job);
}

static gpointer
_scaling_dup0 (gpointer self)
{
	return self ? scaling_dup (self) : NULL;
}

static JpegQuality*
_jpeg_quality_dup (JpegQuality* self)
{
	JpegQuality* dup;
	dup = g_new0 (JpegQuality, 1);
	memcpy (dup, self, sizeof (JpegQuality));
	return dup;
}

static gpointer
__jpeg_quality_dup0 (gpointer self)
{
	return self ? _jpeg_quality_dup (self) : NULL;
}

static PhotoFileFormat*
_photo_file_format_dup (PhotoFileFormat* self)
{
	PhotoFileFormat* dup;
	dup = g_new0 (PhotoFileFormat, 1);
	memcpy (dup, self, sizeof (PhotoFileFormat));
	return dup;
}

static gpointer
__photo_file_format_dup0 (gpointer self)
{
	return self ? _photo_file_format_dup (self) : NULL;
}

static ExporterExportJob*
exporter_export_job_construct (GType object_type,
                               Exporter* owner,
                               MediaSource* media,
                               GFile* dest,
                               Scaling* scaling,
                               JpegQuality* quality,
                               PhotoFileFormat* format,
                               GCancellable* cancellable,
                               gboolean direct_copy_unmodified,
                               gboolean export_metadata)
{
	ExporterExportJob* self = NULL;
	gboolean _tmp0_ = FALSE;
	MediaSource* _tmp1_;
	GFile* _tmp2_;
	Scaling* _tmp3_;
	JpegQuality* _tmp4_;
	PhotoFileFormat* _tmp5_;
	g_return_val_if_fail (IS_EXPORTER (owner), NULL);
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (ExporterExportJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _exporter_on_exported_completion_callback, owner, cancellable, _exporter_on_export_cancelled_cancellation_callback, owner, NULL);
	if (IS_PHOTO (media)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = IS_VIDEO (media);
	}
	_vala_assert (_tmp0_, "media is Photo || media is Video");
	_tmp1_ = _g_object_ref0 (media);
	_g_object_unref0 (self->media);
	self->media = _tmp1_;
	_tmp2_ = _g_object_ref0 (dest);
	_g_object_unref0 (self->dest);
	self->dest = _tmp2_;
	_tmp3_ = _scaling_dup0 (scaling);
	_scaling_free0 (self->scaling);
	self->scaling = _tmp3_;
	_tmp4_ = __jpeg_quality_dup0 (quality);
	_g_free0 (self->quality);
	self->quality = _tmp4_;
	_tmp5_ = __photo_file_format_dup0 (format);
	_g_free0 (self->format);
	self->format = _tmp5_;
	self->direct_copy_unmodified = direct_copy_unmodified;
	self->export_metadata = export_metadata;
	return self;
}

static ExporterExportJob*
exporter_export_job_new (Exporter* owner,
                         MediaSource* media,
                         GFile* dest,
                         Scaling* scaling,
                         JpegQuality* quality,
                         PhotoFileFormat* format,
                         GCancellable* cancellable,
                         gboolean direct_copy_unmodified,
                         gboolean export_metadata)
{
	return exporter_export_job_construct (EXPORTER_TYPE_EXPORT_JOB, owner, media, dest, scaling, quality, format, cancellable, direct_copy_unmodified, export_metadata);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
exporter_export_job_real_execute (BackgroundJob* base)
{
	ExporterExportJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob);
	{
		MediaSource* _tmp0_;
		_tmp0_ = self->media;
		if (IS_PHOTO (_tmp0_)) {
			MediaSource* _tmp1_;
			GFile* _tmp2_;
			Scaling* _tmp3_;
			JpegQuality* _tmp4_;
			PhotoFileFormat* _tmp5_;
			Scaling _tmp6_;
			_tmp1_ = self->media;
			_tmp2_ = self->dest;
			_tmp3_ = self->scaling;
			_tmp4_ = self->quality;
			_tmp5_ = self->format;
			_tmp6_ = *_tmp3_;
			photo_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), _tmp2_, &_tmp6_, *_tmp4_, *_tmp5_, self->direct_copy_unmodified, self->export_metadata, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			MediaSource* _tmp7_;
			_tmp7_ = self->media;
			if (IS_VIDEO (_tmp7_)) {
				MediaSource* _tmp8_;
				GFile* _tmp9_;
				_tmp8_ = self->media;
				_tmp9_ = self->dest;
				video_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video), _tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_g_error_free0 (self->err);
		self->err = _tmp11_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
exporter_export_job_class_init (ExporterExportJobClass * klass,
                                gpointer klass_data)
{
	exporter_export_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = exporter_export_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) exporter_export_job_real_execute;
}

static void
exporter_export_job_instance_init (ExporterExportJob * self,
                                   gpointer klass)
{
	self->err = NULL;
	self->direct_copy_unmodified = FALSE;
	self->export_metadata = TRUE;
}

static void
exporter_export_job_finalize (BackgroundJob * obj)
{
	ExporterExportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob);
	_g_object_unref0 (self->media);
	_g_object_unref0 (self->dest);
	_scaling_free0 (self->scaling);
	_g_free0 (self->quality);
	_g_free0 (self->format);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (exporter_export_job_parent_class)->finalize (obj);
}

static GType
exporter_export_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExporterExportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_export_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterExportJob), 0, (GInstanceInitFunc) exporter_export_job_instance_init, NULL };
	GType exporter_export_job_type_id;
	exporter_export_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ExporterExportJob", &g_define_type_info, 0);
	return exporter_export_job_type_id;
}

static GType
exporter_export_job_get_type (void)
{
	static volatile gsize exporter_export_job_type_id__once = 0;
	if (g_once_init_enter (&exporter_export_job_type_id__once)) {
		GType exporter_export_job_type_id;
		exporter_export_job_type_id = exporter_export_job_get_type_once ();
		g_once_init_leave (&exporter_export_job_type_id__once, exporter_export_job_type_id);
	}
	return exporter_export_job_type_id__once;
}

static void
exporter_class_init (ExporterClass * klass,
                     gpointer klass_data)
{
	exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Exporter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = exporter_finalize;
}

static void
exporter_instance_init (Exporter * self,
                        gpointer klass)
{
	GeeArrayList* _tmp0_;
	Workers* _tmp1_;
	self->priv = exporter_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->to_export = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	self->priv->completed_count = 0;
	_tmp1_ = workers_new (workers_threads_per_cpu (1, 4), FALSE);
	self->priv->workers = _tmp1_;
	self->priv->completion_callback = NULL;
	self->priv->completion_callback_target = NULL;
	self->priv->error_callback = NULL;
	self->priv->error_callback_target = NULL;
	self->priv->overwrite_callback = NULL;
	self->priv->overwrite_callback_target = NULL;
	self->priv->monitor = NULL;
	self->priv->monitor_target = NULL;
	self->priv->replace_all = FALSE;
	self->priv->rename_all = FALSE;
	self->priv->aborted = FALSE;
}

static void
exporter_finalize (GObject * obj)
{
	Exporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER, Exporter);
	_g_object_unref0 (self->priv->to_export);
	self->priv->exported_files = (_vala_array_free (self->priv->exported_files, self->priv->exported_files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->dir);
	_workers_unref0 (self->priv->workers);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (exporter_parent_class)->finalize (obj);
}

static GType
exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Exporter), 0, (GInstanceInitFunc) exporter_instance_init, NULL };
	GType exporter_type_id;
	exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "Exporter", &g_define_type_info, 0);
	Exporter_private_offset = g_type_add_instance_private (exporter_type_id, sizeof (ExporterPrivate));
	return exporter_type_id;
}

GType
exporter_get_type (void)
{
	static volatile gsize exporter_type_id__once = 0;
	if (g_once_init_enter (&exporter_type_id__once)) {
		GType exporter_type_id;
		exporter_type_id = exporter_get_type_once ();
		g_once_init_leave (&exporter_type_id__once, exporter_type_id);
	}
	return exporter_type_id__once;
}

static inline gpointer
exporter_ui_get_instance_private (ExporterUI* self)
{
	return G_STRUCT_MEMBER_P (self, ExporterUI_private_offset);
}

ExporterUI*
exporter_ui_construct (GType object_type,
                       Exporter* exporter)
{
	ExporterUI* self = NULL;
	Exporter* _tmp0_;
	g_return_val_if_fail (IS_EXPORTER (exporter), NULL);
	self = (ExporterUI*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (exporter);
	_g_object_unref0 (self->priv->exporter);
	self->priv->exporter = _tmp0_;
	return self;
}

ExporterUI*
exporter_ui_new (Exporter* exporter)
{
	return exporter_ui_construct (TYPE_EXPORTER_UI, exporter);
}

static void
_exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter,
                                                               gboolean is_cancelled,
                                                               gpointer self)
{
	exporter_ui_on_export_completed ((ExporterUI*) self, exporter, is_cancelled);
}

static gboolean
_exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter,
                                                               GFile* file,
                                                               gint remaining,
                                                               GError* err,
                                                               gpointer self)
{
	gboolean result;
	result = exporter_ui_on_export_failed ((ExporterUI*) self, exporter, file, remaining, err);
	return result;
}

static ExporterOverwrite
_exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter,
                                                              GFile* file,
                                                              gpointer self)
{
	ExporterOverwrite result;
	result = exporter_ui_on_export_overwrite ((ExporterUI*) self, exporter, file);
	return result;
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

void
exporter_ui_export (ExporterUI* self,
                    ExporterCompletionCallback completion_callback,
                    gpointer completion_callback_target)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	GCancellable* _tmp4_;
	ProgressDialog* _tmp5_;
	Exporter* _tmp6_;
	GCancellable* _tmp7_;
	ProgressDialog* _tmp8_;
	g_return_if_fail (IS_EXPORTER_UI (self));
	self->priv->completion_callback = completion_callback;
	self->priv->completion_callback_target = completion_callback_target;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp1_);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->cancellable;
	_tmp5_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow), _ ("Exporting"), _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_tmp6_ = self->priv->exporter;
	_tmp7_ = self->priv->cancellable;
	_tmp8_ = self->priv->progress_dialog;
	exporter_export (_tmp6_, _exporter_ui_on_export_completed_exporter_completion_callback, self, _exporter_ui_on_export_failed_exporter_export_failed_callback, self, _exporter_ui_on_export_overwrite_exporter_overwrite_callback, self, _tmp7_, _progress_dialog_monitor_progress_monitor, _tmp8_);
}

static void
exporter_ui_on_export_completed (ExporterUI* self,
                                 Exporter* exporter,
                                 gboolean is_cancelled)
{
	ProgressDialog* _tmp0_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	ExporterCompletionCallback _tmp4_;
	gpointer _tmp4__target;
	g_return_if_fail (IS_EXPORTER_UI (self));
	g_return_if_fail (IS_EXPORTER (exporter));
	_tmp0_ = self->priv->progress_dialog;
	if (_tmp0_ != NULL) {
		ProgressDialog* _tmp1_;
		_tmp1_ = self->priv->progress_dialog;
		progress_dialog_close (_tmp1_);
		_g_object_unref0 (self->priv->progress_dialog);
		self->priv->progress_dialog = NULL;
	}
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->completion_callback;
	_tmp4__target = self->priv->completion_callback_target;
	_tmp4_ (exporter, is_cancelled, _tmp4__target);
}

static ExporterOverwrite
exporter_ui_on_export_overwrite (ExporterUI* self,
                                 Exporter* exporter,
                                 GFile* file)
{
	ProgressDialog* _tmp0_;
	gchar* question = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint response = 0;
	const gchar* _tmp5_;
	ProgressDialog* _tmp6_;
	gboolean apply_all = FALSE;
	ExporterOverwrite result;
	g_return_val_if_fail (IS_EXPORTER_UI (self), 0);
	g_return_val_if_fail (IS_EXPORTER (exporter), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0);
	_tmp0_ = self->priv->progress_dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), FALSE);
	_tmp1_ = g_file_get_basename (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("File %s already exists. Replace?"), _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	question = _tmp4_;
	_tmp5_ = question;
	response = app_window_export_overwrite_or_replace_question (_tmp5_, _ ("_Skip"), _ ("Rename"), _ ("_Replace"), _ ("_Cancel"), _ ("Export file conflict"), NULL);
	_tmp6_ = self->priv->progress_dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow), TRUE);
	apply_all = (response & 0x80) != 0;
	response &= 0x0f;
	switch (response) {
		case 2:
		{
			if (apply_all) {
				result = EXPORTER_OVERWRITE_RENAME_ALL;
				_g_free0 (question);
				return result;
			} else {
				result = EXPORTER_OVERWRITE_RENAME;
				_g_free0 (question);
				return result;
			}
		}
		case 4:
		{
			if (apply_all) {
				result = EXPORTER_OVERWRITE_REPLACE_ALL;
				_g_free0 (question);
				return result;
			} else {
				result = EXPORTER_OVERWRITE_YES;
				_g_free0 (question);
				return result;
			}
		}
		case 6:
		{
			result = EXPORTER_OVERWRITE_CANCEL;
			_g_free0 (question);
			return result;
		}
		case 1:
		{
			if (apply_all) {
				result = EXPORTER_OVERWRITE_SKIP_ALL;
				_g_free0 (question);
				return result;
			} else {
				result = EXPORTER_OVERWRITE_NO;
				_g_free0 (question);
				return result;
			}
		}
		default:
		{
			result = EXPORTER_OVERWRITE_NO;
			_g_free0 (question);
			return result;
		}
	}
}

static gboolean
exporter_ui_on_export_failed (ExporterUI* self,
                              Exporter* exporter,
                              GFile* file,
                              gint remaining,
                              GError* err)
{
	gboolean result;
	g_return_val_if_fail (IS_EXPORTER_UI (self), FALSE);
	g_return_val_if_fail (IS_EXPORTER (exporter), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (err != NULL, FALSE);
	result = export_error_dialog (file, remaining > 0) != GTK_RESPONSE_CANCEL;
	return result;
}

static void
value_exporter_ui_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_exporter_ui_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		exporter_ui_unref (value->data[0].v_pointer);
	}
}

static void
value_exporter_ui_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = exporter_ui_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_exporter_ui_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_exporter_ui_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ExporterUI * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = exporter_ui_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_exporter_ui_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ExporterUI ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = exporter_ui_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_exporter_ui (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecExporterUI* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPORTER_UI), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_exporter_ui (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI), NULL);
	return value->data[0].v_pointer;
}

void
value_set_exporter_ui (GValue* value,
                       gpointer v_object)
{
	ExporterUI * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		exporter_ui_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		exporter_ui_unref (old);
	}
}

void
value_take_exporter_ui (GValue* value,
                        gpointer v_object)
{
	ExporterUI * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		exporter_ui_unref (old);
	}
}

static void
exporter_ui_class_init (ExporterUIClass * klass,
                        gpointer klass_data)
{
	exporter_ui_parent_class = g_type_class_peek_parent (klass);
	((ExporterUIClass *) klass)->finalize = exporter_ui_finalize;
	g_type_class_adjust_private_offset (klass, &ExporterUI_private_offset);
}

static void
exporter_ui_instance_init (ExporterUI * self,
                           gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = exporter_ui_get_instance_private (self);
	_tmp0_ = g_cancellable_new ();
	self->priv->cancellable = _tmp0_;
	self->priv->progress_dialog = NULL;
	self->priv->completion_callback = NULL;
	self->priv->completion_callback_target = NULL;
	self->ref_count = 1;
}

static void
exporter_ui_finalize (ExporterUI * obj)
{
	ExporterUI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER_UI, ExporterUI);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->exporter);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->progress_dialog);
}

static GType
exporter_ui_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_exporter_ui_init, value_exporter_ui_free_value, value_exporter_ui_copy_value, value_exporter_ui_peek_pointer, "p", value_exporter_ui_collect_value, "p", value_exporter_ui_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ExporterUIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_ui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterUI), 0, (GInstanceInitFunc) exporter_ui_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType exporter_ui_type_id;
	exporter_ui_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ExporterUI", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ExporterUI_private_offset = g_type_add_instance_private (exporter_ui_type_id, sizeof (ExporterUIPrivate));
	return exporter_ui_type_id;
}

GType
exporter_ui_get_type (void)
{
	static volatile gsize exporter_ui_type_id__once = 0;
	if (g_once_init_enter (&exporter_ui_type_id__once)) {
		GType exporter_ui_type_id;
		exporter_ui_type_id = exporter_ui_get_type_once ();
		g_once_init_leave (&exporter_ui_type_id__once, exporter_ui_type_id);
	}
	return exporter_ui_type_id__once;
}

gpointer
exporter_ui_ref (gpointer instance)
{
	ExporterUI * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
exporter_ui_unref (gpointer instance)
{
	ExporterUI * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPORTER_UI_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

